/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('1b37ac92-9571-490a-b3d1-761e2cbee07d','2026-01-31 08:32:24','2026-01-31 08:33:44','2026-01-31 08:33:44',1,'ACTIVE','application/octet-stream','554dc8d2-d437-4e70-a380-9cd5e356d258','1c876f57-9e54-4dcc-b329-199198e47677','Z0FBQUFBQnBmYjRZTEVMWXVCRkZVSGxXN01LWmloa3htenJLWml6YkpoQ3M4RGc0blVnaTJiZFlmT2VrZE1ISUVJLTBtR0NRMnFZeWRTY0RHNnVWNHpXczBJUkp6UlFFZG5jVm43UFR5b08xYnNxZzZ3TE5VTVFNVFFMM242dW1hZk5wMG1adllYcVM=',NULL),('ad9dd6d2-1320-4343-86ee-2b42a74e67d3','2026-01-31 09:00:55','2026-01-31 09:01:44','2026-01-31 09:01:44',1,'ACTIVE','application/octet-stream','cf731dd8-1d28-4250-a5e1-54d441c738cb','bd48f650-4854-4180-8072-859d7617044b','Z0FBQUFBQnBmY1RINnV4ZEhSNzE1LTFhbDFUdTUyc0QyQVRMU3BBNE4xbVV4Tms4THhLdTR6NGpzR2NCTGNLYVpQM2w1SnNyV0M2WXhYQkdid2pNRlZJYlpwZ21zbUxuUFp1ZVVrUDVLQTV4UWxaeW9vYzVEdmZGUktWbm13QmVseGFBYXRhaVdfQkc=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('1c876f57-9e54-4dcc-b329-199198e47677','2026-01-31 08:32:24','2026-01-31 08:34:11','2026-01-31 08:34:11',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-5fe2a450b6ff4f73a7fe8def47304a29-key-6cc019e6-4920-4aea-a2ef-cca0cdc79f9f','dedfaea1-1703-4eb1-9e99-7164dea48802',1,1,'aes',128,'cbc','gAAAAABpfb4Y0mtPgtCnNgKOSwCUV-b3lmp0bvToh6MpcHE7MYLOp2EKuZTezdrVJYOSJo-lpH_4b7GgEf6Fluoc6nPeCu9HWykZNDEANjLJg8RlP9oKL_XagcUUf1l5tD8HKFPnyU5Y'),('bd48f650-4854-4180-8072-859d7617044b','2026-01-31 09:00:55','2026-01-31 09:09:09','2026-01-31 09:09:09',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-76ce367a834b49dfb5b436848118b860-key-fa6409f0-8369-4165-9b90-b53333f9e1bb','15e27ea5-d080-4b6e-ba98-4a476ad3c236',1,1,'aes',128,'cbc','gAAAAABpfcTHWd8V-mY0mIURgw9CvzXVPidSMAX85o_0cuLXnxFPutiQ8FniKL_X7bse9ZrU9cnHVMvX5yhTUVF7OP9jDHHZl7D2tm7MP-XOI7ZylGXJiNNCRBp7gU6-jNgRSLHCL_r6');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('67420097-ec42-49a9-9989-4482783dfa38','2026-01-31 09:00:55','2026-01-31 09:00:55',NULL,0,'ACTIVE','key','15e27ea5-d080-4b6e-ba98-4a476ad3c236',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','cf731dd8-1d28-4250-a5e1-54d441c738cb',NULL,'Unknown','Unknown','dc42b92a5dd34d32b6b184bdc7acb092'),('f8558c6a-9372-4898-b8de-d59f5c0bc042','2026-01-31 08:32:23','2026-01-31 08:32:24',NULL,0,'ACTIVE','key','dedfaea1-1703-4eb1-9e99-7164dea48802',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','554dc8d2-d437-4e70-a380-9cd5e356d258',NULL,'Unknown','Unknown','8efe4dc047d44a0fbd21b243ddc921d8');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('15e27ea5-d080-4b6e-ba98-4a476ad3c236','2026-01-31 09:00:55','2026-01-31 09:09:09','2026-01-31 09:09:09',1,'ACTIVE','76ce367a834b49dfb5b436848118b860'),('dedfaea1-1703-4eb1-9e99-7164dea48802','2026-01-31 08:32:23','2026-01-31 08:34:11','2026-01-31 08:34:11',1,'ACTIVE','5fe2a450b6ff4f73a7fe8def47304a29');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('43cfc39e-e892-4051-863a-5da1bbe8d96b','2026-01-31 08:32:24','2026-01-31 08:33:44','2026-01-31 08:33:44',1,'PENDING','content_type','application/octet-stream','554dc8d2-d437-4e70-a380-9cd5e356d258'),('453a397b-bf09-4fee-99d4-4e13fb7cce76','2026-01-31 09:00:55','2026-01-31 09:01:44','2026-01-31 09:01:44',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','cf731dd8-1d28-4250-a5e1-54d441c738cb'),('a91a4e4a-0353-4724-85a3-66288d615a6d','2026-01-31 08:32:24','2026-01-31 08:33:44','2026-01-31 08:33:44',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','554dc8d2-d437-4e70-a380-9cd5e356d258'),('fec3057e-b69b-471b-83e9-8cff50e5dfc3','2026-01-31 09:00:55','2026-01-31 09:01:44','2026-01-31 09:01:44',1,'PENDING','content_type','application/octet-stream','cf731dd8-1d28-4250-a5e1-54d441c738cb');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('faeb538d-f23d-4127-b05f-b3a2fe922b05','2026-01-31 07:04:50','2026-01-31 07:04:50',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('554dc8d2-d437-4e70-a380-9cd5e356d258','2026-01-31 08:32:24','2026-01-31 08:33:44','2026-01-31 08:33:44',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'8efe4dc047d44a0fbd21b243ddc921d8','dedfaea1-1703-4eb1-9e99-7164dea48802'),('cf731dd8-1d28-4250-a5e1-54d441c738cb','2026-01-31 09:00:55','2026-01-31 09:01:44','2026-01-31 09:01:44',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'dc42b92a5dd34d32b6b184bdc7acb092','15e27ea5-d080-4b6e-ba98-4a476ad3c236');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2026-01-31 09:05:00','2026-01-31 09:06:02','2026-01-31 09:06:04',1,'c7ca3ab9-79be-41d5-86e9-e43f182c2e9e','63f65249-1c72-4002-bc03-114c329384d1','4bd7d1bbf3a8497b8b26f8df83fe8067','c8017efbc64b4244b349174c29a41000','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-287278868',NULL,'backups','deleted',NULL,'{\"base\": \"volume-63f65249-1c72-4002-bc03-114c329384d1.backup.c7ca3ab9-79be-41d5-86e9-e43f182c2e9e\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:05:00','f3799711-34bd-4212-9be5-a6ded13ee858',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-31 09:00:54',NULL,'2026-01-31 09:01:47',1,'aes-xts-plain64','front-end',256,'luks','0b2068ba-e687-4185-afc3-bd7723128446','893a44b9-2cde-44ee-a7a8-089331e13429'),('2026-01-31 08:32:21',NULL,'2026-01-31 08:33:47',1,'aes-xts-plain64','front-end',256,'luks','89e12c0b-5753-4452-a933-7bf6f0ef8aae','9709bfcd-11b2-447c-9b3d-07fe07e25832');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','e254518d-bf2b-4923-b83d-f11566ff7fc9','2026-01-31 07:04:39','2026-01-31 07:04:39',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('e254518d-bf2b-4923-b83d-f11566ff7fc9','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-31 07:04:39','2026-01-31 07:04:39',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-31 07:04:03',NULL,NULL,0,1,'default','volumes',10),('2026-01-31 07:04:03',NULL,NULL,0,2,'default','snapshots',10),('2026-01-31 07:04:03',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-31 07:04:03',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-31 07:04:03',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-31 07:04:03',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2026-01-31 07:44:42','2026-01-31 07:45:39',NULL,0,1,'929444f150804704b1865bcbe068c936','volumes',0,0,NULL,1),('2026-01-31 07:44:42','2026-01-31 07:45:39',NULL,0,2,'929444f150804704b1865bcbe068c936','gigabytes',0,0,NULL,1),('2026-01-31 07:44:42','2026-01-31 07:45:39',NULL,0,3,'929444f150804704b1865bcbe068c936','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:44:42','2026-01-31 07:45:39',NULL,0,4,'929444f150804704b1865bcbe068c936','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:49:20','2026-01-31 07:51:32',NULL,0,5,'e66a774f63ae4139a4e75c7973fbe077','volumes',0,0,NULL,1),('2026-01-31 07:49:20','2026-01-31 07:51:32',NULL,0,6,'e66a774f63ae4139a4e75c7973fbe077','gigabytes',0,0,NULL,1),('2026-01-31 07:49:20','2026-01-31 07:51:32',NULL,0,7,'e66a774f63ae4139a4e75c7973fbe077','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:49:20','2026-01-31 07:51:32',NULL,0,8,'e66a774f63ae4139a4e75c7973fbe077','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:49:31','2026-01-31 07:51:49',NULL,0,9,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes',0,0,NULL,1),('2026-01-31 07:49:31','2026-01-31 07:51:49',NULL,0,10,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes',0,0,NULL,1),('2026-01-31 07:49:31','2026-01-31 07:51:49',NULL,0,11,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:49:31','2026-01-31 07:51:49',NULL,0,12,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:52:38','2026-01-31 07:53:19',NULL,0,13,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes',0,0,NULL,1),('2026-01-31 07:52:38','2026-01-31 07:53:19',NULL,0,14,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes',0,0,NULL,1),('2026-01-31 07:52:38','2026-01-31 07:53:19',NULL,0,15,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:52:38','2026-01-31 07:53:19',NULL,0,16,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:54:01','2026-01-31 07:57:38',NULL,0,17,'fd9f0c923b994b0295e72b111f661de1','volumes',0,0,NULL,1),('2026-01-31 07:54:01','2026-01-31 07:57:38',NULL,0,18,'fd9f0c923b994b0295e72b111f661de1','gigabytes',0,0,NULL,1),('2026-01-31 07:54:01','2026-01-31 07:57:38',NULL,0,19,'fd9f0c923b994b0295e72b111f661de1','volumes_multiattach',0,0,NULL,1),('2026-01-31 07:54:01','2026-01-31 07:57:38',NULL,0,20,'fd9f0c923b994b0295e72b111f661de1','gigabytes_multiattach',0,0,NULL,1),('2026-01-31 07:58:49','2026-01-31 07:59:38',NULL,0,21,'273fe485cc184dd8bf86440d8d1e05f3','volumes',0,0,NULL,1),('2026-01-31 07:58:49','2026-01-31 07:59:38',NULL,0,22,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes',0,0,NULL,1),('2026-01-31 07:58:49','2026-01-31 07:59:38',NULL,0,23,'273fe485cc184dd8bf86440d8d1e05f3','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 07:58:49','2026-01-31 07:59:38',NULL,0,24,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:06:16','2026-01-31 08:10:28',NULL,0,25,'3469c253459e40e39dcf5bcb6a32008f','volumes',0,0,NULL,1),('2026-01-31 08:06:16','2026-01-31 08:10:28',NULL,0,26,'3469c253459e40e39dcf5bcb6a32008f','gigabytes',0,0,NULL,1),('2026-01-31 08:06:16','2026-01-31 08:10:28',NULL,0,27,'3469c253459e40e39dcf5bcb6a32008f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:06:16','2026-01-31 08:10:28',NULL,0,28,'3469c253459e40e39dcf5bcb6a32008f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:09:24','2026-01-31 08:10:23',NULL,0,29,'2901e55f200f4622ae841166074ac8f8','volumes',0,0,NULL,1),('2026-01-31 08:09:24','2026-01-31 08:10:23',NULL,0,30,'2901e55f200f4622ae841166074ac8f8','gigabytes',0,0,NULL,1),('2026-01-31 08:09:24','2026-01-31 08:10:23',NULL,0,31,'2901e55f200f4622ae841166074ac8f8','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:09:24','2026-01-31 08:10:23',NULL,0,32,'2901e55f200f4622ae841166074ac8f8','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:02','2026-01-31 08:12:32',NULL,0,33,'96cffd653fc04612bc1b3434529fb946','volumes',0,0,NULL,1),('2026-01-31 08:11:02','2026-01-31 08:12:32',NULL,0,34,'96cffd653fc04612bc1b3434529fb946','gigabytes',0,0,NULL,1),('2026-01-31 08:11:02','2026-01-31 08:12:32',NULL,0,35,'96cffd653fc04612bc1b3434529fb946','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:02','2026-01-31 08:12:32',NULL,0,36,'96cffd653fc04612bc1b3434529fb946','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:19','2026-01-31 08:15:21',NULL,0,37,'9c03fec1b3664105996aa979e226d8f8','volumes',0,0,NULL,1),('2026-01-31 08:11:19','2026-01-31 08:15:21',NULL,0,38,'9c03fec1b3664105996aa979e226d8f8','gigabytes',0,0,NULL,1),('2026-01-31 08:11:19','2026-01-31 08:15:21',NULL,0,39,'9c03fec1b3664105996aa979e226d8f8','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:11:19','2026-01-31 08:15:21',NULL,0,40,'9c03fec1b3664105996aa979e226d8f8','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:13:25','2026-01-31 08:17:24',NULL,0,41,'5a6c60c75300483aa07e13b08923b1a1','volumes',0,0,NULL,1),('2026-01-31 08:13:25','2026-01-31 08:17:24',NULL,0,42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',0,0,NULL,1),('2026-01-31 08:13:25','2026-01-31 08:17:24',NULL,0,43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:13:25','2026-01-31 08:17:24',NULL,0,44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:13:52','2026-01-31 08:18:13',NULL,0,45,'587e3df6fc904afc99c9c6411095e3ef','volumes',0,0,NULL,1),('2026-01-31 08:13:52','2026-01-31 08:18:13',NULL,0,46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',0,0,NULL,1),('2026-01-31 08:13:52','2026-01-31 08:18:13',NULL,0,47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:13:52','2026-01-31 08:18:13',NULL,0,48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:20:58','2026-01-31 08:23:43',NULL,0,49,'cf024d54545b4af882a87c721105742a','volumes',2,0,NULL,1),('2026-01-31 08:20:58','2026-01-31 08:23:43',NULL,0,50,'cf024d54545b4af882a87c721105742a','gigabytes',2,0,NULL,1),('2026-01-31 08:20:58','2026-01-31 08:23:43',NULL,0,51,'cf024d54545b4af882a87c721105742a','volumes___DEFAULT__',2,0,NULL,1),('2026-01-31 08:20:58','2026-01-31 08:23:43',NULL,0,52,'cf024d54545b4af882a87c721105742a','gigabytes___DEFAULT__',2,0,NULL,1),('2026-01-31 08:24:51','2026-01-31 08:30:57',NULL,0,53,'491937de020742d7b4e847dc3bf57950','volumes',0,0,NULL,1),('2026-01-31 08:24:51','2026-01-31 08:30:57',NULL,0,54,'491937de020742d7b4e847dc3bf57950','gigabytes',0,0,NULL,1),('2026-01-31 08:24:51','2026-01-31 08:30:57',NULL,0,55,'491937de020742d7b4e847dc3bf57950','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:24:51','2026-01-31 08:30:57',NULL,0,56,'491937de020742d7b4e847dc3bf57950','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:31:12','2026-01-31 08:35:31',NULL,0,57,'953a213fa5cb435ab3c04ad96152685f','volumes',0,0,NULL,1),('2026-01-31 08:31:12','2026-01-31 08:35:31',NULL,0,58,'953a213fa5cb435ab3c04ad96152685f','gigabytes',0,0,NULL,1),('2026-01-31 08:31:12','2026-01-31 08:35:31',NULL,0,59,'953a213fa5cb435ab3c04ad96152685f','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:31:12','2026-01-31 08:35:31',NULL,0,60,'953a213fa5cb435ab3c04ad96152685f','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:32:24','2026-01-31 08:33:46',NULL,0,61,'5fe2a450b6ff4f73a7fe8def47304a29','volumes',0,0,NULL,1),('2026-01-31 08:32:24','2026-01-31 08:33:46',NULL,0,62,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes',0,0,NULL,1),('2026-01-31 08:32:24','2026-01-31 08:33:46',NULL,0,63,'5fe2a450b6ff4f73a7fe8def47304a29','volumes_tempest-scenario-type-luks-75396166',0,0,NULL,1),('2026-01-31 08:32:24','2026-01-31 08:33:46',NULL,0,64,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes_tempest-scenario-type-luks-75396166',0,0,NULL,1),('2026-01-31 08:36:42','2026-01-31 08:39:21',NULL,0,65,'fcc39962194d44e5b37cad3fb1adc6c4','volumes',0,0,NULL,1),('2026-01-31 08:36:42','2026-01-31 08:39:21',NULL,0,66,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes',0,0,NULL,1),('2026-01-31 08:36:42','2026-01-31 08:39:21',NULL,0,67,'fcc39962194d44e5b37cad3fb1adc6c4','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:36:42','2026-01-31 08:39:21',NULL,0,68,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:37:32','2026-01-31 08:41:06',NULL,0,69,'1e29363ca464487b931af54fe14166b1','volumes',0,0,NULL,1),('2026-01-31 08:37:32','2026-01-31 08:41:06',NULL,0,70,'1e29363ca464487b931af54fe14166b1','gigabytes',0,0,NULL,1),('2026-01-31 08:37:32','2026-01-31 08:41:06',NULL,0,71,'1e29363ca464487b931af54fe14166b1','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:37:32','2026-01-31 08:41:06',NULL,0,72,'1e29363ca464487b931af54fe14166b1','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:39:33','2026-01-31 08:44:33',NULL,0,73,'621c17d53cba46d386de8efb560a988e','volumes',0,0,NULL,1),('2026-01-31 08:39:33','2026-01-31 08:44:33',NULL,0,74,'621c17d53cba46d386de8efb560a988e','gigabytes',0,0,NULL,1),('2026-01-31 08:39:34','2026-01-31 08:44:33',NULL,0,75,'621c17d53cba46d386de8efb560a988e','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:39:34','2026-01-31 08:44:33',NULL,0,76,'621c17d53cba46d386de8efb560a988e','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:45:31','2026-01-31 08:53:14',NULL,0,77,'8397e0fed04b4dabb57148d0924de2dc','volumes',0,0,NULL,1),('2026-01-31 08:45:31','2026-01-31 08:53:14',NULL,0,78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',0,0,NULL,1),('2026-01-31 08:45:31','2026-01-31 08:53:14',NULL,0,79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',0,0,NULL,1),('2026-01-31 08:45:31','2026-01-31 08:53:14',NULL,0,80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',0,0,NULL,1),('2026-01-31 08:48:13','2026-01-31 08:51:20',NULL,0,81,'bf1c3d387dbe4191b4d05bdfca5959da','volumes',0,0,NULL,1),('2026-01-31 08:48:13','2026-01-31 08:51:20',NULL,0,82,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes',0,0,NULL,1),('2026-01-31 08:48:13','2026-01-31 08:51:20',NULL,0,83,'bf1c3d387dbe4191b4d05bdfca5959da','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:48:13','2026-01-31 08:51:20',NULL,0,84,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:49:11','2026-01-31 08:53:02',NULL,0,85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',0,0,NULL,1),('2026-01-31 08:49:11','2026-01-31 08:53:02',NULL,0,86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',0,0,NULL,1),('2026-01-31 08:49:11','2026-01-31 08:53:02',NULL,0,87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:49:11','2026-01-31 08:53:02',NULL,0,88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:52:04','2026-01-31 08:52:16',NULL,0,89,'8397e0fed04b4dabb57148d0924de2dc','snapshots',0,0,NULL,1),('2026-01-31 08:52:04','2026-01-31 08:52:16',NULL,0,90,'8397e0fed04b4dabb57148d0924de2dc','snapshots_multiattach',0,0,NULL,1),('2026-01-31 08:52:23','2026-01-31 08:52:29',NULL,0,91,'7c88afe842cd47dea75807eea90f5e58','volumes',0,0,NULL,1),('2026-01-31 08:52:23','2026-01-31 08:52:29',NULL,0,92,'7c88afe842cd47dea75807eea90f5e58','gigabytes',0,0,NULL,1),('2026-01-31 08:52:23','2026-01-31 08:52:29',NULL,0,93,'7c88afe842cd47dea75807eea90f5e58','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:52:23','2026-01-31 08:52:29',NULL,0,94,'7c88afe842cd47dea75807eea90f5e58','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:53:20','2026-01-31 08:53:42',NULL,0,95,'c88376bcb43e42cf9894ecb9352e5822','volumes',0,0,NULL,1),('2026-01-31 08:53:20','2026-01-31 08:53:42',NULL,0,96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',0,0,NULL,1),('2026-01-31 08:53:20','2026-01-31 08:53:42',NULL,0,97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:53:20','2026-01-31 08:53:42',NULL,0,98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:54:57','2026-01-31 08:58:34',NULL,0,99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',0,0,NULL,1),('2026-01-31 08:54:57','2026-01-31 08:58:34',NULL,0,100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',0,0,NULL,1),('2026-01-31 08:54:57','2026-01-31 08:57:47',NULL,0,101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',0,0,NULL,1),('2026-01-31 08:54:57','2026-01-31 08:57:47',NULL,0,102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',0,0,NULL,1),('2026-01-31 08:54:58','2026-01-31 08:57:53',NULL,0,103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',0,0,NULL,1),('2026-01-31 08:54:58','2026-01-31 08:57:53',NULL,0,104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',0,0,NULL,1),('2026-01-31 08:55:01','2026-01-31 08:57:48',NULL,0,105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',0,0,NULL,1),('2026-01-31 08:55:01','2026-01-31 08:57:48',NULL,0,106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',0,0,NULL,1),('2026-01-31 08:55:01','2026-01-31 08:57:48',NULL,0,107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:55:01','2026-01-31 08:57:48',NULL,0,108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:55:05','2026-01-31 08:58:34',NULL,0,109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',0,0,NULL,1),('2026-01-31 08:55:05','2026-01-31 08:58:34',NULL,0,110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',0,0,NULL,1),('2026-01-31 08:58:03','2026-01-31 08:58:09',NULL,0,111,'01662186bc9a4adf8b2309e0fff4f829','volumes',0,0,NULL,1),('2026-01-31 08:58:03','2026-01-31 08:58:09',NULL,0,112,'01662186bc9a4adf8b2309e0fff4f829','gigabytes',0,0,NULL,1),('2026-01-31 08:58:03','2026-01-31 08:58:09',NULL,0,113,'01662186bc9a4adf8b2309e0fff4f829','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:58:03','2026-01-31 08:58:09',NULL,0,114,'01662186bc9a4adf8b2309e0fff4f829','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:58:07',NULL,0,115,'01662186bc9a4adf8b2309e0fff4f829','snapshots',0,0,NULL,1),('2026-01-31 08:58:04','2026-01-31 08:58:07',NULL,0,116,'01662186bc9a4adf8b2309e0fff4f829','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 08:59:57','2026-01-31 09:04:11',NULL,0,117,'3d3e35e8f8144cd58baa994b70ef9668','volumes',0,0,NULL,1),('2026-01-31 08:59:57','2026-01-31 09:04:11',NULL,0,118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',0,0,NULL,1),('2026-01-31 08:59:57','2026-01-31 09:04:11',NULL,0,119,'3d3e35e8f8144cd58baa994b70ef9668','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 08:59:57','2026-01-31 09:04:11',NULL,0,120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:00:06','2026-01-31 09:00:40',NULL,0,121,'3d3e35e8f8144cd58baa994b70ef9668','snapshots',0,0,NULL,1),('2026-01-31 09:00:06','2026-01-31 09:00:40',NULL,0,122,'3d3e35e8f8144cd58baa994b70ef9668','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 09:00:55','2026-01-31 09:08:52',NULL,0,123,'76ce367a834b49dfb5b436848118b860','volumes',0,0,NULL,1),('2026-01-31 09:00:55','2026-01-31 09:08:52',NULL,0,124,'76ce367a834b49dfb5b436848118b860','gigabytes',0,0,NULL,1),('2026-01-31 09:00:55','2026-01-31 09:01:46',NULL,0,125,'76ce367a834b49dfb5b436848118b860','volumes_tempest-scenario-type-luks-1403600605',0,0,NULL,1),('2026-01-31 09:00:56','2026-01-31 09:01:46',NULL,0,126,'76ce367a834b49dfb5b436848118b860','gigabytes_tempest-scenario-type-luks-1403600605',0,0,NULL,1),('2026-01-31 09:01:22','2026-01-31 09:03:38',NULL,0,127,'1f293713f6854265a89a1a4a002088d5','volumes',0,0,NULL,1),('2026-01-31 09:01:22','2026-01-31 09:03:38',NULL,0,128,'1f293713f6854265a89a1a4a002088d5','gigabytes',0,0,NULL,1),('2026-01-31 09:01:22','2026-01-31 09:03:38',NULL,0,129,'1f293713f6854265a89a1a4a002088d5','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:01:22','2026-01-31 09:03:38',NULL,0,130,'1f293713f6854265a89a1a4a002088d5','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:01:49','2026-01-31 09:08:52',NULL,0,131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:01:50','2026-01-31 09:08:52',NULL,0,132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:02:07','2026-01-31 09:08:45',NULL,0,133,'76ce367a834b49dfb5b436848118b860','snapshots',0,0,NULL,1),('2026-01-31 09:02:07','2026-01-31 09:08:45',NULL,0,134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',0,0,NULL,1),('2026-01-31 09:04:48','2026-01-31 09:06:05',NULL,0,135,'c8017efbc64b4244b349174c29a41000','volumes',0,0,NULL,1),('2026-01-31 09:04:48','2026-01-31 09:06:05',NULL,0,136,'c8017efbc64b4244b349174c29a41000','gigabytes',0,0,NULL,1),('2026-01-31 09:04:48','2026-01-31 09:06:05',NULL,0,137,'c8017efbc64b4244b349174c29a41000','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:04:48','2026-01-31 09:06:05',NULL,0,138,'c8017efbc64b4244b349174c29a41000','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:05:00','2026-01-31 09:06:04',NULL,0,139,'c8017efbc64b4244b349174c29a41000','backups',0,0,NULL,1),('2026-01-31 09:05:00','2026-01-31 09:06:04',NULL,0,140,'c8017efbc64b4244b349174c29a41000','backup_gigabytes',0,0,NULL,1),('2026-01-31 09:16:36','2026-01-31 09:18:56',NULL,0,141,'390709b3e5174dc4afdc6b04fdae67e3','volumes',0,0,NULL,1),('2026-01-31 09:16:36','2026-01-31 09:18:56',NULL,0,142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',0,0,NULL,1),('2026-01-31 09:16:36','2026-01-31 09:18:56',NULL,0,143,'390709b3e5174dc4afdc6b04fdae67e3','volumes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:16:36','2026-01-31 09:18:56',NULL,0,144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',0,0,NULL,1),('2026-01-31 09:17:17','2026-01-31 09:18:46',NULL,0,145,'390709b3e5174dc4afdc6b04fdae67e3','snapshots',0,0,NULL,1),('2026-01-31 09:17:17','2026-01-31 09:18:46',NULL,0,146,'390709b3e5174dc4afdc6b04fdae67e3','snapshots___DEFAULT__',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2026-01-31 07:44:42','2026-01-31 07:44:43','2026-01-31 07:44:43',1,1,'6829f4db-2e33-43c7-89aa-01581c96a918',1,'929444f150804704b1865bcbe068c936','volumes',1,'2026-02-01 07:44:42',NULL),('2026-01-31 07:44:42','2026-01-31 07:44:43','2026-01-31 07:44:43',1,2,'66db3d6d-93f3-4c90-96d7-8f01120767d1',2,'929444f150804704b1865bcbe068c936','gigabytes',1,'2026-02-01 07:44:42',NULL),('2026-01-31 07:44:42','2026-01-31 07:44:43','2026-01-31 07:44:43',1,3,'6b86e41f-84ab-43a5-830f-4d2c22a28cad',3,'929444f150804704b1865bcbe068c936','volumes___DEFAULT__',1,'2026-02-01 07:44:42',NULL),('2026-01-31 07:44:42','2026-01-31 07:44:43','2026-01-31 07:44:43',1,4,'51db5096-77a1-40de-970d-c8a11b5a35a0',4,'929444f150804704b1865bcbe068c936','gigabytes___DEFAULT__',1,'2026-02-01 07:44:42',NULL),('2026-01-31 07:45:39','2026-01-31 07:45:39','2026-01-31 07:45:39',1,5,'85f1d8ea-561b-4eb9-8e65-2daacf912e54',1,'929444f150804704b1865bcbe068c936','volumes',-1,'2026-02-01 07:45:39',NULL),('2026-01-31 07:45:39','2026-01-31 07:45:39','2026-01-31 07:45:39',1,6,'bdaa60d5-52f1-4d9f-8ed3-a721ee9bcb06',2,'929444f150804704b1865bcbe068c936','gigabytes',-1,'2026-02-01 07:45:39',NULL),('2026-01-31 07:45:39','2026-01-31 07:45:39','2026-01-31 07:45:39',1,7,'fd6315e5-475c-402f-887b-7c9cc51ae70c',3,'929444f150804704b1865bcbe068c936','volumes___DEFAULT__',-1,'2026-02-01 07:45:39',NULL),('2026-01-31 07:45:39','2026-01-31 07:45:39','2026-01-31 07:45:39',1,8,'4c4a6c49-8ad3-483f-bd38-26ca7153da40',4,'929444f150804704b1865bcbe068c936','gigabytes___DEFAULT__',-1,'2026-02-01 07:45:39',NULL),('2026-01-31 07:49:20','2026-01-31 07:49:20','2026-01-31 07:49:20',1,9,'d9947c2c-9f0f-4a2e-a8c6-75f8e50b9fa5',5,'e66a774f63ae4139a4e75c7973fbe077','volumes',1,'2026-02-01 07:49:20',NULL),('2026-01-31 07:49:20','2026-01-31 07:49:20','2026-01-31 07:49:20',1,10,'fab57bf6-c511-4a69-810e-7e0b7d2af5a8',6,'e66a774f63ae4139a4e75c7973fbe077','gigabytes',1,'2026-02-01 07:49:20',NULL),('2026-01-31 07:49:20','2026-01-31 07:49:20','2026-01-31 07:49:20',1,11,'5955d622-fb18-4c1e-9423-273c00c55aeb',7,'e66a774f63ae4139a4e75c7973fbe077','volumes___DEFAULT__',1,'2026-02-01 07:49:20',NULL),('2026-01-31 07:49:20','2026-01-31 07:49:20','2026-01-31 07:49:20',1,12,'232f685b-ebfa-488a-85bf-0d23dfdd8a28',8,'e66a774f63ae4139a4e75c7973fbe077','gigabytes___DEFAULT__',1,'2026-02-01 07:49:20',NULL),('2026-01-31 07:49:31','2026-01-31 07:49:31','2026-01-31 07:49:31',1,13,'f81a573e-4275-4a99-841a-a0789ddabe85',9,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes',1,'2026-02-01 07:49:31',NULL),('2026-01-31 07:49:31','2026-01-31 07:49:31','2026-01-31 07:49:31',1,14,'45b54b96-3668-46fa-a1a9-6be4c060ab71',10,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes',1,'2026-02-01 07:49:31',NULL),('2026-01-31 07:49:31','2026-01-31 07:49:31','2026-01-31 07:49:31',1,15,'a78ded42-517a-4e4e-8de3-20309bb0d958',11,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes___DEFAULT__',1,'2026-02-01 07:49:31',NULL),('2026-01-31 07:49:31','2026-01-31 07:49:31','2026-01-31 07:49:31',1,16,'f5aeb31f-5b9d-4e18-85f1-d3e2f043f8f0',12,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes___DEFAULT__',1,'2026-02-01 07:49:31',NULL),('2026-01-31 07:51:32','2026-01-31 07:51:32','2026-01-31 07:51:32',1,17,'407c2bac-71a6-4fbc-98e9-52b01bcae46e',5,'e66a774f63ae4139a4e75c7973fbe077','volumes',-1,'2026-02-01 07:51:32',NULL),('2026-01-31 07:51:32','2026-01-31 07:51:32','2026-01-31 07:51:32',1,18,'df27d03a-bc6e-4ab9-b0d5-82e27e68a69a',6,'e66a774f63ae4139a4e75c7973fbe077','gigabytes',-1,'2026-02-01 07:51:32',NULL),('2026-01-31 07:51:32','2026-01-31 07:51:32','2026-01-31 07:51:32',1,19,'d4e627d4-c983-4f0d-aefb-25a9c1e1913c',7,'e66a774f63ae4139a4e75c7973fbe077','volumes___DEFAULT__',-1,'2026-02-01 07:51:32',NULL),('2026-01-31 07:51:32','2026-01-31 07:51:32','2026-01-31 07:51:32',1,20,'5eab2a47-4f55-420a-981b-eb7abfc29217',8,'e66a774f63ae4139a4e75c7973fbe077','gigabytes___DEFAULT__',-1,'2026-02-01 07:51:32',NULL),('2026-01-31 07:51:49','2026-01-31 07:51:49','2026-01-31 07:51:49',1,21,'543884c8-8f3a-4e60-a970-3a8599265085',9,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes',-1,'2026-02-01 07:51:49',NULL),('2026-01-31 07:51:49','2026-01-31 07:51:49','2026-01-31 07:51:49',1,22,'9204271b-591f-4398-bbdc-0e3d5520cef8',10,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes',-1,'2026-02-01 07:51:49',NULL),('2026-01-31 07:51:49','2026-01-31 07:51:49','2026-01-31 07:51:49',1,23,'a9186935-dc64-48c9-8a42-31e591bee45f',11,'cbdbb7a4b22a49b68feb3e028bb62fbb','volumes___DEFAULT__',-1,'2026-02-01 07:51:49',NULL),('2026-01-31 07:51:49','2026-01-31 07:51:49','2026-01-31 07:51:49',1,24,'8bc01ad4-d1a7-4cd9-a5c1-ff5a6e95ccb2',12,'cbdbb7a4b22a49b68feb3e028bb62fbb','gigabytes___DEFAULT__',-1,'2026-02-01 07:51:49',NULL),('2026-01-31 07:52:38','2026-01-31 07:52:38','2026-01-31 07:52:38',1,25,'9aac6e47-9fbb-4d8e-89d9-ebe9756634c1',13,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes',1,'2026-02-01 07:52:38',NULL),('2026-01-31 07:52:38','2026-01-31 07:52:38','2026-01-31 07:52:38',1,26,'f2c62064-1ad5-40cb-87e2-da2888a9606d',14,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes',1,'2026-02-01 07:52:38',NULL),('2026-01-31 07:52:38','2026-01-31 07:52:38','2026-01-31 07:52:38',1,27,'4180bebc-7584-409c-be90-ceba118c8725',15,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes___DEFAULT__',1,'2026-02-01 07:52:38',NULL),('2026-01-31 07:52:38','2026-01-31 07:52:38','2026-01-31 07:52:38',1,28,'123d978c-e9d7-446e-bd9f-fbc426adada2',16,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes___DEFAULT__',1,'2026-02-01 07:52:38',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,29,'63ba3d1b-2063-4419-b197-7ce5ca8ad63e',13,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,30,'c797d008-92e1-4613-8b1a-f114f430dc8e',14,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,31,'bc989d55-9fd6-4e38-b010-080bfff92d62',15,'ea1f64b5b90d4a90a6cb764c4cdcca59','volumes___DEFAULT__',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:53:19','2026-01-31 07:53:19','2026-01-31 07:53:19',1,32,'a0adee4c-9785-4a6a-ae1d-ae64ab5dfe54',16,'ea1f64b5b90d4a90a6cb764c4cdcca59','gigabytes___DEFAULT__',-1,'2026-02-01 07:53:19',NULL),('2026-01-31 07:54:01','2026-01-31 07:54:01','2026-01-31 07:54:01',1,33,'1ab02844-a5f5-4001-ba9e-fece804d110b',17,'fd9f0c923b994b0295e72b111f661de1','volumes',1,'2026-02-01 07:54:01',NULL),('2026-01-31 07:54:01','2026-01-31 07:54:01','2026-01-31 07:54:01',1,34,'344b73df-dd75-43e6-921f-84cef5fd4b1c',18,'fd9f0c923b994b0295e72b111f661de1','gigabytes',1,'2026-02-01 07:54:01',NULL),('2026-01-31 07:54:01','2026-01-31 07:54:01','2026-01-31 07:54:01',1,35,'0a272d8d-f554-40f9-94e3-1bfca89fdaf0',19,'fd9f0c923b994b0295e72b111f661de1','volumes_multiattach',1,'2026-02-01 07:54:01',NULL),('2026-01-31 07:54:01','2026-01-31 07:54:01','2026-01-31 07:54:01',1,36,'c058b5a0-a928-44b0-96b9-24bc5141eb2c',20,'fd9f0c923b994b0295e72b111f661de1','gigabytes_multiattach',1,'2026-02-01 07:54:01',NULL),('2026-01-31 07:54:06','2026-01-31 07:54:06','2026-01-31 07:54:06',1,37,'7b8ed190-1ce5-4921-9985-56414a64150b',17,'fd9f0c923b994b0295e72b111f661de1','volumes',1,'2026-02-01 07:54:06',NULL),('2026-01-31 07:54:06','2026-01-31 07:54:06','2026-01-31 07:54:06',1,38,'043722f8-23ec-4eed-9b58-95ff91a22306',18,'fd9f0c923b994b0295e72b111f661de1','gigabytes',1,'2026-02-01 07:54:06',NULL),('2026-01-31 07:54:06','2026-01-31 07:54:06','2026-01-31 07:54:06',1,39,'6dd21338-ee2d-4b09-9a5f-adec1fde0c24',19,'fd9f0c923b994b0295e72b111f661de1','volumes_multiattach',1,'2026-02-01 07:54:06',NULL),('2026-01-31 07:54:06','2026-01-31 07:54:06','2026-01-31 07:54:06',1,40,'5921ba09-234b-499c-b5be-c75ac949aec2',20,'fd9f0c923b994b0295e72b111f661de1','gigabytes_multiattach',1,'2026-02-01 07:54:06',NULL),('2026-01-31 07:57:34','2026-01-31 07:57:34','2026-01-31 07:57:34',1,41,'0fae1831-f42d-49db-a48b-fc873e19ec59',17,'fd9f0c923b994b0295e72b111f661de1','volumes',-1,'2026-02-01 07:57:34',NULL),('2026-01-31 07:57:34','2026-01-31 07:57:34','2026-01-31 07:57:34',1,42,'35423f34-c2cd-4e1d-8926-fc10f4ab3c08',18,'fd9f0c923b994b0295e72b111f661de1','gigabytes',-1,'2026-02-01 07:57:34',NULL),('2026-01-31 07:57:34','2026-01-31 07:57:34','2026-01-31 07:57:34',1,43,'eb13aa18-25d6-43a7-ab3f-c46703c56abb',19,'fd9f0c923b994b0295e72b111f661de1','volumes_multiattach',-1,'2026-02-01 07:57:34',NULL),('2026-01-31 07:57:34','2026-01-31 07:57:34','2026-01-31 07:57:34',1,44,'8b38d83a-921f-4a5d-ae7d-6bfa9b29aff2',20,'fd9f0c923b994b0295e72b111f661de1','gigabytes_multiattach',-1,'2026-02-01 07:57:34',NULL),('2026-01-31 07:57:38','2026-01-31 07:57:38','2026-01-31 07:57:38',1,45,'791d7298-97cc-48fb-b68f-9b2ceed93198',17,'fd9f0c923b994b0295e72b111f661de1','volumes',-1,'2026-02-01 07:57:38',NULL),('2026-01-31 07:57:38','2026-01-31 07:57:38','2026-01-31 07:57:38',1,46,'59367d7a-bb43-4f3e-b254-8c29c7f8fa12',18,'fd9f0c923b994b0295e72b111f661de1','gigabytes',-1,'2026-02-01 07:57:38',NULL),('2026-01-31 07:57:38','2026-01-31 07:57:38','2026-01-31 07:57:38',1,47,'d228808b-95e5-40de-9e01-0a9f234d75fa',19,'fd9f0c923b994b0295e72b111f661de1','volumes_multiattach',-1,'2026-02-01 07:57:38',NULL),('2026-01-31 07:57:38','2026-01-31 07:57:38','2026-01-31 07:57:38',1,48,'7092118a-ef40-4883-8160-66ca9512abb3',20,'fd9f0c923b994b0295e72b111f661de1','gigabytes_multiattach',-1,'2026-02-01 07:57:38',NULL),('2026-01-31 07:58:49','2026-01-31 07:58:49','2026-01-31 07:58:49',1,49,'1a080a05-1aa0-4bf8-96b0-abc9f2b94489',21,'273fe485cc184dd8bf86440d8d1e05f3','volumes',1,'2026-02-01 07:58:49',NULL),('2026-01-31 07:58:49','2026-01-31 07:58:49','2026-01-31 07:58:49',1,50,'29828d91-5f58-4c51-954e-9d10344a6ed4',22,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes',1,'2026-02-01 07:58:49',NULL),('2026-01-31 07:58:49','2026-01-31 07:58:49','2026-01-31 07:58:49',1,51,'a8b8498c-54a4-4ccc-969e-011eace5828e',23,'273fe485cc184dd8bf86440d8d1e05f3','volumes___DEFAULT__',1,'2026-02-01 07:58:49',NULL),('2026-01-31 07:58:49','2026-01-31 07:58:49','2026-01-31 07:58:49',1,52,'4bee5d41-b16d-4d91-9a46-b1d08fc47001',24,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes___DEFAULT__',1,'2026-02-01 07:58:49',NULL),('2026-01-31 07:59:22','2026-01-31 07:59:22','2026-01-31 07:59:22',1,53,'a62c4df5-ebb8-4fa4-a7b3-ce4c95167cd7',21,'273fe485cc184dd8bf86440d8d1e05f3','volumes',1,'2026-02-01 07:59:22',NULL),('2026-01-31 07:59:22','2026-01-31 07:59:22','2026-01-31 07:59:22',1,54,'d9e49088-96cb-450c-a6ac-3f8a11c9651b',22,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes',1,'2026-02-01 07:59:22',NULL),('2026-01-31 07:59:22','2026-01-31 07:59:22','2026-01-31 07:59:22',1,55,'2a59ff6d-3869-4ee8-8940-b7f11465d79d',23,'273fe485cc184dd8bf86440d8d1e05f3','volumes___DEFAULT__',1,'2026-02-01 07:59:22',NULL),('2026-01-31 07:59:22','2026-01-31 07:59:22','2026-01-31 07:59:22',1,56,'69ac9544-3b76-4102-826a-2c05f4c74a83',24,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes___DEFAULT__',1,'2026-02-01 07:59:22',NULL),('2026-01-31 07:59:25','2026-01-31 07:59:25','2026-01-31 07:59:25',1,57,'d029af8c-cc00-4e56-b35d-58dfb85e668b',21,'273fe485cc184dd8bf86440d8d1e05f3','volumes',-1,'2026-02-01 07:59:25',NULL),('2026-01-31 07:59:25','2026-01-31 07:59:25','2026-01-31 07:59:25',1,58,'42579335-e2e5-49e2-927a-1f5fdc5e1425',22,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes',-1,'2026-02-01 07:59:25',NULL),('2026-01-31 07:59:25','2026-01-31 07:59:25','2026-01-31 07:59:25',1,59,'0cf4bd3c-10ff-4d30-b4e9-a3fdef869238',23,'273fe485cc184dd8bf86440d8d1e05f3','volumes___DEFAULT__',-1,'2026-02-01 07:59:25',NULL),('2026-01-31 07:59:25','2026-01-31 07:59:25','2026-01-31 07:59:25',1,60,'dba23f91-082c-4475-9e16-6e351f12e35d',24,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes___DEFAULT__',-1,'2026-02-01 07:59:25',NULL),('2026-01-31 07:59:38','2026-01-31 07:59:38','2026-01-31 07:59:38',1,61,'6f818a59-1028-42b7-9932-94eb0929cd74',21,'273fe485cc184dd8bf86440d8d1e05f3','volumes',-1,'2026-02-01 07:59:38',NULL),('2026-01-31 07:59:38','2026-01-31 07:59:38','2026-01-31 07:59:38',1,62,'089ab645-084a-4266-b1e0-36c81efb858e',22,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes',-1,'2026-02-01 07:59:38',NULL),('2026-01-31 07:59:38','2026-01-31 07:59:38','2026-01-31 07:59:38',1,63,'6bc6c054-5dd0-49c2-81a6-1aa38609299e',23,'273fe485cc184dd8bf86440d8d1e05f3','volumes___DEFAULT__',-1,'2026-02-01 07:59:38',NULL),('2026-01-31 07:59:38','2026-01-31 07:59:38','2026-01-31 07:59:38',1,64,'302fb42e-6a6a-42af-8ec1-40feda565845',24,'273fe485cc184dd8bf86440d8d1e05f3','gigabytes___DEFAULT__',-1,'2026-02-01 07:59:38',NULL),('2026-01-31 08:06:16','2026-01-31 08:06:16','2026-01-31 08:06:16',1,65,'e5521f3f-4ec6-44b9-92f2-dad6805677a9',25,'3469c253459e40e39dcf5bcb6a32008f','volumes',1,'2026-02-01 08:06:16',NULL),('2026-01-31 08:06:16','2026-01-31 08:06:16','2026-01-31 08:06:16',1,66,'c29acbf4-2ed7-40d7-9f8c-5e55a44fe44a',26,'3469c253459e40e39dcf5bcb6a32008f','gigabytes',1,'2026-02-01 08:06:16',NULL),('2026-01-31 08:06:16','2026-01-31 08:06:16','2026-01-31 08:06:16',1,67,'0ed7af4e-c4f7-4d4b-b578-076e6b1a6171',27,'3469c253459e40e39dcf5bcb6a32008f','volumes___DEFAULT__',1,'2026-02-01 08:06:16',NULL),('2026-01-31 08:06:16','2026-01-31 08:06:16','2026-01-31 08:06:16',1,68,'69051546-941d-47ec-952b-36c5313ca935',28,'3469c253459e40e39dcf5bcb6a32008f','gigabytes___DEFAULT__',1,'2026-02-01 08:06:16',NULL),('2026-01-31 08:09:24','2026-01-31 08:09:24','2026-01-31 08:09:24',1,69,'c20f923a-81ee-46de-b94c-de3297fc947e',29,'2901e55f200f4622ae841166074ac8f8','volumes',1,'2026-02-01 08:09:24',NULL),('2026-01-31 08:09:24','2026-01-31 08:09:24','2026-01-31 08:09:24',1,70,'f9319db2-e703-4c86-84ed-a5ac41be6447',30,'2901e55f200f4622ae841166074ac8f8','gigabytes',1,'2026-02-01 08:09:24',NULL),('2026-01-31 08:09:24','2026-01-31 08:09:24','2026-01-31 08:09:24',1,71,'69d782cb-bf82-4730-a75b-1f86277f9809',31,'2901e55f200f4622ae841166074ac8f8','volumes___DEFAULT__',1,'2026-02-01 08:09:24',NULL),('2026-01-31 08:09:24','2026-01-31 08:09:24','2026-01-31 08:09:24',1,72,'c4463342-13c6-4a44-9afa-f80a000f125f',32,'2901e55f200f4622ae841166074ac8f8','gigabytes___DEFAULT__',1,'2026-02-01 08:09:24',NULL),('2026-01-31 08:10:23','2026-01-31 08:10:23','2026-01-31 08:10:23',1,73,'27be6e6e-3a42-4504-846a-f14ce407b821',29,'2901e55f200f4622ae841166074ac8f8','volumes',-1,'2026-02-01 08:10:23',NULL),('2026-01-31 08:10:23','2026-01-31 08:10:23','2026-01-31 08:10:23',1,74,'ab485937-6c2f-4cde-9fe5-5275656337f6',30,'2901e55f200f4622ae841166074ac8f8','gigabytes',-1,'2026-02-01 08:10:23',NULL),('2026-01-31 08:10:23','2026-01-31 08:10:23','2026-01-31 08:10:23',1,75,'b4221fa3-46e0-4205-95ae-c77fc0af6439',31,'2901e55f200f4622ae841166074ac8f8','volumes___DEFAULT__',-1,'2026-02-01 08:10:23',NULL),('2026-01-31 08:10:23','2026-01-31 08:10:23','2026-01-31 08:10:23',1,76,'a7bd1389-c30c-4878-ba62-e0ac5481fe85',32,'2901e55f200f4622ae841166074ac8f8','gigabytes___DEFAULT__',-1,'2026-02-01 08:10:23',NULL),('2026-01-31 08:10:28','2026-01-31 08:10:28','2026-01-31 08:10:28',1,77,'5f078fbc-d596-47cf-88fe-a7bf5e03cf25',25,'3469c253459e40e39dcf5bcb6a32008f','volumes',-1,'2026-02-01 08:10:28',NULL),('2026-01-31 08:10:28','2026-01-31 08:10:28','2026-01-31 08:10:28',1,78,'746faa09-b63b-4089-ae0b-9dc12933b1f8',26,'3469c253459e40e39dcf5bcb6a32008f','gigabytes',-1,'2026-02-01 08:10:28',NULL),('2026-01-31 08:10:28','2026-01-31 08:10:28','2026-01-31 08:10:28',1,79,'41d9505d-656d-41c3-970e-8c053e24e9ea',27,'3469c253459e40e39dcf5bcb6a32008f','volumes___DEFAULT__',-1,'2026-02-01 08:10:28',NULL),('2026-01-31 08:10:28','2026-01-31 08:10:28','2026-01-31 08:10:28',1,80,'ab4fc162-3363-45f1-9178-cc64532b7fe1',28,'3469c253459e40e39dcf5bcb6a32008f','gigabytes___DEFAULT__',-1,'2026-02-01 08:10:28',NULL),('2026-01-31 08:11:02','2026-01-31 08:11:02','2026-01-31 08:11:02',1,81,'0d99a252-81c1-4287-8c8b-6bdeab6dbca3',33,'96cffd653fc04612bc1b3434529fb946','volumes',1,'2026-02-01 08:11:02',NULL),('2026-01-31 08:11:02','2026-01-31 08:11:02','2026-01-31 08:11:02',1,82,'b8aa468a-2eb3-4194-a418-d9455d4950ec',34,'96cffd653fc04612bc1b3434529fb946','gigabytes',1,'2026-02-01 08:11:02',NULL),('2026-01-31 08:11:02','2026-01-31 08:11:02','2026-01-31 08:11:02',1,83,'0bb42f1d-165f-4401-b664-8ac17161d3dc',35,'96cffd653fc04612bc1b3434529fb946','volumes___DEFAULT__',1,'2026-02-01 08:11:02',NULL),('2026-01-31 08:11:02','2026-01-31 08:11:02','2026-01-31 08:11:02',1,84,'f86d7d43-5a84-437f-9af3-247ce5e5eddb',36,'96cffd653fc04612bc1b3434529fb946','gigabytes___DEFAULT__',1,'2026-02-01 08:11:02',NULL),('2026-01-31 08:11:19','2026-01-31 08:11:19','2026-01-31 08:11:19',1,85,'1ba94656-35e4-4586-b282-75390864d492',37,'9c03fec1b3664105996aa979e226d8f8','volumes',1,'2026-02-01 08:11:19',NULL),('2026-01-31 08:11:19','2026-01-31 08:11:19','2026-01-31 08:11:19',1,86,'1e24effc-5ad5-4a9b-bfef-cc0b30061b90',38,'9c03fec1b3664105996aa979e226d8f8','gigabytes',1,'2026-02-01 08:11:19',NULL),('2026-01-31 08:11:19','2026-01-31 08:11:19','2026-01-31 08:11:19',1,87,'36e84e3a-fd21-4d9f-b536-d0d4e4be1148',39,'9c03fec1b3664105996aa979e226d8f8','volumes___DEFAULT__',1,'2026-02-01 08:11:19',NULL),('2026-01-31 08:11:19','2026-01-31 08:11:19','2026-01-31 08:11:19',1,88,'972ce577-e7b6-45f9-b583-d20841b701f7',40,'9c03fec1b3664105996aa979e226d8f8','gigabytes___DEFAULT__',1,'2026-02-01 08:11:19',NULL),('2026-01-31 08:12:32','2026-01-31 08:12:32','2026-01-31 08:12:32',1,89,'457260f2-e40b-4b66-a053-99b5fb9b8f28',33,'96cffd653fc04612bc1b3434529fb946','volumes',-1,'2026-02-01 08:12:32',NULL),('2026-01-31 08:12:32','2026-01-31 08:12:32','2026-01-31 08:12:32',1,90,'e900d0d4-55bd-464f-a02b-ea3d1c4effdd',34,'96cffd653fc04612bc1b3434529fb946','gigabytes',-1,'2026-02-01 08:12:32',NULL),('2026-01-31 08:12:32','2026-01-31 08:12:32','2026-01-31 08:12:32',1,91,'1b895590-bd09-489d-9e36-3777099b855d',35,'96cffd653fc04612bc1b3434529fb946','volumes___DEFAULT__',-1,'2026-02-01 08:12:32',NULL),('2026-01-31 08:12:32','2026-01-31 08:12:32','2026-01-31 08:12:32',1,92,'07c8e8a1-42d0-4e0c-806c-8380a790af03',36,'96cffd653fc04612bc1b3434529fb946','gigabytes___DEFAULT__',-1,'2026-02-01 08:12:32',NULL),('2026-01-31 08:13:07','2026-01-31 08:13:08','2026-01-31 08:13:08',1,93,'8977f734-8e30-47d2-b2e7-4208b5f71402',37,'9c03fec1b3664105996aa979e226d8f8','volumes',1,'2026-02-01 08:13:07',NULL),('2026-01-31 08:13:07','2026-01-31 08:13:08','2026-01-31 08:13:08',1,94,'f0dc6f94-14f5-4b4f-8e41-f08e3bb057a0',38,'9c03fec1b3664105996aa979e226d8f8','gigabytes',1,'2026-02-01 08:13:07',NULL),('2026-01-31 08:13:07','2026-01-31 08:13:08','2026-01-31 08:13:08',1,95,'015dcb83-c703-4597-bead-1fdaffbb164c',39,'9c03fec1b3664105996aa979e226d8f8','volumes___DEFAULT__',1,'2026-02-01 08:13:07',NULL),('2026-01-31 08:13:07','2026-01-31 08:13:08','2026-01-31 08:13:08',1,96,'68d87f9a-88a3-4d6a-acd3-e8550fe9d399',40,'9c03fec1b3664105996aa979e226d8f8','gigabytes___DEFAULT__',1,'2026-02-01 08:13:07',NULL),('2026-01-31 08:13:25','2026-01-31 08:13:25','2026-01-31 08:13:25',1,97,'c99a81a7-50f4-426a-a1ff-afb95d5a38a7',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',1,'2026-02-01 08:13:25',NULL),('2026-01-31 08:13:25','2026-01-31 08:13:25','2026-01-31 08:13:25',1,98,'0f2cb5b5-34cc-467c-ae52-df097244e800',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',1,'2026-02-01 08:13:25',NULL),('2026-01-31 08:13:25','2026-01-31 08:13:25','2026-01-31 08:13:25',1,99,'3978e18e-de00-49f4-b206-ae68b9abc617',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',1,'2026-02-01 08:13:25',NULL),('2026-01-31 08:13:25','2026-01-31 08:13:25','2026-01-31 08:13:25',1,100,'42a27235-85c8-44ca-8762-200f9c0a0313',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',1,'2026-02-01 08:13:25',NULL),('2026-01-31 08:13:39','2026-01-31 08:13:39','2026-01-31 08:13:39',1,101,'c5d5f3d2-b3cc-4268-ac39-31e6f43116d9',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',1,'2026-02-01 08:13:39',NULL),('2026-01-31 08:13:39','2026-01-31 08:13:39','2026-01-31 08:13:39',1,102,'b9b55900-8cdb-4257-af5a-d2dbc00c2dbb',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',1,'2026-02-01 08:13:39',NULL),('2026-01-31 08:13:39','2026-01-31 08:13:39','2026-01-31 08:13:39',1,103,'e4a3456c-7bf4-4da6-b1db-52ab4a44538b',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',1,'2026-02-01 08:13:39',NULL),('2026-01-31 08:13:39','2026-01-31 08:13:39','2026-01-31 08:13:39',1,104,'42560507-a18d-44f5-b849-586a717c3d51',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',1,'2026-02-01 08:13:39',NULL),('2026-01-31 08:13:41','2026-01-31 08:13:41','2026-01-31 08:13:41',1,105,'df16e29b-9122-4691-bb63-a15aec9f8492',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',1,'2026-02-01 08:13:41',NULL),('2026-01-31 08:13:41','2026-01-31 08:13:41','2026-01-31 08:13:41',1,106,'4dd9da7c-ba05-448c-a7a3-ea875f982f4b',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',1,'2026-02-01 08:13:41',NULL),('2026-01-31 08:13:41','2026-01-31 08:13:41','2026-01-31 08:13:41',1,107,'fdae8428-a12a-443f-9be3-06f4946759f5',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',1,'2026-02-01 08:13:41',NULL),('2026-01-31 08:13:41','2026-01-31 08:13:41','2026-01-31 08:13:41',1,108,'471c49c9-d719-41ec-9ddf-ce3ad30d1688',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',1,'2026-02-01 08:13:41',NULL),('2026-01-31 08:13:52','2026-01-31 08:13:52','2026-01-31 08:13:52',1,109,'adef9a35-7fbb-44be-8cb2-4acf51c9c0d7',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',1,'2026-02-01 08:13:52',NULL),('2026-01-31 08:13:52','2026-01-31 08:13:52','2026-01-31 08:13:52',1,110,'3b615a12-0975-41f4-a9d0-09724c8c17e4',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',1,'2026-02-01 08:13:52',NULL),('2026-01-31 08:13:52','2026-01-31 08:13:52','2026-01-31 08:13:52',1,111,'31325895-7452-4b98-96e2-e7ac1882d682',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',1,'2026-02-01 08:13:52',NULL),('2026-01-31 08:13:52','2026-01-31 08:13:52','2026-01-31 08:13:52',1,112,'21ecbbbd-ece1-4990-8c01-e145ab4c6cae',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',1,'2026-02-01 08:13:52',NULL),('2026-01-31 08:14:07','2026-01-31 08:14:08','2026-01-31 08:14:08',1,113,'d96d20aa-98eb-4ee5-a4a1-08a544f98203',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',1,'2026-02-01 08:14:07',NULL),('2026-01-31 08:14:07','2026-01-31 08:14:08','2026-01-31 08:14:08',1,114,'9c7e06d0-341d-47d6-8497-d9cea71e1851',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',1,'2026-02-01 08:14:07',NULL),('2026-01-31 08:14:07','2026-01-31 08:14:08','2026-01-31 08:14:08',1,115,'6e228e4e-2126-4e6b-84e7-9b6cc2feac61',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',1,'2026-02-01 08:14:07',NULL),('2026-01-31 08:14:07','2026-01-31 08:14:08','2026-01-31 08:14:08',1,116,'70e034c6-4fc9-4dd2-b4ed-7704bb34a659',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',1,'2026-02-01 08:14:07',NULL),('2026-01-31 08:14:10','2026-01-31 08:14:11','2026-01-31 08:14:11',1,117,'3433296d-e124-432e-8ccc-7c300bf91c0b',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',1,'2026-02-01 08:14:10',NULL),('2026-01-31 08:14:10','2026-01-31 08:14:11','2026-01-31 08:14:11',1,118,'08677b02-adac-4c64-9ebf-2f990c62ed73',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',1,'2026-02-01 08:14:10',NULL),('2026-01-31 08:14:10','2026-01-31 08:14:11','2026-01-31 08:14:11',1,119,'d362ba8a-812e-4372-9558-5124b0bf5a3d',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',1,'2026-02-01 08:14:10',NULL),('2026-01-31 08:14:10','2026-01-31 08:14:11','2026-01-31 08:14:11',1,120,'447f9083-3f47-456d-aa1b-b80eb6ee48bc',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',1,'2026-02-01 08:14:10',NULL),('2026-01-31 08:14:56','2026-01-31 08:14:57','2026-01-31 08:14:57',1,121,'056505e6-bd87-479f-8a49-aebf6dc20ab4',37,'9c03fec1b3664105996aa979e226d8f8','volumes',-1,'2026-02-01 08:14:56',NULL),('2026-01-31 08:14:56','2026-01-31 08:14:57','2026-01-31 08:14:57',1,122,'94efbfb6-880c-4cd6-a120-57eab6e58258',38,'9c03fec1b3664105996aa979e226d8f8','gigabytes',-1,'2026-02-01 08:14:56',NULL),('2026-01-31 08:14:56','2026-01-31 08:14:57','2026-01-31 08:14:57',1,123,'268c5d0c-cee2-4d15-bfd3-e3db9fc8ede6',39,'9c03fec1b3664105996aa979e226d8f8','volumes___DEFAULT__',-1,'2026-02-01 08:14:56',NULL),('2026-01-31 08:14:56','2026-01-31 08:14:57','2026-01-31 08:14:57',1,124,'976f9985-b12a-4815-ba25-e062fd1a363a',40,'9c03fec1b3664105996aa979e226d8f8','gigabytes___DEFAULT__',-1,'2026-02-01 08:14:56',NULL),('2026-01-31 08:15:21','2026-01-31 08:15:21','2026-01-31 08:15:21',1,125,'1dd42ed1-9f0c-42c6-89b4-b7efc67aa62f',37,'9c03fec1b3664105996aa979e226d8f8','volumes',-1,'2026-02-01 08:15:21',NULL),('2026-01-31 08:15:21','2026-01-31 08:15:21','2026-01-31 08:15:21',1,126,'821f0d50-5212-41f1-8976-dc51fcb268c2',38,'9c03fec1b3664105996aa979e226d8f8','gigabytes',-1,'2026-02-01 08:15:21',NULL),('2026-01-31 08:15:21','2026-01-31 08:15:21','2026-01-31 08:15:21',1,127,'0cc7bcf1-13c3-44b3-9712-665164545c3c',39,'9c03fec1b3664105996aa979e226d8f8','volumes___DEFAULT__',-1,'2026-02-01 08:15:21',NULL),('2026-01-31 08:15:21','2026-01-31 08:15:21','2026-01-31 08:15:21',1,128,'6b403b19-cb94-4177-9216-75a79eabf9c1',40,'9c03fec1b3664105996aa979e226d8f8','gigabytes___DEFAULT__',-1,'2026-02-01 08:15:21',NULL),('2026-01-31 08:17:17','2026-01-31 08:17:18','2026-01-31 08:17:18',1,129,'1af8445d-388d-4287-93d8-a5f3ebd96d61',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',-1,'2026-02-01 08:17:17',NULL),('2026-01-31 08:17:17','2026-01-31 08:17:18','2026-01-31 08:17:18',1,130,'e5e42fb1-9977-4f97-bf41-dddde8fca1e5',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',-1,'2026-02-01 08:17:17',NULL),('2026-01-31 08:17:17','2026-01-31 08:17:18','2026-01-31 08:17:18',1,131,'3481d9eb-54a4-4a2b-bb73-80ddaa479cf6',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',-1,'2026-02-01 08:17:17',NULL),('2026-01-31 08:17:17','2026-01-31 08:17:18','2026-01-31 08:17:18',1,132,'8203270e-9076-44b7-8b8c-29279377bb3e',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',-1,'2026-02-01 08:17:17',NULL),('2026-01-31 08:17:20','2026-01-31 08:17:20','2026-01-31 08:17:20',1,133,'a964be30-f7f4-4b02-acef-6c25a3161a36',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',-1,'2026-02-01 08:17:20',NULL),('2026-01-31 08:17:20','2026-01-31 08:17:20','2026-01-31 08:17:20',1,134,'f8c37bf6-8dec-41ad-9e4c-e49933680586',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',-1,'2026-02-01 08:17:20',NULL),('2026-01-31 08:17:20','2026-01-31 08:17:20','2026-01-31 08:17:20',1,135,'fdac5361-59a6-4d29-86b8-bd9e0b68b01f',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',-1,'2026-02-01 08:17:20',NULL),('2026-01-31 08:17:20','2026-01-31 08:17:20','2026-01-31 08:17:20',1,136,'08bba3b1-81e1-4160-8a33-3d38822af011',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',-1,'2026-02-01 08:17:20',NULL),('2026-01-31 08:17:24','2026-01-31 08:17:24','2026-01-31 08:17:24',1,137,'45b25eec-58cc-482a-9656-711eb80c5bed',41,'5a6c60c75300483aa07e13b08923b1a1','volumes',-1,'2026-02-01 08:17:23',NULL),('2026-01-31 08:17:24','2026-01-31 08:17:24','2026-01-31 08:17:24',1,138,'346db4cc-8295-49d3-9a2d-ae9d05874a4b',42,'5a6c60c75300483aa07e13b08923b1a1','gigabytes',-1,'2026-02-01 08:17:23',NULL),('2026-01-31 08:17:24','2026-01-31 08:17:24','2026-01-31 08:17:24',1,139,'3f38bf9c-f9a3-42df-9562-2bcd7c776f13',43,'5a6c60c75300483aa07e13b08923b1a1','volumes___DEFAULT__',-1,'2026-02-01 08:17:23',NULL),('2026-01-31 08:17:24','2026-01-31 08:17:24','2026-01-31 08:17:24',1,140,'15774988-18c6-4dd4-8958-61fa3baf25d2',44,'5a6c60c75300483aa07e13b08923b1a1','gigabytes___DEFAULT__',-1,'2026-02-01 08:17:23',NULL),('2026-01-31 08:18:01','2026-01-31 08:18:01','2026-01-31 08:18:01',1,141,'0b08adb1-5ac2-4000-9508-4cd15c93f67b',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',-1,'2026-02-01 08:18:01',NULL),('2026-01-31 08:18:01','2026-01-31 08:18:01','2026-01-31 08:18:01',1,142,'5d85bf78-1a77-4c27-94f2-b9b4bc30b610',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',-1,'2026-02-01 08:18:01',NULL),('2026-01-31 08:18:01','2026-01-31 08:18:01','2026-01-31 08:18:01',1,143,'6c9dab73-f2cc-4499-a69d-02746c4d6897',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',-1,'2026-02-01 08:18:01',NULL),('2026-01-31 08:18:01','2026-01-31 08:18:01','2026-01-31 08:18:01',1,144,'fc56150c-f753-4161-8c5f-1603f87d0210',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:01',NULL),('2026-01-31 08:18:03','2026-01-31 08:18:04','2026-01-31 08:18:04',1,145,'f6efd86c-5b4d-494f-a23b-c011d8df4afc',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',-1,'2026-02-01 08:18:03',NULL),('2026-01-31 08:18:03','2026-01-31 08:18:04','2026-01-31 08:18:04',1,146,'46103908-c217-4729-ab5e-f8fe1149c89b',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',-1,'2026-02-01 08:18:03',NULL),('2026-01-31 08:18:03','2026-01-31 08:18:04','2026-01-31 08:18:04',1,147,'f99abaf2-4c48-431a-925d-8bc192d4a2fd',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',-1,'2026-02-01 08:18:03',NULL),('2026-01-31 08:18:03','2026-01-31 08:18:04','2026-01-31 08:18:04',1,148,'e3c8b859-75cb-4358-b0e4-1648f2b4dc62',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:03',NULL),('2026-01-31 08:18:13','2026-01-31 08:18:13','2026-01-31 08:18:13',1,149,'3bd24ca3-80d7-4381-8509-db00b40ded75',45,'587e3df6fc904afc99c9c6411095e3ef','volumes',-1,'2026-02-01 08:18:13',NULL),('2026-01-31 08:18:13','2026-01-31 08:18:13','2026-01-31 08:18:13',1,150,'8f6b11b4-9d53-4076-8c42-631a3317d374',46,'587e3df6fc904afc99c9c6411095e3ef','gigabytes',-1,'2026-02-01 08:18:13',NULL),('2026-01-31 08:18:13','2026-01-31 08:18:13','2026-01-31 08:18:13',1,151,'4f31b50b-a3c1-422b-ac7b-38813cbc89fa',47,'587e3df6fc904afc99c9c6411095e3ef','volumes___DEFAULT__',-1,'2026-02-01 08:18:13',NULL),('2026-01-31 08:18:13','2026-01-31 08:18:13','2026-01-31 08:18:13',1,152,'5e17f83b-43ca-4d51-8c3e-3005eb8562a7',48,'587e3df6fc904afc99c9c6411095e3ef','gigabytes___DEFAULT__',-1,'2026-02-01 08:18:13',NULL),('2026-01-31 08:20:58','2026-01-31 08:20:58','2026-01-31 08:20:58',1,153,'8c5cb4fd-7272-4a3f-8512-92187a3d3d89',49,'cf024d54545b4af882a87c721105742a','volumes',1,'2026-02-01 08:20:58',NULL),('2026-01-31 08:20:58','2026-01-31 08:20:58','2026-01-31 08:20:58',1,154,'946c5f20-983c-4a51-8d0c-b0ad8dedcb4d',50,'cf024d54545b4af882a87c721105742a','gigabytes',1,'2026-02-01 08:20:58',NULL),('2026-01-31 08:20:58','2026-01-31 08:20:58','2026-01-31 08:20:58',1,155,'75222f0f-25e1-442f-a60e-6c587cb3f3b8',51,'cf024d54545b4af882a87c721105742a','volumes___DEFAULT__',1,'2026-02-01 08:20:58',NULL),('2026-01-31 08:20:58','2026-01-31 08:20:58','2026-01-31 08:20:58',1,156,'60e68dd9-492b-47f0-82d0-29d781184e8d',52,'cf024d54545b4af882a87c721105742a','gigabytes___DEFAULT__',1,'2026-02-01 08:20:58',NULL),('2026-01-31 08:23:42','2026-01-31 08:23:43','2026-01-31 08:23:43',1,157,'9200962b-1884-4aed-a38e-95bc4c653314',49,'cf024d54545b4af882a87c721105742a','volumes',1,'2026-02-01 08:23:42',NULL),('2026-01-31 08:23:42','2026-01-31 08:23:43','2026-01-31 08:23:43',1,158,'a49ebb33-d55c-4240-a004-a635f2eedbfd',50,'cf024d54545b4af882a87c721105742a','gigabytes',1,'2026-02-01 08:23:42',NULL),('2026-01-31 08:23:42','2026-01-31 08:23:43','2026-01-31 08:23:43',1,159,'55574d98-2fca-44ca-9f5f-ca4738f7342b',51,'cf024d54545b4af882a87c721105742a','volumes___DEFAULT__',1,'2026-02-01 08:23:42',NULL),('2026-01-31 08:23:42','2026-01-31 08:23:43','2026-01-31 08:23:43',1,160,'90e54679-9699-4d79-a994-42a1777127c4',52,'cf024d54545b4af882a87c721105742a','gigabytes___DEFAULT__',1,'2026-02-01 08:23:42',NULL),('2026-01-31 08:24:51','2026-01-31 08:24:51','2026-01-31 08:24:51',1,161,'274a9933-37cb-448e-8d8d-11b66770878f',53,'491937de020742d7b4e847dc3bf57950','volumes',1,'2026-02-01 08:24:51',NULL),('2026-01-31 08:24:51','2026-01-31 08:24:51','2026-01-31 08:24:51',1,162,'3ad2a333-d8ea-464b-a520-dae35f40d251',54,'491937de020742d7b4e847dc3bf57950','gigabytes',1,'2026-02-01 08:24:51',NULL),('2026-01-31 08:24:51','2026-01-31 08:24:51','2026-01-31 08:24:51',1,163,'0a5c73f3-4c80-4ba5-927f-b502f08711f0',55,'491937de020742d7b4e847dc3bf57950','volumes___DEFAULT__',1,'2026-02-01 08:24:51',NULL),('2026-01-31 08:24:51','2026-01-31 08:24:51','2026-01-31 08:24:51',1,164,'41d1a0bc-7cd0-4ab3-8a23-b55342367632',56,'491937de020742d7b4e847dc3bf57950','gigabytes___DEFAULT__',1,'2026-02-01 08:24:51',NULL),('2026-01-31 08:28:40','2026-01-31 08:28:40','2026-01-31 08:28:40',1,165,'23ebd699-f2f1-4d86-9de9-2e9f67f6f242',53,'491937de020742d7b4e847dc3bf57950','volumes',1,'2026-02-01 08:28:40',NULL),('2026-01-31 08:28:40','2026-01-31 08:28:40','2026-01-31 08:28:40',1,166,'d4afca8c-0336-49d2-9b86-63351f00e6c0',54,'491937de020742d7b4e847dc3bf57950','gigabytes',1,'2026-02-01 08:28:40',NULL),('2026-01-31 08:28:40','2026-01-31 08:28:40','2026-01-31 08:28:40',1,167,'61c64145-81c4-4876-8b72-3db185f11b6f',55,'491937de020742d7b4e847dc3bf57950','volumes___DEFAULT__',1,'2026-02-01 08:28:40',NULL),('2026-01-31 08:28:40','2026-01-31 08:28:40','2026-01-31 08:28:40',1,168,'566e3311-878b-4729-8f71-45bb95720075',56,'491937de020742d7b4e847dc3bf57950','gigabytes___DEFAULT__',1,'2026-02-01 08:28:40',NULL),('2026-01-31 08:30:55','2026-01-31 08:30:56','2026-01-31 08:30:56',1,169,'55d51a79-7fb0-4fef-9a82-c872226d2d1a',53,'491937de020742d7b4e847dc3bf57950','volumes',-1,'2026-02-01 08:30:55',NULL),('2026-01-31 08:30:56','2026-01-31 08:30:56','2026-01-31 08:30:56',1,170,'65d791e4-0174-4fde-b840-aa607d16c80c',54,'491937de020742d7b4e847dc3bf57950','gigabytes',-1,'2026-02-01 08:30:55',NULL),('2026-01-31 08:30:56','2026-01-31 08:30:56','2026-01-31 08:30:56',1,171,'d8624077-c0d8-4337-bc9a-5b844e1900fb',55,'491937de020742d7b4e847dc3bf57950','volumes___DEFAULT__',-1,'2026-02-01 08:30:55',NULL),('2026-01-31 08:30:56','2026-01-31 08:30:56','2026-01-31 08:30:56',1,172,'1731d280-70bb-4510-b8a5-6f482e68ea74',56,'491937de020742d7b4e847dc3bf57950','gigabytes___DEFAULT__',-1,'2026-02-01 08:30:55',NULL),('2026-01-31 08:30:57','2026-01-31 08:30:57','2026-01-31 08:30:57',1,173,'9053f01f-6dc6-4aff-98f6-4652736acb57',53,'491937de020742d7b4e847dc3bf57950','volumes',-1,'2026-02-01 08:30:57',NULL),('2026-01-31 08:30:57','2026-01-31 08:30:57','2026-01-31 08:30:57',1,174,'7eed9a8b-3dc3-4f0f-8fe8-bbbd513799de',54,'491937de020742d7b4e847dc3bf57950','gigabytes',-1,'2026-02-01 08:30:57',NULL),('2026-01-31 08:30:57','2026-01-31 08:30:57','2026-01-31 08:30:57',1,175,'6df9669a-37d8-4757-81a6-572685e77c52',55,'491937de020742d7b4e847dc3bf57950','volumes___DEFAULT__',-1,'2026-02-01 08:30:57',NULL),('2026-01-31 08:30:57','2026-01-31 08:30:57','2026-01-31 08:30:57',1,176,'1d6c28b7-d16d-4880-88eb-5bb6dc13daca',56,'491937de020742d7b4e847dc3bf57950','gigabytes___DEFAULT__',-1,'2026-02-01 08:30:57',NULL),('2026-01-31 08:31:12','2026-01-31 08:31:12','2026-01-31 08:31:12',1,177,'82771d12-28e4-4efd-a84a-3742fcac6ce0',57,'953a213fa5cb435ab3c04ad96152685f','volumes',1,'2026-02-01 08:31:12',NULL),('2026-01-31 08:31:12','2026-01-31 08:31:12','2026-01-31 08:31:12',1,178,'daf54b58-a49b-4d5b-8228-4de994a4c582',58,'953a213fa5cb435ab3c04ad96152685f','gigabytes',1,'2026-02-01 08:31:12',NULL),('2026-01-31 08:31:12','2026-01-31 08:31:12','2026-01-31 08:31:12',1,179,'26a8e5b7-4849-444c-ab91-d6db5f12b829',59,'953a213fa5cb435ab3c04ad96152685f','volumes___DEFAULT__',1,'2026-02-01 08:31:12',NULL),('2026-01-31 08:31:12','2026-01-31 08:31:12','2026-01-31 08:31:12',1,180,'050cefaf-0017-4cec-9f2f-77b59047f9f5',60,'953a213fa5cb435ab3c04ad96152685f','gigabytes___DEFAULT__',1,'2026-02-01 08:31:12',NULL),('2026-01-31 08:32:24','2026-01-31 08:32:24','2026-01-31 08:32:24',1,181,'b6029505-988e-4562-be8a-6859593ae591',61,'5fe2a450b6ff4f73a7fe8def47304a29','volumes',1,'2026-02-01 08:32:24',NULL),('2026-01-31 08:32:24','2026-01-31 08:32:24','2026-01-31 08:32:24',1,182,'c62c341c-84c5-4b03-875b-c7b7a51e39c2',62,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes',1,'2026-02-01 08:32:24',NULL),('2026-01-31 08:32:24','2026-01-31 08:32:24','2026-01-31 08:32:24',1,183,'a9f19c89-99d5-4a4d-82ac-8e67d53bdd44',63,'5fe2a450b6ff4f73a7fe8def47304a29','volumes_tempest-scenario-type-luks-75396166',1,'2026-02-01 08:32:24',NULL),('2026-01-31 08:32:24','2026-01-31 08:32:24','2026-01-31 08:32:24',1,184,'5d0e2f1d-1206-4341-bd84-6797deda216e',64,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes_tempest-scenario-type-luks-75396166',1,'2026-02-01 08:32:24',NULL),('2026-01-31 08:33:46','2026-01-31 08:33:46','2026-01-31 08:33:46',1,185,'127bf005-bdec-4afc-898c-9632d1c44417',61,'5fe2a450b6ff4f73a7fe8def47304a29','volumes',-1,'2026-02-01 08:33:46',NULL),('2026-01-31 08:33:46','2026-01-31 08:33:46','2026-01-31 08:33:46',1,186,'d0c38db1-5b6e-4741-ba57-a4f1afcf16cc',62,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes',-1,'2026-02-01 08:33:46',NULL),('2026-01-31 08:33:46','2026-01-31 08:33:46','2026-01-31 08:33:46',1,187,'a3a0f037-45f3-471a-ac15-974a17f3db11',63,'5fe2a450b6ff4f73a7fe8def47304a29','volumes_tempest-scenario-type-luks-75396166',-1,'2026-02-01 08:33:46',NULL),('2026-01-31 08:33:46','2026-01-31 08:33:46','2026-01-31 08:33:46',1,188,'50832e6a-765b-4186-a01c-c694fe95fb10',64,'5fe2a450b6ff4f73a7fe8def47304a29','gigabytes_tempest-scenario-type-luks-75396166',-1,'2026-02-01 08:33:46',NULL),('2026-01-31 08:35:31','2026-01-31 08:35:31','2026-01-31 08:35:31',1,189,'902d71f6-20e6-46e5-814f-dc96ee733183',57,'953a213fa5cb435ab3c04ad96152685f','volumes',-1,'2026-02-01 08:35:31',NULL),('2026-01-31 08:35:31','2026-01-31 08:35:31','2026-01-31 08:35:31',1,190,'00cef1ec-8dde-4488-9c5d-916f1868016d',58,'953a213fa5cb435ab3c04ad96152685f','gigabytes',-1,'2026-02-01 08:35:31',NULL),('2026-01-31 08:35:31','2026-01-31 08:35:31','2026-01-31 08:35:31',1,191,'3e6dc0d2-e962-4756-9401-b95a928ba929',59,'953a213fa5cb435ab3c04ad96152685f','volumes___DEFAULT__',-1,'2026-02-01 08:35:31',NULL),('2026-01-31 08:35:31','2026-01-31 08:35:31','2026-01-31 08:35:31',1,192,'e7b73ab6-98b0-4f2d-b985-925815e86527',60,'953a213fa5cb435ab3c04ad96152685f','gigabytes___DEFAULT__',-1,'2026-02-01 08:35:31',NULL),('2026-01-31 08:36:42','2026-01-31 08:36:42','2026-01-31 08:36:42',1,193,'673081e6-07e0-4240-95d8-5353de327b0e',65,'fcc39962194d44e5b37cad3fb1adc6c4','volumes',1,'2026-02-01 08:36:42',NULL),('2026-01-31 08:36:42','2026-01-31 08:36:42','2026-01-31 08:36:42',1,194,'02ed3892-0e85-4b67-b315-dcd7d4d64229',66,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes',1,'2026-02-01 08:36:42',NULL),('2026-01-31 08:36:42','2026-01-31 08:36:42','2026-01-31 08:36:42',1,195,'3d02c620-a133-474b-8707-2c8aec696383',67,'fcc39962194d44e5b37cad3fb1adc6c4','volumes___DEFAULT__',1,'2026-02-01 08:36:42',NULL),('2026-01-31 08:36:42','2026-01-31 08:36:42','2026-01-31 08:36:42',1,196,'fa6c5edf-b7bc-4611-ab2d-4bd25aa4124b',68,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes___DEFAULT__',1,'2026-02-01 08:36:42',NULL),('2026-01-31 08:37:32','2026-01-31 08:37:32','2026-01-31 08:37:32',1,197,'e88edcc1-9199-4d80-bcd2-122fea87b1fc',69,'1e29363ca464487b931af54fe14166b1','volumes',1,'2026-02-01 08:37:31',NULL),('2026-01-31 08:37:32','2026-01-31 08:37:32','2026-01-31 08:37:32',1,198,'d696a791-ad25-4430-bbe8-2ff331f96986',70,'1e29363ca464487b931af54fe14166b1','gigabytes',1,'2026-02-01 08:37:31',NULL),('2026-01-31 08:37:32','2026-01-31 08:37:32','2026-01-31 08:37:32',1,199,'a7807413-420d-4d19-b643-a81c52654860',71,'1e29363ca464487b931af54fe14166b1','volumes___DEFAULT__',1,'2026-02-01 08:37:31',NULL),('2026-01-31 08:37:32','2026-01-31 08:37:32','2026-01-31 08:37:32',1,200,'beeb6534-980b-471a-8065-9af474a7f71a',72,'1e29363ca464487b931af54fe14166b1','gigabytes___DEFAULT__',1,'2026-02-01 08:37:31',NULL),('2026-01-31 08:39:21','2026-01-31 08:39:21','2026-01-31 08:39:21',1,201,'ec0bf45e-65ed-45fb-816b-67b68ec5a75f',65,'fcc39962194d44e5b37cad3fb1adc6c4','volumes',-1,'2026-02-01 08:39:21',NULL),('2026-01-31 08:39:21','2026-01-31 08:39:21','2026-01-31 08:39:21',1,202,'15bc3624-5e04-4ba5-8a90-43283c2b61e3',66,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes',-1,'2026-02-01 08:39:21',NULL),('2026-01-31 08:39:21','2026-01-31 08:39:21','2026-01-31 08:39:21',1,203,'49a8d9f5-b5ed-4d60-a67a-0ecf5bcff035',67,'fcc39962194d44e5b37cad3fb1adc6c4','volumes___DEFAULT__',-1,'2026-02-01 08:39:21',NULL),('2026-01-31 08:39:21','2026-01-31 08:39:21','2026-01-31 08:39:21',1,204,'e0a4d84c-ab73-41e7-a9e5-fdf3a6ae81c1',68,'fcc39962194d44e5b37cad3fb1adc6c4','gigabytes___DEFAULT__',-1,'2026-02-01 08:39:21',NULL),('2026-01-31 08:39:34','2026-01-31 08:39:34','2026-01-31 08:39:34',1,205,'294b4597-8793-4670-8d52-ec64a458cedc',73,'621c17d53cba46d386de8efb560a988e','volumes',1,'2026-02-01 08:39:33',NULL),('2026-01-31 08:39:34','2026-01-31 08:39:34','2026-01-31 08:39:34',1,206,'0945bc91-83c3-4098-8632-b186c08ef53d',74,'621c17d53cba46d386de8efb560a988e','gigabytes',1,'2026-02-01 08:39:33',NULL),('2026-01-31 08:39:34','2026-01-31 08:39:34','2026-01-31 08:39:34',1,207,'d98af57a-72d6-4f77-a783-252ad507b78e',75,'621c17d53cba46d386de8efb560a988e','volumes___DEFAULT__',1,'2026-02-01 08:39:33',NULL),('2026-01-31 08:39:34','2026-01-31 08:39:34','2026-01-31 08:39:34',1,208,'70ddc433-b2dd-42c1-b90d-2afd04c6fce1',76,'621c17d53cba46d386de8efb560a988e','gigabytes___DEFAULT__',1,'2026-02-01 08:39:33',NULL),('2026-01-31 08:39:44','2026-01-31 08:39:44','2026-01-31 08:39:44',1,209,'53484115-2246-4ea7-91c8-d26a5a7fa423',73,'621c17d53cba46d386de8efb560a988e','volumes',1,'2026-02-01 08:39:44',NULL),('2026-01-31 08:39:44','2026-01-31 08:39:44','2026-01-31 08:39:44',1,210,'f91d2515-c342-4744-9f94-c036880d40cc',74,'621c17d53cba46d386de8efb560a988e','gigabytes',1,'2026-02-01 08:39:44',NULL),('2026-01-31 08:39:44','2026-01-31 08:39:44','2026-01-31 08:39:44',1,211,'3616f506-1497-49b4-a130-9403dcd7ec8c',75,'621c17d53cba46d386de8efb560a988e','volumes___DEFAULT__',1,'2026-02-01 08:39:44',NULL),('2026-01-31 08:39:44','2026-01-31 08:39:44','2026-01-31 08:39:44',1,212,'1d4ec173-1d98-4f84-b4a2-f7c69891ec0a',76,'621c17d53cba46d386de8efb560a988e','gigabytes___DEFAULT__',1,'2026-02-01 08:39:44',NULL),('2026-01-31 08:41:06','2026-01-31 08:41:06','2026-01-31 08:41:06',1,213,'1ad6fc3b-9883-4ddd-ab2b-8e458ecafe76',69,'1e29363ca464487b931af54fe14166b1','volumes',-1,'2026-02-01 08:41:06',NULL),('2026-01-31 08:41:06','2026-01-31 08:41:06','2026-01-31 08:41:06',1,214,'27987d26-9a1d-4988-a3ab-4e85d5052fd3',70,'1e29363ca464487b931af54fe14166b1','gigabytes',-1,'2026-02-01 08:41:06',NULL),('2026-01-31 08:41:06','2026-01-31 08:41:06','2026-01-31 08:41:06',1,215,'bf4164dd-886c-433f-97e0-8a8e843537f4',71,'1e29363ca464487b931af54fe14166b1','volumes___DEFAULT__',-1,'2026-02-01 08:41:06',NULL),('2026-01-31 08:41:06','2026-01-31 08:41:06','2026-01-31 08:41:06',1,216,'edf58539-f974-4cdf-9c53-42aada095a28',72,'1e29363ca464487b931af54fe14166b1','gigabytes___DEFAULT__',-1,'2026-02-01 08:41:06',NULL),('2026-01-31 08:44:25','2026-01-31 08:44:25','2026-01-31 08:44:25',1,217,'bbd49c7e-3f6d-4ec0-9406-86f10d487507',73,'621c17d53cba46d386de8efb560a988e','volumes',-1,'2026-02-01 08:44:25',NULL),('2026-01-31 08:44:25','2026-01-31 08:44:25','2026-01-31 08:44:25',1,218,'46ca0314-350b-4a90-b54d-8ed6c8fd427a',74,'621c17d53cba46d386de8efb560a988e','gigabytes',-1,'2026-02-01 08:44:25',NULL),('2026-01-31 08:44:25','2026-01-31 08:44:25','2026-01-31 08:44:25',1,219,'243c2fc9-6175-40e0-900f-37e0dfa19ac4',75,'621c17d53cba46d386de8efb560a988e','volumes___DEFAULT__',-1,'2026-02-01 08:44:25',NULL),('2026-01-31 08:44:25','2026-01-31 08:44:25','2026-01-31 08:44:25',1,220,'bf72d65c-2bfa-4182-b78a-081416ccd23a',76,'621c17d53cba46d386de8efb560a988e','gigabytes___DEFAULT__',-1,'2026-02-01 08:44:25',NULL),('2026-01-31 08:44:31','2026-01-31 08:44:33','2026-01-31 08:44:33',1,221,'a030b907-0a7d-4cce-8b56-c5a9fdd598b6',73,'621c17d53cba46d386de8efb560a988e','volumes',-1,'2026-02-01 08:44:30',NULL),('2026-01-31 08:44:31','2026-01-31 08:44:33','2026-01-31 08:44:33',1,222,'9ed207b6-3aab-47d1-921a-9181717ef281',74,'621c17d53cba46d386de8efb560a988e','gigabytes',-1,'2026-02-01 08:44:30',NULL),('2026-01-31 08:44:31','2026-01-31 08:44:33','2026-01-31 08:44:33',1,223,'f1b7156b-83c8-4e6c-95c5-640f47fa8ace',75,'621c17d53cba46d386de8efb560a988e','volumes___DEFAULT__',-1,'2026-02-01 08:44:30',NULL),('2026-01-31 08:44:31','2026-01-31 08:44:33','2026-01-31 08:44:33',1,224,'c64a17a1-7ec8-4b2d-8d1b-edeeb9be33e0',76,'621c17d53cba46d386de8efb560a988e','gigabytes___DEFAULT__',-1,'2026-02-01 08:44:30',NULL),('2026-01-31 08:45:31','2026-01-31 08:45:32','2026-01-31 08:45:32',1,225,'e430e54a-fa4f-4837-89cd-5644a29d1e73',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',1,'2026-02-01 08:45:31',NULL),('2026-01-31 08:45:31','2026-01-31 08:45:32','2026-01-31 08:45:32',1,226,'8eb4e1e1-0abe-44e9-a986-e74eba08655f',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',1,'2026-02-01 08:45:31',NULL),('2026-01-31 08:45:31','2026-01-31 08:45:32','2026-01-31 08:45:32',1,227,'63df3a54-7e08-4980-9015-5cb362ce030a',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',1,'2026-02-01 08:45:31',NULL),('2026-01-31 08:45:31','2026-01-31 08:45:32','2026-01-31 08:45:32',1,228,'27ca87f8-d494-48bb-9ff0-7430d0089522',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',1,'2026-02-01 08:45:31',NULL),('2026-01-31 08:47:34','2026-01-31 08:47:34','2026-01-31 08:47:34',1,229,'6333519c-2bd1-462c-82bb-761a15bb7a92',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',1,'2026-02-01 08:47:34',NULL),('2026-01-31 08:47:34','2026-01-31 08:47:34','2026-01-31 08:47:34',1,230,'d855074d-2e5c-4683-a9ca-4e1211ac6fd2',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',1,'2026-02-01 08:47:34',NULL),('2026-01-31 08:47:34','2026-01-31 08:47:34','2026-01-31 08:47:34',1,231,'32931bc8-62d8-46e3-923c-9a68ff8e1ba3',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',1,'2026-02-01 08:47:34',NULL),('2026-01-31 08:47:34','2026-01-31 08:47:34','2026-01-31 08:47:34',1,232,'9016f290-43ef-402d-afd4-aa11413114c2',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',1,'2026-02-01 08:47:34',NULL),('2026-01-31 08:48:13','2026-01-31 08:48:13','2026-01-31 08:48:13',1,233,'675f3e6a-90fd-4d32-b0d9-a654f2c4d6ed',81,'bf1c3d387dbe4191b4d05bdfca5959da','volumes',1,'2026-02-01 08:48:13',NULL),('2026-01-31 08:48:13','2026-01-31 08:48:13','2026-01-31 08:48:13',1,234,'7d3513a0-f9ae-4339-ad78-54d2ab425d5b',82,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes',1,'2026-02-01 08:48:13',NULL),('2026-01-31 08:48:13','2026-01-31 08:48:13','2026-01-31 08:48:13',1,235,'a9b16d00-dcff-45db-b4a3-2c7817f69d76',83,'bf1c3d387dbe4191b4d05bdfca5959da','volumes___DEFAULT__',1,'2026-02-01 08:48:13',NULL),('2026-01-31 08:48:13','2026-01-31 08:48:13','2026-01-31 08:48:13',1,236,'95d72a7c-d0cd-415c-8eed-caeea67bf653',84,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes___DEFAULT__',1,'2026-02-01 08:48:13',NULL),('2026-01-31 08:48:57','2026-01-31 08:48:58','2026-01-31 08:48:57',1,237,'6592638e-7e4c-4fa4-8385-7193e099a3da',81,'bf1c3d387dbe4191b4d05bdfca5959da','volumes',1,'2026-02-01 08:48:57',NULL),('2026-01-31 08:48:57','2026-01-31 08:48:58','2026-01-31 08:48:58',1,238,'b9d21d1a-1c42-4bc0-ace3-80464474b7e3',82,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes',1,'2026-02-01 08:48:57',NULL),('2026-01-31 08:48:57','2026-01-31 08:48:58','2026-01-31 08:48:58',1,239,'a8472bc9-de27-4fe5-bf23-b8fc031608ca',83,'bf1c3d387dbe4191b4d05bdfca5959da','volumes___DEFAULT__',1,'2026-02-01 08:48:57',NULL),('2026-01-31 08:48:57','2026-01-31 08:48:58','2026-01-31 08:48:58',1,240,'21be87b9-bb40-441c-a14a-0b15e919d99e',84,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes___DEFAULT__',1,'2026-02-01 08:48:57',NULL),('2026-01-31 08:49:11','2026-01-31 08:49:11','2026-01-31 08:49:11',1,241,'1b0808e5-41e0-40e2-9d4c-a31bf1ae341c',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',1,'2026-02-01 08:49:11',NULL),('2026-01-31 08:49:11','2026-01-31 08:49:11','2026-01-31 08:49:11',1,242,'38172a64-980f-4fec-b468-a1306f355535',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',1,'2026-02-01 08:49:11',NULL),('2026-01-31 08:49:11','2026-01-31 08:49:11','2026-01-31 08:49:11',1,243,'ae6fc31b-da38-4a99-8088-d1ec9791b921',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',1,'2026-02-01 08:49:11',NULL),('2026-01-31 08:49:11','2026-01-31 08:49:11','2026-01-31 08:49:11',1,244,'97122738-d112-49ca-9c94-04a80fb8ef78',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',1,'2026-02-01 08:49:11',NULL),('2026-01-31 08:49:18','2026-01-31 08:49:19','2026-01-31 08:49:19',1,245,'c5ebd503-3ee4-4d6e-bda9-4ee1f847ca35',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',1,'2026-02-01 08:49:18',NULL),('2026-01-31 08:49:18','2026-01-31 08:49:19','2026-01-31 08:49:19',1,246,'90a65b79-4dff-49ab-8309-656a9a90bf9a',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',1,'2026-02-01 08:49:18',NULL),('2026-01-31 08:49:18','2026-01-31 08:49:19','2026-01-31 08:49:19',1,247,'53f90837-043b-4fd4-a643-27098eb72da3',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',1,'2026-02-01 08:49:18',NULL),('2026-01-31 08:49:18','2026-01-31 08:49:19','2026-01-31 08:49:19',1,248,'2026b13a-6d72-4508-8c3b-e43d7b2638ef',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',1,'2026-02-01 08:49:18',NULL),('2026-01-31 08:51:16','2026-01-31 08:51:16','2026-01-31 08:51:16',1,249,'1462b414-22bd-4cf4-beda-0c3dd2ad1e1c',81,'bf1c3d387dbe4191b4d05bdfca5959da','volumes',-1,'2026-02-01 08:51:16',NULL),('2026-01-31 08:51:16','2026-01-31 08:51:16','2026-01-31 08:51:16',1,250,'6f211dcb-d620-48e8-bb75-6aef3f0c4c37',82,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes',-1,'2026-02-01 08:51:16',NULL),('2026-01-31 08:51:16','2026-01-31 08:51:16','2026-01-31 08:51:16',1,251,'521285b2-74a8-4e98-a128-c0b9dca0b096',83,'bf1c3d387dbe4191b4d05bdfca5959da','volumes___DEFAULT__',-1,'2026-02-01 08:51:16',NULL),('2026-01-31 08:51:16','2026-01-31 08:51:16','2026-01-31 08:51:16',1,252,'c8f0731e-551c-4c22-b006-d91100f968af',84,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes___DEFAULT__',-1,'2026-02-01 08:51:16',NULL),('2026-01-31 08:51:20','2026-01-31 08:51:20','2026-01-31 08:51:20',1,253,'19c56e83-ae57-4684-bf03-509359fa7dae',81,'bf1c3d387dbe4191b4d05bdfca5959da','volumes',-1,'2026-02-01 08:51:20',NULL),('2026-01-31 08:51:20','2026-01-31 08:51:20','2026-01-31 08:51:20',1,254,'12263adf-31df-4741-8883-656caf28b16b',82,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes',-1,'2026-02-01 08:51:20',NULL),('2026-01-31 08:51:20','2026-01-31 08:51:20','2026-01-31 08:51:20',1,255,'9b269a0a-1b1a-4c13-bbbe-285958e0bf86',83,'bf1c3d387dbe4191b4d05bdfca5959da','volumes___DEFAULT__',-1,'2026-02-01 08:51:20',NULL),('2026-01-31 08:51:20','2026-01-31 08:51:20','2026-01-31 08:51:20',1,256,'d69b3eee-dd8d-44f2-ba2c-3ab43dbc58a7',84,'bf1c3d387dbe4191b4d05bdfca5959da','gigabytes___DEFAULT__',-1,'2026-02-01 08:51:20',NULL),('2026-01-31 08:51:31','2026-01-31 08:51:31','2026-01-31 08:51:31',1,257,'5fbf9e30-1fae-461b-833d-70c62d94c8f0',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',1,'2026-02-01 08:51:31',NULL),('2026-01-31 08:51:31','2026-01-31 08:51:31','2026-01-31 08:51:31',1,258,'2b9307a4-2cb2-443c-ac99-2ac292dc1b60',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',1,'2026-02-01 08:51:31',NULL),('2026-01-31 08:51:31','2026-01-31 08:51:31','2026-01-31 08:51:31',1,259,'7d8bb65c-b9c2-46c9-afe6-10a3dfb36167',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',1,'2026-02-01 08:51:31',NULL),('2026-01-31 08:51:31','2026-01-31 08:51:31','2026-01-31 08:51:31',1,260,'83ddb06e-ef1e-41d6-ac75-a11c0159501d',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',1,'2026-02-01 08:51:31',NULL),('2026-01-31 08:51:33','2026-01-31 08:51:33','2026-01-31 08:51:33',1,261,'d85fc1be-11a4-4cee-b4f7-f14f241949ab',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',1,'2026-02-01 08:51:33',NULL),('2026-01-31 08:51:33','2026-01-31 08:51:33','2026-01-31 08:51:33',1,262,'4ace28c4-8f9a-4df6-bb0d-6966e63af26e',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',1,'2026-02-01 08:51:33',NULL),('2026-01-31 08:51:33','2026-01-31 08:51:33','2026-01-31 08:51:33',1,263,'a36618ec-a76d-4895-8e97-f93ad162eb31',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',1,'2026-02-01 08:51:33',NULL),('2026-01-31 08:51:33','2026-01-31 08:51:33','2026-01-31 08:51:33',1,264,'76cda5b4-0fd4-444a-aa18-fe596f122985',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',1,'2026-02-01 08:51:33',NULL),('2026-01-31 08:52:04','2026-01-31 08:52:04','2026-01-31 08:52:04',1,265,'f45d15ab-996d-48e1-9aa2-109eb74460cc',89,'8397e0fed04b4dabb57148d0924de2dc','snapshots',1,'2026-02-01 08:52:04',NULL),('2026-01-31 08:52:04','2026-01-31 08:52:04','2026-01-31 08:52:04',1,266,'e505a214-a94b-47d2-abec-5bd25d743f36',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',1,'2026-02-01 08:52:04',NULL),('2026-01-31 08:52:04','2026-01-31 08:52:04','2026-01-31 08:52:04',1,267,'0d502453-07ad-4137-94c1-b63fd3ac75d8',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',1,'2026-02-01 08:52:04',NULL),('2026-01-31 08:52:04','2026-01-31 08:52:04','2026-01-31 08:52:04',1,268,'2552ba53-4924-48e4-81eb-e97d5bf9e533',90,'8397e0fed04b4dabb57148d0924de2dc','snapshots_multiattach',1,'2026-02-01 08:52:04',NULL),('2026-01-31 08:52:16','2026-01-31 08:52:16','2026-01-31 08:52:16',1,269,'18d2cc01-d334-4c60-bb84-9aed4d5af971',89,'8397e0fed04b4dabb57148d0924de2dc','snapshots',-1,'2026-02-01 08:52:16',NULL),('2026-01-31 08:52:16','2026-01-31 08:52:16','2026-01-31 08:52:16',1,270,'5c0072d3-946d-4d0e-91aa-8471f4f525ac',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',-1,'2026-02-01 08:52:16',NULL),('2026-01-31 08:52:16','2026-01-31 08:52:16','2026-01-31 08:52:16',1,271,'27798744-3a69-46ea-ae92-6d73228882dd',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',-1,'2026-02-01 08:52:16',NULL),('2026-01-31 08:52:16','2026-01-31 08:52:16','2026-01-31 08:52:16',1,272,'d9e4d02b-ad03-4f02-bb73-0e01746b5267',90,'8397e0fed04b4dabb57148d0924de2dc','snapshots_multiattach',-1,'2026-02-01 08:52:16',NULL),('2026-01-31 08:52:17','2026-01-31 08:52:17','2026-01-31 08:52:17',1,273,'2ddde4aa-8691-4269-8250-f0d662ef9cbe',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',-1,'2026-02-01 08:52:17',NULL),('2026-01-31 08:52:17','2026-01-31 08:52:17','2026-01-31 08:52:17',1,274,'c0361270-adf1-4781-9b2f-e835eef5a9a4',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',-1,'2026-02-01 08:52:17',NULL),('2026-01-31 08:52:17','2026-01-31 08:52:17','2026-01-31 08:52:17',1,275,'f0e1dd67-2c42-4c39-a19f-4f94c54ad8f8',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',-1,'2026-02-01 08:52:17',NULL),('2026-01-31 08:52:17','2026-01-31 08:52:17','2026-01-31 08:52:17',1,276,'03af7d8b-5a2b-4523-88e4-58dd6e202b70',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',-1,'2026-02-01 08:52:17',NULL),('2026-01-31 08:52:23','2026-01-31 08:52:23','2026-01-31 08:52:23',1,277,'febeba69-3d72-4958-b333-5ec396e51cdc',91,'7c88afe842cd47dea75807eea90f5e58','volumes',1,'2026-02-01 08:52:23',NULL),('2026-01-31 08:52:23','2026-01-31 08:52:23','2026-01-31 08:52:23',1,278,'d9e98630-6164-4a7c-b1ef-03e90b5cd4a7',92,'7c88afe842cd47dea75807eea90f5e58','gigabytes',1,'2026-02-01 08:52:23',NULL),('2026-01-31 08:52:23','2026-01-31 08:52:23','2026-01-31 08:52:23',1,279,'ad19020c-3ca1-478d-b3cd-498180544131',93,'7c88afe842cd47dea75807eea90f5e58','volumes___DEFAULT__',1,'2026-02-01 08:52:23',NULL),('2026-01-31 08:52:23','2026-01-31 08:52:23','2026-01-31 08:52:23',1,280,'cad0351a-c1d8-4c1a-b5a7-1c5005067a58',94,'7c88afe842cd47dea75807eea90f5e58','gigabytes___DEFAULT__',1,'2026-02-01 08:52:23',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:28','2026-01-31 08:52:28',1,281,'bd0d0444-9120-4ed2-8726-48f8bbc45257',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:28','2026-01-31 08:52:28',1,282,'4e0af93d-594b-4fb3-a145-d7a6b7bae44f',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:28','2026-01-31 08:52:28',1,283,'cc8c63c2-49cc-4400-b404-701b15a93f60',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:28','2026-01-31 08:52:28',1,284,'7d72fb3e-54b0-41e8-9e75-108b92fa13d9',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:29','2026-01-31 08:52:29',1,285,'11862ea1-b0cd-4770-9304-faa882cdc594',91,'7c88afe842cd47dea75807eea90f5e58','volumes',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:29','2026-01-31 08:52:29',1,286,'345b7710-c5de-46b8-a4f1-14a377a0ca71',92,'7c88afe842cd47dea75807eea90f5e58','gigabytes',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:29','2026-01-31 08:52:29',1,287,'084e8e38-b9f0-4e17-ae39-52b7ddecc8f3',93,'7c88afe842cd47dea75807eea90f5e58','volumes___DEFAULT__',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:28','2026-01-31 08:52:29','2026-01-31 08:52:29',1,288,'2c65afd3-3a13-4029-bd0f-72858d53d98b',94,'7c88afe842cd47dea75807eea90f5e58','gigabytes___DEFAULT__',-1,'2026-02-01 08:52:28',NULL),('2026-01-31 08:52:30','2026-01-31 08:52:30','2026-01-31 08:52:30',1,289,'d6cead2b-c0df-4fab-af32-49f141e3cdf1',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',1,'2026-02-01 08:52:30',NULL),('2026-01-31 08:52:30','2026-01-31 08:52:30','2026-01-31 08:52:30',1,290,'0f5943cb-b4c2-413c-8696-10b8735b79c4',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',1,'2026-02-01 08:52:30',NULL),('2026-01-31 08:52:30','2026-01-31 08:52:30','2026-01-31 08:52:30',1,291,'06591616-f210-46da-88ef-cb815e950f93',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',1,'2026-02-01 08:52:30',NULL),('2026-01-31 08:52:30','2026-01-31 08:52:30','2026-01-31 08:52:30',1,292,'f554a983-e858-48dd-883c-508a768e8ec3',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',1,'2026-02-01 08:52:30',NULL),('2026-01-31 08:52:43','2026-01-31 08:52:43','2026-01-31 08:52:43',1,293,'cef8966f-4d15-4cdf-8513-f04e547a403d',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',-1,'2026-02-01 08:52:43',NULL),('2026-01-31 08:52:43','2026-01-31 08:52:43','2026-01-31 08:52:43',1,294,'03a7e696-5442-4227-995d-2c3250e4c4df',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',-1,'2026-02-01 08:52:43',NULL),('2026-01-31 08:52:43','2026-01-31 08:52:43','2026-01-31 08:52:43',1,295,'d31d6dfc-6a4a-472a-94ff-99265b5ae099',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',-1,'2026-02-01 08:52:43',NULL),('2026-01-31 08:52:43','2026-01-31 08:52:43','2026-01-31 08:52:43',1,296,'62bf98d8-0b64-4a3c-a3bf-abd7df6c2684',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',-1,'2026-02-01 08:52:43',NULL),('2026-01-31 08:52:51','2026-01-31 08:52:52','2026-01-31 08:52:52',1,297,'9798a28e-d111-4339-b20b-b8f1cd46a609',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',-1,'2026-02-01 08:52:51',NULL),('2026-01-31 08:52:51','2026-01-31 08:52:52','2026-01-31 08:52:52',1,298,'c8b85e4c-937b-4851-9f19-96f7e3e1ab45',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',-1,'2026-02-01 08:52:51',NULL),('2026-01-31 08:52:51','2026-01-31 08:52:52','2026-01-31 08:52:52',1,299,'683dfe2a-8402-4954-8c27-a8b7a997f33d',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',-1,'2026-02-01 08:52:51',NULL),('2026-01-31 08:52:51','2026-01-31 08:52:52','2026-01-31 08:52:52',1,300,'54589868-f270-475f-b56b-66489df2104d',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',-1,'2026-02-01 08:52:51',NULL),('2026-01-31 08:52:55','2026-01-31 08:52:55','2026-01-31 08:52:55',1,301,'bbf341ea-1f6c-4b6e-a0d9-576b3a2c5d27',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',-1,'2026-02-01 08:52:55',NULL),('2026-01-31 08:52:55','2026-01-31 08:52:55','2026-01-31 08:52:55',1,302,'b1690b1c-ee04-4577-834a-6162f0b1949c',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',-1,'2026-02-01 08:52:55',NULL),('2026-01-31 08:52:55','2026-01-31 08:52:55','2026-01-31 08:52:55',1,303,'df816dfc-bb82-4cbe-8fe3-fb9c6d686aef',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',-1,'2026-02-01 08:52:55',NULL),('2026-01-31 08:52:55','2026-01-31 08:52:55','2026-01-31 08:52:55',1,304,'b243ae1d-05f6-4efd-a4cf-127a34121ac8',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',-1,'2026-02-01 08:52:55',NULL),('2026-01-31 08:53:01','2026-01-31 08:53:02','2026-01-31 08:53:02',1,305,'20fee629-c755-46be-8e5f-c0a9c5511fc2',85,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes',-1,'2026-02-01 08:53:01',NULL),('2026-01-31 08:53:01','2026-01-31 08:53:02','2026-01-31 08:53:02',1,306,'915bdbb0-f1a0-462e-86df-796753af04d2',86,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes',-1,'2026-02-01 08:53:01',NULL),('2026-01-31 08:53:01','2026-01-31 08:53:02','2026-01-31 08:53:02',1,307,'1a493de7-48fb-4514-8351-b229b4548b3d',87,'76fb5cb7abcd4d74abfc471a96bbd12c','volumes___DEFAULT__',-1,'2026-02-01 08:53:01',NULL),('2026-01-31 08:53:01','2026-01-31 08:53:02','2026-01-31 08:53:02',1,308,'8bb53b06-8d35-455a-8fe1-08abb11da80b',88,'76fb5cb7abcd4d74abfc471a96bbd12c','gigabytes___DEFAULT__',-1,'2026-02-01 08:53:01',NULL),('2026-01-31 08:53:14','2026-01-31 08:53:14','2026-01-31 08:53:14',1,309,'74551d8c-0fc5-4e2b-984c-ab6297fef465',77,'8397e0fed04b4dabb57148d0924de2dc','volumes',-1,'2026-02-01 08:53:14',NULL),('2026-01-31 08:53:14','2026-01-31 08:53:14','2026-01-31 08:53:14',1,310,'390967d7-2798-470c-98d4-af340cab697a',78,'8397e0fed04b4dabb57148d0924de2dc','gigabytes',-1,'2026-02-01 08:53:14',NULL),('2026-01-31 08:53:14','2026-01-31 08:53:14','2026-01-31 08:53:14',1,311,'5cc6ca1e-ea5a-47bb-b87f-b221e6fbf133',79,'8397e0fed04b4dabb57148d0924de2dc','volumes_multiattach',-1,'2026-02-01 08:53:14',NULL),('2026-01-31 08:53:14','2026-01-31 08:53:14','2026-01-31 08:53:14',1,312,'cd95a4aa-069f-4632-bb80-c9588c45f554',80,'8397e0fed04b4dabb57148d0924de2dc','gigabytes_multiattach',-1,'2026-02-01 08:53:14',NULL),('2026-01-31 08:53:20','2026-01-31 08:53:21','2026-01-31 08:53:21',1,313,'041dd490-5cc6-4384-8474-332d0e766b46',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',1,'2026-02-01 08:53:20',NULL),('2026-01-31 08:53:20','2026-01-31 08:53:21','2026-01-31 08:53:21',1,314,'1c21808f-a258-4ff8-ad56-bccdfad14de7',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',1,'2026-02-01 08:53:20',NULL),('2026-01-31 08:53:20','2026-01-31 08:53:21','2026-01-31 08:53:21',1,315,'6e67ca43-b9c8-4fe3-9aba-a2702e25605c',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',1,'2026-02-01 08:53:20',NULL),('2026-01-31 08:53:20','2026-01-31 08:53:21','2026-01-31 08:53:21',1,316,'bf54be14-8e58-4461-a67c-d0dacf6863f6',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',1,'2026-02-01 08:53:20',NULL),('2026-01-31 08:53:26','2026-01-31 08:53:26','2026-01-31 08:53:26',1,317,'d838972a-95ef-4c9e-90ee-8f965fb68d0c',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',1,'2026-02-01 08:53:26',NULL),('2026-01-31 08:53:26','2026-01-31 08:53:26','2026-01-31 08:53:26',1,318,'f10e1bd0-b3fa-4627-b01b-079a566a8210',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',1,'2026-02-01 08:53:26',NULL),('2026-01-31 08:53:26','2026-01-31 08:53:26','2026-01-31 08:53:26',1,319,'3306180e-d841-4566-8980-4b6563b699f8',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',1,'2026-02-01 08:53:26',NULL),('2026-01-31 08:53:26','2026-01-31 08:53:26','2026-01-31 08:53:26',1,320,'130e912d-eb3d-446a-a349-8053dae2fa40',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',1,'2026-02-01 08:53:26',NULL),('2026-01-31 08:53:29','2026-01-31 08:53:29','2026-01-31 08:53:29',1,321,'9df2074c-5e2d-49d6-af65-acd08566e2c2',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',1,'2026-02-01 08:53:29',NULL),('2026-01-31 08:53:29','2026-01-31 08:53:29','2026-01-31 08:53:29',1,322,'a2d25589-ed45-47bd-846d-acbcf59f58d2',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',1,'2026-02-01 08:53:29',NULL),('2026-01-31 08:53:29','2026-01-31 08:53:29','2026-01-31 08:53:29',1,323,'a4663672-cf0f-41be-8c2e-03cd4a022cab',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',1,'2026-02-01 08:53:29',NULL),('2026-01-31 08:53:29','2026-01-31 08:53:29','2026-01-31 08:53:29',1,324,'801ba163-1bd3-4d88-8b11-a287f18d2a29',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',1,'2026-02-01 08:53:29',NULL),('2026-01-31 08:53:38','2026-01-31 08:53:38','2026-01-31 08:53:38',1,325,'3cfa485c-fbb7-469c-adfe-dab3b7dd14b0',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',-1,'2026-02-01 08:53:38',NULL),('2026-01-31 08:53:38','2026-01-31 08:53:38','2026-01-31 08:53:38',1,326,'0a30bb27-7a8f-4f7f-97f5-dd5467217745',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',-1,'2026-02-01 08:53:38',NULL),('2026-01-31 08:53:38','2026-01-31 08:53:38','2026-01-31 08:53:38',1,327,'f051660c-67b4-4e07-8261-d4db21d86114',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',-1,'2026-02-01 08:53:38',NULL),('2026-01-31 08:53:38','2026-01-31 08:53:38','2026-01-31 08:53:38',1,328,'2cff04c1-6e01-4170-8739-20d63d42b7b2',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',-1,'2026-02-01 08:53:38',NULL),('2026-01-31 08:53:40','2026-01-31 08:53:40','2026-01-31 08:53:40',1,329,'aed1520d-73a2-483e-bd58-ba019de0f79a',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',-1,'2026-02-01 08:53:40',NULL),('2026-01-31 08:53:40','2026-01-31 08:53:40','2026-01-31 08:53:40',1,330,'3893666f-3cf0-42d5-8025-6c94a9e6471d',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',-1,'2026-02-01 08:53:40',NULL),('2026-01-31 08:53:40','2026-01-31 08:53:40','2026-01-31 08:53:40',1,331,'0103ba6f-d6b7-461b-9dbe-87cc52d9d207',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',-1,'2026-02-01 08:53:40',NULL),('2026-01-31 08:53:40','2026-01-31 08:53:40','2026-01-31 08:53:40',1,332,'36916812-3328-468f-84e8-31ab9f62b3fe',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',-1,'2026-02-01 08:53:40',NULL),('2026-01-31 08:53:42','2026-01-31 08:53:42','2026-01-31 08:53:42',1,333,'9ac579e6-7206-4e2d-b632-641df2c31396',95,'c88376bcb43e42cf9894ecb9352e5822','volumes',-1,'2026-02-01 08:53:42',NULL),('2026-01-31 08:53:42','2026-01-31 08:53:42','2026-01-31 08:53:42',1,334,'c2c0122d-a06f-47d9-a75b-d37f7a324ac9',96,'c88376bcb43e42cf9894ecb9352e5822','gigabytes',-1,'2026-02-01 08:53:42',NULL),('2026-01-31 08:53:42','2026-01-31 08:53:42','2026-01-31 08:53:42',1,335,'3a54ffde-4f0e-49e0-914b-499f4099d155',97,'c88376bcb43e42cf9894ecb9352e5822','volumes___DEFAULT__',-1,'2026-02-01 08:53:42',NULL),('2026-01-31 08:53:42','2026-01-31 08:53:42','2026-01-31 08:53:42',1,336,'49d8f093-8dd1-47ac-aee1-80a35a7886b0',98,'c88376bcb43e42cf9894ecb9352e5822','gigabytes___DEFAULT__',-1,'2026-02-01 08:53:42',NULL),('2026-01-31 08:54:57','2026-01-31 08:54:58','2026-01-31 08:54:58',1,337,'2bc18b8d-8179-4d05-bf98-8fe887ad32a5',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:54:57',NULL),('2026-01-31 08:54:57','2026-01-31 08:54:58','2026-01-31 08:54:58',1,338,'ff95ddff-8c80-455f-80d1-29b5ab8ba4bd',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:54:57',NULL),('2026-01-31 08:54:57','2026-01-31 08:54:58','2026-01-31 08:54:58',1,339,'a00c6090-48d3-489f-94e6-36a0153d00e1',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:54:57',NULL),('2026-01-31 08:54:57','2026-01-31 08:54:58','2026-01-31 08:54:58',1,340,'a1f66fd7-2472-47c7-9e5f-637f2e9b315c',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:54:57',NULL),('2026-01-31 08:54:58','2026-01-31 08:54:58','2026-01-31 08:54:58',1,341,'c578d5a8-a46e-46d9-8359-994ed66dea1d',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:54:58',NULL),('2026-01-31 08:54:58','2026-01-31 08:54:58','2026-01-31 08:54:58',1,342,'b18d1a53-d9ff-46e7-adf8-d028fa052725',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:54:58',NULL),('2026-01-31 08:54:58','2026-01-31 08:54:58','2026-01-31 08:54:58',1,343,'cd45bca6-5ae6-4c1c-9bde-59f33fe1edc5',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:54:58',NULL),('2026-01-31 08:54:58','2026-01-31 08:54:58','2026-01-31 08:54:58',1,344,'9571cb19-3eaa-4456-ad83-950a58a08e87',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:54:58',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,345,'a3ada8a0-d8e4-42d7-8140-db2ee1beafdf',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,346,'d2343ce9-1758-4969-9d34-47fd028ee59f',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,347,'7b2692eb-a4f6-472d-bd8f-0461e8079f4f',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,348,'d7769827-03ce-47e6-af44-21a42e8672fa',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,349,'d8bcc74b-9e86-4978-944a-f1557a8a0c5c',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,350,'867f48e3-51f2-4d87-98c6-51a6fe405341',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,351,'199191ae-28e2-4120-a341-e933ef5700ad',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:54:59','2026-01-31 08:54:59','2026-01-31 08:54:59',1,352,'296f65bb-b808-4d82-8c53-f54f6d4b0c29',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:54:59',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:00','2026-01-31 08:55:00',1,353,'77b7461c-c716-41be-a190-dbd94a6cf4e5',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:00','2026-01-31 08:55:00',1,354,'f89a320c-0ee5-4493-a1a6-580e5155f5ff',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:00','2026-01-31 08:55:00',1,355,'17e05933-a77b-4981-ba76-f6ed26b61280',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:00','2026-01-31 08:55:00',1,356,'05801462-62e9-4e35-8339-56dfaef91a3d',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:55:01',1,357,'4e9b000b-5277-4326-939d-b05c8faaee10',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:55:01',1,358,'39eff26a-23e7-40b1-b0dd-f4d0a897b370',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:55:01',1,359,'ed275b5e-4dcc-4494-8965-923bea323c5c',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:55:01',1,360,'efb4e488-f92e-469c-9cbb-a1062dd63e26',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',1,'2026-02-01 08:55:00',NULL),('2026-01-31 08:55:01','2026-01-31 08:55:01','2026-01-31 08:55:01',1,361,'85068983-1ba9-4d84-9235-563b1d8a1e7e',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',1,'2026-02-01 08:55:01',NULL),('2026-01-31 08:55:01','2026-01-31 08:55:01','2026-01-31 08:55:01',1,362,'e44870da-e67d-4f9f-853e-e597bfe5e82e',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',1,'2026-02-01 08:55:01',NULL),('2026-01-31 08:55:01','2026-01-31 08:55:01','2026-01-31 08:55:01',1,363,'fc6905fc-666b-4f65-8adb-56244dd6aef5',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',1,'2026-02-01 08:55:01',NULL),('2026-01-31 08:55:01','2026-01-31 08:55:01','2026-01-31 08:55:01',1,364,'51274a7e-9b44-4ec8-8fd4-0b59aed8e9ef',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',1,'2026-02-01 08:55:01',NULL),('2026-01-31 08:55:05','2026-01-31 08:55:05','2026-01-31 08:55:05',1,365,'7f6984f6-b65f-4c39-8a18-64e111a67337',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:55:05',NULL),('2026-01-31 08:55:05','2026-01-31 08:55:05','2026-01-31 08:55:05',1,366,'dc260434-45a1-46fe-9150-bf11a1975173',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:55:05',NULL),('2026-01-31 08:55:05','2026-01-31 08:55:05','2026-01-31 08:55:05',1,367,'bbae00b2-99ac-4e14-a832-a0753dce5db7',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:05',NULL),('2026-01-31 08:55:05','2026-01-31 08:55:05','2026-01-31 08:55:05',1,368,'b4a54f8b-1051-43be-a58a-2727d7a4de36',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:05',NULL),('2026-01-31 08:55:09','2026-01-31 08:55:09','2026-01-31 08:55:09',1,369,'8abc2e4e-1841-42a1-8f40-2a62bf681c1c',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:55:09',NULL),('2026-01-31 08:55:09','2026-01-31 08:55:09','2026-01-31 08:55:09',1,370,'b2033efb-6e72-4f1d-9809-fb8969aa553b',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:55:09',NULL),('2026-01-31 08:55:09','2026-01-31 08:55:09','2026-01-31 08:55:09',1,371,'8a958367-5992-4f68-9c1d-8d918a8f9bbe',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:09',NULL),('2026-01-31 08:55:09','2026-01-31 08:55:09','2026-01-31 08:55:09',1,372,'200c7766-ec9b-4ebf-9894-aa9ba939f89e',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:09',NULL),('2026-01-31 08:55:14','2026-01-31 08:55:14','2026-01-31 08:55:14',1,373,'46bed90f-40f5-4da1-8a24-efe2363300b0',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',1,'2026-02-01 08:55:14',NULL),('2026-01-31 08:55:14','2026-01-31 08:55:14','2026-01-31 08:55:14',1,374,'a6d8ceea-a8b7-4305-8616-b00fa987feb7',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',1,'2026-02-01 08:55:14',NULL),('2026-01-31 08:55:14','2026-01-31 08:55:14','2026-01-31 08:55:14',1,375,'c0b96eb4-3af1-4c09-b0f8-39e23e4bd6c5',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:14',NULL),('2026-01-31 08:55:14','2026-01-31 08:55:14','2026-01-31 08:55:14',1,376,'ffed6c28-5dae-4a59-bac8-f2e464992336',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',1,'2026-02-01 08:55:14',NULL),('2026-01-31 08:56:18','2026-01-31 08:56:18','2026-01-31 08:56:18',1,377,'7a5a7950-7fe6-4017-ac0b-58014b680d2e',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:56:18',NULL),('2026-01-31 08:56:18','2026-01-31 08:56:18','2026-01-31 08:56:18',1,378,'c12aff6c-029e-40d2-8c15-4a4c2a6de108',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:56:18',NULL),('2026-01-31 08:56:18','2026-01-31 08:56:18','2026-01-31 08:56:18',1,379,'b00029ea-13bb-4700-a6d2-b0d85c8a5ffe',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:56:18',NULL),('2026-01-31 08:56:18','2026-01-31 08:56:18','2026-01-31 08:56:18',1,380,'a6393805-1c19-4133-b62a-30c9a8c40b58',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:56:18',NULL),('2026-01-31 08:56:23','2026-01-31 08:56:24','2026-01-31 08:56:24',1,381,'37a96543-4421-44dd-973c-97fb502bf0d5',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:56:23',NULL),('2026-01-31 08:56:23','2026-01-31 08:56:24','2026-01-31 08:56:24',1,382,'7df69188-aaea-4682-87ba-d1779599c216',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:56:23',NULL),('2026-01-31 08:56:23','2026-01-31 08:56:24','2026-01-31 08:56:24',1,383,'4f995d31-a421-4d38-b3aa-b2dc723a9560',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:56:23',NULL),('2026-01-31 08:56:23','2026-01-31 08:56:24','2026-01-31 08:56:24',1,384,'588b53be-4916-4d1d-b50c-658bf042901d',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:56:23',NULL),('2026-01-31 08:57:09','2026-01-31 08:57:10','2026-01-31 08:57:10',1,385,'22699cb2-fdb2-42c6-94b8-962a1d819fe0',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:57:09',NULL),('2026-01-31 08:57:09','2026-01-31 08:57:10','2026-01-31 08:57:10',1,386,'9e09b8f2-fa51-4734-89aa-1435029e41dd',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:57:09',NULL),('2026-01-31 08:57:09','2026-01-31 08:57:10','2026-01-31 08:57:10',1,387,'5a4e8a8c-0801-412e-ba92-8b9a1b5e6605',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:57:09',NULL),('2026-01-31 08:57:09','2026-01-31 08:57:10','2026-01-31 08:57:10',1,388,'d05fe946-1441-4ea8-afc1-d4332fadbdfb',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:57:09',NULL),('2026-01-31 08:57:13','2026-01-31 08:57:13','2026-01-31 08:57:13',1,389,'3ecde403-7a7a-4cd2-aceb-c433958acb25',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:57:13',NULL),('2026-01-31 08:57:13','2026-01-31 08:57:13','2026-01-31 08:57:13',1,390,'51f09c9b-d434-43e1-af4a-ac2f95d93a66',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:57:13',NULL),('2026-01-31 08:57:13','2026-01-31 08:57:13','2026-01-31 08:57:13',1,391,'5ccfa9f0-bb59-4c07-95b3-93998aa47aaa',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:57:13',NULL),('2026-01-31 08:57:13','2026-01-31 08:57:13','2026-01-31 08:57:13',1,392,'fbfbc7f1-abbc-4d3d-bf4f-01c228580c04',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:57:13',NULL),('2026-01-31 08:57:17','2026-01-31 08:57:17','2026-01-31 08:57:17',1,393,'00baf27c-d4b7-4b49-8b1b-178f83f6a2d3',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',1,'2026-02-01 08:57:17',NULL),('2026-01-31 08:57:17','2026-01-31 08:57:17','2026-01-31 08:57:17',1,394,'64ff023f-5932-4681-adb1-65cfe5b1a837',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',1,'2026-02-01 08:57:17',NULL),('2026-01-31 08:57:17','2026-01-31 08:57:17','2026-01-31 08:57:17',1,395,'efc81f87-d854-4d4c-b47b-5c06edff2d7a',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',1,'2026-02-01 08:57:17',NULL),('2026-01-31 08:57:17','2026-01-31 08:57:17','2026-01-31 08:57:17',1,396,'3ea32134-ce91-4065-af40-cd667fc7f25c',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',1,'2026-02-01 08:57:17',NULL),('2026-01-31 08:57:23','2026-01-31 08:57:23','2026-01-31 08:57:23',1,397,'f3148231-3af5-408a-81b6-bc8851bc24c6',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',1,'2026-02-01 08:57:23',NULL),('2026-01-31 08:57:23','2026-01-31 08:57:23','2026-01-31 08:57:23',1,398,'ae767f78-aece-4ac3-8d8f-5a63b43f0c6f',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',1,'2026-02-01 08:57:23',NULL),('2026-01-31 08:57:23','2026-01-31 08:57:23','2026-01-31 08:57:23',1,399,'2f5ef339-7578-45ad-9262-b9eb7501473d',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',1,'2026-02-01 08:57:23',NULL),('2026-01-31 08:57:23','2026-01-31 08:57:23','2026-01-31 08:57:23',1,400,'02368a54-286f-4ccd-9d65-48b5e8bc1f44',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',1,'2026-02-01 08:57:23',NULL),('2026-01-31 08:57:44','2026-01-31 08:57:44','2026-01-31 08:57:44',1,401,'2a05fee7-e700-47ed-9f84-80b8216e0d0f',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',-1,'2026-02-01 08:57:44',NULL),('2026-01-31 08:57:44','2026-01-31 08:57:44','2026-01-31 08:57:44',1,402,'3a8f2e0e-4fa5-4093-b621-d7e72a6519a6',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',-1,'2026-02-01 08:57:44',NULL),('2026-01-31 08:57:44','2026-01-31 08:57:44','2026-01-31 08:57:44',1,403,'e43172f9-d430-4d62-9d0e-b091160e4906',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',-1,'2026-02-01 08:57:44',NULL),('2026-01-31 08:57:44','2026-01-31 08:57:44','2026-01-31 08:57:44',1,404,'e9a15fe1-ca29-41b5-a579-c76f51bbb008',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',-1,'2026-02-01 08:57:44',NULL),('2026-01-31 08:57:46','2026-01-31 08:57:46','2026-01-31 08:57:46',1,405,'1897576c-a7ac-4ebd-b997-2e3c8eaa7f34',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',-1,'2026-02-01 08:57:46',NULL),('2026-01-31 08:57:46','2026-01-31 08:57:46','2026-01-31 08:57:46',1,406,'6f529d5e-61ba-48f4-b1b5-f23e068d3ba9',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',-1,'2026-02-01 08:57:46',NULL),('2026-01-31 08:57:46','2026-01-31 08:57:46','2026-01-31 08:57:46',1,407,'135acf68-d6e1-4784-9c33-7d8c104a66c0',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',-1,'2026-02-01 08:57:46',NULL),('2026-01-31 08:57:46','2026-01-31 08:57:46','2026-01-31 08:57:46',1,408,'00893c1c-eb62-481a-a1c1-1a66ec6cd4db',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',-1,'2026-02-01 08:57:46',NULL),('2026-01-31 08:57:47','2026-01-31 08:57:47','2026-01-31 08:57:47',1,409,'cb086c22-cb2e-4af6-9e3a-d610935a7042',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:57:47',NULL),('2026-01-31 08:57:47','2026-01-31 08:57:47','2026-01-31 08:57:47',1,410,'2a885f82-c18d-4d17-acd0-d8a77c9f5e14',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:57:47',NULL),('2026-01-31 08:57:47','2026-01-31 08:57:47','2026-01-31 08:57:47',1,411,'b43af454-a4bc-4b52-8593-eade3471068a',101,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:57:47',NULL),('2026-01-31 08:57:47','2026-01-31 08:57:47','2026-01-31 08:57:47',1,412,'12df4051-03fb-474a-9cbc-585332d5798e',102,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',-1,'2026-02-01 08:57:47',NULL),('2026-01-31 08:57:48','2026-01-31 08:57:48','2026-01-31 08:57:48',1,413,'7be45b84-1456-4c7e-8b57-f609d97b080c',105,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes',-1,'2026-02-01 08:57:48',NULL),('2026-01-31 08:57:48','2026-01-31 08:57:48','2026-01-31 08:57:48',1,414,'162909b2-a9da-4feb-b916-8044875453fd',106,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes',-1,'2026-02-01 08:57:48',NULL),('2026-01-31 08:57:48','2026-01-31 08:57:48','2026-01-31 08:57:48',1,415,'b2a534fc-3c32-45b8-8b46-aaf3d3a85ac7',107,'ab2d642eb03c4bda84a9a23e86f1fa4d','volumes___DEFAULT__',-1,'2026-02-01 08:57:48',NULL),('2026-01-31 08:57:48','2026-01-31 08:57:48','2026-01-31 08:57:48',1,416,'0c0e81e4-f801-4a15-942f-d5327356ef9d',108,'ab2d642eb03c4bda84a9a23e86f1fa4d','gigabytes___DEFAULT__',-1,'2026-02-01 08:57:48',NULL),('2026-01-31 08:57:53','2026-01-31 08:57:53','2026-01-31 08:57:53',1,417,'746a014d-432f-4d36-9b57-d66a2eb2094e',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:57:53',NULL),('2026-01-31 08:57:53','2026-01-31 08:57:53','2026-01-31 08:57:53',1,418,'4f0317a3-44b8-47f1-94ce-a918265ba9fc',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:57:53',NULL),('2026-01-31 08:57:53','2026-01-31 08:57:53','2026-01-31 08:57:53',1,419,'bf9b0746-ed1d-438e-acd1-69efca0b456e',103,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:57:53',NULL),('2026-01-31 08:57:53','2026-01-31 08:57:53','2026-01-31 08:57:53',1,420,'c8a53685-b313-4983-bd24-65d5e4e6b00c',104,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',-1,'2026-02-01 08:57:53',NULL),('2026-01-31 08:58:03','2026-01-31 08:58:03','2026-01-31 08:58:03',1,421,'9e784263-4df9-4a1f-8652-f7efd3a2a350',111,'01662186bc9a4adf8b2309e0fff4f829','volumes',1,'2026-02-01 08:58:03',NULL),('2026-01-31 08:58:03','2026-01-31 08:58:03','2026-01-31 08:58:03',1,422,'ead12353-ac0b-4ad2-856a-8954e91ae5e7',112,'01662186bc9a4adf8b2309e0fff4f829','gigabytes',1,'2026-02-01 08:58:03',NULL),('2026-01-31 08:58:03','2026-01-31 08:58:03','2026-01-31 08:58:03',1,423,'9f509809-bee9-490e-ad32-5082262c5bfd',113,'01662186bc9a4adf8b2309e0fff4f829','volumes___DEFAULT__',1,'2026-02-01 08:58:03',NULL),('2026-01-31 08:58:03','2026-01-31 08:58:03','2026-01-31 08:58:03',1,424,'913ca658-bd1d-4178-9994-66758576e90a',114,'01662186bc9a4adf8b2309e0fff4f829','gigabytes___DEFAULT__',1,'2026-02-01 08:58:03',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,425,'9fdcf4de-b704-44f1-b02c-afe46e82a767',115,'01662186bc9a4adf8b2309e0fff4f829','snapshots',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,426,'28c8674c-788f-439a-9fbe-e0cd52f5c879',112,'01662186bc9a4adf8b2309e0fff4f829','gigabytes',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,427,'06e450ba-3251-4151-8bec-1e8408e51b13',114,'01662186bc9a4adf8b2309e0fff4f829','gigabytes___DEFAULT__',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:04','2026-01-31 08:58:04','2026-01-31 08:58:04',1,428,'2ae608b8-7cc4-4e5c-9c81-98c3bde3f7c3',116,'01662186bc9a4adf8b2309e0fff4f829','snapshots___DEFAULT__',1,'2026-02-01 08:58:04',NULL),('2026-01-31 08:58:07','2026-01-31 08:58:07','2026-01-31 08:58:07',1,429,'187976dd-358f-497e-ad14-54f439171f2d',115,'01662186bc9a4adf8b2309e0fff4f829','snapshots',-1,'2026-02-01 08:58:07',NULL),('2026-01-31 08:58:07','2026-01-31 08:58:07','2026-01-31 08:58:07',1,430,'5d6f4d8c-d07d-4965-83c5-f0a06e7e667e',112,'01662186bc9a4adf8b2309e0fff4f829','gigabytes',-1,'2026-02-01 08:58:07',NULL),('2026-01-31 08:58:07','2026-01-31 08:58:07','2026-01-31 08:58:07',1,431,'a9256959-47b8-4b05-84da-47bacb28243b',114,'01662186bc9a4adf8b2309e0fff4f829','gigabytes___DEFAULT__',-1,'2026-02-01 08:58:07',NULL),('2026-01-31 08:58:07','2026-01-31 08:58:07','2026-01-31 08:58:07',1,432,'24cd216d-6738-4833-9fba-2f25b70cb237',116,'01662186bc9a4adf8b2309e0fff4f829','snapshots___DEFAULT__',-1,'2026-02-01 08:58:07',NULL),('2026-01-31 08:58:09','2026-01-31 08:58:09','2026-01-31 08:58:09',1,433,'67b47ba8-ba39-4d0c-9225-029f07d7034f',111,'01662186bc9a4adf8b2309e0fff4f829','volumes',-1,'2026-02-01 08:58:09',NULL),('2026-01-31 08:58:09','2026-01-31 08:58:09','2026-01-31 08:58:09',1,434,'7c048b33-8e0c-41d6-b8eb-102baf1ef6d6',112,'01662186bc9a4adf8b2309e0fff4f829','gigabytes',-1,'2026-02-01 08:58:09',NULL),('2026-01-31 08:58:09','2026-01-31 08:58:09','2026-01-31 08:58:09',1,435,'1a692c5f-ada8-49ac-b8e8-060cf6c08506',113,'01662186bc9a4adf8b2309e0fff4f829','volumes___DEFAULT__',-1,'2026-02-01 08:58:09',NULL),('2026-01-31 08:58:09','2026-01-31 08:58:09','2026-01-31 08:58:09',1,436,'f14eca25-7820-48d3-a399-5f754a00f2bc',114,'01662186bc9a4adf8b2309e0fff4f829','gigabytes___DEFAULT__',-1,'2026-02-01 08:58:09',NULL),('2026-01-31 08:58:29','2026-01-31 08:58:29','2026-01-31 08:58:29',1,437,'d7f03638-dff9-49db-85f8-05e3b6794592',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:58:29',NULL),('2026-01-31 08:58:29','2026-01-31 08:58:29','2026-01-31 08:58:29',1,438,'d4b5fb91-eee8-4fef-b821-cd4c304a426d',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:58:29',NULL),('2026-01-31 08:58:29','2026-01-31 08:58:29','2026-01-31 08:58:29',1,439,'88ee417d-f900-4b55-90a7-837d2713da93',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:29',NULL),('2026-01-31 08:58:29','2026-01-31 08:58:29','2026-01-31 08:58:29',1,440,'d0fbdd1b-b610-4961-bf22-3ec3ea921975',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:29',NULL),('2026-01-31 08:58:32','2026-01-31 08:58:32','2026-01-31 08:58:32',1,441,'08b8ad8e-05bc-4b27-be2a-337c54cf1c1f',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:58:32',NULL),('2026-01-31 08:58:32','2026-01-31 08:58:32','2026-01-31 08:58:32',1,442,'05723983-87e8-4143-a1b2-72afddb130a8',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:58:32',NULL),('2026-01-31 08:58:32','2026-01-31 08:58:32','2026-01-31 08:58:32',1,443,'3ce4b0f4-21a0-4f8e-8d08-daa29749a420',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:32',NULL),('2026-01-31 08:58:32','2026-01-31 08:58:32','2026-01-31 08:58:32',1,444,'2e7841d1-0f7d-4b48-96ca-ce8c10a55539',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:32',NULL),('2026-01-31 08:58:34','2026-01-31 08:58:34','2026-01-31 08:58:34',1,445,'d79b1f6b-02c6-4ab8-8bbc-513a21df705f',99,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes',-1,'2026-02-01 08:58:34',NULL),('2026-01-31 08:58:34','2026-01-31 08:58:34','2026-01-31 08:58:34',1,446,'a2880269-8d52-41ba-8339-838802c1905f',100,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes',-1,'2026-02-01 08:58:34',NULL),('2026-01-31 08:58:34','2026-01-31 08:58:34','2026-01-31 08:58:34',1,447,'8f7e967e-b4f8-4440-8c25-4a071aca56dd',109,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:34',NULL),('2026-01-31 08:58:34','2026-01-31 08:58:34','2026-01-31 08:58:34',1,448,'d0017af6-c9b7-4f73-a7d1-1ff977b0108d',110,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',-1,'2026-02-01 08:58:34',NULL),('2026-01-31 08:59:57','2026-01-31 08:59:57','2026-01-31 08:59:57',1,449,'6eb01af6-5387-4ae4-8cc8-838fa7d8580b',117,'3d3e35e8f8144cd58baa994b70ef9668','volumes',1,'2026-02-01 08:59:57',NULL),('2026-01-31 08:59:57','2026-01-31 08:59:57','2026-01-31 08:59:57',1,450,'9bae0ea0-8d95-42dd-9605-4d3b19e07b5f',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',1,'2026-02-01 08:59:57',NULL),('2026-01-31 08:59:57','2026-01-31 08:59:57','2026-01-31 08:59:57',1,451,'0725414a-1dc1-4235-bf76-0e963a1416b8',119,'3d3e35e8f8144cd58baa994b70ef9668','volumes___DEFAULT__',1,'2026-02-01 08:59:57',NULL),('2026-01-31 08:59:57','2026-01-31 08:59:57','2026-01-31 08:59:57',1,452,'0744695a-3bc3-4343-8333-7340e50068e8',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',1,'2026-02-01 08:59:57',NULL),('2026-01-31 09:00:06','2026-01-31 09:00:07','2026-01-31 09:00:07',1,453,'e2f6aabf-4e01-4d3c-89e8-ca33a7f4ba03',121,'3d3e35e8f8144cd58baa994b70ef9668','snapshots',1,'2026-02-01 09:00:06',NULL),('2026-01-31 09:00:06','2026-01-31 09:00:07','2026-01-31 09:00:07',1,454,'ead5c2b5-fb44-4394-b9ac-5a7a47ef6e02',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',1,'2026-02-01 09:00:06',NULL),('2026-01-31 09:00:06','2026-01-31 09:00:07','2026-01-31 09:00:07',1,455,'785f5f05-d71f-4598-873d-e43aaf467a73',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',1,'2026-02-01 09:00:06',NULL),('2026-01-31 09:00:06','2026-01-31 09:00:07','2026-01-31 09:00:07',1,456,'d7241af2-ec54-4827-94f7-14acd659ebc5',122,'3d3e35e8f8144cd58baa994b70ef9668','snapshots___DEFAULT__',1,'2026-02-01 09:00:06',NULL),('2026-01-31 09:00:40','2026-01-31 09:00:40','2026-01-31 09:00:40',1,457,'a27da2e3-00e0-45d4-ba8b-b27bd9cda0a5',121,'3d3e35e8f8144cd58baa994b70ef9668','snapshots',-1,'2026-02-01 09:00:40',NULL),('2026-01-31 09:00:40','2026-01-31 09:00:40','2026-01-31 09:00:40',1,458,'f1e61490-b9f7-45e4-9c26-9c56b04c1dc9',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',-1,'2026-02-01 09:00:40',NULL),('2026-01-31 09:00:40','2026-01-31 09:00:40','2026-01-31 09:00:40',1,459,'8c6bce62-0bc2-4a0e-8bb0-421574d622bb',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',-1,'2026-02-01 09:00:40',NULL),('2026-01-31 09:00:40','2026-01-31 09:00:40','2026-01-31 09:00:40',1,460,'3453bd9b-ed80-4865-aac0-b2d147abc6c0',122,'3d3e35e8f8144cd58baa994b70ef9668','snapshots___DEFAULT__',-1,'2026-02-01 09:00:40',NULL),('2026-01-31 09:00:56','2026-01-31 09:00:56','2026-01-31 09:00:56',1,461,'7652290b-773a-4b6d-b0c7-91bf71c8d89e',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:00:55',NULL),('2026-01-31 09:00:56','2026-01-31 09:00:56','2026-01-31 09:00:56',1,462,'c7e95e7b-8a1a-44e0-928f-649413db5196',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:00:55',NULL),('2026-01-31 09:00:56','2026-01-31 09:00:56','2026-01-31 09:00:56',1,463,'4e56bf44-abcf-4f41-bdc5-dbd2dc481b74',125,'76ce367a834b49dfb5b436848118b860','volumes_tempest-scenario-type-luks-1403600605',1,'2026-02-01 09:00:55',NULL),('2026-01-31 09:00:56','2026-01-31 09:00:56','2026-01-31 09:00:56',1,464,'336c44de-b68f-44c8-8505-3b90d853745e',126,'76ce367a834b49dfb5b436848118b860','gigabytes_tempest-scenario-type-luks-1403600605',1,'2026-02-01 09:00:55',NULL),('2026-01-31 09:01:22','2026-01-31 09:01:22','2026-01-31 09:01:22',1,465,'4416c7e5-1f6d-426e-ab9d-5efbd51b1901',127,'1f293713f6854265a89a1a4a002088d5','volumes',1,'2026-02-01 09:01:22',NULL),('2026-01-31 09:01:22','2026-01-31 09:01:22','2026-01-31 09:01:22',1,466,'a1347b39-1d1f-4199-8a39-0437caacc98c',128,'1f293713f6854265a89a1a4a002088d5','gigabytes',1,'2026-02-01 09:01:22',NULL),('2026-01-31 09:01:22','2026-01-31 09:01:22','2026-01-31 09:01:22',1,467,'b830b6ec-697f-4d9c-b121-4681eb555f06',129,'1f293713f6854265a89a1a4a002088d5','volumes___DEFAULT__',1,'2026-02-01 09:01:22',NULL),('2026-01-31 09:01:22','2026-01-31 09:01:22','2026-01-31 09:01:22',1,468,'36bbdb69-564e-4517-8a23-4f98db250652',130,'1f293713f6854265a89a1a4a002088d5','gigabytes___DEFAULT__',1,'2026-02-01 09:01:22',NULL),('2026-01-31 09:01:45','2026-01-31 09:01:46','2026-01-31 09:01:46',1,469,'91c43d20-9d03-4295-8b83-4c3e9de30d12',117,'3d3e35e8f8144cd58baa994b70ef9668','volumes',-1,'2026-02-01 09:01:45',NULL),('2026-01-31 09:01:45','2026-01-31 09:01:46','2026-01-31 09:01:46',1,470,'71f1721b-50f5-489e-a3c3-a7a2bb11944b',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',-1,'2026-02-01 09:01:45',NULL),('2026-01-31 09:01:45','2026-01-31 09:01:46','2026-01-31 09:01:46',1,471,'7b456959-adf1-4aac-9072-ea1e6dfdc6c7',119,'3d3e35e8f8144cd58baa994b70ef9668','volumes___DEFAULT__',-1,'2026-02-01 09:01:45',NULL),('2026-01-31 09:01:45','2026-01-31 09:01:46','2026-01-31 09:01:46',1,472,'95454e64-20c0-4a7e-b4c3-8256ad41fa4e',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',-1,'2026-02-01 09:01:45',NULL),('2026-01-31 09:01:46','2026-01-31 09:01:46','2026-01-31 09:01:46',1,473,'19042de7-2962-494a-abf5-64368a694166',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:01:46',NULL),('2026-01-31 09:01:46','2026-01-31 09:01:46','2026-01-31 09:01:46',1,474,'4ce9f748-1f9f-49aa-b7d7-075a3d6245c3',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:01:46',NULL),('2026-01-31 09:01:46','2026-01-31 09:01:46','2026-01-31 09:01:46',1,475,'81c8f0e2-e2f0-4cba-93f9-3518d6dbca2b',125,'76ce367a834b49dfb5b436848118b860','volumes_tempest-scenario-type-luks-1403600605',-1,'2026-02-01 09:01:46',NULL),('2026-01-31 09:01:46','2026-01-31 09:01:46','2026-01-31 09:01:46',1,476,'468aeb5e-4fd6-4c57-b281-d7e2dfda1ec5',126,'76ce367a834b49dfb5b436848118b860','gigabytes_tempest-scenario-type-luks-1403600605',-1,'2026-02-01 09:01:46',NULL),('2026-01-31 09:01:50','2026-01-31 09:01:50','2026-01-31 09:01:50',1,477,'2dde51a1-38ff-40a0-9af7-3e55c6c47a4c',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:01:49',NULL),('2026-01-31 09:01:50','2026-01-31 09:01:50','2026-01-31 09:01:50',1,478,'47c2b87e-b57e-4a24-8a81-9fa719f79c20',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:01:49',NULL),('2026-01-31 09:01:50','2026-01-31 09:01:50','2026-01-31 09:01:50',1,479,'c508592a-23af-413c-9989-bec262b0a7b4',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:01:49',NULL),('2026-01-31 09:01:50','2026-01-31 09:01:50','2026-01-31 09:01:50',1,480,'c4235289-58c1-4a33-95a8-a44da2cd3d4a',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:01:49',NULL),('2026-01-31 09:02:07','2026-01-31 09:02:07','2026-01-31 09:02:07',1,481,'51e052c2-a8c7-4748-bdd1-741f3b40956b',133,'76ce367a834b49dfb5b436848118b860','snapshots',1,'2026-02-01 09:02:07',NULL),('2026-01-31 09:02:07','2026-01-31 09:02:07','2026-01-31 09:02:07',1,482,'bf6c7611-097a-4e74-aacb-6f63951251f8',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:02:07',NULL),('2026-01-31 09:02:07','2026-01-31 09:02:07','2026-01-31 09:02:07',1,483,'003cac78-d636-4f49-8d5a-253a3911378f',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:02:07',NULL),('2026-01-31 09:02:07','2026-01-31 09:02:07','2026-01-31 09:02:07',1,484,'184b3bcc-01a2-4436-bc1c-fe1a1388f2d7',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',1,'2026-02-01 09:02:07',NULL),('2026-01-31 09:02:25','2026-01-31 09:02:26','2026-01-31 09:02:26',1,485,'0cf61e11-3cc9-4028-a1d8-e92e8cd720eb',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:02:25',NULL),('2026-01-31 09:02:25','2026-01-31 09:02:26','2026-01-31 09:02:26',1,486,'caf73eef-1551-4eb8-87c3-ad8627dd8d31',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:02:25',NULL),('2026-01-31 09:02:25','2026-01-31 09:02:26','2026-01-31 09:02:26',1,487,'357f807a-33a5-4b23-960f-34e4c9460030',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:02:25',NULL),('2026-01-31 09:02:25','2026-01-31 09:02:26','2026-01-31 09:02:26',1,488,'0d0b1e5f-c6c2-4502-b346-a23f5f23f1c6',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:02:25',NULL),('2026-01-31 09:02:38','2026-01-31 09:02:38','2026-01-31 09:02:38',1,489,'0695cae8-31eb-44e9-b719-2084b7053f4d',117,'3d3e35e8f8144cd58baa994b70ef9668','volumes',1,'2026-02-01 09:02:38',NULL),('2026-01-31 09:02:38','2026-01-31 09:02:38','2026-01-31 09:02:38',1,490,'72b221ce-e3f6-4478-824f-33d42c3dce69',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',1,'2026-02-01 09:02:38',NULL),('2026-01-31 09:02:38','2026-01-31 09:02:38','2026-01-31 09:02:38',1,491,'14e76cca-cdba-4988-82da-dafbc664c06e',119,'3d3e35e8f8144cd58baa994b70ef9668','volumes___DEFAULT__',1,'2026-02-01 09:02:38',NULL),('2026-01-31 09:02:38','2026-01-31 09:02:38','2026-01-31 09:02:38',1,492,'193d1f41-3d26-4e40-badd-9c7baf1241e3',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',1,'2026-02-01 09:02:38',NULL),('2026-01-31 09:02:54','2026-01-31 09:02:54','2026-01-31 09:02:54',1,493,'0560aa06-37e7-4350-94de-9f017830e621',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:02:54',NULL),('2026-01-31 09:02:54','2026-01-31 09:02:54','2026-01-31 09:02:54',1,494,'c3ec708a-e53a-4939-8425-d32a3c5858f6',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:02:54',NULL),('2026-01-31 09:02:54','2026-01-31 09:02:54','2026-01-31 09:02:54',1,495,'6f14982c-134a-4392-8883-76ece91272bf',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:02:54',NULL),('2026-01-31 09:02:54','2026-01-31 09:02:54','2026-01-31 09:02:54',1,496,'05adbd4e-ba40-4b6a-af04-47497ac940b3',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:02:54',NULL),('2026-01-31 09:03:01','2026-01-31 09:03:01','2026-01-31 09:03:01',1,497,'e9387581-fb37-4db7-af78-aa242ce4f1e5',133,'76ce367a834b49dfb5b436848118b860','snapshots',-1,'2026-02-01 09:03:01',NULL),('2026-01-31 09:03:01','2026-01-31 09:03:01','2026-01-31 09:03:01',1,498,'2626d2da-f815-4d31-967f-baa0e000fec8',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:03:01',NULL),('2026-01-31 09:03:01','2026-01-31 09:03:01','2026-01-31 09:03:01',1,499,'93877c9e-23b9-4f7f-b373-736db17c055e',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:03:01',NULL),('2026-01-31 09:03:01','2026-01-31 09:03:01','2026-01-31 09:03:01',1,500,'8f91df37-6f68-46a4-a8ab-52fa9291e73e',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',-1,'2026-02-01 09:03:01',NULL),('2026-01-31 09:03:04','2026-01-31 09:03:04','2026-01-31 09:03:04',1,501,'9c8c719f-e790-4f20-a0dd-f88d36bce895',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:03:04',NULL),('2026-01-31 09:03:04','2026-01-31 09:03:04','2026-01-31 09:03:04',1,502,'f0bc493c-b52c-41d4-8c77-f1ec4000e2e0',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:03:04',NULL),('2026-01-31 09:03:04','2026-01-31 09:03:04','2026-01-31 09:03:04',1,503,'655920e5-e177-43f1-ad6b-86231c08c08a',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:03:04',NULL),('2026-01-31 09:03:04','2026-01-31 09:03:04','2026-01-31 09:03:04',1,504,'d589a872-ec47-4ba5-82fb-b2e1b88c6af2',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:03:04',NULL),('2026-01-31 09:03:06','2026-01-31 09:03:06','2026-01-31 09:03:06',1,505,'0d360a93-551e-457c-9724-e4458393cd2c',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:03:06',NULL),('2026-01-31 09:03:06','2026-01-31 09:03:06','2026-01-31 09:03:06',1,506,'0997b618-f3c4-4feb-a6c4-9ea0675d0a0b',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:03:06',NULL),('2026-01-31 09:03:06','2026-01-31 09:03:06','2026-01-31 09:03:06',1,507,'5f7c28c5-44b8-448e-9b5c-6889d05f48c6',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:03:06',NULL),('2026-01-31 09:03:06','2026-01-31 09:03:06','2026-01-31 09:03:06',1,508,'d42dbfcd-6b4f-4728-b8b5-f69c928d4aa2',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:03:06',NULL),('2026-01-31 09:03:37','2026-01-31 09:03:38','2026-01-31 09:03:38',1,509,'94a6db20-1c7a-40df-96d0-c30820a46e6f',127,'1f293713f6854265a89a1a4a002088d5','volumes',-1,'2026-02-01 09:03:37',NULL),('2026-01-31 09:03:37','2026-01-31 09:03:38','2026-01-31 09:03:38',1,510,'59f22455-ff93-4b2d-ad58-7aa3f236aae5',128,'1f293713f6854265a89a1a4a002088d5','gigabytes',-1,'2026-02-01 09:03:37',NULL),('2026-01-31 09:03:37','2026-01-31 09:03:38','2026-01-31 09:03:38',1,511,'c37af7cc-ef42-4487-a5bf-b864edbe70c3',129,'1f293713f6854265a89a1a4a002088d5','volumes___DEFAULT__',-1,'2026-02-01 09:03:37',NULL),('2026-01-31 09:03:37','2026-01-31 09:03:38','2026-01-31 09:03:38',1,512,'73a76f1d-9703-475a-95f8-04ed3d968202',130,'1f293713f6854265a89a1a4a002088d5','gigabytes___DEFAULT__',-1,'2026-02-01 09:03:37',NULL),('2026-01-31 09:04:11','2026-01-31 09:04:11','2026-01-31 09:04:11',1,513,'52d78099-257b-4a9a-8ea3-22e8447fed35',117,'3d3e35e8f8144cd58baa994b70ef9668','volumes',-1,'2026-02-01 09:04:11',NULL),('2026-01-31 09:04:11','2026-01-31 09:04:11','2026-01-31 09:04:11',1,514,'8884356a-2324-4eb5-961d-63626842c8aa',118,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes',-1,'2026-02-01 09:04:11',NULL),('2026-01-31 09:04:11','2026-01-31 09:04:11','2026-01-31 09:04:11',1,515,'e067909b-0024-4a54-981a-948d5eead9cb',119,'3d3e35e8f8144cd58baa994b70ef9668','volumes___DEFAULT__',-1,'2026-02-01 09:04:11',NULL),('2026-01-31 09:04:11','2026-01-31 09:04:11','2026-01-31 09:04:11',1,516,'5c66f294-286d-4b51-9173-c0b5229e44de',120,'3d3e35e8f8144cd58baa994b70ef9668','gigabytes___DEFAULT__',-1,'2026-02-01 09:04:11',NULL),('2026-01-31 09:04:16','2026-01-31 09:04:16','2026-01-31 09:04:16',1,517,'d68e3e44-4015-4c7e-a151-2b56ec432d6a',133,'76ce367a834b49dfb5b436848118b860','snapshots',1,'2026-02-01 09:04:16',NULL),('2026-01-31 09:04:16','2026-01-31 09:04:16','2026-01-31 09:04:16',1,518,'9ff0cd7e-bab4-45a5-b1f9-e446a6bd6041',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:04:16',NULL),('2026-01-31 09:04:16','2026-01-31 09:04:16','2026-01-31 09:04:16',1,519,'0847e2ab-68d0-453a-8760-fa47d8564454',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:04:16',NULL),('2026-01-31 09:04:16','2026-01-31 09:04:16','2026-01-31 09:04:16',1,520,'992085c7-b9a7-4c4b-9ef9-bfb1f733316e',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',1,'2026-02-01 09:04:16',NULL),('2026-01-31 09:04:42','2026-01-31 09:04:42','2026-01-31 09:04:42',1,521,'7eee8398-f81c-441a-8e9f-48eb040f3de7',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:04:42',NULL),('2026-01-31 09:04:42','2026-01-31 09:04:42','2026-01-31 09:04:42',1,522,'9795c27b-d574-47d2-862b-69a9ba618ec5',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:04:42',NULL),('2026-01-31 09:04:42','2026-01-31 09:04:42','2026-01-31 09:04:42',1,523,'53d9d519-c61f-4247-bbfe-d88408bb3b96',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:04:42',NULL),('2026-01-31 09:04:42','2026-01-31 09:04:42','2026-01-31 09:04:42',1,524,'549e8016-0d15-4abc-90ea-9bf67ff7793a',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:04:42',NULL),('2026-01-31 09:04:48','2026-01-31 09:04:48','2026-01-31 09:04:48',1,525,'7d8ccd12-97c8-457f-9785-f74ee95ff7fc',135,'c8017efbc64b4244b349174c29a41000','volumes',1,'2026-02-01 09:04:48',NULL),('2026-01-31 09:04:48','2026-01-31 09:04:48','2026-01-31 09:04:48',1,526,'bb5c6fe8-406f-4210-9d1a-fbf7b99709ff',136,'c8017efbc64b4244b349174c29a41000','gigabytes',1,'2026-02-01 09:04:48',NULL),('2026-01-31 09:04:48','2026-01-31 09:04:48','2026-01-31 09:04:48',1,527,'91da97e3-2646-4b57-aa78-87f24496943b',137,'c8017efbc64b4244b349174c29a41000','volumes___DEFAULT__',1,'2026-02-01 09:04:48',NULL),('2026-01-31 09:04:48','2026-01-31 09:04:48','2026-01-31 09:04:48',1,528,'447c0aae-0e8d-45a4-bbf8-3a470c696af3',138,'c8017efbc64b4244b349174c29a41000','gigabytes___DEFAULT__',1,'2026-02-01 09:04:48',NULL),('2026-01-31 09:05:00','2026-01-31 09:05:00','2026-01-31 09:05:00',1,529,'cd09a216-ad9d-4745-8cae-3cf5daca0c7d',139,'c8017efbc64b4244b349174c29a41000','backups',1,'2026-02-01 09:05:00',NULL),('2026-01-31 09:05:00','2026-01-31 09:05:00','2026-01-31 09:05:00',1,530,'0f930ee0-ee54-4788-b3a3-dd9dc88ccc61',140,'c8017efbc64b4244b349174c29a41000','backup_gigabytes',1,'2026-02-01 09:05:00',NULL),('2026-01-31 09:05:08','2026-01-31 09:05:08','2026-01-31 09:05:08',1,531,'8d9c19ae-4a9f-40b6-971c-1c58f64a9d75',135,'c8017efbc64b4244b349174c29a41000','volumes',1,'2026-02-01 09:05:08',NULL),('2026-01-31 09:05:08','2026-01-31 09:05:08','2026-01-31 09:05:08',1,532,'3e51b786-60b0-45f4-8f79-bf2bb7732bcd',136,'c8017efbc64b4244b349174c29a41000','gigabytes',1,'2026-02-01 09:05:08',NULL),('2026-01-31 09:05:08','2026-01-31 09:05:08','2026-01-31 09:05:08',1,533,'c014f923-461e-4fbe-bff3-cbccef19d027',137,'c8017efbc64b4244b349174c29a41000','volumes___DEFAULT__',1,'2026-02-01 09:05:08',NULL),('2026-01-31 09:05:08','2026-01-31 09:05:08','2026-01-31 09:05:08',1,534,'17e53615-3260-400d-a747-7517b9d2ccb8',138,'c8017efbc64b4244b349174c29a41000','gigabytes___DEFAULT__',1,'2026-02-01 09:05:08',NULL),('2026-01-31 09:05:37','2026-01-31 09:05:37','2026-01-31 09:05:37',1,535,'68989e3d-f8d6-481f-b698-fd5a7555e952',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:05:37',NULL),('2026-01-31 09:05:37','2026-01-31 09:05:37','2026-01-31 09:05:37',1,536,'985833d6-c2ea-4f74-bc44-9fb81957b090',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:05:37',NULL),('2026-01-31 09:05:37','2026-01-31 09:05:37','2026-01-31 09:05:37',1,537,'4c429f10-7e5f-467f-b416-65a1972ab4cb',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:05:37',NULL),('2026-01-31 09:05:37','2026-01-31 09:05:37','2026-01-31 09:05:37',1,538,'bc5ea032-634f-412f-b780-eec8a120c1f2',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:05:37',NULL),('2026-01-31 09:05:39','2026-01-31 09:05:39','2026-01-31 09:05:39',1,539,'76d1da32-a213-473d-9fa9-5919d5178fdd',133,'76ce367a834b49dfb5b436848118b860','snapshots',-1,'2026-02-01 09:05:39',NULL),('2026-01-31 09:05:39','2026-01-31 09:05:39','2026-01-31 09:05:39',1,540,'8ccae5eb-0a0b-4ada-9faf-ac1be64fe8bd',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:05:39',NULL),('2026-01-31 09:05:39','2026-01-31 09:05:39','2026-01-31 09:05:39',1,541,'8ba21253-1368-482f-8539-33ebd9d1ec89',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:05:39',NULL),('2026-01-31 09:05:39','2026-01-31 09:05:39','2026-01-31 09:05:39',1,542,'9f7f77a2-fe97-40dd-9792-56a7ce050202',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',-1,'2026-02-01 09:05:39',NULL),('2026-01-31 09:05:45','2026-01-31 09:05:45','2026-01-31 09:05:45',1,543,'ef71dd43-7760-4afb-937e-6bedaa4dda2c',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:05:45',NULL),('2026-01-31 09:05:45','2026-01-31 09:05:45','2026-01-31 09:05:45',1,544,'490ddc8e-6747-4d9d-8bcd-a9a944a42b7a',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:05:45',NULL),('2026-01-31 09:05:45','2026-01-31 09:05:45','2026-01-31 09:05:45',1,545,'b75deec8-252f-463f-ba06-293261cc74fe',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:05:45',NULL),('2026-01-31 09:05:45','2026-01-31 09:05:45','2026-01-31 09:05:45',1,546,'68031b94-3c9e-4d05-acd5-a665e012e156',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:05:45',NULL),('2026-01-31 09:05:57','2026-01-31 09:05:57','2026-01-31 09:05:57',1,547,'171c651c-9b84-44e3-9f93-57fb31446f05',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:05:57',NULL),('2026-01-31 09:05:57','2026-01-31 09:05:57','2026-01-31 09:05:57',1,548,'838684a4-8065-4d91-a276-a2184f79898c',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:05:57',NULL),('2026-01-31 09:05:57','2026-01-31 09:05:57','2026-01-31 09:05:57',1,549,'502cb8c2-9ec4-4d6c-9715-f80ea18c0ef1',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:05:57',NULL),('2026-01-31 09:05:57','2026-01-31 09:05:57','2026-01-31 09:05:57',1,550,'adf6b216-f64f-4da7-a0de-f689da7812dc',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:05:57',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,551,'c9f4ca3c-82c1-4768-944b-9c05825fdedb',139,'c8017efbc64b4244b349174c29a41000','backups',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,552,'dc37bf48-7ee2-481d-b3d4-2d504b127e88',140,'c8017efbc64b4244b349174c29a41000','backup_gigabytes',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,553,'8e40f306-b735-4aa8-bff5-490235fad821',135,'c8017efbc64b4244b349174c29a41000','volumes',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,554,'ab286cbc-396f-4ffd-b37d-2dc43cdb58f4',136,'c8017efbc64b4244b349174c29a41000','gigabytes',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,555,'1d28e4c1-d43f-4d33-83cc-751e2260a584',137,'c8017efbc64b4244b349174c29a41000','volumes___DEFAULT__',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:04','2026-01-31 09:06:04','2026-01-31 09:06:04',1,556,'2b0ca00d-04de-40be-8923-05910aa900c9',138,'c8017efbc64b4244b349174c29a41000','gigabytes___DEFAULT__',-1,'2026-02-01 09:06:04',NULL),('2026-01-31 09:06:05','2026-01-31 09:06:05','2026-01-31 09:06:05',1,557,'3b15c880-4e8c-44f3-aae8-ea08a9f69fc9',135,'c8017efbc64b4244b349174c29a41000','volumes',-1,'2026-02-01 09:06:05',NULL),('2026-01-31 09:06:05','2026-01-31 09:06:05','2026-01-31 09:06:05',1,558,'a01a9e23-b6c1-4478-a998-06e75794e1eb',136,'c8017efbc64b4244b349174c29a41000','gigabytes',-1,'2026-02-01 09:06:05',NULL),('2026-01-31 09:06:05','2026-01-31 09:06:05','2026-01-31 09:06:05',1,559,'3850e126-0aec-40b6-93d0-3b840f0fd8e2',137,'c8017efbc64b4244b349174c29a41000','volumes___DEFAULT__',-1,'2026-02-01 09:06:05',NULL),('2026-01-31 09:06:05','2026-01-31 09:06:05','2026-01-31 09:06:05',1,560,'eeeb409b-5102-4896-bc5d-3c5b78b3e72a',138,'c8017efbc64b4244b349174c29a41000','gigabytes___DEFAULT__',-1,'2026-02-01 09:06:05',NULL),('2026-01-31 09:07:41','2026-01-31 09:07:41','2026-01-31 09:07:41',1,561,'30e0c2b0-c9a1-4862-8b95-55ae14925edf',133,'76ce367a834b49dfb5b436848118b860','snapshots',1,'2026-02-01 09:07:41',NULL),('2026-01-31 09:07:41','2026-01-31 09:07:41','2026-01-31 09:07:41',1,562,'3d049d51-019e-4637-8f41-c8ca84e98175',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:07:41',NULL),('2026-01-31 09:07:41','2026-01-31 09:07:41','2026-01-31 09:07:41',1,563,'ce69d1e0-04e8-4c84-b0c5-b8934b7eaf21',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:07:41',NULL),('2026-01-31 09:07:41','2026-01-31 09:07:41','2026-01-31 09:07:41',1,564,'551b03a2-259f-4aad-90e0-e295fc60d269',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',1,'2026-02-01 09:07:41',NULL),('2026-01-31 09:07:43','2026-01-31 09:07:43','2026-01-31 09:07:43',1,565,'2d15dc25-97eb-4758-882b-ed47c3b758ac',123,'76ce367a834b49dfb5b436848118b860','volumes',1,'2026-02-01 09:07:43',NULL),('2026-01-31 09:07:43','2026-01-31 09:07:43','2026-01-31 09:07:43',1,566,'f8d8c8df-7102-43ab-ade7-237731688be0',124,'76ce367a834b49dfb5b436848118b860','gigabytes',1,'2026-02-01 09:07:43',NULL),('2026-01-31 09:07:43','2026-01-31 09:07:43','2026-01-31 09:07:43',1,567,'4da7885a-08fd-4fc3-bd53-3e57db2b7c16',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',1,'2026-02-01 09:07:43',NULL),('2026-01-31 09:07:43','2026-01-31 09:07:43','2026-01-31 09:07:43',1,568,'dfe5e512-1ac2-4fde-be96-2bf039bed042',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',1,'2026-02-01 09:07:43',NULL),('2026-01-31 09:08:44','2026-01-31 09:08:44','2026-01-31 09:08:44',1,569,'32c39afc-b376-4d00-b03c-4756e7486be1',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:08:44',NULL),('2026-01-31 09:08:44','2026-01-31 09:08:44','2026-01-31 09:08:44',1,570,'04d2474e-2a5c-411a-b39a-7d113c931f86',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:08:44',NULL),('2026-01-31 09:08:44','2026-01-31 09:08:44','2026-01-31 09:08:44',1,571,'f80e5076-4f3a-4468-bbbf-23bebe0c5317',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:08:44',NULL),('2026-01-31 09:08:44','2026-01-31 09:08:44','2026-01-31 09:08:44',1,572,'5117b959-e602-4543-9e0b-fe2def63397c',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:08:44',NULL),('2026-01-31 09:08:45','2026-01-31 09:08:45','2026-01-31 09:08:45',1,573,'1b886e3e-49de-41d1-b612-91fb033a101d',133,'76ce367a834b49dfb5b436848118b860','snapshots',-1,'2026-02-01 09:08:45',NULL),('2026-01-31 09:08:45','2026-01-31 09:08:45','2026-01-31 09:08:45',1,574,'af7f1612-4f9e-41aa-b47e-541e49b6afb0',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:08:45',NULL),('2026-01-31 09:08:45','2026-01-31 09:08:45','2026-01-31 09:08:45',1,575,'ecc5cefb-71d9-4ade-b696-a2efebabdac2',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:08:45',NULL),('2026-01-31 09:08:45','2026-01-31 09:08:45','2026-01-31 09:08:45',1,576,'b72bc46c-efe6-4a8a-99a0-671d682d1c50',134,'76ce367a834b49dfb5b436848118b860','snapshots___DEFAULT__',-1,'2026-02-01 09:08:45',NULL),('2026-01-31 09:08:52','2026-01-31 09:08:52','2026-01-31 09:08:52',1,577,'71ec2791-1640-470a-8bc0-07fd86eb72ff',123,'76ce367a834b49dfb5b436848118b860','volumes',-1,'2026-02-01 09:08:52',NULL),('2026-01-31 09:08:52','2026-01-31 09:08:52','2026-01-31 09:08:52',1,578,'af5a9bca-ebe1-4759-a545-c6ec1e74a7a5',124,'76ce367a834b49dfb5b436848118b860','gigabytes',-1,'2026-02-01 09:08:52',NULL),('2026-01-31 09:08:52','2026-01-31 09:08:52','2026-01-31 09:08:52',1,579,'a0a5c237-a40b-4b9f-9e5b-694a8d9c3a16',131,'76ce367a834b49dfb5b436848118b860','volumes___DEFAULT__',-1,'2026-02-01 09:08:52',NULL),('2026-01-31 09:08:52','2026-01-31 09:08:52','2026-01-31 09:08:52',1,580,'c9eb55f4-4d5d-4b5d-b1b0-8716327d70e5',132,'76ce367a834b49dfb5b436848118b860','gigabytes___DEFAULT__',-1,'2026-02-01 09:08:52',NULL),('2026-01-31 09:16:36','2026-01-31 09:16:36','2026-01-31 09:16:36',1,581,'c6b1f158-614a-4744-b863-f9cb02011e57',141,'390709b3e5174dc4afdc6b04fdae67e3','volumes',1,'2026-02-01 09:16:36',NULL),('2026-01-31 09:16:36','2026-01-31 09:16:36','2026-01-31 09:16:36',1,582,'00eaa88b-04d9-4998-9642-a50e5ea4c656',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',1,'2026-02-01 09:16:36',NULL),('2026-01-31 09:16:36','2026-01-31 09:16:36','2026-01-31 09:16:36',1,583,'cb21d9d1-aba1-4f12-aa7a-67b279d8bac3',143,'390709b3e5174dc4afdc6b04fdae67e3','volumes___DEFAULT__',1,'2026-02-01 09:16:36',NULL),('2026-01-31 09:16:36','2026-01-31 09:16:36','2026-01-31 09:16:36',1,584,'243b5c7a-4b21-42b0-bec3-697d7cd7242e',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',1,'2026-02-01 09:16:36',NULL),('2026-01-31 09:17:17','2026-01-31 09:17:17','2026-01-31 09:17:17',1,585,'ce7368cb-7c6c-4b7f-aab4-0c305e7f4810',145,'390709b3e5174dc4afdc6b04fdae67e3','snapshots',1,'2026-02-01 09:17:17',NULL),('2026-01-31 09:17:17','2026-01-31 09:17:17','2026-01-31 09:17:17',1,586,'99a2fa1f-44c3-4470-9dfa-0453138041fb',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',1,'2026-02-01 09:17:17',NULL),('2026-01-31 09:17:17','2026-01-31 09:17:17','2026-01-31 09:17:17',1,587,'3dccd930-923b-46c1-9ca1-c0b6579bb96d',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',1,'2026-02-01 09:17:17',NULL),('2026-01-31 09:17:17','2026-01-31 09:17:17','2026-01-31 09:17:17',1,588,'6812f304-078b-439c-8ce9-9dfb6d62657b',146,'390709b3e5174dc4afdc6b04fdae67e3','snapshots___DEFAULT__',1,'2026-02-01 09:17:17',NULL),('2026-01-31 09:17:26','2026-01-31 09:17:26','2026-01-31 09:17:26',1,589,'f5d4a5b0-6eb8-4fc5-9c97-d4f5f1ee335e',141,'390709b3e5174dc4afdc6b04fdae67e3','volumes',1,'2026-02-01 09:17:26',NULL),('2026-01-31 09:17:26','2026-01-31 09:17:26','2026-01-31 09:17:26',1,590,'48f9a72a-8c3c-45ef-bb21-6eb2dec0d53f',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',1,'2026-02-01 09:17:26',NULL),('2026-01-31 09:17:26','2026-01-31 09:17:26','2026-01-31 09:17:26',1,591,'b071560a-cbe1-40c5-b2cc-f574a915c3c3',143,'390709b3e5174dc4afdc6b04fdae67e3','volumes___DEFAULT__',1,'2026-02-01 09:17:26',NULL),('2026-01-31 09:17:26','2026-01-31 09:17:26','2026-01-31 09:17:26',1,592,'748ae70e-5bc7-4958-972a-c6a81d4946de',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',1,'2026-02-01 09:17:26',NULL),('2026-01-31 09:18:34','2026-01-31 09:18:34','2026-01-31 09:18:34',1,593,'e34ee605-eae8-4ddf-bce3-24c7829c3909',141,'390709b3e5174dc4afdc6b04fdae67e3','volumes',-1,'2026-02-01 09:18:34',NULL),('2026-01-31 09:18:34','2026-01-31 09:18:34','2026-01-31 09:18:34',1,594,'f1785626-8fe9-4bef-a866-b7661da7662a',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',-1,'2026-02-01 09:18:34',NULL),('2026-01-31 09:18:34','2026-01-31 09:18:34','2026-01-31 09:18:34',1,595,'32eed52e-4f28-450f-91cf-a5dc198e76a0',143,'390709b3e5174dc4afdc6b04fdae67e3','volumes___DEFAULT__',-1,'2026-02-01 09:18:34',NULL),('2026-01-31 09:18:34','2026-01-31 09:18:34','2026-01-31 09:18:34',1,596,'ad7a139f-42b7-4efc-a4f0-aa567e03c763',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',-1,'2026-02-01 09:18:34',NULL),('2026-01-31 09:18:46','2026-01-31 09:18:46','2026-01-31 09:18:46',1,597,'ecb1c9b1-6edb-4362-b171-630d8377b56f',145,'390709b3e5174dc4afdc6b04fdae67e3','snapshots',-1,'2026-02-01 09:18:46',NULL),('2026-01-31 09:18:46','2026-01-31 09:18:46','2026-01-31 09:18:46',1,598,'2f431b47-3430-4991-a54b-a28c922c50c3',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',-1,'2026-02-01 09:18:46',NULL),('2026-01-31 09:18:46','2026-01-31 09:18:46','2026-01-31 09:18:46',1,599,'e48c5ef4-d5db-41d0-9621-92ec1deddcb9',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',-1,'2026-02-01 09:18:46',NULL),('2026-01-31 09:18:46','2026-01-31 09:18:46','2026-01-31 09:18:46',1,600,'62478c76-2ae1-4eca-b7bc-d68a76209c95',146,'390709b3e5174dc4afdc6b04fdae67e3','snapshots___DEFAULT__',-1,'2026-02-01 09:18:46',NULL),('2026-01-31 09:18:56','2026-01-31 09:18:56','2026-01-31 09:18:56',1,601,'54ab030e-6afd-4f97-9468-020b89127e21',141,'390709b3e5174dc4afdc6b04fdae67e3','volumes',-1,'2026-02-01 09:18:56',NULL),('2026-01-31 09:18:56','2026-01-31 09:18:56','2026-01-31 09:18:56',1,602,'df4c11b6-c078-4023-af78-9942a293e53d',142,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes',-1,'2026-02-01 09:18:56',NULL),('2026-01-31 09:18:56','2026-01-31 09:18:56','2026-01-31 09:18:56',1,603,'0e2e6cf0-2ecd-4169-8541-4e01c41004f1',143,'390709b3e5174dc4afdc6b04fdae67e3','volumes___DEFAULT__',-1,'2026-02-01 09:18:56',NULL),('2026-01-31 09:18:56','2026-01-31 09:18:56','2026-01-31 09:18:56',1,604,'5dfe06c3-a257-4f34-9238-7272ede17494',144,'390709b3e5174dc4afdc6b04fdae67e3','gigabytes___DEFAULT__',-1,'2026-02-01 09:18:56',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-31 07:04:51','2026-01-31 09:41:50',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',929,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'fe3a02eb-e34f-4032-bd2b-412105ff587e'),('2026-01-31 07:40:43','2026-01-31 09:41:48',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',726,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'91ebc21e-105e-40b3-a5a8-463a7a877f71'),('2026-01-31 07:40:46','2026-01-31 09:41:52',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',726,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2026-01-31 08:58:04','2026-01-31 08:58:06','2026-01-31 08:58:07',1,'4659f73e-f9ac-4b9c-8176-75dd5bbc7517','fb14c875-d28b-48cd-898c-660d2eb46091','c1c047e8715e49b2a126a78e44daf2e8','01662186bc9a4adf8b2309e0fff4f829','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-907322520',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1),('2026-01-31 09:07:41','2026-01-31 09:08:44','2026-01-31 09:08:45',1,'65aa871b-bb87-4e43-b07f-a086967007df','b457f046-29d9-4842-87e2-ad26874ea748','dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1105457441',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1),('2026-01-31 09:02:07','2026-01-31 09:02:59','2026-01-31 09:03:01',1,'714b73f4-e266-4c1a-8a63-cf91334700b6','57ea21d4-80c1-49f4-b17b-267af386ea6e','dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-1487602585',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1),('2026-01-31 09:00:06','2026-01-31 09:00:39','2026-01-31 09:00:40',1,'79696a4d-bb92-42c2-b978-5d44ccc11874','b7cfb970-aa00-4ab7-b895-9c828f0058d5','b97882caec944ca3b26c230fcebff775','3d3e35e8f8144cd58baa994b70ef9668','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-2090904536',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1),('2026-01-31 09:04:16','2026-01-31 09:05:38','2026-01-31 09:05:39',1,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','47ca8e30-e640-4fca-a274-67bf157244e9','dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-724948954',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1),('2026-01-31 08:52:04','2026-01-31 08:52:15','2026-01-31 08:52:16',1,'cf78778e-15b7-4039-9f65-5985e69a326f','f7e6afdb-ed5e-4762-ad08-3a1fceda6276','a498364761ef428b99cac3f92e603385','8397e0fed04b4dabb57148d0924de2dc','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,NULL,NULL,NULL,1),('2026-01-31 09:17:17','2026-01-31 09:18:44','2026-01-31 09:18:46',1,'d4450360-3f6e-407a-b349-a4ab7476743d','bb545a69-3527-4e10-b1af-2e7b80d9ad14','4f25568607234a398bc35cbb67eb406f','390709b3e5174dc4afdc6b04fdae67e3','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-340997898',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2026-01-31 08:33:25','2026-01-31 08:33:34','2026-01-31 08:33:34',1,'05691143-289f-4876-9a9b-4720264fddbd','a91659a9-a045-40d5-a67a-84e5963be227','compute-1.ctlplane.example.com','8e88da8b-f1f3-484b-a632-555780f0de0f','/dev/vdb','2026-01-31 08:33:27','2026-01-31 08:33:34','rw','detached','{\"name\": \"volumes/volume-a91659a9-a045-40d5-a67a-84e5963be227\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"a91659a9-a045-40d5-a67a-84e5963be227\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"05691143-289f-4876-9a9b-4720264fddbd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:12:05','2026-01-31 08:12:19','2026-01-31 08:12:19',1,'09ad1680-f3f2-4edb-93a4-01a6ecd4a735','0a2f77d6-6ebd-4e32-8f3a-3b8197764510','compute-2.ctlplane.example.com','702e2506-8d57-4ea2-b56e-1800da93f646','/dev/vdb','2026-01-31 08:12:07','2026-01-31 08:12:19','rw','detached','{\"name\": \"volumes/volume-0a2f77d6-6ebd-4e32-8f3a-3b8197764510\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"0a2f77d6-6ebd-4e32-8f3a-3b8197764510\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"09ad1680-f3f2-4edb-93a4-01a6ecd4a735\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:31:44','2026-01-31 08:32:19','2026-01-31 08:32:19',1,'0f56aada-8f7d-4f1b-be22-beb78a3a90f0','901896ec-4cee-48ca-89ea-1ef061e9fbf3','compute-0.ctlplane.example.com','a15175ec-85fd-457c-870b-8a6d7c13c906','/dev/vdb','2026-01-31 08:32:02','2026-01-31 08:32:19','rw','detached','{\"name\": \"volumes/volume-901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0f56aada-8f7d-4f1b-be22-beb78a3a90f0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:06:19','2026-01-31 08:06:25','2026-01-31 08:06:25',1,'106b3c9a-2ab8-4dc4-9402-36555746d006','cfc0e54a-67e2-4096-bf5e-8287b1e5add7','compute-1.ctlplane.example.com','2d00dd71-0bdd-41cb-b673-26806329b43a','/dev/vdb','2026-01-31 08:06:20','2026-01-31 08:06:25','rw','detached','{\"name\": \"volumes/volume-cfc0e54a-67e2-4096-bf5e-8287b1e5add7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"cfc0e54a-67e2-4096-bf5e-8287b1e5add7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"106b3c9a-2ab8-4dc4-9402-36555746d006\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:24:23','2026-01-31 08:26:06','2026-01-31 08:26:06',1,'13da4cb4-931b-4f9d-98dc-452bf3204cfa','b717b315-86df-4d2d-96bf-25aba2759093','compute-1.ctlplane.example.com','4627608a-03b0-4a7e-bcb3-b709dade0334','/dev/vda','2026-01-31 08:24:28','2026-01-31 08:26:06','rw','detached','{\"name\": \"volumes/volume-b717b315-86df-4d2d-96bf-25aba2759093\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"b717b315-86df-4d2d-96bf-25aba2759093\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"13da4cb4-931b-4f9d-98dc-452bf3204cfa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:14:26','2026-01-31 08:16:56','2026-01-31 08:16:56',1,'1c386108-15cc-4ed2-a90d-edf67d939cb8','284ce110-dc52-4bb8-b8bc-a99864f7d576','compute-0.ctlplane.example.com','85e16f4c-d977-4032-9cbd-b904f1d789d4','/dev/vda','2026-01-31 08:14:38','2026-01-31 08:16:56','rw','detached','{\"name\": \"volumes/volume-284ce110-dc52-4bb8-b8bc-a99864f7d576\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"284ce110-dc52-4bb8-b8bc-a99864f7d576\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1c386108-15cc-4ed2-a90d-edf67d939cb8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:07:49','2026-01-31 09:08:42','2026-01-31 09:08:42',1,'1e8a006a-1f38-4a26-bda1-eb725330d2b7','64b37453-b9c7-425d-8ee1-936836c623a8','compute-0.ctlplane.example.com','e5867604-e99e-4623-8c07-a3ca7d95fe78','/dev/vda','2026-01-31 09:07:53','2026-01-31 09:08:42','rw','detached','{\"name\": \"volumes/volume-64b37453-b9c7-425d-8ee1-936836c623a8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"64b37453-b9c7-425d-8ee1-936836c623a8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1e8a006a-1f38-4a26-bda1-eb725330d2b7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:14:17','2026-01-31 08:14:54','2026-01-31 08:14:54',1,'22941b24-fd9c-4016-a0c7-7f7c7feacdf9','a072271f-7f43-470f-93ee-c6396eaabeba','compute-0.ctlplane.example.com','8a8d8223-9051-487a-a4d6-a33911813797','/dev/vda','2026-01-31 08:14:26','2026-01-31 08:14:54','rw','detached','{\"name\": \"volumes/volume-a072271f-7f43-470f-93ee-c6396eaabeba\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"a072271f-7f43-470f-93ee-c6396eaabeba\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"22941b24-fd9c-4016-a0c7-7f7c7feacdf9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:55:44','2026-01-31 08:56:15','2026-01-31 08:56:15',1,'28be5535-fab0-4ea0-8c5d-e062c6ff531d','9bc3cb04-a48c-40bd-81ea-100007bee62c','compute-0.ctlplane.example.com','c91674d0-7f78-4e09-b54e-e46f7fbd65a3','/dev/vdb','2026-01-31 08:55:45','2026-01-31 08:56:15','rw','detached','{\"name\": \"volumes/volume-9bc3cb04-a48c-40bd-81ea-100007bee62c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"9bc3cb04-a48c-40bd-81ea-100007bee62c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"28be5535-fab0-4ea0-8c5d-e062c6ff531d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:18:19','2026-01-31 09:18:23','2026-01-31 09:18:23',1,'2ae9d449-0fd6-46de-870e-c46c37894cb9','9c54af70-f6c6-42c1-90a6-95ba3f7c6db1','compute-1.ctlplane.example.com','7f870e76-5f0a-46db-b844-1788cc790f7c','/dev/vdb','2026-01-31 09:18:20','2026-01-31 09:18:23','rw','detached','{\"name\": \"volumes/volume-9c54af70-f6c6-42c1-90a6-95ba3f7c6db1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"9c54af70-f6c6-42c1-90a6-95ba3f7c6db1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2ae9d449-0fd6-46de-870e-c46c37894cb9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:56:38','2026-01-31 08:57:12','2026-01-31 08:57:12',1,'2f60e240-67fa-428c-9862-a5b1a48923bc','75a603c9-1c6b-4103-ac69-0db6813e7404','compute-2.ctlplane.example.com','e9903ecf-c775-4e84-8997-361061869fc6','/dev/vdc','2026-01-31 08:56:41','2026-01-31 08:57:12','rw','detached','{\"name\": \"volumes/volume-75a603c9-1c6b-4103-ac69-0db6813e7404\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"75a603c9-1c6b-4103-ac69-0db6813e7404\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2f60e240-67fa-428c-9862-a5b1a48923bc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:47:38','2026-01-31 08:47:50','2026-01-31 08:47:50',1,'30edc071-5fcd-4a34-a0e2-82228dd04330','dad97247-8d79-4c56-b9b0-e61729262e21','compute-0.ctlplane.example.com','3308d345-19b7-4fbb-bd81-631135649e7d','/dev/vdb','2026-01-31 08:47:40','2026-01-31 08:47:50','rw','detached','{\"name\": \"volumes/volume-dad97247-8d79-4c56-b9b0-e61729262e21\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"dad97247-8d79-4c56-b9b0-e61729262e21\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"30edc071-5fcd-4a34-a0e2-82228dd04330\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:25:55','2026-01-31 08:27:10','2026-01-31 08:27:10',1,'395572e4-5b80-4c49-b44a-e3d5caf7062e','40098f2d-bf66-4831-bd6c-f4f5c78b699e','compute-1.ctlplane.example.com','f3b36b5b-968c-4775-ac4f-93efc36f40ac','/dev/vdc','2026-01-31 08:26:02','2026-01-31 08:27:10','rw','detached','{\"name\": \"volumes/volume-40098f2d-bf66-4831-bd6c-f4f5c78b699e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"40098f2d-bf66-4831-bd6c-f4f5c78b699e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"395572e4-5b80-4c49-b44a-e3d5caf7062e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:56:33','2026-01-31 08:57:08','2026-01-31 08:57:08',1,'396f2e87-48dc-48be-8d15-2b3c3ca6fce3','985c0898-7bd0-457c-b3bb-abe45d65168a','compute-2.ctlplane.example.com','e9903ecf-c775-4e84-8997-361061869fc6','/dev/vdb','2026-01-31 08:56:35','2026-01-31 08:57:08','rw','detached','{\"name\": \"volumes/volume-985c0898-7bd0-457c-b3bb-abe45d65168a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"985c0898-7bd0-457c-b3bb-abe45d65168a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"396f2e87-48dc-48be-8d15-2b3c3ca6fce3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:56:45','2026-01-31 07:57:07','2026-01-31 07:57:07',1,'3df5a4ea-9863-4a70-94e7-37a47bc480d7','bd6a018f-eaef-43b9-b78d-313bb85c40fa','compute-0.ctlplane.example.com','9ba5b3e0-db8e-489f-bb9e-3697ab066ae4','/dev/vdb','2026-01-31 07:56:47','2026-01-31 07:57:07','rw','detached','{\"name\": \"volumes/volume-bd6a018f-eaef-43b9-b78d-313bb85c40fa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"bd6a018f-eaef-43b9-b78d-313bb85c40fa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3df5a4ea-9863-4a70-94e7-37a47bc480d7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:51:47','2026-01-31 08:52:13','2026-01-31 08:52:13',1,'45735b27-dd0f-4d41-be36-8e24eedc76fa','f7e6afdb-ed5e-4762-ad08-3a1fceda6276','compute-0.ctlplane.example.com','cabe126e-f3af-4113-9463-6dde2833448e','/dev/vda','2026-01-31 08:51:51','2026-01-31 08:52:13','rw','detached','{\"name\": \"volumes/volume-f7e6afdb-ed5e-4762-ad08-3a1fceda6276\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"f7e6afdb-ed5e-4762-ad08-3a1fceda6276\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"45735b27-dd0f-4d41-be36-8e24eedc76fa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:49:48','2026-01-31 07:50:37','2026-01-31 07:50:37',1,'4b9eb10a-fc66-42c4-9e17-3b8136950b54','317b1c6b-4f89-402c-94d1-f4852844f1e2','compute-2.ctlplane.example.com','79350fb7-3eed-4a3b-a7e9-f0ec90460ac3','/dev/vda','2026-01-31 07:49:55','2026-01-31 07:50:37','rw','detached','{\"name\": \"volumes/volume-317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4b9eb10a-fc66-42c4-9e17-3b8136950b54\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:49:27','2026-01-31 08:50:53','2026-01-31 08:50:53',1,'57220f93-bfdc-48e9-b764-46da2fb97690','12e9d9b2-8ec9-4b16-b334-60c0f639cb59','compute-1.ctlplane.example.com','4af4043c-8199-4d0f-acf9-38d029560167','/dev/vdb','2026-01-31 08:49:31','2026-01-31 08:50:53','rw','detached','{\"name\": \"volumes/volume-12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"57220f93-bfdc-48e9-b764-46da2fb97690\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:55:37','2026-01-31 08:58:13','2026-01-31 08:58:13',1,'5aeae977-62f2-4ef6-a868-d5612d941b40','a6407347-cd1c-4e32-a08c-1836a1f51dd6','compute-1.ctlplane.example.com','13eea30b-7972-4da3-a3dd-8d068b401d22','/dev/vda','2026-01-31 08:55:43','2026-01-31 08:58:13','rw','detached','{\"name\": \"volumes/volume-a6407347-cd1c-4e32-a08c-1836a1f51dd6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"a6407347-cd1c-4e32-a08c-1836a1f51dd6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5aeae977-62f2-4ef6-a868-d5612d941b40\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:14:51','2026-01-31 08:17:39','2026-01-31 08:17:39',1,'639386f7-bb08-40e2-b25b-04efc71b9a52','785fba22-460b-4d01-b053-ffec518020b7','compute-1.ctlplane.example.com','b49dd2dc-476a-42c6-89f3-868e238698f2','/dev/vdc','2026-01-31 08:15:21','2026-01-31 08:17:39','rw','detached','{\"name\": \"volumes/volume-785fba22-460b-4d01-b053-ffec518020b7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"785fba22-460b-4d01-b053-ffec518020b7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"639386f7-bb08-40e2-b25b-04efc71b9a52\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:29:32','2026-01-31 08:29:36','2026-01-31 08:29:36',1,'6e7ebac0-07a5-4653-b565-763748de72d7','2b231354-b9f3-4583-b7a7-f3ea6fa9f24a',NULL,'b9f38b79-63fc-48a1-a367-6998b8d6a9dc',NULL,NULL,'2026-01-31 08:29:36','null','detached','{}',NULL),('2026-01-31 08:38:25','2026-01-31 08:39:18','2026-01-31 08:39:18',1,'762750a1-b67d-4b15-a2ca-e926ab33383d','7ff7e47c-5991-4995-b62d-9010ad81e5bf','compute-2.ctlplane.example.com','91f04a93-ce38-4962-919b-e1ac0677b4da','/dev/vda','2026-01-31 08:38:47','2026-01-31 08:39:18','rw','detached','{\"name\": \"volumes/volume-7ff7e47c-5991-4995-b62d-9010ad81e5bf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"7ff7e47c-5991-4995-b62d-9010ad81e5bf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"762750a1-b67d-4b15-a2ca-e926ab33383d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:55:30','2026-01-31 08:58:17','2026-01-31 08:58:17',1,'7b2664a9-418c-44ac-a39c-1552e9d00485','49519e92-9c10-4ba7-87c3-e1349e72980c','compute-2.ctlplane.example.com','e9903ecf-c775-4e84-8997-361061869fc6','/dev/vda','2026-01-31 08:55:34','2026-01-31 08:58:17','rw','detached','{\"name\": \"volumes/volume-49519e92-9c10-4ba7-87c3-e1349e72980c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"49519e92-9c10-4ba7-87c3-e1349e72980c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7b2664a9-418c-44ac-a39c-1552e9d00485\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:49:53','2026-01-31 08:51:26','2026-01-31 08:51:26',1,'7f98d534-1a06-4734-ad8c-53eed8ab4746','12e9d9b2-8ec9-4b16-b334-60c0f639cb59','compute-0.ctlplane.example.com','c215327f-37ad-41a7-a883-3dbb23334df6','/dev/vdb','2026-01-31 08:50:01','2026-01-31 08:51:26','rw','detached','{\"name\": \"volumes/volume-12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7f98d534-1a06-4734-ad8c-53eed8ab4746\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:05:23','2026-01-31 09:05:58','2026-01-31 09:05:58',1,'825aef87-7f0c-42d5-af7a-3bc39e839174','f3799711-34bd-4212-9be5-a6ded13ee858','compute-2.ctlplane.example.com','7255c305-4d2b-4335-9af0-2be77f7f097a','/dev/vda','2026-01-31 09:05:27','2026-01-31 09:05:58','rw','detached','{\"name\": \"volumes/volume-f3799711-34bd-4212-9be5-a6ded13ee858\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"f3799711-34bd-4212-9be5-a6ded13ee858\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"825aef87-7f0c-42d5-af7a-3bc39e839174\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:51:35','2026-01-31 08:51:42','2026-01-31 08:51:42',1,'873450d2-bb75-4778-8a37-fec32bf0cd39','0de0b2ab-99ec-43cf-a8f3-b54f9bb71e28','compute-0.ctlplane.example.com','dd9d93b2-c532-41d7-afab-4944d84afd07','/dev/vdb','2026-01-31 08:51:37','2026-01-31 08:51:42','rw','detached','{\"name\": \"volumes/volume-0de0b2ab-99ec-43cf-a8f3-b54f9bb71e28\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"0de0b2ab-99ec-43cf-a8f3-b54f9bb71e28\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"873450d2-bb75-4778-8a37-fec32bf0cd39\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:52:32','2026-01-31 08:52:38','2026-01-31 08:52:38',1,'87a06692-0b3d-4740-a9ca-ef3072df60ea','9af5cb67-e1aa-49f9-909d-b9b2d8642543','compute-1.ctlplane.example.com','1e30fc0d-e774-4cad-b497-496833551f8b','/dev/vdb','2026-01-31 08:52:34','2026-01-31 08:52:38','rw','detached','{\"name\": \"volumes/volume-9af5cb67-e1aa-49f9-909d-b9b2d8642543\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"9af5cb67-e1aa-49f9-909d-b9b2d8642543\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"87a06692-0b3d-4740-a9ca-ef3072df60ea\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:32:18','2026-01-31 08:33:00','2026-01-31 08:32:59',1,'88f848a3-4362-4a8e-8117-5b16a2ea4b45','901896ec-4cee-48ca-89ea-1ef061e9fbf3','compute-2.ctlplane.example.com','a15175ec-85fd-457c-870b-8a6d7c13c906','/dev/vdb','2026-01-31 08:32:32','2026-01-31 08:32:59','rw','detached','{\"name\": \"volumes/volume-901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"88f848a3-4362-4a8e-8117-5b16a2ea4b45\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:55:04','2026-01-31 08:55:42','2026-01-31 08:55:42',1,'89694797-7609-4300-be9a-9184bf1e68fc','95b6d139-2444-4c12-8219-f46fb97d8a4d','compute-1.ctlplane.example.com','c4e77744-5254-4a68-8cdf-49fce00d7b32','/dev/vdb','2026-01-31 08:55:06','2026-01-31 08:55:42','rw','detached','{\"name\": \"volumes/volume-95b6d139-2444-4c12-8219-f46fb97d8a4d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"95b6d139-2444-4c12-8219-f46fb97d8a4d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"89694797-7609-4300-be9a-9184bf1e68fc\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:03:36','2026-01-31 09:05:44','2026-01-31 09:05:44',1,'89d38aa9-30c7-4827-aeb5-f11a82443d9e','47ca8e30-e640-4fca-a274-67bf157244e9','compute-2.ctlplane.example.com','05185cfd-db91-4d53-8ae4-57a005be337f','/dev/vda','2026-01-31 09:03:41','2026-01-31 09:05:44','rw','detached','{\"name\": \"volumes/volume-47ca8e30-e640-4fca-a274-67bf157244e9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"47ca8e30-e640-4fca-a274-67bf157244e9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"89d38aa9-30c7-4827-aeb5-f11a82443d9e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:50:52','2026-01-31 08:51:29','2026-01-31 08:51:29',1,'8c5fdaa4-59ab-4375-b3a7-84593a1767e7','12e9d9b2-8ec9-4b16-b334-60c0f639cb59','compute-2.ctlplane.example.com','4af4043c-8199-4d0f-acf9-38d029560167','/dev/vdb','2026-01-31 08:51:00','2026-01-31 08:51:29','rw','detached','{\"name\": \"volumes/volume-12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8c5fdaa4-59ab-4375-b3a7-84593a1767e7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:51:15','2026-01-31 07:51:37','2026-01-31 07:51:37',1,'8ef00fa7-0a9d-4b9d-a55b-c51a95ca76eb','74f8a6d0-259e-466b-a484-4c7bffded2e1','compute-2.ctlplane.example.com','4b48cc05-9edd-4e4d-a58e-84564afb0612','/dev/vda','2026-01-31 07:51:16','2026-01-31 07:51:37','null','detached','{\"name\": \"volumes/volume-74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8ef00fa7-0a9d-4b9d-a55b-c51a95ca76eb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 09:00:00','2026-01-31 09:01:43','2026-01-31 09:01:43',1,'8f74dbe0-01a0-43a5-af76-f10e47f68a95','b7cfb970-aa00-4ab7-b895-9c828f0058d5','compute-1.ctlplane.example.com','fd777b00-402f-4a2e-8a77-2b61c7cf5484','/dev/vdb','2026-01-31 09:00:03','2026-01-31 09:01:43','rw','detached','{\"name\": \"volumes/volume-b7cfb970-aa00-4ab7-b895-9c828f0058d5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"b7cfb970-aa00-4ab7-b895-9c828f0058d5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8f74dbe0-01a0-43a5-af76-f10e47f68a95\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:13:28','2026-01-31 08:14:17','2026-01-31 08:14:17',1,'8fc86e4a-4e40-4c18-a9f7-f380e5c59b91','a072271f-7f43-470f-93ee-c6396eaabeba','compute-1.ctlplane.example.com','8a8d8223-9051-487a-a4d6-a33911813797','/dev/vda','2026-01-31 08:13:33','2026-01-31 08:14:17','rw','detached','{\"name\": \"volumes/volume-a072271f-7f43-470f-93ee-c6396eaabeba\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"a072271f-7f43-470f-93ee-c6396eaabeba\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8fc86e4a-4e40-4c18-a9f7-f380e5c59b91\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:57:24','2026-01-31 08:57:49','2026-01-31 08:57:49',1,'925cdaee-f41e-4e28-b342-9bac89a792d6','7ad3b3fb-6194-4162-90c8-c3ac9c4017d9','compute-1.ctlplane.example.com','13eea30b-7972-4da3-a3dd-8d068b401d22','/dev/vdc','2026-01-31 08:57:26','2026-01-31 08:57:49','rw','detached','{\"name\": \"volumes/volume-7ad3b3fb-6194-4162-90c8-c3ac9c4017d9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"7ad3b3fb-6194-4162-90c8-c3ac9c4017d9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"925cdaee-f41e-4e28-b342-9bac89a792d6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:49:22','2026-01-31 08:49:53','2026-01-31 08:49:53',1,'94195552-eaf2-4abd-8796-9ad3f1747392','12e9d9b2-8ec9-4b16-b334-60c0f639cb59','compute-2.ctlplane.example.com','c215327f-37ad-41a7-a883-3dbb23334df6','/dev/vdb','2026-01-31 08:49:25','2026-01-31 08:49:53','rw','detached','{\"name\": \"volumes/volume-12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"12e9d9b2-8ec9-4b16-b334-60c0f639cb59\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"94195552-eaf2-4abd-8796-9ad3f1747392\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:56:51','2026-01-31 07:57:04','2026-01-31 07:57:04',1,'97209046-c543-451c-84de-69e19e0a38d6','bd6a018f-eaef-43b9-b78d-313bb85c40fa','compute-2.ctlplane.example.com','0eb7d937-6381-4fca-88d8-57be8d3f0a29','/dev/vdb','2026-01-31 07:56:54','2026-01-31 07:57:04','rw','detached','{\"name\": \"volumes/volume-bd6a018f-eaef-43b9-b78d-313bb85c40fa\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"bd6a018f-eaef-43b9-b78d-313bb85c40fa\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"97209046-c543-451c-84de-69e19e0a38d6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:17:11','2026-01-31 09:17:16','2026-01-31 09:17:16',1,'a1d2d07f-2336-4c5f-8374-d3dd56faf296','bb545a69-3527-4e10-b1af-2e7b80d9ad14','compute-0.ctlplane.example.com','4e6fd1c3-3988-4a7f-a30d-b599226c25a0','/dev/vdb','2026-01-31 09:17:12','2026-01-31 09:17:16','rw','detached','{\"name\": \"volumes/volume-bb545a69-3527-4e10-b1af-2e7b80d9ad14\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"bb545a69-3527-4e10-b1af-2e7b80d9ad14\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a1d2d07f-2336-4c5f-8374-d3dd56faf296\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:57:19','2026-01-31 08:57:31','2026-01-31 08:57:31',1,'a697c025-cb73-4bcc-b4d8-801e4a7d6792','af751b83-d2b1-494f-9ebb-7edf7087a67c','compute-2.ctlplane.example.com','b23e0349-42a8-41d0-9eea-0407b7ffa806','/dev/vdb','2026-01-31 08:57:21','2026-01-31 08:57:31','rw','detached','{\"name\": \"volumes/volume-af751b83-d2b1-494f-9ebb-7edf7087a67c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"af751b83-d2b1-494f-9ebb-7edf7087a67c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a697c025-cb73-4bcc-b4d8-801e4a7d6792\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:14:27','2026-01-31 08:16:57','2026-01-31 08:16:57',1,'a923619c-0654-4d34-b06f-aa3c0335a84b','8211a79e-7243-4aef-aa8b-c47974e4d749','compute-0.ctlplane.example.com','85e16f4c-d977-4032-9cbd-b904f1d789d4','/dev/vdc','2026-01-31 08:14:42','2026-01-31 08:16:57','rw','detached','{\"name\": \"volumes/volume-8211a79e-7243-4aef-aa8b-c47974e4d749\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"8211a79e-7243-4aef-aa8b-c47974e4d749\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a923619c-0654-4d34-b06f-aa3c0335a84b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:57:21','2026-01-31 08:57:45','2026-01-31 08:57:45',1,'aa1d962e-7bc0-433c-97e5-8f3d078d07b8','a91dfbd1-af86-4b71-b911-f9af43fa9cd7','compute-1.ctlplane.example.com','13eea30b-7972-4da3-a3dd-8d068b401d22','/dev/vdb','2026-01-31 08:57:22','2026-01-31 08:57:45','rw','detached','{\"name\": \"volumes/volume-a91dfbd1-af86-4b71-b911-f9af43fa9cd7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"a91dfbd1-af86-4b71-b911-f9af43fa9cd7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"aa1d962e-7bc0-433c-97e5-8f3d078d07b8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:50:00','2026-01-31 08:51:01','2026-01-31 08:51:01',1,'abe8a4d4-2e89-47c0-95db-cc7ace6869f7','756cf314-0b1f-46f3-bdfa-a0682d03b570','compute-1.ctlplane.example.com','84307a3a-98ff-4145-a789-fda9cf8b1905','/dev/vdb','2026-01-31 08:50:02','2026-01-31 08:51:01','rw','detached','{\"name\": \"volumes/volume-756cf314-0b1f-46f3-bdfa-a0682d03b570\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"756cf314-0b1f-46f3-bdfa-a0682d03b570\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"abe8a4d4-2e89-47c0-95db-cc7ace6869f7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:02:38','2026-01-31 09:03:35','2026-01-31 09:03:35',1,'b03c76af-04e1-4d0c-8319-5cca406eaf79','766e40b4-9f67-4558-bd4a-c5d2d46d1ef1','compute-0.ctlplane.example.com','2fbbeeee-ff60-4a39-9bea-e3d59301b0ad','/dev/vda','2026-01-31 09:02:50','2026-01-31 09:03:35','rw','detached','{\"name\": \"volumes/volume-766e40b4-9f67-4558-bd4a-c5d2d46d1ef1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"766e40b4-9f67-4558-bd4a-c5d2d46d1ef1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b03c76af-04e1-4d0c-8319-5cca406eaf79\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:49:17','2026-01-31 08:50:36','2026-01-31 08:50:36',1,'b098b19f-6dce-4976-a847-3c46824f709e','528b148a-172a-43e7-8be2-21819c2d44e5','compute-0.ctlplane.example.com','74f09648-834b-4da1-89a4-bcdcca255908','/dev/vdb','2026-01-31 08:49:20','2026-01-31 08:50:36','rw','detached','{\"name\": \"volumes/volume-528b148a-172a-43e7-8be2-21819c2d44e5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"528b148a-172a-43e7-8be2-21819c2d44e5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b098b19f-6dce-4976-a847-3c46824f709e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:04:46','2026-01-31 09:05:36','2026-01-31 09:05:36',1,'bb9add01-1136-49a5-ade8-ee21559c0532','5fdc5138-2006-48ee-b966-42f286bea7e1','compute-1.ctlplane.example.com','69fccdf1-17df-4c1f-8408-5f8b451e95e9','/dev/vda','2026-01-31 09:04:48','2026-01-31 09:05:36','rw','detached','{\"name\": \"volumes/volume-5fdc5138-2006-48ee-b966-42f286bea7e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"5fdc5138-2006-48ee-b966-42f286bea7e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bb9add01-1136-49a5-ade8-ee21559c0532\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:52:41','2026-01-31 07:52:48','2026-01-31 07:52:48',1,'bfa23ad9-7293-4402-b518-12c0a1ae25da','7df70e23-e53e-4df4-8aa9-3917f141bf82','compute-1.ctlplane.example.com','104c67e8-fcdb-4437-9060-8d66250d4c46','/dev/sdc','2026-01-31 07:52:43','2026-01-31 07:52:48','rw','detached','{\"name\": \"volumes/volume-7df70e23-e53e-4df4-8aa9-3917f141bf82\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"7df70e23-e53e-4df4-8aa9-3917f141bf82\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bfa23ad9-7293-4402-b518-12c0a1ae25da\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2026-01-31 07:50:29','2026-01-31 07:51:04','2026-01-31 07:51:04',1,'c20de688-0876-4e49-80fa-40bec74574ff','317b1c6b-4f89-402c-94d1-f4852844f1e2','compute-1.ctlplane.example.com','79350fb7-3eed-4a3b-a7e9-f0ec90460ac3','/dev/vda','2026-01-31 07:50:30','2026-01-31 07:51:04','null','detached','{\"name\": \"volumes/volume-317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c20de688-0876-4e49-80fa-40bec74574ff\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 08:31:20','2026-01-31 08:31:44','2026-01-31 08:31:44',1,'c7f45505-bd56-4ce4-b729-5f7effde355f','901896ec-4cee-48ca-89ea-1ef061e9fbf3','compute-2.ctlplane.example.com','a15175ec-85fd-457c-870b-8a6d7c13c906','/dev/vdb','2026-01-31 08:31:24','2026-01-31 08:31:44','rw','detached','{\"name\": \"volumes/volume-901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"901896ec-4cee-48ca-89ea-1ef061e9fbf3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c7f45505-bd56-4ce4-b729-5f7effde355f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 09:02:32','2026-01-31 09:02:53','2026-01-31 09:02:53',1,'cd9bf7d3-fc9f-40e2-b948-4891744e03c7','d9130530-fbc3-4fb7-957a-e45c619660f3','compute-1.ctlplane.example.com','8828ce70-2ab6-41e3-ad2a-51031d11bf31','/dev/vda','2026-01-31 09:02:35','2026-01-31 09:02:53','rw','detached','{\"name\": \"volumes/volume-d9130530-fbc3-4fb7-957a-e45c619660f3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"d9130530-fbc3-4fb7-957a-e45c619660f3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cd9bf7d3-fc9f-40e2-b948-4891744e03c7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:11:57','2026-01-31 08:12:05','2026-01-31 08:12:05',1,'cefb6509-31de-4a4e-8fa0-03a3823c06e1','0a2f77d6-6ebd-4e32-8f3a-3b8197764510','compute-2.ctlplane.example.com','702e2506-8d57-4ea2-b56e-1800da93f646','/dev/vdb','2026-01-31 08:11:58','2026-01-31 08:12:05','rw','detached','{\"name\": \"volumes/volume-0a2f77d6-6ebd-4e32-8f3a-3b8197764510\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"0a2f77d6-6ebd-4e32-8f3a-3b8197764510\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cefb6509-31de-4a4e-8fa0-03a3823c06e1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:14:27','2026-01-31 08:16:57','2026-01-31 08:16:57',1,'d453934a-08bc-4abf-8da8-a0387ae6dcf7','f3cb4822-8f33-4837-8242-54aa49d653b7','compute-0.ctlplane.example.com','85e16f4c-d977-4032-9cbd-b904f1d789d4','/dev/vdb','2026-01-31 08:14:39','2026-01-31 08:16:57','rw','detached','{\"name\": \"volumes/volume-f3cb4822-8f33-4837-8242-54aa49d653b7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"f3cb4822-8f33-4837-8242-54aa49d653b7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d453934a-08bc-4abf-8da8-a0387ae6dcf7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:39:33','2026-01-31 08:40:44','2026-01-31 08:40:44',1,'d494679e-1143-4c39-9b30-80982cf8b475','3b63f0e3-6562-4449-962b-ff0c0228f219','compute-0.ctlplane.example.com','92bd94ef-0031-409f-8c26-23d5f3d952e1','/dev/vdb','2026-01-31 08:39:36','2026-01-31 08:40:44','rw','detached','{\"name\": \"volumes/volume-3b63f0e3-6562-4449-962b-ff0c0228f219\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"3b63f0e3-6562-4449-962b-ff0c0228f219\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d494679e-1143-4c39-9b30-80982cf8b475\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:21:03','2026-01-31 08:27:23','2026-01-31 08:27:23',1,'d62d58cb-62c8-4814-ab07-94c3742a7f65','afd3af33-f7a2-401c-9400-47dff922d4f4','compute-0.ctlplane.example.com','23200b4a-e522-43bf-a83e-cb2f9bb31571','/dev/vda','2026-01-31 08:21:05','2026-01-31 08:27:23','rw','detached','{\"name\": \"volumes/volume-afd3af33-f7a2-401c-9400-47dff922d4f4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"afd3af33-f7a2-401c-9400-47dff922d4f4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d62d58cb-62c8-4814-ab07-94c3742a7f65\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:55:24','2026-01-31 08:58:24','2026-01-31 08:58:24',1,'d748cdef-8b51-4810-ba5d-5cc0bc71c23f','26d9ea85-55bc-4b3b-b5ad-d60d188212c2','compute-0.ctlplane.example.com','c91674d0-7f78-4e09-b54e-e46f7fbd65a3','/dev/vda','2026-01-31 08:55:31','2026-01-31 08:58:24','rw','detached','{\"name\": \"volumes/volume-26d9ea85-55bc-4b3b-b5ad-d60d188212c2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"26d9ea85-55bc-4b3b-b5ad-d60d188212c2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d748cdef-8b51-4810-ba5d-5cc0bc71c23f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:50:53','2026-01-31 07:51:24','2026-01-31 07:51:24',1,'d7c0bc0f-56fc-48ef-b4c0-155ffe70671f','317b1c6b-4f89-402c-94d1-f4852844f1e2','compute-2.ctlplane.example.com','79350fb7-3eed-4a3b-a7e9-f0ec90460ac3','/dev/vda','2026-01-31 07:50:54','2026-01-31 07:51:24','null','detached','{\"name\": \"volumes/volume-317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"317b1c6b-4f89-402c-94d1-f4852844f1e2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d7c0bc0f-56fc-48ef-b4c0-155ffe70671f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 08:12:10','2026-01-31 08:12:15','2026-01-31 08:12:15',1,'d99a2a8d-ec49-470e-8e1e-15a8ba4bf847','551f775f-0622-435f-b9d7-dcb85f156132','compute-0.ctlplane.example.com','aa734433-4d60-4a63-9587-234fea7bc0d1','/dev/vdb','2026-01-31 08:12:11','2026-01-31 08:12:15','rw','detached','{\"name\": \"volumes/volume-551f775f-0622-435f-b9d7-dcb85f156132\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"551f775f-0622-435f-b9d7-dcb85f156132\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d99a2a8d-ec49-470e-8e1e-15a8ba4bf847\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:45:26','2026-01-31 07:45:31','2026-01-31 07:45:31',1,'da007980-b3ca-4562-bd1c-c04d4ec6098e','c3f8bc09-4bc5-4545-abcc-da259a7bb1ed','compute-0.ctlplane.example.com','b2c254bb-3943-440e-8ca2-306e8777083f','/dev/vdb','2026-01-31 07:45:28','2026-01-31 07:45:31','rw','detached','{\"name\": \"volumes/volume-c3f8bc09-4bc5-4545-abcc-da259a7bb1ed\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"c3f8bc09-4bc5-4545-abcc-da259a7bb1ed\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"da007980-b3ca-4562-bd1c-c04d4ec6098e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 07:49:47','2026-01-31 07:50:56','2026-01-31 07:50:56',1,'da773656-1631-4e7b-855d-ed146c908f6b','74f8a6d0-259e-466b-a484-4c7bffded2e1','compute-2.ctlplane.example.com','4b48cc05-9edd-4e4d-a58e-84564afb0612','/dev/vda','2026-01-31 07:49:55','2026-01-31 07:50:56','rw','detached','{\"name\": \"volumes/volume-74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"da773656-1631-4e7b-855d-ed146c908f6b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:02:41','2026-01-31 09:04:05','2026-01-31 09:04:05',1,'dc3bb77a-cc57-4f7c-aec0-f53e1801fccd','881e1975-bbbe-4bd4-b026-dc1919960757','compute-1.ctlplane.example.com','83cae6c9-b20c-4ec6-9f1c-5cf06dabdde6','/dev/vdb','2026-01-31 09:02:43','2026-01-31 09:04:05','rw','detached','{\"name\": \"volumes/volume-881e1975-bbbe-4bd4-b026-dc1919960757\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"881e1975-bbbe-4bd4-b026-dc1919960757\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dc3bb77a-cc57-4f7c-aec0-f53e1801fccd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:37:07','2026-01-31 08:38:26','2026-01-31 08:38:26',1,'dcaca1fd-2764-4e7e-a587-8401069935cb','7ff7e47c-5991-4995-b62d-9010ad81e5bf','compute-2.ctlplane.example.com','91f04a93-ce38-4962-919b-e1ac0677b4da','/dev/vda','2026-01-31 08:37:21','2026-01-31 08:38:26','rw','detached','{\"name\": \"volumes/volume-7ff7e47c-5991-4995-b62d-9010ad81e5bf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"7ff7e47c-5991-4995-b62d-9010ad81e5bf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dcaca1fd-2764-4e7e-a587-8401069935cb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:01:45','2026-01-31 09:02:39','2026-01-31 09:02:39',1,'dcfe61c4-06eb-423c-9ffb-cfecfb9cdddb','766e40b4-9f67-4558-bd4a-c5d2d46d1ef1','compute-2.ctlplane.example.com','2fbbeeee-ff60-4a39-9bea-e3d59301b0ad','/dev/vda','2026-01-31 09:01:51','2026-01-31 09:02:39','rw','detached','{\"name\": \"volumes/volume-766e40b4-9f67-4558-bd4a-c5d2d46d1ef1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"766e40b4-9f67-4558-bd4a-c5d2d46d1ef1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dcfe61c4-06eb-423c-9ffb-cfecfb9cdddb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:06:12','2026-01-31 09:06:54','2026-01-31 09:06:54',1,'dd219e33-3c3b-490b-be2d-e751477d9a93','b457f046-29d9-4842-87e2-ad26874ea748','compute-2.ctlplane.example.com','e48e9071-e65c-4dc9-bee0-7d382977f14a','/dev/vda','2026-01-31 09:06:16','2026-01-31 09:06:54','rw','detached','{\"name\": \"volumes/volume-b457f046-29d9-4842-87e2-ad26874ea748\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"b457f046-29d9-4842-87e2-ad26874ea748\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"dd219e33-3c3b-490b-be2d-e751477d9a93\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 09:07:00','2026-01-31 09:08:49','2026-01-31 09:08:49',1,'e215381c-08ee-4176-a743-9d9c114514bb','b457f046-29d9-4842-87e2-ad26874ea748','compute-1.ctlplane.example.com','84bda6d6-4f33-40a6-9f4c-478d073878e1','/dev/vda','2026-01-31 09:07:05','2026-01-31 09:08:49','rw','detached','{\"name\": \"volumes/volume-b457f046-29d9-4842-87e2-ad26874ea748\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"b457f046-29d9-4842-87e2-ad26874ea748\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e215381c-08ee-4176-a743-9d9c114514bb\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:58:51','2026-01-31 07:58:56','2026-01-31 07:58:56',1,'e3151b1e-a19d-4cef-b944-30b818e6b6f5','db1124e5-1a30-4118-a44b-369e05e566a9','compute-2.ctlplane.example.com','ba72fe35-90dd-4806-9195-8a8ff81ae9f0','/dev/vdb','2026-01-31 07:58:53','2026-01-31 07:58:56','rw','detached','{\"name\": \"volumes/volume-db1124e5-1a30-4118-a44b-369e05e566a9\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"db1124e5-1a30-4118-a44b-369e05e566a9\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e3151b1e-a19d-4cef-b944-30b818e6b6f5\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:14:50','2026-01-31 08:17:38','2026-01-31 08:17:38',1,'e6217452-8282-4e11-a078-f705b6777630','20fd9e7c-9700-482e-a6ae-9d5671e6d553','compute-1.ctlplane.example.com','b49dd2dc-476a-42c6-89f3-868e238698f2','/dev/vda','2026-01-31 08:15:16','2026-01-31 08:17:38','rw','detached','{\"name\": \"volumes/volume-20fd9e7c-9700-482e-a6ae-9d5671e6d553\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"20fd9e7c-9700-482e-a6ae-9d5671e6d553\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e6217452-8282-4e11-a078-f705b6777630\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 07:50:50','2026-01-31 07:51:23','2026-01-31 07:51:23',1,'e6430b41-2bd9-4a2a-92ee-fef9061b8529','74f8a6d0-259e-466b-a484-4c7bffded2e1','compute-1.ctlplane.example.com','4b48cc05-9edd-4e4d-a58e-84564afb0612','/dev/vda','2026-01-31 07:50:51','2026-01-31 07:51:23','null','detached','{\"name\": \"volumes/volume-74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"74f8a6d0-259e-466b-a484-4c7bffded2e1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e6430b41-2bd9-4a2a-92ee-fef9061b8529\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2026-01-31 09:01:10','2026-01-31 09:01:40','2026-01-31 09:01:40',1,'f083d67f-52b0-4ca2-941c-f61672efe91d','e4cba400-cc7c-48f0-94b8-a77f724bc898','compute-2.ctlplane.example.com','357f617a-600c-48b2-b5b1-420475f37e61','/dev/vda','2026-01-31 09:01:14','2026-01-31 09:01:40','rw','detached','{\"name\": \"volumes/volume-e4cba400-cc7c-48f0-94b8-a77f724bc898\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"e4cba400-cc7c-48f0-94b8-a77f724bc898\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f083d67f-52b0-4ca2-941c-f61672efe91d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:14:50','2026-01-31 08:17:39','2026-01-31 08:17:39',1,'f60e9547-c27e-4ed8-83d9-7d8315e3b075','e24cf252-b35c-4390-a954-7f28d6e0eaed','compute-1.ctlplane.example.com','b49dd2dc-476a-42c6-89f3-868e238698f2','/dev/vdb','2026-01-31 08:15:19','2026-01-31 08:17:39','rw','detached','{\"name\": \"volumes/volume-e24cf252-b35c-4390-a954-7f28d6e0eaed\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"e24cf252-b35c-4390-a954-7f28d6e0eaed\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f60e9547-c27e-4ed8-83d9-7d8315e3b075\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2026-01-31 08:45:55','2026-01-31 08:53:08','2026-01-31 08:53:08',1,'f7eacdf7-1634-4b3b-b8a3-3de979ab84e4','bf35e6ca-068a-4538-b11a-fe35ddc37a44','compute-2.ctlplane.example.com','0edbf2b9-b76f-446b-85fa-09a4dcb37976','/dev/vda','2026-01-31 08:46:03','2026-01-31 08:53:08','rw','detached','{\"name\": \"volumes/volume-bf35e6ca-068a-4538-b11a-fe35ddc37a44\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"bf35e6ca-068a-4538-b11a-fe35ddc37a44\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f7eacdf7-1634-4b3b-b8a3-3de979ab84e4\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:57:25','2026-01-31 08:57:33','2026-01-31 08:57:33',1,'fb8393c9-ab65-4a4f-89cd-2af5b8d15b45','d8da98d6-6c1a-48c1-8832-4fd207143449','compute-2.ctlplane.example.com','b23e0349-42a8-41d0-9eea-0407b7ffa806','/dev/vdc','2026-01-31 08:57:27','2026-01-31 08:57:33','rw','detached','{\"name\": \"volumes/volume-d8da98d6-6c1a-48c1-8832-4fd207143449\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"d8da98d6-6c1a-48c1-8832-4fd207143449\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fb8393c9-ab65-4a4f-89cd-2af5b8d15b45\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:55:48','2026-01-31 08:56:21','2026-01-31 08:56:21',1,'fbbdb19b-b3ec-44d3-97b3-614efba043dd','f694d315-eb2a-436c-b06d-0d95676e69e3','compute-0.ctlplane.example.com','c91674d0-7f78-4e09-b54e-e46f7fbd65a3','/dev/vdc','2026-01-31 08:55:50','2026-01-31 08:56:21','rw','detached','{\"name\": \"volumes/volume-f694d315-eb2a-436c-b06d-0d95676e69e3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"f694d315-eb2a-436c-b06d-0d95676e69e3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fbbdb19b-b3ec-44d3-97b3-614efba043dd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:9d6ad6ddc476\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e415482-4f51-40cd-acc4-a0d3058a31bb\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2026-01-31 08:09:47','2026-01-31 08:10:22','2026-01-31 08:10:22',1,'fbca7a76-0bf4-4bdc-8716-d63f4ec0ab61','77364634-2150-4955-8185-1bf60ebd89d8','compute-2.ctlplane.example.com','c79a42ab-abd7-41ad-8fb4-784beb525937','/dev/vda','2026-01-31 08:09:50','2026-01-31 08:10:22','rw','detached','{\"name\": \"volumes/volume-77364634-2150-4955-8185-1bf60ebd89d8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"77364634-2150-4955-8185-1bf60ebd89d8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fbca7a76-0bf4-4bdc-8716-d63f4ec0ab61\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:22dda56d75f7\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"4e15465d-7c03-4925-9fc3-ba6a686b7adc\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2026-01-31 08:47:42','2026-01-31 08:47:53','2026-01-31 08:47:53',1,'fce70b36-5636-4d96-85e4-6ab4337847a9','dad97247-8d79-4c56-b9b0-e61729262e21','compute-1.ctlplane.example.com','6fd9c6e1-ddff-436d-b240-240ec06b2a15','/dev/vdb','2026-01-31 08:47:44','2026-01-31 08:47:53','rw','detached','{\"name\": \"volumes/volume-dad97247-8d79-4c56-b9b0-e61729262e21\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"2f5ab832-5f2e-5a84-bd93-cf8bab960ee2\", \"volume_id\": \"dad97247-8d79-4c56-b9b0-e61729262e21\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fce70b36-5636-4d96-85e4-6ab4337847a9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a7d972b74f57\", \"do_local_attach\": false, \"nvme_hostid\": \"0156c751-d05d-449e-959d-30f482d5b822\", \"system uuid\": \"ff96e0bf-56de-4f3e-ba96-02bb86eece1f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:0156c751-d05d-449e-959d-30f482d5b822\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2026-01-31 07:49:29',NULL,'2026-01-31 07:51:32',1,1,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'signature_verified','False'),('2026-01-31 07:49:36',NULL,'2026-01-31 07:51:49',1,2,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'signature_verified','False'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,3,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'hw_rng_model','virtio'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,4,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,5,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,6,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,7,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'container_format','bare'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,8,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'disk_format','qcow2'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,9,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'min_disk','0'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,10,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'min_ram','0'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:32',1,11,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'size','21430272'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,12,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'hw_rng_model','virtio'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,13,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,14,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,15,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,16,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'container_format','bare'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,17,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'disk_format','qcow2'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,18,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'min_disk','0'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,19,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'min_ram','0'),('2026-01-31 07:49:43',NULL,'2026-01-31 07:51:49',1,20,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'size','21430272'),('2026-01-31 08:09:32',NULL,'2026-01-31 08:10:23',1,21,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'signature_verified','False'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,22,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'hw_rng_model','virtio'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,23,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,24,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,25,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,26,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'container_format','bare'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,27,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'disk_format','qcow2'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,28,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'min_disk','0'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,29,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'min_ram','0'),('2026-01-31 08:09:43',NULL,'2026-01-31 08:10:23',1,30,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'size','21430272'),('2026-01-31 08:13:16',NULL,'2026-01-31 08:14:56',1,31,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'signature_verified','False'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,32,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'hw_rng_model','virtio'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,33,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,34,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,35,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,36,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'container_format','bare'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,37,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'disk_format','qcow2'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,38,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'min_disk','0'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,39,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'min_ram','0'),('2026-01-31 08:13:22',NULL,'2026-01-31 08:14:56',1,40,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'size','21430272'),('2026-01-31 08:13:30',NULL,'2026-01-31 08:17:24',1,41,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'signature_verified','False'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,42,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'hw_rng_model','virtio'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,43,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,44,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,45,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,46,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'container_format','bare'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,47,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'disk_format','qcow2'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,48,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'min_disk','0'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,49,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'min_ram','0'),('2026-01-31 08:13:38',NULL,'2026-01-31 08:17:24',1,50,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'size','21430272'),('2026-01-31 08:13:59',NULL,'2026-01-31 08:18:13',1,51,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'signature_verified','False'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,52,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'hw_rng_model','virtio'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,53,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,54,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,55,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,56,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'container_format','bare'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,57,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'disk_format','qcow2'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,58,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'min_disk','0'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,59,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'min_ram','0'),('2026-01-31 08:14:06',NULL,'2026-01-31 08:18:13',1,60,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'size','21430272'),('2026-01-31 08:23:55',NULL,NULL,0,61,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'signature_verified','False'),('2026-01-31 08:24:20',NULL,NULL,0,62,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'hw_rng_model','virtio'),('2026-01-31 08:24:20',NULL,NULL,0,63,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:24:20',NULL,NULL,0,64,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:24:20',NULL,NULL,0,65,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:24:20',NULL,NULL,0,66,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'container_format','bare'),('2026-01-31 08:24:20',NULL,NULL,0,67,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'disk_format','qcow2'),('2026-01-31 08:24:20',NULL,NULL,0,68,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'min_disk','0'),('2026-01-31 08:24:20',NULL,NULL,0,69,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'min_ram','0'),('2026-01-31 08:24:20',NULL,NULL,0,70,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'size','21430272'),('2026-01-31 08:36:53',NULL,'2026-01-31 08:38:43',1,71,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'signature_verified','False'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,72,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'hw_rng_model','virtio'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,73,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,74,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,75,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,76,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'container_format','bare'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,77,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'disk_format','qcow2'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,78,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'min_disk','0'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,79,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'min_ram','0'),('2026-01-31 08:37:03',NULL,'2026-01-31 08:38:43',1,80,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'size','21430272'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,81,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'hw_rng_model','virtio'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,82,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'image_id','0864ca59-9877-4e6d-adfc-f0a3204ed8f8'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,83,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,84,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,85,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'container_format','bare'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,86,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'disk_format','qcow2'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,87,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'min_disk','0'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,88,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'min_ram','0'),('2026-01-31 08:38:43',NULL,'2026-01-31 08:39:21',1,89,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'size','21430272'),('2026-01-31 08:45:39',NULL,'2026-01-31 08:53:14',1,90,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'signature_verified','False'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,91,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'hw_rng_model','virtio'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,92,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,93,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,94,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,95,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'container_format','bare'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,96,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'disk_format','qcow2'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,97,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'min_disk','0'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,98,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'min_ram','0'),('2026-01-31 08:45:47',NULL,'2026-01-31 08:53:14',1,99,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'size','21430272'),('2026-01-31 08:51:37',NULL,'2026-01-31 08:52:17',1,100,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'signature_verified','False'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,101,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'hw_rng_model','virtio'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,102,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,103,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,104,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,105,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'container_format','bare'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,106,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'disk_format','qcow2'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,107,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'min_disk','0'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,108,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'min_ram','0'),('2026-01-31 08:51:43',NULL,'2026-01-31 08:52:17',1,109,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'size','21430272'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,110,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','signature_verified','False'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,111,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','hw_rng_model','virtio'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,112,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,113,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,114,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,115,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','container_format','bare'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,116,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','disk_format','qcow2'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,117,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','min_disk','0'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,118,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','min_ram','0'),('2026-01-31 08:52:05',NULL,'2026-01-31 08:52:16',1,119,NULL,'cf78778e-15b7-4039-9f65-5985e69a326f','size','21430272'),('2026-01-31 08:55:11',NULL,'2026-01-31 08:58:34',1,120,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'signature_verified','False'),('2026-01-31 08:55:16',NULL,'2026-01-31 08:58:32',1,121,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'signature_verified','False'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,122,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'image_id','59ddf935-eb93-411f-a5eb-c6177408c7cf'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,123,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'image_name','tempest-scenario-img--1811671935'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,124,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,125,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'container_format','bare'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,126,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'disk_format','qcow2'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,127,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'min_disk','0'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,128,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'min_ram','0'),('2026-01-31 08:55:19',NULL,'2026-01-31 08:58:34',1,129,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'size','21430272'),('2026-01-31 08:55:20',NULL,'2026-01-31 08:58:29',1,130,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'signature_verified','False'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,131,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'image_id','59ddf935-eb93-411f-a5eb-c6177408c7cf'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,132,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'image_name','tempest-scenario-img--1811671935'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,133,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,134,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'container_format','bare'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,135,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'disk_format','qcow2'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,136,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'min_disk','0'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,137,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'min_ram','0'),('2026-01-31 08:55:22',NULL,'2026-01-31 08:58:32',1,138,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'size','21430272'),('2026-01-31 08:55:27',NULL,'2026-01-31 08:58:29',1,139,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'image_id','59ddf935-eb93-411f-a5eb-c6177408c7cf'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,140,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'image_name','tempest-scenario-img--1811671935'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,141,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,142,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'container_format','bare'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,143,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'disk_format','qcow2'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,144,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'min_disk','0'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,145,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'min_ram','0'),('2026-01-31 08:55:28',NULL,'2026-01-31 08:58:29',1,146,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'size','21430272'),('2026-01-31 09:01:29',NULL,'2026-01-31 09:03:37',1,147,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'signature_verified','False'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,148,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'hw_rng_model','virtio'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,149,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,150,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,151,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,152,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'container_format','bare'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,153,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'disk_format','qcow2'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,154,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'min_disk','0'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,155,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'min_ram','0'),('2026-01-31 09:01:39',NULL,'2026-01-31 09:03:37',1,156,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'size','21430272'),('2026-01-31 09:01:55',NULL,'2026-01-31 09:03:04',1,157,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'signature_verified','False'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,158,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'hw_rng_model','virtio'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,159,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,160,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,161,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,162,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'container_format','bare'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,163,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'disk_format','qcow2'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,164,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'min_disk','0'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,165,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'min_ram','0'),('2026-01-31 09:02:05',NULL,'2026-01-31 09:03:04',1,166,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'size','21430272'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,167,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','signature_verified','False'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,168,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','hw_rng_model','virtio'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,169,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,170,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,171,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,172,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','container_format','bare'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,173,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','disk_format','qcow2'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,174,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','min_disk','0'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,175,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','min_ram','0'),('2026-01-31 09:02:11',NULL,'2026-01-31 09:03:01',1,176,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','size','21430272'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,177,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'signature_verified','False'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,178,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'hw_rng_model','virtio'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,179,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,180,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,181,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,182,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'container_format','bare'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,183,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'disk_format','qcow2'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,184,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'min_disk','0'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,185,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'min_ram','0'),('2026-01-31 09:02:30',NULL,'2026-01-31 09:02:54',1,186,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'size','21430272'),('2026-01-31 09:03:12',NULL,'2026-01-31 09:05:45',1,187,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'signature_verified','False'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,188,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'hw_rng_model','virtio'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,189,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,190,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,191,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,192,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'container_format','bare'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,193,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'disk_format','qcow2'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,194,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'min_disk','0'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,195,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'min_ram','0'),('2026-01-31 09:03:25',NULL,'2026-01-31 09:05:45',1,196,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'size','21430272'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,197,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','signature_verified','False'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,198,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','hw_rng_model','virtio'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,199,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,200,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,201,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,202,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','container_format','bare'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,203,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','disk_format','qcow2'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,204,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','min_disk','0'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,205,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','min_ram','0'),('2026-01-31 09:04:18',NULL,'2026-01-31 09:05:39',1,206,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','size','21430272'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,207,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'signature_verified','False'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,208,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'hw_rng_model','virtio'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,209,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,210,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,211,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,212,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'container_format','bare'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,213,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'disk_format','qcow2'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,214,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'min_disk','0'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,215,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'min_ram','0'),('2026-01-31 09:04:43',NULL,'2026-01-31 09:05:37',1,216,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'size','21430272'),('2026-01-31 09:04:53',NULL,'2026-01-31 09:06:05',1,217,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'signature_verified','False'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,218,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'hw_rng_model','virtio'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,219,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,220,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,221,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,222,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'container_format','bare'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,223,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'disk_format','qcow2'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,224,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'min_disk','0'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,225,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'min_ram','0'),('2026-01-31 09:04:59',NULL,'2026-01-31 09:06:05',1,226,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'size','21430272'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,227,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'signature_verified','False'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,228,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'hw_rng_model','virtio'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,229,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,230,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,231,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,232,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'container_format','bare'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,233,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'disk_format','qcow2'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,234,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'min_disk','0'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,235,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'min_ram','0'),('2026-01-31 09:05:13',NULL,'2026-01-31 09:06:04',1,236,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'size','21430272'),('2026-01-31 09:06:00',NULL,'2026-01-31 09:08:52',1,237,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'signature_verified','False'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,238,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'hw_rng_model','virtio'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,239,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,240,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,241,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,242,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'container_format','bare'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,243,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'disk_format','qcow2'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,244,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'min_disk','0'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,245,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'min_ram','0'),('2026-01-31 09:06:07',NULL,'2026-01-31 09:08:52',1,246,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'size','21430272'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,247,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','signature_verified','False'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,248,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','hw_rng_model','virtio'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,249,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,250,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,251,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,252,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','container_format','bare'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,253,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','disk_format','qcow2'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,254,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','min_disk','0'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,255,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','min_ram','0'),('2026-01-31 09:07:42',NULL,'2026-01-31 09:08:45',1,256,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','size','21430272'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,257,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'signature_verified','False'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,258,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'hw_rng_model','virtio'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,259,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'image_id','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,260,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,261,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,262,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'container_format','bare'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,263,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'disk_format','qcow2'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,264,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'min_disk','0'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,265,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'min_ram','0'),('2026-01-31 09:07:45',NULL,'2026-01-31 09:08:44',1,266,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2026-01-31 08:52:23',NULL,'2026-01-31 08:52:28',1,1,'178fe421-2b8e-431d-ba1f-c61cb97f9d90','Type','work'),('2026-01-31 08:53:21',NULL,'2026-01-31 08:53:42',1,2,'1bacf680-9386-45f4-ba09-5b39c2e5b39d','Type','work'),('2026-01-31 08:53:26',NULL,'2026-01-31 08:53:40',1,3,'5e22def1-0bf4-4827-a908-6c3446a82004','Type','work'),('2026-01-31 08:53:29',NULL,'2026-01-31 08:53:38',1,4,'7a6907ac-6ff5-4310-8f4f-eb55defb5cc1','Type','work'),('2026-01-31 09:05:14',NULL,'2026-01-31 09:06:04',1,5,'f3799711-34bd-4212-9be5-a6ded13ee858','src_backup_id','c7ca3ab9-79be-41d5-86e9-e43f182c2e9e');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2026-01-31 07:42:29',NULL,NULL,0,1,'1687c727-2e98-46a4-986b-7632573bb9d6','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-31 09:00:54',NULL,'2026-01-31 09:01:47',1,'0b2068ba-e687-4185-afc3-bd7723128446','tempest-scenario-type-luks-1403600605',NULL,1,NULL),('2026-01-31 07:42:26',NULL,NULL,0,'1687c727-2e98-46a4-986b-7632573bb9d6','multiattach',NULL,1,NULL),('2026-01-31 07:04:39','2026-01-31 07:04:39',NULL,0,'76f29293-e68c-4b03-b683-3f7eb92b5813','__DEFAULT__',NULL,1,'Default Volume Type'),('2026-01-31 08:54:57',NULL,'2026-01-31 08:58:37',1,'7f430bb5-5191-4b07-9691-ef2d81314eb3','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-1357816968-1210885744',NULL,1,NULL),('2026-01-31 08:32:21',NULL,'2026-01-31 08:33:47',1,'89e12c0b-5753-4452-a933-7bf6f0ef8aae','tempest-scenario-type-luks-75396166',NULL,1,NULL),('2026-01-31 08:54:57',NULL,'2026-01-31 08:58:37',1,'9382c841-5412-4438-8466-c557da1ff3ae','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-42985238-1163518757',NULL,1,NULL),('2026-01-31 08:54:52',NULL,'2026-01-31 08:58:39',1,'eb72ab0c-ff77-4c0a-8918-b139a14d50cc','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-522242991-1329866836',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2026-01-31 08:11:19','2026-01-31 08:15:20','2026-01-31 08:15:21',1,'0a2f77d6-6ebd-4e32-8f3a-3b8197764510',NULL,'12a823bd7c6e4cf492ebf6c1d002a91f','9c03fec1b3664105996aa979e226d8f8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:11:19','2026-01-31 08:11:19','2026-01-31 08:15:20','tempest-ServerActionsTestOtherA-volume-616058989',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:51:33','2026-01-31 08:52:52','2026-01-31 08:52:55',1,'0de0b2ab-99ec-43cf-a8f3-b54f9bb71e28',NULL,'3bd4ce8a916a4bdbbc988eb4fe32991e','76fb5cb7abcd4d74abfc471a96bbd12c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:51:33','2026-01-31 08:51:34','2026-01-31 08:52:52','tempest-AttachVolumeNegativeTest-volume-912255723',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:49:19','2026-01-31 08:52:23','2026-01-31 08:52:28',1,'12e9d9b2-8ec9-4b16-b334-60c0f639cb59',NULL,'a498364761ef428b99cac3f92e603385','8397e0fed04b4dabb57148d0924de2dc','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:49:19','2026-01-31 08:49:20','2026-01-31 08:52:23','tempest-AttachVolumeMultiAttachTest-volume-1225963120',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:39:34','2026-01-31 08:44:27','2026-01-31 08:44:32',1,'14a5819e-189a-4d2d-aa6f-24a9a6888c91',NULL,'516e093a00a44667ba1308900be70d8d','621c17d53cba46d386de8efb560a988e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:39:35','2026-01-31 08:39:36','2026-01-31 08:44:27','tempest-ServersNegativeTestJSON-volume-1497290366',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:52:23','2026-01-31 08:52:26','2026-01-31 08:52:28',1,'178fe421-2b8e-431d-ba1f-c61cb97f9d90',NULL,'9454853c61ff4d0d821e84f00144c006','7c88afe842cd47dea75807eea90f5e58','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:52:23','2026-01-31 08:52:25','2026-01-31 08:52:26','tempest-VolumesGetTestJSON-Volume-1023540761',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:53:20','2026-01-31 08:53:40','2026-01-31 08:53:42',1,'1bacf680-9386-45f4-ba09-5b39c2e5b39d',NULL,'7ecbac610eef4c94bf9fdd2ee240853f','c88376bcb43e42cf9894ecb9352e5822','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:53:21','2026-01-31 08:53:23','2026-01-31 08:53:40','tempest-VolumesTestJSON-volume-1329800156',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:13:52','2026-01-31 08:18:04','2026-01-31 08:18:13',1,'20fd9e7c-9700-482e-a6ae-9d5671e6d553',NULL,'469a76c175b64f84b29a4a44c8eaf3c4','587e3df6fc904afc99c9c6411095e3ef','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:13:53','2026-01-31 08:14:06','2026-01-31 08:18:04','tempest-TaggedBootDevicesTest-volume-1097705299',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:05','2026-01-31 08:58:32','2026-01-31 08:58:34',1,'26d9ea85-55bc-4b3b-b5ad-d60d188212c2',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:05','2026-01-31 08:55:19','2026-01-31 08:58:32','tempest-TestInstancesWithCinderVolumes-volume-289820069',NULL,NULL,NULL,NULL,'eb72ab0c-ff77-4c0a-8918-b139a14d50cc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:13:25','2026-01-31 08:17:21','2026-01-31 08:17:24',1,'284ce110-dc52-4bb8-b8bc-a99864f7d576',NULL,'8080000681f449c3a9754c876165d667','5a6c60c75300483aa07e13b08923b1a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:13:25','2026-01-31 08:13:38','2026-01-31 08:17:21','tempest-TaggedBootDevicesTest_v242-volume-1469119375',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:28:40','2026-01-31 08:30:54','2026-01-31 08:30:56',1,'2b231354-b9f3-4583-b7a7-f3ea6fa9f24a',NULL,'432ac8867d8240408db455fc25bb5901','491937de020742d7b4e847dc3bf57950','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:28:40','2026-01-31 08:28:41','2026-01-31 08:30:54','tempest-AttachVolumeShelveTestJSON-volume-909045928',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:49:20','2026-01-31 07:51:24','2026-01-31 07:51:32',1,'317b1c6b-4f89-402c-94d1-f4852844f1e2',NULL,'37ed25cc14814a29867ac308b3cce8cf','e66a774f63ae4139a4e75c7973fbe077','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:49:21','2026-01-31 07:49:43','2026-01-31 07:51:24','tempest-tempest.common.compute-volume-622006482',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:37:32','2026-01-31 08:41:02','2026-01-31 08:41:06',1,'3b63f0e3-6562-4449-962b-ff0c0228f219',NULL,'b6733330b634472ca8c21316f1ee5057','1e29363ca464487b931af54fe14166b1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:37:33','2026-01-31 08:37:33','2026-01-31 08:41:02','tempest-ServerStableDeviceRescueTest-volume-2056951839',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:24:51','2026-01-31 08:30:56','2026-01-31 08:30:57',1,'40098f2d-bf66-4831-bd6c-f4f5c78b699e',NULL,'432ac8867d8240408db455fc25bb5901','491937de020742d7b4e847dc3bf57950','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:24:52','2026-01-31 08:24:52','2026-01-31 08:30:56','tempest-AttachVolumeShelveTestJSON-volume-1866974950',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:03:06','2026-01-31 09:05:44','2026-01-31 09:05:45',1,'47ca8e30-e640-4fca-a274-67bf157244e9',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:03:07','2026-01-31 09:03:25','2026-01-31 09:05:44','tempest-TestVolumeBootPattern-volume-origin-161642453',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:09','2026-01-31 08:58:30','2026-01-31 08:58:32',1,'49519e92-9c10-4ba7-87c3-e1349e72980c',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:09','2026-01-31 08:55:22','2026-01-31 08:58:30','tempest-TestInstancesWithCinderVolumes-volume-1080826662',NULL,NULL,NULL,NULL,'eb72ab0c-ff77-4c0a-8918-b139a14d50cc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:49:11','2026-01-31 08:52:57','2026-01-31 08:53:02',1,'528b148a-172a-43e7-8be2-21819c2d44e5',NULL,'3bd4ce8a916a4bdbbc988eb4fe32991e','76fb5cb7abcd4d74abfc471a96bbd12c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:49:12','2026-01-31 08:49:15','2026-01-31 08:52:57','tempest-AttachVolumeNegativeTest-volume-1969358374',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:11:02','2026-01-31 08:12:31','2026-01-31 08:12:32',1,'551f775f-0622-435f-b9d7-dcb85f156132',NULL,'80d33e2f57b64bd78a04cd8875660772','96cffd653fc04612bc1b3434529fb946','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:11:04','2026-01-31 08:11:04','2026-01-31 08:12:31','tempest-TaggedAttachmentsTest-volume-1635493530',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:01:50','2026-01-31 09:03:03','2026-01-31 09:03:04',1,'57ea21d4-80c1-49f4-b17b-267af386ea6e',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:01:50','2026-01-31 09:02:05','2026-01-31 09:03:03','tempest-TestVolumeBootPattern-volume-origin-1663213532',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:39:44','2026-01-31 08:44:23','2026-01-31 08:44:25',1,'599d9b91-c6e4-4cec-9a51-0fafe598baa1',NULL,'516e093a00a44667ba1308900be70d8d','621c17d53cba46d386de8efb560a988e','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:39:44','2026-01-31 08:39:45','2026-01-31 08:44:23','tempest-ServersNegativeTestJSON-volume-1195276870',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:53:26','2026-01-31 08:53:39','2026-01-31 08:53:40',1,'5e22def1-0bf4-4827-a908-6c3446a82004',NULL,'7ecbac610eef4c94bf9fdd2ee240853f','c88376bcb43e42cf9894ecb9352e5822','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:53:26','2026-01-31 08:53:27','2026-01-31 08:53:39','tempest-VolumesTestJSON-volume-2083204204',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:04:42','2026-01-31 09:05:36','2026-01-31 09:05:37',1,'5fdc5138-2006-48ee-b966-42f286bea7e1',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:04:42','2026-01-31 09:04:43','2026-01-31 09:05:36','','',NULL,NULL,'a5bb09a5-5ee5-473c-a7c9-bc49c24b7332','76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:04:48','2026-01-31 09:06:02','2026-01-31 09:06:05',1,'63f65249-1c72-4002-bc03-114c329384d1',NULL,'4bd7d1bbf3a8497b8b26f8df83fe8067','c8017efbc64b4244b349174c29a41000','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:04:48','2026-01-31 09:04:59','2026-01-31 09:06:02','tempest-TestVolumeBackupRestore-volume-1720929966',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:07:43','2026-01-31 09:08:43','2026-01-31 09:08:44',1,'64b37453-b9c7-425d-8ee1-936836c623a8',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:07:43','2026-01-31 09:07:45','2026-01-31 09:08:43','tempest-TestVolumeBootPattern-volume-176251004',NULL,NULL,NULL,'65aa871b-bb87-4e43-b07f-a086967007df','76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:54:06','2026-01-31 07:57:26','2026-01-31 07:57:34',1,'6ef78150-3892-44db-ae0c-b2caaa470343',NULL,'d6078cfaadaa45ae9256245554f784fe','fd9f0c923b994b0295e72b111f661de1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:54:06','2026-01-31 07:54:11','2026-01-31 07:57:26','tempest-UpdateMultiattachVolumeNegativeTest-volume-371603153',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:49:31','2026-01-31 07:51:37','2026-01-31 07:51:49',1,'74f8a6d0-259e-466b-a484-4c7bffded2e1',NULL,'795c7f392cbc45f0885f081449883d42','cbdbb7a4b22a49b68feb3e028bb62fbb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:49:32','2026-01-31 07:49:43','2026-01-31 07:51:37','tempest-tempest.common.compute-volume-347459517',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:48:57','2026-01-31 08:51:15','2026-01-31 08:51:16',1,'756cf314-0b1f-46f3-bdfa-a0682d03b570',NULL,'aa7f893021af4a84b03d85b476dadfe0','bf1c3d387dbe4191b4d05bdfca5959da','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:48:58','2026-01-31 08:48:59','2026-01-31 08:51:15','tempest-ServerRescueNegativeTestJSON-volume-103554978',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:54:59','2026-01-31 08:57:12','2026-01-31 08:57:13',1,'75a603c9-1c6b-4103-ac69-0db6813e7404',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:00','2026-01-31 08:55:00','2026-01-31 08:57:12','tempest-TestInstancesWithCinderVolumes-volume-760038752',NULL,NULL,NULL,NULL,'9382c841-5412-4438-8466-c557da1ff3ae',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:01:22','2026-01-31 09:03:36','2026-01-31 09:03:37',1,'766e40b4-9f67-4558-bd4a-c5d2d46d1ef1',NULL,'3859f52c5b70471097d1e4ffa75ecc0e','1f293713f6854265a89a1a4a002088d5','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:01:22','2026-01-31 09:01:39','2026-01-31 09:03:36','tempest-tempest.common.compute-volume-1732705074',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:09:24','2026-01-31 08:10:22','2026-01-31 08:10:23',1,'77364634-2150-4955-8185-1bf60ebd89d8',NULL,'2c72ac0892c84ca0bf3e2ef74eed4f64','2901e55f200f4622ae841166074ac8f8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:09:25','2026-01-31 08:09:43','2026-01-31 08:10:22','tempest-tempest.common.compute-volume-713276510',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:14:10','2026-01-31 08:17:59','2026-01-31 08:18:01',1,'785fba22-460b-4d01-b053-ffec518020b7',NULL,'469a76c175b64f84b29a4a44c8eaf3c4','587e3df6fc904afc99c9c6411095e3ef','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:14:12','2026-01-31 08:14:12','2026-01-31 08:17:59','tempest-TaggedBootDevicesTest-volume-58078847',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:53:29','2026-01-31 08:53:37','2026-01-31 08:53:38',1,'7a6907ac-6ff5-4310-8f4f-eb55defb5cc1',NULL,'7ecbac610eef4c94bf9fdd2ee240853f','c88376bcb43e42cf9894ecb9352e5822','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:53:29','2026-01-31 08:53:30','2026-01-31 08:53:37','tempest-VolumesTestJSON-volume-1385819850',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:01','2026-01-31 08:57:50','2026-01-31 08:57:53',1,'7ad3b3fb-6194-4162-90c8-c3ac9c4017d9',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:01','2026-01-31 08:55:02','2026-01-31 08:57:50','tempest-TestInstancesWithCinderVolumes-volume-934624226',NULL,NULL,NULL,NULL,'9382c841-5412-4438-8466-c557da1ff3ae',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:52:38','2026-01-31 07:53:12','2026-01-31 07:53:19',1,'7df70e23-e53e-4df4-8aa9-3917f141bf82',NULL,'69d26c1015144fbda08ee4b9db0d7b70','ea1f64b5b90d4a90a6cb764c4cdcca59','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:52:38','2026-01-31 07:52:38','2026-01-31 07:53:12','tempest-AttachSCSIVolumeTestJSON-volume-683137905',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:36:42','2026-01-31 08:39:19','2026-01-31 08:39:21',1,'7ff7e47c-5991-4995-b62d-9010ad81e5bf',NULL,'c13cac16cdef424b8050c4bea5a7e9c3','fcc39962194d44e5b37cad3fb1adc6c4','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:36:43','2026-01-31 08:37:03','2026-01-31 08:39:19','tempest-tempest.common.compute-volume-630047084',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:13:41','2026-01-31 08:17:16','2026-01-31 08:17:17',1,'8211a79e-7243-4aef-aa8b-c47974e4d749',NULL,'8080000681f449c3a9754c876165d667','5a6c60c75300483aa07e13b08923b1a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:13:41','2026-01-31 08:13:42','2026-01-31 08:17:16','tempest-TaggedBootDevicesTest_v242-volume-426698623',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:02:38','2026-01-31 09:04:06','2026-01-31 09:04:11',1,'881e1975-bbbe-4bd4-b026-dc1919960757',NULL,'b97882caec944ca3b26c230fcebff775','3d3e35e8f8144cd58baa994b70ef9668','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:02:38','2026-01-31 09:02:39','2026-01-31 09:04:06','tempest-TestMinimumBasicScenario-volume-912776573',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:31:12','2026-01-31 08:35:30','2026-01-31 08:35:31',1,'901896ec-4cee-48ca-89ea-1ef061e9fbf3',NULL,'ef51681d234a4abc88ff433d0640b6e7','953a213fa5cb435ab3c04ad96152685f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:31:13','2026-01-31 08:31:14','2026-01-31 08:35:30','tempest-ServerActionsTestOtherB-volume-801332091',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:01','2026-01-31 08:57:47','2026-01-31 08:57:48',1,'95b6d139-2444-4c12-8219-f46fb97d8a4d',NULL,'53804fd0f3a14f95a4955e3bc6dcc8cb','ab2d642eb03c4bda84a9a23e86f1fa4d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:02','2026-01-31 08:55:02','2026-01-31 08:57:47','tempest-AttachVolumeTestJSON-volume-323483928',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:54:59','2026-01-31 08:57:08','2026-01-31 08:57:09',1,'985c0898-7bd0-457c-b3bb-abe45d65168a',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:54:59','2026-01-31 08:55:00','2026-01-31 08:57:08','tempest-TestInstancesWithCinderVolumes-volume-1322340638',NULL,NULL,NULL,NULL,'7f430bb5-5191-4b07-9691-ef2d81314eb3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:52:30','2026-01-31 08:52:50','2026-01-31 08:52:51',1,'9af5cb67-e1aa-49f9-909d-b9b2d8642543',NULL,'3bd4ce8a916a4bdbbc988eb4fe32991e','76fb5cb7abcd4d74abfc471a96bbd12c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:52:30','2026-01-31 08:52:30','2026-01-31 08:52:50','tempest-AttachVolumeNegativeTest-volume-2025687306',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:54:58','2026-01-31 08:56:17','2026-01-31 08:56:18',1,'9bc3cb04-a48c-40bd-81ea-100007bee62c',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:54:58','2026-01-31 08:54:58','2026-01-31 08:56:17','tempest-TestInstancesWithCinderVolumes-volume-424125335',NULL,NULL,NULL,NULL,'7f430bb5-5191-4b07-9691-ef2d81314eb3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:17:26','2026-01-31 09:18:33','2026-01-31 09:18:34',1,'9c54af70-f6c6-42c1-90a6-95ba3f7c6db1',NULL,'4f25568607234a398bc35cbb67eb406f','390709b3e5174dc4afdc6b04fdae67e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:17:26','2026-01-31 09:17:26','2026-01-31 09:18:33','tempest-TestStampPattern-volume-188569894',NULL,NULL,NULL,'d4450360-3f6e-407a-b349-a4ab7476743d','76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:13:07','2026-01-31 08:14:54','2026-01-31 08:14:56',1,'a072271f-7f43-470f-93ee-c6396eaabeba',NULL,'12a823bd7c6e4cf492ebf6c1d002a91f','9c03fec1b3664105996aa979e226d8f8','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:13:09','2026-01-31 08:13:22','2026-01-31 08:14:54','tempest-tempest.common.compute-volume-398829790',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:14','2026-01-31 08:58:27','2026-01-31 08:58:29',1,'a6407347-cd1c-4e32-a08c-1836a1f51dd6',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:14','2026-01-31 08:55:28','2026-01-31 08:58:27','tempest-TestInstancesWithCinderVolumes-volume-2003775368',NULL,NULL,NULL,NULL,'eb72ab0c-ff77-4c0a-8918-b139a14d50cc',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:32:24','2026-01-31 08:33:44','2026-01-31 08:33:46',1,'a91659a9-a045-40d5-a67a-84e5963be227',NULL,'8efe4dc047d44a0fbd21b243ddc921d8','5fe2a450b6ff4f73a7fe8def47304a29','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:32:25','2026-01-31 08:32:39','2026-01-31 08:33:44','tempest-TestEncryptedCinderVolumes-volume-719150335',NULL,NULL,NULL,NULL,'89e12c0b-5753-4452-a933-7bf6f0ef8aae',NULL,0,NULL,NULL,'554dc8d2-d437-4e70-a380-9cd5e356d258',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:55:00','2026-01-31 08:57:46','2026-01-31 08:57:47',1,'a91dfbd1-af86-4b71-b911-f9af43fa9cd7',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:55:00','2026-01-31 08:55:01','2026-01-31 08:57:46','tempest-TestInstancesWithCinderVolumes-volume-340913200',NULL,NULL,NULL,NULL,'7f430bb5-5191-4b07-9691-ef2d81314eb3',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:57:17','2026-01-31 08:57:45','2026-01-31 08:57:46',1,'af751b83-d2b1-494f-9ebb-7edf7087a67c',NULL,'53804fd0f3a14f95a4955e3bc6dcc8cb','ab2d642eb03c4bda84a9a23e86f1fa4d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:57:17','2026-01-31 08:57:18','2026-01-31 08:57:45','tempest-AttachVolumeTestJSON-volume-446334149',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:20:58','2026-01-31 08:27:23',NULL,0,'afd3af33-f7a2-401c-9400-47dff922d4f4',NULL,'f4d66dd0b7ff443cbcdb6e2c9f5c4c8c','cf024d54545b4af882a87c721105742a','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-31 08:20:58','2026-01-31 08:21:00',NULL,'23200b4a-e522-43bf-a83e-cb2f9bb31571-blank-vol','',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:05:57','2026-01-31 09:08:52','2026-01-31 09:08:52',1,'b457f046-29d9-4842-87e2-ad26874ea748',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:05:57','2026-01-31 09:06:07','2026-01-31 09:08:52','tempest-TestVolumeBootPattern-volume-origin-32813687',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:23:42','2026-01-31 08:26:06',NULL,0,'b717b315-86df-4d2d-96bf-25aba2759093',NULL,'f4d66dd0b7ff443cbcdb6e2c9f5c4c8c','cf024d54545b4af882a87c721105742a','hostgroup@ceph#ceph',1,'nova','available','detached','2026-01-31 08:23:43','2026-01-31 08:24:20',NULL,'','',NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:59:57','2026-01-31 09:01:45','2026-01-31 09:01:45',1,'b7cfb970-aa00-4ab7-b895-9c828f0058d5',NULL,'b97882caec944ca3b26c230fcebff775','3d3e35e8f8144cd58baa994b70ef9668','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:59:58','2026-01-31 08:59:58','2026-01-31 09:01:44','tempest-TestMinimumBasicScenario-volume-83957709',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:16:36','2026-01-31 09:18:54','2026-01-31 09:18:56',1,'bb545a69-3527-4e10-b1af-2e7b80d9ad14',NULL,'4f25568607234a398bc35cbb67eb406f','390709b3e5174dc4afdc6b04fdae67e3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:16:36','2026-01-31 09:16:37','2026-01-31 09:18:54','tempest-TestStampPattern-volume-1202484504',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:54:01','2026-01-31 07:57:36','2026-01-31 07:57:38',1,'bd6a018f-eaef-43b9-b78d-313bb85c40fa',NULL,'d6078cfaadaa45ae9256245554f784fe','fd9f0c923b994b0295e72b111f661de1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:54:01','2026-01-31 07:54:05','2026-01-31 07:57:36','tempest-UpdateMultiattachVolumeNegativeTest-volume-471217483',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:45:32','2026-01-31 08:53:10','2026-01-31 08:53:14',1,'bf35e6ca-068a-4538-b11a-fe35ddc37a44',NULL,'a498364761ef428b99cac3f92e603385','8397e0fed04b4dabb57148d0924de2dc','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:45:32','2026-01-31 08:45:48','2026-01-31 08:53:10','tempest-AttachVolumeMultiAttachTest-volume-1631309760',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:44:43','2026-01-31 07:45:32','2026-01-31 07:45:39',1,'c3f8bc09-4bc5-4545-abcc-da259a7bb1ed',NULL,'2134a4c3d333450692024d3cd8b40429','929444f150804704b1865bcbe068c936','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:44:43','2026-01-31 07:44:46','2026-01-31 07:45:32','tempest-VolumesAssistedSnapshotsTest-volume-797290899',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:48:13','2026-01-31 08:51:17','2026-01-31 08:51:20',1,'c6d7c217-96b5-4771-8335-8c01224b487a',NULL,'aa7f893021af4a84b03d85b476dadfe0','bf1c3d387dbe4191b4d05bdfca5959da','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:48:13','2026-01-31 08:48:14','2026-01-31 08:51:17','tempest-ServerRescueNegativeTestJSON-volume-290427888',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:59:22','2026-01-31 07:59:24','2026-01-31 07:59:25',1,'c9872530-2427-48f5-8602-2d789de2ee86',NULL,'b034a039074641a7b7c872e8b715ca4c','273fe485cc184dd8bf86440d8d1e05f3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:59:23','2026-01-31 07:59:23','2026-01-31 07:59:24','tempest-VolumesAdminNegativeTest-volume-848701140',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:06:16','2026-01-31 08:10:28','2026-01-31 08:10:28',1,'cfc0e54a-67e2-4096-bf5e-8287b1e5add7',NULL,'16d731f5875748ca9b8036b2ba061042','3469c253459e40e39dcf5bcb6a32008f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:06:17','2026-01-31 08:06:17','2026-01-31 08:10:28','tempest-DeleteServersTestJSON-volume-1538483910',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:57:23','2026-01-31 08:57:43','2026-01-31 08:57:44',1,'d8da98d6-6c1a-48c1-8832-4fd207143449',NULL,'53804fd0f3a14f95a4955e3bc6dcc8cb','ab2d642eb03c4bda84a9a23e86f1fa4d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:57:23','2026-01-31 08:57:23','2026-01-31 08:57:43','tempest-AttachVolumeTestJSON-volume-466626943',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:02:26','2026-01-31 09:02:53','2026-01-31 09:02:54',1,'d9130530-fbc3-4fb7-957a-e45c619660f3',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:02:28','2026-01-31 09:02:30','2026-01-31 09:02:53','','',NULL,NULL,'714b73f4-e266-4c1a-8a63-cf91334700b6','76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:47:34','2026-01-31 08:52:41','2026-01-31 08:52:43',1,'dad97247-8d79-4c56-b9b0-e61729262e21',NULL,'a498364761ef428b99cac3f92e603385','8397e0fed04b4dabb57148d0924de2dc','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:47:34','2026-01-31 08:47:36','2026-01-31 08:52:41','tempest-AttachVolumeMultiAttachTest-volume-1128323106',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 07:58:49','2026-01-31 07:59:35','2026-01-31 07:59:38',1,'db1124e5-1a30-4118-a44b-369e05e566a9',NULL,'b034a039074641a7b7c872e8b715ca4c','273fe485cc184dd8bf86440d8d1e05f3','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 07:58:49','2026-01-31 07:58:50','2026-01-31 07:59:35','tempest-VolumesAdminNegativeTest-volume-1808048634',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:14:08','2026-01-31 08:18:02','2026-01-31 08:18:03',1,'e24cf252-b35c-4390-a954-7f28d6e0eaed',NULL,'469a76c175b64f84b29a4a44c8eaf3c4','587e3df6fc904afc99c9c6411095e3ef','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:14:09','2026-01-31 08:14:09','2026-01-31 08:18:02','tempest-TaggedBootDevicesTest-volume-165926660',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:00:56','2026-01-31 09:01:44','2026-01-31 09:01:46',1,'e4cba400-cc7c-48f0-94b8-a77f724bc898',NULL,'dc42b92a5dd34d32b6b184bdc7acb092','76ce367a834b49dfb5b436848118b860','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:00:56','2026-01-31 09:01:05','2026-01-31 09:01:44','tempest-TestVolumeBootPattern-volume-1220306262',NULL,NULL,NULL,NULL,'0b2068ba-e687-4185-afc3-bd7723128446',NULL,1,NULL,NULL,'cf731dd8-1d28-4250-a5e1-54d441c738cb',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 09:05:08','2026-01-31 09:06:02','2026-01-31 09:06:04',1,'f3799711-34bd-4212-9be5-a6ded13ee858',NULL,'4bd7d1bbf3a8497b8b26f8df83fe8067','c8017efbc64b4244b349174c29a41000','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 09:05:08','2026-01-31 09:05:09','2026-01-31 09:06:02','tempest-TestVolumeBackupRestore-volume-1720929966',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:13:39','2026-01-31 08:17:18','2026-01-31 08:17:20',1,'f3cb4822-8f33-4837-8242-54aa49d653b7',NULL,'8080000681f449c3a9754c876165d667','5a6c60c75300483aa07e13b08923b1a1','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:13:39','2026-01-31 08:13:40','2026-01-31 08:17:18','tempest-TaggedBootDevicesTest_v242-volume-695289708',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:54:58','2026-01-31 08:56:22','2026-01-31 08:56:23',1,'f694d315-eb2a-436c-b06d-0d95676e69e3',NULL,'cfaebb011a374541b083e772a6c83f25','06b5fc9cfd4c49abb2d8b9f2f8a82c1f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:54:58','2026-01-31 08:54:59','2026-01-31 08:56:22','tempest-TestInstancesWithCinderVolumes-volume-1272893579',NULL,NULL,NULL,NULL,'9382c841-5412-4438-8466-c557da1ff3ae',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:51:31','2026-01-31 08:52:15','2026-01-31 08:52:17',1,'f7e6afdb-ed5e-4762-ad08-3a1fceda6276',NULL,'a498364761ef428b99cac3f92e603385','8397e0fed04b4dabb57148d0924de2dc','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:51:32','2026-01-31 08:51:43','2026-01-31 08:52:15','tempest-AttachVolumeMultiAttachTest-volume-433753922',NULL,'{\"saved_features\":61}',NULL,NULL,'1687c727-2e98-46a4-986b-7632573bb9d6',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1),('2026-01-31 08:58:03','2026-01-31 08:58:08','2026-01-31 08:58:09',1,'fb14c875-d28b-48cd-898c-660d2eb46091',NULL,'c1c047e8715e49b2a126a78e44daf2e8','01662186bc9a4adf8b2309e0fff4f829','hostgroup@ceph#ceph',1,'nova','deleted','detached','2026-01-31 08:58:03','2026-01-31 08:58:03','2026-01-31 08:58:08','tempest-VolumesSnapshotsTestJSON-volume-1011487722',NULL,NULL,NULL,NULL,'76f29293-e68c-4b03-b683-3f7eb92b5813',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'85900678-4e14-4772-bb98-59f94b16a3c1',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-31 07:04:39','2026-01-31 07:04:39.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16/snap','2026-01-31 07:43:44','2026-01-31 07:43:44',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'0864ca59-9877-4e6d-adfc-f0a3204ed8f8','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/0864ca59-9877-4e6d-adfc-f0a3204ed8f8/snap','2026-01-31 07:43:47','2026-01-31 07:43:47',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'e0fa43e0-9f79-4992-bc07-130eef6d5592','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/e0fa43e0-9f79-4992-bc07-130eef6d5592/snap','2026-01-31 07:51:29','2026-01-31 07:53:11','2026-01-31 07:53:11',1,'{\"store\": \"default_backend\"}','deleted'),(4,'301dc142-04f9-45d9-be1d-5d5ccdcf32fb','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/301dc142-04f9-45d9-be1d-5d5ccdcf32fb/snap','2026-01-31 07:55:50','2026-01-31 07:56:24','2026-01-31 07:56:24',1,'{\"store\": \"default_backend\"}','deleted'),(5,'7b22f4ab-bd25-45c1-a738-6910f1407753','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/7b22f4ab-bd25-45c1-a738-6910f1407753/snap','2026-01-31 07:59:13','2026-01-31 07:59:30','2026-01-31 07:59:30',1,'{\"store\": \"default_backend\"}','deleted'),(6,'919869d2-31bd-400c-b71c-e086ee5512c0','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/919869d2-31bd-400c-b71c-e086ee5512c0/snap','2026-01-31 08:00:06','2026-01-31 08:00:34','2026-01-31 08:00:34',1,'{\"store\": \"default_backend\"}','deleted'),(7,'73cd49f9-2dc0-46db-a474-56b4005fa543','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/73cd49f9-2dc0-46db-a474-56b4005fa543/snap','2026-01-31 08:00:06','2026-01-31 08:00:09','2026-01-31 08:00:09',1,'{\"store\": \"default_backend\"}','deleted'),(8,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/61a37dcc-3d92-40cb-8dfd-e5d9e9576f30/snap','2026-01-31 08:00:45','2026-01-31 08:00:52','2026-01-31 08:00:52',1,'{\"store\": \"default_backend\"}','deleted'),(9,'9516f569-48fb-4a10-80ea-c3a613366509','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/9516f569-48fb-4a10-80ea-c3a613366509/snap','2026-01-31 08:01:54','2026-01-31 08:01:59','2026-01-31 08:01:59',1,'{\"store\": \"default_backend\"}','deleted'),(10,'48732de6-33cc-4857-a389-34f02c69b538','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/48732de6-33cc-4857-a389-34f02c69b538/snap','2026-01-31 08:02:32','2026-01-31 08:02:37','2026-01-31 08:02:37',1,'{\"store\": \"default_backend\"}','deleted'),(11,'3676ca5a-2e55-4575-bc3f-672af49a103b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/3676ca5a-2e55-4575-bc3f-672af49a103b/snap','2026-01-31 08:03:15','2026-01-31 08:03:19','2026-01-31 08:03:19',1,'{\"store\": \"default_backend\"}','deleted'),(12,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/4f6468b7-082d-4995-a147-34ef0ccaa0d2/snap','2026-01-31 08:03:17','2026-01-31 08:03:49','2026-01-31 08:03:49',1,'{\"store\": \"default_backend\"}','deleted'),(13,'82a300ae-ae8c-468e-b588-e2987672944b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/82a300ae-ae8c-468e-b588-e2987672944b/snap','2026-01-31 08:03:19','2026-01-31 08:05:10','2026-01-31 08:05:10',1,'{\"store\": \"default_backend\"}','deleted'),(14,'9317cf42-332f-490f-a964-767c14b9cbfa','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/9317cf42-332f-490f-a964-767c14b9cbfa/snap','2026-01-31 08:03:31','2026-01-31 08:05:05','2026-01-31 08:05:05',1,'{\"store\": \"default_backend\"}','deleted'),(15,'1a6e18bb-b0e4-4e74-971e-ba88c205b347','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/1a6e18bb-b0e4-4e74-971e-ba88c205b347/snap','2026-01-31 08:03:38','2026-01-31 08:05:02','2026-01-31 08:05:02',1,'{\"store\": \"default_backend\"}','deleted'),(16,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/0329a887-4ad2-4163-bd3c-ee2a3ded1631/snap','2026-01-31 08:03:42','2026-01-31 08:03:49','2026-01-31 08:03:49',1,'{\"store\": \"default_backend\"}','deleted'),(17,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/58c2d049-2cc3-4799-9c9b-054364bb8a5e/snap','2026-01-31 08:04:10','2026-01-31 08:04:51','2026-01-31 08:04:51',1,'{\"store\": \"default_backend\"}','deleted'),(18,'c60105d3-836b-48ac-bea6-55acfd972195','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/c60105d3-836b-48ac-bea6-55acfd972195/snap','2026-01-31 08:04:22','2026-01-31 08:04:49','2026-01-31 08:04:49',1,'{\"store\": \"default_backend\"}','deleted'),(19,'d9bfe40a-4757-4935-8bdd-50aa5c769418','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/d9bfe40a-4757-4935-8bdd-50aa5c769418/snap','2026-01-31 08:04:33','2026-01-31 08:04:47','2026-01-31 08:04:47',1,'{\"store\": \"default_backend\"}','deleted'),(20,'7b781d58-222d-48fb-b75e-dda36a2cb764','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/7b781d58-222d-48fb-b75e-dda36a2cb764/snap','2026-01-31 08:08:01','2026-01-31 08:08:17','2026-01-31 08:08:17',1,'{\"store\": \"default_backend\"}','deleted'),(21,'4659652d-d50c-40d4-aa17-bb68b7e73113','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/4659652d-d50c-40d4-aa17-bb68b7e73113/snap','2026-01-31 08:20:47','2026-01-31 08:27:35','2026-01-31 08:27:35',1,'{\"store\": \"default_backend\"}','deleted'),(22,'27d563e8-5fbe-4653-b526-f8048559e6cd','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/27d563e8-5fbe-4653-b526-f8048559e6cd/snap','2026-01-31 08:23:33','2026-01-31 08:26:40','2026-01-31 08:26:40',1,'{\"store\": \"default_backend\"}','deleted'),(23,'81322d27-2584-47ad-bfcd-7642da2c770e','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/81322d27-2584-47ad-bfcd-7642da2c770e/snap','2026-01-31 08:25:35','2026-01-31 08:27:05','2026-01-31 08:27:05',1,'{\"store\": \"default_backend\"}','deleted'),(24,'913987a4-398c-4df5-8903-96535743e328','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/913987a4-398c-4df5-8903-96535743e328/snap','2026-01-31 08:26:42','2026-01-31 08:27:52','2026-01-31 08:27:52',1,'{\"store\": \"default_backend\"}','deleted'),(25,'9dcdf407-c698-4570-bce4-edde88d1813b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/9dcdf407-c698-4570-bce4-edde88d1813b/snap','2026-01-31 08:27:18','2026-01-31 08:28:09','2026-01-31 08:28:09',1,'{\"store\": \"default_backend\"}','deleted'),(26,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/3d658df0-f3c7-45a7-bf8b-c899f015d20b/snap','2026-01-31 08:27:38','2026-01-31 08:28:01','2026-01-31 08:28:01',1,'{\"store\": \"default_backend\"}','deleted'),(27,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/0e9c5d39-8319-43cb-ac29-5664ec7c2a71/snap','2026-01-31 08:29:04','2026-01-31 08:30:17','2026-01-31 08:30:17',1,'{\"store\": \"default_backend\"}','deleted'),(28,'e787704c-b374-4706-807f-a0d18a0ac398','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/e787704c-b374-4706-807f-a0d18a0ac398/snap','2026-01-31 08:34:14','2026-01-31 08:35:15','2026-01-31 08:35:15',1,'{\"store\": \"default_backend\"}','deleted'),(29,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/15979fb2-ffd4-4e76-9dfb-7c7ce052fa99/snap','2026-01-31 08:34:17','2026-01-31 08:41:44','2026-01-31 08:41:44',1,'{\"store\": \"default_backend\"}','deleted'),(30,'a445cf05-8653-452b-bc15-8061b7aa6a98','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/a445cf05-8653-452b-bc15-8061b7aa6a98/snap','2026-01-31 08:34:34','2026-01-31 08:35:10','2026-01-31 08:35:10',1,'{\"store\": \"default_backend\"}','deleted'),(31,'357acf21-e111-4e02-8a13-c11baeb4f6ec','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/357acf21-e111-4e02-8a13-c11baeb4f6ec/snap','2026-01-31 08:35:19','2026-01-31 08:41:20','2026-01-31 08:41:20',1,'{\"store\": \"default_backend\"}','deleted'),(32,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/287f9894-83db-40a1-9a7f-ba7bbf17dc1d/snap','2026-01-31 08:36:41','2026-01-31 08:41:08','2026-01-31 08:41:08',1,'{\"store\": \"default_backend\"}','deleted'),(33,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/9bc0d84f-a933-4fd8-8f17-38e2aca81cce/snap','2026-01-31 08:39:18','2026-01-31 08:40:46','2026-01-31 08:40:46',1,'{\"store\": \"default_backend\"}','deleted'),(34,'269becbf-04a2-4537-bd31-66899150ed70','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/269becbf-04a2-4537-bd31-66899150ed70/snap','2026-01-31 08:42:14','2026-01-31 08:43:17','2026-01-31 08:43:17',1,'{\"store\": \"default_backend\"}','deleted'),(35,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf/snap','2026-01-31 08:52:07','2026-01-31 08:52:22','2026-01-31 08:52:22',1,'{\"store\": \"default_backend\"}','deleted'),(36,'59ddf935-eb93-411f-a5eb-c6177408c7cf','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/59ddf935-eb93-411f-a5eb-c6177408c7cf/snap','2026-01-31 08:54:56','2026-01-31 08:58:39','2026-01-31 08:58:39',1,'{\"store\": \"default_backend\"}','deleted'),(37,'be36fc17-1fc9-4dc7-9df3-92082489a43b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/be36fc17-1fc9-4dc7-9df3-92082489a43b/snap','2026-01-31 08:59:33','2026-01-31 09:01:54','2026-01-31 09:01:54',1,'{\"store\": \"default_backend\"}','deleted'),(38,'297f46fc-627f-48b0-8a66-2e6f3dab7554','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/297f46fc-627f-48b0-8a66-2e6f3dab7554/snap','2026-01-31 09:00:10','2026-01-31 09:00:43','2026-01-31 09:00:43',1,'{\"store\": \"default_backend\"}','deleted'),(39,'4ac04f66-def8-4f84-bf0b-3cd9f30ead2e','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/4ac04f66-def8-4f84-bf0b-3cd9f30ead2e/snap','2026-01-31 09:01:57','2026-01-31 09:04:27','2026-01-31 09:04:27',1,'{\"store\": \"default_backend\"}','deleted'),(40,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/7ac3b86b-56fa-425d-911b-e0b1bc3c9b64/snap','2026-01-31 09:04:21','2026-01-31 09:05:49','2026-01-31 09:05:49',1,'{\"store\": \"default_backend\"}','deleted'),(41,'f398889c-e272-449f-a032-36096e95d18f','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/f398889c-e272-449f-a032-36096e95d18f/snap','2026-01-31 09:11:13','2026-01-31 09:12:15','2026-01-31 09:12:15',1,'{\"store\": \"default_backend\"}','deleted'),(42,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/a6036a30-758c-46f5-b0cb-e59cf3a4220b/snap','2026-01-31 09:12:06','2026-01-31 09:12:08','2026-01-31 09:12:08',1,'{\"store\": \"default_backend\"}','deleted'),(43,'0d074876-a373-4784-8303-5b3716508074','rbd://2f5ab832-5f2e-5a84-bd93-cf8bab960ee2/images/0d074876-a373-4784-8303-5b3716508074/snap','2026-01-31 09:17:25','2026-01-31 09:18:44','2026-01-31 09:18:44',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','hw_rng_model','virtio','2026-01-31 07:43:39','2026-01-31 07:43:39',NULL,0),(2,'0864ca59-9877-4e6d-adfc-f0a3204ed8f8','hw_rng_model','virtio','2026-01-31 07:43:45','2026-01-31 07:43:45',NULL,0),(3,'e0fa43e0-9f79-4992-bc07-130eef6d5592','hw_scsi_model','virtio-scsi','2026-01-31 07:51:17','2026-01-31 07:53:11','2026-01-31 07:53:11',1),(4,'e0fa43e0-9f79-4992-bc07-130eef6d5592','hw_disk_bus','scsi','2026-01-31 07:51:17','2026-01-31 07:53:11','2026-01-31 07:53:11',1),(5,'e0fa43e0-9f79-4992-bc07-130eef6d5592','hw_cdrom_bus','scsi','2026-01-31 07:51:17','2026-01-31 07:53:11','2026-01-31 07:53:11',1),(6,'301dc142-04f9-45d9-be1d-5d5ccdcf32fb','os_version','alt1','2026-01-31 07:55:53','2026-01-31 07:56:24','2026-01-31 07:56:24',1),(7,'301dc142-04f9-45d9-be1d-5d5ccdcf32fb','os_distro','value2','2026-01-31 07:55:53','2026-01-31 07:56:24','2026-01-31 07:56:24',1),(8,'301dc142-04f9-45d9-be1d-5d5ccdcf32fb','architecture','value3','2026-01-31 07:56:03','2026-01-31 07:56:24','2026-01-31 07:56:24',1),(9,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_rng_model','virtio','2026-01-31 07:58:54','2026-01-31 07:59:30','2026-01-31 07:59:30',1),(10,'7b22f4ab-bd25-45c1-a738-6910f1407753','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 07:58:54','2026-01-31 07:59:30','2026-01-31 07:59:30',1),(11,'7b22f4ab-bd25-45c1-a738-6910f1407753','owner_user_name','tempest-UnshelveToHostMultiNodesTest-849130801-project-member','2026-01-31 07:58:54','2026-01-31 07:59:30','2026-01-31 07:59:30',1),(12,'7b22f4ab-bd25-45c1-a738-6910f1407753','owner_project_name','tempest-UnshelveToHostMultiNodesTest-849130801','2026-01-31 07:58:54','2026-01-31 07:59:30','2026-01-31 07:59:30',1),(13,'7b22f4ab-bd25-45c1-a738-6910f1407753','boot_roles','reader,member','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(14,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_machine_type','q35','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(15,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_cdrom_bus','sata','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(16,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_disk_bus','virtio','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(17,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_input_bus','usb','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(18,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_pointer_model','usbtablet','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(19,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_video_model','virtio','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(20,'7b22f4ab-bd25-45c1-a738-6910f1407753','hw_vif_model','virtio','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(21,'7b22f4ab-bd25-45c1-a738-6910f1407753','instance_uuid','a24ac16c-df64-4cef-a252-1f1c38920602','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(22,'7b22f4ab-bd25-45c1-a738-6910f1407753','user_id','2d20e7b6189c4916947ddae2155da8cf','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(23,'7b22f4ab-bd25-45c1-a738-6910f1407753','image_type','snapshot','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(24,'7b22f4ab-bd25-45c1-a738-6910f1407753','image_location','snapshot','2026-01-31 07:59:12','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(25,'7b22f4ab-bd25-45c1-a738-6910f1407753','owner_id','0f3a75a965fc495bbe02cb5bfad2053b','2026-01-31 07:59:12','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(26,'7b22f4ab-bd25-45c1-a738-6910f1407753','image_state','available','2026-01-31 07:59:12','2026-01-31 07:59:31','2026-01-31 07:59:31',1),(27,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_rng_model','virtio','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(28,'919869d2-31bd-400c-b71c-e086ee5512c0','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(29,'919869d2-31bd-400c-b71c-e086ee5512c0','owner_user_name','tempest-UnshelveToHostMultiNodesTest-849130801-project-member','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(30,'919869d2-31bd-400c-b71c-e086ee5512c0','owner_project_name','tempest-UnshelveToHostMultiNodesTest-849130801','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(31,'919869d2-31bd-400c-b71c-e086ee5512c0','boot_roles','reader,member','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(32,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_machine_type','q35','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(33,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_cdrom_bus','sata','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(34,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_disk_bus','virtio','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(35,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_input_bus','usb','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(36,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_pointer_model','usbtablet','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(37,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_video_model','virtio','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(38,'919869d2-31bd-400c-b71c-e086ee5512c0','hw_vif_model','virtio','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(39,'919869d2-31bd-400c-b71c-e086ee5512c0','clean_attempts','1','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(40,'919869d2-31bd-400c-b71c-e086ee5512c0','instance_uuid','a24ac16c-df64-4cef-a252-1f1c38920602','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(41,'919869d2-31bd-400c-b71c-e086ee5512c0','user_id','2d20e7b6189c4916947ddae2155da8cf','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(42,'919869d2-31bd-400c-b71c-e086ee5512c0','image_type','snapshot','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(43,'919869d2-31bd-400c-b71c-e086ee5512c0','image_location','snapshot','2026-01-31 08:00:04','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(44,'919869d2-31bd-400c-b71c-e086ee5512c0','owner_id','0f3a75a965fc495bbe02cb5bfad2053b','2026-01-31 08:00:04','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(45,'919869d2-31bd-400c-b71c-e086ee5512c0','image_state','available','2026-01-31 08:00:04','2026-01-31 08:00:35','2026-01-31 08:00:35',1),(46,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_rng_model','virtio','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(47,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(48,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','owner_user_name','tempest-ImagesTestJSON-1780438391-project-member','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(49,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','owner_project_name','tempest-ImagesTestJSON-1780438391','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(50,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','boot_roles','reader,member','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(51,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_machine_type','q35','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(52,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_cdrom_bus','sata','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(53,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_disk_bus','virtio','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(54,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_input_bus','usb','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(55,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_pointer_model','usbtablet','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(56,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_video_model','virtio','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(57,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','hw_vif_model','virtio','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(58,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','instance_uuid','b4a73ec8-501b-454f-9cf7-4d4a09344db3','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(59,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','user_id','46ffd64a348845fab6cdc53249353575','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(60,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','image_type','snapshot','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(61,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','image_location','snapshot','2026-01-31 08:00:44','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(62,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','owner_id','521dcd459f144f2bb32de93d50ae0391','2026-01-31 08:00:44','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(63,'61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','image_state','available','2026-01-31 08:00:44','2026-01-31 08:00:52','2026-01-31 08:00:52',1),(64,'9516f569-48fb-4a10-80ea-c3a613366509','hw_rng_model','virtio','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(65,'9516f569-48fb-4a10-80ea-c3a613366509','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(66,'9516f569-48fb-4a10-80ea-c3a613366509','owner_user_name','tempest-ImagesTestJSON-1780438391-project-member','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(67,'9516f569-48fb-4a10-80ea-c3a613366509','owner_project_name','tempest-ImagesTestJSON-1780438391','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(68,'9516f569-48fb-4a10-80ea-c3a613366509','boot_roles','reader,member','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(69,'9516f569-48fb-4a10-80ea-c3a613366509','hw_machine_type','q35','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(70,'9516f569-48fb-4a10-80ea-c3a613366509','hw_cdrom_bus','sata','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(71,'9516f569-48fb-4a10-80ea-c3a613366509','hw_disk_bus','virtio','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(72,'9516f569-48fb-4a10-80ea-c3a613366509','hw_input_bus','usb','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(73,'9516f569-48fb-4a10-80ea-c3a613366509','hw_pointer_model','usbtablet','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(74,'9516f569-48fb-4a10-80ea-c3a613366509','hw_video_model','virtio','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(75,'9516f569-48fb-4a10-80ea-c3a613366509','hw_vif_model','virtio','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(76,'9516f569-48fb-4a10-80ea-c3a613366509','instance_uuid','96050b75-1cb6-4b1d-86a1-b86a21570ab2','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(77,'9516f569-48fb-4a10-80ea-c3a613366509','user_id','46ffd64a348845fab6cdc53249353575','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(78,'9516f569-48fb-4a10-80ea-c3a613366509','image_type','snapshot','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(79,'9516f569-48fb-4a10-80ea-c3a613366509','image_location','snapshot','2026-01-31 08:01:53','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(80,'9516f569-48fb-4a10-80ea-c3a613366509','owner_id','521dcd459f144f2bb32de93d50ae0391','2026-01-31 08:01:53','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(81,'9516f569-48fb-4a10-80ea-c3a613366509','image_state','available','2026-01-31 08:01:53','2026-01-31 08:01:59','2026-01-31 08:01:59',1),(82,'48732de6-33cc-4857-a389-34f02c69b538','hw_rng_model','virtio','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(83,'48732de6-33cc-4857-a389-34f02c69b538','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(84,'48732de6-33cc-4857-a389-34f02c69b538','owner_user_name','tempest-ImagesTestJSON-1780438391-project-member','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(85,'48732de6-33cc-4857-a389-34f02c69b538','owner_project_name','tempest-ImagesTestJSON-1780438391','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(86,'48732de6-33cc-4857-a389-34f02c69b538','boot_roles','reader,member','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(87,'48732de6-33cc-4857-a389-34f02c69b538','hw_machine_type','q35','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(88,'48732de6-33cc-4857-a389-34f02c69b538','hw_cdrom_bus','sata','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(89,'48732de6-33cc-4857-a389-34f02c69b538','hw_disk_bus','virtio','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(90,'48732de6-33cc-4857-a389-34f02c69b538','hw_input_bus','usb','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(91,'48732de6-33cc-4857-a389-34f02c69b538','hw_pointer_model','usbtablet','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(92,'48732de6-33cc-4857-a389-34f02c69b538','hw_video_model','virtio','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(93,'48732de6-33cc-4857-a389-34f02c69b538','hw_vif_model','virtio','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(94,'48732de6-33cc-4857-a389-34f02c69b538','old_vm_state','active','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(95,'48732de6-33cc-4857-a389-34f02c69b538','instance_uuid','e0363e14-d6b9-4bed-a555-4466ddb7790d','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(96,'48732de6-33cc-4857-a389-34f02c69b538','user_id','46ffd64a348845fab6cdc53249353575','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(97,'48732de6-33cc-4857-a389-34f02c69b538','image_type','snapshot','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(98,'48732de6-33cc-4857-a389-34f02c69b538','image_location','snapshot','2026-01-31 08:02:30','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(99,'48732de6-33cc-4857-a389-34f02c69b538','owner_id','521dcd459f144f2bb32de93d50ae0391','2026-01-31 08:02:30','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(100,'48732de6-33cc-4857-a389-34f02c69b538','image_state','available','2026-01-31 08:02:30','2026-01-31 08:02:37','2026-01-31 08:02:37',1),(101,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_rng_model','virtio','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(102,'3676ca5a-2e55-4575-bc3f-672af49a103b','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(103,'3676ca5a-2e55-4575-bc3f-672af49a103b','owner_user_name','tempest-ImagesOneServerTestJSON-77816411-project-member','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(104,'3676ca5a-2e55-4575-bc3f-672af49a103b','owner_project_name','tempest-ImagesOneServerTestJSON-77816411','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(105,'3676ca5a-2e55-4575-bc3f-672af49a103b','boot_roles','member,reader','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(106,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_machine_type','q35','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(107,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_cdrom_bus','sata','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(108,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_disk_bus','virtio','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(109,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_input_bus','usb','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(110,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_pointer_model','usbtablet','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(111,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_video_model','virtio','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(112,'3676ca5a-2e55-4575-bc3f-672af49a103b','hw_vif_model','virtio','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(113,'3676ca5a-2e55-4575-bc3f-672af49a103b','instance_uuid','4470f2e9-7e12-43b5-a9a5-f690f2509954','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(114,'3676ca5a-2e55-4575-bc3f-672af49a103b','user_id','97778ff629964356819ef34be55ca5a6','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(115,'3676ca5a-2e55-4575-bc3f-672af49a103b','image_type','test','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(116,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_rng_model','virtio','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(117,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(118,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','owner_user_name','tempest-ImagesTestJSON-1780438391-project-member','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(119,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','owner_project_name','tempest-ImagesTestJSON-1780438391','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(120,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','boot_roles','member,reader','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(121,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_machine_type','q35','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(122,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_cdrom_bus','sata','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(123,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_disk_bus','virtio','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(124,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_input_bus','usb','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(125,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_pointer_model','usbtablet','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(126,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_video_model','virtio','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(127,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','hw_vif_model','virtio','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(128,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','instance_uuid','e549bdcc-5097-4890-8754-89d9f1d15a13','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(129,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','user_id','46ffd64a348845fab6cdc53249353575','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(130,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','image_type','snapshot','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(131,'3676ca5a-2e55-4575-bc3f-672af49a103b','image_location','snapshot','2026-01-31 08:03:14','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(132,'3676ca5a-2e55-4575-bc3f-672af49a103b','owner_id','03f24e162c6d454aa9e31d60b478001d','2026-01-31 08:03:14','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(133,'3676ca5a-2e55-4575-bc3f-672af49a103b','image_state','available','2026-01-31 08:03:14','2026-01-31 08:03:19','2026-01-31 08:03:19',1),(134,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','image_location','snapshot','2026-01-31 08:03:16','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(135,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','owner_id','521dcd459f144f2bb32de93d50ae0391','2026-01-31 08:03:16','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(136,'4f6468b7-082d-4995-a147-34ef0ccaa0d2','image_state','available','2026-01-31 08:03:16','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(137,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_rng_model','virtio','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(138,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(139,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','owner_user_name','tempest-ImagesOneServerTestJSON-77816411-project-member','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(140,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','owner_project_name','tempest-ImagesOneServerTestJSON-77816411','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(141,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','boot_roles','member,reader','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(142,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_machine_type','q35','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(143,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_cdrom_bus','sata','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(144,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_disk_bus','virtio','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(145,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_input_bus','usb','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(146,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_pointer_model','usbtablet','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(147,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_video_model','virtio','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(148,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','hw_vif_model','virtio','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(149,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','instance_uuid','4470f2e9-7e12-43b5-a9a5-f690f2509954','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(150,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','user_id','97778ff629964356819ef34be55ca5a6','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(151,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','image_type','snapshot','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(152,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','image_location','snapshot','2026-01-31 08:03:41','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(153,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','owner_id','03f24e162c6d454aa9e31d60b478001d','2026-01-31 08:03:41','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(154,'0329a887-4ad2-4163-bd3c-ee2a3ded1631','image_state','available','2026-01-31 08:03:41','2026-01-31 08:03:49','2026-01-31 08:03:49',1),(155,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_rng_model','virtio','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(156,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(157,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','owner_user_name','tempest-ListImageFiltersTestJSON-1012419265-project-member','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(158,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','owner_project_name','tempest-ListImageFiltersTestJSON-1012419265','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(159,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','boot_roles','member,reader','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(160,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_machine_type','q35','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(161,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_cdrom_bus','sata','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(162,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_disk_bus','virtio','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(163,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_input_bus','usb','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(164,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_pointer_model','usbtablet','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(165,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_video_model','virtio','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(166,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','hw_vif_model','virtio','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(167,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','instance_uuid','5667536c-3b20-4b38-b8e4-c85686a1eae2','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(168,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','user_id','fd3d70d97c394edaa70e32807d7a96ca','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(169,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','image_type','snapshot','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(170,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','image_location','snapshot','2026-01-31 08:04:08','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(171,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','owner_id','3d28270b439f4cb1aa201d46b9f8a843','2026-01-31 08:04:08','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(172,'58c2d049-2cc3-4799-9c9b-054364bb8a5e','image_state','available','2026-01-31 08:04:08','2026-01-31 08:04:51','2026-01-31 08:04:51',1),(173,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_rng_model','virtio','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(174,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(175,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','owner_user_name','tempest-ImagesTestJSON-1780438391-project-member','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(176,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','owner_project_name','tempest-ImagesTestJSON-1780438391','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(177,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','boot_roles','reader,member','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(178,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_machine_type','q35','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(179,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_cdrom_bus','sata','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(180,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_disk_bus','virtio','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(181,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_input_bus','usb','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(182,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_pointer_model','usbtablet','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(183,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_video_model','virtio','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(184,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','hw_vif_model','virtio','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(185,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','instance_uuid','734f32c9-a26a-41c8-bd90-f34e16a6503c','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(186,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','user_id','46ffd64a348845fab6cdc53249353575','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(187,'0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','image_type','snapshot','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1),(188,'c60105d3-836b-48ac-bea6-55acfd972195','hw_rng_model','virtio','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(189,'c60105d3-836b-48ac-bea6-55acfd972195','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(190,'c60105d3-836b-48ac-bea6-55acfd972195','owner_user_name','tempest-ListImageFiltersTestJSON-1012419265-project-member','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(191,'c60105d3-836b-48ac-bea6-55acfd972195','owner_project_name','tempest-ListImageFiltersTestJSON-1012419265','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(192,'c60105d3-836b-48ac-bea6-55acfd972195','boot_roles','member,reader','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(193,'c60105d3-836b-48ac-bea6-55acfd972195','hw_machine_type','q35','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(194,'c60105d3-836b-48ac-bea6-55acfd972195','hw_cdrom_bus','sata','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(195,'c60105d3-836b-48ac-bea6-55acfd972195','hw_disk_bus','virtio','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(196,'c60105d3-836b-48ac-bea6-55acfd972195','hw_input_bus','usb','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(197,'c60105d3-836b-48ac-bea6-55acfd972195','hw_pointer_model','usbtablet','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(198,'c60105d3-836b-48ac-bea6-55acfd972195','hw_video_model','virtio','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(199,'c60105d3-836b-48ac-bea6-55acfd972195','hw_vif_model','virtio','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(200,'c60105d3-836b-48ac-bea6-55acfd972195','instance_uuid','7d051fe7-956a-4c8c-9f91-47c8c057964c','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(201,'c60105d3-836b-48ac-bea6-55acfd972195','user_id','fd3d70d97c394edaa70e32807d7a96ca','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(202,'c60105d3-836b-48ac-bea6-55acfd972195','image_type','snapshot','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(203,'c60105d3-836b-48ac-bea6-55acfd972195','image_location','snapshot','2026-01-31 08:04:21','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(204,'c60105d3-836b-48ac-bea6-55acfd972195','owner_id','3d28270b439f4cb1aa201d46b9f8a843','2026-01-31 08:04:21','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(205,'c60105d3-836b-48ac-bea6-55acfd972195','image_state','available','2026-01-31 08:04:21','2026-01-31 08:04:49','2026-01-31 08:04:49',1),(206,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_rng_model','virtio','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(207,'d9bfe40a-4757-4935-8bdd-50aa5c769418','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(208,'d9bfe40a-4757-4935-8bdd-50aa5c769418','owner_user_name','tempest-ListImageFiltersTestJSON-1012419265-project-member','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(209,'d9bfe40a-4757-4935-8bdd-50aa5c769418','owner_project_name','tempest-ListImageFiltersTestJSON-1012419265','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(210,'d9bfe40a-4757-4935-8bdd-50aa5c769418','boot_roles','member,reader','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(211,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_machine_type','q35','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(212,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_cdrom_bus','sata','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(213,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_disk_bus','virtio','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(214,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_input_bus','usb','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(215,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_pointer_model','usbtablet','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(216,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_video_model','virtio','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(217,'d9bfe40a-4757-4935-8bdd-50aa5c769418','hw_vif_model','virtio','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(218,'d9bfe40a-4757-4935-8bdd-50aa5c769418','instance_uuid','5667536c-3b20-4b38-b8e4-c85686a1eae2','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(219,'d9bfe40a-4757-4935-8bdd-50aa5c769418','user_id','fd3d70d97c394edaa70e32807d7a96ca','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(220,'d9bfe40a-4757-4935-8bdd-50aa5c769418','image_type','snapshot','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(221,'d9bfe40a-4757-4935-8bdd-50aa5c769418','image_location','snapshot','2026-01-31 08:04:32','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(222,'d9bfe40a-4757-4935-8bdd-50aa5c769418','owner_id','3d28270b439f4cb1aa201d46b9f8a843','2026-01-31 08:04:32','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(223,'d9bfe40a-4757-4935-8bdd-50aa5c769418','image_state','available','2026-01-31 08:04:32','2026-01-31 08:04:47','2026-01-31 08:04:47',1),(224,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_rng_model','virtio','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(225,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(226,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1383889839-project-member','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(227,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1383889839','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(228,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','boot_roles','member,reader','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(229,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_machine_type','q35','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(230,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_cdrom_bus','sata','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(231,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_disk_bus','virtio','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(232,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_input_bus','usb','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(233,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_pointer_model','usbtablet','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(234,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_video_model','virtio','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(235,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','hw_vif_model','virtio','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(236,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','instance_uuid','2dd4a0d4-fd17-4933-9f6d-4a5e84ce8701','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(237,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','user_id','57fcb774fb574bf0beea4fb49adb0f80','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(238,'6f41fe69-cbe5-422f-b305-4d86e60f48e0','image_type','snapshot','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1),(239,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_rng_model','virtio','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(240,'77b495b5-932c-4164-94ff-e9ef49f712d3','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(241,'77b495b5-932c-4164-94ff-e9ef49f712d3','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-1383889839-project-member','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(242,'77b495b5-932c-4164-94ff-e9ef49f712d3','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-1383889839','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(243,'77b495b5-932c-4164-94ff-e9ef49f712d3','boot_roles','reader,member','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(244,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_machine_type','q35','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(245,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_cdrom_bus','sata','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(246,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_disk_bus','virtio','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(247,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_input_bus','usb','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(248,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_pointer_model','usbtablet','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(249,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_video_model','virtio','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(250,'77b495b5-932c-4164-94ff-e9ef49f712d3','hw_vif_model','virtio','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(251,'77b495b5-932c-4164-94ff-e9ef49f712d3','instance_uuid','56447338-cea0-4d74-b9e1-bac3b5d793a0','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(252,'77b495b5-932c-4164-94ff-e9ef49f712d3','user_id','57fcb774fb574bf0beea4fb49adb0f80','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(253,'77b495b5-932c-4164-94ff-e9ef49f712d3','image_type','snapshot','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1),(254,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_rng_model','virtio','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(255,'7b781d58-222d-48fb-b75e-dda36a2cb764','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(256,'7b781d58-222d-48fb-b75e-dda36a2cb764','owner_user_name','tempest-DeleteServersTestJSON-808715310-project-member','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(257,'7b781d58-222d-48fb-b75e-dda36a2cb764','owner_project_name','tempest-DeleteServersTestJSON-808715310','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(258,'7b781d58-222d-48fb-b75e-dda36a2cb764','boot_roles','reader,member','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(259,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_machine_type','q35','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(260,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_cdrom_bus','sata','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(261,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_disk_bus','virtio','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(262,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_input_bus','usb','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(263,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_pointer_model','usbtablet','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(264,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_video_model','virtio','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(265,'7b781d58-222d-48fb-b75e-dda36a2cb764','hw_vif_model','virtio','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(266,'7b781d58-222d-48fb-b75e-dda36a2cb764','instance_uuid','23ffafae-0fb8-48ec-9843-b0127f61e340','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(267,'7b781d58-222d-48fb-b75e-dda36a2cb764','user_id','16d731f5875748ca9b8036b2ba061042','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(268,'7b781d58-222d-48fb-b75e-dda36a2cb764','image_type','snapshot','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(269,'7b781d58-222d-48fb-b75e-dda36a2cb764','owner_id','3469c253459e40e39dcf5bcb6a32008f','2026-01-31 08:07:59','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(270,'7b781d58-222d-48fb-b75e-dda36a2cb764','image_location','snapshot','2026-01-31 08:07:59','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(271,'7b781d58-222d-48fb-b75e-dda36a2cb764','image_state','available','2026-01-31 08:07:59','2026-01-31 08:08:17','2026-01-31 08:08:17',1),(272,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_rng_model','virtio','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(273,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(274,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','owner_user_name','tempest-ServersAaction247Test-777376341-project-member','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(275,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','owner_project_name','tempest-ServersAaction247Test-777376341','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(276,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','boot_roles','member,reader','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(277,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_machine_type','q35','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(278,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_cdrom_bus','sata','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(279,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_disk_bus','virtio','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(280,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_input_bus','usb','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(281,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_pointer_model','usbtablet','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(282,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_video_model','virtio','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(283,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','hw_vif_model','virtio','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(284,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','instance_uuid','2d301840-aeb7-41c2-8de1-80b4ed9c22bc','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(285,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','user_id','124a117e3bc74be7a699df447518bc54','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(286,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','image_type','backup','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(287,'0c260c73-6d17-4f48-aca0-c7eec1c4cba0','backup_type','daily','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1),(288,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_rng_model','virtio','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(289,'4659652d-d50c-40d4-aa17-bb68b7e73113','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(290,'4659652d-d50c-40d4-aa17-bb68b7e73113','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-468517745-project-member','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(291,'4659652d-d50c-40d4-aa17-bb68b7e73113','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-468517745','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(292,'4659652d-d50c-40d4-aa17-bb68b7e73113','boot_roles','reader,member','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(293,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_machine_type','q35','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(294,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_cdrom_bus','sata','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(295,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_disk_bus','virtio','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(296,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_input_bus','usb','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(297,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_pointer_model','usbtablet','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(298,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_video_model','virtio','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(299,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_vif_model','virtio','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(300,'4659652d-d50c-40d4-aa17-bb68b7e73113','instance_uuid','f02cbbe1-1133-4659-a065-630c53ee2683','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(301,'4659652d-d50c-40d4-aa17-bb68b7e73113','user_id','f4d66dd0b7ff443cbcdb6e2c9f5c4c8c','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(302,'4659652d-d50c-40d4-aa17-bb68b7e73113','image_type','snapshot','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(303,'4659652d-d50c-40d4-aa17-bb68b7e73113','image_location','snapshot','2026-01-31 08:20:44','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(304,'4659652d-d50c-40d4-aa17-bb68b7e73113','owner_id','cf024d54545b4af882a87c721105742a','2026-01-31 08:20:44','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(305,'4659652d-d50c-40d4-aa17-bb68b7e73113','image_state','available','2026-01-31 08:20:44','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(306,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_rescue_bus','virtio','2026-01-31 08:21:19','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(307,'4659652d-d50c-40d4-aa17-bb68b7e73113','hw_rescue_device','disk','2026-01-31 08:21:20','2026-01-31 08:27:35','2026-01-31 08:27:35',1),(308,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_rng_model','virtio','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(309,'27d563e8-5fbe-4653-b526-f8048559e6cd','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(310,'27d563e8-5fbe-4653-b526-f8048559e6cd','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-468517745-project-member','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(311,'27d563e8-5fbe-4653-b526-f8048559e6cd','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-468517745','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(312,'27d563e8-5fbe-4653-b526-f8048559e6cd','boot_roles','reader,member','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(313,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_machine_type','q35','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(314,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_cdrom_bus','sata','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(315,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_disk_bus','virtio','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(316,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_input_bus','usb','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(317,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_pointer_model','usbtablet','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(318,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_video_model','virtio','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(319,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_vif_model','virtio','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(320,'27d563e8-5fbe-4653-b526-f8048559e6cd','instance_uuid','dbf4e573-8e19-4920-aab9-c290d7d8eeec','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(321,'27d563e8-5fbe-4653-b526-f8048559e6cd','user_id','f4d66dd0b7ff443cbcdb6e2c9f5c4c8c','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(322,'27d563e8-5fbe-4653-b526-f8048559e6cd','image_type','snapshot','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(323,'27d563e8-5fbe-4653-b526-f8048559e6cd','image_location','snapshot','2026-01-31 08:23:29','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(324,'27d563e8-5fbe-4653-b526-f8048559e6cd','owner_id','cf024d54545b4af882a87c721105742a','2026-01-31 08:23:29','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(325,'27d563e8-5fbe-4653-b526-f8048559e6cd','image_state','available','2026-01-31 08:23:29','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(326,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_rescue_bus','virtio','2026-01-31 08:24:42','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(327,'27d563e8-5fbe-4653-b526-f8048559e6cd','hw_rescue_device','disk','2026-01-31 08:24:43','2026-01-31 08:26:41','2026-01-31 08:26:41',1),(328,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_rng_model','virtio','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(329,'81322d27-2584-47ad-bfcd-7642da2c770e','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(330,'81322d27-2584-47ad-bfcd-7642da2c770e','owner_user_name','tempest-AttachVolumeShelveTestJSON-60119558-project-member','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(331,'81322d27-2584-47ad-bfcd-7642da2c770e','owner_project_name','tempest-AttachVolumeShelveTestJSON-60119558','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(332,'81322d27-2584-47ad-bfcd-7642da2c770e','boot_roles','member,reader','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(333,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_machine_type','q35','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(334,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_cdrom_bus','sata','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(335,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_disk_bus','virtio','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(336,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_input_bus','usb','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(337,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_pointer_model','usbtablet','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(338,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_video_model','virtio','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(339,'81322d27-2584-47ad-bfcd-7642da2c770e','hw_vif_model','virtio','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(340,'81322d27-2584-47ad-bfcd-7642da2c770e','instance_uuid','f3b36b5b-968c-4775-ac4f-93efc36f40ac','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(341,'81322d27-2584-47ad-bfcd-7642da2c770e','user_id','432ac8867d8240408db455fc25bb5901','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(342,'81322d27-2584-47ad-bfcd-7642da2c770e','image_type','snapshot','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(343,'81322d27-2584-47ad-bfcd-7642da2c770e','image_location','snapshot','2026-01-31 08:25:30','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(344,'81322d27-2584-47ad-bfcd-7642da2c770e','owner_id','491937de020742d7b4e847dc3bf57950','2026-01-31 08:25:30','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(345,'81322d27-2584-47ad-bfcd-7642da2c770e','image_state','available','2026-01-31 08:25:30','2026-01-31 08:27:05','2026-01-31 08:27:05',1),(346,'913987a4-398c-4df5-8903-96535743e328','hw_rng_model','virtio','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(347,'913987a4-398c-4df5-8903-96535743e328','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(348,'913987a4-398c-4df5-8903-96535743e328','owner_user_name','tempest-ServerActionsTestOtherB-1048458052-project-member','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(349,'913987a4-398c-4df5-8903-96535743e328','owner_project_name','tempest-ServerActionsTestOtherB-1048458052','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(350,'913987a4-398c-4df5-8903-96535743e328','boot_roles','member,reader','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(351,'913987a4-398c-4df5-8903-96535743e328','hw_machine_type','q35','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(352,'913987a4-398c-4df5-8903-96535743e328','hw_cdrom_bus','sata','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(353,'913987a4-398c-4df5-8903-96535743e328','hw_disk_bus','virtio','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(354,'913987a4-398c-4df5-8903-96535743e328','hw_input_bus','usb','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(355,'913987a4-398c-4df5-8903-96535743e328','hw_pointer_model','usbtablet','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(356,'913987a4-398c-4df5-8903-96535743e328','hw_video_model','virtio','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(357,'913987a4-398c-4df5-8903-96535743e328','hw_vif_model','virtio','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(358,'913987a4-398c-4df5-8903-96535743e328','instance_uuid','cca881fe-18fa-40c1-b9ef-2b1f28855b53','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(359,'913987a4-398c-4df5-8903-96535743e328','user_id','ef51681d234a4abc88ff433d0640b6e7','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(360,'913987a4-398c-4df5-8903-96535743e328','image_type','backup','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(361,'913987a4-398c-4df5-8903-96535743e328','backup_type','daily','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(362,'913987a4-398c-4df5-8903-96535743e328','image_location','snapshot','2026-01-31 08:26:40','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(363,'913987a4-398c-4df5-8903-96535743e328','owner_id','953a213fa5cb435ab3c04ad96152685f','2026-01-31 08:26:40','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(364,'913987a4-398c-4df5-8903-96535743e328','image_state','available','2026-01-31 08:26:40','2026-01-31 08:27:52','2026-01-31 08:27:52',1),(365,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_rng_model','virtio','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(366,'9dcdf407-c698-4570-bce4-edde88d1813b','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(367,'9dcdf407-c698-4570-bce4-edde88d1813b','owner_user_name','tempest-ServerActionsTestOtherB-1048458052-project-member','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(368,'9dcdf407-c698-4570-bce4-edde88d1813b','owner_project_name','tempest-ServerActionsTestOtherB-1048458052','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(369,'9dcdf407-c698-4570-bce4-edde88d1813b','boot_roles','member,reader','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(370,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_machine_type','q35','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(371,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_cdrom_bus','sata','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(372,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_disk_bus','virtio','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(373,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_input_bus','usb','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(374,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_pointer_model','usbtablet','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(375,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_video_model','virtio','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(376,'9dcdf407-c698-4570-bce4-edde88d1813b','hw_vif_model','virtio','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(377,'9dcdf407-c698-4570-bce4-edde88d1813b','instance_uuid','cca881fe-18fa-40c1-b9ef-2b1f28855b53','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(378,'9dcdf407-c698-4570-bce4-edde88d1813b','user_id','ef51681d234a4abc88ff433d0640b6e7','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(379,'9dcdf407-c698-4570-bce4-edde88d1813b','image_type','backup','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(380,'9dcdf407-c698-4570-bce4-edde88d1813b','backup_type','daily','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(381,'9dcdf407-c698-4570-bce4-edde88d1813b','image_location','snapshot','2026-01-31 08:27:16','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(382,'9dcdf407-c698-4570-bce4-edde88d1813b','owner_id','953a213fa5cb435ab3c04ad96152685f','2026-01-31 08:27:16','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(383,'9dcdf407-c698-4570-bce4-edde88d1813b','image_state','available','2026-01-31 08:27:16','2026-01-31 08:28:09','2026-01-31 08:28:09',1),(384,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_rng_model','virtio','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(385,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(386,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','owner_user_name','tempest-ServerActionsTestOtherB-1048458052-project-member','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(387,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','owner_project_name','tempest-ServerActionsTestOtherB-1048458052','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(388,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','boot_roles','member,reader','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(389,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_machine_type','q35','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(390,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_cdrom_bus','sata','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(391,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_disk_bus','virtio','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(392,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_input_bus','usb','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(393,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_pointer_model','usbtablet','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(394,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_video_model','virtio','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(395,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','hw_vif_model','virtio','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(396,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','instance_uuid','cca881fe-18fa-40c1-b9ef-2b1f28855b53','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(397,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','user_id','ef51681d234a4abc88ff433d0640b6e7','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(398,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','image_type','backup','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(399,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','backup_type','daily','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(400,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','image_location','snapshot','2026-01-31 08:27:35','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(401,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','owner_id','953a213fa5cb435ab3c04ad96152685f','2026-01-31 08:27:35','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(402,'3d658df0-f3c7-45a7-bf8b-c899f015d20b','image_state','available','2026-01-31 08:27:35','2026-01-31 08:28:03','2026-01-31 08:28:03',1),(403,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_rng_model','virtio','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(404,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(405,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','owner_user_name','tempest-AttachVolumeShelveTestJSON-60119558-project-member','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(406,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','owner_project_name','tempest-AttachVolumeShelveTestJSON-60119558','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(407,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','boot_roles','reader,member','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(408,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_machine_type','q35','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(409,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_cdrom_bus','sata','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(410,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_disk_bus','virtio','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(411,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_input_bus','usb','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(412,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_pointer_model','usbtablet','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(413,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_video_model','virtio','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(414,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','hw_vif_model','virtio','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(415,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','instance_uuid','b9f38b79-63fc-48a1-a367-6998b8d6a9dc','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(416,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','user_id','432ac8867d8240408db455fc25bb5901','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(417,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','image_type','snapshot','2026-01-31 08:28:43','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(418,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','image_location','snapshot','2026-01-31 08:29:00','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(419,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','owner_id','491937de020742d7b4e847dc3bf57950','2026-01-31 08:29:00','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(420,'0e9c5d39-8319-43cb-ac29-5664ec7c2a71','image_state','available','2026-01-31 08:29:00','2026-01-31 08:30:17','2026-01-31 08:30:17',1),(421,'e787704c-b374-4706-807f-a0d18a0ac398','hw_rng_model','virtio','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(422,'e787704c-b374-4706-807f-a0d18a0ac398','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(423,'e787704c-b374-4706-807f-a0d18a0ac398','owner_user_name','tempest-ServerActionsTestOtherB-1048458052-project-member','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(424,'e787704c-b374-4706-807f-a0d18a0ac398','owner_project_name','tempest-ServerActionsTestOtherB-1048458052','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(425,'e787704c-b374-4706-807f-a0d18a0ac398','boot_roles','reader,member','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(426,'e787704c-b374-4706-807f-a0d18a0ac398','hw_machine_type','q35','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(427,'e787704c-b374-4706-807f-a0d18a0ac398','hw_cdrom_bus','sata','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(428,'e787704c-b374-4706-807f-a0d18a0ac398','hw_disk_bus','virtio','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(429,'e787704c-b374-4706-807f-a0d18a0ac398','hw_input_bus','usb','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(430,'e787704c-b374-4706-807f-a0d18a0ac398','hw_pointer_model','usbtablet','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(431,'e787704c-b374-4706-807f-a0d18a0ac398','hw_video_model','virtio','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(432,'e787704c-b374-4706-807f-a0d18a0ac398','hw_vif_model','virtio','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(433,'e787704c-b374-4706-807f-a0d18a0ac398','instance_uuid','176ef4eb-8ab8-4e87-a1a6-e099ccb51fcc','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(434,'e787704c-b374-4706-807f-a0d18a0ac398','user_id','ef51681d234a4abc88ff433d0640b6e7','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(435,'e787704c-b374-4706-807f-a0d18a0ac398','image_type','snapshot','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(436,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_rng_model','virtio','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(437,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(438,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','owner_user_name','tempest-ServerStableDeviceRescueTest-319343227-project-member','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(439,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','owner_project_name','tempest-ServerStableDeviceRescueTest-319343227','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(440,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','boot_roles','reader,member','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(441,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_machine_type','q35','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(442,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_cdrom_bus','sata','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(443,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_disk_bus','virtio','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(444,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_input_bus','usb','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(445,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_pointer_model','usbtablet','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(446,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_video_model','virtio','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(447,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_vif_model','virtio','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(448,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','instance_uuid','9aac65c2-63f8-4383-80ed-6600852c6fb5','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(449,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','user_id','b6733330b634472ca8c21316f1ee5057','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(450,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','image_type','snapshot','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(451,'e787704c-b374-4706-807f-a0d18a0ac398','image_location','snapshot','2026-01-31 08:34:13','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(452,'e787704c-b374-4706-807f-a0d18a0ac398','owner_id','953a213fa5cb435ab3c04ad96152685f','2026-01-31 08:34:13','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(453,'e787704c-b374-4706-807f-a0d18a0ac398','image_state','available','2026-01-31 08:34:13','2026-01-31 08:35:15','2026-01-31 08:35:15',1),(454,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','owner_id','1e29363ca464487b931af54fe14166b1','2026-01-31 08:34:16','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(455,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','image_location','snapshot','2026-01-31 08:34:16','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(456,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','image_state','available','2026-01-31 08:34:16','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(457,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_rescue_bus','scsi','2026-01-31 08:34:19','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(458,'15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','hw_rescue_device','disk','2026-01-31 08:34:19','2026-01-31 08:41:44','2026-01-31 08:41:44',1),(459,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_rng_model','virtio','2026-01-31 08:34:23','2026-01-31 08:35:10','2026-01-31 08:35:10',1),(460,'a445cf05-8653-452b-bc15-8061b7aa6a98','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:34:23','2026-01-31 08:35:10','2026-01-31 08:35:10',1),(461,'a445cf05-8653-452b-bc15-8061b7aa6a98','owner_user_name','tempest-ServerActionsTestOtherB-1048458052-project-member','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(462,'a445cf05-8653-452b-bc15-8061b7aa6a98','owner_project_name','tempest-ServerActionsTestOtherB-1048458052','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(463,'a445cf05-8653-452b-bc15-8061b7aa6a98','boot_roles','reader,member','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(464,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_machine_type','q35','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(465,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_cdrom_bus','sata','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(466,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_disk_bus','virtio','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(467,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_input_bus','usb','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(468,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_pointer_model','usbtablet','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(469,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_video_model','virtio','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(470,'a445cf05-8653-452b-bc15-8061b7aa6a98','hw_vif_model','virtio','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(471,'a445cf05-8653-452b-bc15-8061b7aa6a98','instance_uuid','adfc4c25-9eb9-45cc-ac90-2029677bcb67','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(472,'a445cf05-8653-452b-bc15-8061b7aa6a98','user_id','ef51681d234a4abc88ff433d0640b6e7','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(473,'a445cf05-8653-452b-bc15-8061b7aa6a98','image_type','snapshot','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(474,'a445cf05-8653-452b-bc15-8061b7aa6a98','image_location','snapshot','2026-01-31 08:34:33','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(475,'a445cf05-8653-452b-bc15-8061b7aa6a98','owner_id','953a213fa5cb435ab3c04ad96152685f','2026-01-31 08:34:33','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(476,'a445cf05-8653-452b-bc15-8061b7aa6a98','image_state','available','2026-01-31 08:34:33','2026-01-31 08:35:11','2026-01-31 08:35:11',1),(477,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_rng_model','virtio','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(478,'357acf21-e111-4e02-8a13-c11baeb4f6ec','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(479,'357acf21-e111-4e02-8a13-c11baeb4f6ec','owner_user_name','tempest-ServerStableDeviceRescueTest-319343227-project-member','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(480,'357acf21-e111-4e02-8a13-c11baeb4f6ec','owner_project_name','tempest-ServerStableDeviceRescueTest-319343227','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(481,'357acf21-e111-4e02-8a13-c11baeb4f6ec','boot_roles','reader,member','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(482,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_machine_type','q35','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(483,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_cdrom_bus','sata','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(484,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_disk_bus','virtio','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(485,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_input_bus','usb','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(486,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_pointer_model','usbtablet','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(487,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_video_model','virtio','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(488,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_vif_model','virtio','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(489,'357acf21-e111-4e02-8a13-c11baeb4f6ec','instance_uuid','9707f58b-2c76-40df-b8a8-5df66bab50bb','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(490,'357acf21-e111-4e02-8a13-c11baeb4f6ec','user_id','b6733330b634472ca8c21316f1ee5057','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(491,'357acf21-e111-4e02-8a13-c11baeb4f6ec','image_type','snapshot','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(492,'357acf21-e111-4e02-8a13-c11baeb4f6ec','owner_id','1e29363ca464487b931af54fe14166b1','2026-01-31 08:35:18','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(493,'357acf21-e111-4e02-8a13-c11baeb4f6ec','image_location','snapshot','2026-01-31 08:35:18','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(494,'357acf21-e111-4e02-8a13-c11baeb4f6ec','image_state','available','2026-01-31 08:35:18','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(495,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_rescue_bus','usb','2026-01-31 08:35:22','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(496,'357acf21-e111-4e02-8a13-c11baeb4f6ec','hw_rescue_device','disk','2026-01-31 08:35:22','2026-01-31 08:41:20','2026-01-31 08:41:20',1),(497,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_rng_model','virtio','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(498,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(499,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','owner_user_name','tempest-ServerStableDeviceRescueTest-319343227-project-member','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(500,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','owner_project_name','tempest-ServerStableDeviceRescueTest-319343227','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(501,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','boot_roles','reader,member','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(502,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_machine_type','q35','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(503,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_cdrom_bus','sata','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(504,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_disk_bus','virtio','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(505,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_input_bus','usb','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(506,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_pointer_model','usbtablet','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(507,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_video_model','virtio','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(508,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_vif_model','virtio','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(509,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','instance_uuid','c95caf87-5069-4b70-9023-d3c2d911e87d','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(510,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','user_id','b6733330b634472ca8c21316f1ee5057','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(511,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','image_type','snapshot','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(512,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','image_location','snapshot','2026-01-31 08:36:40','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(513,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','owner_id','1e29363ca464487b931af54fe14166b1','2026-01-31 08:36:40','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(514,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','image_state','available','2026-01-31 08:36:40','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(515,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_rescue_bus','virtio','2026-01-31 08:36:49','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(516,'287f9894-83db-40a1-9a7f-ba7bbf17dc1d','hw_rescue_device','disk','2026-01-31 08:36:49','2026-01-31 08:41:08','2026-01-31 08:41:08',1),(517,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_rng_model','virtio','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(518,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(519,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','owner_user_name','tempest-ServerStableDeviceRescueTest-319343227-project-member','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(520,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','owner_project_name','tempest-ServerStableDeviceRescueTest-319343227','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(521,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','boot_roles','reader,member','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(522,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_machine_type','q35','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(523,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_cdrom_bus','sata','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(524,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_disk_bus','virtio','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(525,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_input_bus','usb','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(526,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_pointer_model','usbtablet','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(527,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_video_model','virtio','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(528,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_vif_model','virtio','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(529,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','instance_uuid','92bd94ef-0031-409f-8c26-23d5f3d952e1','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(530,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','user_id','b6733330b634472ca8c21316f1ee5057','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(531,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','image_type','snapshot','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(532,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','image_location','snapshot','2026-01-31 08:39:16','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(533,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','owner_id','1e29363ca464487b931af54fe14166b1','2026-01-31 08:39:16','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(534,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','image_state','available','2026-01-31 08:39:16','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(535,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_rescue_bus','virtio','2026-01-31 08:39:22','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(536,'9bc0d84f-a933-4fd8-8f17-38e2aca81cce','hw_rescue_device','disk','2026-01-31 08:39:22','2026-01-31 08:40:46','2026-01-31 08:40:46',1),(537,'269becbf-04a2-4537-bd31-66899150ed70','hw_rng_model','virtio','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(538,'269becbf-04a2-4537-bd31-66899150ed70','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(539,'269becbf-04a2-4537-bd31-66899150ed70','owner_user_name','tempest-ServersNegativeTestJSON-183161027-project-member','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(540,'269becbf-04a2-4537-bd31-66899150ed70','owner_project_name','tempest-ServersNegativeTestJSON-183161027','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(541,'269becbf-04a2-4537-bd31-66899150ed70','boot_roles','member,reader','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(542,'269becbf-04a2-4537-bd31-66899150ed70','hw_machine_type','q35','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(543,'269becbf-04a2-4537-bd31-66899150ed70','hw_cdrom_bus','sata','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(544,'269becbf-04a2-4537-bd31-66899150ed70','hw_disk_bus','virtio','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(545,'269becbf-04a2-4537-bd31-66899150ed70','hw_input_bus','usb','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(546,'269becbf-04a2-4537-bd31-66899150ed70','hw_pointer_model','usbtablet','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(547,'269becbf-04a2-4537-bd31-66899150ed70','hw_video_model','virtio','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(548,'269becbf-04a2-4537-bd31-66899150ed70','hw_vif_model','virtio','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(549,'269becbf-04a2-4537-bd31-66899150ed70','instance_uuid','bd87e542-0f7b-453e-b8d1-643ad6fb64f0','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(550,'269becbf-04a2-4537-bd31-66899150ed70','user_id','516e093a00a44667ba1308900be70d8d','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(551,'269becbf-04a2-4537-bd31-66899150ed70','image_type','snapshot','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(552,'269becbf-04a2-4537-bd31-66899150ed70','image_location','snapshot','2026-01-31 08:42:12','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(553,'269becbf-04a2-4537-bd31-66899150ed70','owner_id','621c17d53cba46d386de8efb560a988e','2026-01-31 08:42:12','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(554,'269becbf-04a2-4537-bd31-66899150ed70','image_state','available','2026-01-31 08:42:12','2026-01-31 08:43:18','2026-01-31 08:43:18',1),(555,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','signature_verified','False','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(556,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_rng_model','virtio','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(557,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','base_image_ref','','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(558,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','owner_user_name','tempest-AttachVolumeMultiAttachTest-1931311941-project-member','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(559,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','owner_project_name','tempest-AttachVolumeMultiAttachTest-1931311941','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(560,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','boot_roles','reader,member','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(561,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_machine_type','q35','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(562,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_cdrom_bus','sata','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(563,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_disk_bus','virtio','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(564,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_input_bus','usb','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(565,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_pointer_model','usbtablet','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(566,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_video_model','virtio','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(567,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','hw_vif_model','virtio','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(568,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','root_device_name','/dev/vda','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(569,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','block_device_mapping','[{\"delete_on_termination\": false, \"no_device\": null, \"volume_size\": 1, \"volume_type\": null, \"tag\": null, \"device_name\": \"/dev/vda\", \"snapshot_id\": \"cf78778e-15b7-4039-9f65-5985e69a326f\", \"encryption_format\": null, \"device_type\": \"disk\", \"image_id\": null, \"destination_type\": \"volume\", \"guest_format\": null, \"volume_id\": null, \"encryption_secret_uuid\": null, \"disk_bus\": \"virtio\", \"encrypted\": null, \"source_type\": \"snapshot\", \"boot_index\": 0, \"encryption_options\": null}]','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(570,'24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','bdm_v2','True','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1),(571,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_rng_model','virtio','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(572,'297f46fc-627f-48b0-8a66-2e6f3dab7554','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(573,'297f46fc-627f-48b0-8a66-2e6f3dab7554','owner_user_name','tempest-TestShelveInstance-1813478377-project-member','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(574,'297f46fc-627f-48b0-8a66-2e6f3dab7554','owner_project_name','tempest-TestShelveInstance-1813478377','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(575,'297f46fc-627f-48b0-8a66-2e6f3dab7554','boot_roles','reader,member','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(576,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_machine_type','q35','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(577,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_cdrom_bus','sata','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(578,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_disk_bus','virtio','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(579,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_input_bus','usb','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(580,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_pointer_model','usbtablet','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(581,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_video_model','virtio','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(582,'297f46fc-627f-48b0-8a66-2e6f3dab7554','hw_vif_model','virtio','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(583,'297f46fc-627f-48b0-8a66-2e6f3dab7554','instance_uuid','3f0d401f-df22-424f-b572-4eb9ab2df0f4','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(584,'297f46fc-627f-48b0-8a66-2e6f3dab7554','user_id','3859f52c5b70471097d1e4ffa75ecc0e','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(585,'297f46fc-627f-48b0-8a66-2e6f3dab7554','image_type','snapshot','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(586,'297f46fc-627f-48b0-8a66-2e6f3dab7554','image_location','snapshot','2026-01-31 09:00:08','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(587,'297f46fc-627f-48b0-8a66-2e6f3dab7554','owner_id','1f293713f6854265a89a1a4a002088d5','2026-01-31 09:00:08','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(588,'297f46fc-627f-48b0-8a66-2e6f3dab7554','image_state','available','2026-01-31 09:00:08','2026-01-31 09:00:43','2026-01-31 09:00:43',1),(589,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','signature_verified','False','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(590,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_rng_model','virtio','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(591,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','base_image_ref','','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(592,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','owner_user_name','tempest-TestVolumeBootPattern-1392945362-project-member','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(593,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','owner_project_name','tempest-TestVolumeBootPattern-1392945362','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(594,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','boot_roles','reader,member','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(595,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_machine_type','q35','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(596,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_cdrom_bus','sata','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(597,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_disk_bus','virtio','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(598,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_input_bus','usb','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(599,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_pointer_model','usbtablet','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(600,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_video_model','virtio','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(601,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','hw_vif_model','virtio','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(602,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','root_device_name','/dev/vda','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(603,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','block_device_mapping','[{\"encryption_options\": null, \"source_type\": \"snapshot\", \"encryption_secret_uuid\": null, \"boot_index\": 0, \"encrypted\": null, \"disk_bus\": \"virtio\", \"volume_id\": null, \"encryption_format\": null, \"guest_format\": null, \"destination_type\": \"volume\", \"device_type\": \"disk\", \"delete_on_termination\": true, \"image_id\": null, \"volume_type\": null, \"snapshot_id\": \"a5bb09a5-5ee5-473c-a7c9-bc49c24b7332\", \"tag\": null, \"volume_size\": 1, \"device_name\": \"/dev/vda\", \"no_device\": null}]','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(604,'7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','bdm_v2','True','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1),(605,'f398889c-e272-449f-a032-36096e95d18f','hw_rng_model','virtio','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(606,'f398889c-e272-449f-a032-36096e95d18f','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(607,'f398889c-e272-449f-a032-36096e95d18f','owner_user_name','tempest-TestSnapshotPattern-418405266-project-member','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(608,'f398889c-e272-449f-a032-36096e95d18f','owner_project_name','tempest-TestSnapshotPattern-418405266','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(609,'f398889c-e272-449f-a032-36096e95d18f','boot_roles','member,reader','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(610,'f398889c-e272-449f-a032-36096e95d18f','hw_machine_type','q35','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(611,'f398889c-e272-449f-a032-36096e95d18f','hw_cdrom_bus','sata','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(612,'f398889c-e272-449f-a032-36096e95d18f','hw_disk_bus','virtio','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(613,'f398889c-e272-449f-a032-36096e95d18f','hw_input_bus','usb','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(614,'f398889c-e272-449f-a032-36096e95d18f','hw_pointer_model','usbtablet','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(615,'f398889c-e272-449f-a032-36096e95d18f','hw_video_model','virtio','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(616,'f398889c-e272-449f-a032-36096e95d18f','hw_vif_model','virtio','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(617,'f398889c-e272-449f-a032-36096e95d18f','instance_uuid','f0b8c4bd-36b6-479c-9160-9adb3a86dc6f','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(618,'f398889c-e272-449f-a032-36096e95d18f','user_id','b7233f93367f4dcd8eb2b6b115680192','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(619,'f398889c-e272-449f-a032-36096e95d18f','image_type','snapshot','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(620,'f398889c-e272-449f-a032-36096e95d18f','owner_id','c0be57039fd34aa9a2d05d9086ccff13','2026-01-31 09:11:12','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(621,'f398889c-e272-449f-a032-36096e95d18f','image_location','snapshot','2026-01-31 09:11:12','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(622,'f398889c-e272-449f-a032-36096e95d18f','image_state','available','2026-01-31 09:11:12','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(623,'f398889c-e272-449f-a032-36096e95d18f','version','8.0','2026-01-31 09:11:14','2026-01-31 09:12:15','2026-01-31 09:12:15',1),(624,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_rng_model','virtio','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(625,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(626,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','owner_user_name','tempest-TestSnapshotPattern-418405266-project-member','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(627,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','owner_project_name','tempest-TestSnapshotPattern-418405266','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(628,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','boot_roles','member,reader','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(629,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_machine_type','q35','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(630,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_cdrom_bus','sata','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(631,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_disk_bus','virtio','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(632,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_input_bus','usb','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(633,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_pointer_model','usbtablet','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(634,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_video_model','virtio','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(635,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','hw_vif_model','virtio','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(636,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','instance_uuid','c893e608-08e4-4eab-a992-b241e484ea48','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(637,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','user_id','b7233f93367f4dcd8eb2b6b115680192','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(638,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','image_type','snapshot','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(639,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','owner_id','c0be57039fd34aa9a2d05d9086ccff13','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(640,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','image_location','snapshot','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(641,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','image_state','available','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(642,'a6036a30-758c-46f5-b0cb-e59cf3a4220b','version','8.0','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1),(643,'0d074876-a373-4784-8303-5b3716508074','hw_rng_model','virtio','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(644,'0d074876-a373-4784-8303-5b3716508074','base_image_ref','37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(645,'0d074876-a373-4784-8303-5b3716508074','owner_user_name','tempest-TestStampPattern-1434051857-project-member','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(646,'0d074876-a373-4784-8303-5b3716508074','owner_project_name','tempest-TestStampPattern-1434051857','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(647,'0d074876-a373-4784-8303-5b3716508074','boot_roles','reader,member','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(648,'0d074876-a373-4784-8303-5b3716508074','hw_machine_type','q35','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(649,'0d074876-a373-4784-8303-5b3716508074','hw_cdrom_bus','sata','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(650,'0d074876-a373-4784-8303-5b3716508074','hw_disk_bus','virtio','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(651,'0d074876-a373-4784-8303-5b3716508074','hw_input_bus','usb','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(652,'0d074876-a373-4784-8303-5b3716508074','hw_pointer_model','usbtablet','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(653,'0d074876-a373-4784-8303-5b3716508074','hw_video_model','virtio','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(654,'0d074876-a373-4784-8303-5b3716508074','hw_vif_model','virtio','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(655,'0d074876-a373-4784-8303-5b3716508074','instance_uuid','4e6fd1c3-3988-4a7f-a30d-b599226c25a0','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(656,'0d074876-a373-4784-8303-5b3716508074','user_id','4f25568607234a398bc35cbb67eb406f','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(657,'0d074876-a373-4784-8303-5b3716508074','image_type','snapshot','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(658,'0d074876-a373-4784-8303-5b3716508074','image_location','snapshot','2026-01-31 09:17:24','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(659,'0d074876-a373-4784-8303-5b3716508074','owner_id','390709b3e5174dc4afdc6b04fdae67e3','2026-01-31 09:17:24','2026-01-31 09:18:44','2026-01-31 09:18:44',1),(660,'0d074876-a373-4784-8303-5b3716508074','image_state','available','2026-01-31 09:17:24','2026-01-31 09:18:44','2026-01-31 09:18:44',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0329a887-4ad2-4163-bd3c-ee2a3ded1631','tempest-₡-2196576',1073741824,'deleted','2026-01-31 08:03:21','2026-01-31 08:03:49','2026-01-31 08:03:49',1,'raw','bare',NULL,'03f24e162c6d454aa9e31d60b478001d',1,0,0,NULL,'private',0,NULL,NULL),('0864ca59-9877-4e6d-adfc-f0a3204ed8f8','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-31 07:43:45','2026-01-31 07:43:47',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','89e274acfc5c4097be7194f5ef1fabd3',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('0c260c73-6d17-4f48-aca0-c7eec1c4cba0','tempest-backup-1-1779953875',NULL,'deleted','2026-01-31 08:19:19','2026-01-31 08:19:21','2026-01-31 08:19:21',1,'qcow2','bare',NULL,'0470bddbdc05460087ff3c4b7dbb6dcd',1,0,0,NULL,'private',0,NULL,NULL),('0c74ddc7-49a4-4f2d-83ce-f79f5ae16288','tempest-test-snap-1147602752',NULL,'deleted','2026-01-31 08:04:09','2026-01-31 08:04:11','2026-01-31 08:04:11',1,NULL,NULL,NULL,'521dcd459f144f2bb32de93d50ae0391',1,0,0,NULL,'private',0,NULL,NULL),('0d074876-a373-4784-8303-5b3716508074','tempest-TestStampPatternsnapshot-1049747782',1073741824,'deleted','2026-01-31 09:17:19','2026-01-31 09:18:44','2026-01-31 09:18:44',1,'raw','bare',NULL,'390709b3e5174dc4afdc6b04fdae67e3',1,0,0,NULL,'private',0,NULL,NULL),('0e9c5d39-8319-43cb-ac29-5664ec7c2a71','tempest-AttachVolumeShelveTestJSON-server-2092089502-shelved',1073741824,'deleted','2026-01-31 08:28:42','2026-01-31 08:30:17','2026-01-31 08:30:17',1,'raw','bare',NULL,'491937de020742d7b4e847dc3bf57950',1,0,0,NULL,'private',0,NULL,NULL),('15979fb2-ffd4-4e76-9dfb-7c7ce052fa99','tempest-ServerStableDeviceRescueTest-image-1645260623',1073741824,'deleted','2026-01-31 08:34:12','2026-01-31 08:41:44','2026-01-31 08:41:44',1,'raw','bare',NULL,'1e29363ca464487b931af54fe14166b1',1,0,0,NULL,'private',0,NULL,NULL),('1a6e18bb-b0e4-4e74-971e-ba88c205b347','tempest-ListImageFiltersTestJSON-image-1065242086',1024,'deleted','2026-01-31 08:03:32','2026-01-31 08:05:03','2026-01-31 08:05:03',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','3d28270b439f4cb1aa201d46b9f8a843',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('24bc3fab-3fe3-4b86-a9bf-77d973d4a7cf','multiattach-snapshot',0,'deleted','2026-01-31 08:52:05','2026-01-31 08:52:22','2026-01-31 08:52:22',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','8397e0fed04b4dabb57148d0924de2dc',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('269becbf-04a2-4537-bd31-66899150ed70','tempest-ServersNegativeTestJSON-server-1679208816-shelved',1073741824,'deleted','2026-01-31 08:41:51','2026-01-31 08:43:18','2026-01-31 08:43:18',1,'raw','bare',NULL,'621c17d53cba46d386de8efb560a988e',1,0,0,NULL,'private',0,NULL,NULL),('27d563e8-5fbe-4653-b526-f8048559e6cd','tempest-ServerBootFromVolumeStableRescueTest-image-458759205',1073741824,'deleted','2026-01-31 08:23:14','2026-01-31 08:26:41','2026-01-31 08:26:41',1,'raw','bare',NULL,'cf024d54545b4af882a87c721105742a',1,0,0,NULL,'private',0,NULL,NULL),('287f9894-83db-40a1-9a7f-ba7bbf17dc1d','tempest-ServerStableDeviceRescueTest-image-482259837',1073741824,'deleted','2026-01-31 08:36:28','2026-01-31 08:41:08','2026-01-31 08:41:08',1,'raw','bare',NULL,'1e29363ca464487b931af54fe14166b1',1,0,0,NULL,'private',0,NULL,NULL),('297f46fc-627f-48b0-8a66-2e6f3dab7554','tempest-TestShelveInstance-server-273568541-shelved',1073741824,'deleted','2026-01-31 08:59:59','2026-01-31 09:00:43','2026-01-31 09:00:43',1,'raw','bare',NULL,'1f293713f6854265a89a1a4a002088d5',1,0,0,NULL,'private',0,NULL,NULL),('301dc142-04f9-45d9-be1d-5d5ccdcf32fb','tempest-image-897207550',1024,'deleted','2026-01-31 07:55:44','2026-01-31 07:56:24','2026-01-31 07:56:24',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','d54668a882fd4d94979d2b767c4127ee',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('357acf21-e111-4e02-8a13-c11baeb4f6ec','tempest-ServerStableDeviceRescueTest-image-474025940',1073741824,'deleted','2026-01-31 08:35:11','2026-01-31 08:41:20','2026-01-31 08:41:20',1,'raw','bare',NULL,'1e29363ca464487b931af54fe14166b1',1,0,0,NULL,'private',0,NULL,NULL),('3676ca5a-2e55-4575-bc3f-672af49a103b','tempest-image-1139341813',1073741824,'deleted','2026-01-31 08:02:55','2026-01-31 08:03:19','2026-01-31 08:03:19',1,'raw','bare',NULL,'03f24e162c6d454aa9e31d60b478001d',1,0,0,NULL,'private',0,NULL,NULL),('37c0ea6b-d0de-4997-aa0a-7a7de3dd2f16','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-31 07:43:39','2026-01-31 07:43:44',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','89e274acfc5c4097be7194f5ef1fabd3',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('3d658df0-f3c7-45a7-bf8b-c899f015d20b','tempest-backup-3-1549194934',1073741824,'deleted','2026-01-31 08:27:21','2026-01-31 08:28:03','2026-01-31 08:28:03',1,'raw','bare',NULL,'953a213fa5cb435ab3c04ad96152685f',1,0,0,NULL,'private',0,NULL,NULL),('4659652d-d50c-40d4-aa17-bb68b7e73113','tempest-ServerBootFromVolumeStableRescueTest-image-478257285',1073741824,'deleted','2026-01-31 08:20:35','2026-01-31 08:27:35','2026-01-31 08:27:35',1,'raw','bare',NULL,'cf024d54545b4af882a87c721105742a',1,0,0,NULL,'private',0,NULL,NULL),('48732de6-33cc-4857-a389-34f02c69b538','tempest-test-snap-812705281',1073741824,'deleted','2026-01-31 08:02:24','2026-01-31 08:02:37','2026-01-31 08:02:37',1,'raw','bare',NULL,'521dcd459f144f2bb32de93d50ae0391',1,0,0,NULL,'private',0,NULL,NULL),('4ac04f66-def8-4f84-bf0b-3cd9f30ead2e','tempest-scenario-img--576066856',21430272,'deleted','2026-01-31 09:01:54','2026-01-31 09:04:28','2026-01-31 09:04:28',1,'qcow2','bare','c8fc807773e5354afe61636071771906','3d3e35e8f8144cd58baa994b70ef9668',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('4f6468b7-082d-4995-a147-34ef0ccaa0d2','tempest-test-snap-1154036698',1073741824,'deleted','2026-01-31 08:03:01','2026-01-31 08:03:49','2026-01-31 08:03:49',1,'raw','bare',NULL,'521dcd459f144f2bb32de93d50ae0391',1,0,0,NULL,'private',0,NULL,NULL),('58c2d049-2cc3-4799-9c9b-054364bb8a5e','tempest-ListImageFiltersTestJSON-image-1572583090',1073741824,'deleted','2026-01-31 08:03:53','2026-01-31 08:04:51','2026-01-31 08:04:51',1,'raw','bare',NULL,'3d28270b439f4cb1aa201d46b9f8a843',1,0,0,NULL,'private',0,NULL,NULL),('59ddf935-eb93-411f-a5eb-c6177408c7cf','tempest-scenario-img--1811671935',21430272,'deleted','2026-01-31 08:54:53','2026-01-31 08:58:39','2026-01-31 08:58:39',1,'qcow2','bare','c8fc807773e5354afe61636071771906','06b5fc9cfd4c49abb2d8b9f2f8a82c1f',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('61a37dcc-3d92-40cb-8dfd-e5d9e9576f30','tempest-test-snap-1790209613',1073741824,'deleted','2026-01-31 08:00:32','2026-01-31 08:00:52','2026-01-31 08:00:52',1,'raw','bare',NULL,'521dcd459f144f2bb32de93d50ae0391',1,0,0,NULL,'private',0,NULL,NULL),('6f41fe69-cbe5-422f-b305-4d86e60f48e0','tempest-ImagesOneServerNegativeTestJSON-image-1029374049',NULL,'deleted','2026-01-31 08:05:20','2026-01-31 08:05:22','2026-01-31 08:05:22',1,NULL,NULL,NULL,'44ad7f776f814675b2232eb023baacdd',1,0,0,NULL,'private',0,NULL,NULL),('73cd49f9-2dc0-46db-a474-56b4005fa543','tempest-image-1680081860',3517,'deleted','2026-01-31 08:00:04','2026-01-31 08:00:09','2026-01-31 08:00:09',1,'qcow2','bare','aa70c8adc8e9b46a34601ee1ce24105a','5e2423ea3fcb4c06a5d51165ed251cd7',0,129,0,NULL,'private',0,'sha512','a531b71abb131600a7cc8857122e62273ec8199985cd39ce8a983bd36ded5dc1c512bfa6c745e3af6b883869445ded5f1e757b9ef45f5423aad9cb1fead23b39'),('77b495b5-932c-4164-94ff-e9ef49f712d3','tempest-ImagesOneServerNegativeTestJSON-image-955810361',NULL,'deleted','2026-01-31 08:06:06','2026-01-31 08:06:07','2026-01-31 08:06:07',1,NULL,NULL,NULL,'44ad7f776f814675b2232eb023baacdd',1,0,0,NULL,'private',0,NULL,NULL),('7ac3b86b-56fa-425d-911b-e0b1bc3c9b64','tempest-TestVolumeBootPatternsnapshot-724948954',0,'deleted','2026-01-31 09:04:17','2026-01-31 09:05:49','2026-01-31 09:05:49',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','76ce367a834b49dfb5b436848118b860',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('7b22f4ab-bd25-45c1-a738-6910f1407753','tempest-UnshelveToHostMultiNodesTest-server-1524536714-shelved',1073741824,'deleted','2026-01-31 07:58:54','2026-01-31 07:59:31','2026-01-31 07:59:31',1,'raw','bare',NULL,'0f3a75a965fc495bbe02cb5bfad2053b',1,0,0,NULL,'private',0,NULL,NULL),('7b781d58-222d-48fb-b75e-dda36a2cb764','tempest-DeleteServersTestJSON-server-5961696-shelved',1073741824,'deleted','2026-01-31 08:07:28','2026-01-31 08:08:17','2026-01-31 08:08:17',1,'raw','bare',NULL,'3469c253459e40e39dcf5bcb6a32008f',1,0,0,NULL,'private',0,NULL,NULL),('81322d27-2584-47ad-bfcd-7642da2c770e','tempest-AttachVolumeShelveTestJSON-server-657799937-shelved',1073741824,'deleted','2026-01-31 08:24:54','2026-01-31 08:27:05','2026-01-31 08:27:05',1,'raw','bare',NULL,'491937de020742d7b4e847dc3bf57950',1,0,0,NULL,'private',0,NULL,NULL),('82a300ae-ae8c-468e-b588-e2987672944b','tempest-ListImageFiltersTestJSON-image-200120032',1024,'deleted','2026-01-31 08:03:16','2026-01-31 08:05:10','2026-01-31 08:05:10',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','3d28270b439f4cb1aa201d46b9f8a843',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('913987a4-398c-4df5-8903-96535743e328','tempest-backup-1-17944734',1073741824,'deleted','2026-01-31 08:26:19','2026-01-31 08:27:52','2026-01-31 08:27:52',1,'raw','bare',NULL,'953a213fa5cb435ab3c04ad96152685f',1,0,0,NULL,'private',0,NULL,NULL),('919869d2-31bd-400c-b71c-e086ee5512c0','tempest-UnshelveToHostMultiNodesTest-server-1524536714-shelved',1073741824,'deleted','2026-01-31 07:59:36','2026-01-31 08:00:35','2026-01-31 08:00:35',1,'raw','bare',NULL,'0f3a75a965fc495bbe02cb5bfad2053b',1,0,0,NULL,'private',0,NULL,NULL),('9317cf42-332f-490f-a964-767c14b9cbfa','tempest-ListImageFiltersTestJSON-image-473830824',1024,'deleted','2026-01-31 08:03:20','2026-01-31 08:05:05','2026-01-31 08:05:05',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','3d28270b439f4cb1aa201d46b9f8a843',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('9516f569-48fb-4a10-80ea-c3a613366509','tempest-test-snap-1911567568',1073741824,'deleted','2026-01-31 08:01:44','2026-01-31 08:01:59','2026-01-31 08:01:59',1,'raw','bare',NULL,'521dcd459f144f2bb32de93d50ae0391',1,0,0,NULL,'private',0,NULL,NULL),('9bc0d84f-a933-4fd8-8f17-38e2aca81cce','tempest-ServerStableDeviceRescueTest-image-1689950157',1073741824,'deleted','2026-01-31 08:39:04','2026-01-31 08:40:46','2026-01-31 08:40:46',1,'raw','bare',NULL,'1e29363ca464487b931af54fe14166b1',1,0,0,NULL,'private',0,NULL,NULL),('9dcdf407-c698-4570-bce4-edde88d1813b','tempest-backup-2-358031678',1073741824,'deleted','2026-01-31 08:26:47','2026-01-31 08:28:09','2026-01-31 08:28:09',1,'raw','bare',NULL,'953a213fa5cb435ab3c04ad96152685f',1,0,0,NULL,'private',0,NULL,NULL),('a445cf05-8653-452b-bc15-8061b7aa6a98','tempest-ServerActionsTestOtherB-server-966483760-shelved',1073741824,'deleted','2026-01-31 08:34:23','2026-01-31 08:35:11','2026-01-31 08:35:11',1,'raw','bare',NULL,'953a213fa5cb435ab3c04ad96152685f',1,0,0,NULL,'private',0,NULL,NULL),('a6036a30-758c-46f5-b0cb-e59cf3a4220b','tempest-TestSnapshotPatternsnapshot-1343594239',1073741824,'deleted','2026-01-31 09:12:01','2026-01-31 09:12:08','2026-01-31 09:12:08',1,'raw','bare',NULL,'c0be57039fd34aa9a2d05d9086ccff13',1,0,0,NULL,'private',0,NULL,NULL),('be36fc17-1fc9-4dc7-9df3-92082489a43b','tempest-scenario-img--1945406638',21430272,'deleted','2026-01-31 08:59:30','2026-01-31 09:01:54','2026-01-31 09:01:54',1,'qcow2','bare','c8fc807773e5354afe61636071771906','3d3e35e8f8144cd58baa994b70ef9668',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('c60105d3-836b-48ac-bea6-55acfd972195','tempest-ListImageFiltersTestJSON-image-984024274',1073741824,'deleted','2026-01-31 08:04:14','2026-01-31 08:04:49','2026-01-31 08:04:49',1,'raw','bare',NULL,'3d28270b439f4cb1aa201d46b9f8a843',1,0,0,NULL,'private',0,NULL,NULL),('d9bfe40a-4757-4935-8bdd-50aa5c769418','tempest-ListImageFiltersTestJSON-image-1762429015',1073741824,'deleted','2026-01-31 08:04:25','2026-01-31 08:04:47','2026-01-31 08:04:47',1,'raw','bare',NULL,'3d28270b439f4cb1aa201d46b9f8a843',1,0,0,NULL,'private',0,NULL,NULL),('e0fa43e0-9f79-4992-bc07-130eef6d5592',NULL,21430272,'deleted','2026-01-31 07:51:17','2026-01-31 07:53:11','2026-01-31 07:53:11',1,'qcow2','bare','c8fc807773e5354afe61636071771906','18a55c4784fc43908a027752a1a5fc3c',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('e787704c-b374-4706-807f-a0d18a0ac398','tempest-ServerActionsTestOtherB-server-1695242703-shelved',1073741824,'deleted','2026-01-31 08:34:07','2026-01-31 08:35:15','2026-01-31 08:35:15',1,'raw','bare',NULL,'953a213fa5cb435ab3c04ad96152685f',1,0,0,NULL,'private',0,NULL,NULL),('f398889c-e272-449f-a032-36096e95d18f','tempest-TestSnapshotPatternsnapshot-707513110',1073741824,'deleted','2026-01-31 09:11:06','2026-01-31 09:12:15','2026-01-31 09:12:15',1,'raw','bare',NULL,'c0be57039fd34aa9a2d05d9086ccff13',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-31 07:03:15',NULL),(1,2,'image','CIM_RASD_','2026-01-31 07:03:16',NULL),(1,3,NULL,'CIM_SASD_','2026-01-31 07:03:18',NULL),(1,9,'image','hw_','2026-01-31 07:03:21',NULL),(1,10,'image','hw_','2026-01-31 07:03:22',NULL),(1,14,'image',NULL,'2026-01-31 07:03:25',NULL),(1,19,'image','hw_','2026-01-31 07:03:37',NULL),(1,25,'image','hw_','2026-01-31 07:03:39',NULL),(1,29,'image',NULL,'2026-01-31 07:03:41',NULL),(1,30,'image',NULL,'2026-01-31 07:03:42',NULL),(1,31,'image',NULL,'2026-01-31 07:03:42',NULL),(1,32,'image',NULL,'2026-01-31 07:03:43',NULL),(2,1,NULL,'CIM_PASD_','2026-01-31 07:03:15',NULL),(2,8,NULL,'hw_','2026-01-31 07:03:19',NULL),(2,9,NULL,'hw_','2026-01-31 07:03:19',NULL),(2,10,NULL,'hw_','2026-01-31 07:03:22',NULL),(2,11,NULL,NULL,'2026-01-31 07:03:22',NULL),(2,13,NULL,NULL,'2026-01-31 07:03:23',NULL),(2,14,NULL,NULL,'2026-01-31 07:03:25',NULL),(2,15,NULL,NULL,'2026-01-31 07:03:27',NULL),(2,16,NULL,'hw_','2026-01-31 07:03:29',NULL),(2,19,NULL,'hw_','2026-01-31 07:03:37',NULL),(2,22,NULL,NULL,'2026-01-31 07:03:38',NULL),(2,23,NULL,'hw_','2026-01-31 07:03:39',NULL),(2,24,NULL,'traits:','2026-01-31 07:03:39',NULL),(2,25,NULL,'hw_','2026-01-31 07:03:39',NULL),(2,26,NULL,NULL,'2026-01-31 07:03:40',NULL),(2,28,NULL,NULL,'2026-01-31 07:03:40',NULL),(2,29,NULL,NULL,'2026-01-31 07:03:41',NULL),(2,30,NULL,NULL,'2026-01-31 07:03:42',NULL),(2,31,NULL,NULL,'2026-01-31 07:03:42',NULL),(2,32,NULL,NULL,'2026-01-31 07:03:43',NULL),(2,33,NULL,'cinder_','2026-01-31 07:03:43',NULL),(3,1,NULL,'CIM_PASD_','2026-01-31 07:03:16',NULL),(3,2,NULL,'CIM_RASD_','2026-01-31 07:03:16',NULL),(3,3,NULL,'CIM_SASD_','2026-01-31 07:03:18',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-31 07:03:19',NULL),(3,5,NULL,NULL,'2026-01-31 07:03:19',NULL),(3,6,NULL,NULL,'2026-01-31 07:03:19',NULL),(3,7,NULL,NULL,'2026-01-31 07:03:19',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-31 07:03:23',NULL),(4,1,NULL,'CIM_PASD_','2026-01-31 07:03:16',NULL),(4,2,NULL,'CIM_RASD_','2026-01-31 07:03:16',NULL),(4,3,NULL,'CIM_SASD_','2026-01-31 07:03:18',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-31 07:03:19',NULL),(4,8,NULL,'hw:','2026-01-31 07:03:19',NULL),(4,9,NULL,'hw:','2026-01-31 07:03:22',NULL),(4,10,NULL,'hw:','2026-01-31 07:03:22',NULL),(4,12,NULL,'capabilities:','2026-01-31 07:03:22',NULL),(4,16,NULL,'hw:','2026-01-31 07:03:30',NULL),(4,17,NULL,NULL,'2026-01-31 07:03:36',NULL),(4,18,NULL,NULL,'2026-01-31 07:03:37',NULL),(4,19,NULL,'hw:','2026-01-31 07:03:37',NULL),(4,20,NULL,NULL,'2026-01-31 07:03:38',NULL),(4,21,NULL,NULL,'2026-01-31 07:03:38',NULL),(4,23,NULL,'hw:','2026-01-31 07:03:39',NULL),(4,24,NULL,'traits:','2026-01-31 07:03:39',NULL),(4,25,NULL,'hw:','2026-01-31 07:03:39',NULL),(5,1,'scheduler_hints',NULL,'2026-01-31 07:03:16',NULL),(5,30,'metadata',NULL,'2026-01-31 07:03:42',NULL),(5,31,'metadata',NULL,'2026-01-31 07:03:42',NULL),(5,32,'metadata',NULL,'2026-01-31 07:03:43',NULL),(6,30,NULL,NULL,'2026-01-31 07:03:42',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-31 07:03:15',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-31 07:03:16',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-31 07:03:18',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-31 07:03:18',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-31 07:03:19',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-31 07:03:19',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-31 07:03:19',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-31 07:03:19',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-31 07:03:19',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-31 07:03:22',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-31 07:03:22',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-31 07:03:22',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-31 07:03:23',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-31 07:03:24',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 07:03:26',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 07:03:29',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 07:03:36',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-31 07:03:37',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-31 07:03:37',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 07:03:38',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 07:03:38',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 07:03:38',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-31 07:03:39',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-31 07:03:39',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-31 07:03:39',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-31 07:03:40',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-31 07:03:40',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-31 07:03:40',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-31 07:03:41',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-31 07:03:42',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-31 07:03:42',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-31 07:03:43',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-31 07:03:43',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-31 07:03:36',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-31 07:03:36',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-31 07:03:37',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-31 07:03:42',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-31 07:03:42',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-31 07:03:42',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-31 07:03:42',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-31 07:03:42',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-31 07:03:42',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-31 07:03:42',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-31 07:03:42',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-31 07:03:42',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-31 07:03:43',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-31 07:03:43',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 07:03:43',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 07:03:43',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-31 07:03:43',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-31 07:03:16',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-31 07:03:16',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-31 07:03:16',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-31 07:03:16',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-31 07:03:16',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-31 07:03:16',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-31 07:03:16',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-31 07:03:16',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-31 07:03:16',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-31 07:03:17',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-31 07:03:17',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-31 07:03:17',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-31 07:03:18',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-31 07:03:18',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-31 07:03:18',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-31 07:03:18',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-31 07:03:19',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-31 07:03:19',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-31 07:03:19',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-31 07:03:19',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-31 07:03:19',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-31 07:03:19',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-31 07:03:19',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-31 07:03:19',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-31 07:03:22',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-31 07:03:22',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-31 07:03:22',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 07:03:22',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-31 07:03:23',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-31 07:03:23',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-31 07:03:23',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 07:03:23',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 07:03:23',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-31 07:03:23',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-31 07:03:23',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-31 07:03:24',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-31 07:03:24',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-31 07:03:25',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 07:03:26',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-31 07:03:28',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-31 07:03:28',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-31 07:03:29',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-31 07:03:29',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-31 07:03:29',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-31 07:03:29',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-31 07:03:29',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 07:03:29',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-31 07:03:29',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-31 07:03:29',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-31 07:03:29',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 07:03:29',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 07:03:29',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 07:03:29',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-31 07:03:29',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-31 07:03:29',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 07:03:31',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 07:03:32',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 07:03:36',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-31 07:03:37',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-31 07:03:37',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-31 07:03:37',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:37',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:37',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:38',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:38',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:38',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-31 07:03:38',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-31 07:03:38',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-31 07:03:38',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 07:03:38',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-31 07:03:38',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-31 07:03:38',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-31 07:03:38',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-31 07:03:38',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-31 07:03:39',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-31 07:03:39',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-31 07:03:39',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-31 07:03:39',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-31 07:03:39',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-31 07:03:39',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-31 07:03:40',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-31 07:03:40',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-31 07:03:40',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-31 07:03:40',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-31 07:03:40',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-31 07:03:40',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-31 07:03:40',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-31 07:03:40',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-31 07:03:40',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-31 07:03:42',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-31 07:03:42',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-31 07:03:42',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-31 07:03:43',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-31 07:03:15',NULL),(2,'OS::Glance::Image',1,'2026-01-31 07:03:15',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-31 07:03:15',NULL),(4,'OS::Nova::Flavor',1,'2026-01-31 07:03:16',NULL),(5,'OS::Nova::Server',1,'2026-01-31 07:03:16',NULL),(6,'OS::Trove::Instance',1,'2026-01-31 07:03:42',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0fd227e5eb914b38913f4b820440a0f4','cb417a6cb57d4693a4fbcf628ac13cdc','39a15a7e0ebb47f2a5950a25ddafa71b',0),('UserProject','0fd227e5eb914b38913f4b820440a0f4','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','3a2db34c566140b18fc5d0e7df30ac08','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','3a2db34c566140b18fc5d0e7df30ac08','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','89c9e86efe094b728b1685c8888cf0ef','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','89c9e86efe094b728b1685c8888cf0ef','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','8fc1d2951eff4fa99fcd5cea6fb616dc','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','8fc1d2951eff4fa99fcd5cea6fb616dc','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','94836483675641d9846c5768c3b91eed','89e274acfc5c4097be7194f5ef1fabd3','2134871004ec4b26904b383c322a2b98',0),('UserProject','94836483675641d9846c5768c3b91eed','89e274acfc5c4097be7194f5ef1fabd3','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','94836483675641d9846c5768c3b91eed','f9043b2bd33144e6884cd2ee092d45f1','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','9ec13114bad64754bf2a77073de5e283','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','9ec13114bad64754bf2a77073de5e283','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','ec8086da066b421c98595b09183028d8','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','ec8086da066b421c98595b09183028d8','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','ef86a0e6a6684d7181beb07880022b46','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','ef86a0e6a6684d7181beb07880022b46','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0),('UserProject','fe07f3865a614b72984f087353419503','cb417a6cb57d4693a4fbcf628ac13cdc','70ad65214ee1420c8460157bb2436cb2',0),('UserProject','fe07f3865a614b72984f087353419503','cb417a6cb57d4693a4fbcf628ac13cdc','bf61c4f9a3934cdc80e13a91cd28faf8',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('35164df3f9e24f1f86ab4c7b0d3f2b89',NULL,'internal','19fcf0e1e45a4860a8dc8dac498938d5','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('3ea00a959a9f4cd8ba8f3822b5e34bc5',NULL,'public','f7e534cd4bcd45c19d14780f8b3c9ef7','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('50beffcaab42467c8e54239ed79c644d',NULL,'public','21e626d2baf84246892ef04d903a9433','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('52ab38cdbce0487dbbd94ef2d3f99727',NULL,'public','d9bb228504a949fc806d7b505ec24d2b','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('6359f270b70048fcae04ceeb3d821f3f',NULL,'internal','f7e534cd4bcd45c19d14780f8b3c9ef7','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('70c3a0e5563f483cbb9f35761cc6addb',NULL,'public','19fcf0e1e45a4860a8dc8dac498938d5','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('7128cd528adc4727985c0a85ae66c12c',NULL,'internal','21e626d2baf84246892ef04d903a9433','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('742fa68029764d71b2237078efdcac49',NULL,'public','aa17c9ce3a00476eb334700815f72946','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('754091c296144edfa70d8577b9ce4349',NULL,'internal','09d81b3e45d64d5ea641c8ff364f357f','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('80e58bff9507442e81ba9c59769aa0bd',NULL,'internal','b85577cdbf374eb4986621abe822ced7','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('8d1c61f1a3d24bf68d2a3488a5dedf2c',NULL,'internal','e9889c59d9ff44caa8737eeb80a18cb3','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('92450df4ae9948ccbf8460f75beffc5d',NULL,'public','09d81b3e45d64d5ea641c8ff364f357f','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('b42a39c2b6834eac88c6d57f564f11b9',NULL,'internal','d9bb228504a949fc806d7b505ec24d2b','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('cab12299c2e143d3bb9ad2e5a2d49dd5',NULL,'public','e9889c59d9ff44caa8737eeb80a18cb3','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('e0414ac376d842d1993aa0b36cc46dc9',NULL,'internal','aa17c9ce3a00476eb334700815f72946','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('fdefdc1052634084bfd7235cfb9ee013',NULL,'public','b85577cdbf374eb4986621abe822ced7','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('39a15a7e0ebb47f2a5950a25ddafa71b','c244b714c79b40ab84a78edfde726094'),('70ad65214ee1420c8460157bb2436cb2','39a15a7e0ebb47f2a5950a25ddafa71b');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'94836483675641d9846c5768c3b91eed','default','admin',0,NULL),(2,'ef86a0e6a6684d7181beb07880022b46','default','glance',0,NULL),(3,'8fc1d2951eff4fa99fcd5cea6fb616dc','default','ceilometer',0,NULL),(4,'9ec13114bad64754bf2a77073de5e283','default','cinder',0,NULL),(5,'ec8086da066b421c98595b09183028d8','default','nova',0,NULL),(6,'3a2db34c566140b18fc5d0e7df30ac08','default','placement',0,NULL),(7,'89c9e86efe094b728b1685c8888cf0ef','default','barbican',0,NULL),(8,'fe07f3865a614b72984f087353419503','default','neutron',0,NULL),(9,'0fd227e5eb914b38913f4b820440a0f4','default','swift',0,NULL),(10,'a6c21815d0ba4a709d7167306e85483f','default','demo_tempestconf',0,NULL),(11,'1c46f75898f04dc69571e7e1edb2426e','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$YsSujVFstg2m.TD31Q/ZcO6AcdSHbW1rQkNDUorTL/mKQscN7Hdny',1769843002732865,NULL,'2026-01-31 07:03:22'),(2,2,NULL,0,'$2b$12$Im2HfXq6y.IAl3eqRmw/u./Om.9BiTnhZPyg26TZz5OuZ5J4Von6e',1769843095831401,NULL,'2026-01-31 07:04:55'),(3,3,NULL,0,'$2b$12$Rhqpi3pEa2pPGZld5nH/ROgKJF1vYlIKbMMkVyNglhVGz0.g/.vXK',1769843100047099,NULL,'2026-01-31 07:05:00'),(4,4,NULL,0,'$2b$12$nGMN6rdLnHPITzHPCDyn9.i0yTY8F8ZuOEmFoQec2TCNLPm3sW2LG',1769843103445695,NULL,'2026-01-31 07:05:03'),(5,5,NULL,0,'$2b$12$Szv5PjdwjrCy8PZOuQLjNe3LNLE0EZdPUl9NWicJjiKgZoy2VrabK',1769843114535527,NULL,'2026-01-31 07:05:14'),(6,6,NULL,0,'$2b$12$W.RUQaLTsR43OaHsj4rKfOMM.ZUb.AnTn/.mGNzBVg103945fB9zy',1769843122251336,NULL,'2026-01-31 07:05:22'),(7,7,NULL,0,'$2b$12$7S5wgz4ypWxOpU10GFCpYuru32Ioq0Ar3r239nkN0AJKqDjMCf3b2',1769843131466994,NULL,'2026-01-31 07:05:31'),(8,8,NULL,0,'$2b$12$aCnOFrqsJ0eZ4MTwPL1lVeoX3kwqUYIZIRqiCegtIEeyU9wBsvohe',1769843192882927,NULL,'2026-01-31 07:06:32'),(9,9,NULL,0,'$2b$12$EpvILXVkni1VVm5mHYP5Aeew50CyTZJKj1anHv/f8VDyxOgniM0Cq',1769844219414080,NULL,'2026-01-31 07:23:39'),(10,10,NULL,0,'$2b$12$udZO6tkdDeliMmZS2/X4o.9E6yqpbOkTlioZSG8mBCArlpWqhbHV2',1769845408599048,NULL,'2026-01-31 07:43:28'),(11,11,NULL,0,'$2b$12$.h271M7g53u7TutXD71U.ufWtoFT8E3CgndKaIcKkkASg5KvK.Uae',1769845410069633,NULL,'2026-01-31 07:43:30');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('449ee517cd164855a4735fdb66c78488','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('89e274acfc5c4097be7194f5ef1fabd3','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('cb417a6cb57d4693a4fbcf628ac13cdc','service','{}','service',1,'default','default',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('f9043b2bd33144e6884cd2ee092d45f1','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (126,NULL,NULL,'4e887d8783db44ff93a55e1ea75aa78e',NULL,NULL,NULL,NULL,'2026-01-31 07:49:39',NULL,'2026-01-31 07:49:39',NULL,NULL),(127,NULL,NULL,'cd588efdd47d4cefafe6efce9dd7d09e',NULL,NULL,NULL,NULL,'2026-01-31 07:49:39',NULL,'2026-01-31 07:49:39',NULL,NULL),(128,NULL,'2c52201ee1a6452388ca22ab06da1e56',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:42',NULL,'2026-01-31 07:49:42',NULL,NULL),(129,NULL,'2ca2f28405884a6ea92bcde9c8f91ff9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:45',NULL,'2026-01-31 07:49:45',NULL,NULL),(130,NULL,NULL,'eb6d11d1446f459d88ff19e4bf8d16be',NULL,NULL,NULL,NULL,'2026-01-31 07:49:50',NULL,'2026-01-31 07:49:50',NULL,NULL),(131,NULL,NULL,'c562f4365ac74b0e9476a928ed48df6a',NULL,NULL,NULL,NULL,'2026-01-31 07:49:51',NULL,'2026-01-31 07:49:51',NULL,NULL),(132,NULL,'88b55e0cb6f4447fbf7c8b50f7f446ef',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:56',NULL,'2026-01-31 07:49:56',NULL,NULL),(133,NULL,'54539dd964cc426b8db9899d22651470',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:49:58',NULL,'2026-01-31 07:49:58',NULL,NULL),(134,NULL,NULL,'f966a9f649044fefb548779aa0a57ade',NULL,NULL,NULL,NULL,'2026-01-31 07:50:34',NULL,'2026-01-31 07:50:34',NULL,NULL),(135,NULL,NULL,'d0479e819c644e20b7fea35b1ec0b8eb',NULL,NULL,NULL,NULL,'2026-01-31 07:50:35',NULL,'2026-01-31 07:50:35',NULL,NULL),(136,NULL,'d8f111451da745b98d0546a46b1451bf',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:38',NULL,'2026-01-31 07:50:38',NULL,NULL),(137,NULL,'3c305ec558a4499ca2f3874df3d0a71c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:40',NULL,'2026-01-31 07:50:40',NULL,NULL),(138,NULL,NULL,'ef2319e9aaac4b57a0f47eba6f9785b5',NULL,NULL,NULL,NULL,'2026-01-31 07:50:45',NULL,'2026-01-31 07:50:45',NULL,NULL),(139,NULL,NULL,'8fdc56f1946c42cc88952eb22112c7bd',NULL,NULL,NULL,NULL,'2026-01-31 07:50:45',NULL,'2026-01-31 07:50:45',NULL,NULL),(140,NULL,'80b3faf9a57b46699d65bcbe774e93d9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:47',NULL,'2026-01-31 07:50:47',NULL,NULL),(141,NULL,'4193996ca5364e6c97cc7fd100ba1cea',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:50:48',NULL,'2026-01-31 07:50:48',NULL,NULL),(142,NULL,NULL,'37ed25cc14814a29867ac308b3cce8cf',NULL,NULL,NULL,NULL,'2026-01-31 07:52:07',NULL,'2026-01-31 07:52:07',NULL,NULL),(143,NULL,NULL,'2281b211104541868e559053ffafa8db',NULL,NULL,NULL,NULL,'2026-01-31 07:52:07',NULL,'2026-01-31 07:52:07',NULL,NULL),(144,NULL,'e66a774f63ae4139a4e75c7973fbe077',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:08',NULL,'2026-01-31 07:52:08',NULL,NULL),(145,NULL,'af359d31615c49d28000f10b153d6e39',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:10',NULL,'2026-01-31 07:52:10',NULL,NULL),(146,NULL,NULL,'b57bca8fad514614a04d8d13d98e2ffd',NULL,NULL,NULL,NULL,'2026-01-31 07:52:20',NULL,'2026-01-31 07:52:20',NULL,NULL),(147,NULL,'2ec4566b60574efd806601307c2918d2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:21',NULL,'2026-01-31 07:52:21',NULL,NULL),(148,NULL,NULL,'6bb6b4da3da34b54ba20d4c54f5beef4',NULL,NULL,NULL,NULL,'2026-01-31 07:52:21',NULL,'2026-01-31 07:52:21',NULL,NULL),(149,NULL,NULL,'c5ab840fb5064645a774595442baaa3f',NULL,NULL,NULL,NULL,'2026-01-31 07:52:22',NULL,'2026-01-31 07:52:22',NULL,NULL),(150,NULL,'5be068a0d8e1421b9eecba8235d2ea8a',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:27',NULL,'2026-01-31 07:52:27',NULL,NULL),(151,NULL,'b927a66c128b48bab6eb2feab0d99a26',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:30',NULL,'2026-01-31 07:52:30',NULL,NULL),(152,NULL,NULL,'795c7f392cbc45f0885f081449883d42',NULL,NULL,NULL,NULL,'2026-01-31 07:52:37',NULL,'2026-01-31 07:52:37',NULL,NULL),(153,NULL,NULL,'3a97c6056ac04f13b6b8a954619eb4f3',NULL,NULL,NULL,NULL,'2026-01-31 07:52:37',NULL,'2026-01-31 07:52:37',NULL,NULL),(154,NULL,'cbdbb7a4b22a49b68feb3e028bb62fbb',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:39',NULL,'2026-01-31 07:52:39',NULL,NULL),(155,NULL,NULL,'1fc9773806234e07ba54d797457cc523',NULL,NULL,NULL,NULL,'2026-01-31 07:52:40',NULL,'2026-01-31 07:52:40',NULL,NULL),(156,NULL,'91fe47bcda2a4f40b318b3233b378e5e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:40',NULL,'2026-01-31 07:52:40',NULL,NULL),(157,NULL,NULL,'bdf9c9f418c74f538155bf91d4179559',NULL,NULL,NULL,NULL,'2026-01-31 07:52:41',NULL,'2026-01-31 07:52:41',NULL,NULL),(158,NULL,'ace85892fea146fea0409a7b19662de3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:41',NULL,'2026-01-31 07:52:41',NULL,NULL),(159,NULL,NULL,'d34cddc1f78d4cd39fe4a4982b8b24e8',NULL,NULL,NULL,NULL,'2026-01-31 07:52:41',NULL,'2026-01-31 07:52:41',NULL,NULL),(160,NULL,'eb870412a2d94c69a26cd610d98a6d92',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:44',NULL,'2026-01-31 07:52:44',NULL,NULL),(161,NULL,'a9c71eca74234b7aaca6d251032cc94b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:47',NULL,'2026-01-31 07:52:47',NULL,NULL),(162,NULL,NULL,'686b918d7fe348f9a56753af6becf349',NULL,NULL,NULL,NULL,'2026-01-31 07:52:48',NULL,'2026-01-31 07:52:48',NULL,NULL),(163,NULL,NULL,'088a39f35fe841e5888ea9b6ae397a19',NULL,NULL,NULL,NULL,'2026-01-31 07:52:48',NULL,'2026-01-31 07:52:48',NULL,NULL),(164,NULL,NULL,'8a59efd78e244f44a1c70650f82a2c50',NULL,NULL,NULL,NULL,'2026-01-31 07:52:49',NULL,'2026-01-31 07:52:49',NULL,NULL),(165,NULL,NULL,'fad82ed81c81456297863bf537d98c83',NULL,NULL,NULL,NULL,'2026-01-31 07:52:50',NULL,'2026-01-31 07:52:50',NULL,NULL),(166,NULL,'ff757bbeb1ce42cc9d87cc4e6f11f075',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:51',NULL,'2026-01-31 07:52:51',NULL,NULL),(167,NULL,'b3fcea0c21ef4dc8bbc27e3216fc550f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:53',NULL,'2026-01-31 07:52:53',NULL,NULL),(168,NULL,'97eb962880cb4e97a9e880e9ab3db8db',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:53',NULL,'2026-01-31 07:52:53',NULL,NULL),(169,NULL,NULL,'5ed0a1dcee6947bd9e1dd9ebc9840443',NULL,NULL,NULL,NULL,'2026-01-31 07:52:53',NULL,'2026-01-31 07:52:53',NULL,NULL),(170,NULL,NULL,'aa5d3def07594a26b02c92c298d9dbd5',NULL,NULL,NULL,NULL,'2026-01-31 07:52:53',NULL,'2026-01-31 07:52:53',NULL,NULL),(171,NULL,'1627a71b855b4032b51e234e44a9d570',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:55',NULL,'2026-01-31 07:52:55',NULL,NULL),(172,NULL,'4bd3246285e84335b9c8f59efe1f0470',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:55',NULL,'2026-01-31 07:52:55',NULL,NULL),(173,NULL,'362817df80dc43999ed85e258dab523e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:52:57',NULL,'2026-01-31 07:52:57',NULL,NULL),(174,NULL,NULL,'6e315d3b2d004bc3811f866b74dbdb32',NULL,NULL,NULL,NULL,'2026-01-31 07:53:00',NULL,'2026-01-31 07:53:00',NULL,NULL),(175,NULL,NULL,'322c73a0c85643c8bf8e1d0185dae2c4',NULL,NULL,NULL,NULL,'2026-01-31 07:53:00',NULL,'2026-01-31 07:53:00',NULL,NULL),(176,NULL,'30873b7184234202a75c759c679bcef5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:03',NULL,'2026-01-31 07:53:03',NULL,NULL),(177,NULL,'7eb1798d31ad40108d03bd8abde558cc',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:05',NULL,'2026-01-31 07:53:05',NULL,NULL),(178,NULL,NULL,'4778ad63bc45422bb229e52aa734671e',NULL,NULL,NULL,NULL,'2026-01-31 07:53:18',NULL,'2026-01-31 07:53:18',NULL,NULL),(179,NULL,NULL,'7debe78dd17f4c949868d7fb077cae9c',NULL,NULL,NULL,NULL,'2026-01-31 07:53:19',NULL,'2026-01-31 07:53:19',NULL,NULL),(180,NULL,'2b1840da98ad49c79b0243c9013b2e94',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:21',NULL,'2026-01-31 07:53:21',NULL,NULL),(181,NULL,NULL,'a4d67af6cd5e4666b122e952d7518768',NULL,NULL,NULL,NULL,'2026-01-31 07:53:21',NULL,'2026-01-31 07:53:21',NULL,NULL),(182,NULL,NULL,'1de3d87f1d0545d7a011eeed69e1916c',NULL,NULL,NULL,NULL,'2026-01-31 07:53:22',NULL,'2026-01-31 07:53:22',NULL,NULL),(183,NULL,'e3c9cdde07364a62ad6417124140e085',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:23',NULL,'2026-01-31 07:53:23',NULL,NULL),(184,NULL,'74dc764498fa4a86a4d6d7baa8d2ef66',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:25',NULL,'2026-01-31 07:53:25',NULL,NULL),(185,NULL,'30f949231a2445598823beb5ace97642',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:27',NULL,'2026-01-31 07:53:27',NULL,NULL),(186,NULL,NULL,'52dfb714105e45afac868e6adeaa7773',NULL,NULL,NULL,NULL,'2026-01-31 07:53:29',NULL,'2026-01-31 07:53:29',NULL,NULL),(187,NULL,NULL,'b5ca4e9c8d314badad8f9f9b6ce3d2d9',NULL,NULL,NULL,NULL,'2026-01-31 07:53:30',NULL,'2026-01-31 07:53:30',NULL,NULL),(188,NULL,NULL,'9b862c5fdc1f4295a6d3dd1818ec550b',NULL,NULL,NULL,NULL,'2026-01-31 07:53:30',NULL,'2026-01-31 07:53:30',NULL,NULL),(189,NULL,'33c94545347344cca3116311306ad73c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:33',NULL,'2026-01-31 07:53:33',NULL,NULL),(190,NULL,NULL,'69d26c1015144fbda08ee4b9db0d7b70',NULL,NULL,NULL,NULL,'2026-01-31 07:53:33',NULL,'2026-01-31 07:53:33',NULL,NULL),(191,NULL,NULL,'10048d86ed874c63a0dddba94e9c3192',NULL,NULL,NULL,NULL,'2026-01-31 07:53:34',NULL,'2026-01-31 07:53:34',NULL,NULL),(192,NULL,'16e51fafae224def941345353454a8bc',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:35',NULL,'2026-01-31 07:53:35',NULL,NULL),(193,NULL,'ea1f64b5b90d4a90a6cb764c4cdcca59',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:35',NULL,'2026-01-31 07:53:35',NULL,NULL),(194,NULL,'c27ae453ccc74fa4a184f73b296011aa',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:36',NULL,'2026-01-31 07:53:36',NULL,NULL),(195,NULL,'18a55c4784fc43908a027752a1a5fc3c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:36',NULL,'2026-01-31 07:53:36',NULL,NULL),(196,NULL,NULL,'5baed7ec51044fc6859b3df3fe9c4bdd',NULL,NULL,NULL,NULL,'2026-01-31 07:53:50',NULL,'2026-01-31 07:53:50',NULL,NULL),(197,NULL,NULL,'31d932b5f41944cca2bc3a967b02a4ce',NULL,NULL,NULL,NULL,'2026-01-31 07:53:50',NULL,'2026-01-31 07:53:50',NULL,NULL),(198,NULL,'3a9450c40fc14e10acd79c5e479c398e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:52',NULL,'2026-01-31 07:53:52',NULL,NULL),(199,NULL,'9b5dbf38b98c4018b86f5dccf80a9f30',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:53:54',NULL,'2026-01-31 07:53:54',NULL,NULL),(200,NULL,NULL,'784fa1eae9554e8ba1780d9a15d86b07',NULL,NULL,NULL,NULL,'2026-01-31 07:54:21',NULL,'2026-01-31 07:54:21',NULL,NULL),(201,NULL,NULL,'b0ff126eb9b74deea0033ae0badab500',NULL,NULL,NULL,NULL,'2026-01-31 07:54:22',NULL,'2026-01-31 07:54:22',NULL,NULL),(202,NULL,'4eaf18b9bc8c4afd86bc06639fac4764',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:54:23',NULL,'2026-01-31 07:54:23',NULL,NULL),(203,NULL,'a5275ac0df7242498feffe6147cb00e4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:54:25',NULL,'2026-01-31 07:54:25',NULL,NULL),(204,NULL,NULL,'0ee689c4c14744fb8b4e1d54f6831626',NULL,NULL,NULL,NULL,'2026-01-31 07:54:40',NULL,'2026-01-31 07:54:40',NULL,NULL),(205,NULL,NULL,'9565dfd51dc34930a3f05eaa4c60c7ee',NULL,NULL,NULL,NULL,'2026-01-31 07:54:40',NULL,'2026-01-31 07:54:40',NULL,NULL),(206,NULL,'f63afec818164f31a848360151f96a68',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:54:42',NULL,'2026-01-31 07:54:42',NULL,NULL),(207,NULL,'9d8a708699004a25bfb9d13c5a8fe481',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:54:44',NULL,'2026-01-31 07:54:44',NULL,NULL),(208,NULL,NULL,'0384d6fc8c0b4f66bf382009760ab9f5',NULL,NULL,NULL,NULL,'2026-01-31 07:55:40',NULL,'2026-01-31 07:55:40',NULL,NULL),(209,NULL,'8a2b8f01b0d74b8588a3f97400e9fbff',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:55:41',NULL,'2026-01-31 07:55:41',NULL,NULL),(210,NULL,NULL,'0794c4f318db4902826c34141b7df554',NULL,NULL,NULL,NULL,'2026-01-31 07:56:25',NULL,'2026-01-31 07:56:25',NULL,NULL),(211,NULL,'d54668a882fd4d94979d2b767c4127ee',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:56:28',NULL,'2026-01-31 07:56:28',NULL,NULL),(212,NULL,NULL,'d4307bc8a2224140b78ba248cecefe55',NULL,NULL,NULL,NULL,'2026-01-31 07:57:24',NULL,'2026-01-31 07:57:24',NULL,NULL),(213,NULL,NULL,'00913197f7f34a9c998a1541d750eab1',NULL,NULL,NULL,NULL,'2026-01-31 07:57:24',NULL,'2026-01-31 07:57:24',NULL,NULL),(214,NULL,'b6dca32431594e2682c5d2acb448bbf4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:57:26',NULL,'2026-01-31 07:57:26',NULL,NULL),(215,NULL,'b76ef29d55e94046a4998712dbf6c13f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:57:30',NULL,'2026-01-31 07:57:30',NULL,NULL),(216,NULL,NULL,'af90832a37cd4b10b02397d75b4802c9',NULL,NULL,NULL,NULL,'2026-01-31 07:57:38',NULL,'2026-01-31 07:57:38',NULL,NULL),(217,NULL,'200fedf7dc594b4da20c0397b4581e89',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:57:42',NULL,'2026-01-31 07:57:42',NULL,NULL),(218,NULL,NULL,'a22f7f81f5614398b27d857344f5e736',NULL,NULL,NULL,NULL,'2026-01-31 07:57:51',NULL,'2026-01-31 07:57:51',NULL,NULL),(219,NULL,'96226752957f4955a17a20529a3deb53',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:57:54',NULL,'2026-01-31 07:57:54',NULL,NULL),(220,NULL,NULL,'9199650599914a098a8de0cc3cc368fe',NULL,NULL,NULL,NULL,'2026-01-31 07:57:58',NULL,'2026-01-31 07:57:58',NULL,NULL),(221,NULL,NULL,'d6078cfaadaa45ae9256245554f784fe',NULL,NULL,NULL,NULL,'2026-01-31 07:57:59',NULL,'2026-01-31 07:57:59',NULL,NULL),(222,NULL,NULL,'2ca2fda9f5dd4cf6af70572c31323ef4',NULL,NULL,NULL,NULL,'2026-01-31 07:58:00',NULL,'2026-01-31 07:58:00',NULL,NULL),(223,NULL,'ea7be433800c4bb0a1588752184a4acd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:02',NULL,'2026-01-31 07:58:02',NULL,NULL),(224,NULL,'8c1a62e636554f37b2cce33e96424cc9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:02',NULL,'2026-01-31 07:58:02',NULL,NULL),(225,NULL,'fd9f0c923b994b0295e72b111f661de1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:03',NULL,'2026-01-31 07:58:03',NULL,NULL),(226,NULL,NULL,'71f1e2aacc6b45e9929b713fbad6529b',NULL,NULL,NULL,NULL,'2026-01-31 07:58:08',NULL,'2026-01-31 07:58:08',NULL,NULL),(227,NULL,NULL,'e3e9c6030a444f7db3315bda9238210e',NULL,NULL,NULL,NULL,'2026-01-31 07:58:10',NULL,'2026-01-31 07:58:10',NULL,NULL),(228,NULL,'d72a7d87c05a4aacb8b2ffe14fdc802d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:12',NULL,'2026-01-31 07:58:12',NULL,NULL),(229,NULL,'7fc3f7044fcb49b181117fb37f469e85',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:15',NULL,'2026-01-31 07:58:15',NULL,NULL),(230,NULL,NULL,'868dd7bf11a2490fa81662ff24fdd50a',NULL,NULL,NULL,NULL,'2026-01-31 07:58:17',NULL,'2026-01-31 07:58:17',NULL,NULL),(231,NULL,'666a8e0f3460420b8e411dd528cb65c7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:18',NULL,'2026-01-31 07:58:18',NULL,NULL),(232,NULL,NULL,'c6b0f050f04547538ad3d984a782d2f5',NULL,NULL,NULL,NULL,'2026-01-31 07:58:22',NULL,'2026-01-31 07:58:22',NULL,NULL),(233,NULL,'101a88b5437b4a48be8924430c457a78',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:23',NULL,'2026-01-31 07:58:23',NULL,NULL),(234,NULL,NULL,'93973daeb08c453e90372a79b54b9ede',NULL,NULL,NULL,NULL,'2026-01-31 07:58:39',NULL,'2026-01-31 07:58:39',NULL,NULL),(235,NULL,NULL,'f604ab8ce514415199c9c6743e4c5883',NULL,NULL,NULL,NULL,'2026-01-31 07:58:39',NULL,'2026-01-31 07:58:39',NULL,NULL),(236,NULL,'49463c3785ca451ea25e79210872c961',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:40',NULL,'2026-01-31 07:58:40',NULL,NULL),(237,NULL,'8033316fc42c4926bfd1f8a34b02fa97',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:58:41',NULL,'2026-01-31 07:58:41',NULL,NULL),(238,NULL,NULL,'e5b93162787e405080a5a790c1847434',NULL,NULL,NULL,NULL,'2026-01-31 07:59:50',NULL,'2026-01-31 07:59:50',NULL,NULL),(239,NULL,'dbf6b6306ca449dfb064371ec88681f5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:59:51',NULL,'2026-01-31 07:59:51',NULL,NULL),(240,NULL,NULL,'b034a039074641a7b7c872e8b715ca4c',NULL,NULL,NULL,NULL,'2026-01-31 07:59:57',NULL,'2026-01-31 07:59:57',NULL,NULL),(241,NULL,NULL,'28bc3d7192a948568166447bc8fbb75d',NULL,NULL,NULL,NULL,'2026-01-31 07:59:57',NULL,'2026-01-31 07:59:57',NULL,NULL),(242,NULL,'273fe485cc184dd8bf86440d8d1e05f3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 07:59:59',NULL,'2026-01-31 07:59:59',NULL,NULL),(243,NULL,'6a006c2e574848d99c5d0c897941e8bf',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:01',NULL,'2026-01-31 08:00:01',NULL,NULL),(244,NULL,NULL,'9385accdf1c042398e05444a3080e018',NULL,NULL,NULL,NULL,'2026-01-31 08:00:09',NULL,'2026-01-31 08:00:09',NULL,NULL),(245,NULL,'5e2423ea3fcb4c06a5d51165ed251cd7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:12',NULL,'2026-01-31 08:00:12',NULL,NULL),(246,NULL,NULL,'0e402088c09448e1a6f0cd61b11e0816',NULL,NULL,NULL,NULL,'2026-01-31 08:00:24',NULL,'2026-01-31 08:00:24',NULL,NULL),(247,NULL,'f31b0319126848a5b8fd9521dc509172',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:26',NULL,'2026-01-31 08:00:26',NULL,NULL),(248,NULL,NULL,'4d51b2b0699a4ec181f389dd7faada4f',NULL,NULL,NULL,NULL,'2026-01-31 08:00:28',NULL,'2026-01-31 08:00:28',NULL,NULL),(249,NULL,'6c810112303547ea89cf9536f8378d07',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:00:30',NULL,'2026-01-31 08:00:30',NULL,NULL),(250,NULL,NULL,'2d20e7b6189c4916947ddae2155da8cf',NULL,NULL,NULL,NULL,'2026-01-31 08:00:51',NULL,'2026-01-31 08:00:51',NULL,NULL),(251,NULL,NULL,'aca4a3ac27c249718268b71ac43ef4f9',NULL,NULL,NULL,NULL,'2026-01-31 08:00:51',NULL,'2026-01-31 08:00:51',NULL,NULL),(252,NULL,'546c0d49cea64695b5f4ee15ea24aa42',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:02',NULL,'2026-01-31 08:01:02',NULL,NULL),(253,NULL,'0f3a75a965fc495bbe02cb5bfad2053b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:06',NULL,'2026-01-31 08:01:06',NULL,NULL),(254,NULL,NULL,'d191786cc14e4c58971de1366b2033b4',NULL,NULL,NULL,NULL,'2026-01-31 08:01:17',NULL,'2026-01-31 08:01:17',NULL,NULL),(255,NULL,NULL,'3d34f095c6f44c6b969538bb8c8f8af2',NULL,NULL,NULL,NULL,'2026-01-31 08:01:19',NULL,'2026-01-31 08:01:19',NULL,NULL),(256,NULL,'2f7d58f158dd464392148ccaaef83c90',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:19',NULL,'2026-01-31 08:01:19',NULL,NULL),(257,NULL,NULL,'464591ccb78f45fb825bdb6e52074693',NULL,NULL,NULL,NULL,'2026-01-31 08:01:19',NULL,'2026-01-31 08:01:19',NULL,NULL),(258,NULL,'68792dd4703c48cbbe83c6d94fcddd11',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:22',NULL,'2026-01-31 08:01:22',NULL,NULL),(259,NULL,'4e2178dfa4d54cdea4c80869fb8cf9d0',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:27',NULL,'2026-01-31 08:01:27',NULL,NULL),(260,NULL,NULL,'004b5e28a46640649cafc101d998a6b6',NULL,NULL,NULL,NULL,'2026-01-31 08:01:36',NULL,'2026-01-31 08:01:36',NULL,NULL),(261,NULL,NULL,'37dcea154c554a9caa08cddfd7e27a5d',NULL,NULL,NULL,NULL,'2026-01-31 08:01:36',NULL,'2026-01-31 08:01:36',NULL,NULL),(262,NULL,'bafa97bd232441c8a73b7c853b40ba35',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:39',NULL,'2026-01-31 08:01:39',NULL,NULL),(263,NULL,'099bc8f95a084c519372423f6597b130',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:01:41',NULL,'2026-01-31 08:01:41',NULL,NULL),(264,NULL,NULL,'2be936219af64d418d37a46d4f237684',NULL,NULL,NULL,NULL,'2026-01-31 08:02:02',NULL,'2026-01-31 08:02:02',NULL,NULL),(265,NULL,'b79bd603356c4b49b4dca3d45a2c84e9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:04',NULL,'2026-01-31 08:02:04',NULL,NULL),(266,NULL,NULL,'03c559ac8a6c4025904d17c410176ada',NULL,NULL,NULL,NULL,'2026-01-31 08:02:10',NULL,'2026-01-31 08:02:10',NULL,NULL),(267,NULL,'ad88f4beaded4242afc8335d7db35891',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:12',NULL,'2026-01-31 08:02:12',NULL,NULL),(268,NULL,NULL,'749feb683f1348cf89ef08d30c59290a',NULL,NULL,NULL,NULL,'2026-01-31 08:02:17',NULL,'2026-01-31 08:02:17',NULL,NULL),(269,NULL,'92226b5403bf4828aa18d263c772ab9e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:18',NULL,'2026-01-31 08:02:18',NULL,NULL),(270,NULL,NULL,'c03bfebfc7e34f83b204997b98c8e690',NULL,NULL,NULL,NULL,'2026-01-31 08:02:26',NULL,'2026-01-31 08:02:26',NULL,NULL),(271,NULL,'3e7009d6ac414afab6cdf704bd382133',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:27',NULL,'2026-01-31 08:02:27',NULL,NULL),(272,NULL,NULL,'63595161657444fd965a169bce69db80',NULL,NULL,NULL,NULL,'2026-01-31 08:02:41',NULL,'2026-01-31 08:02:41',NULL,NULL),(273,NULL,'ce21ddfb389f4a7ca69d4a17b280e656',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:02:42',NULL,'2026-01-31 08:02:42',NULL,NULL),(274,NULL,NULL,'9125de10fe4a4730bd1db10e3fbd846e',NULL,NULL,NULL,NULL,'2026-01-31 08:03:11',NULL,'2026-01-31 08:03:11',NULL,NULL),(275,NULL,'665d05725a96453782fbfaaab0953f1b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:03:13',NULL,'2026-01-31 08:03:13',NULL,NULL),(276,NULL,NULL,'4eb6c0e509f14fb2958ca76604db17c0',NULL,NULL,NULL,NULL,'2026-01-31 08:03:49',NULL,'2026-01-31 08:03:49',NULL,NULL),(277,NULL,'29c39093d6684600bef00c63da85e6b7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:03:51',NULL,'2026-01-31 08:03:51',NULL,NULL),(278,NULL,NULL,'97778ff629964356819ef34be55ca5a6',NULL,NULL,NULL,NULL,'2026-01-31 08:04:03',NULL,'2026-01-31 08:04:03',NULL,NULL),(279,NULL,'03f24e162c6d454aa9e31d60b478001d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:04:04',NULL,'2026-01-31 08:04:04',NULL,NULL),(280,NULL,NULL,'e1d35c23d6b748ad87537afe5abe334b',NULL,NULL,NULL,NULL,'2026-01-31 08:04:08',NULL,'2026-01-31 08:04:08',NULL,NULL),(281,NULL,'1e963058ee2443b39b0b7611fbe7aae8',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:04:10',NULL,'2026-01-31 08:04:10',NULL,NULL),(282,NULL,NULL,'46ffd64a348845fab6cdc53249353575',NULL,NULL,NULL,NULL,'2026-01-31 08:04:34',NULL,'2026-01-31 08:04:34',NULL,NULL),(283,NULL,'521dcd459f144f2bb32de93d50ae0391',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:04:35',NULL,'2026-01-31 08:04:35',NULL,NULL),(284,NULL,NULL,'35d966201a0243c2a8f4c689350e8ddd',NULL,NULL,NULL,NULL,'2026-01-31 08:05:04',NULL,'2026-01-31 08:05:04',NULL,NULL),(285,NULL,'506fa1d7269349f1aa48237dd82ac79e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:05:05',NULL,'2026-01-31 08:05:05',NULL,NULL),(286,NULL,NULL,'fd3d70d97c394edaa70e32807d7a96ca',NULL,NULL,NULL,NULL,'2026-01-31 08:05:10',NULL,'2026-01-31 08:05:10',NULL,NULL),(287,NULL,'3d28270b439f4cb1aa201d46b9f8a843',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:05:12',NULL,'2026-01-31 08:05:12',NULL,NULL),(288,NULL,NULL,'62c4293768ff432a9fe75bfc030daea4',NULL,NULL,NULL,NULL,'2026-01-31 08:05:17',NULL,'2026-01-31 08:05:17',NULL,NULL),(289,NULL,'8e7f05f4f2434c0aac733672635a0e5e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:05:21',NULL,'2026-01-31 08:05:21',NULL,NULL),(290,NULL,NULL,'3a682e3ec6f149f7b44cbafe29a53597',NULL,NULL,NULL,NULL,'2026-01-31 08:06:25',NULL,'2026-01-31 08:06:25',NULL,NULL),(291,NULL,'2da05c238ef24774b1c46b0979d5512b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:06:27',NULL,'2026-01-31 08:06:27',NULL,NULL),(292,NULL,NULL,'57fcb774fb574bf0beea4fb49adb0f80',NULL,NULL,NULL,NULL,'2026-01-31 08:07:00',NULL,'2026-01-31 08:07:00',NULL,NULL),(293,NULL,'44ad7f776f814675b2232eb023baacdd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:07:04',NULL,'2026-01-31 08:07:04',NULL,NULL),(294,NULL,NULL,'b03026160db94db6986ad5102d7c91b0',NULL,NULL,NULL,NULL,'2026-01-31 08:07:08',NULL,'2026-01-31 08:07:08',NULL,NULL),(295,NULL,'29e3a29d74394a8b8d065d1a3b29dfa7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:07:09',NULL,'2026-01-31 08:07:09',NULL,NULL),(296,NULL,NULL,'635d241d11954d41bf1a7e1c53752f32',NULL,NULL,NULL,NULL,'2026-01-31 08:07:26',NULL,'2026-01-31 08:07:26',NULL,NULL),(297,NULL,'c3bd1701a2c74b659f9a0cd3c58182d2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:07:28',NULL,'2026-01-31 08:07:28',NULL,NULL),(298,NULL,NULL,'f189bb192c164df8b0af4c5f50a1285f',NULL,NULL,NULL,NULL,'2026-01-31 08:08:02',NULL,'2026-01-31 08:08:02',NULL,NULL),(299,NULL,'ccb16926f2c74ec3b393103a33e7fa3b',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:05',NULL,'2026-01-31 08:08:05',NULL,NULL),(300,NULL,NULL,'496d66c21c524cd193afd4289fccd421',NULL,NULL,NULL,NULL,'2026-01-31 08:08:42',NULL,'2026-01-31 08:08:42',NULL,NULL),(301,NULL,'e1b9f4d9a424402a969a75d0e1a09aa4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:43',NULL,'2026-01-31 08:08:43',NULL,NULL),(302,NULL,NULL,'31a158d811524ad292199b931be12bc7',NULL,NULL,NULL,NULL,'2026-01-31 08:08:48',NULL,'2026-01-31 08:08:48',NULL,NULL),(303,NULL,'64a52f6edb6c4843a8decc313f8c10e3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:08:50',NULL,'2026-01-31 08:08:50',NULL,NULL),(304,NULL,NULL,'60f2b878669c4c529b35e04860cc6d64',NULL,NULL,NULL,NULL,'2026-01-31 08:08:59',NULL,'2026-01-31 08:08:59',NULL,NULL),(305,NULL,'0c73212dc7c84914b6c934d45b6826f7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:09:00',NULL,'2026-01-31 08:09:00',NULL,NULL),(306,NULL,NULL,'6ec2f1b397404af09d4aba95271759dd',NULL,NULL,NULL,NULL,'2026-01-31 08:09:31',NULL,'2026-01-31 08:09:31',NULL,NULL),(307,NULL,'dd99975994ff45c99cc41da24976e491',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:09:32',NULL,'2026-01-31 08:09:32',NULL,NULL),(308,NULL,NULL,'9b363a9a11084c998b823d2941f27c97',NULL,NULL,NULL,NULL,'2026-01-31 08:09:48',NULL,'2026-01-31 08:09:48',NULL,NULL),(309,NULL,'dfc138d4fe084f1e8bfe6a94be18cc23',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:09:49',NULL,'2026-01-31 08:09:49',NULL,NULL),(310,NULL,NULL,'2c72ac0892c84ca0bf3e2ef74eed4f64',NULL,NULL,NULL,NULL,'2026-01-31 08:10:30',NULL,'2026-01-31 08:10:30',NULL,NULL),(311,NULL,'2901e55f200f4622ae841166074ac8f8',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:31',NULL,'2026-01-31 08:10:31',NULL,NULL),(312,NULL,NULL,'16d731f5875748ca9b8036b2ba061042',NULL,NULL,NULL,NULL,'2026-01-31 08:10:35',NULL,'2026-01-31 08:10:35',NULL,NULL),(313,NULL,'3469c253459e40e39dcf5bcb6a32008f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:37',NULL,'2026-01-31 08:10:37',NULL,NULL),(314,NULL,NULL,'c85c4974d1024573aedad360db16c274',NULL,NULL,NULL,NULL,'2026-01-31 08:10:54',NULL,'2026-01-31 08:10:54',NULL,NULL),(315,NULL,'a328413b1f5d4bdb90716c256341492f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:10:55',NULL,'2026-01-31 08:10:55',NULL,NULL),(316,NULL,NULL,'55f81600a60b49aaae5b4c28549afdaf',NULL,NULL,NULL,NULL,'2026-01-31 08:12:33',NULL,'2026-01-31 08:12:33',NULL,NULL),(317,NULL,'88b896f61c644b6fac0351ce6828b6e1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:12:37',NULL,'2026-01-31 08:12:37',NULL,NULL),(318,NULL,NULL,'80d33e2f57b64bd78a04cd8875660772',NULL,NULL,NULL,NULL,'2026-01-31 08:12:50',NULL,'2026-01-31 08:12:50',NULL,NULL),(319,NULL,NULL,'8c19b2a579af4991bda8532fb17617a1',NULL,NULL,NULL,NULL,'2026-01-31 08:12:54',NULL,'2026-01-31 08:12:54',NULL,NULL),(320,NULL,'c880a122b70a4b858703f9e041fc1ac2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:12:55',NULL,'2026-01-31 08:12:55',NULL,NULL),(321,NULL,'96cffd653fc04612bc1b3434529fb946',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:12:57',NULL,'2026-01-31 08:12:57',NULL,NULL),(322,NULL,NULL,'12a823bd7c6e4cf492ebf6c1d002a91f',NULL,NULL,NULL,NULL,'2026-01-31 08:15:42',NULL,'2026-01-31 08:15:42',NULL,NULL),(323,NULL,'9c03fec1b3664105996aa979e226d8f8',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:15:45',NULL,'2026-01-31 08:15:45',NULL,NULL),(324,NULL,NULL,'111fdaf79c084a91902fe37a7a502020',NULL,NULL,NULL,NULL,'2026-01-31 08:15:58',NULL,'2026-01-31 08:15:58',NULL,NULL),(325,NULL,'58e900992be7400fb940ca20f13e12d1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:16:03',NULL,'2026-01-31 08:16:03',NULL,NULL),(326,NULL,NULL,'684cece6993b4999be175313a51a3eac',NULL,NULL,NULL,NULL,'2026-01-31 08:17:32',NULL,'2026-01-31 08:17:32',NULL,NULL),(327,NULL,'5c1adda10526412b8a61b51f1d5d947a',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:17:35',NULL,'2026-01-31 08:17:35',NULL,NULL),(328,NULL,NULL,'8080000681f449c3a9754c876165d667',NULL,NULL,NULL,NULL,'2026-01-31 08:18:00',NULL,'2026-01-31 08:18:00',NULL,NULL),(329,NULL,NULL,'15566d31e0b8433dadcb9333298c0491',NULL,NULL,NULL,NULL,'2026-01-31 08:18:00',NULL,'2026-01-31 08:18:00',NULL,NULL),(330,NULL,'89102c3023954037985fa547a12096b4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:03',NULL,'2026-01-31 08:18:03',NULL,NULL),(331,NULL,'5a6c60c75300483aa07e13b08923b1a1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:11',NULL,'2026-01-31 08:18:11',NULL,NULL),(332,NULL,NULL,'8db5a8acb6d04c988f9dd4f74380c487',NULL,NULL,NULL,NULL,'2026-01-31 08:18:28',NULL,'2026-01-31 08:18:28',NULL,NULL),(333,NULL,'eafe22d6cfcb41d4b31597087498a565',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:31',NULL,'2026-01-31 08:18:31',NULL,NULL),(334,NULL,NULL,'469a76c175b64f84b29a4a44c8eaf3c4',NULL,NULL,NULL,NULL,'2026-01-31 08:18:42',NULL,'2026-01-31 08:18:42',NULL,NULL),(335,NULL,NULL,'8085cb30d93141e792bb903cc733f24b',NULL,NULL,NULL,NULL,'2026-01-31 08:18:43',NULL,'2026-01-31 08:18:43',NULL,NULL),(336,NULL,'587e3df6fc904afc99c9c6411095e3ef',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:45',NULL,'2026-01-31 08:18:45',NULL,NULL),(337,NULL,'885adac0277749699f679ade6da7ec1d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:18:47',NULL,'2026-01-31 08:18:47',NULL,NULL),(338,NULL,NULL,'46e80dac513240c291cce30a27941388',NULL,NULL,NULL,NULL,'2026-01-31 08:18:54',NULL,'2026-01-31 08:18:54',NULL,NULL),(339,NULL,'38090db689d64133b0f48fe28c946a00',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:00',NULL,'2026-01-31 08:19:00',NULL,NULL),(340,NULL,NULL,'e6ba0fce7089428195e6cdb716cb9394',NULL,NULL,NULL,NULL,'2026-01-31 08:19:14',NULL,'2026-01-31 08:19:14',NULL,NULL),(341,NULL,'26804c65ac6d433ba336d37f70fdfa3f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:16',NULL,'2026-01-31 08:19:16',NULL,NULL),(342,NULL,NULL,'124a117e3bc74be7a699df447518bc54',NULL,NULL,NULL,NULL,'2026-01-31 08:19:26',NULL,'2026-01-31 08:19:26',NULL,NULL),(343,NULL,NULL,'588d05c741d9418f8c5b5bfa0d0c887a',NULL,NULL,NULL,NULL,'2026-01-31 08:19:28',NULL,'2026-01-31 08:19:28',NULL,NULL),(344,NULL,'0470bddbdc05460087ff3c4b7dbb6dcd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:28',NULL,'2026-01-31 08:19:28',NULL,NULL),(345,NULL,'b88014f079bc4442acb657ee1d42b453',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:19:30',NULL,'2026-01-31 08:19:30',NULL,NULL),(346,NULL,NULL,'a80ca71875e8413caa2b52e679e1dd40',NULL,NULL,NULL,NULL,'2026-01-31 08:21:47',NULL,'2026-01-31 08:21:47',NULL,NULL),(347,NULL,'782758ebebe64580accb21a22280e02f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:21:49',NULL,'2026-01-31 08:21:49',NULL,NULL),(348,NULL,NULL,'a8897cd859ff4a79a1a16eaee71d22ed',NULL,NULL,NULL,NULL,'2026-01-31 08:22:40',NULL,'2026-01-31 08:22:40',NULL,NULL),(349,NULL,'29d7f464a8694725aa9692aac772c256',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:22:44',NULL,'2026-01-31 08:22:44',NULL,NULL),(350,NULL,NULL,'407d34e8fb1740348074421e727316b9',NULL,NULL,NULL,NULL,'2026-01-31 08:22:49',NULL,'2026-01-31 08:22:49',NULL,NULL),(351,NULL,'21dda741497c4909bbf47acb9be16da7',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:22:54',NULL,'2026-01-31 08:22:54',NULL,NULL),(352,NULL,NULL,'67b7ae50c2294d9ea18500f8b2a7a0e1',NULL,NULL,NULL,NULL,'2026-01-31 08:23:02',NULL,'2026-01-31 08:23:02',NULL,NULL),(353,NULL,'c27447f4c694467d8668782cfb03d478',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:23:06',NULL,'2026-01-31 08:23:06',NULL,NULL),(354,NULL,NULL,'9df3521cb77f4056ab3994a6ce6a53ea',NULL,NULL,NULL,NULL,'2026-01-31 08:23:11',NULL,'2026-01-31 08:23:11',NULL,NULL),(355,NULL,'24ad0fe9941e4567963cd736586a3cd9',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:23:14',NULL,'2026-01-31 08:23:14',NULL,NULL),(356,NULL,NULL,'c086a82bd0384612a78981006889df41',NULL,NULL,NULL,NULL,'2026-01-31 08:24:20',NULL,'2026-01-31 08:24:20',NULL,NULL),(357,NULL,'96de645f38844180b404d1a7cf7dd460',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:24:22',NULL,'2026-01-31 08:24:22',NULL,NULL),(358,NULL,NULL,'f4d66dd0b7ff443cbcdb6e2c9f5c4c8c',NULL,NULL,NULL,NULL,'2026-01-31 08:28:09',NULL,'2026-01-31 08:28:09',NULL,NULL),(359,NULL,'cf024d54545b4af882a87c721105742a',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:28:11',NULL,'2026-01-31 08:28:11',NULL,NULL),(360,NULL,NULL,'1d03198d8ab846bda092e089b2d5a6c7',NULL,NULL,NULL,NULL,'2026-01-31 08:29:30',NULL,'2026-01-31 08:29:30',NULL,NULL),(361,NULL,'5b87da3b3f42494f96baeeeaf60b54df',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:29:32',NULL,'2026-01-31 08:29:32',NULL,NULL),(362,NULL,NULL,'4bda95d045de4dfeaa9bb7be3ab9970b',NULL,NULL,NULL,NULL,'2026-01-31 08:29:41',NULL,'2026-01-31 08:29:41',NULL,NULL),(363,NULL,NULL,'69ec085ad17d481d9da688ef0ec6ace4',NULL,NULL,NULL,NULL,'2026-01-31 08:29:42',NULL,'2026-01-31 08:29:42',NULL,NULL),(364,NULL,'6ebb12f413f2487db425a12bb8b17261',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:29:49',NULL,'2026-01-31 08:29:49',NULL,NULL),(365,NULL,NULL,'e6c30048433a434292bdcecdaf4458d3',NULL,NULL,NULL,NULL,'2026-01-31 08:29:56',NULL,'2026-01-31 08:29:56',NULL,NULL),(366,NULL,NULL,'86b11b858a2e480cad536adeeb6fd771',NULL,NULL,NULL,NULL,'2026-01-31 08:29:56',NULL,'2026-01-31 08:29:56',NULL,NULL),(367,NULL,'25edff63f82545baa1e2cf5c780069e3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:30:00',NULL,'2026-01-31 08:30:00',NULL,NULL),(368,NULL,NULL,'ba81d91ee3fa41f0b2aec26a89112489',NULL,NULL,NULL,NULL,'2026-01-31 08:30:50',NULL,'2026-01-31 08:30:50',NULL,NULL),(369,NULL,'3e158f8d290b47cbb39903484e3df783',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:30:52',NULL,'2026-01-31 08:30:52',NULL,NULL),(370,NULL,NULL,'432ac8867d8240408db455fc25bb5901',NULL,NULL,NULL,NULL,'2026-01-31 08:31:21',NULL,'2026-01-31 08:31:21',NULL,NULL),(371,NULL,'491937de020742d7b4e847dc3bf57950',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:31:24',NULL,'2026-01-31 08:31:24',NULL,NULL),(372,NULL,NULL,'d91ac41a8e444974a11ffbef7b04ddb3',NULL,NULL,NULL,NULL,'2026-01-31 08:33:33',NULL,'2026-01-31 08:33:33',NULL,NULL),(373,NULL,'b6a7de05649d42c6acb1aa6e6026b2b4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:33:35',NULL,'2026-01-31 08:33:35',NULL,NULL),(374,NULL,NULL,'8efe4dc047d44a0fbd21b243ddc921d8',NULL,NULL,NULL,NULL,'2026-01-31 08:34:08',NULL,'2026-01-31 08:34:08',NULL,NULL),(375,NULL,NULL,'70415ffcacb442aeba9eee72745e52c7',NULL,NULL,NULL,NULL,'2026-01-31 08:34:08',NULL,'2026-01-31 08:34:08',NULL,NULL),(376,NULL,'f29ce02c82b64cab8f3ba34301743d61',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:34:09',NULL,'2026-01-31 08:34:09',NULL,NULL),(377,NULL,'5fe2a450b6ff4f73a7fe8def47304a29',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:34:11',NULL,'2026-01-31 08:34:11',NULL,NULL),(378,NULL,NULL,'fb3f20f0143d465ebfe98f6a13200890',NULL,NULL,NULL,NULL,'2026-01-31 08:35:34',NULL,'2026-01-31 08:35:34',NULL,NULL),(379,NULL,NULL,'80d7177061144a41ad741471577f6ae1',NULL,NULL,NULL,NULL,'2026-01-31 08:35:34',NULL,'2026-01-31 08:35:34',NULL,NULL),(380,NULL,'40db421b27d84f809f8074c58151327f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:35:37',NULL,'2026-01-31 08:35:37',NULL,NULL),(381,NULL,NULL,'ef51681d234a4abc88ff433d0640b6e7',NULL,NULL,NULL,NULL,'2026-01-31 08:36:03',NULL,'2026-01-31 08:36:03',NULL,NULL),(382,NULL,'953a213fa5cb435ab3c04ad96152685f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:36:07',NULL,'2026-01-31 08:36:07',NULL,NULL),(383,NULL,NULL,'59bd928a3bb24a89af6a53a8392bd344',NULL,NULL,NULL,NULL,'2026-01-31 08:37:04',NULL,'2026-01-31 08:37:04',NULL,NULL),(384,NULL,'2c23fe6507444c32a4c0254003f2c6cb',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:37:16',NULL,'2026-01-31 08:37:16',NULL,NULL),(385,NULL,NULL,'c13cac16cdef424b8050c4bea5a7e9c3',NULL,NULL,NULL,NULL,'2026-01-31 08:39:50',NULL,'2026-01-31 08:39:50',NULL,NULL),(386,NULL,'fcc39962194d44e5b37cad3fb1adc6c4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:39:53',NULL,'2026-01-31 08:39:53',NULL,NULL),(387,NULL,NULL,'c6c60cceb0414556a99e4009200ad565',NULL,NULL,NULL,NULL,'2026-01-31 08:41:24',NULL,'2026-01-31 08:41:24',NULL,NULL),(388,NULL,'0026cad467ff4524ae5b675192e66666',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:41:32',NULL,'2026-01-31 08:41:32',NULL,NULL),(389,NULL,NULL,'b6733330b634472ca8c21316f1ee5057',NULL,NULL,NULL,NULL,'2026-01-31 08:42:14',NULL,'2026-01-31 08:42:14',NULL,NULL),(390,NULL,'1e29363ca464487b931af54fe14166b1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:42:17',NULL,'2026-01-31 08:42:17',NULL,NULL),(391,NULL,NULL,'8ecca7135cc34e33aafec6544e0148af',NULL,NULL,NULL,NULL,'2026-01-31 08:42:38',NULL,'2026-01-31 08:42:38',NULL,NULL),(392,NULL,'9d498c29ca8f4e7faefa2959efff3cb2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:42:40',NULL,'2026-01-31 08:42:40',NULL,NULL),(393,NULL,NULL,'152becc96c854e3ca68b1b377cae845d',NULL,NULL,NULL,NULL,'2026-01-31 08:44:22',NULL,'2026-01-31 08:44:22',NULL,NULL),(394,NULL,'0a5099d95b08434397e0bf691596b2cf',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:44:26',NULL,'2026-01-31 08:44:26',NULL,NULL),(395,NULL,NULL,'5ffac39d7ad34155a4e068c9bf04635e',NULL,NULL,NULL,NULL,'2026-01-31 08:44:34',NULL,'2026-01-31 08:44:34',NULL,NULL),(396,NULL,NULL,'c2e417cf7927412d9555b79aae71bb54',NULL,NULL,NULL,NULL,'2026-01-31 08:44:36',NULL,'2026-01-31 08:44:36',NULL,NULL),(397,NULL,'4ac1759c892d49069e58e75323dece87',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:44:44',NULL,'2026-01-31 08:44:44',NULL,NULL),(398,NULL,'2e7958dbdd8e4d4683489284850647e0',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:44:49',NULL,'2026-01-31 08:44:49',NULL,NULL),(399,NULL,NULL,'516e093a00a44667ba1308900be70d8d',NULL,NULL,NULL,NULL,'2026-01-31 08:45:16',NULL,'2026-01-31 08:45:16',NULL,NULL),(400,NULL,'621c17d53cba46d386de8efb560a988e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:45:19',NULL,'2026-01-31 08:45:19',NULL,NULL),(401,NULL,NULL,'e5e1edb815004883bd699ac3ac702cdb',NULL,NULL,NULL,NULL,'2026-01-31 08:46:32',NULL,'2026-01-31 08:46:32',NULL,NULL),(402,NULL,'f45314d9274542ac86156e752065d617',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:46:35',NULL,'2026-01-31 08:46:35',NULL,NULL),(403,NULL,NULL,'d169542a81014a91ac7ff995f44e45a5',NULL,NULL,NULL,NULL,'2026-01-31 08:47:26',NULL,'2026-01-31 08:47:26',NULL,NULL),(404,NULL,NULL,'c6cf04cf27114946bfcc25863fa00307',NULL,NULL,NULL,NULL,'2026-01-31 08:47:27',NULL,'2026-01-31 08:47:27',NULL,NULL),(405,NULL,'b32c37451e874c5b883c6ba460587c52',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:47:28',NULL,'2026-01-31 08:47:28',NULL,NULL),(406,NULL,'d8d191d40d924e418ffde5e8b5483cf4',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:47:30',NULL,'2026-01-31 08:47:30',NULL,NULL),(407,NULL,NULL,'aa7f893021af4a84b03d85b476dadfe0',NULL,NULL,NULL,NULL,'2026-01-31 08:51:40',NULL,'2026-01-31 08:51:40',NULL,NULL),(408,NULL,'bf1c3d387dbe4191b4d05bdfca5959da',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:51:41',NULL,'2026-01-31 08:51:41',NULL,NULL),(409,NULL,NULL,'1b85a92acbd44357b341ea45817e0d54',NULL,NULL,NULL,NULL,'2026-01-31 08:52:18',NULL,'2026-01-31 08:52:18',NULL,NULL),(410,NULL,'d25e38c8ee7e4c819da74af820219c54',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:52:20',NULL,'2026-01-31 08:52:20',NULL,NULL),(411,NULL,NULL,'9454853c61ff4d0d821e84f00144c006',NULL,NULL,NULL,NULL,'2026-01-31 08:52:29',NULL,'2026-01-31 08:52:29',NULL,NULL),(412,NULL,'7c88afe842cd47dea75807eea90f5e58',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:52:31',NULL,'2026-01-31 08:52:31',NULL,NULL),(413,NULL,NULL,'3bd4ce8a916a4bdbbc988eb4fe32991e',NULL,NULL,NULL,NULL,'2026-01-31 08:53:14',NULL,'2026-01-31 08:53:14',NULL,NULL),(414,NULL,'76fb5cb7abcd4d74abfc471a96bbd12c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:53:17',NULL,'2026-01-31 08:53:17',NULL,NULL),(415,NULL,NULL,'a498364761ef428b99cac3f92e603385',NULL,NULL,NULL,NULL,'2026-01-31 08:53:27',NULL,'2026-01-31 08:53:27',NULL,NULL),(416,NULL,'8397e0fed04b4dabb57148d0924de2dc',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:53:30',NULL,'2026-01-31 08:53:30',NULL,NULL),(417,NULL,NULL,'7ecbac610eef4c94bf9fdd2ee240853f',NULL,NULL,NULL,NULL,'2026-01-31 08:53:42',NULL,'2026-01-31 08:53:42',NULL,NULL),(418,NULL,'c88376bcb43e42cf9894ecb9352e5822',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:53:50',NULL,'2026-01-31 08:53:50',NULL,NULL),(419,NULL,NULL,'f1c6e7eff11b435a81429826a682b32f',NULL,NULL,NULL,NULL,'2026-01-31 08:56:48',NULL,'2026-01-31 08:56:48',NULL,NULL),(420,NULL,NULL,'f40dad094c6e43daab6e48d01b1df1ff',NULL,NULL,NULL,NULL,'2026-01-31 08:56:49',NULL,'2026-01-31 08:56:49',NULL,NULL),(421,NULL,'0bfe11bd9d694684b527666e2c378eed',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:56:51',NULL,'2026-01-31 08:56:51',NULL,NULL),(422,NULL,'bf9fd1d29e534bd99b47eb8854374663',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:56:58',NULL,'2026-01-31 08:56:58',NULL,NULL),(423,NULL,NULL,'53804fd0f3a14f95a4955e3bc6dcc8cb',NULL,NULL,NULL,NULL,'2026-01-31 08:57:58',NULL,'2026-01-31 08:57:58',NULL,NULL),(424,NULL,'ab2d642eb03c4bda84a9a23e86f1fa4d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:00',NULL,'2026-01-31 08:58:00',NULL,NULL),(425,NULL,NULL,'c1c047e8715e49b2a126a78e44daf2e8',NULL,NULL,NULL,NULL,'2026-01-31 08:58:11',NULL,'2026-01-31 08:58:11',NULL,NULL),(426,NULL,'01662186bc9a4adf8b2309e0fff4f829',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:14',NULL,'2026-01-31 08:58:14',NULL,NULL),(427,NULL,NULL,'755fd387d57b4fd69ffc64b80037fc0a',NULL,NULL,NULL,NULL,'2026-01-31 08:58:19',NULL,'2026-01-31 08:58:19',NULL,NULL),(428,NULL,'163643f7b31c4f1a986bc64f67da6073',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:21',NULL,'2026-01-31 08:58:21',NULL,NULL),(429,NULL,NULL,'a796d9f54ef0447d87526caaeac9763b',NULL,NULL,NULL,NULL,'2026-01-31 08:58:26',NULL,'2026-01-31 08:58:26',NULL,NULL),(430,NULL,NULL,'4e364ad937544559bea978006e9ff229',NULL,NULL,NULL,NULL,'2026-01-31 08:58:26',NULL,'2026-01-31 08:58:26',NULL,NULL),(431,NULL,'9ce62b246a60455e8ec83f770113c52c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:28',NULL,'2026-01-31 08:58:28',NULL,NULL),(432,NULL,'c37e7d6d634448bfb3172894ad2af105',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:31',NULL,'2026-01-31 08:58:31',NULL,NULL),(433,NULL,NULL,'cfaebb011a374541b083e772a6c83f25',NULL,NULL,NULL,NULL,'2026-01-31 08:58:53',NULL,'2026-01-31 08:58:53',NULL,NULL),(434,NULL,NULL,'1abd4d98f10845a7aa2b52dc709add72',NULL,NULL,NULL,NULL,'2026-01-31 08:58:54',NULL,'2026-01-31 08:58:54',NULL,NULL),(435,NULL,'f905106fa7f44c2887b979b4a26c636c',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:55',NULL,'2026-01-31 08:58:55',NULL,NULL),(436,NULL,'06b5fc9cfd4c49abb2d8b9f2f8a82c1f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:58:56',NULL,'2026-01-31 08:58:56',NULL,NULL),(437,NULL,NULL,'802db4935c5046888527023acbf8d3f5',NULL,NULL,NULL,NULL,'2026-01-31 08:59:29',NULL,'2026-01-31 08:59:29',NULL,NULL),(438,NULL,NULL,'9215f8331c82464fa6c6bd5b6d8099c7',NULL,NULL,NULL,NULL,'2026-01-31 08:59:30',NULL,'2026-01-31 08:59:30',NULL,NULL),(439,NULL,'b70c116d55604d64a98bef8370dd9bc1',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:59:32',NULL,'2026-01-31 08:59:32',NULL,NULL),(440,NULL,'790b9059378345aca91bca183d37da86',NULL,NULL,NULL,NULL,NULL,'2026-01-31 08:59:34',NULL,'2026-01-31 08:59:34',NULL,NULL),(441,NULL,NULL,'28a189bdf91449668d0c69498a7d87c1',NULL,NULL,NULL,NULL,'2026-01-31 09:00:04',NULL,'2026-01-31 09:00:04',NULL,NULL),(442,NULL,NULL,'bcf1e1157d7e443b8d368c84c9262aca',NULL,NULL,NULL,NULL,'2026-01-31 09:00:05',NULL,'2026-01-31 09:00:05',NULL,NULL),(443,NULL,'90899b511b3649779a3d222272698917',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:00:08',NULL,'2026-01-31 09:00:08',NULL,NULL),(444,NULL,NULL,'3859f52c5b70471097d1e4ffa75ecc0e',NULL,NULL,NULL,NULL,'2026-01-31 09:03:58',NULL,'2026-01-31 09:03:58',NULL,NULL),(445,NULL,NULL,'160c2aefd48b4e4b8c77c0d1cb59e487',NULL,NULL,NULL,NULL,'2026-01-31 09:03:58',NULL,'2026-01-31 09:03:58',NULL,NULL),(446,NULL,'1f293713f6854265a89a1a4a002088d5',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:04:00',NULL,'2026-01-31 09:04:00',NULL,NULL),(447,NULL,'9eac81fb2ffb497c9ff2610281a1bebd',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:04:02',NULL,'2026-01-31 09:04:02',NULL,NULL),(448,NULL,NULL,'b97882caec944ca3b26c230fcebff775',NULL,NULL,NULL,NULL,'2026-01-31 09:04:50',NULL,'2026-01-31 09:04:50',NULL,NULL),(449,NULL,NULL,'e70178eeba91454daf5f4e8a04f65425',NULL,NULL,NULL,NULL,'2026-01-31 09:04:51',NULL,'2026-01-31 09:04:51',NULL,NULL),(450,NULL,'3d3e35e8f8144cd58baa994b70ef9668',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:04:53',NULL,'2026-01-31 09:04:53',NULL,NULL),(451,NULL,'ad975c2936a74584ad30fd82247a9315',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:04:56',NULL,'2026-01-31 09:04:56',NULL,NULL),(452,NULL,NULL,'4bd7d1bbf3a8497b8b26f8df83fe8067',NULL,NULL,NULL,NULL,'2026-01-31 09:06:21',NULL,'2026-01-31 09:06:21',NULL,NULL),(453,NULL,NULL,'c35b4cdb6d104563b9476e3e80b932a8',NULL,NULL,NULL,NULL,'2026-01-31 09:06:22',NULL,'2026-01-31 09:06:22',NULL,NULL),(454,NULL,'c8017efbc64b4244b349174c29a41000',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:06:25',NULL,'2026-01-31 09:06:25',NULL,NULL),(455,NULL,'81da138e8aad4fd3a7a9a04f8bd41808',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:06:28',NULL,'2026-01-31 09:06:28',NULL,NULL),(456,NULL,NULL,'dc42b92a5dd34d32b6b184bdc7acb092',NULL,NULL,NULL,NULL,'2026-01-31 09:09:07',NULL,'2026-01-31 09:09:07',NULL,NULL),(457,NULL,NULL,'2f4847150ddc49b0878c3726aab83fb0',NULL,NULL,NULL,NULL,'2026-01-31 09:09:07',NULL,'2026-01-31 09:09:07',NULL,NULL),(458,NULL,'76ce367a834b49dfb5b436848118b860',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:09:09',NULL,'2026-01-31 09:09:09',NULL,NULL),(459,NULL,'c229e281241d4368996c6c9ffefa8392',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:09:11',NULL,'2026-01-31 09:09:11',NULL,NULL),(460,NULL,NULL,'d442c7ba12ed444ca6d4dcc5cfd36150',NULL,NULL,NULL,NULL,'2026-01-31 09:09:50',NULL,'2026-01-31 09:09:50',NULL,NULL),(461,NULL,NULL,'08cc4c7cd582442699579a9343235dae',NULL,NULL,NULL,NULL,'2026-01-31 09:09:50',NULL,'2026-01-31 09:09:50',NULL,NULL),(462,NULL,'abf9393aa2b646feb00a3d887a9dee14',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:09:52',NULL,'2026-01-31 09:09:52',NULL,NULL),(463,NULL,'b95106b4641046f0ad54f7a649270f89',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:09:53',NULL,'2026-01-31 09:09:53',NULL,NULL),(464,NULL,NULL,'b7233f93367f4dcd8eb2b6b115680192',NULL,NULL,NULL,NULL,'2026-01-31 09:12:34',NULL,'2026-01-31 09:12:34',NULL,NULL),(465,NULL,NULL,'25f49330703042d5ab68779413368eda',NULL,NULL,NULL,NULL,'2026-01-31 09:12:34',NULL,'2026-01-31 09:12:34',NULL,NULL),(466,NULL,'7db363281a8a4be7854dc58be863830f',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:12:35',NULL,'2026-01-31 09:12:35',NULL,NULL),(467,NULL,'c0be57039fd34aa9a2d05d9086ccff13',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:12:39',NULL,'2026-01-31 09:12:39',NULL,NULL),(468,NULL,NULL,'ebd43008d7a64b8bbf97a2304b1f78b6',NULL,NULL,NULL,NULL,'2026-01-31 09:13:50',NULL,'2026-01-31 09:13:50',NULL,NULL),(469,NULL,NULL,'47dc950da7924a109657b08e4b8b55b7',NULL,NULL,NULL,NULL,'2026-01-31 09:13:50',NULL,'2026-01-31 09:13:50',NULL,NULL),(470,NULL,NULL,'4e1071e8c366412e814324b2be6d17e5',NULL,NULL,NULL,NULL,'2026-01-31 09:13:50',NULL,'2026-01-31 09:13:50',NULL,NULL),(471,NULL,'4d103de0dcec4f3f8bc7f8b3bec01a34',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:13:53',NULL,'2026-01-31 09:13:53',NULL,NULL),(472,NULL,'4eb2e4e553214eaa8aea5a04e2a8b925',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:13:55',NULL,'2026-01-31 09:13:55',NULL,NULL),(473,NULL,'0c7930b92fc3471f87d9fe78ee56e71e',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:13:58',NULL,'2026-01-31 09:13:58',NULL,NULL),(474,NULL,NULL,'da3c9cc3dae946679d48679d183c0fc7',NULL,NULL,NULL,NULL,'2026-01-31 09:16:08',NULL,'2026-01-31 09:16:08',NULL,NULL),(475,NULL,NULL,'e6c18a62f8054a3fb1b9fe9960823490',NULL,NULL,NULL,NULL,'2026-01-31 09:16:08',NULL,'2026-01-31 09:16:08',NULL,NULL),(476,NULL,'afb6def7f4644d408d679d186607330d',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:16:09',NULL,'2026-01-31 09:16:09',NULL,NULL),(477,NULL,'be71ed72a4a048229c95e8ebbcc2d527',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:16:11',NULL,'2026-01-31 09:16:11',NULL,NULL),(478,NULL,NULL,'4f25568607234a398bc35cbb67eb406f',NULL,NULL,NULL,NULL,'2026-01-31 09:19:10',NULL,'2026-01-31 09:19:10',NULL,NULL),(479,NULL,NULL,'6f2df71d6246468d92b28350c0f26cef',NULL,NULL,NULL,NULL,'2026-01-31 09:19:10',NULL,'2026-01-31 09:19:10',NULL,NULL),(480,NULL,'390709b3e5174dc4afdc6b04fdae67e3',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:19:12',NULL,'2026-01-31 09:19:12',NULL,NULL),(481,NULL,'70a837f85bbc4d048c19b59a3ac0c4d2',NULL,NULL,NULL,NULL,NULL,'2026-01-31 09:19:14',NULL,'2026-01-31 09:19:14',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('2134871004ec4b26904b383c322a2b98','swiftoperator','{}','<<null>>',NULL),('39a15a7e0ebb47f2a5950a25ddafa71b','member','{}','<<null>>',NULL),('3a888fb271974f14b401434b2b0df6dd','ResellerAdmin','{}','<<null>>',NULL),('70ad65214ee1420c8460157bb2436cb2','admin','{}','<<null>>',NULL),('bf61c4f9a3934cdc80e13a91cd28faf8','service','{}','<<null>>',NULL),('c244b714c79b40ab84a78edfde726094','reader','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('39a15a7e0ebb47f2a5950a25ddafa71b','IMMU','true'),('70ad65214ee1420c8460157bb2436cb2','IMMU','true'),('c244b714c79b40ab84a78edfde726094','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('09d81b3e45d64d5ea641c8ff364f357f','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('19fcf0e1e45a4860a8dc8dac498938d5','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('21e626d2baf84246892ef04d903a9433','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('7ca2768819be45cf8fb9b27de50d0142','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('aa17c9ce3a00476eb334700815f72946','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('b85577cdbf374eb4986621abe822ced7','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('d9bb228504a949fc806d7b505ec24d2b','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('e9889c59d9ff44caa8737eeb80a18cb3','identity',1,'{\"name\": \"keystone\"}'),('f7e534cd4bcd45c19d14780f8b3c9ef7','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','94836483675641d9846c5768c3b91eed','system','70ad65214ee1420c8460157bb2436cb2',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0fd227e5eb914b38913f4b820440a0f4','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:23:39',NULL,'default'),('1c46f75898f04dc69571e7e1edb2426e','{\"tenantId\": \"449ee517cd164855a4735fdb66c78488\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-31 07:43:30',NULL,'default'),('3a2db34c566140b18fc5d0e7df30ac08','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:05:22','2026-01-31','default'),('89c9e86efe094b728b1685c8888cf0ef','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:05:31','2026-01-31','default'),('8fc1d2951eff4fa99fcd5cea6fb616dc','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:05:00','2026-01-31','default'),('94836483675641d9846c5768c3b91eed','{}',1,NULL,'2026-01-31 07:03:23','2026-01-31','default'),('9ec13114bad64754bf2a77073de5e283','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:05:03','2026-01-31','default'),('a6c21815d0ba4a709d7167306e85483f','{\"tenantId\": \"f9043b2bd33144e6884cd2ee092d45f1\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-31 07:43:28',NULL,'default'),('ec8086da066b421c98595b09183028d8','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:05:14','2026-01-31','default'),('ef86a0e6a6684d7181beb07880022b46','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:04:56','2026-01-31','default'),('fe07f3865a614b72984f087353419503','{}',1,'cb417a6cb57d4693a4fbcf628ac13cdc','2026-01-31 07:06:33','2026-01-31','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_cd7a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_1c33','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_2fb2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_cd7a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_1c33','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_2fb2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_56c1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_56c1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_f9f1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_f9f1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_e299','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_e299','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_a073','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_a073','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_8b96','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_8b96','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1769842962}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1769842962}'),('localhost','keystone_cd7a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D421BBFB9B43D860ADFC9C64C8B4B58CA6586C89\",\"password_last_changed\":1769842946}'),('localhost','placement_1c33','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BCAC7D03FE5E447C473EEBE8744340EF66C2396A\",\"password_last_changed\":1769842946}'),('localhost','glance_2fb2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*91CA2626665254FEAA5A428976FAAA1EA9791A53\",\"password_last_changed\":1769842946}'),('%','keystone_cd7a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D421BBFB9B43D860ADFC9C64C8B4B58CA6586C89\",\"password_last_changed\":1769842946}'),('%','placement_1c33','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*BCAC7D03FE5E447C473EEBE8744340EF66C2396A\",\"password_last_changed\":1769842946}'),('%','glance_2fb2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*91CA2626665254FEAA5A428976FAAA1EA9791A53\",\"password_last_changed\":1769842946}'),('localhost','cinder_56c1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D4681CBC06F3A1542091197020EAB5E2984C59C1\",\"password_last_changed\":1769842962}'),('%','cinder_56c1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*D4681CBC06F3A1542091197020EAB5E2984C59C1\",\"password_last_changed\":1769842962}'),('localhost','neutron_f9f1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B8AFB7BEDEE49EA08CAEF637D676744D881F4557\",\"password_last_changed\":1769842962}'),('%','neutron_f9f1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B8AFB7BEDEE49EA08CAEF637D676744D881F4557\",\"password_last_changed\":1769842962}'),('localhost','barbican_e299','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*66561F924385B3543BB08605D6B45665ADE0AA63\",\"password_last_changed\":1769842962}'),('%','barbican_e299','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*66561F924385B3543BB08605D6B45665ADE0AA63\",\"password_last_changed\":1769842962}'),('localhost','nova_api_a073','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*921EBFD56FE861FC9AA9EEA057FC6C932C6B170E\",\"password_last_changed\":1769843121}'),('%','nova_api_a073','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*921EBFD56FE861FC9AA9EEA057FC6C932C6B170E\",\"password_last_changed\":1769843121}'),('localhost','nova_cell0_8b96','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19B1A0B89DD3A8C42C308A9F1254B8E962CF9F41\",\"password_last_changed\":1769843123}'),('%','nova_cell0_8b96','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*19B1A0B89DD3A8C42C308A9F1254B8E962CF9F41\",\"password_last_changed\":1769843124}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/'),(145,'ST_POINTN',13,'Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/'),(146,'ST_STARTPOINT',13,'Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/'),(150,'INET_ATON',14,'Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/'),(151,'INET_NTOA',14,'Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/'),(98,'SAVEPOINT',8,'Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/'),(99,'Metadata Locking',8,'MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/'),(100,'Transaction Timeouts',8,'MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/'),(152,'IS_FREE_LOCK',14,'Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/'),(156,'IS_IPV6',14,'Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/'),(157,'IS_USED_LOCK',14,'Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/'),(102,'WAIT and NOWAIT',8,'MariaDB starting with 10.3.0\n-------