/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('19ffd816-f2be-475f-a80a-452c877fe25d','2026-01-20 13:22:16','2026-01-20 13:22:16',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2026-01-20 13:50:28','2026-01-20 13:50:39','2026-01-20 13:50:39',1,'aes-cbc-essiv','front-end',256,'nova.volume.encryptors.luks.LuksEncryptor','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','cb07f10d-92ba-4843-a62e-fac8fdd3d443');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','0af08f0d-46ce-463a-ae05-a00ff9278e71','2026-01-20 13:22:03','2026-01-20 13:22:03',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('0af08f0d-46ce-463a-ae05-a00ff9278e71','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2026-01-20 13:22:03','2026-01-20 13:22:03',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2026-01-20 13:22:00',NULL,NULL,0,1,'default','volumes',10),('2026-01-20 13:22:00',NULL,NULL,0,2,'default','snapshots',10),('2026-01-20 13:22:00',NULL,NULL,0,3,'default','gigabytes',1000),('2026-01-20 13:22:00',NULL,NULL,0,4,'default','consistencygroups',10),('2026-01-20 13:22:00',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2026-01-20 13:22:00',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2026-01-20 13:22:13','2026-01-20 14:19:15',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',338,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'eebdfb20-5ae5-4731-8e60-26d698eee79f');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2026-01-20 13:50:28',NULL,'2026-01-20 13:50:39',1,'2682a6a4-78e2-43fa-8e60-3da97d4f29eb','LUKS',NULL,1,NULL),('2026-01-20 13:22:03','2026-01-20 13:22:03',NULL,0,'4eca19be-0627-4a9f-a9d0-0fb8a397cee4','__DEFAULT__',NULL,1,'Default Volume Type');
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2026-01-20 13:22:03','2026-01-20 13:22:03.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34','2026-01-20 13:49:41','2026-01-20 13:49:41',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'58900fd9-e9d7-4a4f-b861-e2e0fbfeb94c','swift+https://service%3Aglance:12345678@keystone-internal.openstack.svc:5000/glance/58900fd9-e9d7-4a4f-b861-e2e0fbfeb94c','2026-01-20 13:49:43','2026-01-20 13:49:43',NULL,0,'{\"store\": \"default_backend\"}','active');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34','hw_rng_model','virtio','2026-01-20 13:49:40','2026-01-20 13:49:40',NULL,0),(2,'58900fd9-e9d7-4a4f-b861-e2e0fbfeb94c','hw_rng_model','virtio','2026-01-20 13:49:42','2026-01-20 13:49:42',NULL,0);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('58900fd9-e9d7-4a4f-b861-e2e0fbfeb94c','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2026-01-20 13:49:42','2026-01-20 13:49:43',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','2ad51e96726a496fbbce4a0ed4cf0061',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34','cirros-0.6.2-x86_64-disk.img',21430272,'active','2026-01-20 13:49:40','2026-01-20 13:49:41',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','2ad51e96726a496fbbce4a0ed4cf0061',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b');
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2026-01-20 13:21:03',NULL),(1,2,'image','CIM_RASD_','2026-01-20 13:21:03',NULL),(1,3,NULL,'CIM_SASD_','2026-01-20 13:21:03',NULL),(1,9,'image','hw_','2026-01-20 13:21:05',NULL),(1,10,'image','hw_','2026-01-20 13:21:05',NULL),(1,14,'image',NULL,'2026-01-20 13:21:05',NULL),(1,19,'image','hw_','2026-01-20 13:21:05',NULL),(1,25,'image','hw_','2026-01-20 13:21:05',NULL),(1,29,'image',NULL,'2026-01-20 13:21:05',NULL),(1,30,'image',NULL,'2026-01-20 13:21:06',NULL),(1,31,'image',NULL,'2026-01-20 13:21:06',NULL),(1,32,'image',NULL,'2026-01-20 13:21:06',NULL),(2,1,NULL,'CIM_PASD_','2026-01-20 13:21:03',NULL),(2,8,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,9,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,10,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,11,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,13,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,14,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,15,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,16,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,19,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,22,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,23,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,24,NULL,'traits:','2026-01-20 13:21:05',NULL),(2,25,NULL,'hw_','2026-01-20 13:21:05',NULL),(2,26,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,28,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,29,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,30,NULL,NULL,'2026-01-20 13:21:05',NULL),(2,31,NULL,NULL,'2026-01-20 13:21:06',NULL),(2,32,NULL,NULL,'2026-01-20 13:21:06',NULL),(2,33,NULL,'cinder_','2026-01-20 13:21:06',NULL),(3,1,NULL,'CIM_PASD_','2026-01-20 13:21:03',NULL),(3,2,NULL,'CIM_RASD_','2026-01-20 13:21:03',NULL),(3,3,NULL,'CIM_SASD_','2026-01-20 13:21:03',NULL),(3,4,NULL,'CIM_VSSD_','2026-01-20 13:21:04',NULL),(3,5,NULL,NULL,'2026-01-20 13:21:04',NULL),(3,6,NULL,NULL,'2026-01-20 13:21:05',NULL),(3,7,NULL,NULL,'2026-01-20 13:21:05',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2026-01-20 13:21:05',NULL),(4,1,NULL,'CIM_PASD_','2026-01-20 13:21:03',NULL),(4,2,NULL,'CIM_RASD_','2026-01-20 13:21:03',NULL),(4,3,NULL,'CIM_SASD_','2026-01-20 13:21:03',NULL),(4,4,NULL,'CIM_VSSD_','2026-01-20 13:21:04',NULL),(4,8,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,9,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,10,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,12,NULL,'capabilities:','2026-01-20 13:21:05',NULL),(4,16,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,17,NULL,NULL,'2026-01-20 13:21:05',NULL),(4,18,NULL,NULL,'2026-01-20 13:21:05',NULL),(4,19,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,20,NULL,NULL,'2026-01-20 13:21:05',NULL),(4,21,NULL,NULL,'2026-01-20 13:21:05',NULL),(4,23,NULL,'hw:','2026-01-20 13:21:05',NULL),(4,24,NULL,'traits:','2026-01-20 13:21:05',NULL),(4,25,NULL,'hw:','2026-01-20 13:21:05',NULL),(5,1,'scheduler_hints',NULL,'2026-01-20 13:21:03',NULL),(5,30,'metadata',NULL,'2026-01-20 13:21:06',NULL),(5,31,'metadata',NULL,'2026-01-20 13:21:06',NULL),(5,32,'metadata',NULL,'2026-01-20 13:21:06',NULL),(6,30,NULL,NULL,'2026-01-20 13:21:06',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2026-01-20 13:21:03',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2026-01-20 13:21:03',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2026-01-20 13:21:03',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2026-01-20 13:21:04',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-20 13:21:04',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2026-01-20 13:21:04',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2026-01-20 13:21:05',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2026-01-20 13:21:05',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2026-01-20 13:21:05',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2026-01-20 13:21:05',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2026-01-20 13:21:05',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2026-01-20 13:21:05',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2026-01-20 13:21:05',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2026-01-20 13:21:05',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:21:05',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:21:05',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:21:05',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2026-01-20 13:21:05',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2026-01-20 13:21:05',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:21:05',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:21:05',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:21:05',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2026-01-20 13:21:05',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2026-01-20 13:21:05',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2026-01-20 13:21:05',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2026-01-20 13:21:05',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2026-01-20 13:21:05',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2026-01-20 13:21:05',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2026-01-20 13:21:05',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2026-01-20 13:21:05',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2026-01-20 13:21:06',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2026-01-20 13:21:06',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2026-01-20 13:21:06',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2026-01-20 13:21:05',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2026-01-20 13:21:05',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2026-01-20 13:21:05',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2026-01-20 13:21:06',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2026-01-20 13:21:06',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2026-01-20 13:21:06',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2026-01-20 13:21:06',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-20 13:21:06',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2026-01-20 13:21:06',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2026-01-20 13:21:06',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2026-01-20 13:21:06',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2026-01-20 13:21:06',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:21:06',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:21:06',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2026-01-20 13:21:06',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2026-01-20 13:21:03',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2026-01-20 13:21:03',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2026-01-20 13:21:03',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2026-01-20 13:21:03',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2026-01-20 13:21:03',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-20 13:21:03',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2026-01-20 13:21:03',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2026-01-20 13:21:03',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2026-01-20 13:21:03',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2026-01-20 13:21:03',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2026-01-20 13:21:03',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2026-01-20 13:21:03',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2026-01-20 13:21:04',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2026-01-20 13:21:04',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2026-01-20 13:21:04',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2026-01-20 13:21:04',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2026-01-20 13:21:04',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2026-01-20 13:21:05',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2026-01-20 13:21:05',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2026-01-20 13:21:05',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2026-01-20 13:21:05',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2026-01-20 13:21:05',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:21:05',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2026-01-20 13:21:05',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2026-01-20 13:21:05',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2026-01-20 13:21:05',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:21:05',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:21:05',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2026-01-20 13:21:05',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2026-01-20 13:21:05',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2026-01-20 13:21:05',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2026-01-20 13:21:05',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2026-01-20 13:21:05',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:21:05',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-20 13:21:05',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2026-01-20 13:21:05',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2026-01-20 13:21:05',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2026-01-20 13:21:05',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2026-01-20 13:21:05',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2026-01-20 13:21:05',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:21:05',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2026-01-20 13:21:05',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2026-01-20 13:21:05',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:21:05',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:21:05',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:21:05',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2026-01-20 13:21:05',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2026-01-20 13:21:05',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:21:05',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:21:05',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:21:05',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2026-01-20 13:21:05',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2026-01-20 13:21:05',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2026-01-20 13:21:05',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:21:05',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2026-01-20 13:21:05',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2026-01-20 13:21:05',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2026-01-20 13:21:05',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2026-01-20 13:21:05',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2026-01-20 13:21:05',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2026-01-20 13:21:05',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2026-01-20 13:21:05',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2026-01-20 13:21:05',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-20 13:21:05',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2026-01-20 13:21:05',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2026-01-20 13:21:05',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2026-01-20 13:21:05',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2026-01-20 13:21:05',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2026-01-20 13:21:05',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2026-01-20 13:21:05',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2026-01-20 13:21:05',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2026-01-20 13:21:05',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2026-01-20 13:21:05',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2026-01-20 13:21:05',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2026-01-20 13:21:06',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2026-01-20 13:21:03',NULL),(2,'OS::Glance::Image',1,'2026-01-20 13:21:03',NULL),(3,'OS::Nova::Aggregate',1,'2026-01-20 13:21:03',NULL),(4,'OS::Nova::Flavor',1,'2026-01-20 13:21:03',NULL),(5,'OS::Nova::Server',1,'2026-01-20 13:21:03',NULL),(6,'OS::Trove::Instance',1,'2026-01-20 13:21:06',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1524 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
INSERT INTO `event` (`id`, `uuid`, `stack_id`, `created_at`, `updated_at`, `resource_action`, `resource_status`, `resource_name`, `physical_resource_id`, `resource_status_reason`, `resource_type`, `resource_properties`, `rsrc_prop_data_id`) VALUES (1,'85c10191-5e31-4b6d-983e-398ee0bd40f2','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','api-1445742041-envstack','f1fe6a09-5314-4193-bfa5-d443356dc3d3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(2,'b33e6751-c087-429f-9676-dc7192ffdec0','87a46c98-cc95-42ca-9a1e-9a12087c387b','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','api-442217991-envstack','87a46c98-cc95-42ca-9a1e-9a12087c387b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(3,'dc3373e1-0ed1-4fa7-ae52-c9e1aa7369bb','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','test','api-1445742041-envstack-test-g7pqc5fz2nu4','state changed','OS::Heat::TestResource',NULL,1),(4,'e862ed94-c342-4865-a9e2-4fdd83d33563','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','test','api-1445742041-envstack-test-g7pqc5fz2nu4','state changed','OS::Heat::TestResource',NULL,1),(5,'d46fe8e1-1898-4b80-bb0b-080f9c8748fb','87a46c98-cc95-42ca-9a1e-9a12087c387b','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','test','api-442217991-envstack-test-4vgolau3igcb','state changed','OS::Heat::TestResource',NULL,2),(6,'43ec5fe0-779a-4df3-b9de-46b45de3e0f5','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','api-1445742041-envstack','f1fe6a09-5314-4193-bfa5-d443356dc3d3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(7,'f1e9747d-d0e0-4d30-ab30-8b57ed4a1ab5','bb9e894c-a1b7-49ce-82a9-0a593c58c737','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','api-108285926-envstack','bb9e894c-a1b7-49ce-82a9-0a593c58c737','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(8,'adac3a2e-608f-4fab-9aad-32c5ed9ad9fc','87a46c98-cc95-42ca-9a1e-9a12087c387b','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','test','api-442217991-envstack-test-4vgolau3igcb','state changed','OS::Heat::TestResource',NULL,2),(9,'75314475-b2e3-4d79-8889-7f78bfbdb4f6','87a46c98-cc95-42ca-9a1e-9a12087c387b','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','api-442217991-envstack','87a46c98-cc95-42ca-9a1e-9a12087c387b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(10,'01603446-22b1-4069-9925-21792483faed','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','api-1214827273-rsrcstack','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(11,'474dab85-5e3a-4d07-b201-25aea2183613','bb9e894c-a1b7-49ce-82a9-0a593c58c737','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','test','api-108285926-envstack-test-xi4iirw6yz53','state changed','OS::Heat::TestResource',NULL,3),(12,'5859b46b-8cf3-4947-a546-c8be7310e74e','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:05',NULL,'CREATE','IN_PROGRESS','test','api-1214827273-rsrcstack-test-663ywabt5kv7','state changed','OS::Heat::TestResource',NULL,4),(13,'fa2e1bdb-a12b-491d-baab-a8582f9e42e9','bb9e894c-a1b7-49ce-82a9-0a593c58c737','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','test','api-108285926-envstack-test-xi4iirw6yz53','state changed','OS::Heat::TestResource',NULL,3),(14,'5341161b-3da5-4595-87d1-15da3f75c41d','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','test','api-1214827273-rsrcstack-test-663ywabt5kv7','state changed','OS::Heat::TestResource',NULL,4),(15,'82d4880c-c4f0-46ad-99d1-0faaeca549cd','bb9e894c-a1b7-49ce-82a9-0a593c58c737','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','api-108285926-envstack','bb9e894c-a1b7-49ce-82a9-0a593c58c737','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(16,'d3f7c0e8-efd1-4676-88b4-4e088125a1f0','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','api-1214827273-rsrcstack','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(17,'e26cea12-5031-4ac0-9332-e9484dbf29f3','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:07',NULL,'DELETE','IN_PROGRESS','api-1445742041-envstack','f1fe6a09-5314-4193-bfa5-d443356dc3d3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(18,'140213bf-1691-41e6-94c3-9f60d5a7b2ad','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:07',NULL,'DELETE','IN_PROGRESS','test','api-1445742041-envstack-test-g7pqc5fz2nu4','state changed','OS::Heat::TestResource',NULL,1),(19,'bcabc238-c7bb-4474-930f-f83f8774d79c','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:07',NULL,'DELETE','COMPLETE','test','api-1445742041-envstack-test-g7pqc5fz2nu4','state changed','OS::Heat::TestResource',NULL,1),(20,'804ca755-79d6-42b3-8dad-a080e12e0fcf','f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:07',NULL,'DELETE','COMPLETE','api-1445742041-envstack','f1fe6a09-5314-4193-bfa5-d443356dc3d3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(21,'8649abff-3573-4f48-b711-89f58e84bbd4','b140e17f-aa70-41c5-a917-02c242d68958','2026-01-20 13:50:08',NULL,'CREATE','IN_PROGRESS','api-108285926-rsrcstack','b140e17f-aa70-41c5-a917-02c242d68958','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(22,'8e793f60-a16a-404f-9944-30a0202c2890','b140e17f-aa70-41c5-a917-02c242d68958','2026-01-20 13:50:08',NULL,'CREATE','IN_PROGRESS','test','api-108285926-rsrcstack-test-5fz3h7bwgvaw','state changed','OS::Heat::TestResource',NULL,5),(23,'3b4da150-693d-450a-8985-482b647af924','b140e17f-aa70-41c5-a917-02c242d68958','2026-01-20 13:50:08',NULL,'CREATE','COMPLETE','test','api-108285926-rsrcstack-test-5fz3h7bwgvaw','state changed','OS::Heat::TestResource',NULL,5),(24,'13f20979-b28f-4c28-9bb7-99b443f86018','b140e17f-aa70-41c5-a917-02c242d68958','2026-01-20 13:50:08',NULL,'CREATE','COMPLETE','api-108285926-rsrcstack','b140e17f-aa70-41c5-a917-02c242d68958','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(25,'28ce5a22-da95-4964-84d2-ed11b107c817','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:08',NULL,'CHECK','FAILED','test','api-1214827273-rsrcstack-test-663ywabt5kv7','resource deleted','OS::Heat::TestResource',NULL,4),(26,'b6bc5c25-d07d-4557-98be-8e7e82f986a8','a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:08',NULL,'CREATE','IN_PROGRESS','api-442217991-rsrcstack','a02006a6-cff0-49dc-be8f-81748ec3e4e0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(27,'aca7294b-3b3c-4f47-8c64-0c32b951ef9e','a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:08',NULL,'CREATE','IN_PROGRESS','test','api-442217991-rsrcstack-test-wkmxffgt76dp','state changed','OS::Heat::TestResource',NULL,6),(28,'46e70682-20f4-46d7-a61b-82cc0609a6f4','a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:08',NULL,'CREATE','COMPLETE','test','api-442217991-rsrcstack-test-wkmxffgt76dp','state changed','OS::Heat::TestResource',NULL,6),(29,'0b5e75d4-b972-4e66-b1af-25f335cf73c4','a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:08',NULL,'CREATE','COMPLETE','api-442217991-rsrcstack','a02006a6-cff0-49dc-be8f-81748ec3e4e0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(30,'b269e7b5-5807-4fee-b920-aa48e2b33474','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:09',NULL,'CREATE','IN_PROGRESS','api-1445742041-rsrcstack','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(31,'58b33304-e249-4a4b-861b-082d242bd4f1','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:09',NULL,'CREATE','IN_PROGRESS','test','api-1445742041-rsrcstack-test-ahvhbb4evidn','state changed','OS::Heat::TestResource',NULL,7),(32,'36925a60-5336-4114-b09e-a0afec9d760e','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:09',NULL,'CREATE','COMPLETE','test','api-1445742041-rsrcstack-test-ahvhbb4evidn','state changed','OS::Heat::TestResource',NULL,7),(33,'2f78680c-f6ea-428d-97d8-0c3c9cacbc1b','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:09',NULL,'CREATE','COMPLETE','api-1445742041-rsrcstack','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(34,'75b47167-f2d3-4d80-99eb-8c1932f0a287','a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:09',NULL,'CHECK','FAILED','test','api-442217991-rsrcstack-test-wkmxffgt76dp','resource deleted','OS::Heat::TestResource',NULL,6),(35,'1582147a-b39b-4cde-9f65-3e7fbda30934','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:12',NULL,'CHECK','FAILED','test','api-1445742041-rsrcstack-test-ahvhbb4evidn','resource deleted','OS::Heat::TestResource',NULL,7),(36,'cf5a4026-f6e9-40d4-a750-1a44488a16db','d65e0219-2aeb-4432-8186-72c5a4420429','2026-01-20 13:50:13',NULL,'CREATE','IN_PROGRESS','api-108285926-empty','d65e0219-2aeb-4432-8186-72c5a4420429','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(37,'008d00d6-a419-48ea-a6f9-c755ddd8447e','d65e0219-2aeb-4432-8186-72c5a4420429','2026-01-20 13:50:13',NULL,'CREATE','COMPLETE','api-108285926-empty','d65e0219-2aeb-4432-8186-72c5a4420429','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(38,'2019f63a-116f-433f-80a4-0914d179dd30','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:13',NULL,'DELETE','IN_PROGRESS','api-1445742041-rsrcstack','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(39,'6ac0ed98-de3a-4205-b5b2-53b1e0b868d5','d65e0219-2aeb-4432-8186-72c5a4420429','2026-01-20 13:50:13',NULL,'DELETE','IN_PROGRESS','api-108285926-empty','d65e0219-2aeb-4432-8186-72c5a4420429','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(40,'0b651979-64bc-4e81-a4ff-4a76a3cfc9bd','d65e0219-2aeb-4432-8186-72c5a4420429','2026-01-20 13:50:13',NULL,'DELETE','COMPLETE','api-108285926-empty','d65e0219-2aeb-4432-8186-72c5a4420429','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(41,'6631cdb1-f15c-4edd-83df-81355cda728f','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:13',NULL,'DELETE','IN_PROGRESS','test','api-1445742041-rsrcstack-test-ahvhbb4evidn','state changed','OS::Heat::TestResource',NULL,7),(42,'7c256d44-aa2d-48ec-9ee4-caa0b49e2141','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:13',NULL,'DELETE','COMPLETE','test','api-1445742041-rsrcstack-test-ahvhbb4evidn','state changed','OS::Heat::TestResource',NULL,7),(43,'4bd8e2f1-d12e-411d-a412-63686e945457','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:13',NULL,'DELETE','COMPLETE','api-1445742041-rsrcstack','30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(44,'fadcf59e-1a96-449a-9736-0044237d8fde','67bccff8-94b7-41ac-95be-3c3ca4a709ca','2026-01-20 13:50:13',NULL,'CREATE','IN_PROGRESS','api-1214827273-empty','67bccff8-94b7-41ac-95be-3c3ca4a709ca','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(45,'3cbc5c6b-6f34-424b-b5c0-1ecdda90a8ce','67bccff8-94b7-41ac-95be-3c3ca4a709ca','2026-01-20 13:50:13',NULL,'CREATE','COMPLETE','api-1214827273-empty','67bccff8-94b7-41ac-95be-3c3ca4a709ca','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(46,'c85f974c-5ca2-4188-9943-5d9398321691','67bccff8-94b7-41ac-95be-3c3ca4a709ca','2026-01-20 13:50:14',NULL,'DELETE','IN_PROGRESS','api-1214827273-empty','67bccff8-94b7-41ac-95be-3c3ca4a709ca','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(47,'1d6b1531-7c05-481c-974e-efaabdf65959','67bccff8-94b7-41ac-95be-3c3ca4a709ca','2026-01-20 13:50:14',NULL,'DELETE','COMPLETE','api-1214827273-empty','67bccff8-94b7-41ac-95be-3c3ca4a709ca','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(48,'fb5cbb38-e95e-444b-a82e-699d8807c2b8','231ae6d8-25bf-41b0-b034-91ef9413e0a7','2026-01-20 13:50:14',NULL,'CREATE','IN_PROGRESS','api-442217991-empty','231ae6d8-25bf-41b0-b034-91ef9413e0a7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(49,'d419bf73-2f7b-4298-97ba-31dc80cd3735','231ae6d8-25bf-41b0-b034-91ef9413e0a7','2026-01-20 13:50:14',NULL,'CREATE','COMPLETE','api-442217991-empty','231ae6d8-25bf-41b0-b034-91ef9413e0a7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(50,'d3224b06-07a7-4f7c-bdc3-1e9b8aca152d','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:14',NULL,'CREATE','IN_PROGRESS','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(51,'16ae5bca-7792-45b7-b0f1-80e3492120fc','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:14',NULL,'CREATE','IN_PROGRESS','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,8),(52,'0ec09a3d-98f6-4929-9fa5-5e4f7a151eee','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:14',NULL,'CREATE','COMPLETE','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,8),(53,'e70ea3e8-a390-48c4-b4e2-b43b9eee3f0b','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:15',NULL,'CREATE','COMPLETE','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(54,'1e3e05c1-47ae-4fc5-a7a9-0860994edeaf','231ae6d8-25bf-41b0-b034-91ef9413e0a7','2026-01-20 13:50:15',NULL,'DELETE','IN_PROGRESS','api-442217991-empty','231ae6d8-25bf-41b0-b034-91ef9413e0a7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(55,'cb2baa48-a1a3-4c86-9dbb-81b3078570dc','231ae6d8-25bf-41b0-b034-91ef9413e0a7','2026-01-20 13:50:15',NULL,'DELETE','COMPLETE','api-442217991-empty','231ae6d8-25bf-41b0-b034-91ef9413e0a7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(56,'1e5c3ebf-4d31-4745-8733-d7df19616c57','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:15',NULL,'CREATE','IN_PROGRESS','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(57,'f6e56487-9cbf-4568-a92b-5d1ea698bcde','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:15',NULL,'CREATE','IN_PROGRESS','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,9),(58,'89d0dd9c-c418-4f5a-b83f-711ef326451c','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:15',NULL,'CREATE','COMPLETE','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,9),(59,'b53851ee-ca0c-43d2-b5a7-3bfaf84303fd','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:15',NULL,'CREATE','COMPLETE','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(60,'e6242e43-1d97-4b46-856f-eebdbf61fea2','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:16',NULL,'UPDATE','IN_PROGRESS','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(61,'d7c0ca49-3cc1-4181-b351-fdc916b28b31','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:16',NULL,'UPDATE','IN_PROGRESS','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,8),(62,'7ff1faeb-709f-4ecd-92b0-45526924e9e1','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:16',NULL,'CREATE','IN_PROGRESS','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(63,'8a64e55c-8111-449b-b148-2d623a48db92','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:16',NULL,'CREATE','IN_PROGRESS','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,10),(64,'bae4e625-ab1f-4094-97f5-d4357c064047','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:16',NULL,'CREATE','COMPLETE','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,10),(65,'7790fd3c-e29a-45c6-84e0-7dde58f75329','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:16',NULL,'CREATE','COMPLETE','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(66,'fa14d499-6f10-486e-980e-02d4c1bdbff0','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:16',NULL,'UPDATE','IN_PROGRESS','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(67,'aaa1a2ce-23b9-4dfc-93cc-e1472414e3be','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:16',NULL,'UPDATE','IN_PROGRESS','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,9),(68,'536b22ba-4bd6-4850-8ae8-c39bd13b1c03','5af846ba-164e-43db-8a12-1b42def99db1','2026-01-20 13:50:17',NULL,'CREATE','IN_PROGRESS','api-1445742041-empty','5af846ba-164e-43db-8a12-1b42def99db1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(69,'485a0d57-fedf-4fa4-ac0d-48c8b25a2914','5af846ba-164e-43db-8a12-1b42def99db1','2026-01-20 13:50:17',NULL,'CREATE','COMPLETE','api-1445742041-empty','5af846ba-164e-43db-8a12-1b42def99db1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(70,'3a0da7bc-8b82-4b49-b655-66357df06dd0','5af846ba-164e-43db-8a12-1b42def99db1','2026-01-20 13:50:17',NULL,'DELETE','IN_PROGRESS','api-1445742041-empty','5af846ba-164e-43db-8a12-1b42def99db1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(71,'fa9aadcc-597f-440e-bad8-92a808b55b9b','5af846ba-164e-43db-8a12-1b42def99db1','2026-01-20 13:50:17',NULL,'DELETE','COMPLETE','api-1445742041-empty','5af846ba-164e-43db-8a12-1b42def99db1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(72,'f5b88e56-5142-416b-9847-d0c9c44b74a4','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:18',NULL,'UPDATE','COMPLETE','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,11),(73,'7b5ac3e9-62fa-432b-99fc-9cb11dcefd51','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:18',NULL,'CREATE','IN_PROGRESS','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(74,'5f5a79a5-aa51-4aa2-9f24-91fa5c386f4e','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:18',NULL,'UPDATE','COMPLETE','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(75,'6ab02907-2dd3-4764-b01a-489e733c2be7','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:18',NULL,'CREATE','IN_PROGRESS','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,12),(76,'d79021c3-ba88-4b1f-b7e0-6fca9e046995','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:18',NULL,'CREATE','COMPLETE','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,12),(77,'7c023f34-d9b6-45e1-81df-768808d5693a','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:18',NULL,'CREATE','COMPLETE','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(78,'1c2d7691-4974-4b4d-b2fe-b3e2afaddf46','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:18',NULL,'UPDATE','COMPLETE','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,13),(79,'9e4ffc96-ee17-44fe-9218-7a2061b68e56','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:18',NULL,'UPDATE','COMPLETE','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(80,'12b46605-38aa-4a35-9740-c859a2acda29','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(81,'19b17d4f-4bfe-479b-8867-5ca92b7fe3f6','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(82,'c08fed0c-c908-43c2-8370-72cd02676a21','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(83,'fbc8f7cf-049c-4794-9395-d01b5324fe11','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,11),(84,'917a19ea-efd9-4d49-8a04-a4325017eb4f','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,10),(85,'99554228-752d-4555-b5d8-e120e2104b34','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,13),(86,'544ffdf2-f7ee-4b32-8169-2e0e3a40b4c5','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(87,'41f753a0-31fe-45e9-806f-2aa23acd023c','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:19',NULL,'UPDATE','IN_PROGRESS','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,12),(88,'42ccb5cb-349f-4f57-be03-694c50e1caeb','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:21',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(89,'48847323-34a5-4403-8785-10f13f9da47a','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:21',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-1177326764-net-wy5ivb3kw4a3','state changed','OS::Neutron::Net',NULL,NULL),(90,'99f9efc5-adb4-40bd-bd87-73e80c12ee91','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','test','api-108285926-stack-test-5w4zfynxxbns','state changed','OS::Heat::TestResource',NULL,14),(91,'e06f8753-bdd3-45af-b481-3a35ae4f1fd7','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,15),(92,'e665ea86-8613-49a7-94c2-a826a5aa678a','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','test','api-1214827273-stack-test-f65w7bg4hkvl','state changed','OS::Heat::TestResource',NULL,16),(93,'cb42fca0-d5a1-4a33-8040-de6c49200982','62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','api-108285926-stack','62188458-aab9-4802-8579-c47bb0c683f3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(94,'471a1a89-79ba-4084-a1b2-5b1b8452667e','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','api-1214827273-stack','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(95,'c02d5f73-22d2-4c76-8c89-cfc237a4b826','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:21',NULL,'UPDATE','COMPLETE','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(96,'2d4210e1-4cd2-4ead-8f3b-00d589f8cfe6','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:22',NULL,'UPDATE','COMPLETE','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,17),(97,'d8c1e5bd-a12f-40dd-969a-896a0426afb0','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:22',NULL,'UPDATE','COMPLETE','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(98,'6c7cfbed-9b8c-4d78-a166-29eda20d5baf','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:22',NULL,'UPDATE','IN_PROGRESS','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(99,'589ddd26-27e1-4340-96df-e9e0e545ba9a','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:23',NULL,'UPDATE','IN_PROGRESS','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,17),(100,'33bed2f6-63ae-479e-9045-1be40a5ebe3f','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:23',NULL,'CREATE','COMPLETE','net','428a20ee-3476-451f-97bc-8bb2c787bc4c','state changed','OS::Neutron::Net',NULL,NULL),(101,'c3a1a444-3ef9-42ca-a2db-134b0603b7bb','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:23',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-1177326764-subnet-a3suehmp43l7','state changed','OS::Neutron::Subnet',NULL,18),(102,'2babf734-35b5-47b1-b997-ebed0fea6c4d','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:24',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(103,'f9a4bb7b-88ab-450c-a665-891befee9958','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:24',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-574386486-net-3lpusi372lcm','state changed','OS::Neutron::Net',NULL,NULL),(104,'55c5aa32-aee7-48cc-8a1f-1151dce7d584','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:25',NULL,'UPDATE','IN_PROGRESS','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(105,'652a4d04-51e6-4d23-ab64-02cbfcd56654','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:25',NULL,'CREATE','COMPLETE','subnet','a51f4258-8291-41ba-896e-b58fdd19c0b4','state changed','OS::Neutron::Subnet',NULL,18),(106,'307ea1d6-5b18-4ed9-8f07-c6f7191fd661','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:25',NULL,'UPDATE','IN_PROGRESS','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,15),(107,'6dc3cea0-dca8-4fe0-b819-b070511bd65d','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:25',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-1177326764-port-2tsn53ijglnu','state changed','OS::Neutron::Port',NULL,19),(108,'2ff2e2f9-64a0-4347-9418-22074ae59875','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:25',NULL,'UPDATE','COMPLETE','test','api-1445742041-stack-test-ccmomaeaylkd','state changed','OS::Heat::TestResource',NULL,20),(109,'2b4311f6-69e7-4635-8baa-ce2f22cf1f8c','9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:25',NULL,'UPDATE','COMPLETE','api-1445742041-stack','9fb2ea8b-a649-4533-966f-b6fcdab608c8','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(110,'753342c2-50f0-4611-9cab-452b1ab1c762','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:26',NULL,'CREATE','COMPLETE','net','20820931-bb2b-46b3-8ddb-340917102728','state changed','OS::Neutron::Net',NULL,NULL),(111,'4d962e5e-11fd-45a4-973b-eaf2380ad799','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:26',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-574386486-subnet-uoqnuizv3q2w','state changed','OS::Neutron::Subnet',NULL,21),(112,'e680fa4c-0b89-47b9-92e5-281ae223a82b','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:27',NULL,'CREATE','COMPLETE','port','040419ac-31ee-41a1-a090-da29d0523734','state changed','OS::Neutron::Port',NULL,19),(113,'b73cfb72-f376-470c-a249-b71598c9adcb','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:27',NULL,'UPDATE','COMPLETE','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,22),(114,'49ef11f9-3c42-4fb2-ae62-5a98ebc05f14','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:27',NULL,'UPDATE','COMPLETE','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(115,'76841254-631c-4820-8c7d-d4c43cbbcc97','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:27',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-1177326764-test-ac2nggs5yw4b','state changed','OS::Heat::TestResource',NULL,24),(116,'99f10bd9-1e74-4abe-ad6a-f3f7d9fa6d6e','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:27',NULL,'CREATE','COMPLETE','test','UpdatePortTest-1177326764-test-ac2nggs5yw4b','state changed','OS::Heat::TestResource',NULL,24),(117,'01478873-1afd-4c97-93e8-cb0e94bef0f1','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:27',NULL,'CREATE','COMPLETE','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(118,'74871418-86bd-4799-8862-170b456d0373','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:27',NULL,'CREATE','COMPLETE','subnet','3c795864-1e7d-4845-9287-fa0389bb80f2','state changed','OS::Neutron::Subnet',NULL,21),(119,'599f61ce-d60e-4740-85e7-3bda3fa2d4ce','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:28',NULL,'CREATE','COMPLETE','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(120,'f3a48bda-d5ec-4fe3-adf0-15ec18a3e168','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:28',NULL,'CREATE','IN_PROGRESS','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(121,'012e0489-dfa7-42d4-8c30-16886e87453c','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:28',NULL,'CREATE','IN_PROGRESS','my_volume_type','EncryptionVolTypeTest-1016197023-my_volume_type-szfttjlsfwpn','state changed','OS::Cinder::VolumeType',NULL,25),(122,'17282535-ad35-425d-bb9d-a9b80305f18f','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:28',NULL,'DELETE','IN_PROGRESS','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(123,'03391611-817d-4565-87be-5c396f687603','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:28',NULL,'DELETE','IN_PROGRESS','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,22),(124,'541a4f7c-0ed0-4bda-98e8-f22c3d99784c','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:28',NULL,'DELETE','COMPLETE','test','api-442217991-stack-test-cctum7z4gyxh','state changed','OS::Heat::TestResource',NULL,22),(125,'5017b9be-42c9-44d8-a152-6ee71380c33e','342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:28',NULL,'DELETE','COMPLETE','api-442217991-stack','342cc870-d390-45f3-b653-df8f6101a117','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(126,'7e9dd583-ed48-4a13-8009-6fbe88b4106b','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:28',NULL,'CREATE','COMPLETE','my_volume_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::VolumeType',NULL,25),(127,'349e47a8-1c61-42b0-b9fc-674b8143aa49','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:28',NULL,'CREATE','IN_PROGRESS','my_encrypted_vol_type','EncryptionVolTypeTest-1016197023-my_encrypted_vol_type-fhuwau7hzngb','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(128,'41130ac8-78e0-4e16-aa93-235f77832218','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:29',NULL,'CREATE','COMPLETE','my_encrypted_vol_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(129,'5698bb18-2b6b-4f27-89bf-70444dbfbb8a','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:29',NULL,'CREATE','COMPLETE','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(130,'b10562c5-2b21-4ee0-bd64-9372cec99585','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:30',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(131,'c38f8982-61f8-49b3-8acd-0802b663c3fc','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:30',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(132,'b286ada4-d43d-48d5-8b36-6f616da367e6','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:30',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1597981622-trunk_net_two-czjeumnr5cf7','state changed','OS::Neutron::Net',NULL,NULL),(133,'ed8d3f38-261f-4e0f-b041-fcf9869e4b4c','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:30',NULL,'UPDATE','IN_PROGRESS','subnet','3c795864-1e7d-4845-9287-fa0389bb80f2','state changed','OS::Neutron::Subnet',NULL,21),(134,'4cb33def-0671-45ea-b9e1-09c818d615ce','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:31',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(135,'79539a26-5479-4568-9154-b3a9422abd8e','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:31',NULL,'CREATE','COMPLETE','trunk_net_two','06e2e3dd-5776-4bc5-bb48-bc2a19171c73','state changed','OS::Neutron::Net',NULL,NULL),(136,'2dd0d0f1-5028-4d1f-8fe0-1fe01c1aef6a','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:31',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1597981622-trunk_subnet_two-ih4vqnily4lg','state changed','OS::Neutron::Subnet',NULL,28),(137,'d83bf711-8659-4406-88be-d507e26e6159','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:31',NULL,'UPDATE','COMPLETE','subnet','3c795864-1e7d-4845-9287-fa0389bb80f2','state changed','OS::Neutron::Subnet',NULL,29),(138,'ecc0ff95-a079-411e-bec6-6163d226b815','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:31',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(139,'a068cf41-adf9-406a-be61-96287020e5a4','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:31',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1597981622-parent_net-lf4vwhwah7rz','state changed','OS::Neutron::Net',NULL,NULL),(140,'572d0748-d660-4d42-937c-331ed3129221','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:31',NULL,'UPDATE','IN_PROGRESS','port','040419ac-31ee-41a1-a090-da29d0523734','state changed','OS::Neutron::Port',NULL,19),(141,'bca6f1af-7f91-4f7e-9381-31e2c3a9674a','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:32',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1597981622-trunk_net_one-o5pvid6czgdv','state changed','OS::Neutron::Net',NULL,NULL),(142,'4993ccbd-4dc8-46d3-be26-417924a57d76','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','COMPLETE','parent_net','b7befc96-23b2-4866-a9a9-1c06391628b0','state changed','OS::Neutron::Net',NULL,NULL),(143,'c963c3d5-c4ec-40cc-a3a0-f9911cce8db3','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1597981622-parent_subnet-6mgwgv5qvcfc','state changed','OS::Neutron::Subnet',NULL,30),(144,'e030ce9b-6111-409e-9930-9ae475d533ab','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','COMPLETE','trunk_net_one','c08c1e5e-44c8-484f-9b37-57726f1f69fd','state changed','OS::Neutron::Net',NULL,NULL),(145,'d5cb92c7-899d-455e-8e58-7a6eaf442e43','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1597981622-trunk_subnet_one-u4dono5ojv6j','state changed','OS::Neutron::Subnet',NULL,31),(146,'6de8bc6f-eb79-46ef-95d8-1a302ba027f9','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','COMPLETE','trunk_subnet_two','2f838186-ffe8-4a4e-b187-f3b5ba8ae5e5','state changed','OS::Neutron::Subnet',NULL,28),(147,'ba9f01b9-0553-4abe-ae19-382497d68dd0','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:33',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1597981622-sub_port_two-beo7c4cjh7ad','state changed','OS::Neutron::Port',NULL,32),(148,'e82d8d67-70da-4f28-8586-2de6be63c251','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:33',NULL,'UPDATE','COMPLETE','port','040419ac-31ee-41a1-a090-da29d0523734','state changed','OS::Neutron::Port',NULL,33),(149,'d90009d0-eb0d-4a48-8cc8-4322f350d366','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:33',NULL,'UPDATE','IN_PROGRESS','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(150,'8e466090-04ae-4372-af08-c3ebff41ca89','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:34',NULL,'UPDATE','IN_PROGRESS','my_encrypted_vol_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::EncryptedVolumeType',NULL,26),(151,'b977feb8-dde7-421c-b326-716deb4696cc','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:34',NULL,'UPDATE','COMPLETE','my_encrypted_vol_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::EncryptedVolumeType',NULL,35),(152,'4af36e4a-0158-4b0c-8883-8a1ebf14b074','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:34',NULL,'UPDATE','COMPLETE','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(153,'4a08867a-a075-4f18-a3c3-c57438cc9e0c','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:34',NULL,'UPDATE','COMPLETE','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(154,'4769bee0-795d-46e2-8821-9d987cfbec03','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:34',NULL,'CREATE','COMPLETE','sub_port_two','07ee6358-21dc-4a9e-8610-9c61dd6e6608','state changed','OS::Neutron::Port',NULL,32),(155,'e6d49543-3b43-4084-ac8d-5947c8ecc99b','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:35',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(156,'b3489d19-18d7-41d4-b093-5bda88798c8e','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:35',NULL,'CREATE','COMPLETE','parent_subnet','d8434c28-1b82-451f-88a4-fac3d8e9fb82','state changed','OS::Neutron::Subnet',NULL,30),(157,'20dc8144-ae5b-40c2-b960-17fede2aacf1','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:35',NULL,'DELETE','IN_PROGRESS','subnet','3c795864-1e7d-4845-9287-fa0389bb80f2','state changed','OS::Neutron::Subnet',NULL,29),(158,'406fd378-8001-4259-9c97-79ed327874b2','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:35',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1597981622-parent_port-iiypjuwpzvqc','state changed','OS::Neutron::Port',NULL,37),(159,'d70c275c-e0fd-4d3c-8d51-3645187bd7b0','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:35',NULL,'CREATE','COMPLETE','trunk_subnet_one','05b016d9-1e9d-4086-9b12-73b3c8ed3a58','state changed','OS::Neutron::Subnet',NULL,31),(160,'d67b26a7-09f6-43d4-ace0-8f6efcf5906c','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:35',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1597981622-sub_port_one-yvzzfd22pcv2','state changed','OS::Neutron::Port',NULL,38),(161,'5ff7e0e4-cf64-4bf5-bab5-6568d20358d8','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:35',NULL,'DELETE','COMPLETE','subnet','3c795864-1e7d-4845-9287-fa0389bb80f2','state changed','OS::Neutron::Subnet',NULL,29),(162,'0b196bac-36c4-4e34-bf72-805e82753d7c','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:35',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(163,'db61ec5e-2590-4f1e-afd9-9367fcb59b4d','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:35',NULL,'DELETE','IN_PROGRESS','net','20820931-bb2b-46b3-8ddb-340917102728','state changed','OS::Neutron::Net',NULL,NULL),(164,'7d4bfed4-ba55-4c02-919c-218f5afff5bf','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:35',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-1177326764-test-ac2nggs5yw4b','state changed','OS::Heat::TestResource',NULL,24),(165,'b9cf218b-0bc4-478d-ab95-a35f0d1780f9','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:35',NULL,'DELETE','COMPLETE','test','UpdatePortTest-1177326764-test-ac2nggs5yw4b','state changed','OS::Heat::TestResource',NULL,24),(166,'51ef29d4-8fcd-40a5-92a4-54d585d69431','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:36',NULL,'DELETE','IN_PROGRESS','port','040419ac-31ee-41a1-a090-da29d0523734','state changed','OS::Neutron::Port',NULL,33),(167,'4b09b909-dbeb-4621-958c-8afce72b559f','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:36',NULL,'CREATE','COMPLETE','parent_port','5584f878-6f49-4fbb-b0e6-6fbbab7d3ac8','state changed','OS::Neutron::Port',NULL,37),(168,'65e94fed-5543-4a42-a056-acfca2d3b539','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:36',NULL,'CREATE','COMPLETE','sub_port_one','a4a9ee06-c4ac-4116-b1b4-16df3ea5e369','state changed','OS::Neutron::Port',NULL,38),(169,'dba548b9-9de8-43ee-8b2f-1a52bd0838c0','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:36',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1597981622-trunk-giorzqhimokl','state changed','OS::Neutron::Trunk',NULL,39),(170,'35ed5285-60b5-4d52-8546-c1d161ccabed','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:37',NULL,'DELETE','COMPLETE','net','20820931-bb2b-46b3-8ddb-340917102728','state changed','OS::Neutron::Net',NULL,NULL),(171,'15e52902-b47a-46d4-8a07-f8dd08c7d6a8','392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:37',NULL,'DELETE','COMPLETE','UpdateSubnetTest-574386486','392082f6-2f1f-455b-a46f-d19921aa2c4b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(172,'49b721ae-6dc7-4916-8373-e514d0699a43','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:37',NULL,'DELETE','COMPLETE','port','040419ac-31ee-41a1-a090-da29d0523734','state changed','OS::Neutron::Port',NULL,33),(173,'e5af7c5c-32b3-4b73-970e-426927cf2c28','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:37',NULL,'DELETE','IN_PROGRESS','subnet','a51f4258-8291-41ba-896e-b58fdd19c0b4','state changed','OS::Neutron::Subnet',NULL,18),(174,'a09532d7-73b5-42aa-baa5-80fc53b745d8','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:37',NULL,'DELETE','COMPLETE','subnet','a51f4258-8291-41ba-896e-b58fdd19c0b4','state changed','OS::Neutron::Subnet',NULL,18),(175,'b568e4a6-a464-4d04-b127-7b848475d50d','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:37',NULL,'DELETE','IN_PROGRESS','net','428a20ee-3476-451f-97bc-8bb2c787bc4c','state changed','OS::Neutron::Net',NULL,NULL),(176,'5b4582df-a135-4f9d-b7d7-4e6b8cd2ffff','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:38',NULL,'CREATE','COMPLETE','trunk','29853631-a4dc-4c21-a55d-d55d1ed52a96','state changed','OS::Neutron::Trunk',NULL,39),(177,'6a3b6082-950f-434f-9117-a5aa57b7f8cc','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:38',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(178,'79c01361-b0dd-4f46-8d2e-47e79a57ed10','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:38',NULL,'DELETE','COMPLETE','net','428a20ee-3476-451f-97bc-8bb2c787bc4c','state changed','OS::Neutron::Net',NULL,NULL),(179,'027a6adb-28d2-4735-aff4-d13318447fb4','20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:38',NULL,'DELETE','COMPLETE','UpdatePortTest-1177326764','20ca30d0-05f1-4456-b87e-a2d3274a8e75','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(180,'2325b1f9-a94e-4105-84e1-50a59b6e8e98','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:38',NULL,'DELETE','IN_PROGRESS','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(181,'9fe11ba7-1b60-4dc5-9900-a9af0b32821d','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:38',NULL,'DELETE','IN_PROGRESS','my_encrypted_vol_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::EncryptedVolumeType',NULL,35),(182,'381ebf9f-e7cc-4d6e-acfd-371b0cf87585','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:39',NULL,'DELETE','COMPLETE','my_encrypted_vol_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::EncryptedVolumeType',NULL,35),(183,'7d0347ba-b13f-48bf-87a5-d874cbbff167','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:39',NULL,'DELETE','IN_PROGRESS','my_volume_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::VolumeType',NULL,25),(184,'b931ca3e-acce-4121-867d-8de3887df2b1','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:39',NULL,'DELETE','COMPLETE','my_volume_type','2682a6a4-78e2-43fa-8e60-3da97d4f29eb','state changed','OS::Cinder::VolumeType',NULL,25),(185,'9fbc69e6-bb17-4f1e-ab45-2040e421eb7c','8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:39',NULL,'DELETE','COMPLETE','EncryptionVolTypeTest-1016197023','8e2f1935-c309-44ff-916c-5be86a24aa8a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(186,'1aaa566d-d893-4acd-9da5-1456c0a30798','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:39',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(187,'11240358-31fe-41ae-914a-4ff377749591','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:41',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(188,'d132c42b-8dba-41af-80c3-3f8076363b32','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:41',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-990839975-net-jj2kylu7eigw','state changed','OS::Neutron::Net',NULL,NULL),(189,'cfa01c31-9cd7-4db9-b884-b48e3e29e51d','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:41',NULL,'CREATE','IN_PROGRESS','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(190,'7b22aa66-7d36-43d7-a7bb-bfed7dc67055','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:41',NULL,'CREATE','IN_PROGRESS','net','UpdatePortTest-859279828-net-smfv4elide2b','state changed','OS::Neutron::Net',NULL,NULL),(191,'094ed04b-eb1b-407e-9527-dcbade9a1e77','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:41',NULL,'CREATE','COMPLETE','net','dc4cf4ee-b9cd-4909-80f1-ac5e599592a5','state changed','OS::Neutron::Net',NULL,NULL),(192,'a94f0ae3-bb6e-47ca-b58f-6c04ff3c674b','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:42',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-990839975-subnet-sh5sdvz2aerj','state changed','OS::Neutron::Subnet',NULL,40),(193,'affbef64-971a-4e1b-9c84-69500d493beb','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:42',NULL,'CREATE','COMPLETE','net','8706bb00-4d3b-45b5-aa30-3ab7cadf13fe','state changed','OS::Neutron::Net',NULL,NULL),(194,'cab56124-87bd-40a3-a188-ddf0b1329c8c','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:42',NULL,'CREATE','IN_PROGRESS','subnet','UpdatePortTest-859279828-subnet-iw5wui2bj7zv','state changed','OS::Neutron::Subnet',NULL,41),(195,'c55ed3a7-eb75-4638-b523-73f6e33843bf','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:42',NULL,'UPDATE','IN_PROGRESS','trunk','29853631-a4dc-4c21-a55d-d55d1ed52a96','state changed','OS::Neutron::Trunk',NULL,39),(196,'ab8e3400-d935-492c-b352-5f022ae6bc63','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:43',NULL,'CREATE','COMPLETE','subnet','1f51b12b-07d7-4d33-892d-9b1da0cf006a','state changed','OS::Neutron::Subnet',NULL,40),(197,'92a0cf0d-bced-4739-9b71-e71f161dfd23','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:43',NULL,'CREATE','COMPLETE','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(198,'a4d92f78-7885-42bb-a6ac-ebe7b259f2df','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:43',NULL,'CREATE','COMPLETE','subnet','c32f1eb6-702a-4a80-af9f-72fc7e1e74b9','state changed','OS::Neutron::Subnet',NULL,41),(199,'a46fe19a-2f70-49d9-be1f-08ddec972bdf','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:43',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-859279828-port-ehfnn53c2ymq','state changed','OS::Neutron::Port',NULL,42),(200,'9826c3d3-72cb-4476-9061-96c04085998c','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:44',NULL,'CREATE','COMPLETE','port','2ec75bae-02e4-4769-97c7-9f4c4790f415','state changed','OS::Neutron::Port',NULL,42),(201,'82b63797-2dbb-40b8-af92-c36d4d9827d1','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:44',NULL,'UPDATE','COMPLETE','trunk','29853631-a4dc-4c21-a55d-d55d1ed52a96','state changed','OS::Neutron::Trunk',NULL,44),(202,'f0c0f313-6c8a-45b2-9783-445a7055ebce','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:44',NULL,'CREATE','IN_PROGRESS','test','UpdatePortTest-859279828-test-lktbfzlctorc','state changed','OS::Heat::TestResource',NULL,45),(203,'ad500977-d5da-44a6-a7fe-d1dd80a77ee8','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:44',NULL,'CREATE','COMPLETE','test','UpdatePortTest-859279828-test-lktbfzlctorc','state changed','OS::Heat::TestResource',NULL,45),(204,'c8b6aacf-75ab-4d5a-ad04-4673587bc3d3','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:44',NULL,'CREATE','COMPLETE','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(205,'dffdef16-6d77-4419-a25f-9c740a9941a7','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:45',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(206,'97d68097-77b8-4cc0-a3fa-ef1f37194843','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:45',NULL,'CREATE','IN_PROGRESS','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(207,'7de90643-9ae7-40f5-89e3-535e2677a42e','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:45',NULL,'CREATE','IN_PROGRESS','net','add_network-net-sj6zgay7at5r','state changed','OS::Neutron::Net',NULL,46),(208,'226cbea9-2cb3-4ceb-b81e-3f04ce3603fd','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:45',NULL,'CREATE','COMPLETE','net','3a57b7dd-7fc0-4118-bf54-dc6cb3cf29bd','state changed','OS::Neutron::Net',NULL,46),(209,'de84b1b6-d772-411a-9516-3d63dbe3f074','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:46',NULL,'CREATE','IN_PROGRESS','subnet','add_network-subnet-ipka2limpete','state changed','OS::Neutron::Subnet',NULL,48),(210,'c5736f93-7c8b-4b79-bc8a-7b1bd28ad4d6','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:46',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(211,'4f0c1e3a-da18-4dc4-b2dd-ec26ec1a24c2','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:46',NULL,'UPDATE','IN_PROGRESS','subnet','1f51b12b-07d7-4d33-892d-9b1da0cf006a','state changed','OS::Neutron::Subnet',NULL,40),(212,'32d7622e-8271-47f8-8a2a-571f09224747','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:46',NULL,'UPDATE','IN_PROGRESS','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(213,'e133c57b-5b3c-41f8-a045-a84a6817572b','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:47',NULL,'UPDATE','COMPLETE','subnet','1f51b12b-07d7-4d33-892d-9b1da0cf006a','state changed','OS::Neutron::Subnet',NULL,49),(214,'8e2cd939-72b9-485f-b757-6b857a2c3b34','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:47',NULL,'CREATE','COMPLETE','subnet','9c902034-d478-4019-9ac0-b1200ab4c874','state changed','OS::Neutron::Subnet',NULL,48),(215,'545dab96-5e06-439b-bff4-ee7d77adc6c4','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:47',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(216,'c3fe4151-76ec-4b60-95f2-4f17b120e58b','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:47',NULL,'UPDATE','IN_PROGRESS','port','2ec75bae-02e4-4769-97c7-9f4c4790f415','state changed','OS::Neutron::Port',NULL,42),(217,'8e7dd2cf-1ac8-4623-8120-6c11cfe83725','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:47',NULL,'CREATE','IN_PROGRESS','server','add_network-server-4z7mm2gfbrf5','state changed','OS::Nova::Server',NULL,50),(218,'c742b145-bc72-42c7-a244-62ddd247bff8','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:52',NULL,'UPDATE','COMPLETE','port','2ec75bae-02e4-4769-97c7-9f4c4790f415','The Resource port requires replacement.','OS::Neutron::Port',NULL,42),(219,'2c2c31ac-338e-409c-a267-bd4756890fbf','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:52',NULL,'CREATE','IN_PROGRESS','port','UpdatePortTest-859279828-port-6fbmm4fgdjqz','state changed','OS::Neutron::Port',NULL,53),(220,'b9a24e31-0aad-4445-9d36-df25ef5dc3d4','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:52',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(221,'1b323b5d-645b-47a7-80c0-766b4ba56c96','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:52',NULL,'DELETE','IN_PROGRESS','subnet','1f51b12b-07d7-4d33-892d-9b1da0cf006a','state changed','OS::Neutron::Subnet',NULL,49),(222,'eb03d3ba-5c5c-48e0-b65d-4cd6af6be9a9','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:52',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(223,'9f7eb179-7d22-4eda-a6bb-de47434c9a60','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:52',NULL,'DELETE','IN_PROGRESS','trunk','29853631-a4dc-4c21-a55d-d55d1ed52a96','state changed','OS::Neutron::Trunk',NULL,44),(224,'4adb1589-345c-4bbb-b2ff-99b4dc045ce0','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:52',NULL,'DELETE','COMPLETE','subnet','1f51b12b-07d7-4d33-892d-9b1da0cf006a','state changed','OS::Neutron::Subnet',NULL,49),(225,'cd421aa0-a1b2-4857-bb0d-785514960936','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:52',NULL,'DELETE','IN_PROGRESS','net','dc4cf4ee-b9cd-4909-80f1-ac5e599592a5','state changed','OS::Neutron::Net',NULL,NULL),(226,'40180d67-efa7-4883-8a53-136362cdd964','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:53',NULL,'DELETE','COMPLETE','trunk','29853631-a4dc-4c21-a55d-d55d1ed52a96','state changed','OS::Neutron::Trunk',NULL,44),(227,'1ee687f2-6874-4429-8679-5c0e302c93e5','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:53',NULL,'DELETE','IN_PROGRESS','sub_port_one','a4a9ee06-c4ac-4116-b1b4-16df3ea5e369','state changed','OS::Neutron::Port',NULL,38),(228,'490201d9-26e5-4caa-b14b-a6445dac0426','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:53',NULL,'DELETE','IN_PROGRESS','sub_port_two','07ee6358-21dc-4a9e-8610-9c61dd6e6608','state changed','OS::Neutron::Port',NULL,32),(229,'2865515a-bc89-47e5-9210-6526e1f716d1','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:53',NULL,'DELETE','IN_PROGRESS','parent_port','5584f878-6f49-4fbb-b0e6-6fbbab7d3ac8','state changed','OS::Neutron::Port',NULL,37),(230,'fb023439-21e1-436e-8984-c394bf8ff0de','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:53',NULL,'CREATE','COMPLETE','port','5c8e51c8-cb42-4cec-8955-b367e3bfb26c','state changed','OS::Neutron::Port',NULL,53),(231,'9300efd2-584b-415a-9245-80cf93eff485','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:53',NULL,'DELETE','COMPLETE','net','dc4cf4ee-b9cd-4909-80f1-ac5e599592a5','state changed','OS::Neutron::Net',NULL,NULL),(232,'ba73b444-c85b-42a4-9f3b-3e526908f6e3','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:53',NULL,'DELETE','IN_PROGRESS','port','2ec75bae-02e4-4769-97c7-9f4c4790f415','state changed','OS::Neutron::Port',NULL,42),(233,'a51663c3-ad32-45a1-abff-3ec6eb80451c','e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:53',NULL,'DELETE','COMPLETE','UpdateSubnetTest-990839975','e6575805-bf41-4704-9151-e79aa66c4a03','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(234,'d90499fa-1680-4372-9cf6-d849e6ee881c','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','sub_port_one','a4a9ee06-c4ac-4116-b1b4-16df3ea5e369','state changed','OS::Neutron::Port',NULL,38),(235,'8348b400-9668-44b7-a10b-de15b20c9d8c','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','05b016d9-1e9d-4086-9b12-73b3c8ed3a58','state changed','OS::Neutron::Subnet',NULL,31),(236,'0ab38045-7b8b-4db7-93a0-2913f2291d05','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','sub_port_two','07ee6358-21dc-4a9e-8610-9c61dd6e6608','state changed','OS::Neutron::Port',NULL,32),(237,'18ad8aa3-aac7-4937-9904-363eb1085a01','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','parent_port','5584f878-6f49-4fbb-b0e6-6fbbab7d3ac8','state changed','OS::Neutron::Port',NULL,37),(238,'3d7dc985-ec2a-4e2d-9b48-42a24bb09caa','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','2f838186-ffe8-4a4e-b187-f3b5ba8ae5e5','state changed','OS::Neutron::Subnet',NULL,28),(239,'b4cd8070-de1b-4b18-b327-08c54b408528','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','parent_subnet','d8434c28-1b82-451f-88a4-fac3d8e9fb82','state changed','OS::Neutron::Subnet',NULL,30),(240,'e8bdb7b7-804e-4fa2-8c74-ed770307dfa5','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','port','2ec75bae-02e4-4769-97c7-9f4c4790f415','state changed','OS::Neutron::Port',NULL,42),(241,'8687d708-ae2f-45ff-9aa0-aeea3c81d871','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','trunk_subnet_one','05b016d9-1e9d-4086-9b12-73b3c8ed3a58','state changed','OS::Neutron::Subnet',NULL,31),(242,'8a712bfb-ef46-441f-bae4-0f4b615b82ef','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:54',NULL,'UPDATE','COMPLETE','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(243,'f34e53e1-123d-497d-8a96-04be4256002d','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','trunk_net_one','c08c1e5e-44c8-484f-9b37-57726f1f69fd','state changed','OS::Neutron::Net',NULL,NULL),(244,'383a24a2-7cb6-4df2-a263-f944155600c7','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','parent_subnet','d8434c28-1b82-451f-88a4-fac3d8e9fb82','state changed','OS::Neutron::Subnet',NULL,30),(245,'7f75b292-3134-4c25-b598-34dd567402ae','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','COMPLETE','trunk_subnet_two','2f838186-ffe8-4a4e-b187-f3b5ba8ae5e5','state changed','OS::Neutron::Subnet',NULL,28),(246,'b7f95465-2b74-4192-9c5e-a4eb78786bdb','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','trunk_net_two','06e2e3dd-5776-4bc5-bb48-bc2a19171c73','state changed','OS::Neutron::Net',NULL,NULL),(247,'22970711-e42b-44c8-90d8-bca41ec63ad1','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:54',NULL,'DELETE','IN_PROGRESS','parent_net','b7befc96-23b2-4866-a9a9-1c06391628b0','state changed','OS::Neutron::Net',NULL,NULL),(248,'87721212-6049-4e50-b9d3-8acfcba51c9e','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:56',NULL,'DELETE','COMPLETE','trunk_net_one','c08c1e5e-44c8-484f-9b37-57726f1f69fd','state changed','OS::Neutron::Net',NULL,NULL),(249,'d0d98a13-dee0-4ad8-ae9d-6be2560c8b16','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:56',NULL,'DELETE','COMPLETE','parent_net','b7befc96-23b2-4866-a9a9-1c06391628b0','state changed','OS::Neutron::Net',NULL,NULL),(250,'87247f8e-b60e-4c7c-98a6-6af45722e2c5','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:56',NULL,'DELETE','COMPLETE','trunk_net_two','06e2e3dd-5776-4bc5-bb48-bc2a19171c73','state changed','OS::Neutron::Net',NULL,NULL),(251,'97136f69-c3e7-4547-9849-d040d90c70c5','9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:56',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1597981622','9213d019-ef0e-449e-a350-1575dc1f6b74','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(252,'48a7d97f-d6af-4cfc-8fb5-b0300e29d005','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:56',NULL,'DELETE','IN_PROGRESS','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(253,'150b441d-6a5d-4ce1-b702-0ef94fd6ee76','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:56',NULL,'DELETE','IN_PROGRESS','port','5c8e51c8-cb42-4cec-8955-b367e3bfb26c','state changed','OS::Neutron::Port',NULL,53),(254,'25052b93-1f5d-486c-95fb-98bfc98143fc','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','COMPLETE','port','5c8e51c8-cb42-4cec-8955-b367e3bfb26c','state changed','OS::Neutron::Port',NULL,53),(255,'2bf731fb-869b-40ee-89cb-54bab8cc1ee6','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','IN_PROGRESS','subnet','c32f1eb6-702a-4a80-af9f-72fc7e1e74b9','state changed','OS::Neutron::Subnet',NULL,41),(256,'782e5b7d-2c4c-4d11-9472-6c9f76064919','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','IN_PROGRESS','test','UpdatePortTest-859279828-test-lktbfzlctorc','state changed','OS::Heat::TestResource',NULL,45),(257,'8997c144-284d-44fc-a1b2-8fe9442ec1df','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','COMPLETE','test','UpdatePortTest-859279828-test-lktbfzlctorc','state changed','OS::Heat::TestResource',NULL,45),(258,'b0ca2e55-bb7c-4ea9-983a-fa9586de11a4','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','COMPLETE','subnet','c32f1eb6-702a-4a80-af9f-72fc7e1e74b9','state changed','OS::Neutron::Subnet',NULL,41),(259,'5029a4a8-9568-4b50-99b0-8a5d412b8ad4','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:57',NULL,'DELETE','IN_PROGRESS','net','8706bb00-4d3b-45b5-aa30-3ab7cadf13fe','state changed','OS::Neutron::Net',NULL,NULL),(260,'7e72996d-8adf-4124-9f99-abcfa5431acf','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:50:58',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(261,'1e98f9ff-6317-451f-b467-01369085cf08','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:50:58',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1850581261-net-7xt66z4u5ut5','state changed','OS::Neutron::Net',NULL,NULL),(262,'2dc812fe-5cc1-4921-9f8a-09c20c23b107','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:58',NULL,'DELETE','COMPLETE','net','8706bb00-4d3b-45b5-aa30-3ab7cadf13fe','state changed','OS::Neutron::Net',NULL,NULL),(263,'5bfc3cb5-d319-45d6-84a4-6f05067688a3','2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:58',NULL,'DELETE','COMPLETE','UpdatePortTest-859279828','2b18d5e5-918f-4797-873e-81ecc1bdc475','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(264,'fc7bd073-7ae8-4d35-a918-09c0c22ebda8','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:50:58',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(265,'d7690f4d-6b29-4ad6-bc02-fb4b1881ce9c','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:50:59',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1488414881-trunk_net_two-azpqqjaf6gxn','state changed','OS::Neutron::Net',NULL,NULL),(266,'eac41c87-2918-447e-bc43-ae91017a3885','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:50:59',NULL,'CREATE','COMPLETE','net','5c6b37a6-0860-43f1-951f-dcefd1e70e72','state changed','OS::Neutron::Net',NULL,NULL),(267,'936aca42-e5f1-472f-b1cd-fa2e01e24465','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:50:59',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1850581261-subnet-iacmbxuft2d6','state changed','OS::Neutron::Subnet',NULL,55),(268,'011da748-1bf1-4b76-8982-80b90ecfc458','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:00',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1488414881-trunk_net_one-mxzgz3tqqhqm','state changed','OS::Neutron::Net',NULL,NULL),(269,'e6c9245d-f671-4e20-b8ab-e18004fb33e9','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:01',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1488414881-parent_net-tivolkt4jmkn','state changed','OS::Neutron::Net',NULL,NULL),(270,'f481f4a4-9e9a-4a50-940c-602eb258ed48','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:01',NULL,'CREATE','COMPLETE','parent_net','29a24e95-cb93-4eec-9ad6-95928ce68f51','state changed','OS::Neutron::Net',NULL,NULL),(271,'8e6c079c-8035-4367-b991-e220369ca53b','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:01',NULL,'CREATE','COMPLETE','trunk_net_two','43d410f6-d678-4cd8-9e85-80f5fa9bdd65','state changed','OS::Neutron::Net',NULL,NULL),(272,'9bedd9f2-19b4-4cce-9bd1-5da57dca82e2','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:01',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1488414881-parent_subnet-o6qijptc4kru','state changed','OS::Neutron::Subnet',NULL,56),(273,'fa71ae1e-7665-4679-89b5-f1703ca36e3d','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:02',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1488414881-trunk_subnet_two-y6qpycxw4oi4','state changed','OS::Neutron::Subnet',NULL,57),(274,'8d860cb2-e25a-4451-b3fa-229809fabfac','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:03',NULL,'CREATE','IN_PROGRESS','EncryptedParametersTest-1283256311','ce5d58fe-5f90-4769-a448-345dac77cb1c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(275,'b4d71494-7bb1-4671-9f2d-93aceb4c9dde','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:03',NULL,'CREATE','IN_PROGRESS','server_with_encrypted_property','En-256311-server_with_encrypted_property-7ujaehdmq75b','state changed','OS::Nova::Server',NULL,58),(276,'9a7e8844-d1a1-42fc-946e-30de1aaa2cf0','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:03',NULL,'CREATE','COMPLETE','trunk_net_one','7edaeedd-a4cc-45e8-9eb7-e3361b5c2c1d','state changed','OS::Neutron::Net',NULL,NULL),(277,'c5f41a67-5768-4519-b749-7fa46f4ecf90','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:03',NULL,'CREATE','COMPLETE','subnet','c7e5bd4b-5223-4b40-82c6-c9e025086e0d','state changed','OS::Neutron::Subnet',NULL,55),(278,'0a5062e7-1711-4127-9cd7-d9763817bc98','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:03',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(279,'c33a6e8a-4692-488e-a95a-5d411715875d','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:03',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1488414881-trunk_subnet_one-yv6r6i5pdpgl','state changed','OS::Neutron::Subnet',NULL,59),(280,'ba9b2f79-a71f-4883-bec2-7a65cc123581','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:05',NULL,'CREATE','COMPLETE','trunk_subnet_one','ac3c50a4-9210-4a66-bafc-f51bcd498959','state changed','OS::Neutron::Subnet',NULL,59),(281,'642d1755-3f31-4512-b52b-fc00c1f8e4a6','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:05',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1488414881-sub_port_one-z26irti4ginq','state changed','OS::Neutron::Port',NULL,60),(282,'b0fce79e-730b-4c69-b1f6-a27d52756938','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:05',NULL,'CREATE','COMPLETE','parent_subnet','92582532-858b-4a6a-a3f8-6bf06ac31e9e','state changed','OS::Neutron::Subnet',NULL,56),(283,'3b4448a8-fd47-4d28-8f8e-1c210569cf1a','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:05',NULL,'CREATE','COMPLETE','trunk_subnet_two','d791ee39-676f-4e64-bdb1-7653cca72343','state changed','OS::Neutron::Subnet',NULL,57),(284,'2b25afd5-5563-4101-aa32-464b41543534','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:06',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1488414881-parent_port-okaah2vrunio','state changed','OS::Neutron::Port',NULL,61),(285,'8856fd24-4ce3-4c33-aece-a4d9a1cc5961','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:06',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1488414881-sub_port_two-5e2wepqphpkw','state changed','OS::Neutron::Port',NULL,62),(286,'7ad64184-57fd-4040-8c83-9b28e1ed2c2e','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:06',NULL,'CREATE','COMPLETE','sub_port_one','3fc359f3-2e1b-418c-bf06-3fdb3632aca1','state changed','OS::Neutron::Port',NULL,60),(287,'2b606201-9555-471f-a71e-9781bd931f5a','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:08',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(288,'2b6ee3f6-0be3-47fd-9d7f-749516b3ac9b','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:08',NULL,'UPDATE','IN_PROGRESS','subnet','c7e5bd4b-5223-4b40-82c6-c9e025086e0d','state changed','OS::Neutron::Subnet',NULL,55),(289,'d7e6b102-5aa9-4756-a68e-45c5f08a55ae','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:09',NULL,'CREATE','COMPLETE','parent_port','8a95b7c3-71cd-445b-bad9-08545a0a6771','state changed','OS::Neutron::Port',NULL,61),(290,'2a7f5ed4-909f-43c0-a07b-b6b017b48e38','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:09',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1488414881-trunk-6ov75cijjzo7','state changed','OS::Neutron::Trunk',NULL,64),(291,'93563643-4fea-406a-a895-7617353d2dd1','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:09',NULL,'CREATE','COMPLETE','sub_port_two','cdcf6ae9-9111-4a7e-86ce-43c5bf2884a9','state changed','OS::Neutron::Port',NULL,62),(292,'ce247857-10d0-4fa1-99ee-abbaa3c5ab22','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:10',NULL,'UPDATE','COMPLETE','subnet','c7e5bd4b-5223-4b40-82c6-c9e025086e0d','state changed','OS::Neutron::Subnet',NULL,65),(293,'a548731e-d72a-445f-8261-ed6ac09d6e49','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:10',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(294,'e75525ce-084b-4ebf-8a92-cc105bcae7bf','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:11',NULL,'CREATE','COMPLETE','trunk','cb8e0619-5fb7-4f79-979e-9ed1e57185f6','state changed','OS::Neutron::Trunk',NULL,64),(295,'9c019166-f1fc-4ae8-a4b2-a319347ac1b2','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:11',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(296,'737abbd1-5820-4eb7-9f9a-688fac62cd00','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:11',NULL,'CREATE','COMPLETE','server','13dbe1f3-e13d-4c02-aa8e-ddf3a89f8e59','state changed','OS::Nova::Server',NULL,50),(297,'21362818-a2a5-4775-aed6-8a751535fe39','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:11',NULL,'CREATE','COMPLETE','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(298,'9c1a4ecb-731b-46a4-8067-a1948c362ebc','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:12',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(299,'09ae1cb2-4d46-44cc-9c3b-28c67a5d9e03','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:14',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(300,'6fae63c2-1a70-497a-929c-f796a909ce79','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:14',NULL,'DELETE','IN_PROGRESS','subnet','c7e5bd4b-5223-4b40-82c6-c9e025086e0d','state changed','OS::Neutron::Subnet',NULL,65),(301,'ac8b1ea6-2342-4e46-bf21-fec022db1aee','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:14',NULL,'DELETE','COMPLETE','subnet','c7e5bd4b-5223-4b40-82c6-c9e025086e0d','state changed','OS::Neutron::Subnet',NULL,65),(302,'7edef01e-b18b-4e0e-b4b1-4331204ae0aa','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:14',NULL,'DELETE','IN_PROGRESS','net','5c6b37a6-0860-43f1-951f-dcefd1e70e72','state changed','OS::Neutron::Net',NULL,NULL),(303,'e9a15e31-1ed2-40c5-8648-699505c4ebf7','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:15',NULL,'DELETE','COMPLETE','net','5c6b37a6-0860-43f1-951f-dcefd1e70e72','state changed','OS::Neutron::Net',NULL,NULL),(304,'b7f9df8b-9a46-43f4-8ee5-01bf9257c8eb','4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:51:15',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1850581261','4aacb383-051a-437f-98b4-44e5d1db2085','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(305,'87df11ec-5650-495d-b386-0751b86fd12a','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:15',NULL,'UPDATE','IN_PROGRESS','trunk','cb8e0619-5fb7-4f79-979e-9ed1e57185f6','state changed','OS::Neutron::Trunk',NULL,64),(306,'730aca3b-b97b-493a-83d8-dbe061f520d6','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:17',NULL,'CREATE','COMPLETE','server_with_encrypted_property','ccaff5df-c404-455c-a261-5e9303b457e9','state changed','OS::Nova::Server',NULL,58),(307,'499905e3-f4ad-42bc-bdd2-02135f36c308','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:17',NULL,'CREATE','COMPLETE','EncryptedParametersTest-1283256311','ce5d58fe-5f90-4769-a448-345dac77cb1c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(308,'ffc475d8-47f5-477e-a27e-b041aa3f235b','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:17',NULL,'UPDATE','COMPLETE','trunk','cb8e0619-5fb7-4f79-979e-9ed1e57185f6','state changed','OS::Neutron::Trunk',NULL,68),(309,'679e128b-f5b0-46ec-87e6-81c934d7d42e','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:17',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(310,'31dbd701-0074-4cbb-9ecb-44b7f825d9c1','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:17',NULL,'UPDATE','IN_PROGRESS','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(311,'b77fe952-9859-4b9d-9315-f0dd72c9b5ae','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:18',NULL,'UPDATE','IN_PROGRESS','server','13dbe1f3-e13d-4c02-aa8e-ddf3a89f8e59','state changed','OS::Nova::Server',NULL,50),(312,'707e4bdd-9713-48e7-ad9a-05c7fa71f314','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:19',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(313,'c794c47f-bbd6-43af-bc53-7212abbf2088','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:20',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1324097782-net-h2ys2aik7mez','state changed','OS::Neutron::Net',NULL,NULL),(314,'c3268cb1-9998-4baf-a808-c78871f5a946','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:20',NULL,'DELETE','IN_PROGRESS','EncryptedParametersTest-1283256311','ce5d58fe-5f90-4769-a448-345dac77cb1c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(315,'ec136e4b-e402-4c42-b361-c5235c566316','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:20',NULL,'DELETE','IN_PROGRESS','server_with_encrypted_property','ccaff5df-c404-455c-a261-5e9303b457e9','state changed','OS::Nova::Server',NULL,58),(316,'a2b57a94-7214-4a1d-82d1-0650709d92dd','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:21',NULL,'CREATE','COMPLETE','net','8801d255-7713-4d3c-bf81-eb7c7f220ff7','state changed','OS::Neutron::Net',NULL,NULL),(317,'dfa3e8ff-d794-4ea1-b977-8f56daa11676','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:21',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1324097782-subnet-6ocsjldagtrj','state changed','OS::Neutron::Subnet',NULL,69),(318,'5ce90971-62c5-45c6-a7d9-464e7ba832ca','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:21',NULL,'UPDATE','COMPLETE','server','13dbe1f3-e13d-4c02-aa8e-ddf3a89f8e59','state changed','OS::Nova::Server',NULL,70),(319,'b375d305-63ef-4512-8c1d-778c5240c2cd','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:21',NULL,'UPDATE','COMPLETE','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(320,'3c494d75-4ebc-43cf-b66b-ebf4443d1e2d','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:22',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(321,'fa295d25-2a14-429e-86e3-50596f64c854','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:22',NULL,'DELETE','IN_PROGRESS','sub_port_two','cdcf6ae9-9111-4a7e-86ce-43c5bf2884a9','state changed','OS::Neutron::Port',NULL,62),(322,'4f9451ac-ec3b-40f0-82d5-d0e8466f635a','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:22',NULL,'DELETE','COMPLETE','server_with_encrypted_property','ccaff5df-c404-455c-a261-5e9303b457e9','state changed','OS::Nova::Server',NULL,58),(323,'11378b30-20c2-4d55-9df1-ca0809b63369','ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:22',NULL,'DELETE','COMPLETE','EncryptedParametersTest-1283256311','ce5d58fe-5f90-4769-a448-345dac77cb1c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(324,'b7a8a5c7-4621-4c08-bf13-4df5660ecd66','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:22',NULL,'CREATE','COMPLETE','subnet','9912762f-df67-4d2f-9235-c5c1869452bf','state changed','OS::Neutron::Subnet',NULL,69),(325,'9def83a4-d239-438b-bb50-bd85deea2e87','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:22',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(326,'8aa1c9aa-7329-402f-ae0c-6486c055c8a9','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','COMPLETE','sub_port_two','cdcf6ae9-9111-4a7e-86ce-43c5bf2884a9','state changed','OS::Neutron::Port',NULL,62),(327,'7780f032-afa5-4e8c-8b55-24d3c9156708','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','d791ee39-676f-4e64-bdb1-7653cca72343','state changed','OS::Neutron::Subnet',NULL,57),(328,'74abca3e-6470-494f-bebc-25e79f98da2c','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','trunk','cb8e0619-5fb7-4f79-979e-9ed1e57185f6','state changed','OS::Neutron::Trunk',NULL,68),(329,'465726bb-35a8-4176-8dd0-0ba63f5e245f','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','COMPLETE','trunk_subnet_two','d791ee39-676f-4e64-bdb1-7653cca72343','state changed','OS::Neutron::Subnet',NULL,57),(330,'53cdb3fb-812b-4975-a7ce-d3254899319e','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','trunk_net_two','43d410f6-d678-4cd8-9e85-80f5fa9bdd65','state changed','OS::Neutron::Net',NULL,NULL),(331,'4dab3b92-559f-4bec-aa01-36ee2d643238','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','COMPLETE','trunk','cb8e0619-5fb7-4f79-979e-9ed1e57185f6','state changed','OS::Neutron::Trunk',NULL,68),(332,'9229aded-7d42-465d-bc24-c43425062354','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','parent_port','8a95b7c3-71cd-445b-bad9-08545a0a6771','state changed','OS::Neutron::Port',NULL,61),(333,'8b504e91-7878-48a6-b0fc-4d3693ad80f8','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','sub_port_one','3fc359f3-2e1b-418c-bf06-3fdb3632aca1','state changed','OS::Neutron::Port',NULL,60),(334,'10c5198d-2bda-4041-8645-c25e840cb0a6','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:23',NULL,'DELETE','IN_PROGRESS','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(335,'87a2f2fd-1715-4cd4-804d-420c8779d979','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:24',NULL,'DELETE','IN_PROGRESS','server','13dbe1f3-e13d-4c02-aa8e-ddf3a89f8e59','state changed','OS::Nova::Server',NULL,70),(336,'fc22d9fa-1805-40fb-8833-83db41944712','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:24',NULL,'DELETE','COMPLETE','sub_port_one','3fc359f3-2e1b-418c-bf06-3fdb3632aca1','state changed','OS::Neutron::Port',NULL,60),(337,'83c2557f-2db8-4b53-bedc-7e876ba3803d','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:24',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','ac3c50a4-9210-4a66-bafc-f51bcd498959','state changed','OS::Neutron::Subnet',NULL,59),(338,'c5c73f93-5087-46bb-a8af-37afbda361c6','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:24',NULL,'DELETE','COMPLETE','parent_port','8a95b7c3-71cd-445b-bad9-08545a0a6771','state changed','OS::Neutron::Port',NULL,61),(339,'35380ecd-d438-494d-a7eb-61f6422f15dd','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:24',NULL,'DELETE','COMPLETE','trunk_net_two','43d410f6-d678-4cd8-9e85-80f5fa9bdd65','state changed','OS::Neutron::Net',NULL,NULL),(340,'bbce1d50-6c49-4a75-9ae8-945e7b59c658','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:24',NULL,'DELETE','IN_PROGRESS','parent_subnet','92582532-858b-4a6a-a3f8-6bf06ac31e9e','state changed','OS::Neutron::Subnet',NULL,56),(341,'37646cdf-8dcb-4b51-b3f4-126ddbe6b4fb','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:25',NULL,'DELETE','COMPLETE','trunk_subnet_one','ac3c50a4-9210-4a66-bafc-f51bcd498959','state changed','OS::Neutron::Subnet',NULL,59),(342,'50a1cf1e-0d9b-4351-8600-9a65a7ea84e7','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:25',NULL,'DELETE','IN_PROGRESS','trunk_net_one','7edaeedd-a4cc-45e8-9eb7-e3361b5c2c1d','state changed','OS::Neutron::Net',NULL,NULL),(343,'5e89f461-2e2c-4894-9a42-15efadb7547d','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:25',NULL,'DELETE','COMPLETE','parent_subnet','92582532-858b-4a6a-a3f8-6bf06ac31e9e','state changed','OS::Neutron::Subnet',NULL,56),(344,'a2bb17de-b499-42e5-ac5b-55af443f6bdb','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:25',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(345,'bc7f3cc1-1722-4635-a9f2-d33aa7438774','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:25',NULL,'DELETE','IN_PROGRESS','parent_net','29a24e95-cb93-4eec-9ad6-95928ce68f51','state changed','OS::Neutron::Net',NULL,NULL),(346,'1c9988ea-0307-4f10-8855-87423066fb44','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:25',NULL,'UPDATE','IN_PROGRESS','subnet','9912762f-df67-4d2f-9235-c5c1869452bf','state changed','OS::Neutron::Subnet',NULL,69),(347,'c3b4404d-3874-4d9b-8f89-e6b67a60021a','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:25',NULL,'DELETE','COMPLETE','trunk_net_one','7edaeedd-a4cc-45e8-9eb7-e3361b5c2c1d','state changed','OS::Neutron::Net',NULL,NULL),(348,'302e2acb-ea0d-468a-8c0b-7380af7e61f4','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:26',NULL,'DELETE','COMPLETE','parent_net','29a24e95-cb93-4eec-9ad6-95928ce68f51','state changed','OS::Neutron::Net',NULL,NULL),(349,'da4e8818-98bd-44a8-8877-1caf820eba77','5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:51:26',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1488414881','5d38f36b-a174-4e5a-8907-0272bda0c157','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(350,'9225d069-ea5b-4994-9756-43d1d183580c','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:26',NULL,'CREATE','IN_PROGRESS','server_with_port','217d4478-6268-4748-9435-22510c02434d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(351,'ae9e3489-2d00-419c-8cb2-c066e552c9b3','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:26',NULL,'DELETE','COMPLETE','server','13dbe1f3-e13d-4c02-aa8e-ddf3a89f8e59','state changed','OS::Nova::Server',NULL,70),(352,'b0a3f022-2e26-49bb-a446-0cc56ed662a5','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:26',NULL,'DELETE','IN_PROGRESS','subnet','9c902034-d478-4019-9ac0-b1200ab4c874','state changed','OS::Neutron::Subnet',NULL,48),(353,'3433c57d-9e6c-4d19-a17a-921344511478','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:26',NULL,'UPDATE','COMPLETE','subnet','9912762f-df67-4d2f-9235-c5c1869452bf','state changed','OS::Neutron::Subnet',NULL,74),(354,'583af15d-20e2-4c09-811c-4231043288f6','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:26',NULL,'CREATE','IN_PROGRESS','net','server_with_port-net-ranu6blsabfu','state changed','OS::Neutron::Net',NULL,75),(355,'dda94b54-d180-4d8b-bd70-96188fa560ec','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:26',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(356,'c0cbf713-1f96-4084-b063-bb8ff5087c26','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:27',NULL,'DELETE','COMPLETE','subnet','9c902034-d478-4019-9ac0-b1200ab4c874','state changed','OS::Neutron::Subnet',NULL,48),(357,'06479d97-33dc-4519-b31c-f82a98ee1394','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:27',NULL,'DELETE','IN_PROGRESS','net','3a57b7dd-7fc0-4118-bf54-dc6cb3cf29bd','state changed','OS::Neutron::Net',NULL,46),(358,'f3fbda22-6b30-4e1d-9d3f-decfdd08626a','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:27',NULL,'CREATE','COMPLETE','net','75dc0740-9854-4ea8-afc0-81cea3d1d364','state changed','OS::Neutron::Net',NULL,75),(359,'3d228ff5-4526-4e2b-8c19-84b1a85cb6af','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:27',NULL,'CREATE','IN_PROGRESS','subnet','server_with_port-subnet-4vgg2dwq3wii','state changed','OS::Neutron::Subnet',NULL,76),(360,'7e47da44-1d5c-4eee-b133-fe902ea8af44','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:27',NULL,'DELETE','COMPLETE','net','3a57b7dd-7fc0-4118-bf54-dc6cb3cf29bd','state changed','OS::Neutron::Net',NULL,46),(361,'6c3ffad7-a514-46a6-9fe6-f62f8f5db2cb','da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:51:27',NULL,'DELETE','COMPLETE','add_network','da164336-cc20-4b39-9725-79f404891d39','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(362,'9217a446-260b-4001-afee-06aeb7c9a0c0','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:31',NULL,'CREATE','COMPLETE','subnet','0c775d4d-b54d-443a-ae8e-780b418c6734','state changed','OS::Neutron::Subnet',NULL,76),(363,'244694bb-0766-4e65-953a-40ffdc055ba3','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:32',NULL,'CREATE','IN_PROGRESS','port','server_with_port-port-2sq2da42cqqa','state changed','OS::Neutron::Port',NULL,77),(364,'3e3ec0b6-6579-4c00-9a2b-4afcacc7fefd','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:34',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(365,'cd87c4b6-31a6-49e0-bf24-fb0d7ccf7fa1','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:34',NULL,'DELETE','IN_PROGRESS','subnet','9912762f-df67-4d2f-9235-c5c1869452bf','state changed','OS::Neutron::Subnet',NULL,74),(366,'78a5ef9e-5477-480c-a258-863639fea2a7','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:34',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(367,'48601872-1ce1-4b63-a98e-1702888c8259','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:34',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1380021495-trunk_net_one-7izfuzmiy5yp','state changed','OS::Neutron::Net',NULL,NULL),(368,'a60bdf47-2e32-46b6-b49f-5cf236efb882','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:34',NULL,'DELETE','COMPLETE','subnet','9912762f-df67-4d2f-9235-c5c1869452bf','state changed','OS::Neutron::Subnet',NULL,74),(369,'244e42f9-c956-43a8-9bce-7b8f4db680ef','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:34',NULL,'DELETE','IN_PROGRESS','net','8801d255-7713-4d3c-bf81-eb7c7f220ff7','state changed','OS::Neutron::Net',NULL,NULL),(370,'baa84aca-f098-45be-a5dc-1642dfb76a92','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:35',NULL,'CREATE','IN_PROGRESS','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(371,'1b3fa495-2f9c-4f69-88ad-de892c9c3ab5','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:35',NULL,'CREATE','IN_PROGRESS','net','same_fixed_ip-net-uxmn3rwfl4ot','state changed','OS::Neutron::Net',NULL,79),(372,'44b39b83-7a94-4ce3-b66c-10dbc455dd63','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:35',NULL,'CREATE','COMPLETE','port','8ce7e99d-bed8-41a5-89c6-17b79e306a6a','state changed','OS::Neutron::Port',NULL,77),(373,'77526fb6-2e04-4492-b238-2afe2dca36d0','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:35',NULL,'CREATE','IN_PROGRESS','server','server_with_port-server-ikuytq7u3z7k','state changed','OS::Nova::Server',NULL,80),(374,'5516e19e-a45e-46ac-8352-5338e2452202','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:35',NULL,'DELETE','COMPLETE','net','8801d255-7713-4d3c-bf81-eb7c7f220ff7','state changed','OS::Neutron::Net',NULL,NULL),(375,'9650dea0-773a-4115-821d-d85a4c424033','6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:35',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1324097782','6202f2b6-dc35-4531-bc27-43932ebb80b4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(376,'a5dcb5b5-f967-47a7-9af4-5444244e391c','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:35',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1380021495-trunk_net_two-naxwm26om4pi','state changed','OS::Neutron::Net',NULL,NULL),(377,'4b8f57ef-0a95-4aae-997c-783556aa3e90','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:36',NULL,'CREATE','COMPLETE','trunk_net_one','c7834cc6-197b-45bc-95c2-5dcfa20cecce','state changed','OS::Neutron::Net',NULL,NULL),(378,'64fb4bfb-39c1-41bc-af80-b83a6d6e1bc4','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:36',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1380021495-trunk_subnet_one-7rfcwqf5zbe3','state changed','OS::Neutron::Subnet',NULL,81),(379,'6ea7d7bb-01fe-4621-9e4a-159b525511a3','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:36',NULL,'CREATE','COMPLETE','net','b9c02741-791c-45c3-b569-18504f1c1de0','state changed','OS::Neutron::Net',NULL,79),(380,'9f5a24ea-ed96-46d4-aa17-8d1bbcbb44ca','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:36',NULL,'CREATE','IN_PROGRESS','subnet','same_fixed_ip-subnet-fpl5vo4vo6xe','state changed','OS::Neutron::Subnet',NULL,82),(381,'ab74deb0-f501-4929-a17c-6c3f189a689b','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:37',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1380021495-parent_net-h6iswmzrdgbv','state changed','OS::Neutron::Net',NULL,NULL),(382,'b73392e3-94cc-4655-b06e-be74295ed563','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:37',NULL,'CREATE','COMPLETE','trunk_net_two','093dd2bb-9f94-48af-bdcd-a3aa4352548b','state changed','OS::Neutron::Net',NULL,NULL),(383,'589b7f1f-1c97-4249-bbea-ceb692ece651','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:38',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1380021495-trunk_subnet_two-3rb3dgxfzx3f','state changed','OS::Neutron::Subnet',NULL,83),(384,'96dc1284-e7c0-4698-9bf4-40de72fa837d','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:38',NULL,'CREATE','COMPLETE','subnet','f0844e3c-8182-4208-8104-2fa8b4457955','state changed','OS::Neutron::Subnet',NULL,82),(385,'be7d147c-ece1-4c3e-99bb-2b08f6d69eb8','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:38',NULL,'CREATE','IN_PROGRESS','server','same_fixed_ip-server-r7vwkpw3kwgb','state changed','OS::Nova::Server',NULL,84),(386,'cef3b593-1626-4365-8a40-e158cd0db1f8','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:39',NULL,'CREATE','COMPLETE','parent_net','1b30aa72-8693-4561-b9eb-a1f52575b263','state changed','OS::Neutron::Net',NULL,NULL),(387,'f2cf543d-4f87-4a70-8996-e1de4d9d9ba7','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:39',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1380021495-parent_subnet-xrooymzy2dem','state changed','OS::Neutron::Subnet',NULL,85),(388,'c71cef6f-12c5-4e54-a368-b40a5bfcf5ce','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:39',NULL,'CREATE','COMPLETE','trunk_subnet_one','1a6d9577-dca6-493b-8bdd-d35508451239','state changed','OS::Neutron::Subnet',NULL,81),(389,'162141f3-6c6c-477a-ad4b-cdfd713cbe86','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:40',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1380021495-sub_port_one-6pub4xz73lkb','state changed','OS::Neutron::Port',NULL,86),(390,'5776e4f5-72f2-4a25-a850-81530909007b','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:40',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(391,'1b034024-857e-45f1-8a27-a2ed563c1e2f','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:40',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1112033237-net-x7cpvq6am2kg','state changed','OS::Neutron::Net',NULL,NULL),(392,'898798c4-6214-401b-9d93-a0cf757f0d21','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:41',NULL,'CREATE','COMPLETE','parent_subnet','d72a0525-9b31-415a-99a9-38389803e6a7','state changed','OS::Neutron::Subnet',NULL,85),(393,'fcf539c1-69ce-464b-b8b0-052e72e0e20f','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:41',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1380021495-parent_port-jq4w55ek36p5','state changed','OS::Neutron::Port',NULL,87),(394,'4109a59f-dca3-4ca3-bc5b-ac54aab2714c','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:41',NULL,'CREATE','COMPLETE','trunk_subnet_two','3ec2b5c0-912b-44af-b36d-8d3c73c5b3ed','state changed','OS::Neutron::Subnet',NULL,83),(395,'74725bdc-f61b-44b9-87b0-a087606d80a9','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:41',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1380021495-sub_port_two-izyf4q2xvzzm','state changed','OS::Neutron::Port',NULL,88),(396,'548064ed-415f-43b7-bd7b-5bf284ff77b7','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:42',NULL,'CREATE','COMPLETE','net','6a62735f-5285-459a-8763-3a10ce21d521','state changed','OS::Neutron::Net',NULL,NULL),(397,'2f49a327-5a65-4147-a4fa-086fb4ab7b33','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:42',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1112033237-subnet-vvymuvntimcs','state changed','OS::Neutron::Subnet',NULL,89),(398,'dd892a76-c3c9-4afc-b721-a9d3043876ae','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:42',NULL,'CREATE','COMPLETE','sub_port_one','f7a24831-372e-4bbd-9a5b-1f429c9fa8b0','state changed','OS::Neutron::Port',NULL,86),(399,'49c7391c-26d2-4dda-985c-adfacf091835','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:42',NULL,'CREATE','COMPLETE','parent_port','6f6de104-a15e-4321-a0af-93d2f312c37d','state changed','OS::Neutron::Port',NULL,87),(400,'8e2aae1a-7330-4054-a142-4f602495d3e3','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:43',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1380021495-trunk-3hrsui2vn5dh','state changed','OS::Neutron::Trunk',NULL,90),(401,'68a87f4f-acfc-4d6a-bee1-6cbfadb57edd','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:44',NULL,'CREATE','COMPLETE','sub_port_two','7c02e196-3ff5-4fd7-a30b-d2528c53066b','state changed','OS::Neutron::Port',NULL,88),(402,'285cc9a6-0410-4c4f-a537-c68977e91897','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:45',NULL,'CREATE','COMPLETE','subnet','7d82b661-3ca5-4eae-990e-62bdedb5a219','state changed','OS::Neutron::Subnet',NULL,89),(403,'83163bfd-9b55-44fd-b87b-296e4f4051b5','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:45',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(404,'839759fb-c197-4ef9-8d6b-8246a67baad3','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:45',NULL,'CREATE','COMPLETE','trunk','856fdb65-55ac-4d51-ae3b-2e470eeee343','state changed','OS::Neutron::Trunk',NULL,90),(405,'7c0ff29f-c295-4bf3-8c36-b2424dd7f971','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:45',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(406,'962435d7-2dee-4b7c-8268-ee016fe011cb','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:48',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(407,'e9beabaa-1b2a-489e-9050-f16b7ce916e2','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:51',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(408,'9d3658d3-0b25-4e27-a8f7-ca1e71721532','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:51',NULL,'UPDATE','IN_PROGRESS','subnet','7d82b661-3ca5-4eae-990e-62bdedb5a219','state changed','OS::Neutron::Subnet',NULL,89),(409,'d96307c7-7559-4397-b14f-175af9c05970','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:52',NULL,'UPDATE','IN_PROGRESS','trunk','856fdb65-55ac-4d51-ae3b-2e470eeee343','state changed','OS::Neutron::Trunk',NULL,90),(410,'4fbfa375-2e37-4522-a466-61bb725577cd','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:53',NULL,'UPDATE','COMPLETE','subnet','7d82b661-3ca5-4eae-990e-62bdedb5a219','state changed','OS::Neutron::Subnet',NULL,92),(411,'1652d771-f62d-4bae-bf97-aa30b946b03a','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:53',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(412,'c104af3c-39e0-4df1-bcf5-fba9eabdbf57','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:54',NULL,'CREATE','COMPLETE','server','c2f01a3a-b429-4b00-b81d-92ed5980a9a0','state changed','OS::Nova::Server',NULL,80),(413,'e6d1fc2a-b960-4dfd-9bbb-b1d3eba34ed5','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:54',NULL,'CREATE','COMPLETE','server_with_port','217d4478-6268-4748-9435-22510c02434d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(414,'ff7e3c99-27ef-427e-b530-27ec445b71f3','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:54',NULL,'UPDATE','COMPLETE','trunk','856fdb65-55ac-4d51-ae3b-2e470eeee343','state changed','OS::Neutron::Trunk',NULL,93),(415,'8aa50f93-c649-48d9-a2f6-4031f4ac8cea','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:55',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(416,'cd1492eb-2a98-4689-9722-13a5b01d4a64','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:55',NULL,'CREATE','COMPLETE','server','44dd9bce-70e7-415a-a6c3-7e78d336b55b','state changed','OS::Nova::Server',NULL,84),(417,'3db05765-32cd-4366-80f1-bd2dfadffe3c','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:55',NULL,'CREATE','COMPLETE','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(418,'38533b9d-3e4e-4037-9581-da5dda332320','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:56',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(419,'92099070-a0de-4287-90dc-f0a73517056b','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:56',NULL,'DELETE','IN_PROGRESS','subnet','7d82b661-3ca5-4eae-990e-62bdedb5a219','state changed','OS::Neutron::Subnet',NULL,92),(420,'4af1bb2b-9089-4698-8efb-998f79dcb88d','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:57',NULL,'DELETE','IN_PROGRESS','server_with_port','217d4478-6268-4748-9435-22510c02434d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(421,'409a5413-3bac-4c86-8d2d-794914073b01','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:57',NULL,'DELETE','IN_PROGRESS','server','c2f01a3a-b429-4b00-b81d-92ed5980a9a0','state changed','OS::Nova::Server',NULL,80),(422,'5fc21fb5-2cc5-42df-9770-d7d81a59429e','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:57',NULL,'DELETE','COMPLETE','subnet','7d82b661-3ca5-4eae-990e-62bdedb5a219','state changed','OS::Neutron::Subnet',NULL,92),(423,'c323e0b1-c69f-492c-8978-188d2fa27027','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:57',NULL,'DELETE','IN_PROGRESS','net','6a62735f-5285-459a-8763-3a10ce21d521','state changed','OS::Neutron::Net',NULL,NULL),(424,'cec3b300-f1e5-421d-bf5e-d681f5ee701c','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:58',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(425,'40fe25a2-1ccd-4740-9915-ff13e40c30a4','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:58',NULL,'DELETE','IN_PROGRESS','trunk','856fdb65-55ac-4d51-ae3b-2e470eeee343','state changed','OS::Neutron::Trunk',NULL,93),(426,'cc6a62dd-9f04-4d7e-8bb0-900d6b4ca8d3','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:58',NULL,'DELETE','COMPLETE','trunk','856fdb65-55ac-4d51-ae3b-2e470eeee343','state changed','OS::Neutron::Trunk',NULL,93),(427,'6aff25c9-d71e-4964-b336-0dd5ed3f1605','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:58',NULL,'DELETE','IN_PROGRESS','parent_port','6f6de104-a15e-4321-a0af-93d2f312c37d','state changed','OS::Neutron::Port',NULL,87),(428,'0b2959b8-4045-4782-a7aa-f769f1748bab','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:58',NULL,'DELETE','COMPLETE','net','6a62735f-5285-459a-8763-3a10ce21d521','state changed','OS::Neutron::Net',NULL,NULL),(429,'5b4bedcd-9f1c-4fe7-adb4-a9d174861bb2','3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:58',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1112033237','3d993ff3-b44d-4656-906d-69870da50d4c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(430,'4e8da779-08bb-4bc3-acc3-d548cfddfe2b','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:58',NULL,'DELETE','COMPLETE','parent_port','6f6de104-a15e-4321-a0af-93d2f312c37d','state changed','OS::Neutron::Port',NULL,87),(431,'a33731b4-2944-473f-8a8b-8d17d0d16dc9','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:59',NULL,'DELETE','IN_PROGRESS','parent_subnet','d72a0525-9b31-415a-99a9-38389803e6a7','state changed','OS::Neutron::Subnet',NULL,85),(432,'086cc286-41ba-4731-b4ea-8f46553c6a91','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:59',NULL,'DELETE','IN_PROGRESS','sub_port_one','f7a24831-372e-4bbd-9a5b-1f429c9fa8b0','state changed','OS::Neutron::Port',NULL,86),(433,'d981b5bd-d638-4685-a1fb-0a4e93133900','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:59',NULL,'UPDATE','IN_PROGRESS','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(434,'3536d034-84d7-4998-8e40-ed2007d0c9ce','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:59',NULL,'DELETE','COMPLETE','parent_subnet','d72a0525-9b31-415a-99a9-38389803e6a7','state changed','OS::Neutron::Subnet',NULL,85),(435,'bdce54b2-5798-4e1d-bb75-fd47bf7662c2','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:59',NULL,'DELETE','IN_PROGRESS','parent_net','1b30aa72-8693-4561-b9eb-a1f52575b263','state changed','OS::Neutron::Net',NULL,NULL),(436,'dfa19c4e-ba0b-419d-82e0-0efc7521650b','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','COMPLETE','sub_port_one','f7a24831-372e-4bbd-9a5b-1f429c9fa8b0','state changed','OS::Neutron::Port',NULL,86),(437,'2c3d3777-aff5-4ae4-a9e0-8f93cbdc0ac0','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','1a6d9577-dca6-493b-8bdd-d35508451239','state changed','OS::Neutron::Subnet',NULL,81),(438,'780d6eee-ccae-4476-bc2b-3f4bae21a6a3','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:00',NULL,'UPDATE','IN_PROGRESS','server','44dd9bce-70e7-415a-a6c3-7e78d336b55b','state changed','OS::Nova::Server',NULL,84),(439,'4d5d0df1-a3ee-45ea-b26d-6125f3a69a5a','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','IN_PROGRESS','sub_port_two','7c02e196-3ff5-4fd7-a30b-d2528c53066b','state changed','OS::Neutron::Port',NULL,88),(440,'77cf6234-1475-4768-8d61-0c27eb7e9b5d','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','COMPLETE','parent_net','1b30aa72-8693-4561-b9eb-a1f52575b263','state changed','OS::Neutron::Net',NULL,NULL),(441,'88e951e4-6ba8-4982-bf22-c353d1a001b0','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','COMPLETE','trunk_subnet_one','1a6d9577-dca6-493b-8bdd-d35508451239','state changed','OS::Neutron::Subnet',NULL,81),(442,'d337ffed-acf2-46bc-abca-34ed82999bd8','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:00',NULL,'DELETE','COMPLETE','server','c2f01a3a-b429-4b00-b81d-92ed5980a9a0','state changed','OS::Nova::Server',NULL,80),(443,'3ebccf1d-a2e9-4fb7-aa31-2a765c014ce0','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','IN_PROGRESS','trunk_net_one','c7834cc6-197b-45bc-95c2-5dcfa20cecce','state changed','OS::Neutron::Net',NULL,NULL),(444,'74123ac5-ec45-4b44-9cae-d8d6634c488f','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:00',NULL,'DELETE','IN_PROGRESS','port','8ce7e99d-bed8-41a5-89c6-17b79e306a6a','state changed','OS::Neutron::Port',NULL,77),(445,'2c432b58-9f7d-4ab2-b3ee-08d706c2cd58','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','COMPLETE','sub_port_two','7c02e196-3ff5-4fd7-a30b-d2528c53066b','state changed','OS::Neutron::Port',NULL,88),(446,'6610774a-8b1b-4998-89c6-b472cd64f411','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:00',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','3ec2b5c0-912b-44af-b36d-8d3c73c5b3ed','state changed','OS::Neutron::Subnet',NULL,83),(447,'58ad3134-3ab8-4a15-b66b-bec424c33a90','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:01',NULL,'DELETE','COMPLETE','trunk_subnet_two','3ec2b5c0-912b-44af-b36d-8d3c73c5b3ed','state changed','OS::Neutron::Subnet',NULL,83),(448,'70c05417-6cad-4ce0-8fc2-6fcc942c934c','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:01',NULL,'DELETE','IN_PROGRESS','trunk_net_two','093dd2bb-9f94-48af-bdcd-a3aa4352548b','state changed','OS::Neutron::Net',NULL,NULL),(449,'99a7f8ec-6e7f-4484-9ba4-73ec44e9536c','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:01',NULL,'DELETE','COMPLETE','port','8ce7e99d-bed8-41a5-89c6-17b79e306a6a','state changed','OS::Neutron::Port',NULL,77),(450,'6b8b0b3c-e396-4145-ae59-484d1c6067cd','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:01',NULL,'DELETE','IN_PROGRESS','subnet','0c775d4d-b54d-443a-ae8e-780b418c6734','state changed','OS::Neutron::Subnet',NULL,76),(451,'f1576217-23db-4eae-84f6-d7b8559828b3','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:01',NULL,'DELETE','COMPLETE','trunk_net_one','c7834cc6-197b-45bc-95c2-5dcfa20cecce','state changed','OS::Neutron::Net',NULL,NULL),(452,'46e06841-7716-4a87-8b8e-27f489a13e56','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:02',NULL,'DELETE','COMPLETE','trunk_net_two','093dd2bb-9f94-48af-bdcd-a3aa4352548b','state changed','OS::Neutron::Net',NULL,NULL),(453,'13fdf536-c3a0-4ae0-9f06-9a63a78ec14e','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:52:02',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1380021495','a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(454,'3da7b4a6-64ae-4e22-99cb-82fa44a7ee3a','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:02',NULL,'DELETE','COMPLETE','subnet','0c775d4d-b54d-443a-ae8e-780b418c6734','state changed','OS::Neutron::Subnet',NULL,76),(455,'969538ba-c858-4061-bd6a-db94e4fee778','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:02',NULL,'DELETE','IN_PROGRESS','net','75dc0740-9854-4ea8-afc0-81cea3d1d364','state changed','OS::Neutron::Net',NULL,75),(456,'8248ffb5-3d33-493c-bb54-52d8ce5155b3','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:02',NULL,'CREATE','IN_PROGRESS','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(457,'07f724ab-58e2-48f4-8f29-e079ca58f1f8','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:02',NULL,'CREATE','IN_PROGRESS','net','UpdateSubnetTest-1871972168-net-5kb6k4na2sqi','state changed','OS::Neutron::Net',NULL,NULL),(458,'1384e9b2-dbd9-43d3-9798-fb233d76bfca','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:03',NULL,'DELETE','COMPLETE','net','75dc0740-9854-4ea8-afc0-81cea3d1d364','state changed','OS::Neutron::Net',NULL,75),(459,'4eef0bac-ef38-40e9-83c5-8f29dbbaf9e9','217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:52:03',NULL,'DELETE','COMPLETE','server_with_port','217d4478-6268-4748-9435-22510c02434d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(460,'9b3bbae2-44eb-4f5b-b81a-6b4d9e3be88b','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:03',NULL,'CREATE','COMPLETE','net','8727a630-00b6-4187-aa8b-97105d8fa27e','state changed','OS::Neutron::Net',NULL,NULL),(461,'cf4e5c96-67a4-41a1-8c6f-6a8a5f8dd398','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:03',NULL,'CREATE','IN_PROGRESS','subnet','UpdateSubnetTest-1871972168-subnet-thwoddef5jdy','state changed','OS::Neutron::Subnet',NULL,97),(462,'ceb18356-3807-499d-8a96-fa7fe324f9eb','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:04',NULL,'UPDATE','COMPLETE','server','44dd9bce-70e7-415a-a6c3-7e78d336b55b','state changed','OS::Nova::Server',NULL,98),(463,'e6319107-83d5-41c0-a07a-15fde35181c1','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:04',NULL,'UPDATE','COMPLETE','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(464,'6a34fdac-9f50-42cb-8942-069af90d2a38','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:06',NULL,'CREATE','COMPLETE','subnet','3cbfa44b-95b4-4246-8a7a-16252c892add','state changed','OS::Neutron::Subnet',NULL,97),(465,'f7cf049e-de55-4d1a-a172-bcfa9974e55f','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:06',NULL,'CREATE','COMPLETE','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(466,'4573e7f1-e7b8-4f4d-914f-ae325959a7d5','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:08',NULL,'UPDATE','IN_PROGRESS','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(467,'797ee832-a2fe-4cea-921c-f188b7177520','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:08',NULL,'CREATE','IN_PROGRESS','server_with_sub_ip','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(468,'48c01e20-c631-4c2e-bbbe-811ce3ddde69','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:08',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(469,'9eea7704-a228-472c-8275-793936d47c53','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:08',NULL,'UPDATE','IN_PROGRESS','subnet','3cbfa44b-95b4-4246-8a7a-16252c892add','state changed','OS::Neutron::Subnet',NULL,97),(470,'5047a24d-44c8-4dd6-ac02-138489c77702','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:08',NULL,'CREATE','IN_PROGRESS','net','server_with_sub_ip-net-qlx7s3dw7npt','state changed','OS::Neutron::Net',NULL,100),(471,'22c504ba-c4ed-43ea-acb0-429f4d3f97fe','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:08',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1305200445-parent_net-7qftld2bkn43','state changed','OS::Neutron::Net',NULL,NULL),(472,'4528e6f8-ae91-4795-baee-0ebbbf69a381','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:09',NULL,'UPDATE','COMPLETE','subnet','3cbfa44b-95b4-4246-8a7a-16252c892add','state changed','OS::Neutron::Subnet',NULL,101),(473,'dfff6038-b2d6-4201-bc21-086296bf169e','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:09',NULL,'CREATE','IN_PROGRESS','security_group','server_with_sub_ip-security_group-np4hhnjy47is','state changed','OS::Neutron::SecurityGroup',NULL,102),(474,'8b471ffe-c4e7-46bb-be1c-528bf6ae3bbb','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:09',NULL,'UPDATE','COMPLETE','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(475,'6b90f776-fb79-4750-9c33-73cbf018e17e','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:09',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1305200445-trunk_net_two-5oxo3dq6dqlm','state changed','OS::Neutron::Net',NULL,NULL),(476,'5df32a96-8171-42bc-b31c-6495eaced389','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:10',NULL,'CREATE','COMPLETE','net','9946ec75-e13d-4e17-b4c5-b003ff9c0eb1','state changed','OS::Neutron::Net',NULL,100),(477,'9b317133-c2c4-4978-9e01-9f8f4146228f','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:10',NULL,'CREATE','IN_PROGRESS','subnet','server_with_sub_ip-subnet-fafsspyhkvlf','state changed','OS::Neutron::Subnet',NULL,103),(478,'47a19701-1aa5-4d96-a8f0-09d33e345e8b','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:10',NULL,'CREATE','COMPLETE','parent_net','6f8f6475-0be5-48db-b659-09adad2433f1','state changed','OS::Neutron::Net',NULL,NULL),(479,'46d224ad-a5fb-4a9f-9b34-68b03663fdaf','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:10',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1305200445-parent_subnet-uxri6wp4hkfs','state changed','OS::Neutron::Subnet',NULL,105),(480,'f785c837-a751-47f8-ae7e-635157e06e68','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:10',NULL,'DELETE','IN_PROGRESS','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(481,'3fc207ad-ff85-489a-919f-d109083bd66f','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:10',NULL,'DELETE','IN_PROGRESS','server','44dd9bce-70e7-415a-a6c3-7e78d336b55b','state changed','OS::Nova::Server',NULL,98),(482,'4b84fe67-dff0-4c57-9161-aaee29215b04','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:11',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1305200445-trunk_net_one-f6eegcwqb63k','state changed','OS::Neutron::Net',NULL,NULL),(483,'cef86b36-291f-4278-b637-3ab4053c34f8','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:11',NULL,'CREATE','COMPLETE','trunk_net_two','6625097a-abed-4c42-88e4-8e10be907580','state changed','OS::Neutron::Net',NULL,NULL),(484,'23faa86d-d180-465c-ac6a-b994f7106954','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:11',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1305200445-trunk_subnet_two-pjddgn5mpvfw','state changed','OS::Neutron::Subnet',NULL,106),(485,'4923444d-38b4-4ae4-9e1a-0c6418af0846','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:11',NULL,'CREATE','COMPLETE','security_group','b3802cf5-62c1-4792-88d5-51268e8062a8','state changed','OS::Neutron::SecurityGroup',NULL,102),(486,'ca2ea46f-9f4f-4b6e-b743-be63ae7da0d5','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:12',NULL,'CREATE','COMPLETE','subnet','c8d766dd-96c3-4e9f-a64c-8a23548b368a','state changed','OS::Neutron::Subnet',NULL,103),(487,'2835d13c-40cd-4522-93b3-2b8aaeb301b1','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:12',NULL,'CREATE','COMPLETE','trunk_net_one','5abea305-33d2-41d2-a794-5efe8b8004c2','state changed','OS::Neutron::Net',NULL,NULL),(488,'c6f7cce7-cc6e-439f-9a81-c1327889d521','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:12',NULL,'CREATE','IN_PROGRESS','server','server_with_sub_ip-server-5zqs3qz7eoxx','state changed','OS::Nova::Server',NULL,107),(489,'fd665cd7-cae5-421f-8141-de3068bf47e0','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:12',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1305200445-trunk_subnet_one-rdgiovfkoo4w','state changed','OS::Neutron::Subnet',NULL,108),(490,'52510833-a812-4ba5-9808-f4b9ee2ced5b','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:12',NULL,'CREATE','COMPLETE','parent_subnet','a10076f1-6120-4536-83f9-0292089b30c3','state changed','OS::Neutron::Subnet',NULL,105),(491,'38150f3d-5b48-439e-b3a8-5f9550e53537','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:12',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1305200445-parent_port-wazkwheosnyq','state changed','OS::Neutron::Port',NULL,109),(492,'8f2ffb9b-11b5-48e6-9bdf-06489c125c55','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:13',NULL,'CREATE','COMPLETE','trunk_subnet_two','43cefa5b-6b0d-413d-9314-1eadff5c711d','state changed','OS::Neutron::Subnet',NULL,106),(493,'40af2e4d-aaf6-4554-a0ef-fe5f65eaaf53','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:13',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1305200445-sub_port_two-bu6vls7xcqnv','state changed','OS::Neutron::Port',NULL,110),(494,'750a6326-8b9c-48e9-a2e8-3962915e87e8','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:13',NULL,'DELETE','COMPLETE','server','44dd9bce-70e7-415a-a6c3-7e78d336b55b','state changed','OS::Nova::Server',NULL,98),(495,'396faef1-6973-4598-a861-bcccee5faa80','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:13',NULL,'DELETE','IN_PROGRESS','subnet','f0844e3c-8182-4208-8104-2fa8b4457955','state changed','OS::Neutron::Subnet',NULL,82),(496,'bb5372e1-fb25-4a25-897b-849143db0046','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:13',NULL,'DELETE','IN_PROGRESS','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(497,'2df883b3-e6d1-4f22-96f0-bb54316051de','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:13',NULL,'DELETE','IN_PROGRESS','subnet','3cbfa44b-95b4-4246-8a7a-16252c892add','state changed','OS::Neutron::Subnet',NULL,101),(498,'09e49be7-6a9c-4bd8-8796-20b2f743f150','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:14',NULL,'DELETE','COMPLETE','subnet','f0844e3c-8182-4208-8104-2fa8b4457955','state changed','OS::Neutron::Subnet',NULL,82),(499,'6fc660af-f453-4c21-80bc-4cca7aeadd93','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:14',NULL,'DELETE','IN_PROGRESS','net','b9c02741-791c-45c3-b569-18504f1c1de0','state changed','OS::Neutron::Net',NULL,79),(500,'459b29a2-78ce-4f02-9e05-ab148ef78cf2','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:14',NULL,'CREATE','COMPLETE','sub_port_two','d0d0b958-396c-4bc1-9b7f-b0c0a14215e5','state changed','OS::Neutron::Port',NULL,110),(501,'785f11bc-2434-47ce-bcb2-cb7876e7a19d','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:14',NULL,'DELETE','COMPLETE','subnet','3cbfa44b-95b4-4246-8a7a-16252c892add','state changed','OS::Neutron::Subnet',NULL,101),(502,'1e42fc3b-74bf-4a78-bedc-ae8af2ec3e60','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:14',NULL,'CREATE','COMPLETE','parent_port','b31f7931-85c6-4bb6-9dab-6a6d57053d48','state changed','OS::Neutron::Port',NULL,109),(503,'354dfc82-89b4-4ba7-90e6-ee3c59c96cd4','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:14',NULL,'DELETE','IN_PROGRESS','net','8727a630-00b6-4187-aa8b-97105d8fa27e','state changed','OS::Neutron::Net',NULL,NULL),(504,'9a4c2624-bb6b-417d-9944-9f42d3b4484d','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:15',NULL,'CREATE','COMPLETE','trunk_subnet_one','099f49c7-7db6-4e96-b183-af361eb0c8f6','state changed','OS::Neutron::Subnet',NULL,108),(505,'cd9280e9-f3d3-48bb-bd70-58bf4c88776d','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:15',NULL,'DELETE','COMPLETE','net','b9c02741-791c-45c3-b569-18504f1c1de0','state changed','OS::Neutron::Net',NULL,79),(506,'72d16fbf-0c32-4b9a-a317-62f3afded373','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:15',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1305200445-sub_port_one-ku22wzkuei73','state changed','OS::Neutron::Port',NULL,112),(507,'a63ec7f6-89b6-47e4-a037-44930622b3de','dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:52:15',NULL,'DELETE','COMPLETE','same_fixed_ip','dd746e70-9c55-42ac-ba85-b733929725a2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(508,'98b82f68-a721-4c5e-966f-475f6e2937b9','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:16',NULL,'DELETE','COMPLETE','net','8727a630-00b6-4187-aa8b-97105d8fa27e','state changed','OS::Neutron::Net',NULL,NULL),(509,'64829856-9ac1-460a-88ee-15aef9696189','692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:16',NULL,'DELETE','COMPLETE','UpdateSubnetTest-1871972168','692c6768-914c-48ab-aaa6-97f017665ebe','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(510,'9a1676ec-dd6d-425a-9db7-35625f805117','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:16',NULL,'CREATE','COMPLETE','sub_port_one','962ea677-2d06-44f9-802a-45358f45646c','state changed','OS::Neutron::Port',NULL,112),(511,'c45d8975-3bb4-4641-a1cc-4c93a2d28fe0','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:17',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1305200445-trunk-lrasnaoxhroa','state changed','OS::Neutron::Trunk',NULL,113),(512,'bd9a4017-306c-4650-b52a-8fc290c5ba70','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:21',NULL,'CREATE','COMPLETE','trunk','913639b9-c60b-4a11-9066-22690070d208','state changed','OS::Neutron::Trunk',NULL,113),(513,'cea89a79-495a-464c-9bfe-26736934f81a','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:21',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(514,'5adeb41a-d311-4ad0-87f8-cbcdf07b6b71','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:22',NULL,'CREATE','IN_PROGRESS','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(515,'3371283b-b131-4d86-a331-9e68700fbe92','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:22',NULL,'CREATE','IN_PROGRESS','net','add_subnet-net-lz3ewu5pj5ve','state changed','OS::Neutron::Net',NULL,114),(516,'a257cc8a-8820-408f-9796-f96ce7604637','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:25',NULL,'CREATE','COMPLETE','net','36e46566-9455-4a78-b79a-3825f4dc1885','state changed','OS::Neutron::Net',NULL,114),(517,'2700e0b5-0640-4194-9549-46de2085ce47','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:25',NULL,'CREATE','IN_PROGRESS','subnet','add_subnet-subnet-qdedyrnbvrxe','state changed','OS::Neutron::Subnet',NULL,115),(518,'afac2c64-8fc6-446b-9627-f37da075be2e','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:26',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(519,'c6b042d2-a7ff-4666-a216-b74fd3ae9b1b','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:29',NULL,'CREATE','COMPLETE','subnet','1b6e61bd-dca4-4f9e-93b7-059a6e2830da','state changed','OS::Neutron::Subnet',NULL,115),(520,'cc44277e-c9f6-46e2-9452-c0d98973f652','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:29',NULL,'CREATE','IN_PROGRESS','server','add_subnet-server-tartzg3jnblf','state changed','OS::Nova::Server',NULL,116),(521,'6cc6d55a-229d-460e-a206-cbc18cc604f7','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:31',NULL,'UPDATE','IN_PROGRESS','trunk','913639b9-c60b-4a11-9066-22690070d208','state changed','OS::Neutron::Trunk',NULL,113),(522,'b819b2a6-5b3b-45ba-80ab-63e8b691d0e5','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:33',NULL,'UPDATE','COMPLETE','trunk','913639b9-c60b-4a11-9066-22690070d208','state changed','OS::Neutron::Trunk',NULL,117),(523,'e4d0644f-e1c6-4f5f-a579-464bc4943675','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:34',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(524,'8a446df8-370f-4765-98d4-f45866ce3e77','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:34',NULL,'CREATE','COMPLETE','server','7c6aeaf2-6e53-4789-bdd6-5ea85ac7d3e1','state changed','OS::Nova::Server',NULL,107),(525,'1ce283d7-ce14-4c0b-bb6e-bf2dde31c555','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:34',NULL,'CREATE','COMPLETE','server_with_sub_ip','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(526,'5a4f9a19-8779-4f24-95cf-dc9ca3e47f84','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:36',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(527,'67e85605-e011-4275-a864-12553f7151fd','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:36',NULL,'DELETE','IN_PROGRESS','trunk','913639b9-c60b-4a11-9066-22690070d208','state changed','OS::Neutron::Trunk',NULL,117),(528,'ee15e56f-3942-424d-ab27-6f9a2e5a579c','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','COMPLETE','trunk','913639b9-c60b-4a11-9066-22690070d208','state changed','OS::Neutron::Trunk',NULL,117),(529,'d4df2dc3-9742-48a4-8881-35b8500b7990','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','IN_PROGRESS','parent_port','b31f7931-85c6-4bb6-9dab-6a6d57053d48','state changed','OS::Neutron::Port',NULL,109),(530,'ed80f9d1-d8d9-4a2f-a103-45151a8b62b1','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','IN_PROGRESS','sub_port_one','962ea677-2d06-44f9-802a-45358f45646c','state changed','OS::Neutron::Port',NULL,112),(531,'f1d97000-aaee-4c88-903b-39fb41e2228f','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','IN_PROGRESS','sub_port_two','d0d0b958-396c-4bc1-9b7f-b0c0a14215e5','state changed','OS::Neutron::Port',NULL,110),(532,'3dcf6feb-b61c-4671-aa00-f822762c8930','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','COMPLETE','parent_port','b31f7931-85c6-4bb6-9dab-6a6d57053d48','state changed','OS::Neutron::Port',NULL,109),(533,'3620a587-2bcf-4663-8a89-67eb80dd3941','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','IN_PROGRESS','parent_subnet','a10076f1-6120-4536-83f9-0292089b30c3','state changed','OS::Neutron::Subnet',NULL,105),(534,'d127f579-e21d-4051-8216-1fb5cbcf8289','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','COMPLETE','sub_port_one','962ea677-2d06-44f9-802a-45358f45646c','state changed','OS::Neutron::Port',NULL,112),(535,'2cc68588-82ac-418c-91b3-e9caf7b0bc90','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:37',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','099f49c7-7db6-4e96-b183-af361eb0c8f6','state changed','OS::Neutron::Subnet',NULL,108),(536,'62269940-1720-4f15-91fa-67cd1b608c95','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','COMPLETE','sub_port_two','d0d0b958-396c-4bc1-9b7f-b0c0a14215e5','state changed','OS::Neutron::Port',NULL,110),(537,'fc034aa7-255d-4a5b-9273-9bf1f0612010','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','43cefa5b-6b0d-413d-9314-1eadff5c711d','state changed','OS::Neutron::Subnet',NULL,106),(538,'b2322f14-4361-46f3-8382-1a7f500f7fa1','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','COMPLETE','parent_subnet','a10076f1-6120-4536-83f9-0292089b30c3','state changed','OS::Neutron::Subnet',NULL,105),(539,'a17e3dc4-c159-4e45-b076-8da5fa9d69b4','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','IN_PROGRESS','parent_net','6f8f6475-0be5-48db-b659-09adad2433f1','state changed','OS::Neutron::Net',NULL,NULL),(540,'1dd6085b-7806-45ac-9674-ecf52dcc0fc6','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','COMPLETE','trunk_subnet_one','099f49c7-7db6-4e96-b183-af361eb0c8f6','state changed','OS::Neutron::Subnet',NULL,108),(541,'577148ab-7460-4af6-9e00-0b9282e9a57f','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:38',NULL,'DELETE','IN_PROGRESS','trunk_net_one','5abea305-33d2-41d2-a794-5efe8b8004c2','state changed','OS::Neutron::Net',NULL,NULL),(542,'a3ecb1c1-1c42-474f-b3b0-11058f51100c','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:39',NULL,'DELETE','COMPLETE','trunk_subnet_two','43cefa5b-6b0d-413d-9314-1eadff5c711d','state changed','OS::Neutron::Subnet',NULL,106),(543,'89f596d8-0945-43a1-a7dc-d89961e25d5a','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:39',NULL,'DELETE','IN_PROGRESS','trunk_net_two','6625097a-abed-4c42-88e4-8e10be907580','state changed','OS::Neutron::Net',NULL,NULL),(544,'b412c66b-dd53-49fd-9c44-dec81f7fa4d9','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:39',NULL,'DELETE','COMPLETE','parent_net','6f8f6475-0be5-48db-b659-09adad2433f1','state changed','OS::Neutron::Net',NULL,NULL),(545,'293fc9af-1d47-4f00-bd73-fd24ed8b4aa0','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:39',NULL,'DELETE','COMPLETE','trunk_net_one','5abea305-33d2-41d2-a794-5efe8b8004c2','state changed','OS::Neutron::Net',NULL,NULL),(546,'43520b0d-1851-4286-bb79-0799eb5dce02','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:40',NULL,'DELETE','COMPLETE','trunk_net_two','6625097a-abed-4c42-88e4-8e10be907580','state changed','OS::Neutron::Net',NULL,NULL),(547,'90f95089-5575-4bcb-9d21-bce7a8dce40f','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:40',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1305200445','434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(548,'c316bead-873f-4614-b4a1-dddb54c4a130','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:41',NULL,'DELETE','IN_PROGRESS','server_with_sub_ip','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(549,'afa836ff-d854-4c1d-a778-d6f97a41e86c','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:41',NULL,'DELETE','IN_PROGRESS','server','7c6aeaf2-6e53-4789-bdd6-5ea85ac7d3e1','state changed','OS::Nova::Server',NULL,107),(550,'13356152-deb0-4727-a597-4d357eb71ef8','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:43',NULL,'CREATE','COMPLETE','server','192d0408-d215-4920-b298-14c06fb988f3','state changed','OS::Nova::Server',NULL,116),(551,'73ab19c2-5486-4aa5-8b19-104299f2988a','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:43',NULL,'CREATE','COMPLETE','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(552,'a1af62e4-19c5-4e9c-bd50-b56078567805','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:43',NULL,'DELETE','COMPLETE','server','7c6aeaf2-6e53-4789-bdd6-5ea85ac7d3e1','state changed','OS::Nova::Server',NULL,107),(553,'076296ab-808a-495a-8279-327b76677db7','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:43',NULL,'DELETE','IN_PROGRESS','security_group','b3802cf5-62c1-4792-88d5-51268e8062a8','state changed','OS::Neutron::SecurityGroup',NULL,102),(554,'ec7c9607-7098-4ebc-a03a-325035b711e2','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:43',NULL,'DELETE','IN_PROGRESS','subnet','c8d766dd-96c3-4e9f-a64c-8a23548b368a','state changed','OS::Neutron::Subnet',NULL,103),(555,'4f04df3e-7360-4bdc-9a1d-1ad30e0e5fe6','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:44',NULL,'DELETE','COMPLETE','subnet','c8d766dd-96c3-4e9f-a64c-8a23548b368a','state changed','OS::Neutron::Subnet',NULL,103),(556,'e2297178-4ccf-4aa2-a0db-bc7a4ed9a407','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:44',NULL,'DELETE','IN_PROGRESS','net','9946ec75-e13d-4e17-b4c5-b003ff9c0eb1','state changed','OS::Neutron::Net',NULL,100),(557,'a86e5823-8741-4c6c-9fbf-030cb81478cd','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:45',NULL,'DELETE','COMPLETE','net','9946ec75-e13d-4e17-b4c5-b003ff9c0eb1','state changed','OS::Neutron::Net',NULL,100),(558,'8cc2fa96-c7d1-4a84-bc0e-a53454989847','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:46',NULL,'DELETE','COMPLETE','security_group','b3802cf5-62c1-4792-88d5-51268e8062a8','state changed','OS::Neutron::SecurityGroup',NULL,102),(559,'ebb8e890-651a-407c-b41f-252f8f3137da','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:46',NULL,'DELETE','COMPLETE','server_with_sub_ip','4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(560,'dc97daa3-789f-4d02-a9ee-9c953c6dac4b','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:46',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(561,'3331823a-deb9-411e-b6d3-8e607d6c175e','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:46',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-770074732-trunk_net_two-yulmokx6jlfm','state changed','OS::Neutron::Net',NULL,NULL),(562,'c94eabe3-d0f7-44da-9bbd-65d7c60b23fe','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:47',NULL,'UPDATE','IN_PROGRESS','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(563,'8cc48b69-02c3-439a-9e5f-2bc2cbed4a1f','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:47',NULL,'CREATE','COMPLETE','trunk_net_two','ddedf93a-7af8-4327-b743-55e99db3ac9e','state changed','OS::Neutron::Net',NULL,NULL),(564,'359a66a4-3563-4b65-8644-2e2558761333','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:47',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-770074732-trunk_subnet_two-pfd2ehrx3dh5','state changed','OS::Neutron::Subnet',NULL,121),(565,'e2e162d6-2a34-4609-8c49-562ad6e46bb8','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:47',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-770074732-parent_net-d2sx3vpnqjke','state changed','OS::Neutron::Net',NULL,NULL),(566,'b99586af-0190-488b-bab2-1caac4c887b7','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:48',NULL,'UPDATE','IN_PROGRESS','server','192d0408-d215-4920-b298-14c06fb988f3','state changed','OS::Nova::Server',NULL,116),(567,'e78f3de4-214c-4ec0-b9ce-dc3d2743ea9d','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:48',NULL,'CREATE','COMPLETE','trunk_subnet_two','7391d192-a161-499b-b733-991f3958f820','state changed','OS::Neutron::Subnet',NULL,121),(568,'4b0d9e7e-7197-43de-808f-a4da95059470','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:48',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-770074732-trunk_net_one-smaidkgubhdf','state changed','OS::Neutron::Net',NULL,NULL),(569,'9bbd2f0e-38b6-472a-b526-39f4db07be60','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:48',NULL,'CREATE','COMPLETE','parent_net','2c3cee5c-8203-4536-a5e6-897b5dd97c37','state changed','OS::Neutron::Net',NULL,NULL),(570,'68129d2f-f876-47c7-bcde-e6db16327171','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:48',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-770074732-sub_port_two-j4voag4ghdcn','state changed','OS::Neutron::Port',NULL,122),(571,'da2afd49-16e7-4e55-84d5-23aa7b1ae33d','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:48',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-770074732-parent_subnet-hurnabh7bexo','state changed','OS::Neutron::Subnet',NULL,123),(572,'1da0b486-e24d-4388-9211-c5896423edfc','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:50',NULL,'CREATE','COMPLETE','trunk_net_one','b359bb9a-48d1-471e-b6be-82aa4a43ca3a','state changed','OS::Neutron::Net',NULL,NULL),(573,'548623d9-9dd2-4aee-add7-ee60d6816a4a','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:51',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-770074732-trunk_subnet_one-fxtusyqhbola','state changed','OS::Neutron::Subnet',NULL,124),(574,'22443473-05c3-45e5-990b-8e20846aba8a','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:51',NULL,'CREATE','COMPLETE','sub_port_two','e2d16f82-d665-4863-8c8c-56a414e8148f','state changed','OS::Neutron::Port',NULL,122),(575,'6814c745-b3a8-40c0-952f-007bea3b37d9','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:51',NULL,'CREATE','COMPLETE','parent_subnet','bb550079-93c2-4d7e-a91e-648fa8cd0c83','state changed','OS::Neutron::Subnet',NULL,123),(576,'ef70ab1b-e9ba-4d9c-88cb-16ca9e0afec6','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:52',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-770074732-parent_port-7mehqgx6xmbn','state changed','OS::Neutron::Port',NULL,125),(577,'00b3fd60-d2fa-4437-87e5-d2e4766451ca','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:52',NULL,'CREATE','IN_PROGRESS','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(578,'dbf42aac-9987-48eb-b2f4-fbed776730c9','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:52',NULL,'CREATE','IN_PROGRESS','net','create_server_with_sub_ip-net-ee3raxk73vry','state changed','OS::Neutron::Net',NULL,126),(579,'b1088f59-ae57-4c52-ba08-521cf903930c','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:52',NULL,'UPDATE','COMPLETE','server','192d0408-d215-4920-b298-14c06fb988f3','state changed','OS::Nova::Server',NULL,127),(580,'76427986-e27d-442f-bfaf-45d01cc8da4a','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:52',NULL,'UPDATE','COMPLETE','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(581,'0d90882f-5dc8-42fe-a4d8-4d4c7ac36f3d','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:52',NULL,'CREATE','COMPLETE','trunk_subnet_one','30e249c7-877e-40ca-9f3d-66f563290c53','state changed','OS::Neutron::Subnet',NULL,124),(582,'34901784-0c44-48bf-ad80-47d67362f807','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:52',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-770074732-sub_port_one-4dcxm7kktsk4','state changed','OS::Neutron::Port',NULL,128),(583,'171d5cd8-5402-45b1-b8b8-78fee38e05bb','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:53',NULL,'CREATE','COMPLETE','net','f14c6b8d-dd7e-4018-a7a4-009f8f8f4f3e','state changed','OS::Neutron::Net',NULL,126),(584,'afb1b6d6-8171-4298-83be-fe38d7647f96','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:53',NULL,'CREATE','COMPLETE','parent_port','788d4dc1-d8ce-4dc8-9ef2-2b0b5f507253','state changed','OS::Neutron::Port',NULL,125),(585,'2298a2cb-e88a-4ac8-87db-a86cf515b3bb','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:53',NULL,'CREATE','IN_PROGRESS','subnet_b','create_server_with_sub_ip-subnet_b-pb3bqeniaik3','state changed','OS::Neutron::Subnet',NULL,129),(586,'a561486e-a14f-4347-bee9-e2bd41e89501','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:53',NULL,'CREATE','IN_PROGRESS','subnet_a','create_server_with_sub_ip-subnet_a-gih56cyuk7is','state changed','OS::Neutron::Subnet',NULL,130),(587,'dfece56d-58c3-45dc-b527-a5b6298b4b3a','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:54',NULL,'CREATE','COMPLETE','sub_port_one','bdb15712-3672-435b-8201-b6f373e495ec','state changed','OS::Neutron::Port',NULL,128),(588,'3c88252b-e445-4acf-99b6-9c118b97cbe1','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:54',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-770074732-trunk-4ezsv7ta4776','state changed','OS::Neutron::Trunk',NULL,131),(589,'1e8037d8-c65c-4b6f-997c-fa29cd9b3ae9','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:54',NULL,'CREATE','COMPLETE','subnet_a','12222ae5-779b-4e02-9da8-8957d6cc6c5e','state changed','OS::Neutron::Subnet',NULL,130),(590,'e68dbe2c-3fe0-40fc-afc1-718513d66ad7','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:54',NULL,'CREATE','COMPLETE','subnet_b','ee3f81f3-5396-4fd6-90ec-6960e3aa09a0','state changed','OS::Neutron::Subnet',NULL,129),(591,'731c399e-f97a-41d9-bea9-f9028ba83814','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:54',NULL,'CREATE','IN_PROGRESS','server','create_server_with_sub_ip-server-y5gorcv6htru','state changed','OS::Nova::Server',NULL,132),(592,'11d848ae-72ee-42a7-8ff1-6fda32abd6bb','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:55',NULL,'CREATE','COMPLETE','trunk','4f01fdc1-3792-4f04-b912-34e53b4271ab','state changed','OS::Neutron::Trunk',NULL,131),(593,'2175a7b3-adf6-45c1-93c9-058053716b27','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:55',NULL,'CREATE','COMPLETE','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(594,'d5f0f967-8e8e-4924-8eae-d6cab03e3426','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:57',NULL,'DELETE','IN_PROGRESS','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(595,'cb2e3aee-a819-4143-a6a3-db0eec25b710','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:57',NULL,'DELETE','IN_PROGRESS','server','192d0408-d215-4920-b298-14c06fb988f3','state changed','OS::Nova::Server',NULL,127),(596,'af6f46ef-72c2-45c2-b6a7-4c3aaaa89a24','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:59',NULL,'DELETE','COMPLETE','server','192d0408-d215-4920-b298-14c06fb988f3','state changed','OS::Nova::Server',NULL,127),(597,'9158e519-c957-4f1a-9abb-2a304f26fb19','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:59',NULL,'DELETE','IN_PROGRESS','subnet','1b6e61bd-dca4-4f9e-93b7-059a6e2830da','state changed','OS::Neutron::Subnet',NULL,115),(598,'cf765864-cf84-4244-8c00-71e7835aa762','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:59',NULL,'DELETE','COMPLETE','subnet','1b6e61bd-dca4-4f9e-93b7-059a6e2830da','state changed','OS::Neutron::Subnet',NULL,115),(599,'fc2b21c7-4772-492d-9acd-3196204479bb','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:59',NULL,'DELETE','IN_PROGRESS','net','36e46566-9455-4a78-b79a-3825f4dc1885','state changed','OS::Neutron::Net',NULL,114),(600,'917238f7-d057-454f-94d3-8d3a52730272','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:00',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(601,'4703782b-16c4-414d-99ee-e41378adea79','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:53:00',NULL,'DELETE','COMPLETE','net','36e46566-9455-4a78-b79a-3825f4dc1885','state changed','OS::Neutron::Net',NULL,114),(602,'28dc2905-6846-4620-b5c9-1278d876d43e','90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:53:00',NULL,'DELETE','COMPLETE','add_subnet','90cd326a-058b-4800-bc61-ae1230c15e72','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(603,'df7e739f-c85c-477e-9afe-122f8d30625c','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:04',NULL,'CREATE','IN_PROGRESS','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(604,'498d3390-dcbf-4fe8-9038-105f6e914ef2','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:04',NULL,'UPDATE','IN_PROGRESS','trunk','4f01fdc1-3792-4f04-b912-34e53b4271ab','state changed','OS::Neutron::Trunk',NULL,131),(605,'9b98d435-f1c9-4841-bc84-66daafc8c99a','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:04',NULL,'CREATE','IN_PROGRESS','net','multi_networks_swaps-net-az3x6bbpjr6n','state changed','OS::Neutron::Net',NULL,134),(606,'5c2cb76d-bacf-4ec9-97c6-1cd57ab6179b','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:07',NULL,'CREATE','COMPLETE','net','c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7','state changed','OS::Neutron::Net',NULL,134),(607,'d8a155d7-f623-42dc-819c-a912ee6622f7','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:07',NULL,'CREATE','IN_PROGRESS','subnet','multi_networks_swaps-subnet-ggn7j3cjtmt7','state changed','OS::Neutron::Subnet',NULL,135),(608,'507385d0-1f67-4dfd-bb5f-4098040db66d','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:08',NULL,'CREATE','COMPLETE','server','b234f355-bdde-430b-8c69-c0ab5379ca68','state changed','OS::Nova::Server',NULL,132),(609,'9cbfef12-37d6-423a-9a12-18033cd06499','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:08',NULL,'CREATE','COMPLETE','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(610,'91e62674-0445-4006-9fd0-d5c20861a43d','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:08',NULL,'UPDATE','COMPLETE','trunk','4f01fdc1-3792-4f04-b912-34e53b4271ab','state changed','OS::Neutron::Trunk',NULL,136),(611,'882aa5f1-8a3f-4cc7-a4f7-694560b5974e','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:09',NULL,'CREATE','COMPLETE','subnet','e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12','state changed','OS::Neutron::Subnet',NULL,135),(612,'d0f4a822-de95-445d-a158-7c5ae4a3e10e','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:09',NULL,'CREATE','IN_PROGRESS','server','multi_networks_swaps-server-ot574smgnyyp','state changed','OS::Nova::Server',NULL,137),(613,'248ea665-a6cd-4b72-8fb9-eb1a67867a5c','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:09',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(614,'1d96734b-25ce-470c-90ef-f5fe920b7525','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:15',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(615,'5f740e47-006a-47e4-8f17-5808a6d85c19','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:15',NULL,'DELETE','IN_PROGRESS','trunk','4f01fdc1-3792-4f04-b912-34e53b4271ab','state changed','OS::Neutron::Trunk',NULL,136),(616,'5dbc0d21-3dad-4667-add7-d79a6645ddcc','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:15',NULL,'UPDATE','IN_PROGRESS','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(617,'c16a4515-af1f-4dce-bd65-cc70c0b0e322','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:15',NULL,'DELETE','COMPLETE','trunk','4f01fdc1-3792-4f04-b912-34e53b4271ab','state changed','OS::Neutron::Trunk',NULL,136),(618,'0578b7db-252d-4244-906b-896c3bc12b96','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:15',NULL,'DELETE','IN_PROGRESS','parent_port','788d4dc1-d8ce-4dc8-9ef2-2b0b5f507253','state changed','OS::Neutron::Port',NULL,125),(619,'8701be6b-499e-4ec2-90ea-99b5148a2b3c','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:15',NULL,'DELETE','IN_PROGRESS','sub_port_one','bdb15712-3672-435b-8201-b6f373e495ec','state changed','OS::Neutron::Port',NULL,128),(620,'102b4a5e-fc75-4e78-af35-ec5bb03ce29a','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','IN_PROGRESS','sub_port_two','e2d16f82-d665-4863-8c8c-56a414e8148f','state changed','OS::Neutron::Port',NULL,122),(621,'e394dc37-aa5a-4efb-aac3-ed50f8f140f5','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','COMPLETE','sub_port_one','bdb15712-3672-435b-8201-b6f373e495ec','state changed','OS::Neutron::Port',NULL,128),(622,'123d02a2-92f0-455c-a505-383c9ce9c63b','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:16',NULL,'UPDATE','IN_PROGRESS','server','b234f355-bdde-430b-8c69-c0ab5379ca68','state changed','OS::Nova::Server',NULL,132),(623,'b6ab5588-f2fe-4a54-a01b-ee175ea4e5a4','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','30e249c7-877e-40ca-9f3d-66f563290c53','state changed','OS::Neutron::Subnet',NULL,124),(624,'b08c003a-4de5-4104-a136-8a96f0d73261','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','COMPLETE','sub_port_two','e2d16f82-d665-4863-8c8c-56a414e8148f','state changed','OS::Neutron::Port',NULL,122),(625,'37275ba2-fc3f-45b3-937e-d1ae00d5d9b0','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','COMPLETE','parent_port','788d4dc1-d8ce-4dc8-9ef2-2b0b5f507253','state changed','OS::Neutron::Port',NULL,125),(626,'ac9d67c3-10f6-4553-b0e1-2b68a3d2ca5b','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','IN_PROGRESS','parent_subnet','bb550079-93c2-4d7e-a91e-648fa8cd0c83','state changed','OS::Neutron::Subnet',NULL,123),(627,'b7918551-88a7-4e6e-8f9c-f634f3140296','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:16',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','7391d192-a161-499b-b733-991f3958f820','state changed','OS::Neutron::Subnet',NULL,121),(628,'09009b62-3b80-47d8-ae01-9fa6df96f9b3','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:17',NULL,'DELETE','COMPLETE','trunk_subnet_one','30e249c7-877e-40ca-9f3d-66f563290c53','state changed','OS::Neutron::Subnet',NULL,124),(629,'f2dad57d-9edd-42bc-8f0e-2278d5c961f6','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:17',NULL,'DELETE','IN_PROGRESS','trunk_net_one','b359bb9a-48d1-471e-b6be-82aa4a43ca3a','state changed','OS::Neutron::Net',NULL,NULL),(630,'8537b62c-0856-4531-85fe-ee06ea166747','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:18',NULL,'DELETE','COMPLETE','trunk_subnet_two','7391d192-a161-499b-b733-991f3958f820','state changed','OS::Neutron::Subnet',NULL,121),(631,'df12cd79-4a83-447f-9650-2ac3a3f8db04','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:18',NULL,'DELETE','IN_PROGRESS','trunk_net_two','ddedf93a-7af8-4327-b743-55e99db3ac9e','state changed','OS::Neutron::Net',NULL,NULL),(632,'dd64a010-c7d3-4e4f-b729-cab62e243e93','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:19',NULL,'DELETE','COMPLETE','parent_subnet','bb550079-93c2-4d7e-a91e-648fa8cd0c83','state changed','OS::Neutron::Subnet',NULL,123),(633,'34a568bb-72b0-492a-87bd-01a1f083f1d9','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:19',NULL,'DELETE','IN_PROGRESS','parent_net','2c3cee5c-8203-4536-a5e6-897b5dd97c37','state changed','OS::Neutron::Net',NULL,NULL),(634,'354fb229-a862-46fd-8ddf-60da4880337f','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:19',NULL,'DELETE','COMPLETE','trunk_net_one','b359bb9a-48d1-471e-b6be-82aa4a43ca3a','state changed','OS::Neutron::Net',NULL,NULL),(635,'cf66cb33-495b-4c65-b978-29164e792765','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:20',NULL,'DELETE','COMPLETE','trunk_net_two','ddedf93a-7af8-4327-b743-55e99db3ac9e','state changed','OS::Neutron::Net',NULL,NULL),(636,'03e3203a-9dd5-4741-98f5-17a3de3a84ce','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:21',NULL,'DELETE','COMPLETE','parent_net','2c3cee5c-8203-4536-a5e6-897b5dd97c37','state changed','OS::Neutron::Net',NULL,NULL),(637,'7bfb3522-ccb1-4da1-925e-eb8a98f16292','f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:53:21',NULL,'DELETE','COMPLETE','UpdateTrunkTest-770074732','f0d274a8-82a4-42b6-9f57-390d1f313689','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(638,'d449ef47-2c63-45f0-ac0b-40e7d836ac3a','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:25',NULL,'CREATE','IN_PROGRESS','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(639,'7363e52c-5c34-44d6-a901-1d86cbcf086a','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:25',NULL,'CREATE','IN_PROGRESS','trunk_net_one','UpdateTrunkTest-1377681932-trunk_net_one-alxtzbfxvb33','state changed','OS::Neutron::Net',NULL,NULL),(640,'0824a0b7-22ba-4960-b537-360b55fba9d7','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:26',NULL,'CREATE','IN_PROGRESS','trunk_net_two','UpdateTrunkTest-1377681932-trunk_net_two-eyuyyrmiinp7','state changed','OS::Neutron::Net',NULL,NULL),(641,'ee5d9c54-9e04-453a-85e9-0e7405083bee','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:27',NULL,'CREATE','IN_PROGRESS','parent_net','UpdateTrunkTest-1377681932-parent_net-tncwpxygnbtz','state changed','OS::Neutron::Net',NULL,NULL),(642,'7e5f47fc-d8be-48f7-be2e-a21ca4002774','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:27',NULL,'CREATE','COMPLETE','trunk_net_one','d7a29abf-67fc-490b-83c6-0af9f521d6fd','state changed','OS::Neutron::Net',NULL,NULL),(643,'52172cce-e634-4b9e-8e59-a9d7dafa5b13','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:27',NULL,'CREATE','IN_PROGRESS','trunk_subnet_one','UpdateTrunkTest-1377681932-trunk_subnet_one-wf3on6fusozn','state changed','OS::Neutron::Subnet',NULL,140),(644,'00bdd381-c883-4699-b9f5-508ff1759014','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:28',NULL,'CREATE','COMPLETE','trunk_net_two','beb5caa3-a9b8-4dac-859b-b6fd566e14f4','state changed','OS::Neutron::Net',NULL,NULL),(645,'99d5b065-9b12-4254-83c4-d429fb686d34','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:28',NULL,'CREATE','IN_PROGRESS','trunk_subnet_two','UpdateTrunkTest-1377681932-trunk_subnet_two-2x5ebcbaqybn','state changed','OS::Neutron::Subnet',NULL,141),(646,'a316c7fe-b5de-4f99-a28c-8dd549cb9bf7','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:28',NULL,'CREATE','COMPLETE','parent_net','36118700-e1af-4580-93c2-0ff000e015c0','state changed','OS::Neutron::Net',NULL,NULL),(647,'5a062d9a-7210-45ae-90fc-b3c68e116efb','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:28',NULL,'CREATE','IN_PROGRESS','parent_subnet','UpdateTrunkTest-1377681932-parent_subnet-6xrm4pfey6yb','state changed','OS::Neutron::Subnet',NULL,142),(648,'26ecaa9f-be88-4ad1-9a9b-289f142f18b7','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:30',NULL,'CREATE','COMPLETE','trunk_subnet_one','a37b13e2-83ae-43f4-b59a-43a4ebdee5a3','state changed','OS::Neutron::Subnet',NULL,140),(649,'f716b284-ffbe-4969-9821-5f3e990621c3','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:30',NULL,'CREATE','IN_PROGRESS','sub_port_one','UpdateTrunkTest-1377681932-sub_port_one-v3evje2plgg5','state changed','OS::Neutron::Port',NULL,143),(650,'07c3cb7f-2b53-43ac-a36d-5e091a152f8b','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:30',NULL,'CREATE','COMPLETE','parent_subnet','ab590d8a-27c8-48ac-9f61-9ad0360ec910','state changed','OS::Neutron::Subnet',NULL,142),(651,'7400d00a-2ab7-41b4-966a-c13cca392be5','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:30',NULL,'CREATE','IN_PROGRESS','parent_port','UpdateTrunkTest-1377681932-parent_port-dnu2zv4jt7bf','state changed','OS::Neutron::Port',NULL,144),(652,'cc67d90a-5f0e-4615-b14c-310c4bd951f9','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:31',NULL,'CREATE','COMPLETE','trunk_subnet_two','8cc6a1be-66fa-4f4a-a211-bd311e44dc0c','state changed','OS::Neutron::Subnet',NULL,141),(653,'ef9e9e31-9baa-4ed8-8104-528f6edb0daa','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:31',NULL,'CREATE','IN_PROGRESS','sub_port_two','UpdateTrunkTest-1377681932-sub_port_two-rga4njsys4km','state changed','OS::Neutron::Port',NULL,145),(654,'e64fa347-0e5e-4058-88f9-41a07bd2c6de','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:31',NULL,'CREATE','COMPLETE','sub_port_one','fcdea190-b981-4211-9d1b-00359e53e3df','state changed','OS::Neutron::Port',NULL,143),(655,'ce66db0c-2892-4ff7-99d5-30c09bb5254f','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:31',NULL,'CREATE','COMPLETE','parent_port','f6b93916-5fbd-4b46-b50b-e96d65699d38','state changed','OS::Neutron::Port',NULL,144),(656,'f8564edc-9578-42cd-b160-1f19413a5752','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:32',NULL,'CREATE','IN_PROGRESS','trunk','UpdateTrunkTest-1377681932-trunk-2zg7coemapmr','state changed','OS::Neutron::Trunk',NULL,146),(657,'a8a25a8c-7c62-43b6-af52-926c4ccc82f0','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:33',NULL,'CREATE','COMPLETE','sub_port_two','0d37e77d-7bce-4d27-baca-1fb606270003','state changed','OS::Neutron::Port',NULL,145),(658,'1fe1cb79-f362-4489-8cca-76fe1e51e53b','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:33',NULL,'CREATE','COMPLETE','trunk','fffe749f-b6a0-47d4-a4a1-fa005c692dfe','state changed','OS::Neutron::Trunk',NULL,146),(659,'cfcfcd6b-72ab-476a-a67c-048534d0212a','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:33',NULL,'CREATE','COMPLETE','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(660,'93852dbb-c970-46f8-9f43-2f78f3c5290e','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:34',NULL,'UPDATE','IN_PROGRESS','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(661,'dbd95226-8788-45fb-9fbd-2ca21256275f','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:36',NULL,'UPDATE','COMPLETE','server','b234f355-bdde-430b-8c69-c0ab5379ca68','state changed','OS::Nova::Server',NULL,147),(662,'0e24c477-388a-41a3-8eb9-c2edf72247ba','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:36',NULL,'UPDATE','COMPLETE','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(663,'cf67a0fb-808d-4109-9585-9e697ba27ad1','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:38',NULL,'UPDATE','IN_PROGRESS','trunk','fffe749f-b6a0-47d4-a4a1-fa005c692dfe','state changed','OS::Neutron::Trunk',NULL,146),(664,'16e0d0fd-bf31-47e8-b47f-0a757abb1704','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:38',NULL,'UPDATE','COMPLETE','trunk','fffe749f-b6a0-47d4-a4a1-fa005c692dfe','state changed','OS::Neutron::Trunk',NULL,148),(665,'a43686ec-b32b-460c-a2b3-b15353fcc6b2','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:38',NULL,'UPDATE','COMPLETE','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(666,'67907315-d784-4d7e-8fa5-9f0efe7e7139','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:41',NULL,'DELETE','IN_PROGRESS','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(667,'c7dc3050-03d2-413c-aab5-d1a1adf3e148','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:41',NULL,'DELETE','IN_PROGRESS','server','b234f355-bdde-430b-8c69-c0ab5379ca68','state changed','OS::Nova::Server',NULL,147),(668,'7045c15e-7020-43ae-964f-d3d195e45808','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:44',NULL,'DELETE','IN_PROGRESS','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(669,'089c626c-5e5a-4d27-be9c-57c5e2aa30b3','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:45',NULL,'DELETE','COMPLETE','server','b234f355-bdde-430b-8c69-c0ab5379ca68','state changed','OS::Nova::Server',NULL,147),(670,'dabc76dd-85ae-4019-8ccb-58304d0d8012','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:45',NULL,'DELETE','IN_PROGRESS','subnet_b','ee3f81f3-5396-4fd6-90ec-6960e3aa09a0','state changed','OS::Neutron::Subnet',NULL,129),(671,'124bf17b-2052-4319-9235-0681e9ea254e','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:45',NULL,'DELETE','IN_PROGRESS','subnet_a','12222ae5-779b-4e02-9da8-8957d6cc6c5e','state changed','OS::Neutron::Subnet',NULL,130),(672,'2e79838e-8d67-400e-9387-03b07bc50b03','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:45',NULL,'DELETE','IN_PROGRESS','sub_port_two','0d37e77d-7bce-4d27-baca-1fb606270003','state changed','OS::Neutron::Port',NULL,145),(673,'06d4052b-d79b-4b69-a7c6-4b703f1c5300','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:45',NULL,'CREATE','COMPLETE','server','6afcb61a-48c6-4d2a-8ff0-9918fdce97e3','state changed','OS::Nova::Server',NULL,137),(674,'ba8393dc-91c7-4b4d-9b21-3784677c730c','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:45',NULL,'CREATE','COMPLETE','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(675,'6187ca22-3324-417c-bbf9-1ef46f2bcc2d','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:45',NULL,'DELETE','COMPLETE','subnet_b','ee3f81f3-5396-4fd6-90ec-6960e3aa09a0','state changed','OS::Neutron::Subnet',NULL,129),(676,'a0bd646e-088c-490e-aad4-8772bafd9063','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:45',NULL,'DELETE','COMPLETE','subnet_a','12222ae5-779b-4e02-9da8-8957d6cc6c5e','state changed','OS::Neutron::Subnet',NULL,130),(677,'9a17a743-fc60-4e3a-b486-be6b6c4403ea','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:46',NULL,'DELETE','IN_PROGRESS','trunk','fffe749f-b6a0-47d4-a4a1-fa005c692dfe','state changed','OS::Neutron::Trunk',NULL,148),(678,'7ff0ee89-f671-4ad6-9499-9d1602df029f','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:46',NULL,'DELETE','IN_PROGRESS','net','f14c6b8d-dd7e-4018-a7a4-009f8f8f4f3e','state changed','OS::Neutron::Net',NULL,126),(679,'f3fd14b4-00ee-45b5-8a8b-15443f45a541','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:46',NULL,'DELETE','COMPLETE','sub_port_two','0d37e77d-7bce-4d27-baca-1fb606270003','state changed','OS::Neutron::Port',NULL,145),(680,'a4cae2ad-c0a6-482e-8cef-0e74b8a8cabc','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:47',NULL,'DELETE','IN_PROGRESS','trunk_subnet_two','8cc6a1be-66fa-4f4a-a211-bd311e44dc0c','state changed','OS::Neutron::Subnet',NULL,141),(681,'d39b6a1f-7d56-476b-b503-035122cb8da2','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:47',NULL,'DELETE','IN_PROGRESS','sub_port_one','fcdea190-b981-4211-9d1b-00359e53e3df','state changed','OS::Neutron::Port',NULL,143),(682,'59d7edac-0f01-47df-ae8f-9606833d5979','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:47',NULL,'DELETE','COMPLETE','trunk','fffe749f-b6a0-47d4-a4a1-fa005c692dfe','state changed','OS::Neutron::Trunk',NULL,148),(683,'94e09cb0-8c10-491b-b152-0a19fc5b04c1','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','IN_PROGRESS','parent_port','f6b93916-5fbd-4b46-b50b-e96d65699d38','state changed','OS::Neutron::Port',NULL,144),(684,'c9fefc00-7034-469c-a505-354577352de1','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','trunk_subnet_two','8cc6a1be-66fa-4f4a-a211-bd311e44dc0c','state changed','OS::Neutron::Subnet',NULL,141),(685,'e36e7f52-fb8a-48d1-96ae-bcfaa5e38c9a','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','IN_PROGRESS','trunk_net_two','beb5caa3-a9b8-4dac-859b-b6fd566e14f4','state changed','OS::Neutron::Net',NULL,NULL),(686,'49f56efb-5afb-4a6e-a6b2-cfcb50cfb629','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','net','f14c6b8d-dd7e-4018-a7a4-009f8f8f4f3e','state changed','OS::Neutron::Net',NULL,126),(687,'8fd76554-44ab-4928-a77a-e6a2a57fa77c','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','sub_port_one','fcdea190-b981-4211-9d1b-00359e53e3df','state changed','OS::Neutron::Port',NULL,143),(688,'5d412cb5-052c-4016-b02b-35c411e925ff','3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','create_server_with_sub_ip','3819d7a4-a93a-4915-83fa-803c95d59207','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(689,'d71f1fc2-f7ca-4379-a382-e2aa3fe3fcd1','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','IN_PROGRESS','trunk_subnet_one','a37b13e2-83ae-43f4-b59a-43a4ebdee5a3','state changed','OS::Neutron::Subnet',NULL,140),(690,'9f240c92-939b-4ce6-b546-371be6214be8','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','parent_port','f6b93916-5fbd-4b46-b50b-e96d65699d38','state changed','OS::Neutron::Port',NULL,144),(691,'622776d3-a2cd-4217-9a3c-904da87999bb','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','IN_PROGRESS','parent_subnet','ab590d8a-27c8-48ac-9f61-9ad0360ec910','state changed','OS::Neutron::Subnet',NULL,142),(692,'9eddd6cc-7d19-483c-92ce-71fdfb17425f','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:48',NULL,'DELETE','COMPLETE','trunk_net_two','beb5caa3-a9b8-4dac-859b-b6fd566e14f4','state changed','OS::Neutron::Net',NULL,NULL),(693,'dca54232-a0bb-41eb-a5ec-9d5dad4566b9','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:49',NULL,'DELETE','COMPLETE','trunk_subnet_one','a37b13e2-83ae-43f4-b59a-43a4ebdee5a3','state changed','OS::Neutron::Subnet',NULL,140),(694,'5b8dfd0e-9972-4591-ad99-bd7a511c0648','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:49',NULL,'DELETE','IN_PROGRESS','trunk_net_one','d7a29abf-67fc-490b-83c6-0af9f521d6fd','state changed','OS::Neutron::Net',NULL,NULL),(695,'16643ae9-9ed1-4de0-b424-c4cb2fcdd7cd','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:49',NULL,'DELETE','COMPLETE','parent_subnet','ab590d8a-27c8-48ac-9f61-9ad0360ec910','state changed','OS::Neutron::Subnet',NULL,142),(696,'8c7b4447-fbc4-44a1-943a-a7c8d3f06d39','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:49',NULL,'DELETE','IN_PROGRESS','parent_net','36118700-e1af-4580-93c2-0ff000e015c0','state changed','OS::Neutron::Net',NULL,NULL),(697,'f093914d-f417-4db3-adae-d3c17d9defb3','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:49',NULL,'DELETE','COMPLETE','trunk_net_one','d7a29abf-67fc-490b-83c6-0af9f521d6fd','state changed','OS::Neutron::Net',NULL,NULL),(698,'18687470-b9c1-4ef1-bb0f-6b5998331b9c','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:50',NULL,'DELETE','COMPLETE','parent_net','36118700-e1af-4580-93c2-0ff000e015c0','state changed','OS::Neutron::Net',NULL,NULL),(699,'13992664-f3cc-439b-831a-0f1b64904609','291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:50',NULL,'DELETE','COMPLETE','UpdateTrunkTest-1377681932','291dc099-8006-4f6a-a09e-e498237ef0c3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(700,'5693f345-fb74-4560-b699-bc96e1e20fa9','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:52',NULL,'UPDATE','IN_PROGRESS','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(701,'4bdbb686-9134-48ad-9b9e-cb5b5679e831','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:53',NULL,'UPDATE','IN_PROGRESS','server','6afcb61a-48c6-4d2a-8ff0-9918fdce97e3','state changed','OS::Nova::Server',NULL,137),(702,'550eaadf-d945-43ac-9aaf-44be27a82299','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-245063210','fc057844-c4c8-4d18-b6d4-5503f16c7c55','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(703,'62be4e00-1344-4cb4-a120-c689ba9622f7','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-245063210-test1-exbqnxbrcxd6','state changed','OS::Heat::TestResource',NULL,NULL),(704,'f6d6a4ec-e3a7-48af-a14f-46d5426ca9c8','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(705,'a908dea0-87fe-4808-ad56-b17da8a14c47','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(706,'7e2c9663-a814-44b6-9546-2a6bae53abc6','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'CREATE','COMPLETE','ExternalReferencesTest-245063210','fc057844-c4c8-4d18-b6d4-5503f16c7c55','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(707,'50060010-39e3-4046-aff7-bf33a410e49d','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:55',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-70146590','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(708,'2a094ced-5e14-47f7-b029-410df773306c','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:55',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-70146590-random1-yraw5nf6xshf','state changed','OS::Heat::RandomString',NULL,NULL),(709,'233af578-1ba5-47eb-a699-78a6a7577583','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:55',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-70146590-random1-yraw5nf6xshf','state changed','OS::Heat::RandomString',NULL,NULL),(710,'f4498f5b-af09-41fd-be94-e7497661ff32','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:55',NULL,'CREATE','COMPLETE','RemoteStackTest-70146590','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(711,'3a607b77-6872-46a3-be96-63f01019a78d','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:55',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-245063210','fc057844-c4c8-4d18-b6d4-5503f16c7c55','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(712,'6fe9115f-b60f-498a-a517-603a333abcee','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:56',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(713,'d0d86680-99ba-44c3-a428-5c2db71785d1','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:56',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(714,'4a0ba30e-9a4b-4932-b800-94bd97da92ba','fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:56',NULL,'DELETE','COMPLETE','ExternalReferencesTest-245063210','fc057844-c4c8-4d18-b6d4-5503f16c7c55','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(715,'4990fc67-14ee-46ab-a05e-39d711ad359a','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:56',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-70146590','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(716,'4aaab849-f375-498a-8044-baa6779f060f','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:56',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-70146590-random1-yraw5nf6xshf','state changed','OS::Heat::RandomString',NULL,NULL),(717,'b6a4287e-2b10-408a-bb5d-0e7d039ce012','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:56',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-70146590-random1-yraw5nf6xshf','state changed','OS::Heat::RandomString',NULL,NULL),(718,'19cc37ae-0f4a-45ef-96ad-134b2597b913','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:56',NULL,'DELETE','COMPLETE','RemoteStackTest-70146590','8a3c369a-a004-4745-bc5d-b7c0da7e0a21','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(719,'023f7836-629e-41c2-99fe-3905ebbff638','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:58',NULL,'UPDATE','COMPLETE','server','6afcb61a-48c6-4d2a-8ff0-9918fdce97e3','state changed','OS::Nova::Server',NULL,152),(720,'8803a9f8-b78d-412d-82d9-16e9a86b50f5','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:58',NULL,'UPDATE','COMPLETE','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(721,'112de2dc-dfb9-495a-b201-3132257eb17b','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:01',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(722,'d57d5d51-bbef-43e6-b723-c4fa42bb9d79','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:02',NULL,'ADOPT','IN_PROGRESS','test1','ExternalReferencesTest-423530269-test1-huadn6zb24rv','state changed','OS::Heat::TestResource',NULL,NULL),(723,'eea9b706-e751-4bc4-84e5-f8d15d32d561','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:02',NULL,'ADOPT','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(724,'064680c9-ca8a-4813-a875-41045b38fc34','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:02',NULL,'CHECK','COMPLETE','test1','foobar','CHECK not supported for OS::Heat::TestResource','OS::Heat::TestResource',NULL,NULL),(725,'8e655ec1-3215-46a0-9a01-bb42778af29a','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:02',NULL,'CREATE','COMPLETE','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(726,'f93c1052-a821-4614-b097-22cee6d2296f','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:02',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-108274908','ff278435-332f-47a4-93ae-9c9fc8f54517','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(727,'ceed62cf-84bc-4b1c-8d84-3261eae0d19b','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:02',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh','state changed','OS::Heat::Stack',NULL,153),(728,'ae1edda1-3f03-4963-961c-6abaed7026d3','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:03',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(729,'edb92126-10f2-4625-82af-12ab7d8561a4','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:03',NULL,'UPDATE','COMPLETE','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(730,'aadaefd5-9694-4314-b6f6-7b0dff15dca9','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:03',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh','f4295e51-2751-4bf3-91ee-d69a80500e3b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(731,'f596ea42-800f-4b56-a10b-b7500fac0994','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:03',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh-random1-huk2egc7h34m','state changed','OS::Heat::RandomString',NULL,NULL),(732,'8bc8dd42-0c3c-466f-8dde-25cc10e2a635','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:03',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh-random1-huk2egc7h34m','state changed','OS::Heat::RandomString',NULL,NULL),(733,'18da6ec7-e27f-4e6c-8af4-429308cce82d','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:03',NULL,'CREATE','COMPLETE','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh','f4295e51-2751-4bf3-91ee-d69a80500e3b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(734,'1cd1b8c8-dbf2-411d-944f-aeb06a19a542','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:04',NULL,'CREATE','COMPLETE','my_stack','f4295e51-2751-4bf3-91ee-d69a80500e3b','state changed','OS::Heat::Stack',NULL,153),(735,'59b98d86-922a-4dc3-8009-1bc117473e1c','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:04',NULL,'CREATE','COMPLETE','RemoteStackTest-108274908','ff278435-332f-47a4-93ae-9c9fc8f54517','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(736,'2a9ba778-fc9b-4967-b337-327de2cf5de0','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:05',NULL,'DELETE','IN_PROGRESS','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(737,'66157058-fa2e-470e-a524-72e53972fb06','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:05',NULL,'DELETE','IN_PROGRESS','server','6afcb61a-48c6-4d2a-8ff0-9918fdce97e3','state changed','OS::Nova::Server',NULL,152),(738,'b8567f3f-d7b8-4237-8bc8-82102356549b','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:08',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(739,'5abf5ace-0087-4109-8577-8fba8fac518d','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:08',NULL,'DELETE','IN_PROGRESS','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(740,'4815b0ce-4351-48a6-adf0-42fa4b696d6c','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:08',NULL,'DELETE','COMPLETE','test1','foobar','state changed','OS::Heat::TestResource',NULL,NULL),(741,'546170de-e307-4d1f-a88b-e9f410d390ff','3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:08',NULL,'DELETE','COMPLETE','ExternalReferencesTest-423530269','3036d6bf-2270-437f-96b4-f8139efcbc8a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(742,'1e622ff9-bdee-4500-b9c8-8f345acb8837','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:09',NULL,'DELETE','COMPLETE','server','6afcb61a-48c6-4d2a-8ff0-9918fdce97e3','state changed','OS::Nova::Server',NULL,152),(743,'b957c3b0-7ed3-4df6-b65c-d4f4cf3d67e5','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:09',NULL,'DELETE','IN_PROGRESS','subnet','e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12','state changed','OS::Neutron::Subnet',NULL,135),(744,'54bc7311-7393-450d-b7aa-35f3c3d6b57a','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:09',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-108274908','ff278435-332f-47a4-93ae-9c9fc8f54517','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(745,'1c176bdb-676e-4121-8fbd-f1d8e70eab94','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:09',NULL,'DELETE','IN_PROGRESS','my_stack','f4295e51-2751-4bf3-91ee-d69a80500e3b','state changed','OS::Heat::Stack',NULL,153),(746,'86300f44-bee8-4a4a-b28a-7cd618a32695','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:10',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh','f4295e51-2751-4bf3-91ee-d69a80500e3b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(747,'1480a54d-a7cd-4080-985c-9a27d5ed23d5','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:10',NULL,'DELETE','COMPLETE','subnet','e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12','state changed','OS::Neutron::Subnet',NULL,135),(748,'9a8cb7fb-d615-4896-93af-f962bf5a805a','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:10',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh-random1-huk2egc7h34m','state changed','OS::Heat::RandomString',NULL,NULL),(749,'53fde6f8-fbd7-4307-9e39-a4524203a22a','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:10',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh-random1-huk2egc7h34m','state changed','OS::Heat::RandomString',NULL,NULL),(750,'721b6472-00a1-433a-9dad-5a6b15ca9d3b','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:10',NULL,'DELETE','IN_PROGRESS','net','c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7','state changed','OS::Neutron::Net',NULL,134),(751,'34ea70ba-9fc8-419a-812e-8d02d0668773','f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:10',NULL,'DELETE','COMPLETE','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh','f4295e51-2751-4bf3-91ee-d69a80500e3b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(752,'430ec482-a4b2-4da8-96f5-63e995252651','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:10',NULL,'DELETE','COMPLETE','my_stack','f4295e51-2751-4bf3-91ee-d69a80500e3b','state changed','OS::Heat::Stack',NULL,153),(753,'998e0d71-06ad-4a93-9762-e383aa59a837','ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:10',NULL,'DELETE','COMPLETE','RemoteStackTest-108274908','ff278435-332f-47a4-93ae-9c9fc8f54517','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(754,'c95d5002-0957-4b03-966e-b18a9ce37c21','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:12',NULL,'DELETE','COMPLETE','net','c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7','state changed','OS::Neutron::Net',NULL,134),(755,'bc1ca6ef-dce7-47fe-8d9c-1d7ea1ef6f77','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:54:12',NULL,'DELETE','COMPLETE','multi_networks_swaps','5bb6ebc0-909b-4ba6-929d-9270b67d7f36','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(756,'4272fdfc-393b-4fc8-8ea5-8f6b3e4e523c','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:14',NULL,'CREATE','IN_PROGRESS','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(757,'8e690601-5c81-4cd4-b5f8-fac4ff4d2a9f','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:14',NULL,'CREATE','IN_PROGRESS','test1','ExternalReferencesTest-1222046502-test1-uwdpdd4nyx3f','state changed','OS::Heat::TestResource',NULL,NULL),(758,'e24db0bb-e1c3-4b93-9195-8b5b56bdd5e1','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:14',NULL,'CREATE','COMPLETE','test1','ExternalReferencesTest-1222046502-test1-uwdpdd4nyx3f','state changed','OS::Heat::TestResource',NULL,NULL),(759,'23cba1e6-cbb6-4e02-9518-1a609b70de74','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:14',NULL,'CREATE','COMPLETE','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(760,'638d2997-7fa3-4fa6-9af7-a6ecb9c62c00','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:15',NULL,'UPDATE','IN_PROGRESS','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(761,'a678f09e-250b-4696-bcd6-8b4f5aa90aa3','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:15',NULL,'UPDATE','FAILED','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Resource UPDATE failed: NotSupported: resources.test1: Update to property external_id of test1 (OS::Heat::TestResource) is not supported.','OS::Heat::Stack',NULL,NULL),(762,'b7067365-34f1-4a3a-9be3-0310d02a4bf0','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:16',NULL,'CREATE','IN_PROGRESS','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(763,'9897e7fb-56b8-4d87-898b-d3870bc03fdf','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:16',NULL,'CREATE','IN_PROGRESS','net','swap_network_port-net-u5b6wzzcuort','state changed','OS::Neutron::Net',NULL,156),(764,'ef17696a-8686-449b-9640-d289bf191569','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:16',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(765,'e4c0b698-cd9a-4990-8a07-a579ea7f4579','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:16',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','state changed','OS::Heat::Stack',NULL,157),(766,'6724f428-a0e0-4792-801a-4a6eb7ae9e9e','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:17',NULL,'CREATE','COMPLETE','net','521851aa-d705-4cb1-9d23-329f51e24de2','state changed','OS::Neutron::Net',NULL,156),(767,'743ea3b3-6fc2-4020-9a45-d95dab8017ad','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:17',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_port-subnet-elqq4yngrxbm','state changed','OS::Neutron::Subnet',NULL,158),(768,'f17408e2-767e-40b7-b15c-d8d270672bd0','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:17',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(769,'47b7093a-4366-48af-af45-3bdae214ca68','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:17',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(770,'4cfad37a-c41c-4748-b58d-f2f559b2dc80','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:17',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(771,'7415cf35-0d5a-4d6f-81d8-4dab1120a1b0','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:17',NULL,'CREATE','COMPLETE','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(772,'eaadad05-6ec9-4869-a793-2fbcd26b7f45','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:18',NULL,'CREATE','COMPLETE','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(773,'73e25833-f73a-45fa-9a84-778f52e44a4c','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:18',NULL,'CREATE','COMPLETE','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(774,'976d76ac-6a2e-4eec-89dc-fd7b9c17d14c','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:18',NULL,'CREATE','COMPLETE','subnet','93eebb0b-384e-41b5-affb-405420875dfb','state changed','OS::Neutron::Subnet',NULL,158),(775,'69d61d19-87e1-486f-898a-2f637eba5d0c','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:18',NULL,'CREATE','IN_PROGRESS','server','swap_network_port-server-4k3pz3fn23aa','state changed','OS::Nova::Server',NULL,159),(776,'8a6d9f5b-646a-48a6-b038-33989a9293dc','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:21',NULL,'DELETE','IN_PROGRESS','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(777,'8c3b2aaf-199d-40df-8cee-c4a2a29a1234','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:21',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(778,'b4d53fac-b582-4c9b-a8ee-379cfaebd5f0','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:22',NULL,'SUSPEND','IN_PROGRESS','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(779,'776ba103-2731-4240-a36b-a666b5ee33a9','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:22',NULL,'DELETE','IN_PROGRESS','test1','ExternalReferencesTest-1222046502-test1-uwdpdd4nyx3f','state changed','OS::Heat::TestResource',NULL,NULL),(780,'92b28285-0337-44f3-a554-0e6ab625c72e','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:22',NULL,'DELETE','COMPLETE','test1','ExternalReferencesTest-1222046502-test1-uwdpdd4nyx3f','state changed','OS::Heat::TestResource',NULL,NULL),(781,'e79b08d7-a59f-457e-9f56-9aa5dfa9e058','31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:22',NULL,'DELETE','COMPLETE','ExternalReferencesTest-1222046502','31809bc8-7bd6-4340-ab3a-076e5e8445e6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(782,'faab5b33-017c-4e40-a487-ef5bbae06d6d','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:23',NULL,'SUSPEND','IN_PROGRESS','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack SUSPEND started','OS::Heat::Stack',NULL,NULL),(783,'27be021d-b9dc-4e6e-b7eb-bd8d47f345d0','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:23',NULL,'SUSPEND','IN_PROGRESS','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(784,'2d15350e-be05-4e4e-a3ab-eedd4a62e587','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:24',NULL,'SUSPEND','COMPLETE','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(785,'daf4449e-9c9e-4f77-ae65-ad5abdf40f3f','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:24',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(786,'80112c54-bf9c-4d86-b64c-92a4a8be241f','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:24',NULL,'SUSPEND','COMPLETE','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(787,'df70a130-4eab-425c-b16e-c87e01cb61e4','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:24',NULL,'SUSPEND','COMPLETE','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack SUSPEND completed successfully','OS::Heat::Stack',NULL,NULL),(788,'924d2afb-65ab-4580-b9dc-b428f77a2b90','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:29',NULL,'CREATE','IN_PROGRESS','HooksTest-2076002288','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(789,'4fd59b17-51b3-4c04-a6f6-e9994783105c','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:29',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-2076002288-foo_step1-e5hyu7bq2vgp','state changed','OS::Heat::RandomString',NULL,NULL),(790,'e2ca7fec-0f0b-4678-80c4-834fedeacea5','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:31',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-2076002288-foo_step1-e5hyu7bq2vgp','state changed','OS::Heat::RandomString',NULL,NULL),(791,'228b8fda-9158-4b0c-a89c-836043e8557c','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:31',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(792,'4152930f-0060-472a-b87b-062e3f1884c3','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:33',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(793,'009cf62f-faf4-4bba-a177-1bf93e3f8173','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:34',NULL,'RESUME','IN_PROGRESS','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(794,'6ca880f6-4d39-47a3-94a8-b4d86acccc06','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:34',NULL,'RESUME','IN_PROGRESS','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack RESUME started','OS::Heat::Stack',NULL,NULL),(795,'18c3fd56-f26a-4e36-a790-bca14ba180f4','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:34',NULL,'RESUME','IN_PROGRESS','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(796,'a800e01b-b63d-4914-9487-beff7c25d615','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:34',NULL,'RESUME','COMPLETE','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(797,'0f77c84b-d09a-4f55-acb6-ccf35124568f','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:35',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(798,'886ecbac-17f2-40e6-8525-1e3558d4d92c','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:35',NULL,'RESUME','COMPLETE','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(799,'150416dd-76df-4445-81c7-4bd296c789c3','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:35',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-2076002288-foo_step2-oo4h6bbc4jyx','state changed','OS::Heat::RandomString',NULL,NULL),(800,'350bd47a-b2a7-42de-ad35-d28715c745d4','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:36',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-2076002288-foo_step2-oo4h6bbc4jyx','state changed','OS::Heat::RandomString',NULL,NULL),(801,'7714d3e1-d95b-47ec-82e1-87b5e3faf0d3','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:36',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-2076002288-foo_step3-zsbbgkuhenca','state changed','OS::Heat::RandomString',NULL,NULL),(802,'f7b06094-77d4-47fb-b883-281302a72634','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:36',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-2076002288-foo_step3-zsbbgkuhenca','state changed','OS::Heat::RandomString',NULL,NULL),(803,'7e8a07ba-a43d-4cb0-b874-de4aa67b1ea8','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:36',NULL,'RESUME','COMPLETE','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(804,'936bb4b7-6073-46b2-908b-423725f1948f','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:36',NULL,'CREATE','COMPLETE','HooksTest-2076002288','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(805,'0c954435-1bab-47f1-9f94-b0af229f7219','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:36',NULL,'RESUME','COMPLETE','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack RESUME completed successfully','OS::Heat::Stack',NULL,NULL),(806,'feb46e1b-08a2-4dac-9692-e64c2574d3c5','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:39',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(807,'c276c1e4-66f5-4213-9362-9da387bcb4ad','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:39',NULL,'DELETE','IN_PROGRESS','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(808,'3b8f39d6-8942-4e87-bf3d-b9b3d05886e9','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(809,'99ff7ee1-d3ae-4dec-a564-ae1f20d96128','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','HooksTest-2076002288','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(810,'bfc1f08c-a1b9-48cd-ab64-df3385135259','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:40',NULL,'CREATE','COMPLETE','server','3855bbe2-3a19-4360-aaaa-3e3e5aa51a7f','state changed','OS::Nova::Server',NULL,159),(811,'608e2180-4cc2-43d7-bfca-a62de55e4009','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(812,'3c3ae8ef-a575-4636-b04a-c56ac6a05a8f','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5-random1-o6pvzjjerltk','state changed','OS::Heat::RandomString',NULL,NULL),(813,'1c8fa405-ff43-46a2-bf29-8c9967289f43','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:40',NULL,'CREATE','COMPLETE','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(814,'b8e8428c-7333-4c81-9469-60dbe7cfea8d','f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5','f8cfeee7-b166-4963-90c6-4ede882de6be','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(815,'07426b39-e4ff-41c2-bbd7-1b89e643f2eb','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-2076002288-foo_step3-zsbbgkuhenca','state changed','OS::Heat::RandomString',NULL,NULL),(816,'f885c13b-6ec4-47a7-8914-d0df45f538dc','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-2076002288-foo_step3-zsbbgkuhenca','state changed','OS::Heat::RandomString',NULL,NULL),(817,'76677865-92af-4551-b732-21698054b20d','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','my_stack','f8cfeee7-b166-4963-90c6-4ede882de6be','state changed','OS::Heat::Stack',NULL,157),(818,'f6a66c25-6b71-47c2-aafd-85e2dc7801a6','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','RemoteStackTest-1369055629','1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(819,'f76eae02-ffc0-4fc5-96ef-8605f3961177','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-2076002288-foo_step2-oo4h6bbc4jyx','state changed','OS::Heat::RandomString',NULL,NULL),(820,'2dd554bb-8d99-4a31-bcbd-f45f9c9f5005','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-2076002288-foo_step2-oo4h6bbc4jyx','state changed','OS::Heat::RandomString',NULL,NULL),(821,'abfa7973-71dd-4f64-945b-1e762cb33175','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-2076002288-foo_step1-e5hyu7bq2vgp','state changed','OS::Heat::RandomString',NULL,NULL),(822,'dc06060e-a3eb-46eb-af26-cce1fc698b0c','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-2076002288-foo_step1-e5hyu7bq2vgp','state changed','OS::Heat::RandomString',NULL,NULL),(823,'bcda1a4b-93b9-4c9e-8aba-868d45501764','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:40',NULL,'DELETE','COMPLETE','HooksTest-2076002288','3630e8a5-ab85-4c55-94d3-a7e54936c3aa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(824,'f36a0ecc-bf6c-482d-a25b-f42c4fa5d962','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:45',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(825,'9abcaf6e-5419-47a1-8831-96ab5d893b03','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:45',NULL,'CREATE','IN_PROGRESS','my_stack','RemoteStackTest-374237530-my_stack-jylljfvf254r','state changed','OS::Heat::Stack',NULL,161),(826,'9b1711f7-7206-49a9-a43a-ad3431788aa3','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:45',NULL,'CREATE','IN_PROGRESS','HooksTest-1960363033','42c7d028-3a33-438e-9098-dea53e975d86','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(827,'7102dc2b-cde1-4c23-b5fc-6396ade597ca','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:45',NULL,'CREATE','IN_PROGRESS','nested','HooksTest-1960363033-nested-vtxf4f4k5gag','state changed','nested.yaml',NULL,NULL),(828,'ede028a0-e2c2-487f-b7fb-c2a9590b8112','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:46',NULL,'CREATE','IN_PROGRESS','HooksTest-1960363033-nested-vtxf4f4k5gag','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(829,'570b5a8e-8696-4611-81d3-ca9927fb5290','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:46',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step1-ztucdodeij34','state changed','OS::Heat::RandomString',NULL,NULL),(830,'9292cfbc-ff20-4e5f-8f8d-bb744a84f1ae','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:46',NULL,'UPDATE','IN_PROGRESS','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(831,'b0595d69-d029-406f-8ce8-070ac594c723','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:46',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step1-ztucdodeij34','state changed','OS::Heat::RandomString',NULL,NULL),(832,'e8cd8378-d136-43c5-87d1-37e6c3475ff1','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:46',NULL,'CREATE','IN_PROGRESS','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(833,'c8d62f24-43e5-46ae-a4f7-f1635959d131','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:46',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(834,'6d561158-b79a-4267-8d88-b3cb72a3bffb','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:46',NULL,'CREATE','IN_PROGRESS','random1','RemoteStackTest-374237530-my_stack-jylljfvf254r-random1-5j7cuou7a3i7','state changed','OS::Heat::RandomString',NULL,NULL),(835,'3ac76514-225c-4cfa-a765-0f580af3773e','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:46',NULL,'CREATE','COMPLETE','random1','RemoteStackTest-374237530-my_stack-jylljfvf254r-random1-5j7cuou7a3i7','state changed','OS::Heat::RandomString',NULL,NULL),(836,'ab425eb7-d59a-4650-83d4-efe45ce3c5c7','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:46',NULL,'CREATE','COMPLETE','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(837,'c40f6bba-e318-4026-ac93-1b265d1caa83','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:46',NULL,'CREATE','COMPLETE','my_stack','749cc569-bb07-49e8-a3ca-c34c93fd182d','state changed','OS::Heat::Stack',NULL,161),(838,'dfd60e80-f74f-42af-9921-c872ea2428eb','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:46',NULL,'CREATE','COMPLETE','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(839,'ee3de98c-b381-4dad-be37-6df97b764300','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:47',NULL,'UPDATE','IN_PROGRESS','server','3855bbe2-3a19-4360-aaaa-3e3e5aa51a7f','state changed','OS::Nova::Server',NULL,159),(840,'353b4aeb-cf30-45e0-8681-c9cb5a874480','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:50',NULL,'UPDATE','COMPLETE','server','3855bbe2-3a19-4360-aaaa-3e3e5aa51a7f','state changed','OS::Nova::Server',NULL,162),(841,'d41f18c6-2445-456e-89ba-bd44b3f115eb','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:50',NULL,'UPDATE','COMPLETE','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(842,'73fc9b56-d35e-4337-9d23-d5a51663fad3','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:51',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(843,'150ac877-1d03-41e8-81bb-a78f2dd041b8','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:51',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(844,'fd43ffc7-c12d-4294-bb28-05e46e4dd463','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:51',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step2-3vmmymmnicqx','state changed','OS::Heat::RandomString',NULL,NULL),(845,'067fe958-f5de-4953-a88c-c9e03604cbad','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:51',NULL,'UPDATE','IN_PROGRESS','my_stack','749cc569-bb07-49e8-a3ca-c34c93fd182d','state changed','OS::Heat::Stack',NULL,161),(846,'5c1abb5b-7c4e-4798-a8c5-9c759012c2cf','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:52',NULL,'DELETE','IN_PROGRESS','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(847,'eddfa35b-cd83-4ff4-8c2e-c56e05107804','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:52',NULL,'UPDATE','IN_PROGRESS','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(848,'49544453-fcff-4755-885a-8713d3dd3dea','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:52',NULL,'DELETE','IN_PROGRESS','server','3855bbe2-3a19-4360-aaaa-3e3e5aa51a7f','state changed','OS::Nova::Server',NULL,162),(849,'b9e03f11-2681-4098-a4e5-4e15511ea565','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:52',NULL,'DELETE','IN_PROGRESS','random1','RemoteStackTest-374237530-my_stack-jylljfvf254r-random1-5j7cuou7a3i7','state changed','OS::Heat::RandomString',NULL,NULL),(850,'53415262-3f14-4339-917a-479aa0c0b4ba','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:52',NULL,'DELETE','COMPLETE','random1','RemoteStackTest-374237530-my_stack-jylljfvf254r-random1-5j7cuou7a3i7','state changed','OS::Heat::RandomString',NULL,NULL),(851,'62c951fe-0b6b-42f3-93f0-f64a03798d97','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:53',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step2-3vmmymmnicqx','state changed','OS::Heat::RandomString',NULL,NULL),(852,'b08a0030-5c70-4995-b771-90e509c2aa8b','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:53',NULL,'CREATE','IN_PROGRESS','random2','RemoteStackTest-374237530-my_stack-jylljfvf254r-random2-42xc3dtgrltk','state changed','OS::Heat::RandomString',NULL,NULL),(853,'971116ad-5a64-4c4c-9d2c-728b16f80543','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:53',NULL,'CREATE','COMPLETE','random2','RemoteStackTest-374237530-my_stack-jylljfvf254r-random2-42xc3dtgrltk','state changed','OS::Heat::RandomString',NULL,NULL),(854,'bfc5ae58-0526-422d-8e6a-c6116b6d9d6b','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:54',NULL,'UPDATE','COMPLETE','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(855,'34f6aecb-a166-4cb7-8a08-8886164dc512','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:54',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step3-3frhwka6b2ov','state changed','OS::Heat::RandomString',NULL,NULL),(856,'7e21c0ec-ed37-4a95-a063-836bfe957a43','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:54',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step3-3frhwka6b2ov','state changed','OS::Heat::RandomString',NULL,NULL),(857,'d6a5eff8-6c74-4342-95d9-a07d0414a92e','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:54',NULL,'CREATE','COMPLETE','HooksTest-1960363033-nested-vtxf4f4k5gag','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(858,'ed4e3cb5-f374-4b67-b767-8eda4301c5a4','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:54',NULL,'CREATE','COMPLETE','nested','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','state changed','nested.yaml',NULL,NULL),(859,'aa1a400f-f70d-41a5-94e9-d687f0ad7f35','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:54',NULL,'CREATE','COMPLETE','HooksTest-1960363033','42c7d028-3a33-438e-9098-dea53e975d86','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(860,'a0c17c71-1e17-4814-83f5-cd23a2332e3c','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:55',NULL,'DELETE','COMPLETE','server','3855bbe2-3a19-4360-aaaa-3e3e5aa51a7f','state changed','OS::Nova::Server',NULL,162),(861,'9b1d39f0-35a7-404f-8f44-82459c67ea18','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:55',NULL,'DELETE','IN_PROGRESS','subnet','93eebb0b-384e-41b5-affb-405420875dfb','state changed','OS::Neutron::Subnet',NULL,158),(862,'7069f2fe-9467-4f5f-8018-0751df039d39','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:55',NULL,'UPDATE','COMPLETE','my_stack','749cc569-bb07-49e8-a3ca-c34c93fd182d','state changed','OS::Heat::Stack',NULL,164),(863,'714adb65-a29a-436d-b18d-a2692a870337','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:55',NULL,'UPDATE','COMPLETE','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(864,'5dff246d-5fbf-409e-9e99-8de6656bb491','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:56',NULL,'DELETE','COMPLETE','subnet','93eebb0b-384e-41b5-affb-405420875dfb','state changed','OS::Neutron::Subnet',NULL,158),(865,'14adca72-26e2-431e-930c-c6c1dc438d27','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:57',NULL,'DELETE','IN_PROGRESS','net','521851aa-d705-4cb1-9d23-329f51e24de2','state changed','OS::Neutron::Net',NULL,156),(866,'bd70f4d4-ea39-428f-9d12-96152b3b085c','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:57',NULL,'DELETE','IN_PROGRESS','HooksTest-1960363033','42c7d028-3a33-438e-9098-dea53e975d86','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(867,'dd632b5f-e7fe-44b5-8118-bb682db84c1d','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:58',NULL,'DELETE','IN_PROGRESS','nested','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','state changed','nested.yaml',NULL,NULL),(868,'866973f9-88bf-4a9b-b2b2-17b8a8ef9da9','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:59',NULL,'DELETE','IN_PROGRESS','HooksTest-1960363033-nested-vtxf4f4k5gag','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(869,'f784185c-aaad-45c6-9b7a-aeb9428c7f36','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:59',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step3-3frhwka6b2ov','state changed','OS::Heat::RandomString',NULL,NULL),(870,'2dcd3dbf-b53a-4c78-a1b2-8ff231256b37','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:59',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step3-3frhwka6b2ov','state changed','OS::Heat::RandomString',NULL,NULL),(871,'a90b9471-d17e-4de3-aa55-1449cbea59a4','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:55:00',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step2-3vmmymmnicqx','state changed','OS::Heat::RandomString',NULL,NULL),(872,'eb109deb-5d12-41e2-a0ed-f107d948511d','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step2-3vmmymmnicqx','state changed','OS::Heat::RandomString',NULL,NULL),(873,'edbfd5e0-7206-4935-9e0c-483c84e70a74','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:55:00',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step1-ztucdodeij34','state changed','OS::Heat::RandomString',NULL,NULL),(874,'576f55b2-b670-4774-b7e9-afd4bf061540','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1960363033-nested-vtxf4f4k5gag-foo_step1-ztucdodeij34','state changed','OS::Heat::RandomString',NULL,NULL),(875,'4baed7c8-827c-409d-8c24-0f43c6c1e46a','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','net','521851aa-d705-4cb1-9d23-329f51e24de2','state changed','OS::Neutron::Net',NULL,156),(876,'b21eaace-252f-4925-b82d-af4f9c58fc5c','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','HooksTest-1960363033-nested-vtxf4f4k5gag','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(877,'74fc7a7c-5082-442f-a2c6-9c7456804629','4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','swap_network_port','4b4bbd4e-06ec-4510-b52d-96e160653efd','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(878,'d704cc3f-9567-4541-b703-8d102554569c','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','nested','2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','state changed','nested.yaml',NULL,NULL),(879,'3085fdf3-1416-4fea-9692-12df8c177840','42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:55:00',NULL,'DELETE','COMPLETE','HooksTest-1960363033','42c7d028-3a33-438e-9098-dea53e975d86','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(880,'fde4d3e2-5d66-4e33-9689-e90afcdfd375','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:55:01',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(881,'191b686e-2cd4-45bf-8f94-0890169da3cd','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:55:01',NULL,'DELETE','IN_PROGRESS','my_stack','749cc569-bb07-49e8-a3ca-c34c93fd182d','state changed','OS::Heat::Stack',NULL,164),(882,'6e3aab27-43b9-43f4-89b0-7daf445b921f','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:55:01',NULL,'DELETE','IN_PROGRESS','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(883,'c4c8da3f-026c-4cce-8096-8d7ec3fa7104','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:55:01',NULL,'DELETE','IN_PROGRESS','random2','RemoteStackTest-374237530-my_stack-jylljfvf254r-random2-42xc3dtgrltk','state changed','OS::Heat::RandomString',NULL,NULL),(884,'fe2f700f-deaa-4c35-96fa-b73f50bdaace','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:55:01',NULL,'DELETE','COMPLETE','random2','RemoteStackTest-374237530-my_stack-jylljfvf254r-random2-42xc3dtgrltk','state changed','OS::Heat::RandomString',NULL,NULL),(885,'de3b375a-18ea-4760-953b-4396fb83561a','749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:55:01',NULL,'DELETE','COMPLETE','RemoteStackTest-374237530-my_stack-jylljfvf254r','749cc569-bb07-49e8-a3ca-c34c93fd182d','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(886,'8ca570e2-8b2a-416f-9c74-3d4d2b58defc','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:55:02',NULL,'DELETE','COMPLETE','my_stack','749cc569-bb07-49e8-a3ca-c34c93fd182d','state changed','OS::Heat::Stack',NULL,164),(887,'0103f79f-6e53-4a64-979f-463d1b9cedc8','c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:55:02',NULL,'DELETE','COMPLETE','RemoteStackTest-374237530','c2d21718-3d44-486d-98f7-f40f013a8e24','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(888,'3da2645f-53a0-4f9e-823c-e4342f40537f','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:03',NULL,'CREATE','IN_PROGRESS','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(889,'d9490ca0-a72a-4c64-bb76-4104c7ea3490','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:03',NULL,'CREATE','IN_PROGRESS','net','swap_network_subnet-net-zj6pg6rhk3z7','state changed','OS::Neutron::Net',NULL,165),(890,'769c1397-b318-4653-8add-a2b4d9dc8bd3','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:04',NULL,'CREATE','IN_PROGRESS','HooksTest-704349220','4920fd19-e6d2-4b55-956c-e84dc8649b12','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(891,'e1e811cb-c390-4cb7-b3ea-05ca76c1191c','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:05',NULL,'INIT','COMPLETE','foo_step1',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(892,'debf8eda-7e78-47ba-afec-51dfea9277cd','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:05',NULL,'CREATE','COMPLETE','net','cc255312-7fdf-4af3-b29e-c428e1741e64','state changed','OS::Neutron::Net',NULL,165),(893,'0d560cc8-5b77-4223-a92f-f53a189683c2','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:05',NULL,'CREATE','IN_PROGRESS','subnet','swap_network_subnet-subnet-4fglfs3qtvjm','state changed','OS::Neutron::Subnet',NULL,166),(894,'b592ce57-0c12-47b8-8074-99c15a80f957','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:06',NULL,'INIT','COMPLETE','foo_step1',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(895,'8b1e5f7b-68f2-48ee-b740-f4625b996776','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:06',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-704349220-foo_step1-lr5j3qse46u7','state changed','OS::Heat::RandomString',NULL,NULL),(896,'8fc0c26b-b778-46bf-98d1-f6d0838d78c4','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:07',NULL,'CREATE','IN_PROGRESS','ResourcesList-327004057','436c6e22-2813-4feb-84af-03e11cca11d8','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(897,'240f4de9-5c01-422d-b881-962288c79c43','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:07',NULL,'CREATE','COMPLETE','subnet','4344eda7-72d8-4dd9-921e-dbe1e13e5119','state changed','OS::Neutron::Subnet',NULL,166),(898,'dbe78897-46c9-46d9-a191-5ff92db36f18','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:07',NULL,'CREATE','IN_PROGRESS','server','swap_network_subnet-server-wjshlnav7twn','state changed','OS::Nova::Server',NULL,167),(899,'0254b8b8-5d93-4c74-9062-a0aedd798a8e','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:07',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-704349220-foo_step1-lr5j3qse46u7','state changed','OS::Heat::RandomString',NULL,NULL),(900,'74ec5be7-0553-4b00-8412-af06ee259aff','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:07',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-327004057-test1-xazofusd6jo5','state changed','OS::Heat::TestResource',NULL,168),(901,'32ac1f31-0ec3-4766-8128-476f448f770e','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:07',NULL,'CREATE','COMPLETE','test1','ResourcesList-327004057-test1-xazofusd6jo5','state changed','OS::Heat::TestResource',NULL,168),(902,'4b4ab0a3-418a-4991-a626-b09ec05f04da','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:07',NULL,'INIT','COMPLETE','foo_step2',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(903,'4093a86e-5849-4da3-9ecd-1152b72565ca','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:08',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-327004057-test2-cpqvh3qctfee','state changed','OS::Heat::TestResource',NULL,169),(904,'fe95bc28-6bd2-4bb8-be3b-c94f0101813a','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:08',NULL,'CREATE','COMPLETE','test2','ResourcesList-327004057-test2-cpqvh3qctfee','state changed','OS::Heat::TestResource',NULL,169),(905,'cc16ce2b-4f96-472d-85fe-8f5a24b03e5b','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:08',NULL,'CREATE','COMPLETE','ResourcesList-327004057','436c6e22-2813-4feb-84af-03e11cca11d8','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(906,'6e407737-91b0-443b-a6fd-4f9634e6d2d3','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:09',NULL,'DELETE','IN_PROGRESS','ResourcesList-327004057','436c6e22-2813-4feb-84af-03e11cca11d8','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(907,'d4e50135-f11f-4929-8640-2f960d4f79b2','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:10',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-327004057-test2-cpqvh3qctfee','state changed','OS::Heat::TestResource',NULL,169),(908,'ef06ca84-4d1a-48b3-ab16-4f138c15cc31','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:10',NULL,'DELETE','COMPLETE','test2','ResourcesList-327004057-test2-cpqvh3qctfee','state changed','OS::Heat::TestResource',NULL,169),(909,'266aa0a1-6c27-4b8f-80f7-dd5d9ce7c160','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:10',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-327004057-test1-xazofusd6jo5','state changed','OS::Heat::TestResource',NULL,168),(910,'00259e1c-0aca-4708-b829-cb16a2c0485b','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:10',NULL,'DELETE','COMPLETE','test1','ResourcesList-327004057-test1-xazofusd6jo5','state changed','OS::Heat::TestResource',NULL,168),(911,'aa70ada8-af3c-4ebe-aaa8-34b4c3854295','436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:10',NULL,'DELETE','COMPLETE','ResourcesList-327004057','436c6e22-2813-4feb-84af-03e11cca11d8','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(912,'926125e2-01ba-4e29-abd1-39a207a647e2','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:12',NULL,'INIT','COMPLETE','foo_step2',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(913,'13b71451-26de-4245-be94-1eff1f044f4d','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:12',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-704349220-foo_step2-dha7hlwcm4xq','state changed','OS::Heat::RandomString',NULL,NULL),(914,'43c96d3b-3ec9-4119-8eff-44065103b5fe','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:13',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-704349220-foo_step2-dha7hlwcm4xq','state changed','OS::Heat::RandomString',NULL,NULL),(915,'435a7293-f61b-4e88-8988-158f7fab12af','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:13',NULL,'INIT','COMPLETE','foo_step3',NULL,'CREATE paused until Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(916,'902ee817-8bf7-41d0-b303-d9ef87b68cd0','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:15',NULL,'CREATE','IN_PROGRESS','ResourcesList-1607286495','9e7a635e-4d78-446c-bd95-f703e19d24d0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(917,'0a2d7b41-2a33-45ec-91c7-ab47d9da0f75','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:15',NULL,'CREATE','IN_PROGRESS','test1','ResourcesList-1607286495-test1-d3molwsi4l4n','state changed','OS::Heat::TestResource',NULL,170),(918,'fef4be75-9eb4-4f41-ba1e-a017cf6d532d','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:15',NULL,'CREATE','COMPLETE','test1','ResourcesList-1607286495-test1-d3molwsi4l4n','state changed','OS::Heat::TestResource',NULL,170),(919,'8048a718-1f95-4d99-87f1-f054ce909eef','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'CREATE','IN_PROGRESS','test2','ResourcesList-1607286495-test2-gknh25xxfsuh','state changed','OS::Heat::TestResource',NULL,171),(920,'3585cd1d-b617-4bcc-a6b7-54f9256cb4a6','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'CREATE','COMPLETE','test2','ResourcesList-1607286495-test2-gknh25xxfsuh','state changed','OS::Heat::TestResource',NULL,171),(921,'f20971da-1519-4de6-a9de-564ab441a502','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'CREATE','COMPLETE','ResourcesList-1607286495','9e7a635e-4d78-446c-bd95-f703e19d24d0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(922,'7c0a10f2-fcb4-48a6-8506-7b1b53f36a01','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','IN_PROGRESS','ResourcesList-1607286495','9e7a635e-4d78-446c-bd95-f703e19d24d0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(923,'6d86ba1a-fb53-4ab1-8e48-bc2c3219670c','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','IN_PROGRESS','test2','ResourcesList-1607286495-test2-gknh25xxfsuh','state changed','OS::Heat::TestResource',NULL,171),(924,'aacb5c53-c26f-419b-b96c-b9d63a47225a','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','COMPLETE','test2','ResourcesList-1607286495-test2-gknh25xxfsuh','state changed','OS::Heat::TestResource',NULL,171),(925,'9157efd9-9f31-4e50-9331-d84301968624','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','IN_PROGRESS','test1','ResourcesList-1607286495-test1-d3molwsi4l4n','state changed','OS::Heat::TestResource',NULL,170),(926,'25f70a4b-9600-4e48-8710-91916a9f908c','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','COMPLETE','test1','ResourcesList-1607286495-test1-d3molwsi4l4n','state changed','OS::Heat::TestResource',NULL,170),(927,'44eafd92-671a-4586-8026-fcf9be37315b','9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:16',NULL,'DELETE','COMPLETE','ResourcesList-1607286495','9e7a635e-4d78-446c-bd95-f703e19d24d0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(928,'551fc670-0e71-4e42-95f6-60a7f7105e6e','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:17',NULL,'INIT','COMPLETE','foo_step3',NULL,'Hook pre-create is cleared','OS::Heat::RandomString',NULL,NULL),(929,'ee636f24-7a43-41ae-a24c-0c5b56c8d3bd','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:17',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-704349220-foo_step3-ygwxleuciknm','state changed','OS::Heat::RandomString',NULL,NULL),(930,'a9396423-985b-4661-bf60-73c8bb321a95','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:18',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-704349220-foo_step3-ygwxleuciknm','state changed','OS::Heat::RandomString',NULL,NULL),(931,'1bde84bb-6fef-4708-97fc-d258237b2622','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:18',NULL,'CREATE','COMPLETE','HooksTest-704349220','4920fd19-e6d2-4b55-956c-e84dc8649b12','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(932,'3377b81c-860e-470a-b033-738307391731','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','IN_PROGRESS','HooksTest-704349220','4920fd19-e6d2-4b55-956c-e84dc8649b12','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(933,'5c189adb-e5a7-46c3-9aa8-5a71206c6a9a','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-704349220-foo_step3-ygwxleuciknm','state changed','OS::Heat::RandomString',NULL,NULL),(934,'2f669a80-faa9-4fa1-bc22-de23a086fc42','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-704349220-foo_step3-ygwxleuciknm','state changed','OS::Heat::RandomString',NULL,NULL),(935,'721a32b8-d585-4885-8806-03124dd580aa','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:22',NULL,'CREATE','COMPLETE','server','8ae3c070-a6dc-4282-a0ea-08d002f79d5e','state changed','OS::Nova::Server',NULL,167),(936,'4e1d8b18-878c-4aef-b443-bf7ad3b5a88b','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:22',NULL,'CREATE','COMPLETE','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(937,'47a3b50b-aa7c-4cd9-9c7c-e86ec45270f2','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-704349220-foo_step2-dha7hlwcm4xq','state changed','OS::Heat::RandomString',NULL,NULL),(938,'19e51ba3-99c4-4ef5-850a-251df20d5799','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-704349220-foo_step2-dha7hlwcm4xq','state changed','OS::Heat::RandomString',NULL,NULL),(939,'7ff3eb2a-0d58-440a-b606-05fd7419d399','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-704349220-foo_step1-lr5j3qse46u7','state changed','OS::Heat::RandomString',NULL,NULL),(940,'28560acd-854a-4343-a7be-f81ff15b6107','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-704349220-foo_step1-lr5j3qse46u7','state changed','OS::Heat::RandomString',NULL,NULL),(941,'62a20d60-77cc-4935-a18d-4ba2d837b1f7','4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:22',NULL,'DELETE','COMPLETE','HooksTest-704349220','4920fd19-e6d2-4b55-956c-e84dc8649b12','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(942,'7251b637-1a3e-4dc8-8839-27ec407b1814','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:55:22',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-611247670','ef62c216-05d1-4b4b-be2f-a8500ee480b4','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(943,'4b8cb290-5ab5-4615-a0e2-141b0843e85e','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:55:22',NULL,'CREATE','IN_PROGRESS','server','ParallelDeploymentsTest-611247670-server-pgkuepgw5ei5','state changed','OS::Nova::Server',NULL,172),(944,'2823baca-4da6-4632-aa6f-33b1ebae3ba4','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:28',NULL,'CREATE','IN_PROGRESS','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(945,'1a366dbc-6d07-4df5-bdf3-360b0f746152','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:28',NULL,'UPDATE','IN_PROGRESS','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(946,'645615e1-70e7-426d-9e3f-d267e834549d','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:28',NULL,'CREATE','IN_PROGRESS','rg','HooksTest-996220411-rg-b74unp2mrokw','state changed','OS::Heat::ResourceGroup',NULL,174),(947,'0f81a023-f1f4-4c84-9f24-2867469c0833','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:28',NULL,'CREATE','IN_PROGRESS','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(948,'38a240a7-028b-4f0e-bd73-e7a95d7a8b0b','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:29',NULL,'CREATE','IN_PROGRESS','0','HooksTest-996220411-rg-b74unp2mrokw-0-ssnqrttir2us','state changed','OS::Heat::RandomString',NULL,NULL),(949,'888c5b1e-cf8f-4648-a07a-274b1d554839','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:29',NULL,'CREATE','COMPLETE','0','HooksTest-996220411-rg-b74unp2mrokw-0-ssnqrttir2us','state changed','OS::Heat::RandomString',NULL,NULL),(950,'7437156f-2a0b-4f7b-ad30-f9cbc4ce2a60','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:30',NULL,'CREATE','COMPLETE','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(951,'b7100a61-3ead-4d81-a30b-74cc43c3ecac','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:31',NULL,'CREATE','COMPLETE','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','state changed','OS::Heat::ResourceGroup',NULL,174),(952,'20025cab-3790-417d-aea1-32e03547a5ce','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:31',NULL,'UPDATE','IN_PROGRESS','server','8ae3c070-a6dc-4282-a0ea-08d002f79d5e','state changed','OS::Nova::Server',NULL,167),(953,'16702763-366e-42ea-b409-9d41bf165359','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:31',NULL,'CREATE','COMPLETE','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(954,'2eb0f65e-c9b9-49c3-a442-b5a745ea2521','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:35',NULL,'UPDATE','COMPLETE','server','8ae3c070-a6dc-4282-a0ea-08d002f79d5e','state changed','OS::Nova::Server',NULL,175),(955,'70e6b066-8ed3-4e19-8ddf-37b0d839d767','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:35',NULL,'UPDATE','COMPLETE','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(956,'b9d35d07-09c0-46e2-923b-983eb7539783','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:35',NULL,'UPDATE','IN_PROGRESS','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(957,'d62401c3-029c-4497-9fea-50021aa136a7','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:35',NULL,'CREATE','COMPLETE','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','UPDATE paused until Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,174),(958,'a675b185-5fa2-4390-b14b-5894e34a2181','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:36',NULL,'CREATE','COMPLETE','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Hook pre-update is cleared','OS::Heat::ResourceGroup',NULL,174),(959,'9d54c641-5178-4835-bed4-454e0c81a4ec','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:36',NULL,'UPDATE','IN_PROGRESS','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','state changed','OS::Heat::ResourceGroup',NULL,174),(960,'bf1fae59-9804-4403-8196-71125e9404e1','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:37',NULL,'UPDATE','IN_PROGRESS','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(961,'ea056b11-fccf-4f31-9436-4dbef51b57c2','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:55:37',NULL,'CREATE','COMPLETE','server','19e51f33-595b-4a06-b661-e59340ad23de','state changed','OS::Nova::Server',NULL,172),(962,'3fcffd24-0ea6-4532-bc68-00fb28d66b3b','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:55:37',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-611247670','ef62c216-05d1-4b4b-be2f-a8500ee480b4','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(963,'0ecc29ac-08b6-4c43-ba6c-bee90495d973','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:38',NULL,'CREATE','IN_PROGRESS','1','HooksTest-996220411-rg-b74unp2mrokw-1-33c37gzyrase','state changed','OS::Heat::RandomString',NULL,NULL),(964,'e7b18586-0500-49ba-ae8b-ffd124544b97','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:38',NULL,'CREATE','COMPLETE','1','HooksTest-996220411-rg-b74unp2mrokw-1-33c37gzyrase','state changed','OS::Heat::RandomString',NULL,NULL),(965,'f6c350ce-a05d-4eec-852a-bf91960b0928','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:38',NULL,'UPDATE','COMPLETE','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(966,'86820fdc-7d42-49b2-b4ca-dec866e9a87a','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:39',NULL,'UPDATE','COMPLETE','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','state changed','OS::Heat::ResourceGroup',NULL,176),(967,'518d2a35-2823-4a27-822e-1f5bc2a4487b','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:39',NULL,'UPDATE','COMPLETE','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(968,'db0ecfab-095e-4080-867c-97a06d89596b','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:40',NULL,'DELETE','IN_PROGRESS','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(969,'a734e0a5-6305-4a35-bbe3-a7e0b949540d','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:40',NULL,'DELETE','IN_PROGRESS','server','8ae3c070-a6dc-4282-a0ea-08d002f79d5e','state changed','OS::Nova::Server',NULL,175),(970,'942490a0-4dd1-4f66-a01c-f116afffe2ce','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:41',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404','bf3b6dfb-6ce1-4008-a718-2570a6107907','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(971,'74eb7384-eaed-453e-b1df-582ce80c6e40','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-13617404-config-g6y2r7wxch6i','state changed','OS::Heat::SoftwareConfig',NULL,178),(972,'c3850c13-95c3-4e93-aea6-b8035df69ca3','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:42',NULL,'DELETE','IN_PROGRESS','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(973,'8237f2ac-bc04-43f1-9e9b-fb760ca9f767','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','COMPLETE','config','5dc13f31-1a14-4801-adb5-098842edc7e2','state changed','OS::Heat::SoftwareConfig',NULL,178),(974,'0452456a-3695-4eae-b410-ffb9bb3ac878','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:42',NULL,'DELETE','IN_PROGRESS','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','state changed','OS::Heat::ResourceGroup',NULL,176),(975,'12e3db09-7c73-40aa-b26a-d9fb900a30e2','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt','state changed','OS::Heat::SoftwareDeployments',NULL,179),(976,'8befb41d-4013-444e-9dfe-2bcf0ed75cae','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh','state changed','OS::Heat::SoftwareDeployments',NULL,180),(977,'53477631-bf10-4e85-bfb8-bac8b3728245','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw','state changed','OS::Heat::SoftwareDeployments',NULL,181),(978,'1422a7f4-70d9-4347-a272-ff5243f43d74','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd','state changed','OS::Heat::SoftwareDeployments',NULL,182),(979,'1c2b29a8-22ad-4227-8ea4-84e0cf5a640f','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:42',NULL,'DELETE','IN_PROGRESS','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(980,'6dc090bd-8040-437d-8e26-5f21513e5432','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws','state changed','OS::Heat::SoftwareDeployments',NULL,183),(981,'54cba04d-49fb-488c-9dbd-a8246015ad19','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw','8707886f-7ca6-4279-8a25-33d4c65a87f7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(982,'826db5f4-9ac1-4688-8c2f-027b0b352d7f','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(983,'aea6e413-8fb7-480f-8aec-126b77635945','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(984,'35772719-79ea-4d5e-8589-6069c6ce8c4e','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh','fc547785-0f54-4ea0-a8a1-6de34ceca347','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(985,'a5b4dda4-1746-4afe-a784-64d3011c910e','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:42',NULL,'DELETE','IN_PROGRESS','0','HooksTest-996220411-rg-b74unp2mrokw-0-ssnqrttir2us','state changed','OS::Heat::RandomString',NULL,NULL),(986,'e0f28a57-828f-4b01-a58c-b12a69c07e1f','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(987,'762a5332-67b8-499c-9094-d01e814fcc2b','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:42',NULL,'DELETE','COMPLETE','0','HooksTest-996220411-rg-b74unp2mrokw-0-ssnqrttir2us','state changed','OS::Heat::RandomString',NULL,NULL),(988,'8d1106fe-2546-495f-98a2-25129a1dd5b7','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw-0-zsyfvencyibo','state changed','OS::Heat::SoftwareDeployment',NULL,184),(989,'5b37d109-cc0f-4003-99ee-59e1801d090f','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh-0-fy7zujs5uces','state changed','OS::Heat::SoftwareDeployment',NULL,186),(990,'c3f93e39-b0e5-4402-a807-f31d36e9705a','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt-0-xof2or4mnscf','state changed','OS::Heat::SoftwareDeployment',NULL,185),(991,'e4224866-5db3-4a19-b117-6bbfedce6b7c','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd-0-i6sv6uku7byu','state changed','OS::Heat::SoftwareDeployment',NULL,187),(992,'d074620b-8767-4f6c-8e69-c13dcedb723e','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:55:42',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws-0-d6fzlcebfb6q','state changed','OS::Heat::SoftwareDeployment',NULL,188),(993,'72acf144-8e18-4c5d-9def-766b793b24c3','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:43',NULL,'DELETE','COMPLETE','server','8ae3c070-a6dc-4282-a0ea-08d002f79d5e','state changed','OS::Nova::Server',NULL,175),(994,'fb3bfbf7-14aa-4839-a462-334a6c5647e7','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:43',NULL,'DELETE','IN_PROGRESS','subnet','4344eda7-72d8-4dd9-921e-dbe1e13e5119','state changed','OS::Neutron::Subnet',NULL,166),(995,'b275a498-d508-4e16-aa27-c3df34b79831','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:43',NULL,'DELETE','IN_PROGRESS','1','HooksTest-996220411-rg-b74unp2mrokw-1-33c37gzyrase','state changed','OS::Heat::RandomString',NULL,NULL),(996,'623cb5b2-6ef5-4084-bfef-0e6c484f2cee','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:43',NULL,'DELETE','COMPLETE','1','HooksTest-996220411-rg-b74unp2mrokw-1-33c37gzyrase','state changed','OS::Heat::RandomString',NULL,NULL),(997,'a5d2316d-dc1e-40bc-baa0-e8608b7f89eb','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:43',NULL,'DELETE','COMPLETE','HooksTest-996220411-rg-b74unp2mrokw','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(998,'5575b1f6-d818-42cf-8400-58bf4e93e8f9','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:43',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(999,'4c3136f8-c516-4023-96c3-c65d2440f4d5','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-218845895-config-dlisys2oxzg3','state changed','OS::Heat::SoftwareConfig',NULL,189),(1000,'9feb419e-3d37-4da1-b693-9ed8a360b43c','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:44',NULL,'DELETE','COMPLETE','subnet','4344eda7-72d8-4dd9-921e-dbe1e13e5119','state changed','OS::Neutron::Subnet',NULL,166),(1001,'3e9bb1b9-befa-4bef-958c-e63af2179698','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:44',NULL,'DELETE','IN_PROGRESS','net','cc255312-7fdf-4af3-b29e-c428e1741e64','state changed','OS::Neutron::Net',NULL,165),(1002,'519b5459-2655-401f-8d5a-0847cff94680','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','COMPLETE','config','3cc252a8-398e-4a67-9276-e44e75a3c773','state changed','OS::Heat::SoftwareConfig',NULL,189),(1003,'e2c77ba7-4ea9-471b-9c7c-5bae1d73e21e','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','dep_4','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf','state changed','OS::Heat::SoftwareDeployments',NULL,190),(1004,'41414998-8ce9-4e6e-bbd7-7e933d2b3845','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','dep_3','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb','state changed','OS::Heat::SoftwareDeployments',NULL,191),(1005,'fdc6248a-b06e-48a0-88ad-e913456e2101','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:44',NULL,'DELETE','COMPLETE','rg','d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','state changed','OS::Heat::ResourceGroup',NULL,176),(1006,'44d8b80f-35c6-4547-95dc-da41312e8a50','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces','state changed','OS::Heat::SoftwareDeployments',NULL,192),(1007,'64f8f35d-f96d-46ca-aa6e-05554da2aab2','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1008,'ab38bada-2948-4a3c-87d1-47a476339784','ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:44',NULL,'DELETE','COMPLETE','HooksTest-996220411','ebef2b47-842a-4891-83fc-6993230f3000','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1009,'f7f15a79-51db-49d7-b833-39ab21d52dee','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1010,'6bd6f23c-f3fc-4971-a5f8-8f48785ab490','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf','ca79085e-1ca6-4079-b3b5-820adecfa6d5','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1011,'8facf19a-944d-4a47-8336-f9a5fd83695a','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces','c94b83d2-5c79-451b-8ca3-b564e01091bc','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1012,'e7e38f6a-a132-491d-8fe9-da6dee5bca5a','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1013,'e22b68ee-5b8c-4440-bda1-bad21ab52c4e','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk','876878a6-95f6-49e5-bac0-26e70ec9adca','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1014,'52fd23d7-b887-4247-b979-48e639524a25','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb-0-wihquxfnecft','state changed','OS::Heat::SoftwareDeployment',NULL,195),(1015,'e4ec6afe-ac63-46ca-b38e-29db3bf536bb','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf-0-7gegdceeamcx','state changed','OS::Heat::SoftwareDeployment',NULL,196),(1016,'4c76d6e6-ff22-422f-8d08-55c7176a694c','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk-0-r545omjdvkdk','state changed','OS::Heat::SoftwareDeployment',NULL,197),(1017,'b0d1a470-075e-4eb4-812c-5bdda4e833cc','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1018,'efd17bf1-b65e-4cf1-894a-becc4b219e6d','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces-0-zjh3axh6fqhm','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1019,'e08eeb53-91fd-42d0-9165-dd93e1587da9','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:55:44',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7-0-ae2sbnfzrzoz','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1020,'8f4ef5ca-6c21-44f5-b517-d67b646ad78e','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:45',NULL,'DELETE','COMPLETE','net','cc255312-7fdf-4af3-b29e-c428e1741e64','state changed','OS::Neutron::Net',NULL,165),(1021,'a3c53a0f-680f-4376-b5eb-326168fe81bf','913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:45',NULL,'DELETE','COMPLETE','swap_network_subnet','913e7d81-33e8-4882-a54c-779cfc4419d3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1022,'61d0cee4-752d-45be-a200-f1e649518a4f','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','IN_PROGRESS','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1023,'98883357-9961-4ce5-ab30-3aba861c975f','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-191390256-foo_step1-a7gg6stupd7e','state changed','OS::Heat::RandomString',NULL,NULL),(1024,'02ef6a33-00c3-4201-a9f8-5428abab0b87','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-191390256-foo_step1-a7gg6stupd7e','state changed','OS::Heat::RandomString',NULL,NULL),(1025,'2ec073de-3587-45c7-ab35-cdc368a42367','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','state changed','OS::Heat::RandomString',NULL,NULL),(1026,'c0dbf67c-c9e8-49fc-ba44-a01bc8c3c77e','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','state changed','OS::Heat::RandomString',NULL,NULL),(1027,'92010189-95bd-4fd1-a169-7a8fb959766a','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-191390256-foo_step3-67ildcgx3sxp','state changed','OS::Heat::RandomString',NULL,NULL),(1028,'4bfab194-f913-4b96-b5b5-ca055c812b09','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-191390256-foo_step3-67ildcgx3sxp','state changed','OS::Heat::RandomString',NULL,NULL),(1029,'3a71d86b-3075-46fa-a55e-8ee4fa667e3d','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:48',NULL,'CREATE','COMPLETE','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1030,'049efa16-f373-477d-99d7-20f0b9e86c79','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:49',NULL,'UPDATE','IN_PROGRESS','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1031,'280d53e1-7dfe-43cf-ad25-155ee931b356','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:49',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1032,'ca37d808-4114-4cdb-bf52-fbff5f1b5803','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:49',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-269394896','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1033,'6615a888-a79b-4c37-9649-7d166295005c','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:50',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-269394896-config-3wskaawracbk','state changed','OS::Heat::SoftwareConfig',NULL,200),(1034,'de6a8143-44b4-4f57-a0b7-c81c725f7521','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:52',NULL,'CREATE','COMPLETE','config','0a394036-a9cb-4790-a393-a17519c45099','state changed','OS::Heat::SoftwareConfig',NULL,200),(1035,'9776b436-1d9d-4039-a25b-3e608120ce39','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:52',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1036,'ec3de5bf-a612-4854-bca1-6bbca2f67a3e','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1037,'f8868a49-1e5c-4a8f-a436-aeb2e8e62bdb','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1038,'9617d992-b98a-4ddf-8c90-864192c35079','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1039,'6eb77282-923f-4bfb-b7ec-080848e1c3d1','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1040,'6490bfff-a6cf-4798-9c3e-29b69aa9e9d3','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd','2b3397b5-dce8-4bf4-aa95-537d9d366039','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1041,'414ece32-c0e0-46b1-892f-0ddc963b8685','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo','a9331ed6-4247-4121-ab61-082bb2f6211e','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1042,'0b8f036f-5e43-4212-9616-1da2c8a5b3a4','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1043,'96c1a9d8-2edc-4d28-bd8b-63802faf6a99','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:55:52',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd-0-5n7d5zxaouwt','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1044,'f8477d80-7669-4606-b7b4-442cd7fdc071','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:55:53',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo-0-f2k5p4coxphl','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1045,'c0282e29-0f2c-42fc-9c55-c09d5a8fc74f','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:53',NULL,'CREATE','IN_PROGRESS','net','swap_subnet_network-net-tgdemfahhwnv','state changed','OS::Neutron::Net',NULL,206),(1046,'27bd62b0-1ff4-4020-9227-5b618a26c2d9','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:55:53',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p-0-gtlnslb2z5uz','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1047,'86df3631-5b8e-40df-9c71-bbc8885979ee','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'UPDATE','COMPLETE','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1048,'c00daa01-2bf6-40af-97e8-58df981ea643','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'DELETE','IN_PROGRESS','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1049,'dfd8f8a3-e6aa-4aac-bc1e-477339b479a7','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-191390256-foo_step3-67ildcgx3sxp','state changed','OS::Heat::RandomString',NULL,NULL),(1050,'b761b456-df6d-4890-8be8-139ab2b19eff','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-191390256-foo_step3-67ildcgx3sxp','state changed','OS::Heat::RandomString',NULL,NULL),(1051,'b41d2e9f-fd50-4a4c-8b40-b62da9edbdd9','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:53',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1375998189','fab57e2a-6be8-4888-9705-5ff23fd7e69a','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1052,'0e50176d-b333-467a-ae3f-649e4d70b5b4','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','state changed','OS::Heat::RandomString',NULL,NULL),(1053,'2fc57856-381e-46e3-8eae-2db4d94de6be','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:53',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-191390256-foo_step2-btdubngivsxa','state changed','OS::Heat::RandomString',NULL,NULL),(1054,'547eec46-aa1b-4921-bc8a-8610f93e4976','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:54',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-191390256-foo_step1-a7gg6stupd7e','state changed','OS::Heat::RandomString',NULL,NULL),(1055,'ed69ece7-b82d-4f8c-9c64-c8481a6bcb1d','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:54',NULL,'CREATE','COMPLETE','net','94a1b7ae-57e3-4fe6-b60c-c503dccee1e1','state changed','OS::Neutron::Net',NULL,206),(1056,'dcfafa42-04ab-42bb-a0d5-3f95a2b8b035','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:54',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-191390256-foo_step1-a7gg6stupd7e','state changed','OS::Heat::RandomString',NULL,NULL),(1057,'4f049f54-8412-4ebe-923a-86ba314b9aa8','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1375998189-config-2fwnvuw32ceb','state changed','OS::Heat::SoftwareConfig',NULL,208),(1058,'f931790c-08ae-478f-9b9c-c33569939eae','07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:54',NULL,'DELETE','COMPLETE','HooksTest-191390256','07926ba9-1a40-4d37-a318-08e5fd0337ac','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1059,'a62cc658-3e93-42fb-8eac-58f00f4929df','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','subnet','swap_subnet_network-subnet-4dlxvrlkyqxe','state changed','OS::Neutron::Subnet',NULL,209),(1060,'9052c939-8f66-4787-9838-21a6114fc3ff','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:54',NULL,'CREATE','COMPLETE','config','51da4ba3-5a3a-4080-9dc5-ac01240c1ac0','state changed','OS::Heat::SoftwareConfig',NULL,208),(1061,'0490c6f6-f722-4ffa-b2d8-db4eb83f4cb4','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1062,'e19223ba-a6d5-4cee-8bfc-59bab0016df2','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1063,'281aff55-2912-4f1a-953a-037440e59824','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1064,'0f81ab37-258f-4d7f-a798-342d96707c77','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni','a5db7eca-245b-42fd-85e6-a681b854992b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1065,'7a1fb0e0-201e-4c1a-9e3a-d64c5a30289d','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g','9b280d66-4c0d-4819-af76-36514cc68d89','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1066,'1b7e3b10-4cb9-4ebc-848b-6afbc590f6cd','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r','09ac263d-b621-4142-a590-7a996ff26cfb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1067,'b331d8fd-20f8-461a-93d4-65ef69ae66cc','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni-0-vhkvoqktuokm','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1068,'deb0bd39-0f5c-470f-b2b3-eda3479450a6','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g-0-ky3ttw6xpcab','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1069,'747726c7-3c00-4033-a953-bfa1842eed59','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:55:54',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r-0-k2se3ojfr6fl','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1070,'b337a610-1008-4ae4-932f-7d221d0d2e09','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:55',NULL,'CREATE','COMPLETE','subnet','aefe4656-efc7-4733-a84b-1f4360f0d4d2','state changed','OS::Neutron::Subnet',NULL,209),(1071,'a64d07ac-6ffb-4bf5-ab64-2c0c5da6f5d7','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1006090207','03b07b2a-f62f-43d4-a292-4939980296c0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1072,'1d7acd7c-6cec-4dad-8746-6a50ea576bac','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','server','swap_subnet_network-server-oll2mezxsdmz','state changed','OS::Nova::Server',NULL,216),(1073,'06a4f00c-15ea-4187-af7f-930582f23539','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-1006090207-config-ufdhn536a75z','state changed','OS::Heat::SoftwareConfig',NULL,217),(1074,'d825f4db-5eb3-4a16-97cd-a56f4995e35a','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','COMPLETE','config','71f022f4-74f0-440c-bf6f-28c7cbbde1b9','state changed','OS::Heat::SoftwareConfig',NULL,217),(1075,'8b4f8df8-3e7f-4c49-829d-5317de3b5ba5','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1076,'3fca4b95-9281-4197-a445-679e6b567764','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1077,'50337b36-9704-4958-acb1-35318af6c465','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1078,'a2c88bdd-58fe-4fda-b48d-a198f38dc57c','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:55:55',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1079,'a081a7cc-6edc-4e39-bd89-b02adfc7ebeb','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:55:56',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257','bb6e480a-bfd4-4d75-953c-7faa946564f9','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1080,'40662624-2718-423f-b2e6-fb4d542da3d2','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:55:56',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff','fce72fa2-5a0b-4527-8a2d-50360121335c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1081,'4f4dc804-72e6-4a6d-a1aa-d941fce94b6a','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:55:57',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u-0-md4u7jmoemgl','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1082,'66db0759-eac7-41f1-b2cf-7797a18a7d5d','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:55:57',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff-0-rsyowud7bbyj','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1083,'27113e04-4349-47ac-b52e-dd8c27e2fade','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:55:57',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257-0-johpzhavdrl6','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1084,'7cf1e106-9ae2-483d-bb48-ecefb0308877','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59',NULL,'CREATE','IN_PROGRESS','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1085,'ac7deb3b-befc-4c25-8026-6f82514608af','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59',NULL,'CREATE','IN_PROGRESS','foo_step1','HooksTest-1805989431-foo_step1-oyfbgsnagwfp','state changed','OS::Heat::RandomString',NULL,NULL),(1086,'b6aa87e8-ff17-40e1-a3fa-f07d1d227d6c','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59',NULL,'CREATE','COMPLETE','foo_step1','HooksTest-1805989431-foo_step1-oyfbgsnagwfp','state changed','OS::Heat::RandomString',NULL,NULL),(1087,'19c509ee-bfee-4e08-9359-65c1aaa89ad4','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','state changed','OS::Heat::RandomString',NULL,NULL),(1088,'0ec0443f-d85b-4fbd-a128-d53cd03aa725','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','state changed','OS::Heat::RandomString',NULL,NULL),(1089,'fdbdd4f0-bdac-4f51-ae35-58bb4476a8c2','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:01',NULL,'CREATE','IN_PROGRESS','foo_step3','HooksTest-1805989431-foo_step3-lhoswwkfc2ms','state changed','OS::Heat::RandomString',NULL,NULL),(1090,'3bb16b2b-55c8-4c42-a756-19d0b5dd9531','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:01',NULL,'CREATE','COMPLETE','foo_step3','HooksTest-1805989431-foo_step3-lhoswwkfc2ms','state changed','OS::Heat::RandomString',NULL,NULL),(1091,'dc91a8b8-d399-4c55-a097-7cbaba25de90','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:01',NULL,'CREATE','COMPLETE','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1092,'ea8e1a16-a5a4-4f96-a628-532055156704','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:02',NULL,'SIGNAL','IN_PROGRESS','0','34b8969d-78db-486c-b088-cc70fa70d8bf','Signal: deployment 34b8969d-78db-486c-b088-cc70fa70d8bf succeeded','OS::Heat::SoftwareDeployment',NULL,223),(1093,'4c0a66c0-aa68-429b-89a6-bbf402bebd4d','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:04',NULL,'CREATE','COMPLETE','0','34b8969d-78db-486c-b088-cc70fa70d8bf','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1094,'bf399373-2506-4572-9da1-b3af0377d953','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:04',NULL,'SIGNAL','IN_PROGRESS','0','8ae26553-b6eb-4262-bf24-b416cd8d1406','Signal: deployment 8ae26553-b6eb-4262-bf24-b416cd8d1406 succeeded','OS::Heat::SoftwareDeployment',NULL,222),(1095,'0c9846f2-467a-4d8c-b111-0e1d0997f014','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:04',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257','bb6e480a-bfd4-4d75-953c-7faa946564f9','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1096,'f8f56f00-1eeb-4ae4-a709-74e7010e1ae7','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:04',NULL,'SIGNAL','IN_PROGRESS','0','d54768e0-c0fc-4dff-899f-59a6fecfade8','Signal: deployment d54768e0-c0fc-4dff-899f-59a6fecfade8 succeeded','OS::Heat::SoftwareDeployment',NULL,221),(1097,'81ff7078-9791-49be-b043-dd316467b0f8','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','dep_2','bb6e480a-bfd4-4d75-953c-7faa946564f9','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1098,'ce569403-6a2e-4083-bd87-fc73a3dda99b','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','0','8ae26553-b6eb-4262-bf24-b416cd8d1406','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1099,'c3949bb8-f5c1-4987-a236-c0a483046f7d','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:56:05',NULL,'SIGNAL','IN_PROGRESS','0','530b45d0-e039-4747-bea8-459686f1342e','Signal: deployment 530b45d0-e039-4747-bea8-459686f1342e succeeded','OS::Heat::SoftwareDeployment',NULL,186),(1100,'3dcf3718-ada2-41a3-aff7-55d7fdb0088a','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','0','d54768e0-c0fc-4dff-899f-59a6fecfade8','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1101,'0f7381a3-cc85-4699-a25a-06153855c5b8','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff','fce72fa2-5a0b-4527-8a2d-50360121335c','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1102,'372045d8-b519-4b71-9d13-41cf52a65564','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1103,'100631bb-7702-400d-abd8-4e25df5c2173','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:05',NULL,'CREATE','COMPLETE','dep_0','fce72fa2-5a0b-4527-8a2d-50360121335c','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1104,'1de5a6e1-075c-4461-84bf-142d282b0271','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:06',NULL,'UPDATE','IN_PROGRESS','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1105,'01aafc58-fa2b-49fa-823a-75ecbe1685e4','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:06',NULL,'CREATE','COMPLETE','dep_1','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1106,'de2b3119-52d3-4d52-8d61-01f53ea3db86','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:56:06',NULL,'CREATE','COMPLETE','0','530b45d0-e039-4747-bea8-459686f1342e','state changed','OS::Heat::SoftwareDeployment',NULL,186),(1107,'debd7c68-6e70-4508-b757-392805c4e49b','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:56:07',NULL,'SIGNAL','IN_PROGRESS','0','c8338fa9-5d82-4898-bc0d-5ef8d3c00142','Signal: deployment c8338fa9-5d82-4898-bc0d-5ef8d3c00142 succeeded','OS::Heat::SoftwareDeployment',NULL,187),(1108,'8b2909b2-c7ea-4a89-8db8-970e99f46b61','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:08',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1006090207','03b07b2a-f62f-43d4-a292-4939980296c0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1109,'3f15d590-bfbb-4635-a48c-61a2ed617b5c','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:56:08',NULL,'CREATE','COMPLETE','0','c8338fa9-5d82-4898-bc0d-5ef8d3c00142','state changed','OS::Heat::SoftwareDeployment',NULL,187),(1110,'fef075f5-31a6-489b-aa77-b8ff3c279a5b','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:56:08',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh','fc547785-0f54-4ea0-a8a1-6de34ceca347','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1111,'951a2f02-e27d-41dd-a7ef-5b090112194c','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:56:08',NULL,'SIGNAL','IN_PROGRESS','0','e789043f-005e-4ff3-872a-7835bffdc6e1','Signal: deployment e789043f-005e-4ff3-872a-7835bffdc6e1 succeeded','OS::Heat::SoftwareDeployment',NULL,184),(1112,'904e9ad1-f5fb-4cd4-bc7a-1a748d9c3259','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:56:08',NULL,'SIGNAL','IN_PROGRESS','0','f5fbc506-8944-468a-be80-52aba5fb0bb0','Signal: deployment f5fbc506-8944-468a-be80-52aba5fb0bb0 succeeded','OS::Heat::SoftwareDeployment',NULL,185),(1113,'1b09f23c-cf7e-42bc-a25d-cc52b785f16a','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:56:09',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1114,'20782c1b-516f-4c5a-ad6e-7804a962d48b','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:09',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','UPDATE paused until Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1115,'4d75df2e-07ce-42e8-bca2-ae03ea2a6381','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:09',NULL,'CREATE','COMPLETE','dep_2','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','state changed','OS::Heat::SoftwareDeployments',NULL,182),(1116,'447f1eca-cb44-4c14-a54d-37fe620c95ca','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:56:09',NULL,'SIGNAL','IN_PROGRESS','0','f8cf484b-84e9-4538-ab8f-000baaab619c','Signal: deployment f8cf484b-84e9-4538-ab8f-000baaab619c succeeded','OS::Heat::SoftwareDeployment',NULL,188),(1117,'52cc12fa-cb01-4d94-82d4-4b780e4231a2','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:09',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','Hook pre-update is cleared','OS::Heat::RandomString',NULL,NULL),(1118,'27402370-e24e-4f70-a443-2f5b11728e14','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:09',NULL,'CREATE','COMPLETE','dep_3','fc547785-0f54-4ea0-a8a1-6de34ceca347','state changed','OS::Heat::SoftwareDeployments',NULL,180),(1119,'17f841c2-71dc-43af-b17d-ec96b893cd85','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','0','f5fbc506-8944-468a-be80-52aba5fb0bb0','state changed','OS::Heat::SoftwareDeployment',NULL,185),(1120,'686bfd8d-0094-42f2-9269-948f51c07e10','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','0','e789043f-005e-4ff3-872a-7835bffdc6e1','state changed','OS::Heat::SoftwareDeployment',NULL,184),(1121,'cbdd692c-483b-4ae1-9543-14c70f740205','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','0','f8cf484b-84e9-4538-ab8f-000baaab619c','state changed','OS::Heat::SoftwareDeployment',NULL,188),(1122,'3065095f-d4ca-4901-bce2-ad7b3b9f3733','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'UPDATE','IN_PROGRESS','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','state changed','OS::Heat::RandomString',NULL,NULL),(1123,'2221b797-baf0-4361-9b08-03d7f3496559','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1124,'1356474a-6c6c-4c02-9398-82da4f50066a','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'UPDATE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','The Resource foo_step2 requires replacement.','OS::Heat::RandomString',NULL,NULL),(1125,'3c9badff-821d-4af8-ac1d-e209314c5c1b','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw','8707886f-7ca6-4279-8a25-33d4c65a87f7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1126,'c23ee93e-f95f-4633-a6df-b5cbdeaf237f','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1127,'d8422c6b-8299-4b18-a5b9-0f9748af7095','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:10',NULL,'SIGNAL','IN_PROGRESS','0','02f95c19-38bf-408d-8822-9c2733f833ca','Signal: deployment 02f95c19-38bf-408d-8822-9c2733f833ca succeeded','OS::Heat::SoftwareDeployment',NULL,213),(1128,'08324b99-03e3-4359-8345-bd641e47c9c1','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'CREATE','IN_PROGRESS','foo_step2','HooksTest-1805989431-foo_step2-ijfocc6jyhpe','state changed','OS::Heat::RandomString',NULL,224),(1129,'2854275a-68d8-450c-9d4e-d96efbe872d1','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','dep_4','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','state changed','OS::Heat::SoftwareDeployments',NULL,179),(1130,'3ab27e2d-4b83-4ba0-8c77-94d6f63f6197','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-ijfocc6jyhpe','state changed','OS::Heat::RandomString',NULL,224),(1131,'605989d1-bd61-4b08-bcc0-78615dde3c43','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','state changed','OS::Heat::RandomString',NULL,NULL),(1132,'ef503bdf-0169-41ec-af9f-4e7803df238b','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-tyxoo3wpi6k7','state changed','OS::Heat::RandomString',NULL,NULL),(1133,'49c2ef31-147f-4fb2-bc8e-865c63c030d5','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:10',NULL,'UPDATE','COMPLETE','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1134,'0906a954-9eb1-4639-bd81-0d24e46609b8','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:10',NULL,'SIGNAL','IN_PROGRESS','0','05e05c17-b02e-4c16-bf5e-20584915df68','Signal: deployment 05e05c17-b02e-4c16-bf5e-20584915df68 succeeded','OS::Heat::SoftwareDeployment',NULL,214),(1135,'42ff1f26-1046-4f91-9702-bece29ae4654','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','dep_1','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','state changed','OS::Heat::SoftwareDeployments',NULL,183),(1136,'f73c44d7-4628-428c-b021-58016072dbdc','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','dep_0','8707886f-7ca6-4279-8a25-33d4c65a87f7','state changed','OS::Heat::SoftwareDeployments',NULL,181),(1137,'7bbcee1a-c585-4e9a-a6a5-9570273dc8ed','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:56:10',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-13617404','bf3b6dfb-6ce1-4008-a718-2570a6107907','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1138,'905d6786-a16c-4532-9895-0ce1c2e9d0d1','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:11',NULL,'CREATE','COMPLETE','0','02f95c19-38bf-408d-8822-9c2733f833ca','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1139,'e038be35-6b6a-4e9e-a23f-4483599b6398','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:11',NULL,'SIGNAL','IN_PROGRESS','0','dffb0b03-3f98-4c36-b3ee-63be3ad745cc','Signal: deployment dffb0b03-3f98-4c36-b3ee-63be3ad745cc succeeded','OS::Heat::SoftwareDeployment',NULL,215),(1140,'3bb713bb-7eea-48a4-9d8f-0c618f390abe','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:11',NULL,'CREATE','COMPLETE','0','05e05c17-b02e-4c16-bf5e-20584915df68','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1141,'cbd80e26-41d5-491f-bdb5-a82dd59f8b3e','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:11',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni','a5db7eca-245b-42fd-85e6-a681b854992b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1142,'e4277689-4d91-4179-9523-bdc73acd5b5c','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:12',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g','9b280d66-4c0d-4819-af76-36514cc68d89','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1143,'002f426d-9dad-42b7-9d03-7129a18b72a1','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:13',NULL,'CREATE','COMPLETE','dep_0','a5db7eca-245b-42fd-85e6-a681b854992b','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1144,'2321ae23-3924-4258-a56d-d13c066297a2','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:13',NULL,'CREATE','COMPLETE','dep_2','9b280d66-4c0d-4819-af76-36514cc68d89','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1145,'87acdf9a-5122-45c3-befe-bbc18252f32f','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:13',NULL,'CREATE','COMPLETE','0','dffb0b03-3f98-4c36-b3ee-63be3ad745cc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1146,'233e3be5-0324-4253-8b47-ec16d74f4ddd','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:13',NULL,'SIGNAL','IN_PROGRESS','0','19ade2b0-8700-49cf-aa54-c754bd6d0f15','Signal: deployment 19ade2b0-8700-49cf-aa54-c754bd6d0f15 succeeded','OS::Heat::SoftwareDeployment',NULL,195),(1147,'1f0461b6-5a19-47d6-97dc-025aab190fae','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:13',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r','09ac263d-b621-4142-a590-7a996ff26cfb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1148,'daa7b13b-46a1-4c78-8a78-cf98350e5032','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:13',NULL,'SIGNAL','IN_PROGRESS','0','425d8f42-5803-4c3c-b29c-777dfef00020','Signal: deployment 425d8f42-5803-4c3c-b29c-777dfef00020 succeeded','OS::Heat::SoftwareDeployment',NULL,197),(1149,'7685912b-be65-4992-ac00-22b19c3d5595','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:13',NULL,'SIGNAL','IN_PROGRESS','0','fe44ad61-9e93-4088-9e74-a4d2ea4d4d43','Signal: deployment fe44ad61-9e93-4088-9e74-a4d2ea4d4d43 succeeded','OS::Heat::SoftwareDeployment',NULL,196),(1150,'104ff851-26a1-43cb-9a90-d0b375580c4b','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:13',NULL,'SIGNAL','IN_PROGRESS','0','8e4aeb55-c7c0-492c-9f33-3aa64ff97765','Signal: deployment 8e4aeb55-c7c0-492c-9f33-3aa64ff97765 succeeded','OS::Heat::SoftwareDeployment',NULL,199),(1151,'60514fba-21e7-4d72-89f5-9ac95893d1aa','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','dep_1','09ac263d-b621-4142-a590-7a996ff26cfb','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1152,'90cac22a-f465-4192-bac8-af9fd3c46d61','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','0','8e4aeb55-c7c0-492c-9f33-3aa64ff97765','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1153,'e72bf7fb-d431-4a00-befd-5cf39f79d11b','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','0','425d8f42-5803-4c3c-b29c-777dfef00020','state changed','OS::Heat::SoftwareDeployment',NULL,197),(1154,'df15623b-e1b3-44fe-acaf-65e573572e93','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','0','fe44ad61-9e93-4088-9e74-a4d2ea4d4d43','state changed','OS::Heat::SoftwareDeployment',NULL,196),(1155,'27992379-ad49-44aa-9473-824df1ed4530','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:14',NULL,'SIGNAL','IN_PROGRESS','0','bba9a68c-9566-42a5-80d8-38809ab1c70c','Signal: deployment bba9a68c-9566-42a5-80d8-38809ab1c70c succeeded','OS::Heat::SoftwareDeployment',NULL,198),(1156,'9d95a006-8da9-40c4-839e-0de3e9fb99ef','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','0','19ade2b0-8700-49cf-aa54-c754bd6d0f15','state changed','OS::Heat::SoftwareDeployment',NULL,195),(1157,'964240d2-e482-4bd4-b733-7067d191ede6','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1375998189','fab57e2a-6be8-4888-9705-5ff23fd7e69a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1158,'e4009991-1e0c-49dd-8e0d-cbfee7557d91','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk','876878a6-95f6-49e5-bac0-26e70ec9adca','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1159,'062fb91d-da51-4142-a5c1-bc606b4d1f4d','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1160,'0a6c2f1f-f6a0-4591-b4db-57a58081445d','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf','ca79085e-1ca6-4079-b3b5-820adecfa6d5','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1161,'d5690872-0909-4972-b87b-e2954fd079a2','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1162,'00c33071-c259-4417-af73-8dc00c242701','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','server','63a6e5b9-d23e-4011-93c4-06a91ccfe0d5','state changed','OS::Nova::Server',NULL,216),(1163,'785cdb53-a87f-4288-84e8-73766cb69137','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:14',NULL,'DELETE','IN_PROGRESS','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1164,'0092d4c0-8042-472f-b61b-7f5972cbcdab','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:14',NULL,'CREATE','COMPLETE','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1165,'5cfd45ca-1a63-4355-b96c-8135e9d0705e','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:14',NULL,'SIGNAL','IN_PROGRESS','0','ace86538-4feb-4f11-bbe2-132ceeb8b19f','Signal: deployment ace86538-4feb-4f11-bbe2-132ceeb8b19f succeeded','OS::Heat::SoftwareDeployment',NULL,204),(1166,'4d04e7e6-a8d4-4344-a32b-94bdb93d92fd','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:14',NULL,'DELETE','IN_PROGRESS','foo_step3','HooksTest-1805989431-foo_step3-lhoswwkfc2ms','state changed','OS::Heat::RandomString',NULL,NULL),(1167,'fce9b0f7-9d35-422b-a12c-2d86b5654a28','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:14',NULL,'DELETE','COMPLETE','foo_step3','HooksTest-1805989431-foo_step3-lhoswwkfc2ms','state changed','OS::Heat::RandomString',NULL,NULL),(1168,'05dd9c07-611f-4973-b9a2-7b8157ddd16b','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:14',NULL,'SIGNAL','IN_PROGRESS','0','24276c1f-636a-475b-8413-cab173b5aac5','Signal: deployment 24276c1f-636a-475b-8413-cab173b5aac5 succeeded','OS::Heat::SoftwareDeployment',NULL,207),(1169,'7c35a4d0-7968-46e1-9474-bf1105e49142','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','dep_3','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','state changed','OS::Heat::SoftwareDeployments',NULL,191),(1170,'fa92f2d9-9d47-445e-88da-5506e53484a4','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','dep_2','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1171,'8c115f2f-4f79-4287-9035-1ee0494977f6','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','dep_1','876878a6-95f6-49e5-bac0-26e70ec9adca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1172,'028bea23-a420-4acd-98f9-eef2e688e4ea','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:15',NULL,'SIGNAL','IN_PROGRESS','0','9b8b5db2-03a9-47b4-baac-742970e2e6c2','Signal: deployment 9b8b5db2-03a9-47b4-baac-742970e2e6c2 succeeded','OS::Heat::SoftwareDeployment',NULL,205),(1173,'262349f9-273d-4717-9196-e44232e3b344','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','dep_4','ca79085e-1ca6-4079-b3b5-820adecfa6d5','state changed','OS::Heat::SoftwareDeployments',NULL,190),(1174,'f70a74f7-6716-4dbe-b6f4-f4cca6686259','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','0','9b8b5db2-03a9-47b4-baac-742970e2e6c2','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1175,'45fb9e0b-5c50-451f-8802-ee56bcefc2e0','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','0','bba9a68c-9566-42a5-80d8-38809ab1c70c','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1176,'3578e0fb-7759-4774-b6c7-240971173434','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','0','ace86538-4feb-4f11-bbe2-132ceeb8b19f','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1177,'d7672771-e93a-4535-ba7f-8afe50cec8d4','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','0','24276c1f-636a-475b-8413-cab173b5aac5','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1178,'8fbcd35c-4c56-4a5f-b177-5ba936edb150','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo','a9331ed6-4247-4121-ab61-082bb2f6211e','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1179,'f2d1fbc3-a475-4d00-81b0-7fa708988561','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1180,'0a2fe362-1f93-4295-af85-575c15197791','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces','c94b83d2-5c79-451b-8ca3-b564e01091bc','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1181,'69ad70e9-3a20-440f-b81d-244cb9399a80','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:15',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd','2b3397b5-dce8-4bf4-aa95-537d9d366039','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1182,'c35f1191-2b2a-4e49-aabb-8eae26f0c394','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:15',NULL,'DELETE','IN_PROGRESS','foo_step2','HooksTest-1805989431-foo_step2-ijfocc6jyhpe','state changed','OS::Heat::RandomString',NULL,224),(1183,'1411706c-905f-46ba-b908-322bc042e08a','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:15',NULL,'DELETE','COMPLETE','foo_step2','HooksTest-1805989431-foo_step2-ijfocc6jyhpe','state changed','OS::Heat::RandomString',NULL,224),(1184,'ae511ee9-927c-4c93-8c79-9d9afa5cb7dc','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:15',NULL,'DELETE','IN_PROGRESS','foo_step1','HooksTest-1805989431-foo_step1-oyfbgsnagwfp','state changed','OS::Heat::RandomString',NULL,NULL),(1185,'89b36c51-ae7a-4615-9203-f30b7809279b','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:15',NULL,'DELETE','COMPLETE','foo_step1','HooksTest-1805989431-foo_step1-oyfbgsnagwfp','state changed','OS::Heat::RandomString',NULL,NULL),(1186,'ad6370bc-ff88-40bd-8f7b-0b9f763f27a7','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:56:16',NULL,'DELETE','COMPLETE','HooksTest-1805989431','1f92bcda-cc59-4806-a482-5fa9ca1d0f58','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1187,'272d5368-cd43-45ce-8b9c-3358c67bb8fa','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:16',NULL,'CREATE','COMPLETE','dep_2','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1188,'b855c1de-a903-4170-a4c1-25e3697439e8','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:16',NULL,'CREATE','COMPLETE','dep_0','c94b83d2-5c79-451b-8ca3-b564e01091bc','state changed','OS::Heat::SoftwareDeployments',NULL,192),(1189,'ef64c140-0a59-4198-9c4a-49d48bf0b425','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:16',NULL,'CREATE','COMPLETE','dep_0','2b3397b5-dce8-4bf4-aa95-537d9d366039','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1190,'0a8abfb8-9b01-4088-b121-79dead7bd3cb','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:16',NULL,'CREATE','COMPLETE','dep_1','a9331ed6-4247-4121-ab61-082bb2f6211e','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1191,'844b9cca-64f7-4475-94aa-b8d5fe614bb0','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:16',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-218845895','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1192,'f5ac884d-7735-476b-9884-723e4e0f5c47','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:17',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-269394896','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1193,'8a7c6644-bf89-4703-8b83-750a03d6c4a1','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:20',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1006090207','03b07b2a-f62f-43d4-a292-4939980296c0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1194,'28165eef-8cf5-4b27-8e72-a6b8d5ea8340','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:20',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1195,'718855ed-f91b-4bad-a55d-dc6ee0ef1331','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:20',NULL,'DELETE','IN_PROGRESS','dep_1','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1196,'58a4f7af-df25-41d6-b335-b422468b506b','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:20',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1197,'5bd5c406-1bcb-46f7-a23d-8878a3df9965','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:20',NULL,'CREATE','IN_PROGRESS','parent','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','state changed','1.yaml',NULL,NULL),(1198,'648f3d05-9309-4f61-b639-f3e17a99f86c','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:20',NULL,'DELETE','IN_PROGRESS','0','d54768e0-c0fc-4dff-899f-59a6fecfade8','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1199,'3eae82aa-f8bf-4b16-bd2e-0dec6cb966b5','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:20',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1200,'a4879e69-a7ec-42d1-abb5-8aa62a6aeb85','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:21',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_a-45eg35ozpb7u','state changed','OS::Heat::TestResource',NULL,226),(1201,'802f4aa8-dc60-4c05-8f45-1c2e618cff23','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:21',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_a-45eg35ozpb7u','state changed','OS::Heat::TestResource',NULL,226),(1202,'7484fdf0-97f4-4771-b84a-8f892fe913e3','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:21',NULL,'DELETE','IN_PROGRESS','dep_0','fce72fa2-5a0b-4527-8a2d-50360121335c','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1203,'ad85d011-8aeb-4d84-b38e-3a30c7ba7b2c','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:21',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff','fce72fa2-5a0b-4527-8a2d-50360121335c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1204,'0a27fce1-92fd-47eb-8ca5-beb746513424','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:21',NULL,'DELETE','IN_PROGRESS','0','8ae26553-b6eb-4262-bf24-b416cd8d1406','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1205,'6969f59b-a61e-42ac-a87a-d8c41b216db5','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:21',NULL,'UPDATE','IN_PROGRESS','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1206,'3491e1d6-ef82-41a2-a651-b1e4ef47028e','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:22',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_b-vjb6knwdqrot','state changed','OS::Heat::TestResource',NULL,227),(1207,'81088aad-fd39-49a2-98e8-828f09ef6267','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:22',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_b-vjb6knwdqrot','state changed','OS::Heat::TestResource',NULL,227),(1208,'1c24ecb2-0f9e-4b35-8c15-0b15f9b2fcd9','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:22',NULL,'CREATE','COMPLETE','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1209,'01cb05c0-1991-4c19-a702-9a2be26054a4','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:22',NULL,'DELETE','COMPLETE','0','d54768e0-c0fc-4dff-899f-59a6fecfade8','state changed','OS::Heat::SoftwareDeployment',NULL,221),(1210,'b285f6be-5b34-4f5a-ad63-f0a3815fbc06','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:56:22',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1211,'6b6b92c2-62d1-4c4a-8243-95fc694864ef','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:22',NULL,'DELETE','IN_PROGRESS','dep_2','bb6e480a-bfd4-4d75-953c-7faa946564f9','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1212,'6ed49539-e138-4d3c-94d4-078b4b56329f','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:22',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257','bb6e480a-bfd4-4d75-953c-7faa946564f9','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1213,'fe58c76d-1904-4b07-80d9-43576e90d124','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:22',NULL,'DELETE','COMPLETE','dep_1','e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','state changed','OS::Heat::SoftwareDeployments',NULL,218),(1214,'cfeba4ad-3be2-4580-920c-4bc35ede389f','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:22',NULL,'DELETE','IN_PROGRESS','0','34b8969d-78db-486c-b088-cc70fa70d8bf','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1215,'4f48b18f-431d-488d-bee4-4c9311c5cb94','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:22',NULL,'CREATE','COMPLETE','parent','dcf2c6e8-e722-4a9a-a816-3d5742207356','state changed','1.yaml',NULL,NULL),(1216,'6169ce93-d9fb-4301-8ef5-c8643ba7aed1','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:22',NULL,'CREATE','COMPLETE','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1217,'2a14a044-1b03-4e22-ab74-57a296e55b9b','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:22',NULL,'UPDATE','IN_PROGRESS','server','63a6e5b9-d23e-4011-93c4-06a91ccfe0d5','state changed','OS::Nova::Server',NULL,216),(1218,'d8ca1ebf-a581-49d8-9c76-6d0d8ee32a7d','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:22',NULL,'DELETE','COMPLETE','0','8ae26553-b6eb-4262-bf24-b416cd8d1406','state changed','OS::Heat::SoftwareDeployment',NULL,222),(1219,'071ef737-bab9-47af-a0db-2d46abe9801e','fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:56:22',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff','fce72fa2-5a0b-4527-8a2d-50360121335c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1220,'fab3bf06-4793-4a49-837d-0f58a2c086aa','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:23',NULL,'DELETE','COMPLETE','0','34b8969d-78db-486c-b088-cc70fa70d8bf','state changed','OS::Heat::SoftwareDeployment',NULL,223),(1221,'00d273d3-e071-45db-a29a-abcf41234566','bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:56:23',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257','bb6e480a-bfd4-4d75-953c-7faa946564f9','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1222,'128fe8d7-5b7f-404a-a49d-0df434e7808c','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:23',NULL,'DELETE','COMPLETE','dep_0','fce72fa2-5a0b-4527-8a2d-50360121335c','state changed','OS::Heat::SoftwareDeployments',NULL,219),(1223,'f3a549a0-d6e6-47c6-861e-94af89092201','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:24',NULL,'DELETE','COMPLETE','dep_2','bb6e480a-bfd4-4d75-953c-7faa946564f9','state changed','OS::Heat::SoftwareDeployments',NULL,220),(1224,'c6ece54c-47c2-4d08-8bc3-f63452513b4b','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:24',NULL,'DELETE','IN_PROGRESS','config','71f022f4-74f0-440c-bf6f-28c7cbbde1b9','state changed','OS::Heat::SoftwareConfig',NULL,217),(1225,'a3c570db-6a16-4290-86ff-03df457511b2','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:25',NULL,'DELETE','COMPLETE','config','71f022f4-74f0-440c-bf6f-28c7cbbde1b9','state changed','OS::Heat::SoftwareConfig',NULL,217),(1226,'3e9aeb2f-691e-4552-8361-d840bb1bfdcb','03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:56:25',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1006090207','03b07b2a-f62f-43d4-a292-4939980296c0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1227,'c3045e01-0930-4132-bc50-807e6f38aac3','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:25',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1228,'cb3614d0-74bb-4059-aa65-238797b57b61','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:25',NULL,'UPDATE','IN_PROGRESS','parent','dcf2c6e8-e722-4a9a-a816-3d5742207356','state changed','1.yaml',NULL,NULL),(1229,'e886cf07-f1a2-453d-baa2-3559481f49a9','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:26',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1230,'e883e963-b3d9-404c-9bf1-194014ac3c14','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:26',NULL,'UPDATE','COMPLETE','server','63a6e5b9-d23e-4011-93c4-06a91ccfe0d5','state changed','OS::Nova::Server',NULL,228),(1231,'ae7b712a-70b8-49ea-a2cb-bcb77d7b345c','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:26',NULL,'UPDATE','COMPLETE','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1232,'005d809c-3556-4bb5-b7a6-e333c699e269','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:27',NULL,'UPDATE','COMPLETE','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1233,'b2cd1d38-4a7a-46a1-bd0f-38ba5a64eed1','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:28',NULL,'UPDATE','COMPLETE','parent','dcf2c6e8-e722-4a9a-a816-3d5742207356','state changed','1.yaml',NULL,NULL),(1234,'41e689b1-5429-4f08-9241-2fd84fd7e3ca','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:29',NULL,'UPDATE','COMPLETE','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1235,'704eab89-93e3-43fe-8371-42b2833bd96a','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:29',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1375998189','fab57e2a-6be8-4888-9705-5ff23fd7e69a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1236,'704e605e-98e4-433e-af00-6d6c998a80b3','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:30',NULL,'DELETE','IN_PROGRESS','dep_2','9b280d66-4c0d-4819-af76-36514cc68d89','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1237,'a1fbeba1-c866-4e39-92cd-4b29df81d06a','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:30',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g','9b280d66-4c0d-4819-af76-36514cc68d89','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1238,'c4912ccf-964b-4a75-8d8a-b956a46ba329','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:30',NULL,'DELETE','IN_PROGRESS','0','05e05c17-b02e-4c16-bf5e-20584915df68','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1239,'6d61b865-c793-4724-aff6-3bfdcfde7cb3','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:30',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1240,'961f3465-c4e1-4b19-a6e8-fdd5100c3273','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','parent','dcf2c6e8-e722-4a9a-a816-3d5742207356','state changed','1.yaml',NULL,NULL),(1241,'c45c6fc4-2cbb-4210-a02a-db999e668542','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','dep_1','09ac263d-b621-4142-a590-7a996ff26cfb','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1242,'e7953a1a-348c-48ba-be13-0e9dc28d1cca','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1243,'fe0da391-968f-4d66-bb1c-e5a942b81443','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r','09ac263d-b621-4142-a590-7a996ff26cfb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1244,'52895157-0d49-43d6-9aed-2dddfcc23b59','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_b-vjb6knwdqrot','state changed','OS::Heat::TestResource',NULL,227),(1245,'f4810cd2-0bb8-4152-9ad6-269ee98718cb','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:31',NULL,'DELETE','IN_PROGRESS','0','dffb0b03-3f98-4c36-b3ee-63be3ad745cc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1246,'12def9d1-520a-4783-895d-96ec4ca000e1','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:31',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_b-vjb6knwdqrot','state changed','OS::Heat::TestResource',NULL,227),(1247,'52a700df-5fd2-4a1f-9c1a-dfdd9f1f7efd','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:31',NULL,'DELETE','COMPLETE','0','05e05c17-b02e-4c16-bf5e-20584915df68','state changed','OS::Heat::SoftwareDeployment',NULL,214),(1248,'79cd65f3-7af4-4822-9271-db7ba55fc241','9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:56:31',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g','9b280d66-4c0d-4819-af76-36514cc68d89','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1249,'3aadc72f-07eb-40c8-b3f6-fb0fa5170d36','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:32',NULL,'DELETE','IN_PROGRESS','dep_0','a5db7eca-245b-42fd-85e6-a681b854992b','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1250,'b4acc1df-5811-47a5-bc75-4a6c6c701b25','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:32',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni','a5db7eca-245b-42fd-85e6-a681b854992b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1251,'1ed53070-b1be-4de8-b55a-1fd571857a3f','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:32',NULL,'DELETE','COMPLETE','dep_2','9b280d66-4c0d-4819-af76-36514cc68d89','state changed','OS::Heat::SoftwareDeployments',NULL,210),(1252,'b25abe52-bf5a-4cdb-98f1-cb2552b5a50a','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:32',NULL,'DELETE','COMPLETE','0','dffb0b03-3f98-4c36-b3ee-63be3ad745cc','state changed','OS::Heat::SoftwareDeployment',NULL,215),(1253,'98b6fe41-9735-468f-839c-c5e6945bc6c7','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:32',NULL,'DELETE','IN_PROGRESS','0','02f95c19-38bf-408d-8822-9c2733f833ca','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1254,'632e5846-48f1-417f-ae3a-8341785602cf','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:32',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_a-45eg35ozpb7u','state changed','OS::Heat::TestResource',NULL,226),(1255,'5f2ccf5a-c0ee-4e82-aef7-aa8e579a098e','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:32',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1518396458-parent-74m4rcnd7gxu-test_resource_a-45eg35ozpb7u','state changed','OS::Heat::TestResource',NULL,226),(1256,'fbbee250-378c-4a9a-a7f7-b6a9175c6d8b','09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:56:32',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r','09ac263d-b621-4142-a590-7a996ff26cfb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1257,'a26fc01d-70e3-4328-ad59-24ef77134559','dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:32',NULL,'DELETE','COMPLETE','StackOutputsTest-1518396458-parent-74m4rcnd7gxu','dcf2c6e8-e722-4a9a-a816-3d5742207356','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1258,'b23ceb27-1a4d-4cec-9dd5-f12924e946d9','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:33',NULL,'DELETE','IN_PROGRESS','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1259,'9184891a-fb6e-49be-bbc2-2210cebcf754','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:33',NULL,'DELETE','IN_PROGRESS','server','63a6e5b9-d23e-4011-93c4-06a91ccfe0d5','state changed','OS::Nova::Server',NULL,228),(1260,'c51bdce7-9166-4d53-bbfe-e483b7b218c4','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:33',NULL,'DELETE','COMPLETE','dep_1','09ac263d-b621-4142-a590-7a996ff26cfb','state changed','OS::Heat::SoftwareDeployments',NULL,212),(1261,'7f7ecf6c-9fe1-4a6f-94a0-6febe259bdc3','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:33',NULL,'DELETE','COMPLETE','parent','dcf2c6e8-e722-4a9a-a816-3d5742207356','state changed','1.yaml',NULL,NULL),(1262,'e9459dfa-3241-4132-8a7e-e992bc20ebe9','e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:33',NULL,'DELETE','COMPLETE','StackOutputsTest-1518396458','e1852d79-9927-4210-bc89-af7c675cbd75','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1263,'b3fb1a1a-2cd0-4e5a-a8a4-cbd1d9639dcf','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:33',NULL,'DELETE','COMPLETE','0','02f95c19-38bf-408d-8822-9c2733f833ca','state changed','OS::Heat::SoftwareDeployment',NULL,213),(1264,'7596af86-0390-4799-a480-d05a0689a05a','a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:56:33',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni','a5db7eca-245b-42fd-85e6-a681b854992b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1265,'8fafd636-0483-4cb9-8e32-69d008f29dca','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:34',NULL,'DELETE','COMPLETE','dep_0','a5db7eca-245b-42fd-85e6-a681b854992b','state changed','OS::Heat::SoftwareDeployments',NULL,211),(1266,'36f098ac-a632-4ee3-b1b8-5efb103f2274','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:34',NULL,'DELETE','IN_PROGRESS','config','51da4ba3-5a3a-4080-9dc5-ac01240c1ac0','state changed','OS::Heat::SoftwareConfig',NULL,208),(1267,'54b695a8-2c0b-405c-9248-b76727942b57','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:34',NULL,'DELETE','COMPLETE','config','51da4ba3-5a3a-4080-9dc5-ac01240c1ac0','state changed','OS::Heat::SoftwareConfig',NULL,208),(1268,'02f5f958-6b28-41ad-bb78-1c7fff421584','fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:56:34',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1375998189','fab57e2a-6be8-4888-9705-5ff23fd7e69a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1269,'d6e74c79-e40e-46d0-af34-22a600077e72','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:35',NULL,'DELETE','COMPLETE','server','63a6e5b9-d23e-4011-93c4-06a91ccfe0d5','state changed','OS::Nova::Server',NULL,228),(1270,'e1461b6e-defd-450e-9e22-bab52f37c5c9','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:36',NULL,'DELETE','IN_PROGRESS','subnet','aefe4656-efc7-4733-a84b-1f4360f0d4d2','state changed','OS::Neutron::Subnet',NULL,209),(1271,'fc3da866-f0ad-42b1-a8ba-2bfdbe48c7b8','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:36',NULL,'DELETE','COMPLETE','subnet','aefe4656-efc7-4733-a84b-1f4360f0d4d2','state changed','OS::Neutron::Subnet',NULL,209),(1272,'f5af4403-81c3-4cbc-8498-22c675ff9ebe','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:36',NULL,'DELETE','IN_PROGRESS','net','94a1b7ae-57e3-4fe6-b60c-c503dccee1e1','state changed','OS::Neutron::Net',NULL,206),(1273,'d657f011-b30f-4b47-848b-df5da932b7cf','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:36',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-1814818406','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1274,'dbe3aa33-39d5-47ac-9729-8bf4793d17d9','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:37',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-1814818406-test_resource_b-pqinkiopmb2d','state changed','OS::Heat::TestResource',NULL,231),(1275,'9bdedc76-e75c-408a-8f17-e3fc98448940','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:37',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-1814818406-test_resource_b-pqinkiopmb2d','state changed','OS::Heat::TestResource',NULL,231),(1276,'a4d9da8a-5330-4b03-a4a7-47a3e158a672','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:37',NULL,'DELETE','COMPLETE','net','94a1b7ae-57e3-4fe6-b60c-c503dccee1e1','state changed','OS::Neutron::Net',NULL,206),(1277,'0971e114-f659-4808-921b-2cf8b8a4a107','66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:56:37',NULL,'DELETE','COMPLETE','swap_subnet_network','66f6a281-48a6-4053-b4c6-49d5d8e96121','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1278,'b6bfb15d-6558-47f7-ae01-3758f4d96d41','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:38',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-1814818406-test_resource_a-mm3xyzhsj4be','state changed','OS::Heat::TestResource',NULL,232),(1279,'fd7bd024-ec06-4481-8ee2-6c8c271b8b5a','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:38',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-1814818406-test_resource_a-mm3xyzhsj4be','state changed','OS::Heat::TestResource',NULL,232),(1280,'c6b61e96-1ba4-48ed-be31-2f2472523574','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:38',NULL,'CREATE','COMPLETE','StackOutputsTest-1814818406','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1281,'542dc0c5-e07f-4815-aa34-319f5fa9a1f1','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:39',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-269394896','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1282,'7e331d66-17b7-41cc-8bbc-8f71c1133295','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:40',NULL,'DELETE','IN_PROGRESS','dep_0','2b3397b5-dce8-4bf4-aa95-537d9d366039','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1283,'4d6a1cfd-1bad-45a0-ba5e-62bb88840d89','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:41',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd','2b3397b5-dce8-4bf4-aa95-537d9d366039','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1284,'7e27b6ab-343a-461e-9519-7552ea4e299e','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:41',NULL,'DELETE','IN_PROGRESS','dep_2','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1285,'dfbbd620-7c47-40e5-9070-7e65138eec7d','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:42',NULL,'DELETE','IN_PROGRESS','0','ace86538-4feb-4f11-bbe2-132ceeb8b19f','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1286,'7a57336b-6f5e-4e53-8297-063f71ed8afe','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:42',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1287,'299eb9f3-851d-4aad-9cba-2d734077e63a','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','dep_1','a9331ed6-4247-4121-ab61-082bb2f6211e','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1288,'9e1f310d-946f-45b4-8362-36516b3e6ffa','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','0','24276c1f-636a-475b-8413-cab173b5aac5','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1289,'e8f3917d-252c-49d1-9302-45960a830a7d','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo','a9331ed6-4247-4121-ab61-082bb2f6211e','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1290,'230d5aeb-18e2-4cfc-8bb3-045f1ef6ed33','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','0','9b8b5db2-03a9-47b4-baac-742970e2e6c2','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1291,'600d7cdb-7c08-428d-9c5e-5d7c361af48f','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-1814818406','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1292,'374d34c0-2310-4618-b884-ec826d653328','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:43',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-1814818406-test_resource_a-mm3xyzhsj4be','state changed','OS::Heat::TestResource',NULL,232),(1293,'1b574e2b-30b5-458b-be1c-8996772956f7','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:43',NULL,'CREATE','IN_PROGRESS','StackEventsTest-632118980','7cfc803b-d511-477e-be1f-fee8674a6efa','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1294,'84d058f9-34f2-4da1-ba3c-124683cd4192','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:43',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-1814818406-test_resource_a-mm3xyzhsj4be','state changed','OS::Heat::TestResource',NULL,232),(1295,'95df6db3-3d0d-424c-8636-e57c564a9afb','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:44',NULL,'CREATE','IN_PROGRESS','test_resource','StackEventsTest-632118980-test_resource-3djvi2w4n7mv','state changed','OS::Heat::TestResource',NULL,233),(1296,'6de501c5-6046-4aee-b65f-8027ec7988f3','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:44',NULL,'CREATE','COMPLETE','test_resource','StackEventsTest-632118980-test_resource-3djvi2w4n7mv','state changed','OS::Heat::TestResource',NULL,233),(1297,'e87f56d9-2f50-4cba-b62b-fb9a7624c2ac','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:44',NULL,'CREATE','COMPLETE','StackEventsTest-632118980','7cfc803b-d511-477e-be1f-fee8674a6efa','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1298,'05395e23-ed9b-4207-bb5a-8394a4bc5017','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','0','ace86538-4feb-4f11-bbe2-132ceeb8b19f','state changed','OS::Heat::SoftwareDeployment',NULL,204),(1299,'655c145b-5a7c-41ba-a0fd-7fba55757232','2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd','2b3397b5-dce8-4bf4-aa95-537d9d366039','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1300,'13d1bbbe-9f75-4efc-914f-79390df56572','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','0','9b8b5db2-03a9-47b4-baac-742970e2e6c2','state changed','OS::Heat::SoftwareDeployment',NULL,205),(1301,'cbbd0cd4-f64a-4d2f-9d70-ac3a6598e0fc','a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo','a9331ed6-4247-4121-ab61-082bb2f6211e','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1302,'08628164-a343-4238-927c-1b7c84bc034b','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','0','24276c1f-636a-475b-8413-cab173b5aac5','state changed','OS::Heat::SoftwareDeployment',NULL,207),(1303,'3d356896-bb3e-4d80-ba48-cb4698181a9b','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1304,'1289d765-dee1-42c3-a1cd-83385c38ce30','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:44',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-1814818406-test_resource_b-pqinkiopmb2d','state changed','OS::Heat::TestResource',NULL,231),(1305,'21c3ebec-b8ed-41a3-9db8-b076a05d55e3','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-1814818406-test_resource_b-pqinkiopmb2d','state changed','OS::Heat::TestResource',NULL,231),(1306,'9713b2d6-46d1-44bd-99b3-31026e5086c9','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:44',NULL,'DELETE','COMPLETE','dep_0','2b3397b5-dce8-4bf4-aa95-537d9d366039','state changed','OS::Heat::SoftwareDeployments',NULL,201),(1307,'a2f8c863-3b83-4903-8017-fee74e5ac2d4','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:45',NULL,'DELETE','COMPLETE','StackOutputsTest-1814818406','1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1308,'c505102a-7135-4472-9612-433f8a941fa7','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:45',NULL,'DELETE','COMPLETE','dep_2','4fb4c1a9-bd7c-4f60-8603-c55d220b3697','state changed','OS::Heat::SoftwareDeployments',NULL,203),(1309,'c27601ea-60a5-433d-9293-3fac12d718e7','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:45',NULL,'DELETE','COMPLETE','dep_1','a9331ed6-4247-4121-ab61-082bb2f6211e','state changed','OS::Heat::SoftwareDeployments',NULL,202),(1310,'2000a721-22f0-4d0a-ac8f-af964d8ec2fc','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:45',NULL,'DELETE','IN_PROGRESS','config','0a394036-a9cb-4790-a393-a17519c45099','state changed','OS::Heat::SoftwareConfig',NULL,200),(1311,'ac823e5a-f2b5-4164-b83c-ad8c213c2377','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:45',NULL,'DELETE','COMPLETE','config','0a394036-a9cb-4790-a393-a17519c45099','state changed','OS::Heat::SoftwareConfig',NULL,200),(1312,'d8a30b94-a64a-498b-a8b7-6433f77d2fca','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:56:45',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-269394896','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1313,'b6a278a1-f59f-493a-96ea-c97a7b28f993','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:48',NULL,'DELETE','IN_PROGRESS','StackEventsTest-632118980','7cfc803b-d511-477e-be1f-fee8674a6efa','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1314,'ff9c8742-293f-4a6d-a1e7-7a84cce566aa','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:48',NULL,'DELETE','IN_PROGRESS','test_resource','StackEventsTest-632118980-test_resource-3djvi2w4n7mv','state changed','OS::Heat::TestResource',NULL,233),(1315,'a76093e9-f191-4b93-b0a9-9c2ddc55bd46','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:48',NULL,'DELETE','COMPLETE','test_resource','StackEventsTest-632118980-test_resource-3djvi2w4n7mv','state changed','OS::Heat::TestResource',NULL,233),(1316,'422a9b42-c5f4-4b10-9820-fca56f408896','7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:48',NULL,'DELETE','COMPLETE','StackEventsTest-632118980','7cfc803b-d511-477e-be1f-fee8674a6efa','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1317,'c74e6404-f3a9-4c74-89bc-04e0774c8bb4','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:50',NULL,'CREATE','IN_PROGRESS','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1318,'484b5ace-c1c8-4604-8fd8-b652c71a9cd7','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:50',NULL,'CREATE','IN_PROGRESS','test_resource_a','StackOutputsTest-565959838-test_resource_a-7sfc627cryyx','state changed','OS::Heat::TestResource',NULL,234),(1319,'42a2b1fd-d67d-4e9b-b9d2-735564f441ab','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:50',NULL,'CREATE','COMPLETE','test_resource_a','StackOutputsTest-565959838-test_resource_a-7sfc627cryyx','state changed','OS::Heat::TestResource',NULL,234),(1320,'518a6665-c727-4b1e-99c6-4548aa69f808','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:50',NULL,'CREATE','COMPLETE','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1321,'19a45a3c-2742-4dde-aa7f-fc25eddbc827','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:51',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1322,'f76697fd-5842-414f-8571-4eea0da4fb6e','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:51',NULL,'DELETE','IN_PROGRESS','dep_1','876878a6-95f6-49e5-bac0-26e70ec9adca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1323,'e9ac5a95-6374-4278-8cde-bb829b7a5dd3','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:51',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk','876878a6-95f6-49e5-bac0-26e70ec9adca','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1324,'7c39f3db-d68a-42f1-8ac6-11665760ce2c','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:51',NULL,'DELETE','IN_PROGRESS','0','425d8f42-5803-4c3c-b29c-777dfef00020','state changed','OS::Heat::SoftwareDeployment',NULL,197),(1325,'10cc0a89-5806-44ec-bc3c-37683150b22c','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:51',NULL,'UPDATE','IN_PROGRESS','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1326,'5cab42a8-f6ba-402d-a096-4c19d6762ca4','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:52',NULL,'CREATE','IN_PROGRESS','test_resource_b','StackOutputsTest-565959838-test_resource_b-64m6fmfalu7i','state changed','OS::Heat::TestResource',NULL,235),(1327,'c440419f-59a7-4d45-90af-158260c31cfc','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:52',NULL,'CREATE','COMPLETE','test_resource_b','StackOutputsTest-565959838-test_resource_b-64m6fmfalu7i','state changed','OS::Heat::TestResource',NULL,235),(1328,'dce4809b-b43e-4cc9-b3c4-d81cf4a90220','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:52',NULL,'UPDATE','COMPLETE','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1329,'ae09fa19-f55f-43bc-8b23-3b9ccc495b45','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:52',NULL,'DELETE','COMPLETE','0','425d8f42-5803-4c3c-b29c-777dfef00020','state changed','OS::Heat::SoftwareDeployment',NULL,197),(1330,'6df5a195-cfe4-4ad0-8c65-0191563cd119','876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:56:52',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk','876878a6-95f6-49e5-bac0-26e70ec9adca','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1331,'10cf5511-f01f-4f48-97b8-388b9468edf7','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:52',NULL,'DELETE','IN_PROGRESS','dep_3','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','state changed','OS::Heat::SoftwareDeployments',NULL,191),(1332,'d78cce40-8ee5-4951-a8bf-f2ccc838f22f','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:52',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1333,'75a41dc3-e2b9-472d-a6e1-2b4eee9c9ab0','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:52',NULL,'DELETE','IN_PROGRESS','0','19ade2b0-8700-49cf-aa54-c754bd6d0f15','state changed','OS::Heat::SoftwareDeployment',NULL,195),(1334,'05287d2e-4089-4137-b995-e17d6b8d5eec','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:52',NULL,'DELETE','COMPLETE','dep_1','876878a6-95f6-49e5-bac0-26e70ec9adca','state changed','OS::Heat::SoftwareDeployments',NULL,194),(1335,'db20b83e-d715-4f43-ae4a-80d99fb2f6ec','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','dep_0','c94b83d2-5c79-451b-8ca3-b564e01091bc','state changed','OS::Heat::SoftwareDeployments',NULL,192),(1336,'2093efd1-5ec7-4de4-b650-87cb26eefbaf','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces','c94b83d2-5c79-451b-8ca3-b564e01091bc','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1337,'014349d3-3bd7-4ccc-a1c1-f47370e5941a','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','dep_4','ca79085e-1ca6-4079-b3b5-820adecfa6d5','state changed','OS::Heat::SoftwareDeployments',NULL,190),(1338,'2d6f1704-dedc-46a7-8b0e-58b45c81d97b','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf','ca79085e-1ca6-4079-b3b5-820adecfa6d5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1339,'fc22e696-9de5-4cf0-9dcc-86c195bf302c','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','0','bba9a68c-9566-42a5-80d8-38809ab1c70c','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1340,'be1b9c84-b312-44dc-92ff-6f6755310fb7','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:54',NULL,'DELETE','COMPLETE','0','19ade2b0-8700-49cf-aa54-c754bd6d0f15','state changed','OS::Heat::SoftwareDeployment',NULL,195),(1341,'f7f4133d-3390-411f-9c4c-5d991ccccc78','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:54',NULL,'DELETE','IN_PROGRESS','0','fe44ad61-9e93-4088-9e74-a4d2ea4d4d43','state changed','OS::Heat::SoftwareDeployment',NULL,196),(1342,'8d0f88f4-4f8a-4741-b554-fcc78a8fc2ef','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:56:54',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1343,'daa674ca-b33f-4869-806a-6618f4d31260','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','dep_3','b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','state changed','OS::Heat::SoftwareDeployments',NULL,191),(1344,'a4e5a379-1b48-4d3f-9580-f87bcdb4cd59','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','0','bba9a68c-9566-42a5-80d8-38809ab1c70c','state changed','OS::Heat::SoftwareDeployment',NULL,198),(1345,'eca0a35f-a127-428d-8da3-73592ab4d955','c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces','c94b83d2-5c79-451b-8ca3-b564e01091bc','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1346,'3066c95c-5f14-4fac-b525-ea75f2110e88','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','0','fe44ad61-9e93-4088-9e74-a4d2ea4d4d43','state changed','OS::Heat::SoftwareDeployment',NULL,196),(1347,'f9d51e6b-0253-44f0-936b-5b4539824e61','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','dep_0','c94b83d2-5c79-451b-8ca3-b564e01091bc','state changed','OS::Heat::SoftwareDeployments',NULL,192),(1348,'869ebacf-127e-4050-838b-c938730ccda1','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:55',NULL,'DELETE','IN_PROGRESS','dep_2','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1349,'d01275ad-26a0-4faa-b747-ccfa60852f40','ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf','ca79085e-1ca6-4079-b3b5-820adecfa6d5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1350,'e76e31ae-c164-4c9f-8b40-46873fe90b25','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:55',NULL,'DELETE','COMPLETE','dep_4','ca79085e-1ca6-4079-b3b5-820adecfa6d5','state changed','OS::Heat::SoftwareDeployments',NULL,190),(1351,'7557b1e2-731c-4a16-bd57-89a43103c0b9','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:55',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1352,'300af03a-300f-4a86-8a73-eeec4d330f74','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:55',NULL,'DELETE','IN_PROGRESS','0','8e4aeb55-c7c0-492c-9f33-3aa64ff97765','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1353,'8d8c4ff4-ade0-44b7-8d56-0d5a20ab6630','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:56:55',NULL,'CREATE','IN_PROGRESS','StackTagTest-2092522984','603a193f-38e1-4ba4-adff-2608856255f3','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1354,'0d5d632b-6982-48ef-908f-d16571c72a1c','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:56:55',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-2092522984-not-used-v4y7f65wukdw','state changed','OS::Heat::TestResource',NULL,236),(1355,'cbe8e2f1-82a1-47d0-a620-d721e6759ccd','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','0','8e4aeb55-c7c0-492c-9f33-3aa64ff97765','state changed','OS::Heat::SoftwareDeployment',NULL,199),(1356,'a196bd06-f9ca-4cec-b410-d6d60412bdd1','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1357,'c2c15590-0e5d-4f8b-aa16-f689f080c95e','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','dep_2','1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','state changed','OS::Heat::SoftwareDeployments',NULL,193),(1358,'47405840-c0a2-40da-8232-9a42b1ffa8d8','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:56',NULL,'DELETE','IN_PROGRESS','config','3cc252a8-398e-4a67-9276-e44e75a3c773','state changed','OS::Heat::SoftwareConfig',NULL,189),(1359,'2c452f15-3a64-47a6-9934-af7dc7c3e381','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','config','3cc252a8-398e-4a67-9276-e44e75a3c773','state changed','OS::Heat::SoftwareConfig',NULL,189),(1360,'6fe4102d-c228-4271-8b79-40efe869b264','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-218845895','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1361,'15b636f2-2f6e-46ff-9d99-0dec04392836','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:56',NULL,'DELETE','IN_PROGRESS','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1362,'15ad5394-4812-4b3f-adf3-a5c7f7c2131b','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:56',NULL,'DELETE','IN_PROGRESS','test_resource_b','StackOutputsTest-565959838-test_resource_b-64m6fmfalu7i','state changed','OS::Heat::TestResource',NULL,235),(1363,'be52afd1-c89a-4b9a-8f1c-1914336a3179','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:56',NULL,'DELETE','COMPLETE','test_resource_b','StackOutputsTest-565959838-test_resource_b-64m6fmfalu7i','state changed','OS::Heat::TestResource',NULL,235),(1364,'1727863f-0122-41ce-88f1-f173d1504070','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:57',NULL,'DELETE','IN_PROGRESS','test_resource_a','StackOutputsTest-565959838-test_resource_a-7sfc627cryyx','state changed','OS::Heat::TestResource',NULL,234),(1365,'5fe6d291-f55e-492d-b10d-e84226fed74f','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:57',NULL,'DELETE','COMPLETE','test_resource_a','StackOutputsTest-565959838-test_resource_a-7sfc627cryyx','state changed','OS::Heat::TestResource',NULL,234),(1366,'71c624a2-d4d8-4d98-a326-e79e46698a1a','0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:57',NULL,'DELETE','COMPLETE','StackOutputsTest-565959838','0caf173f-db2a-4c41-a8a3-2b957a744eda','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1367,'e963f99e-3696-4cf0-9ee9-2776f6b476a6','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:56:57',NULL,'CREATE','COMPLETE','not-used','StackTagTest-2092522984-not-used-v4y7f65wukdw','state changed','OS::Heat::TestResource',NULL,236),(1368,'14958a36-e9e1-4057-b91a-10e05a4dfdd9','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:56:57',NULL,'CREATE','COMPLETE','StackTagTest-2092522984','603a193f-38e1-4ba4-adff-2608856255f3','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1369,'8cbdad9d-d0be-4cc5-ae48-41d72f2ea963','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:01',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404','bf3b6dfb-6ce1-4008-a718-2570a6107907','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1370,'f0df4eb8-a4a9-4869-b362-826b1c09de4a','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:02',NULL,'DELETE','IN_PROGRESS','dep_2','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','state changed','OS::Heat::SoftwareDeployments',NULL,182),(1371,'921dac23-89cc-4807-9482-d41871912c72','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:57:02',NULL,'DELETE','IN_PROGRESS','StackTagTest-2092522984','603a193f-38e1-4ba4-adff-2608856255f3','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1372,'3d4be5dc-b890-4567-ba69-ef2e4ef346a4','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:57:02',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1373,'494cf154-b1f5-4aa8-8c11-ad04711bc5c9','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:57:02',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-2092522984-not-used-v4y7f65wukdw','state changed','OS::Heat::TestResource',NULL,236),(1374,'29b8d54d-1afb-4641-b3b7-f45f8f308c29','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:57:02',NULL,'DELETE','IN_PROGRESS','0','c8338fa9-5d82-4898-bc0d-5ef8d3c00142','state changed','OS::Heat::SoftwareDeployment',NULL,187),(1375,'24c29fb4-b2f6-4761-9efe-a980a70b85f1','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:03',NULL,'DELETE','IN_PROGRESS','dep_1','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','state changed','OS::Heat::SoftwareDeployments',NULL,183),(1376,'5ce6f62b-a232-4a21-9e8c-b3dbbc3fad36','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:57:03',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1377,'dc0984f6-8566-44b9-b5f0-6136d07786fc','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:57:03',NULL,'DELETE','IN_PROGRESS','0','f8cf484b-84e9-4538-ab8f-000baaab619c','state changed','OS::Heat::SoftwareDeployment',NULL,188),(1378,'aa06ea6a-f784-4fe3-a8bd-43a6eb95e3c9','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:57:03',NULL,'DELETE','COMPLETE','0','c8338fa9-5d82-4898-bc0d-5ef8d3c00142','state changed','OS::Heat::SoftwareDeployment',NULL,187),(1379,'236f92a9-29d1-4319-83e1-b6617057e265','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:57:03',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1380,'ddaf7073-0b8f-4112-b14e-201076d7e2a7','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:04',NULL,'DELETE','IN_PROGRESS','dep_0','8707886f-7ca6-4279-8a25-33d4c65a87f7','state changed','OS::Heat::SoftwareDeployments',NULL,181),(1381,'30ed3101-2791-4a1b-8356-cc752067cf5b','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:57:04',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw','8707886f-7ca6-4279-8a25-33d4c65a87f7','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1382,'63f6c5c6-aca7-410d-87b0-7d77b84c7276','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:57:04',NULL,'DELETE','COMPLETE','0','f8cf484b-84e9-4538-ab8f-000baaab619c','state changed','OS::Heat::SoftwareDeployment',NULL,188),(1383,'05aacc44-3e18-4644-aebd-60ba7997a5a0','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:04',NULL,'DELETE','COMPLETE','dep_2','aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','state changed','OS::Heat::SoftwareDeployments',NULL,182),(1384,'67267c75-4872-423a-8587-599a5b47bc11','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:57:04',NULL,'DELETE','IN_PROGRESS','0','e789043f-005e-4ff3-872a-7835bffdc6e1','state changed','OS::Heat::SoftwareDeployment',NULL,184),(1385,'ce82c7c7-8be1-4021-ba5f-49a85576822e','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:57:04',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1386,'04675cb7-b9b1-4582-a1af-de51f0a60cf6','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:57:04',NULL,'DELETE','COMPLETE','not-used','StackTagTest-2092522984-not-used-v4y7f65wukdw','state changed','OS::Heat::TestResource',NULL,236),(1387,'6c954400-e46a-4507-9ceb-f821aadfdffb','603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:57:04',NULL,'DELETE','COMPLETE','StackTagTest-2092522984','603a193f-38e1-4ba4-adff-2608856255f3','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1388,'7582277c-0de2-4caa-b6f1-a5442f5b2a08','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:04',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322','9cde8460-8c64-454f-bb34-d30f29ee9056','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1389,'352dc43f-e71d-41e3-bcbd-5f4ccf767944','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:04',NULL,'CREATE','IN_PROGRESS','network_stack','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5','state changed','OS::Heat::Stack',NULL,237),(1390,'20ef629a-7b38-42f9-934f-da8dea3ec11a','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:57:05',NULL,'DELETE','COMPLETE','0','e789043f-005e-4ff3-872a-7835bffdc6e1','state changed','OS::Heat::SoftwareDeployment',NULL,184),(1391,'97b13935-54e0-4f0f-b727-8e502cc51088','8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:57:05',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw','8707886f-7ca6-4279-8a25-33d4c65a87f7','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1392,'157493c4-3396-465a-a45e-761c5f7b873d','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:05',NULL,'DELETE','COMPLETE','dep_1','eba7d579-7f3a-49f9-a764-e7bf3a46ac38','state changed','OS::Heat::SoftwareDeployments',NULL,183),(1393,'60ee9913-d8e1-40c0-aad7-80cfabc17d27','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:05',NULL,'DELETE','IN_PROGRESS','dep_4','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','state changed','OS::Heat::SoftwareDeployments',NULL,179),(1394,'648c0ddb-c404-49a3-a1ff-843753ee3bdf','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:57:05',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1395,'b739991b-a3c9-48ef-98dc-cac33360575d','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:57:05',NULL,'DELETE','IN_PROGRESS','0','f5fbc506-8944-468a-be80-52aba5fb0bb0','state changed','OS::Heat::SoftwareDeployment',NULL,185),(1396,'ba6854ad-dc49-4fba-b6a1-51d97cd11554','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:05',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5','1f8fe575-2886-4923-bb89-d7214b8c829b','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1397,'62e57bd7-4816-4f48-bdd6-ef41b3ccff27','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:05',NULL,'CREATE','IN_PROGRESS','network_stack_as_custom_type','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,238),(1398,'9582ccc4-7407-4553-990a-04abfa2d9af8','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:05',NULL,'CREATE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1399,'4048d07b-2a47-4d42-9218-a44163a21932','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:06',NULL,'CREATE','IN_PROGRESS','router','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam-router-6nhry7sr2dxm','state changed','OS::Neutron::Router',NULL,239),(1400,'c0b2662f-ee74-4b1a-b67a-6df219892baa','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:57:06',NULL,'DELETE','COMPLETE','0','f5fbc506-8944-468a-be80-52aba5fb0bb0','state changed','OS::Heat::SoftwareDeployment',NULL,185),(1401,'8d3c89a3-2a2c-4741-92f7-abbbf01283df','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:57:06',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1402,'1611bbb8-5912-4bd8-897e-20cb552e61c5','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:06',NULL,'DELETE','COMPLETE','dep_0','8707886f-7ca6-4279-8a25-33d4c65a87f7','state changed','OS::Heat::SoftwareDeployments',NULL,181),(1403,'4c9379b2-44c5-469a-8637-9e8566c6a591','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:06',NULL,'DELETE','IN_PROGRESS','dep_3','fc547785-0f54-4ea0-a8a1-6de34ceca347','state changed','OS::Heat::SoftwareDeployments',NULL,180),(1404,'b9242753-6314-4888-8e4f-b8fec900e6ce','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:57:07',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh','fc547785-0f54-4ea0-a8a1-6de34ceca347','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1405,'d1f9de44-2690-4740-92e3-8e9436a60373','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:57:07',NULL,'DELETE','IN_PROGRESS','0','530b45d0-e039-4747-bea8-459686f1342e','state changed','OS::Heat::SoftwareDeployment',NULL,186),(1406,'2d2da6e8-61db-4c12-b465-b416fc1302f3','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:57:07',NULL,'DELETE','COMPLETE','0','530b45d0-e039-4747-bea8-459686f1342e','state changed','OS::Heat::SoftwareDeployment',NULL,186),(1407,'d5f31dd0-fbc5-4903-9709-acc5979586d0','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:07',NULL,'DELETE','COMPLETE','dep_4','5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','state changed','OS::Heat::SoftwareDeployments',NULL,179),(1408,'1cdbb96a-7b29-49b7-8234-25b254ecf18b','fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:57:07',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh','fc547785-0f54-4ea0-a8a1-6de34ceca347','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1409,'01106240-8ee2-4d62-812b-e5a13834226f','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:08',NULL,'DELETE','COMPLETE','dep_3','fc547785-0f54-4ea0-a8a1-6de34ceca347','state changed','OS::Heat::SoftwareDeployments',NULL,180),(1410,'00b0b0ff-836c-4aaa-a506-68e59ab4025d','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:08',NULL,'DELETE','IN_PROGRESS','config','5dc13f31-1a14-4801-adb5-098842edc7e2','state changed','OS::Heat::SoftwareConfig',NULL,178),(1411,'57a366ee-5724-4f17-8288-46d627296631','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:08',NULL,'DELETE','COMPLETE','config','5dc13f31-1a14-4801-adb5-098842edc7e2','state changed','OS::Heat::SoftwareConfig',NULL,178),(1412,'7fa01ef4-59fa-4d73-b6a4-38e2fa196530','bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:57:08',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-13617404','bf3b6dfb-6ce1-4008-a718-2570a6107907','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1413,'712245c3-34e7-44ba-8559-aed1c2e7d69a','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:08',NULL,'CREATE','IN_PROGRESS','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1414,'b101df50-395b-4417-9c1f-2f785c0430aa','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:08',NULL,'CREATE','IN_PROGRESS','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,240),(1415,'e29ad961-e8e9-47a5-8393-36d8f9acda6c','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:09',NULL,'CREATE','COMPLETE','router','2bf944ed-e598-4bcc-a0b8-5f6edde0560d','state changed','OS::Neutron::Router',NULL,239),(1416,'deed3961-a3ab-42b1-abe0-5d7eeade1da6','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:10',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1417,'2ac74f75-aafb-4d91-a109-e6e19c702c2b','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:10',NULL,'CREATE','COMPLETE','network_stack_as_custom_type','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,238),(1418,'4155a278-7084-4398-926c-4ebd1a661c9a','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:10',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5','1f8fe575-2886-4923-bb89-d7214b8c829b','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1419,'da23ffc7-ad16-4cf5-9404-5956de7a0fcc','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:10',NULL,'CREATE','COMPLETE','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,240),(1420,'d74fe517-bdb2-4fd9-8bf9-66fd64dce54d','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:10',NULL,'CREATE','COMPLETE','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1421,'af7fe42b-209b-4c94-bd33-4490133855f1','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:11',NULL,'CREATE','COMPLETE','network_stack','1f8fe575-2886-4923-bb89-d7214b8c829b','state changed','OS::Heat::Stack',NULL,237),(1422,'61314edb-3381-4936-9979-ca70f92c935b','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:11',NULL,'CREATE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322','9cde8460-8c64-454f-bb34-d30f29ee9056','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1423,'51b13923-58d7-4993-9f57-2a7aa6bca67c','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:57:11',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-611247670','ef62c216-05d1-4b4b-be2f-a8500ee480b4','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1424,'dce10688-617e-4252-9f77-4041ad9d5f0d','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:57:12',NULL,'DELETE','IN_PROGRESS','server','19e51f33-595b-4a06-b661-e59340ad23de','state changed','OS::Nova::Server',NULL,172),(1425,'c670780e-f36b-410b-8588-42672806bcd9','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:14',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322','9cde8460-8c64-454f-bb34-d30f29ee9056','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1426,'61420a3e-49df-4dd1-996a-e3d795694c2b','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:14',NULL,'UPDATE','IN_PROGRESS','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1427,'79d4ba6c-1eb3-42cd-9b74-7cf605d07a39','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:14',NULL,'DELETE','IN_PROGRESS','network_stack','1f8fe575-2886-4923-bb89-d7214b8c829b','state changed','OS::Heat::Stack',NULL,237),(1428,'8a378200-3697-4fd5-bf2a-bbbc0c1b9dc1','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:14',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,240),(1429,'27cca84a-112c-482b-8ce6-917f5e15b898','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:15',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5','1f8fe575-2886-4923-bb89-d7214b8c829b','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1430,'f76f3a8a-0205-4259-85c0-f629ada1b804','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:15',NULL,'DELETE','IN_PROGRESS','network_stack_as_custom_type','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,238),(1431,'e4866972-d94e-48dc-baf3-d26ef320f478','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:15',NULL,'DELETE','IN_PROGRESS','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1432,'91d24ac7-15c0-439e-904c-619c8e8cdf04','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:15',NULL,'DELETE','IN_PROGRESS','router','2bf944ed-e598-4bcc-a0b8-5f6edde0560d','state changed','OS::Neutron::Router',NULL,239),(1433,'ee1df7be-95bf-4886-89cf-3520c136d821','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:57:15',NULL,'DELETE','COMPLETE','server','19e51f33-595b-4a06-b661-e59340ad23de','state changed','OS::Nova::Server',NULL,172),(1434,'bf43406e-2e83-4a82-aa2e-462746d3849f','ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:57:15',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-611247670','ef62c216-05d1-4b4b-be2f-a8500ee480b4','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1435,'eb531a4e-5e49-47a3-8473-877c44cb14ac','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:16',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,243),(1436,'056814c4-7eb9-4dfc-9a83-3a1d496413ff','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:16',NULL,'DELETE','COMPLETE','router','2bf944ed-e598-4bcc-a0b8-5f6edde0560d','state changed','OS::Neutron::Router',NULL,239),(1437,'11a00c9a-2b47-4547-bdc9-b6edcb780e6d','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:16',NULL,'UPDATE','COMPLETE','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1438,'541dbf39-da45-403d-94fa-87c3eef16a21','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:16',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1439,'c38be408-2182-4b86-b887-73dcb343623b','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:17',NULL,'DELETE','COMPLETE','network_stack_as_custom_type','e98326e4-2bc3-43d6-a36c-c0b3d7f87490','state changed','file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml',NULL,238),(1440,'d9b17e63-743c-4088-b2dd-2922ce4bd5fe','1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:17',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5','1f8fe575-2886-4923-bb89-d7214b8c829b','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1441,'87eaf4e8-c795-444e-863a-2f5892373531','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:17',NULL,'DELETE','COMPLETE','network_stack','1f8fe575-2886-4923-bb89-d7214b8c829b','state changed','OS::Heat::Stack',NULL,237),(1442,'1c322bce-0300-4106-a77d-c6e319e5dc3f','9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:17',NULL,'DELETE','COMPLETE','RemoteDeeplyNestedStackTest-1050101322','9cde8460-8c64-454f-bb34-d30f29ee9056','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1443,'c12479ab-2920-48e4-8976-85ce1486b6ab','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:57:18',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-1495015573','1cc331e6-c438-4bca-bd7d-209c06e68dd0','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1444,'dfb0110f-1d59-4822-b959-ab30698825cc','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:57:18',NULL,'CREATE','IN_PROGRESS','server','Pa-llelDeploymentsTest-1495015573-server-ogdxr2nack55','state changed','OS::Nova::Server',NULL,244),(1445,'7df08ed3-e89f-497a-8a58-45be003c5c20','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:19',NULL,'UPDATE','IN_PROGRESS','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack UPDATE started','OS::Heat::Stack',NULL,NULL),(1446,'5ccd7dbb-2a7e-482c-9948-05bcd5295e32','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:19',NULL,'UPDATE','IN_PROGRESS','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,243),(1447,'8ceaa485-8d8d-4293-924e-5b229ed76581','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:21',NULL,'UPDATE','COMPLETE','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,245),(1448,'b77263f8-2371-4479-914a-aa06e0a798bf','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:22',NULL,'UPDATE','COMPLETE','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack UPDATE completed successfully','OS::Heat::Stack',NULL,NULL),(1449,'d6744e50-bfc6-42fa-a245-40cc9745c77e','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:24',NULL,'DELETE','IN_PROGRESS','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1450,'241ca03a-faad-4e97-ac5a-11d4eed898d2','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:24',NULL,'DELETE','IN_PROGRESS','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,245),(1451,'487884a7-a734-49a5-862f-a4863f457041','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:26',NULL,'DELETE','COMPLETE','not-used','StackTagTest-2138038557-not-used-jwmonh2pdu5m','state changed','OS::Heat::TestResource',NULL,245),(1452,'aec2f7e2-2e4f-4cc1-9e5d-9f524f82cebe','09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:26',NULL,'DELETE','COMPLETE','StackTagTest-2138038557','09d32f36-159e-4b6d-ae75-3e66af71d0eb','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1453,'24a45026-3bc4-4e1d-aba3-fd40c2a902d0','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:57:30',NULL,'CREATE','COMPLETE','server','a1c2e4fd-59d3-4b48-bd34-fae7e6d73925','state changed','OS::Nova::Server',NULL,244),(1454,'9d4cb40c-1685-40b0-8ddf-a7816c3dea32','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:57:30',NULL,'CREATE','COMPLETE','ParallelDeploymentsTest-1495015573','1cc331e6-c438-4bca-bd7d-209c06e68dd0','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1455,'59d88620-7724-4570-9474-39aad9d9c413','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:30',NULL,'CREATE','IN_PROGRESS','TemplateAPITest-315994526','c379503b-9eb6-45f7-8b54-75624f9b2300','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1456,'8c2f9ce0-539d-4492-9d5d-51e5ad070619','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:30',NULL,'CREATE','IN_PROGRESS','test1','TemplateAPITest-315994526-test1-xm25wah4k5jr','state changed','OS::Heat::TestResource',NULL,246),(1457,'2af4684e-c82e-435e-8b09-23a2f88bb20c','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:30',NULL,'CREATE','COMPLETE','test1','TemplateAPITest-315994526-test1-xm25wah4k5jr','state changed','OS::Heat::TestResource',NULL,246),(1458,'327a6a06-ddce-48eb-9736-be0670022e63','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:30',NULL,'CREATE','COMPLETE','TemplateAPITest-315994526','c379503b-9eb6-45f7-8b54-75624f9b2300','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1459,'b49ab1f3-de9c-4a4e-8b25-e5d498b47eee','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:31',NULL,'DELETE','IN_PROGRESS','TemplateAPITest-315994526','c379503b-9eb6-45f7-8b54-75624f9b2300','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1460,'ce59fcda-0c4b-473f-bc57-2be7e2a61a3b','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:31',NULL,'DELETE','IN_PROGRESS','test1','TemplateAPITest-315994526-test1-xm25wah4k5jr','state changed','OS::Heat::TestResource',NULL,246),(1461,'a9cebf6f-9429-4745-b713-89bda5d897d0','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:31',NULL,'DELETE','COMPLETE','test1','TemplateAPITest-315994526-test1-xm25wah4k5jr','state changed','OS::Heat::TestResource',NULL,246),(1462,'019a5dc1-fb4a-479c-93f8-f1aa6ade6966','c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:31',NULL,'DELETE','COMPLETE','TemplateAPITest-315994526','c379503b-9eb6-45f7-8b54-75624f9b2300','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1463,'7d8d8e31-8c18-486c-b290-ef0c5b600611','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:33',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1464,'476ff319-9a09-4b63-8215-1e9f93d80478','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','config','ParallelDeploymentsTest-862999738-config-7gzuckn4e7ur','state changed','OS::Heat::SoftwareConfig',NULL,247),(1465,'86ecc631-d316-469a-8293-90765770b918','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:34',NULL,'CREATE','COMPLETE','config','7e64b40e-d7c3-402d-8e5e-0cd315cc18b4','state changed','OS::Heat::SoftwareConfig',NULL,247),(1466,'cb5ee8b2-c0ba-4765-aedd-7b2355b19218','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','dep_0','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1467,'3afa7224-f2b1-4a3a-b376-47cc13a05871','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','dep_2','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','state changed','OS::Heat::SoftwareDeployments',NULL,249),(1468,'bab33003-2c11-4e2d-a4ea-75bf436ea2ce','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','dep_1','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','state changed','OS::Heat::SoftwareDeployments',NULL,250),(1469,'fa198948-e806-46b5-8f00-f76b509608a2','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1470,'5c9099d8-3d1e-49a2-98c9-eeca743269c8','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1471,'a5014434-3958-4ef4-b51e-1922d1af5ac0','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1472,'bebd1081-0d1d-486d-8338-3d9998c46b8a','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp-0-pqwx57qtq4kp','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1473,'78482485-d2a4-4cd8-8a1f-04d41070a630','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw-0-3iaw46563spn','state changed','OS::Heat::SoftwareDeployment',NULL,252),(1474,'6b9237a9-65e3-4af9-8c0c-a552f47ef0f6','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:57:34',NULL,'CREATE','IN_PROGRESS','0','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5-0-igw6p55inbme','state changed','OS::Heat::SoftwareDeployment',NULL,253),(1475,'89339b1b-9378-4493-af83-06cb2d6be363','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','dep_0','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','CREATE aborted (Task create from SoftwareDeployments \"dep_0\" Stack \"ParallelDeploymentsTest-862999738\" [86823e94-9b05-48f8-bf47-db859524cc29] Timed out)','OS::Heat::SoftwareDeployments',NULL,248),(1476,'a1b94b37-7ed2-47c6-ad41-b5ef4a52f7db','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','dep_2','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','CREATE aborted (Task create from SoftwareDeployments \"dep_2\" Stack \"ParallelDeploymentsTest-862999738\" [86823e94-9b05-48f8-bf47-db859524cc29] Timed out)','OS::Heat::SoftwareDeployments',NULL,249),(1477,'e0630d73-1fad-468c-8073-215b4b5758ad','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1478,'f59d1ea7-bbd5-4a75-9c92-60accc90cf5f','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','dep_1','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','CREATE aborted (Task create from SoftwareDeployments \"dep_1\" Stack \"ParallelDeploymentsTest-862999738\" [86823e94-9b05-48f8-bf47-db859524cc29] Timed out)','OS::Heat::SoftwareDeployments',NULL,250),(1479,'03872be0-fad6-4f14-91e1-74d77d0354d9','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Timed out','OS::Heat::Stack',NULL,NULL),(1480,'7553fa36-cebe-4913-829d-c0e8ef0ed3ce','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1481,'ea19ccc2-0a67-4f95-acd9-e8a68571e9a9','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','0','ce08bbc4-beab-4da8-bf99-e17e47eb7080','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw\" [2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf] Timed out)','OS::Heat::SoftwareDeployment',NULL,252),(1482,'32721dad-1413-45c2-84ee-cc3b150ee10c','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','Stack CREATE cancelled','OS::Heat::Stack',NULL,NULL),(1483,'32ea255e-026f-4817-a6ec-e5a1fd096ba7','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Timed out','OS::Heat::Stack',NULL,NULL),(1484,'d03f5210-42bd-4a42-93ae-6f1721300762','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Timed out','OS::Heat::Stack',NULL,NULL),(1485,'8914dc5c-b379-46b6-9bd0-503bd4bcbd41','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','0','b4f47156-598b-4ee4-8c3b-9bb8fe13ff16','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp\" [e7a7db52-859b-4eb5-aa7b-67f2047e31bf] Timed out)','OS::Heat::SoftwareDeployment',NULL,251),(1486,'1dc5ca40-93fe-4b66-8010-8821ec736df4','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','Timed out','OS::Heat::Stack',NULL,NULL),(1487,'21e3cfd1-7858-488f-bdf7-30ca603b9098','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:35',NULL,'CREATE','FAILED','0','fbf1f81a-d076-4379-8517-f65aebc106e6','CREATE aborted (Task create from SoftwareDeployment \"0\" Stack \"ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5\" [d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c] Timed out)','OS::Heat::SoftwareDeployment',NULL,253),(1488,'48869d75-0860-47af-985f-6f7881b45898','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','Timed out','OS::Heat::Stack',NULL,NULL),(1489,'4d80394c-c951-483a-b997-f64245e9b659','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:35',NULL,'CREATE','FAILED','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','Timed out','OS::Heat::Stack',NULL,NULL),(1490,'803f55ed-997a-44a8-80af-7895ceb4bc06','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:40',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1491,'ff086d4a-b788-4e17-a8f4-397409065e7d','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:41',NULL,'DELETE','IN_PROGRESS','dep_2','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','state changed','OS::Heat::SoftwareDeployments',NULL,249),(1492,'2a0dc36d-0625-4a4b-96ca-30dfbe816c5a','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:41',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1493,'9d3b4ae7-8737-46c7-8f9a-6ff80f3cb9fa','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:41',NULL,'DELETE','IN_PROGRESS','0','ce08bbc4-beab-4da8-bf99-e17e47eb7080','state changed','OS::Heat::SoftwareDeployment',NULL,252),(1494,'7d710f09-33ed-4551-81b2-aa6cdf6a334b','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:42',NULL,'DELETE','IN_PROGRESS','dep_1','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','state changed','OS::Heat::SoftwareDeployments',NULL,250),(1495,'94a5422f-b4c8-4f86-8702-efa2f7794ea5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:42',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1496,'01f207d8-2635-4024-998b-e4b4f84e2884','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:42',NULL,'DELETE','COMPLETE','0','ce08bbc4-beab-4da8-bf99-e17e47eb7080','state changed','OS::Heat::SoftwareDeployment',NULL,252),(1497,'1274f848-36f7-4e04-9420-c9256c0519fb','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:42',NULL,'DELETE','IN_PROGRESS','0','fbf1f81a-d076-4379-8517-f65aebc106e6','state changed','OS::Heat::SoftwareDeployment',NULL,253),(1498,'57d725d6-c417-4132-85d6-f58cb73c9785','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:58:42',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1499,'732c2d0b-92a1-441b-9f4e-a12af3f8e73d','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:44',NULL,'DELETE','COMPLETE','dep_2','2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','state changed','OS::Heat::SoftwareDeployments',NULL,249),(1500,'1ab78104-8d58-4a84-8817-17f73cc1d7dc','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:44',NULL,'DELETE','IN_PROGRESS','dep_0','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1501,'69d3714f-0183-4773-a9bd-e203a49565bc','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:44',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1502,'53324354-55ee-42a1-8f96-f7c1a838f762','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:44',NULL,'DELETE','IN_PROGRESS','0','b4f47156-598b-4ee4-8c3b-9bb8fe13ff16','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1503,'6d5d6eda-71cb-4e50-8632-05e9df8a86d9','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:44',NULL,'DELETE','COMPLETE','0','fbf1f81a-d076-4379-8517-f65aebc106e6','state changed','OS::Heat::SoftwareDeployment',NULL,253),(1504,'94e5ac30-7743-4eca-8860-99c5443a5488','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:58:44',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1505,'0ee640cc-460b-4c7e-8a86-2668a6651043','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:45',NULL,'DELETE','COMPLETE','dep_1','d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','state changed','OS::Heat::SoftwareDeployments',NULL,250),(1506,'8f58479c-6e6f-44ef-b393-433d09001fd2','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:45',NULL,'DELETE','COMPLETE','0','b4f47156-598b-4ee4-8c3b-9bb8fe13ff16','state changed','OS::Heat::SoftwareDeployment',NULL,251),(1507,'16e446bf-eec0-4d9e-975f-a956e6c924f0','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:58:45',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1508,'a5268a70-b7b1-4d83-8fca-fa1240dd741f','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:46',NULL,'DELETE','COMPLETE','dep_0','e7a7db52-859b-4eb5-aa7b-67f2047e31bf','state changed','OS::Heat::SoftwareDeployments',NULL,248),(1509,'73ba72e4-364e-458d-9470-2def42ee1b56','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:47',NULL,'DELETE','IN_PROGRESS','config','7e64b40e-d7c3-402d-8e5e-0cd315cc18b4','state changed','OS::Heat::SoftwareConfig',NULL,247),(1510,'f2361a88-82ab-4ef0-8f9d-b0fb0c98a7c9','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:47',NULL,'DELETE','COMPLETE','config','7e64b40e-d7c3-402d-8e5e-0cd315cc18b4','state changed','OS::Heat::SoftwareConfig',NULL,247),(1511,'31c29ff9-3df2-452a-9bd7-93272835d97a','86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:58:47',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-862999738','86823e94-9b05-48f8-bf47-db859524cc29','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1512,'1468d811-f2f5-4ea2-b685-a9b9dd94a925','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:58:50',NULL,'DELETE','IN_PROGRESS','ParallelDeploymentsTest-1495015573','1cc331e6-c438-4bca-bd7d-209c06e68dd0','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1513,'22456cf0-a8bc-475f-af05-2ef538593eee','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:58:50',NULL,'DELETE','IN_PROGRESS','server','a1c2e4fd-59d3-4b48-bd34-fae7e6d73925','state changed','OS::Nova::Server',NULL,244),(1514,'f88d5ca1-5e22-4043-9d82-583e92f02aa7','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:58:53',NULL,'DELETE','COMPLETE','server','a1c2e4fd-59d3-4b48-bd34-fae7e6d73925','state changed','OS::Nova::Server',NULL,244),(1515,'a1d363d0-cbf6-43a6-a5b2-8c8131f25b42','1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:58:54',NULL,'DELETE','COMPLETE','ParallelDeploymentsTest-1495015573','1cc331e6-c438-4bca-bd7d-209c06e68dd0','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL),(1516,'a8749db6-efaa-4c61-be38-22ac395c6b09','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:56',NULL,'CREATE','IN_PROGRESS','StackUnicodeTemplateTest-2554332','0b242c5a-ddc1-4546-9f35-baf3f0441e90','Stack CREATE started','OS::Heat::Stack',NULL,NULL),(1517,'e58415e3-3bbc-45f7-bc5b-b2895e45a5a9','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:56',NULL,'CREATE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2554332-资源-nuzkmjltty5h','state changed','OS::Heat::RandomString',NULL,254),(1518,'4eeb6ab8-55c0-482b-a8cc-8fbb07a516a3','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:56',NULL,'CREATE','COMPLETE','资源','StackUnicodeTemplateTest-2554332-资源-nuzkmjltty5h','state changed','OS::Heat::RandomString',NULL,254),(1519,'43e6d39f-d965-4903-865e-d94e124a042f','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:56',NULL,'CREATE','COMPLETE','StackUnicodeTemplateTest-2554332','0b242c5a-ddc1-4546-9f35-baf3f0441e90','Stack CREATE completed successfully','OS::Heat::Stack',NULL,NULL),(1520,'a79e1536-695c-41c2-8e93-4ba7998db603','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:56',NULL,'DELETE','IN_PROGRESS','StackUnicodeTemplateTest-2554332','0b242c5a-ddc1-4546-9f35-baf3f0441e90','Stack DELETE started','OS::Heat::Stack',NULL,NULL),(1521,'7bfc7f51-11ef-45bc-ae7b-81185a48bd49','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:57',NULL,'DELETE','IN_PROGRESS','资源','StackUnicodeTemplateTest-2554332-资源-nuzkmjltty5h','state changed','OS::Heat::RandomString',NULL,254),(1522,'cdfb052e-5b5a-42d4-b5c5-2d4971451e9c','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:57',NULL,'DELETE','COMPLETE','资源','StackUnicodeTemplateTest-2554332-资源-nuzkmjltty5h','state changed','OS::Heat::RandomString',NULL,254),(1523,'e4182f90-51bf-4c98-9b81-d7fe47ddf013','0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:57',NULL,'DELETE','COMPLETE','StackUnicodeTemplateTest-2554332','0b242c5a-ddc1-4546-9f35-baf3f0441e90','Stack DELETE completed successfully','OS::Heat::Stack',NULL,NULL);
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=243 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
INSERT INTO `raw_template` (`id`, `created_at`, `updated_at`, `template`, `files`, `environment`, `files_id`) VALUES (2,'2026-01-20 13:50:04',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(3,'2026-01-20 13:50:04',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(4,'2026-01-20 13:50:04',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(5,'2026-01-20 13:50:06',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(6,'2026-01-20 13:50:07',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(7,'2026-01-20 13:50:07',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"test\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(11,'2026-01-20 13:50:13',NULL,'{\"heat_template_version\": \"2016-04-08\", \"parameters\": {\"test_val\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(12,'2026-01-20 13:50:13',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(15,'2026-01-20 13:50:14',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(17,'2026-01-20 13:50:15',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(22,'2026-01-20 13:50:17',NULL,'{\"heat_template_version\": \"2016-04-08\"}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(24,'2026-01-20 13:50:19',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(26,'2026-01-20 13:50:19',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(29,'2026-01-20 13:50:22',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {\"test\": {\"type\": \"OS::Heat::TestResource\", \"properties\": {\"value\": {\"get_param\": \"test_val\"}, \"action_wait_secs\": {\"update\": 1}}}}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(33,'2026-01-20 13:50:28',NULL,'{\"heat_template_version\": \"pike\", \"parameters\": {\"test_val\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"output_value\": {\"value\": {\"get_attr\": [\"test\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"test_val\": \"new_patched_value\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(38,'2026-01-20 13:50:35',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(39,'2026-01-20 13:50:35',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(40,'2026-01-20 13:50:38',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create encryption volume type.\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(47,'2026-01-20 13:50:52',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(48,'2026-01-20 13:50:52',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(49,'2026-01-20 13:50:56',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create port wit ip_address.\", \"parameters\": {\"mac\": {\"type\": \"string\", \"default\": \"00-00-00-00-BB-BB\"}}, \"resources\": {}, \"outputs\": {\"port_ip\": {\"value\": {\"get_attr\": [\"port\", \"fixed_ips\", 0, \"ip_address\"]}}, \"mac_address\": {\"value\": {\"get_attr\": [\"port\", \"mac_address\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"mac\": \"00-00-00-00-AA-AA\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(55,'2026-01-20 13:51:14',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(58,'2026-01-20 13:51:20',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": {\"image\": {\"type\": \"string\"}, \"flavor\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}, \"foo\": {\"type\": \"string\", \"description\": \"parameter with encryption turned on\", \"hidden\": true, \"default\": \"secret\"}}, \"resources\": {}, \"outputs\": {\"encrypted_foo_param\": {\"description\": \"encrypted param\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"network\": \"heat_tempestconf_network\", \"foo\": \"my_encrypted_foo\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(59,'2026-01-20 13:51:22',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(60,'2026-01-20 13:51:23',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(64,'2026-01-20 13:51:34',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(69,'2026-01-20 13:51:56',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(70,'2026-01-20 13:51:57',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with port.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(71,'2026-01-20 13:51:58',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(77,'2026-01-20 13:52:10',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(78,'2026-01-20 13:52:13',NULL,'{\"heat_template_version\": \"2015-04-30\", \"description\": \"Test template to create/update subnet with allocation_pools.\", \"resources\": {}, \"outputs\": {\"alloc_pools\": {\"value\": {\"get_attr\": [\"subnet\", \"allocation_pools\"]}}, \"gateway_ip\": {\"value\": {\"get_attr\": [\"subnet\", \"gateway_ip\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(81,'2026-01-20 13:52:36',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(82,'2026-01-20 13:52:41',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server with subnet and fixed_ip.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(86,'2026-01-20 13:52:57',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(89,'2026-01-20 13:53:15',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(93,'2026-01-20 13:53:41',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"networks\": {\"value\": {\"get_attr\": [\"server\", \"networks\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(94,'2026-01-20 13:53:44',NULL,'{\"description\": \"Test template to create, update, delete trunk.\", \"heat_template_version\": \"pike\", \"outputs\": {\"trunk_parent_port\": {\"value\": {\"get_attr\": [\"trunk\", \"port_id\"]}}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(98,'2026-01-20 13:53:55',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(99,'2026-01-20 13:53:56',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(104,'2026-01-20 13:54:05',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(105,'2026-01-20 13:54:08',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(106,'2026-01-20 13:54:09',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',1),(107,'2026-01-20 13:54:10',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',2),(108,'2026-01-20 13:54:13',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {\"test1\": {\"type\": \"OS::Heat::TestResource\"}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(113,'2026-01-20 13:54:21',NULL,'{\"heat_template_version\": \"2016-10-14\", \"resources\": {}, \"outputs\": {\"str\": {\"value\": {\"get_resource\": \"test1\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(115,'2026-01-20 13:54:39',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',3),(116,'2026-01-20 13:54:40',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random1\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',4),(117,'2026-01-20 13:54:40',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(124,'2026-01-20 13:54:52',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(126,'2026-01-20 13:54:57',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"nested\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"nested.yaml\": \"nested.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',6),(127,'2026-01-20 13:54:59',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',6),(128,'2026-01-20 13:55:01',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"key\": {\"value\": {\"get_attr\": [\"my_stack\", \"outputs\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',8),(129,'2026-01-20 13:55:01',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}, \"outputs\": {\"remote_key\": {\"value\": {\"get_attr\": [\"random2\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',9),(133,'2026-01-20 13:55:09',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(135,'2026-01-20 13:55:16',NULL,'{\"heat_template_version\": \"2013-05-23\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(137,'2026-01-20 13:55:22',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_*\": {\"hooks\": \"pre-create\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(143,'2026-01-20 13:55:40',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(145,'2026-01-20 13:55:42',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"rg\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(148,'2026-01-20 13:55:42',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}, \"outputs\": {\"refs_map\": {\"value\": {\"0\": {\"get_resource\": \"0\"}, \"1\": {\"get_resource\": \"1\"}}}}}','null','{\"resource_registry\": {\"resources\": {\"hooks\": \"pre-update\"}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(166,'2026-01-20 13:55:53',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(176,'2026-01-20 13:56:14',NULL,'{\"heat_template_version\": \"2014-10-16\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {\"foo_step2\": {\"hooks\": \"pre-update\"}}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(178,'2026-01-20 13:56:20',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(179,'2026-01-20 13:56:20',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(181,'2026-01-20 13:56:21',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(183,'2026-01-20 13:56:22',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(186,'2026-01-20 13:56:29',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(187,'2026-01-20 13:56:30',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(188,'2026-01-20 13:56:30',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_a\"]}, \"description\": \"parent a\"}, \"resource_output_b\": {\"value\": {\"get_attr\": [\"parent\", \"resource_output_b\"]}, \"description\": \"parent b\"}}}','null','{\"resource_registry\": {\"resources\": {}, \"1.yaml\": \"1.yaml\"}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',11),(189,'2026-01-20 13:56:31',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_param\": \"foo\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',11),(190,'2026-01-20 13:56:31',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(191,'2026-01-20 13:56:32',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(192,'2026-01-20 13:56:33',NULL,'{\"heat_template_version\": \"2016-04-08\", \"description\": \"Test template to test nova server network updates.\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"port0_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"port\"]}}, \"port1_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"port\"]}}, \"port2_id\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"port\"]}}, \"port0_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 0, \"addr\"]}}, \"port1_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 1, \"addr\"]}}, \"port2_ip_addr\": {\"value\": {\"get_attr\": [\"server\", \"addresses\", \"the_net\", 2, \"addr\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(194,'2026-01-20 13:56:39',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(195,'2026-01-20 13:56:41',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(196,'2026-01-20 13:56:42',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(198,'2026-01-20 13:56:43',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(199,'2026-01-20 13:56:43',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"resource_output_a\": {\"description\": \"Output of resource a\", \"value\": {\"get_attr\": [\"test_resource_a\", \"output\"]}}, \"resource_output_b\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(200,'2026-01-20 13:56:48',NULL,'{\"heat_template_version\": \"2014-10-16\", \"parameters\": null, \"resources\": {}, \"outputs\": {\"resource_id\": {\"description\": \"ID of resource\", \"value\": {\"get_resource\": \"test_resource\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(202,'2026-01-20 13:56:51',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(203,'2026-01-20 13:56:51',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(205,'2026-01-20 13:56:52',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(206,'2026-01-20 13:56:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(207,'2026-01-20 13:56:54',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(209,'2026-01-20 13:56:55',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(210,'2026-01-20 13:56:56',NULL,'{\"heat_template_version\": \"2015-10-15\", \"resources\": {}, \"outputs\": {\"output_value\": {\"description\": \"Output of resource b\", \"value\": {\"get_attr\": [\"test_resource_b\", \"output\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(211,'2026-01-20 13:57:01',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(212,'2026-01-20 13:57:02',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(213,'2026-01-20 13:57:02',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(214,'2026-01-20 13:57:03',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(216,'2026-01-20 13:57:04',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(218,'2026-01-20 13:57:05',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(220,'2026-01-20 13:57:06',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(222,'2026-01-20 13:57:11',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"network\": \"heat_tempestconf_network\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(224,'2026-01-20 13:57:14',NULL,'{\"description\": \"The root stack (containing a remote stack) for the deeply-nested remote\\nstack test.\\n\", \"heat_template_version\": \"2015-10-15\", \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack\", \"outputs\", \"router\"]}}}, \"parameters\": {\"name\": {\"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}], \"description\": \"Name of the router\", \"type\": \"string\"}, \"network_name\": {\"constraints\": [{\"custom_constraint\": \"neutron.network\"}], \"description\": \"The public network to connect to\", \"type\": \"string\"}, \"region\": {\"default\": \"RegionOne\", \"description\": \"The region in which to create the remote stack\", \"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\", \"region\": \"regionOne\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',12),(225,'2026-01-20 13:57:14',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The intermediate stack (containing a local nested stack) to be instantiated\\nremotely in the remote deeply-nested stack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The public network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_attr\": [\"network_stack_as_custom_type\", \"router\"]}}}}','null','{\"resource_registry\": {\"resources\": {}, \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(226,'2026-01-20 13:57:15',NULL,'{\"heat_template_version\": \"2015-10-15\", \"description\": \"The base stack (containing an actual resource) for the remote deeply-nested\\nstack test.\\n\", \"parameters\": {\"name\": {\"type\": \"string\", \"description\": \"Name of the router\", \"constraints\": [{\"allowed_pattern\": \"[a-z][a-z0-9-]{1,}\"}]}, \"network_name\": {\"type\": \"string\", \"description\": \"The network to connect to\", \"constraints\": [{\"custom_constraint\": \"neutron.network\"}]}}, \"resources\": {}, \"outputs\": {\"router\": {\"value\": {\"get_resource\": \"router\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',13),(229,'2026-01-20 13:57:24',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"foo\", \"parameters\": {\"input\": {\"type\": \"string\", \"default\": \"test\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"input\": \"none\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(231,'2026-01-20 13:57:31',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"Test Template APIs\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(236,'2026-01-20 13:58:40',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"server\": {\"type\": \"string\"}}, \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"server\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(237,'2026-01-20 13:58:41',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(238,'2026-01-20 13:58:42',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(239,'2026-01-20 13:58:44',NULL,'{\"heat_template_version\": \"2015-04-30\", \"resources\": {}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(240,'2026-01-20 13:58:50',NULL,'{\"heat_template_version\": \"2013-05-23\", \"parameters\": {\"flavor\": {\"type\": \"string\"}, \"image\": {\"type\": \"string\"}, \"network\": {\"type\": \"string\"}}, \"resources\": {}, \"outputs\": {\"server\": {\"value\": {\"get_resource\": \"server\"}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {\"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"network\": \"heat_tempestconf_network\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\"}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL),(242,'2026-01-20 13:58:56',NULL,'{\"heat_template_version\": \"2014-10-16\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"parameters\": {\"\\u53c2\\u6570\": {\"type\": \"number\", \"default\": 10, \"label\": \"\\u6807\\u7b7e\", \"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\"}}, \"resources\": {}, \"outputs\": {\"\\u8f93\\u51fa\": {\"description\": \"\\u8fd9\\u662f\\u4e00\\u4e2a\\u63cf\\u8ff0\", \"value\": {\"get_attr\": [\"\\u8d44\\u6e90\", \"value\"]}}}}','null','{\"resource_registry\": {\"resources\": {}}, \"parameters\": {}, \"parameter_defaults\": {}, \"event_sinks\": [], \"encrypted_param_names\": []}',NULL);
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
INSERT INTO `raw_template_files` (`id`, `files`, `created_at`, `updated_at`) VALUES (1,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-20 13:54:01',NULL),(2,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-20 13:54:02',NULL),(3,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-20 13:54:15',NULL),(4,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}','2026-01-20 13:54:17',NULL),(6,'{\"nested.yaml\": \"heat_template_version: \'2014-10-16\'\\nresources:\\n  foo_step1:\\n    type: OS::Heat::RandomString\\n  foo_step2:\\n    depends_on: foo_step1\\n    type: OS::Heat::RandomString\\n  foo_step3:\\n    depends_on: foo_step2\\n    type: OS::Heat::RandomString\\n\"}','2026-01-20 13:54:44',NULL),(8,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-01-20 13:54:51',NULL),(9,'{\"remote_stack.yaml\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}','2026-01-20 13:54:52',NULL),(11,'{\"1.yaml\": \"\\nheat_template_version: 2015-10-15\\nresources:\\n  test_resource_a:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'a\'\\n  test_resource_b:\\n    type: OS::Heat::TestResource\\n    properties:\\n      value: \'b\'\\noutputs:\\n  resource_output_a:\\n    description: \'Output of resource a\'\\n    value: { get_attr: [test_resource_a, output] }\\n  resource_output_b:\\n    description: \'Output of resource b\'\\n    value: { get_param: foo }\\n\"}','2026-01-20 13:56:25',NULL),(12,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-01-20 13:57:03',NULL),(13,'{\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The base stack (containing an actual resource) for the remote deeply-nested\\\\nstack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"router\\\": {\\\"type\\\": \\\"OS::Neutron::Router\\\", \\\"properties\\\": {\\\"name\\\": {\\\"list_join\\\": [\\\"-\\\", [{\\\"get_param\\\": \\\"name\\\"}, \\\"router\\\"]]}, \\\"external_gateway_info\\\": {\\\"network\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_resource\\\": \\\"router\\\"}}}}\", \"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_intermediate.yaml\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}','2026-01-20 13:57:04',NULL);
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=231 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
INSERT INTO `resource` (`id`, `uuid`, `nova_instance`, `name`, `created_at`, `updated_at`, `action`, `status`, `status_reason`, `stack_id`, `rsrc_metadata`, `properties_data`, `engine_id`, `atomic_key`, `needed_by`, `requires`, `replaces`, `replaced_by`, `current_template_id`, `properties_data_encrypted`, `root_stack_id`, `rsrc_prop_data_id`, `attr_data_id`) VALUES (2,'29b41841-ce58-4e54-8d12-b468bc4554cb','api-442217991-envstack-test-4vgolau3igcb','test','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','state changed','87a46c98-cc95-42ca-9a1e-9a12087c387b','{}','null',NULL,2,'[]','[]',NULL,NULL,2,NULL,'87a46c98-cc95-42ca-9a1e-9a12087c387b',2,NULL),(3,'6dec67bb-8844-4ba3-b8d6-903487830232','api-108285926-envstack-test-xi4iirw6yz53','test','2026-01-20 13:50:05',NULL,'CREATE','COMPLETE','state changed','bb9e894c-a1b7-49ce-82a9-0a593c58c737','{}','null',NULL,2,'[]','[]',NULL,NULL,3,NULL,'bb9e894c-a1b7-49ce-82a9-0a593c58c737',3,NULL),(4,'033eaabf-78b0-4f7b-a9d4-625034bdfd11','api-1214827273-rsrcstack-test-663ywabt5kv7','test','2026-01-20 13:50:05',NULL,'CHECK','FAILED','resource deleted','ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','{}','null',NULL,4,'[]','[]',NULL,NULL,4,NULL,'ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191',4,NULL),(5,'c3635416-3b3f-4e97-b8d5-afff55fd54af','api-108285926-rsrcstack-test-5fz3h7bwgvaw','test','2026-01-20 13:50:08',NULL,'CREATE','COMPLETE','state changed','b140e17f-aa70-41c5-a917-02c242d68958','{}','null',NULL,2,'[]','[]',NULL,NULL,5,NULL,'b140e17f-aa70-41c5-a917-02c242d68958',5,NULL),(6,'4d3ff86f-9729-4b29-af64-bf9bdeb040a7','api-442217991-rsrcstack-test-wkmxffgt76dp','test','2026-01-20 13:50:08',NULL,'CHECK','FAILED','resource deleted','a02006a6-cff0-49dc-be8f-81748ec3e4e0','{}','null',NULL,4,'[]','[]',NULL,NULL,6,NULL,'a02006a6-cff0-49dc-be8f-81748ec3e4e0',6,NULL),(8,'1b7b85b2-992e-4edb-b584-0758506ab703','api-108285926-stack-test-5w4zfynxxbns','test','2026-01-20 13:50:14','2026-01-20 13:50:19','UPDATE','COMPLETE','state changed','62188458-aab9-4802-8579-c47bb0c683f3','{}','null',NULL,6,'[]','[]',NULL,NULL,24,NULL,'62188458-aab9-4802-8579-c47bb0c683f3',14,NULL),(9,'4dc3aaab-b6f8-42fb-b751-e2161848f711','api-1214827273-stack-test-f65w7bg4hkvl','test','2026-01-20 13:50:15','2026-01-20 13:50:19','UPDATE','COMPLETE','state changed','75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','{}','null',NULL,6,'[]','[]',NULL,NULL,26,NULL,'75b9e2b0-e2e8-4e18-a401-2d211d0c53f7',16,NULL),(11,'080c2d43-8e60-4109-b0ee-0282915c6ae0','api-1445742041-stack-test-ccmomaeaylkd','test','2026-01-20 13:50:18','2026-01-20 13:50:22','UPDATE','COMPLETE','state changed','9fb2ea8b-a649-4533-966f-b6fcdab608c8','{}','null',NULL,6,'[]','[]',NULL,NULL,29,NULL,'9fb2ea8b-a649-4533-966f-b6fcdab608c8',20,NULL);
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
INSERT INTO `resource_data` (`id`, `created_at`, `updated_at`, `key`, `value`, `redact`, `decrypt_method`, `resource_id`) VALUES (2,'2026-01-20 13:50:05',NULL,'value','test',0,'',2),(3,'2026-01-20 13:50:05',NULL,'value','test',0,'',3),(4,'2026-01-20 13:50:05',NULL,'value','test',0,'',4),(5,'2026-01-20 13:50:08',NULL,'value','test',0,'',5),(6,'2026-01-20 13:50:08',NULL,'value','test',0,'',6),(8,'2026-01-20 13:50:14','2026-01-20 13:50:19','value','new_patched_value',0,'',8),(9,'2026-01-20 13:50:15','2026-01-20 13:50:19','value','new_patched_value',0,'',9),(11,'2026-01-20 13:50:18','2026-01-20 13:50:23','value','new_patched_value',0,'',11);
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
INSERT INTO `resource_properties_data` (`id`, `data`, `encrypted`, `created_at`, `updated_at`) VALUES (1,'{\"value\": \"test\"}',0,'2026-01-20 13:50:05',NULL),(2,'{\"value\": \"test\"}',0,'2026-01-20 13:50:05',NULL),(3,'{\"value\": \"test\"}',0,'2026-01-20 13:50:05',NULL),(4,'{\"value\": \"test\"}',0,'2026-01-20 13:50:05',NULL),(5,'{\"value\": \"test\"}',0,'2026-01-20 13:50:08',NULL),(6,'{\"value\": \"test\"}',0,'2026-01-20 13:50:08',NULL),(7,'{\"value\": \"test\"}',0,'2026-01-20 13:50:09',NULL),(8,'{\"value\": \"value\"}',0,'2026-01-20 13:50:14',NULL),(9,'{\"value\": \"value\"}',0,'2026-01-20 13:50:15',NULL),(10,'{\"value\": \"value\"}',0,'2026-01-20 13:50:16',NULL),(11,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:18',NULL),(12,'{\"value\": \"value\"}',0,'2026-01-20 13:50:18',NULL),(13,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:18',NULL),(14,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:21',NULL),(15,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:21',NULL),(16,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:21',NULL),(17,'{\"value\": \"new_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:21',NULL),(18,'{\"enable_dhcp\": false, \"network\": \"428a20ee-3476-451f-97bc-8bb2c787bc4c\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:50:23',NULL),(19,'{\"network\": \"428a20ee-3476-451f-97bc-8bb2c787bc4c\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"a51f4258-8291-41ba-896e-b58fdd19c0b4\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-20 13:50:25',NULL),(20,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:25',NULL),(21,'{\"network\": \"20820931-bb2b-46b3-8ddb-340917102728\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:50:26',NULL),(22,'{\"value\": \"new_patched_value\", \"action_wait_secs\": {\"update\": 1}}',0,'2026-01-20 13:50:27',NULL),(24,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-01-20 13:50:27',NULL),(25,'{\"name\": \"LUKS\"}',0,'2026-01-20 13:50:28',NULL),(26,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-xts-plain64\", \"key_size\": 512, \"volume_type\": \"2682a6a4-78e2-43fa-8e60-3da97d4f29eb\"}',0,'2026-01-20 13:50:28',NULL),(28,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"06e2e3dd-5776-4bc5-bb48-bc2a19171c73\"}',0,'2026-01-20 13:50:31',NULL),(29,'{\"network\": \"20820931-bb2b-46b3-8ddb-340917102728\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.100\"}]}',0,'2026-01-20 13:50:31',NULL),(30,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"b7befc96-23b2-4866-a9a9-1c06391628b0\"}',0,'2026-01-20 13:50:33',NULL),(31,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"c08c1e5e-44c8-484f-9b37-57726f1f69fd\"}',0,'2026-01-20 13:50:33',NULL),(32,'{\"name\": \"trunk_sub_port_two\", \"network\": \"06e2e3dd-5776-4bc5-bb48-bc2a19171c73\"}',0,'2026-01-20 13:50:33',NULL),(33,'{\"network\": \"428a20ee-3476-451f-97bc-8bb2c787bc4c\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"a51f4258-8291-41ba-896e-b58fdd19c0b4\"}]}',0,'2026-01-20 13:50:33',NULL),(35,'{\"provider\": \"nova.volume.encryptors.luks.LuksEncryptor\", \"control_location\": \"front-end\", \"cipher\": \"aes-cbc-essiv\", \"key_size\": 256, \"volume_type\": \"2682a6a4-78e2-43fa-8e60-3da97d4f29eb\"}',0,'2026-01-20 13:50:34',NULL),(37,'{\"name\": \"trunk_parent_port\", \"network\": \"b7befc96-23b2-4866-a9a9-1c06391628b0\"}',0,'2026-01-20 13:50:35',NULL),(38,'{\"name\": \"trunk_sub_port_one\", \"network\": \"c08c1e5e-44c8-484f-9b37-57726f1f69fd\"}',0,'2026-01-20 13:50:35',NULL),(39,'{\"name\": \"test_trunk\", \"port\": \"5584f878-6f49-4fbb-b0e6-6fbbab7d3ac8\", \"sub_ports\": [{\"port\": \"a4a9ee06-c4ac-4116-b1b4-16df3ea5e369\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:50:36',NULL),(40,'{\"network\": \"dc4cf4ee-b9cd-4909-80f1-ac5e599592a5\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:50:41',NULL),(41,'{\"enable_dhcp\": false, \"network\": \"8706bb00-4d3b-45b5-aa30-3ab7cadf13fe\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:50:42',NULL),(42,'{\"network\": \"8706bb00-4d3b-45b5-aa30-3ab7cadf13fe\", \"mac_address\": \"00-00-00-00-BB-BB\", \"fixed_ips\": [{\"subnet\": \"c32f1eb6-702a-4a80-af9f-72fc7e1e74b9\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-20 13:50:43',NULL),(44,'{\"name\": \"test_trunk\", \"port\": \"5584f878-6f49-4fbb-b0e6-6fbbab7d3ac8\", \"sub_ports\": [{\"port\": \"a4a9ee06-c4ac-4116-b1b4-16df3ea5e369\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"07ee6358-21dc-4a9e-8610-9c61dd6e6608\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:50:44',NULL),(45,'{\"value\": \"Test1\", \"fail\": false}',0,'2026-01-20 13:50:44',NULL),(46,'{\"name\": \"the_net\"}',0,'2026-01-20 13:50:45',NULL),(48,'{\"name\": \"the_subnet\", \"network\": \"3a57b7dd-7fc0-4118-bf54-dc6cb3cf29bd\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:50:45',NULL),(49,'{\"network\": \"dc4cf4ee-b9cd-4909-80f1-ac5e599592a5\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": []}',0,'2026-01-20 13:50:47',NULL),(50,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"9c902034-d478-4019-9ac0-b1200ab4c874\"}]}',0,'2026-01-20 13:50:47',NULL),(53,'{\"network\": \"8706bb00-4d3b-45b5-aa30-3ab7cadf13fe\", \"mac_address\": \"00-00-00-00-AA-AA\", \"fixed_ips\": [{\"subnet\": \"c32f1eb6-702a-4a80-af9f-72fc7e1e74b9\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-20 13:50:52',NULL),(55,'{\"network\": \"5c6b37a6-0860-43f1-951f-dcefd1e70e72\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:50:59',NULL),(56,'{\"network\": \"29a24e95-cb93-4eec-9ad6-95928ce68f51\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-01-20 13:51:01',NULL),(57,'{\"network\": \"43d410f6-d678-4cd8-9e85-80f5fa9bdd65\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-01-20 13:51:01',NULL),(58,'{\"name\": \"my_encrypted_foo\", \"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-20 13:51:03',NULL),(59,'{\"network\": \"7edaeedd-a4cc-45e8-9eb7-e3361b5c2c1d\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-01-20 13:51:03',NULL),(60,'{\"network\": \"7edaeedd-a4cc-45e8-9eb7-e3361b5c2c1d\", \"name\": \"trunk_sub_port_one\"}',0,'2026-01-20 13:51:05',NULL),(61,'{\"network\": \"29a24e95-cb93-4eec-9ad6-95928ce68f51\", \"name\": \"trunk_parent_port\"}',0,'2026-01-20 13:51:05',NULL),(62,'{\"network\": \"43d410f6-d678-4cd8-9e85-80f5fa9bdd65\", \"name\": \"trunk_sub_port_two\"}',0,'2026-01-20 13:51:06',NULL),(64,'{\"name\": \"test_trunk\", \"port\": \"8a95b7c3-71cd-445b-bad9-08545a0a6771\", \"sub_ports\": null}',0,'2026-01-20 13:51:09',NULL),(65,'{\"network\": \"5c6b37a6-0860-43f1-951f-dcefd1e70e72\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.9\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:51:10',NULL),(68,'{\"name\": \"test_trunk\", \"port\": \"8a95b7c3-71cd-445b-bad9-08545a0a6771\", \"sub_ports\": [{\"port\": \"3fc359f3-2e1b-418c-bf06-3fdb3632aca1\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:51:17',NULL),(69,'{\"network\": \"8801d255-7713-4d3c-bf81-eb7c7f220ff7\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:51:21',NULL),(70,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"3a57b7dd-7fc0-4118-bf54-dc6cb3cf29bd\", \"subnet\": \"9c902034-d478-4019-9ac0-b1200ab4c874\"}]}',0,'2026-01-20 13:51:21',NULL),(74,'{\"network\": \"8801d255-7713-4d3c-bf81-eb7c7f220ff7\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": null, \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:51:26',NULL),(75,'{\"name\": \"server_with_port_net\"}',0,'2026-01-20 13:51:26',NULL),(76,'{\"network\": \"75dc0740-9854-4ea8-afc0-81cea3d1d364\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:51:27',NULL),(77,'{\"network\": \"75dc0740-9854-4ea8-afc0-81cea3d1d364\", \"fixed_ips\": [{\"subnet\": \"0c775d4d-b54d-443a-ae8e-780b418c6734\", \"ip_address\": \"11.11.11.11\"}]}',0,'2026-01-20 13:51:32',NULL),(79,'{\"name\": \"the_net\"}',0,'2026-01-20 13:51:35',NULL),(80,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"port\": \"8ce7e99d-bed8-41a5-89c6-17b79e306a6a\"}]}',0,'2026-01-20 13:51:35',NULL),(81,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"c7834cc6-197b-45bc-95c2-5dcfa20cecce\"}',0,'2026-01-20 13:51:36',NULL),(82,'{\"name\": \"the_subnet\", \"network\": \"b9c02741-791c-45c3-b569-18504f1c1de0\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:51:36',NULL),(83,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"093dd2bb-9f94-48af-bdcd-a3aa4352548b\"}',0,'2026-01-20 13:51:38',NULL),(84,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"b9c02741-791c-45c3-b569-18504f1c1de0\"}]}',0,'2026-01-20 13:51:38',NULL),(85,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"1b30aa72-8693-4561-b9eb-a1f52575b263\"}',0,'2026-01-20 13:51:39',NULL),(86,'{\"name\": \"trunk_sub_port_one\", \"network\": \"c7834cc6-197b-45bc-95c2-5dcfa20cecce\"}',0,'2026-01-20 13:51:40',NULL),(87,'{\"name\": \"trunk_parent_port\", \"network\": \"1b30aa72-8693-4561-b9eb-a1f52575b263\"}',0,'2026-01-20 13:51:41',NULL),(88,'{\"name\": \"trunk_sub_port_two\", \"network\": \"093dd2bb-9f94-48af-bdcd-a3aa4352548b\"}',0,'2026-01-20 13:51:41',NULL),(89,'{\"network\": \"6a62735f-5285-459a-8763-3a10ce21d521\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:51:42',NULL),(90,'{\"name\": \"test_trunk\", \"port\": \"6f6de104-a15e-4321-a0af-93d2f312c37d\", \"sub_ports\": [{\"port\": \"f7a24831-372e-4bbd-9a5b-1f429c9fa8b0\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:51:42',NULL),(92,'{\"network\": \"6a62735f-5285-459a-8763-3a10ce21d521\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\"}',0,'2026-01-20 13:51:53',NULL),(93,'{\"name\": \"test_trunk\", \"port\": \"6f6de104-a15e-4321-a0af-93d2f312c37d\", \"sub_ports\": []}',0,'2026-01-20 13:51:54',NULL),(97,'{\"network\": \"8727a630-00b6-4187-aa8b-97105d8fa27e\", \"cidr\": \"11.11.11.0/24\", \"gateway_ip\": \"11.11.11.5\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:52:03',NULL),(98,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"b9c02741-791c-45c3-b569-18504f1c1de0\", \"fixed_ip\": \"11.11.11.198\"}]}',0,'2026-01-20 13:52:04',NULL),(100,'{\"name\": \"my_net\"}',0,'2026-01-20 13:52:08',NULL),(101,'{\"network\": \"8727a630-00b6-4187-aa8b-97105d8fa27e\", \"cidr\": \"11.11.11.0/24\", \"allocation_pools\": [{\"start\": \"11.11.11.10\", \"end\": \"11.11.11.250\"}]}',0,'2026-01-20 13:52:09',NULL),(102,'{\"name\": \"the_sg\", \"description\": \"Ping and SSH\", \"rules\": [{\"protocol\": \"icmp\"}, {\"protocol\": \"tcp\", \"port_range_min\": 22, \"port_range_max\": 22}]}',0,'2026-01-20 13:52:09',NULL),(103,'{\"network\": \"9946ec75-e13d-4e17-b4c5-b003ff9c0eb1\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:52:10',NULL),(105,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"6f8f6475-0be5-48db-b659-09adad2433f1\"}',0,'2026-01-20 13:52:10',NULL),(106,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"6625097a-abed-4c42-88e4-8e10be907580\"}',0,'2026-01-20 13:52:11',NULL),(107,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"c8d766dd-96c3-4e9f-a64c-8a23548b368a\", \"fixed_ip\": \"11.11.11.11\"}], \"security_groups\": [\"b3802cf5-62c1-4792-88d5-51268e8062a8\"]}',0,'2026-01-20 13:52:12',NULL),(108,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"5abea305-33d2-41d2-a794-5efe8b8004c2\"}',0,'2026-01-20 13:52:12',NULL),(109,'{\"name\": \"trunk_parent_port\", \"network\": \"6f8f6475-0be5-48db-b659-09adad2433f1\"}',0,'2026-01-20 13:52:12',NULL),(110,'{\"name\": \"trunk_sub_port_two\", \"network\": \"6625097a-abed-4c42-88e4-8e10be907580\"}',0,'2026-01-20 13:52:13',NULL),(112,'{\"name\": \"trunk_sub_port_one\", \"network\": \"5abea305-33d2-41d2-a794-5efe8b8004c2\"}',0,'2026-01-20 13:52:15',NULL),(113,'{\"name\": \"test_trunk\", \"port\": \"b31f7931-85c6-4bb6-9dab-6a6d57053d48\", \"sub_ports\": [{\"port\": \"962ea677-2d06-44f9-802a-45358f45646c\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}, {\"port\": \"d0d0b958-396c-4bc1-9b7f-b0c0a14215e5\", \"segmentation_id\": 20, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:52:16',NULL),(114,'{\"name\": \"the_net\"}',0,'2026-01-20 13:52:22',NULL),(115,'{\"name\": \"the_subnet\", \"network\": \"36e46566-9455-4a78-b79a-3825f4dc1885\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:52:25',NULL),(116,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"36e46566-9455-4a78-b79a-3825f4dc1885\"}]}',0,'2026-01-20 13:52:29',NULL),(117,'{\"name\": \"test_trunk\", \"port\": \"b31f7931-85c6-4bb6-9dab-6a6d57053d48\", \"sub_ports\": [{\"port\": \"962ea677-2d06-44f9-802a-45358f45646c\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:52:33',NULL),(121,'{\"cidr\": \"10.20.0.0/16\", \"network\": \"ddedf93a-7af8-4327-b743-55e99db3ac9e\"}',0,'2026-01-20 13:52:47',NULL),(122,'{\"name\": \"trunk_sub_port_two\", \"network\": \"ddedf93a-7af8-4327-b743-55e99db3ac9e\"}',0,'2026-01-20 13:52:48',NULL),(123,'{\"cidr\": \"10.0.0.0/16\", \"network\": \"2c3cee5c-8203-4536-a5e6-897b5dd97c37\"}',0,'2026-01-20 13:52:48',NULL),(124,'{\"cidr\": \"10.10.0.0/16\", \"network\": \"b359bb9a-48d1-471e-b6be-82aa4a43ca3a\"}',0,'2026-01-20 13:52:51',NULL),(125,'{\"name\": \"trunk_parent_port\", \"network\": \"2c3cee5c-8203-4536-a5e6-897b5dd97c37\"}',0,'2026-01-20 13:52:52',NULL),(126,'{\"name\": \"the_net\"}',0,'2026-01-20 13:52:52',NULL),(127,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"36e46566-9455-4a78-b79a-3825f4dc1885\", \"subnet\": \"1b6e61bd-dca4-4f9e-93b7-059a6e2830da\"}]}',0,'2026-01-20 13:52:52',NULL),(128,'{\"name\": \"trunk_sub_port_one\", \"network\": \"b359bb9a-48d1-471e-b6be-82aa4a43ca3a\"}',0,'2026-01-20 13:52:52',NULL),(129,'{\"network\": \"f14c6b8d-dd7e-4018-a7a4-009f8f8f4f3e\", \"cidr\": \"12.12.12.0/24\", \"name\": \"subnet_b\"}',0,'2026-01-20 13:52:53',NULL),(130,'{\"network\": \"f14c6b8d-dd7e-4018-a7a4-009f8f8f4f3e\", \"cidr\": \"11.11.11.0/24\", \"name\": \"subnet_a\"}',0,'2026-01-20 13:52:53',NULL),(131,'{\"name\": \"test_trunk\", \"port\": \"788d4dc1-d8ce-4dc8-9ef2-2b0b5f507253\", \"sub_ports\": [{\"port\": \"bdb15712-3672-435b-8201-b6f373e495ec\", \"segmentation_id\": 10, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:52:54',NULL),(132,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"12222ae5-779b-4e02-9da8-8957d6cc6c5e\"}]}',0,'2026-01-20 13:52:54',NULL),(134,'{\"name\": \"the_net\"}',0,'2026-01-20 13:53:04',NULL),(135,'{\"name\": \"the_subnet\", \"network\": \"c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:53:07',NULL),(136,'{\"name\": \"test_trunk\", \"port\": \"788d4dc1-d8ce-4dc8-9ef2-2b0b5f507253\", \"sub_ports\": [{\"port\": \"bdb15712-3672-435b-8201-b6f373e495ec\", \"segmentation_id\": 99, \"segmentation_type\": \"vlan\"}]}',0,'2026-01-20 13:53:08',NULL),(137,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7\"}, {\"network\": \"c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7\", \"fixed_ip\": \"11.11.11.33\"}, {\"subnet\": \"e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12\"}]}',0,'2026-01-20 13:53:09',NULL),(140,'{\"network\": \"d7a29abf-67fc-490b-83c6-0af9f521d6fd\", \"cidr\": \"10.10.0.0/16\"}',0,'2026-01-20 13:53:27',NULL),(141,'{\"network\": \"beb5caa3-a9b8-4dac-859b-b6fd566e14f4\", \"cidr\": \"10.20.0.0/16\"}',0,'2026-01-20 13:53:28',NULL),(142,'{\"network\": \"36118700-e1af-4580-93c2-0ff000e015c0\", \"cidr\": \"10.0.0.0/16\"}',0,'2026-01-20 13:53:28',NULL),(143,'{\"network\": \"d7a29abf-67fc-490b-83c6-0af9f521d6fd\", \"name\": \"trunk_sub_port_one\"}',0,'2026-01-20 13:53:30',NULL),(144,'{\"network\": \"36118700-e1af-4580-93c2-0ff000e015c0\", \"name\": \"trunk_parent_port\"}',0,'2026-01-20 13:53:30',NULL),(145,'{\"network\": \"beb5caa3-a9b8-4dac-859b-b6fd566e14f4\", \"name\": \"trunk_sub_port_two\"}',0,'2026-01-20 13:53:31',NULL),(146,'{\"name\": \"test_trunk\", \"port\": \"f6b93916-5fbd-4b46-b50b-e96d65699d38\", \"sub_ports\": null}',0,'2026-01-20 13:53:31',NULL),(147,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"ee3f81f3-5396-4fd6-90ec-6960e3aa09a0\"}]}',0,'2026-01-20 13:53:36',NULL),(148,'{\"description\": \"This is a test trunk\", \"name\": \"pineapple\", \"port\": \"f6b93916-5fbd-4b46-b50b-e96d65699d38\", \"sub_ports\": null}',0,'2026-01-20 13:53:38',NULL),(152,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12\"}, {\"network\": \"c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7\"}, {\"network\": \"c4ad32ae-0eaf-4ce6-a31c-31bd0329cda7\", \"subnet\": \"e23e3731-a2b4-4ebf-b0a5-13bfb2bf6c12\"}]}',0,'2026-01-20 13:53:58',NULL),(153,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-20 13:54:02',NULL),(156,'{\"name\": \"the_net\"}',0,'2026-01-20 13:54:16',NULL),(157,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-20 13:54:16',NULL),(158,'{\"name\": \"the_subnet\", \"network\": \"521851aa-d705-4cb1-9d23-329f51e24de2\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:54:17',NULL),(159,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"521851aa-d705-4cb1-9d23-329f51e24de2\"}]}',0,'2026-01-20 13:54:18',NULL),(161,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random1:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random1, value]}\\n\"}',0,'2026-01-20 13:54:45',NULL),(162,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"port\": \"39005553-c415-483a-95a0-70226e4ae241\"}]}',0,'2026-01-20 13:54:50',NULL),(164,'{\"context\": {\"region_name\": \"regionOne\"}, \"template\": \"\\nheat_template_version: 2013-05-23\\nresources:\\n  random2:\\n    type: OS::Heat::RandomString\\noutputs:\\n  remote_key:\\n    value: {get_attr: [random2, value]}\\n\"}',0,'2026-01-20 13:54:55',NULL),(165,'{\"name\": \"the_net\"}',0,'2026-01-20 13:55:03',NULL),(166,'{\"name\": \"the_subnet\", \"network\": \"cc255312-7fdf-4af3-b29e-c428e1741e64\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:55:05',NULL),(167,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"cc255312-7fdf-4af3-b29e-c428e1741e64\"}]}',0,'2026-01-20 13:55:07',NULL),(168,'{\"value\": \"Test1\"}',0,'2026-01-20 13:55:07',NULL),(169,'{\"value\": \"Test2\"}',0,'2026-01-20 13:55:07',NULL),(170,'{\"value\": \"Test1\"}',0,'2026-01-20 13:55:15',NULL),(171,'{\"value\": \"Test2\"}',0,'2026-01-20 13:55:16',NULL),(172,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-20 13:55:22',NULL),(174,'{\"count\": 1, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-01-20 13:55:28',NULL),(175,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"4344eda7-72d8-4dd9-921e-dbe1e13e5119\"}]}',0,'2026-01-20 13:55:35',NULL),(176,'{\"count\": 2, \"resource_def\": {\"type\": \"OS::Heat::RandomString\"}}',0,'2026-01-20 13:55:39',NULL),(178,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:55:42',NULL),(179,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:42',NULL),(180,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:42',NULL),(181,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:42',NULL),(182,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:42',NULL),(183,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:42',NULL),(184,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:42',NULL),(185,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:42',NULL),(186,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:42',NULL),(187,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:42',NULL),(188,'{\"config\": \"5dc13f31-1a14-4801-adb5-098842edc7e2\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:42',NULL),(189,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:55:44',NULL),(190,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:44',NULL),(191,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:44',NULL),(192,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:44',NULL),(193,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:44',NULL),(194,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:44',NULL),(195,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:44',NULL),(196,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:44',NULL),(197,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:44',NULL),(198,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:44',NULL),(199,'{\"config\": \"3cc252a8-398e-4a67-9276-e44e75a3c773\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:44',NULL),(200,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:55:49',NULL),(201,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:52',NULL),(202,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:52',NULL),(203,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:52',NULL),(204,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:52',NULL),(205,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:52',NULL),(206,'{\"name\": \"the_net\"}',0,'2026-01-20 13:55:53',NULL),(207,'{\"config\": \"0a394036-a9cb-4790-a393-a17519c45099\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:53',NULL),(208,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:55:54',NULL),(209,'{\"name\": \"the_subnet\", \"network\": \"94a1b7ae-57e3-4fe6-b60c-c503dccee1e1\", \"cidr\": \"11.11.11.0/24\"}',0,'2026-01-20 13:55:54',NULL),(210,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:54',NULL),(211,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:54',NULL),(212,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:54',NULL),(213,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:54',NULL),(214,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:54',NULL),(215,'{\"config\": \"51da4ba3-5a3a-4080-9dc5-ac01240c1ac0\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:54',NULL),(216,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"subnet\": \"aefe4656-efc7-4733-a84b-1f4360f0d4d2\"}]}',0,'2026-01-20 13:55:55',NULL),(217,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:55:55',NULL),(218,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:55',NULL),(219,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:55',NULL),(220,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"servers\": {\"0\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}}',0,'2026-01-20 13:55:55',NULL),(221,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:56',NULL),(222,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:57',NULL),(223,'{\"config\": \"71f022f4-74f0-440c-bf6f-28c7cbbde1b9\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"19e51f33-595b-4a06-b661-e59340ad23de\"}',0,'2026-01-20 13:55:57',NULL),(224,'{\"length\": 10}',0,'2026-01-20 13:56:10',NULL),(226,'{\"value\": \"a\"}',0,'2026-01-20 13:56:21',NULL),(227,'{\"value\": \"b\"}',0,'2026-01-20 13:56:22',NULL),(228,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"networks\": [{\"network\": \"94a1b7ae-57e3-4fe6-b60c-c503dccee1e1\"}]}',0,'2026-01-20 13:56:26',NULL),(231,'{\"value\": \"b\"}',0,'2026-01-20 13:56:37',NULL),(232,'{\"value\": \"a\"}',0,'2026-01-20 13:56:38',NULL),(233,'{\"value\": \"test1\", \"fail\": false, \"update_replace\": false, \"wait_secs\": 0}',0,'2026-01-20 13:56:44',NULL),(234,'{\"value\": \"foo\"}',0,'2026-01-20 13:56:50',NULL),(235,'{\"value\": \"foo\"}',0,'2026-01-20 13:56:52',NULL),(236,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-01-20 13:56:55',NULL),(237,'{\"context\": {\"region_name\": \"regionOne\"}, \"parameters\": {\"name\": \"remote-nested\", \"network_name\": \"public\"}, \"template\": \"{\\\"heat_template_version\\\": \\\"2015-10-15\\\", \\\"description\\\": \\\"The intermediate stack (containing a local nested stack) to be instantiated\\\\nremotely in the remote deeply-nested stack test.\\\\n\\\", \\\"parameters\\\": {\\\"name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"Name of the router\\\", \\\"constraints\\\": [{\\\"allowed_pattern\\\": \\\"[a-z][a-z0-9-]{1,}\\\"}]}, \\\"network_name\\\": {\\\"type\\\": \\\"string\\\", \\\"description\\\": \\\"The public network to connect to\\\", \\\"constraints\\\": [{\\\"custom_constraint\\\": \\\"neutron.network\\\"}]}}, \\\"resources\\\": {\\\"network_stack_as_custom_type\\\": {\\\"type\\\": \\\"file:///usr/lib/python3.9/site-packages/heat_tempest_plugin/tests/scenario/templates/remote_nested_base.yaml\\\", \\\"properties\\\": {\\\"name\\\": {\\\"get_param\\\": \\\"name\\\"}, \\\"network_name\\\": {\\\"get_param\\\": \\\"network_name\\\"}}}}, \\\"outputs\\\": {\\\"router\\\": {\\\"value\\\": {\\\"get_attr\\\": [\\\"network_stack_as_custom_type\\\", \\\"router\\\"]}}}}\"}',0,'2026-01-20 13:57:04',NULL),(238,'{\"name\": \"remote-nested\", \"network_name\": \"public\"}',0,'2026-01-20 13:57:05',NULL),(239,'{\"name\": \"remote-nested-router\", \"external_gateway_info\": {\"network\": \"public\"}}',0,'2026-01-20 13:57:06',NULL),(240,'{\"wait_secs\": 1, \"value\": \"test\"}',0,'2026-01-20 13:57:08',NULL),(243,'{\"wait_secs\": 1, \"value\": \"next\"}',0,'2026-01-20 13:57:16',NULL),(244,'{\"image\": \"6ce7f43a-0878-4c7a-8a8d-03b0b1ebca34\", \"flavor\": \"b334ccc6-8375-47ae-952b-c2998ec7eb5b\", \"user_data_format\": \"SOFTWARE_CONFIG\", \"networks\": [{\"network\": \"heat_tempestconf_network\"}]}',0,'2026-01-20 13:57:18',NULL),(245,'{\"wait_secs\": 1, \"value\": \"none\"}',0,'2026-01-20 13:57:21',NULL),(246,'{\"update_replace\": false, \"wait_secs\": 0, \"value\": \"Test1\", \"fail\": false}',0,'2026-01-20 13:57:30',NULL),(247,'{\"config\": \"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\"}',0,'2026-01-20 13:57:34',NULL),(248,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"servers\": {\"0\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}}',0,'2026-01-20 13:57:34',NULL),(249,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"servers\": {\"0\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}}',0,'2026-01-20 13:57:34',NULL),(250,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"servers\": {\"0\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}}',0,'2026-01-20 13:57:34',NULL),(251,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}',0,'2026-01-20 13:57:34',NULL),(252,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}',0,'2026-01-20 13:57:34',NULL),(253,'{\"config\": \"7e64b40e-d7c3-402d-8e5e-0cd315cc18b4\", \"input_values\": null, \"actions\": [\"CREATE\", \"UPDATE\"], \"name\": null, \"signal_transport\": \"CFN_SIGNAL\", \"server\": \"a1c2e4fd-59d3-4b48-bd34-fae7e6d73925\"}',0,'2026-01-20 13:57:34',NULL),(254,'{\"length\": 10}',0,'2026-01-20 13:58:56',NULL);
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('1bf97ed7-5140-4acf-bffe-8e0696e480fc','dd2f7bea-57ba-424f-be42-f25aaeecb10a','heat-engine-56fcff5664-cmd6l','heat-engine-56fcff5664-cmd6l','heat-engine','engine',60,'2026-01-20 13:22:38','2026-01-20 13:23:05','2026-01-20 13:23:05'),('399a1b2f-854e-4ffa-ac76-fe43b2e07fa3','ea486b46-4704-42e9-980a-a05a8edc446f','heat-engine-56fcff5664-cmd6l','heat-engine-56fcff5664-cmd6l','heat-engine','engine',60,'2026-01-20 13:22:38','2026-01-20 13:23:05','2026-01-20 13:23:05'),('3ed602bd-ae38-498e-9097-9745300356a1','2a92ca97-fa35-47ad-992c-a5318a82341a','heat-engine-56fcff5664-cmd6l','heat-engine-56fcff5664-cmd6l','heat-engine','engine',60,'2026-01-20 13:22:38','2026-01-20 13:23:05','2026-01-20 13:23:05'),('562587e2-27c5-4eab-b7e7-745abdbffb6e','9c6ec381-ece0-4ae5-8c24-c33690bf2be9','heat-engine-b4c58bb9c-5hngx','heat-engine-b4c58bb9c-5hngx','heat-engine','engine',60,'2026-01-20 13:22:54','2026-01-20 14:18:54',NULL),('72f19ab1-e988-4a2b-b64b-2c1a1b705882','4f6ce987-37b0-4d4a-b8fa-07f8306230d0','heat-engine-56fcff5664-cmd6l','heat-engine-56fcff5664-cmd6l','heat-engine','engine',60,'2026-01-20 13:22:38','2026-01-20 13:23:05','2026-01-20 13:23:05'),('8ba13400-f6eb-426e-a919-59027b023b9c','8b9ac40a-60f2-4aa8-9a09-5851cd1fc5a6','heat-engine-b4c58bb9c-5hngx','heat-engine-b4c58bb9c-5hngx','heat-engine','engine',60,'2026-01-20 13:22:54','2026-01-20 14:18:54',NULL),('ddf04bf2-6afc-4289-8e94-4331b28d6b22','7b3b778a-be28-407d-bc0d-36d5269a75da','heat-engine-b4c58bb9c-5hngx','heat-engine-b4c58bb9c-5hngx','heat-engine','engine',60,'2026-01-20 13:22:54','2026-01-20 14:18:54',NULL),('f17c5900-f7de-4773-8bb1-4d62f498171f','9c364bff-e5b6-477f-945e-b670b8a29692','heat-engine-b4c58bb9c-5hngx','heat-engine-b4c58bb9c-5hngx','heat-engine','engine',60,'2026-01-20 13:22:54','2026-01-20 14:18:54',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
INSERT INTO `software_config` (`id`, `created_at`, `updated_at`, `name`, `group`, `config`, `tenant`) VALUES ('204e13d3-a3a0-4a72-a8c0-1106f784b227','2026-01-20 13:50:15',NULL,'api-1445742041-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','9fefc90697004684a6a41a2739520551'),('75efb795-9778-4b74-812c-0dbdb267f3ba','2026-01-20 13:50:09',NULL,'api-1214827273-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','9fefc90697004684a6a41a2739520551'),('f6c70a22-9438-4e07-b9d5-3e5a03e58ff5','2026-01-20 13:50:09',NULL,'api-108285926-config','script','{\"inputs\": [], \"outputs\": [], \"options\": {}, \"config\": \"#!/bin/sh -x\\\\necho hello\"}','9fefc90697004684a6a41a2739520551');
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
INSERT INTO `software_deployment` (`id`, `created_at`, `updated_at`, `server_id`, `config_id`, `input_values`, `output_values`, `action`, `status`, `status_reason`, `tenant`, `stack_user_project_id`) VALUES ('ca1d3b88-b7c8-4192-b7f2-31c4d58a8db1','2026-01-20 13:50:10','2026-01-20 13:50:11','dummy_server','75efb795-9778-4b74-812c-0dbdb267f3ba','{}','null','ACTION1','COMPLETE','completed','9fefc90697004684a6a41a2739520551',NULL);
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_name` (`name`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
INSERT INTO `stack` (`id`, `created_at`, `updated_at`, `deleted_at`, `name`, `raw_template_id`, `prev_raw_template_id`, `user_creds_id`, `username`, `owner_id`, `action`, `status`, `status_reason`, `timeout`, `tenant`, `disable_rollback`, `stack_user_project_id`, `backup`, `nested_depth`, `convergence`, `current_traversal`, `current_deps`, `parent_resource_name`) VALUES ('03b07b2a-f62f-43d4-a292-4939980296c0','2026-01-20 13:55:54','2026-01-20 13:56:20','2026-01-20 13:56:25','ParallelDeploymentsTest-1006090207',178,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'183896f7a46647b6aa926f08ed8475df',0,0,1,'44390dfe-dfb2-42f3-bbc4-fdff882f7527','{\"edges\": [[[200, false], [199, false]], [[200, false], [197, false]], [[200, false], [198, false]]]}',NULL),('07926ba9-1a40-4d37-a318-08e5fd0337ac','2026-01-20 13:55:47','2026-01-20 13:55:53','2026-01-20 13:55:55','HooksTest-191390256',166,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'ca14576370fd4dc3ba3c5467ec19c03b',0,0,1,'6b8dac85-08c7-47a1-b3cd-58491792a260','{\"edges\": [[[178, false], [177, false]], [[179, false], [178, false]]]}',NULL),('09ac263d-b621-4142-a590-7a996ff26cfb','2026-01-20 13:55:54','2026-01-20 13:56:31','2026-01-20 13:56:32','ParallelDeploymentsTest-1375998189-dep_1-sirjbj4w5u7r',190,NULL,NULL,'demo_tempestconf','fab57e2a-6be8-4888-9705-5ff23fd7e69a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'95f93cc50035402f9167bb764e0d2ed1',0,1,1,'4b8e3251-fd80-4f73-a91d-36c5ced9105f','{\"edges\": [[[196, false], null]]}','dep_1'),('09d32f36-159e-4b6d-ae75-3e66af71d0eb','2026-01-20 13:57:08','2026-01-20 13:57:24','2026-01-20 13:57:27','StackTagTest-2138038557',229,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'07da5df89fb841e8828a83e4f0c67768',0,0,1,'aefe52bc-40c6-4a2f-8d64-81a87e8dd3d0','{\"edges\": [[[220, false], null]]}',NULL),('0b242c5a-ddc1-4546-9f35-baf3f0441e90','2026-01-20 13:58:55','2026-01-20 13:58:56','2026-01-20 13:58:57','StackUnicodeTemplateTest-2554332',242,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'4f1c12d5a7c54c70b23ad1d935d457ae',0,0,1,'da33230b-01bb-4755-a9f7-01478d3835d2','{\"edges\": [[[230, false], null]]}',NULL),('0caf173f-db2a-4c41-a8a3-2b957a744eda','2026-01-20 13:56:50','2026-01-20 13:56:56','2026-01-20 13:56:58','StackOutputsTest-565959838',210,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'ec00e7a3a0014a91a9a829fd0384a56b',0,0,1,'eded655f-b27c-449f-af5c-1f9265b5df37','{\"edges\": [[[214, false], [215, false]]]}',NULL),('10eb6231-59ee-4d3a-b82a-b6f6d27f1471','2026-01-20 13:55:42','2026-01-20 13:56:51','2026-01-20 13:56:57','ParallelDeploymentsTest-218845895',202,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,0,1,'31dae4f1-a8d0-480d-8869-daea61af9588','{\"edges\": [[[171, false], [169, false]], [[171, false], [167, false]], [[171, false], [170, false]], [[171, false], [168, false]], [[171, false], [166, false]]]}',NULL),('1cc331e6-c438-4bca-bd7d-209c06e68dd0','2026-01-20 13:57:17','2026-01-20 13:58:50','2026-01-20 13:58:54','ParallelDeploymentsTest-1495015573',240,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'a6609e04340e496abb42e276520a05ab',0,0,1,'53dd9ae3-e9bd-495b-b599-05d8f2df2bc8','{\"edges\": [[[221, false], null]]}',NULL),('1d8a9c3d-6c43-45c6-8c95-04a45cc406c1','2026-01-20 13:54:16','2026-01-20 13:54:39','2026-01-20 13:54:40','RemoteStackTest-1369055629',115,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'21071fb676f6415eb018bdae903b83ad',0,0,1,'844d0aed-969a-4033-b081-f7fca69eb68f','{\"edges\": [[[129, false], null]]}',NULL),('1eaf07de-5ba6-4ae8-96bc-4064e5b165d7','2026-01-20 13:56:36','2026-01-20 13:56:43','2026-01-20 13:56:46','StackOutputsTest-1814818406',199,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'40c08407a5fd48279928e7a8c282fdf2',0,0,1,'67154523-0a5f-401c-a0fd-61a4315b33c4','{\"edges\": [[[211, false], null], [[212, false], null]]}',NULL),('1f7a6e7f-773c-4c35-a6ae-a7e7f39522f2','2026-01-20 13:55:44','2026-01-20 13:56:55','2026-01-20 13:56:56','ParallelDeploymentsTest-218845895-dep_2-x7ph3hbun5j7',209,NULL,NULL,'demo_tempestconf','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,1,1,'15f30822-0c5b-4253-8304-fdb441d8fb9d','{\"edges\": [[[176, false], null]]}','dep_2'),('1f8fe575-2886-4923-bb89-d7214b8c829b','2026-01-20 13:57:05','2026-01-20 13:57:14','2026-01-20 13:57:17','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5',225,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'51b9523186f14b51bdc9f105e59b8748',0,0,1,'83c9ce59-6b67-4222-838e-497f6c783d8c','{\"edges\": [[[218, false], null]]}',NULL),('1f92bcda-cc59-4806-a482-5fa9ca1d0f58','2026-01-20 13:55:59','2026-01-20 13:56:14','2026-01-20 13:56:17','HooksTest-1805989431',176,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c618a0929ab94e89af02963ba756231e',0,0,1,'67fb72a8-623d-4d11-9b62-8310c80731a1','{\"edges\": [[[204, false], null], [[206, false], [207, false]]]}',NULL),('20ca30d0-05f1-4456-b87e-a2d3274a8e75','2026-01-20 13:50:20','2026-01-20 13:50:35','2026-01-20 13:50:39','UpdatePortTest-1177326764',39,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'68c46bafe0b44e86828c2ed7d7c8968e',0,0,1,'975bc792-d70c-4169-9c5b-f08501fb3e02','{\"edges\": [[[13, false], [12, false]], [[15, false], [13, false]], [[15, false], [14, false]], [[14, false], [13, false]]]}',NULL),('217d4478-6268-4748-9435-22510c02434d','2026-01-20 13:51:26','2026-01-20 13:51:57','2026-01-20 13:52:04','server_with_port',70,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c77f48a01c804a7290d3d86a44e34260',0,0,1,'b91bf972-6c52-4df6-b538-4fbceb6f1985','{\"edges\": [[[57, false], [56, false]], [[57, false], [55, false]], [[56, false], [55, false]], [[58, false], [56, false]], [[58, false], [57, false]]]}',NULL),('231ae6d8-25bf-41b0-b034-91ef9413e0a7','2026-01-20 13:50:14','2026-01-20 13:50:15','2026-01-20 13:50:16','api-442217991-empty',17,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'57fb1d72d7984a29a53e0285b8f6bff0',0,0,1,'db6b3b37-ee69-47b3-8e5e-cfbd3bf6be0a','{\"edges\": []}',NULL),('291dc099-8006-4f6a-a09e-e498237ef0c3','2026-01-20 13:53:24','2026-01-20 13:53:44','2026-01-20 13:53:51','UpdateTrunkTest-1377681932',94,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'828a0a6d7b194b91af5cadb218381391',0,0,1,'9b855302-c126-4105-9864-942f609a8d0f','{\"edges\": [[[112, false], [110, false]], [[112, false], [111, false]], [[111, false], [110, false]], [[114, false], [113, false]], [[116, false], [115, false]], [[116, false], [114, false]], [[115, false], [114, false]], [[119, false], [118, false]], [[119, false], [117, false]], [[118, false], [117, false]]]}',NULL),('2b18d5e5-918f-4797-873e-81ecc1bdc475','2026-01-20 13:50:41','2026-01-20 13:50:56','2026-01-20 13:50:59','UpdatePortTest-859279828',49,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'2ad51e96726a496fbbce4a0ed4cf0061',1,'3bee9f9f311248698122e33961977af1',0,0,1,'9a7659aa-e9eb-49ce-a4f4-9308d11eb386','{\"edges\": [[[32, false], null], [[34, false], [39, false]], [[35, false], [39, false]], [[35, false], [34, false]]]}',NULL),('2b3397b5-dce8-4bf4-aa95-537d9d366039','2026-01-20 13:55:52','2026-01-20 13:56:41','2026-01-20 13:56:44','ParallelDeploymentsTest-269394896-dep_0-umwvmtyj76dd',195,NULL,NULL,'demo_tempestconf','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c35dbdd1e5cb4748b4e7a2cc82c158ab',0,1,1,'29f9ba67-c112-4b35-a536-4a66531010f6','{\"edges\": [[[185, false], null]]}','dep_0'),('2bffa8f5-d94b-4bc8-8a58-8b34630fb4bf','2026-01-20 13:57:34','2026-01-20 13:58:41','2026-01-20 13:58:42','ParallelDeploymentsTest-862999738-dep_2-wca3kmf5o3dw',237,NULL,NULL,'demo_tempestconf','86823e94-9b05-48f8-bf47-db859524cc29','DELETE','COMPLETE','Stack DELETE completed successfully',1,'9fefc90697004684a6a41a2739520551',1,'22cadf4b63384f2eb09799c7c3aa31dc',0,1,1,'4a8923ec-6465-4d38-aaa2-758500820ac3','{\"edges\": [[[228, false], null]]}','dep_2'),('2fe14eb7-f6bb-491f-a596-3c6e7e25a7f7','2026-01-20 13:54:46','2026-01-20 13:54:59','2026-01-20 13:55:00','HooksTest-1960363033-nested-vtxf4f4k5gag',127,NULL,NULL,'demo_tempestconf','42c7d028-3a33-438e-9098-dea53e975d86','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'b40a0da75e0c4bcc9479e82061f02030',0,1,1,'952774e1-9da8-40c7-a2cb-5e6257015f01','{\"edges\": [[[137, false], [136, false]], [[138, false], [137, false]]]}','nested'),('3036d6bf-2270-437f-96b4-f8139efcbc8a','2026-01-20 13:54:01','2026-01-20 13:54:08','2026-01-20 13:54:09','ExternalReferencesTest-423530269',105,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'506fbd8420404e109aa975c5c40b2599',0,0,1,'94e60e5b-b8a0-48d0-a2b4-2aa5a63745a9','{\"edges\": [[[122, false], null]]}',NULL),('30b7146c-ea7b-4695-8a2b-b5d59d95ddf2','2026-01-20 13:50:08','2026-01-20 13:50:13','2026-01-20 13:50:14','api-1445742041-rsrcstack',11,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'f6acd1b862ed48a0adbb0286216ee993',0,0,1,'cbdfd90f-54b6-4443-a7f1-74414f2e181d','{\"edges\": [[[7, false], null]]}',NULL),('31809bc8-7bd6-4340-ab3a-076e5e8445e6','2026-01-20 13:54:14','2026-01-20 13:54:21','2026-01-20 13:54:24','ExternalReferencesTest-1222046502',113,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'fd49dbf332a5460ea7d0b218bacff8fe',0,0,1,'5fac7637-a331-4424-9739-3a5d4c95edaa','{\"edges\": [[[125, false], null]]}',NULL),('342cc870-d390-45f3-b653-df8f6101a117','2026-01-20 13:50:16','2026-01-20 13:50:28','2026-01-20 13:50:29','api-442217991-stack',33,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'f7be6651d8b54000bec8aa9a964052c1',0,0,1,'57181d06-f9c5-4808-b5e7-d62a5d9fe6ac','{\"edges\": [[[10, false], null]]}',NULL),('3630e8a5-ab85-4c55-94d3-a7e54936c3aa','2026-01-20 13:54:28','2026-01-20 13:54:40','2026-01-20 13:54:41','HooksTest-2076002288',117,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'72e5e907712741489aa504c8a831b918',0,0,1,'acc2416e-a7cf-4a16-8b75-34e33f645f6e','{\"edges\": [[[132, false], [131, false]], [[133, false], [132, false]]]}',NULL),('3819d7a4-a93a-4915-83fa-803c95d59207','2026-01-20 13:52:51','2026-01-20 13:53:41','2026-01-20 13:53:49','create_server_with_sub_ip',93,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'7fcaabb46e624201a8d55fbc914e3002',0,0,1,'69d9820f-3c00-42e8-a353-79559d463ccc','{\"edges\": [[[105, false], [103, false]], [[104, false], [103, false]], [[106, false], [104, false]], [[106, false], [105, false]]]}',NULL),('392082f6-2f1f-455b-a46f-d19921aa2c4b','2026-01-20 13:50:24','2026-01-20 13:50:35','2026-01-20 13:50:37','UpdateSubnetTest-574386486',38,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'1d7ff4b422df4d428580a0232d0bef02',0,0,1,'2dc469e6-62c9-49bf-a688-17e58e6187a5','{\"edges\": [[[17, false], [16, false]]]}',NULL),('3d993ff3-b44d-4656-906d-69870da50d4c','2026-01-20 13:51:39','2026-01-20 13:51:56','2026-01-20 13:51:59','UpdateSubnetTest-1112033237',69,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'a27b7eaa906a4db69b76306e145ffc9d',0,0,1,'342cec6f-1128-4aba-881a-65d89e3babcf','{\"edges\": [[[73, false], [72, false]]]}',NULL),('42c7d028-3a33-438e-9098-dea53e975d86','2026-01-20 13:54:45','2026-01-20 13:54:57','2026-01-20 13:55:01','HooksTest-1960363033',126,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'b40a0da75e0c4bcc9479e82061f02030',0,0,1,'86cffe53-c534-4568-9a99-2a0fe459e652','{\"edges\": [[[135, false], null]]}',NULL),('434e5aeb-17bd-4e97-9aa4-1b3662d9ba7b','2026-01-20 13:52:08','2026-01-20 13:52:36','2026-01-20 13:52:40','UpdateTrunkTest-1305200445',81,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'958d78849ea349a186b695c01ead0874',0,0,1,'26faa632-b1ee-4e1c-a0dc-4d0874071439','{\"edges\": [[[87, false], [80, false]], [[82, false], [80, false]], [[86, false], [85, false]], [[86, false], [81, false]], [[85, false], [81, false]], [[84, false], [82, false]], [[84, false], [83, false]], [[83, false], [82, false]], [[89, false], [88, false]], [[89, false], [87, false]], [[88, false], [87, false]]]}',NULL),('436c6e22-2813-4feb-84af-03e11cca11d8','2026-01-20 13:55:07','2026-01-20 13:55:09','2026-01-20 13:55:11','ResourcesList-327004057',133,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'2a1338cfdea24e66a603e803873cef1a',0,0,1,'aff40fb1-91f6-4508-aff5-5a36d0e39a16','{\"edges\": [[[148, false], [147, false]]]}',NULL),('47e18409-bbb5-4e58-ad6b-5cc29ec2913a','2026-01-20 13:55:49','2026-01-20 13:56:39','2026-01-20 13:56:46','ParallelDeploymentsTest-269394896',194,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c35dbdd1e5cb4748b4e7a2cc82c158ab',0,0,1,'f43f4ac9-c79a-4058-ae6e-a741a906c1ea','{\"edges\": [[[183, false], [180, false]], [[183, false], [181, false]], [[183, false], [182, false]]]}',NULL),('4920fd19-e6d2-4b55-956c-e84dc8649b12','2026-01-20 13:55:04','2026-01-20 13:55:22','2026-01-20 13:55:23','HooksTest-704349220',137,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'6ea5efe736f2407eb44bf54ee24e6f5c',0,0,1,'7e2b4573-9d70-49b1-a1bb-744caf24024d','{\"edges\": [[[145, false], [144, false]], [[146, false], [145, false]]]}',NULL),('4aacb383-051a-437f-98b4-44e5d1db2085','2026-01-20 13:50:57','2026-01-20 13:51:14','2026-01-20 13:51:16','UpdateSubnetTest-1850581261',55,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'9a1f202caedf4e31a217597bb7ece15d',0,0,1,'8b791ba9-a1dc-4905-88bc-2f968aa125c8','{\"edges\": [[[41, false], [40, false]]]}',NULL),('4b4bbd4e-06ec-4510-b52d-96e160653efd','2026-01-20 13:54:15','2026-01-20 13:54:52','2026-01-20 13:55:01','swap_network_port',124,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'279e49d0931a49d1a159866fd0a6fae7',0,0,1,'422b9295-02af-4757-97ea-58ea8d62ed7f','{\"edges\": [[[127, false], [126, false]], [[128, false], [127, false]]]}',NULL),('4f72e5a4-ecdc-4092-a3ed-ec4caf05ebd6','2026-01-20 13:52:08','2026-01-20 13:52:41','2026-01-20 13:52:46','server_with_sub_ip',82,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c109b7472f3b4c43932bdc4c94fddaf5',0,0,1,'a428dd92-81da-4e86-ba0f-242188a8dccd','{\"edges\": [[[78, false], [76, false]], [[77, false], [76, false]], [[79, false], [78, false]]]}',NULL),('4fb4c1a9-bd7c-4f60-8603-c55d220b3697','2026-01-20 13:55:52','2026-01-20 13:56:42','2026-01-20 13:56:44','ParallelDeploymentsTest-269394896-dep_2-wfn5bvgtpw3p',196,NULL,NULL,'demo_tempestconf','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c35dbdd1e5cb4748b4e7a2cc82c158ab',0,1,1,'5d5dd8b6-fe7e-430d-ae35-35fabb298c15','{\"edges\": [[[189, false], null]]}','dep_2'),('5af846ba-164e-43db-8a12-1b42def99db1','2026-01-20 13:50:16','2026-01-20 13:50:17','2026-01-20 13:50:18','api-1445742041-empty',22,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'4e6ffe4e294d45a7aff14437839098e6',0,0,1,'b3e7d0cf-f5cc-44e4-b75c-972ed4a9cbe0','{\"edges\": []}',NULL),('5bb6ebc0-909b-4ba6-929d-9270b67d7f36','2026-01-20 13:53:04','2026-01-20 13:54:05','2026-01-20 13:54:13','multi_networks_swaps',104,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'d49ca89f5f324ae8aaa41c27a5ffd209',0,0,1,'b597f615-81cc-4804-be66-28053f8918c3','{\"edges\": [[[109, false], [107, false]], [[109, false], [108, false]], [[108, false], [107, false]]]}',NULL),('5cea7ac1-da52-4b36-ab15-4dc07eea5ce1','2026-01-20 13:55:42','2026-01-20 13:57:05','2026-01-20 13:57:06','ParallelDeploymentsTest-13617404-dep_4-tx4xgskm5ynt',218,NULL,NULL,'demo_tempestconf','bf3b6dfb-6ce1-4008-a718-2570a6107907','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,1,1,'6f947532-657f-4b8b-a48a-38d15c9cee7e','{\"edges\": [[[162, false], null]]}','dep_4'),('5d38f36b-a174-4e5a-8907-0272bda0c157','2026-01-20 13:50:58','2026-01-20 13:51:22','2026-01-20 13:51:27','UpdateTrunkTest-1488414881',59,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'cf40831e74cb485d83e9ae71483d4600',0,0,1,'99e5d553-ab6d-4158-9b78-6301aebfc02e','{\"edges\": [[[44, false], [42, false]], [[44, false], [43, false]], [[43, false], [42, false]], [[49, false], [45, false]], [[46, false], [45, false]], [[48, false], [47, false]], [[48, false], [46, false]], [[47, false], [46, false]], [[51, false], [50, false]], [[51, false], [49, false]], [[50, false], [49, false]]]}',NULL),('603a193f-38e1-4ba4-adff-2608856255f3','2026-01-20 13:56:55','2026-01-20 13:57:02','2026-01-20 13:57:05','StackTagTest-2092522984',212,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'ac1e142a46fb45edbb04b7e894368f72',0,0,1,'1d584081-d6c4-4170-9705-cbaefe584b89','{\"edges\": [[[216, false], null]]}',NULL),('6202f2b6-dc35-4531-bc27-43932ebb80b4','2026-01-20 13:51:19','2026-01-20 13:51:34','2026-01-20 13:51:36','UpdateSubnetTest-1324097782',64,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'a917bdbb0ae645338ff9ab9fcf180ee1',0,0,1,'c74c18de-b5ba-45fb-b1d0-545ed43e8a67','{\"edges\": [[[54, false], [53, false]]]}',NULL),('62188458-aab9-4802-8579-c47bb0c683f3','2026-01-20 13:50:14','2026-01-20 13:50:19',NULL,'api-108285926-stack',24,NULL,11,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'70be33cc11294fc8a13a54683de41d98',0,0,1,'3850a6ac-f57c-4528-9b11-62c844a06c65','{\"edges\": [[[8, false], [8, true]]]}',NULL),('66f6a281-48a6-4053-b4c6-49d5d8e96121','2026-01-20 13:55:52','2026-01-20 13:56:33','2026-01-20 13:56:37','swap_subnet_network',192,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'2fb817c7143f49d0ac624e0fce79adf1',0,0,1,'c759341d-ad4b-4ffa-b4ed-ac149614d380','{\"edges\": [[[188, false], [187, false]], [[188, false], [184, false]], [[187, false], [184, false]]]}',NULL),('67bccff8-94b7-41ac-95be-3c3ca4a709ca','2026-01-20 13:50:13','2026-01-20 13:50:14','2026-01-20 13:50:15','api-1214827273-empty',15,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'f21691ebc3bb49a3a2759be83b8bacc9',0,0,1,'5f1fe79a-53c1-49c3-a833-cfbdb7d3e2cc','{\"edges\": []}',NULL),('692c6768-914c-48ab-aaa6-97f017665ebe','2026-01-20 13:52:02','2026-01-20 13:52:13','2026-01-20 13:52:16','UpdateSubnetTest-1871972168',78,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'f72b2ce4367e41c78e4015b8fa4e14ab',0,0,1,'fcaeebc5-6121-4839-b4bc-afd92aa8193d','{\"edges\": [[[75, false], [74, false]]]}',NULL),('749cc569-bb07-49e8-a3ca-c34c93fd182d','2026-01-20 13:54:46','2026-01-20 13:55:01','2026-01-20 13:55:03','RemoteStackTest-374237530-my_stack-jylljfvf254r',129,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'49dae34eba8b4b68adfd7166e1efad59',0,0,1,'090e66c1-1156-4b7a-a31b-8550b0a70345','{\"edges\": [[[140, false], null]]}',NULL),('75b9e2b0-e2e8-4e18-a401-2d211d0c53f7','2026-01-20 13:50:15','2026-01-20 13:50:19',NULL,'api-1214827273-stack',26,NULL,12,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'3f47f669049b4176b89d85274c738ef9',0,0,1,'3b62c251-7bdb-4e8d-8ce2-aaf252a81e40','{\"edges\": [[[9, false], [9, true]]]}',NULL),('7cfc803b-d511-477e-be1f-fee8674a6efa','2026-01-20 13:56:43','2026-01-20 13:56:48','2026-01-20 13:56:49','StackEventsTest-632118980',200,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5f987fd16e4f4fe893e5ed782d18f8e8',0,0,1,'40127b71-3935-48aa-b580-636d1e21432c','{\"edges\": [[[213, false], null]]}',NULL),('86823e94-9b05-48f8-bf47-db859524cc29','2026-01-20 13:57:33','2026-01-20 13:58:40','2026-01-20 13:58:47','ParallelDeploymentsTest-862999738',236,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1,'9fefc90697004684a6a41a2739520551',1,'22cadf4b63384f2eb09799c7c3aa31dc',0,0,1,'cbbdd1c5-0649-4324-9972-58b69245fc45','{\"edges\": [[[226, false], [224, false]], [[226, false], [225, false]], [[226, false], [223, false]]]}',NULL),('8707886f-7ca6-4279-8a25-33d4c65a87f7','2026-01-20 13:55:42','2026-01-20 13:57:04','2026-01-20 13:57:05','ParallelDeploymentsTest-13617404-dep_0-i2qcmuwf2wyw',216,NULL,NULL,'demo_tempestconf','bf3b6dfb-6ce1-4008-a718-2570a6107907','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,1,1,'ff835832-210a-406c-af1e-bba7a32242b4','{\"edges\": [[[161, false], null]]}','dep_0'),('876878a6-95f6-49e5-bac0-26e70ec9adca','2026-01-20 13:55:44','2026-01-20 13:56:51','2026-01-20 13:56:52','ParallelDeploymentsTest-218845895-dep_1-ybnivkyzgwqk',203,NULL,NULL,'demo_tempestconf','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,1,1,'c340db70-ea93-4848-ac48-ee832ed410a1','{\"edges\": [[[174, false], null]]}','dep_1'),('87a46c98-cc95-42ca-9a1e-9a12087c387b','2026-01-20 13:50:04',NULL,NULL,'api-442217991-envstack',2,NULL,1,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'f1d4c30cd66d487ab81410a68d2fd2b3',0,0,1,'bd630e37-3b90-4772-b86a-0efe7ff82026','{\"edges\": [[[2, true], null]]}',NULL),('8a3c369a-a004-4745-bc5d-b7c0da7e0a21','2026-01-20 13:53:55','2026-01-20 13:53:56','2026-01-20 13:53:57','RemoteStackTest-70146590',99,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'9970c55d4c77486b83d2a1cd3929b795',0,0,1,'2e07503a-5dc9-4994-8244-445b5326c2d7','{\"edges\": [[[121, false], null]]}',NULL),('8e2f1935-c309-44ff-916c-5be86a24aa8a','2026-01-20 13:50:27','2026-01-20 13:50:38','2026-01-20 13:50:39','EncryptionVolTypeTest-1016197023',40,NULL,NULL,'admin',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'2ad51e96726a496fbbce4a0ed4cf0061',1,'ecd4d39d374c46cbb196d1902eee5e09',0,0,1,'ae8bd107-1c27-4eb2-96e9-3ecd9c4a8f5d','{\"edges\": [[[19, false], [18, false]]]}',NULL),('90cd326a-058b-4800-bc61-ae1230c15e72','2026-01-20 13:52:21','2026-01-20 13:52:57','2026-01-20 13:53:02','add_subnet',86,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'6061eced2bcc4b63b8772e3360182a14',0,0,1,'c5f98c91-8a67-49c5-9e33-97888dacdeba','{\"edges\": [[[92, false], [91, false]], [[92, false], [90, false]], [[91, false], [90, false]]]}',NULL),('913e7d81-33e8-4882-a54c-779cfc4419d3','2026-01-20 13:55:03','2026-01-20 13:55:40','2026-01-20 13:55:46','swap_network_subnet',143,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'e6b5da275df24e8eb808b391a4e5c5f0',0,0,1,'1e4e6149-abce-4678-888d-32c9b8451fae','{\"edges\": [[[142, false], [141, false]], [[143, false], [142, false]]]}',NULL),('9213d019-ef0e-449e-a350-1575dc1f6b74','2026-01-20 13:50:29','2026-01-20 13:50:52','2026-01-20 13:50:57','UpdateTrunkTest-1597981622',48,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5aeb6e1e31be40dc84e998572215c61d',0,0,1,'cb7662ab-e3cf-447a-8ee5-8adba4646bf2','{\"edges\": [[[20, false], [23, false]], [[22, false], [20, false]], [[22, false], [21, false]], [[21, false], [20, false]], [[27, false], [23, false]], [[24, false], [23, false]], [[26, false], [25, false]], [[26, false], [24, false]], [[25, false], [24, false]], [[29, false], [28, false]], [[29, false], [27, false]], [[28, false], [27, false]]]}',NULL),('9b280d66-4c0d-4819-af76-36514cc68d89','2026-01-20 13:55:54','2026-01-20 13:56:30','2026-01-20 13:56:31','ParallelDeploymentsTest-1375998189-dep_2-uyd33ax3fw2g',187,NULL,NULL,'demo_tempestconf','fab57e2a-6be8-4888-9705-5ff23fd7e69a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'95f93cc50035402f9167bb764e0d2ed1',0,1,1,'69882e3a-4312-42d0-8657-9a534d303fc1','{\"edges\": [[[195, false], null]]}','dep_2'),('9cde8460-8c64-454f-bb34-d30f29ee9056','2026-01-20 13:57:04','2026-01-20 13:57:14','2026-01-20 13:57:18','RemoteDeeplyNestedStackTest-1050101322',224,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'d9f7b358af814a1a8c53bbb5348dccbd',0,0,1,'55523d4f-26ed-40a1-bf39-36dec61a9d8b','{\"edges\": [[[217, false], null]]}',NULL),('9e7a635e-4d78-446c-bd95-f703e19d24d0','2026-01-20 13:55:15','2026-01-20 13:55:16','2026-01-20 13:55:17','ResourcesList-1607286495',135,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'38aa282f355b4e0ebcf00ea961594d45',0,0,1,'6fcc66db-bc54-4e68-b239-9c75964c989a','{\"edges\": [[[150, false], [149, false]]]}',NULL),('9fb2ea8b-a649-4533-966f-b6fcdab608c8','2026-01-20 13:50:18','2026-01-20 13:50:22',NULL,'api-1445742041-stack',29,NULL,15,'demo_tempestconf',NULL,'UPDATE','COMPLETE','Stack UPDATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'bf406c8f22644163a8cd9805146b391d',0,0,1,'e4f39b6d-767f-4f56-a362-7911ede107c6','{\"edges\": [[[11, false], [11, true]]]}',NULL),('a02006a6-cff0-49dc-be8f-81748ec3e4e0','2026-01-20 13:50:08',NULL,NULL,'api-442217991-rsrcstack',6,NULL,6,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'e85c9e8b484144e4a4f4652e881bba05',0,0,1,'924c1308-f7ff-48c1-944a-58e9fb2ee70f','{\"edges\": [[[6, true], null]]}',NULL),('a5db7eca-245b-42fd-85e6-a681b854992b','2026-01-20 13:55:54','2026-01-20 13:56:32','2026-01-20 13:56:33','ParallelDeploymentsTest-1375998189-dep_0-3u3htxsw5qni',191,NULL,NULL,'demo_tempestconf','fab57e2a-6be8-4888-9705-5ff23fd7e69a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'95f93cc50035402f9167bb764e0d2ed1',0,1,1,'b35f99b0-f20f-4651-a1a3-ef356ccecfec','{\"edges\": [[[194, false], null]]}','dep_0'),('a8db32b2-8ccc-4d2b-b7f1-e5a6d5493996','2026-01-20 13:51:34','2026-01-20 13:51:58','2026-01-20 13:52:02','UpdateTrunkTest-1380021495',71,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'3bc75a322dc24718880585d9f1413291',0,0,1,'cb045577-35f0-4591-ad50-0498f0ef0503','{\"edges\": [[[61, false], [59, false]], [[61, false], [60, false]], [[60, false], [59, false]], [[63, false], [62, false]], [[65, false], [63, false]], [[65, false], [64, false]], [[64, false], [63, false]], [[68, false], [66, false]], [[68, false], [67, false]], [[67, false], [66, false]]]}',NULL),('a9331ed6-4247-4121-ab61-082bb2f6211e','2026-01-20 13:55:52','2026-01-20 13:56:43','2026-01-20 13:56:44','ParallelDeploymentsTest-269394896-dep_1-pouqh4fl2cqo',198,NULL,NULL,'demo_tempestconf','47e18409-bbb5-4e58-ad6b-5cc29ec2913a','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'c35dbdd1e5cb4748b4e7a2cc82c158ab',0,1,1,'1aeb5b4b-3eb2-48f3-ab7a-e8bfb6b300d0','{\"edges\": [[[186, false], null]]}','dep_1'),('aad78fbb-3d45-4ae1-b0fc-4a0ec15793c5','2026-01-20 13:55:42','2026-01-20 13:57:02','2026-01-20 13:57:03','ParallelDeploymentsTest-13617404-dep_2-et23e4357tjd',213,NULL,NULL,'demo_tempestconf','bf3b6dfb-6ce1-4008-a718-2570a6107907','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,1,1,'cbfaa886-26d6-4a3d-b672-7140bc4c3f86','{\"edges\": [[[164, false], null]]}','dep_2'),('ad4a2432-dc7d-4f3c-8d61-1a39f0ad0191','2026-01-20 13:50:05',NULL,NULL,'api-1214827273-rsrcstack',4,NULL,4,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'ee9e437c09b14cf7b586be84a53cf480',0,0,1,'c5c42cea-fe1c-4a34-a593-b072f7f89d68','{\"edges\": [[[4, true], null]]}',NULL),('b140e17f-aa70-41c5-a917-02c242d68958','2026-01-20 13:50:07',NULL,NULL,'api-108285926-rsrcstack',5,NULL,5,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'d9b1acaba39647bcbd43feb841f8c833',0,0,1,'b6eca7b3-ec4b-441d-9f4f-e58ae5908160','{\"edges\": [[[5, true], null]]}',NULL),('b8818c4f-9aae-4a8e-955b-c6e5733c5fd3','2026-01-20 13:55:44','2026-01-20 13:56:52','2026-01-20 13:56:54','ParallelDeploymentsTest-218845895-dep_3-z5f2rx6paggb',205,NULL,NULL,'demo_tempestconf','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,1,1,'0ed589ed-f2cf-4672-8773-47a67fb63689','{\"edges\": [[[173, false], null]]}','dep_3'),('bb6e480a-bfd4-4d75-953c-7faa946564f9','2026-01-20 13:55:55','2026-01-20 13:56:22','2026-01-20 13:56:23','ParallelDeploymentsTest-1006090207-dep_2-67obevb2f257',183,NULL,NULL,'demo_tempestconf','03b07b2a-f62f-43d4-a292-4939980296c0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'183896f7a46647b6aa926f08ed8475df',0,1,1,'328de922-4948-463d-a4cc-c3f227c5ac54','{\"edges\": [[[202, false], null]]}','dep_2'),('bb9e894c-a1b7-49ce-82a9-0a593c58c737','2026-01-20 13:50:05',NULL,NULL,'api-108285926-envstack',3,NULL,3,'demo_tempestconf',NULL,'CREATE','COMPLETE','Stack CREATE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'30f57af6d3f949c68407ec5324b3461e',0,0,1,'5f09fb96-d145-4d78-9025-94f4647cf8d4','{\"edges\": [[[3, true], null]]}',NULL),('bf3b6dfb-6ce1-4008-a718-2570a6107907','2026-01-20 13:55:41','2026-01-20 13:57:01','2026-01-20 13:57:08','ParallelDeploymentsTest-13617404',211,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,0,1,'83f18a80-2719-43cc-842e-9bda323a9e58','{\"edges\": [[[160, false], [156, false]], [[160, false], [158, false]], [[160, false], [159, false]], [[160, false], [157, false]], [[160, false], [155, false]]]}',NULL),('c2d21718-3d44-486d-98f7-f40f013a8e24','2026-01-20 13:54:45','2026-01-20 13:55:01','2026-01-20 13:55:03','RemoteStackTest-374237530',128,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'3b1244f712434aedaab0f68622c9bf41',0,0,1,'b310d5fa-010d-4e9b-91f2-0f9ae8c0cde6','{\"edges\": [[[134, false], null]]}',NULL),('c379503b-9eb6-45f7-8b54-75624f9b2300','2026-01-20 13:57:29','2026-01-20 13:57:31','2026-01-20 13:57:32','TemplateAPITest-315994526',231,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'bce06bfb4cd4492785122b1f9a5389e4',0,0,1,'29885ff5-a98d-400c-9945-f6425c481fad','{\"edges\": [[[222, false], null]]}',NULL),('c94b83d2-5c79-451b-8ca3-b564e01091bc','2026-01-20 13:55:44','2026-01-20 13:56:54','2026-01-20 13:56:55','ParallelDeploymentsTest-218845895-dep_0-am37liej4ces',206,NULL,NULL,'demo_tempestconf','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,1,1,'f1c0e18d-12ca-4d0a-ae1b-3b89d58cfb9a','{\"edges\": [[[175, false], null]]}','dep_0'),('ca79085e-1ca6-4079-b3b5-820adecfa6d5','2026-01-20 13:55:44','2026-01-20 13:56:54','2026-01-20 13:56:55','ParallelDeploymentsTest-218845895-dep_4-az52zvsrziaf',207,NULL,NULL,'demo_tempestconf','10eb6231-59ee-4d3a-b82a-b6f6d27f1471','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'5640bb625493459684062ad85e17bd93',0,1,1,'549275c1-35e4-43c3-9716-130651e524c1','{\"edges\": [[[172, false], null]]}','dep_4'),('ce5d58fe-5f90-4769-a448-345dac77cb1c','2026-01-20 13:51:02','2026-01-20 13:51:20','2026-01-20 13:51:23','EncryptedParametersTest-1283256311',58,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'d69a28b09fa64a15bb6ec7af059e88d3',0,0,1,'e4af2ea8-801f-4baf-b72a-e2ef3bcdc95d','{\"edges\": [[[52, false], null]]}',NULL),('d57c7c5c-e766-4ed6-abbc-e1c2c95e2a0c','2026-01-20 13:57:34','2026-01-20 13:58:42','2026-01-20 13:58:44','ParallelDeploymentsTest-862999738-dep_1-fz2tuvosbgw5',238,NULL,NULL,'demo_tempestconf','86823e94-9b05-48f8-bf47-db859524cc29','DELETE','COMPLETE','Stack DELETE completed successfully',1,'9fefc90697004684a6a41a2739520551',1,'22cadf4b63384f2eb09799c7c3aa31dc',0,1,1,'df4d9453-9eba-43f3-bdfe-c3c8988cbc2a','{\"edges\": [[[229, false], null]]}','dep_1'),('d61a6a19-0fa0-4e17-98a7-442b5ad0ccc6','2026-01-20 13:55:28','2026-01-20 13:55:42','2026-01-20 13:55:43','HooksTest-996220411-rg-b74unp2mrokw',148,NULL,NULL,'demo_tempestconf','ebef2b47-842a-4891-83fc-6993230f3000','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'017db7c85d8241d59a1e3dfc7b38da61',0,1,1,'5c44c792-5888-48bd-a037-6b8338fac887','{\"edges\": [[[153, false], null], [[154, false], null]]}','rg'),('d65e0219-2aeb-4432-8186-72c5a4420429','2026-01-20 13:50:12','2026-01-20 13:50:13','2026-01-20 13:50:14','api-108285926-empty',12,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'d7af983d254e4307b915130bcd3bfe07',0,0,1,'c11ffddd-0e76-46db-b1f2-f0824b2858ec','{\"edges\": []}',NULL),('da164336-cc20-4b39-9725-79f404891d39','2026-01-20 13:50:44','2026-01-20 13:51:23','2026-01-20 13:51:28','add_network',60,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'396421c9d59d490885a8d5bbc0dba946',0,0,1,'d6b9a991-4b33-4407-8a41-a29f1973b2ec','{\"edges\": [[[38, false], [36, false]], [[38, false], [37, false]], [[37, false], [36, false]]]}',NULL),('dcf2c6e8-e722-4a9a-a816-3d5742207356','2026-01-20 13:56:20','2026-01-20 13:56:31','2026-01-20 13:56:32','StackOutputsTest-1518396458-parent-74m4rcnd7gxu',189,NULL,NULL,'demo_tempestconf','e1852d79-9927-4210-bc89-af7c675cbd75','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'a00ef6339a244cae95463800fe3096b2',0,1,1,'dc8331c4-d049-4d6a-89f5-a20e4b692b27','{\"edges\": [[[209, false], null], [[210, false], null]]}','parent'),('dd746e70-9c55-42ac-ba85-b733929725a2','2026-01-20 13:51:34','2026-01-20 13:52:10','2026-01-20 13:52:16','same_fixed_ip',77,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'f670d78cd8534a9cba35ab15efe37534',0,0,1,'b8f81b69-9e1f-4709-9c87-0754597e0dd8','{\"edges\": [[[71, false], [69, false]], [[71, false], [70, false]], [[70, false], [69, false]]]}',NULL),('e1852d79-9927-4210-bc89-af7c675cbd75','2026-01-20 13:56:19','2026-01-20 13:56:30','2026-01-20 13:56:34','StackOutputsTest-1518396458',188,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'a00ef6339a244cae95463800fe3096b2',0,0,1,'67c80f71-0ba7-4cec-8d10-dd5e61fd46d9','{\"edges\": [[[208, false], null]]}',NULL),('e6575805-bf41-4704-9151-e79aa66c4a03','2026-01-20 13:50:40','2026-01-20 13:50:52','2026-01-20 13:50:54','UpdateSubnetTest-990839975',47,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'d8818871e5384454bacc5f6096e5909c',0,0,1,'60a3256f-53f3-4afc-89fb-efceb5a328c1','{\"edges\": [[[31, false], [30, false]]]}',NULL),('e7a7db52-859b-4eb5-aa7b-67f2047e31bf','2026-01-20 13:57:34','2026-01-20 13:58:44','2026-01-20 13:58:45','ParallelDeploymentsTest-862999738-dep_0-m3adzhfczrlp',239,NULL,NULL,'demo_tempestconf','86823e94-9b05-48f8-bf47-db859524cc29','DELETE','COMPLETE','Stack DELETE completed successfully',1,'9fefc90697004684a6a41a2739520551',1,'22cadf4b63384f2eb09799c7c3aa31dc',0,1,1,'117b587a-2a16-437e-b122-7f147fc88c31','{\"edges\": [[[227, false], null]]}','dep_0'),('e8a3fc67-21be-48e1-8bd0-0c143bcd1f16','2026-01-20 13:55:55','2026-01-20 13:56:20','2026-01-20 13:56:22','ParallelDeploymentsTest-1006090207-dep_1-7cw4fohquw5u',179,NULL,NULL,'demo_tempestconf','03b07b2a-f62f-43d4-a292-4939980296c0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'183896f7a46647b6aa926f08ed8475df',0,1,1,'90644b02-0fb2-4a37-9c01-0d9378a0dd8b','{\"edges\": [[[201, false], null]]}','dep_1'),('e98326e4-2bc3-43d6-a36c-c0b3d7f87490','2026-01-20 13:57:05','2026-01-20 13:57:15','2026-01-20 13:57:16','RemoteDeeplyNestedStackTest-1050101322-network_stack-zaj7sbjqk7m5-network_stack_as_custom_type-lpfmcphszoam',226,NULL,NULL,'demo_tempestconf','1f8fe575-2886-4923-bb89-d7214b8c829b','DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'51b9523186f14b51bdc9f105e59b8748',0,1,1,'751472a8-0a82-4338-98a8-dc8d52ae3113','{\"edges\": [[[219, false], null]]}','network_stack_as_custom_type'),('eba7d579-7f3a-49f9-a764-e7bf3a46ac38','2026-01-20 13:55:42','2026-01-20 13:57:03','2026-01-20 13:57:04','ParallelDeploymentsTest-13617404-dep_1-vi42pompa3ws',214,NULL,NULL,'demo_tempestconf','bf3b6dfb-6ce1-4008-a718-2570a6107907','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,1,1,'732e7cdd-dce5-4fc8-bbe8-fb6e0b6c1b51','{\"edges\": [[[165, false], null]]}','dep_1'),('ebef2b47-842a-4891-83fc-6993230f3000','2026-01-20 13:55:28','2026-01-20 13:55:42','2026-01-20 13:55:45','HooksTest-996220411',145,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'017db7c85d8241d59a1e3dfc7b38da61',0,0,1,'ff156bcc-73be-4cd9-a785-9233c035a5ed','{\"edges\": [[[152, false], null]]}',NULL),('ef62c216-05d1-4b4b-be2f-a8500ee480b4','2026-01-20 13:55:22','2026-01-20 13:57:11','2026-01-20 13:57:16','ParallelDeploymentsTest-611247670',222,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'8acd8a35b85945138d7b80b201553ee0',0,0,1,'5e324ec7-3100-4eaf-ab61-b2f100ad1895','{\"edges\": [[[151, false], null]]}',NULL),('f0d274a8-82a4-42b6-9f57-390d1f313689','2026-01-20 13:52:46','2026-01-20 13:53:15','2026-01-20 13:53:22','UpdateTrunkTest-770074732',89,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'b22b1c53ce3a4db1b13dbaab75787a9c',0,0,1,'f355bda1-85b4-4b5d-989e-4c8c8fc81e4a','{\"edges\": [[[95, false], [94, false]], [[95, false], [93, false]], [[94, false], [93, false]], [[100, false], [96, false]], [[97, false], [96, false]], [[99, false], [97, false]], [[99, false], [98, false]], [[98, false], [97, false]], [[102, false], [100, false]], [[102, false], [101, false]], [[101, false], [100, false]]]}',NULL),('f1fe6a09-5314-4193-bfa5-d443356dc3d3','2026-01-20 13:50:04','2026-01-20 13:50:07','2026-01-20 13:50:08','api-1445742041-envstack',7,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'32c32573321c402fb0df11362e20ffc6',0,0,1,'0c9369c8-c07c-4b8f-a8d7-3984283c2947','{\"edges\": [[[1, false], null]]}',NULL),('f4295e51-2751-4bf3-91ee-d69a80500e3b','2026-01-20 13:54:03','2026-01-20 13:54:10','2026-01-20 13:54:11','RemoteStackTest-108274908-my_stack-gwqtrumfjwoh',107,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'74c717f658534fffa84069277824a8b4',0,0,1,'a916470c-96da-494d-a2df-45321f5eb5d0','{\"edges\": [[[124, false], null]]}',NULL),('f8cfeee7-b166-4963-90c6-4ede882de6be','2026-01-20 13:54:17','2026-01-20 13:54:39','2026-01-20 13:54:40','RemoteStackTest-1369055629-my_stack-a6ahn7gw7am5',116,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',NULL,'9fefc90697004684a6a41a2739520551',1,'68cb73c8e8764e43be53a2e082442204',0,0,1,'7dd27af6-5b6f-472a-8004-fd1ea82b00c5','{\"edges\": [[[130, false], null]]}',NULL),('fab57e2a-6be8-4888-9705-5ff23fd7e69a','2026-01-20 13:55:53','2026-01-20 13:56:29','2026-01-20 13:56:35','ParallelDeploymentsTest-1375998189',186,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'95f93cc50035402f9167bb764e0d2ed1',0,0,1,'591b2725-b213-4150-aed5-c4d4470ba1b0','{\"edges\": [[[193, false], [191, false]], [[193, false], [192, false]], [[193, false], [190, false]]]}',NULL),('fc057844-c4c8-4d18-b6d4-5503f16c7c55','2026-01-20 13:53:54','2026-01-20 13:53:55','2026-01-20 13:53:57','ExternalReferencesTest-245063210',98,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'2446e13f423a426f90944963a1b31629',0,0,1,'4f8fafdb-da0c-4f5f-8199-dca1a4b08a72','{\"edges\": [[[120, false], null]]}',NULL),('fc547785-0f54-4ea0-a8a1-6de34ceca347','2026-01-20 13:55:42','2026-01-20 13:57:06','2026-01-20 13:57:07','ParallelDeploymentsTest-13617404-dep_3-sz2jrkjl2tdh',220,NULL,NULL,'demo_tempestconf','bf3b6dfb-6ce1-4008-a718-2570a6107907','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'db5afb233d9f409abf7a40b460bf74e4',0,1,1,'b48733e8-cb6f-4bb8-8016-75ac6b276ce7','{\"edges\": [[[163, false], null]]}','dep_3'),('fce72fa2-5a0b-4527-8a2d-50360121335c','2026-01-20 13:55:55','2026-01-20 13:56:21','2026-01-20 13:56:22','ParallelDeploymentsTest-1006090207-dep_0-zz3zuc6nroff',181,NULL,NULL,'demo_tempestconf','03b07b2a-f62f-43d4-a292-4939980296c0','DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'183896f7a46647b6aa926f08ed8475df',0,1,1,'1b746a29-228b-4a55-b5f0-1aab06a9fb81','{\"edges\": [[[203, false], null]]}','dep_0'),('ff278435-332f-47a4-93ae-9c9fc8f54517','2026-01-20 13:54:02','2026-01-20 13:54:09','2026-01-20 13:54:11','RemoteStackTest-108274908',106,NULL,NULL,'demo_tempestconf',NULL,'DELETE','COMPLETE','Stack DELETE completed successfully',1200,'9fefc90697004684a6a41a2739520551',1,'e4aab235f5864b9fbe91b9609dd1630c',0,0,1,'4e213df8-adf3-49f0-b024-db7ca44a0555','{\"edges\": [[[123, false], null]]}',NULL);
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
INSERT INTO `stack_tag` (`id`, `created_at`, `updated_at`, `tag`, `stack_id`) VALUES (1,'2026-01-20 13:56:55',NULL,'foo','603a193f-38e1-4ba4-adff-2608856255f3'),(2,'2026-01-20 13:56:55',NULL,'data-processing-cluster','603a193f-38e1-4ba4-adff-2608856255f3');
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
INSERT INTO `user_creds` (`id`, `created_at`, `updated_at`, `username`, `password`, `region_name`, `decrypt_method`, `tenant`, `auth_url`, `tenant_id`, `trust_id`, `trustor_user_id`) VALUES (1,'2026-01-20 13:50:04',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gMOGZqBqfKfJvvSiCcxOmOoU1UBDQg27h4qSgXlD-iJ1syS94gLjPC_F-IcNOf43g5LOEjtBRSNLbzzS9-2dWdXvdvfdseq8XI9UavHlIzO5mwmmKooYxBZROmebf7HK45','dfb88765d65243b59fe5c30b77db78cc'),(3,'2026-01-20 13:50:04',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gM4UDmCJrbsAKTwMPMPwLzCqG2CG9mRoXbcXzj89s7NbC_23XskWmWrUYn2dP1CX1m8Ivc2XKnQTEuNimomyaoc73jBJ_iFGefkrqxl6-CFieLhvlSbBsPkWk3uwYS8lzR','dfb88765d65243b59fe5c30b77db78cc'),(4,'2026-01-20 13:50:05',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gNcTBHYn2FQx-MVUC9AlZ7b0f1IH3IgTD7WPaLu97aCfKCDtA8viMRbOiOSXMMqB1mqoJiEoEOqiLfj1uOvhbcuS3gj9bPjqPaxMg5WhMFBjFIIgYVETyI5Q4jNXMoH854','dfb88765d65243b59fe5c30b77db78cc'),(5,'2026-01-20 13:50:07',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gOWsBggD4CKuhAsaixH4up0Di13VeBnEUpQcRd_JVU0ncBeVOeGpS4KhodjTRsTKaNwPhEKCUbQxwrXkuQ8Sx55wWOStVpm-wh2P8Ke-nrrBjlAt8gqs9hD0PcVjbMT4-l','dfb88765d65243b59fe5c30b77db78cc'),(6,'2026-01-20 13:50:08',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gQ56YtFtaVimynoVF4dBm7Knj1MD93AlMhvTHhvOWnbmYvt7Q1fWanyA_awAv4-mlN2qB6RPHMOJ_QmEqWzyuBUds067dl0lZUt6huKp6XNJ8jyBA_yTxKUqxDQpxd4Yw6','dfb88765d65243b59fe5c30b77db78cc'),(11,'2026-01-20 13:50:14',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gWfPiqXlFMKH9z7n2TlyvAkGc7oEIK98QWh6nOl-ONqnJkXPTjELNVMdDAfPKH7Pk6txeiw74PZ8tmo9RqRh2DRQpRqcZJJLZboCe4HtXgyKb9RzxoZQ_ePImtqIa-a2-v','dfb88765d65243b59fe5c30b77db78cc'),(12,'2026-01-20 13:50:15',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4gX2YLsLtw7bMJtwKYqYg9cHq1NIIe1dWmbb0xP37Mw-nQwv2eiWVWsI-uSE_KEaCDTIee9mdUSqrexDMv-kKghAe81DAZlMeCzRUNPFC_iDSbRAVZnoIPk5LW-wI0YULbd','dfb88765d65243b59fe5c30b77db78cc'),(15,'2026-01-20 13:50:18',NULL,NULL,NULL,NULL,'cryptography_decrypt_v1','demo','https://keystone-internal.openstack.svc:5000','9fefc90697004684a6a41a2739520551','gAAAAABpb4ga7eZ2Vu8I5VjtlkMlNgDqkQho5v6CDFIhzhdC9q0WFtr5bt6rTnU5naUOyEFYDYTX2NFdoebN3EDdrq5AOpQanxHk-GFkSSHOiTv8A6BVWKXvhpMXoDacedR9qWxLCFRB','dfb88765d65243b59fe5c30b77db78cc');
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','1aef1dae401645159257de28a8e93432','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','1aef1dae401645159257de28a8e93432','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','2cc7cc45ba634f7a91cd3bcade2d70b0','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','2cc7cc45ba634f7a91cd3bcade2d70b0','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','2ee3482325254872a2fcde1baa41837f','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','2ee3482325254872a2fcde1baa41837f','88c93604a4ea416ab4c4a1e962c3a525','7b2e2a17db50409584c33b4d05abf509',0),('UserProject','2ee3482325254872a2fcde1baa41837f','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','3859580ee17f4f0797dca674aa723353','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','3859580ee17f4f0797dca674aa723353','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','39ad29784c094363a0d2b4d812d396a2','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','39ad29784c094363a0d2b4d812d396a2','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','4d96c55d0649499c9af03a5756738c30','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','4d96c55d0649499c9af03a5756738c30','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','5f95888288f3436a9b4af2889e5f3927','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','5f95888288f3436a9b4af2889e5f3927','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','aa37593a8c3e4cd3a8e16becd7c1adc6','2ad51e96726a496fbbce4a0ed4cf0061','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','aa37593a8c3e4cd3a8e16becd7c1adc6','9fefc90697004684a6a41a2739520551','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','af0fc46fc1914701aae9d6ec04d35623','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','af0fc46fc1914701aae9d6ec04d35623','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserProject','dfb88765d65243b59fe5c30b77db78cc','9fefc90697004684a6a41a2739520551','2bb72a62ff69468aad218b63b939aa90',0),('UserProject','f447ad7de72c4dfab6bd2c36dad26816','88c93604a4ea416ab4c4a1e962c3a525','0b09b7be70374c9b8bf97c336d6ff058',0),('UserProject','f447ad7de72c4dfab6bd2c36dad26816','88c93604a4ea416ab4c4a1e962c3a525','8011ad49f2914db7a09ec75adce4d271',0),('UserDomain','1bc4d57465be47deb9af0f8f6d4aea49','35e70bfa06174539be01dc2b24dd5b9f','0b09b7be70374c9b8bf97c336d6ff058',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('09db8f56fbc743fe9218f78c03d0a97a',NULL,'internal','b11bb3ba974e45619e18ec0967bde7f5','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('10046b66d4cb4bbdbe0c8db46aa81910',NULL,'public','10db826283db4891b43b8995432cbd48','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('10bf463ef36b46eba68228cd08e8e48a',NULL,'internal','47320a6326cc492ea167e675395d8d0d','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('25322e3d58764b1e99b1e942049679c8',NULL,'internal','d05f97f0e224497c8451a4fb8af561d4','https://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('3ba62b699ffe43e189b4178a2c1d99fc',NULL,'internal','c8341ae673ac48d3bc733f7b158fca8f','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('418817c0a51241138c1094aafde0867e',NULL,'public','9405fc400df844df83409b7e1ba7f2d4','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('4197cb077f594b848900067dae2c0d9b',NULL,'public','d05f97f0e224497c8451a4fb8af561d4','https://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('46736b18febd4cd6a04ba23331103caf',NULL,'public','2e0f345bb2d14c9391f8afc8b536f255','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('5641dbc3a2a547149f814754f20b9451',NULL,'internal','53dcb29e751943bf8f309a7d656ee45a','https://swift-internal.openstack.svc:8080/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('6491c64044a24dfe81c694ef42973601',NULL,'internal','9405fc400df844df83409b7e1ba7f2d4','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('78430203e8954fdebd555a9a2e255315',NULL,'internal','a4992343e9224160b7a35c7e3d58acac','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('9602df2ea02740f0b9c5c495196deb3c',NULL,'public','cfb6c58282a9458d8181746e152640da','https://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('9e3361fd0a92475e89bcb2bfe17b2248',NULL,'public','b11bb3ba974e45619e18ec0967bde7f5','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('9e805b01808f4ad3b2a07b6853bc1c39',NULL,'public','a4992343e9224160b7a35c7e3d58acac','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('b5c8d81aeaea435abbf1201d46295986',NULL,'internal','10db826283db4891b43b8995432cbd48','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('c24790342a324145b6d1b4e75c546d83',NULL,'internal','cfb6c58282a9458d8181746e152640da','https://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('cd9a343a5d4c4df886b68b2706753f68',NULL,'public','c8341ae673ac48d3bc733f7b158fca8f','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('d073554c490d412abdf8dc76df0e05d7',NULL,'public','53dcb29e751943bf8f309a7d656ee45a','https://swift-public-openstack.apps-crc.testing/v1/AUTH_%(tenant_id)s','{\"name\": \"swift\"}',1,'regionOne'),('f3728ff8310c452a95f5a588116cb0ff',NULL,'internal','2e0f345bb2d14c9391f8afc8b536f255','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('f970dfd31d6a459eb59242ff87991535',NULL,'public','47320a6326cc492ea167e675395d8d0d','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('0b09b7be70374c9b8bf97c336d6ff058','2bb72a62ff69468aad218b63b939aa90'),('2bb72a62ff69468aad218b63b939aa90','5dffc31fb5414c4ba66014546473f3dd');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'aa37593a8c3e4cd3a8e16becd7c1adc6','default','admin',0,NULL),(2,'3859580ee17f4f0797dca674aa723353','default','nova',0,NULL),(3,'1bc4d57465be47deb9af0f8f6d4aea49','35e70bfa06174539be01dc2b24dd5b9f','heat_stack_domain_admin',0,NULL),(4,'f447ad7de72c4dfab6bd2c36dad26816','default','cinder',0,NULL),(5,'5f95888288f3436a9b4af2889e5f3927','default','swift',0,NULL),(6,'2ee3482325254872a2fcde1baa41837f','default','ceilometer',0,NULL),(7,'2cc7cc45ba634f7a91cd3bcade2d70b0','default','neutron',0,NULL),(8,'af0fc46fc1914701aae9d6ec04d35623','default','barbican',0,NULL),(9,'1aef1dae401645159257de28a8e93432','default','glance',0,NULL),(10,'39ad29784c094363a0d2b4d812d396a2','default','placement',0,NULL),(11,'4d96c55d0649499c9af03a5756738c30','default','heat',0,NULL),(12,'dfb88765d65243b59fe5c30b77db78cc','default','demo_tempestconf',0,NULL),(13,'7753d6d5c13d4e0a97b1df3b4994cdd4','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$BsZyt7GW6csqGmoYhcIJoeya/8i4swIlmt1ICVqKQtb9ag3VP9.Mm',1768915278622126,NULL,'2026-01-20 13:21:18'),(2,2,NULL,0,'$2b$12$nOczX7yP58q2PrZKnj.CXOwxT/fvGWNtaRJbqAEfpCW4PG3Rfy4fi',1768915350118861,NULL,'2026-01-20 13:22:30'),(3,3,NULL,0,'$2b$12$1WR9xpHvWyxvp7u8L7ibcOjXOWUCP4sp4UdAOwIP6/e.UYxP6sVi.',1768915351546358,NULL,'2026-01-20 13:22:31'),(4,4,NULL,0,'$2b$12$ikS7WUDE2VVPi3vuLr/p3.PdzZKA68Wzpoj.9w3CPi0uOVzZff9lS',1768915357840238,NULL,'2026-01-20 13:22:37'),(5,5,NULL,0,'$2b$12$aIeN2NZeJ174yIyYiP3..u64kgFUDus3OIkBtwi5bCDEjitwjCbvS',1768915362591348,NULL,'2026-01-20 13:22:42'),(6,6,NULL,0,'$2b$12$tggdOHMMbgCB/hq/iCrNGOkeQrQYP7tLgR1MabxboB5uWsk2iWU/O',1768915366017109,NULL,'2026-01-20 13:22:46'),(7,7,NULL,0,'$2b$12$Q9SHFDv2UVAQlSwYzu0whe0nehJT3o0sIcW4R5ZRsmxjniGn6Yb3C',1768915370136533,NULL,'2026-01-20 13:22:50'),(8,8,NULL,0,'$2b$12$9iBzkXx4R7uwW35I6qDlsecTbnUWE9cec9N.CKFHEOHBB10R1Dw5e',1768915375422888,NULL,'2026-01-20 13:22:55'),(9,9,NULL,0,'$2b$12$EqtJHZCt3KYTL2VW2B3hue9x2DDVQ1D4kfU8hpCc0jOxDkr9ycpYS',1768915398107901,NULL,'2026-01-20 13:23:18'),(10,10,NULL,0,'$2b$12$mXygBYlBhQoVXzUnOYa1D.SiMnmDC2dPWKitTIMtub5N6f7oKBBoC',1768915401153355,NULL,'2026-01-20 13:23:21'),(11,11,NULL,0,'$2b$12$nIjnTHOZAr2c5.LrvkqjXuw6jyq9TGThdoV.RKAI0KeXu4aIF4w8q',1768915405688014,NULL,'2026-01-20 13:23:25'),(12,12,NULL,0,'$2b$12$pDN5cumpWDOa4bpi/SKsLepkum1KRk/PFpuz7l8JedhafUyFTqTUq',1768916972370394,NULL,'2026-01-20 13:49:32'),(13,13,NULL,0,'$2b$12$MAwpMQhFfP0DxTxnx83iOersCZykxxMEetH78UwskUUgJAY2yleIa',1768916972840385,NULL,'2026-01-20 13:49:32');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('2ad51e96726a496fbbce4a0ed4cf0061','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('30f57af6d3f949c68407ec5324b3461e','9fefc90697004684a6a41a2739520551-bb9e894c-a1b7-49ce-82a9-0a593c5','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('35e70bfa06174539be01dc2b24dd5b9f','heat_stack','{}','Domain for Heat stacks',1,'<<keystone.domain.root>>',NULL,1),('3f47f669049b4176b89d85274c738ef9','9fefc90697004684a6a41a2739520551-75b9e2b0-e2e8-4e18-a401-2d211d0','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('70be33cc11294fc8a13a54683de41d98','9fefc90697004684a6a41a2739520551-62188458-aab9-4802-8579-c47bb0c','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('88c93604a4ea416ab4c4a1e962c3a525','service','{}','service',1,'default','default',0),('9fefc90697004684a6a41a2739520551','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('bf406c8f22644163a8cd9805146b391d','9fefc90697004684a6a41a2739520551-9fb2ea8b-a649-4533-966f-b6fcdab','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('d530fc7710314e769f96929eccbcf850','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('d9b1acaba39647bcbd43feb841f8c833','9fefc90697004684a6a41a2739520551-b140e17f-aa70-41c5-a917-02c242d','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1),('e85c9e8b484144e4a4f4652e881bba05','9fefc90697004684a6a41a2739520551-a02006a6-cff0-49dc-be8f-81748ec','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('ee9e437c09b14cf7b586be84a53cf480','9fefc90697004684a6a41a2739520551-ad4a2432-dc7d-4f3c-8d61-1a39f0a','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0),('f1d4c30cd66d487ab81410a68d2fd2b3','9fefc90697004684a6a41a2739520551-87a46c98-cc95-42ca-9a1e-9a12087','{}','Heat stack user project',1,'35e70bfa06174539be01dc2b24dd5b9f','35e70bfa06174539be01dc2b24dd5b9f',0);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,NULL,NULL,'a52ddc77d8974f67b3b5adb2ba391212',NULL,NULL,'2026-01-20 13:50:08',NULL,'2026-01-20 13:50:08',NULL,NULL),(2,NULL,'32c32573321c402fb0df11362e20ffc6',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:08',NULL,'2026-01-20 13:50:08',NULL,NULL),(3,NULL,NULL,NULL,NULL,'31d762aa51f443cf8fa2b1bfcc2feefc',NULL,NULL,'2026-01-20 13:50:13',NULL,'2026-01-20 13:50:13',NULL,NULL),(4,NULL,NULL,NULL,NULL,'330ec960a8d6460ab868b12588ef6fe2',NULL,NULL,'2026-01-20 13:50:13',NULL,'2026-01-20 13:50:13',NULL,NULL),(5,NULL,'d7af983d254e4307b915130bcd3bfe07',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:14',NULL,'2026-01-20 13:50:14',NULL,NULL),(6,NULL,'f6acd1b862ed48a0adbb0286216ee993',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:14',NULL,'2026-01-20 13:50:14',NULL,NULL),(7,NULL,NULL,NULL,NULL,'faad449f326348d1a55da8d5de2efb60',NULL,NULL,'2026-01-20 13:50:14',NULL,'2026-01-20 13:50:14',NULL,NULL),(8,NULL,'f21691ebc3bb49a3a2759be83b8bacc9',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:15',NULL,'2026-01-20 13:50:15',NULL,NULL),(9,NULL,NULL,NULL,NULL,'e5610c58cf644ea5a2a4f2aed364dec3',NULL,NULL,'2026-01-20 13:50:15',NULL,'2026-01-20 13:50:15',NULL,NULL),(10,NULL,'57fb1d72d7984a29a53e0285b8f6bff0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:16',NULL,'2026-01-20 13:50:16',NULL,NULL),(11,NULL,NULL,NULL,NULL,'3253eb6cfa9c451eb4f9e89015e0326b',NULL,NULL,'2026-01-20 13:50:17',NULL,'2026-01-20 13:50:17',NULL,NULL),(12,NULL,'4e6ffe4e294d45a7aff14437839098e6',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:18',NULL,'2026-01-20 13:50:18',NULL,NULL),(13,NULL,NULL,NULL,NULL,'cad12d80f3ce4e7989ed0e3b5973afa0',NULL,NULL,'2026-01-20 13:50:28',NULL,'2026-01-20 13:50:28',NULL,NULL),(14,NULL,'f7be6651d8b54000bec8aa9a964052c1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:29',NULL,'2026-01-20 13:50:29',NULL,NULL),(15,NULL,NULL,NULL,NULL,'86bb8ecdef9a40caa144ae19496e72fe',NULL,NULL,'2026-01-20 13:50:37',NULL,'2026-01-20 13:50:37',NULL,NULL),(16,NULL,'1d7ff4b422df4d428580a0232d0bef02',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:37',NULL,'2026-01-20 13:50:37',NULL,NULL),(17,NULL,NULL,NULL,NULL,'910cde95cf2640918376212dd806f531',NULL,NULL,'2026-01-20 13:50:38',NULL,'2026-01-20 13:50:38',NULL,NULL),(18,NULL,'68c46bafe0b44e86828c2ed7d7c8968e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:39',NULL,'2026-01-20 13:50:39',NULL,NULL),(19,NULL,NULL,NULL,NULL,'36b7b76949634759affb61ec695f24c7',NULL,NULL,'2026-01-20 13:50:39',NULL,'2026-01-20 13:50:39',NULL,NULL),(20,NULL,'ecd4d39d374c46cbb196d1902eee5e09',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:39',NULL,'2026-01-20 13:50:39',NULL,NULL),(21,NULL,NULL,NULL,NULL,'14ba874006184da18f07e956c0d2f8ea',NULL,NULL,'2026-01-20 13:50:54',NULL,'2026-01-20 13:50:54',NULL,NULL),(22,NULL,'d8818871e5384454bacc5f6096e5909c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:54',NULL,'2026-01-20 13:50:54',NULL,NULL),(23,NULL,NULL,NULL,NULL,'e4ff77e3fc474ea28fe2dbb23d381ee5',NULL,NULL,'2026-01-20 13:50:56',NULL,'2026-01-20 13:50:56',NULL,NULL),(24,NULL,'5aeb6e1e31be40dc84e998572215c61d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:57',NULL,'2026-01-20 13:50:57',NULL,NULL),(25,NULL,NULL,NULL,NULL,'5ec3271511e145418fc4e623c3eafec4',NULL,NULL,'2026-01-20 13:50:58',NULL,'2026-01-20 13:50:58',NULL,NULL),(26,NULL,'3bee9f9f311248698122e33961977af1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:50:59',NULL,'2026-01-20 13:50:59',NULL,NULL),(27,NULL,NULL,NULL,NULL,'ca6b59a6f2aa4d82ab1ea1b4f6642516',NULL,NULL,'2026-01-20 13:51:15',NULL,'2026-01-20 13:51:15',NULL,NULL),(28,NULL,'9a1f202caedf4e31a217597bb7ece15d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:16',NULL,'2026-01-20 13:51:16',NULL,NULL),(29,NULL,NULL,NULL,NULL,'4879dd78c0374ee4850fd1076753badf',NULL,NULL,'2026-01-20 13:51:22',NULL,'2026-01-20 13:51:22',NULL,NULL),(30,NULL,'d69a28b09fa64a15bb6ec7af059e88d3',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:23',NULL,'2026-01-20 13:51:23',NULL,NULL),(31,NULL,NULL,NULL,NULL,'923ae8d173784af2935727b3524cd287',NULL,NULL,'2026-01-20 13:51:26',NULL,'2026-01-20 13:51:26',NULL,NULL),(32,NULL,'cf40831e74cb485d83e9ae71483d4600',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:27',NULL,'2026-01-20 13:51:27',NULL,NULL),(33,NULL,NULL,NULL,NULL,'13441499353749609e8a26ec93e4c9e4',NULL,NULL,'2026-01-20 13:51:27',NULL,'2026-01-20 13:51:27',NULL,NULL),(34,NULL,'396421c9d59d490885a8d5bbc0dba946',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:28',NULL,'2026-01-20 13:51:28',NULL,NULL),(35,NULL,NULL,NULL,NULL,'a75c2684dfe94593ba286957754a09cd',NULL,NULL,'2026-01-20 13:51:35',NULL,'2026-01-20 13:51:35',NULL,NULL),(36,NULL,'a917bdbb0ae645338ff9ab9fcf180ee1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:36',NULL,'2026-01-20 13:51:36',NULL,NULL),(37,NULL,NULL,NULL,NULL,'695310287f2a4f1d9486c5ded76e2151',NULL,NULL,'2026-01-20 13:51:58',NULL,'2026-01-20 13:51:58',NULL,NULL),(38,NULL,'a27b7eaa906a4db69b76306e145ffc9d',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:51:59',NULL,'2026-01-20 13:51:59',NULL,NULL),(39,NULL,NULL,NULL,NULL,'c2bc1dd49c314ecd8c8b0b0e70c03bb4',NULL,NULL,'2026-01-20 13:52:02',NULL,'2026-01-20 13:52:02',NULL,NULL),(40,NULL,'3bc75a322dc24718880585d9f1413291',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:02',NULL,'2026-01-20 13:52:02',NULL,NULL),(41,NULL,NULL,NULL,NULL,'a1587f48b072413e9bd8d74f8022acfb',NULL,NULL,'2026-01-20 13:52:03',NULL,'2026-01-20 13:52:03',NULL,NULL),(42,NULL,'c77f48a01c804a7290d3d86a44e34260',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:04',NULL,'2026-01-20 13:52:04',NULL,NULL),(43,NULL,NULL,NULL,NULL,'21aac4a5cc984ced9a60601007b05121',NULL,NULL,'2026-01-20 13:52:15',NULL,'2026-01-20 13:52:15',NULL,NULL),(44,NULL,NULL,NULL,NULL,'ffca3ccfdc9b4b9387767d00bd738a37',NULL,NULL,'2026-01-20 13:52:16',NULL,'2026-01-20 13:52:16',NULL,NULL),(45,NULL,'f670d78cd8534a9cba35ab15efe37534',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:16',NULL,'2026-01-20 13:52:16',NULL,NULL),(46,NULL,'f72b2ce4367e41c78e4015b8fa4e14ab',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:16',NULL,'2026-01-20 13:52:16',NULL,NULL),(47,NULL,NULL,NULL,NULL,'8052471a7156444aa02412379b57cd39',NULL,NULL,'2026-01-20 13:52:40',NULL,'2026-01-20 13:52:40',NULL,NULL),(48,NULL,'958d78849ea349a186b695c01ead0874',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:40',NULL,'2026-01-20 13:52:40',NULL,NULL),(49,NULL,NULL,NULL,NULL,'cfba24d5b272406293c70d5554c77269',NULL,NULL,'2026-01-20 13:52:46',NULL,'2026-01-20 13:52:46',NULL,NULL),(50,NULL,'c109b7472f3b4c43932bdc4c94fddaf5',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:52:46',NULL,'2026-01-20 13:52:46',NULL,NULL),(51,NULL,NULL,NULL,NULL,'d62d9841f8f54325bc7f443c36537725',NULL,NULL,'2026-01-20 13:53:00',NULL,'2026-01-20 13:53:00',NULL,NULL),(52,NULL,'6061eced2bcc4b63b8772e3360182a14',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:02',NULL,'2026-01-20 13:53:02',NULL,NULL),(53,NULL,NULL,NULL,NULL,'417f4d21e8d24824853632a33b9dc5cd',NULL,NULL,'2026-01-20 13:53:21',NULL,'2026-01-20 13:53:21',NULL,NULL),(54,NULL,'b22b1c53ce3a4db1b13dbaab75787a9c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:22',NULL,'2026-01-20 13:53:22',NULL,NULL),(55,NULL,NULL,NULL,NULL,'36cf95b745ea4569953e4bd773e58815',NULL,NULL,'2026-01-20 13:53:48',NULL,'2026-01-20 13:53:48',NULL,NULL),(56,NULL,'7fcaabb46e624201a8d55fbc914e3002',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:49',NULL,'2026-01-20 13:53:49',NULL,NULL),(57,NULL,NULL,NULL,NULL,'8ef01670e4ca47329734399cb4e170c1',NULL,NULL,'2026-01-20 13:53:50',NULL,'2026-01-20 13:53:50',NULL,NULL),(58,NULL,'828a0a6d7b194b91af5cadb218381391',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:51',NULL,'2026-01-20 13:53:51',NULL,NULL),(59,NULL,NULL,NULL,NULL,'28d13148f30244d48b60cbd2e5af04d1',NULL,NULL,'2026-01-20 13:53:56',NULL,'2026-01-20 13:53:56',NULL,NULL),(60,NULL,NULL,NULL,NULL,'144a5f74653a4848880c8f6209981b7a',NULL,NULL,'2026-01-20 13:53:57',NULL,'2026-01-20 13:53:57',NULL,NULL),(61,NULL,'2446e13f423a426f90944963a1b31629',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:57',NULL,'2026-01-20 13:53:57',NULL,NULL),(62,NULL,'9970c55d4c77486b83d2a1cd3929b795',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:53:57',NULL,'2026-01-20 13:53:57',NULL,NULL),(63,NULL,NULL,NULL,NULL,'e86c31a9a34549639db558304caf3719',NULL,NULL,'2026-01-20 13:54:08',NULL,'2026-01-20 13:54:08',NULL,NULL),(64,NULL,'506fbd8420404e109aa975c5c40b2599',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:09',NULL,'2026-01-20 13:54:09',NULL,NULL),(65,NULL,NULL,NULL,NULL,'89c3f25b792044e29c24e6a764041d58',NULL,NULL,'2026-01-20 13:54:10',NULL,'2026-01-20 13:54:10',NULL,NULL),(66,NULL,NULL,NULL,NULL,'df885b63168e4ad5a67886caa3c27cb0',NULL,NULL,'2026-01-20 13:54:11',NULL,'2026-01-20 13:54:11',NULL,NULL),(67,NULL,'74c717f658534fffa84069277824a8b4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:11',NULL,'2026-01-20 13:54:11',NULL,NULL),(68,NULL,'e4aab235f5864b9fbe91b9609dd1630c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:11',NULL,'2026-01-20 13:54:11',NULL,NULL),(69,NULL,NULL,NULL,NULL,'513b6b241aef4580a1fa38a10883d4bc',NULL,NULL,'2026-01-20 13:54:12',NULL,'2026-01-20 13:54:12',NULL,NULL),(70,NULL,'d49ca89f5f324ae8aaa41c27a5ffd209',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:13',NULL,'2026-01-20 13:54:13',NULL,NULL),(71,NULL,NULL,NULL,NULL,'29897190fbd14d6292b1e2a8a958aad2',NULL,NULL,'2026-01-20 13:54:23',NULL,'2026-01-20 13:54:23',NULL,NULL),(72,NULL,'fd49dbf332a5460ea7d0b218bacff8fe',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:24',NULL,'2026-01-20 13:54:24',NULL,NULL),(73,NULL,NULL,NULL,NULL,'dda0a4f7445949edae9cd09e948fe4d2',NULL,NULL,'2026-01-20 13:54:40',NULL,'2026-01-20 13:54:40',NULL,NULL),(74,NULL,NULL,NULL,NULL,'0c82f90788b044bd9cdea00279153f12',NULL,NULL,'2026-01-20 13:54:40',NULL,'2026-01-20 13:54:40',NULL,NULL),(75,NULL,NULL,NULL,NULL,'fa2c7f6941f246ae85243002c4adf9a7',NULL,NULL,'2026-01-20 13:54:40',NULL,'2026-01-20 13:54:40',NULL,NULL),(76,NULL,'68cb73c8e8764e43be53a2e082442204',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:40',NULL,'2026-01-20 13:54:40',NULL,NULL),(77,NULL,'21071fb676f6415eb018bdae903b83ad',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:40',NULL,'2026-01-20 13:54:40',NULL,NULL),(78,NULL,'72e5e907712741489aa504c8a831b918',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:54:41',NULL,'2026-01-20 13:54:41',NULL,NULL),(79,NULL,NULL,NULL,NULL,'c910c552c5bf4e53990bcd37c46d7c8c',NULL,NULL,'2026-01-20 13:55:00',NULL,'2026-01-20 13:55:00',NULL,NULL),(80,NULL,'279e49d0931a49d1a159866fd0a6fae7',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:01',NULL,'2026-01-20 13:55:01',NULL,NULL),(81,NULL,NULL,NULL,NULL,'e63efe2e6b4d41e985367c51d57ae531',NULL,NULL,'2026-01-20 13:55:01',NULL,'2026-01-20 13:55:01',NULL,NULL),(82,NULL,'b40a0da75e0c4bcc9479e82061f02030',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:01',NULL,'2026-01-20 13:55:01',NULL,NULL),(83,NULL,NULL,NULL,NULL,'b77ed2627ff540088220f3b8b1647ec9',NULL,NULL,'2026-01-20 13:55:02',NULL,'2026-01-20 13:55:02',NULL,NULL),(84,NULL,NULL,NULL,NULL,'1debc06ad9244fac82b5a2aef2e4eca0',NULL,NULL,'2026-01-20 13:55:03',NULL,'2026-01-20 13:55:03',NULL,NULL),(85,NULL,'49dae34eba8b4b68adfd7166e1efad59',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:03',NULL,'2026-01-20 13:55:03',NULL,NULL),(86,NULL,'3b1244f712434aedaab0f68622c9bf41',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:03',NULL,'2026-01-20 13:55:03',NULL,NULL),(87,NULL,NULL,NULL,NULL,'36b105ffd48345368824c9f20bac8f33',NULL,NULL,'2026-01-20 13:55:11',NULL,'2026-01-20 13:55:11',NULL,NULL),(88,NULL,'2a1338cfdea24e66a603e803873cef1a',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:11',NULL,'2026-01-20 13:55:11',NULL,NULL),(89,NULL,NULL,NULL,NULL,'98989fbb02ed4ce3ac22865d52f6a5a6',NULL,NULL,'2026-01-20 13:55:16',NULL,'2026-01-20 13:55:16',NULL,NULL),(90,NULL,'38aa282f355b4e0ebcf00ea961594d45',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:17',NULL,'2026-01-20 13:55:17',NULL,NULL),(91,NULL,NULL,NULL,NULL,'5a9c8701f64d4199ba498a0c16a0bdd0',NULL,NULL,'2026-01-20 13:55:22',NULL,'2026-01-20 13:55:22',NULL,NULL),(92,NULL,'6ea5efe736f2407eb44bf54ee24e6f5c',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:23',NULL,'2026-01-20 13:55:23',NULL,NULL),(93,NULL,NULL,NULL,NULL,'25d897a9341d4e809934fc6e3477c15a',NULL,NULL,'2026-01-20 13:55:44',NULL,'2026-01-20 13:55:44',NULL,NULL),(94,NULL,NULL,NULL,NULL,'951d988b3c9a45f1a2ee68b832a4b6bd',NULL,NULL,'2026-01-20 13:55:45',NULL,'2026-01-20 13:55:45',NULL,NULL),(95,NULL,'017db7c85d8241d59a1e3dfc7b38da61',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:45',NULL,'2026-01-20 13:55:45',NULL,NULL),(96,NULL,'e6b5da275df24e8eb808b391a4e5c5f0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:46',NULL,'2026-01-20 13:55:46',NULL,NULL),(97,NULL,NULL,NULL,NULL,'8a3c3375f1ac4a229f36a06f1eaef9e4',NULL,NULL,'2026-01-20 13:55:54',NULL,'2026-01-20 13:55:54',NULL,NULL),(98,NULL,'ca14576370fd4dc3ba3c5467ec19c03b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:55:55',NULL,'2026-01-20 13:55:55',NULL,NULL),(99,NULL,NULL,NULL,NULL,'e99b8ceff6ab43e6b8edb8eba1645b0e',NULL,NULL,'2026-01-20 13:56:16',NULL,'2026-01-20 13:56:16',NULL,NULL),(100,NULL,'c618a0929ab94e89af02963ba756231e',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:17',NULL,'2026-01-20 13:56:17',NULL,NULL),(101,NULL,NULL,'82770fd307c245ceb83cbbc7104e3294',NULL,NULL,NULL,NULL,'2026-01-20 13:56:22',NULL,'2026-01-20 13:56:22',NULL,NULL),(102,NULL,NULL,'71a2f0d39e4144279d552c18046d4111',NULL,NULL,NULL,NULL,'2026-01-20 13:56:22',NULL,'2026-01-20 13:56:22',NULL,NULL),(103,NULL,NULL,'2cf4a15640484041a6e5936231bcec19',NULL,NULL,NULL,NULL,'2026-01-20 13:56:23',NULL,'2026-01-20 13:56:23',NULL,NULL),(104,NULL,NULL,NULL,NULL,'90095e0409b3449e822be5dc8e3afb81',NULL,NULL,'2026-01-20 13:56:25',NULL,'2026-01-20 13:56:25',NULL,NULL),(105,NULL,'183896f7a46647b6aa926f08ed8475df',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:25',NULL,'2026-01-20 13:56:25',NULL,NULL),(106,NULL,NULL,'e4ca916c88ea4b76b70f8deeecd2c293',NULL,NULL,NULL,NULL,'2026-01-20 13:56:31',NULL,'2026-01-20 13:56:31',NULL,NULL),(107,NULL,NULL,'a55befa2b4c943e3a992950d842e06c1',NULL,NULL,NULL,NULL,'2026-01-20 13:56:32',NULL,'2026-01-20 13:56:32',NULL,NULL),(108,NULL,NULL,NULL,NULL,'693f718c4a884feab611ed6e51d4ad30',NULL,NULL,'2026-01-20 13:56:33',NULL,'2026-01-20 13:56:33',NULL,NULL),(109,NULL,NULL,'045fd627a3a74d57abf90fbf3eb4e73a',NULL,NULL,NULL,NULL,'2026-01-20 13:56:33',NULL,'2026-01-20 13:56:33',NULL,NULL),(110,NULL,'a00ef6339a244cae95463800fe3096b2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:34',NULL,'2026-01-20 13:56:34',NULL,NULL),(111,NULL,NULL,NULL,NULL,'69952963affd496291e66fcf4e78788e',NULL,NULL,'2026-01-20 13:56:34',NULL,'2026-01-20 13:56:34',NULL,NULL),(112,NULL,'95f93cc50035402f9167bb764e0d2ed1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:35',NULL,'2026-01-20 13:56:35',NULL,NULL),(113,NULL,NULL,NULL,NULL,'c1ce9dda29ed4e3b8ba346f54391e6e0',NULL,NULL,'2026-01-20 13:56:37',NULL,'2026-01-20 13:56:37',NULL,NULL),(114,NULL,'2fb817c7143f49d0ac624e0fce79adf1',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:37',NULL,'2026-01-20 13:56:37',NULL,NULL),(115,NULL,NULL,'b06f92fd9d944b949a738be0bbbe9a66',NULL,NULL,NULL,NULL,'2026-01-20 13:56:44',NULL,'2026-01-20 13:56:44',NULL,NULL),(116,NULL,NULL,'135c451010d3451db62a85354c4ffa4f',NULL,NULL,NULL,NULL,'2026-01-20 13:56:44',NULL,'2026-01-20 13:56:44',NULL,NULL),(117,NULL,NULL,'01c4a64abe4b470895c2ef175aeb8c94',NULL,NULL,NULL,NULL,'2026-01-20 13:56:44',NULL,'2026-01-20 13:56:44',NULL,NULL),(118,NULL,NULL,NULL,NULL,'b93b442f4f19403f977b01195e7cc5b9',NULL,NULL,'2026-01-20 13:56:45',NULL,'2026-01-20 13:56:45',NULL,NULL),(119,NULL,NULL,NULL,NULL,'65e8d4a8ec0e4ef9a3cd5710f33075f3',NULL,NULL,'2026-01-20 13:56:45',NULL,'2026-01-20 13:56:45',NULL,NULL),(120,NULL,'40c08407a5fd48279928e7a8c282fdf2',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:46',NULL,'2026-01-20 13:56:46',NULL,NULL),(121,NULL,'c35dbdd1e5cb4748b4e7a2cc82c158ab',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:46',NULL,'2026-01-20 13:56:46',NULL,NULL),(122,NULL,NULL,NULL,NULL,'dd43e271955a41c6ae6ac233c5d0e874',NULL,NULL,'2026-01-20 13:56:49',NULL,'2026-01-20 13:56:49',NULL,NULL),(123,NULL,'5f987fd16e4f4fe893e5ed782d18f8e8',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:49',NULL,'2026-01-20 13:56:49',NULL,NULL),(124,NULL,NULL,'6822751077664033899bcc516b244aa3',NULL,NULL,NULL,NULL,'2026-01-20 13:56:52',NULL,'2026-01-20 13:56:52',NULL,NULL),(125,NULL,NULL,'e8ac53b988b74ed499610c4022ec0a96',NULL,NULL,NULL,NULL,'2026-01-20 13:56:54',NULL,'2026-01-20 13:56:54',NULL,NULL),(126,NULL,NULL,'2d1ac44bd8674c52ab2ea78f431bbb80',NULL,NULL,NULL,NULL,'2026-01-20 13:56:55',NULL,'2026-01-20 13:56:55',NULL,NULL),(127,NULL,NULL,'5f39574a8bf24acfb0cd152bebe18416',NULL,NULL,NULL,NULL,'2026-01-20 13:56:55',NULL,'2026-01-20 13:56:55',NULL,NULL),(128,NULL,NULL,'1eff83f97fb94950a29689b9d65a4dd4',NULL,NULL,NULL,NULL,'2026-01-20 13:56:56',NULL,'2026-01-20 13:56:56',NULL,NULL),(129,NULL,NULL,NULL,NULL,'cd22c5a32ee047688480548e55c92d83',NULL,NULL,'2026-01-20 13:56:56',NULL,'2026-01-20 13:56:56',NULL,NULL),(130,NULL,'5640bb625493459684062ad85e17bd93',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:57',NULL,'2026-01-20 13:56:57',NULL,NULL),(131,NULL,NULL,NULL,NULL,'3d30d96f43924b25b7e7be5c2b822e47',NULL,NULL,'2026-01-20 13:56:57',NULL,'2026-01-20 13:56:57',NULL,NULL),(132,NULL,'ec00e7a3a0014a91a9a829fd0384a56b',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:56:58',NULL,'2026-01-20 13:56:58',NULL,NULL),(133,NULL,NULL,'8a415d01fd564ba6b56f2a34795830f9',NULL,NULL,NULL,NULL,'2026-01-20 13:57:03',NULL,'2026-01-20 13:57:03',NULL,NULL),(134,NULL,NULL,'f39eae23d59b4565ac1a886eaca6e6ee',NULL,NULL,NULL,NULL,'2026-01-20 13:57:04',NULL,'2026-01-20 13:57:04',NULL,NULL),(135,NULL,NULL,NULL,NULL,'70eeb7df10c84182a572df0515cdeb17',NULL,NULL,'2026-01-20 13:57:04',NULL,'2026-01-20 13:57:04',NULL,NULL),(136,NULL,NULL,'8ad6cdb7ff4f4b4f98a06c306e56529f',NULL,NULL,NULL,NULL,'2026-01-20 13:57:04',NULL,'2026-01-20 13:57:04',NULL,NULL),(137,NULL,'ac1e142a46fb45edbb04b7e894368f72',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:05',NULL,'2026-01-20 13:57:05',NULL,NULL),(138,NULL,NULL,'8480e31db0a640d6830eeb78d0c29bb3',NULL,NULL,NULL,NULL,'2026-01-20 13:57:06',NULL,'2026-01-20 13:57:06',NULL,NULL),(139,NULL,NULL,'30ec3d5822124d6aa47d8661043e296f',NULL,NULL,NULL,NULL,'2026-01-20 13:57:07',NULL,'2026-01-20 13:57:07',NULL,NULL),(140,NULL,NULL,NULL,NULL,'6bf334b2114b4fc39627bd4d10a910e6',NULL,NULL,'2026-01-20 13:57:08',NULL,'2026-01-20 13:57:08',NULL,NULL),(141,NULL,'db5afb233d9f409abf7a40b460bf74e4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:08',NULL,'2026-01-20 13:57:08',NULL,NULL),(142,NULL,NULL,'571386f14c8c4435b4ba0461f8a2a4e5',NULL,NULL,NULL,NULL,'2026-01-20 13:57:12',NULL,'2026-01-20 13:57:12',NULL,NULL),(143,NULL,NULL,NULL,NULL,'c32dd1b333ff476bbb18f2496562eace',NULL,NULL,'2026-01-20 13:57:16',NULL,'2026-01-20 13:57:16',NULL,NULL),(144,NULL,'8acd8a35b85945138d7b80b201553ee0',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:16',NULL,'2026-01-20 13:57:16',NULL,NULL),(145,NULL,NULL,NULL,NULL,'ee4f2ee4df504f1b9842e440b6b8f1ef',NULL,NULL,'2026-01-20 13:57:17',NULL,'2026-01-20 13:57:17',NULL,NULL),(146,NULL,'51b9523186f14b51bdc9f105e59b8748',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:17',NULL,'2026-01-20 13:57:17',NULL,NULL),(147,NULL,NULL,NULL,NULL,'af953e5c555b4a8ebfb1e7c71e7aca44',NULL,NULL,'2026-01-20 13:57:18',NULL,'2026-01-20 13:57:18',NULL,NULL),(148,NULL,'d9f7b358af814a1a8c53bbb5348dccbd',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:18',NULL,'2026-01-20 13:57:18',NULL,NULL),(149,NULL,NULL,NULL,NULL,'2995855f86a24cbf9cd015f051873e36',NULL,NULL,'2026-01-20 13:57:27',NULL,'2026-01-20 13:57:27',NULL,NULL),(150,NULL,'07da5df89fb841e8828a83e4f0c67768',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:27',NULL,'2026-01-20 13:57:27',NULL,NULL),(151,NULL,NULL,NULL,NULL,'6faaf91fb0524ab0a6e8fa227615be51',NULL,NULL,'2026-01-20 13:57:32',NULL,'2026-01-20 13:57:32',NULL,NULL),(152,NULL,'bce06bfb4cd4492785122b1f9a5389e4',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:57:32',NULL,'2026-01-20 13:57:32',NULL,NULL),(153,NULL,NULL,'1cefa828cefe4a5280974f4f2138f32a',NULL,NULL,NULL,NULL,'2026-01-20 13:58:42',NULL,'2026-01-20 13:58:42',NULL,NULL),(154,NULL,NULL,'ae29a0d057274c4faacba9d1245d92b4',NULL,NULL,NULL,NULL,'2026-01-20 13:58:44',NULL,'2026-01-20 13:58:44',NULL,NULL),(155,NULL,NULL,'0791414ae15246e791d099c846554b19',NULL,NULL,NULL,NULL,'2026-01-20 13:58:45',NULL,'2026-01-20 13:58:45',NULL,NULL),(156,NULL,NULL,NULL,NULL,'6372b95361174197bdf4ac71a83c2223',NULL,NULL,'2026-01-20 13:58:47',NULL,'2026-01-20 13:58:47',NULL,NULL),(157,NULL,'22cadf4b63384f2eb09799c7c3aa31dc',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:58:47',NULL,'2026-01-20 13:58:47',NULL,NULL),(158,NULL,NULL,'3a9d3cb0f9dd460182bbcc3bdd80af1c',NULL,NULL,NULL,NULL,'2026-01-20 13:58:50',NULL,'2026-01-20 13:58:50',NULL,NULL),(159,NULL,NULL,NULL,NULL,'47bb582da55846e4a220a47ca58c93bb',NULL,NULL,'2026-01-20 13:58:54',NULL,'2026-01-20 13:58:54',NULL,NULL),(160,NULL,'a6609e04340e496abb42e276520a05ab',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:58:54',NULL,'2026-01-20 13:58:54',NULL,NULL),(161,NULL,NULL,NULL,NULL,'f25af07d09454df69ce89168f0fcb5de',NULL,NULL,'2026-01-20 13:58:57',NULL,'2026-01-20 13:58:57',NULL,NULL),(162,NULL,'4f1c12d5a7c54c70b23ad1d935d457ae',NULL,NULL,NULL,NULL,NULL,'2026-01-20 13:58:57',NULL,'2026-01-20 13:58:57',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('022ef2e4005c4c538da78c90936aa704','SwiftProjectReader','{}','<<null>>',NULL),('0b09b7be70374c9b8bf97c336d6ff058','admin','{}','<<null>>',NULL),('219da98177f54891a0520a60e248380c','swiftoperator','{}','<<null>>',NULL),('2bb72a62ff69468aad218b63b939aa90','member','{}','<<null>>',NULL),('44d319e0aa4944d787c71fec6a860745','heat_stack_user','{}','<<null>>',NULL),('5dffc31fb5414c4ba66014546473f3dd','reader','{}','<<null>>',NULL),('7b2e2a17db50409584c33b4d05abf509','SwiftSystemReader','{}','<<null>>',NULL),('8011ad49f2914db7a09ec75adce4d271','service','{}','<<null>>',NULL),('aca716a2422c4b1b94b15ac7534d4f9f','ResellerAdmin','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('0b09b7be70374c9b8bf97c336d6ff058','IMMU','true'),('2bb72a62ff69468aad218b63b939aa90','IMMU','true'),('5dffc31fb5414c4ba66014546473f3dd','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('10db826283db4891b43b8995432cbd48','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('2e0f345bb2d14c9391f8afc8b536f255','identity',1,'{\"name\": \"keystone\"}'),('33865a3d7fe546f8a91cca67fae52629','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('47320a6326cc492ea167e675395d8d0d','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('53dcb29e751943bf8f309a7d656ee45a','object-store',1,'{\"description\": \"Swift Object Storage\", \"name\": \"swift\"}'),('9405fc400df844df83409b7e1ba7f2d4','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('a4992343e9224160b7a35c7e3d58acac','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('b11bb3ba974e45619e18ec0967bde7f5','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('c8341ae673ac48d3bc733f7b158fca8f','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('cfb6c58282a9458d8181746e152640da','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('d05f97f0e224497c8451a4fb8af561d4','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','aa37593a8c3e4cd3a8e16becd7c1adc6','system','0b09b7be70374c9b8bf97c336d6ff058',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_trust_id` (`trust_id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('005a094282b346e79ad4e4e8749999f9','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('1a91b13f668041ae879d97b1de136948','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('243cf1562fb241e5b80c0d3c11ceeab6','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('431de033fc5744dcbd6fd63684e52b2d','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('4386550c883246b386579d6932ec883b','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('a66e72fe479b466983b90264800a472f','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('b61a2bb698144cfd89143c2ff7088921','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0),('c0097c12448046d996d0230dff13e341','dfb88765d65243b59fe5c30b77db78cc','4d96c55d0649499c9af03a5756738c30','9fefc90697004684a6a41a2739520551',1,NULL,NULL,NULL,'{\"roles\": [{\"id\": \"5dffc31fb5414c4ba66014546473f3dd\"}, {\"id\": \"2bb72a62ff69468aad218b63b939aa90\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('005a094282b346e79ad4e4e8749999f9','2bb72a62ff69468aad218b63b939aa90'),('005a094282b346e79ad4e4e8749999f9','5dffc31fb5414c4ba66014546473f3dd'),('0c82f90788b044bd9cdea00279153f12','2bb72a62ff69468aad218b63b939aa90'),('0c82f90788b044bd9cdea00279153f12','5dffc31fb5414c4ba66014546473f3dd'),('13441499353749609e8a26ec93e4c9e4','2bb72a62ff69468aad218b63b939aa90'),('13441499353749609e8a26ec93e4c9e4','5dffc31fb5414c4ba66014546473f3dd'),('144a5f74653a4848880c8f6209981b7a','2bb72a62ff69468aad218b63b939aa90'),('144a5f74653a4848880c8f6209981b7a','5dffc31fb5414c4ba66014546473f3dd'),('14ba874006184da18f07e956c0d2f8ea','2bb72a62ff69468aad218b63b939aa90'),('14ba874006184da18f07e956c0d2f8ea','5dffc31fb5414c4ba66014546473f3dd'),('1a91b13f668041ae879d97b1de136948','2bb72a62ff69468aad218b63b939aa90'),('1a91b13f668041ae879d97b1de136948','5dffc31fb5414c4ba66014546473f3dd'),('1debc06ad9244fac82b5a2aef2e4eca0','2bb72a62ff69468aad218b63b939aa90'),('1debc06ad9244fac82b5a2aef2e4eca0','5dffc31fb5414c4ba66014546473f3dd'),('21aac4a5cc984ced9a60601007b05121','2bb72a62ff69468aad218b63b939aa90'),('21aac4a5cc984ced9a60601007b05121','5dffc31fb5414c4ba66014546473f3dd'),('243cf1562fb241e5b80c0d3c11ceeab6','2bb72a62ff69468aad218b63b939aa90'),('243cf1562fb241e5b80c0d3c11ceeab6','5dffc31fb5414c4ba66014546473f3dd'),('25d897a9341d4e809934fc6e3477c15a','2bb72a62ff69468aad218b63b939aa90'),('25d897a9341d4e809934fc6e3477c15a','5dffc31fb5414c4ba66014546473f3dd'),('28d13148f30244d48b60cbd2e5af04d1','2bb72a62ff69468aad218b63b939aa90'),('28d13148f30244d48b60cbd2e5af04d1','5dffc31fb5414c4ba66014546473f3dd'),('29897190fbd14d6292b1e2a8a958aad2','2bb72a62ff69468aad218b63b939aa90'),('29897190fbd14d6292b1e2a8a958aad2','5dffc31fb5414c4ba66014546473f3dd'),('2995855f86a24cbf9cd015f051873e36','2bb72a62ff69468aad218b63b939aa90'),('2995855f86a24cbf9cd015f051873e36','5dffc31fb5414c4ba66014546473f3dd'),('31d762aa51f443cf8fa2b1bfcc2feefc','2bb72a62ff69468aad218b63b939aa90'),('31d762aa51f443cf8fa2b1bfcc2feefc','5dffc31fb5414c4ba66014546473f3dd'),('3253eb6cfa9c451eb4f9e89015e0326b','2bb72a62ff69468aad218b63b939aa90'),('3253eb6cfa9c451eb4f9e89015e0326b','5dffc31fb5414c4ba66014546473f3dd'),('330ec960a8d6460ab868b12588ef6fe2','2bb72a62ff69468aad218b63b939aa90'),('330ec960a8d6460ab868b12588ef6fe2','5dffc31fb5414c4ba66014546473f3dd'),('36b105ffd48345368824c9f20bac8f33','2bb72a62ff69468aad218b63b939aa90'),('36b105ffd48345368824c9f20bac8f33','5dffc31fb5414c4ba66014546473f3dd'),('36b7b76949634759affb61ec695f24c7','0b09b7be70374c9b8bf97c336d6ff058'),('36b7b76949634759affb61ec695f24c7','2bb72a62ff69468aad218b63b939aa90'),('36b7b76949634759affb61ec695f24c7','5dffc31fb5414c4ba66014546473f3dd'),('36cf95b745ea4569953e4bd773e58815','2bb72a62ff69468aad218b63b939aa90'),('36cf95b745ea4569953e4bd773e58815','5dffc31fb5414c4ba66014546473f3dd'),('3d30d96f43924b25b7e7be5c2b822e47','2bb72a62ff69468aad218b63b939aa90'),('3d30d96f43924b25b7e7be5c2b822e47','5dffc31fb5414c4ba66014546473f3dd'),('417f4d21e8d24824853632a33b9dc5cd','2bb72a62ff69468aad218b63b939aa90'),('417f4d21e8d24824853632a33b9dc5cd','5dffc31fb5414c4ba66014546473f3dd'),('431de033fc5744dcbd6fd63684e52b2d','2bb72a62ff69468aad218b63b939aa90'),('431de033fc5744dcbd6fd63684e52b2d','5dffc31fb5414c4ba66014546473f3dd'),('4386550c883246b386579d6932ec883b','2bb72a62ff69468aad218b63b939aa90'),('4386550c883246b386579d6932ec883b','5dffc31fb5414c4ba66014546473f3dd'),('47bb582da55846e4a220a47ca58c93bb','2bb72a62ff69468aad218b63b939aa90'),('47bb582da55846e4a220a47ca58c93bb','5dffc31fb5414c4ba66014546473f3dd'),('4879dd78c0374ee4850fd1076753badf','2bb72a62ff69468aad218b63b939aa90'),('4879dd78c0374ee4850fd1076753badf','5dffc31fb5414c4ba66014546473f3dd'),('513b6b241aef4580a1fa38a10883d4bc','2bb72a62ff69468aad218b63b939aa90'),('513b6b241aef4580a1fa38a10883d4bc','5dffc31fb5414c4ba66014546473f3dd'),('5a9c8701f64d4199ba498a0c16a0bdd0','2bb72a62ff69468aad218b63b939aa90'),('5a9c8701f64d4199ba498a0c16a0bdd0','5dffc31fb5414c4ba66014546473f3dd'),('5ec3271511e145418fc4e623c3eafec4','0b09b7be70374c9b8bf97c336d6ff058'),('5ec3271511e145418fc4e623c3eafec4','2bb72a62ff69468aad218b63b939aa90'),('5ec3271511e145418fc4e623c3eafec4','5dffc31fb5414c4ba66014546473f3dd'),('6372b95361174197bdf4ac71a83c2223','2bb72a62ff69468aad218b63b939aa90'),('6372b95361174197bdf4ac71a83c2223','5dffc31fb5414c4ba66014546473f3dd'),('65e8d4a8ec0e4ef9a3cd5710f33075f3','2bb72a62ff69468aad218b63b939aa90'),('65e8d4a8ec0e4ef9a3cd5710f33075f3','5dffc31fb5414c4ba66014546473f3dd'),('693f718c4a884feab611ed6e51d4ad30','2bb72a62ff69468aad218b63b939aa90'),('693f718c4a884feab611ed6e51d4ad30','5dffc31fb5414c4ba66014546473f3dd'),('695310287f2a4f1d9486c5ded76e2151','2bb72a62ff69468aad218b63b939aa90'),('695310287f2a4f1d9486c5ded76e2151','5dffc31fb5414c4ba66014546473f3dd'),('69952963affd496291e66fcf4e78788e','2bb72a62ff69468aad218b63b939aa90'),('69952963affd496291e66fcf4e78788e','5dffc31fb5414c4ba66014546473f3dd'),('6bf334b2114b4fc39627bd4d10a910e6','2bb72a62ff69468aad218b63b939aa90'),('6bf334b2114b4fc39627bd4d10a910e6','5dffc31fb5414c4ba66014546473f3dd'),('6faaf91fb0524ab0a6e8fa227615be51','2bb72a62ff69468aad218b63b939aa90'),('6faaf91fb0524ab0a6e8fa227615be51','5dffc31fb5414c4ba66014546473f3dd'),('70eeb7df10c84182a572df0515cdeb17','2bb72a62ff69468aad218b63b939aa90'),('70eeb7df10c84182a572df0515cdeb17','5dffc31fb5414c4ba66014546473f3dd'),('8052471a7156444aa02412379b57cd39','2bb72a62ff69468aad218b63b939aa90'),('8052471a7156444aa02412379b57cd39','5dffc31fb5414c4ba66014546473f3dd'),('86bb8ecdef9a40caa144ae19496e72fe','2bb72a62ff69468aad218b63b939aa90'),('86bb8ecdef9a40caa144ae19496e72fe','5dffc31fb5414c4ba66014546473f3dd'),('89c3f25b792044e29c24e6a764041d58','2bb72a62ff69468aad218b63b939aa90'),('89c3f25b792044e29c24e6a764041d58','5dffc31fb5414c4ba66014546473f3dd'),('8a3c3375f1ac4a229f36a06f1eaef9e4','2bb72a62ff69468aad218b63b939aa90'),('8a3c3375f1ac4a229f36a06f1eaef9e4','5dffc31fb5414c4ba66014546473f3dd'),('8ef01670e4ca47329734399cb4e170c1','2bb72a62ff69468aad218b63b939aa90'),('8ef01670e4ca47329734399cb4e170c1','5dffc31fb5414c4ba66014546473f3dd'),('90095e0409b3449e822be5dc8e3afb81','2bb72a62ff69468aad218b63b939aa90'),('90095e0409b3449e822be5dc8e3afb81','5dffc31fb5414c4ba66014546473f3dd'),('910cde95cf2640918376212dd806f531','2bb72a62ff69468aad218b63b939aa90'),('910cde95cf2640918376212dd806f531','5dffc31fb5414c4ba66014546473f3dd'),('923ae8d173784af2935727b3524cd287','2bb72a62ff69468aad218b63b939aa90'),('923ae8d173784af2935727b3524cd287','5dffc31fb5414c4ba66014546473f3dd'),('951d988b3c9a45f1a2ee68b832a4b6bd','2bb72a62ff69468aad218b63b939aa90'),('951d988b3c9a45f1a2ee68b832a4b6bd','5dffc31fb5414c4ba66014546473f3dd'),('98989fbb02ed4ce3ac22865d52f6a5a6','2bb72a62ff69468aad218b63b939aa90'),('98989fbb02ed4ce3ac22865d52f6a5a6','5dffc31fb5414c4ba66014546473f3dd'),('a1587f48b072413e9bd8d74f8022acfb','2bb72a62ff69468aad218b63b939aa90'),('a1587f48b072413e9bd8d74f8022acfb','5dffc31fb5414c4ba66014546473f3dd'),('a52ddc77d8974f67b3b5adb2ba391212','2bb72a62ff69468aad218b63b939aa90'),('a52ddc77d8974f67b3b5adb2ba391212','5dffc31fb5414c4ba66014546473f3dd'),('a66e72fe479b466983b90264800a472f','2bb72a62ff69468aad218b63b939aa90'),('a66e72fe479b466983b90264800a472f','5dffc31fb5414c4ba66014546473f3dd'),('a75c2684dfe94593ba286957754a09cd','2bb72a62ff69468aad218b63b939aa90'),('a75c2684dfe94593ba286957754a09cd','5dffc31fb5414c4ba66014546473f3dd'),('af953e5c555b4a8ebfb1e7c71e7aca44','2bb72a62ff69468aad218b63b939aa90'),('af953e5c555b4a8ebfb1e7c71e7aca44','5dffc31fb5414c4ba66014546473f3dd'),('b61a2bb698144cfd89143c2ff7088921','2bb72a62ff69468aad218b63b939aa90'),('b61a2bb698144cfd89143c2ff7088921','5dffc31fb5414c4ba66014546473f3dd'),('b77ed2627ff540088220f3b8b1647ec9','2bb72a62ff69468aad218b63b939aa90'),('b77ed2627ff540088220f3b8b1647ec9','5dffc31fb5414c4ba66014546473f3dd'),('b93b442f4f19403f977b01195e7cc5b9','2bb72a62ff69468aad218b63b939aa90'),('b93b442f4f19403f977b01195e7cc5b9','5dffc31fb5414c4ba66014546473f3dd'),('c0097c12448046d996d0230dff13e341','2bb72a62ff69468aad218b63b939aa90'),('c0097c12448046d996d0230dff13e341','5dffc31fb5414c4ba66014546473f3dd'),('c1ce9dda29ed4e3b8ba346f54391e6e0','2bb72a62ff69468aad218b63b939aa90'),('c1ce9dda29ed4e3b8ba346f54391e6e0','5dffc31fb5414c4ba66014546473f3dd'),('c2bc1dd49c314ecd8c8b0b0e70c03bb4','2bb72a62ff69468aad218b63b939aa90'),('c2bc1dd49c314ecd8c8b0b0e70c03bb4','5dffc31fb5414c4ba66014546473f3dd'),('c32dd1b333ff476bbb18f2496562eace','2bb72a62ff69468aad218b63b939aa90'),('c32dd1b333ff476bbb18f2496562eace','5dffc31fb5414c4ba66014546473f3dd'),('c910c552c5bf4e53990bcd37c46d7c8c','2bb72a62ff69468aad218b63b939aa90'),('c910c552c5bf4e53990bcd37c46d7c8c','5dffc31fb5414c4ba66014546473f3dd'),('ca6b59a6f2aa4d82ab1ea1b4f6642516','2bb72a62ff69468aad218b63b939aa90'),('ca6b59a6f2aa4d82ab1ea1b4f6642516','5dffc31fb5414c4ba66014546473f3dd'),('cad12d80f3ce4e7989ed0e3b5973afa0','2bb72a62ff69468aad218b63b939aa90'),('cad12d80f3ce4e7989ed0e3b5973afa0','5dffc31fb5414c4ba66014546473f3dd'),('cd22c5a32ee047688480548e55c92d83','2bb72a62ff69468aad218b63b939aa90'),('cd22c5a32ee047688480548e55c92d83','5dffc31fb5414c4ba66014546473f3dd'),('cfba24d5b272406293c70d5554c77269','2bb72a62ff69468aad218b63b939aa90'),('cfba24d5b272406293c70d5554c77269','5dffc31fb5414c4ba66014546473f3dd'),('d62d9841f8f54325bc7f443c36537725','2bb72a62ff69468aad218b63b939aa90'),('d62d9841f8f54325bc7f443c36537725','5dffc31fb5414c4ba66014546473f3dd'),('dd43e271955a41c6ae6ac233c5d0e874','2bb72a62ff69468aad218b63b939aa90'),('dd43e271955a41c6ae6ac233c5d0e874','5dffc31fb5414c4ba66014546473f3dd'),('dda0a4f7445949edae9cd09e948fe4d2','2bb72a62ff69468aad218b63b939aa90'),('dda0a4f7445949edae9cd09e948fe4d2','5dffc31fb5414c4ba66014546473f3dd'),('df885b63168e4ad5a67886caa3c27cb0','2bb72a62ff69468aad218b63b939aa90'),('df885b63168e4ad5a67886caa3c27cb0','5dffc31fb5414c4ba66014546473f3dd'),('e4ff77e3fc474ea28fe2dbb23d381ee5','2bb72a62ff69468aad218b63b939aa90'),('e4ff77e3fc474ea28fe2dbb23d381ee5','5dffc31fb5414c4ba66014546473f3dd'),('e5610c58cf644ea5a2a4f2aed364dec3','2bb72a62ff69468aad218b63b939aa90'),('e5610c58cf644ea5a2a4f2aed364dec3','5dffc31fb5414c4ba66014546473f3dd'),('e63efe2e6b4d41e985367c51d57ae531','2bb72a62ff69468aad218b63b939aa90'),('e63efe2e6b4d41e985367c51d57ae531','5dffc31fb5414c4ba66014546473f3dd'),('e86c31a9a34549639db558304caf3719','2bb72a62ff69468aad218b63b939aa90'),('e86c31a9a34549639db558304caf3719','5dffc31fb5414c4ba66014546473f3dd'),('e99b8ceff6ab43e6b8edb8eba1645b0e','2bb72a62ff69468aad218b63b939aa90'),('e99b8ceff6ab43e6b8edb8eba1645b0e','5dffc31fb5414c4ba66014546473f3dd'),('ee4f2ee4df504f1b9842e440b6b8f1ef','2bb72a62ff69468aad218b63b939aa90'),('ee4f2ee4df504f1b9842e440b6b8f1ef','5dffc31fb5414c4ba66014546473f3dd'),('f25af07d09454df69ce89168f0fcb5de','2bb72a62ff69468aad218b63b939aa90'),('f25af07d09454df69ce89168f0fcb5de','5dffc31fb5414c4ba66014546473f3dd'),('fa2c7f6941f246ae85243002c4adf9a7','2bb72a62ff69468aad218b63b939aa90'),('fa2c7f6941f246ae85243002c4adf9a7','5dffc31fb5414c4ba66014546473f3dd'),('faad449f326348d1a55da8d5de2efb60','2bb72a62ff69468aad218b63b939aa90'),('faad449f326348d1a55da8d5de2efb60','5dffc31fb5414c4ba66014546473f3dd'),('ffca3ccfdc9b4b9387767d00bd738a37','2bb72a62ff69468aad218b63b939aa90'),('ffca3ccfdc9b4b9387767d00bd738a37','5dffc31fb5414c4ba66014546473f3dd');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('1aef1dae401645159257de28a8e93432','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:23:18','2026-01-20','default'),('1bc4d57465be47deb9af0f8f6d4aea49','{}',1,NULL,'2026-01-20 13:22:31','2026-01-20','35e70bfa06174539be01dc2b24dd5b9f'),('2cc7cc45ba634f7a91cd3bcade2d70b0','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:50','2026-01-20','default'),('2ee3482325254872a2fcde1baa41837f','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:46','2026-01-20','default'),('3859580ee17f4f0797dca674aa723353','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:30','2026-01-20','default'),('39ad29784c094363a0d2b4d812d396a2','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:23:21','2026-01-20','default'),('4d96c55d0649499c9af03a5756738c30','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:23:25','2026-01-20','default'),('5f95888288f3436a9b4af2889e5f3927','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:42','2026-01-20','default'),('7753d6d5c13d4e0a97b1df3b4994cdd4','{\"tenantId\": \"d530fc7710314e769f96929eccbcf850\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2026-01-20 13:49:33',NULL,'default'),('aa37593a8c3e4cd3a8e16becd7c1adc6','{}',1,NULL,'2026-01-20 13:21:18','2026-01-20','default'),('af0fc46fc1914701aae9d6ec04d35623','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:55',NULL,'default'),('dfb88765d65243b59fe5c30b77db78cc','{\"tenantId\": \"9fefc90697004684a6a41a2739520551\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2026-01-20 13:49:32','2026-01-20','default'),('f447ad7de72c4dfab6bd2c36dad26816','{}',1,'88c93604a4ea416ab4c4a1e962c3a525','2026-01-20 13:22:38','2026-01-20','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','glance','glance_9d24','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_9d24','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_a10f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_a10f','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','keystone','keystone_c2b2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_c2b2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','heat','heat_d54a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','heat','heat_d54a','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_0243','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_0243','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_1aa7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_1aa7','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_b03e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_b03e','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_5072','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_ebae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_5072','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_ebae','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1768915236}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1768915236}'),('localhost','glance_9d24','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6B9AD5914B5EE72C1995B81E8512073916F8F365\",\"password_last_changed\":1768915227}'),('%','glance_9d24','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6B9AD5914B5EE72C1995B81E8512073916F8F365\",\"password_last_changed\":1768915227}'),('localhost','placement_a10f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*232041B6670078BF569DD6007F7BF81E7A8A4A3D\",\"password_last_changed\":1768915236}'),('%','placement_a10f','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*232041B6670078BF569DD6007F7BF81E7A8A4A3D\",\"password_last_changed\":1768915236}'),('localhost','keystone_c2b2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*354B8DA70A03CEB8DC971EE1663C126DBE124D6F\",\"password_last_changed\":1768915236}'),('%','keystone_c2b2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*354B8DA70A03CEB8DC971EE1663C126DBE124D6F\",\"password_last_changed\":1768915236}'),('localhost','heat_d54a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E65433270E25DCCED57835B502B9A92A30FB9D94\",\"password_last_changed\":1768915260}'),('%','heat_d54a','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E65433270E25DCCED57835B502B9A92A30FB9D94\",\"password_last_changed\":1768915260}'),('localhost','cinder_0243','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*81B057C91A085AEAF60639CD20853A8772CD0293\",\"password_last_changed\":1768915260}'),('%','cinder_0243','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*81B057C91A085AEAF60639CD20853A8772CD0293\",\"password_last_changed\":1768915260}'),('localhost','barbican_1aa7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B1AC6B37DE573209055E37DB5DB283B51C0E33E8\",\"password_last_changed\":1768915261}'),('%','barbican_1aa7','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*B1AC6B37DE573209055E37DB5DB283B51C0E33E8\",\"password_last_changed\":1768915261}'),('localhost','neutron_b03e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*869C1A27F1E5C71F78641F1D7C6271CCD2C247C8\",\"password_last_changed\":1768915261}'),('%','neutron_b03e','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*869C1A27F1E5C71F78641F1D7C6271CCD2C247C8\",\"password_last_changed\":1768915261}'),('localhost','nova_api_5072','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*711C88053524B4805750DCF68A790374302051F5\",\"password_last_changed\":1768915357}'),('localhost','nova_cell0_ebae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E9925A1B14C906B48FF6D414FE6BD45B3B40ABBB\",\"password_last_changed\":1768915357}'),('%','nova_api_5072','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*711C88053524B4805750DCF68A790374302051F5\",\"password_last_changed\":1768915357}'),('%','nova_cell0_ebae','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E9925A1B14C906B48FF6D414FE6BD45B3B40ABBB\",\"password_last_changed\":1768915357}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no priv