/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
INSERT INTO `encrypted_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `content_type`, `secret_id`, `kek_id`, `cypher_text`, `kek_meta_extended`) VALUES ('d5e26661-7bf2-42a9-ac4c-155243bdc3a6','2025-12-06 07:46:57','2025-12-06 07:48:16','2025-12-06 07:48:16',1,'ACTIVE','application/octet-stream','7eed8ca9-eab0-4d8c-a68e-c776c26acb17','ed59320a-1f77-4e6c-ba80-87113978acb0','Z0FBQUFBQnBNOTl4QmpxU1NyQ0dlckhUMExMX3NIUGhldnp6ZDVuUk9LZEhkZ2RGNmtpUUN2dE9haHl4R2hScXBOQ0xKbU1kR1pEanM4bmQya1prenBCTEhuRG9PdGEyVUFia3d6VGFzem9EZmltcC1aYThkeEVMVDBqc09XSjE2RGRTTVo0OENPUjM=',NULL),('ff7dc752-ba61-4090-bf73-a1ebd642da64','2025-12-06 08:15:35','2025-12-06 08:16:09','2025-12-06 08:16:09',1,'ACTIVE','application/octet-stream','75728468-de3d-4c09-a185-2a907c7b8906','65fcedcf-80ba-4abb-9b67-a143e0670bfc','Z0FBQUFBQnBNLVluRTZiMXJwNGZCSmNXcUxFWUdyR1BiQWk5dWZQV1BLVGtKMkxkZEY2Q3B6R0RiLUJERzFVQ0ZGaUFWcF9MQ3BpZGNYLXdDVWdWd0RFSDdiUHdNYVNRTmZ2bDRSUG10ODRSMHhKRTRqakVoSzFnbkVEWnIyUjJpZzFZN00tczk4WjA=',NULL);
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
INSERT INTO `kek_data` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `plugin_name`, `kek_label`, `project_id`, `active`, `bind_completed`, `algorithm`, `bit_length`, `mode`, `plugin_meta`) VALUES ('65fcedcf-80ba-4abb-9b67-a143e0670bfc','2025-12-06 08:15:35','2025-12-06 08:22:46','2025-12-06 08:22:46',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-4b2dc4b8729f446a9c7ac69ca446f71d-key-ae316ea5-0043-4a88-a237-df1411b1f441','28cbc7f4-5e15-4ca7-a5c6-8298f0c0d7d8',1,1,'aes',128,'cbc','gAAAAABpM-Yn62QUn0S9BmDF43VEf3X-zXH-J8R0HVz8qagOrvf-Dt1vYifgWRKGoglYr_ZNCt_U6svkww-A9c7f-6fKHMZod27en0fZS2FrBR2_kf72Bbsj5O1mT2Ini1qcvo4Lbcck'),('ed59320a-1f77-4e6c-ba80-87113978acb0','2025-12-06 07:46:57','2025-12-06 07:48:53','2025-12-06 07:48:53',1,'ACTIVE','barbican.plugin.crypto.simple_crypto.SimpleCryptoPlugin','project-329d4c9562c84ec5a42ca68894cbf27f-key-70db4424-5122-4df7-b8e9-b048613704ec','976523db-4037-4a8a-bd16-d4b4721be6d4',1,1,'aes',128,'cbc','gAAAAABpM99x0kBdLDJORzGCuFqmu3kzn4bKNSX1oLTJO2yqVxdQZrnC6RqOMLbCGli0c6gDRNnw0q2zvId1r0JO38NA2WfK4csVP0FqOIg8R6eZ3vceX9ltLGjKEc_3iaPTSPPnX1r4');
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `type`, `project_id`, `error_status_code`, `error_reason`, `meta`, `secret_id`, `container_id`, `sub_status`, `sub_status_message`, `creator_id`) VALUES ('5f69d477-4e49-41f4-82a1-422826263ce5','2025-12-06 07:46:57','2025-12-06 07:46:57',NULL,0,'ACTIVE','key','976523db-4037-4a8a-bd16-d4b4721be6d4',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','7eed8ca9-eab0-4d8c-a68e-c776c26acb17',NULL,'Unknown','Unknown','5933a27f4e504e23a5d084501196c0fb'),('ef5259cb-fd40-4c99-baee-0f9a7a2beb2a','2025-12-06 08:15:35','2025-12-06 08:15:35',NULL,0,'ACTIVE','key','28cbc7f4-5e15-4ca7-a5c6-8298f0c0d7d8',NULL,NULL,'{\"algorithm\": \"aes\", \"bit_length\": 256, \"name\": null, \"expiration\": null}','75728468-de3d-4c09-a185-2a907c7b8906',NULL,'Unknown','Unknown','8e8feb4540af4e2caa45a88a9202dbe2');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `external_id`) VALUES ('28cbc7f4-5e15-4ca7-a5c6-8298f0c0d7d8','2025-12-06 08:15:35','2025-12-06 08:22:46','2025-12-06 08:22:46',1,'ACTIVE','4b2dc4b8729f446a9c7ac69ca446f71d'),('976523db-4037-4a8a-bd16-d4b4721be6d4','2025-12-06 07:46:57','2025-12-06 07:48:53','2025-12-06 07:48:53',1,'ACTIVE','329d4c9562c84ec5a42ca68894cbf27f');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
INSERT INTO `secret_store_metadata` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `key`, `value`, `secret_id`) VALUES ('bd74dcd2-f381-4ad3-8593-9342b2826112','2025-12-06 08:15:35','2025-12-06 08:16:09','2025-12-06 08:16:09',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','75728468-de3d-4c09-a185-2a907c7b8906'),('c220b2a8-8b29-4eb0-817e-d0f600e1d2dc','2025-12-06 07:46:57','2025-12-06 07:48:16','2025-12-06 07:48:16',1,'PENDING','content_type','application/octet-stream','7eed8ca9-eab0-4d8c-a68e-c776c26acb17'),('e9b61bd6-8ab7-4e6d-8dd2-3ce5f7d68656','2025-12-06 08:15:35','2025-12-06 08:16:09','2025-12-06 08:16:09',1,'PENDING','content_type','application/octet-stream','75728468-de3d-4c09-a185-2a907c7b8906'),('f8ec4304-8222-4702-bb12-78c7fb436ad2','2025-12-06 07:46:57','2025-12-06 07:48:16','2025-12-06 07:48:16',1,'PENDING','plugin_name','barbican.plugin.store_crypto.StoreCryptoAdapterPlugin','7eed8ca9-eab0-4d8c-a68e-c776c26acb17');
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('34d507b8-cf6c-4bc5-8a11-81a6bc2b138b','2025-12-06 06:09:50','2025-12-06 06:09:50',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
INSERT INTO `secrets` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `name`, `secret_type`, `expiration`, `algorithm`, `bit_length`, `mode`, `creator_id`, `project_id`) VALUES ('75728468-de3d-4c09-a185-2a907c7b8906','2025-12-06 08:15:35','2025-12-06 08:16:09','2025-12-06 08:16:09',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'8e8feb4540af4e2caa45a88a9202dbe2','28cbc7f4-5e15-4ca7-a5c6-8298f0c0d7d8'),('7eed8ca9-eab0-4d8c-a68e-c776c26acb17','2025-12-06 07:46:57','2025-12-06 07:48:16','2025-12-06 07:48:16',1,'ACTIVE',NULL,'symmetric',NULL,'aes',256,NULL,'5933a27f4e504e23a5d084501196c0fb','976523db-4037-4a8a-bd16-d4b4721be6d4');
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-12-06 08:27:36','2025-12-06 08:28:26','2025-12-06 08:28:27',1,'ee09be67-d52d-4f80-a400-600e604fb947','4cedca42-d524-4fdd-9e45-495f41b61117','00e2fea2f8f54b1c9af85553820566a6','55d0236410514dd9ad6cdb3e1a5d0ee6','cinder-backup-0',NULL,'tempest-TestVolumeBackupRestore-backup-1086090116',NULL,'backups','deleted',NULL,'{\"base\": \"volume-4cedca42-d524-4fdd-9e45-495f41b61117.backup.ee09be67-d52d-4f80-a400-600e604fb947\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:27:36','cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-06 07:46:56',NULL,'2025-12-06 07:48:17',1,'aes-xts-plain64','front-end',256,'luks','dc92f0f9-02c2-4310-b039-2df7a47f17b2','d0a87eff-85e7-4b2d-bf0b-5783b82f15af'),('2025-12-06 08:15:35',NULL,'2025-12-06 08:16:10',1,'aes-xts-plain64','front-end',256,'luks','a2eb05af-1af9-44c8-9c14-fb3696d6596b','f9a504ca-d937-44ce-a28f-a60c73b3e0fb');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'consistent_group_snapshot_enabled','<is> True','f49d644f-3264-4b21-b9be-1e7597b901cd','2025-12-06 06:09:50','2025-12-06 06:09:50',NULL,0);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('f49d644f-3264-4b21-b9be-1e7597b901cd','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-06 06:09:50','2025-12-06 06:09:50',NULL,0,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-06 06:09:42',NULL,NULL,0,1,'default','volumes',10),('2025-12-06 06:09:42',NULL,NULL,0,2,'default','snapshots',10),('2025-12-06 06:09:42',NULL,NULL,0,3,'default','gigabytes',1000),('2025-12-06 06:09:42',NULL,NULL,0,4,'default','consistencygroups',10),('2025-12-06 06:09:42',NULL,NULL,0,5,'default','per_volume_gigabytes',-1),('2025-12-06 06:09:42',NULL,NULL,0,6,'default','groups',10);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`,`race_preventer`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-12-06 06:57:55','2025-12-06 06:59:03',NULL,0,1,'ac4575fdd57240a9988c7ae425f0c2aa','volumes',0,0,NULL,1),('2025-12-06 06:57:55','2025-12-06 06:59:03',NULL,0,2,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes',0,0,NULL,1),('2025-12-06 06:57:55','2025-12-06 06:59:03',NULL,0,3,'ac4575fdd57240a9988c7ae425f0c2aa','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 06:57:55','2025-12-06 06:59:03',NULL,0,4,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:02:28','2025-12-06 07:03:55',NULL,0,5,'dc1bc9517198484ab30d93ebd5d88c35','volumes',0,0,NULL,1),('2025-12-06 07:02:28','2025-12-06 07:03:55',NULL,0,6,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes',0,0,NULL,1),('2025-12-06 07:02:28','2025-12-06 07:03:55',NULL,0,7,'dc1bc9517198484ab30d93ebd5d88c35','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:02:28','2025-12-06 07:03:55',NULL,0,8,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:04:24','2025-12-06 07:05:30',NULL,0,9,'9e86c61372e24db392d4a12ca71f7e00','volumes',0,0,NULL,1),('2025-12-06 07:04:24','2025-12-06 07:05:30',NULL,0,10,'9e86c61372e24db392d4a12ca71f7e00','gigabytes',0,0,NULL,1),('2025-12-06 07:04:24','2025-12-06 07:05:30',NULL,0,11,'9e86c61372e24db392d4a12ca71f7e00','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:04:24','2025-12-06 07:05:30',NULL,0,12,'9e86c61372e24db392d4a12ca71f7e00','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:05:25','2025-12-06 07:05:41',NULL,0,13,'edcc68bbf9cd4c9189e59964db884a26','volumes',0,0,NULL,1),('2025-12-06 07:05:25','2025-12-06 07:05:41',NULL,0,14,'edcc68bbf9cd4c9189e59964db884a26','gigabytes',0,0,NULL,1),('2025-12-06 07:05:25','2025-12-06 07:05:41',NULL,0,15,'edcc68bbf9cd4c9189e59964db884a26','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:05:25','2025-12-06 07:05:41',NULL,0,16,'edcc68bbf9cd4c9189e59964db884a26','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:06:42','2025-12-06 07:09:10',NULL,0,17,'c2236fb6443441618c69ad660b0932dd','volumes',0,0,NULL,1),('2025-12-06 07:06:42','2025-12-06 07:09:10',NULL,0,18,'c2236fb6443441618c69ad660b0932dd','gigabytes',0,0,NULL,1),('2025-12-06 07:06:42','2025-12-06 07:09:10',NULL,0,19,'c2236fb6443441618c69ad660b0932dd','volumes_multiattach',0,0,NULL,1),('2025-12-06 07:06:42','2025-12-06 07:09:10',NULL,0,20,'c2236fb6443441618c69ad660b0932dd','gigabytes_multiattach',0,0,NULL,1),('2025-12-06 07:09:11','2025-12-06 07:10:00',NULL,0,21,'4c41abd44bbf46f39df642d2a2cd19eb','volumes',0,0,NULL,1),('2025-12-06 07:09:11','2025-12-06 07:10:00',NULL,0,22,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes',0,0,NULL,1),('2025-12-06 07:09:11','2025-12-06 07:10:00',NULL,0,23,'4c41abd44bbf46f39df642d2a2cd19eb','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:09:11','2025-12-06 07:10:00',NULL,0,24,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:16:23','2025-12-06 07:18:45',NULL,0,25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',0,0,NULL,1),('2025-12-06 07:16:23','2025-12-06 07:18:45',NULL,0,26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',0,0,NULL,1),('2025-12-06 07:16:23','2025-12-06 07:18:45',NULL,0,27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:16:23','2025-12-06 07:18:45',NULL,0,28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:18:28','2025-12-06 07:19:49',NULL,0,29,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes',0,0,NULL,1),('2025-12-06 07:18:28','2025-12-06 07:19:49',NULL,0,30,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes',0,0,NULL,1),('2025-12-06 07:18:28','2025-12-06 07:19:49',NULL,0,31,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:18:28','2025-12-06 07:19:49',NULL,0,32,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:21:32','2025-12-06 07:23:05',NULL,0,33,'9536676f60844b6f802518771f02409f','volumes',0,0,NULL,1),('2025-12-06 07:21:32','2025-12-06 07:23:05',NULL,0,34,'9536676f60844b6f802518771f02409f','gigabytes',0,0,NULL,1),('2025-12-06 07:21:32','2025-12-06 07:23:05',NULL,0,35,'9536676f60844b6f802518771f02409f','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:21:32','2025-12-06 07:23:05',NULL,0,36,'9536676f60844b6f802518771f02409f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:21:37','2025-12-06 07:27:31',NULL,0,37,'c6d2f50c0db54315bfa96a24511dda90','volumes',0,0,NULL,1),('2025-12-06 07:21:37','2025-12-06 07:27:31',NULL,0,38,'c6d2f50c0db54315bfa96a24511dda90','gigabytes',0,0,NULL,1),('2025-12-06 07:21:37','2025-12-06 07:27:31',NULL,0,39,'c6d2f50c0db54315bfa96a24511dda90','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:21:37','2025-12-06 07:27:31',NULL,0,40,'c6d2f50c0db54315bfa96a24511dda90','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:24:54','2025-12-06 07:30:26',NULL,0,41,'001e2256cb8b430d93c1ff613010d199','volumes',0,0,NULL,1),('2025-12-06 07:24:54','2025-12-06 07:30:26',NULL,0,42,'001e2256cb8b430d93c1ff613010d199','gigabytes',0,0,NULL,1),('2025-12-06 07:24:54','2025-12-06 07:30:26',NULL,0,43,'001e2256cb8b430d93c1ff613010d199','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:24:54','2025-12-06 07:30:26',NULL,0,44,'001e2256cb8b430d93c1ff613010d199','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:28:36','2025-12-06 07:33:10',NULL,0,45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',0,0,NULL,1),('2025-12-06 07:28:36','2025-12-06 07:33:10',NULL,0,46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',0,0,NULL,1),('2025-12-06 07:28:36','2025-12-06 07:33:10',NULL,0,47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:28:36','2025-12-06 07:33:10',NULL,0,48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:32:16','2025-12-06 07:40:47',NULL,0,49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',0,0,NULL,1),('2025-12-06 07:32:16','2025-12-06 07:40:47',NULL,0,50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',0,0,NULL,1),('2025-12-06 07:32:16','2025-12-06 07:40:47',NULL,0,51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',0,0,NULL,1),('2025-12-06 07:32:16','2025-12-06 07:40:47',NULL,0,52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',0,0,NULL,1),('2025-12-06 07:34:04','2025-12-06 07:36:57',NULL,0,53,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes',2,0,NULL,1),('2025-12-06 07:34:04','2025-12-06 07:36:57',NULL,0,54,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes',2,0,NULL,1),('2025-12-06 07:34:04','2025-12-06 07:36:57',NULL,0,55,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes___DEFAULT__',2,0,NULL,1),('2025-12-06 07:34:04','2025-12-06 07:36:57',NULL,0,56,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes___DEFAULT__',2,0,NULL,1),('2025-12-06 07:36:29','2025-12-06 07:39:35',NULL,0,57,'21cd37bffa864aaebe5c734ba468f466','volumes',0,0,NULL,1),('2025-12-06 07:36:29','2025-12-06 07:39:35',NULL,0,58,'21cd37bffa864aaebe5c734ba468f466','gigabytes',0,0,NULL,1),('2025-12-06 07:36:29','2025-12-06 07:39:35',NULL,0,59,'21cd37bffa864aaebe5c734ba468f466','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:36:29','2025-12-06 07:39:35',NULL,0,60,'21cd37bffa864aaebe5c734ba468f466','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:37:42','2025-12-06 07:42:42',NULL,0,61,'b10aa03d68eb4d4799d53538521cc364','volumes',0,0,NULL,1),('2025-12-06 07:37:42','2025-12-06 07:42:42',NULL,0,62,'b10aa03d68eb4d4799d53538521cc364','gigabytes',0,0,NULL,1),('2025-12-06 07:37:42','2025-12-06 07:42:42',NULL,0,63,'b10aa03d68eb4d4799d53538521cc364','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:37:42','2025-12-06 07:42:42',NULL,0,64,'b10aa03d68eb4d4799d53538521cc364','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:39:37','2025-12-06 07:39:51',NULL,0,65,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots',0,0,NULL,1),('2025-12-06 07:39:37','2025-12-06 07:39:51',NULL,0,66,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots_multiattach',0,0,NULL,1),('2025-12-06 07:42:14','2025-12-06 07:46:03',NULL,0,67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',0,0,NULL,1),('2025-12-06 07:42:14','2025-12-06 07:46:03',NULL,0,68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',0,0,NULL,1),('2025-12-06 07:42:14','2025-12-06 07:46:03',NULL,0,69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:42:14','2025-12-06 07:46:03',NULL,0,70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:44:50','2025-12-06 07:47:23',NULL,0,71,'4ec9294f6d4b4f44a72414374d646a4a','volumes',0,0,NULL,1),('2025-12-06 07:44:50','2025-12-06 07:47:23',NULL,0,72,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes',0,0,NULL,1),('2025-12-06 07:44:50','2025-12-06 07:47:23',NULL,0,73,'4ec9294f6d4b4f44a72414374d646a4a','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:44:50','2025-12-06 07:47:23',NULL,0,74,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:35','2025-12-06 07:45:37',NULL,0,75,'00a24842329842059aee8ff6e53c0c00','volumes',0,0,NULL,1),('2025-12-06 07:45:35','2025-12-06 07:45:37',NULL,0,76,'00a24842329842059aee8ff6e53c0c00','gigabytes',0,0,NULL,1),('2025-12-06 07:45:35','2025-12-06 07:45:37',NULL,0,77,'00a24842329842059aee8ff6e53c0c00','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:35','2025-12-06 07:45:37',NULL,0,78,'00a24842329842059aee8ff6e53c0c00','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:42','2025-12-06 07:45:58',NULL,0,79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',0,0,NULL,1),('2025-12-06 07:45:42','2025-12-06 07:45:58',NULL,0,80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',0,0,NULL,1),('2025-12-06 07:45:42','2025-12-06 07:45:58',NULL,0,81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:42','2025-12-06 07:45:58',NULL,0,82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:55','2025-12-06 07:47:58',NULL,0,83,'f44ecb8bdc7e4692a299e29603301124','volumes',0,0,NULL,1),('2025-12-06 07:45:55','2025-12-06 07:47:58',NULL,0,84,'f44ecb8bdc7e4692a299e29603301124','gigabytes',0,0,NULL,1),('2025-12-06 07:45:55','2025-12-06 07:47:58',NULL,0,85,'f44ecb8bdc7e4692a299e29603301124','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:45:55','2025-12-06 07:47:58',NULL,0,86,'f44ecb8bdc7e4692a299e29603301124','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:46:13','2025-12-06 07:46:23',NULL,0,87,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes',0,0,NULL,1),('2025-12-06 07:46:13','2025-12-06 07:46:23',NULL,0,88,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes',0,0,NULL,1),('2025-12-06 07:46:13','2025-12-06 07:46:23',NULL,0,89,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:46:13','2025-12-06 07:46:23',NULL,0,90,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:46:16','2025-12-06 07:46:21',NULL,0,91,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots',0,0,NULL,1),('2025-12-06 07:46:16','2025-12-06 07:46:21',NULL,0,92,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-06 07:46:57','2025-12-06 07:48:17',NULL,0,93,'329d4c9562c84ec5a42ca68894cbf27f','volumes',0,0,NULL,1),('2025-12-06 07:46:57','2025-12-06 07:48:17',NULL,0,94,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes',0,0,NULL,1),('2025-12-06 07:46:57','2025-12-06 07:48:17',NULL,0,95,'329d4c9562c84ec5a42ca68894cbf27f','volumes_tempest-scenario-type-luks-717406057',0,0,NULL,1),('2025-12-06 07:46:57','2025-12-06 07:48:17',NULL,0,96,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes_tempest-scenario-type-luks-717406057',0,0,NULL,1),('2025-12-06 07:50:24','2025-12-06 07:53:20',NULL,0,97,'c4cf19b89a6d46bca307e65731a9dd21','volumes',0,0,NULL,1),('2025-12-06 07:50:24','2025-12-06 07:53:20',NULL,0,98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',0,0,NULL,1),('2025-12-06 07:50:24','2025-12-06 07:53:20',NULL,0,99,'c4cf19b89a6d46bca307e65731a9dd21','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:24','2025-12-06 07:53:20',NULL,0,100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:32','2025-12-06 07:54:13',NULL,0,101,'0c8fc5bc237e42bfad505a0bca6681eb','volumes',0,0,NULL,1),('2025-12-06 07:50:32','2025-12-06 07:54:13',NULL,0,102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',0,0,NULL,1),('2025-12-06 07:50:32','2025-12-06 07:54:13',NULL,0,103,'0c8fc5bc237e42bfad505a0bca6681eb','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:32','2025-12-06 07:54:13',NULL,0,104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:40','2025-12-06 07:51:04',NULL,0,105,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots',0,0,NULL,1),('2025-12-06 07:50:40','2025-12-06 07:51:04',NULL,0,106,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:55','2025-12-06 07:53:48',NULL,0,107,'4842ecff6dce4ccc981a6b65a14ea406','volumes',0,0,NULL,1),('2025-12-06 07:50:55','2025-12-06 07:53:48',NULL,0,108,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes',0,0,NULL,1),('2025-12-06 07:50:55','2025-12-06 07:53:48',NULL,0,109,'4842ecff6dce4ccc981a6b65a14ea406','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:50:55','2025-12-06 07:53:48',NULL,0,110,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:51:17','2025-12-06 07:54:47',NULL,0,111,'cfa713d92cc94fa1b94404ed58b0563f','volumes',0,0,NULL,1),('2025-12-06 07:51:17','2025-12-06 07:54:47',NULL,0,112,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes',0,0,NULL,1),('2025-12-06 07:51:17','2025-12-06 07:54:47',NULL,0,113,'cfa713d92cc94fa1b94404ed58b0563f','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:51:17','2025-12-06 07:54:47',NULL,0,114,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:51:29','2025-12-06 07:53:08',NULL,0,115,'c4cf19b89a6d46bca307e65731a9dd21','snapshots',0,0,NULL,1),('2025-12-06 07:51:29','2025-12-06 07:53:08',NULL,0,116,'c4cf19b89a6d46bca307e65731a9dd21','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-06 07:55:09','2025-12-06 07:58:24',NULL,0,117,'63df107b8bd14504974c75ba92ae469b','volumes',0,0,NULL,1),('2025-12-06 07:55:09','2025-12-06 07:58:24',NULL,0,118,'63df107b8bd14504974c75ba92ae469b','gigabytes',0,0,NULL,1),('2025-12-06 07:55:09','2025-12-06 07:58:24',NULL,0,119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:55:09','2025-12-06 07:58:24',NULL,0,120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:58:15',NULL,0,121,'6164fee998c94b71a37886fe42b4c56c','volumes',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:58:15',NULL,0,122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:57:20',NULL,0,123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:57:20',NULL,0,124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:57:29',NULL,0,125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',0,0,NULL,1),('2025-12-06 07:55:27','2025-12-06 07:57:29',NULL,0,126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',0,0,NULL,1),('2025-12-06 07:55:30','2025-12-06 07:58:15',NULL,0,127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',0,0,NULL,1),('2025-12-06 07:55:30','2025-12-06 07:58:15',NULL,0,128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',0,0,NULL,1),('2025-12-06 07:58:38','2025-12-06 08:00:51',NULL,0,129,'c3c0564f8e9f4af9ae5b597a275c989f','volumes',0,0,NULL,1),('2025-12-06 07:58:38','2025-12-06 08:00:51',NULL,0,130,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes',0,0,NULL,1),('2025-12-06 07:58:38','2025-12-06 08:00:51',NULL,0,131,'c3c0564f8e9f4af9ae5b597a275c989f','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 07:58:38','2025-12-06 08:00:51',NULL,0,132,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 08:15:35','2025-12-06 08:22:27',NULL,0,133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',0,0,NULL,1),('2025-12-06 08:15:35','2025-12-06 08:22:27',NULL,0,134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',0,0,NULL,1),('2025-12-06 08:15:35','2025-12-06 08:16:09',NULL,0,135,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes_tempest-scenario-type-luks-1522269493',0,0,NULL,1),('2025-12-06 08:15:35','2025-12-06 08:16:09',NULL,0,136,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes_tempest-scenario-type-luks-1522269493',0,0,NULL,1),('2025-12-06 08:16:12','2025-12-06 08:22:27',NULL,0,137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 08:16:12','2025-12-06 08:22:27',NULL,0,138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 08:16:20','2025-12-06 08:22:14',NULL,0,139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',0,0,NULL,1),('2025-12-06 08:16:20','2025-12-06 08:22:14',NULL,0,140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',0,0,NULL,1),('2025-12-06 08:27:27','2025-12-06 08:28:27',NULL,0,141,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes',0,0,NULL,1),('2025-12-06 08:27:27','2025-12-06 08:28:27',NULL,0,142,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes',0,0,NULL,1),('2025-12-06 08:27:27','2025-12-06 08:28:27',NULL,0,143,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes___DEFAULT__',0,0,NULL,1),('2025-12-06 08:27:27','2025-12-06 08:28:27',NULL,0,144,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes___DEFAULT__',0,0,NULL,1),('2025-12-06 08:27:36','2025-12-06 08:28:27',NULL,0,145,'55d0236410514dd9ad6cdb3e1a5d0ee6','backups',0,0,NULL,1),('2025-12-06 08:27:36','2025-12-06 08:28:27',NULL,0,146,'55d0236410514dd9ad6cdb3e1a5d0ee6','backup_gigabytes',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-12-06 06:57:55','2025-12-06 06:57:55','2025-12-06 06:57:55',1,1,'7564ec58-80bc-4350-ba49-850a75cda42a',1,'ac4575fdd57240a9988c7ae425f0c2aa','volumes',1,'2025-12-07 06:57:55',NULL),('2025-12-06 06:57:55','2025-12-06 06:57:55','2025-12-06 06:57:55',1,2,'71972143-5fc2-4390-92c5-8d4152d00f28',2,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes',1,'2025-12-07 06:57:55',NULL),('2025-12-06 06:57:55','2025-12-06 06:57:55','2025-12-06 06:57:55',1,3,'ef749bce-39aa-4cdb-8e7e-7826dfd68e56',3,'ac4575fdd57240a9988c7ae425f0c2aa','volumes___DEFAULT__',1,'2025-12-07 06:57:55',NULL),('2025-12-06 06:57:55','2025-12-06 06:57:55','2025-12-06 06:57:55',1,4,'5e357143-bfbf-4ca4-b0a4-40b7b08214f3',4,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes___DEFAULT__',1,'2025-12-07 06:57:55',NULL),('2025-12-06 06:59:03','2025-12-06 06:59:03','2025-12-06 06:59:03',1,5,'d256a884-f7a2-4ed4-bb08-56bfae7a8cec',1,'ac4575fdd57240a9988c7ae425f0c2aa','volumes',-1,'2025-12-07 06:59:03',NULL),('2025-12-06 06:59:03','2025-12-06 06:59:03','2025-12-06 06:59:03',1,6,'6117ea2b-ae99-4f4b-8183-9271a57f99b3',2,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes',-1,'2025-12-07 06:59:03',NULL),('2025-12-06 06:59:03','2025-12-06 06:59:03','2025-12-06 06:59:03',1,7,'c81054ca-04f3-4ebb-8b7d-c3ecc4a8a11f',3,'ac4575fdd57240a9988c7ae425f0c2aa','volumes___DEFAULT__',-1,'2025-12-07 06:59:03',NULL),('2025-12-06 06:59:03','2025-12-06 06:59:03','2025-12-06 06:59:03',1,8,'b70cbd8d-8108-4025-bd34-7de1d96a462c',4,'ac4575fdd57240a9988c7ae425f0c2aa','gigabytes___DEFAULT__',-1,'2025-12-07 06:59:03',NULL),('2025-12-06 07:02:28','2025-12-06 07:02:28','2025-12-06 07:02:28',1,9,'3e10ce4c-fc2e-4b1d-b17f-08887d7727b1',5,'dc1bc9517198484ab30d93ebd5d88c35','volumes',1,'2025-12-07 07:02:28',NULL),('2025-12-06 07:02:28','2025-12-06 07:02:28','2025-12-06 07:02:28',1,10,'02427023-6fbb-4e43-90dd-f40e909d6a47',6,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes',1,'2025-12-07 07:02:28',NULL),('2025-12-06 07:02:28','2025-12-06 07:02:28','2025-12-06 07:02:28',1,11,'cb789808-80a6-4bd8-9470-dc85fae0a6ae',7,'dc1bc9517198484ab30d93ebd5d88c35','volumes___DEFAULT__',1,'2025-12-07 07:02:28',NULL),('2025-12-06 07:02:28','2025-12-06 07:02:28','2025-12-06 07:02:28',1,12,'b8ba718b-4264-41a8-a5b5-168cd93c4af4',8,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes___DEFAULT__',1,'2025-12-07 07:02:28',NULL),('2025-12-06 07:03:55','2025-12-06 07:03:55','2025-12-06 07:03:55',1,13,'26d9fd33-4195-4e9d-bac2-b6870c439eed',5,'dc1bc9517198484ab30d93ebd5d88c35','volumes',-1,'2025-12-07 07:03:55',NULL),('2025-12-06 07:03:55','2025-12-06 07:03:55','2025-12-06 07:03:55',1,14,'cf1a717c-2495-49d4-8490-19e2a940eb8c',6,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes',-1,'2025-12-07 07:03:55',NULL),('2025-12-06 07:03:55','2025-12-06 07:03:55','2025-12-06 07:03:55',1,15,'9c446881-d3ac-4192-947c-de287bc284a0',7,'dc1bc9517198484ab30d93ebd5d88c35','volumes___DEFAULT__',-1,'2025-12-07 07:03:55',NULL),('2025-12-06 07:03:55','2025-12-06 07:03:55','2025-12-06 07:03:55',1,16,'8922f651-7898-4b34-bc09-59f2362f220e',8,'dc1bc9517198484ab30d93ebd5d88c35','gigabytes___DEFAULT__',-1,'2025-12-07 07:03:55',NULL),('2025-12-06 07:04:24','2025-12-06 07:04:24','2025-12-06 07:04:24',1,17,'4ab70a89-f560-4401-abcd-e340c358eb0b',9,'9e86c61372e24db392d4a12ca71f7e00','volumes',1,'2025-12-07 07:04:24',NULL),('2025-12-06 07:04:24','2025-12-06 07:04:24','2025-12-06 07:04:24',1,18,'cb6c632e-6f83-4c31-9226-eaff5fc392d9',10,'9e86c61372e24db392d4a12ca71f7e00','gigabytes',1,'2025-12-07 07:04:24',NULL),('2025-12-06 07:04:24','2025-12-06 07:04:24','2025-12-06 07:04:24',1,19,'1a9a0948-9bcd-45b0-b172-d93263e3de26',11,'9e86c61372e24db392d4a12ca71f7e00','volumes___DEFAULT__',1,'2025-12-07 07:04:24',NULL),('2025-12-06 07:04:24','2025-12-06 07:04:24','2025-12-06 07:04:24',1,20,'5a0d624d-7e5d-4bac-99fa-718000cd0d33',12,'9e86c61372e24db392d4a12ca71f7e00','gigabytes___DEFAULT__',1,'2025-12-07 07:04:24',NULL),('2025-12-06 07:05:25','2025-12-06 07:05:25','2025-12-06 07:05:25',1,21,'9b843f3c-b443-420f-b742-9da1a10fd0df',13,'edcc68bbf9cd4c9189e59964db884a26','volumes',1,'2025-12-07 07:05:25',NULL),('2025-12-06 07:05:25','2025-12-06 07:05:25','2025-12-06 07:05:25',1,22,'0b1ff1b6-4ed6-4a00-992a-892899621da3',14,'edcc68bbf9cd4c9189e59964db884a26','gigabytes',1,'2025-12-07 07:05:25',NULL),('2025-12-06 07:05:25','2025-12-06 07:05:25','2025-12-06 07:05:25',1,23,'2f4f9a88-7e62-464a-9b17-6349778cdfba',15,'edcc68bbf9cd4c9189e59964db884a26','volumes___DEFAULT__',1,'2025-12-07 07:05:25',NULL),('2025-12-06 07:05:25','2025-12-06 07:05:25','2025-12-06 07:05:25',1,24,'037483de-a325-4940-860d-c7ad550adeaf',16,'edcc68bbf9cd4c9189e59964db884a26','gigabytes___DEFAULT__',1,'2025-12-07 07:05:25',NULL),('2025-12-06 07:05:30','2025-12-06 07:05:30','2025-12-06 07:05:30',1,25,'e1569501-aab0-437b-a3af-2508625c9de1',9,'9e86c61372e24db392d4a12ca71f7e00','volumes',-1,'2025-12-07 07:05:30',NULL),('2025-12-06 07:05:30','2025-12-06 07:05:30','2025-12-06 07:05:30',1,26,'c99f30f9-937f-4aa1-b67d-e1c824a26fbd',10,'9e86c61372e24db392d4a12ca71f7e00','gigabytes',-1,'2025-12-07 07:05:30',NULL),('2025-12-06 07:05:30','2025-12-06 07:05:30','2025-12-06 07:05:30',1,27,'044dff71-328c-4568-82a6-8718063a1568',11,'9e86c61372e24db392d4a12ca71f7e00','volumes___DEFAULT__',-1,'2025-12-07 07:05:30',NULL),('2025-12-06 07:05:30','2025-12-06 07:05:30','2025-12-06 07:05:30',1,28,'1f1dbead-1af3-44aa-8540-2df559e8aa78',12,'9e86c61372e24db392d4a12ca71f7e00','gigabytes___DEFAULT__',-1,'2025-12-07 07:05:30',NULL),('2025-12-06 07:05:41','2025-12-06 07:05:41','2025-12-06 07:05:41',1,29,'34c6d4ad-4828-44cf-8e32-38dd50a37a97',13,'edcc68bbf9cd4c9189e59964db884a26','volumes',-1,'2025-12-07 07:05:41',NULL),('2025-12-06 07:05:41','2025-12-06 07:05:41','2025-12-06 07:05:41',1,30,'d46cc944-e65c-424a-8e8d-d17daa960567',14,'edcc68bbf9cd4c9189e59964db884a26','gigabytes',-1,'2025-12-07 07:05:41',NULL),('2025-12-06 07:05:41','2025-12-06 07:05:41','2025-12-06 07:05:41',1,31,'9fe1fac2-b950-4a95-8954-d3674464a358',15,'edcc68bbf9cd4c9189e59964db884a26','volumes___DEFAULT__',-1,'2025-12-07 07:05:41',NULL),('2025-12-06 07:05:41','2025-12-06 07:05:41','2025-12-06 07:05:41',1,32,'0038059b-44c2-4dcf-86b2-49559c842c62',16,'edcc68bbf9cd4c9189e59964db884a26','gigabytes___DEFAULT__',-1,'2025-12-07 07:05:41',NULL),('2025-12-06 07:06:42','2025-12-06 07:06:42','2025-12-06 07:06:42',1,33,'297b9c66-d1cd-4e40-828e-0ebb87798304',17,'c2236fb6443441618c69ad660b0932dd','volumes',1,'2025-12-07 07:06:42',NULL),('2025-12-06 07:06:42','2025-12-06 07:06:42','2025-12-06 07:06:42',1,34,'5110d9eb-a66a-41c4-9e3b-2bb59dafd3ad',18,'c2236fb6443441618c69ad660b0932dd','gigabytes',1,'2025-12-07 07:06:42',NULL),('2025-12-06 07:06:42','2025-12-06 07:06:42','2025-12-06 07:06:42',1,35,'866228ab-26e7-4e57-bd1a-818343c59d3d',19,'c2236fb6443441618c69ad660b0932dd','volumes_multiattach',1,'2025-12-07 07:06:42',NULL),('2025-12-06 07:06:42','2025-12-06 07:06:42','2025-12-06 07:06:42',1,36,'4d58ba81-61f4-45e8-b0bc-f02a9c2fa8b2',20,'c2236fb6443441618c69ad660b0932dd','gigabytes_multiattach',1,'2025-12-07 07:06:42',NULL),('2025-12-06 07:06:44','2025-12-06 07:06:44','2025-12-06 07:06:44',1,37,'d36e3140-a4bc-4093-8687-fe567dbdf588',17,'c2236fb6443441618c69ad660b0932dd','volumes',1,'2025-12-07 07:06:44',NULL),('2025-12-06 07:06:44','2025-12-06 07:06:44','2025-12-06 07:06:44',1,38,'53df7bb7-f72b-4beb-b688-39026b06ae4b',18,'c2236fb6443441618c69ad660b0932dd','gigabytes',1,'2025-12-07 07:06:44',NULL),('2025-12-06 07:06:44','2025-12-06 07:06:44','2025-12-06 07:06:44',1,39,'378ad925-303c-4210-aaf8-866c513fc23f',19,'c2236fb6443441618c69ad660b0932dd','volumes_multiattach',1,'2025-12-07 07:06:44',NULL),('2025-12-06 07:06:44','2025-12-06 07:06:44','2025-12-06 07:06:44',1,40,'d5ac18c6-deb1-4d04-ad8c-05723cf997c6',20,'c2236fb6443441618c69ad660b0932dd','gigabytes_multiattach',1,'2025-12-07 07:06:44',NULL),('2025-12-06 07:09:07','2025-12-06 07:09:07','2025-12-06 07:09:07',1,41,'c3964968-9b44-4040-8fec-3e26080fee91',17,'c2236fb6443441618c69ad660b0932dd','volumes',-1,'2025-12-07 07:09:07',NULL),('2025-12-06 07:09:07','2025-12-06 07:09:07','2025-12-06 07:09:07',1,42,'4cdc1cdf-bfe2-4ab4-9414-010286ccb1a3',18,'c2236fb6443441618c69ad660b0932dd','gigabytes',-1,'2025-12-07 07:09:07',NULL),('2025-12-06 07:09:07','2025-12-06 07:09:07','2025-12-06 07:09:07',1,43,'d2efbc07-75d8-4b05-9b5f-84ce816f1a8f',19,'c2236fb6443441618c69ad660b0932dd','volumes_multiattach',-1,'2025-12-07 07:09:07',NULL),('2025-12-06 07:09:07','2025-12-06 07:09:07','2025-12-06 07:09:07',1,44,'c5ec253f-8f1f-4fb6-b7bb-83cb2f39759a',20,'c2236fb6443441618c69ad660b0932dd','gigabytes_multiattach',-1,'2025-12-07 07:09:07',NULL),('2025-12-06 07:09:10','2025-12-06 07:09:10','2025-12-06 07:09:10',1,45,'2e6f334f-3576-487c-b605-8af62f25c1fb',17,'c2236fb6443441618c69ad660b0932dd','volumes',-1,'2025-12-07 07:09:10',NULL),('2025-12-06 07:09:10','2025-12-06 07:09:10','2025-12-06 07:09:10',1,46,'d57e3613-b635-4504-88c4-cec2d18f5686',18,'c2236fb6443441618c69ad660b0932dd','gigabytes',-1,'2025-12-07 07:09:10',NULL),('2025-12-06 07:09:10','2025-12-06 07:09:10','2025-12-06 07:09:10',1,47,'d383bb09-b7dd-4ab9-8aa8-fd488fde8b25',19,'c2236fb6443441618c69ad660b0932dd','volumes_multiattach',-1,'2025-12-07 07:09:10',NULL),('2025-12-06 07:09:10','2025-12-06 07:09:10','2025-12-06 07:09:10',1,48,'924c6c57-b5ff-47cd-83b6-f9b191adecfd',20,'c2236fb6443441618c69ad660b0932dd','gigabytes_multiattach',-1,'2025-12-07 07:09:10',NULL),('2025-12-06 07:09:11','2025-12-06 07:09:11','2025-12-06 07:09:11',1,49,'b08ab769-4235-4fc9-830c-7e9e8b5ee334',21,'4c41abd44bbf46f39df642d2a2cd19eb','volumes',1,'2025-12-07 07:09:11',NULL),('2025-12-06 07:09:11','2025-12-06 07:09:11','2025-12-06 07:09:11',1,50,'3cd184c3-af6d-47cc-9fd0-94e5bc2607eb',22,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes',1,'2025-12-07 07:09:11',NULL),('2025-12-06 07:09:11','2025-12-06 07:09:11','2025-12-06 07:09:11',1,51,'6d295f40-f540-48be-b3a4-9c84762240c3',23,'4c41abd44bbf46f39df642d2a2cd19eb','volumes___DEFAULT__',1,'2025-12-07 07:09:11',NULL),('2025-12-06 07:09:11','2025-12-06 07:09:11','2025-12-06 07:09:11',1,52,'5462eefc-cc18-4ff2-9e1c-119845fccd78',24,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes___DEFAULT__',1,'2025-12-07 07:09:11',NULL),('2025-12-06 07:09:35','2025-12-06 07:09:35','2025-12-06 07:09:35',1,53,'fdd7c5cc-5afb-467a-91b2-5a11d6ce5b99',21,'4c41abd44bbf46f39df642d2a2cd19eb','volumes',1,'2025-12-07 07:09:35',NULL),('2025-12-06 07:09:35','2025-12-06 07:09:35','2025-12-06 07:09:35',1,54,'992cb24f-afc5-4f96-966d-f1febc8ff8e4',22,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes',1,'2025-12-07 07:09:35',NULL),('2025-12-06 07:09:35','2025-12-06 07:09:35','2025-12-06 07:09:35',1,55,'7c8d99ed-40e4-4746-bbaf-278679b1317c',23,'4c41abd44bbf46f39df642d2a2cd19eb','volumes___DEFAULT__',1,'2025-12-07 07:09:35',NULL),('2025-12-06 07:09:35','2025-12-06 07:09:35','2025-12-06 07:09:35',1,56,'0c59c019-df43-4064-a871-121d8aec10ac',24,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes___DEFAULT__',1,'2025-12-07 07:09:35',NULL),('2025-12-06 07:09:39','2025-12-06 07:09:39','2025-12-06 07:09:39',1,57,'f207485d-2445-4cdc-ad44-576de3168e3d',21,'4c41abd44bbf46f39df642d2a2cd19eb','volumes',-1,'2025-12-07 07:09:39',NULL),('2025-12-06 07:09:39','2025-12-06 07:09:39','2025-12-06 07:09:39',1,58,'239cc2b5-cda0-4f58-b6d5-316081abe8bc',22,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes',-1,'2025-12-07 07:09:39',NULL),('2025-12-06 07:09:39','2025-12-06 07:09:39','2025-12-06 07:09:39',1,59,'8c5e979f-935b-4d40-9958-0af4ad7ad2e6',23,'4c41abd44bbf46f39df642d2a2cd19eb','volumes___DEFAULT__',-1,'2025-12-07 07:09:39',NULL),('2025-12-06 07:09:39','2025-12-06 07:09:39','2025-12-06 07:09:39',1,60,'719c0af9-b740-4af7-bbff-ac4d1b1b48da',24,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes___DEFAULT__',-1,'2025-12-07 07:09:39',NULL),('2025-12-06 07:10:00','2025-12-06 07:10:00','2025-12-06 07:10:00',1,61,'1276a9ba-c598-4f8c-8c2b-4de561ce0cd2',21,'4c41abd44bbf46f39df642d2a2cd19eb','volumes',-1,'2025-12-07 07:10:00',NULL),('2025-12-06 07:10:00','2025-12-06 07:10:00','2025-12-06 07:10:00',1,62,'e8cbca25-bd64-49b8-96ee-43383543b2b7',22,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes',-1,'2025-12-07 07:10:00',NULL),('2025-12-06 07:10:00','2025-12-06 07:10:00','2025-12-06 07:10:00',1,63,'2d06b0ba-79cf-4de6-ac35-c1e2088b9f16',23,'4c41abd44bbf46f39df642d2a2cd19eb','volumes___DEFAULT__',-1,'2025-12-07 07:10:00',NULL),('2025-12-06 07:10:00','2025-12-06 07:10:00','2025-12-06 07:10:00',1,64,'da86282c-8fa3-460f-afeb-133309c54226',24,'4c41abd44bbf46f39df642d2a2cd19eb','gigabytes___DEFAULT__',-1,'2025-12-07 07:10:00',NULL),('2025-12-06 07:16:23','2025-12-06 07:16:23','2025-12-06 07:16:23',1,65,'3fe17411-9f9c-47a7-9577-70320bc8fad7',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',1,'2025-12-07 07:16:23',NULL),('2025-12-06 07:16:23','2025-12-06 07:16:23','2025-12-06 07:16:23',1,66,'970214ca-9a8c-4420-b974-ab95eb455ef5',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',1,'2025-12-07 07:16:23',NULL),('2025-12-06 07:16:23','2025-12-06 07:16:23','2025-12-06 07:16:23',1,67,'ce2b573e-6ec0-462f-ae3b-96bf8e8e041d',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',1,'2025-12-07 07:16:23',NULL),('2025-12-06 07:16:23','2025-12-06 07:16:23','2025-12-06 07:16:23',1,68,'f333dd03-53fc-4a82-ae62-45ab1dcf2af9',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',1,'2025-12-07 07:16:23',NULL),('2025-12-06 07:16:31','2025-12-06 07:16:31','2025-12-06 07:16:31',1,69,'9d416cd5-ece8-4ec1-867f-e515b84bcbfc',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',1,'2025-12-07 07:16:31',NULL),('2025-12-06 07:16:31','2025-12-06 07:16:31','2025-12-06 07:16:31',1,70,'1c2e0559-3cfa-4f73-aebd-9a28847d0ea8',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',1,'2025-12-07 07:16:31',NULL),('2025-12-06 07:16:31','2025-12-06 07:16:31','2025-12-06 07:16:31',1,71,'a7822f62-4b44-4ff6-b511-67312526c39b',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',1,'2025-12-07 07:16:31',NULL),('2025-12-06 07:16:31','2025-12-06 07:16:31','2025-12-06 07:16:31',1,72,'21241106-e19e-4d42-b08d-1d62a2594db3',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',1,'2025-12-07 07:16:31',NULL),('2025-12-06 07:16:32','2025-12-06 07:16:32','2025-12-06 07:16:32',1,73,'ce458a67-4b39-45fa-b408-224370102d3d',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',1,'2025-12-07 07:16:32',NULL),('2025-12-06 07:16:32','2025-12-06 07:16:32','2025-12-06 07:16:32',1,74,'ae90d51d-8688-4360-9f2c-0d2d09a9a364',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',1,'2025-12-07 07:16:32',NULL),('2025-12-06 07:16:32','2025-12-06 07:16:32','2025-12-06 07:16:32',1,75,'8321c68a-9bbb-4f6c-b2f6-35ff20198183',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',1,'2025-12-07 07:16:32',NULL),('2025-12-06 07:16:32','2025-12-06 07:16:32','2025-12-06 07:16:32',1,76,'1ab61902-df0c-49e4-9438-5cdc6a8e3b75',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',1,'2025-12-07 07:16:32',NULL),('2025-12-06 07:18:28','2025-12-06 07:18:28','2025-12-06 07:18:28',1,77,'a86cbb7b-3cc2-4d4c-a734-71d5b98ef45c',29,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes',1,'2025-12-07 07:18:28',NULL),('2025-12-06 07:18:28','2025-12-06 07:18:28','2025-12-06 07:18:28',1,78,'b465032e-9da9-47a9-a2a7-2478fc5d5173',30,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes',1,'2025-12-07 07:18:28',NULL),('2025-12-06 07:18:28','2025-12-06 07:18:28','2025-12-06 07:18:28',1,79,'0d32bba0-a169-42cf-ba21-abcf4f5d1f5b',31,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes___DEFAULT__',1,'2025-12-07 07:18:28',NULL),('2025-12-06 07:18:28','2025-12-06 07:18:28','2025-12-06 07:18:28',1,80,'9cff6b0f-062b-4065-ac5c-a1089bcda333',32,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes___DEFAULT__',1,'2025-12-07 07:18:28',NULL),('2025-12-06 07:18:38','2025-12-06 07:18:40','2025-12-06 07:18:40',1,81,'acd5dc80-57ea-4264-82ff-26761b413d1a',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',-1,'2025-12-07 07:18:38',NULL),('2025-12-06 07:18:38','2025-12-06 07:18:40','2025-12-06 07:18:40',1,82,'441a8e19-d383-4f7e-85d6-5195c91786e9',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',-1,'2025-12-07 07:18:38',NULL),('2025-12-06 07:18:38','2025-12-06 07:18:40','2025-12-06 07:18:40',1,83,'22a11280-d87a-4a56-9ace-1c222a61839c',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',-1,'2025-12-07 07:18:38',NULL),('2025-12-06 07:18:38','2025-12-06 07:18:40','2025-12-06 07:18:40',1,84,'90f38609-0fa8-4232-a35e-6de95cf2913b',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',-1,'2025-12-07 07:18:38',NULL),('2025-12-06 07:18:43','2025-12-06 07:18:43','2025-12-06 07:18:43',1,85,'b7eb8086-1ed8-40c6-ba3f-868f55739a13',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',-1,'2025-12-07 07:18:43',NULL),('2025-12-06 07:18:43','2025-12-06 07:18:43','2025-12-06 07:18:43',1,86,'c0c43701-242a-4b25-9bea-6dcd7c6a7d41',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',-1,'2025-12-07 07:18:43',NULL),('2025-12-06 07:18:43','2025-12-06 07:18:43','2025-12-06 07:18:43',1,87,'3226951a-431d-49e8-88ad-8dc2bed4b6f2',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',-1,'2025-12-07 07:18:43',NULL),('2025-12-06 07:18:43','2025-12-06 07:18:43','2025-12-06 07:18:43',1,88,'2fda1caa-d37c-4591-a4ec-c45db50d3de1',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',-1,'2025-12-07 07:18:43',NULL),('2025-12-06 07:18:45','2025-12-06 07:18:45','2025-12-06 07:18:45',1,89,'ceb4d81d-8fd8-429a-b88c-524965e656fb',25,'8f938a037b8141cf9408cbf6f5cd081d','volumes',-1,'2025-12-07 07:18:45',NULL),('2025-12-06 07:18:45','2025-12-06 07:18:45','2025-12-06 07:18:45',1,90,'27f99956-35ca-45c8-97fd-dd4ed05f8fdc',26,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes',-1,'2025-12-07 07:18:45',NULL),('2025-12-06 07:18:45','2025-12-06 07:18:45','2025-12-06 07:18:45',1,91,'5e4baf96-82aa-46ce-a0c8-6ee98b4bc988',27,'8f938a037b8141cf9408cbf6f5cd081d','volumes___DEFAULT__',-1,'2025-12-07 07:18:45',NULL),('2025-12-06 07:18:45','2025-12-06 07:18:45','2025-12-06 07:18:45',1,92,'85f25a03-dfaa-4ab5-919f-fc82ba706873',28,'8f938a037b8141cf9408cbf6f5cd081d','gigabytes___DEFAULT__',-1,'2025-12-07 07:18:45',NULL),('2025-12-06 07:19:49','2025-12-06 07:19:49','2025-12-06 07:19:49',1,93,'78839b14-2278-420f-a1df-6199b301c1dc',29,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes',-1,'2025-12-07 07:19:49',NULL),('2025-12-06 07:19:49','2025-12-06 07:19:49','2025-12-06 07:19:49',1,94,'f0f7ec03-56ad-4ce7-b913-12752e7f23e9',30,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes',-1,'2025-12-07 07:19:49',NULL),('2025-12-06 07:19:49','2025-12-06 07:19:49','2025-12-06 07:19:49',1,95,'b48769fd-e715-4bca-bcab-043d208427f5',31,'6c6696bf390d4cc5bfd9852d5b264b5a','volumes___DEFAULT__',-1,'2025-12-07 07:19:49',NULL),('2025-12-06 07:19:49','2025-12-06 07:19:49','2025-12-06 07:19:49',1,96,'1f47fbf2-5cca-4b3e-bf22-7de09d40c70c',32,'6c6696bf390d4cc5bfd9852d5b264b5a','gigabytes___DEFAULT__',-1,'2025-12-07 07:19:49',NULL),('2025-12-06 07:21:32','2025-12-06 07:21:32','2025-12-06 07:21:32',1,97,'7e4eef35-7489-4dc5-9913-0d18f050aa54',33,'9536676f60844b6f802518771f02409f','volumes',1,'2025-12-07 07:21:32',NULL),('2025-12-06 07:21:32','2025-12-06 07:21:32','2025-12-06 07:21:32',1,98,'7d5c00d1-2f3d-4f39-930c-8ab76135e89a',34,'9536676f60844b6f802518771f02409f','gigabytes',1,'2025-12-07 07:21:32',NULL),('2025-12-06 07:21:32','2025-12-06 07:21:32','2025-12-06 07:21:32',1,99,'8a54c8bf-8b02-4354-bd1c-d56f85981697',35,'9536676f60844b6f802518771f02409f','volumes___DEFAULT__',1,'2025-12-07 07:21:32',NULL),('2025-12-06 07:21:32','2025-12-06 07:21:32','2025-12-06 07:21:32',1,100,'5456e79f-fed2-4c90-aca4-e1aa26e0b061',36,'9536676f60844b6f802518771f02409f','gigabytes___DEFAULT__',1,'2025-12-07 07:21:32',NULL),('2025-12-06 07:21:37','2025-12-06 07:21:37','2025-12-06 07:21:37',1,101,'a18beca9-dc04-4a0f-b7e0-a27c5da0f092',37,'c6d2f50c0db54315bfa96a24511dda90','volumes',1,'2025-12-07 07:21:37',NULL),('2025-12-06 07:21:37','2025-12-06 07:21:37','2025-12-06 07:21:37',1,102,'3e5a4f18-d8f5-4854-8638-6f2c75657e42',38,'c6d2f50c0db54315bfa96a24511dda90','gigabytes',1,'2025-12-07 07:21:37',NULL),('2025-12-06 07:21:37','2025-12-06 07:21:37','2025-12-06 07:21:37',1,103,'5928c0dc-54b3-4d8a-8919-e1e930166392',39,'c6d2f50c0db54315bfa96a24511dda90','volumes___DEFAULT__',1,'2025-12-07 07:21:37',NULL),('2025-12-06 07:21:37','2025-12-06 07:21:37','2025-12-06 07:21:37',1,104,'b2909e81-1cd7-4c75-bf0e-0462089c6560',40,'c6d2f50c0db54315bfa96a24511dda90','gigabytes___DEFAULT__',1,'2025-12-07 07:21:37',NULL),('2025-12-06 07:23:05','2025-12-06 07:23:05','2025-12-06 07:23:05',1,105,'e01696d4-98ba-42e8-9086-71b59c2bbc69',33,'9536676f60844b6f802518771f02409f','volumes',-1,'2025-12-07 07:23:05',NULL),('2025-12-06 07:23:05','2025-12-06 07:23:05','2025-12-06 07:23:05',1,106,'5788e939-b22b-42c4-8240-4167c870c661',34,'9536676f60844b6f802518771f02409f','gigabytes',-1,'2025-12-07 07:23:05',NULL),('2025-12-06 07:23:05','2025-12-06 07:23:05','2025-12-06 07:23:05',1,107,'6eca0bda-af7b-4438-8d6e-f37aeb7d2283',35,'9536676f60844b6f802518771f02409f','volumes___DEFAULT__',-1,'2025-12-07 07:23:05',NULL),('2025-12-06 07:23:05','2025-12-06 07:23:05','2025-12-06 07:23:05',1,108,'9a8acbe5-67d9-4a0e-9746-11f0ed82b11e',36,'9536676f60844b6f802518771f02409f','gigabytes___DEFAULT__',-1,'2025-12-07 07:23:05',NULL),('2025-12-06 07:24:54','2025-12-06 07:24:54','2025-12-06 07:24:54',1,109,'5bd66bc2-1774-4e22-aac2-def075651714',41,'001e2256cb8b430d93c1ff613010d199','volumes',1,'2025-12-07 07:24:54',NULL),('2025-12-06 07:24:54','2025-12-06 07:24:54','2025-12-06 07:24:54',1,110,'70a4dcaf-c00e-4bf9-a36d-6ed18688c88e',42,'001e2256cb8b430d93c1ff613010d199','gigabytes',1,'2025-12-07 07:24:54',NULL),('2025-12-06 07:24:54','2025-12-06 07:24:54','2025-12-06 07:24:54',1,111,'ca2622a2-7146-48a4-a02d-290d7f592025',43,'001e2256cb8b430d93c1ff613010d199','volumes___DEFAULT__',1,'2025-12-07 07:24:54',NULL),('2025-12-06 07:24:54','2025-12-06 07:24:54','2025-12-06 07:24:54',1,112,'9e425e46-8840-47e8-afbf-d7e2d6fe85fa',44,'001e2256cb8b430d93c1ff613010d199','gigabytes___DEFAULT__',1,'2025-12-07 07:24:54',NULL),('2025-12-06 07:27:31','2025-12-06 07:27:31','2025-12-06 07:27:31',1,113,'9473cc49-b38f-43d0-be5c-6b250ea50ef8',37,'c6d2f50c0db54315bfa96a24511dda90','volumes',-1,'2025-12-07 07:27:31',NULL),('2025-12-06 07:27:31','2025-12-06 07:27:31','2025-12-06 07:27:31',1,114,'759c58e4-af2a-4a81-917b-4d8d3393e66d',38,'c6d2f50c0db54315bfa96a24511dda90','gigabytes',-1,'2025-12-07 07:27:31',NULL),('2025-12-06 07:27:31','2025-12-06 07:27:31','2025-12-06 07:27:31',1,115,'492a7993-ddb0-4be2-a108-1012b95e217c',39,'c6d2f50c0db54315bfa96a24511dda90','volumes___DEFAULT__',-1,'2025-12-07 07:27:31',NULL),('2025-12-06 07:27:31','2025-12-06 07:27:31','2025-12-06 07:27:31',1,116,'34774379-f8ea-4b7c-ac3a-ff8f88548a3f',40,'c6d2f50c0db54315bfa96a24511dda90','gigabytes___DEFAULT__',-1,'2025-12-07 07:27:31',NULL),('2025-12-06 07:27:40','2025-12-06 07:27:40','2025-12-06 07:27:40',1,117,'9a1ec75a-16c5-4d9b-8f97-5c0b5d47a60a',41,'001e2256cb8b430d93c1ff613010d199','volumes',1,'2025-12-07 07:27:40',NULL),('2025-12-06 07:27:40','2025-12-06 07:27:40','2025-12-06 07:27:40',1,118,'c80994f9-54e9-4282-9afd-8f647a712a9e',42,'001e2256cb8b430d93c1ff613010d199','gigabytes',1,'2025-12-07 07:27:40',NULL),('2025-12-06 07:27:40','2025-12-06 07:27:40','2025-12-06 07:27:40',1,119,'62b52693-fee3-4128-b5a5-08e5355d6366',43,'001e2256cb8b430d93c1ff613010d199','volumes___DEFAULT__',1,'2025-12-07 07:27:40',NULL),('2025-12-06 07:27:40','2025-12-06 07:27:40','2025-12-06 07:27:40',1,120,'fd6a09df-ae97-44a6-8ce1-30af03d49cf0',44,'001e2256cb8b430d93c1ff613010d199','gigabytes___DEFAULT__',1,'2025-12-07 07:27:40',NULL),('2025-12-06 07:28:36','2025-12-06 07:28:36','2025-12-06 07:28:36',1,121,'1e662fc7-32b8-44b9-8743-0d2ba459edf0',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',1,'2025-12-07 07:28:36',NULL),('2025-12-06 07:28:36','2025-12-06 07:28:36','2025-12-06 07:28:36',1,122,'0d106252-7f6d-4fb8-8a52-2e78151872a9',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',1,'2025-12-07 07:28:36',NULL),('2025-12-06 07:28:36','2025-12-06 07:28:36','2025-12-06 07:28:36',1,123,'be97bd05-061e-4e90-bc00-d0c04255358b',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',1,'2025-12-07 07:28:36',NULL),('2025-12-06 07:28:36','2025-12-06 07:28:36','2025-12-06 07:28:36',1,124,'159ce580-d25c-4905-87e7-df10208ae9ff',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',1,'2025-12-07 07:28:36',NULL),('2025-12-06 07:29:30','2025-12-06 07:29:30','2025-12-06 07:29:30',1,125,'c5b2b850-f5f4-4e48-848d-654473bcdcec',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',1,'2025-12-07 07:29:30',NULL),('2025-12-06 07:29:30','2025-12-06 07:29:30','2025-12-06 07:29:30',1,126,'9ac32840-e88b-4369-97cb-e6cb7affe2b4',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',1,'2025-12-07 07:29:30',NULL),('2025-12-06 07:29:30','2025-12-06 07:29:30','2025-12-06 07:29:30',1,127,'cec46523-b884-4663-a183-385334d97b0f',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',1,'2025-12-07 07:29:30',NULL),('2025-12-06 07:29:30','2025-12-06 07:29:30','2025-12-06 07:29:30',1,128,'1e003684-06f8-4910-add5-975721068908',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',1,'2025-12-07 07:29:30',NULL),('2025-12-06 07:29:31','2025-12-06 07:29:32','2025-12-06 07:29:32',1,129,'f946a400-52a2-4c53-be0e-6930282bf61b',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',1,'2025-12-07 07:29:31',NULL),('2025-12-06 07:29:31','2025-12-06 07:29:32','2025-12-06 07:29:32',1,130,'88b0d32b-17d1-4682-b647-956126d16576',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',1,'2025-12-07 07:29:31',NULL),('2025-12-06 07:29:31','2025-12-06 07:29:32','2025-12-06 07:29:32',1,131,'3f5e1762-af89-4519-867e-2374fdc1be45',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',1,'2025-12-07 07:29:31',NULL),('2025-12-06 07:29:32','2025-12-06 07:29:32','2025-12-06 07:29:32',1,132,'7f884428-b9be-4169-a412-c01d06c69f40',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',1,'2025-12-07 07:29:31',NULL),('2025-12-06 07:30:20','2025-12-06 07:30:20','2025-12-06 07:30:20',1,133,'f9c4f61c-9212-442a-83d9-b36ac8c56861',41,'001e2256cb8b430d93c1ff613010d199','volumes',-1,'2025-12-07 07:30:20',NULL),('2025-12-06 07:30:20','2025-12-06 07:30:20','2025-12-06 07:30:20',1,134,'794bd0b1-adc7-49df-aee8-901db80f291e',42,'001e2256cb8b430d93c1ff613010d199','gigabytes',-1,'2025-12-07 07:30:20',NULL),('2025-12-06 07:30:20','2025-12-06 07:30:20','2025-12-06 07:30:20',1,135,'b31c0eeb-010b-4366-8c88-90dfaf891ace',43,'001e2256cb8b430d93c1ff613010d199','volumes___DEFAULT__',-1,'2025-12-07 07:30:20',NULL),('2025-12-06 07:30:20','2025-12-06 07:30:20','2025-12-06 07:30:20',1,136,'5ed4a74b-d161-4add-a2d9-45357decc061',44,'001e2256cb8b430d93c1ff613010d199','gigabytes___DEFAULT__',-1,'2025-12-07 07:30:20',NULL),('2025-12-06 07:30:26','2025-12-06 07:30:26','2025-12-06 07:30:26',1,137,'d950b162-ab3b-45c8-bfe6-b720e2ec5130',41,'001e2256cb8b430d93c1ff613010d199','volumes',-1,'2025-12-07 07:30:26',NULL),('2025-12-06 07:30:26','2025-12-06 07:30:26','2025-12-06 07:30:26',1,138,'32643f4c-80bb-460a-b388-ee4578a9a673',42,'001e2256cb8b430d93c1ff613010d199','gigabytes',-1,'2025-12-07 07:30:26',NULL),('2025-12-06 07:30:26','2025-12-06 07:30:26','2025-12-06 07:30:26',1,139,'f4a3bedd-8fcc-4079-a69d-3b79e19510f8',43,'001e2256cb8b430d93c1ff613010d199','volumes___DEFAULT__',-1,'2025-12-07 07:30:26',NULL),('2025-12-06 07:30:26','2025-12-06 07:30:26','2025-12-06 07:30:26',1,140,'b73bc3fd-1978-4915-9a26-fe760bb91f27',44,'001e2256cb8b430d93c1ff613010d199','gigabytes___DEFAULT__',-1,'2025-12-07 07:30:26',NULL),('2025-12-06 07:32:16','2025-12-06 07:32:16','2025-12-06 07:32:16',1,141,'a4002135-e7b4-40a9-bf12-503681a3ed4c',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',1,'2025-12-07 07:32:16',NULL),('2025-12-06 07:32:16','2025-12-06 07:32:16','2025-12-06 07:32:16',1,142,'56371f69-75cc-44e4-aff9-ebd3288e252d',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',1,'2025-12-07 07:32:16',NULL),('2025-12-06 07:32:16','2025-12-06 07:32:16','2025-12-06 07:32:16',1,143,'b492713d-df4f-4aa5-ae0e-1af4b3b9c4c5',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',1,'2025-12-07 07:32:16',NULL),('2025-12-06 07:32:16','2025-12-06 07:32:16','2025-12-06 07:32:16',1,144,'8d2d819e-e2bd-4701-96cd-2ddfd8107501',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',1,'2025-12-07 07:32:16',NULL),('2025-12-06 07:32:53','2025-12-06 07:32:54','2025-12-06 07:32:54',1,145,'e18a034f-224b-4938-85c2-a64f62984074',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',-1,'2025-12-07 07:32:53',NULL),('2025-12-06 07:32:53','2025-12-06 07:32:54','2025-12-06 07:32:54',1,146,'a00ee3c1-0207-44ce-bfde-763b6361d5d3',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',-1,'2025-12-07 07:32:53',NULL),('2025-12-06 07:32:53','2025-12-06 07:32:54','2025-12-06 07:32:54',1,147,'9f341ea4-5220-4445-bf80-b6d25fc774a8',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',-1,'2025-12-07 07:32:53',NULL),('2025-12-06 07:32:53','2025-12-06 07:32:54','2025-12-06 07:32:54',1,148,'c59316cb-78e0-45a7-9229-063699de4ec4',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',-1,'2025-12-07 07:32:53',NULL),('2025-12-06 07:33:04','2025-12-06 07:33:04','2025-12-06 07:33:04',1,149,'f2a409ea-e16b-495c-a39c-2e02e2863430',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',-1,'2025-12-07 07:33:04',NULL),('2025-12-06 07:33:04','2025-12-06 07:33:04','2025-12-06 07:33:04',1,150,'f5626be1-91da-432d-a293-51caa6d3dd16',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',-1,'2025-12-07 07:33:04',NULL),('2025-12-06 07:33:04','2025-12-06 07:33:04','2025-12-06 07:33:04',1,151,'62c714b7-d208-4a3a-8812-eaf3116a195d',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',-1,'2025-12-07 07:33:04',NULL),('2025-12-06 07:33:04','2025-12-06 07:33:04','2025-12-06 07:33:04',1,152,'2e4c1dfe-3bf4-4c7c-96cc-f4a660cb37de',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',-1,'2025-12-07 07:33:04',NULL),('2025-12-06 07:33:10','2025-12-06 07:33:10','2025-12-06 07:33:10',1,153,'7d507e98-7e5f-406f-a0f3-a4c700fe06ba',45,'1a5dd5f9ca5747618b386c87a40ede88','volumes',-1,'2025-12-07 07:33:10',NULL),('2025-12-06 07:33:10','2025-12-06 07:33:10','2025-12-06 07:33:10',1,154,'7cd20589-43d7-4a00-9151-ca4ea03fcb2b',46,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes',-1,'2025-12-07 07:33:10',NULL),('2025-12-06 07:33:10','2025-12-06 07:33:10','2025-12-06 07:33:10',1,155,'e7559c5f-fe04-4376-b442-4296007d8003',47,'1a5dd5f9ca5747618b386c87a40ede88','volumes___DEFAULT__',-1,'2025-12-07 07:33:10',NULL),('2025-12-06 07:33:10','2025-12-06 07:33:10','2025-12-06 07:33:10',1,156,'b5ec07aa-73c8-4155-9896-ca35b235954e',48,'1a5dd5f9ca5747618b386c87a40ede88','gigabytes___DEFAULT__',-1,'2025-12-07 07:33:10',NULL),('2025-12-06 07:34:04','2025-12-06 07:34:04','2025-12-06 07:34:04',1,157,'c3e27763-639b-473a-84a0-d9c18fa2ff2e',53,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes',1,'2025-12-07 07:34:04',NULL),('2025-12-06 07:34:04','2025-12-06 07:34:04','2025-12-06 07:34:04',1,158,'41ca6877-46d3-4fea-93ec-d9fe686f4e76',54,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes',1,'2025-12-07 07:34:04',NULL),('2025-12-06 07:34:04','2025-12-06 07:34:04','2025-12-06 07:34:04',1,159,'a54bcc8f-89fc-4cfb-903e-c233f406fe3b',55,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes___DEFAULT__',1,'2025-12-07 07:34:04',NULL),('2025-12-06 07:34:04','2025-12-06 07:34:04','2025-12-06 07:34:04',1,160,'95e79852-2f35-4ecf-a047-2eb2c45b3da7',56,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes___DEFAULT__',1,'2025-12-07 07:34:04',NULL),('2025-12-06 07:34:28','2025-12-06 07:34:28','2025-12-06 07:34:28',1,161,'4b4c9871-1b30-4bc4-8d5c-e29eb57f15f3',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',1,'2025-12-07 07:34:28',NULL),('2025-12-06 07:34:28','2025-12-06 07:34:28','2025-12-06 07:34:28',1,162,'0d2a24ed-f4c8-4596-9fbe-aec9d250a6d5',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',1,'2025-12-07 07:34:28',NULL),('2025-12-06 07:34:28','2025-12-06 07:34:28','2025-12-06 07:34:28',1,163,'8ff7afe8-e77e-4fc6-8188-24b129459618',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',1,'2025-12-07 07:34:28',NULL),('2025-12-06 07:34:28','2025-12-06 07:34:28','2025-12-06 07:34:28',1,164,'4318085d-cc3f-4413-9dcd-de39e9a59a74',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',1,'2025-12-07 07:34:28',NULL),('2025-12-06 07:35:49','2025-12-06 07:35:49','2025-12-06 07:35:49',1,165,'c7cc7e8d-1bb7-4e4b-9db9-c3b83ff47ca4',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',1,'2025-12-07 07:35:49',NULL),('2025-12-06 07:35:49','2025-12-06 07:35:49','2025-12-06 07:35:49',1,166,'adf01e27-dc0b-414f-ab35-64af3864cf44',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',1,'2025-12-07 07:35:49',NULL),('2025-12-06 07:35:49','2025-12-06 07:35:49','2025-12-06 07:35:49',1,167,'13b0c22b-49c5-43a0-896d-1f281455cfa2',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',1,'2025-12-07 07:35:49',NULL),('2025-12-06 07:35:49','2025-12-06 07:35:49','2025-12-06 07:35:49',1,168,'719e5904-0068-4b8e-b1b5-25da5b1f5bb6',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',1,'2025-12-07 07:35:49',NULL),('2025-12-06 07:36:29','2025-12-06 07:36:29','2025-12-06 07:36:29',1,169,'1e2a3466-f407-413d-b985-2b34e8a820d8',57,'21cd37bffa864aaebe5c734ba468f466','volumes',1,'2025-12-07 07:36:29',NULL),('2025-12-06 07:36:29','2025-12-06 07:36:29','2025-12-06 07:36:29',1,170,'c8f529f3-1fcf-4e3c-8994-3b899c922fe3',58,'21cd37bffa864aaebe5c734ba468f466','gigabytes',1,'2025-12-07 07:36:29',NULL),('2025-12-06 07:36:29','2025-12-06 07:36:29','2025-12-06 07:36:29',1,171,'a3c6f0bf-44e9-4925-9876-452959172fb6',59,'21cd37bffa864aaebe5c734ba468f466','volumes___DEFAULT__',1,'2025-12-07 07:36:29',NULL),('2025-12-06 07:36:29','2025-12-06 07:36:29','2025-12-06 07:36:29',1,172,'4d8fd62c-46fc-4064-af27-9f3e65dbbf18',60,'21cd37bffa864aaebe5c734ba468f466','gigabytes___DEFAULT__',1,'2025-12-07 07:36:29',NULL),('2025-12-06 07:36:56','2025-12-06 07:36:57','2025-12-06 07:36:57',1,173,'80265c4e-2a04-43d2-91e7-6e5171ff4c77',53,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes',1,'2025-12-07 07:36:56',NULL),('2025-12-06 07:36:56','2025-12-06 07:36:57','2025-12-06 07:36:57',1,174,'5fe4c480-2d38-42b1-ab91-997acead73be',54,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes',1,'2025-12-07 07:36:56',NULL),('2025-12-06 07:36:56','2025-12-06 07:36:57','2025-12-06 07:36:57',1,175,'bb715410-23d2-4ced-a494-517e04d764cf',55,'17cdfa63c4424ec7a0eb4bb3d7372c14','volumes___DEFAULT__',1,'2025-12-07 07:36:56',NULL),('2025-12-06 07:36:56','2025-12-06 07:36:57','2025-12-06 07:36:57',1,176,'77fa2cb2-f2b9-4f2d-84a9-8c00f0b571bf',56,'17cdfa63c4424ec7a0eb4bb3d7372c14','gigabytes___DEFAULT__',1,'2025-12-07 07:36:56',NULL),('2025-12-06 07:37:42','2025-12-06 07:37:42','2025-12-06 07:37:42',1,177,'a9f64274-df8b-408e-84c3-b73e14e1d418',61,'b10aa03d68eb4d4799d53538521cc364','volumes',1,'2025-12-07 07:37:42',NULL),('2025-12-06 07:37:42','2025-12-06 07:37:42','2025-12-06 07:37:42',1,178,'b1f7d60a-7f02-4b22-a518-a2de680d5371',62,'b10aa03d68eb4d4799d53538521cc364','gigabytes',1,'2025-12-07 07:37:42',NULL),('2025-12-06 07:37:42','2025-12-06 07:37:42','2025-12-06 07:37:42',1,179,'c9681856-8807-4a42-8399-e1f6cbbbafa2',63,'b10aa03d68eb4d4799d53538521cc364','volumes___DEFAULT__',1,'2025-12-07 07:37:42',NULL),('2025-12-06 07:37:42','2025-12-06 07:37:42','2025-12-06 07:37:42',1,180,'6efa5451-5f8c-443c-b476-f7eddcf164bc',64,'b10aa03d68eb4d4799d53538521cc364','gigabytes___DEFAULT__',1,'2025-12-07 07:37:42',NULL),('2025-12-06 07:38:03','2025-12-06 07:38:03','2025-12-06 07:38:03',1,181,'837209e2-18c3-4749-b8be-e12cdb06b5a3',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',1,'2025-12-07 07:38:03',NULL),('2025-12-06 07:38:03','2025-12-06 07:38:03','2025-12-06 07:38:03',1,182,'9d28fbaa-2d78-406a-83c8-6813d19b3312',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',1,'2025-12-07 07:38:03',NULL),('2025-12-06 07:38:03','2025-12-06 07:38:03','2025-12-06 07:38:03',1,183,'313332a0-1839-48a6-bf2d-f750759a9cf2',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',1,'2025-12-07 07:38:03',NULL),('2025-12-06 07:38:03','2025-12-06 07:38:03','2025-12-06 07:38:03',1,184,'f8fe93f3-774a-45ab-8553-bd281a081e68',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',1,'2025-12-07 07:38:03',NULL),('2025-12-06 07:39:35','2025-12-06 07:39:35','2025-12-06 07:39:35',1,185,'6002677e-f2a8-48de-ab8f-b346b4b175e9',57,'21cd37bffa864aaebe5c734ba468f466','volumes',-1,'2025-12-07 07:39:34',NULL),('2025-12-06 07:39:35','2025-12-06 07:39:35','2025-12-06 07:39:35',1,186,'b5a24eb0-72d9-43b9-9ea8-3bcc4b0c2173',58,'21cd37bffa864aaebe5c734ba468f466','gigabytes',-1,'2025-12-07 07:39:34',NULL),('2025-12-06 07:39:35','2025-12-06 07:39:35','2025-12-06 07:39:35',1,187,'81d97ce5-3bdd-497e-916c-4dc58473fb67',59,'21cd37bffa864aaebe5c734ba468f466','volumes___DEFAULT__',-1,'2025-12-07 07:39:34',NULL),('2025-12-06 07:39:35','2025-12-06 07:39:35','2025-12-06 07:39:35',1,188,'6277251c-7ae0-417a-b5cc-2f6370c54fc4',60,'21cd37bffa864aaebe5c734ba468f466','gigabytes___DEFAULT__',-1,'2025-12-07 07:39:34',NULL),('2025-12-06 07:39:37','2025-12-06 07:39:37','2025-12-06 07:39:37',1,189,'97d97c0a-34c5-4236-95ab-2eb1b4467416',65,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots',1,'2025-12-07 07:39:37',NULL),('2025-12-06 07:39:37','2025-12-06 07:39:37','2025-12-06 07:39:37',1,190,'f2fb0d78-35da-4f14-969b-adc9d15d9c81',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',1,'2025-12-07 07:39:37',NULL),('2025-12-06 07:39:37','2025-12-06 07:39:37','2025-12-06 07:39:37',1,191,'fcf761de-f10e-4db2-a356-c619bb74347b',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',1,'2025-12-07 07:39:37',NULL),('2025-12-06 07:39:37','2025-12-06 07:39:37','2025-12-06 07:39:37',1,192,'5b8d929e-f2d0-4dc4-ae56-b7297cc56129',66,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots_multiattach',1,'2025-12-07 07:39:37',NULL),('2025-12-06 07:39:51','2025-12-06 07:39:51','2025-12-06 07:39:51',1,193,'3d5a75c9-db5e-4f28-983f-52bb1b83dc51',65,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots',-1,'2025-12-07 07:39:51',NULL),('2025-12-06 07:39:51','2025-12-06 07:39:51','2025-12-06 07:39:51',1,194,'9a6cd718-5c05-4d3c-ad15-752385cb40a7',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',-1,'2025-12-07 07:39:51',NULL),('2025-12-06 07:39:51','2025-12-06 07:39:51','2025-12-06 07:39:51',1,195,'38fafd5a-62fe-4d82-a10b-556e9cee6080',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',-1,'2025-12-07 07:39:51',NULL),('2025-12-06 07:39:51','2025-12-06 07:39:51','2025-12-06 07:39:51',1,196,'0d4f0581-28b8-41c9-ab26-514ec179cf29',66,'833f4cf9f5a64b2ab94c3bf330353a31','snapshots_multiattach',-1,'2025-12-07 07:39:51',NULL),('2025-12-06 07:39:52','2025-12-06 07:39:52','2025-12-06 07:39:52',1,197,'2ed9638b-143a-49c3-a412-05715e158596',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',-1,'2025-12-07 07:39:52',NULL),('2025-12-06 07:39:52','2025-12-06 07:39:52','2025-12-06 07:39:52',1,198,'f88eeb90-f96a-4b4c-b58d-5204a9f5bd61',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',-1,'2025-12-07 07:39:52',NULL),('2025-12-06 07:39:52','2025-12-06 07:39:52','2025-12-06 07:39:52',1,199,'5473805c-7105-42db-ae11-ee7625f6f6ea',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',-1,'2025-12-07 07:39:52',NULL),('2025-12-06 07:39:52','2025-12-06 07:39:52','2025-12-06 07:39:52',1,200,'d2aa4431-8429-44b5-aec1-164739d5e122',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',-1,'2025-12-07 07:39:52',NULL),('2025-12-06 07:39:56','2025-12-06 07:39:57','2025-12-06 07:39:57',1,201,'6f156c55-d86c-4bbb-91bd-6c9c8a1a1be9',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',-1,'2025-12-07 07:39:56',NULL),('2025-12-06 07:39:56','2025-12-06 07:39:57','2025-12-06 07:39:57',1,202,'f2510017-ba35-44b8-b866-5f6bc751eb6e',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',-1,'2025-12-07 07:39:56',NULL),('2025-12-06 07:39:56','2025-12-06 07:39:57','2025-12-06 07:39:57',1,203,'0cdace07-8d9d-4f25-b0ef-698d6379e120',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',-1,'2025-12-07 07:39:56',NULL),('2025-12-06 07:39:56','2025-12-06 07:39:57','2025-12-06 07:39:57',1,204,'3df4c0b8-f817-4ee3-b630-e80872d5aaa9',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',-1,'2025-12-07 07:39:56',NULL),('2025-12-06 07:40:23','2025-12-06 07:40:23','2025-12-06 07:40:23',1,205,'60051a46-d6db-4aae-b74e-66670c92ac10',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',-1,'2025-12-07 07:40:23',NULL),('2025-12-06 07:40:23','2025-12-06 07:40:23','2025-12-06 07:40:23',1,206,'08f50b9d-c895-47db-8779-3fb6daf084e4',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',-1,'2025-12-07 07:40:23',NULL),('2025-12-06 07:40:23','2025-12-06 07:40:23','2025-12-06 07:40:23',1,207,'beb765db-8c03-4d0c-ba3b-5d79bd626a54',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',-1,'2025-12-07 07:40:23',NULL),('2025-12-06 07:40:23','2025-12-06 07:40:23','2025-12-06 07:40:23',1,208,'5bc6ad0c-da64-4fb4-b028-713f8e41e282',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',-1,'2025-12-07 07:40:23',NULL),('2025-12-06 07:40:47','2025-12-06 07:40:47','2025-12-06 07:40:47',1,209,'8434091f-aeef-468a-a1b5-5c31fa8d9ee1',49,'833f4cf9f5a64b2ab94c3bf330353a31','volumes',-1,'2025-12-07 07:40:47',NULL),('2025-12-06 07:40:47','2025-12-06 07:40:47','2025-12-06 07:40:47',1,210,'75ddf519-c15c-4f6d-bb49-543f508cb9d9',50,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes',-1,'2025-12-07 07:40:47',NULL),('2025-12-06 07:40:47','2025-12-06 07:40:47','2025-12-06 07:40:47',1,211,'1f1aec3a-5ae3-4b1c-aa98-0862a17ac533',51,'833f4cf9f5a64b2ab94c3bf330353a31','volumes_multiattach',-1,'2025-12-07 07:40:47',NULL),('2025-12-06 07:40:47','2025-12-06 07:40:47','2025-12-06 07:40:47',1,212,'926eb215-4c79-47c6-b081-7ce2fef5847a',52,'833f4cf9f5a64b2ab94c3bf330353a31','gigabytes_multiattach',-1,'2025-12-07 07:40:47',NULL),('2025-12-06 07:42:14','2025-12-06 07:42:14','2025-12-06 07:42:14',1,213,'5ff16dd8-d54e-4bea-80a5-f8bb596b9f78',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',1,'2025-12-07 07:42:14',NULL),('2025-12-06 07:42:14','2025-12-06 07:42:14','2025-12-06 07:42:14',1,214,'4ed3d776-24b0-49e3-9b11-e3f689add74f',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',1,'2025-12-07 07:42:14',NULL),('2025-12-06 07:42:14','2025-12-06 07:42:14','2025-12-06 07:42:14',1,215,'6dba8144-6e4c-4244-8417-d0e34e39a0dc',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',1,'2025-12-07 07:42:14',NULL),('2025-12-06 07:42:14','2025-12-06 07:42:14','2025-12-06 07:42:14',1,216,'60b7aad1-feac-4c7a-a54b-8627c3a7769f',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',1,'2025-12-07 07:42:14',NULL),('2025-12-06 07:42:42','2025-12-06 07:42:42','2025-12-06 07:42:42',1,217,'883d09db-e52b-4a76-ae2b-d6e726bef4ce',61,'b10aa03d68eb4d4799d53538521cc364','volumes',-1,'2025-12-07 07:42:42',NULL),('2025-12-06 07:42:42','2025-12-06 07:42:42','2025-12-06 07:42:42',1,218,'5d18c9ea-4f0a-4537-ac17-a6736db8a103',62,'b10aa03d68eb4d4799d53538521cc364','gigabytes',-1,'2025-12-07 07:42:42',NULL),('2025-12-06 07:42:42','2025-12-06 07:42:42','2025-12-06 07:42:42',1,219,'f3f09ebe-ccb3-4845-8b20-a20c6f7715d6',63,'b10aa03d68eb4d4799d53538521cc364','volumes___DEFAULT__',-1,'2025-12-07 07:42:42',NULL),('2025-12-06 07:42:42','2025-12-06 07:42:42','2025-12-06 07:42:42',1,220,'df3ebb9e-6eb2-40a6-b238-7eabb079d11b',64,'b10aa03d68eb4d4799d53538521cc364','gigabytes___DEFAULT__',-1,'2025-12-07 07:42:42',NULL),('2025-12-06 07:44:26','2025-12-06 07:44:27','2025-12-06 07:44:27',1,221,'8df01897-09da-4bf8-86a3-6a53c86123eb',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',1,'2025-12-07 07:44:26',NULL),('2025-12-06 07:44:26','2025-12-06 07:44:27','2025-12-06 07:44:27',1,222,'a5c7031f-cf28-42f2-b6ed-80c610e269ad',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',1,'2025-12-07 07:44:26',NULL),('2025-12-06 07:44:26','2025-12-06 07:44:27','2025-12-06 07:44:27',1,223,'a84e3ba8-e6df-41d2-9c50-49c68f25b9df',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',1,'2025-12-07 07:44:26',NULL),('2025-12-06 07:44:26','2025-12-06 07:44:27','2025-12-06 07:44:27',1,224,'386436be-ae8d-4c69-866e-02be08589bad',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',1,'2025-12-07 07:44:26',NULL),('2025-12-06 07:44:50','2025-12-06 07:44:50','2025-12-06 07:44:50',1,225,'5d7f3eb3-2f7b-429c-8ddf-aa98d9fafe21',71,'4ec9294f6d4b4f44a72414374d646a4a','volumes',1,'2025-12-07 07:44:50',NULL),('2025-12-06 07:44:50','2025-12-06 07:44:50','2025-12-06 07:44:50',1,226,'3550fbb9-5342-4184-b28c-76fbf2e70a0e',72,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes',1,'2025-12-07 07:44:50',NULL),('2025-12-06 07:44:50','2025-12-06 07:44:50','2025-12-06 07:44:50',1,227,'099fe0cf-412d-4bfe-b828-0010e970a577',73,'4ec9294f6d4b4f44a72414374d646a4a','volumes___DEFAULT__',1,'2025-12-07 07:44:50',NULL),('2025-12-06 07:44:50','2025-12-06 07:44:50','2025-12-06 07:44:50',1,228,'5d8d48e2-fbf3-4b7a-abc7-9ac20aa5c7e8',74,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes___DEFAULT__',1,'2025-12-07 07:44:50',NULL),('2025-12-06 07:44:55','2025-12-06 07:44:55','2025-12-06 07:44:55',1,229,'54aa553d-f153-4ddd-b295-5ec007fea18a',71,'4ec9294f6d4b4f44a72414374d646a4a','volumes',1,'2025-12-07 07:44:55',NULL),('2025-12-06 07:44:55','2025-12-06 07:44:55','2025-12-06 07:44:55',1,230,'72e2588f-867a-493c-91e1-d62221ec4b9b',72,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes',1,'2025-12-07 07:44:55',NULL),('2025-12-06 07:44:55','2025-12-06 07:44:55','2025-12-06 07:44:55',1,231,'fa837c3d-01d9-408b-9acb-9e6a8f67e760',73,'4ec9294f6d4b4f44a72414374d646a4a','volumes___DEFAULT__',1,'2025-12-07 07:44:55',NULL),('2025-12-06 07:44:55','2025-12-06 07:44:55','2025-12-06 07:44:55',1,232,'8f1bf520-eab0-47bd-aa66-26bba641c5f2',74,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes___DEFAULT__',1,'2025-12-07 07:44:55',NULL),('2025-12-06 07:45:35','2025-12-06 07:45:35','2025-12-06 07:45:35',1,233,'b19779fe-0368-4ff5-8372-5d07c8ccbd86',75,'00a24842329842059aee8ff6e53c0c00','volumes',1,'2025-12-07 07:45:35',NULL),('2025-12-06 07:45:35','2025-12-06 07:45:35','2025-12-06 07:45:35',1,234,'e7a9dc38-120d-45dd-b6ce-9fa593622e32',76,'00a24842329842059aee8ff6e53c0c00','gigabytes',1,'2025-12-07 07:45:35',NULL),('2025-12-06 07:45:35','2025-12-06 07:45:35','2025-12-06 07:45:35',1,235,'365e57a5-9511-4bfe-bd67-171cd654b688',77,'00a24842329842059aee8ff6e53c0c00','volumes___DEFAULT__',1,'2025-12-07 07:45:35',NULL),('2025-12-06 07:45:35','2025-12-06 07:45:35','2025-12-06 07:45:35',1,236,'819d6b5e-9832-4019-b645-42cdc6c3bdfa',78,'00a24842329842059aee8ff6e53c0c00','gigabytes___DEFAULT__',1,'2025-12-07 07:45:35',NULL),('2025-12-06 07:45:37','2025-12-06 07:45:37','2025-12-06 07:45:37',1,237,'17beaf82-4ecc-4b4a-8f64-b79140001d55',75,'00a24842329842059aee8ff6e53c0c00','volumes',-1,'2025-12-07 07:45:37',NULL),('2025-12-06 07:45:37','2025-12-06 07:45:37','2025-12-06 07:45:37',1,238,'be06d76c-26a4-449b-b9ff-7879c833f018',76,'00a24842329842059aee8ff6e53c0c00','gigabytes',-1,'2025-12-07 07:45:37',NULL),('2025-12-06 07:45:37','2025-12-06 07:45:37','2025-12-06 07:45:37',1,239,'c92a5428-061f-42e8-9bd3-e0687f779df5',77,'00a24842329842059aee8ff6e53c0c00','volumes___DEFAULT__',-1,'2025-12-07 07:45:37',NULL),('2025-12-06 07:45:37','2025-12-06 07:45:37','2025-12-06 07:45:37',1,240,'65525eae-3dc8-4546-ae53-3923e630c8f7',78,'00a24842329842059aee8ff6e53c0c00','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:37',NULL),('2025-12-06 07:45:39','2025-12-06 07:45:39','2025-12-06 07:45:39',1,241,'eb3a1171-972f-4741-92a8-009bc723a241',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',1,'2025-12-07 07:45:39',NULL),('2025-12-06 07:45:39','2025-12-06 07:45:39','2025-12-06 07:45:39',1,242,'5a773612-22b6-4e9c-b8ac-df9512fa2e85',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',1,'2025-12-07 07:45:39',NULL),('2025-12-06 07:45:39','2025-12-06 07:45:39','2025-12-06 07:45:39',1,243,'b7643ec1-4a04-415b-8b16-2060c84e9e02',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',1,'2025-12-07 07:45:39',NULL),('2025-12-06 07:45:39','2025-12-06 07:45:39','2025-12-06 07:45:39',1,244,'13d02a01-b676-4818-b3cd-21f964d1fea2',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',1,'2025-12-07 07:45:39',NULL),('2025-12-06 07:45:42','2025-12-06 07:45:43','2025-12-06 07:45:43',1,245,'d950d697-e8ac-45db-b4d4-17344dd7372b',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',1,'2025-12-07 07:45:42',NULL),('2025-12-06 07:45:42','2025-12-06 07:45:43','2025-12-06 07:45:43',1,246,'dfc4024c-d179-4d66-899b-c9babf319dd7',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',1,'2025-12-07 07:45:42',NULL),('2025-12-06 07:45:42','2025-12-06 07:45:43','2025-12-06 07:45:43',1,247,'bbe7468f-dfad-4901-bb72-151884bcfaeb',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',1,'2025-12-07 07:45:42',NULL),('2025-12-06 07:45:42','2025-12-06 07:45:43','2025-12-06 07:45:43',1,248,'6f87cd18-9f08-4108-9130-46394d6822e0',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',1,'2025-12-07 07:45:42',NULL),('2025-12-06 07:45:45','2025-12-06 07:45:45','2025-12-06 07:45:45',1,249,'2fa97d46-dea9-4287-9e8f-19f75218a548',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',1,'2025-12-07 07:45:45',NULL),('2025-12-06 07:45:45','2025-12-06 07:45:45','2025-12-06 07:45:45',1,250,'e0c6b5c0-535e-4d43-8a5c-8e81417bfc2b',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',1,'2025-12-07 07:45:45',NULL),('2025-12-06 07:45:45','2025-12-06 07:45:45','2025-12-06 07:45:45',1,251,'a3bdbc9e-7597-40da-9e23-84cf0987da8d',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',1,'2025-12-07 07:45:45',NULL),('2025-12-06 07:45:45','2025-12-06 07:45:45','2025-12-06 07:45:45',1,252,'e2da883c-4329-4ea8-8f8e-dbbfd26928a0',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',1,'2025-12-07 07:45:45',NULL),('2025-12-06 07:45:47','2025-12-06 07:45:47','2025-12-06 07:45:47',1,253,'8b5c26c1-e494-40df-b21d-39e6177dc9f3',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',1,'2025-12-07 07:45:47',NULL),('2025-12-06 07:45:47','2025-12-06 07:45:47','2025-12-06 07:45:47',1,254,'710417de-f8b0-4bdf-9ad3-47e386c907a4',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',1,'2025-12-07 07:45:47',NULL),('2025-12-06 07:45:47','2025-12-06 07:45:47','2025-12-06 07:45:47',1,255,'522328f9-04cb-420a-b9c2-af3178fd6cd0',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',1,'2025-12-07 07:45:47',NULL),('2025-12-06 07:45:47','2025-12-06 07:45:47','2025-12-06 07:45:47',1,256,'e1e4b38b-801c-4189-9bca-d36749bc78b3',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',1,'2025-12-07 07:45:47',NULL),('2025-12-06 07:45:53','2025-12-06 07:45:53','2025-12-06 07:45:53',1,257,'946dd54c-c909-487c-9829-9e7c610cb2d9',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',-1,'2025-12-07 07:45:53',NULL),('2025-12-06 07:45:53','2025-12-06 07:45:53','2025-12-06 07:45:53',1,258,'687c3ef2-ecf2-4649-8f4c-ed62e82a6b9f',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',-1,'2025-12-07 07:45:53',NULL),('2025-12-06 07:45:53','2025-12-06 07:45:53','2025-12-06 07:45:53',1,259,'d525e8ad-ec84-4ae5-97af-995267b68f7e',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',-1,'2025-12-07 07:45:53',NULL),('2025-12-06 07:45:53','2025-12-06 07:45:53','2025-12-06 07:45:53',1,260,'0e881702-3d9e-4a39-af28-662f60171beb',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:53',NULL),('2025-12-06 07:45:54','2025-12-06 07:45:54','2025-12-06 07:45:54',1,261,'e31150e6-591d-4140-8e03-e35be7c21011',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',-1,'2025-12-07 07:45:54',NULL),('2025-12-06 07:45:54','2025-12-06 07:45:54','2025-12-06 07:45:54',1,262,'8d5e82d3-bffb-4802-ada3-0d34823d5131',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',-1,'2025-12-07 07:45:54',NULL),('2025-12-06 07:45:54','2025-12-06 07:45:54','2025-12-06 07:45:54',1,263,'44977903-cc91-4dfe-9f99-9d2689532cad',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',-1,'2025-12-07 07:45:54',NULL),('2025-12-06 07:45:54','2025-12-06 07:45:54','2025-12-06 07:45:54',1,264,'95cbf4ce-2c9f-4dd2-a64a-21663d6ab65d',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:54',NULL),('2025-12-06 07:45:55','2025-12-06 07:45:55','2025-12-06 07:45:55',1,265,'c2f23e38-0b9c-489b-8fbb-c9578a210e77',83,'f44ecb8bdc7e4692a299e29603301124','volumes',1,'2025-12-07 07:45:55',NULL),('2025-12-06 07:45:55','2025-12-06 07:45:55','2025-12-06 07:45:55',1,266,'f88c1eb3-522e-42f3-a852-0f8dd211c191',84,'f44ecb8bdc7e4692a299e29603301124','gigabytes',1,'2025-12-07 07:45:55',NULL),('2025-12-06 07:45:55','2025-12-06 07:45:55','2025-12-06 07:45:55',1,267,'1e683495-4df9-422d-a6be-acbc1fe8a3bc',85,'f44ecb8bdc7e4692a299e29603301124','volumes___DEFAULT__',1,'2025-12-07 07:45:55',NULL),('2025-12-06 07:45:55','2025-12-06 07:45:55','2025-12-06 07:45:55',1,268,'bbb4bd89-987b-43d5-a220-6128d0886077',86,'f44ecb8bdc7e4692a299e29603301124','gigabytes___DEFAULT__',1,'2025-12-07 07:45:55',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,269,'b54647e9-ffab-4f41-8f78-13bee403787c',79,'5dcd2d068ff04070b59e12a2cd84f89c','volumes',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,270,'6226e8d4-8425-46d5-9955-3b3a1a4da952',80,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,271,'ee723cf5-1dd8-4a3f-b275-2fbb55492055',81,'5dcd2d068ff04070b59e12a2cd84f89c','volumes___DEFAULT__',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,272,'da5cf9e9-eaa7-415e-a046-20f6ac3b4eba',82,'5dcd2d068ff04070b59e12a2cd84f89c','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,273,'6a0845b3-c45d-434a-9408-ca9ba67b8890',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,274,'85a2dcf2-8e40-4e71-8995-a12accaa5485',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,275,'71f6f4d1-e502-4a81-a307-706308309c6b',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:58','2025-12-06 07:45:58','2025-12-06 07:45:58',1,276,'15ac1ff7-031d-44f8-999b-976ecbe6de0f',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:58',NULL),('2025-12-06 07:45:59','2025-12-06 07:45:59','2025-12-06 07:45:59',1,277,'d8599884-8b8d-46e2-8528-d00a12a6382c',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',-1,'2025-12-07 07:45:59',NULL),('2025-12-06 07:45:59','2025-12-06 07:46:00','2025-12-06 07:46:00',1,278,'1b97c1ee-c9e8-427c-8fd1-bbb014aa3759',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',-1,'2025-12-07 07:45:59',NULL),('2025-12-06 07:45:59','2025-12-06 07:46:00','2025-12-06 07:46:00',1,279,'8530cd36-bf7d-4452-a0d3-63a98d9638d1',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',-1,'2025-12-07 07:45:59',NULL),('2025-12-06 07:45:59','2025-12-06 07:46:00','2025-12-06 07:46:00',1,280,'6ad732f2-0cc7-4793-b001-8f0a9a9e0c34',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',-1,'2025-12-07 07:45:59',NULL),('2025-12-06 07:46:03','2025-12-06 07:46:03','2025-12-06 07:46:03',1,281,'c238a41a-e4cc-4212-928b-d0046a323872',67,'741dc47f9ced423cbd99fd6f9d32904f','volumes',-1,'2025-12-07 07:46:03',NULL),('2025-12-06 07:46:03','2025-12-06 07:46:03','2025-12-06 07:46:03',1,282,'e788aaf5-120a-4ce3-8491-23aeee427da0',68,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes',-1,'2025-12-07 07:46:03',NULL),('2025-12-06 07:46:03','2025-12-06 07:46:03','2025-12-06 07:46:03',1,283,'02718497-cb0a-40e6-9fe0-c635e68a05bd',69,'741dc47f9ced423cbd99fd6f9d32904f','volumes___DEFAULT__',-1,'2025-12-07 07:46:03',NULL),('2025-12-06 07:46:03','2025-12-06 07:46:03','2025-12-06 07:46:03',1,284,'1289dade-4b6e-4088-a9ed-6df4ed1d3262',70,'741dc47f9ced423cbd99fd6f9d32904f','gigabytes___DEFAULT__',-1,'2025-12-07 07:46:03',NULL),('2025-12-06 07:46:13','2025-12-06 07:46:13','2025-12-06 07:46:13',1,285,'f3a0dbfd-4a66-440b-afcf-904b664d0557',87,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes',1,'2025-12-07 07:46:13',NULL),('2025-12-06 07:46:13','2025-12-06 07:46:13','2025-12-06 07:46:13',1,286,'e22c6bbb-2039-4525-96da-4c61f55f984f',88,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes',1,'2025-12-07 07:46:13',NULL),('2025-12-06 07:46:13','2025-12-06 07:46:13','2025-12-06 07:46:13',1,287,'5ab3a30d-8ce5-4fce-8706-ad451704e820',89,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes___DEFAULT__',1,'2025-12-07 07:46:13',NULL),('2025-12-06 07:46:13','2025-12-06 07:46:13','2025-12-06 07:46:13',1,288,'be822faf-718c-4488-b4e9-4c2d7138bdd3',90,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes___DEFAULT__',1,'2025-12-07 07:46:13',NULL),('2025-12-06 07:46:16','2025-12-06 07:46:16','2025-12-06 07:46:16',1,289,'6020b350-374e-4b99-a48a-15d404b657fd',91,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots',1,'2025-12-07 07:46:16',NULL),('2025-12-06 07:46:16','2025-12-06 07:46:16','2025-12-06 07:46:16',1,290,'9da69707-8b0d-4e75-b18e-78e5e580379f',88,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes',1,'2025-12-07 07:46:16',NULL),('2025-12-06 07:46:16','2025-12-06 07:46:16','2025-12-06 07:46:16',1,291,'15b51434-feb3-42ab-a441-369f208db817',90,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes___DEFAULT__',1,'2025-12-07 07:46:16',NULL),('2025-12-06 07:46:16','2025-12-06 07:46:16','2025-12-06 07:46:16',1,292,'a54e3586-4405-4846-9586-d15a51799fc7',92,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots___DEFAULT__',1,'2025-12-07 07:46:16',NULL),('2025-12-06 07:46:21','2025-12-06 07:46:21','2025-12-06 07:46:21',1,293,'6d21aa34-a2c8-4a8c-a312-194def197696',91,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots',-1,'2025-12-07 07:46:21',NULL),('2025-12-06 07:46:21','2025-12-06 07:46:21','2025-12-06 07:46:21',1,294,'e03016c6-19e9-4b6f-8eb3-5f1d1247f2b1',88,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes',-1,'2025-12-07 07:46:21',NULL),('2025-12-06 07:46:21','2025-12-06 07:46:21','2025-12-06 07:46:21',1,295,'39874e83-80a2-41bf-af81-d7f4fef99cb0',90,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes___DEFAULT__',-1,'2025-12-07 07:46:21',NULL),('2025-12-06 07:46:21','2025-12-06 07:46:21','2025-12-06 07:46:21',1,296,'e46af749-1899-4da6-876e-7b50b3d05281',92,'40da133fd2cc44f4b03dfcaa8d2a67a6','snapshots___DEFAULT__',-1,'2025-12-07 07:46:21',NULL),('2025-12-06 07:46:23','2025-12-06 07:46:23','2025-12-06 07:46:23',1,297,'4f011394-309d-4a94-b58e-eaf42bbbaf46',87,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes',-1,'2025-12-07 07:46:23',NULL),('2025-12-06 07:46:23','2025-12-06 07:46:23','2025-12-06 07:46:23',1,298,'4a0b66ae-d4a4-461d-b138-4f4eccf12356',88,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes',-1,'2025-12-07 07:46:23',NULL),('2025-12-06 07:46:23','2025-12-06 07:46:23','2025-12-06 07:46:23',1,299,'d5cb2c40-53f6-4e4b-aa41-e6bfff604d93',89,'40da133fd2cc44f4b03dfcaa8d2a67a6','volumes___DEFAULT__',-1,'2025-12-07 07:46:23',NULL),('2025-12-06 07:46:23','2025-12-06 07:46:23','2025-12-06 07:46:23',1,300,'fae28dfb-d830-4872-8977-167b2adac6f0',90,'40da133fd2cc44f4b03dfcaa8d2a67a6','gigabytes___DEFAULT__',-1,'2025-12-07 07:46:23',NULL),('2025-12-06 07:46:57','2025-12-06 07:46:57','2025-12-06 07:46:57',1,301,'04d556ca-50be-47da-b5e2-3c2e7eede226',93,'329d4c9562c84ec5a42ca68894cbf27f','volumes',1,'2025-12-07 07:46:57',NULL),('2025-12-06 07:46:57','2025-12-06 07:46:57','2025-12-06 07:46:57',1,302,'bc8649cf-4a49-4f96-bb3f-6c4725596613',94,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes',1,'2025-12-07 07:46:57',NULL),('2025-12-06 07:46:57','2025-12-06 07:46:57','2025-12-06 07:46:57',1,303,'3718e002-4bdd-4695-93fb-58f50367771e',95,'329d4c9562c84ec5a42ca68894cbf27f','volumes_tempest-scenario-type-luks-717406057',1,'2025-12-07 07:46:57',NULL),('2025-12-06 07:46:57','2025-12-06 07:46:57','2025-12-06 07:46:57',1,304,'354e5153-2999-442a-82ec-03a37513eeef',96,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes_tempest-scenario-type-luks-717406057',1,'2025-12-07 07:46:57',NULL),('2025-12-06 07:47:22','2025-12-06 07:47:22','2025-12-06 07:47:22',1,305,'f22c98f4-aa3e-43d7-88bd-8ce649715da9',71,'4ec9294f6d4b4f44a72414374d646a4a','volumes',-1,'2025-12-07 07:47:22',NULL),('2025-12-06 07:47:22','2025-12-06 07:47:22','2025-12-06 07:47:22',1,306,'9aef4c90-79cf-4d15-aaae-66267f34226f',72,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes',-1,'2025-12-07 07:47:22',NULL),('2025-12-06 07:47:22','2025-12-06 07:47:22','2025-12-06 07:47:22',1,307,'69124359-5fd9-4a9b-81d1-abb1ce0fc50b',73,'4ec9294f6d4b4f44a72414374d646a4a','volumes___DEFAULT__',-1,'2025-12-07 07:47:22',NULL),('2025-12-06 07:47:22','2025-12-06 07:47:22','2025-12-06 07:47:22',1,308,'5a4343b9-b266-4c8b-883e-3a94e2a6422e',74,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes___DEFAULT__',-1,'2025-12-07 07:47:22',NULL),('2025-12-06 07:47:23','2025-12-06 07:47:23','2025-12-06 07:47:23',1,309,'0b9373f0-6d2d-45c0-935d-e62e55d3d411',71,'4ec9294f6d4b4f44a72414374d646a4a','volumes',-1,'2025-12-07 07:47:23',NULL),('2025-12-06 07:47:23','2025-12-06 07:47:23','2025-12-06 07:47:23',1,310,'17e24222-26c9-43a7-a845-86686925e9f6',72,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes',-1,'2025-12-07 07:47:23',NULL),('2025-12-06 07:47:23','2025-12-06 07:47:23','2025-12-06 07:47:23',1,311,'6094a9a5-ae2c-4b59-9cbf-cfbd6e64b51e',73,'4ec9294f6d4b4f44a72414374d646a4a','volumes___DEFAULT__',-1,'2025-12-07 07:47:23',NULL),('2025-12-06 07:47:23','2025-12-06 07:47:23','2025-12-06 07:47:23',1,312,'c5094ec8-d720-4b0b-ac0b-756668fb3414',74,'4ec9294f6d4b4f44a72414374d646a4a','gigabytes___DEFAULT__',-1,'2025-12-07 07:47:23',NULL),('2025-12-06 07:47:58','2025-12-06 07:47:58','2025-12-06 07:47:58',1,313,'640869da-bd91-41ee-9e2b-7cf3271f699c',83,'f44ecb8bdc7e4692a299e29603301124','volumes',-1,'2025-12-07 07:47:58',NULL),('2025-12-06 07:47:58','2025-12-06 07:47:58','2025-12-06 07:47:58',1,314,'7a502987-13cb-47d6-a3e5-253fdefb8085',84,'f44ecb8bdc7e4692a299e29603301124','gigabytes',-1,'2025-12-07 07:47:58',NULL),('2025-12-06 07:47:58','2025-12-06 07:47:58','2025-12-06 07:47:58',1,315,'aa678d38-f14f-49c2-9a77-36d5123df320',85,'f44ecb8bdc7e4692a299e29603301124','volumes___DEFAULT__',-1,'2025-12-07 07:47:58',NULL),('2025-12-06 07:47:58','2025-12-06 07:47:58','2025-12-06 07:47:58',1,316,'39c2afb4-76b8-4a16-a982-3cab418c7ae0',86,'f44ecb8bdc7e4692a299e29603301124','gigabytes___DEFAULT__',-1,'2025-12-07 07:47:58',NULL),('2025-12-06 07:48:17','2025-12-06 07:48:17','2025-12-06 07:48:17',1,317,'93f92de9-1af9-46a1-a7ae-2f3d5af67f6a',93,'329d4c9562c84ec5a42ca68894cbf27f','volumes',-1,'2025-12-07 07:48:17',NULL),('2025-12-06 07:48:17','2025-12-06 07:48:17','2025-12-06 07:48:17',1,318,'a7f3dc6a-a1df-4402-8fe8-e7a65dcf1d22',94,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes',-1,'2025-12-07 07:48:17',NULL),('2025-12-06 07:48:17','2025-12-06 07:48:17','2025-12-06 07:48:17',1,319,'a4f93acc-c813-4fdf-b524-e80ca66d180a',95,'329d4c9562c84ec5a42ca68894cbf27f','volumes_tempest-scenario-type-luks-717406057',-1,'2025-12-07 07:48:17',NULL),('2025-12-06 07:48:17','2025-12-06 07:48:17','2025-12-06 07:48:17',1,320,'f67be47d-6961-4822-ab3d-0fabd6533aa2',96,'329d4c9562c84ec5a42ca68894cbf27f','gigabytes_tempest-scenario-type-luks-717406057',-1,'2025-12-07 07:48:17',NULL),('2025-12-06 07:50:24','2025-12-06 07:50:24','2025-12-06 07:50:24',1,321,'d555dc56-3bd0-45a0-af91-66793bec1b73',97,'c4cf19b89a6d46bca307e65731a9dd21','volumes',1,'2025-12-07 07:50:24',NULL),('2025-12-06 07:50:24','2025-12-06 07:50:24','2025-12-06 07:50:24',1,322,'72fcacb2-8cee-4921-900c-ea334d554e53',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',1,'2025-12-07 07:50:24',NULL),('2025-12-06 07:50:24','2025-12-06 07:50:24','2025-12-06 07:50:24',1,323,'14b6bc18-b24a-44a7-8963-3234b733d538',99,'c4cf19b89a6d46bca307e65731a9dd21','volumes___DEFAULT__',1,'2025-12-07 07:50:24',NULL),('2025-12-06 07:50:24','2025-12-06 07:50:24','2025-12-06 07:50:24',1,324,'e17ab77b-c8ee-413c-91b2-ad2c6cdbbd42',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',1,'2025-12-07 07:50:24',NULL),('2025-12-06 07:50:32','2025-12-06 07:50:32','2025-12-06 07:50:32',1,325,'3af66f20-e4c3-4b25-b6e8-c34ce0f3c283',101,'0c8fc5bc237e42bfad505a0bca6681eb','volumes',1,'2025-12-07 07:50:32',NULL),('2025-12-06 07:50:32','2025-12-06 07:50:32','2025-12-06 07:50:32',1,326,'b9236585-eeb2-4b1e-869b-aa92e158f3e0',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',1,'2025-12-07 07:50:32',NULL),('2025-12-06 07:50:32','2025-12-06 07:50:32','2025-12-06 07:50:32',1,327,'b4929b10-630a-4824-a07b-af7d5347a324',103,'0c8fc5bc237e42bfad505a0bca6681eb','volumes___DEFAULT__',1,'2025-12-07 07:50:32',NULL),('2025-12-06 07:50:32','2025-12-06 07:50:32','2025-12-06 07:50:32',1,328,'1f28a8c5-4fcb-4ab8-a445-65d2bd7db32b',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',1,'2025-12-07 07:50:32',NULL),('2025-12-06 07:50:40','2025-12-06 07:50:40','2025-12-06 07:50:40',1,329,'2cf68fda-7c30-4a55-9d3b-6b5770527857',105,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots',1,'2025-12-07 07:50:40',NULL),('2025-12-06 07:50:40','2025-12-06 07:50:40','2025-12-06 07:50:40',1,330,'c8fdb3f3-4f4e-4908-bb61-ef784b02df13',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',1,'2025-12-07 07:50:40',NULL),('2025-12-06 07:50:40','2025-12-06 07:50:40','2025-12-06 07:50:40',1,331,'9ee8d4f8-739c-4fcd-b9ed-c6c8739f8ff5',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',1,'2025-12-07 07:50:40',NULL),('2025-12-06 07:50:40','2025-12-06 07:50:41','2025-12-06 07:50:40',1,332,'79e68d73-c920-44bd-b43a-1afe2ea03b62',106,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots___DEFAULT__',1,'2025-12-07 07:50:40',NULL),('2025-12-06 07:50:55','2025-12-06 07:50:55','2025-12-06 07:50:55',1,333,'32bc31df-1f49-42e3-8616-33f20b6991fa',107,'4842ecff6dce4ccc981a6b65a14ea406','volumes',1,'2025-12-07 07:50:55',NULL),('2025-12-06 07:50:55','2025-12-06 07:50:55','2025-12-06 07:50:55',1,334,'60a7f8f1-3276-41fa-bab1-cbc5778e4a79',108,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes',1,'2025-12-07 07:50:55',NULL),('2025-12-06 07:50:55','2025-12-06 07:50:55','2025-12-06 07:50:55',1,335,'587545a4-832b-4a26-ab84-03bf13558f1d',109,'4842ecff6dce4ccc981a6b65a14ea406','volumes___DEFAULT__',1,'2025-12-07 07:50:55',NULL),('2025-12-06 07:50:55','2025-12-06 07:50:55','2025-12-06 07:50:55',1,336,'6e723471-3590-4c11-8de5-16610033fb63',110,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes___DEFAULT__',1,'2025-12-07 07:50:55',NULL),('2025-12-06 07:51:04','2025-12-06 07:51:04','2025-12-06 07:51:04',1,337,'c00c26f3-f180-49f6-b512-e25bcdfee323',105,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots',-1,'2025-12-07 07:51:04',NULL),('2025-12-06 07:51:04','2025-12-06 07:51:04','2025-12-06 07:51:04',1,338,'060017d7-42ba-481e-b5dd-6e78d0e18c13',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',-1,'2025-12-07 07:51:04',NULL),('2025-12-06 07:51:04','2025-12-06 07:51:04','2025-12-06 07:51:04',1,339,'7a0a0fe7-91ad-4998-8d2e-1b692eb265c1',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',-1,'2025-12-07 07:51:04',NULL),('2025-12-06 07:51:04','2025-12-06 07:51:04','2025-12-06 07:51:04',1,340,'d62ab9c5-6100-41fb-a5b3-e8dc1c6c9fa2',106,'0c8fc5bc237e42bfad505a0bca6681eb','snapshots___DEFAULT__',-1,'2025-12-07 07:51:04',NULL),('2025-12-06 07:51:18','2025-12-06 07:51:22','2025-12-06 07:51:22',1,341,'f30c9f7b-6788-473d-ba14-20e21aa26bd2',111,'cfa713d92cc94fa1b94404ed58b0563f','volumes',1,'2025-12-07 07:51:17',NULL),('2025-12-06 07:51:18','2025-12-06 07:51:22','2025-12-06 07:51:22',1,342,'b21d735a-1d18-4543-87b4-969ad8d825ef',112,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes',1,'2025-12-07 07:51:17',NULL),('2025-12-06 07:51:18','2025-12-06 07:51:22','2025-12-06 07:51:22',1,343,'a5e47173-bf2d-4cee-811e-44a0759a7788',113,'cfa713d92cc94fa1b94404ed58b0563f','volumes___DEFAULT__',1,'2025-12-07 07:51:17',NULL),('2025-12-06 07:51:18','2025-12-06 07:51:22','2025-12-06 07:51:22',1,344,'12ac4566-3e94-43e8-b79a-5a38c36d53ce',114,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes___DEFAULT__',1,'2025-12-07 07:51:17',NULL),('2025-12-06 07:51:29','2025-12-06 07:51:30','2025-12-06 07:51:30',1,345,'934e5e6e-ba0e-4b02-8d0c-2993039306a2',115,'c4cf19b89a6d46bca307e65731a9dd21','snapshots',1,'2025-12-07 07:51:29',NULL),('2025-12-06 07:51:29','2025-12-06 07:51:30','2025-12-06 07:51:30',1,346,'0162f1ef-6aba-4f94-a118-8bf9825ff004',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',1,'2025-12-07 07:51:29',NULL),('2025-12-06 07:51:29','2025-12-06 07:51:30','2025-12-06 07:51:30',1,347,'9c54ef73-390a-4af7-b95d-30b502442f2a',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',1,'2025-12-07 07:51:29',NULL),('2025-12-06 07:51:29','2025-12-06 07:51:30','2025-12-06 07:51:30',1,348,'6ecf4b96-5c46-45f9-87b8-947f5c0b0341',116,'c4cf19b89a6d46bca307e65731a9dd21','snapshots___DEFAULT__',1,'2025-12-07 07:51:29',NULL),('2025-12-06 07:51:35','2025-12-06 07:51:36','2025-12-06 07:51:36',1,349,'08222871-fd16-4ab6-b4b4-52981a936d2e',107,'4842ecff6dce4ccc981a6b65a14ea406','volumes',1,'2025-12-07 07:51:35',NULL),('2025-12-06 07:51:35','2025-12-06 07:51:36','2025-12-06 07:51:36',1,350,'c758a8e2-09f5-4b50-905e-ee0979ad544d',108,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes',1,'2025-12-07 07:51:35',NULL),('2025-12-06 07:51:35','2025-12-06 07:51:36','2025-12-06 07:51:36',1,351,'9dcc58a9-58eb-4932-bd1e-42b80f9b7350',109,'4842ecff6dce4ccc981a6b65a14ea406','volumes___DEFAULT__',1,'2025-12-07 07:51:35',NULL),('2025-12-06 07:51:35','2025-12-06 07:51:36','2025-12-06 07:51:36',1,352,'066d10d1-9aef-4b08-9c72-77f9c6f5bbe7',110,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes___DEFAULT__',1,'2025-12-07 07:51:35',NULL),('2025-12-06 07:51:42','2025-12-06 07:51:42','2025-12-06 07:51:42',1,353,'4ea55415-c9c9-459c-be9a-20aa8b34c0e3',97,'c4cf19b89a6d46bca307e65731a9dd21','volumes',1,'2025-12-07 07:51:42',NULL),('2025-12-06 07:51:42','2025-12-06 07:51:42','2025-12-06 07:51:42',1,354,'b5c94128-a1ce-4508-a62e-962e575ae2b0',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',1,'2025-12-07 07:51:42',NULL),('2025-12-06 07:51:42','2025-12-06 07:51:42','2025-12-06 07:51:42',1,355,'20170559-f636-425b-9b65-e123414404d8',99,'c4cf19b89a6d46bca307e65731a9dd21','volumes___DEFAULT__',1,'2025-12-07 07:51:42',NULL),('2025-12-06 07:51:42','2025-12-06 07:51:42','2025-12-06 07:51:42',1,356,'1757d458-7fe6-4131-bd91-414fe031527f',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',1,'2025-12-07 07:51:42',NULL),('2025-12-06 07:52:15','2025-12-06 07:52:15','2025-12-06 07:52:15',1,357,'65b96c78-df6f-4c07-9121-0c6765a4e900',101,'0c8fc5bc237e42bfad505a0bca6681eb','volumes',-1,'2025-12-07 07:52:15',NULL),('2025-12-06 07:52:15','2025-12-06 07:52:15','2025-12-06 07:52:15',1,358,'1dc2e239-6bf7-48b5-b339-bd26783a2e37',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',-1,'2025-12-07 07:52:15',NULL),('2025-12-06 07:52:15','2025-12-06 07:52:15','2025-12-06 07:52:15',1,359,'b129f7b5-c29b-46a8-9736-8928d758e560',103,'0c8fc5bc237e42bfad505a0bca6681eb','volumes___DEFAULT__',-1,'2025-12-07 07:52:15',NULL),('2025-12-06 07:52:15','2025-12-06 07:52:15','2025-12-06 07:52:15',1,360,'1467b562-9d82-4846-bf22-bd654ac59e18',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',-1,'2025-12-07 07:52:15',NULL),('2025-12-06 07:52:55','2025-12-06 07:52:55','2025-12-06 07:52:55',1,361,'e3f61671-76d9-4e77-a47e-993d4a4476e8',101,'0c8fc5bc237e42bfad505a0bca6681eb','volumes',1,'2025-12-07 07:52:54',NULL),('2025-12-06 07:52:55','2025-12-06 07:52:55','2025-12-06 07:52:55',1,362,'7ebbb113-979a-44b9-8c46-75d65e3799a8',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',1,'2025-12-07 07:52:54',NULL),('2025-12-06 07:52:55','2025-12-06 07:52:55','2025-12-06 07:52:55',1,363,'e9542308-3c54-4713-99f7-b23fb17f7bbb',103,'0c8fc5bc237e42bfad505a0bca6681eb','volumes___DEFAULT__',1,'2025-12-07 07:52:54',NULL),('2025-12-06 07:52:55','2025-12-06 07:52:55','2025-12-06 07:52:55',1,364,'dc0d1172-dfe0-43cb-b296-401d2167f342',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',1,'2025-12-07 07:52:54',NULL),('2025-12-06 07:53:03','2025-12-06 07:53:03','2025-12-06 07:53:03',1,365,'5b92ab80-14db-4d82-bf0c-0c5e2faba997',97,'c4cf19b89a6d46bca307e65731a9dd21','volumes',-1,'2025-12-07 07:53:03',NULL),('2025-12-06 07:53:03','2025-12-06 07:53:03','2025-12-06 07:53:03',1,366,'00c89437-17b4-4497-a5ba-9a36674facd2',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',-1,'2025-12-07 07:53:03',NULL),('2025-12-06 07:53:03','2025-12-06 07:53:03','2025-12-06 07:53:03',1,367,'8695cdf8-f4cb-45d3-89a1-c758924db165',99,'c4cf19b89a6d46bca307e65731a9dd21','volumes___DEFAULT__',-1,'2025-12-07 07:53:03',NULL),('2025-12-06 07:53:03','2025-12-06 07:53:03','2025-12-06 07:53:03',1,368,'85f1c9c5-03f1-4a03-a279-4e601be5285e',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',-1,'2025-12-07 07:53:03',NULL),('2025-12-06 07:53:08','2025-12-06 07:53:08','2025-12-06 07:53:08',1,369,'497bd5d9-2ee9-4506-acf7-d7819905f109',115,'c4cf19b89a6d46bca307e65731a9dd21','snapshots',-1,'2025-12-07 07:53:08',NULL),('2025-12-06 07:53:08','2025-12-06 07:53:08','2025-12-06 07:53:08',1,370,'9e87021f-6393-409b-99b7-824d4b563971',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',-1,'2025-12-07 07:53:08',NULL),('2025-12-06 07:53:08','2025-12-06 07:53:08','2025-12-06 07:53:08',1,371,'196e3012-620b-42fa-a9fe-2c6ef2af601a',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',-1,'2025-12-07 07:53:08',NULL),('2025-12-06 07:53:08','2025-12-06 07:53:08','2025-12-06 07:53:08',1,372,'28118ef9-74e2-49e8-b3aa-a2e8a9b188c8',116,'c4cf19b89a6d46bca307e65731a9dd21','snapshots___DEFAULT__',-1,'2025-12-07 07:53:08',NULL),('2025-12-06 07:53:20','2025-12-06 07:53:20','2025-12-06 07:53:20',1,373,'1e3f65f5-b101-4c1e-bea2-4ab0425d8fa8',97,'c4cf19b89a6d46bca307e65731a9dd21','volumes',-1,'2025-12-07 07:53:20',NULL),('2025-12-06 07:53:20','2025-12-06 07:53:20','2025-12-06 07:53:20',1,374,'75a96d0d-616e-456c-bf0e-ac99d2b10baf',98,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes',-1,'2025-12-07 07:53:20',NULL),('2025-12-06 07:53:20','2025-12-06 07:53:20','2025-12-06 07:53:20',1,375,'cd22562d-79e1-447e-97c6-1b550da3dae5',99,'c4cf19b89a6d46bca307e65731a9dd21','volumes___DEFAULT__',-1,'2025-12-07 07:53:20',NULL),('2025-12-06 07:53:20','2025-12-06 07:53:20','2025-12-06 07:53:20',1,376,'e83471cd-eef8-428d-93b6-a5b3aa16aed5',100,'c4cf19b89a6d46bca307e65731a9dd21','gigabytes___DEFAULT__',-1,'2025-12-07 07:53:20',NULL),('2025-12-06 07:53:38','2025-12-06 07:53:39','2025-12-06 07:53:39',1,377,'1c0ec94b-ff66-4848-9f2b-5ff55f82e610',111,'cfa713d92cc94fa1b94404ed58b0563f','volumes',1,'2025-12-07 07:53:38',NULL),('2025-12-06 07:53:38','2025-12-06 07:53:39','2025-12-06 07:53:39',1,378,'7bcaf06b-733c-4a6c-8769-4bbb4accef61',112,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes',1,'2025-12-07 07:53:38',NULL),('2025-12-06 07:53:38','2025-12-06 07:53:39','2025-12-06 07:53:39',1,379,'3a748e08-bfcb-4f88-9748-15308b8d302a',113,'cfa713d92cc94fa1b94404ed58b0563f','volumes___DEFAULT__',1,'2025-12-07 07:53:38',NULL),('2025-12-06 07:53:38','2025-12-06 07:53:39','2025-12-06 07:53:39',1,380,'dc489e44-ad18-4987-8422-8ef5af5a634a',114,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes___DEFAULT__',1,'2025-12-07 07:53:38',NULL),('2025-12-06 07:53:47','2025-12-06 07:53:47','2025-12-06 07:53:47',1,381,'5399ad18-fc7d-48ac-ad59-06a58a34b9de',107,'4842ecff6dce4ccc981a6b65a14ea406','volumes',-1,'2025-12-07 07:53:47',NULL),('2025-12-06 07:53:47','2025-12-06 07:53:47','2025-12-06 07:53:47',1,382,'225f10b9-8fc9-40f0-9c1d-1533c6718204',108,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes',-1,'2025-12-07 07:53:47',NULL),('2025-12-06 07:53:47','2025-12-06 07:53:47','2025-12-06 07:53:47',1,383,'c4afe1bd-d1cc-4c50-a691-3439e99b4894',109,'4842ecff6dce4ccc981a6b65a14ea406','volumes___DEFAULT__',-1,'2025-12-07 07:53:47',NULL),('2025-12-06 07:53:47','2025-12-06 07:53:47','2025-12-06 07:53:47',1,384,'09c01d19-11a8-47e5-8b08-4ed6c2f93ecd',110,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes___DEFAULT__',-1,'2025-12-07 07:53:47',NULL),('2025-12-06 07:53:48','2025-12-06 07:53:48','2025-12-06 07:53:48',1,385,'278c69cb-1922-4ce0-aacb-4862ac64a3df',107,'4842ecff6dce4ccc981a6b65a14ea406','volumes',-1,'2025-12-07 07:53:48',NULL),('2025-12-06 07:53:48','2025-12-06 07:53:48','2025-12-06 07:53:48',1,386,'6aeadd98-43a9-4498-9f46-d9196ae4c2ec',108,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes',-1,'2025-12-07 07:53:48',NULL),('2025-12-06 07:53:48','2025-12-06 07:53:48','2025-12-06 07:53:48',1,387,'29600e06-17cc-4d1c-b730-b366f8fbda1e',109,'4842ecff6dce4ccc981a6b65a14ea406','volumes___DEFAULT__',-1,'2025-12-07 07:53:48',NULL),('2025-12-06 07:53:48','2025-12-06 07:53:48','2025-12-06 07:53:48',1,388,'7d3cb43d-bc5d-470f-94ca-c4a76a26bee0',110,'4842ecff6dce4ccc981a6b65a14ea406','gigabytes___DEFAULT__',-1,'2025-12-07 07:53:48',NULL),('2025-12-06 07:54:13','2025-12-06 07:54:13','2025-12-06 07:54:13',1,389,'e22794ab-8b2f-4175-8741-934442c38af4',101,'0c8fc5bc237e42bfad505a0bca6681eb','volumes',-1,'2025-12-07 07:54:13',NULL),('2025-12-06 07:54:13','2025-12-06 07:54:13','2025-12-06 07:54:13',1,390,'5b64ae99-1fc0-4264-8f8f-375dde3a6266',102,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes',-1,'2025-12-07 07:54:13',NULL),('2025-12-06 07:54:13','2025-12-06 07:54:13','2025-12-06 07:54:13',1,391,'0079b878-4bc1-4952-814d-b3eb4c1f054f',103,'0c8fc5bc237e42bfad505a0bca6681eb','volumes___DEFAULT__',-1,'2025-12-07 07:54:13',NULL),('2025-12-06 07:54:13','2025-12-06 07:54:13','2025-12-06 07:54:13',1,392,'9ac89e9b-c40d-47e3-9f54-c31482e1b35e',104,'0c8fc5bc237e42bfad505a0bca6681eb','gigabytes___DEFAULT__',-1,'2025-12-07 07:54:13',NULL),('2025-12-06 07:54:45','2025-12-06 07:54:45','2025-12-06 07:54:45',1,393,'2f9672b5-b989-48d8-8ed1-a204716dca61',111,'cfa713d92cc94fa1b94404ed58b0563f','volumes',-1,'2025-12-07 07:54:45',NULL),('2025-12-06 07:54:45','2025-12-06 07:54:45','2025-12-06 07:54:45',1,394,'1ec05502-6bfd-4649-acfc-28ad10121348',112,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes',-1,'2025-12-07 07:54:45',NULL),('2025-12-06 07:54:45','2025-12-06 07:54:45','2025-12-06 07:54:45',1,395,'5cf2c4a2-9a54-4382-a055-a0dbe0862c89',113,'cfa713d92cc94fa1b94404ed58b0563f','volumes___DEFAULT__',-1,'2025-12-07 07:54:45',NULL),('2025-12-06 07:54:45','2025-12-06 07:54:45','2025-12-06 07:54:45',1,396,'9e69b5fe-e4e0-44b3-9a57-5fef564cc826',114,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes___DEFAULT__',-1,'2025-12-07 07:54:45',NULL),('2025-12-06 07:54:47','2025-12-06 07:54:47','2025-12-06 07:54:47',1,397,'f2020a17-16f2-4605-ae89-7b9f62295bed',111,'cfa713d92cc94fa1b94404ed58b0563f','volumes',-1,'2025-12-07 07:54:47',NULL),('2025-12-06 07:54:47','2025-12-06 07:54:47','2025-12-06 07:54:47',1,398,'d5cbff3f-a1e6-406f-97d2-8bef5d41ee1e',112,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes',-1,'2025-12-07 07:54:47',NULL),('2025-12-06 07:54:47','2025-12-06 07:54:47','2025-12-06 07:54:47',1,399,'689b2503-7d9e-418e-ad3d-4bbf6debb319',113,'cfa713d92cc94fa1b94404ed58b0563f','volumes___DEFAULT__',-1,'2025-12-07 07:54:47',NULL),('2025-12-06 07:54:47','2025-12-06 07:54:47','2025-12-06 07:54:47',1,400,'1f850b10-45cd-4b32-83d2-9680cada4987',114,'cfa713d92cc94fa1b94404ed58b0563f','gigabytes___DEFAULT__',-1,'2025-12-07 07:54:47',NULL),('2025-12-06 07:55:09','2025-12-06 07:55:09','2025-12-06 07:55:09',1,401,'04d81f34-d6d0-4c6a-b66e-4b7229526f00',117,'63df107b8bd14504974c75ba92ae469b','volumes',1,'2025-12-07 07:55:09',NULL),('2025-12-06 07:55:09','2025-12-06 07:55:09','2025-12-06 07:55:09',1,402,'b55dcbe9-db69-44bc-92ba-f9d69975cccb',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',1,'2025-12-07 07:55:09',NULL),('2025-12-06 07:55:09','2025-12-06 07:55:09','2025-12-06 07:55:09',1,403,'f98205c2-0053-47ea-8945-83294bafe875',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',1,'2025-12-07 07:55:09',NULL),('2025-12-06 07:55:09','2025-12-06 07:55:09','2025-12-06 07:55:09',1,404,'695c92da-8493-4fac-aa6b-9f66c1ff482b',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',1,'2025-12-07 07:55:09',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,405,'60cd8f53-63ea-47ff-b0f6-097e6c348e72',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,406,'39831925-3b25-49aa-b2e2-29c71b04fa53',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,407,'a8d6af07-4d18-4c06-b3c3-bb84e58913a9',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,408,'ca1c76f5-feaa-4fb9-82f0-da0b625ee1dd',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,409,'8f453c4c-74c5-43db-bef1-dff276d11926',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,410,'22a62a54-06e4-450b-8c60-6a8be4c41e61',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,411,'5a859191-4761-43ca-aa10-5a145cbb59a2',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:27','2025-12-06 07:55:27','2025-12-06 07:55:27',1,412,'795f6a22-08d2-4e3f-a7b5-5d548d873247',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:27',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,413,'67061190-8ef6-4867-be27-fe4ec5ea4c22',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,414,'410a32cf-605d-445e-957d-cb533fcd4e0f',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,415,'9f956713-2de4-4706-bc0a-4b5a0f47dacc',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,416,'73b17ac5-9acb-4165-bde7-993009d51b86',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,417,'7ceda130-112a-4592-ae44-9d5cf8a4ea68',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,418,'f9d2ff4f-7cd9-41fd-8fb1-cb0c60108e41',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,419,'693ff768-9da8-421a-a4a3-967312ad597f',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,420,'d221f9f9-fdfc-440f-9b36-fe0b6711f37e',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,421,'0376ef0f-eef6-459d-b810-7b1db6b144bc',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,422,'e3fd8b45-0351-4365-adc2-fe6be5e9950d',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,423,'c9f4e024-aee9-4abd-b653-7580d37332ca',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,424,'2cfb7c9f-f65c-42fe-989f-ce1ff74ba511',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,425,'bdd066e2-2cac-4d59-a68b-f94e5af93808',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,426,'b8bde57d-f14a-48f9-b5e4-f6bc9e674fbd',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,427,'658ad088-43be-43dc-95a3-7cf167a4b6aa',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:55:28',1,428,'f62c14af-f19a-4dd5-8673-012c76424b2f',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',1,'2025-12-07 07:55:28',NULL),('2025-12-06 07:55:31','2025-12-06 07:55:31','2025-12-06 07:55:31',1,429,'6294f087-124c-4beb-ac59-a18af55e72dc',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:30',NULL),('2025-12-06 07:55:31','2025-12-06 07:55:31','2025-12-06 07:55:31',1,430,'d49cd2cd-16ee-470d-8e81-0999ed9458e9',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:30',NULL),('2025-12-06 07:55:31','2025-12-06 07:55:31','2025-12-06 07:55:31',1,431,'8e9403b7-d477-46d4-bf23-da997cd41a4a',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:30',NULL),('2025-12-06 07:55:31','2025-12-06 07:55:31','2025-12-06 07:55:31',1,432,'dfd1a36c-acbf-46a7-a48d-c8c1258855e0',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:30',NULL),('2025-12-06 07:55:32','2025-12-06 07:55:32','2025-12-06 07:55:32',1,433,'6a362abc-1e98-46a6-b706-3618fd8983cd',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:32',NULL),('2025-12-06 07:55:32','2025-12-06 07:55:32','2025-12-06 07:55:32',1,434,'89d870f9-7d1e-472d-8c1d-edbc6f426b90',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:32',NULL),('2025-12-06 07:55:32','2025-12-06 07:55:32','2025-12-06 07:55:32',1,435,'b9cb7dbc-fb6c-42a6-8e4b-f72043c3df2a',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:32',NULL),('2025-12-06 07:55:32','2025-12-06 07:55:32','2025-12-06 07:55:32',1,436,'b3a89a6c-4833-4ea8-a8e2-0a91daa02fad',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:32',NULL),('2025-12-06 07:55:33','2025-12-06 07:55:34','2025-12-06 07:55:34',1,437,'90fbd662-faf5-4930-a6ec-36ca75bd754a',121,'6164fee998c94b71a37886fe42b4c56c','volumes',1,'2025-12-07 07:55:33',NULL),('2025-12-06 07:55:33','2025-12-06 07:55:34','2025-12-06 07:55:34',1,438,'b2c58499-1ef7-4d6e-b7a2-a54cdf797e1e',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',1,'2025-12-07 07:55:33',NULL),('2025-12-06 07:55:33','2025-12-06 07:55:34','2025-12-06 07:55:34',1,439,'78009ebd-4dbd-40cb-adda-1d5faf5081df',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:33',NULL),('2025-12-06 07:55:33','2025-12-06 07:55:34','2025-12-06 07:55:34',1,440,'434429df-d86b-44dd-9536-c060822ebee5',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',1,'2025-12-07 07:55:33',NULL),('2025-12-06 07:56:19','2025-12-06 07:56:19','2025-12-06 07:56:19',1,441,'ee690b05-cab6-4626-b6a0-d852ec30e708',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:56:19',NULL),('2025-12-06 07:56:19','2025-12-06 07:56:19','2025-12-06 07:56:19',1,442,'df71ab53-a93e-46a1-b242-2d656999fb2e',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:56:19',NULL),('2025-12-06 07:56:19','2025-12-06 07:56:19','2025-12-06 07:56:19',1,443,'3d853ee7-835e-4e34-bfe0-e62635ce9918',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:56:19',NULL),('2025-12-06 07:56:19','2025-12-06 07:56:19','2025-12-06 07:56:19',1,444,'16839a77-48d5-4574-b370-47677707d612',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:56:19',NULL),('2025-12-06 07:56:26','2025-12-06 07:56:26','2025-12-06 07:56:26',1,445,'6a9932bf-f268-453e-ab44-3239b8f3d907',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:56:26',NULL),('2025-12-06 07:56:26','2025-12-06 07:56:26','2025-12-06 07:56:26',1,446,'d026c738-cef8-497c-b74b-007a5756b1bc',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:56:26',NULL),('2025-12-06 07:56:26','2025-12-06 07:56:26','2025-12-06 07:56:26',1,447,'39adc843-c040-415c-99ce-cc04b04cca4d',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:56:26',NULL),('2025-12-06 07:56:26','2025-12-06 07:56:26','2025-12-06 07:56:26',1,448,'c7c270e7-9984-4753-8178-9a7731c1bbaf',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:56:26',NULL),('2025-12-06 07:56:50','2025-12-06 07:56:50','2025-12-06 07:56:50',1,449,'6f0791a2-be7f-4b55-8c81-43557882a067',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:56:50',NULL),('2025-12-06 07:56:50','2025-12-06 07:56:50','2025-12-06 07:56:50',1,450,'dccfb213-6e86-43ed-978c-22b14c3bf062',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:56:50',NULL),('2025-12-06 07:56:50','2025-12-06 07:56:50','2025-12-06 07:56:50',1,451,'a5ba4326-ef4c-42ce-8ad3-eddefc70ef1b',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:56:50',NULL),('2025-12-06 07:56:50','2025-12-06 07:56:50','2025-12-06 07:56:50',1,452,'5f260f72-29df-4e43-81e6-44694d3fa145',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:56:50',NULL),('2025-12-06 07:56:53','2025-12-06 07:56:53','2025-12-06 07:56:53',1,453,'8a1b661e-55dc-42b4-b5c5-f3945b055b42',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:56:53',NULL),('2025-12-06 07:56:53','2025-12-06 07:56:53','2025-12-06 07:56:53',1,454,'fc37d998-6c1f-4456-a42b-586aa6f761a1',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:56:53',NULL),('2025-12-06 07:56:53','2025-12-06 07:56:53','2025-12-06 07:56:53',1,455,'0948a7e0-d41e-44c4-af0e-8ac92ebd0ace',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:56:53',NULL),('2025-12-06 07:56:53','2025-12-06 07:56:53','2025-12-06 07:56:53',1,456,'f5ec6957-a8e9-4314-b98c-42a7ea88bc01',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:56:53',NULL),('2025-12-06 07:57:20','2025-12-06 07:57:20','2025-12-06 07:57:20',1,457,'4893e8f7-ffc6-44d3-90b9-88c2769a51fb',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:57:20',NULL),('2025-12-06 07:57:20','2025-12-06 07:57:20','2025-12-06 07:57:20',1,458,'810d38a9-09b8-4bc0-9179-0fae842e515c',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:57:20',NULL),('2025-12-06 07:57:20','2025-12-06 07:57:20','2025-12-06 07:57:20',1,459,'f28e7225-7cc8-441f-80ed-b7ee4b5fee15',123,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:57:20',NULL),('2025-12-06 07:57:20','2025-12-06 07:57:20','2025-12-06 07:57:20',1,460,'ba5dac28-c7fd-4bc2-bd35-616b8ff64938',124,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',-1,'2025-12-07 07:57:20',NULL),('2025-12-06 07:57:29','2025-12-06 07:57:29','2025-12-06 07:57:29',1,461,'167d32cf-caff-4f18-b1d8-1e1a26744611',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:57:29',NULL),('2025-12-06 07:57:29','2025-12-06 07:57:29','2025-12-06 07:57:29',1,462,'76a40be2-4513-4ddc-bb9f-b75a0ed632cf',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:57:29',NULL),('2025-12-06 07:57:29','2025-12-06 07:57:29','2025-12-06 07:57:29',1,463,'75b4e577-f35f-4c1c-8efb-7ccf5c7b9e39',125,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:57:29',NULL),('2025-12-06 07:57:29','2025-12-06 07:57:29','2025-12-06 07:57:29',1,464,'d49276cd-a90e-4eb7-9f9d-03b314693b40',126,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',-1,'2025-12-07 07:57:29',NULL),('2025-12-06 07:57:41','2025-12-06 07:57:41','2025-12-06 07:57:41',1,465,'966e63bb-3195-48f9-bce6-7acc8c06b7a0',117,'63df107b8bd14504974c75ba92ae469b','volumes',1,'2025-12-07 07:57:41',NULL),('2025-12-06 07:57:41','2025-12-06 07:57:41','2025-12-06 07:57:41',1,466,'77facdb4-7d51-4df4-a3c2-8a6c7e09ec30',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',1,'2025-12-07 07:57:41',NULL),('2025-12-06 07:57:41','2025-12-06 07:57:41','2025-12-06 07:57:41',1,467,'cc429ed4-ffbf-4330-9f3a-18b064b464e2',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',1,'2025-12-07 07:57:41',NULL),('2025-12-06 07:57:41','2025-12-06 07:57:41','2025-12-06 07:57:41',1,468,'51f177e2-6d59-431c-88b0-ee4bf722efe0',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',1,'2025-12-07 07:57:41',NULL),('2025-12-06 07:57:46','2025-12-06 07:57:46','2025-12-06 07:57:46',1,469,'1a68f0ba-0bd6-486c-a65a-57b53323aa90',117,'63df107b8bd14504974c75ba92ae469b','volumes',1,'2025-12-07 07:57:46',NULL),('2025-12-06 07:57:46','2025-12-06 07:57:46','2025-12-06 07:57:46',1,470,'dbc1b5a8-91c7-4ba2-9b36-bd4c9ba4dcba',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',1,'2025-12-07 07:57:46',NULL),('2025-12-06 07:57:46','2025-12-06 07:57:46','2025-12-06 07:57:46',1,471,'acce4c42-be22-4ad0-b3e4-a90b8506169c',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',1,'2025-12-07 07:57:46',NULL),('2025-12-06 07:57:46','2025-12-06 07:57:46','2025-12-06 07:57:46',1,472,'1dacc3e5-9dec-4467-b8ad-daf0b863499e',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',1,'2025-12-07 07:57:46',NULL),('2025-12-06 07:57:57','2025-12-06 07:57:57','2025-12-06 07:57:57',1,473,'a679e703-5e5a-4026-bb27-4681e6f8c341',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:57:57',NULL),('2025-12-06 07:57:57','2025-12-06 07:57:57','2025-12-06 07:57:57',1,474,'1e673f2b-7827-4b30-8dd2-0ece3483926b',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:57:57',NULL),('2025-12-06 07:57:57','2025-12-06 07:57:57','2025-12-06 07:57:57',1,475,'3e66f8a7-95b0-4cc5-a39b-11118353e8d9',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:57:57',NULL),('2025-12-06 07:57:57','2025-12-06 07:57:57','2025-12-06 07:57:57',1,476,'85972456-df58-45ab-b3c2-3e83e24dac37',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:57:57',NULL),('2025-12-06 07:58:01','2025-12-06 07:58:02','2025-12-06 07:58:02',1,477,'1f4a780e-ab53-475e-8cb9-0bc8edbb79ea',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:58:01',NULL),('2025-12-06 07:58:01','2025-12-06 07:58:02','2025-12-06 07:58:02',1,478,'70c7817b-25a7-4a59-acd8-f93ed5ebc1cb',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:58:01',NULL),('2025-12-06 07:58:01','2025-12-06 07:58:02','2025-12-06 07:58:02',1,479,'8287338a-a3c5-469d-88b9-e9610b0f3940',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:58:01',NULL),('2025-12-06 07:58:01','2025-12-06 07:58:02','2025-12-06 07:58:02',1,480,'d0775bd4-4e87-46f2-9d99-4a41e8632bc4',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:58:01',NULL),('2025-12-06 07:58:15','2025-12-06 07:58:15','2025-12-06 07:58:15',1,481,'38972d9f-be19-4bee-8ce0-21f78687028b',121,'6164fee998c94b71a37886fe42b4c56c','volumes',-1,'2025-12-07 07:58:15',NULL),('2025-12-06 07:58:15','2025-12-06 07:58:15','2025-12-06 07:58:15',1,482,'472d412c-1a04-4e7d-998e-47f2f03f658e',122,'6164fee998c94b71a37886fe42b4c56c','gigabytes',-1,'2025-12-07 07:58:15',NULL),('2025-12-06 07:58:15','2025-12-06 07:58:15','2025-12-06 07:58:15',1,483,'4b8b623f-6230-4eba-a19d-0a433554c255',127,'6164fee998c94b71a37886fe42b4c56c','volumes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:58:15',NULL),('2025-12-06 07:58:15','2025-12-06 07:58:15','2025-12-06 07:58:15',1,484,'cebb0ee9-975c-4ad4-bf45-85b369698f2c',128,'6164fee998c94b71a37886fe42b4c56c','gigabytes_tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',-1,'2025-12-07 07:58:15',NULL),('2025-12-06 07:58:17','2025-12-06 07:58:18','2025-12-06 07:58:18',1,485,'de5d29a7-446b-4c6a-adc8-fd9e75bd8f2d',117,'63df107b8bd14504974c75ba92ae469b','volumes',-1,'2025-12-07 07:58:17',NULL),('2025-12-06 07:58:17','2025-12-06 07:58:18','2025-12-06 07:58:18',1,486,'aaceca50-eca7-4b51-a6fb-336b450e1287',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',-1,'2025-12-07 07:58:17',NULL),('2025-12-06 07:58:17','2025-12-06 07:58:18','2025-12-06 07:58:18',1,487,'c757d163-e7bf-43db-8b6e-96c8ce932a4c',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',-1,'2025-12-07 07:58:17',NULL),('2025-12-06 07:58:17','2025-12-06 07:58:18','2025-12-06 07:58:18',1,488,'d3e1748b-1ec4-4fdd-8261-757a97bb2289',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',-1,'2025-12-07 07:58:17',NULL),('2025-12-06 07:58:22','2025-12-06 07:58:22','2025-12-06 07:58:22',1,489,'7f3ec585-5976-409d-b1b0-0bf84910fd76',117,'63df107b8bd14504974c75ba92ae469b','volumes',-1,'2025-12-07 07:58:22',NULL),('2025-12-06 07:58:22','2025-12-06 07:58:22','2025-12-06 07:58:22',1,490,'69f1feef-4bde-4d7d-964f-c267fc381699',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',-1,'2025-12-07 07:58:22',NULL),('2025-12-06 07:58:22','2025-12-06 07:58:22','2025-12-06 07:58:22',1,491,'e32aa951-c286-4ba1-8de4-35211981f59f',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',-1,'2025-12-07 07:58:22',NULL),('2025-12-06 07:58:22','2025-12-06 07:58:22','2025-12-06 07:58:22',1,492,'22dc661e-0bf9-4eed-94b1-bf214c03d276',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',-1,'2025-12-07 07:58:22',NULL),('2025-12-06 07:58:24','2025-12-06 07:58:24','2025-12-06 07:58:24',1,493,'0485866d-7349-4658-b5bb-e39f8cf45086',117,'63df107b8bd14504974c75ba92ae469b','volumes',-1,'2025-12-07 07:58:24',NULL),('2025-12-06 07:58:24','2025-12-06 07:58:24','2025-12-06 07:58:24',1,494,'1542a932-7505-46d7-827d-8cf8a1c9d5dd',118,'63df107b8bd14504974c75ba92ae469b','gigabytes',-1,'2025-12-07 07:58:24',NULL),('2025-12-06 07:58:24','2025-12-06 07:58:24','2025-12-06 07:58:24',1,495,'7371cfd0-8071-4768-b1fa-85fbcaa8a1cd',119,'63df107b8bd14504974c75ba92ae469b','volumes___DEFAULT__',-1,'2025-12-07 07:58:24',NULL),('2025-12-06 07:58:24','2025-12-06 07:58:24','2025-12-06 07:58:24',1,496,'7c2e51e2-b51c-4a0f-a302-a51a0797c32a',120,'63df107b8bd14504974c75ba92ae469b','gigabytes___DEFAULT__',-1,'2025-12-07 07:58:24',NULL),('2025-12-06 07:58:38','2025-12-06 07:58:38','2025-12-06 07:58:38',1,497,'2aa68fd9-1c57-4426-99f2-4ca3fee84e35',129,'c3c0564f8e9f4af9ae5b597a275c989f','volumes',1,'2025-12-07 07:58:38',NULL),('2025-12-06 07:58:38','2025-12-06 07:58:38','2025-12-06 07:58:38',1,498,'5d9dffc8-a663-49ce-a68d-a29463b0f579',130,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes',1,'2025-12-07 07:58:38',NULL),('2025-12-06 07:58:38','2025-12-06 07:58:38','2025-12-06 07:58:38',1,499,'71a2d3ae-6e51-491c-83b2-f5e1face5564',131,'c3c0564f8e9f4af9ae5b597a275c989f','volumes___DEFAULT__',1,'2025-12-07 07:58:38',NULL),('2025-12-06 07:58:38','2025-12-06 07:58:38','2025-12-06 07:58:38',1,500,'0ffed70f-737c-41cf-8321-baed63cfeaa8',132,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes___DEFAULT__',1,'2025-12-07 07:58:38',NULL),('2025-12-06 08:00:51','2025-12-06 08:00:51','2025-12-06 08:00:51',1,501,'4dbf709f-c9fc-46e9-b79d-60d8c7ae433e',129,'c3c0564f8e9f4af9ae5b597a275c989f','volumes',-1,'2025-12-07 08:00:51',NULL),('2025-12-06 08:00:51','2025-12-06 08:00:51','2025-12-06 08:00:51',1,502,'dae9a969-3837-45c2-941f-e74752bd7ffe',130,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes',-1,'2025-12-07 08:00:51',NULL),('2025-12-06 08:00:51','2025-12-06 08:00:51','2025-12-06 08:00:51',1,503,'f7dd52d7-7730-4a48-b6e5-a41a4483aee4',131,'c3c0564f8e9f4af9ae5b597a275c989f','volumes___DEFAULT__',-1,'2025-12-07 08:00:51',NULL),('2025-12-06 08:00:51','2025-12-06 08:00:51','2025-12-06 08:00:51',1,504,'58c7033d-91c4-446e-91b4-5eb406692bc7',132,'c3c0564f8e9f4af9ae5b597a275c989f','gigabytes___DEFAULT__',-1,'2025-12-07 08:00:51',NULL),('2025-12-06 08:15:35','2025-12-06 08:15:35','2025-12-06 08:15:35',1,505,'102376eb-dca5-4230-bad6-3987ed9c4d6e',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:15:35',NULL),('2025-12-06 08:15:35','2025-12-06 08:15:35','2025-12-06 08:15:35',1,506,'79d8917c-ac1c-4153-9ede-75a9691de6ad',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:15:35',NULL),('2025-12-06 08:15:35','2025-12-06 08:15:35','2025-12-06 08:15:35',1,507,'95710d50-7cdc-454f-a4f9-f1f0cccaa6b6',135,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes_tempest-scenario-type-luks-1522269493',1,'2025-12-07 08:15:35',NULL),('2025-12-06 08:15:35','2025-12-06 08:15:35','2025-12-06 08:15:35',1,508,'4c1188e7-50ea-4de4-92b0-071afa5ec3f5',136,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes_tempest-scenario-type-luks-1522269493',1,'2025-12-07 08:15:35',NULL),('2025-12-06 08:16:09','2025-12-06 08:16:09','2025-12-06 08:16:09',1,509,'36d69ab4-4b50-40c1-89f7-f6dc0df3f1c2',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:16:09',NULL),('2025-12-06 08:16:09','2025-12-06 08:16:09','2025-12-06 08:16:09',1,510,'6b4ef86d-8347-4a21-9218-87904ac27a59',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:16:09',NULL),('2025-12-06 08:16:09','2025-12-06 08:16:09','2025-12-06 08:16:09',1,511,'39dd92e9-3293-42fe-ac96-f31ce5a244a2',135,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes_tempest-scenario-type-luks-1522269493',-1,'2025-12-07 08:16:09',NULL),('2025-12-06 08:16:09','2025-12-06 08:16:09','2025-12-06 08:16:09',1,512,'d6e9760a-d12d-49b2-8f6e-04a4573f43dd',136,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes_tempest-scenario-type-luks-1522269493',-1,'2025-12-07 08:16:09',NULL),('2025-12-06 08:16:12','2025-12-06 08:16:12','2025-12-06 08:16:12',1,513,'ab74a85a-96a0-4ab1-80e8-e6e097890e20',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:16:12',NULL),('2025-12-06 08:16:12','2025-12-06 08:16:12','2025-12-06 08:16:12',1,514,'88e61990-6368-4e0a-ac05-e185564fa648',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:16:12',NULL),('2025-12-06 08:16:12','2025-12-06 08:16:12','2025-12-06 08:16:12',1,515,'32e5183b-9ba1-4848-a7d3-5b1d419f18de',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:16:12',NULL),('2025-12-06 08:16:12','2025-12-06 08:16:12','2025-12-06 08:16:12',1,516,'7dca4457-8996-4d1f-9542-1e5374808a3f',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:16:12',NULL),('2025-12-06 08:16:20','2025-12-06 08:16:20','2025-12-06 08:16:20',1,517,'facd3b3c-ef2f-41f3-95e1-cf72c038897c',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',1,'2025-12-07 08:16:20',NULL),('2025-12-06 08:16:20','2025-12-06 08:16:20','2025-12-06 08:16:20',1,518,'aa4f26a5-9ce3-412f-8fab-8cccd0a46697',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:16:20',NULL),('2025-12-06 08:16:20','2025-12-06 08:16:20','2025-12-06 08:16:20',1,519,'425743c3-0ad1-4335-b0ee-c1274cd92de2',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:16:20',NULL),('2025-12-06 08:16:20','2025-12-06 08:16:20','2025-12-06 08:16:20',1,520,'3d21a50d-fdf6-47fd-ba2d-634c1d8153dc',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',1,'2025-12-07 08:16:20',NULL),('2025-12-06 08:16:31','2025-12-06 08:16:31','2025-12-06 08:16:31',1,521,'70b01a68-ad74-4249-a8e2-90aebfe8ab3d',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:16:31',NULL),('2025-12-06 08:16:31','2025-12-06 08:16:31','2025-12-06 08:16:31',1,522,'9b616aba-0ff2-458d-b1c5-9967f5699186',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:16:31',NULL),('2025-12-06 08:16:31','2025-12-06 08:16:31','2025-12-06 08:16:31',1,523,'b3cdaa0d-81d4-4740-b9d2-d3bc488c3096',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:16:31',NULL),('2025-12-06 08:16:31','2025-12-06 08:16:31','2025-12-06 08:16:31',1,524,'9cb160d9-4b5f-4636-89e7-36ff3450c0f5',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:16:31',NULL),('2025-12-06 08:16:51','2025-12-06 08:16:51','2025-12-06 08:16:51',1,525,'a9d693d9-f793-4e07-9077-eb3fe4514310',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:16:51',NULL),('2025-12-06 08:16:51','2025-12-06 08:16:51','2025-12-06 08:16:51',1,526,'e0b95212-6456-4094-9466-2781fca0c611',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:16:51',NULL),('2025-12-06 08:16:51','2025-12-06 08:16:51','2025-12-06 08:16:51',1,527,'6d81ef49-107d-4c45-a23a-b7fb7e7d1c35',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:16:51',NULL),('2025-12-06 08:16:51','2025-12-06 08:16:51','2025-12-06 08:16:51',1,528,'2290bdf7-558d-467d-bc85-be31643c9f3e',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:16:51',NULL),('2025-12-06 08:16:53','2025-12-06 08:16:53','2025-12-06 08:16:53',1,529,'a4c5f67d-fea8-4f1e-b270-a9bdc197b54f',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',-1,'2025-12-07 08:16:53',NULL),('2025-12-06 08:16:53','2025-12-06 08:16:53','2025-12-06 08:16:53',1,530,'87272e58-8ebf-4515-94e5-2e49394e141e',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:16:53',NULL),('2025-12-06 08:16:53','2025-12-06 08:16:53','2025-12-06 08:16:53',1,531,'7613a78f-cc37-4733-83e8-ad8962378a11',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:16:53',NULL),('2025-12-06 08:16:53','2025-12-06 08:16:53','2025-12-06 08:16:53',1,532,'6f37d59b-7375-4c1b-bd88-eb8272ed1c05',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',-1,'2025-12-07 08:16:53',NULL),('2025-12-06 08:16:54','2025-12-06 08:16:54','2025-12-06 08:16:54',1,533,'c6d46e2d-0c5f-4571-9040-66594e94b4fe',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:16:54',NULL),('2025-12-06 08:16:54','2025-12-06 08:16:54','2025-12-06 08:16:54',1,534,'2d263307-e41b-4760-9023-4519d1c93c08',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:16:54',NULL),('2025-12-06 08:16:54','2025-12-06 08:16:54','2025-12-06 08:16:54',1,535,'c53d0a9f-5de2-4c6b-857b-12c69b97cd1b',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:16:54',NULL),('2025-12-06 08:16:54','2025-12-06 08:16:54','2025-12-06 08:16:54',1,536,'d200982b-6171-4c34-b1bd-a275330ec659',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:16:54',NULL),('2025-12-06 08:16:56','2025-12-06 08:16:56','2025-12-06 08:16:56',1,537,'6de2cb5c-50a7-4f5a-941b-345cc284ec51',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:16:56',NULL),('2025-12-06 08:16:56','2025-12-06 08:16:56','2025-12-06 08:16:56',1,538,'fa0f179f-9ca6-490e-acb3-3bba83382ef3',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:16:56',NULL),('2025-12-06 08:16:56','2025-12-06 08:16:56','2025-12-06 08:16:56',1,539,'b5955115-6551-4c2d-9126-798928dae2b9',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:16:56',NULL),('2025-12-06 08:16:56','2025-12-06 08:16:56','2025-12-06 08:16:56',1,540,'d020e51e-b337-4325-9bb4-42e680e8006e',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:16:56',NULL),('2025-12-06 08:17:44','2025-12-06 08:17:45','2025-12-06 08:17:45',1,541,'48adf4c1-179d-44c0-88f1-4aa91a891313',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',1,'2025-12-07 08:17:44',NULL),('2025-12-06 08:17:44','2025-12-06 08:17:45','2025-12-06 08:17:45',1,542,'432d422e-ce12-4900-9726-804dde68fb06',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:17:44',NULL),('2025-12-06 08:17:44','2025-12-06 08:17:45','2025-12-06 08:17:45',1,543,'a6434662-f05c-4873-b60b-e8adf8d64471',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:17:44',NULL),('2025-12-06 08:17:44','2025-12-06 08:17:45','2025-12-06 08:17:45',1,544,'1ec0f4cd-45cd-4f5e-bf11-8cd25a66d7cf',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',1,'2025-12-07 08:17:44',NULL),('2025-12-06 08:17:56','2025-12-06 08:17:56','2025-12-06 08:17:56',1,545,'9fe12594-c749-48bf-869c-be7401ca206d',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:17:56',NULL),('2025-12-06 08:17:56','2025-12-06 08:17:56','2025-12-06 08:17:56',1,546,'469791eb-3034-4348-894a-07582e470877',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:17:56',NULL),('2025-12-06 08:17:56','2025-12-06 08:17:56','2025-12-06 08:17:56',1,547,'d8dc0cf5-136f-4006-b4a8-320e7ec1f5e5',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:17:56',NULL),('2025-12-06 08:17:56','2025-12-06 08:17:56','2025-12-06 08:17:56',1,548,'4e5f7258-cf0a-4fe3-8d96-869d3e179aeb',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:17:56',NULL),('2025-12-06 08:18:44','2025-12-06 08:18:44','2025-12-06 08:18:44',1,549,'5e5c1bcf-3a9c-4efe-b59d-35a21a9f521c',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:18:44',NULL),('2025-12-06 08:18:44','2025-12-06 08:18:44','2025-12-06 08:18:44',1,550,'19576f1d-fd48-42a2-ac93-854d4cec2c77',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:18:44',NULL),('2025-12-06 08:18:44','2025-12-06 08:18:44','2025-12-06 08:18:44',1,551,'01a7fa06-fb4c-415f-8245-80fb64f0040c',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:18:44',NULL),('2025-12-06 08:18:44','2025-12-06 08:18:44','2025-12-06 08:18:44',1,552,'4e74671d-84bf-48da-b1d1-551a88de2a11',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:18:44',NULL),('2025-12-06 08:18:45','2025-12-06 08:18:45','2025-12-06 08:18:45',1,553,'511dcdb4-a36d-440a-bad6-babffc750210',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',-1,'2025-12-07 08:18:45',NULL),('2025-12-06 08:18:45','2025-12-06 08:18:45','2025-12-06 08:18:45',1,554,'30be7a85-89a3-4f7e-a717-5b267065270f',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:18:45',NULL),('2025-12-06 08:18:45','2025-12-06 08:18:45','2025-12-06 08:18:45',1,555,'65f1e76f-18a6-4ed2-aea1-d98ec90666e8',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:18:45',NULL),('2025-12-06 08:18:45','2025-12-06 08:18:45','2025-12-06 08:18:45',1,556,'5220023b-25d9-4731-b787-767163345ab6',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',-1,'2025-12-07 08:18:45',NULL),('2025-12-06 08:18:49','2025-12-06 08:18:49','2025-12-06 08:18:49',1,557,'11d326f9-8152-4877-8b71-a0bea9727e58',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:18:49',NULL),('2025-12-06 08:18:49','2025-12-06 08:18:49','2025-12-06 08:18:49',1,558,'a16f7721-1fe2-46b6-be89-f0a78cd1f572',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:18:49',NULL),('2025-12-06 08:18:49','2025-12-06 08:18:49','2025-12-06 08:18:49',1,559,'91a2eb77-81fe-4fa0-8e19-48a941839923',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:18:49',NULL),('2025-12-06 08:18:49','2025-12-06 08:18:49','2025-12-06 08:18:49',1,560,'e03de4db-1cae-4931-86d7-cc21d5c4eece',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:18:49',NULL),('2025-12-06 08:19:11','2025-12-06 08:19:11','2025-12-06 08:19:11',1,561,'7c25609a-ee66-4d31-bef0-b014bfd84435',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:19:11',NULL),('2025-12-06 08:19:11','2025-12-06 08:19:11','2025-12-06 08:19:11',1,562,'acedeff0-1db8-491a-b2f2-ad56d2b6a97e',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:19:11',NULL),('2025-12-06 08:19:11','2025-12-06 08:19:11','2025-12-06 08:19:11',1,563,'546069da-c593-42f8-874c-c2b4f7a7dd65',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:19:11',NULL),('2025-12-06 08:19:11','2025-12-06 08:19:11','2025-12-06 08:19:11',1,564,'cf975c64-8c3f-424a-863f-efe1aab103ef',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:19:11',NULL),('2025-12-06 08:21:05','2025-12-06 08:21:07','2025-12-06 08:21:07',1,565,'8f3f01f4-bac3-4549-8921-d3203c35a706',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',1,'2025-12-07 08:21:05',NULL),('2025-12-06 08:21:05','2025-12-06 08:21:07','2025-12-06 08:21:07',1,566,'b97d559e-5006-4d09-b945-a5a051e72c9e',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:21:05',NULL),('2025-12-06 08:21:05','2025-12-06 08:21:07','2025-12-06 08:21:07',1,567,'05dac085-ca60-458a-ae15-8e72485b1e32',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:21:05',NULL),('2025-12-06 08:21:05','2025-12-06 08:21:07','2025-12-06 08:21:07',1,568,'ebefa6a4-0358-42df-b220-512fdfdd63e9',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',1,'2025-12-07 08:21:05',NULL),('2025-12-06 08:21:09','2025-12-06 08:21:09','2025-12-06 08:21:09',1,569,'5a81e733-20f4-4392-aaf8-e6101d4e511e',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',1,'2025-12-07 08:21:09',NULL),('2025-12-06 08:21:09','2025-12-06 08:21:09','2025-12-06 08:21:09',1,570,'aa6d5894-9b64-43be-a98f-457425630283',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',1,'2025-12-07 08:21:09',NULL),('2025-12-06 08:21:09','2025-12-06 08:21:09','2025-12-06 08:21:09',1,571,'c5986383-fbf0-4e8a-bcb6-abacd3e80f02',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',1,'2025-12-07 08:21:09',NULL),('2025-12-06 08:21:09','2025-12-06 08:21:09','2025-12-06 08:21:09',1,572,'55549868-a48b-4518-ab91-dd502d19ab90',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',1,'2025-12-07 08:21:09',NULL),('2025-12-06 08:22:11','2025-12-06 08:22:11','2025-12-06 08:22:11',1,573,'11c1ce57-962a-4954-b8da-fa3eae277e7b',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:22:11',NULL),('2025-12-06 08:22:11','2025-12-06 08:22:11','2025-12-06 08:22:11',1,574,'274c6395-54a6-4cb7-a624-33b94b9c7ce6',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:22:11',NULL),('2025-12-06 08:22:11','2025-12-06 08:22:11','2025-12-06 08:22:11',1,575,'85d5e7fa-b11e-48ea-bdf6-effb4f84d918',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:22:11',NULL),('2025-12-06 08:22:11','2025-12-06 08:22:11','2025-12-06 08:22:11',1,576,'2d498c75-c0fe-45d6-9192-8d04f1930968',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:22:11',NULL),('2025-12-06 08:22:14','2025-12-06 08:22:14','2025-12-06 08:22:14',1,577,'bba2c5b5-abe3-4f58-b286-ce657b826356',139,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots',-1,'2025-12-07 08:22:14',NULL),('2025-12-06 08:22:14','2025-12-06 08:22:14','2025-12-06 08:22:14',1,578,'cdd53b09-5caf-4fff-96ad-7bea3592f362',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:22:14',NULL),('2025-12-06 08:22:14','2025-12-06 08:22:14','2025-12-06 08:22:14',1,579,'03cb0914-69d1-4315-b9ab-bbbb63602e90',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:22:14',NULL),('2025-12-06 08:22:14','2025-12-06 08:22:14','2025-12-06 08:22:14',1,580,'93d2c080-ef99-451d-b763-2e71dd91869c',140,'4b2dc4b8729f446a9c7ac69ca446f71d','snapshots___DEFAULT__',-1,'2025-12-07 08:22:14',NULL),('2025-12-06 08:22:27','2025-12-06 08:22:27','2025-12-06 08:22:27',1,581,'159dfc9c-cc93-42dd-8c06-c19d7cf93ad2',133,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes',-1,'2025-12-07 08:22:27',NULL),('2025-12-06 08:22:27','2025-12-06 08:22:27','2025-12-06 08:22:27',1,582,'45d2d0b7-1442-409a-80e7-2b28e36fe832',134,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes',-1,'2025-12-07 08:22:27',NULL),('2025-12-06 08:22:27','2025-12-06 08:22:27','2025-12-06 08:22:27',1,583,'d99fa752-6461-4131-a997-aefb16d164af',137,'4b2dc4b8729f446a9c7ac69ca446f71d','volumes___DEFAULT__',-1,'2025-12-07 08:22:27',NULL),('2025-12-06 08:22:27','2025-12-06 08:22:27','2025-12-06 08:22:27',1,584,'5cc9ea36-2b8a-4c68-99a8-163f2717bc91',138,'4b2dc4b8729f446a9c7ac69ca446f71d','gigabytes___DEFAULT__',-1,'2025-12-07 08:22:27',NULL),('2025-12-06 08:27:27','2025-12-06 08:27:27','2025-12-06 08:27:27',1,585,'cab4f780-9d1f-432a-b3d8-1dd338cf7d51',141,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes',1,'2025-12-07 08:27:27',NULL),('2025-12-06 08:27:27','2025-12-06 08:27:27','2025-12-06 08:27:27',1,586,'c2fa75bb-6cb7-4b65-9e05-ce8f819a976c',142,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes',1,'2025-12-07 08:27:27',NULL),('2025-12-06 08:27:27','2025-12-06 08:27:27','2025-12-06 08:27:27',1,587,'d50609ee-16b9-4734-90f5-b19ff0e63ca4',143,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes___DEFAULT__',1,'2025-12-07 08:27:27',NULL),('2025-12-06 08:27:27','2025-12-06 08:27:27','2025-12-06 08:27:27',1,588,'7c187ce1-0aff-49cf-bf49-3c2e436eb2ac',144,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes___DEFAULT__',1,'2025-12-07 08:27:27',NULL),('2025-12-06 08:27:36','2025-12-06 08:27:36','2025-12-06 08:27:36',1,589,'6373ce87-2c96-41ec-8eb0-d71619fb9c1c',145,'55d0236410514dd9ad6cdb3e1a5d0ee6','backups',1,'2025-12-07 08:27:36',NULL),('2025-12-06 08:27:36','2025-12-06 08:27:36','2025-12-06 08:27:36',1,590,'4bf51d55-3f2a-4237-be17-482724873916',146,'55d0236410514dd9ad6cdb3e1a5d0ee6','backup_gigabytes',1,'2025-12-07 08:27:36',NULL),('2025-12-06 08:27:43','2025-12-06 08:27:43','2025-12-06 08:27:43',1,591,'63174d18-1678-42f8-98cc-45f28c1b9e71',141,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes',1,'2025-12-07 08:27:43',NULL),('2025-12-06 08:27:43','2025-12-06 08:27:43','2025-12-06 08:27:43',1,592,'c8659209-6cd3-4d64-8204-f93f6108551b',142,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes',1,'2025-12-07 08:27:43',NULL),('2025-12-06 08:27:43','2025-12-06 08:27:43','2025-12-06 08:27:43',1,593,'585a6f39-2436-4379-b65f-85cd2c36c784',143,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes___DEFAULT__',1,'2025-12-07 08:27:43',NULL),('2025-12-06 08:27:43','2025-12-06 08:27:43','2025-12-06 08:27:43',1,594,'8b84418c-8960-4783-84ad-56bc6c823b99',144,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes___DEFAULT__',1,'2025-12-07 08:27:43',NULL),('2025-12-06 08:28:26','2025-12-06 08:28:26','2025-12-06 08:28:26',1,595,'e78884f3-aa37-48ef-a8f0-3f8a1dc41ce2',141,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes',-1,'2025-12-07 08:28:26',NULL),('2025-12-06 08:28:26','2025-12-06 08:28:26','2025-12-06 08:28:26',1,596,'7ffcd18c-5943-4df2-85d1-bd3b3a307cab',142,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes',-1,'2025-12-07 08:28:26',NULL),('2025-12-06 08:28:26','2025-12-06 08:28:26','2025-12-06 08:28:26',1,597,'b142d19e-1f53-4771-8fb4-59f9155541bb',143,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes___DEFAULT__',-1,'2025-12-07 08:28:26',NULL),('2025-12-06 08:28:26','2025-12-06 08:28:26','2025-12-06 08:28:26',1,598,'2a9ccdbb-9848-4613-81cb-647e9f3967c9',144,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes___DEFAULT__',-1,'2025-12-07 08:28:26',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,599,'496ebb1b-be3a-4561-a554-54ed3d097153',141,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes',-1,'2025-12-07 08:28:27',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,600,'d0fae543-494c-4d3d-b041-c8694a5546b0',142,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes',-1,'2025-12-07 08:28:27',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,601,'5eea46bb-9d5f-4a7b-9094-1a16c82349db',143,'55d0236410514dd9ad6cdb3e1a5d0ee6','volumes___DEFAULT__',-1,'2025-12-07 08:28:27',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,602,'9bde065c-ba95-435a-b658-b8dc77439c19',144,'55d0236410514dd9ad6cdb3e1a5d0ee6','gigabytes___DEFAULT__',-1,'2025-12-07 08:28:27',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,603,'5d8327d6-1997-48bd-8581-d8213d95cb98',145,'55d0236410514dd9ad6cdb3e1a5d0ee6','backups',-1,'2025-12-07 08:28:27',NULL),('2025-12-06 08:28:27','2025-12-06 08:28:27','2025-12-06 08:28:27',1,604,'2c92780d-6b60-4636-847e-005dc9e90573',146,'55d0236410514dd9ad6cdb3e1a5d0ee6','backup_gigabytes',-1,'2025-12-07 08:28:27',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-06 06:10:01','2025-12-06 08:52:39',NULL,0,1,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',971,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'e277ef27-48d7-4b9e-8f27-10df3f6e41f5'),('2025-12-06 06:53:11','2025-12-06 08:52:35',NULL,0,2,'cinder-backup-0','cinder-backup','cinder-backup',716,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'575da7b0-3b4b-4955-ae6d-11393488cbf2'),('2025-12-06 06:53:11','2025-12-06 08:52:34',NULL,0,3,'hostgroup@ceph','cinder-volume','cinder-volume',715,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-12-06 07:50:40','2025-12-06 07:51:03','2025-12-06 07:51:04',1,'1a9003f5-0e3e-4def-83f2-28294fb43fa7','1c4642f5-e00c-416f-9c41-e5aa7293d85b','0f669e963dc54ad7bebf8dd20341428a','0c8fc5bc237e42bfad505a0bca6681eb','deleted','100%',1,NULL,'tempest-TestMinimumBasicScenario-snapshot-1207991945',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1),('2025-12-06 08:16:20','2025-12-06 08:16:51','2025-12-06 08:16:53',1,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','4275992e-c3b8-40ee-88ea-39dad5a19265','8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-732636127',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1),('2025-12-06 08:21:06','2025-12-06 08:22:13','2025-12-06 08:22:14',1,'7d12a72c-e009-4022-8c27-07aaf6d67092','51b925ec-146c-45cc-ba59-9db845a18e81','8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','deleted','100%',1,NULL,'tempest-TestVolumeBootPattern-snapshot-820322425',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1),('2025-12-06 08:17:44','2025-12-06 08:18:44','2025-12-06 08:18:45',1,'8c532b5e-c264-4201-a213-9aa271d92ee9','aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1','8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','deleted','100%',1,NULL,'snapshot for tempest-TestVolumeBootPatternsnapshot-107678206',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1),('2025-12-06 07:46:16','2025-12-06 07:46:20','2025-12-06 07:46:21',1,'8f12007c-0695-4a20-8935-b2de758d55ec','0a5b51e1-c033-46c2-82b0-6283b345dd9a','45451a914c994cd69359ed7c4e71ec0a','40da133fd2cc44f4b03dfcaa8d2a67a6','deleted','100%',1,NULL,'tempest-VolumesSnapshotsTestJSON-Snapshot-1420374706',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1),('2025-12-06 07:39:37','2025-12-06 07:39:49','2025-12-06 07:39:51',1,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','67ebc469-c3e0-45da-a1b6-9f2891a4f2a7','605b5481e0c944048e6a67046c30d693','833f4cf9f5a64b2ab94c3bf330353a31','deleted','100%',1,NULL,'snapshot for multiattach-snapshot',NULL,NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,NULL,NULL,NULL,1),('2025-12-06 07:51:29','2025-12-06 07:53:06','2025-12-06 07:53:08',1,'ca43e69d-85f3-4654-8bd9-bdfc55d6116e','3c0c17ef-cec5-45f2-956d-446361af61f4','4962bc7b172346e19d127b46ea2d7a11','c4cf19b89a6d46bca307e65731a9dd21','deleted','100%',1,NULL,'tempest-TestStampPattern-snapshot-1172738265',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-12-06 07:45:43','2025-12-06 07:45:47','2025-12-06 07:45:47',1,'0299eeaa-32ac-40fc-92e9-a9d346380c58','15c50314-82b8-4e1c-81d1-ad7ba14c56de','compute-2.ctlplane.example.com','d66a90db-5589-4b7f-b805-4096fffbd9f8','/dev/vdb','2025-12-06 07:45:44','2025-12-06 07:45:47','rw','detached','{\"name\": \"volumes/volume-15c50314-82b8-4e1c-81d1-ad7ba14c56de\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"15c50314-82b8-4e1c-81d1-ad7ba14c56de\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0299eeaa-32ac-40fc-92e9-a9d346380c58\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:20:24','2025-12-06 08:22:21','2025-12-06 08:22:21',1,'0376b513-a863-4882-9990-f00c95971e30','51b925ec-146c-45cc-ba59-9db845a18e81','compute-0.ctlplane.example.com','f2b69bc0-d3ae-4f20-9026-421ff6537c3f','/dev/vda','2025-12-06 08:20:30','2025-12-06 08:22:21','rw','detached','{\"name\": \"volumes/volume-51b925ec-146c-45cc-ba59-9db845a18e81\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"51b925ec-146c-45cc-ba59-9db845a18e81\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0376b513-a863-4882-9990-f00c95971e30\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:57:43','2025-12-06 07:57:53','2025-12-06 07:57:53',1,'07facc5c-dc70-489d-99ff-b91176773f2a','b338aabc-085b-43e3-adbc-b55bb8505744','compute-0.ctlplane.example.com','3bd60b1c-0294-4922-a147-cf09dadee874','/dev/vdb','2025-12-06 07:57:44','2025-12-06 07:57:53','rw','detached','{\"name\": \"volumes/volume-b338aabc-085b-43e3-adbc-b55bb8505744\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"b338aabc-085b-43e3-adbc-b55bb8505744\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"07facc5c-dc70-489d-99ff-b91176773f2a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:47:50','2025-12-06 07:47:59','2025-12-06 07:47:59',1,'08050d54-8477-42c7-a114-d7e13e3651ee','d3873e66-0cd3-4a84-b18d-551e693a7554','compute-2.ctlplane.example.com','e268006c-e26b-4400-8c9a-da1925cd1a57','/dev/vdb','2025-12-06 07:47:52','2025-12-06 07:47:59','rw','detached','{\"name\": \"volumes/volume-d3873e66-0cd3-4a84-b18d-551e693a7554\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"d3873e66-0cd3-4a84-b18d-551e693a7554\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"08050d54-8477-42c7-a114-d7e13e3651ee\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:52:37','2025-12-06 07:52:46','2025-12-06 07:52:46',1,'0853f26e-9475-461f-837c-4ce0b71081e7','5cd6cf93-6842-435d-92c9-f0e7f8a0e1f7','compute-0.ctlplane.example.com','822fc37e-13a4-4b1b-983f-6cc928c1dfa3','/dev/vdb','2025-12-06 07:52:39','2025-12-06 07:52:46','rw','detached','{\"name\": \"volumes/volume-5cd6cf93-6842-435d-92c9-f0e7f8a0e1f7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5cd6cf93-6842-435d-92c9-f0e7f8a0e1f7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0853f26e-9475-461f-837c-4ce0b71081e7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:25:39','2025-12-06 07:26:00','2025-12-06 07:26:00',1,'0c6cc203-8dde-49d6-ad46-ef5abf12f4f3','5061c285-a1ac-4ce6-96b8-9bd9d7f18a74','compute-1.ctlplane.example.com','8ace964d-3645-4195-8f65-8b625bce1b00','/dev/vdb','2025-12-06 07:25:42','2025-12-06 07:26:00','rw','detached','{\"name\": \"volumes/volume-5061c285-a1ac-4ce6-96b8-9bd9d7f18a74\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5061c285-a1ac-4ce6-96b8-9bd9d7f18a74\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"0c6cc203-8dde-49d6-ad46-ef5abf12f4f3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:21:20','2025-12-06 08:22:07','2025-12-06 08:22:07',1,'10a5a500-79ad-4389-83b0-797a05fcdb28','09c93a0a-7903-4f14-b7b3-cc5eeb590680','compute-2.ctlplane.example.com','a7305638-446a-410d-8da1-2a2e5ddfa894','/dev/vda','2025-12-06 08:21:28','2025-12-06 08:22:07','rw','detached','{\"name\": \"volumes/volume-09c93a0a-7903-4f14-b7b3-cc5eeb590680\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"09c93a0a-7903-4f14-b7b3-cc5eeb590680\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"10a5a500-79ad-4389-83b0-797a05fcdb28\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:30:04','2025-12-06 07:32:21','2025-12-06 07:32:21',1,'14554c76-4c07-4f31-8b77-0531073660cd','6db274ff-02a7-4513-aa8b-c44494100a39','compute-2.ctlplane.example.com','02b3a680-d1bd-462f-95dc-aa0934c7ceac','/dev/vdc','2025-12-06 07:30:14','2025-12-06 07:32:21','rw','detached','{\"name\": \"volumes/volume-6db274ff-02a7-4513-aa8b-c44494100a39\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"6db274ff-02a7-4513-aa8b-c44494100a39\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"14554c76-4c07-4f31-8b77-0531073660cd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:57:48','2025-12-06 07:57:55','2025-12-06 07:57:55',1,'1648adba-2716-478f-9583-31d19f3d0ba2','eb0607fb-3d18-4469-8db9-a7f938c59ae5','compute-0.ctlplane.example.com','3bd60b1c-0294-4922-a147-cf09dadee874','/dev/vdc','2025-12-06 07:57:49','2025-12-06 07:57:55','rw','detached','{\"name\": \"volumes/volume-eb0607fb-3d18-4469-8db9-a7f938c59ae5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"eb0607fb-3d18-4469-8db9-a7f938c59ae5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1648adba-2716-478f-9583-31d19f3d0ba2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:33:13','2025-12-06 07:40:40','2025-12-06 07:40:40',1,'177787eb-317a-4b17-abb9-a2eae2295c31','d2147d68-ea53-4b01-b660-c00c430f356d','compute-2.ctlplane.example.com','6a50a40c-3b05-4c0e-aa67-1489e203824e','/dev/vda','2025-12-06 07:33:19','2025-12-06 07:40:40','rw','detached','{\"name\": \"volumes/volume-d2147d68-ea53-4b01-b660-c00c430f356d\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"d2147d68-ea53-4b01-b660-c00c430f356d\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"177787eb-317a-4b17-abb9-a2eae2295c31\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:03:33','2025-12-06 07:03:53','2025-12-06 07:03:53',1,'19eb40c2-5f93-4980-80e2-674cb32592fa','82a6fabc-b798-4571-a13e-f9c67a3f9413','compute-2.ctlplane.example.com','4dd1863a-3cb1-4e42-8611-ed9587a0b6ce','/dev/vda','2025-12-06 07:03:34','2025-12-06 07:03:53','null','detached','{\"name\": \"volumes/volume-82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"19eb40c2-5f93-4980-80e2-674cb32592fa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-12-06 07:53:00','2025-12-06 07:54:12','2025-12-06 07:54:12',1,'1f746326-4f3f-419f-9f12-fd6263259048','903b6ad8-93b6-4571-9ff7-80ce95667ba0','compute-1.ctlplane.example.com','4d2e7124-8b09-4fd5-bc94-c2c9a3d964af','/dev/vdb','2025-12-06 07:53:01','2025-12-06 07:54:12','rw','detached','{\"name\": \"volumes/volume-903b6ad8-93b6-4571-9ff7-80ce95667ba0\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"903b6ad8-93b6-4571-9ff7-80ce95667ba0\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1f746326-4f3f-419f-9f12-fd6263259048\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:02:46','2025-12-06 07:03:19','2025-12-06 07:03:19',1,'1f7e2e99-fed4-47ad-9a87-fb8a1b33200d','82a6fabc-b798-4571-a13e-f9c67a3f9413','compute-2.ctlplane.example.com','4dd1863a-3cb1-4e42-8611-ed9587a0b6ce','/dev/vda','2025-12-06 07:02:51','2025-12-06 07:03:19','rw','detached','{\"name\": \"volumes/volume-82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"1f7e2e99-fed4-47ad-9a87-fb8a1b33200d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:29:38','2025-12-06 07:30:20','2025-12-06 07:30:20',1,'21ca6e03-67ed-4dbc-bbaf-49d8d79cf1b2','f889bfdf-c600-4260-90f0-d332e8e3d79b','compute-1.ctlplane.example.com','6ee4f2f5-3303-4c84-b708-eb35a65082b6','/dev/vda','2025-12-06 07:29:46','2025-12-06 07:30:20','rw','detached','{\"name\": \"volumes/volume-f889bfdf-c600-4260-90f0-d332e8e3d79b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"f889bfdf-c600-4260-90f0-d332e8e3d79b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"21ca6e03-67ed-4dbc-bbaf-49d8d79cf1b2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:18:43','2025-12-06 07:19:36','2025-12-06 07:19:36',1,'2493396f-2b2d-40f4-92f6-42d8b6305e0d','b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4','compute-1.ctlplane.example.com','5f718fcb-597c-47a7-b738-1cd8d4b7b0de','/dev/vda','2025-12-06 07:18:53','2025-12-06 07:19:36','rw','detached','{\"name\": \"volumes/volume-b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"2493396f-2b2d-40f4-92f6-42d8b6305e0d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:55:12','2025-12-06 07:55:59','2025-12-06 07:55:59',1,'265aadc4-cb45-4d0e-961a-0c69172d5d36','4740f75b-6222-44e7-8496-fed71a346d64','compute-1.ctlplane.example.com','563d5f63-1ecc-4c65-855c-e375f6f97f29','/dev/vdb','2025-12-06 07:55:13','2025-12-06 07:55:59','rw','detached','{\"name\": \"volumes/volume-4740f75b-6222-44e7-8496-fed71a346d64\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"4740f75b-6222-44e7-8496-fed71a346d64\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"265aadc4-cb45-4d0e-961a-0c69172d5d36\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:51:05','2025-12-06 07:51:29','2025-12-06 07:51:29',1,'34e4d033-7d30-4dd0-a2cc-735fe90e8897','3c0c17ef-cec5-45f2-956d-446361af61f4','compute-1.ctlplane.example.com','e7d5d854-2a1f-485b-931a-4ec90cf7ba04','/dev/vdb','2025-12-06 07:51:23','2025-12-06 07:51:29','rw','detached','{\"name\": \"volumes/volume-3c0c17ef-cec5-45f2-956d-446361af61f4\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"3c0c17ef-cec5-45f2-956d-446361af61f4\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"34e4d033-7d30-4dd0-a2cc-735fe90e8897\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:55:47','2025-12-06 07:57:46','2025-12-06 07:57:46',1,'3e903a71-9fe4-4d3b-852b-f059add7a90f','38a07fdf-f182-4202-a84f-220c1b1f0f42','compute-1.ctlplane.example.com','5ae1d2f2-f2e3-43b3-8b37-94095588eb3a','/dev/vda','2025-12-06 07:55:50','2025-12-06 07:57:46','rw','detached','{\"name\": \"volumes/volume-38a07fdf-f182-4202-a84f-220c1b1f0f42\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"38a07fdf-f182-4202-a84f-220c1b1f0f42\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"3e903a71-9fe4-4d3b-852b-f059add7a90f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:05:14','2025-12-06 07:05:29','2025-12-06 07:05:29',1,'4665ccf9-8f21-4e2c-a697-a1594a9e57e7','2b74c89f-1018-4ad4-8af8-84109979b9c7','compute-2.ctlplane.example.com','1712064c-6ba8-4660-972f-1e827a40781a','/dev/vda','2025-12-06 07:05:15','2025-12-06 07:05:29','null','detached','{\"name\": \"volumes/volume-2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4665ccf9-8f21-4e2c-a697-a1594a9e57e7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-12-06 07:03:12','2025-12-06 07:03:38','2025-12-06 07:03:38',1,'48e3400e-42f6-4554-8920-994a6676cae0','82a6fabc-b798-4571-a13e-f9c67a3f9413','compute-1.ctlplane.example.com','4dd1863a-3cb1-4e42-8611-ed9587a0b6ce','/dev/vda','2025-12-06 07:03:13','2025-12-06 07:03:38','null','detached','{\"name\": \"volumes/volume-82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"82a6fabc-b798-4571-a13e-f9c67a3f9413\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"48e3400e-42f6-4554-8920-994a6676cae0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-12-06 07:55:44','2025-12-06 07:57:49','2025-12-06 07:57:49',1,'49dce9ff-d05f-47b8-be29-7f989b6b3505','bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92','compute-2.ctlplane.example.com','21c591a0-5eed-4aa8-a68b-59a616b16e2b','/dev/vda','2025-12-06 07:55:48','2025-12-06 07:57:49','rw','detached','{\"name\": \"volumes/volume-bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"49dce9ff-d05f-47b8-be29-7f989b6b3505\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:42:17','2025-12-06 07:43:25','2025-12-06 07:43:25',1,'4fee68e0-59a5-4e0f-9dd0-bfc35724e881','df0e5c71-5906-44fa-bff0-b66876c47ac5','compute-1.ctlplane.example.com','f50ab4f6-4d4c-488a-9793-0b9979a2e193','/dev/vdb','2025-12-06 07:42:19','2025-12-06 07:43:25','rw','detached','{\"name\": \"volumes/volume-df0e5c71-5906-44fa-bff0-b66876c47ac5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"df0e5c71-5906-44fa-bff0-b66876c47ac5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"4fee68e0-59a5-4e0f-9dd0-bfc35724e881\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:17:08','2025-12-06 08:18:48','2025-12-06 08:18:48',1,'555216c0-15c7-4dbd-ad53-603c7a858461','aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1','compute-2.ctlplane.example.com','02dd8ac7-35d8-410a-9ec7-05f6acfed2a1','/dev/vda','2025-12-06 08:17:11','2025-12-06 08:18:48','rw','detached','{\"name\": \"volumes/volume-aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"555216c0-15c7-4dbd-ad53-603c7a858461\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:36:05','2025-12-06 07:36:22','2025-12-06 07:36:22',1,'588b948b-da3b-4aaf-bfab-1367bd77ec8a','fb115316-35b8-4af3-9847-c6315737a158','compute-2.ctlplane.example.com','b4be0ef8-945f-47a1-a3a8-5962f1e692e5','/dev/vdb','2025-12-06 07:36:06','2025-12-06 07:36:22','rw','detached','{\"name\": \"volumes/volume-fb115316-35b8-4af3-9847-c6315737a158\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"fb115316-35b8-4af3-9847-c6315737a158\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"588b948b-da3b-4aaf-bfab-1367bd77ec8a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:56:59','2025-12-06 07:57:18','2025-12-06 07:57:18',1,'59aaa346-0c9c-4675-ad79-24f49c115eba','9cadf3d0-8133-453d-9dbc-ba304e3665f2','compute-1.ctlplane.example.com','5ae1d2f2-f2e3-43b3-8b37-94095588eb3a','/dev/vdb','2025-12-06 07:57:00','2025-12-06 07:57:18','rw','detached','{\"name\": \"volumes/volume-9cadf3d0-8133-453d-9dbc-ba304e3665f2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"9cadf3d0-8133-453d-9dbc-ba304e3665f2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"59aaa346-0c9c-4675-ad79-24f49c115eba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:58:50','2025-12-06 07:59:43','2025-12-06 07:59:43',1,'5f015061-4496-477d-9e1d-627940a2de6c','f1cb8c3c-521b-48db-b5f7-453fef5dd2fe','compute-2.ctlplane.example.com','27f553d7-b010-40ef-b0cb-42ff0c466354','/dev/vda','2025-12-06 07:58:53','2025-12-06 07:59:43','rw','detached','{\"name\": \"volumes/volume-f1cb8c3c-521b-48db-b5f7-453fef5dd2fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"f1cb8c3c-521b-48db-b5f7-453fef5dd2fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"5f015061-4496-477d-9e1d-627940a2de6c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:30:03','2025-12-06 07:32:21','2025-12-06 07:32:21',1,'605fe259-713f-428e-a86f-1b28c17a77b3','0deea545-3f8b-4364-87f8-f0e1b1b71caf','compute-2.ctlplane.example.com','02b3a680-d1bd-462f-95dc-aa0934c7ceac','/dev/vda','2025-12-06 07:30:11','2025-12-06 07:32:21','rw','detached','{\"name\": \"volumes/volume-0deea545-3f8b-4364-87f8-f0e1b1b71caf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"0deea545-3f8b-4364-87f8-f0e1b1b71caf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"605fe259-713f-428e-a86f-1b28c17a77b3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:46:44','2025-12-06 07:47:45','2025-12-06 07:47:45',1,'6344a4b6-c2e7-4399-bfff-63a5072820b9','1392b4ff-bd9d-4acf-a769-40407523ee0a','compute-2.ctlplane.example.com','2b4b3181-da12-4705-9215-7ee5b869102b','/dev/vdb','2025-12-06 07:46:46','2025-12-06 07:47:45','rw','detached','{\"name\": \"volumes/volume-1392b4ff-bd9d-4acf-a769-40407523ee0a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"1392b4ff-bd9d-4acf-a769-40407523ee0a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6344a4b6-c2e7-4399-bfff-63a5072820b9\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:55:41','2025-12-06 07:57:54','2025-12-06 07:57:54',1,'65097bc2-7207-442f-b133-04ee2fd4c64d','10679127-bb23-4af1-8eeb-3ae98e77d7db','compute-0.ctlplane.example.com','d7cce8d1-30dc-4c3c-8e97-c0e0cf1aaad2','/dev/vda','2025-12-06 07:55:44','2025-12-06 07:57:54','rw','detached','{\"name\": \"volumes/volume-10679127-bb23-4af1-8eeb-3ae98e77d7db\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"10679127-bb23-4af1-8eeb-3ae98e77d7db\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"65097bc2-7207-442f-b133-04ee2fd4c64d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:30:03','2025-12-06 07:32:21','2025-12-06 07:32:21',1,'6b36861a-4ab3-49b3-80b9-e4897e7f322c','2c5c3509-8d3e-4707-bc90-7053f467e836','compute-2.ctlplane.example.com','02b3a680-d1bd-462f-95dc-aa0934c7ceac','/dev/vdb','2025-12-06 07:30:12','2025-12-06 07:32:21','rw','detached','{\"name\": \"volumes/volume-2c5c3509-8d3e-4707-bc90-7053f467e836\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"2c5c3509-8d3e-4707-bc90-7053f467e836\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6b36861a-4ab3-49b3-80b9-e4897e7f322c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:36:22','2025-12-06 07:37:58','2025-12-06 07:37:58',1,'6e4fa302-71b2-4e3f-92ba-7d0c0085bcc7','fb115316-35b8-4af3-9847-c6315737a158','compute-2.ctlplane.example.com','b4be0ef8-945f-47a1-a3a8-5962f1e692e5','/dev/vdb','2025-12-06 07:36:27','2025-12-06 07:37:58','rw','detached','{\"name\": \"volumes/volume-fb115316-35b8-4af3-9847-c6315737a158\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"fb115316-35b8-4af3-9847-c6315737a158\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"6e4fa302-71b2-4e3f-92ba-7d0c0085bcc7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:25:58','2025-12-06 07:26:36','2025-12-06 07:26:36',1,'733d4904-fcb0-4f84-8fcd-8dc4b09d4a43','5061c285-a1ac-4ce6-96b8-9bd9d7f18a74','compute-1.ctlplane.example.com','8ace964d-3645-4195-8f65-8b625bce1b00','/dev/vdb','2025-12-06 07:26:05','2025-12-06 07:26:36','rw','detached','{\"name\": \"volumes/volume-5061c285-a1ac-4ce6-96b8-9bd9d7f18a74\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5061c285-a1ac-4ce6-96b8-9bd9d7f18a74\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"733d4904-fcb0-4f84-8fcd-8dc4b09d4a43\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:34:40','2025-12-06 07:34:51','2025-12-06 07:34:51',1,'7374f7da-58b8-4b31-ba66-95645456f3e3','783c2bdc-ead3-4bc6-bfc6-f7f7388312c6','compute-1.ctlplane.example.com','0c3768cf-031f-4b14-a8b4-9ff73a9cfa72','/dev/vdb','2025-12-06 07:34:42','2025-12-06 07:34:51','rw','detached','{\"name\": \"volumes/volume-783c2bdc-ead3-4bc6-bfc6-f7f7388312c6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"783c2bdc-ead3-4bc6-bfc6-f7f7388312c6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7374f7da-58b8-4b31-ba66-95645456f3e3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:15:47','2025-12-06 08:16:06','2025-12-06 08:16:06',1,'787f5f22-2874-4af8-a0cf-ee1d95931ae7','0ad7c9d2-a5e5-41f2-b829-63fa58265115','compute-2.ctlplane.example.com','326c22d5-36a0-4d26-bfbf-6dc1811a1ea4','/dev/vda','2025-12-06 08:15:50','2025-12-06 08:16:06','rw','detached','{\"name\": \"volumes/volume-0ad7c9d2-a5e5-41f2-b829-63fa58265115\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"0ad7c9d2-a5e5-41f2-b829-63fa58265115\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": true, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"787f5f22-2874-4af8-a0cf-ee1d95931ae7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:55:59','2025-12-06 07:56:20','2025-12-06 07:56:20',1,'7ac5e72a-7ff5-439f-b48f-76d979f4ab9d','1b7ce5d9-6944-4992-97d1-2fb28bc7b126','compute-0.ctlplane.example.com','d7cce8d1-30dc-4c3c-8e97-c0e0cf1aaad2','/dev/vdc','2025-12-06 07:56:00','2025-12-06 07:56:20','rw','detached','{\"name\": \"volumes/volume-1b7ce5d9-6944-4992-97d1-2fb28bc7b126\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"1b7ce5d9-6944-4992-97d1-2fb28bc7b126\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7ac5e72a-7ff5-439f-b48f-76d979f4ab9d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:57:02','2025-12-06 07:57:26','2025-12-06 07:57:26',1,'7e7be027-efe1-4de5-ac6d-30c958af2890','8eb73d4f-1376-44e4-bc55-b6d259ff218b','compute-1.ctlplane.example.com','5ae1d2f2-f2e3-43b3-8b37-94095588eb3a','/dev/vdc','2025-12-06 07:57:03','2025-12-06 07:57:26','rw','detached','{\"name\": \"volumes/volume-8eb73d4f-1376-44e4-bc55-b6d259ff218b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"8eb73d4f-1376-44e4-bc55-b6d259ff218b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"7e7be027-efe1-4de5-ac6d-30c958af2890\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:50:36','2025-12-06 07:52:13','2025-12-06 07:52:13',1,'8af8b9ed-2781-4f3f-8961-beda66d23d33','1c4642f5-e00c-416f-9c41-e5aa7293d85b','compute-2.ctlplane.example.com','fa71018e-7574-4438-bb85-43d1c96cf9b9','/dev/vdb','2025-12-06 07:50:38','2025-12-06 07:52:13','rw','detached','{\"name\": \"volumes/volume-1c4642f5-e00c-416f-9c41-e5aa7293d85b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"1c4642f5-e00c-416f-9c41-e5aa7293d85b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8af8b9ed-2781-4f3f-8961-beda66d23d33\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:55:55','2025-12-06 07:56:16','2025-12-06 07:56:16',1,'8c9d307e-4065-46a7-b824-0c2533f64d2c','7e4b734a-50a7-4ff3-bbbd-b8eb0e71528f','compute-0.ctlplane.example.com','d7cce8d1-30dc-4c3c-8e97-c0e0cf1aaad2','/dev/vdb','2025-12-06 07:55:56','2025-12-06 07:56:16','rw','detached','{\"name\": \"volumes/volume-7e4b734a-50a7-4ff3-bbbd-b8eb0e71528f\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"7e4b734a-50a7-4ff3-bbbd-b8eb0e71528f\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8c9d307e-4065-46a7-b824-0c2533f64d2c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:27:53','2025-12-06 08:28:24','2025-12-06 08:28:24',1,'8cd113ac-847b-4e13-af9a-7723f57e95f0','cac0df88-28ec-4cc6-ba02-9bd488ce8782','compute-0.ctlplane.example.com','ec4b7c40-d407-4a4a-bafa-4d075f29487f','/dev/vda','2025-12-06 08:27:56','2025-12-06 08:28:24','rw','detached','{\"name\": \"volumes/volume-cac0df88-28ec-4cc6-ba02-9bd488ce8782\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"cac0df88-28ec-4cc6-ba02-9bd488ce8782\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8cd113ac-847b-4e13-af9a-7723f57e95f0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:16:55','2025-12-06 07:18:29','2025-12-06 07:18:29',1,'8db5ccc5-1962-4524-9c53-b93313669576','d3c6383c-41f5-49ad-8585-fc49088a4d05','compute-2.ctlplane.example.com','067b423b-4ac2-4ca9-9000-44b6fb2af34e','/dev/vdc','2025-12-06 07:17:11','2025-12-06 07:18:29','rw','detached','{\"name\": \"volumes/volume-d3c6383c-41f5-49ad-8585-fc49088a4d05\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"d3c6383c-41f5-49ad-8585-fc49088a4d05\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"8db5ccc5-1962-4524-9c53-b93313669576\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:37:23','2025-12-06 07:39:34','2025-12-06 07:39:34',1,'915aa72a-4057-4688-bfcf-15f26826837c','4cae51dd-790a-4050-b673-0850eb817a06','compute-0.ctlplane.example.com','f37cdbe1-70ec-41d7-8e94-24a34612404f','/dev/vda','2025-12-06 07:37:24','2025-12-06 07:39:34','rw','detached','{\"name\": \"volumes/volume-4cae51dd-790a-4050-b673-0850eb817a06\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"4cae51dd-790a-4050-b673-0850eb817a06\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"915aa72a-4057-4688-bfcf-15f26826837c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:51:41','2025-12-06 07:52:33','2025-12-06 07:52:33',1,'9191512e-a554-40c3-868b-8dce94d4d8b3','47d2f91f-77e4-4f73-968f-583938f7d1cb','compute-0.ctlplane.example.com','0b9681c0-c0e7-4bd8-9040-865c1bff517b','/dev/vdc','2025-12-06 07:51:46','2025-12-06 07:52:33','rw','detached','{\"name\": \"volumes/volume-47d2f91f-77e4-4f73-968f-583938f7d1cb\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"47d2f91f-77e4-4f73-968f-583938f7d1cb\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9191512e-a554-40c3-868b-8dce94d4d8b3\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 06:58:56','2025-12-06 06:59:01','2025-12-06 06:59:01',1,'91bc07dc-2e56-419d-9563-145a0a1f9ffd','efe8ed74-896b-4b4f-9562-1c790f1f79e8','compute-2.ctlplane.example.com','1dd278c9-e3ac-480b-9a02-2e580da2d211','/dev/vdb','2025-12-06 06:58:58','2025-12-06 06:59:01','rw','detached','{\"name\": \"volumes/volume-efe8ed74-896b-4b4f-9562-1c790f1f79e8\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"efe8ed74-896b-4b4f-9562-1c790f1f79e8\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"91bc07dc-2e56-419d-9563-145a0a1f9ffd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:28:17','2025-12-06 07:29:38','2025-12-06 07:29:38',1,'9a973fe2-99ba-4c5d-8004-b747f98eb275','f889bfdf-c600-4260-90f0-d332e8e3d79b','compute-0.ctlplane.example.com','6ee4f2f5-3303-4c84-b708-eb35a65082b6','/dev/vda','2025-12-06 07:28:23','2025-12-06 07:29:38','rw','detached','{\"name\": \"volumes/volume-f889bfdf-c600-4260-90f0-d332e8e3d79b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"f889bfdf-c600-4260-90f0-d332e8e3d79b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9a973fe2-99ba-4c5d-8004-b747f98eb275\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:52:28','2025-12-06 07:53:35','2025-12-06 07:53:35',1,'9b25da7f-a519-440f-b579-a9606260e07b','abe8f868-d32c-4fcd-9cd6-843e5af74a06','compute-2.ctlplane.example.com','9cc0604e-1ff7-4781-8383-c780b6f598c5','/dev/vdb','2025-12-06 07:52:29','2025-12-06 07:53:35','rw','detached','{\"name\": \"volumes/volume-abe8f868-d32c-4fcd-9cd6-843e5af74a06\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"abe8f868-d32c-4fcd-9cd6-843e5af74a06\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9b25da7f-a519-440f-b579-a9606260e07b\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:09:13','2025-12-06 07:09:17','2025-12-06 07:09:17',1,'9b7992bd-aa08-47ce-afa0-12dacb2ac5d0','5076e091-edac-4ad3-a1b0-4b489857bfaf','compute-0.ctlplane.example.com','76a87dcb-b252-427a-8f49-7a8ab838bb3f','/dev/vdb','2025-12-06 07:09:14','2025-12-06 07:09:17','rw','detached','{\"name\": \"volumes/volume-5076e091-edac-4ad3-a1b0-4b489857bfaf\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5076e091-edac-4ad3-a1b0-4b489857bfaf\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9b7992bd-aa08-47ce-afa0-12dacb2ac5d0\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:04:56','2025-12-06 07:05:19','2025-12-06 07:05:19',1,'9c9d8800-f1b1-4d13-bc69-4ef58df68604','2b74c89f-1018-4ad4-8af8-84109979b9c7','compute-1.ctlplane.example.com','1712064c-6ba8-4660-972f-1e827a40781a','/dev/vda','2025-12-06 07:04:57','2025-12-06 07:05:19','null','detached','{\"name\": \"volumes/volume-2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9c9d8800-f1b1-4d13-bc69-4ef58df68604\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\", \"mode\": null}'),('2025-12-06 07:22:33','2025-12-06 07:22:40','2025-12-06 07:22:40',1,'9f2222d7-b216-413d-a5e8-1d5fe76054d6','b28b2367-60a4-4325-8a01-53a6de96135e','compute-2.ctlplane.example.com','6dc14838-5602-4f43-a3e3-2374b4f603eb','/dev/vdb','2025-12-06 07:22:36','2025-12-06 07:22:40','rw','detached','{\"name\": \"volumes/volume-b28b2367-60a4-4325-8a01-53a6de96135e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"b28b2367-60a4-4325-8a01-53a6de96135e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9f2222d7-b216-413d-a5e8-1d5fe76054d6\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:37:50','2025-12-06 07:38:09','2025-12-06 07:38:09',1,'a799365d-be42-4ca8-87e9-e01efde0fc10','5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6','compute-0.ctlplane.example.com','2de097e3-8182-48e5-b69d-88acbfb84e66','/dev/vdb','2025-12-06 07:37:52','2025-12-06 07:38:09','rw','detached','{\"name\": \"volumes/volume-5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a799365d-be42-4ca8-87e9-e01efde0fc10\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:36:56','2025-12-06 07:37:57','2025-12-06 07:37:57',1,'a904617c-462d-4f96-aaee-4174b3538c6e','a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c','compute-2.ctlplane.example.com','ffee41ca-ba3b-4787-8435-b3903ffb29a9','/dev/vda','2025-12-06 07:37:00','2025-12-06 07:37:57','rw','detached','{\"name\": \"volumes/volume-a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"a904617c-462d-4f96-aaee-4174b3538c6e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:08:41','2025-12-06 07:08:48','2025-12-06 07:08:48',1,'ac8b39ec-4c0b-4c95-beaf-af3f9984f2dd','86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6','compute-2.ctlplane.example.com','19dd5782-9191-431a-bc5b-c5c3d41fc07c','/dev/vdb','2025-12-06 07:08:42','2025-12-06 07:08:48','rw','detached','{\"name\": \"volumes/volume-86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ac8b39ec-4c0b-4c95-beaf-af3f9984f2dd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:16:55','2025-12-06 07:18:29','2025-12-06 07:18:29',1,'af25083f-54c8-43c2-9707-73274e5a5dea','4f7ebde6-5ba7-48cd-9d0a-8cec3b7dceb3','compute-2.ctlplane.example.com','067b423b-4ac2-4ca9-9000-44b6fb2af34e','/dev/vdb','2025-12-06 07:17:08','2025-12-06 07:18:29','rw','detached','{\"name\": \"volumes/volume-4f7ebde6-5ba7-48cd-9d0a-8cec3b7dceb3\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"4f7ebde6-5ba7-48cd-9d0a-8cec3b7dceb3\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"af25083f-54c8-43c2-9707-73274e5a5dea\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:37:56','2025-12-06 07:39:28','2025-12-06 07:39:28',1,'b1919775-1b27-454b-91f9-61cf71009f3f','a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c','compute-2.ctlplane.example.com','ffee41ca-ba3b-4787-8435-b3903ffb29a9','/dev/vda','2025-12-06 07:38:15','2025-12-06 07:39:28','rw','detached','{\"name\": \"volumes/volume-a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b1919775-1b27-454b-91f9-61cf71009f3f\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:04:37','2025-12-06 07:05:00','2025-12-06 07:05:00',1,'b2a91c5a-7187-4625-b7d3-9dd1c6ec4d90','2b74c89f-1018-4ad4-8af8-84109979b9c7','compute-2.ctlplane.example.com','1712064c-6ba8-4660-972f-1e827a40781a','/dev/vda','2025-12-06 07:04:40','2025-12-06 07:05:00','rw','detached','{\"name\": \"volumes/volume-2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"2b74c89f-1018-4ad4-8af8-84109979b9c7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b2a91c5a-7187-4625-b7d3-9dd1c6ec4d90\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:36:08','2025-12-06 07:37:19','2025-12-06 07:37:19',1,'b75fc88a-f547-4e16-b4bb-08670c6d6262','fb115316-35b8-4af3-9847-c6315737a158','compute-2.ctlplane.example.com','3d4b97f9-b8c3-4764-87f9-4006968fecd4','/dev/vdb','2025-12-06 07:36:10','2025-12-06 07:37:19','rw','detached','{\"name\": \"volumes/volume-fb115316-35b8-4af3-9847-c6315737a158\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"fb115316-35b8-4af3-9847-c6315737a158\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"b75fc88a-f547-4e16-b4bb-08670c6d6262\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:56:30','2025-12-06 07:56:51','2025-12-06 07:56:51',1,'bd946cba-8def-44b2-a537-58e2af18ae02','cbaeb237-1f40-498b-93c2-2ed85aff86b7','compute-2.ctlplane.example.com','21c591a0-5eed-4aa8-a68b-59a616b16e2b','/dev/vdc','2025-12-06 07:56:32','2025-12-06 07:56:51','rw','detached','{\"name\": \"volumes/volume-cbaeb237-1f40-498b-93c2-2ed85aff86b7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"cbaeb237-1f40-498b-93c2-2ed85aff86b7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bd946cba-8def-44b2-a537-58e2af18ae02\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdc\"}'),('2025-12-06 07:08:38','2025-12-06 07:08:50','2025-12-06 07:08:50',1,'bed1f198-b9f2-4672-8da5-e9e95a574eba','86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6','compute-1.ctlplane.example.com','e6b21faf-c7e9-4efe-9ce7-6aaeb2a4e96e','/dev/vdb','2025-12-06 07:08:39','2025-12-06 07:08:50','rw','detached','{\"name\": \"volumes/volume-86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"bed1f198-b9f2-4672-8da5-e9e95a574eba\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:34:30','2025-12-06 07:34:48','2025-12-06 07:34:48',1,'c773479c-7f2e-48d2-b912-dd798ce25bc8','783c2bdc-ead3-4bc6-bfc6-f7f7388312c6','compute-1.ctlplane.example.com','829161c5-19b5-459e-88a3-58512aaa5fc7','/dev/vdb','2025-12-06 07:34:31','2025-12-06 07:34:48','rw','detached','{\"name\": \"volumes/volume-783c2bdc-ead3-4bc6-bfc6-f7f7388312c6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"783c2bdc-ead3-4bc6-bfc6-f7f7388312c6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c773479c-7f2e-48d2-b912-dd798ce25bc8\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:34:04','2025-12-06 07:39:49','2025-12-06 07:39:49',1,'c92e5c00-d68a-4954-9986-06588c40c17d','95b7906f-ca03-4ae4-bdc0-817cf9423acd','compute-0.ctlplane.example.com','c2e6b8fd-375c-4658-b338-f2d334041ba3','/dev/vda','2025-12-06 07:34:06','2025-12-06 07:39:49','rw','detached','{\"name\": \"volumes/volume-95b7906f-ca03-4ae4-bdc0-817cf9423acd\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"95b7906f-ca03-4ae4-bdc0-817cf9423acd\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"c92e5c00-d68a-4954-9986-06588c40c17d\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:21:40','2025-12-06 07:21:52','2025-12-06 07:21:52',1,'cf440460-4f1e-4d37-b8a7-a54a1867bde1','47e6e09c-3fa4-4d8f-9362-4fced2e03fd2','compute-1.ctlplane.example.com','d9b5a381-4236-4a72-bedd-3fe7eca161bc','/dev/vdb','2025-12-06 07:21:41','2025-12-06 07:21:52','rw','detached','{\"name\": \"volumes/volume-47e6e09c-3fa4-4d8f-9362-4fced2e03fd2\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"47e6e09c-3fa4-4d8f-9362-4fced2e03fd2\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"cf440460-4f1e-4d37-b8a7-a54a1867bde1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:16:35','2025-12-06 08:16:49','2025-12-06 08:16:49',1,'d2614f9e-fadc-4f11-bbc8-fcaeae80a1cd','a427e5a0-fe95-4f1e-be90-c6d37b0a00af','compute-2.ctlplane.example.com','1afa9f23-5514-4eb1-9d88-856a8f5e6744','/dev/vda','2025-12-06 08:16:36','2025-12-06 08:16:49','rw','detached','{\"name\": \"volumes/volume-a427e5a0-fe95-4f1e-be90-c6d37b0a00af\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"a427e5a0-fe95-4f1e-be90-c6d37b0a00af\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d2614f9e-fadc-4f11-bbc8-fcaeae80a1cd\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:38:08','2025-12-06 07:38:57','2025-12-06 07:38:57',1,'d9727c8d-937a-430f-bbb7-b0cec953896c','5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6','compute-2.ctlplane.example.com','2de097e3-8182-48e5-b69d-88acbfb84e66','/dev/vdb','2025-12-06 07:38:17','2025-12-06 07:38:57','rw','detached','{\"name\": \"volumes/volume-5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"d9727c8d-937a-430f-bbb7-b0cec953896c\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:59:42','2025-12-06 08:00:49','2025-12-06 08:00:49',1,'e469efc4-a2a5-40fa-b1ad-62c2931170d2','f1cb8c3c-521b-48db-b5f7-453fef5dd2fe','compute-2.ctlplane.example.com','27f553d7-b010-40ef-b0cb-42ff0c466354','/dev/vda','2025-12-06 07:59:59','2025-12-06 08:00:49','rw','detached','{\"name\": \"volumes/volume-f1cb8c3c-521b-48db-b5f7-453fef5dd2fe\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"f1cb8c3c-521b-48db-b5f7-453fef5dd2fe\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e469efc4-a2a5-40fa-b1ad-62c2931170d2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:38:55','2025-12-06 07:39:36','2025-12-06 07:39:36',1,'e7a3f41d-7bea-4fd4-a1d8-f3e314ae080a','5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6','compute-0.ctlplane.example.com','2de097e3-8182-48e5-b69d-88acbfb84e66','/dev/vdb','2025-12-06 07:39:13','2025-12-06 07:39:36','rw','detached','{\"name\": \"volumes/volume-5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"e7a3f41d-7bea-4fd4-a1d8-f3e314ae080a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:44:32','2025-12-06 07:44:41','2025-12-06 07:44:41',1,'f12acac1-8fdb-4176-9e37-e39a2ef932e7','13b2825e-5790-477b-b9fb-6ad4efe8c20c','compute-0.ctlplane.example.com','f3e780ab-f17f-4ecf-908b-16e88419d5f4','/dev/vdb','2025-12-06 07:44:34','2025-12-06 07:44:41','rw','detached','{\"name\": \"volumes/volume-13b2825e-5790-477b-b9fb-6ad4efe8c20c\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"13b2825e-5790-477b-b9fb-6ad4efe8c20c\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f12acac1-8fdb-4176-9e37-e39a2ef932e7\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.100\", \"host\": \"compute-0.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:14d7cbfe12ab\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"dc45738e-2bb0-4417-914c-a006d79f6275\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 08:19:26','2025-12-06 08:20:11','2025-12-06 08:20:11',1,'f15f1579-5bca-46a9-99e4-f9b965870bfa','51b925ec-146c-45cc-ba59-9db845a18e81','compute-1.ctlplane.example.com','f1b83445-6063-4baa-b214-de9700ef24ac','/dev/vda','2025-12-06 08:19:31','2025-12-06 08:20:11','rw','detached','{\"name\": \"volumes/volume-51b925ec-146c-45cc-ba59-9db845a18e81\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"51b925ec-146c-45cc-ba59-9db845a18e81\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f15f1579-5bca-46a9-99e4-f9b965870bfa\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:53:59','2025-12-06 07:54:00','2025-12-06 07:54:00',1,'f24cf003-3743-427f-86e7-0997f7372c97','37eab4d3-9f52-4ac3-b2a0-38a34338da05',NULL,'91b85b86-0d07-4df4-80d5-48fa343c00b8',NULL,NULL,'2025-12-06 07:54:00','null','detached','{}',NULL),('2025-12-06 07:16:55','2025-12-06 07:18:28','2025-12-06 07:18:28',1,'f4de751c-899f-475e-ac3a-d68ed0f1ae07','0a534f34-78f8-4439-88a1-9db3d9b7638b','compute-2.ctlplane.example.com','067b423b-4ac2-4ca9-9000-44b6fb2af34e','/dev/vda','2025-12-06 07:17:05','2025-12-06 07:18:28','rw','detached','{\"name\": \"volumes/volume-0a534f34-78f8-4439-88a1-9db3d9b7638b\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"0a534f34-78f8-4439-88a1-9db3d9b7638b\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f4de751c-899f-475e-ac3a-d68ed0f1ae07\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 08:18:00','2025-12-06 08:18:43','2025-12-06 08:18:43',1,'f9616046-1843-4502-87dc-b5e3433ae6e1','43e97266-6e92-4724-9224-f4b44696e11a','compute-1.ctlplane.example.com','fd33cb27-7fd5-4a29-9653-903deb886052','/dev/vda','2025-12-06 08:18:01','2025-12-06 08:18:43','rw','detached','{\"name\": \"volumes/volume-43e97266-6e92-4724-9224-f4b44696e11a\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"43e97266-6e92-4724-9224-f4b44696e11a\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"f9616046-1843-4502-87dc-b5e3433ae6e1\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:39:04','2025-12-06 07:39:46','2025-12-06 07:39:46',1,'faf88ffd-3691-4171-8a88-e9ae104d0a9e','67ebc469-c3e0-45da-a1b6-9f2891a4f2a7','compute-2.ctlplane.example.com','db714956-5ece-4543-8db8-4634df66962e','/dev/vda','2025-12-06 07:39:18','2025-12-06 07:39:46','rw','detached','{\"name\": \"volumes/volume-67ebc469-c3e0-45da-a1b6-9f2891a4f2a7\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"67ebc469-c3e0-45da-a1b6-9f2891a4f2a7\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"faf88ffd-3691-4171-8a88-e9ae104d0a9e\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vda\"}'),('2025-12-06 07:05:27','2025-12-06 07:05:31','2025-12-06 07:05:31',1,'fc6b029d-c725-493f-bfa2-32d3f1426e64','72f42200-60a4-4bc0-ac08-8ab63713f05e','compute-2.ctlplane.example.com','9b0dea9b-128d-43a8-aedd-6a023517b89f','/dev/sdc','2025-12-06 07:05:29','2025-12-06 07:05:31','rw','detached','{\"name\": \"volumes/volume-72f42200-60a4-4bc0-ac08-8ab63713f05e\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"72f42200-60a4-4bc0-ac08-8ab63713f05e\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"fc6b029d-c725-493f-bfa2-32d3f1426e64\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/sdc\"}'),('2025-12-06 07:37:19','2025-12-06 07:38:00','2025-12-06 07:38:00',1,'ff7c18f6-2b04-47ef-839a-eeab9de58e5a','fb115316-35b8-4af3-9847-c6315737a158','compute-1.ctlplane.example.com','3d4b97f9-b8c3-4764-87f9-4006968fecd4','/dev/vdb','2025-12-06 07:37:24','2025-12-06 07:38:00','rw','detached','{\"name\": \"volumes/volume-fb115316-35b8-4af3-9847-c6315737a158\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"fb115316-35b8-4af3-9847-c6315737a158\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ff7c18f6-2b04-47ef-839a-eeab9de58e5a\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.101\", \"host\": \"compute-1.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:7842346547e0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"effe0b74-d2bb-436f-b621-5e7c5f665fb5\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}'),('2025-12-06 07:56:27','2025-12-06 07:56:47','2025-12-06 07:56:47',1,'ffb6853f-47ee-4734-855e-0bdec24290a2','c7a5e27c-c7d8-4759-87be-61891912cec5','compute-2.ctlplane.example.com','21c591a0-5eed-4aa8-a68b-59a616b16e2b','/dev/vdb','2025-12-06 07:56:29','2025-12-06 07:56:47','rw','detached','{\"name\": \"volumes/volume-c7a5e27c-c7d8-4759-87be-61891912cec5\", \"hosts\": [\"192.168.122.100\", \"192.168.122.102\", \"192.168.122.101\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"40a1bae4-cf76-5610-8dab-c75116dfe0bb\", \"volume_id\": \"c7a5e27c-c7d8-4759-87be-61891912cec5\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"ffb6853f-47ee-4734-855e-0bdec24290a2\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.102\", \"host\": \"compute-2.ctlplane.example.com\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:63778d5959f0\", \"do_local_attach\": false, \"nvme_hostid\": \"bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"system uuid\": \"ec2492e2-e0d1-43d3-b74f-744a8272a0e6\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:bf3e0a14-a5f8-4123-aa26-e7cad37b879a\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-06 07:02:36',NULL,'2025-12-06 07:03:55',1,1,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'signature_verified','False'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,2,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'hw_rng_model','virtio'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,3,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,4,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,5,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,6,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'container_format','bare'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,7,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'disk_format','qcow2'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,8,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'min_disk','0'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,9,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'min_ram','0'),('2025-12-06 07:02:42',NULL,'2025-12-06 07:03:55',1,10,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'size','21430272'),('2025-12-06 07:04:28',NULL,'2025-12-06 07:05:30',1,11,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'signature_verified','False'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,12,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'hw_rng_model','virtio'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,13,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,14,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,15,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,16,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'container_format','bare'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,17,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'disk_format','qcow2'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,18,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'min_disk','0'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,19,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'min_ram','0'),('2025-12-06 07:04:32',NULL,'2025-12-06 07:05:30',1,20,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'size','21430272'),('2025-12-06 07:16:26',NULL,'2025-12-06 07:18:45',1,21,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'signature_verified','False'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,22,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'hw_rng_model','virtio'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,23,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,24,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,25,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,26,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'container_format','bare'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,27,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'disk_format','qcow2'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,28,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'min_disk','0'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,29,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'min_ram','0'),('2025-12-06 07:16:30',NULL,'2025-12-06 07:18:45',1,30,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'size','21430272'),('2025-12-06 07:18:31',NULL,'2025-12-06 07:19:49',1,31,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'signature_verified','False'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,32,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'hw_rng_model','virtio'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,33,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,34,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,35,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,36,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'container_format','bare'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,37,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'disk_format','qcow2'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,38,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'min_disk','0'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,39,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'min_ram','0'),('2025-12-06 07:18:37',NULL,'2025-12-06 07:19:49',1,40,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'size','21430272'),('2025-12-06 07:28:01',NULL,'2025-12-06 07:30:20',1,41,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'signature_verified','False'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,42,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'hw_rng_model','virtio'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,43,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,44,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,45,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,46,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'container_format','bare'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,47,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'disk_format','qcow2'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,48,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'min_disk','0'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,49,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'min_ram','0'),('2025-12-06 07:28:14',NULL,'2025-12-06 07:30:20',1,50,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'size','21430272'),('2025-12-06 07:28:45',NULL,'2025-12-06 07:33:10',1,51,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'signature_verified','False'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,52,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'hw_rng_model','virtio'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,53,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,54,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,55,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,56,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'container_format','bare'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,57,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'disk_format','qcow2'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,58,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'min_disk','0'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,59,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'min_ram','0'),('2025-12-06 07:29:30',NULL,'2025-12-06 07:33:10',1,60,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'size','21430272'),('2025-12-06 07:32:40',NULL,'2025-12-06 07:40:47',1,61,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'signature_verified','False'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,62,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'hw_rng_model','virtio'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,63,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,64,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,65,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,66,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'container_format','bare'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,67,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'disk_format','qcow2'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,68,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'min_disk','0'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,69,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'min_ram','0'),('2025-12-06 07:33:09',NULL,'2025-12-06 07:40:47',1,70,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'size','21430272'),('2025-12-06 07:36:38',NULL,'2025-12-06 07:38:13',1,71,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'signature_verified','False'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,72,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'hw_rng_model','virtio'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,73,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,74,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,75,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,76,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'container_format','bare'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,77,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'disk_format','qcow2'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,78,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'min_disk','0'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,79,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'min_ram','0'),('2025-12-06 07:36:53',NULL,'2025-12-06 07:38:13',1,80,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'size','21430272'),('2025-12-06 07:37:03',NULL,NULL,0,81,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'signature_verified','False'),('2025-12-06 07:37:20',NULL,NULL,0,82,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'hw_rng_model','virtio'),('2025-12-06 07:37:20',NULL,NULL,0,83,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:37:20',NULL,NULL,0,84,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:37:20',NULL,NULL,0,85,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:37:20',NULL,NULL,0,86,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'container_format','bare'),('2025-12-06 07:37:20',NULL,NULL,0,87,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'disk_format','qcow2'),('2025-12-06 07:37:20',NULL,NULL,0,88,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'min_disk','0'),('2025-12-06 07:37:20',NULL,NULL,0,89,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'min_ram','0'),('2025-12-06 07:37:20',NULL,NULL,0,90,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'size','21430272'),('2025-12-06 07:38:07',NULL,'2025-12-06 07:39:52',1,91,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'signature_verified','False'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,92,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'hw_rng_model','virtio'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,93,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'image_id','412dd61d-1b1e-439f-b7f9-7e7c4e42924c'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,94,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img_alt'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,95,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,96,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'container_format','bare'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,97,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'disk_format','qcow2'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,98,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'min_disk','0'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,99,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'min_ram','0'),('2025-12-06 07:38:13',NULL,'2025-12-06 07:39:35',1,100,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'size','21430272'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,101,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'hw_rng_model','virtio'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,102,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,103,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,104,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,105,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'container_format','bare'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,106,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'disk_format','qcow2'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,107,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'min_disk','0'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,108,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'min_ram','0'),('2025-12-06 07:38:57',NULL,'2025-12-06 07:39:52',1,109,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'size','21430272'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,110,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','signature_verified','False'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,111,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','hw_rng_model','virtio'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,112,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,113,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,114,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,115,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','container_format','bare'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,116,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','disk_format','qcow2'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,117,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','min_disk','0'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,118,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','min_ram','0'),('2025-12-06 07:39:39',NULL,'2025-12-06 07:39:51',1,119,NULL,'bbf2fddd-4329-419d-b38f-42646c0e4ed3','size','21430272'),('2025-12-06 07:55:33',NULL,'2025-12-06 07:58:15',1,120,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'signature_verified','False'),('2025-12-06 07:55:34',NULL,'2025-12-06 07:58:02',1,121,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'signature_verified','False'),('2025-12-06 07:55:36',NULL,'2025-12-06 07:57:57',1,122,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'signature_verified','False'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,123,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'image_id','d2f3b5e0-e512-4475-bd2e-0cf53dc74129'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,124,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'image_name','tempest-scenario-img--392476316'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,125,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,126,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'container_format','bare'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,127,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'disk_format','qcow2'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,128,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'min_disk','0'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,129,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'min_ram','0'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:15',1,130,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'size','21430272'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,131,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'image_id','d2f3b5e0-e512-4475-bd2e-0cf53dc74129'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,132,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'image_name','tempest-scenario-img--392476316'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,133,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,134,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'container_format','bare'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,135,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'disk_format','qcow2'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,136,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'min_disk','0'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,137,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'min_ram','0'),('2025-12-06 07:55:38',NULL,'2025-12-06 07:58:02',1,138,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'size','21430272'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,139,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'image_id','d2f3b5e0-e512-4475-bd2e-0cf53dc74129'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,140,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'image_name','tempest-scenario-img--392476316'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,141,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,142,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'container_format','bare'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,143,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'disk_format','qcow2'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,144,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'min_disk','0'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,145,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'min_ram','0'),('2025-12-06 07:55:40',NULL,'2025-12-06 07:57:57',1,146,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'size','21430272'),('2025-12-06 07:58:43',NULL,'2025-12-06 08:00:51',1,147,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'signature_verified','False'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,148,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'hw_rng_model','virtio'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,149,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,150,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,151,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,152,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'container_format','bare'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,153,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'disk_format','qcow2'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,154,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'min_disk','0'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,155,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'min_ram','0'),('2025-12-06 07:58:47',NULL,'2025-12-06 08:00:51',1,156,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'size','21430272'),('2025-12-06 08:16:15',NULL,'2025-12-06 08:16:54',1,157,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'signature_verified','False'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,158,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'hw_rng_model','virtio'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,159,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,160,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,161,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,162,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'container_format','bare'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,163,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'disk_format','qcow2'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,164,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'min_disk','0'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,165,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'min_ram','0'),('2025-12-06 08:16:19',NULL,'2025-12-06 08:16:54',1,166,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'size','21430272'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,167,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','signature_verified','False'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,168,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','hw_rng_model','virtio'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,169,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,170,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,171,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,172,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','container_format','bare'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,173,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','disk_format','qcow2'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,174,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','min_disk','0'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,175,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','min_ram','0'),('2025-12-06 08:16:22',NULL,'2025-12-06 08:16:53',1,176,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','size','21430272'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,177,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'signature_verified','False'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,178,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'hw_rng_model','virtio'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,179,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,180,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,181,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,182,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'container_format','bare'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,183,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'disk_format','qcow2'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,184,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'min_disk','0'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,185,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'min_ram','0'),('2025-12-06 08:16:31',NULL,'2025-12-06 08:16:51',1,186,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'size','21430272'),('2025-12-06 08:16:58',NULL,'2025-12-06 08:18:49',1,187,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'signature_verified','False'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,188,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'hw_rng_model','virtio'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,189,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,190,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,191,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,192,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'container_format','bare'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,193,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'disk_format','qcow2'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,194,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'min_disk','0'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,195,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'min_ram','0'),('2025-12-06 08:17:03',NULL,'2025-12-06 08:18:49',1,196,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'size','21430272'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,197,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','signature_verified','False'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,198,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','hw_rng_model','virtio'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,199,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,200,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,201,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,202,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','container_format','bare'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,203,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','disk_format','qcow2'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,204,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','min_disk','0'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,205,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','min_ram','0'),('2025-12-06 08:17:46',NULL,'2025-12-06 08:18:45',1,206,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','size','21430272'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,207,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'signature_verified','False'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,208,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'hw_rng_model','virtio'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,209,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,210,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,211,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,212,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'container_format','bare'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,213,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'disk_format','qcow2'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,214,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'min_disk','0'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,215,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'min_ram','0'),('2025-12-06 08:17:57',NULL,'2025-12-06 08:18:44',1,216,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'size','21430272'),('2025-12-06 08:19:14',NULL,'2025-12-06 08:22:27',1,217,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'signature_verified','False'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,218,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'hw_rng_model','virtio'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,219,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,220,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,221,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,222,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'container_format','bare'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,223,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'disk_format','qcow2'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,224,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'min_disk','0'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,225,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'min_ram','0'),('2025-12-06 08:19:19',NULL,'2025-12-06 08:22:27',1,226,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'size','21430272'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,227,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','signature_verified','False'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,228,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','hw_rng_model','virtio'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,229,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,230,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,231,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,232,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','container_format','bare'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,233,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','disk_format','qcow2'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,234,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','min_disk','0'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,235,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','min_ram','0'),('2025-12-06 08:21:08',NULL,'2025-12-06 08:22:14',1,236,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','size','21430272'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,237,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'signature_verified','False'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,238,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'hw_rng_model','virtio'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,239,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,240,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,241,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,242,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'container_format','bare'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,243,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'disk_format','qcow2'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,244,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'min_disk','0'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,245,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'min_ram','0'),('2025-12-06 08:21:10',NULL,'2025-12-06 08:22:11',1,246,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'size','21430272'),('2025-12-06 08:27:30',NULL,'2025-12-06 08:28:27',1,247,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'signature_verified','False'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,248,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'hw_rng_model','virtio'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,249,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,250,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,251,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,252,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'container_format','bare'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,253,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'disk_format','qcow2'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,254,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'min_disk','0'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,255,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'min_ram','0'),('2025-12-06 08:27:34',NULL,'2025-12-06 08:28:27',1,256,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'size','21430272'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,257,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'signature_verified','False'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,258,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'hw_rng_model','virtio'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,259,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'image_id','6efab05d-c7cf-4770-a5c3-c806a2739063'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,260,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,261,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,262,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'container_format','bare'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,263,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'disk_format','qcow2'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,264,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'min_disk','0'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,265,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'min_ram','0'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,266,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-06 07:45:35',NULL,'2025-12-06 07:45:37',1,1,'fd7b45bb-5a45-450f-a9a7-d69b49c92abc','Type','work'),('2025-12-06 07:45:42',NULL,'2025-12-06 07:45:58',1,2,'1405e1d2-9e0f-4a46-9f41-4ca16f7db0c2','Type','work'),('2025-12-06 07:45:45',NULL,'2025-12-06 07:45:54',1,3,'6555c795-5067-401b-b1bb-2b940961fc91','Type','work'),('2025-12-06 07:45:47',NULL,'2025-12-06 07:45:53',1,4,'f2f4c32e-dd22-4d24-ac81-511282328976','Type','work'),('2025-12-06 08:27:46',NULL,'2025-12-06 08:28:26',1,5,'cac0df88-28ec-4cc6-ba02-9bd488ce8782','src_backup_id','ee09be67-d52d-4f80-a400-600e604fb947');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-12-06 06:55:04',NULL,NULL,0,1,'b1150443-1e04-4872-9c8f-90f403a56362','multiattach','<is> True');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-06 07:55:27',NULL,'2025-12-06 07:58:17',1,'034fd9f5-eb5d-4abf-820e-ec38ca97d791','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-413842116-981270992',NULL,1,NULL),('2025-12-06 07:55:23',NULL,'2025-12-06 07:58:21',1,'58b799b3-95b6-421a-829c-be22998d1df8','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-735022974-1306212811',NULL,1,NULL),('2025-12-06 06:09:50','2025-12-06 06:09:50',NULL,0,'6156fe10-4ec6-42bd-b179-f6683c03e87b','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-06 08:15:34',NULL,'2025-12-06 08:16:10',1,'a2eb05af-1af9-44c8-9c14-fb3696d6596b','tempest-scenario-type-luks-1522269493',NULL,1,NULL),('2025-12-06 06:55:02',NULL,NULL,0,'b1150443-1e04-4872-9c8f-90f403a56362','multiattach',NULL,1,NULL),('2025-12-06 07:55:27',NULL,'2025-12-06 07:58:17',1,'c9da6baf-5607-4566-b482-f3ed098a9ca2','tempest-scenario-type-tempest-TestInstancesWithCinderVolumes-volume-type-2028255588-1316054734',NULL,1,NULL),('2025-12-06 07:46:56',NULL,'2025-12-06 07:48:17',1,'dc92f0f9-02c2-4310-b039-2df7a47f17b2','tempest-scenario-type-luks-717406057',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-12-06 08:21:09','2025-12-06 08:22:10','2025-12-06 08:22:11',1,'09c93a0a-7903-4f14-b7b3-cc5eeb590680',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:21:09','2025-12-06 08:21:10','2025-12-06 08:22:10','tempest-TestVolumeBootPattern-volume-795155609',NULL,NULL,NULL,'7d12a72c-e009-4022-8c27-07aaf6d67092','6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:16:23','2025-12-06 07:18:44','2025-12-06 07:18:45',1,'0a534f34-78f8-4439-88a1-9db3d9b7638b',NULL,'197a9b0ee1db487d82542eb31e84f33e','8f938a037b8141cf9408cbf6f5cd081d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:16:23','2025-12-06 07:16:30','2025-12-06 07:18:44','tempest-TaggedBootDevicesTest-volume-250717398',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:46:13','2025-12-06 07:46:22','2025-12-06 07:46:23',1,'0a5b51e1-c033-46c2-82b0-6283b345dd9a',NULL,'45451a914c994cd69359ed7c4e71ec0a','40da133fd2cc44f4b03dfcaa8d2a67a6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:46:13','2025-12-06 07:46:13','2025-12-06 07:46:22','tempest-VolumesSnapshotsTestJSON-volume-993863039',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:15:35','2025-12-06 08:16:09','2025-12-06 08:16:09',1,'0ad7c9d2-a5e5-41f2-b829-63fa58265115',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:15:36','2025-12-06 08:15:43','2025-12-06 08:16:09','tempest-TestVolumeBootPattern-volume-1474592676',NULL,NULL,NULL,NULL,'a2eb05af-1af9-44c8-9c14-fb3696d6596b',NULL,1,NULL,NULL,'75728468-de3d-4c09-a185-2a907c7b8906',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:28:36','2025-12-06 07:33:04','2025-12-06 07:33:10',1,'0deea545-3f8b-4364-87f8-f0e1b1b71caf',NULL,'8e5d532f4af34acc9e3a7a08819bb089','1a5dd5f9ca5747618b386c87a40ede88','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:28:36','2025-12-06 07:29:30','2025-12-06 07:33:04','tempest-TaggedBootDevicesTest_v242-volume-828203689',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:31','2025-12-06 07:58:02','2025-12-06 07:58:15',1,'10679127-bb23-4af1-8eeb-3ae98e77d7db',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:31','2025-12-06 07:55:38','2025-12-06 07:58:02','tempest-TestInstancesWithCinderVolumes-volume-1037964460',NULL,NULL,NULL,NULL,'58b799b3-95b6-421a-829c-be22998d1df8',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:55','2025-12-06 07:47:57','2025-12-06 07:47:58',1,'1392b4ff-bd9d-4acf-a769-40407523ee0a',NULL,'e997a5eeee174b368a43ed8cb35fa1d0','f44ecb8bdc7e4692a299e29603301124','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:55','2025-12-06 07:45:56','2025-12-06 07:47:57','tempest-ServerStableDeviceRescueTest-volume-359772130',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:44:27','2025-12-06 07:45:59','2025-12-06 07:45:59',1,'13b2825e-5790-477b-b9fb-6ad4efe8c20c',NULL,'297bc99c242e4fa8aedea4a6367b61c0','741dc47f9ced423cbd99fd6f9d32904f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:44:27','2025-12-06 07:44:30','2025-12-06 07:45:59','tempest-AttachVolumeNegativeTest-volume-1913219340',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:42','2025-12-06 07:45:55','2025-12-06 07:45:58',1,'1405e1d2-9e0f-4a46-9f41-4ca16f7db0c2',NULL,'823b61c4027c48dc9b8f4e41bca5cf83','5dcd2d068ff04070b59e12a2cd84f89c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:43','2025-12-06 07:45:43','2025-12-06 07:45:55','tempest-VolumesTestJSON-volume-39721599',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:39','2025-12-06 07:45:56','2025-12-06 07:45:58',1,'15c50314-82b8-4e1c-81d1-ad7ba14c56de',NULL,'297bc99c242e4fa8aedea4a6367b61c0','741dc47f9ced423cbd99fd6f9d32904f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:39','2025-12-06 07:45:40','2025-12-06 07:45:56','tempest-AttachVolumeNegativeTest-volume-1474423437',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:27','2025-12-06 07:56:21','2025-12-06 07:56:26',1,'1b7ce5d9-6944-4992-97d1-2fb28bc7b126',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:56:21','tempest-TestInstancesWithCinderVolumes-volume-1988280763',NULL,NULL,NULL,NULL,'c9da6baf-5607-4566-b482-f3ed098a9ca2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:50:32','2025-12-06 07:52:14','2025-12-06 07:52:15',1,'1c4642f5-e00c-416f-9c41-e5aa7293d85b',NULL,'0f669e963dc54ad7bebf8dd20341428a','0c8fc5bc237e42bfad505a0bca6681eb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:50:32','2025-12-06 07:50:35','2025-12-06 07:52:14','tempest-TestMinimumBasicScenario-volume-2046955082',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:04:24','2025-12-06 07:05:29','2025-12-06 07:05:30',1,'2b74c89f-1018-4ad4-8af8-84109979b9c7',NULL,'756e3e1fa7e44042bdf37a6cdd877fac','9e86c61372e24db392d4a12ca71f7e00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:04:24','2025-12-06 07:04:32','2025-12-06 07:05:29','tempest-tempest.common.compute-volume-501383586',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:29:30','2025-12-06 07:32:54','2025-12-06 07:33:04',1,'2c5c3509-8d3e-4707-bc90-7053f467e836',NULL,'8e5d532f4af34acc9e3a7a08819bb089','1a5dd5f9ca5747618b386c87a40ede88','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:29:30','2025-12-06 07:29:31','2025-12-06 07:32:54','tempest-TaggedBootDevicesTest_v242-volume-916571221',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:44:55','2025-12-06 07:47:19','2025-12-06 07:47:22',1,'36cc48f7-cf95-47a2-842d-83cf24d8acb0',NULL,'1035ecd55ed54b57aa35fe32fb915cc5','4ec9294f6d4b4f44a72414374d646a4a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:44:55','2025-12-06 07:44:56','2025-12-06 07:47:19','tempest-ServersNegativeTestJSON-volume-1141538620',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:53:39','2025-12-06 07:54:44','2025-12-06 07:54:45',1,'37eab4d3-9f52-4ac3-b2a0-38a34338da05',NULL,'90c9de6e67724c898a8e23b05fbf14da','cfa713d92cc94fa1b94404ed58b0563f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:53:39','2025-12-06 07:53:40','2025-12-06 07:54:44','tempest-AttachVolumeShelveTestJSON-volume-1114576812',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:33','2025-12-06 07:57:56','2025-12-06 07:57:57',1,'38a07fdf-f182-4202-a84f-220c1b1f0f42',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:34','2025-12-06 07:55:40','2025-12-06 07:57:56','tempest-TestInstancesWithCinderVolumes-volume-885387542',NULL,NULL,NULL,NULL,'58b799b3-95b6-421a-829c-be22998d1df8',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:50:24','2025-12-06 07:53:19','2025-12-06 07:53:20',1,'3c0c17ef-cec5-45f2-956d-446361af61f4',NULL,'4962bc7b172346e19d127b46ea2d7a11','c4cf19b89a6d46bca307e65731a9dd21','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:50:24','2025-12-06 07:50:24','2025-12-06 07:53:19','tempest-TestStampPattern-volume-653166786',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:16:12','2025-12-06 08:16:54','2025-12-06 08:16:54',1,'4275992e-c3b8-40ee-88ea-39dad5a19265',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:16:12','2025-12-06 08:16:19','2025-12-06 08:16:54','tempest-TestVolumeBootPattern-volume-origin-1462287878',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:17:56','2025-12-06 08:18:43','2025-12-06 08:18:44',1,'43e97266-6e92-4724-9224-f4b44696e11a',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:17:56','2025-12-06 08:17:57','2025-12-06 08:18:43','','',NULL,NULL,'8c532b5e-c264-4201-a213-9aa271d92ee9','6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:50:55','2025-12-06 07:53:47','2025-12-06 07:53:48',1,'444c5863-34e2-4070-9690-67abdc08491e',NULL,'f2335740042045fba7f544ee5140eb87','4842ecff6dce4ccc981a6b65a14ea406','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:50:56','2025-12-06 07:50:56','2025-12-06 07:53:47','tempest-ServerRescueNegativeTestJSON-volume-1966267544',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:09','2025-12-06 07:58:23','2025-12-06 07:58:24',1,'4740f75b-6222-44e7-8496-fed71a346d64',NULL,'0ce6d0a8def6432aa60891ea00ef9d8b','63df107b8bd14504974c75ba92ae469b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:10','2025-12-06 07:55:10','2025-12-06 07:58:23','tempest-AttachVolumeTestJSON-volume-1361432313',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:51:20','2025-12-06 07:54:46','2025-12-06 07:54:47',1,'47d2f91f-77e4-4f73-968f-583938f7d1cb',NULL,'90c9de6e67724c898a8e23b05fbf14da','cfa713d92cc94fa1b94404ed58b0563f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:51:22','2025-12-06 07:51:23','2025-12-06 07:54:46','tempest-AttachVolumeShelveTestJSON-volume-1636880823',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:21:37','2025-12-06 07:27:22','2025-12-06 07:27:31',1,'47e6e09c-3fa4-4d8f-9362-4fced2e03fd2',NULL,'d966fefcb38a45219b9cc637c46a3d62','c6d2f50c0db54315bfa96a24511dda90','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:21:37','2025-12-06 07:21:39','2025-12-06 07:27:22','tempest-DeleteServersTestJSON-volume-1755833886',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:36:57','2025-12-06 07:39:34',NULL,0,'4cae51dd-790a-4050-b673-0850eb817a06',NULL,'2aa5b15c15f84a8cb24776d5c781eb09','17cdfa63c4424ec7a0eb4bb3d7372c14','hostgroup@ceph#ceph',1,'nova','available','detached','2025-12-06 07:36:57','2025-12-06 07:37:20',NULL,'','',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:27:27','2025-12-06 08:28:26','2025-12-06 08:28:27',1,'4cedca42-d524-4fdd-9e45-495f41b61117',NULL,'00e2fea2f8f54b1c9af85553820566a6','55d0236410514dd9ad6cdb3e1a5d0ee6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:27:27','2025-12-06 08:27:34','2025-12-06 08:28:26','tempest-TestVolumeBackupRestore-volume-551996610',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:16:31','2025-12-06 07:18:40','2025-12-06 07:18:43',1,'4f7ebde6-5ba7-48cd-9d0a-8cec3b7dceb3',NULL,'197a9b0ee1db487d82542eb31e84f33e','8f938a037b8141cf9408cbf6f5cd081d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:16:31','2025-12-06 07:16:31','2025-12-06 07:18:40','tempest-TaggedBootDevicesTest-volume-183361527',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:24:54','2025-12-06 07:30:25','2025-12-06 07:30:26',1,'5061c285-a1ac-4ce6-96b8-9bd9d7f18a74',NULL,'baddb65c90da47a58d026b0db966f6c8','001e2256cb8b430d93c1ff613010d199','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:24:54','2025-12-06 07:25:00','2025-12-06 07:30:25','tempest-ServerActionsTestOtherA-volume-1330476105',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:09:11','2025-12-06 07:09:54','2025-12-06 07:10:00',1,'5076e091-edac-4ad3-a1b0-4b489857bfaf',NULL,'33518fed43cc4fdfbdce993ccb4cc360','4c41abd44bbf46f39df642d2a2cd19eb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:09:11','2025-12-06 07:09:11','2025-12-06 07:09:54','tempest-VolumesAdminNegativeTest-volume-1918206741',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:19:11','2025-12-06 08:22:26','2025-12-06 08:22:27',1,'51b925ec-146c-45cc-ba59-9db845a18e81',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:19:11','2025-12-06 08:19:19','2025-12-06 08:22:26','tempest-TestVolumeBootPattern-volume-origin-491667449',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:37:42','2025-12-06 07:42:21','2025-12-06 07:42:42',1,'5ac3b430-9e6d-4b6b-b6db-a57a4cebd8e6',NULL,'a70f6c3c5e2c402bb6fa0e0507e9b6dc','b10aa03d68eb4d4799d53538521cc364','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:37:43','2025-12-06 07:37:43','2025-12-06 07:42:21','tempest-ServerActionsTestOtherB-volume-428913311',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:51:42','2025-12-06 07:53:02','2025-12-06 07:53:03',1,'5cd6cf93-6842-435d-92c9-f0e7f8a0e1f7',NULL,'4962bc7b172346e19d127b46ea2d7a11','c4cf19b89a6d46bca307e65731a9dd21','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:51:42','2025-12-06 07:51:43','2025-12-06 07:53:02','tempest-TestStampPattern-volume-696978171',NULL,NULL,NULL,'ca43e69d-85f3-4654-8bd9-bdfc55d6116e','6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:45','2025-12-06 07:45:53','2025-12-06 07:45:54',1,'6555c795-5067-401b-b1bb-2b940961fc91',NULL,'823b61c4027c48dc9b8f4e41bca5cf83','5dcd2d068ff04070b59e12a2cd84f89c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:45','2025-12-06 07:45:46','2025-12-06 07:45:53','tempest-VolumesTestJSON-volume-1857888380',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:38:03','2025-12-06 07:39:49','2025-12-06 07:39:52',1,'67ebc469-c3e0-45da-a1b6-9f2891a4f2a7',NULL,'605b5481e0c944048e6a67046c30d693','833f4cf9f5a64b2ab94c3bf330353a31','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:38:04','2025-12-06 07:38:57','2025-12-06 07:39:49','tempest-AttachVolumeMultiAttachTest-volume-808942888',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:06:44','2025-12-06 07:09:07','2025-12-06 07:09:07',1,'69de683a-3c3f-4661-888d-5e060d575230',NULL,'b7c2f91caf1444c68dcf6bd66966d67e','c2236fb6443441618c69ad660b0932dd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:06:44','2025-12-06 07:06:44','2025-12-06 07:09:06','tempest-UpdateMultiattachVolumeNegativeTest-volume-768788121',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:29:32','2025-12-06 07:32:28','2025-12-06 07:32:53',1,'6db274ff-02a7-4513-aa8b-c44494100a39',NULL,'8e5d532f4af34acc9e3a7a08819bb089','1a5dd5f9ca5747618b386c87a40ede88','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:29:32','2025-12-06 07:29:33','2025-12-06 07:32:28','tempest-TaggedBootDevicesTest_v242-volume-521933641',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:05:25','2025-12-06 07:05:40','2025-12-06 07:05:41',1,'72f42200-60a4-4bc0-ac08-8ab63713f05e',NULL,'e5f62143343c4499a86f710385c0c2f8','edcc68bbf9cd4c9189e59964db884a26','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:05:25','2025-12-06 07:05:25','2025-12-06 07:05:40','tempest-AttachSCSIVolumeTestJSON-volume-1722432833',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:34:28','2025-12-06 07:40:16','2025-12-06 07:40:23',1,'783c2bdc-ead3-4bc6-bfc6-f7f7388312c6',NULL,'605b5481e0c944048e6a67046c30d693','833f4cf9f5a64b2ab94c3bf330353a31','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:34:28','2025-12-06 07:34:28','2025-12-06 07:40:16','tempest-AttachVolumeMultiAttachTest-volume-33855251',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:27','2025-12-06 07:56:16','2025-12-06 07:56:19',1,'7e4b734a-50a7-4ff3-bbbd-b8eb0e71528f',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:27','2025-12-06 07:55:28','2025-12-06 07:56:16','tempest-TestInstancesWithCinderVolumes-volume-1920962140',NULL,NULL,NULL,NULL,'034fd9f5-eb5d-4abf-820e-ec38ca97d791',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:02:28','2025-12-06 07:03:54','2025-12-06 07:03:55',1,'82a6fabc-b798-4571-a13e-f9c67a3f9413',NULL,'6805353f6bf048f9b406a1e565a13f11','dc1bc9517198484ab30d93ebd5d88c35','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:02:28','2025-12-06 07:02:42','2025-12-06 07:03:54','tempest-tempest.common.compute-volume-179919969',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:09:35','2025-12-06 07:09:38','2025-12-06 07:09:39',1,'856edcf6-573e-47ac-9cd1-4993eb87b72c',NULL,'33518fed43cc4fdfbdce993ccb4cc360','4c41abd44bbf46f39df642d2a2cd19eb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:09:35','2025-12-06 07:09:36','2025-12-06 07:09:38','tempest-VolumesAdminNegativeTest-volume-1226805516',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:06:42','2025-12-06 07:09:08','2025-12-06 07:09:10',1,'86c40c18-0a1f-4cdf-8dd9-d48abd4ceed6',NULL,'b7c2f91caf1444c68dcf6bd66966d67e','c2236fb6443441618c69ad660b0932dd','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:06:42','2025-12-06 07:06:43','2025-12-06 07:09:08','tempest-UpdateMultiattachVolumeNegativeTest-volume-763384241',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:28','2025-12-06 07:57:27','2025-12-06 07:57:29',1,'8eb73d4f-1376-44e4-bc55-b6d259ff218b',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:28','2025-12-06 07:55:29','2025-12-06 07:57:27','tempest-TestInstancesWithCinderVolumes-volume-1576423276',NULL,NULL,NULL,NULL,'c9da6baf-5607-4566-b482-f3ed098a9ca2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:52:55','2025-12-06 07:54:13','2025-12-06 07:54:13',1,'903b6ad8-93b6-4571-9ff7-80ce95667ba0',NULL,'0f669e963dc54ad7bebf8dd20341428a','0c8fc5bc237e42bfad505a0bca6681eb','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:52:55','2025-12-06 07:52:56','2025-12-06 07:54:13','tempest-TestMinimumBasicScenario-volume-130315951',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:34:04','2025-12-06 07:39:49',NULL,0,'95b7906f-ca03-4ae4-bdc0-817cf9423acd',NULL,'2aa5b15c15f84a8cb24776d5c781eb09','17cdfa63c4424ec7a0eb4bb3d7372c14','hostgroup@ceph#ceph',1,'nova','available','detached','2025-12-06 07:34:04','2025-12-06 07:34:04',NULL,'c2e6b8fd-375c-4658-b338-f2d334041ba3-blank-vol','',NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:28','2025-12-06 07:57:19','2025-12-06 07:57:20',1,'9cadf3d0-8133-453d-9dbc-ba304e3665f2',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:28','2025-12-06 07:55:29','2025-12-06 07:57:19','tempest-TestInstancesWithCinderVolumes-volume-878053807',NULL,NULL,NULL,NULL,'034fd9f5-eb5d-4abf-820e-ec38ca97d791',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:36:29','2025-12-06 07:39:29','2025-12-06 07:39:35',1,'a032ab5d-3621-4ab1-82c3-2e8c7d4eeb9c',NULL,'7960f8f407754e5d83bee65690a6b772','21cd37bffa864aaebe5c734ba468f466','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:36:29','2025-12-06 07:36:53','2025-12-06 07:39:29','tempest-tempest.common.compute-volume-1864148988',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'reserved',NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:44:50','2025-12-06 07:47:22','2025-12-06 07:47:23',1,'a14d6586-39b0-4276-af6f-b199a727eac8',NULL,'1035ecd55ed54b57aa35fe32fb915cc5','4ec9294f6d4b4f44a72414374d646a4a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:44:51','2025-12-06 07:44:51','2025-12-06 07:47:22','tempest-ServersNegativeTestJSON-volume-1385768181',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:16:31','2025-12-06 08:16:49','2025-12-06 08:16:51',1,'a427e5a0-fe95-4f1e-be90-c6d37b0a00af',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:16:31','2025-12-06 08:16:32','2025-12-06 08:16:49','','',NULL,NULL,'65e19d19-35ce-41d2-a291-8681f1e9bcd8','6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:16:56','2025-12-06 08:18:48','2025-12-06 08:18:49',1,'aa997441-9cbb-4e9f-b2e7-f4b6f1e20ab1',NULL,'8e8feb4540af4e2caa45a88a9202dbe2','4b2dc4b8729f446a9c7ac69ca446f71d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:16:56','2025-12-06 08:17:03','2025-12-06 08:18:48','tempest-TestVolumeBootPattern-volume-origin-1798837453',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:51:35','2025-12-06 07:53:46','2025-12-06 07:53:47',1,'abe8f868-d32c-4fcd-9cd6-843e5af74a06',NULL,'f2335740042045fba7f544ee5140eb87','4842ecff6dce4ccc981a6b65a14ea406','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:51:36','2025-12-06 07:51:36','2025-12-06 07:53:46','tempest-ServerRescueNegativeTestJSON-volume-995405100',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:21:32','2025-12-06 07:22:55','2025-12-06 07:23:05',1,'b28b2367-60a4-4325-8a01-53a6de96135e',NULL,'c2404fce4d1f48779c97d3cbcb6ae594','9536676f60844b6f802518771f02409f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:21:32','2025-12-06 07:21:33','2025-12-06 07:22:55','tempest-TaggedAttachmentsTest-volume-1554309617',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:57:41','2025-12-06 07:58:18','2025-12-06 07:58:22',1,'b338aabc-085b-43e3-adbc-b55bb8505744',NULL,'0ce6d0a8def6432aa60891ea00ef9d8b','63df107b8bd14504974c75ba92ae469b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:57:41','2025-12-06 07:57:41','2025-12-06 07:58:18','tempest-AttachVolumeTestJSON-volume-1002867368',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:18:28','2025-12-06 07:19:37','2025-12-06 07:19:49',1,'b6c10720-e1c1-4fdc-b2cd-94ad0567f0a4',NULL,'f4715802a0b24079b4ca157db07e1d75','6c6696bf390d4cc5bfd9852d5b264b5a','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:18:28','2025-12-06 07:18:37','2025-12-06 07:19:37','tempest-tempest.common.compute-volume-915581571',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:32','2025-12-06 07:57:58','2025-12-06 07:58:02',1,'bbe9824b-1a7c-4ec6-8a4f-0f69d7c2bc92',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:32','2025-12-06 07:55:38','2025-12-06 07:57:58','tempest-TestInstancesWithCinderVolumes-volume-988367928',NULL,NULL,NULL,NULL,'58b799b3-95b6-421a-829c-be22998d1df8',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:28','2025-12-06 07:56:49','2025-12-06 07:56:50',1,'c7a5e27c-c7d8-4759-87be-61891912cec5',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:56:49','tempest-TestInstancesWithCinderVolumes-volume-1293997086',NULL,NULL,NULL,NULL,'034fd9f5-eb5d-4abf-820e-ec38ca97d791',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 08:27:43','2025-12-06 08:28:26','2025-12-06 08:28:26',1,'cac0df88-28ec-4cc6-ba02-9bd488ce8782',NULL,'00e2fea2f8f54b1c9af85553820566a6','55d0236410514dd9ad6cdb3e1a5d0ee6','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 08:27:43','2025-12-06 08:27:43','2025-12-06 08:28:26','tempest-TestVolumeBackupRestore-volume-551996610',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:55:28','2025-12-06 07:56:52','2025-12-06 07:56:53',1,'cbaeb237-1f40-498b-93c2-2ed85aff86b7',NULL,'e685a049c8a74aa8aea831fbdaf2acf8','6164fee998c94b71a37886fe42b4c56c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:55:28','2025-12-06 07:55:28','2025-12-06 07:56:52','tempest-TestInstancesWithCinderVolumes-volume-47494743',NULL,NULL,NULL,NULL,'c9da6baf-5607-4566-b482-f3ed098a9ca2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:32:16','2025-12-06 07:40:44','2025-12-06 07:40:47',1,'d2147d68-ea53-4b01-b660-c00c430f356d',NULL,'605b5481e0c944048e6a67046c30d693','833f4cf9f5a64b2ab94c3bf330353a31','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:32:16','2025-12-06 07:33:09','2025-12-06 07:40:44','tempest-AttachVolumeMultiAttachTest-volume-901235593',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:46:57','2025-12-06 07:48:16','2025-12-06 07:48:17',1,'d3873e66-0cd3-4a84-b18d-551e693a7554',NULL,'5933a27f4e504e23a5d084501196c0fb','329d4c9562c84ec5a42ca68894cbf27f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:46:58','2025-12-06 07:47:08','2025-12-06 07:48:16','tempest-TestEncryptedCinderVolumes-volume-627830965',NULL,NULL,NULL,NULL,'dc92f0f9-02c2-4310-b039-2df7a47f17b2',NULL,0,NULL,NULL,'7eed8ca9-eab0-4d8c-a68e-c776c26acb17',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:16:32','2025-12-06 07:18:38','2025-12-06 07:18:38',1,'d3c6383c-41f5-49ad-8585-fc49088a4d05',NULL,'197a9b0ee1db487d82542eb31e84f33e','8f938a037b8141cf9408cbf6f5cd081d','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:16:32','2025-12-06 07:16:33','2025-12-06 07:18:38','tempest-TaggedBootDevicesTest-volume-187231485',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:42:14','2025-12-06 07:46:01','2025-12-06 07:46:03',1,'df0e5c71-5906-44fa-bff0-b66876c47ac5',NULL,'297bc99c242e4fa8aedea4a6367b61c0','741dc47f9ced423cbd99fd6f9d32904f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:42:14','2025-12-06 07:42:15','2025-12-06 07:46:01','tempest-AttachVolumeNegativeTest-volume-1161379000',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:57:46','2025-12-06 07:58:08','2025-12-06 07:58:17',1,'eb0607fb-3d18-4469-8db9-a7f938c59ae5',NULL,'0ce6d0a8def6432aa60891ea00ef9d8b','63df107b8bd14504974c75ba92ae469b','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:57:46','2025-12-06 07:57:46','2025-12-06 07:58:08','tempest-AttachVolumeTestJSON-volume-1141116819',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 06:57:55','2025-12-06 06:59:02','2025-12-06 06:59:03',1,'efe8ed74-896b-4b4f-9562-1c790f1f79e8',NULL,'28495070d0e94414977511fb98ee8288','ac4575fdd57240a9988c7ae425f0c2aa','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 06:57:55','2025-12-06 06:57:57','2025-12-06 06:59:02','tempest-VolumesAssistedSnapshotsTest-volume-1226220488',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:58:38','2025-12-06 08:00:49','2025-12-06 08:00:51',1,'f1cb8c3c-521b-48db-b5f7-453fef5dd2fe',NULL,'98e657096e3f4b528cd461a3dd6a750e','c3c0564f8e9f4af9ae5b597a275c989f','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:58:38','2025-12-06 07:58:47','2025-12-06 08:00:49','tempest-tempest.common.compute-volume-1966113612',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:47','2025-12-06 07:45:52','2025-12-06 07:45:53',1,'f2f4c32e-dd22-4d24-ac81-511282328976',NULL,'823b61c4027c48dc9b8f4e41bca5cf83','5dcd2d068ff04070b59e12a2cd84f89c','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:47','2025-12-06 07:45:47','2025-12-06 07:45:52','tempest-VolumesTestJSON-volume-229456353',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:27:40','2025-12-06 07:30:20','2025-12-06 07:30:20',1,'f889bfdf-c600-4260-90f0-d332e8e3d79b',NULL,'baddb65c90da47a58d026b0db966f6c8','001e2256cb8b430d93c1ff613010d199','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:27:40','2025-12-06 07:28:14','2025-12-06 07:30:20','tempest-tempest.common.compute-volume-1339361521',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:35:49','2025-12-06 07:39:55','2025-12-06 07:39:56',1,'fb115316-35b8-4af3-9847-c6315737a158',NULL,'605b5481e0c944048e6a67046c30d693','833f4cf9f5a64b2ab94c3bf330353a31','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:35:49','2025-12-06 07:36:03','2025-12-06 07:39:55','tempest-AttachVolumeMultiAttachTest-volume-206566439',NULL,'{\"saved_features\":61}',NULL,NULL,'b1150443-1e04-4872-9c8f-90f403a56362',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1),('2025-12-06 07:45:35','2025-12-06 07:45:36','2025-12-06 07:45:37',1,'fd7b45bb-5a45-450f-a9a7-d69b49c92abc',NULL,'d0ccbbf5f3da4654a5c9919be9b8a2bb','00a24842329842059aee8ff6e53c0c00','hostgroup@ceph#ceph',1,'nova','deleted','detached','2025-12-06 07:45:35','2025-12-06 07:45:36','2025-12-06 07:45:36','tempest-VolumesGetTestJSON-Volume-984618614',NULL,NULL,NULL,NULL,'6156fe10-4ec6-42bd-b179-f6683c03e87b',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'879893a8-2aa9-4f72-bd95-1dbf7c6f334b',0,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-06 06:09:50','2025-12-06 06:09:50.000123',NULL,0,1,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (1,'6efab05d-c7cf-4770-a5c3-c806a2739063','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/6efab05d-c7cf-4770-a5c3-c806a2739063/snap','2025-12-06 06:56:38','2025-12-06 06:56:38',NULL,0,'{\"store\": \"default_backend\"}','active'),(2,'412dd61d-1b1e-439f-b7f9-7e7c4e42924c','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/412dd61d-1b1e-439f-b7f9-7e7c4e42924c/snap','2025-12-06 06:56:41','2025-12-06 06:56:41',NULL,0,'{\"store\": \"default_backend\"}','active'),(3,'544e5cd1-78c2-46b6-bec1-176dc9a97c75','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/544e5cd1-78c2-46b6-bec1-176dc9a97c75/snap','2025-12-06 07:04:51','2025-12-06 07:05:39','2025-12-06 07:05:39',1,'{\"store\": \"default_backend\"}','deleted'),(4,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/6e62d22c-45f1-4591-b9e8-303a0bc90e48/snap','2025-12-06 07:05:25','2025-12-06 07:05:39','2025-12-06 07:05:39',1,'{\"store\": \"default_backend\"}','deleted'),(5,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/11dbd9ca-4725-400f-ade9-f5493c82f6e2/snap','2025-12-06 07:06:01','2025-12-06 07:06:16','2025-12-06 07:06:16',1,'{\"store\": \"default_backend\"}','deleted'),(6,'66510630-de0f-49cc-be1c-e43008b502ef','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/66510630-de0f-49cc-be1c-e43008b502ef/snap','2025-12-06 07:08:18','2025-12-06 07:08:36','2025-12-06 07:08:36',1,'{\"store\": \"default_backend\"}','deleted'),(7,'7214bfa6-0002-48d4-93d1-72a077cc984f','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/7214bfa6-0002-48d4-93d1-72a077cc984f/snap','2025-12-06 07:08:44','2025-12-06 07:10:27','2025-12-06 07:10:27',1,'{\"store\": \"default_backend\"}','deleted'),(8,'14f124b6-e911-4720-a685-affb8dbe0f13','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/14f124b6-e911-4720-a685-affb8dbe0f13/snap','2025-12-06 07:08:47','2025-12-06 07:10:25','2025-12-06 07:10:25',1,'{\"store\": \"default_backend\"}','deleted'),(9,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/a2519fc1-5a48-4adb-858b-30c6d08d1a53/snap','2025-12-06 07:08:48','2025-12-06 07:08:54','2025-12-06 07:08:54',1,'{\"store\": \"default_backend\"}','deleted'),(10,'c74443ce-ba5e-43f8-9494-f21e8c68a03c','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/c74443ce-ba5e-43f8-9494-f21e8c68a03c/snap','2025-12-06 07:08:51','2025-12-06 07:10:23','2025-12-06 07:10:23',1,'{\"store\": \"default_backend\"}','deleted'),(11,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/4038f20e-02ea-4a6a-aa3a-eaf0b9450896/snap','2025-12-06 07:09:04','2025-12-06 07:09:08','2025-12-06 07:09:08',1,'{\"store\": \"default_backend\"}','deleted'),(12,'84696b79-26a5-4d20-90c5-9f50a860fde7','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/84696b79-26a5-4d20-90c5-9f50a860fde7/snap','2025-12-06 07:09:10','2025-12-06 07:09:59','2025-12-06 07:09:59',1,'{\"store\": \"default_backend\"}','deleted'),(13,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6/snap','2025-12-06 07:09:17','2025-12-06 07:09:55','2025-12-06 07:09:55',1,'{\"store\": \"default_backend\"}','deleted'),(14,'b4deb7ef-9e65-4ebe-874a-920264d09c32','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/b4deb7ef-9e65-4ebe-874a-920264d09c32/snap','2025-12-06 07:09:25','2025-12-06 07:09:29','2025-12-06 07:09:29',1,'{\"store\": \"default_backend\"}','deleted'),(15,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc/snap','2025-12-06 07:09:27','2025-12-06 07:09:50','2025-12-06 07:09:50',1,'{\"store\": \"default_backend\"}','deleted'),(16,'29145f63-7097-42b2-b998-dd2d2a5d0fda','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/29145f63-7097-42b2-b998-dd2d2a5d0fda/snap','2025-12-06 07:11:35','2025-12-06 07:11:38','2025-12-06 07:11:38',1,'{\"store\": \"default_backend\"}','deleted'),(17,'eba516b2-6064-409c-87d5-453285b93544','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/eba516b2-6064-409c-87d5-453285b93544/snap','2025-12-06 07:12:31','2025-12-06 07:12:34','2025-12-06 07:12:34',1,'{\"store\": \"default_backend\"}','deleted'),(18,'9b6e4b95-ff8f-4732-b604-e00530db621e','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/9b6e4b95-ff8f-4732-b604-e00530db621e/snap','2025-12-06 07:13:00','2025-12-06 07:13:04','2025-12-06 07:13:04',1,'{\"store\": \"default_backend\"}','deleted'),(19,'6b59300d-e8aa-4c06-be5d-280ba7e39063','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/6b59300d-e8aa-4c06-be5d-280ba7e39063/snap','2025-12-06 07:13:30','2025-12-06 07:14:00','2025-12-06 07:14:00',1,'{\"store\": \"default_backend\"}','deleted'),(20,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/ce6c8150-0026-4838-b3e9-1b872e9a3cee/snap','2025-12-06 07:23:15','2025-12-06 07:23:25','2025-12-06 07:23:25',1,'{\"store\": \"default_backend\"}','deleted'),(21,'24540ea9-2655-4ff6-a852-08458e75db90','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/24540ea9-2655-4ff6-a852-08458e75db90/snap','2025-12-06 07:33:46','2025-12-06 07:34:26','2025-12-06 07:34:26',1,'{\"store\": \"default_backend\"}','deleted'),(22,'deed3bf2-6426-476b-8bb8-98ac272255a2','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/deed3bf2-6426-476b-8bb8-98ac272255a2/snap','2025-12-06 07:33:59','2025-12-06 07:39:52','2025-12-06 07:39:52',1,'{\"store\": \"default_backend\"}','deleted'),(23,'c4654208-04b4-4132-87e5-c9f3bf472e83','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/c4654208-04b4-4132-87e5-c9f3bf472e83/snap','2025-12-06 07:34:08','2025-12-06 07:34:52','2025-12-06 07:34:52',1,'{\"store\": \"default_backend\"}','deleted'),(24,'a40e0372-ba8c-4000-a161-8b667b00eb86','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/a40e0372-ba8c-4000-a161-8b667b00eb86/snap','2025-12-06 07:34:22','2025-12-06 07:34:29','2025-12-06 07:34:29',1,'{\"store\": \"default_backend\"}','deleted'),(25,'441cc72d-7648-41a4-9dbf-54930196cf56','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/441cc72d-7648-41a4-9dbf-54930196cf56/snap','2025-12-06 07:36:48','2025-12-06 07:39:39','2025-12-06 07:39:39',1,'{\"store\": \"default_backend\"}','deleted'),(26,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/60ee3e9a-fd92-41ea-ba58-4c45d1211b24/snap','2025-12-06 07:39:39','2025-12-06 07:39:54','2025-12-06 07:39:54',1,'{\"store\": \"default_backend\"}','deleted'),(27,'4df1dc2e-92f6-4200-8389-10650a86e843','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/4df1dc2e-92f6-4200-8389-10650a86e843/snap','2025-12-06 07:40:51','2025-12-06 07:42:01','2025-12-06 07:42:01',1,'{\"store\": \"default_backend\"}','deleted'),(28,'16647923-36b7-4c61-9de3-fb629f75ca61','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/16647923-36b7-4c61-9de3-fb629f75ca61/snap','2025-12-06 07:41:21','2025-12-06 07:41:48','2025-12-06 07:41:48',1,'{\"store\": \"default_backend\"}','deleted'),(29,'de1696d2-fc5b-497d-a09d-4993ee316ff9','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/de1696d2-fc5b-497d-a09d-4993ee316ff9/snap','2025-12-06 07:43:31','2025-12-06 07:48:23','2025-12-06 07:48:23',1,'{\"store\": \"default_backend\"}','deleted'),(30,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9/snap','2025-12-06 07:44:23','2025-12-06 07:48:13','2025-12-06 07:48:13',1,'{\"store\": \"default_backend\"}','deleted'),(31,'5b8b504a-6057-4871-810a-63dfe9ed4af8','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/5b8b504a-6057-4871-810a-63dfe9ed4af8/snap','2025-12-06 07:45:28','2025-12-06 07:48:02','2025-12-06 07:48:02',1,'{\"store\": \"default_backend\"}','deleted'),(32,'1a501272-45c2-411f-9825-0c663b862e6b','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/1a501272-45c2-411f-9825-0c663b862e6b/snap','2025-12-06 07:46:29','2025-12-06 07:46:46','2025-12-06 07:46:46',1,'{\"store\": \"default_backend\"}','deleted'),(33,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/4a5b4c30-2416-4ed2-b947-8bb73ef88bd7/snap','2025-12-06 07:46:39','2025-12-06 07:47:46','2025-12-06 07:47:46',1,'{\"store\": \"default_backend\"}','deleted'),(34,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/85f1f69b-a9ee-46e0-a30b-ae7faf09ffef/snap','2025-12-06 07:47:12','2025-12-06 07:48:19','2025-12-06 07:48:19',1,'{\"store\": \"default_backend\"}','deleted'),(35,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/5ed78aa8-6ca4-4423-a38b-01e37b179e36/snap','2025-12-06 07:48:02','2025-12-06 07:48:03','2025-12-06 07:48:03',1,'{\"store\": \"default_backend\"}','deleted'),(36,'6916f635-11b7-4158-ab13-60ff56406973','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/6916f635-11b7-4158-ab13-60ff56406973/snap','2025-12-06 07:50:05','2025-12-06 07:52:27','2025-12-06 07:52:27',1,'{\"store\": \"default_backend\"}','deleted'),(37,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e/snap','2025-12-06 07:51:34','2025-12-06 07:51:57','2025-12-06 07:51:57',1,'{\"store\": \"default_backend\"}','deleted'),(38,'83fea89a-3a0d-4881-b429-13684080bb6c','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/83fea89a-3a0d-4881-b429-13684080bb6c/snap','2025-12-06 07:51:40','2025-12-06 07:53:05','2025-12-06 07:53:05',1,'{\"store\": \"default_backend\"}','deleted'),(39,'1af12b1c-b711-4118-bb67-f97cd1b83061','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/1af12b1c-b711-4118-bb67-f97cd1b83061/snap','2025-12-06 07:52:31','2025-12-06 07:54:21','2025-12-06 07:54:21',1,'{\"store\": \"default_backend\"}','deleted'),(40,'f1264656-a902-4225-be11-839d8f664fd7','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/f1264656-a902-4225-be11-839d8f664fd7/snap','2025-12-06 07:53:50','2025-12-06 07:54:18','2025-12-06 07:54:18',1,'{\"store\": \"default_backend\"}','deleted'),(41,'d2f3b5e0-e512-4475-bd2e-0cf53dc74129','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/d2f3b5e0-e512-4475-bd2e-0cf53dc74129/snap','2025-12-06 07:55:26','2025-12-06 07:58:20','2025-12-06 07:58:20',1,'{\"store\": \"default_backend\"}','deleted'),(42,'12e13902-aaee-45d7-b251-bc95170ae31e','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/12e13902-aaee-45d7-b251-bc95170ae31e/snap','2025-12-06 07:57:40','2025-12-06 07:58:15','2025-12-06 07:58:15',1,'{\"store\": \"default_backend\"}','deleted'),(43,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','rbd://40a1bae4-cf76-5610-8dab-c75116dfe0bb/images/c5cbac11-d6e7-4196-b42c-615f51a1fae2/snap','2025-12-06 08:17:47','2025-12-06 08:19:00','2025-12-06 08:19:00',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'6efab05d-c7cf-4770-a5c3-c806a2739063','hw_rng_model','virtio','2025-12-06 06:56:26','2025-12-06 06:56:26',NULL,0),(2,'412dd61d-1b1e-439f-b7f9-7e7c4e42924c','hw_rng_model','virtio','2025-12-06 06:56:38','2025-12-06 06:56:38',NULL,0),(3,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_rng_model','virtio','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(4,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(5,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','owner_user_name','tempest-UnshelveToHostMultiNodesTest-311268056-project-member','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(6,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','owner_project_name','tempest-UnshelveToHostMultiNodesTest-311268056','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(7,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','boot_roles','reader,member','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(8,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_machine_type','q35','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(9,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_cdrom_bus','sata','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(10,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_disk_bus','virtio','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(11,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_input_bus','usb','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(12,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_pointer_model','usbtablet','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(13,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_video_model','virtio','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(14,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','hw_vif_model','virtio','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(15,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','instance_uuid','dd7ff314-b789-4550-ab9a-44dc02948350','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(16,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','user_id','3c3859554f86419a941a5924e80b88de','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(17,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','image_type','snapshot','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(18,'544e5cd1-78c2-46b6-bec1-176dc9a97c75','hw_scsi_model','virtio-scsi','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(19,'544e5cd1-78c2-46b6-bec1-176dc9a97c75','hw_disk_bus','scsi','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(20,'544e5cd1-78c2-46b6-bec1-176dc9a97c75','hw_cdrom_bus','scsi','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1),(21,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','image_state','available','2025-12-06 07:05:21','2025-12-06 07:05:40','2025-12-06 07:05:40',1),(22,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','owner_id','e2384cf38a13417c9220db3aafff6b24','2025-12-06 07:05:21','2025-12-06 07:05:40','2025-12-06 07:05:40',1),(23,'6e62d22c-45f1-4591-b9e8-303a0bc90e48','image_location','snapshot','2025-12-06 07:05:21','2025-12-06 07:05:40','2025-12-06 07:05:40',1),(24,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_rng_model','virtio','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(25,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(26,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','owner_user_name','tempest-UnshelveToHostMultiNodesTest-311268056-project-member','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(27,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','owner_project_name','tempest-UnshelveToHostMultiNodesTest-311268056','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(28,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','boot_roles','reader,member','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(29,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_machine_type','q35','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(30,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_cdrom_bus','sata','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(31,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_disk_bus','virtio','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(32,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_input_bus','usb','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(33,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_pointer_model','usbtablet','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(34,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_video_model','virtio','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(35,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','hw_vif_model','virtio','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(36,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','clean_attempts','1','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(37,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','instance_uuid','dd7ff314-b789-4550-ab9a-44dc02948350','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(38,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','user_id','3c3859554f86419a941a5924e80b88de','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(39,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','image_type','snapshot','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(40,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','image_state','available','2025-12-06 07:06:00','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(41,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','owner_id','e2384cf38a13417c9220db3aafff6b24','2025-12-06 07:06:00','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(42,'11dbd9ca-4725-400f-ade9-f5493c82f6e2','image_location','snapshot','2025-12-06 07:06:00','2025-12-06 07:06:16','2025-12-06 07:06:16',1),(43,'66510630-de0f-49cc-be1c-e43008b502ef','os_distro','value2','2025-12-06 07:08:20','2025-12-06 07:08:36','2025-12-06 07:08:36',1),(44,'66510630-de0f-49cc-be1c-e43008b502ef','os_version','alt1','2025-12-06 07:08:20','2025-12-06 07:08:36','2025-12-06 07:08:36',1),(45,'66510630-de0f-49cc-be1c-e43008b502ef','architecture','value3','2025-12-06 07:08:28','2025-12-06 07:08:36','2025-12-06 07:08:36',1),(46,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_rng_model','virtio','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(47,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(48,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','owner_user_name','tempest-ImagesOneServerTestJSON-1888020106-project-member','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(49,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','owner_project_name','tempest-ImagesOneServerTestJSON-1888020106','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(50,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','boot_roles','member,reader','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(51,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_machine_type','q35','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(52,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_cdrom_bus','sata','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(53,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_disk_bus','virtio','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(54,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_input_bus','usb','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(55,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_pointer_model','usbtablet','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(56,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_video_model','virtio','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(57,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','hw_vif_model','virtio','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(58,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','instance_uuid','f9624722-30f1-4e59-ae6a-347ad7a8a4fd','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(59,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','user_id','98f77d99921448508eb3ac7bf8c4fa34','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(60,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','image_type','test','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(61,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','owner_id','87ee3f11e794407692b09a4b77c91610','2025-12-06 07:08:47','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(62,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','image_state','available','2025-12-06 07:08:47','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(63,'a2519fc1-5a48-4adb-858b-30c6d08d1a53','image_location','snapshot','2025-12-06 07:08:47','2025-12-06 07:08:54','2025-12-06 07:08:54',1),(64,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_rng_model','virtio','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(65,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(66,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','owner_user_name','tempest-ImagesOneServerTestJSON-1888020106-project-member','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(67,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','owner_project_name','tempest-ImagesOneServerTestJSON-1888020106','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(68,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','boot_roles','member,reader','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(69,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_machine_type','q35','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(70,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_cdrom_bus','sata','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(71,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_disk_bus','virtio','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(72,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_input_bus','usb','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(73,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_pointer_model','usbtablet','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(74,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_video_model','virtio','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(75,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','hw_vif_model','virtio','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(76,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','instance_uuid','f9624722-30f1-4e59-ae6a-347ad7a8a4fd','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(77,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','user_id','98f77d99921448508eb3ac7bf8c4fa34','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(78,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','image_type','snapshot','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(79,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','owner_id','87ee3f11e794407692b09a4b77c91610','2025-12-06 07:09:04','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(80,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','image_state','available','2025-12-06 07:09:04','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(81,'4038f20e-02ea-4a6a-aa3a-eaf0b9450896','image_location','snapshot','2025-12-06 07:09:04','2025-12-06 07:09:08','2025-12-06 07:09:08',1),(82,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_rng_model','virtio','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(83,'84696b79-26a5-4d20-90c5-9f50a860fde7','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(84,'84696b79-26a5-4d20-90c5-9f50a860fde7','owner_user_name','tempest-ListImageFiltersTestJSON-1891540223-project-member','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(85,'84696b79-26a5-4d20-90c5-9f50a860fde7','owner_project_name','tempest-ListImageFiltersTestJSON-1891540223','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(86,'84696b79-26a5-4d20-90c5-9f50a860fde7','boot_roles','reader,member','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(87,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_machine_type','q35','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(88,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_cdrom_bus','sata','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(89,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_disk_bus','virtio','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(90,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_input_bus','usb','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(91,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_pointer_model','usbtablet','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(92,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_video_model','virtio','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(93,'84696b79-26a5-4d20-90c5-9f50a860fde7','hw_vif_model','virtio','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(94,'84696b79-26a5-4d20-90c5-9f50a860fde7','instance_uuid','c67cab07-55d9-4f41-aa3c-c367f840ba27','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(95,'84696b79-26a5-4d20-90c5-9f50a860fde7','user_id','3786fc2472ec43adb27b29bfa497a6a2','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(96,'84696b79-26a5-4d20-90c5-9f50a860fde7','image_type','snapshot','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(97,'84696b79-26a5-4d20-90c5-9f50a860fde7','image_state','available','2025-12-06 07:09:09','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(98,'84696b79-26a5-4d20-90c5-9f50a860fde7','owner_id','6f86ab5a5bf14cb6b789f065cc8ca04a','2025-12-06 07:09:09','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(99,'84696b79-26a5-4d20-90c5-9f50a860fde7','image_location','snapshot','2025-12-06 07:09:09','2025-12-06 07:10:00','2025-12-06 07:10:00',1),(100,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_rng_model','virtio','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(101,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(102,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','owner_user_name','tempest-ListImageFiltersTestJSON-1891540223-project-member','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(103,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','owner_project_name','tempest-ListImageFiltersTestJSON-1891540223','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(104,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','boot_roles','reader,member','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(105,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_machine_type','q35','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(106,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_cdrom_bus','sata','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(107,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_disk_bus','virtio','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(108,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_input_bus','usb','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(109,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_pointer_model','usbtablet','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(110,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_video_model','virtio','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(111,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','hw_vif_model','virtio','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(112,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','instance_uuid','8d469882-2e42-4956-8009-73a78a8e5c80','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(113,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','user_id','3786fc2472ec43adb27b29bfa497a6a2','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(114,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','image_type','snapshot','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(115,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','owner_id','6f86ab5a5bf14cb6b789f065cc8ca04a','2025-12-06 07:09:16','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(116,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','image_location','snapshot','2025-12-06 07:09:16','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(117,'f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','image_state','available','2025-12-06 07:09:16','2025-12-06 07:09:55','2025-12-06 07:09:55',1),(118,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_rng_model','virtio','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(119,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(120,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','owner_user_name','tempest-ListImageFiltersTestJSON-1891540223-project-member','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(121,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','owner_project_name','tempest-ListImageFiltersTestJSON-1891540223','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(122,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','boot_roles','reader,member','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(123,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_machine_type','q35','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(124,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_cdrom_bus','sata','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(125,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_disk_bus','virtio','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(126,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_input_bus','usb','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(127,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_pointer_model','usbtablet','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(128,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_video_model','virtio','2025-12-06 07:09:19','2025-12-06 07:09:50','2025-12-06 07:09:50',1),(129,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','hw_vif_model','virtio','2025-12-06 07:09:19','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(130,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','instance_uuid','c67cab07-55d9-4f41-aa3c-c367f840ba27','2025-12-06 07:09:19','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(131,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','user_id','3786fc2472ec43adb27b29bfa497a6a2','2025-12-06 07:09:19','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(132,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','image_type','snapshot','2025-12-06 07:09:19','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(133,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','image_state','available','2025-12-06 07:09:27','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(134,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','owner_id','6f86ab5a5bf14cb6b789f065cc8ca04a','2025-12-06 07:09:27','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(135,'0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','image_location','snapshot','2025-12-06 07:09:27','2025-12-06 07:09:51','2025-12-06 07:09:51',1),(136,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_rng_model','virtio','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(137,'29145f63-7097-42b2-b998-dd2d2a5d0fda','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(138,'29145f63-7097-42b2-b998-dd2d2a5d0fda','owner_user_name','tempest-ImagesTestJSON-134159412-project-member','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(139,'29145f63-7097-42b2-b998-dd2d2a5d0fda','owner_project_name','tempest-ImagesTestJSON-134159412','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(140,'29145f63-7097-42b2-b998-dd2d2a5d0fda','boot_roles','member,reader','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(141,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_machine_type','q35','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(142,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_cdrom_bus','sata','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(143,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_disk_bus','virtio','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(144,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_input_bus','usb','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(145,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_pointer_model','usbtablet','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(146,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_video_model','virtio','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(147,'29145f63-7097-42b2-b998-dd2d2a5d0fda','hw_vif_model','virtio','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(148,'29145f63-7097-42b2-b998-dd2d2a5d0fda','instance_uuid','ea037582-b3d9-4ad8-ab2c-0b47adfb9c3d','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(149,'29145f63-7097-42b2-b998-dd2d2a5d0fda','user_id','bdd7994b0ebb4035a373b6560aa7dbcf','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(150,'29145f63-7097-42b2-b998-dd2d2a5d0fda','image_type','snapshot','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(151,'29145f63-7097-42b2-b998-dd2d2a5d0fda','owner_id','af7365adc05f4624a08a71cd5a77ada6','2025-12-06 07:11:34','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(152,'29145f63-7097-42b2-b998-dd2d2a5d0fda','image_state','available','2025-12-06 07:11:34','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(153,'29145f63-7097-42b2-b998-dd2d2a5d0fda','image_location','snapshot','2025-12-06 07:11:34','2025-12-06 07:11:38','2025-12-06 07:11:38',1),(154,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_rng_model','virtio','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(155,'1353436e-de17-4a6b-a172-0c01d62ca482','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(156,'1353436e-de17-4a6b-a172-0c01d62ca482','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-324135674-project-member','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(157,'1353436e-de17-4a6b-a172-0c01d62ca482','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-324135674','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(158,'1353436e-de17-4a6b-a172-0c01d62ca482','boot_roles','reader,member','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(159,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_machine_type','q35','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(160,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_cdrom_bus','sata','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(161,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_disk_bus','virtio','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(162,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_input_bus','usb','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(163,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_pointer_model','usbtablet','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(164,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_video_model','virtio','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(165,'1353436e-de17-4a6b-a172-0c01d62ca482','hw_vif_model','virtio','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(166,'1353436e-de17-4a6b-a172-0c01d62ca482','instance_uuid','1445e39c-6c8c-4a8f-9eab-64e13b262e40','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(167,'1353436e-de17-4a6b-a172-0c01d62ca482','user_id','a1ed181a1103481fa4d0b29ce1009dca','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(168,'1353436e-de17-4a6b-a172-0c01d62ca482','image_type','snapshot','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1),(169,'eba516b2-6064-409c-87d5-453285b93544','hw_rng_model','virtio','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(170,'eba516b2-6064-409c-87d5-453285b93544','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(171,'eba516b2-6064-409c-87d5-453285b93544','owner_user_name','tempest-ImagesTestJSON-134159412-project-member','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(172,'eba516b2-6064-409c-87d5-453285b93544','owner_project_name','tempest-ImagesTestJSON-134159412','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(173,'eba516b2-6064-409c-87d5-453285b93544','boot_roles','reader,member','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(174,'eba516b2-6064-409c-87d5-453285b93544','hw_machine_type','q35','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(175,'eba516b2-6064-409c-87d5-453285b93544','hw_cdrom_bus','sata','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(176,'eba516b2-6064-409c-87d5-453285b93544','hw_disk_bus','virtio','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(177,'eba516b2-6064-409c-87d5-453285b93544','hw_input_bus','usb','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(178,'eba516b2-6064-409c-87d5-453285b93544','hw_pointer_model','usbtablet','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(179,'eba516b2-6064-409c-87d5-453285b93544','hw_video_model','virtio','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(180,'eba516b2-6064-409c-87d5-453285b93544','hw_vif_model','virtio','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(181,'eba516b2-6064-409c-87d5-453285b93544','instance_uuid','d59682c6-381c-46bb-9d18-5f76d43dc560','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(182,'eba516b2-6064-409c-87d5-453285b93544','user_id','bdd7994b0ebb4035a373b6560aa7dbcf','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(183,'eba516b2-6064-409c-87d5-453285b93544','image_type','snapshot','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(184,'eba516b2-6064-409c-87d5-453285b93544','image_state','available','2025-12-06 07:12:31','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(185,'eba516b2-6064-409c-87d5-453285b93544','owner_id','af7365adc05f4624a08a71cd5a77ada6','2025-12-06 07:12:31','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(186,'eba516b2-6064-409c-87d5-453285b93544','image_location','snapshot','2025-12-06 07:12:31','2025-12-06 07:12:34','2025-12-06 07:12:34',1),(187,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_rng_model','virtio','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(188,'9b6e4b95-ff8f-4732-b604-e00530db621e','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(189,'9b6e4b95-ff8f-4732-b604-e00530db621e','owner_user_name','tempest-ImagesTestJSON-134159412-project-member','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(190,'9b6e4b95-ff8f-4732-b604-e00530db621e','owner_project_name','tempest-ImagesTestJSON-134159412','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(191,'9b6e4b95-ff8f-4732-b604-e00530db621e','boot_roles','member,reader','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(192,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_machine_type','q35','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(193,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_cdrom_bus','sata','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(194,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_disk_bus','virtio','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(195,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_input_bus','usb','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(196,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_pointer_model','usbtablet','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(197,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_video_model','virtio','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(198,'9b6e4b95-ff8f-4732-b604-e00530db621e','hw_vif_model','virtio','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(199,'9b6e4b95-ff8f-4732-b604-e00530db621e','old_vm_state','active','2025-12-06 07:12:53','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(200,'9b6e4b95-ff8f-4732-b604-e00530db621e','instance_uuid','a4b6c016-d090-4c71-9a1d-1f0debbdf5b0','2025-12-06 07:12:53','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(201,'9b6e4b95-ff8f-4732-b604-e00530db621e','user_id','bdd7994b0ebb4035a373b6560aa7dbcf','2025-12-06 07:12:53','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(202,'9b6e4b95-ff8f-4732-b604-e00530db621e','image_type','snapshot','2025-12-06 07:12:53','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(203,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_rng_model','virtio','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(204,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(205,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','owner_user_name','tempest-ImagesOneServerNegativeTestJSON-324135674-project-member','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(206,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','owner_project_name','tempest-ImagesOneServerNegativeTestJSON-324135674','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(207,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','boot_roles','reader,member','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(208,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_machine_type','q35','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(209,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_cdrom_bus','sata','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(210,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_disk_bus','virtio','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(211,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_input_bus','usb','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(212,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_pointer_model','usbtablet','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(213,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_video_model','virtio','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(214,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','hw_vif_model','virtio','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(215,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','instance_uuid','4e5a488b-67a2-44eb-a8b5-e963515206c9','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(216,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','user_id','a1ed181a1103481fa4d0b29ce1009dca','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(217,'78b95c69-8ea4-40d9-832c-1e5db1eba4f8','image_type','snapshot','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1),(218,'9b6e4b95-ff8f-4732-b604-e00530db621e','owner_id','af7365adc05f4624a08a71cd5a77ada6','2025-12-06 07:12:57','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(219,'9b6e4b95-ff8f-4732-b604-e00530db621e','image_location','snapshot','2025-12-06 07:12:57','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(220,'9b6e4b95-ff8f-4732-b604-e00530db621e','image_state','available','2025-12-06 07:12:57','2025-12-06 07:13:04','2025-12-06 07:13:04',1),(221,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_rng_model','virtio','2025-12-06 07:13:22','2025-12-06 07:14:00','2025-12-06 07:14:00',1),(222,'6b59300d-e8aa-4c06-be5d-280ba7e39063','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:13:22','2025-12-06 07:14:00','2025-12-06 07:14:00',1),(223,'6b59300d-e8aa-4c06-be5d-280ba7e39063','owner_user_name','tempest-ImagesTestJSON-134159412-project-member','2025-12-06 07:13:22','2025-12-06 07:14:00','2025-12-06 07:14:00',1),(224,'6b59300d-e8aa-4c06-be5d-280ba7e39063','owner_project_name','tempest-ImagesTestJSON-134159412','2025-12-06 07:13:22','2025-12-06 07:14:00','2025-12-06 07:14:00',1),(225,'6b59300d-e8aa-4c06-be5d-280ba7e39063','boot_roles','reader,member','2025-12-06 07:13:22','2025-12-06 07:14:00','2025-12-06 07:14:00',1),(226,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_machine_type','q35','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(227,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_cdrom_bus','sata','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(228,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_disk_bus','virtio','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(229,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_input_bus','usb','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(230,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_pointer_model','usbtablet','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(231,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_video_model','virtio','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(232,'6b59300d-e8aa-4c06-be5d-280ba7e39063','hw_vif_model','virtio','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(233,'6b59300d-e8aa-4c06-be5d-280ba7e39063','instance_uuid','db2b4e57-20af-415b-ad7b-ac5b7197acb6','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(234,'6b59300d-e8aa-4c06-be5d-280ba7e39063','user_id','bdd7994b0ebb4035a373b6560aa7dbcf','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(235,'6b59300d-e8aa-4c06-be5d-280ba7e39063','image_type','snapshot','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(236,'6b59300d-e8aa-4c06-be5d-280ba7e39063','owner_id','af7365adc05f4624a08a71cd5a77ada6','2025-12-06 07:13:27','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(237,'6b59300d-e8aa-4c06-be5d-280ba7e39063','image_location','snapshot','2025-12-06 07:13:27','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(238,'6b59300d-e8aa-4c06-be5d-280ba7e39063','image_state','available','2025-12-06 07:13:27','2025-12-06 07:14:01','2025-12-06 07:14:01',1),(239,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_rng_model','virtio','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(240,'0439f43d-0ed1-4c0e-8789-8b023308de16','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(241,'0439f43d-0ed1-4c0e-8789-8b023308de16','owner_user_name','tempest-ImagesTestJSON-134159412-project-member','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(242,'0439f43d-0ed1-4c0e-8789-8b023308de16','owner_project_name','tempest-ImagesTestJSON-134159412','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(243,'0439f43d-0ed1-4c0e-8789-8b023308de16','boot_roles','reader,member','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(244,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_machine_type','q35','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(245,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_cdrom_bus','sata','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(246,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_disk_bus','virtio','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(247,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_input_bus','usb','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(248,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_pointer_model','usbtablet','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(249,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_video_model','virtio','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(250,'0439f43d-0ed1-4c0e-8789-8b023308de16','hw_vif_model','virtio','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(251,'0439f43d-0ed1-4c0e-8789-8b023308de16','instance_uuid','47e12df1-0113-4c0a-9272-6078816e5844','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(252,'0439f43d-0ed1-4c0e-8789-8b023308de16','user_id','bdd7994b0ebb4035a373b6560aa7dbcf','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(253,'0439f43d-0ed1-4c0e-8789-8b023308de16','image_type','snapshot','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1),(254,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_rng_model','virtio','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(255,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(256,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','owner_user_name','tempest-DeleteServersTestJSON-1764569218-project-member','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(257,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','owner_project_name','tempest-DeleteServersTestJSON-1764569218','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(258,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','boot_roles','member,reader','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(259,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_machine_type','q35','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(260,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_cdrom_bus','sata','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(261,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_disk_bus','virtio','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(262,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_input_bus','usb','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(263,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_pointer_model','usbtablet','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(264,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_video_model','virtio','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(265,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','hw_vif_model','virtio','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(266,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','instance_uuid','8be3ed9f-1d51-4e7b-b352-45a261ab48ea','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(267,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','user_id','d966fefcb38a45219b9cc637c46a3d62','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(268,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','image_type','snapshot','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(269,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','owner_id','c6d2f50c0db54315bfa96a24511dda90','2025-12-06 07:23:14','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(270,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','image_state','available','2025-12-06 07:23:14','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(271,'ce6c8150-0026-4838-b3e9-1b872e9a3cee','image_location','snapshot','2025-12-06 07:23:14','2025-12-06 07:23:25','2025-12-06 07:23:25',1),(272,'24540ea9-2655-4ff6-a852-08458e75db90','hw_rng_model','virtio','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(273,'24540ea9-2655-4ff6-a852-08458e75db90','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(274,'24540ea9-2655-4ff6-a852-08458e75db90','owner_user_name','tempest-ServerActionsTestOtherB-874907570-project-member','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(275,'24540ea9-2655-4ff6-a852-08458e75db90','owner_project_name','tempest-ServerActionsTestOtherB-874907570','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(276,'24540ea9-2655-4ff6-a852-08458e75db90','boot_roles','reader,member','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(277,'24540ea9-2655-4ff6-a852-08458e75db90','hw_machine_type','q35','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(278,'24540ea9-2655-4ff6-a852-08458e75db90','hw_cdrom_bus','sata','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(279,'24540ea9-2655-4ff6-a852-08458e75db90','hw_disk_bus','virtio','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(280,'24540ea9-2655-4ff6-a852-08458e75db90','hw_input_bus','usb','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(281,'24540ea9-2655-4ff6-a852-08458e75db90','hw_pointer_model','usbtablet','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(282,'24540ea9-2655-4ff6-a852-08458e75db90','hw_video_model','virtio','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(283,'24540ea9-2655-4ff6-a852-08458e75db90','hw_vif_model','virtio','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(284,'24540ea9-2655-4ff6-a852-08458e75db90','instance_uuid','a01650e7-2f06-400b-82aa-0ad2c8b84e6c','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(285,'24540ea9-2655-4ff6-a852-08458e75db90','user_id','a70f6c3c5e2c402bb6fa0e0507e9b6dc','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(286,'24540ea9-2655-4ff6-a852-08458e75db90','image_type','backup','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(287,'24540ea9-2655-4ff6-a852-08458e75db90','backup_type','daily','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(288,'24540ea9-2655-4ff6-a852-08458e75db90','owner_id','b10aa03d68eb4d4799d53538521cc364','2025-12-06 07:33:40','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(289,'24540ea9-2655-4ff6-a852-08458e75db90','image_state','available','2025-12-06 07:33:40','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(290,'24540ea9-2655-4ff6-a852-08458e75db90','image_location','snapshot','2025-12-06 07:33:40','2025-12-06 07:34:26','2025-12-06 07:34:26',1),(291,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_rng_model','virtio','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(292,'deed3bf2-6426-476b-8bb8-98ac272255a2','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(293,'deed3bf2-6426-476b-8bb8-98ac272255a2','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-344238221-project-member','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(294,'deed3bf2-6426-476b-8bb8-98ac272255a2','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-344238221','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(295,'deed3bf2-6426-476b-8bb8-98ac272255a2','boot_roles','member,reader','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(296,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_machine_type','q35','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(297,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_cdrom_bus','sata','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(298,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_disk_bus','virtio','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(299,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_input_bus','usb','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(300,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_pointer_model','usbtablet','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(301,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_video_model','virtio','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(302,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_vif_model','virtio','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(303,'deed3bf2-6426-476b-8bb8-98ac272255a2','instance_uuid','70928eda-043f-429b-aa4e-af1f3189a7c1','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(304,'deed3bf2-6426-476b-8bb8-98ac272255a2','user_id','2aa5b15c15f84a8cb24776d5c781eb09','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(305,'deed3bf2-6426-476b-8bb8-98ac272255a2','image_type','snapshot','2025-12-06 07:33:43','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(306,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_rng_model','virtio','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(307,'c4654208-04b4-4132-87e5-c9f3bf472e83','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(308,'c4654208-04b4-4132-87e5-c9f3bf472e83','owner_user_name','tempest-ServerActionsTestOtherB-874907570-project-member','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(309,'c4654208-04b4-4132-87e5-c9f3bf472e83','owner_project_name','tempest-ServerActionsTestOtherB-874907570','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(310,'c4654208-04b4-4132-87e5-c9f3bf472e83','boot_roles','reader,member','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(311,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_machine_type','q35','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(312,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_cdrom_bus','sata','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(313,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_disk_bus','virtio','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(314,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_input_bus','usb','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(315,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_pointer_model','usbtablet','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(316,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_video_model','virtio','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(317,'c4654208-04b4-4132-87e5-c9f3bf472e83','hw_vif_model','virtio','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(318,'c4654208-04b4-4132-87e5-c9f3bf472e83','instance_uuid','a01650e7-2f06-400b-82aa-0ad2c8b84e6c','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(319,'c4654208-04b4-4132-87e5-c9f3bf472e83','user_id','a70f6c3c5e2c402bb6fa0e0507e9b6dc','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(320,'c4654208-04b4-4132-87e5-c9f3bf472e83','image_type','backup','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(321,'c4654208-04b4-4132-87e5-c9f3bf472e83','backup_type','daily','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(322,'deed3bf2-6426-476b-8bb8-98ac272255a2','image_state','available','2025-12-06 07:33:54','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(323,'deed3bf2-6426-476b-8bb8-98ac272255a2','owner_id','17cdfa63c4424ec7a0eb4bb3d7372c14','2025-12-06 07:33:54','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(324,'deed3bf2-6426-476b-8bb8-98ac272255a2','image_location','snapshot','2025-12-06 07:33:54','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(325,'c4654208-04b4-4132-87e5-c9f3bf472e83','owner_id','b10aa03d68eb4d4799d53538521cc364','2025-12-06 07:34:05','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(326,'c4654208-04b4-4132-87e5-c9f3bf472e83','image_state','available','2025-12-06 07:34:05','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(327,'c4654208-04b4-4132-87e5-c9f3bf472e83','image_location','snapshot','2025-12-06 07:34:05','2025-12-06 07:34:52','2025-12-06 07:34:52',1),(328,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_rng_model','virtio','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(329,'a40e0372-ba8c-4000-a161-8b667b00eb86','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(330,'a40e0372-ba8c-4000-a161-8b667b00eb86','owner_user_name','tempest-ServerActionsTestOtherB-874907570-project-member','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(331,'a40e0372-ba8c-4000-a161-8b667b00eb86','owner_project_name','tempest-ServerActionsTestOtherB-874907570','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(332,'a40e0372-ba8c-4000-a161-8b667b00eb86','boot_roles','reader,member','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(333,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_machine_type','q35','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(334,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_cdrom_bus','sata','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(335,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_disk_bus','virtio','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(336,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_input_bus','usb','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(337,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_pointer_model','usbtablet','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(338,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_video_model','virtio','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(339,'a40e0372-ba8c-4000-a161-8b667b00eb86','hw_vif_model','virtio','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(340,'a40e0372-ba8c-4000-a161-8b667b00eb86','instance_uuid','a01650e7-2f06-400b-82aa-0ad2c8b84e6c','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(341,'a40e0372-ba8c-4000-a161-8b667b00eb86','user_id','a70f6c3c5e2c402bb6fa0e0507e9b6dc','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(342,'a40e0372-ba8c-4000-a161-8b667b00eb86','image_type','backup','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(343,'a40e0372-ba8c-4000-a161-8b667b00eb86','backup_type','daily','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(344,'a40e0372-ba8c-4000-a161-8b667b00eb86','owner_id','b10aa03d68eb4d4799d53538521cc364','2025-12-06 07:34:21','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(345,'a40e0372-ba8c-4000-a161-8b667b00eb86','image_state','available','2025-12-06 07:34:21','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(346,'a40e0372-ba8c-4000-a161-8b667b00eb86','image_location','snapshot','2025-12-06 07:34:21','2025-12-06 07:34:29','2025-12-06 07:34:29',1),(347,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_rescue_bus','virtio','2025-12-06 07:34:22','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(348,'deed3bf2-6426-476b-8bb8-98ac272255a2','hw_rescue_device','disk','2025-12-06 07:34:23','2025-12-06 07:39:52','2025-12-06 07:39:52',1),(349,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_rng_model','virtio','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(350,'441cc72d-7648-41a4-9dbf-54930196cf56','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(351,'441cc72d-7648-41a4-9dbf-54930196cf56','owner_user_name','tempest-ServerBootFromVolumeStableRescueTest-344238221-project-member','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(352,'441cc72d-7648-41a4-9dbf-54930196cf56','owner_project_name','tempest-ServerBootFromVolumeStableRescueTest-344238221','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(353,'441cc72d-7648-41a4-9dbf-54930196cf56','boot_roles','reader,member','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(354,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_machine_type','q35','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(355,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_cdrom_bus','sata','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(356,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_disk_bus','virtio','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(357,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_input_bus','usb','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(358,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_pointer_model','usbtablet','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(359,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_video_model','virtio','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(360,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_vif_model','virtio','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(361,'441cc72d-7648-41a4-9dbf-54930196cf56','instance_uuid','7bca344a-3af1-4217-b97d-3f288712b57d','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(362,'441cc72d-7648-41a4-9dbf-54930196cf56','user_id','2aa5b15c15f84a8cb24776d5c781eb09','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(363,'441cc72d-7648-41a4-9dbf-54930196cf56','image_type','snapshot','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(364,'441cc72d-7648-41a4-9dbf-54930196cf56','owner_id','17cdfa63c4424ec7a0eb4bb3d7372c14','2025-12-06 07:36:47','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(365,'441cc72d-7648-41a4-9dbf-54930196cf56','image_state','available','2025-12-06 07:36:47','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(366,'441cc72d-7648-41a4-9dbf-54930196cf56','image_location','snapshot','2025-12-06 07:36:47','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(367,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_rescue_bus','virtio','2025-12-06 07:37:35','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(368,'441cc72d-7648-41a4-9dbf-54930196cf56','hw_rescue_device','disk','2025-12-06 07:37:36','2025-12-06 07:39:39','2025-12-06 07:39:39',1),(369,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','signature_verified','False','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(370,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_rng_model','virtio','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(371,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','base_image_ref','','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(372,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','owner_user_name','tempest-AttachVolumeMultiAttachTest-690984293-project-member','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(373,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','owner_project_name','tempest-AttachVolumeMultiAttachTest-690984293','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(374,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','boot_roles','member,reader','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(375,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_machine_type','q35','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(376,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_cdrom_bus','sata','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(377,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_disk_bus','virtio','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(378,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_input_bus','usb','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(379,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_pointer_model','usbtablet','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(380,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_video_model','virtio','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(381,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','hw_vif_model','virtio','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(382,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','root_device_name','/dev/vda','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(383,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','block_device_mapping','[{\"image_id\": null, \"volume_size\": 1, \"destination_type\": \"volume\", \"tag\": null, \"encryption_format\": null, \"snapshot_id\": \"bbf2fddd-4329-419d-b38f-42646c0e4ed3\", \"disk_bus\": \"virtio\", \"encryption_secret_uuid\": null, \"volume_id\": null, \"encrypted\": null, \"source_type\": \"snapshot\", \"encryption_options\": null, \"device_type\": \"disk\", \"delete_on_termination\": false, \"guest_format\": null, \"no_device\": null, \"device_name\": \"/dev/vda\", \"volume_type\": null, \"boot_index\": 0}]','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(384,'60ee3e9a-fd92-41ea-ba58-4c45d1211b24','bdm_v2','True','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1),(385,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_rng_model','virtio','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(386,'f4dc7ee2-ba9d-4b34-978b-662676af5606','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(387,'f4dc7ee2-ba9d-4b34-978b-662676af5606','owner_user_name','tempest-ServersAaction247Test-447964022-project-member','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(388,'f4dc7ee2-ba9d-4b34-978b-662676af5606','owner_project_name','tempest-ServersAaction247Test-447964022','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(389,'f4dc7ee2-ba9d-4b34-978b-662676af5606','boot_roles','member,reader','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(390,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_machine_type','q35','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(391,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_cdrom_bus','sata','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(392,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_disk_bus','virtio','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(393,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_input_bus','usb','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(394,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_pointer_model','usbtablet','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(395,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_video_model','virtio','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(396,'f4dc7ee2-ba9d-4b34-978b-662676af5606','hw_vif_model','virtio','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(397,'f4dc7ee2-ba9d-4b34-978b-662676af5606','instance_uuid','78c21010-1e12-412a-8a98-2cb6e015f94a','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(398,'f4dc7ee2-ba9d-4b34-978b-662676af5606','user_id','2f3bfc62663b415caedcd269c56412be','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(399,'f4dc7ee2-ba9d-4b34-978b-662676af5606','image_type','backup','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(400,'f4dc7ee2-ba9d-4b34-978b-662676af5606','backup_type','daily','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1),(401,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_rng_model','virtio','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(402,'4df1dc2e-92f6-4200-8389-10650a86e843','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(403,'4df1dc2e-92f6-4200-8389-10650a86e843','owner_user_name','tempest-ServerActionsTestOtherB-874907570-project-member','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(404,'4df1dc2e-92f6-4200-8389-10650a86e843','owner_project_name','tempest-ServerActionsTestOtherB-874907570','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(405,'4df1dc2e-92f6-4200-8389-10650a86e843','boot_roles','member,reader','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(406,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_machine_type','q35','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(407,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_cdrom_bus','sata','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(408,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_disk_bus','virtio','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(409,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_input_bus','usb','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(410,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_pointer_model','usbtablet','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(411,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_video_model','virtio','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(412,'4df1dc2e-92f6-4200-8389-10650a86e843','hw_vif_model','virtio','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(413,'4df1dc2e-92f6-4200-8389-10650a86e843','instance_uuid','2d45e460-a94a-4fcb-881d-de59908d47b3','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(414,'4df1dc2e-92f6-4200-8389-10650a86e843','user_id','a70f6c3c5e2c402bb6fa0e0507e9b6dc','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(415,'4df1dc2e-92f6-4200-8389-10650a86e843','image_type','snapshot','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(416,'4df1dc2e-92f6-4200-8389-10650a86e843','owner_id','b10aa03d68eb4d4799d53538521cc364','2025-12-06 07:40:50','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(417,'4df1dc2e-92f6-4200-8389-10650a86e843','image_location','snapshot','2025-12-06 07:40:50','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(418,'4df1dc2e-92f6-4200-8389-10650a86e843','image_state','available','2025-12-06 07:40:50','2025-12-06 07:42:01','2025-12-06 07:42:01',1),(419,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_rng_model','virtio','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(420,'16647923-36b7-4c61-9de3-fb629f75ca61','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(421,'16647923-36b7-4c61-9de3-fb629f75ca61','owner_user_name','tempest-ServerActionsTestOtherB-874907570-project-member','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(422,'16647923-36b7-4c61-9de3-fb629f75ca61','owner_project_name','tempest-ServerActionsTestOtherB-874907570','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(423,'16647923-36b7-4c61-9de3-fb629f75ca61','boot_roles','member,reader','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(424,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_machine_type','q35','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(425,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_cdrom_bus','sata','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(426,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_disk_bus','virtio','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(427,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_input_bus','usb','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(428,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_pointer_model','usbtablet','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(429,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_video_model','virtio','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(430,'16647923-36b7-4c61-9de3-fb629f75ca61','hw_vif_model','virtio','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(431,'16647923-36b7-4c61-9de3-fb629f75ca61','instance_uuid','b85968f0-ebd7-48f6-a932-c4e8da09381e','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(432,'16647923-36b7-4c61-9de3-fb629f75ca61','user_id','a70f6c3c5e2c402bb6fa0e0507e9b6dc','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(433,'16647923-36b7-4c61-9de3-fb629f75ca61','image_type','snapshot','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(434,'16647923-36b7-4c61-9de3-fb629f75ca61','image_state','available','2025-12-06 07:41:19','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(435,'16647923-36b7-4c61-9de3-fb629f75ca61','owner_id','b10aa03d68eb4d4799d53538521cc364','2025-12-06 07:41:19','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(436,'16647923-36b7-4c61-9de3-fb629f75ca61','image_location','snapshot','2025-12-06 07:41:19','2025-12-06 07:41:48','2025-12-06 07:41:48',1),(437,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_rng_model','virtio','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(438,'de1696d2-fc5b-497d-a09d-4993ee316ff9','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(439,'de1696d2-fc5b-497d-a09d-4993ee316ff9','owner_user_name','tempest-ServerStableDeviceRescueTest-1830949011-project-member','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(440,'de1696d2-fc5b-497d-a09d-4993ee316ff9','owner_project_name','tempest-ServerStableDeviceRescueTest-1830949011','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(441,'de1696d2-fc5b-497d-a09d-4993ee316ff9','boot_roles','reader,member','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(442,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_machine_type','q35','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(443,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_cdrom_bus','sata','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(444,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_disk_bus','virtio','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(445,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_input_bus','usb','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(446,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_pointer_model','usbtablet','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(447,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_video_model','virtio','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(448,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_vif_model','virtio','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(449,'de1696d2-fc5b-497d-a09d-4993ee316ff9','instance_uuid','119a621b-6198-42db-9a89-d73da6c2a2da','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(450,'de1696d2-fc5b-497d-a09d-4993ee316ff9','user_id','e997a5eeee174b368a43ed8cb35fa1d0','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(451,'de1696d2-fc5b-497d-a09d-4993ee316ff9','image_type','snapshot','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(452,'de1696d2-fc5b-497d-a09d-4993ee316ff9','owner_id','f44ecb8bdc7e4692a299e29603301124','2025-12-06 07:43:31','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(453,'de1696d2-fc5b-497d-a09d-4993ee316ff9','image_state','available','2025-12-06 07:43:31','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(454,'de1696d2-fc5b-497d-a09d-4993ee316ff9','image_location','snapshot','2025-12-06 07:43:31','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(455,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_rescue_bus','scsi','2025-12-06 07:43:33','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(456,'de1696d2-fc5b-497d-a09d-4993ee316ff9','hw_rescue_device','disk','2025-12-06 07:43:33','2025-12-06 07:48:23','2025-12-06 07:48:23',1),(457,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_rng_model','virtio','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(458,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(459,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','owner_user_name','tempest-ServerStableDeviceRescueTest-1830949011-project-member','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(460,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','owner_project_name','tempest-ServerStableDeviceRescueTest-1830949011','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(461,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','boot_roles','member,reader','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(462,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_machine_type','q35','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(463,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_cdrom_bus','sata','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(464,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_disk_bus','virtio','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(465,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_input_bus','usb','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(466,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_pointer_model','usbtablet','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(467,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_video_model','virtio','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(468,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_vif_model','virtio','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(469,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','instance_uuid','53cabacd-b2a5-4ad1-a97a-0d0710d43bf9','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(470,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','user_id','e997a5eeee174b368a43ed8cb35fa1d0','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(471,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','image_type','snapshot','2025-12-06 07:44:08','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(472,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','image_state','available','2025-12-06 07:44:17','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(473,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','owner_id','f44ecb8bdc7e4692a299e29603301124','2025-12-06 07:44:17','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(474,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','image_location','snapshot','2025-12-06 07:44:17','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(475,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_rescue_bus','usb','2025-12-06 07:44:27','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(476,'9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','hw_rescue_device','disk','2025-12-06 07:44:27','2025-12-06 07:48:15','2025-12-06 07:48:15',1),(477,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_rng_model','virtio','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(478,'5b8b504a-6057-4871-810a-63dfe9ed4af8','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(479,'5b8b504a-6057-4871-810a-63dfe9ed4af8','owner_user_name','tempest-ServerStableDeviceRescueTest-1830949011-project-member','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(480,'5b8b504a-6057-4871-810a-63dfe9ed4af8','owner_project_name','tempest-ServerStableDeviceRescueTest-1830949011','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(481,'5b8b504a-6057-4871-810a-63dfe9ed4af8','boot_roles','reader,member','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(482,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_machine_type','q35','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(483,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_cdrom_bus','sata','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(484,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_disk_bus','virtio','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(485,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_input_bus','usb','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(486,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_pointer_model','usbtablet','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(487,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_video_model','virtio','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(488,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_vif_model','virtio','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(489,'5b8b504a-6057-4871-810a-63dfe9ed4af8','instance_uuid','53b4413c-a38e-4ad9-9f1b-43babd1fe2a5','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(490,'5b8b504a-6057-4871-810a-63dfe9ed4af8','user_id','e997a5eeee174b368a43ed8cb35fa1d0','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(491,'5b8b504a-6057-4871-810a-63dfe9ed4af8','image_type','snapshot','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(492,'5b8b504a-6057-4871-810a-63dfe9ed4af8','image_state','available','2025-12-06 07:45:27','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(493,'5b8b504a-6057-4871-810a-63dfe9ed4af8','owner_id','f44ecb8bdc7e4692a299e29603301124','2025-12-06 07:45:27','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(494,'5b8b504a-6057-4871-810a-63dfe9ed4af8','image_location','snapshot','2025-12-06 07:45:27','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(495,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_rescue_bus','virtio','2025-12-06 07:45:33','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(496,'5b8b504a-6057-4871-810a-63dfe9ed4af8','hw_rescue_device','disk','2025-12-06 07:45:33','2025-12-06 07:48:02','2025-12-06 07:48:02',1),(497,'1a501272-45c2-411f-9825-0c663b862e6b','hw_rng_model','virtio','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(498,'1a501272-45c2-411f-9825-0c663b862e6b','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(499,'1a501272-45c2-411f-9825-0c663b862e6b','owner_user_name','tempest-ServersNegativeTestJSON-776446295-project-member','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(500,'1a501272-45c2-411f-9825-0c663b862e6b','owner_project_name','tempest-ServersNegativeTestJSON-776446295','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(501,'1a501272-45c2-411f-9825-0c663b862e6b','boot_roles','member,reader','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(502,'1a501272-45c2-411f-9825-0c663b862e6b','hw_machine_type','q35','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(503,'1a501272-45c2-411f-9825-0c663b862e6b','hw_cdrom_bus','sata','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(504,'1a501272-45c2-411f-9825-0c663b862e6b','hw_disk_bus','virtio','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(505,'1a501272-45c2-411f-9825-0c663b862e6b','hw_input_bus','usb','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(506,'1a501272-45c2-411f-9825-0c663b862e6b','hw_pointer_model','usbtablet','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(507,'1a501272-45c2-411f-9825-0c663b862e6b','hw_video_model','virtio','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(508,'1a501272-45c2-411f-9825-0c663b862e6b','hw_vif_model','virtio','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(509,'1a501272-45c2-411f-9825-0c663b862e6b','instance_uuid','f67d89a8-836a-4f47-af8d-37cf99529275','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(510,'1a501272-45c2-411f-9825-0c663b862e6b','user_id','1035ecd55ed54b57aa35fe32fb915cc5','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(511,'1a501272-45c2-411f-9825-0c663b862e6b','image_type','snapshot','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(512,'1a501272-45c2-411f-9825-0c663b862e6b','owner_id','4ec9294f6d4b4f44a72414374d646a4a','2025-12-06 07:46:28','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(513,'1a501272-45c2-411f-9825-0c663b862e6b','image_location','snapshot','2025-12-06 07:46:28','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(514,'1a501272-45c2-411f-9825-0c663b862e6b','image_state','available','2025-12-06 07:46:28','2025-12-06 07:46:46','2025-12-06 07:46:46',1),(515,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_rng_model','virtio','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(516,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(517,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','owner_user_name','tempest-ServerStableDeviceRescueTest-1830949011-project-member','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(518,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','owner_project_name','tempest-ServerStableDeviceRescueTest-1830949011','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(519,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','boot_roles','member,reader','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(520,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_machine_type','q35','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(521,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_cdrom_bus','sata','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(522,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_disk_bus','virtio','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(523,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_input_bus','usb','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(524,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_pointer_model','usbtablet','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(525,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_video_model','virtio','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(526,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_vif_model','virtio','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(527,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','instance_uuid','2b4b3181-da12-4705-9215-7ee5b869102b','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(528,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','user_id','e997a5eeee174b368a43ed8cb35fa1d0','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(529,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','image_type','snapshot','2025-12-06 07:46:33','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(530,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','owner_id','f44ecb8bdc7e4692a299e29603301124','2025-12-06 07:46:38','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(531,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','image_location','snapshot','2025-12-06 07:46:38','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(532,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','image_state','available','2025-12-06 07:46:38','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(533,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_rescue_bus','virtio','2025-12-06 07:46:43','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(534,'4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','hw_rescue_device','disk','2025-12-06 07:46:43','2025-12-06 07:47:46','2025-12-06 07:47:46',1),(535,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_rng_model','virtio','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(536,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(537,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','owner_user_name','tempest-TestSnapshotPattern-563672408-project-member','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(538,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','owner_project_name','tempest-TestSnapshotPattern-563672408','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(539,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','boot_roles','reader,member','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(540,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_machine_type','q35','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(541,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_cdrom_bus','sata','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(542,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_disk_bus','virtio','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(543,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_input_bus','usb','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(544,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_pointer_model','usbtablet','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(545,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_video_model','virtio','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(546,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','hw_vif_model','virtio','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(547,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','instance_uuid','29195b63-c365-4ace-a4f5-9c2dba89c276','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(548,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','user_id','89d63d29c7534f70817e13d23cada716','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(549,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','image_type','snapshot','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(550,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','owner_id','f093eaeb91c042dd8c85f5cd256c4394','2025-12-06 07:47:11','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(551,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','image_state','available','2025-12-06 07:47:11','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(552,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','image_location','snapshot','2025-12-06 07:47:11','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(553,'85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','version','8.0','2025-12-06 07:47:13','2025-12-06 07:48:19','2025-12-06 07:48:19',1),(554,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_rng_model','virtio','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(555,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(556,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','owner_user_name','tempest-TestSnapshotPattern-563672408-project-member','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(557,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','owner_project_name','tempest-TestSnapshotPattern-563672408','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(558,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','boot_roles','member,reader','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(559,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_machine_type','q35','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(560,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_cdrom_bus','sata','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(561,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_disk_bus','virtio','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(562,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_input_bus','usb','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(563,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_pointer_model','usbtablet','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(564,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_video_model','virtio','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(565,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','hw_vif_model','virtio','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(566,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','instance_uuid','f09d4c2b-5734-457e-93cf-a2b4f61e3afd','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(567,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','user_id','89d63d29c7534f70817e13d23cada716','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(568,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','image_type','snapshot','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(569,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','owner_id','f093eaeb91c042dd8c85f5cd256c4394','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(570,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','image_state','available','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(571,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','image_location','snapshot','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(572,'5ed78aa8-6ca4-4423-a38b-01e37b179e36','version','8.0','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1),(573,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_rng_model','virtio','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(574,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(575,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','owner_user_name','tempest-AttachVolumeShelveTestJSON-1510980811-project-member','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(576,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','owner_project_name','tempest-AttachVolumeShelveTestJSON-1510980811','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(577,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','boot_roles','member,reader','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(578,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_machine_type','q35','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(579,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_cdrom_bus','sata','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(580,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_disk_bus','virtio','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(581,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_input_bus','usb','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(582,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_pointer_model','usbtablet','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(583,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_video_model','virtio','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(584,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','hw_vif_model','virtio','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(585,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','instance_uuid','0b9681c0-c0e7-4bd8-9040-865c1bff517b','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(586,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','user_id','90c9de6e67724c898a8e23b05fbf14da','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(587,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','image_type','snapshot','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(588,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_rng_model','virtio','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(589,'83fea89a-3a0d-4881-b429-13684080bb6c','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(590,'83fea89a-3a0d-4881-b429-13684080bb6c','owner_user_name','tempest-TestStampPattern-1318067975-project-member','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(591,'83fea89a-3a0d-4881-b429-13684080bb6c','owner_project_name','tempest-TestStampPattern-1318067975','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(592,'83fea89a-3a0d-4881-b429-13684080bb6c','boot_roles','reader,member','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(593,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_machine_type','q35','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(594,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_cdrom_bus','sata','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(595,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_disk_bus','virtio','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(596,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_input_bus','usb','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(597,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_pointer_model','usbtablet','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(598,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_video_model','virtio','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(599,'83fea89a-3a0d-4881-b429-13684080bb6c','hw_vif_model','virtio','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(600,'83fea89a-3a0d-4881-b429-13684080bb6c','instance_uuid','e7d5d854-2a1f-485b-931a-4ec90cf7ba04','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(601,'83fea89a-3a0d-4881-b429-13684080bb6c','user_id','4962bc7b172346e19d127b46ea2d7a11','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(602,'83fea89a-3a0d-4881-b429-13684080bb6c','image_type','snapshot','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(603,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','owner_id','cfa713d92cc94fa1b94404ed58b0563f','2025-12-06 07:51:34','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(604,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','image_location','snapshot','2025-12-06 07:51:34','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(605,'2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','image_state','available','2025-12-06 07:51:34','2025-12-06 07:51:57','2025-12-06 07:51:57',1),(606,'83fea89a-3a0d-4881-b429-13684080bb6c','owner_id','c4cf19b89a6d46bca307e65731a9dd21','2025-12-06 07:51:40','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(607,'83fea89a-3a0d-4881-b429-13684080bb6c','image_state','available','2025-12-06 07:51:40','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(608,'83fea89a-3a0d-4881-b429-13684080bb6c','image_location','snapshot','2025-12-06 07:51:40','2025-12-06 07:53:06','2025-12-06 07:53:06',1),(609,'f1264656-a902-4225-be11-839d8f664fd7','hw_rng_model','virtio','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(610,'f1264656-a902-4225-be11-839d8f664fd7','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(611,'f1264656-a902-4225-be11-839d8f664fd7','owner_user_name','tempest-AttachVolumeShelveTestJSON-1510980811-project-member','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(612,'f1264656-a902-4225-be11-839d8f664fd7','owner_project_name','tempest-AttachVolumeShelveTestJSON-1510980811','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(613,'f1264656-a902-4225-be11-839d8f664fd7','boot_roles','member,reader','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(614,'f1264656-a902-4225-be11-839d8f664fd7','hw_machine_type','q35','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(615,'f1264656-a902-4225-be11-839d8f664fd7','hw_cdrom_bus','sata','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(616,'f1264656-a902-4225-be11-839d8f664fd7','hw_disk_bus','virtio','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(617,'f1264656-a902-4225-be11-839d8f664fd7','hw_input_bus','usb','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(618,'f1264656-a902-4225-be11-839d8f664fd7','hw_pointer_model','usbtablet','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(619,'f1264656-a902-4225-be11-839d8f664fd7','hw_video_model','virtio','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(620,'f1264656-a902-4225-be11-839d8f664fd7','hw_vif_model','virtio','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(621,'f1264656-a902-4225-be11-839d8f664fd7','instance_uuid','91b85b86-0d07-4df4-80d5-48fa343c00b8','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(622,'f1264656-a902-4225-be11-839d8f664fd7','user_id','90c9de6e67724c898a8e23b05fbf14da','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(623,'f1264656-a902-4225-be11-839d8f664fd7','image_type','snapshot','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(624,'f1264656-a902-4225-be11-839d8f664fd7','image_state','available','2025-12-06 07:53:49','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(625,'f1264656-a902-4225-be11-839d8f664fd7','owner_id','cfa713d92cc94fa1b94404ed58b0563f','2025-12-06 07:53:49','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(626,'f1264656-a902-4225-be11-839d8f664fd7','image_location','snapshot','2025-12-06 07:53:49','2025-12-06 07:54:18','2025-12-06 07:54:18',1),(627,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_rng_model','virtio','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(628,'12e13902-aaee-45d7-b251-bc95170ae31e','base_image_ref','6efab05d-c7cf-4770-a5c3-c806a2739063','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(629,'12e13902-aaee-45d7-b251-bc95170ae31e','owner_user_name','tempest-TestShelveInstance-1863009913-project-member','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(630,'12e13902-aaee-45d7-b251-bc95170ae31e','owner_project_name','tempest-TestShelveInstance-1863009913','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(631,'12e13902-aaee-45d7-b251-bc95170ae31e','boot_roles','reader,member','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(632,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_machine_type','q35','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(633,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_cdrom_bus','sata','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(634,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_disk_bus','virtio','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(635,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_input_bus','usb','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(636,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_pointer_model','usbtablet','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(637,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_video_model','virtio','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(638,'12e13902-aaee-45d7-b251-bc95170ae31e','hw_vif_model','virtio','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(639,'12e13902-aaee-45d7-b251-bc95170ae31e','instance_uuid','9aa31d67-6e8e-4301-99db-832dd1fe00bc','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(640,'12e13902-aaee-45d7-b251-bc95170ae31e','user_id','98e657096e3f4b528cd461a3dd6a750e','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(641,'12e13902-aaee-45d7-b251-bc95170ae31e','image_type','snapshot','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(642,'12e13902-aaee-45d7-b251-bc95170ae31e','owner_id','c3c0564f8e9f4af9ae5b597a275c989f','2025-12-06 07:57:39','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(643,'12e13902-aaee-45d7-b251-bc95170ae31e','image_location','snapshot','2025-12-06 07:57:39','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(644,'12e13902-aaee-45d7-b251-bc95170ae31e','image_state','available','2025-12-06 07:57:39','2025-12-06 07:58:15','2025-12-06 07:58:15',1),(645,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','signature_verified','False','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(646,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_rng_model','virtio','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(647,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','base_image_ref','','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(648,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','owner_user_name','tempest-TestVolumeBootPattern-97496240-project-member','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(649,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','owner_project_name','tempest-TestVolumeBootPattern-97496240','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(650,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','boot_roles','reader,member','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(651,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_machine_type','q35','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(652,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_cdrom_bus','sata','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(653,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_disk_bus','virtio','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(654,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_input_bus','usb','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(655,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_pointer_model','usbtablet','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(656,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_video_model','virtio','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(657,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','hw_vif_model','virtio','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(658,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','root_device_name','/dev/vda','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(659,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','block_device_mapping','[{\"image_id\": null, \"volume_size\": 1, \"destination_type\": \"volume\", \"tag\": null, \"encryption_format\": null, \"snapshot_id\": \"8c532b5e-c264-4201-a213-9aa271d92ee9\", \"disk_bus\": \"virtio\", \"encryption_secret_uuid\": null, \"volume_id\": null, \"encrypted\": null, \"source_type\": \"snapshot\", \"encryption_options\": null, \"device_type\": \"disk\", \"delete_on_termination\": true, \"guest_format\": null, \"no_device\": null, \"device_name\": \"/dev/vda\", \"volume_type\": null, \"boot_index\": 0}]','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1),(660,'c5cbac11-d6e7-4196-b42c-615f51a1fae2','bdm_v2','True','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('0439f43d-0ed1-4c0e-8789-8b023308de16','tempest-test-snap-991225194',NULL,'deleted','2025-12-06 07:14:30','2025-12-06 07:14:32','2025-12-06 07:14:32',1,NULL,NULL,NULL,'af7365adc05f4624a08a71cd5a77ada6',1,0,0,NULL,'private',0,NULL,NULL),('0a1ac31b-510b-45cf-af8d-b5ab53f7ddcc','tempest-ListImageFiltersTestJSON-image-1418904940',1073741824,'deleted','2025-12-06 07:09:19','2025-12-06 07:09:51','2025-12-06 07:09:51',1,'raw','bare',NULL,'6f86ab5a5bf14cb6b789f065cc8ca04a',1,0,0,NULL,'private',0,NULL,NULL),('11dbd9ca-4725-400f-ade9-f5493c82f6e2','tempest-UnshelveToHostMultiNodesTest-server-316061423-shelved',1073741824,'deleted','2025-12-06 07:05:42','2025-12-06 07:06:16','2025-12-06 07:06:16',1,'raw','bare',NULL,'e2384cf38a13417c9220db3aafff6b24',1,0,0,NULL,'private',0,NULL,NULL),('12e13902-aaee-45d7-b251-bc95170ae31e','tempest-TestShelveInstance-server-760058587-shelved',1073741824,'deleted','2025-12-06 07:57:25','2025-12-06 07:58:15','2025-12-06 07:58:15',1,'raw','bare',NULL,'c3c0564f8e9f4af9ae5b597a275c989f',1,0,0,NULL,'private',0,NULL,NULL),('1353436e-de17-4a6b-a172-0c01d62ca482','tempest-ImagesOneServerNegativeTestJSON-image-1827044591',NULL,'deleted','2025-12-06 07:12:08','2025-12-06 07:12:09','2025-12-06 07:12:09',1,NULL,NULL,NULL,'c297e84c3a9f48a9a82aebc9e5ade875',1,0,0,NULL,'private',0,NULL,NULL),('14f124b6-e911-4720-a685-affb8dbe0f13','tempest-ListImageFiltersTestJSON-image-336093857',1024,'deleted','2025-12-06 07:08:45','2025-12-06 07:10:25','2025-12-06 07:10:25',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6f86ab5a5bf14cb6b789f065cc8ca04a',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('16647923-36b7-4c61-9de3-fb629f75ca61','tempest-ServerActionsTestOtherB-server-1033932756-shelved',1073741824,'deleted','2025-12-06 07:41:06','2025-12-06 07:41:48','2025-12-06 07:41:48',1,'raw','bare',NULL,'b10aa03d68eb4d4799d53538521cc364',1,0,0,NULL,'private',0,NULL,NULL),('1a501272-45c2-411f-9825-0c663b862e6b','tempest-ServersNegativeTestJSON-server-2113241509-shelved',1073741824,'deleted','2025-12-06 07:46:19','2025-12-06 07:46:46','2025-12-06 07:46:46',1,'raw','bare',NULL,'4ec9294f6d4b4f44a72414374d646a4a',1,0,0,NULL,'private',0,NULL,NULL),('1af12b1c-b711-4118-bb67-f97cd1b83061','tempest-scenario-img--39023373',21430272,'deleted','2025-12-06 07:52:27','2025-12-06 07:54:21','2025-12-06 07:54:21',1,'qcow2','bare','c8fc807773e5354afe61636071771906','0c8fc5bc237e42bfad505a0bca6681eb',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('24540ea9-2655-4ff6-a852-08458e75db90','tempest-backup-1-1069380800',1073741824,'deleted','2025-12-06 07:33:25','2025-12-06 07:34:26','2025-12-06 07:34:26',1,'raw','bare',NULL,'b10aa03d68eb4d4799d53538521cc364',1,0,0,NULL,'private',0,NULL,NULL),('29145f63-7097-42b2-b998-dd2d2a5d0fda','tempest-test-snap-1944923105',1073741824,'deleted','2025-12-06 07:11:28','2025-12-06 07:11:38','2025-12-06 07:11:38',1,'raw','bare',NULL,'af7365adc05f4624a08a71cd5a77ada6',1,0,0,NULL,'private',0,NULL,NULL),('2bf7c3bd-26e5-44a8-90a5-c1b8c9d58e1e','tempest-AttachVolumeShelveTestJSON-server-676074581-shelved',1073741824,'deleted','2025-12-06 07:51:25','2025-12-06 07:51:57','2025-12-06 07:51:57',1,'raw','bare',NULL,'cfa713d92cc94fa1b94404ed58b0563f',1,0,0,NULL,'private',0,NULL,NULL),('4038f20e-02ea-4a6a-aa3a-eaf0b9450896','tempest-₡-1757351906',1073741824,'deleted','2025-12-06 07:08:55','2025-12-06 07:09:08','2025-12-06 07:09:08',1,'raw','bare',NULL,'87ee3f11e794407692b09a4b77c91610',1,0,0,NULL,'private',0,NULL,NULL),('412dd61d-1b1e-439f-b7f9-7e7c4e42924c','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-06 06:56:38','2025-12-06 06:56:41',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','5ed95c9b17ee4dcb83395850789304e6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('441cc72d-7648-41a4-9dbf-54930196cf56','tempest-ServerBootFromVolumeStableRescueTest-image-1092707697',1073741824,'deleted','2025-12-06 07:36:22','2025-12-06 07:39:39','2025-12-06 07:39:39',1,'raw','bare',NULL,'17cdfa63c4424ec7a0eb4bb3d7372c14',1,0,0,NULL,'private',0,NULL,NULL),('4a5b4c30-2416-4ed2-b947-8bb73ef88bd7','tempest-ServerStableDeviceRescueTest-image-1352191077',1073741824,'deleted','2025-12-06 07:46:33','2025-12-06 07:47:47','2025-12-06 07:47:47',1,'raw','bare',NULL,'f44ecb8bdc7e4692a299e29603301124',1,0,0,NULL,'private',0,NULL,NULL),('4df1dc2e-92f6-4200-8389-10650a86e843','tempest-ServerActionsTestOtherB-server-1918499189-shelved',1073741824,'deleted','2025-12-06 07:40:43','2025-12-06 07:42:01','2025-12-06 07:42:01',1,'raw','bare',NULL,'b10aa03d68eb4d4799d53538521cc364',1,0,0,NULL,'private',0,NULL,NULL),('544e5cd1-78c2-46b6-bec1-176dc9a97c75',NULL,21430272,'deleted','2025-12-06 07:04:49','2025-12-06 07:05:39','2025-12-06 07:05:39',1,'qcow2','bare','c8fc807773e5354afe61636071771906','9175aeced50c47b9b3aba5550ef48619',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('5b8b504a-6057-4871-810a-63dfe9ed4af8','tempest-ServerStableDeviceRescueTest-image-578549706',1073741824,'deleted','2025-12-06 07:45:22','2025-12-06 07:48:02','2025-12-06 07:48:02',1,'raw','bare',NULL,'f44ecb8bdc7e4692a299e29603301124',1,0,0,NULL,'private',0,NULL,NULL),('5ed78aa8-6ca4-4423-a38b-01e37b179e36','tempest-TestSnapshotPatternsnapshot-2118878485',1073741824,'deleted','2025-12-06 07:47:51','2025-12-06 07:48:04','2025-12-06 07:48:04',1,'raw','bare',NULL,'f093eaeb91c042dd8c85f5cd256c4394',1,0,0,NULL,'private',0,NULL,NULL),('60ee3e9a-fd92-41ea-ba58-4c45d1211b24','multiattach-snapshot',0,'deleted','2025-12-06 07:39:37','2025-12-06 07:39:54','2025-12-06 07:39:54',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','833f4cf9f5a64b2ab94c3bf330353a31',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('66510630-de0f-49cc-be1c-e43008b502ef','tempest-image-978167722',1024,'deleted','2025-12-06 07:08:15','2025-12-06 07:08:36','2025-12-06 07:08:36',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','e795388aa12c4c8db6a45f21af53750e',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('6916f635-11b7-4158-ab13-60ff56406973','tempest-scenario-img--953834163',21430272,'deleted','2025-12-06 07:50:02','2025-12-06 07:52:27','2025-12-06 07:52:27',1,'qcow2','bare','c8fc807773e5354afe61636071771906','0c8fc5bc237e42bfad505a0bca6681eb',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('6b59300d-e8aa-4c06-be5d-280ba7e39063','tempest-test-snap-1571596018',1073741824,'deleted','2025-12-06 07:13:22','2025-12-06 07:14:01','2025-12-06 07:14:01',1,'raw','bare',NULL,'af7365adc05f4624a08a71cd5a77ada6',1,0,0,NULL,'private',0,NULL,NULL),('6e62d22c-45f1-4591-b9e8-303a0bc90e48','tempest-UnshelveToHostMultiNodesTest-server-316061423-shelved',1073741824,'deleted','2025-12-06 07:04:49','2025-12-06 07:05:40','2025-12-06 07:05:40',1,'raw','bare',NULL,'e2384cf38a13417c9220db3aafff6b24',1,0,0,NULL,'private',0,NULL,NULL),('6efab05d-c7cf-4770-a5c3-c806a2739063','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-06 06:56:26','2025-12-06 06:56:38',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','5ed95c9b17ee4dcb83395850789304e6',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('7214bfa6-0002-48d4-93d1-72a077cc984f','tempest-ListImageFiltersTestJSON-image-210526244',1024,'deleted','2025-12-06 07:08:40','2025-12-06 07:10:27','2025-12-06 07:10:27',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6f86ab5a5bf14cb6b789f065cc8ca04a',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('78b95c69-8ea4-40d9-832c-1e5db1eba4f8','tempest-ImagesOneServerNegativeTestJSON-image-870549008',NULL,'deleted','2025-12-06 07:12:57','2025-12-06 07:12:57','2025-12-06 07:12:57',1,NULL,NULL,NULL,'c297e84c3a9f48a9a82aebc9e5ade875',1,0,0,NULL,'private',0,NULL,NULL),('83fea89a-3a0d-4881-b429-13684080bb6c','tempest-TestStampPatternsnapshot-646723643',1073741824,'deleted','2025-12-06 07:51:32','2025-12-06 07:53:06','2025-12-06 07:53:06',1,'raw','bare',NULL,'c4cf19b89a6d46bca307e65731a9dd21',1,0,0,NULL,'private',0,NULL,NULL),('84696b79-26a5-4d20-90c5-9f50a860fde7','tempest-ListImageFiltersTestJSON-image-2036122265',1073741824,'deleted','2025-12-06 07:09:04','2025-12-06 07:10:00','2025-12-06 07:10:00',1,'raw','bare',NULL,'6f86ab5a5bf14cb6b789f065cc8ca04a',1,0,0,NULL,'private',0,NULL,NULL),('85f1f69b-a9ee-46e0-a30b-ae7faf09ffef','tempest-TestSnapshotPatternsnapshot-1473063084',1073741824,'deleted','2025-12-06 07:47:04','2025-12-06 07:48:19','2025-12-06 07:48:19',1,'raw','bare',NULL,'f093eaeb91c042dd8c85f5cd256c4394',1,0,0,NULL,'private',0,NULL,NULL),('9b2bfd1e-afa4-4eb9-a3eb-6b2d196bc5e9','tempest-ServerStableDeviceRescueTest-image-732852412',1073741824,'deleted','2025-12-06 07:44:08','2025-12-06 07:48:16','2025-12-06 07:48:16',1,'raw','bare',NULL,'f44ecb8bdc7e4692a299e29603301124',1,0,0,NULL,'private',0,NULL,NULL),('9b6e4b95-ff8f-4732-b604-e00530db621e','tempest-test-snap-448075251',1073741824,'deleted','2025-12-06 07:12:52','2025-12-06 07:13:04','2025-12-06 07:13:04',1,'raw','bare',NULL,'af7365adc05f4624a08a71cd5a77ada6',1,0,0,NULL,'private',0,NULL,NULL),('a2519fc1-5a48-4adb-858b-30c6d08d1a53','tempest-image-127238551',1073741824,'deleted','2025-12-06 07:08:40','2025-12-06 07:08:54','2025-12-06 07:08:54',1,'raw','bare',NULL,'87ee3f11e794407692b09a4b77c91610',1,0,0,NULL,'private',0,NULL,NULL),('a40e0372-ba8c-4000-a161-8b667b00eb86','tempest-backup-3-1776156931',1073741824,'deleted','2025-12-06 07:34:10','2025-12-06 07:34:29','2025-12-06 07:34:29',1,'raw','bare',NULL,'b10aa03d68eb4d4799d53538521cc364',1,0,0,NULL,'private',0,NULL,NULL),('b4deb7ef-9e65-4ebe-874a-920264d09c32','tempest-image-7189070',3476,'deleted','2025-12-06 07:09:24','2025-12-06 07:09:29','2025-12-06 07:09:29',1,'qcow2','bare','92cae9816b9a6f67ad76524b64d007d4','c3c141a8c05349c291457adf658cdefa',0,129,0,NULL,'private',0,'sha512','9bbafbf667199989b72ce347c51531fb67932d701ead61c9777932c0238472415333e742f4fa3b15b6c11343f34959f7b1d9c939c6cb6f9355dc9713c312c23c'),('c4654208-04b4-4132-87e5-c9f3bf472e83','tempest-backup-2-550976278',1073741824,'deleted','2025-12-06 07:33:53','2025-12-06 07:34:52','2025-12-06 07:34:52',1,'raw','bare',NULL,'b10aa03d68eb4d4799d53538521cc364',1,0,0,NULL,'private',0,NULL,NULL),('c5cbac11-d6e7-4196-b42c-615f51a1fae2','tempest-TestVolumeBootPatternsnapshot-107678206',0,'deleted','2025-12-06 08:17:46','2025-12-06 08:19:00','2025-12-06 08:19:00',1,'qcow2','bare','d41d8cd98f00b204e9800998ecf8427e','4b2dc4b8729f446a9c7ac69ca446f71d',1,0,0,NULL,'private',0,'sha512','cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e'),('c74443ce-ba5e-43f8-9494-f21e8c68a03c','tempest-ListImageFiltersTestJSON-image-949678031',1024,'deleted','2025-12-06 07:08:48','2025-12-06 07:10:23','2025-12-06 07:10:23',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','6f86ab5a5bf14cb6b789f065cc8ca04a',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('ce6c8150-0026-4838-b3e9-1b872e9a3cee','tempest-DeleteServersTestJSON-server-895305952-shelved',1073741824,'deleted','2025-12-06 07:22:33','2025-12-06 07:23:25','2025-12-06 07:23:25',1,'raw','bare',NULL,'c6d2f50c0db54315bfa96a24511dda90',1,0,0,NULL,'private',0,NULL,NULL),('d2f3b5e0-e512-4475-bd2e-0cf53dc74129','tempest-scenario-img--392476316',21430272,'deleted','2025-12-06 07:55:23','2025-12-06 07:58:20','2025-12-06 07:58:20',1,'qcow2','bare','c8fc807773e5354afe61636071771906','6164fee998c94b71a37886fe42b4c56c',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('de1696d2-fc5b-497d-a09d-4993ee316ff9','tempest-ServerStableDeviceRescueTest-image-635247196',1073741824,'deleted','2025-12-06 07:43:23','2025-12-06 07:48:23','2025-12-06 07:48:23',1,'raw','bare',NULL,'f44ecb8bdc7e4692a299e29603301124',1,0,0,NULL,'private',0,NULL,NULL),('deed3bf2-6426-476b-8bb8-98ac272255a2','tempest-ServerBootFromVolumeStableRescueTest-image-2117457201',1073741824,'deleted','2025-12-06 07:33:43','2025-12-06 07:39:53','2025-12-06 07:39:52',1,'raw','bare',NULL,'17cdfa63c4424ec7a0eb4bb3d7372c14',1,0,0,NULL,'private',0,NULL,NULL),('eba516b2-6064-409c-87d5-453285b93544','tempest-test-snap-1009878067',1073741824,'deleted','2025-12-06 07:12:24','2025-12-06 07:12:34','2025-12-06 07:12:34',1,'raw','bare',NULL,'af7365adc05f4624a08a71cd5a77ada6',1,0,0,NULL,'private',0,NULL,NULL),('f0e8ecfe-6e18-4449-a7f5-bd1505cb90f6','tempest-ListImageFiltersTestJSON-image-303069161',1073741824,'deleted','2025-12-06 07:09:12','2025-12-06 07:09:55','2025-12-06 07:09:55',1,'raw','bare',NULL,'6f86ab5a5bf14cb6b789f065cc8ca04a',1,0,0,NULL,'private',0,NULL,NULL),('f1264656-a902-4225-be11-839d8f664fd7','tempest-AttachVolumeShelveTestJSON-server-1180268370-shelved',1073741824,'deleted','2025-12-06 07:53:42','2025-12-06 07:54:18','2025-12-06 07:54:18',1,'raw','bare',NULL,'cfa713d92cc94fa1b94404ed58b0563f',1,0,0,NULL,'private',0,NULL,NULL),('f4dc7ee2-ba9d-4b34-978b-662676af5606','tempest-backup-1-503154771',NULL,'deleted','2025-12-06 07:40:01','2025-12-06 07:40:04','2025-12-06 07:40:04',1,'qcow2','bare',NULL,'17906cc84c6c4f43b1a09758e5552c63',1,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (1,1,'image','CIM_PASD_','2025-12-06 06:09:03',NULL),(1,2,'image','CIM_RASD_','2025-12-06 06:09:05',NULL),(1,3,NULL,'CIM_SASD_','2025-12-06 06:09:06',NULL),(1,9,'image','hw_','2025-12-06 06:09:06',NULL),(1,10,'image','hw_','2025-12-06 06:09:06',NULL),(1,14,'image',NULL,'2025-12-06 06:09:06',NULL),(1,19,'image','hw_','2025-12-06 06:09:06',NULL),(1,25,'image','hw_','2025-12-06 06:09:07',NULL),(1,29,'image',NULL,'2025-12-06 06:09:07',NULL),(1,30,'image',NULL,'2025-12-06 06:09:07',NULL),(1,31,'image',NULL,'2025-12-06 06:09:08',NULL),(1,32,'image',NULL,'2025-12-06 06:09:08',NULL),(2,1,NULL,'CIM_PASD_','2025-12-06 06:09:03',NULL),(2,8,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,9,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,10,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,11,NULL,NULL,'2025-12-06 06:09:06',NULL),(2,13,NULL,NULL,'2025-12-06 06:09:06',NULL),(2,14,NULL,NULL,'2025-12-06 06:09:06',NULL),(2,15,NULL,NULL,'2025-12-06 06:09:06',NULL),(2,16,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,19,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,22,NULL,NULL,'2025-12-06 06:09:06',NULL),(2,23,NULL,'hw_','2025-12-06 06:09:06',NULL),(2,24,NULL,'traits:','2025-12-06 06:09:06',NULL),(2,25,NULL,'hw_','2025-12-06 06:09:07',NULL),(2,26,NULL,NULL,'2025-12-06 06:09:07',NULL),(2,28,NULL,NULL,'2025-12-06 06:09:07',NULL),(2,29,NULL,NULL,'2025-12-06 06:09:07',NULL),(2,30,NULL,NULL,'2025-12-06 06:09:07',NULL),(2,31,NULL,NULL,'2025-12-06 06:09:08',NULL),(2,32,NULL,NULL,'2025-12-06 06:09:08',NULL),(2,33,NULL,'cinder_','2025-12-06 06:09:08',NULL),(3,1,NULL,'CIM_PASD_','2025-12-06 06:09:05',NULL),(3,2,NULL,'CIM_RASD_','2025-12-06 06:09:05',NULL),(3,3,NULL,'CIM_SASD_','2025-12-06 06:09:06',NULL),(3,4,NULL,'CIM_VSSD_','2025-12-06 06:09:06',NULL),(3,5,NULL,NULL,'2025-12-06 06:09:06',NULL),(3,6,NULL,NULL,'2025-12-06 06:09:06',NULL),(3,7,NULL,NULL,'2025-12-06 06:09:06',NULL),(3,12,NULL,'aggregate_instance_extra_specs:','2025-12-06 06:09:06',NULL),(4,1,NULL,'CIM_PASD_','2025-12-06 06:09:05',NULL),(4,2,NULL,'CIM_RASD_','2025-12-06 06:09:05',NULL),(4,3,NULL,'CIM_SASD_','2025-12-06 06:09:06',NULL),(4,4,NULL,'CIM_VSSD_','2025-12-06 06:09:06',NULL),(4,8,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,9,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,10,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,12,NULL,'capabilities:','2025-12-06 06:09:06',NULL),(4,16,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,17,NULL,NULL,'2025-12-06 06:09:06',NULL),(4,18,NULL,NULL,'2025-12-06 06:09:06',NULL),(4,19,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,20,NULL,NULL,'2025-12-06 06:09:06',NULL),(4,21,NULL,NULL,'2025-12-06 06:09:06',NULL),(4,23,NULL,'hw:','2025-12-06 06:09:06',NULL),(4,24,NULL,'traits:','2025-12-06 06:09:06',NULL),(4,25,NULL,'hw:','2025-12-06 06:09:07',NULL),(5,1,'scheduler_hints',NULL,'2025-12-06 06:09:05',NULL),(5,30,'metadata',NULL,'2025-12-06 06:09:07',NULL),(5,31,'metadata',NULL,'2025-12-06 06:09:08',NULL),(5,32,'metadata',NULL,'2025-12-06 06:09:08',NULL),(6,30,NULL,NULL,'2025-12-06 06:09:07',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (1,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-06 06:09:03',NULL),(2,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-06 06:09:05',NULL),(3,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-06 06:09:06',NULL),(4,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-06 06:09:06',NULL),(5,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 06:09:06',NULL),(6,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 06:09:06',NULL),(7,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-06 06:09:06',NULL),(8,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-06 06:09:06',NULL),(9,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-06 06:09:06',NULL),(10,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-06 06:09:06',NULL),(11,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-06 06:09:06',NULL),(12,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-06 06:09:06',NULL),(13,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-06 06:09:06',NULL),(14,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-06 06:09:06',NULL),(15,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 06:09:06',NULL),(16,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 06:09:06',NULL),(17,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 06:09:06',NULL),(18,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-06 06:09:06',NULL),(19,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-06 06:09:06',NULL),(20,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 06:09:06',NULL),(21,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 06:09:06',NULL),(22,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 06:09:06',NULL),(23,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-06 06:09:06',NULL),(24,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-06 06:09:06',NULL),(25,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 06:09:07',NULL),(26,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 06:09:07',NULL),(27,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-06 06:09:07',NULL),(28,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-06 06:09:07',NULL),(29,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-06 06:09:07',NULL),(30,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-06 06:09:07',NULL),(31,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-06 06:09:08',NULL),(32,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-06 06:09:08',NULL),(33,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-06 06:09:08',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (1,17,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-06 06:09:06',NULL),(2,17,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-06 06:09:06',NULL),(3,17,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-06 06:09:06',NULL),(4,30,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-06 06:09:07',NULL),(5,30,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-06 06:09:07',NULL),(6,30,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-06 06:09:07',NULL),(7,30,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-06 06:09:07',NULL),(8,30,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 06:09:07',NULL),(9,30,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(10,30,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 06:09:08',NULL),(11,30,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 06:09:08',NULL),(12,30,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(13,30,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-06 06:09:08',NULL),(14,30,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(15,30,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-06 06:09:08',NULL),(16,31,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(17,31,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(18,31,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(19,31,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(20,31,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-06 06:09:08',NULL),(21,32,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 06:09:08',NULL),(22,32,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 06:09:08',NULL),(23,32,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 06:09:08',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (1,1,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-06 06:09:05',NULL),(2,1,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-06 06:09:05',NULL),(3,1,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-06 06:09:05',NULL),(4,2,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(5,2,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(6,2,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(7,2,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-06 06:09:05',NULL),(8,2,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-06 06:09:05',NULL),(9,2,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 06:09:05',NULL),(10,2,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(11,2,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-06 06:09:05',NULL),(12,2,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(13,2,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(14,2,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(15,2,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(16,2,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-06 06:09:05',NULL),(17,2,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 06:09:06',NULL),(18,2,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(19,2,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(20,2,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(21,2,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(22,2,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(23,3,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(24,3,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(25,3,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(26,3,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(27,3,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(28,3,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(29,3,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(30,3,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(31,3,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(32,3,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(33,3,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(34,3,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(35,3,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(36,4,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(37,4,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(38,4,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-06 06:09:06',NULL),(39,4,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(40,4,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(41,4,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(42,4,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(43,4,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(44,4,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(45,4,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(46,4,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(47,4,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(48,4,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(49,4,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(50,4,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(51,4,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(52,4,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(53,5,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-06 06:09:06',NULL),(54,6,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-06 06:09:06',NULL),(55,7,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-06 06:09:06',NULL),(56,8,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-06 06:09:06',NULL),(57,9,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-06 06:09:06',NULL),(58,9,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-06 06:09:06',NULL),(59,10,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(60,11,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 06:09:06',NULL),(61,12,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-06 06:09:06',NULL),(62,12,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-06 06:09:06',NULL),(63,12,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-06 06:09:06',NULL),(64,12,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 06:09:06',NULL),(65,12,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 06:09:06',NULL),(66,12,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 06:09:06',NULL),(67,12,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-06 06:09:06',NULL),(68,13,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-06 06:09:06',NULL),(69,13,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-06 06:09:06',NULL),(70,14,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-06 06:09:06',NULL),(71,14,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 06:09:06',NULL),(72,15,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 06:09:06',NULL),(73,15,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 06:09:06',NULL),(74,15,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-06 06:09:06',NULL),(75,15,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-06 06:09:06',NULL),(76,15,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(77,15,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-06 06:09:06',NULL),(78,15,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\", \"bochs\"]}','2025-12-06 06:09:06',NULL),(79,15,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 06:09:06',NULL),(80,15,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(81,15,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-06 06:09:06',NULL),(82,15,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, virtio, e1000e and vmxnet3. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\", \"vmxnet3\"]}','2025-12-06 06:09:06',NULL),(83,15,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 06:09:06',NULL),(84,15,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 06:09:06',NULL),(85,15,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 06:09:06',NULL),(86,15,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-06 06:09:06',NULL),(87,15,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 06:09:06',NULL),(88,16,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 06:09:06',NULL),(89,16,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 06:09:06',NULL),(90,16,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 06:09:06',NULL),(91,18,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-06 06:09:06',NULL),(92,18,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(93,18,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(94,19,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(95,19,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(96,19,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(97,19,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(98,19,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(99,19,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 06:09:06',NULL),(100,20,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-06 06:09:06',NULL),(101,20,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-06 06:09:06',NULL),(102,21,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 06:09:06',NULL),(103,21,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 06:09:06',NULL),(104,22,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-06 06:09:06',NULL),(105,22,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-06 06:09:06',NULL),(106,22,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-06 06:09:06',NULL),(107,22,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-06 06:09:06',NULL),(108,22,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-06 06:09:06',NULL),(109,22,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 06:09:06',NULL),(110,23,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-06 06:09:06',NULL),(111,24,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 06:09:06',NULL),(112,24,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 06:09:07',NULL),(113,25,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-06 06:09:07',NULL),(114,26,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-06 06:09:07',NULL),(115,27,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-06 06:09:07',NULL),(116,27,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-06 06:09:07',NULL),(117,27,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-06 06:09:07',NULL),(118,27,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(119,27,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(120,27,'hw_cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"This specifies the CPU Mode for the guest vm\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(121,27,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(122,27,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(123,27,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(124,27,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-06 06:09:07',NULL),(125,28,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(126,28,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(127,28,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-06 06:09:07',NULL),(128,28,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-06 06:09:07',NULL),(129,29,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(130,29,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(131,29,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-06 06:09:07',NULL),(132,33,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-06 06:09:08',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (1,'OS::Cinder::Volume',1,'2025-12-06 06:09:03',NULL),(2,'OS::Glance::Image',1,'2025-12-06 06:09:03',NULL),(3,'OS::Nova::Aggregate',1,'2025-12-06 06:09:03',NULL),(4,'OS::Nova::Flavor',1,'2025-12-06 06:09:05',NULL),(5,'OS::Nova::Server',1,'2025-12-06 06:09:05',NULL),(6,'OS::Trove::Instance',1,'2025-12-06 06:09:07',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `user_id` (`user_id`),
  KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','05522e78304c4c4eb4be044936c2fa3e','5ed95c9b17ee4dcb83395850789304e6','71e8014d856149b8b848710bb2692df2',0),('UserProject','05522e78304c4c4eb4be044936c2fa3e','5ed95c9b17ee4dcb83395850789304e6','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','05522e78304c4c4eb4be044936c2fa3e','6428a925613245eebefa379bad924d3c','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','0c7273e6d9c9413aaf1939a555f98d43','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','0c7273e6d9c9413aaf1939a555f98d43','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','10d8005d16834ef79aa0a18f4f12aed4','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','10d8005d16834ef79aa0a18f4f12aed4','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','24082ac6496f4383ae58462e38fb76da','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','24082ac6496f4383ae58462e38fb76da','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','9b3b4521d53f41ee909faead65f3c704','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','9b3b4521d53f41ee909faead65f3c704','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','c40fca403a64496ab31b4e2ebf5d74c4','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','c40fca403a64496ab31b4e2ebf5d74c4','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','dc3c916f09ac4f91b8e6a3247de028c1','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','dc3c916f09ac4f91b8e6a3247de028c1','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0),('UserProject','f38aca50c0714fbe9b6c2b0731af9373','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','f38aca50c0714fbe9b6c2b0731af9373','6363f866b688477296a48bc0eb3789ff','c449766ccbe34b22b7ebca739e5a7690',0),('UserProject','fe5320efd8664ae5bc09c39f39d3dbf1','6363f866b688477296a48bc0eb3789ff','75c57372495a4225abb3dbc4f7f9e530',0),('UserProject','fe5320efd8664ae5bc09c39f39d3dbf1','6363f866b688477296a48bc0eb3789ff','c8ea18b6064c40c791d4f23ccb1762a8',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  KEY `service_id` (`service_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('09f037d0792c46f3983e03e67204b171',NULL,'public','466def2f045e4fd2a721cc56fc6ac608','https://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('0bf6d0343c94403d921e187e77efc906',NULL,'internal','b29f2b3933974c3491bcb338e546687e','https://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('1c4da8c34824410d8b53e47e828a3a26',NULL,'internal','b0ad0351a14e492a8f14ef74c4275bcb','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('1c7380a2e1e342c188de8146325ddf88',NULL,'internal','5360ade0728247ae9415cea79e88828f','https://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('2415c33f2d6248aea0bf3f100963ed9c',NULL,'public','b29f2b3933974c3491bcb338e546687e','https://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('7f7a96a4763c4895b6d5ebe06557b676',NULL,'public','8c77ba74dabf4523be64d6a39fb611ae','https://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('997b28b639be4b3999f03a62682eba3d',NULL,'internal','c23d386bd1284033a502616abbd0bd93','https://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('a08a87d747864a5899a18e1845c3fe8d',NULL,'internal','0002f4d1682740549204c340e0008915','https://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('a10f0346952c4f99a8bd094ca7f29393',NULL,'internal','466def2f045e4fd2a721cc56fc6ac608','https://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('b06cefbc86a2415bab3904fc8ceded56',NULL,'public','b0ad0351a14e492a8f14ef74c4275bcb','http://192.168.122.2:8080/swift/v1/AUTH_%(tenant_id)s','{}',1,'regionOne'),('bfa5463173d247e9bd1a7710df6cd6df',NULL,'public','c23d386bd1284033a502616abbd0bd93','https://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('d2287f665ba14d2399674b56bf0f6e0f',NULL,'public','5360ade0728247ae9415cea79e88828f','https://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('e165fa20cf1f45198f6ebebc62cbb1fc',NULL,'internal','8c77ba74dabf4523be64d6a39fb611ae','https://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('e9a2bd3c37584af3bc42ecf0c69a59b1',NULL,'internal','828cd701c6ea4714bab3484afe50e4cb','https://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('eba178cab2324ecca595d0beb05cb995',NULL,'public','0002f4d1682740549204c340e0008915','https://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('fc43109ab8a0414e9bf41b98f494b948',NULL,'public','828cd701c6ea4714bab3484afe50e4cb','https://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('75c57372495a4225abb3dbc4f7f9e530','c449766ccbe34b22b7ebca739e5a7690'),('c449766ccbe34b22b7ebca739e5a7690','2297c0e5be154dbebc7f06df0865708c');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (1,'05522e78304c4c4eb4be044936c2fa3e','default','admin',0,NULL),(2,'0c7273e6d9c9413aaf1939a555f98d43','default','neutron',0,NULL),(3,'fe5320efd8664ae5bc09c39f39d3dbf1','default','placement',0,NULL),(4,'9b3b4521d53f41ee909faead65f3c704','default','glance',0,NULL),(5,'24082ac6496f4383ae58462e38fb76da','default','barbican',0,NULL),(6,'10d8005d16834ef79aa0a18f4f12aed4','default','ceilometer',0,NULL),(7,'c40fca403a64496ab31b4e2ebf5d74c4','default','nova',0,NULL),(8,'dc3c916f09ac4f91b8e6a3247de028c1','default','cinder',0,NULL),(9,'f38aca50c0714fbe9b6c2b0731af9373','default','swift',0,NULL),(10,'f52e47aca4ef465ca8e14c4032520ac6','default','demo_tempestconf',0,NULL),(11,'442c3a4401884580a5658964942c5472','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (1,1,NULL,0,'$2b$12$UQK9clx.sSG3PKoyvHjm7uiWnBmP/pye8YSuTccKWQPHZpK0/uYVy',1765001355110010,NULL,'2025-12-06 06:09:15'),(2,2,NULL,0,'$2b$12$MM7HyCfSZqXcFQGXkpvgouhwu03gpraKX1jqCfhs7WA00rSn/uLIi',1765001416077187,NULL,'2025-12-06 06:10:16'),(3,3,NULL,0,'$2b$12$04WsbGoa.VkFfUUzWV3a3Oy1AjxujPMydgMDCfq9r1n9e6A2gq1Q6',1765001418811037,NULL,'2025-12-06 06:10:18'),(4,4,NULL,0,'$2b$12$G/H0veTDOFVaCzljVQAAXuDVN902YALFxKssfUBIKo1IYTH9SRPby',1765001422645586,NULL,'2025-12-06 06:10:22'),(5,5,NULL,0,'$2b$12$dSwCfDhTS9g745yRWTHZ4uY.zJXU8n.wj3K.zlxB1qB.zhS3yZHOK',1765001428336543,NULL,'2025-12-06 06:10:28'),(6,6,NULL,0,'$2b$12$b91S40lFfrDojCYbsOd2yuhQUR/UI4L/8yjwsgMFmoEz/5by/JGy6',1765001433785312,NULL,'2025-12-06 06:10:33'),(7,7,NULL,0,'$2b$12$KQSb3cGFV9rXKuQMKHvxzuon7IG25igIzDQhvDPwF3Manlmyxn/fK',1765001441652631,NULL,'2025-12-06 06:10:41'),(8,8,NULL,0,'$2b$12$o3ww4/3QjL5KwR.s/dJYkOob9PtAuGcMeOTCOrwvtdR1HHc7LzyWC',1765001446813247,NULL,'2025-12-06 06:10:46'),(9,9,NULL,0,'$2b$12$gyPQMPzr3J.aJS19ACKtveo5OI/MX6KLXG17SsUGpuFJP9/z2pWVe',1765002624783768,NULL,'2025-12-06 06:30:24'),(10,10,NULL,0,'$2b$12$dso8ldfFO0qi/R2jpYY0P.OYleDNgowYuecxU0f1F9bUglTUjYV8C',1765004162367390,NULL,'2025-12-06 06:56:02'),(11,11,NULL,0,'$2b$12$uAhPb0sSPA28HKwziOItbeekGFT5H.f4SGNRUuihjxd857tPR2dd2',1765004165844442,NULL,'2025-12-06 06:56:05');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('5ed95c9b17ee4dcb83395850789304e6','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('6363f866b688477296a48bc0eb3789ff','service','{}','service',1,'default','default',0),('6428a925613245eebefa379bad924d3c','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('95663129bada415eba2b8562f5a23e2a','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (42,NULL,NULL,'db82cb64dc464715ad349b14a2a72d49',NULL,NULL,NULL,NULL,'2025-12-06 06:58:39',NULL,'2025-12-06 06:58:39',NULL,NULL),(43,NULL,NULL,'559e5452b69b46c5bf466bed6b7c3a23',NULL,NULL,NULL,NULL,'2025-12-06 06:58:39',NULL,'2025-12-06 06:58:39',NULL,NULL),(44,NULL,NULL,'72d258bb71be4ebf8a2d77cd0cd76f70',NULL,NULL,NULL,NULL,'2025-12-06 06:58:39',NULL,'2025-12-06 06:58:39',NULL,NULL),(45,NULL,'f6a860cac2784c9aa40e368ead10f26e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:40',NULL,'2025-12-06 06:58:40',NULL,NULL),(46,NULL,NULL,'97c22f0233864178895094d252362ebb',NULL,NULL,NULL,NULL,'2025-12-06 06:58:40',NULL,'2025-12-06 06:58:40',NULL,NULL),(47,NULL,NULL,'42c17161cb594890bdbe90a2773ce576',NULL,NULL,NULL,NULL,'2025-12-06 06:58:40',NULL,'2025-12-06 06:58:40',NULL,NULL),(48,NULL,'385a5a94c17e4c8c8d719f448d5483c2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:41',NULL,'2025-12-06 06:58:41',NULL,NULL),(49,NULL,'97498611bc6741669fa3f269fe754046',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:41',NULL,'2025-12-06 06:58:41',NULL,NULL),(50,NULL,'0e3e6779145340cda113df7384628578',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:41',NULL,'2025-12-06 06:58:41',NULL,NULL),(51,NULL,'d91d743551a845a7b601e89b5308b9be',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:43',NULL,'2025-12-06 06:58:43',NULL,NULL),(52,NULL,NULL,'8c69c7678e6f4c2b8b4049a5783e5566',NULL,NULL,NULL,NULL,'2025-12-06 06:58:45',NULL,'2025-12-06 06:58:45',NULL,NULL),(53,NULL,NULL,'b71e827518b04f998b2367b3f8e336c0',NULL,NULL,NULL,NULL,'2025-12-06 06:58:45',NULL,'2025-12-06 06:58:45',NULL,NULL),(54,NULL,'9a1c354f35de474db71d30cd434fd595',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:46',NULL,'2025-12-06 06:58:46',NULL,NULL),(55,NULL,NULL,'f3a4e45d5fe9445d8505914d906fbd69',NULL,NULL,NULL,NULL,'2025-12-06 06:58:46',NULL,'2025-12-06 06:58:46',NULL,NULL),(56,NULL,NULL,'56cdfcc1f05c4371bd82965e8a66a2cb',NULL,NULL,NULL,NULL,'2025-12-06 06:58:46',NULL,'2025-12-06 06:58:46',NULL,NULL),(57,NULL,'29e3a7070e114ab991ef2cda8b7e3021',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:48',NULL,'2025-12-06 06:58:48',NULL,NULL),(58,NULL,'5fde703e7bd8455c934a38338aee465b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:49',NULL,'2025-12-06 06:58:49',NULL,NULL),(59,NULL,'e39410450ece4bd884b149540a5a212c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:50',NULL,'2025-12-06 06:58:50',NULL,NULL),(60,NULL,NULL,'a0057d8b116b4156afb5e02d5461162a',NULL,NULL,NULL,NULL,'2025-12-06 06:58:52',NULL,'2025-12-06 06:58:52',NULL,NULL),(61,NULL,NULL,'7412014993844c48a98a14a1189136bf',NULL,NULL,NULL,NULL,'2025-12-06 06:58:52',NULL,'2025-12-06 06:58:52',NULL,NULL),(62,NULL,'6d4c5a8bca4845a58ab0d96479e5adaf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:54',NULL,'2025-12-06 06:58:54',NULL,NULL),(63,NULL,'42a5915b358e4ab9945ee30d8fc5c2ca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:58:55',NULL,'2025-12-06 06:58:55',NULL,NULL),(64,NULL,NULL,'e5122185c6194067bdb22d6ba8205dca',NULL,NULL,NULL,NULL,'2025-12-06 06:59:07',NULL,'2025-12-06 06:59:07',NULL,NULL),(65,NULL,'066c314d67e347f6a49e8e3e27998441',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:10',NULL,'2025-12-06 06:59:10',NULL,NULL),(66,NULL,NULL,'de3c7b57276149768f499355b80aea5a',NULL,NULL,NULL,NULL,'2025-12-06 06:59:16',NULL,'2025-12-06 06:59:16',NULL,NULL),(67,NULL,NULL,'00719a0d2bec4b9786d0b2074cfce9a9',NULL,NULL,NULL,NULL,'2025-12-06 06:59:16',NULL,'2025-12-06 06:59:16',NULL,NULL),(68,NULL,'82b43f15c8ff489384c01811a03c50ee',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:17',NULL,'2025-12-06 06:59:17',NULL,NULL),(69,NULL,NULL,'21371e07b1764fe883604309e8ae27d5',NULL,NULL,NULL,NULL,'2025-12-06 06:59:18',NULL,'2025-12-06 06:59:18',NULL,NULL),(70,NULL,NULL,'9690c3ae82544cab91af1f68211dc8d1',NULL,NULL,NULL,NULL,'2025-12-06 06:59:18',NULL,'2025-12-06 06:59:18',NULL,NULL),(71,NULL,'47fa7bc0f01c4a13ac0d14e1f9a7c59a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:18',NULL,'2025-12-06 06:59:18',NULL,NULL),(72,NULL,'640161fc88f944cd94a82d5f36e7fa99',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:19',NULL,'2025-12-06 06:59:19',NULL,NULL),(73,NULL,'164f3793f37e4768b0da70527fb86c4c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:20',NULL,'2025-12-06 06:59:20',NULL,NULL),(74,NULL,NULL,'cf4eeebcfa114fa680c20e22678d4514',NULL,NULL,NULL,NULL,'2025-12-06 06:59:21',NULL,'2025-12-06 06:59:21',NULL,NULL),(75,NULL,NULL,'a6ac8db8322348c5b6354f65f479e7b8',NULL,NULL,NULL,NULL,'2025-12-06 06:59:22',NULL,'2025-12-06 06:59:22',NULL,NULL),(76,NULL,'1aa42b1041f14e0084d2a5bcaaddfc46',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:24',NULL,'2025-12-06 06:59:24',NULL,NULL),(77,NULL,NULL,'4e358e8cf5374d0b818b9d1de2f01848',NULL,NULL,NULL,NULL,'2025-12-06 06:59:24',NULL,'2025-12-06 06:59:24',NULL,NULL),(78,NULL,NULL,'28495070d0e94414977511fb98ee8288',NULL,NULL,NULL,NULL,'2025-12-06 06:59:24',NULL,'2025-12-06 06:59:24',NULL,NULL),(79,NULL,NULL,'60162eb3313e412fbdb405f46832c14a',NULL,NULL,NULL,NULL,'2025-12-06 06:59:24',NULL,'2025-12-06 06:59:24',NULL,NULL),(80,NULL,'0acfd927da11444ab5eca29a9418affe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:25',NULL,'2025-12-06 06:59:25',NULL,NULL),(81,NULL,'a33d484d48c9436da22da22551266623',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:25',NULL,'2025-12-06 06:59:25',NULL,NULL),(82,NULL,'bccff877c0f34760846113a84f5b0709',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:26',NULL,'2025-12-06 06:59:26',NULL,NULL),(83,NULL,'ac4575fdd57240a9988c7ae425f0c2aa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:27',NULL,'2025-12-06 06:59:27',NULL,NULL),(84,NULL,NULL,'1ee66be53ba54987ab7e89ecd6d73d99',NULL,NULL,NULL,NULL,'2025-12-06 06:59:36',NULL,'2025-12-06 06:59:36',NULL,NULL),(85,NULL,NULL,'416e1dcf3a5c4ecf9e1386444103ab9e',NULL,NULL,NULL,NULL,'2025-12-06 06:59:37',NULL,'2025-12-06 06:59:37',NULL,NULL),(86,NULL,'c8f425959a6a4d6d9a67dac4a07eabf3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:40',NULL,'2025-12-06 06:59:40',NULL,NULL),(87,NULL,'65d2d5a52afd4d4097f6a6e020bc1dc8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:41',NULL,'2025-12-06 06:59:41',NULL,NULL),(88,NULL,NULL,'45fae70f04444b6dbf5bc2ef7d7e2663',NULL,NULL,NULL,NULL,'2025-12-06 06:59:46',NULL,'2025-12-06 06:59:46',NULL,NULL),(89,NULL,NULL,'cbf00ee99e6140d19c296749e287cdfc',NULL,NULL,NULL,NULL,'2025-12-06 06:59:46',NULL,'2025-12-06 06:59:46',NULL,NULL),(90,NULL,'dd40696da8e74b1bae5107bc1578bf2e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:48',NULL,'2025-12-06 06:59:48',NULL,NULL),(91,NULL,'54c709feb75b49ecb9fd77a776c20142',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:49',NULL,'2025-12-06 06:59:49',NULL,NULL),(92,NULL,NULL,'26dec1da14a4461b915127a1802eca01',NULL,NULL,NULL,NULL,'2025-12-06 06:59:53',NULL,'2025-12-06 06:59:53',NULL,NULL),(93,NULL,NULL,'4b1663d589134f5fa4646111538fa235',NULL,NULL,NULL,NULL,'2025-12-06 06:59:53',NULL,'2025-12-06 06:59:53',NULL,NULL),(94,NULL,'00368be7605440d7b3d643a4df9885d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:55',NULL,'2025-12-06 06:59:55',NULL,NULL),(95,NULL,'10f5406ad0d241f48de178db2ddf380c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 06:59:58',NULL,'2025-12-06 06:59:58',NULL,NULL),(96,NULL,NULL,'388434589fc24ffd89fa13b3ad1232be',NULL,NULL,NULL,NULL,'2025-12-06 07:00:04',NULL,'2025-12-06 07:00:04',NULL,NULL),(97,NULL,NULL,'18e992e5748c461e82b6b6a731393eca',NULL,NULL,NULL,NULL,'2025-12-06 07:00:04',NULL,'2025-12-06 07:00:04',NULL,NULL),(98,NULL,'392b1ea6494f4d3fa022609761b48d2f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:06',NULL,'2025-12-06 07:00:06',NULL,NULL),(99,NULL,'cb39a03721bf4c5fbea3b72ba0e4eeaf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:07',NULL,'2025-12-06 07:00:07',NULL,NULL),(100,NULL,NULL,'06f6f52d98454c8ba677e0020e21d006',NULL,NULL,NULL,NULL,'2025-12-06 07:00:12',NULL,'2025-12-06 07:00:12',NULL,NULL),(101,NULL,NULL,'0915ad469e774c6f9cf09bb524558ea2',NULL,NULL,NULL,NULL,'2025-12-06 07:00:13',NULL,'2025-12-06 07:00:13',NULL,NULL),(102,NULL,'cc2fd397dd974a6fb63e0af2912d7246',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:16',NULL,'2025-12-06 07:00:16',NULL,NULL),(103,NULL,'f0a2dde5275d4bf18a4d85278036706a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:17',NULL,'2025-12-06 07:00:17',NULL,NULL),(104,NULL,NULL,'ad684d91f774407a80c15bb5eb75e709',NULL,NULL,NULL,NULL,'2025-12-06 07:00:22',NULL,'2025-12-06 07:00:22',NULL,NULL),(105,NULL,NULL,'657d7b826c0348be876b8bf8e56e4aa1',NULL,NULL,NULL,NULL,'2025-12-06 07:00:22',NULL,'2025-12-06 07:00:22',NULL,NULL),(106,NULL,'461a491725c2401a9dd7770480a04d45',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:24',NULL,'2025-12-06 07:00:24',NULL,NULL),(107,NULL,'2655c5b2ce5c4b9bb12ee0f7a2b233b9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:25',NULL,'2025-12-06 07:00:25',NULL,NULL),(108,NULL,NULL,'f1cd1e8db3944f9d99d30fe0f2ca9b40',NULL,NULL,NULL,NULL,'2025-12-06 07:00:32',NULL,'2025-12-06 07:00:32',NULL,NULL),(109,NULL,NULL,'9a58273bf6eb4a3a88fbbc1b22606890',NULL,NULL,NULL,NULL,'2025-12-06 07:00:32',NULL,'2025-12-06 07:00:32',NULL,NULL),(110,NULL,'8f2466826a40412e9d3a961f7f8e6505',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:40',NULL,'2025-12-06 07:00:40',NULL,NULL),(111,NULL,'541f4be208834729aa35dbfd881f9774',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:00:44',NULL,'2025-12-06 07:00:44',NULL,NULL),(112,NULL,NULL,'c471515305d641a4ad0f6c96b0a3a99c',NULL,NULL,NULL,NULL,'2025-12-06 07:01:07',NULL,'2025-12-06 07:01:07',NULL,NULL),(113,NULL,NULL,'24a0d7bc709e496a899c9cdc3d4626d3',NULL,NULL,NULL,NULL,'2025-12-06 07:01:08',NULL,'2025-12-06 07:01:08',NULL,NULL),(114,NULL,'2afd88dcb7eb49519ff580bf538ba30c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:01:12',NULL,'2025-12-06 07:01:12',NULL,NULL),(115,NULL,'93ed74fbaa5248349a016be1f013fb09',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:01:14',NULL,'2025-12-06 07:01:14',NULL,NULL),(116,NULL,NULL,'56a80bccd06a46eb841b4a39bdc45f76',NULL,NULL,NULL,NULL,'2025-12-06 07:02:25',NULL,'2025-12-06 07:02:25',NULL,NULL),(117,NULL,NULL,'67151e4eb51a4d4f85095b06b80cf555',NULL,NULL,NULL,NULL,'2025-12-06 07:02:25',NULL,'2025-12-06 07:02:25',NULL,NULL),(118,NULL,'531b73cdaf46455fb28982d32a910a49',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:27',NULL,'2025-12-06 07:02:27',NULL,NULL),(119,NULL,'e2869bdde00d4ef8bea339be8805aa3f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:28',NULL,'2025-12-06 07:02:28',NULL,NULL),(120,NULL,NULL,'6c85e9c769e54717968fcdf311dbb4cb',NULL,NULL,NULL,NULL,'2025-12-06 07:02:33',NULL,'2025-12-06 07:02:33',NULL,NULL),(121,NULL,NULL,'f375ce710e3043aaac5e0676424b8718',NULL,NULL,NULL,NULL,'2025-12-06 07:02:33',NULL,'2025-12-06 07:02:33',NULL,NULL),(122,NULL,'fcde392c111a447d982224ba9cd2e58b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:35',NULL,'2025-12-06 07:02:35',NULL,NULL),(123,NULL,'56a3c10c603c4575afa6144c7c6c0490',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:39',NULL,'2025-12-06 07:02:39',NULL,NULL),(124,NULL,NULL,'1f9e303948154e6e84ebb56966463de3',NULL,NULL,NULL,NULL,'2025-12-06 07:02:46',NULL,'2025-12-06 07:02:46',NULL,NULL),(125,NULL,NULL,'c94e83a66a2e4e0cbf140fdf05640ff6',NULL,NULL,NULL,NULL,'2025-12-06 07:02:46',NULL,'2025-12-06 07:02:46',NULL,NULL),(126,NULL,'282d9de441f7436fb15cc5e1f78eafd2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:50',NULL,'2025-12-06 07:02:50',NULL,NULL),(127,NULL,NULL,'538aa592cfb04958ab11223ed2d98106',NULL,NULL,NULL,NULL,'2025-12-06 07:02:52',NULL,'2025-12-06 07:02:52',NULL,NULL),(128,NULL,NULL,'41a5abb93e70428cb0414a3d26c3ee84',NULL,NULL,NULL,NULL,'2025-12-06 07:02:52',NULL,'2025-12-06 07:02:52',NULL,NULL),(129,NULL,'bcac2d15ebea4745a7dcc7225aab8e12',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:53',NULL,'2025-12-06 07:02:53',NULL,NULL),(130,NULL,'35f18a3faa574f23a2b399946979fa9d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:54',NULL,'2025-12-06 07:02:54',NULL,NULL),(131,NULL,'fc6c493097a84d069d178020ca398a25',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:02:56',NULL,'2025-12-06 07:02:56',NULL,NULL),(132,NULL,NULL,'7b841bfcd0ce4656ab079869414f1999',NULL,NULL,NULL,NULL,'2025-12-06 07:02:58',NULL,'2025-12-06 07:02:58',NULL,NULL),(133,NULL,NULL,'7164934f9291483abff2b0ecfb5c4f45',NULL,NULL,NULL,NULL,'2025-12-06 07:02:58',NULL,'2025-12-06 07:02:58',NULL,NULL),(134,NULL,'caf212204f3c48c0869774e17c54d045',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:00',NULL,'2025-12-06 07:03:00',NULL,NULL),(135,NULL,NULL,'9e9f4d3e904d4693aaf2d9251edde7b0',NULL,NULL,NULL,NULL,'2025-12-06 07:03:02',NULL,'2025-12-06 07:03:02',NULL,NULL),(136,NULL,NULL,'b4d08ae1ebb14d07bcd695c8ac4e44d3',NULL,NULL,NULL,NULL,'2025-12-06 07:03:02',NULL,'2025-12-06 07:03:02',NULL,NULL),(137,NULL,'0aa1471026df4b51b2a9c05bec21e4fc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:02',NULL,'2025-12-06 07:03:02',NULL,NULL),(138,NULL,'fcee766b8f2840c6b0e6db5ea2bba325',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:04',NULL,'2025-12-06 07:03:04',NULL,NULL),(139,NULL,'1e8f9dcc26e6498eadf203ea42e32e9f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:05',NULL,'2025-12-06 07:03:05',NULL,NULL),(140,NULL,NULL,'c060c4d87b6245b0aa21fc6f24f2765b',NULL,NULL,NULL,NULL,'2025-12-06 07:03:07',NULL,'2025-12-06 07:03:07',NULL,NULL),(141,NULL,NULL,'17a8ea628f9a4d62948909d13b7d8ec6',NULL,NULL,NULL,NULL,'2025-12-06 07:03:07',NULL,'2025-12-06 07:03:07',NULL,NULL),(142,NULL,'fda440ef65974beba9a726c96b7269f5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:09',NULL,'2025-12-06 07:03:09',NULL,NULL),(143,NULL,NULL,'ac96bf0df53945f1b159209af056b438',NULL,NULL,NULL,NULL,'2025-12-06 07:03:10',NULL,'2025-12-06 07:03:10',NULL,NULL),(144,NULL,NULL,'cd879af76b5c4eb1b00491d358fa6a99',NULL,NULL,NULL,NULL,'2025-12-06 07:03:10',NULL,'2025-12-06 07:03:10',NULL,NULL),(145,NULL,'08fae52070c7460eb63c025b5c1f0013',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:10',NULL,'2025-12-06 07:03:10',NULL,NULL),(146,NULL,'72130054b9304665a88c6cc5f90cfbe5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:13',NULL,'2025-12-06 07:03:13',NULL,NULL),(147,NULL,'a4285fa16d3e4b8da2f6d2b54b412c0e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:15',NULL,'2025-12-06 07:03:15',NULL,NULL),(148,NULL,NULL,'caf18ea8e6c0425d8fc9f0795b4aed13',NULL,NULL,NULL,NULL,'2025-12-06 07:03:26',NULL,'2025-12-06 07:03:26',NULL,NULL),(149,NULL,NULL,'74dac92b332b46b988a680a049c61f72',NULL,NULL,NULL,NULL,'2025-12-06 07:03:27',NULL,'2025-12-06 07:03:27',NULL,NULL),(150,NULL,'9d3db837f6a546ce9c3d159e70a38443',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:28',NULL,'2025-12-06 07:03:28',NULL,NULL),(151,NULL,'80face097c4447b3b8d17bc00eacfa7c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:30',NULL,'2025-12-06 07:03:30',NULL,NULL),(152,NULL,NULL,'bacfe2d6545a465e92bea2335e406521',NULL,NULL,NULL,NULL,'2025-12-06 07:03:51',NULL,'2025-12-06 07:03:51',NULL,NULL),(153,NULL,NULL,'01c1111bb347460881b64177b58b9736',NULL,NULL,NULL,NULL,'2025-12-06 07:03:51',NULL,'2025-12-06 07:03:51',NULL,NULL),(154,NULL,'60d9cd58f52c44b59e2294a90f7fa428',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:53',NULL,'2025-12-06 07:03:53',NULL,NULL),(155,NULL,'908b04db71714759ab21a36247441df5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:03:54',NULL,'2025-12-06 07:03:54',NULL,NULL),(156,NULL,NULL,'e53d35ee2a994a8a9b397f772571123e',NULL,NULL,NULL,NULL,'2025-12-06 07:04:09',NULL,'2025-12-06 07:04:09',NULL,NULL),(157,NULL,NULL,'65ee878cf7144ceaaac06cf1c473333f',NULL,NULL,NULL,NULL,'2025-12-06 07:04:10',NULL,'2025-12-06 07:04:10',NULL,NULL),(158,NULL,'7bc18054c7b54331a9f141e9c35a9d00',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:12',NULL,'2025-12-06 07:04:12',NULL,NULL),(159,NULL,'418031d879994067872c57f047bea151',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:13',NULL,'2025-12-06 07:04:13',NULL,NULL),(160,NULL,NULL,'a3cae056210a400fa5e3495fe827d29a',NULL,NULL,NULL,NULL,'2025-12-06 07:04:16',NULL,'2025-12-06 07:04:16',NULL,NULL),(161,NULL,NULL,'772d06a215da4b2f88e6a2a37c9e7194',NULL,NULL,NULL,NULL,'2025-12-06 07:04:16',NULL,'2025-12-06 07:04:16',NULL,NULL),(162,NULL,'b6179a8b65c2484eb7ca1e068d93a58c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:17',NULL,'2025-12-06 07:04:17',NULL,NULL),(163,NULL,'bcfff898efaa4054886db7320c2a0364',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:17',NULL,'2025-12-06 07:04:17',NULL,NULL),(164,NULL,NULL,'6805353f6bf048f9b406a1e565a13f11',NULL,NULL,NULL,NULL,'2025-12-06 07:04:18',NULL,'2025-12-06 07:04:18',NULL,NULL),(165,NULL,NULL,'549336d6442b4deeb6b3016b3ba916fe',NULL,NULL,NULL,NULL,'2025-12-06 07:04:18',NULL,'2025-12-06 07:04:18',NULL,NULL),(166,NULL,'096c573a8cb34680b1bcc6f529b2a707',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:19',NULL,'2025-12-06 07:04:19',NULL,NULL),(167,NULL,'dc1bc9517198484ab30d93ebd5d88c35',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:20',NULL,'2025-12-06 07:04:20',NULL,NULL),(168,NULL,NULL,'d3e319dfcfb74c3c8be44faaaf8d3b23',NULL,NULL,NULL,NULL,'2025-12-06 07:04:21',NULL,'2025-12-06 07:04:21',NULL,NULL),(169,NULL,NULL,'567401c19cd8417587203de8beda99ad',NULL,NULL,NULL,NULL,'2025-12-06 07:04:21',NULL,'2025-12-06 07:04:21',NULL,NULL),(170,NULL,'c2cb87af28c1416cb7771e5f69eccd1b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:22',NULL,'2025-12-06 07:04:22',NULL,NULL),(171,NULL,'b61823f2ce6041e787305b4502de5839',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:24',NULL,'2025-12-06 07:04:24',NULL,NULL),(172,NULL,NULL,'19ef0304d5c5408da35caa178036cb00',NULL,NULL,NULL,NULL,'2025-12-06 07:04:24',NULL,'2025-12-06 07:04:24',NULL,NULL),(173,NULL,NULL,'40a6412de70841a6a4914655fbca6afb',NULL,NULL,NULL,NULL,'2025-12-06 07:04:24',NULL,'2025-12-06 07:04:24',NULL,NULL),(174,NULL,'08279cb4c8b14fbe8628e5d308b6991e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:26',NULL,'2025-12-06 07:04:26',NULL,NULL),(175,NULL,'8b8c9901ee794bae80bd37f121f31173',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:27',NULL,'2025-12-06 07:04:27',NULL,NULL),(176,NULL,NULL,'5167a4dd46d2432abb1fe892c0a4a969',NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(177,NULL,'05ec17e60e754f0dbd57722f5dc7db4e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(178,NULL,NULL,'bf0082bf71304b52abb6e2a486d0b5fd',NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(179,NULL,NULL,'e3271801a7ec4e8c98140835d902af20',NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(180,NULL,NULL,'3413e524013a47e2984d780df5cddaa4',NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(181,NULL,NULL,'bd4c40bcf01844bfb954b43aa5dbad6f',NULL,NULL,NULL,NULL,'2025-12-06 07:04:32',NULL,'2025-12-06 07:04:32',NULL,NULL),(182,NULL,'21bd2411fcd346ed98b5a43d0211dc29',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:33',NULL,'2025-12-06 07:04:33',NULL,NULL),(183,NULL,'80ff51d0b3b24875aba4fff9772ae201',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:34',NULL,'2025-12-06 07:04:34',NULL,NULL),(184,NULL,'40ac3304afac44b68623d1eb9a5e0a3f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:34',NULL,'2025-12-06 07:04:34',NULL,NULL),(185,NULL,'cbe7fb1c3dfa4a0786e5bff946801145',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:04:35',NULL,'2025-12-06 07:04:35',NULL,NULL),(186,NULL,NULL,'1a0ca5a46a9442b1845863069ff295f4',NULL,NULL,NULL,NULL,'2025-12-06 07:05:16',NULL,'2025-12-06 07:05:16',NULL,NULL),(187,NULL,NULL,'3023ba2dbe884b7bae3939f663e07aea',NULL,NULL,NULL,NULL,'2025-12-06 07:05:16',NULL,'2025-12-06 07:05:16',NULL,NULL),(188,NULL,'a055b1b8e2e54e4a81cfca74765ddcb1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:18',NULL,'2025-12-06 07:05:18',NULL,NULL),(189,NULL,'236cf6b5e92b4f19a8664920ae6791af',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:19',NULL,'2025-12-06 07:05:19',NULL,NULL),(190,NULL,NULL,'cc97b80ef60545f49754c1c2d3b43075',NULL,NULL,NULL,NULL,'2025-12-06 07:05:23',NULL,'2025-12-06 07:05:23',NULL,NULL),(191,NULL,NULL,'395328f76fc84184a0965c25846d1e44',NULL,NULL,NULL,NULL,'2025-12-06 07:05:23',NULL,'2025-12-06 07:05:23',NULL,NULL),(192,NULL,'d23a0538e15f4f2d9c1f4d2b872897d2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:25',NULL,'2025-12-06 07:05:25',NULL,NULL),(193,NULL,'e499fd884cff4937a414aaf2f5b3d866',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:26',NULL,'2025-12-06 07:05:26',NULL,NULL),(194,NULL,NULL,'80e7264f985d465b9dddefd6429bf7f6',NULL,NULL,NULL,NULL,'2025-12-06 07:05:40',NULL,'2025-12-06 07:05:40',NULL,NULL),(195,NULL,NULL,'050e9aa8673049839eae812311af4361',NULL,NULL,NULL,NULL,'2025-12-06 07:05:40',NULL,'2025-12-06 07:05:40',NULL,NULL),(196,NULL,'c5ae70f9b4104dcca7240b5f78eaabcd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:42',NULL,'2025-12-06 07:05:42',NULL,NULL),(197,NULL,'08c7fcd71bde4f6fb1661f23775cd7fb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:43',NULL,'2025-12-06 07:05:43',NULL,NULL),(198,NULL,NULL,'756e3e1fa7e44042bdf37a6cdd877fac',NULL,NULL,NULL,NULL,'2025-12-06 07:05:45',NULL,'2025-12-06 07:05:45',NULL,NULL),(199,NULL,NULL,'daab2cfaa69a4e9f819a57290bfd54d9',NULL,NULL,NULL,NULL,'2025-12-06 07:05:45',NULL,'2025-12-06 07:05:45',NULL,NULL),(200,NULL,'9e86c61372e24db392d4a12ca71f7e00',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:46',NULL,'2025-12-06 07:05:46',NULL,NULL),(201,NULL,NULL,'5f0c162d465644af9f3667bc6e9057f1',NULL,NULL,NULL,NULL,'2025-12-06 07:05:47',NULL,'2025-12-06 07:05:47',NULL,NULL),(202,NULL,NULL,'3b5e3a14b5af4b6aa12a81225f3c6312',NULL,NULL,NULL,NULL,'2025-12-06 07:05:47',NULL,'2025-12-06 07:05:47',NULL,NULL),(203,NULL,'646c511edd3f4a5c93117e8dcfea183b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:47',NULL,'2025-12-06 07:05:47',NULL,NULL),(204,NULL,'75754a12eadf4d6a9b7169dd9ab15ff2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:49',NULL,'2025-12-06 07:05:49',NULL,NULL),(205,NULL,NULL,'e5f62143343c4499a86f710385c0c2f8',NULL,NULL,NULL,NULL,'2025-12-06 07:05:50',NULL,'2025-12-06 07:05:50',NULL,NULL),(206,NULL,NULL,'9516c2157b264d33a8d3123134dc3cf0',NULL,NULL,NULL,NULL,'2025-12-06 07:05:50',NULL,'2025-12-06 07:05:50',NULL,NULL),(207,NULL,'eca8c33d750f413db545b27d5d3859d9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:50',NULL,'2025-12-06 07:05:50',NULL,NULL),(208,NULL,'9175aeced50c47b9b3aba5550ef48619',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:51',NULL,'2025-12-06 07:05:51',NULL,NULL),(209,NULL,'edcc68bbf9cd4c9189e59964db884a26',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:05:52',NULL,'2025-12-06 07:05:52',NULL,NULL),(210,NULL,NULL,'5e66cd58a9a94a0d852ed7c8b792e595',NULL,NULL,NULL,NULL,'2025-12-06 07:06:05',NULL,'2025-12-06 07:06:05',NULL,NULL),(211,NULL,NULL,'889809c6d85e477e94db70e92c7cd5dc',NULL,NULL,NULL,NULL,'2025-12-06 07:06:05',NULL,'2025-12-06 07:06:05',NULL,NULL),(212,NULL,NULL,'51ddcd9aef3f4694b510bfe0c16a2eb5',NULL,NULL,NULL,NULL,'2025-12-06 07:06:05',NULL,'2025-12-06 07:06:05',NULL,NULL),(213,NULL,'dad6457c27494a8a9e5f2004a841cf60',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:06:08',NULL,'2025-12-06 07:06:08',NULL,NULL),(214,NULL,'aa7c35d912e74a6fb35d13d710216035',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:06:11',NULL,'2025-12-06 07:06:11',NULL,NULL),(215,NULL,'9f25949b55a44fdd965efc6e6f4460e8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:06:13',NULL,'2025-12-06 07:06:13',NULL,NULL),(216,NULL,NULL,'3c3859554f86419a941a5924e80b88de',NULL,NULL,NULL,NULL,'2025-12-06 07:06:21',NULL,'2025-12-06 07:06:21',NULL,NULL),(217,NULL,NULL,'fe5ab093e92243bbbb3fe0185089dd0b',NULL,NULL,NULL,NULL,'2025-12-06 07:06:21',NULL,'2025-12-06 07:06:21',NULL,NULL),(218,NULL,'e2384cf38a13417c9220db3aafff6b24',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:06:23',NULL,'2025-12-06 07:06:23',NULL,NULL),(219,NULL,'db5c847a1cb84e2ba4e1e360b69c614f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:06:24',NULL,'2025-12-06 07:06:24',NULL,NULL),(220,NULL,NULL,'331b8c2798cf4e52a2f60b73cf2831a3',NULL,NULL,NULL,NULL,'2025-12-06 07:07:00',NULL,'2025-12-06 07:07:00',NULL,NULL),(221,NULL,'0bb2a00a1f30495ca45c1cb0c482b67c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:03',NULL,'2025-12-06 07:07:03',NULL,NULL),(222,NULL,NULL,'21af856fbd8843c2969956a9587ca48a',NULL,NULL,NULL,NULL,'2025-12-06 07:07:09',NULL,'2025-12-06 07:07:09',NULL,NULL),(223,NULL,NULL,'0893d60e82a841cd841320ce696c1510',NULL,NULL,NULL,NULL,'2025-12-06 07:07:09',NULL,'2025-12-06 07:07:09',NULL,NULL),(224,NULL,'51e20cf6e1a94295ae4d975419037ae7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:15',NULL,'2025-12-06 07:07:15',NULL,NULL),(225,NULL,'2c1f48b58dd04b828c83d6350cc4e13d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:20',NULL,'2025-12-06 07:07:20',NULL,NULL),(226,NULL,NULL,'c21dfd492d1e4a719d62a4a42bb6ce22',NULL,NULL,NULL,NULL,'2025-12-06 07:07:29',NULL,'2025-12-06 07:07:29',NULL,NULL),(227,NULL,NULL,'db0fb24b4a98439ea2d58970d715cb88',NULL,NULL,NULL,NULL,'2025-12-06 07:07:30',NULL,'2025-12-06 07:07:30',NULL,NULL),(228,NULL,'0a70cdd980274fa296dbc980da407ec7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:36',NULL,'2025-12-06 07:07:36',NULL,NULL),(229,NULL,'32af848ffad2419097d5f0cb876ddc9e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:40',NULL,'2025-12-06 07:07:40',NULL,NULL),(230,NULL,NULL,'c9025bd3f0854dff80d9408800d6b76b',NULL,NULL,NULL,NULL,'2025-12-06 07:07:42',NULL,'2025-12-06 07:07:42',NULL,NULL),(231,NULL,'503b2dfdce9d47598a8b9de4b15e1d45',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:07:43',NULL,'2025-12-06 07:07:43',NULL,NULL),(232,NULL,NULL,'b9343f7eea174bc8ad0a14b1247d7d0f',NULL,NULL,NULL,NULL,'2025-12-06 07:08:07',NULL,'2025-12-06 07:08:07',NULL,NULL),(233,NULL,'09660a2b244f472083042e6223025786',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:08:09',NULL,'2025-12-06 07:08:09',NULL,NULL),(234,NULL,NULL,'efe05a48ec334e45abf7bb61dd8378f5',NULL,NULL,NULL,NULL,'2025-12-06 07:08:10',NULL,'2025-12-06 07:08:10',NULL,NULL),(235,NULL,'518550462c5642c68d460d777e3915ee',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:08:12',NULL,'2025-12-06 07:08:12',NULL,NULL),(236,NULL,NULL,'0d3ecc911f3d4bb0ba95713e7d7d3f7b',NULL,NULL,NULL,NULL,'2025-12-06 07:08:36',NULL,'2025-12-06 07:08:36',NULL,NULL),(237,NULL,'e795388aa12c4c8db6a45f21af53750e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:08:38',NULL,'2025-12-06 07:08:38',NULL,NULL),(238,NULL,NULL,'98f77d99921448508eb3ac7bf8c4fa34',NULL,NULL,NULL,NULL,'2025-12-06 07:09:17',NULL,'2025-12-06 07:09:17',NULL,NULL),(239,NULL,'87ee3f11e794407692b09a4b77c91610',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:18',NULL,'2025-12-06 07:09:18',NULL,NULL),(240,NULL,NULL,'b7c2f91caf1444c68dcf6bd66966d67e',NULL,NULL,NULL,NULL,'2025-12-06 07:09:20',NULL,'2025-12-06 07:09:20',NULL,NULL),(241,NULL,NULL,'43d74004790a4e45a82d0ca55cd54ed6',NULL,NULL,NULL,NULL,'2025-12-06 07:09:20',NULL,'2025-12-06 07:09:20',NULL,NULL),(242,NULL,NULL,'0fc49199006c49f8acbf16dbb092b30e',NULL,NULL,NULL,NULL,'2025-12-06 07:09:20',NULL,'2025-12-06 07:09:20',NULL,NULL),(243,NULL,'48c30d0eed09471b82c581b450d520b1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:21',NULL,'2025-12-06 07:09:21',NULL,NULL),(244,NULL,'4dede504f5804984b13a5a61b4d41f40',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:22',NULL,'2025-12-06 07:09:22',NULL,NULL),(245,NULL,'c2236fb6443441618c69ad660b0932dd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:22',NULL,'2025-12-06 07:09:22',NULL,NULL),(246,NULL,NULL,'d4a62c5901374aaf922665bea2f200fc',NULL,NULL,NULL,NULL,'2025-12-06 07:09:25',NULL,'2025-12-06 07:09:25',NULL,NULL),(247,NULL,'9ac7bf79c36e40419fed4f086cd8410c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:26',NULL,'2025-12-06 07:09:26',NULL,NULL),(248,NULL,NULL,'26351103f81345c08304503b027a03b0',NULL,NULL,NULL,NULL,'2025-12-06 07:09:28',NULL,'2025-12-06 07:09:28',NULL,NULL),(249,NULL,NULL,'2ae18408acaa446dbf2a9a636afd757e',NULL,NULL,NULL,NULL,'2025-12-06 07:09:29',NULL,'2025-12-06 07:09:29',NULL,NULL),(250,NULL,'76a65e3a72364d07a0877f878ec93130',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:30',NULL,'2025-12-06 07:09:30',NULL,NULL),(251,NULL,'c3c141a8c05349c291457adf658cdefa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:31',NULL,'2025-12-06 07:09:31',NULL,NULL),(252,NULL,NULL,'dcea8b816b174d4b911c9d7a31f38dee',NULL,NULL,NULL,NULL,'2025-12-06 07:09:38',NULL,'2025-12-06 07:09:38',NULL,NULL),(253,NULL,'0538d1c2fffa41b8a9a620dc9c82ae1f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:09:42',NULL,'2025-12-06 07:09:42',NULL,NULL),(254,NULL,NULL,'6765f3c3646341b68884aec5c4ac93b8',NULL,NULL,NULL,NULL,'2025-12-06 07:10:12',NULL,'2025-12-06 07:10:12',NULL,NULL),(255,NULL,'8eb83de605b94d779609650c12dbe05d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:15',NULL,'2025-12-06 07:10:15',NULL,NULL),(256,NULL,NULL,'95bad3f218a6416b8d21a76826834f33',NULL,NULL,NULL,NULL,'2025-12-06 07:10:20',NULL,'2025-12-06 07:10:20',NULL,NULL),(257,NULL,'9cc7a6879e1e4cc7a3ac4c32f40bdb16',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:22',NULL,'2025-12-06 07:10:22',NULL,NULL),(258,NULL,NULL,'3786fc2472ec43adb27b29bfa497a6a2',NULL,NULL,NULL,NULL,'2025-12-06 07:10:27',NULL,'2025-12-06 07:10:27',NULL,NULL),(259,NULL,NULL,'33518fed43cc4fdfbdce993ccb4cc360',NULL,NULL,NULL,NULL,'2025-12-06 07:10:28',NULL,'2025-12-06 07:10:28',NULL,NULL),(260,NULL,NULL,'3f234c397bcd414fba10c3693a66c05b',NULL,NULL,NULL,NULL,'2025-12-06 07:10:28',NULL,'2025-12-06 07:10:28',NULL,NULL),(261,NULL,'6f86ab5a5bf14cb6b789f065cc8ca04a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:29',NULL,'2025-12-06 07:10:29',NULL,NULL),(262,NULL,'4c41abd44bbf46f39df642d2a2cd19eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:30',NULL,'2025-12-06 07:10:30',NULL,NULL),(263,NULL,'8d6d539c9fe9424e8ef1bf0a975b7122',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:31',NULL,'2025-12-06 07:10:31',NULL,NULL),(264,NULL,NULL,'9baf1f24681f45f593e062ef9064df62',NULL,NULL,NULL,NULL,'2025-12-06 07:10:35',NULL,'2025-12-06 07:10:35',NULL,NULL),(265,NULL,'5e46f687592d4abf83c1aa920da0539a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:37',NULL,'2025-12-06 07:10:37',NULL,NULL),(266,NULL,NULL,'453245394595432897a0119af3dbcc2b',NULL,NULL,NULL,NULL,'2025-12-06 07:10:38',NULL,'2025-12-06 07:10:38',NULL,NULL),(267,NULL,'5332da2ffd1440c4aabeff29f5efe192',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:40',NULL,'2025-12-06 07:10:40',NULL,NULL),(268,NULL,NULL,'d27af3aa39b748f8a3ee32f3d54e6cdc',NULL,NULL,NULL,NULL,'2025-12-06 07:10:45',NULL,'2025-12-06 07:10:45',NULL,NULL),(269,NULL,'3892736484af4c9bb7a14813b133e70a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:10:48',NULL,'2025-12-06 07:10:48',NULL,NULL),(270,NULL,NULL,'c9d48574106d47b89409a4c75e8fe200',NULL,NULL,NULL,NULL,'2025-12-06 07:11:05',NULL,'2025-12-06 07:11:05',NULL,NULL),(271,NULL,'23782d4b7b964f319bad154f487d4b08',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:11:06',NULL,'2025-12-06 07:11:06',NULL,NULL),(272,NULL,NULL,'e97a1486f59c4c579c2000a00687546e',NULL,NULL,NULL,NULL,'2025-12-06 07:11:28',NULL,'2025-12-06 07:11:28',NULL,NULL),(273,NULL,'56c9c309bcb24fd189fb78aaed58ab70',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:11:29',NULL,'2025-12-06 07:11:29',NULL,NULL),(274,NULL,NULL,'ef5fe6979bc448399956738faf6c8d3f',NULL,NULL,NULL,NULL,'2025-12-06 07:11:55',NULL,'2025-12-06 07:11:55',NULL,NULL),(275,NULL,'50fdc02b371b4fb9b701031b47f328f4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:11:57',NULL,'2025-12-06 07:11:57',NULL,NULL),(276,NULL,NULL,'337447c5cffc48bf8256c9166a6ff0e2',NULL,NULL,NULL,NULL,'2025-12-06 07:12:35',NULL,'2025-12-06 07:12:35',NULL,NULL),(277,NULL,'da24f0e2d59745828feaaecfeb9fed45',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:12:36',NULL,'2025-12-06 07:12:36',NULL,NULL),(278,NULL,NULL,'5e090a5aa1bf4e4394b5fbf3418f0e6d',NULL,NULL,NULL,NULL,'2025-12-06 07:13:26',NULL,'2025-12-06 07:13:26',NULL,NULL),(279,NULL,'84491fd4e10b457ab46523330f88bb07',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:13:27',NULL,'2025-12-06 07:13:27',NULL,NULL),(280,NULL,NULL,'03fb2817729e4b71932023a7637c6244',NULL,NULL,NULL,NULL,'2025-12-06 07:13:51',NULL,'2025-12-06 07:13:51',NULL,NULL),(281,NULL,'de09de98b3b1445f88b6094b6aac4a30',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:13:52',NULL,'2025-12-06 07:13:52',NULL,NULL),(282,NULL,NULL,'a1ed181a1103481fa4d0b29ce1009dca',NULL,NULL,NULL,NULL,'2025-12-06 07:13:59',NULL,'2025-12-06 07:13:59',NULL,NULL),(283,NULL,'c297e84c3a9f48a9a82aebc9e5ade875',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:14:00',NULL,'2025-12-06 07:14:00',NULL,NULL),(284,NULL,NULL,'c868dc0dcc324306ac266427e46d053f',NULL,NULL,NULL,NULL,'2025-12-06 07:14:05',NULL,'2025-12-06 07:14:05',NULL,NULL),(285,NULL,'d1f055ea379847dfbbaa66c69c6402f1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:14:06',NULL,'2025-12-06 07:14:06',NULL,NULL),(286,NULL,NULL,'5170c7fd029d49919219216322a15062',NULL,NULL,NULL,NULL,'2025-12-06 07:14:44',NULL,'2025-12-06 07:14:44',NULL,NULL),(287,NULL,NULL,'30cfe1ade59e4735affe15c43e86fec2',NULL,NULL,NULL,NULL,'2025-12-06 07:14:44',NULL,'2025-12-06 07:14:44',NULL,NULL),(288,NULL,'6e9f9bf28d894bf5945c431333ed76da',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:14:45',NULL,'2025-12-06 07:14:45',NULL,NULL),(289,NULL,'9b693354f7db4a0eb127bf2915dd342e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:14:45',NULL,'2025-12-06 07:14:45',NULL,NULL),(290,NULL,NULL,'bdd7994b0ebb4035a373b6560aa7dbcf',NULL,NULL,NULL,NULL,'2025-12-06 07:14:56',NULL,'2025-12-06 07:14:56',NULL,NULL),(291,NULL,'af7365adc05f4624a08a71cd5a77ada6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:14:57',NULL,'2025-12-06 07:14:57',NULL,NULL),(292,NULL,NULL,'26c40f188ec748a3a0c954e74fe334e3',NULL,NULL,NULL,NULL,'2025-12-06 07:15:00',NULL,'2025-12-06 07:15:00',NULL,NULL),(293,NULL,'e365255aaae247aab829eb45f2ec7566',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:15:05',NULL,'2025-12-06 07:15:05',NULL,NULL),(294,NULL,NULL,'79646773d83f4dc2a8e3afe20ccaa2ca',NULL,NULL,NULL,NULL,'2025-12-06 07:15:09',NULL,'2025-12-06 07:15:09',NULL,NULL),(295,NULL,'35246c3a0dec48fb8d7b60960b373d5d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:15:11',NULL,'2025-12-06 07:15:11',NULL,NULL),(296,NULL,NULL,'60c8cae0bd8d40059b7dc1f903f672b0',NULL,NULL,NULL,NULL,'2025-12-06 07:16:00',NULL,'2025-12-06 07:16:00',NULL,NULL),(297,NULL,'72a7e6711aab4e1eadba6423fa038649',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:16:01',NULL,'2025-12-06 07:16:01',NULL,NULL),(298,NULL,NULL,'67604a2c995248f8931119287d416e1c',NULL,NULL,NULL,NULL,'2025-12-06 07:16:35',NULL,'2025-12-06 07:16:35',NULL,NULL),(299,NULL,'4ba80f0b33d04d6d9508bc18e9b1914b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:16:35',NULL,'2025-12-06 07:16:35',NULL,NULL),(300,NULL,NULL,'360b73532ab84aa88ddcf2826824350a',NULL,NULL,NULL,NULL,'2025-12-06 07:16:59',NULL,'2025-12-06 07:16:59',NULL,NULL),(301,NULL,'b446d455a24e402d956714a5a5fe94b5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:17:02',NULL,'2025-12-06 07:17:02',NULL,NULL),(302,NULL,NULL,'bc90c28aab6c4b1d8e2d984f532d7894',NULL,NULL,NULL,NULL,'2025-12-06 07:18:02',NULL,'2025-12-06 07:18:02',NULL,NULL),(303,NULL,'a369472476f14c5db73734ea0b24ecf0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:18:03',NULL,'2025-12-06 07:18:03',NULL,NULL),(304,NULL,NULL,'197a9b0ee1db487d82542eb31e84f33e',NULL,NULL,NULL,NULL,'2025-12-06 07:19:05',NULL,'2025-12-06 07:19:05',NULL,NULL),(305,NULL,NULL,'ec3a55f6b65144e880cad944b8645bdc',NULL,NULL,NULL,NULL,'2025-12-06 07:19:05',NULL,'2025-12-06 07:19:05',NULL,NULL),(306,NULL,'57f9359057914603a84563a5cd22b1e6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:19:07',NULL,'2025-12-06 07:19:07',NULL,NULL),(307,NULL,'8f938a037b8141cf9408cbf6f5cd081d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:19:08',NULL,'2025-12-06 07:19:08',NULL,NULL),(308,NULL,NULL,'f4715802a0b24079b4ca157db07e1d75',NULL,NULL,NULL,NULL,'2025-12-06 07:19:44',NULL,'2025-12-06 07:19:44',NULL,NULL),(309,NULL,'6c6696bf390d4cc5bfd9852d5b264b5a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:19:45',NULL,'2025-12-06 07:19:45',NULL,NULL),(310,NULL,NULL,'3af050664af642888620680c329441c5',NULL,NULL,NULL,NULL,'2025-12-06 07:20:00',NULL,'2025-12-06 07:20:00',NULL,NULL),(311,NULL,'08ea3b6ed6c24b0f87e477586001ac99',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:20:01',NULL,'2025-12-06 07:20:01',NULL,NULL),(312,NULL,NULL,'06f5b46553b24b39a1493d96ec4e503e',NULL,NULL,NULL,NULL,'2025-12-06 07:20:36',NULL,'2025-12-06 07:20:36',NULL,NULL),(313,NULL,'35df5125c2cf4d29a6b975951af14910',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:20:37',NULL,'2025-12-06 07:20:37',NULL,NULL),(314,NULL,NULL,'3ecd49377e5d4777bf6bc093c1cea59a',NULL,NULL,NULL,NULL,'2025-12-06 07:20:39',NULL,'2025-12-06 07:20:39',NULL,NULL),(315,NULL,'72dfb73f46434d30b1b9570f02d58901',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:20:41',NULL,'2025-12-06 07:20:41',NULL,NULL),(316,NULL,NULL,'585886c5d2044f729963a6485c93acd5',NULL,NULL,NULL,NULL,'2025-12-06 07:21:09',NULL,'2025-12-06 07:21:09',NULL,NULL),(317,NULL,'a16333d9a99c4d4ba7c9a1c235b6219b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:21:10',NULL,'2025-12-06 07:21:10',NULL,NULL),(318,NULL,NULL,'e3d8ea3dcb5b4ee3b9bd24c62fdd61b2',NULL,NULL,NULL,NULL,'2025-12-06 07:21:18',NULL,'2025-12-06 07:21:18',NULL,NULL),(319,NULL,'da41861044a74eee9bc96841e54c57cc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:21:18',NULL,'2025-12-06 07:21:18',NULL,NULL),(320,NULL,NULL,'627c36bb63534e52a4b1d5adf47e6ffd',NULL,NULL,NULL,NULL,'2025-12-06 07:21:53',NULL,'2025-12-06 07:21:53',NULL,NULL),(321,NULL,'929e2be1488d4b80b7ad8946093a6abe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:21:54',NULL,'2025-12-06 07:21:54',NULL,NULL),(322,NULL,NULL,'a52e2b4388994d8791443483bd42cc33',NULL,NULL,NULL,NULL,'2025-12-06 07:22:19',NULL,'2025-12-06 07:22:19',NULL,NULL),(323,NULL,'b558585a6aa14470bdad319926a98046',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:22:19',NULL,'2025-12-06 07:22:19',NULL,NULL),(324,NULL,NULL,'533d567dcaba4c8dbb23aaf04f662dcb',NULL,NULL,NULL,NULL,'2025-12-06 07:22:24',NULL,'2025-12-06 07:22:24',NULL,NULL),(325,NULL,'bb68240dfcb046d4a9c84fa861aef5b6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:22:25',NULL,'2025-12-06 07:22:25',NULL,NULL),(326,NULL,NULL,'19dfacbc6d334cada6c8eed809adafe2',NULL,NULL,NULL,NULL,'2025-12-06 07:22:28',NULL,'2025-12-06 07:22:28',NULL,NULL),(327,NULL,'d7dd2f88c9ba41b6baa5e20db9002858',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:22:29',NULL,'2025-12-06 07:22:29',NULL,NULL),(328,NULL,NULL,'c2404fce4d1f48779c97d3cbcb6ae594',NULL,NULL,NULL,NULL,'2025-12-06 07:23:12',NULL,'2025-12-06 07:23:12',NULL,NULL),(329,NULL,NULL,'a4c1218897b74f3eae8af9b1f5935e4a',NULL,NULL,NULL,NULL,'2025-12-06 07:23:13',NULL,'2025-12-06 07:23:13',NULL,NULL),(330,NULL,'8cfb29a59e0448bcbe30cc5481e8197c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:23:13',NULL,'2025-12-06 07:23:13',NULL,NULL),(331,NULL,'9536676f60844b6f802518771f02409f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:23:15',NULL,'2025-12-06 07:23:15',NULL,NULL),(332,NULL,NULL,'ca0a4a5ab2bb41298078e4d8c601925f',NULL,NULL,NULL,NULL,'2025-12-06 07:23:17',NULL,'2025-12-06 07:23:17',NULL,NULL),(333,NULL,'597285dcf6f141219338afe733e28a2a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:23:18',NULL,'2025-12-06 07:23:18',NULL,NULL),(334,NULL,NULL,'d0385d6c425a4b6ca71336ef4a2beb43',NULL,NULL,NULL,NULL,'2025-12-06 07:24:06',NULL,'2025-12-06 07:24:06',NULL,NULL),(335,NULL,'76ed0aa861fd42da90bbded63873a563',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:24:07',NULL,'2025-12-06 07:24:07',NULL,NULL),(336,NULL,NULL,'bf140baee82f408e8fafa81062146641',NULL,NULL,NULL,NULL,'2025-12-06 07:27:24',NULL,'2025-12-06 07:27:24',NULL,NULL),(337,NULL,'c5036a5cbf7d44fd809d00942afd76e6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:27:26',NULL,'2025-12-06 07:27:26',NULL,NULL),(338,NULL,NULL,'d966fefcb38a45219b9cc637c46a3d62',NULL,NULL,NULL,NULL,'2025-12-06 07:27:41',NULL,'2025-12-06 07:27:41',NULL,NULL),(339,NULL,'c6d2f50c0db54315bfa96a24511dda90',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:27:43',NULL,'2025-12-06 07:27:43',NULL,NULL),(340,NULL,NULL,'f6f0d78959484986bab10b40c84e9406',NULL,NULL,NULL,NULL,'2025-12-06 07:30:12',NULL,'2025-12-06 07:30:12',NULL,NULL),(341,NULL,'036c977b26cc46cabc5f599cb6c00e9a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:30:14',NULL,'2025-12-06 07:30:14',NULL,NULL),(342,NULL,NULL,'d67c136e82ad4001b000848d75eef50d',NULL,NULL,NULL,NULL,'2025-12-06 07:30:16',NULL,'2025-12-06 07:30:16',NULL,NULL),(343,NULL,'88f5b34244614321a9b6e902eaba0ece',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:30:17',NULL,'2025-12-06 07:30:17',NULL,NULL),(344,NULL,NULL,'baddb65c90da47a58d026b0db966f6c8',NULL,NULL,NULL,NULL,'2025-12-06 07:30:44',NULL,'2025-12-06 07:30:44',NULL,NULL),(345,NULL,'001e2256cb8b430d93c1ff613010d199',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:30:45',NULL,'2025-12-06 07:30:45',NULL,NULL),(346,NULL,NULL,'c3e74d72d7114a37b1fa3e366712c49e',NULL,NULL,NULL,NULL,'2025-12-06 07:31:33',NULL,'2025-12-06 07:31:33',NULL,NULL),(347,NULL,'c7c878bda5244b67976c298fc026bbcd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:31:34',NULL,'2025-12-06 07:31:34',NULL,NULL),(348,NULL,NULL,'ba221a62b5d5452c80ef6e9223ab018d',NULL,NULL,NULL,NULL,'2025-12-06 07:31:42',NULL,'2025-12-06 07:31:42',NULL,NULL),(349,NULL,NULL,'a4f3cac602f942718452b29d8ede4536',NULL,NULL,NULL,NULL,'2025-12-06 07:31:43',NULL,'2025-12-06 07:31:43',NULL,NULL),(350,NULL,'7f577827abb5458f902bb5d5580b7d69',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:31:43',NULL,'2025-12-06 07:31:43',NULL,NULL),(351,NULL,'a739117bee9940b0a047ef0dfc826f46',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:31:46',NULL,'2025-12-06 07:31:46',NULL,NULL),(352,NULL,NULL,'b3cda409ca8d4dd7abf40dd53f29b399',NULL,NULL,NULL,NULL,'2025-12-06 07:31:48',NULL,'2025-12-06 07:31:48',NULL,NULL),(353,NULL,'c2726ab824e34c9bb00126313f7adc1f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:31:50',NULL,'2025-12-06 07:31:50',NULL,NULL),(354,NULL,NULL,'cc3f479307934ec98b7cf7922906d4c6',NULL,NULL,NULL,NULL,'2025-12-06 07:31:52',NULL,'2025-12-06 07:31:52',NULL,NULL),(355,NULL,'a7ed8984dbc547e098d541218a39bab6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:31:54',NULL,'2025-12-06 07:31:54',NULL,NULL),(356,NULL,NULL,'3f95d5fc3ae84153badf13157ceaf23e',NULL,NULL,NULL,NULL,'2025-12-06 07:33:02',NULL,'2025-12-06 07:33:02',NULL,NULL),(357,NULL,'39801d5920c640488d08116f4121fc25',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:33:04',NULL,'2025-12-06 07:33:04',NULL,NULL),(358,NULL,NULL,'8e5d532f4af34acc9e3a7a08819bb089',NULL,NULL,NULL,NULL,'2025-12-06 07:33:31',NULL,'2025-12-06 07:33:31',NULL,NULL),(359,NULL,NULL,'b81b45db6db645a2b55687d7c3f51d68',NULL,NULL,NULL,NULL,'2025-12-06 07:33:31',NULL,'2025-12-06 07:33:31',NULL,NULL),(360,NULL,'1a5dd5f9ca5747618b386c87a40ede88',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:33:33',NULL,'2025-12-06 07:33:33',NULL,NULL),(361,NULL,'7c32a01bcfc2424baad93ca18a0ec925',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:33:35',NULL,'2025-12-06 07:33:35',NULL,NULL),(362,NULL,NULL,'bb72a3e638064a9896ab40615cfc7d67',NULL,NULL,NULL,NULL,'2025-12-06 07:34:29',NULL,'2025-12-06 07:34:29',NULL,NULL),(363,NULL,'1b09bb22417b499cbf8771188f7ae36f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:34:29',NULL,'2025-12-06 07:34:29',NULL,NULL),(364,NULL,NULL,'603967295b474367b2a605071d414bbf',NULL,NULL,NULL,NULL,'2025-12-06 07:36:12',NULL,'2025-12-06 07:36:12',NULL,NULL),(365,NULL,'2cfa2f2dfd6f4dc090f85672b1f24e68',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:36:14',NULL,'2025-12-06 07:36:14',NULL,NULL),(366,NULL,NULL,'7960f8f407754e5d83bee65690a6b772',NULL,NULL,NULL,NULL,'2025-12-06 07:39:43',NULL,'2025-12-06 07:39:43',NULL,NULL),(367,NULL,'21cd37bffa864aaebe5c734ba468f466',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:39:46',NULL,'2025-12-06 07:39:46',NULL,NULL),(368,NULL,NULL,'2f3bfc62663b415caedcd269c56412be',NULL,NULL,NULL,NULL,'2025-12-06 07:40:17',NULL,'2025-12-06 07:40:17',NULL,NULL),(369,NULL,NULL,'2aa5b15c15f84a8cb24776d5c781eb09',NULL,NULL,NULL,NULL,'2025-12-06 07:40:19',NULL,'2025-12-06 07:40:19',NULL,NULL),(370,NULL,'17906cc84c6c4f43b1a09758e5552c63',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:40:22',NULL,'2025-12-06 07:40:22',NULL,NULL),(371,NULL,'17cdfa63c4424ec7a0eb4bb3d7372c14',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:40:22',NULL,'2025-12-06 07:40:22',NULL,NULL),(372,NULL,NULL,'605b5481e0c944048e6a67046c30d693',NULL,NULL,NULL,NULL,'2025-12-06 07:41:00',NULL,'2025-12-06 07:41:00',NULL,NULL),(373,NULL,'833f4cf9f5a64b2ab94c3bf330353a31',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:41:02',NULL,'2025-12-06 07:41:02',NULL,NULL),(374,NULL,NULL,'23cdebcd22d647eb808445dbd33d4f04',NULL,NULL,NULL,NULL,'2025-12-06 07:41:15',NULL,'2025-12-06 07:41:15',NULL,NULL),(375,NULL,'28f1acf1ee4b40f695e30ee36e56b9d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:41:16',NULL,'2025-12-06 07:41:16',NULL,NULL),(376,NULL,NULL,'9419977a15f540f09b213cf3ee9019ba',NULL,NULL,NULL,NULL,'2025-12-06 07:41:35',NULL,'2025-12-06 07:41:35',NULL,NULL),(377,NULL,'1e455c27d6274596a394266e9e2ea7fe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:41:36',NULL,'2025-12-06 07:41:36',NULL,NULL),(378,NULL,NULL,'05dfe700f5a141638f3ecb185261858e',NULL,NULL,NULL,NULL,'2025-12-06 07:42:27',NULL,'2025-12-06 07:42:27',NULL,NULL),(379,NULL,'765a234f3c484ca28bf25e21cff07bd1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:42:28',NULL,'2025-12-06 07:42:28',NULL,NULL),(380,NULL,NULL,'a70f6c3c5e2c402bb6fa0e0507e9b6dc',NULL,NULL,NULL,NULL,'2025-12-06 07:42:55',NULL,'2025-12-06 07:42:55',NULL,NULL),(381,NULL,'b10aa03d68eb4d4799d53538521cc364',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:42:57',NULL,'2025-12-06 07:42:57',NULL,NULL),(382,NULL,NULL,'8b7e1fb80daa458699ec19892dc9a92c',NULL,NULL,NULL,NULL,'2025-12-06 07:43:28',NULL,'2025-12-06 07:43:28',NULL,NULL),(383,NULL,NULL,'aab6b3c980644130954c2f7ad7e0df23',NULL,NULL,NULL,NULL,'2025-12-06 07:43:28',NULL,'2025-12-06 07:43:28',NULL,NULL),(384,NULL,'6061a73c34904608870b68e204d01c42',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:43:29',NULL,'2025-12-06 07:43:29',NULL,NULL),(385,NULL,NULL,'0d8b62a3276f4a8b8349af67b82134c8',NULL,NULL,NULL,NULL,'2025-12-06 07:44:30',NULL,'2025-12-06 07:44:30',NULL,NULL),(386,NULL,NULL,'9812a08676d24dd3b9debb0af69a18bd',NULL,NULL,NULL,NULL,'2025-12-06 07:44:31',NULL,'2025-12-06 07:44:31',NULL,NULL),(387,NULL,'eff1f6a1654b45079de20eddb830e76d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:44:34',NULL,'2025-12-06 07:44:34',NULL,NULL),(388,NULL,NULL,'ea0c2e89d39744778d7bbb99f8dc9934',NULL,NULL,NULL,NULL,'2025-12-06 07:45:20',NULL,'2025-12-06 07:45:20',NULL,NULL),(389,NULL,'c9ca41d51b00465db7923ccd90b0b1fe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:45:23',NULL,'2025-12-06 07:45:23',NULL,NULL),(390,NULL,NULL,'a409ddd6936b48a48db04fb82f3b940f',NULL,NULL,NULL,NULL,'2025-12-06 07:45:31',NULL,'2025-12-06 07:45:31',NULL,NULL),(391,NULL,'e2225aa797064772bb586851cb354868',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:45:32',NULL,'2025-12-06 07:45:32',NULL,NULL),(392,NULL,NULL,'d0ccbbf5f3da4654a5c9919be9b8a2bb',NULL,NULL,NULL,NULL,'2025-12-06 07:45:37',NULL,'2025-12-06 07:45:37',NULL,NULL),(393,NULL,'00a24842329842059aee8ff6e53c0c00',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:45:39',NULL,'2025-12-06 07:45:39',NULL,NULL),(394,NULL,NULL,'823b61c4027c48dc9b8f4e41bca5cf83',NULL,NULL,NULL,NULL,'2025-12-06 07:45:58',NULL,'2025-12-06 07:45:58',NULL,NULL),(395,NULL,'5dcd2d068ff04070b59e12a2cd84f89c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:46:00',NULL,'2025-12-06 07:46:00',NULL,NULL),(396,NULL,NULL,'297bc99c242e4fa8aedea4a6367b61c0',NULL,NULL,NULL,NULL,'2025-12-06 07:46:10',NULL,'2025-12-06 07:46:10',NULL,NULL),(397,NULL,'741dc47f9ced423cbd99fd6f9d32904f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:46:10',NULL,'2025-12-06 07:46:10',NULL,NULL),(398,NULL,NULL,'45451a914c994cd69359ed7c4e71ec0a',NULL,NULL,NULL,NULL,'2025-12-06 07:46:24',NULL,'2025-12-06 07:46:24',NULL,NULL),(399,NULL,'40da133fd2cc44f4b03dfcaa8d2a67a6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:46:26',NULL,'2025-12-06 07:46:26',NULL,NULL),(400,NULL,NULL,'f07b7cee08124c2c920bca285679cfd8',NULL,NULL,NULL,NULL,'2025-12-06 07:46:30',NULL,'2025-12-06 07:46:30',NULL,NULL),(401,NULL,'edb53b663ad74999b9a21956d5926997',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:46:31',NULL,'2025-12-06 07:46:31',NULL,NULL),(402,NULL,NULL,'1035ecd55ed54b57aa35fe32fb915cc5',NULL,NULL,NULL,NULL,'2025-12-06 07:47:40',NULL,'2025-12-06 07:47:40',NULL,NULL),(403,NULL,'4ec9294f6d4b4f44a72414374d646a4a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:47:42',NULL,'2025-12-06 07:47:42',NULL,NULL),(404,NULL,NULL,'5933a27f4e504e23a5d084501196c0fb',NULL,NULL,NULL,NULL,'2025-12-06 07:48:48',NULL,'2025-12-06 07:48:48',NULL,NULL),(405,NULL,NULL,'4216dff085a14493b897b828aff7c9d1',NULL,NULL,NULL,NULL,'2025-12-06 07:48:49',NULL,'2025-12-06 07:48:49',NULL,NULL),(406,NULL,NULL,'e997a5eeee174b368a43ed8cb35fa1d0',NULL,NULL,NULL,NULL,'2025-12-06 07:48:49',NULL,'2025-12-06 07:48:49',NULL,NULL),(407,NULL,'f44ecb8bdc7e4692a299e29603301124',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:48:52',NULL,'2025-12-06 07:48:52',NULL,NULL),(408,NULL,'d54b90702fda48b79c07b0ab03037ff8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:48:52',NULL,'2025-12-06 07:48:52',NULL,NULL),(409,NULL,NULL,'89d63d29c7534f70817e13d23cada716',NULL,NULL,NULL,NULL,'2025-12-06 07:48:53',NULL,'2025-12-06 07:48:53',NULL,NULL),(410,NULL,NULL,'e0d40cf783d345ad9129d656d5ebf5eb',NULL,NULL,NULL,NULL,'2025-12-06 07:48:53',NULL,'2025-12-06 07:48:53',NULL,NULL),(411,NULL,'329d4c9562c84ec5a42ca68894cbf27f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:48:53',NULL,'2025-12-06 07:48:53',NULL,NULL),(412,NULL,'abe27bc772a44e19b38413cebe8cdf6e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:48:54',NULL,'2025-12-06 07:48:54',NULL,NULL),(413,NULL,'f093eaeb91c042dd8c85f5cd256c4394',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:48:59',NULL,'2025-12-06 07:48:59',NULL,NULL),(414,NULL,NULL,'f1ecb7cb2b5e454d80f5a0ba9240a894',NULL,NULL,NULL,NULL,'2025-12-06 07:50:00',NULL,'2025-12-06 07:50:00',NULL,NULL),(415,NULL,NULL,'19fb60d080644bb58cd252135dc177a3',NULL,NULL,NULL,NULL,'2025-12-06 07:50:01',NULL,'2025-12-06 07:50:01',NULL,NULL),(416,NULL,'86b361be239c42758c8ab85ae6854857',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:50:02',NULL,'2025-12-06 07:50:02',NULL,NULL),(417,NULL,'f6a50bd5901d4c03a893841d8ecbbe05',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:50:04',NULL,'2025-12-06 07:50:04',NULL,NULL),(418,NULL,NULL,'4962bc7b172346e19d127b46ea2d7a11',NULL,NULL,NULL,NULL,'2025-12-06 07:53:36',NULL,'2025-12-06 07:53:36',NULL,NULL),(419,NULL,NULL,'8854f445147140bb9f70c865bd7a5570',NULL,NULL,NULL,NULL,'2025-12-06 07:53:36',NULL,'2025-12-06 07:53:36',NULL,NULL),(420,NULL,'c4cf19b89a6d46bca307e65731a9dd21',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:53:37',NULL,'2025-12-06 07:53:37',NULL,NULL),(421,NULL,'5a852aeea58a40189a7760e7a72cc320',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:53:38',NULL,'2025-12-06 07:53:38',NULL,NULL),(422,NULL,NULL,'f2335740042045fba7f544ee5140eb87',NULL,NULL,NULL,NULL,'2025-12-06 07:54:06',NULL,'2025-12-06 07:54:06',NULL,NULL),(423,NULL,'4842ecff6dce4ccc981a6b65a14ea406',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:08',NULL,'2025-12-06 07:54:08',NULL,NULL),(424,NULL,NULL,'0a1c97d262cb4a169f24c8530e92a4bd',NULL,NULL,NULL,NULL,'2025-12-06 07:54:12',NULL,'2025-12-06 07:54:12',NULL,NULL),(425,NULL,NULL,'3e4b100361994bcaaf9e1caf376dae11',NULL,NULL,NULL,NULL,'2025-12-06 07:54:12',NULL,'2025-12-06 07:54:12',NULL,NULL),(426,NULL,'601bd3abef1d42a395fd825bc79d65a6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:13',NULL,'2025-12-06 07:54:13',NULL,NULL),(427,NULL,NULL,'1826add887e94704ba1646265eca8c41',NULL,NULL,NULL,NULL,'2025-12-06 07:54:16',NULL,'2025-12-06 07:54:16',NULL,NULL),(428,NULL,'3c50c143349a4204bd8bb082def8f951',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:18',NULL,'2025-12-06 07:54:18',NULL,NULL),(429,NULL,NULL,'0f669e963dc54ad7bebf8dd20341428a',NULL,NULL,NULL,NULL,'2025-12-06 07:54:34',NULL,'2025-12-06 07:54:34',NULL,NULL),(430,NULL,NULL,'d7590ca567194977a7a5af285a5d4490',NULL,NULL,NULL,NULL,'2025-12-06 07:54:35',NULL,'2025-12-06 07:54:35',NULL,NULL),(431,NULL,'de8bd7edd9df4459926125c8c38e96ba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:36',NULL,'2025-12-06 07:54:36',NULL,NULL),(432,NULL,'0c8fc5bc237e42bfad505a0bca6681eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:37',NULL,'2025-12-06 07:54:37',NULL,NULL),(433,NULL,NULL,'90c9de6e67724c898a8e23b05fbf14da',NULL,NULL,NULL,NULL,'2025-12-06 07:54:52',NULL,'2025-12-06 07:54:52',NULL,NULL),(434,NULL,'cfa713d92cc94fa1b94404ed58b0563f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:54:53',NULL,'2025-12-06 07:54:53',NULL,NULL),(435,NULL,NULL,'383c99c13fb24b039259ed88ae2f32c0',NULL,NULL,NULL,NULL,'2025-12-06 07:56:05',NULL,'2025-12-06 07:56:05',NULL,NULL),(436,NULL,NULL,'32a8737480e34eb894732cfdccea6565',NULL,NULL,NULL,NULL,'2025-12-06 07:56:06',NULL,'2025-12-06 07:56:06',NULL,NULL),(437,NULL,'2b02ca2bf61d48d99724e6446cfd3524',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:56:06',NULL,'2025-12-06 07:56:06',NULL,NULL),(438,NULL,'cf270650c1cb4d06b38470ec0875cc0b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:56:07',NULL,'2025-12-06 07:56:07',NULL,NULL),(439,NULL,NULL,'0ce6d0a8def6432aa60891ea00ef9d8b',NULL,NULL,NULL,NULL,'2025-12-06 07:58:34',NULL,'2025-12-06 07:58:34',NULL,NULL),(440,NULL,'63df107b8bd14504974c75ba92ae469b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:58:36',NULL,'2025-12-06 07:58:36',NULL,NULL),(441,NULL,NULL,'e685a049c8a74aa8aea831fbdaf2acf8',NULL,NULL,NULL,NULL,'2025-12-06 07:58:38',NULL,'2025-12-06 07:58:38',NULL,NULL),(442,NULL,NULL,'f0af457c21324be39dc45f9aae88d2eb',NULL,NULL,NULL,NULL,'2025-12-06 07:58:38',NULL,'2025-12-06 07:58:38',NULL,NULL),(443,NULL,'7897ac8b4a26447b8d75f85b0578fcbe',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:58:40',NULL,'2025-12-06 07:58:40',NULL,NULL),(444,NULL,'6164fee998c94b71a37886fe42b4c56c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 07:58:41',NULL,'2025-12-06 07:58:41',NULL,NULL),(445,NULL,NULL,'98e657096e3f4b528cd461a3dd6a750e',NULL,NULL,NULL,NULL,'2025-12-06 08:01:43',NULL,'2025-12-06 08:01:43',NULL,NULL),(446,NULL,NULL,'ccd15a8a00c94d79b00deae6cfd505fa',NULL,NULL,NULL,NULL,'2025-12-06 08:01:44',NULL,'2025-12-06 08:01:44',NULL,NULL),(447,NULL,'c3c0564f8e9f4af9ae5b597a275c989f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:01:46',NULL,'2025-12-06 08:01:46',NULL,NULL),(448,NULL,'308732bb782c40d1a3eba8e229e0ebae',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:01:50',NULL,'2025-12-06 08:01:50',NULL,NULL),(449,NULL,NULL,'2ed2d17026504d70b893923a85cece4d',NULL,NULL,NULL,NULL,'2025-12-06 08:15:05',NULL,'2025-12-06 08:15:05',NULL,NULL),(450,NULL,NULL,'1bdbfd9a9c034d4baf0368c23697a002',NULL,NULL,NULL,NULL,'2025-12-06 08:15:05',NULL,'2025-12-06 08:15:05',NULL,NULL),(451,NULL,'fd8e24e430c64364ace789d88a68ba5f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:15:06',NULL,'2025-12-06 08:15:06',NULL,NULL),(452,NULL,'0280d2f586294ccf97547f8bc41590f8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:15:07',NULL,'2025-12-06 08:15:07',NULL,NULL),(453,NULL,NULL,'d5359905348247d0b9b5b95982e890bb',NULL,NULL,NULL,NULL,'2025-12-06 08:15:21',NULL,'2025-12-06 08:15:21',NULL,NULL),(454,NULL,NULL,'d44fefa5b2244329a8e4bf722f060285',NULL,NULL,NULL,NULL,'2025-12-06 08:15:22',NULL,'2025-12-06 08:15:22',NULL,NULL),(455,NULL,'3fa1df60a3e7467ba78773985f86c65a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:15:24',NULL,'2025-12-06 08:15:24',NULL,NULL),(456,NULL,'f4735a799c84437b9dd4ea8778ad2fbb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:15:26',NULL,'2025-12-06 08:15:26',NULL,NULL),(457,NULL,NULL,'8e8feb4540af4e2caa45a88a9202dbe2',NULL,NULL,NULL,NULL,'2025-12-06 08:22:43',NULL,'2025-12-06 08:22:43',NULL,NULL),(458,NULL,NULL,'92f62b218a13470ebe85846ca2ad273d',NULL,NULL,NULL,NULL,'2025-12-06 08:22:43',NULL,'2025-12-06 08:22:43',NULL,NULL),(459,NULL,'d94c1b0341fb439a80ac945516b48f57',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:22:46',NULL,'2025-12-06 08:22:46',NULL,NULL),(460,NULL,'4b2dc4b8729f446a9c7ac69ca446f71d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:22:46',NULL,'2025-12-06 08:22:46',NULL,NULL),(461,NULL,NULL,'0432cb6633e14c1b86fc320e7f3bb880',NULL,NULL,NULL,NULL,'2025-12-06 08:24:45',NULL,'2025-12-06 08:24:45',NULL,NULL),(462,NULL,NULL,'e07a31bfb9584e07a5620ecf91e88a4b',NULL,NULL,NULL,NULL,'2025-12-06 08:24:45',NULL,'2025-12-06 08:24:45',NULL,NULL),(463,NULL,NULL,'9e20cb39ac8c4c6fb656df6382cb7d2f',NULL,NULL,NULL,NULL,'2025-12-06 08:24:46',NULL,'2025-12-06 08:24:46',NULL,NULL),(464,NULL,'5d23d1d6ffc142eaa9bee0ef93fe60e4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:24:47',NULL,'2025-12-06 08:24:47',NULL,NULL),(465,NULL,'c9b819f443be4cbe852a843ef1c9e3c7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:24:48',NULL,'2025-12-06 08:24:48',NULL,NULL),(466,NULL,'808cb5928c7d484b912429e790466822',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:24:49',NULL,'2025-12-06 08:24:49',NULL,NULL),(467,NULL,NULL,'ebd2983853994f2684b4bba5a9593dd0',NULL,NULL,NULL,NULL,'2025-12-06 08:25:36',NULL,'2025-12-06 08:25:36',NULL,NULL),(468,NULL,NULL,'ecd11309ac6745a798ee4c16d479bb9c',NULL,NULL,NULL,NULL,'2025-12-06 08:25:36',NULL,'2025-12-06 08:25:36',NULL,NULL),(469,NULL,'d82b0e57c7a246a7abb3cc909b561513',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:25:37',NULL,'2025-12-06 08:25:37',NULL,NULL),(470,NULL,'82f4e46f4649433f865b09c2320be75a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:25:38',NULL,'2025-12-06 08:25:38',NULL,NULL),(471,NULL,NULL,'bd1af433dad948599352db2e972a676c',NULL,NULL,NULL,NULL,'2025-12-06 08:26:44',NULL,'2025-12-06 08:26:44',NULL,NULL),(472,NULL,NULL,'4989b6252b64443aaec21b075dbc29d9',NULL,NULL,NULL,NULL,'2025-12-06 08:26:44',NULL,'2025-12-06 08:26:44',NULL,NULL),(473,NULL,'7102dcd5b58d4dec801a71dacc60eaaf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:26:44',NULL,'2025-12-06 08:26:44',NULL,NULL),(474,NULL,'41c7ac10745449b3a23d724093a203c1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:26:45',NULL,'2025-12-06 08:26:45',NULL,NULL),(475,NULL,NULL,'7be04794e78b4de6b2a80b1b2a0da164',NULL,NULL,NULL,NULL,'2025-12-06 08:27:05',NULL,'2025-12-06 08:27:05',NULL,NULL),(476,NULL,NULL,'1ffbaf8457854c799ed970d87e9eeffc',NULL,NULL,NULL,NULL,'2025-12-06 08:27:05',NULL,'2025-12-06 08:27:05',NULL,NULL),(477,NULL,'5ef773fb7e9142da81519dc5041efb8b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:27:06',NULL,'2025-12-06 08:27:06',NULL,NULL),(478,NULL,NULL,'00e2fea2f8f54b1c9af85553820566a6',NULL,NULL,NULL,NULL,'2025-12-06 08:28:34',NULL,'2025-12-06 08:28:34',NULL,NULL),(479,NULL,NULL,'a35dc253ff7c44dfa147ca05c6d87381',NULL,NULL,NULL,NULL,'2025-12-06 08:28:35',NULL,'2025-12-06 08:28:35',NULL,NULL),(480,NULL,'55d0236410514dd9ad6cdb3e1a5d0ee6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:28:35',NULL,'2025-12-06 08:28:35',NULL,NULL),(481,NULL,'4b132159e8584a398e71edc1d82f2d1a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 08:28:36',NULL,'2025-12-06 08:28:36',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('2297c0e5be154dbebc7f06df0865708c','reader','{}','<<null>>',NULL),('6c53f0db31ef4d12a4b9c81254d400bb','ResellerAdmin','{}','<<null>>',NULL),('71e8014d856149b8b848710bb2692df2','swiftoperator','{}','<<null>>',NULL),('75c57372495a4225abb3dbc4f7f9e530','admin','{}','<<null>>',NULL),('c449766ccbe34b22b7ebca739e5a7690','member','{}','<<null>>',NULL),('c8ea18b6064c40c791d4f23ccb1762a8','service','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('2297c0e5be154dbebc7f06df0865708c','IMMU','true'),('75c57372495a4225abb3dbc4f7f9e530','IMMU','true'),('c449766ccbe34b22b7ebca739e5a7690','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('0002f4d1682740549204c340e0008915','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('44ae7abb01044f81953b9ce8a0a661b9','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('466def2f045e4fd2a721cc56fc6ac608','identity',1,'{\"name\": \"keystone\"}'),('5360ade0728247ae9415cea79e88828f','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}'),('828cd701c6ea4714bab3484afe50e4cb','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('8c77ba74dabf4523be64d6a39fb611ae','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('b0ad0351a14e492a8f14ef74c4275bcb','object-store',1,'{\"name\": \"swift\", \"description\": \"OpenStack Object Storage\"}'),('b29f2b3933974c3491bcb338e546687e','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('c23d386bd1284033a502616abbd0bd93','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','05522e78304c4c4eb4be044936c2fa3e','system','75c57372495a4225abb3dbc4f7f9e530',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('05522e78304c4c4eb4be044936c2fa3e','{}',1,NULL,'2025-12-06 06:09:15','2025-12-06','default'),('0c7273e6d9c9413aaf1939a555f98d43','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:16','2025-12-06','default'),('10d8005d16834ef79aa0a18f4f12aed4','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:34','2025-12-06','default'),('24082ac6496f4383ae58462e38fb76da','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:28','2025-12-06','default'),('442c3a4401884580a5658964942c5472','{\"tenantId\": \"95663129bada415eba2b8562f5a23e2a\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 06:56:06',NULL,'default'),('9b3b4521d53f41ee909faead65f3c704','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:23','2025-12-06','default'),('c40fca403a64496ab31b4e2ebf5d74c4','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:41','2025-12-06','default'),('dc3c916f09ac4f91b8e6a3247de028c1','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:47','2025-12-06','default'),('f38aca50c0714fbe9b6c2b0731af9373','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:30:25',NULL,'default'),('f52e47aca4ef465ca8e14c4032520ac6','{\"tenantId\": \"6428a925613245eebefa379bad924d3c\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 06:56:02',NULL,'default'),('fe5320efd8664ae5bc09c39f39d3dbf1','{}',1,'6363f866b688477296a48bc0eb3789ff','2025-12-06 06:10:19','2025-12-06','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `mysql`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `mysql` /*!40100 DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci */;

USE `mysql`;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumtext NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` bigint(20) unsigned NOT NULL,
  `rows_examined` bigint(20) unsigned NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `rows_affected` bigint(20) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `column_stats`
--

DROP TABLE IF EXISTS `column_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `column_stats` (
  `db_name` varchar(64) NOT NULL,
  `table_name` varchar(64) NOT NULL,
  `column_name` varchar(64) NOT NULL,
  `min_value` varbinary(255) DEFAULT NULL,
  `max_value` varbinary(255) DEFAULT NULL,
  `nulls_ratio` decimal(12,4) DEFAULT NULL,
  `avg_length` decimal(12,4) DEFAULT NULL,
  `avg_frequency` decimal(12,4) DEFAULT NULL,
  `hist_size` tinyint(3) unsigned DEFAULT NULL,
  `hist_type` enum('SINGLE_PREC_HB','DOUBLE_PREC_HB') DEFAULT NULL,
  `histogram` varbinary(255) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`table_name`,`column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='Statistics on Columns';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `column_stats`
--

LOCK TABLES `column_stats` WRITE;
/*!40000 ALTER TABLE `column_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `column_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Table_name` char(64) NOT NULL DEFAULT '',
  `Column_name` char(64) NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `db` (
  `Host` char(60) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  `Delete_history_priv` enum('N','Y') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` (`Host`, `Db`, `User`, `Select_priv`, `Insert_priv`, `Update_priv`, `Delete_priv`, `Create_priv`, `Drop_priv`, `Grant_priv`, `References_priv`, `Index_priv`, `Alter_priv`, `Create_tmp_table_priv`, `Lock_tables_priv`, `Create_view_priv`, `Show_view_priv`, `Create_routine_priv`, `Alter_routine_priv`, `Execute_priv`, `Event_priv`, `Trigger_priv`, `Delete_history_priv`) VALUES ('localhost','keystone','keystone_cb97','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','keystone','keystone_cb97','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','placement','placement_6dce','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','glance','glance_b16c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','placement','placement_6dce','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','glance','glance_b16c','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','barbican','barbican_c485','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','barbican','barbican_c485','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','cinder','cinder_2de2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','cinder','cinder_2de2','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','neutron','neutron_2ead','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','neutron','neutron_2ead','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_api','nova_api_c3c0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_api','nova_api_c3c0','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('localhost','nova_cell0','nova_cell0_64c1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'),('%','nova_cell0','nova_cell0_64c1','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(141) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','IGNORE_BAD_TABLE_OPTIONS','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH','EMPTY_STRING_IS_NULL','SIMULTANEOUS_ASSIGNMENT','TIME_ROUND_FRACTIONAL') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob DEFAULT NULL,
  PRIMARY KEY (`db`,`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `func` (
  `name` char(64) NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT 0,
  `dl` char(128) NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `global_priv`
--

DROP TABLE IF EXISTS `global_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_priv` (
  `Host` char(60) NOT NULL DEFAULT '',
  `User` char(80) NOT NULL DEFAULT '',
  `Priv` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '{}' CHECK (json_valid(`Priv`)),
  PRIMARY KEY (`Host`,`User`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_bin PAGE_CHECKSUM=1 TRANSACTIONAL=1 COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_priv`
--

LOCK TABLES `global_priv` WRITE;
/*!40000 ALTER TABLE `global_priv` DISABLE KEYS */;
INSERT INTO `global_priv` (`Host`, `User`, `Priv`) VALUES ('localhost','mariadb.sys','{\"access\":0,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"\",\"account_locked\":true,\"password_last_changed\":0}'),('localhost','root','{\"access\": 549755813887, \"plugin\": \"mysql_native_password\", \"authentication_string\": \"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\", \"auth_or\": [{}],\"version_id\":100529,\"password_last_changed\":1765001278}'),('%','root','{\"access\":549755813887,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*84AAC12F54AB666ECFC2A83C676908C8BBC381B1\",\"password_last_changed\":1765001278}'),('localhost','keystone_cb97','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E4FF3B0144B3A6E1C6DA27AE85226CAF4028F6ED\",\"password_last_changed\":1765001295}'),('%','keystone_cb97','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E4FF3B0144B3A6E1C6DA27AE85226CAF4028F6ED\",\"password_last_changed\":1765001295}'),('localhost','placement_6dce','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*95F77A9BC7480D3CC0C2A89902CDF0EAF7BAB795\",\"password_last_changed\":1765001295}'),('localhost','glance_b16c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E6930EEA9D0DDCA8E627942D490D559585C6AE72\",\"password_last_changed\":1765001295}'),('%','placement_6dce','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*95F77A9BC7480D3CC0C2A89902CDF0EAF7BAB795\",\"password_last_changed\":1765001295}'),('%','glance_b16c','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*E6930EEA9D0DDCA8E627942D490D559585C6AE72\",\"password_last_changed\":1765001295}'),('localhost','barbican_c485','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*AA34821CB521981785CC43608EDDA0CC4D758EB0\",\"password_last_changed\":1765001335}'),('%','barbican_c485','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*AA34821CB521981785CC43608EDDA0CC4D758EB0\",\"password_last_changed\":1765001335}'),('localhost','cinder_2de2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*018721005687805C56D7E57CB7DDC69F32CDCBBB\",\"password_last_changed\":1765001335}'),('%','cinder_2de2','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*018721005687805C56D7E57CB7DDC69F32CDCBBB\",\"password_last_changed\":1765001335}'),('localhost','neutron_2ead','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6DB634B99C017725DF1D31A7E3CE638949ED91F4\",\"password_last_changed\":1765001335}'),('%','neutron_2ead','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*6DB634B99C017725DF1D31A7E3CE638949ED91F4\",\"password_last_changed\":1765001336}'),('localhost','nova_api_c3c0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*407002B57C8286BD0C056B6BF67E082CF29B948F\",\"password_last_changed\":1765001445}'),('%','nova_api_c3c0','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*407002B57C8286BD0C056B6BF67E082CF29B948F\",\"password_last_changed\":1765001445}'),('localhost','nova_cell0_64c1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5AB235A99E487328B7E849089FDE97CA9E758F0A\",\"password_last_changed\":1765001445}'),('%','nova_cell0_64c1','{\"access\":0,\"version_id\":100529,\"plugin\":\"mysql_native_password\",\"authentication_string\":\"*5AB235A99E487328B7E849089FDE97CA9E758F0A\",\"password_last_changed\":1765001445}');
/*!40000 ALTER TABLE `global_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_slave_pos`
--

DROP TABLE IF EXISTS `gtid_slave_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gtid_slave_pos` (
  `domain_id` int(10) unsigned NOT NULL,
  `sub_id` bigint(20) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `seq_no` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`domain_id`,`sub_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Replication slave GTID position';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gtid_slave_pos`
--

LOCK TABLES `gtid_slave_pos` WRITE;
/*!40000 ALTER TABLE `gtid_slave_pos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gtid_slave_pos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` (`help_category_id`, `name`, `parent_category_id`, `url`) VALUES (1,'Contents',0,''),(2,'Polygon Properties',34,''),(3,'WKT',34,''),(4,'Numeric Functions',37,''),(5,'Plugins',1,''),(6,'MBR',34,''),(7,'Control Flow Functions',37,''),(8,'Transactions',1,''),(9,'Help Metadata',1,''),(10,'Account Management',1,''),(11,'Point Properties',34,''),(12,'Encryption Functions',37,''),(13,'LineString Properties',34,''),(14,'Miscellaneous Functions',37,''),(15,'Logical Operators',47,''),(16,'Functions and Modifiers for Use with GROUP BY',1,''),(17,'Information Functions',37,''),(18,'Assignment Operators',47,''),(19,'Comparison Operators',47,''),(20,'Bit Functions',37,''),(21,'Table Maintenance',1,''),(22,'User-Defined Functions',1,''),(23,'Data Types',1,''),(24,'Compound Statements',1,''),(25,'Geometry Constructors',34,''),(26,'Administration',1,''),(27,'Data Manipulation',1,''),(28,'Utility',1,''),(29,'Language Structure',1,''),(30,'Geometry Relations',34,''),(31,'Date and Time Functions',37,''),(32,'WKB',34,''),(33,'Procedures',1,''),(34,'Geographic Features',1,''),(35,'Geometry Properties',34,''),(36,'String Functions',37,''),(37,'Functions',1,''),(38,'Data Definition',1,''),(39,'Sequences',1,''),(40,'JSON Functions',37,''),(41,'Window Functions',37,''),(42,'Spider Functions',37,''),(43,'Dynamic Column Functions',37,''),(44,'Galera Functions',37,''),(45,'Temporal Tables',1,''),(46,'GeoJSON',34,''),(47,'Operators',1,''),(48,'Arithmetic Operators',47,''),(49,'Replication',1,''),(50,'Prepared Statements',1,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` (`help_keyword_id`, `name`) VALUES (1,'work'),(2,'locks'),(3,'locking'),(4,'drop'),(5,'super'),(6,'usage'),(7,'binlog admin'),(8,'binlog monitor'),(9,'binlog replay'),(10,'connection admin'),(11,'federated admin'),(12,'grant option'),(13,'read_only admin'),(14,'replica monitor'),(15,'replication replica'),(16,'roles'),(17,'values'),(18,'value'),(19,'not'),(20,'and'),(21,'or'),(22,':='),(23,'assignment operator'),(24,'='),(25,'!='),(26,'<>'),(27,'not equal'),(28,'less than'),(29,'less than or equal'),(30,'NULL-safe equal'),(31,'equal'),(32,'greater than'),(33,'greater than or equal'),(34,'bitwise and'),(35,'shift left'),(36,'shift right'),(37,'bitwise xor'),(38,'bitwise or'),(39,'bitwise not'),(40,'returns'),(41,'udfs'),(42,'udf calling sequences'),(43,'udf security'),(44,'int1'),(45,'int2'),(46,'int3'),(47,'integer'),(48,'int4'),(49,'int8'),(50,'dec'),(51,'numeric'),(52,'fixed'),(53,'number'),(54,'real'),(55,'double precision'),(56,'nchar'),(57,'long'),(58,'long varchar'),(59,'repeat'),(60,'declare'),(61,'cursor'),(62,'show'),(63,'columns'),(64,'kill connection'),(65,'kill query'),(66,'delete returning'),(67,'sql_big_result'),(68,'minus'),(69,'cte'),(70,'insert returning'),(71,'queries'),(72,'query'),(73,'explain format'),(74,'explain format json'),(75,'rlike'),(76,'character_length'),(77,'escape'),(78,'mode'),(79,'trim_oracle'),(80,'schedule'),(81,'row_format'),(82,'starts'),(83,'host'),(84,'generated columns'),(85,'virtual columns'),(86,'computed columns'),(87,'hidden columns'),(88,'nextval'),(89,'lastval'),(90,'+'),(91,'addition operator'),(92,'/'),(93,'division operator'),(94,'%'),(95,'modulo operator'),(96,'*'),(97,'multiplication operator'),(98,'-'),(99,'subtraction operator'),(100,'master_ssl_verify_cert'),(101,'start replica'),(102,'stop replica'),(103,'reset slave'),(104,'reset replica'),(105,'drop prepare'),(106,'deallocate prepare');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`),
  KEY `help_topic_id` (`help_topic_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` (`help_topic_id`, `help_keyword_id`) VALUES (94,1),(97,2),(99,2),(101,2),(116,2),(147,2),(152,2),(157,2),(161,2),(162,2),(338,2),(438,2),(97,3),(99,3),(101,3),(116,3),(147,3),(152,3),(157,3),(161,3),(162,3),(338,3),(438,3),(106,4),(112,4),(250,4),(687,4),(697,4),(713,4),(714,4),(715,4),(716,4),(717,4),(718,4),(719,4),(720,4),(722,4),(723,4),(731,4),(107,5),(107,6),(107,7),(107,8),(107,9),(107,10),(107,11),(107,12),(107,13),(107,14),(107,15),(115,16),(166,17),(166,18),(167,19),(168,20),(170,21),(210,22),(210,23),(211,23),(211,24),(212,25),(212,26),(212,27),(213,28),(214,29),(215,30),(216,31),(217,32),(218,33),(232,34),(233,35),(234,36),(236,37),(237,38),(238,39),(249,40),(251,41),(252,42),(253,43),(255,44),(257,45),(258,46),(259,47),(259,48),(260,49),(261,50),(261,51),(261,52),(261,53),(263,54),(263,55),(269,56),(275,57),(275,58),(304,59),(664,59),(311,60),(311,61),(331,62),(332,62),(333,62),(334,62),(335,62),(342,62),(343,62),(344,62),(345,62),(346,62),(347,62),(354,62),(356,62),(357,62),(358,62),(359,62),(360,62),(361,62),(362,62),(363,62),(364,62),(365,62),(366,62),(367,62),(368,62),(369,62),(370,62),(371,62),(372,62),(373,62),(374,62),(375,62),(376,62),(377,62),(378,62),(379,62),(380,62),(381,62),(382,62),(383,62),(384,62),(385,62),(386,62),(387,62),(388,62),(389,62),(390,62),(391,62),(392,62),(393,62),(394,62),(395,62),(396,62),(397,62),(398,62),(408,62),(409,62),(333,63),(403,64),(403,65),(410,66),(414,67),(425,68),(431,69),(432,69),(433,69),(453,70),(460,71),(460,72),(466,73),(466,74),(622,75),(632,76),(651,77),(657,78),(678,79),(689,80),(696,81),(701,82),(707,83),(711,84),(711,85),(711,86),(712,87),(732,88),(733,89),(804,90),(804,91),(805,92),(805,93),(806,94),(806,95),(807,96),(807,97),(808,98),(808,99),(809,100),(810,101),(811,102),(812,103),(812,104),(816,105),(816,106);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=Aria DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci PAGE_CHECKSUM=1 TRANSACTIONAL=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` (`help_topic_id`, `name`, `help_category_id`, `description`, `example`, `url`) VALUES (1,'HELP_DATE',9,'Help Contents generated from the MariaDB Knowledge Base on 23 January 2023.','',''),(2,'HELP_VERSION',9,'Help Contents generated for MariaDB 10.5 from the MariaDB Knowledge Base on 23 January 2023.','',''),(3,'AREA',2,'A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/'),(4,'CENTROID',2,'A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/'),(5,'ExteriorRing',2,'A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/'),(6,'InteriorRingN',2,'A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/'),(7,'NumInteriorRings',2,'A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/'),(8,'ST_AREA',2,'Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/'),(9,'ST_CENTROID',2,'Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/'),(10,'ST_ExteriorRing',2,'Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/'),(11,'ST_InteriorRingN',2,'Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/'),(12,'ST_NumInteriorRings',2,'Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/'),(14,'AsText',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/'),(15,'AsWKT',3,'A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/'),(16,'GeomCollFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/'),(17,'GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/'),(18,'GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/'),(19,'GeomFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/'),(20,'LineFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/'),(21,'LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/'),(22,'MLineFromText',3,'Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/'),(23,'MPointFromText',3,'Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/'),(13,'WKT Definition',3,'Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/'),(24,'MPolyFromText',3,'Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/'),(25,'MultiLineStringFromText',3,'A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/'),(26,'MultiPointFromText',3,'A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/'),(27,'MultiPolygonFromText',3,'A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/'),(28,'PointFromText',3,'A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/'),(29,'PolyFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/'),(30,'PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/'),(31,'ST_AsText',3,'Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/'),(32,'ST_ASWKT',3,'A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/'),(33,'ST_GeomCollFromText',3,'Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/'),(34,'ST_GeometryCollectionFromText',3,'A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/'),(35,'ST_GeometryFromText',3,'A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/'),(36,'ST_GeomFromText',3,'Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/'),(37,'ST_LineFromText',3,'Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/'),(38,'ST_LineStringFromText',3,'A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/'),(39,'ST_PointFromText',3,'Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/'),(40,'ST_PolyFromText',3,'Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/'),(41,'ST_PolygonFromText',3,'A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/'),(42,'DIV',4,'Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/'),(43,'ABS',4,'Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/'),(44,'ACOS',4,'Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/'),(45,'ASIN',4,'Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/'),(46,'ATAN',4,'Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/'),(47,'ATAN2',4,'Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/'),(48,'CEIL',4,'Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/'),(49,'CEILING',4,'Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/'),(51,'COS',4,'Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/'),(52,'COT',4,'Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/'),(54,'DEGREES',4,'Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/'),(55,'EXP',4,'Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/'),(50,'CONV',4,'Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/'),(53,'CRC32',4,'Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/'),(56,'FLOOR',4,'Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/'),(57,'LN',4,'Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/'),(58,'LOG',4,'Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/'),(59,'LOG10',4,'Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/'),(60,'LOG2',4,'Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/'),(62,'OCT',4,'Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/'),(63,'PI',4,'Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/'),(64,'POW',4,'Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/'),(65,'POWER',4,'Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/'),(61,'MOD',4,'Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/'),(66,'RADIANS',4,'Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/'),(67,'RAND',4,'Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/'),(68,'ROUND',4,'Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/'),(69,'SIGN',4,'Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/'),(70,'SIN',4,'Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/'),(71,'SQRT',4,'Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/'),(72,'TAN',4,'Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/'),(73,'TRUNCATE',4,'This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/'),(74,'INSTALL PLUGIN',5,'Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/'),(78,'Plugin Overview',5,'Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mysql_plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mysqld option, but it requires a server\nrestart.\n* A plugin can be installed with the mysql_plugin utility, while the server is\ncompletely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mysqld option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mysqld or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mysqld --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mysql_plugin\n-------------------------------------\n\nA plugin can be installed with the mysql_plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmysql_plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmysql_plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mysqld or\nit can be specified in a relevant server option group in an option file. For\nexample:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mysqld or it can be specified in a\nrelevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mysql_plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mysql_plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mysql_plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/','','https://mariadb.com/kb/en/plugin-overview/'),(79,'MBR Definition',6,'Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/'),(80,'MBRContains',6,'Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/'),(82,'MBREqual',6,'Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/'),(86,'MBRWithin',6,'Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/'),(75,'UNINSTALL PLUGIN',5,'Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/'),(76,'INSTALL SONAME',5,'Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/'),(77,'UNINSTALL SONAME',5,'Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/'),(90,'NULLIF',7,'Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/'),(91,'NVL',7,'MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/'),(92,'NVL2',7,'MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/'),(81,'MBRDisjoint',6,'Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/'),(83,'MBRIntersects',6,'Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/'),(84,'MBROverlaps',6,'Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/'),(85,'MBRTouches',6,'Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/'),(87,'CASE OPERATOR',7,'Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/'),(101,'UNLOCK TABLES',8,'Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/'),(103,'XA Transactions',8,'Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/'),(104,'CREATE USER',10,'Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/','','https://mariadb.com/kb/en/create-user/'),(105,'ALTER USER',10,'Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/','','https://mariadb.com/kb/en/alter-user/'),(107,'GRANT',10,'Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mysqladmin processlist. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin/mysqladmin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mysqladmin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mysqladmin debug command. Also, this permission allows the\nuser to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges, although it remains\nan alias for these smaller privileges.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mysql_upgrade will   |\n|                                  | grant this privilege as well.           |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE TRIGGER  |\n|                                  | and DROP TRIGGER statements. You will   |\n|                                  | still be able to see triggers.          |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mysql_install_db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/','','https://mariadb.com/kb/en/grant/'),(117,'Authentication from MariaDB 10.4',10,'MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mysql_install_db is created with\nthe ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by mysql_install_db\nto use unix_socket authentication by default, then there are a few ways to\nrevert to the previous mysql_native_password authentication method for this\nuser account.\n\nConfiguring mysql_install_db to Revert to the Previous Authentication Method\n----------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mysql_install_db with a\nspecial option. If mysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmysql_install_db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmysql_install_db:\n\nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmysql_install_db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mysql_install_db is executed,\nthen mysql_install_db will read this option from the option file, and it will\nautomatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/'),(119,'ST_X',11,'Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/'),(88,'IF Function',7,'Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/'),(89,'IFNULL',7,'Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/'),(94,'START TRANSACTION',8,'Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/'),(120,'ST_Y',11,'Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/'),(121,'X',11,'A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/'),(122,'Y',11,'A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/'),(125,'DECODE_ORACLE',12,'MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/'),(93,'SET TRANSACTION',8,'Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ-UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can perform DDL\nstatements on temporary tables.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/'),(126,'AES_DECRYPT',12,'Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/'),(133,'MD5',12,'Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/'),(95,'COMMIT',8,'The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/'),(96,'ROLLBACK',8,'The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/'),(138,'ENDPOINT',13,'A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/'),(139,'GLENGTH',13,'Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/'),(140,'NumPoints',13,'A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/'),(141,'PointN',13,'A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/'),(142,'STARTPOINT',13,'A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/'),(143,'ST_ENDPOINT',13,'Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/'),(144,'ST_NUMPOINTS',13,'Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/'),(97,'LOCK TABLES',8,'Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation. This restriction was removed in MariaDB\n10.6.2:\n\nERROR 1314 (0A000): LOCK is not allo