/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: 
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `aodh`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `aodh` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `aodh`;

--
-- Table structure for table `alarm`
--

DROP TABLE IF EXISTS `alarm`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm` (
  `alarm_id` varchar(128) NOT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `state_reason` text DEFAULT NULL,
  `state_timestamp` datetime(6) DEFAULT NULL,
  `ok_actions` text DEFAULT NULL,
  `alarm_actions` text DEFAULT NULL,
  `insufficient_data_actions` text DEFAULT NULL,
  `repeat_actions` tinyint(1) DEFAULT NULL,
  `rule` text DEFAULT NULL,
  `time_constraints` text DEFAULT NULL,
  `evaluate_timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`alarm_id`),
  KEY `ix_alarm_type` (`type`),
  KEY `ix_alarm_user_id` (`user_id`),
  KEY `ix_alarm_project_id` (`project_id`),
  KEY `ix_alarm_enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm`
--

LOCK TABLES `alarm` WRITE;
/*!40000 ALTER TABLE `alarm` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alarm_history`
--

DROP TABLE IF EXISTS `alarm_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alarm_history` (
  `event_id` varchar(128) NOT NULL,
  `alarm_id` varchar(128) DEFAULT NULL,
  `on_behalf_of` varchar(128) DEFAULT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `user_id` varchar(128) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `detail` text DEFAULT NULL,
  `timestamp` datetime(6) DEFAULT NULL,
  `severity` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`event_id`),
  KEY `ix_alarm_history_alarm_id` (`alarm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alarm_history`
--

LOCK TABLES `alarm_history` WRITE;
/*!40000 ALTER TABLE `alarm_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `alarm_history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('007');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota`
--

DROP TABLE IF EXISTS `quota`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(128) DEFAULT NULL,
  `resource` varchar(50) DEFAULT NULL,
  `limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_id` (`project_id`,`resource`),
  KEY `ix_quota_project_id_resource` (`project_id`,`resource`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota`
--

LOCK TABLES `quota` WRITE;
/*!40000 ALTER TABLE `quota` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `barbican`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `barbican` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `barbican`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('8c74e2d7f1ff');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authorities`
--

DROP TABLE IF EXISTS `certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `plugin_ca_id` text NOT NULL,
  `expiration` datetime DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cas_project_fk` (`project_id`),
  CONSTRAINT `cas_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authorities`
--

LOCK TABLES `certificate_authorities` WRITE;
/*!40000 ALTER TABLE `certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certificate_authority_metadata`
--

DROP TABLE IF EXISTS `certificate_authority_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certificate_authority_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_certificate_authority_metadatum_uc` (`ca_id`,`key`),
  KEY `ix_certificate_authority_metadata_ca_id` (`ca_id`),
  KEY `ix_certificate_authority_metadata_key` (`key`),
  CONSTRAINT `certificate_authority_metadata_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certificate_authority_metadata`
--

LOCK TABLES `certificate_authority_metadata` WRITE;
/*!40000 ALTER TABLE `certificate_authority_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `certificate_authority_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acl_users`
--

DROP TABLE IF EXISTS `container_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_container_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `container_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `container_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acl_users`
--

LOCK TABLES `container_acl_users` WRITE;
/*!40000 ALTER TABLE `container_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_acls`
--

DROP TABLE IF EXISTS `container_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_acl_operation_uc` (`container_id`,`operation`),
  KEY `ix_container_acls_container_id` (`container_id`),
  CONSTRAINT `container_acls_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_acls`
--

LOCK TABLES `container_acls` WRITE;
/*!40000 ALTER TABLE `container_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_consumer_metadata`
--

DROP TABLE IF EXISTS `container_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `container_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `name` varchar(36) DEFAULT NULL,
  `URL` varchar(255) DEFAULT NULL,
  `data_hash` char(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_consumer_hashed_container_name_url_uc` (`data_hash`),
  KEY `ix_container_consumer_metadata_container_id` (`container_id`),
  KEY `ix_container_consumer_metadata_project_id` (`project_id`),
  KEY `values_index` (`container_id`,`name`,`URL`),
  CONSTRAINT `container_consumer_metadata_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_consumer_metadata_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_consumer_metadata`
--

LOCK TABLES `container_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `container_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `container_secret`
--

DROP TABLE IF EXISTS `container_secret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `container_secret` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `container_id` varchar(36) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_container_secret_name_uc` (`container_id`,`secret_id`,`name`),
  KEY `ix_container_secret_container_id` (`container_id`),
  KEY `ix_container_secret_secret_id` (`secret_id`),
  CONSTRAINT `container_secret_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `container_secret_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `container_secret`
--

LOCK TABLES `container_secret` WRITE;
/*!40000 ALTER TABLE `container_secret` DISABLE KEYS */;
/*!40000 ALTER TABLE `container_secret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `containers`
--

DROP TABLE IF EXISTS `containers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `containers` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` enum('generic','rsa','dsa','certificate') DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_containers_project_id` (`project_id`),
  CONSTRAINT `containers_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `containers`
--

LOCK TABLES `containers` WRITE;
/*!40000 ALTER TABLE `containers` DISABLE KEYS */;
/*!40000 ALTER TABLE `containers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encrypted_data`
--

DROP TABLE IF EXISTS `encrypted_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encrypted_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `secret_id` varchar(36) NOT NULL,
  `kek_id` varchar(36) NOT NULL,
  `cypher_text` text DEFAULT NULL,
  `kek_meta_extended` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_encrypted_data_kek_id` (`kek_id`),
  KEY `ix_encrypted_data_secret_id` (`secret_id`),
  CONSTRAINT `encrypted_data_ibfk_1` FOREIGN KEY (`kek_id`) REFERENCES `kek_data` (`id`),
  CONSTRAINT `encrypted_data_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encrypted_data`
--

LOCK TABLES `encrypted_data` WRITE;
/*!40000 ALTER TABLE `encrypted_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `encrypted_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kek_data`
--

DROP TABLE IF EXISTS `kek_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kek_data` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `kek_label` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `bind_completed` tinyint(1) NOT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `plugin_meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_kek_data_project_id` (`project_id`),
  CONSTRAINT `kek_data_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kek_data`
--

LOCK TABLES `kek_data` WRITE;
/*!40000 ALTER TABLE `kek_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `kek_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_barbican_metadata`
--

DROP TABLE IF EXISTS `order_barbican_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_barbican_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_barbican_metadata_order_id` (`order_id`),
  CONSTRAINT `order_barbican_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_barbican_metadata`
--

LOCK TABLES `order_barbican_metadata` WRITE;
/*!40000 ALTER TABLE `order_barbican_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_barbican_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_plugin_metadata`
--

DROP TABLE IF EXISTS `order_plugin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_plugin_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_plugin_metadata_order_id` (`order_id`),
  CONSTRAINT `order_plugin_metadata_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_plugin_metadata`
--

LOCK TABLES `order_plugin_metadata` WRITE;
/*!40000 ALTER TABLE `order_plugin_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_plugin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `order_retry_tasks`
--

DROP TABLE IF EXISTS `order_retry_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `order_retry_tasks` (
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `id` varchar(36) NOT NULL,
  `order_id` varchar(36) NOT NULL,
  `retry_task` text NOT NULL,
  `retry_at` datetime NOT NULL,
  `retry_args` text NOT NULL,
  `retry_kwargs` text NOT NULL,
  `retry_count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_order_retry_tasks_order_id` (`order_id`),
  CONSTRAINT `order_retry_tasks_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `order_retry_tasks`
--

LOCK TABLES `order_retry_tasks` WRITE;
/*!40000 ALTER TABLE `order_retry_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_retry_tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `error_status_code` varchar(16) DEFAULT NULL,
  `error_reason` varchar(255) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  `secret_id` varchar(36) DEFAULT NULL,
  `container_id` varchar(36) DEFAULT NULL,
  `sub_status` varchar(36) DEFAULT NULL,
  `sub_status_message` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_orders_container_id` (`container_id`),
  KEY `ix_orders_project_id` (`project_id`),
  KEY `ix_orders_secret_id` (`secret_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`container_id`) REFERENCES `containers` (`id`),
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`),
  CONSTRAINT `orders_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `preferred_certificate_authorities`
--

DROP TABLE IF EXISTS `preferred_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `preferred_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_preferred_certificate_authorities_project_id` (`project_id`),
  KEY `ix_preferred_certificate_authorities_ca_id` (`ca_id`),
  CONSTRAINT `preferred_certificate_authorities_fk` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `preferred_certificate_authorities_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `preferred_certificate_authorities`
--

LOCK TABLES `preferred_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `preferred_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `preferred_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_certificate_authorities`
--

DROP TABLE IF EXISTS `project_certificate_authorities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_certificate_authorities` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `ca_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_certificate_authority_uc` (`project_id`,`ca_id`),
  KEY `ix_project_certificate_authorities_ca_id` (`ca_id`),
  KEY `ix_project_certificate_authorities_project_id` (`project_id`),
  CONSTRAINT `project_certificate_authorities_ibfk_1` FOREIGN KEY (`ca_id`) REFERENCES `certificate_authorities` (`id`),
  CONSTRAINT `project_certificate_authorities_ibfk_2` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_certificate_authorities`
--

LOCK TABLES `project_certificate_authorities` WRITE;
/*!40000 ALTER TABLE `project_certificate_authorities` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_certificate_authorities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_quotas`
--

DROP TABLE IF EXISTS `project_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_quotas` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  `secrets` int(11) DEFAULT NULL,
  `orders` int(11) DEFAULT NULL,
  `containers` int(11) DEFAULT NULL,
  `consumers` int(11) DEFAULT NULL,
  `cas` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_project_quotas_project_id` (`project_id`),
  CONSTRAINT `project_quotas_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_quotas`
--

LOCK TABLES `project_quotas` WRITE;
/*!40000 ALTER TABLE `project_quotas` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_secret_store`
--

DROP TABLE IF EXISTS `project_secret_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_secret_store` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_store_id` varchar(36) NOT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_project_secret_store_project_uc` (`project_id`),
  KEY `ix_project_secret_store_project_id` (`project_id`),
  KEY `ix_project_secret_store_secret_store_id` (`secret_store_id`),
  CONSTRAINT `project_secret_store_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `project_secret_store_ibfk_2` FOREIGN KEY (`secret_store_id`) REFERENCES `secret_stores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_secret_store`
--

LOCK TABLES `project_secret_store` WRITE;
/*!40000 ALTER TABLE `project_secret_store` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_secret_store` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projects` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `external_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acl_users`
--

DROP TABLE IF EXISTS `secret_acl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acl_users` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `acl_id` varchar(36) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_user_uc` (`acl_id`,`user_id`),
  KEY `ix_secret_acl_users_acl_id` (`acl_id`),
  CONSTRAINT `secret_acl_users_ibfk_1` FOREIGN KEY (`acl_id`) REFERENCES `secret_acls` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acl_users`
--

LOCK TABLES `secret_acl_users` WRITE;
/*!40000 ALTER TABLE `secret_acl_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_acls`
--

DROP TABLE IF EXISTS `secret_acls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_acls` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `operation` varchar(255) NOT NULL,
  `project_access` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_acl_operation_uc` (`secret_id`,`operation`),
  KEY `ix_secret_acls_secret_id` (`secret_id`),
  CONSTRAINT `secret_acls_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_acls`
--

LOCK TABLES `secret_acls` WRITE;
/*!40000 ALTER TABLE `secret_acls` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_acls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_consumer_metadata`
--

DROP TABLE IF EXISTS `secret_consumer_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_consumer_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  `project_id` varchar(36) DEFAULT NULL,
  `service` varchar(255) NOT NULL,
  `resource_type` varchar(255) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_consumer_resource_uc` (`secret_id`,`service`,`resource_type`,`resource_id`),
  KEY `ix_secret_consumer_metadata_secret_id` (`secret_id`),
  KEY `ix_secret_consumer_metadata_resource_id` (`resource_id`),
  KEY `ix_secret_consumer_metadata_project_id` (`project_id`),
  CONSTRAINT `fk_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`),
  CONSTRAINT `secret_consumer_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_consumer_metadata`
--

LOCK TABLES `secret_consumer_metadata` WRITE;
/*!40000 ALTER TABLE `secret_consumer_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_consumer_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_store_metadata`
--

DROP TABLE IF EXISTS `secret_store_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_store_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secret_store_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_store_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_store_metadata`
--

LOCK TABLES `secret_store_metadata` WRITE;
/*!40000 ALTER TABLE `secret_store_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_store_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_stores`
--

DROP TABLE IF EXISTS `secret_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_stores` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `store_plugin` varchar(255) NOT NULL,
  `crypto_plugin` varchar(255) DEFAULT NULL,
  `global_default` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_stores_name_uc` (`name`),
  UNIQUE KEY `_secret_stores_plugin_names_uc` (`store_plugin`,`crypto_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_stores`
--

LOCK TABLES `secret_stores` WRITE;
/*!40000 ALTER TABLE `secret_stores` DISABLE KEYS */;
INSERT INTO `secret_stores` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`, `store_plugin`, `crypto_plugin`, `global_default`, `name`) VALUES ('0847dca2-fe3a-47c3-80be-2c9b22c0398c','2025-12-06 09:02:31','2025-12-06 09:02:31',NULL,0,'ACTIVE','store_crypto','simple_crypto',1,'Software Only Crypto');
/*!40000 ALTER TABLE `secret_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secret_user_metadata`
--

DROP TABLE IF EXISTS `secret_user_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secret_user_metadata` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `secret_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `_secret_key_uc` (`secret_id`,`key`),
  KEY `ix_secret_user_metadata_secret_id` (`secret_id`),
  CONSTRAINT `secret_user_metadata_ibfk_1` FOREIGN KEY (`secret_id`) REFERENCES `secrets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secret_user_metadata`
--

LOCK TABLES `secret_user_metadata` WRITE;
/*!40000 ALTER TABLE `secret_user_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `secret_user_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `secrets`
--

DROP TABLE IF EXISTS `secrets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `secrets` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `secret_type` varchar(255) DEFAULT 'opaque',
  `expiration` datetime DEFAULT NULL,
  `algorithm` varchar(255) DEFAULT NULL,
  `bit_length` int(11) DEFAULT NULL,
  `mode` varchar(255) DEFAULT NULL,
  `creator_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_secrets_project_id` (`project_id`),
  CONSTRAINT `secrets_project_fk` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `secrets`
--

LOCK TABLES `secrets` WRITE;
/*!40000 ALTER TABLE `secrets` DISABLE KEYS */;
/*!40000 ALTER TABLE `secrets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transport_keys`
--

DROP TABLE IF EXISTS `transport_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transport_keys` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `transport_key` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transport_keys`
--

LOCK TABLES `transport_keys` WRITE;
/*!40000 ALTER TABLE `transport_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `transport_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `cinder`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `cinder` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `cinder`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('daa98075b90d');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attachment_specs`
--

DROP TABLE IF EXISTS `attachment_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_attachment_specs_attachment_id` (`attachment_id`),
  CONSTRAINT `attachment_specs_ibfk_1` FOREIGN KEY (`attachment_id`) REFERENCES `volume_attachment` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attachment_specs`
--

LOCK TABLES `attachment_specs` WRITE;
/*!40000 ALTER TABLE `attachment_specs` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachment_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_metadata`
--

DROP TABLE IF EXISTS `backup_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backup_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_backup_metadata_backup_id` (`backup_id`),
  CONSTRAINT `backup_metadata_ibfk_1` FOREIGN KEY (`backup_id`) REFERENCES `backups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_metadata`
--

LOCK TABLES `backup_metadata` WRITE;
/*!40000 ALTER TABLE `backup_metadata` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backups`
--

DROP TABLE IF EXISTS `backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `container` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `fail_reason` varchar(255) DEFAULT NULL,
  `service_metadata` varchar(255) DEFAULT NULL,
  `service` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `object_count` int(11) DEFAULT NULL,
  `parent_id` varchar(36) DEFAULT NULL,
  `temp_volume_id` varchar(36) DEFAULT NULL,
  `temp_snapshot_id` varchar(36) DEFAULT NULL,
  `num_dependent_backups` int(11) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `data_timestamp` datetime DEFAULT NULL,
  `restore_volume_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `backups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backups`
--

LOCK TABLES `backups` WRITE;
/*!40000 ALTER TABLE `backups` DISABLE KEYS */;
INSERT INTO `backups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `host`, `availability_zone`, `display_name`, `display_description`, `container`, `status`, `fail_reason`, `service_metadata`, `service`, `size`, `object_count`, `parent_id`, `temp_volume_id`, `temp_snapshot_id`, `num_dependent_backups`, `snapshot_id`, `data_timestamp`, `restore_volume_id`, `encryption_key_id`) VALUES ('2025-12-06 10:24:59','2025-12-06 10:25:16','2025-12-06 10:25:18',1,'09b93e96-24eb-4845-83e4-738de53d833d','aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965','b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1173390369',NULL,'backups','deleted',NULL,'{\"base\": \"volume-aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965.backup.09b93e96-24eb-4845-83e4-738de53d833d\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,0,NULL,'2025-12-06 10:24:59',NULL,NULL),('2025-12-06 10:22:28','2025-12-06 10:22:41','2025-12-06 10:22:43',1,'0c7dd433-ba6f-4f9b-be17-f12361d6cf82','a9b72058-b3a6-4112-b2ef-a614b1de0110','b898d0b45de84b89a6a6ac9032ba8e8e','083713cc3880454487a156230b40fd02','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-1772520082',NULL,'backups','deleted',NULL,'{\"base\": \"volume-a9b72058-b3a6-4112-b2ef-a614b1de0110.backup.0c7dd433-ba6f-4f9b-be17-f12361d6cf82\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:28','eb844db9-3326-400d-ac0b-d6537fc655b9',NULL),('2025-12-06 10:22:47','2025-12-06 10:22:51','2025-12-06 10:22:53',1,'193b243e-9848-4a4f-8847-d8d459bda90f','c8bf4e16-7338-4494-ab1d-72a69d8b9b6d','b898d0b45de84b89a6a6ac9032ba8e8e','083713cc3880454487a156230b40fd02','cinder-backup-0',NULL,'tempest-VolumesBackupsAdminTest-Backup-624651129',NULL,'backups','deleted',NULL,'{\"base\": \"volume-c8bf4e16-7338-4494-ab1d-72a69d8b9b6d.backup.193b243e-9848-4a4f-8847-d8d459bda90f\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:47',NULL,NULL),('2025-12-06 10:23:56','2025-12-06 10:24:06','2025-12-06 10:24:07',1,'2275aa64-1738-42a1-9c89-3639a4019908','323db21e-9cd3-4a57-af96-05c49a2bb708','b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-294445681',NULL,'backups','deleted',NULL,'{\"base\": \"volume-323db21e-9cd3-4a57-af96-05c49a2bb708.backup.2275aa64-1738-42a1-9c89-3639a4019908\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:56','fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:39','2025-12-06 10:21:41',1,'3596b291-1285-46aa-a298-cd273710bd22','ca3e4a86-d265-4057-b134-ad9b5e3eae4e','efa0a8b565434ce69ac6e465c0524033','eab6fb5a053a4a4f8668138357e0b3b6','cinder-backup-0',NULL,'tempest-VolumesBackupsV39Test-Backup-73207612','tempest-volume-backup-description-805825794','backups','deleted',NULL,'{\"base\": \"volume-ca3e4a86-d265-4057-b134-ad9b5e3eae4e.backup.3596b291-1285-46aa-a298-cd273710bd22\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:33',NULL,NULL),('2025-12-06 10:25:03','2025-12-06 10:25:07','2025-12-06 10:25:09',1,'3e91f8df-76d8-4fc3-ac59-6f10c64d0855','aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965','b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','cinder-backup-0',NULL,NULL,NULL,'backups','deleted',NULL,'{\"base\": \"volume-aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965.backup.09b93e96-24eb-4845-83e4-738de53d833d\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'09b93e96-24eb-4845-83e4-738de53d833d',NULL,NULL,NULL,NULL,'2025-12-06 10:25:03',NULL,NULL),('2025-12-06 10:23:20','2025-12-06 10:23:37','2025-12-06 10:23:38',1,'626a3cd7-af06-4a4b-b188-24993550e17e','2a956d59-22c7-4046-a8e9-3b5d490292c5','ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','cinder-backup-0',NULL,'tempest-VolumesSnapshotTestJSON-Backup-1415028342',NULL,'backups','deleted',NULL,NULL,'cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,NULL,NULL,NULL,NULL,'bef84337-bca2-4e45-be0a-64b7f25e1843','2025-12-06 10:23:19',NULL,NULL),('2025-12-06 10:25:10','2025-12-06 10:25:14','2025-12-06 10:25:16',1,'d55a4521-6395-4a25-899e-f4f4908ad802','aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965','b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','cinder-backup-0',NULL,'tempest-VolumesBackupsTest-Backup-1086716659',NULL,'backups','deleted',NULL,'{\"base\": \"volume-aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965.backup.09b93e96-24eb-4845-83e4-738de53d833d\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,NULL,'09b93e96-24eb-4845-83e4-738de53d833d',NULL,NULL,NULL,NULL,'2025-12-06 10:25:10',NULL,NULL),('2025-12-06 10:22:28','2025-12-06 10:22:40','2025-12-06 10:22:40',1,'efaaa879-e4eb-4a3f-9cea-87b23d60e3ed','a9b72058-b3a6-4112-b2ef-a614b1de0110','0623bd128f7a4499b3bbaf6262aeae18','4b53cb909ca348ccacfc19b982cb4913','cinder-backup-0','nova','tempest-VolumesBackupsAdminTest-Backup-1772520082',NULL,'backups','deleted',NULL,'{\"base\": \"volume-a9b72058-b3a6-4112-b2ef-a614b1de0110.backup.0c7dd433-ba6f-4f9b-be17-f12361d6cf82\"}','cinder.backup.drivers.ceph.CephBackupDriver',1,0,NULL,NULL,NULL,0,NULL,'2025-12-06 10:22:28',NULL,NULL);
/*!40000 ALTER TABLE `backups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cgsnapshots`
--

DROP TABLE IF EXISTS `cgsnapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cgsnapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `consistencygroup_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_cgsnapshots_consistencygroup_id` (`consistencygroup_id`),
  CONSTRAINT `cgsnapshots_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cgsnapshots`
--

LOCK TABLES `cgsnapshots` WRITE;
/*!40000 ALTER TABLE `cgsnapshots` DISABLE KEYS */;
/*!40000 ALTER TABLE `cgsnapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clusters`
--

DROP TABLE IF EXISTS `clusters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `clusters` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `frozen` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`binary`,`race_preventer`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clusters`
--

LOCK TABLES `clusters` WRITE;
/*!40000 ALTER TABLE `clusters` DISABLE KEYS */;
/*!40000 ALTER TABLE `clusters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consistencygroups`
--

DROP TABLE IF EXISTS `consistencygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consistencygroups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `volume_type_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `source_cgid` varchar(36) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consistencygroups`
--

LOCK TABLES `consistencygroups` WRITE;
/*!40000 ALTER TABLE `consistencygroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `consistencygroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `default_volume_types`
--

DROP TABLE IF EXISTS `default_volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `default_volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) NOT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  KEY `ix_default_volume_types_volume_type_id` (`volume_type_id`),
  CONSTRAINT `default_volume_types_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `default_volume_types`
--

LOCK TABLES `default_volume_types` WRITE;
/*!40000 ALTER TABLE `default_volume_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `default_volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver_initiator_data`
--

DROP TABLE IF EXISTS `driver_initiator_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `driver_initiator_data` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `initiator` varchar(255) NOT NULL,
  `namespace` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `initiator` (`initiator`,`namespace`,`key`),
  KEY `ix_driver_initiator_data_initiator` (`initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver_initiator_data`
--

LOCK TABLES `driver_initiator_data` WRITE;
/*!40000 ALTER TABLE `driver_initiator_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `driver_initiator_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `encryption`
--

DROP TABLE IF EXISTS `encryption`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `encryption` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `cipher` varchar(255) DEFAULT NULL,
  `control_location` varchar(255) NOT NULL,
  `key_size` int(11) DEFAULT NULL,
  `provider` varchar(255) NOT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `encryption_id` varchar(36) NOT NULL,
  PRIMARY KEY (`encryption_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `encryption`
--

LOCK TABLES `encryption` WRITE;
/*!40000 ALTER TABLE `encryption` DISABLE KEYS */;
INSERT INTO `encryption` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `cipher`, `control_location`, `key_size`, `provider`, `volume_type_id`, `encryption_id`) VALUES ('2025-12-06 10:22:49','2025-12-06 10:22:49','2025-12-06 10:22:49',1,'aes-xts-plain64','back-end',128,'SomeProvider','332c9b63-3160-487c-8c95-a73ae379254c','19355f26-1d6a-4f58-97ec-f9e419ab055a');
/*!40000 ALTER TABLE `encryption` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_snapshots`
--

DROP TABLE IF EXISTS `group_snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_snapshots_group_id` (`group_id`),
  KEY `group_snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `group_snapshots_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_snapshots`
--

LOCK TABLES `group_snapshots` WRITE;
/*!40000 ALTER TABLE `group_snapshots` DISABLE KEYS */;
INSERT INTO `group_snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `group_id`, `user_id`, `project_id`, `name`, `description`, `status`, `group_type_id`) VALUES ('2025-12-06 10:17:37','2025-12-06 10:17:40','2025-12-06 10:17:41',1,'0efabb33-cb68-43d1-8f6a-a396134145f2','b88908cd-5813-4342-8e39-d31d3002e7ec','9746c911f01c4fee942db215e7ee0535','3d64b92c0ac84e00a6e31382047e6db5','tempest-GroupSnapshotsV319Test-Group_Snapshot-1435614098',NULL,'deleted','d0d66881-c585-473e-92e8-0d9946e34d35'),('2025-12-06 10:18:20','2025-12-06 10:18:22','2025-12-06 10:18:23',1,'21638b59-7b9e-4b1c-b4bd-4beef4d51a82','bd444e34-d819-4ff5-9444-4271d29ce628','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','tempest-group_snapshot-1147147118',NULL,'deleted','90b27182-8c9f-4b0f-ab24-f1bd4ddb2f08'),('2025-12-06 10:18:09','2025-12-06 10:18:13','2025-12-06 10:18:15',1,'31739f3e-0c63-44d0-aaa7-b4c1d0a5330a','f2946e24-c767-49a4-b96c-8c9689ac8ba7','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','tempest-GroupSnapshotsTest-Group_Snapshot-747549073',NULL,'deleted','82d126c6-326b-41d8-afcc-cdc12d8cd15d'),('2025-12-06 10:17:52','2025-12-06 10:17:57','2025-12-06 10:17:58',1,'5d570957-ff61-47b9-90b6-1b114d4e460d','1f8f804e-8752-4bda-a487-d6683876ed8b','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','tempest-group_snapshot-198457173',NULL,'deleted','b3a34db6-ae62-46f5-ae77-fb4e3d8e6ad4');
/*!40000 ALTER TABLE `group_snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_projects`
--

DROP TABLE IF EXISTS `group_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_type_id` (`group_type_id`,`project_id`,`deleted`),
  CONSTRAINT `group_type_projects_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_projects`
--

LOCK TABLES `group_type_projects` WRITE;
/*!40000 ALTER TABLE `group_type_projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_type_specs`
--

DROP TABLE IF EXISTS `group_type_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_type_specs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_type_specs_group_type_id` (`group_type_id`),
  CONSTRAINT `group_type_specs_ibfk_1` FOREIGN KEY (`group_type_id`) REFERENCES `group_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_type_specs`
--

LOCK TABLES `group_type_specs` WRITE;
/*!40000 ALTER TABLE `group_type_specs` DISABLE KEYS */;
INSERT INTO `group_type_specs` (`id`, `key`, `value`, `group_type_id`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'consistent_group_snapshot_enabled','<is> True','c4109a90-44da-4a7a-8dbd-9221e1370582','2025-12-06 08:26:03','2025-12-06 08:26:03',NULL,0),(5,'consistent_group_snapshot_enabled','<is> False','65aad2f6-624f-4ea2-acff-cc03ed4592fd','2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',1),(6,'key1','value1','ea8e89b3-ffc1-4867-a130-ea4cc7cd9cb6','2025-12-06 10:22:28',NULL,'2025-12-06 10:22:28',1),(7,'key2','value2-updated','ea8e89b3-ffc1-4867-a130-ea4cc7cd9cb6','2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1),(8,'key3','value3-updated','ea8e89b3-ffc1-4867-a130-ea4cc7cd9cb6','2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1);
/*!40000 ALTER TABLE `group_type_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_types`
--

DROP TABLE IF EXISTS `group_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_types` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_types`
--

LOCK TABLES `group_types` WRITE;
/*!40000 ALTER TABLE `group_types` DISABLE KEYS */;
INSERT INTO `group_types` (`id`, `name`, `description`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `is_public`) VALUES ('1ef197d6-2578-424d-8368-81a400f3f340','tempest-GroupsV320Test-group-type-1505174887',NULL,'2025-12-06 10:22:20',NULL,'2025-12-06 10:22:23',1,1),('5baa189a-629b-4474-af79-9f998cda8495','tempest-GroupsTest-group-type-36152636',NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:09',1,1),('65aad2f6-624f-4ea2-acff-cc03ed4592fd','tempest-GroupTypesTest-updated-group-type-432593543','updated-group-type-desc','2025-12-06 10:17:50','2025-12-06 10:17:50','2025-12-06 10:17:50',1,1),('82d126c6-326b-41d8-afcc-cdc12d8cd15d','tempest-GroupSnapshotsTest-group-type-106651589',NULL,'2025-12-06 10:18:01',NULL,'2025-12-06 10:18:18',1,1),('8f53aaa1-a4f7-4778-ae8f-964dadbe78fc','a_tempest-group-type-953308159',NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',1,1),('90a68bed-18c9-4795-9ab5-0b74087a5ee3','b_tempest-group-type-1614217581',NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',1,0),('90b27182-8c9f-4b0f-ab24-f1bd4ddb2f08','tempest-GroupSnapshotsTest-group-type-2139658',NULL,'2025-12-06 10:18:18',NULL,'2025-12-06 10:18:25',1,1),('9b1bb549-48a3-40ff-b8fb-d1359ae65f90','tempest-GroupsTest-group-type-1468611443',NULL,'2025-12-06 10:20:53',NULL,'2025-12-06 10:21:00',1,1),('b3a34db6-ae62-46f5-ae77-fb4e3d8e6ad4','tempest-GroupSnapshotsTest-group-type-511448095',NULL,'2025-12-06 10:17:49',NULL,'2025-12-06 10:18:00',1,1),('c4109a90-44da-4a7a-8dbd-9221e1370582','default_cgsnapshot_type','Default group type for migrating cgsnapshot','2025-12-06 08:26:03','2025-12-06 08:26:03',NULL,0,1),('d0d66881-c585-473e-92e8-0d9946e34d35','tempest-GroupSnapshotsV319Test-group-type-1291778516',NULL,'2025-12-06 10:17:33',NULL,'2025-12-06 10:17:43',1,1),('ea8e89b3-ffc1-4867-a130-ea4cc7cd9cb6','tempest-GroupTypeSpecsTest-group-type-1248027948',NULL,'2025-12-06 10:22:28',NULL,'2025-12-06 10:22:28',1,1),('f8d3f889-288d-4cca-8fcc-679321924a88','tempest-GroupsV314Test-group-type-1498320851',NULL,'2025-12-06 10:21:48',NULL,'2025-12-06 10:21:56',1,1);
/*!40000 ALTER TABLE `group_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group_volume_type_mapping`
--

DROP TABLE IF EXISTS `group_volume_type_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_volume_type_mapping` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `group_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_group_volume_type_mapping_volume_type_id` (`volume_type_id`),
  KEY `ix_group_volume_type_mapping_group_id` (`group_id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `group_volume_type_mapping_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group_volume_type_mapping`
--

LOCK TABLES `group_volume_type_mapping` WRITE;
/*!40000 ALTER TABLE `group_volume_type_mapping` DISABLE KEYS */;
INSERT INTO `group_volume_type_mapping` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `group_id`) VALUES ('2025-12-06 10:17:33',NULL,'2025-12-06 10:17:43',1,1,'03c53960-549b-4237-86ca-243e6e72af42','b88908cd-5813-4342-8e39-d31d3002e7ec'),('2025-12-06 10:17:49',NULL,'2025-12-06 10:18:00',1,2,'927dda5f-99e7-4e29-8c0d-bc2850a18ade','1f8f804e-8752-4bda-a487-d6683876ed8b'),('2025-12-06 10:17:54',NULL,'2025-12-06 10:17:56',1,3,'927dda5f-99e7-4e29-8c0d-bc2850a18ade','d333590b-3e8b-433e-b9e6-239776cbcf11'),('2025-12-06 10:18:01',NULL,'2025-12-06 10:18:17',1,4,'80dfab08-2b1b-44e7-b2de-1f8cbff02067','f2946e24-c767-49a4-b96c-8c9689ac8ba7'),('2025-12-06 10:18:18',NULL,'2025-12-06 10:18:24',1,5,'b0f02714-dafa-4a55-8991-344da33daa86','bd444e34-d819-4ff5-9444-4271d29ce628'),('2025-12-06 10:20:53',NULL,'2025-12-06 10:20:58',1,6,'8cfd4194-b2ea-43fd-9d8f-e9aee14615fa','61f08fa1-34ba-4f34-ae28-4354b3cad228'),('2025-12-06 10:20:55',NULL,'2025-12-06 10:20:59',1,7,'8cfd4194-b2ea-43fd-9d8f-e9aee14615fa','691a6328-2e92-4e95-a655-54d976164675'),('2025-12-06 10:21:00',NULL,'2025-12-06 10:21:08',1,8,'4775656f-035a-4184-abec-1a7b067cc6c9','06c34df4-7c6a-4a20-86ff-af8c5c25fdcd'),('2025-12-06 10:21:49',NULL,'2025-12-06 10:21:55',1,9,'f53abe89-cb1b-4f24-bcc7-eb7c1802a9ea','a63a6870-1eca-49de-936b-8fcaf3bed7ec'),('2025-12-06 10:21:51',NULL,'2025-12-06 10:21:54',1,10,'f53abe89-cb1b-4f24-bcc7-eb7c1802a9ea','92ce1d4a-1cd3-48d1-a7ff-11c28aeb1baf'),('2025-12-06 10:22:21',NULL,'2025-12-06 10:22:22',1,11,'1284d8af-5130-4cd5-b7eb-d43ba7ac283b','99ef059b-78ea-4323-b87c-a030f49c4300');
/*!40000 ALTER TABLE `group_volume_type_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `groups` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `group_type_id` varchar(36) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `source_group_id` varchar(36) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `groups_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `cluster_name`, `host`, `availability_zone`, `name`, `description`, `group_type_id`, `status`, `group_snapshot_id`, `source_group_id`, `replication_status`) VALUES ('2025-12-06 10:21:00','2025-12-06 10:21:08','2025-12-06 10:21:08',1,'06c34df4-7c6a-4a20-86ff-af8c5c25fdcd','a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','new_group','This is a new group','5baa189a-629b-4474-af79-9f998cda8495','deleted',NULL,NULL,'disabled'),('2025-12-06 10:17:49','2025-12-06 10:18:00','2025-12-06 10:18:00',1,'1f8f804e-8752-4bda-a487-d6683876ed8b','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-985747303',NULL,'b3a34db6-ae62-46f5-ae77-fb4e3d8e6ad4','deleted',NULL,NULL,'disabled'),('2025-12-06 10:20:54','2025-12-06 10:20:58','2025-12-06 10:20:58',1,'61f08fa1-34ba-4f34-ae28-4354b3cad228','a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group1-1958145217',NULL,'9b1bb549-48a3-40ff-b8fb-d1359ae65f90','deleted',NULL,NULL,'disabled'),('2025-12-06 10:20:55','2025-12-06 10:20:59','2025-12-06 10:20:59',1,'691a6328-2e92-4e95-a655-54d976164675','a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group2-820122394',NULL,'9b1bb549-48a3-40ff-b8fb-d1359ae65f90','deleted',NULL,NULL,'disabled'),('2025-12-06 10:21:52','2025-12-06 10:21:54','2025-12-06 10:21:54',1,'92ce1d4a-1cd3-48d1-a7ff-11c28aeb1baf','69342e816b8a4c66a18fe32123f49c95','8566f9acc2b141e2a06f7a1cbef81657',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_grp-1924308213',NULL,'f8d3f889-288d-4cca-8fcc-679321924a88','deleted',NULL,'a63a6870-1eca-49de-936b-8fcaf3bed7ec','disabled'),('2025-12-06 10:22:21','2025-12-06 10:22:22','2025-12-06 10:22:22',1,'99ef059b-78ea-4323-b87c-a030f49c4300','ec4c4d91ee4c4892b5a0007e35639cbc','318e19e7541249a9a89016c23feff533',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV320Test-Group-1669168031',NULL,'1ef197d6-2578-424d-8368-81a400f3f340','deleted',NULL,NULL,'disabled'),('2025-12-06 10:21:49','2025-12-06 10:21:55','2025-12-06 10:21:55',1,'a63a6870-1eca-49de-936b-8fcaf3bed7ec','69342e816b8a4c66a18fe32123f49c95','8566f9acc2b141e2a06f7a1cbef81657',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupsV314Test-Group-132760098',NULL,'f8d3f889-288d-4cca-8fcc-679321924a88','deleted',NULL,NULL,'disabled'),('2025-12-06 10:17:33','2025-12-06 10:17:43','2025-12-06 10:17:43',1,'b88908cd-5813-4342-8e39-d31d3002e7ec','9746c911f01c4fee942db215e7ee0535','3d64b92c0ac84e00a6e31382047e6db5',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsV319Test-Group-1061797076',NULL,'d0d66881-c585-473e-92e8-0d9946e34d35','deleted',NULL,NULL,'disabled'),('2025-12-06 10:18:18','2025-12-06 10:18:24','2025-12-06 10:18:24',1,'bd444e34-d819-4ff5-9444-4271d29ce628','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-1044279309',NULL,'90b27182-8c9f-4b0f-ab24-f1bd4ddb2f08','deleted',NULL,NULL,'disabled'),('2025-12-06 10:17:54','2025-12-06 10:17:56','2025-12-06 10:17:56',1,'d333590b-3e8b-433e-b9e6-239776cbcf11','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-Group_from_snap-557532538',NULL,'b3a34db6-ae62-46f5-ae77-fb4e3d8e6ad4','deleted','5d570957-ff61-47b9-90b6-1b114d4e460d',NULL,'disabled'),('2025-12-06 10:18:01','2025-12-06 10:18:17','2025-12-06 10:18:17',1,'f2946e24-c767-49a4-b96c-8c9689ac8ba7','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857',NULL,'hostgroup@tripleo_ceph#tripleo_ceph','nova','tempest-GroupSnapshotsTest-Group-665310288',NULL,'82d126c6-326b-41d8-afcc-cdc12d8cd15d','deleted',NULL,NULL,'disabled');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_volume_cache_entries`
--

DROP TABLE IF EXISTS `image_volume_cache_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_volume_cache_entries` (
  `image_updated_at` datetime DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `image_id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `size` int(11) NOT NULL,
  `last_used` datetime NOT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_volume_cache_entries_image_id` (`image_id`),
  KEY `ix_image_volume_cache_entries_host` (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_volume_cache_entries`
--

LOCK TABLES `image_volume_cache_entries` WRITE;
/*!40000 ALTER TABLE `image_volume_cache_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_volume_cache_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(36) DEFAULT NULL,
  `resource_uuid` varchar(255) DEFAULT NULL,
  `event_id` varchar(255) NOT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `action_id` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_messages_expires_at` (`expires_at`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_uuid`, `event_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`, `detail_id`, `action_id`) VALUES ('b2e282b6-72a8-4bb8-9845-d0c03368c34d','0869d8bc1b684db8b15afc4eebf3f39d','req-3c11220e-a4ee-41e3-ad74-4592fb9a2f80','VOLUME','153abf3e-83be-4688-baed-f6caf3971b67','VOLUME_VOLUME_001_003','ERROR','2025-12-06 10:22:11',NULL,'2025-12-06 10:22:12',1,'2026-01-05 10:22:11','003','001'),('bd9ea3d5-c6bc-4093-bf99-4546fa462ca6','0869d8bc1b684db8b15afc4eebf3f39d','req-636a6b6f-0935-427b-b941-9a39bfa22bb1','VOLUME','ded1304c-77ea-4a6a-8e83-00704b16b4af','VOLUME_VOLUME_001_003','ERROR','2025-12-06 10:22:13',NULL,'2025-12-06 10:22:14',1,'2026-01-05 10:22:13','003','001');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('cinder','/usr/lib/python3.9/site-packages/cinder/db/sqlalchemy/migrate_repo',145);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quality_of_service_specs`
--

DROP TABLE IF EXISTS `quality_of_service_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quality_of_service_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `specs_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quality_of_service_specs_specs_id` (`specs_id`),
  CONSTRAINT `quality_of_service_specs_ibfk_1` FOREIGN KEY (`specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quality_of_service_specs`
--

LOCK TABLES `quality_of_service_specs` WRITE;
/*!40000 ALTER TABLE `quality_of_service_specs` DISABLE KEYS */;
INSERT INTO `quality_of_service_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `specs_id`, `key`, `value`) VALUES ('2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',1,'002ea5ba-b628-4b41-9867-d5703b5a68c7',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-707147068'),('2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',1,'1dbedbfc-af15-4014-b134-943b79dbe515',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-484381652'),('2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',1,'3fd9e95d-c101-4a17-ba44-fde814b1ba55','002ea5ba-b628-4b41-9867-d5703b5a68c7','consumer','back-end'),('2025-12-06 10:22:04',NULL,'2025-12-06 10:22:04',1,'50a1b2b9-ec0f-4d58-afca-ffd9102893aa','e4b29ede-9a14-4e61-8de6-c1825759d531','iops_bytes','500'),('2025-12-06 10:22:04',NULL,'2025-12-06 10:22:04',1,'6e8ddcef-060b-486d-a247-2195b30c5763',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-qos-915913375'),('2025-12-06 10:22:02',NULL,'2025-12-06 10:22:04',1,'9e4c90b0-9e4b-4826-a310-b3b4c50ede5d','e4b29ede-9a14-4e61-8de6-c1825759d531','read_iops_sec','2000'),('2025-12-06 10:22:02',NULL,'2025-12-06 10:22:04',1,'b322c625-70c6-4501-9bf0-5b9bbcfe2ea4','e4b29ede-9a14-4e61-8de6-c1825759d531','consumer','front-end'),('2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',1,'c0a1bf72-087a-484e-b917-76fdd7f0eddc','1dbedbfc-af15-4014-b134-943b79dbe515','consumer','both'),('2025-12-06 10:22:02',NULL,'2025-12-06 10:22:04',1,'e4b29ede-9a14-4e61-8de6-c1825759d531',NULL,'QoS_Specs_Name','tempest-QosSpecsTestJSON-QoS-289748274'),('2025-12-06 10:22:04',NULL,'2025-12-06 10:22:04',1,'fa274162-9d81-404c-b9df-b41cb61642d5','6e8ddcef-060b-486d-a247-2195b30c5763','consumer','front-end');
/*!40000 ALTER TABLE `quality_of_service_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
INSERT INTO `quota_classes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `class_name`, `resource`, `hard_limit`) VALUES ('2025-12-06 08:25:59','2025-12-06 10:22:21',NULL,0,2,'default','volumes',10),('2025-12-06 08:25:59','2025-12-06 10:22:21',NULL,0,5,'default','snapshots',10),('2025-12-06 08:25:59','2025-12-06 10:22:21',NULL,0,8,'default','gigabytes',1000),('2025-12-06 08:25:59',NULL,NULL,0,11,'default','consistencygroups',10),('2025-12-06 08:25:59',NULL,NULL,0,14,'default','per_volume_gigabytes',-1),('2025-12-06 08:25:59',NULL,NULL,0,17,'default','groups',10),('2025-12-06 10:22:20','2025-12-06 10:22:21',NULL,0,20,'default','backups',10),('2025-12-06 10:22:20','2025-12-06 10:22:21',NULL,0,21,'default','backup_gigabytes',1000),('2025-12-06 10:22:20',NULL,NULL,0,22,'default','volumes_tempest-VolumeQuotaClassesTest-volume-type-852158285',9),('2025-12-06 10:22:20',NULL,NULL,0,23,'default','snapshots_tempest-VolumeQuotaClassesTest-volume-type-852158285',2),('2025-12-06 10:22:20',NULL,NULL,0,24,'default','gigabytes_tempest-VolumeQuotaClassesTest-volume-type-852158285',9);
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(300) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `race_preventer` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `quota_usages_project_id_key` (`project_id`,`resource`,`race_preventer`),
  KEY `quota_usage_project_resource_idx` (`project_id`,`resource`),
  KEY `ix_quota_usages_project_id` (`project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `race_preventer`) VALUES ('2025-12-06 10:17:33','2025-12-06 10:17:43',NULL,0,1,'3d64b92c0ac84e00a6e31382047e6db5','groups',0,0,NULL,1),('2025-12-06 10:17:35','2025-12-06 10:17:43',NULL,0,2,'3d64b92c0ac84e00a6e31382047e6db5','volumes',0,0,NULL,1),('2025-12-06 10:17:35','2025-12-06 10:17:43',NULL,0,3,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes',0,0,NULL,1),('2025-12-06 10:17:35','2025-12-06 10:17:43',NULL,0,4,'3d64b92c0ac84e00a6e31382047e6db5','volumes_tempest-GroupSnapshotsV319Test-volume-type-552402764',0,0,NULL,1),('2025-12-06 10:17:35','2025-12-06 10:17:43',NULL,0,5,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-552402764',0,0,NULL,1),('2025-12-06 10:17:37','2025-12-06 10:17:41',NULL,0,6,'3d64b92c0ac84e00a6e31382047e6db5','snapshots',0,0,NULL,1),('2025-12-06 10:17:37','2025-12-06 10:17:41',NULL,0,7,'3d64b92c0ac84e00a6e31382047e6db5','snapshots_tempest-GroupSnapshotsV319Test-volume-type-552402764',0,0,NULL,1),('2025-12-06 10:17:49','2025-12-06 10:18:24',NULL,0,8,'49b6390c5ae14ddf850d4e9fda870857','groups',0,0,NULL,1),('2025-12-06 10:17:51','2025-12-06 10:18:24',NULL,0,9,'49b6390c5ae14ddf850d4e9fda870857','volumes',0,0,NULL,1),('2025-12-06 10:17:51','2025-12-06 10:18:24',NULL,0,10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',0,0,NULL,1),('2025-12-06 10:17:51','2025-12-06 10:18:00',NULL,0,11,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-2067352107',0,0,NULL,1),('2025-12-06 10:17:51','2025-12-06 10:17:58',NULL,0,12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',0,0,NULL,1),('2025-12-06 10:17:52','2025-12-06 10:18:23',NULL,0,13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',0,0,NULL,1),('2025-12-06 10:17:52','2025-12-06 10:17:58',NULL,0,14,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-2067352107',0,0,NULL,1),('2025-12-06 10:17:58','2025-12-06 10:18:01',NULL,0,15,'514ec268f5ca4320a08c7470e3cc5655','volumes',0,0,NULL,1),('2025-12-06 10:17:58','2025-12-06 10:18:01',NULL,0,16,'514ec268f5ca4320a08c7470e3cc5655','gigabytes',0,0,NULL,1),('2025-12-06 10:17:58','2025-12-06 10:18:00',NULL,0,17,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-1',0,0,NULL,1),('2025-12-06 10:17:58','2025-12-06 10:18:00',NULL,0,18,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-1',0,0,NULL,1),('2025-12-06 10:17:59','2025-12-06 10:18:01',NULL,0,19,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-2',0,0,NULL,1),('2025-12-06 10:17:59','2025-12-06 10:18:01',NULL,0,20,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-2',0,0,NULL,1),('2025-12-06 10:18:02','2025-12-06 10:18:17',NULL,0,21,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1882379761',0,0,NULL,1),('2025-12-06 10:18:02','2025-12-06 10:18:17',NULL,0,22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',0,0,NULL,1),('2025-12-06 10:18:09','2025-12-06 10:18:23',NULL,0,23,'82e66d987af642e79e2539d816511c7b','volumes',0,0,NULL,1),('2025-12-06 10:18:09','2025-12-06 10:18:23',NULL,0,24,'82e66d987af642e79e2539d816511c7b','gigabytes',0,0,NULL,1),('2025-12-06 10:18:09','2025-12-06 10:18:23',NULL,0,25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:09','2025-12-06 10:18:23',NULL,0,26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:10','2025-12-06 10:18:15',NULL,0,27,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1882379761',0,0,NULL,1),('2025-12-06 10:18:17','2025-12-06 10:18:20',NULL,0,28,'8d525f3db4524999ac4cbc2a6d6f399f','volumes',0,0,NULL,1),('2025-12-06 10:18:17','2025-12-06 10:18:20',NULL,0,29,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes',0,0,NULL,1),('2025-12-06 10:18:17','2025-12-06 10:18:20',NULL,0,30,'8d525f3db4524999ac4cbc2a6d6f399f','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:17','2025-12-06 10:18:20',NULL,0,31,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:19','2025-12-06 10:18:24',NULL,0,32,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1726901555',0,0,NULL,1),('2025-12-06 10:18:19','2025-12-06 10:18:24',NULL,0,33,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1726901555',0,0,NULL,1),('2025-12-06 10:18:21','2025-12-06 10:18:23',NULL,0,34,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1726901555',0,0,NULL,1),('2025-12-06 10:18:24','2025-12-06 10:18:28',NULL,0,35,'bdae3a4fd57541f391ba58bd701f861c','volumes',0,0,NULL,1),('2025-12-06 10:18:24','2025-12-06 10:18:28',NULL,0,36,'bdae3a4fd57541f391ba58bd701f861c','gigabytes',0,0,NULL,1),('2025-12-06 10:18:24','2025-12-06 10:18:28',NULL,0,37,'bdae3a4fd57541f391ba58bd701f861c','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:24','2025-12-06 10:18:28',NULL,0,38,'bdae3a4fd57541f391ba58bd701f861c','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:25','2025-12-06 10:18:27',NULL,0,39,'bdae3a4fd57541f391ba58bd701f861c','snapshots',0,0,NULL,1),('2025-12-06 10:18:25','2025-12-06 10:18:27',NULL,0,40,'bdae3a4fd57541f391ba58bd701f861c','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:18:35','2025-12-06 10:18:42',NULL,0,41,'fa979675ad6e484daf8c7eb00c115ce5','volumes',0,0,NULL,1),('2025-12-06 10:18:35','2025-12-06 10:18:42',NULL,0,42,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes',0,0,NULL,1),('2025-12-06 10:18:35','2025-12-06 10:18:42',NULL,0,43,'fa979675ad6e484daf8c7eb00c115ce5','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:35','2025-12-06 10:18:42',NULL,0,44,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:37','2025-12-06 10:18:40',NULL,0,45,'fa979675ad6e484daf8c7eb00c115ce5','snapshots',0,0,NULL,1),('2025-12-06 10:18:37','2025-12-06 10:18:40',NULL,0,46,'fa979675ad6e484daf8c7eb00c115ce5','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,47,'68eebcd7dc804fc1b9bdc2fcca919216','volumes',0,0,NULL,1),('2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,48,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',0,0,NULL,1),('2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,49,'68eebcd7dc804fc1b9bdc2fcca919216','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,50,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:39','2025-12-06 10:18:41',NULL,0,51,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots',0,0,NULL,1),('2025-12-06 10:18:39','2025-12-06 10:18:41',NULL,0,52,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:18:47','2025-12-06 10:18:49',NULL,0,53,'8107242293454375a6260c46e0ab59e4','volumes',0,0,NULL,1),('2025-12-06 10:18:47','2025-12-06 10:18:49',NULL,0,54,'8107242293454375a6260c46e0ab59e4','gigabytes',0,0,NULL,1),('2025-12-06 10:18:47','2025-12-06 10:18:49',NULL,0,55,'8107242293454375a6260c46e0ab59e4','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:47','2025-12-06 10:18:49',NULL,0,56,'8107242293454375a6260c46e0ab59e4','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:16',NULL,0,57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:16',NULL,0,58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:16',NULL,0,59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:16',NULL,0,60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:14',NULL,0,61,'2cca2deb59744cdd922204ff50f015d2','volumes',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:14',NULL,0,62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:14',NULL,0,63,'2cca2deb59744cdd922204ff50f015d2','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:18:55','2025-12-06 10:19:14',NULL,0,64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:19:09','2025-12-06 10:19:12',NULL,0,65,'2cca2deb59744cdd922204ff50f015d2','snapshots',0,0,NULL,1),('2025-12-06 10:19:09','2025-12-06 10:19:12',NULL,0,66,'2cca2deb59744cdd922204ff50f015d2','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:19:17','2025-12-06 10:19:42',NULL,0,67,'911a328debfc4f209bacf73debc10fe3','volumes',0,0,NULL,1),('2025-12-06 10:19:17','2025-12-06 10:19:42',NULL,0,68,'911a328debfc4f209bacf73debc10fe3','gigabytes',0,0,NULL,1),('2025-12-06 10:19:17','2025-12-06 10:19:42',NULL,0,69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:19:17','2025-12-06 10:19:42',NULL,0,70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:19:20','2025-12-06 10:19:23',NULL,0,71,'839b049bc4e04682a1654015a92dbbe4','volumes',0,0,NULL,1),('2025-12-06 10:19:20','2025-12-06 10:19:23',NULL,0,72,'839b049bc4e04682a1654015a92dbbe4','gigabytes',0,0,NULL,1),('2025-12-06 10:19:20','2025-12-06 10:19:23',NULL,0,73,'839b049bc4e04682a1654015a92dbbe4','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:19:20','2025-12-06 10:19:23',NULL,0,74,'839b049bc4e04682a1654015a92dbbe4','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:20:11','2025-12-06 10:20:30',NULL,0,75,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes',0,0,NULL,1),('2025-12-06 10:20:11','2025-12-06 10:20:30',NULL,0,76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',0,0,NULL,1),('2025-12-06 10:20:11','2025-12-06 10:20:30',NULL,0,77,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:20:11','2025-12-06 10:20:30',NULL,0,78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:20:12','2025-12-06 10:20:29',NULL,0,79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',0,0,NULL,1),('2025-12-06 10:20:12','2025-12-06 10:20:29',NULL,0,80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:20:36','2025-12-06 10:20:39',NULL,0,81,'889aeebe2fa34e0285e071ed4d74ee04','volumes',0,0,NULL,1),('2025-12-06 10:20:36','2025-12-06 10:20:39',NULL,0,82,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes',0,0,NULL,1),('2025-12-06 10:20:36','2025-12-06 10:20:39',NULL,0,83,'889aeebe2fa34e0285e071ed4d74ee04','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:20:36','2025-12-06 10:20:39',NULL,0,84,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:20:46','2025-12-06 10:20:48',NULL,0,85,'511a934bef1b402c802c2c54d54771e7','volumes',0,0,NULL,1),('2025-12-06 10:20:46','2025-12-06 10:20:48',NULL,0,86,'511a934bef1b402c802c2c54d54771e7','gigabytes',0,0,NULL,1),('2025-12-06 10:20:46','2025-12-06 10:20:48',NULL,0,87,'511a934bef1b402c802c2c54d54771e7','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:20:46','2025-12-06 10:20:48',NULL,0,88,'511a934bef1b402c802c2c54d54771e7','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:20:53','2025-12-06 10:21:08',NULL,0,89,'0862199e316e4225866a9d2f97b97851','groups',0,0,NULL,1),('2025-12-06 10:20:56','2025-12-06 10:21:08',NULL,0,90,'0862199e316e4225866a9d2f97b97851','volumes',0,0,NULL,1),('2025-12-06 10:20:56','2025-12-06 10:21:08',NULL,0,91,'0862199e316e4225866a9d2f97b97851','gigabytes',0,0,NULL,1),('2025-12-06 10:20:56','2025-12-06 10:20:58',NULL,0,92,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1538876885',0,0,NULL,1),('2025-12-06 10:20:56','2025-12-06 10:20:58',NULL,0,93,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1538876885',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:09',NULL,0,94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:09',NULL,0,95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:09',NULL,0,96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:09',NULL,0,97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:08',NULL,0,98,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1333005575',0,0,NULL,1),('2025-12-06 10:21:01','2025-12-06 10:21:08',NULL,0,99,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1333005575',0,0,NULL,1),('2025-12-06 10:21:05','2025-12-06 10:21:07',NULL,0,100,'abf3db88f6aa45ec885a741fbdfeee25','volumes',0,0,NULL,1),('2025-12-06 10:21:05','2025-12-06 10:21:07',NULL,0,101,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes',0,0,NULL,1),('2025-12-06 10:21:05','2025-12-06 10:21:07',NULL,0,102,'abf3db88f6aa45ec885a741fbdfeee25','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:05','2025-12-06 10:21:07',NULL,0,103,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:16','2025-12-06 10:21:18',NULL,0,104,'617e21f2837c4be9825357089f4f14b0','volumes',0,0,NULL,1),('2025-12-06 10:21:16','2025-12-06 10:21:18',NULL,0,105,'617e21f2837c4be9825357089f4f14b0','gigabytes',0,0,NULL,1),('2025-12-06 10:21:16','2025-12-06 10:21:18',NULL,0,106,'617e21f2837c4be9825357089f4f14b0','volumes_tempest-VolumeTypesAccessTest-volume-type-1317874922',0,0,NULL,1),('2025-12-06 10:21:16','2025-12-06 10:21:18',NULL,0,107,'617e21f2837c4be9825357089f4f14b0','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1317874922',0,0,NULL,1),('2025-12-06 10:21:20','2025-12-06 10:21:25',NULL,0,108,'9847f1afa3464dc7b8aac27cb0247e9e','volumes',0,0,NULL,1),('2025-12-06 10:21:20','2025-12-06 10:21:25',NULL,0,109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',0,0,NULL,1),('2025-12-06 10:21:20','2025-12-06 10:21:25',NULL,0,110,'9847f1afa3464dc7b8aac27cb0247e9e','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:20','2025-12-06 10:21:25',NULL,0,111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:21','2025-12-06 10:21:23',NULL,0,112,'be339059edb649ed9bb15e3853dd8f27','volumes',0,0,NULL,1),('2025-12-06 10:21:21','2025-12-06 10:21:23',NULL,0,113,'be339059edb649ed9bb15e3853dd8f27','gigabytes',0,0,NULL,1),('2025-12-06 10:21:21','2025-12-06 10:21:23',NULL,0,114,'be339059edb649ed9bb15e3853dd8f27','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:21','2025-12-06 10:21:23',NULL,0,115,'be339059edb649ed9bb15e3853dd8f27','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:21',NULL,NULL,0,116,'be339059edb649ed9bb15e3853dd8f27','snapshots',0,0,NULL,1),('2025-12-06 10:21:21',NULL,NULL,0,117,'be339059edb649ed9bb15e3853dd8f27','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:21:21',NULL,NULL,0,118,'9847f1afa3464dc7b8aac27cb0247e9e','snapshots',0,0,NULL,1),('2025-12-06 10:21:21',NULL,NULL,0,119,'9847f1afa3464dc7b8aac27cb0247e9e','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:21:27','2025-12-06 10:21:33',NULL,0,120,'1ef7790e4e3343f99faca2d9c608b7f6','volumes',0,0,NULL,1),('2025-12-06 10:21:27','2025-12-06 10:21:33',NULL,0,121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',0,0,NULL,1),('2025-12-06 10:21:27','2025-12-06 10:21:33',NULL,0,122,'1ef7790e4e3343f99faca2d9c608b7f6','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:27','2025-12-06 10:21:33',NULL,0,123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:29','2025-12-06 10:21:30',NULL,0,124,'f0737a9f95674489a78f5f5ca36df954','volumes',0,0,NULL,1),('2025-12-06 10:21:29','2025-12-06 10:21:30',NULL,0,125,'f0737a9f95674489a78f5f5ca36df954','gigabytes',0,0,NULL,1),('2025-12-06 10:21:29','2025-12-06 10:21:30',NULL,0,126,'f0737a9f95674489a78f5f5ca36df954','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:29','2025-12-06 10:21:30',NULL,0,127,'f0737a9f95674489a78f5f5ca36df954','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:29',NULL,NULL,0,128,'f0737a9f95674489a78f5f5ca36df954','snapshots',0,0,NULL,1),('2025-12-06 10:21:29',NULL,NULL,0,129,'f0737a9f95674489a78f5f5ca36df954','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:21:29',NULL,NULL,0,130,'1ef7790e4e3343f99faca2d9c608b7f6','snapshots',0,0,NULL,1),('2025-12-06 10:21:29',NULL,NULL,0,131,'1ef7790e4e3343f99faca2d9c608b7f6','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:21:31','2025-12-06 10:21:42',NULL,0,132,'eab6fb5a053a4a4f8668138357e0b3b6','volumes',0,0,NULL,1),('2025-12-06 10:21:31','2025-12-06 10:21:42',NULL,0,133,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes',0,0,NULL,1),('2025-12-06 10:21:31','2025-12-06 10:21:42',NULL,0,134,'eab6fb5a053a4a4f8668138357e0b3b6','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:31','2025-12-06 10:21:42',NULL,0,135,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:21:33','2025-12-06 10:21:41',NULL,0,136,'eab6fb5a053a4a4f8668138357e0b3b6','backups',0,0,NULL,1),('2025-12-06 10:21:33','2025-12-06 10:21:41',NULL,0,137,'eab6fb5a053a4a4f8668138357e0b3b6','backup_gigabytes',0,0,NULL,1),('2025-12-06 10:21:49','2025-12-06 10:21:55',NULL,0,138,'8566f9acc2b141e2a06f7a1cbef81657','groups',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:21:55',NULL,0,139,'8566f9acc2b141e2a06f7a1cbef81657','volumes',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:21:55',NULL,0,140,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:21:55',NULL,0,141,'8566f9acc2b141e2a06f7a1cbef81657','volumes_tempest-GroupsV314Test-volume-type-1517531844',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:21:55',NULL,0,142,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes_tempest-GroupsV314Test-volume-type-1517531844',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:22:42',NULL,0,143,'fd1c979900294beeb6f273c0e1a6333a','volumes',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:22:42',NULL,0,144,'fd1c979900294beeb6f273c0e1a6333a','gigabytes',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:22:42',NULL,0,145,'fd1c979900294beeb6f273c0e1a6333a','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:21:50','2025-12-06 10:22:42',NULL,0,146,'fd1c979900294beeb6f273c0e1a6333a','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:11','2025-12-06 10:22:14',NULL,0,147,'0869d8bc1b684db8b15afc4eebf3f39d','volumes',0,0,NULL,1),('2025-12-06 10:22:11','2025-12-06 10:22:14',NULL,0,148,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes',0,0,NULL,1),('2025-12-06 10:22:11','2025-12-06 10:22:13',NULL,0,149,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1709855650',0,0,NULL,1),('2025-12-06 10:22:11','2025-12-06 10:22:13',NULL,0,150,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1709855650',0,0,NULL,1),('2025-12-06 10:22:13','2025-12-06 10:22:14',NULL,0,151,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1206940502',0,0,NULL,1),('2025-12-06 10:22:13','2025-12-06 10:22:14',NULL,0,152,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1206940502',0,0,NULL,1),('2025-12-06 10:22:21','2025-12-06 10:22:22',NULL,0,153,'318e19e7541249a9a89016c23feff533','groups',0,0,NULL,1),('2025-12-06 10:22:27','2025-12-06 10:22:55',NULL,0,154,'083713cc3880454487a156230b40fd02','volumes',0,0,NULL,1),('2025-12-06 10:22:27','2025-12-06 10:22:55',NULL,0,155,'083713cc3880454487a156230b40fd02','gigabytes',0,0,NULL,1),('2025-12-06 10:22:27','2025-12-06 10:22:55',NULL,0,156,'083713cc3880454487a156230b40fd02','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:27','2025-12-06 10:22:55',NULL,0,157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:53',NULL,0,158,'083713cc3880454487a156230b40fd02','backups',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:53',NULL,0,159,'083713cc3880454487a156230b40fd02','backup_gigabytes',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:38',NULL,0,160,'190aaeb6184a4deda2f79f6b164f3204','volumes',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:38',NULL,0,161,'190aaeb6184a4deda2f79f6b164f3204','gigabytes',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:38',NULL,0,162,'190aaeb6184a4deda2f79f6b164f3204','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:28','2025-12-06 10:22:38',NULL,0,163,'190aaeb6184a4deda2f79f6b164f3204','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:33','2025-12-06 10:22:40',NULL,0,164,'4b53cb909ca348ccacfc19b982cb4913','backups',0,0,NULL,1),('2025-12-06 10:22:33','2025-12-06 10:22:40',NULL,0,165,'4b53cb909ca348ccacfc19b982cb4913','backup_gigabytes',0,0,NULL,1),('2025-12-06 10:22:36','2025-12-06 10:22:40',NULL,0,166,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',0,0,NULL,1),('2025-12-06 10:22:36','2025-12-06 10:22:40',NULL,0,167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',0,0,NULL,1),('2025-12-06 10:22:36','2025-12-06 10:22:40',NULL,0,168,'709404a5dbce4ee7a79b01c6ddec07bd','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:36','2025-12-06 10:22:40',NULL,0,169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:40','2025-12-06 10:22:41',NULL,0,170,'257a7584f7b14f3fb15fdf774f388f44','volumes',0,0,NULL,1),('2025-12-06 10:22:40','2025-12-06 10:22:41',NULL,0,171,'257a7584f7b14f3fb15fdf774f388f44','gigabytes',0,0,NULL,1),('2025-12-06 10:22:40','2025-12-06 10:22:41',NULL,0,172,'257a7584f7b14f3fb15fdf774f388f44','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:40','2025-12-06 10:22:41',NULL,0,173,'257a7584f7b14f3fb15fdf774f388f44','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:40',NULL,NULL,0,174,'257a7584f7b14f3fb15fdf774f388f44','snapshots',0,0,NULL,1),('2025-12-06 10:22:40',NULL,NULL,0,175,'257a7584f7b14f3fb15fdf774f388f44','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:22:40',NULL,NULL,0,176,'709404a5dbce4ee7a79b01c6ddec07bd','snapshots',0,0,NULL,1),('2025-12-06 10:22:40',NULL,NULL,0,177,'709404a5dbce4ee7a79b01c6ddec07bd','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:22:46','2025-12-06 10:22:54',NULL,0,178,'096aefe63e33405396d6efe65bbb1733','volumes',0,0,NULL,1),('2025-12-06 10:22:46','2025-12-06 10:22:54',NULL,0,179,'096aefe63e33405396d6efe65bbb1733','gigabytes',0,0,NULL,1),('2025-12-06 10:22:46','2025-12-06 10:22:54',NULL,0,180,'096aefe63e33405396d6efe65bbb1733','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:46','2025-12-06 10:22:54',NULL,0,181,'096aefe63e33405396d6efe65bbb1733','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:22:48','2025-12-06 10:22:57',NULL,0,182,'24d6923c0e47455ca133a232d042e0fc','volumes',0,0,NULL,1),('2025-12-06 10:22:48','2025-12-06 10:22:57',NULL,0,183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',0,0,NULL,1),('2025-12-06 10:22:48','2025-12-06 10:22:57',NULL,0,184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:22:48','2025-12-06 10:22:57',NULL,0,185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:01','2025-12-06 10:23:24',NULL,0,186,'0ade48b7157047d2bc354a1299624e2c','volumes',0,0,NULL,1),('2025-12-06 10:23:01','2025-12-06 10:23:24',NULL,0,187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',0,0,NULL,1),('2025-12-06 10:23:01','2025-12-06 10:23:24',NULL,0,188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:23:01','2025-12-06 10:23:24',NULL,0,189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:02','2025-12-06 10:23:21',NULL,0,190,'0ade48b7157047d2bc354a1299624e2c','snapshots',0,0,NULL,1),('2025-12-06 10:23:02','2025-12-06 10:23:21',NULL,0,191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:23:18','2025-12-06 10:24:02',NULL,0,192,'8321907d0a38406c8e7c51f32ab796ad','volumes',0,0,NULL,1),('2025-12-06 10:23:18','2025-12-06 10:24:02',NULL,0,193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',0,0,NULL,1),('2025-12-06 10:23:18','2025-12-06 10:24:02',NULL,0,194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:23:18','2025-12-06 10:24:02',NULL,0,195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:19','2025-12-06 10:23:59',NULL,0,196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',0,0,NULL,1),('2025-12-06 10:23:19','2025-12-06 10:23:59',NULL,0,197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:23:20','2025-12-06 10:23:38',NULL,0,198,'8321907d0a38406c8e7c51f32ab796ad','backups',0,0,NULL,1),('2025-12-06 10:23:20','2025-12-06 10:23:38',NULL,0,199,'8321907d0a38406c8e7c51f32ab796ad','backup_gigabytes',0,0,NULL,1),('2025-12-06 10:23:30','2025-12-06 10:23:37',NULL,0,200,'70f435eabdfe445ab287f469849a5cad','volumes',0,0,NULL,1),('2025-12-06 10:23:30','2025-12-06 10:23:37',NULL,0,201,'70f435eabdfe445ab287f469849a5cad','gigabytes',0,0,NULL,1),('2025-12-06 10:23:30','2025-12-06 10:23:37',NULL,0,202,'70f435eabdfe445ab287f469849a5cad','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:23:30','2025-12-06 10:23:37',NULL,0,203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:32','2025-12-06 10:23:34',NULL,0,204,'e2b088aa0aa04fe8a692c8ef32041e76','volumes',0,0,NULL,1),('2025-12-06 10:23:32','2025-12-06 10:23:34',NULL,0,205,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes',0,0,NULL,1),('2025-12-06 10:23:32','2025-12-06 10:23:34',NULL,0,206,'e2b088aa0aa04fe8a692c8ef32041e76','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:23:32','2025-12-06 10:23:34',NULL,0,207,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:32',NULL,NULL,0,208,'e2b088aa0aa04fe8a692c8ef32041e76','snapshots',0,0,NULL,1),('2025-12-06 10:23:32',NULL,NULL,0,209,'e2b088aa0aa04fe8a692c8ef32041e76','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:23:32',NULL,NULL,0,210,'70f435eabdfe445ab287f469849a5cad','snapshots',0,0,NULL,1),('2025-12-06 10:23:32',NULL,NULL,0,211,'70f435eabdfe445ab287f469849a5cad','snapshots_tripleo',0,0,NULL,1),('2025-12-06 10:23:49','2025-12-06 10:25:28',NULL,0,212,'b51f704fe6204487b0317c3332364cca','volumes',0,0,NULL,1),('2025-12-06 10:23:49','2025-12-06 10:25:28',NULL,0,213,'b51f704fe6204487b0317c3332364cca','gigabytes',0,0,NULL,1),('2025-12-06 10:23:49','2025-12-06 10:25:28',NULL,0,214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:23:49','2025-12-06 10:25:28',NULL,0,215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:23:56','2025-12-06 10:25:18',NULL,0,216,'b51f704fe6204487b0317c3332364cca','backups',0,0,NULL,1),('2025-12-06 10:23:56','2025-12-06 10:25:18',NULL,0,217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',0,0,NULL,1),('2025-12-06 10:25:34','2025-12-06 10:25:45',NULL,0,218,'bccedbe520d34898aad89e97c5258b2b','volumes',0,0,NULL,1),('2025-12-06 10:25:34','2025-12-06 10:25:45',NULL,0,219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',0,0,NULL,1),('2025-12-06 10:25:34','2025-12-06 10:25:45',NULL,0,220,'bccedbe520d34898aad89e97c5258b2b','volumes_tripleo',0,0,NULL,1),('2025-12-06 10:25:34','2025-12-06 10:25:45',NULL,0,221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',0,0,NULL,1),('2025-12-06 10:25:36','2025-12-06 10:25:43',NULL,0,222,'bccedbe520d34898aad89e97c5258b2b','snapshots',0,0,NULL,1),('2025-12-06 10:25:36','2025-12-06 10:25:43',NULL,0,223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',0,0,NULL,1);
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `allocated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`, `allocated`) VALUES (1,'2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',1000,0),(2,'2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','volumes',10,0),(3,'2025-12-06 10:18:38','2025-12-06 10:18:43',NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots',10,0),(4,'2025-12-06 10:18:43',NULL,NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','per_volume_gigabytes',-1,0),(5,'2025-12-06 10:18:43',NULL,NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','backups',10,0),(6,'2025-12-06 10:18:43',NULL,NULL,0,'68eebcd7dc804fc1b9bdc2fcca919216','backup_gigabytes',1000,0),(7,'2025-12-06 10:20:37','2025-12-06 10:20:39',NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes',1000,0),(8,'2025-12-06 10:20:37','2025-12-06 10:20:39',NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','volumes',10,0),(9,'2025-12-06 10:20:39',NULL,NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','per_volume_gigabytes',-1,0),(10,'2025-12-06 10:20:39',NULL,NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','snapshots',10,0),(11,'2025-12-06 10:20:39',NULL,NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','backups',10,0),(12,'2025-12-06 10:20:39',NULL,NULL,0,'889aeebe2fa34e0285e071ed4d74ee04','backup_gigabytes',1000,0),(13,'2025-12-06 10:22:35','2025-12-06 10:22:35','2025-12-06 10:22:35',1,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',15,0),(14,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',10,0),(15,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','per_volume_gigabytes',-1,0),(16,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','snapshots',10,0),(17,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',1000,0),(18,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','backups',10,0),(19,'2025-12-06 10:22:35','2025-12-06 10:22:42',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','backup_gigabytes',1000,0);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `allocated_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  KEY `ix_reservations_usage_id` (`usage_id`),
  KEY `reservations_deleted_uuid_idx` (`deleted`,`uuid`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `ix_reservations_allocated_id` (`allocated_id`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`),
  CONSTRAINT `reservations_ibfk_2` FOREIGN KEY (`allocated_id`) REFERENCES `quotas` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=925 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `allocated_id`) VALUES ('2025-12-06 10:17:33','2025-12-06 10:17:33','2025-12-06 10:17:33',1,1,'a4c0a57a-3427-4e4f-aeb9-108735e2c758',1,'3d64b92c0ac84e00a6e31382047e6db5','groups',1,'2025-12-07 10:17:33',NULL),('2025-12-06 10:17:35','2025-12-06 10:17:35','2025-12-06 10:17:35',1,2,'d830c5ff-7dda-40ad-8c66-0634a3826c07',2,'3d64b92c0ac84e00a6e31382047e6db5','volumes',1,'2025-12-07 10:17:35',NULL),('2025-12-06 10:17:35','2025-12-06 10:17:35','2025-12-06 10:17:35',1,3,'def8857d-6595-47cd-a39f-fd8ad8c5c6b7',3,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes',1,'2025-12-07 10:17:35',NULL),('2025-12-06 10:17:35','2025-12-06 10:17:35','2025-12-06 10:17:35',1,4,'a5987cb8-5032-413d-9341-53f3a1358141',4,'3d64b92c0ac84e00a6e31382047e6db5','volumes_tempest-GroupSnapshotsV319Test-volume-type-552402764',1,'2025-12-07 10:17:35',NULL),('2025-12-06 10:17:35','2025-12-06 10:17:35','2025-12-06 10:17:35',1,5,'7732f92c-cab6-49be-ab5d-d71b9398ffa7',5,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-552402764',1,'2025-12-07 10:17:35',NULL),('2025-12-06 10:17:37','2025-12-06 10:17:37','2025-12-06 10:17:37',1,6,'39766bb1-8943-4aeb-8b5f-2c3216e81c50',6,'3d64b92c0ac84e00a6e31382047e6db5','snapshots',1,'2025-12-07 10:17:37',NULL),('2025-12-06 10:17:37','2025-12-06 10:17:38','2025-12-06 10:17:38',1,7,'84e1683d-e482-407e-a8dc-682d60ba1f5a',3,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes',1,'2025-12-07 10:17:37',NULL),('2025-12-06 10:17:37','2025-12-06 10:17:38','2025-12-06 10:17:38',1,8,'5cceb0b6-87a1-4051-97c6-c2f887511365',5,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-552402764',1,'2025-12-07 10:17:37',NULL),('2025-12-06 10:17:37','2025-12-06 10:17:38','2025-12-06 10:17:38',1,9,'2813478a-c696-4b36-bc11-06ac94830724',7,'3d64b92c0ac84e00a6e31382047e6db5','snapshots_tempest-GroupSnapshotsV319Test-volume-type-552402764',1,'2025-12-07 10:17:37',NULL),('2025-12-06 10:17:41','2025-12-06 10:17:41','2025-12-06 10:17:41',1,10,'7943065a-3f0c-443c-8659-82676ca7c6e6',6,'3d64b92c0ac84e00a6e31382047e6db5','snapshots',-1,'2025-12-07 10:17:41',NULL),('2025-12-06 10:17:41','2025-12-06 10:17:41','2025-12-06 10:17:41',1,11,'59dd418f-dfa7-458d-affe-176d6f42acae',3,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes',-1,'2025-12-07 10:17:41',NULL),('2025-12-06 10:17:41','2025-12-06 10:17:41','2025-12-06 10:17:41',1,12,'d333ec05-fe7b-442c-b8ea-4fa87768686e',5,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-552402764',-1,'2025-12-07 10:17:41',NULL),('2025-12-06 10:17:41','2025-12-06 10:17:41','2025-12-06 10:17:41',1,13,'39ed1200-e44f-475c-8c19-f2393d5c391e',7,'3d64b92c0ac84e00a6e31382047e6db5','snapshots_tempest-GroupSnapshotsV319Test-volume-type-552402764',-1,'2025-12-07 10:17:41',NULL),('2025-12-06 10:17:43','2025-12-06 10:17:43','2025-12-06 10:17:43',1,14,'46f14679-7675-4248-9ebf-67dc6989ae08',1,'3d64b92c0ac84e00a6e31382047e6db5','groups',-1,'2025-12-07 10:17:43',NULL),('2025-12-06 10:17:43','2025-12-06 10:17:43','2025-12-06 10:17:43',1,15,'541282bf-1304-425b-99c7-9dd7295b7a84',2,'3d64b92c0ac84e00a6e31382047e6db5','volumes',-1,'2025-12-07 10:17:43',NULL),('2025-12-06 10:17:43','2025-12-06 10:17:43','2025-12-06 10:17:43',1,16,'528c9d86-71b5-4a2b-bad7-0115ffd6d893',3,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes',-1,'2025-12-07 10:17:43',NULL),('2025-12-06 10:17:43','2025-12-06 10:17:43','2025-12-06 10:17:43',1,17,'ece3af7a-0968-40ce-a460-3b38ca610ca4',4,'3d64b92c0ac84e00a6e31382047e6db5','volumes_tempest-GroupSnapshotsV319Test-volume-type-552402764',-1,'2025-12-07 10:17:43',NULL),('2025-12-06 10:17:43','2025-12-06 10:17:43','2025-12-06 10:17:43',1,18,'9914e95f-4ad6-4b86-acaf-24b2ff81fd61',5,'3d64b92c0ac84e00a6e31382047e6db5','gigabytes_tempest-GroupSnapshotsV319Test-volume-type-552402764',-1,'2025-12-07 10:17:43',NULL),('2025-12-06 10:17:49','2025-12-06 10:17:49','2025-12-06 10:17:49',1,19,'9a526667-f171-4d39-ac60-f5c519a3a367',8,'49b6390c5ae14ddf850d4e9fda870857','groups',1,'2025-12-07 10:17:49',NULL),('2025-12-06 10:17:51','2025-12-06 10:17:51','2025-12-06 10:17:51',1,20,'7b9e0952-fc59-4ef6-a98f-c4d6be15bcc8',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',1,'2025-12-07 10:17:51',NULL),('2025-12-06 10:17:51','2025-12-06 10:17:51','2025-12-06 10:17:51',1,21,'5ab3ac77-0c73-4c8a-918e-f9572bb038ee',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:17:51',NULL),('2025-12-06 10:17:51','2025-12-06 10:17:51','2025-12-06 10:17:51',1,22,'21b6188d-d825-41ea-8aea-31c12edfd6ee',11,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-2067352107',1,'2025-12-07 10:17:51',NULL),('2025-12-06 10:17:51','2025-12-06 10:17:51','2025-12-06 10:17:51',1,23,'01f5293e-a062-47e6-b6ae-d56eda89544a',12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',1,'2025-12-07 10:17:51',NULL),('2025-12-06 10:17:52','2025-12-06 10:17:52','2025-12-06 10:17:52',1,24,'f98be64e-3b30-4b77-b9cb-c8172e494dfb',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',1,'2025-12-07 10:17:52',NULL),('2025-12-06 10:17:52','2025-12-06 10:17:52','2025-12-06 10:17:52',1,25,'747f11da-90b3-433b-a166-a87e2e630e47',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:17:52',NULL),('2025-12-06 10:17:52','2025-12-06 10:17:52','2025-12-06 10:17:52',1,26,'7ba32bec-85df-452f-ba41-1d19d33cf8ae',12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',1,'2025-12-07 10:17:52',NULL),('2025-12-06 10:17:52','2025-12-06 10:17:52','2025-12-06 10:17:52',1,27,'14f09e40-fab7-4c7d-8b27-7f8acdef1ff7',14,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-2067352107',1,'2025-12-07 10:17:52',NULL),('2025-12-06 10:17:54','2025-12-06 10:17:54','2025-12-06 10:17:54',1,28,'74a98c08-353b-4cec-9155-033b2fdd5e81',8,'49b6390c5ae14ddf850d4e9fda870857','groups',1,'2025-12-07 10:17:54',NULL),('2025-12-06 10:17:54','2025-12-06 10:17:54','2025-12-06 10:17:54',1,29,'af87cfba-d339-4ef1-83ab-1def8733e540',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',1,'2025-12-07 10:17:54',NULL),('2025-12-06 10:17:54','2025-12-06 10:17:54','2025-12-06 10:17:54',1,30,'a1d6d38f-7dc2-4fb9-8051-82c7c00340c6',11,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-2067352107',1,'2025-12-07 10:17:54',NULL),('2025-12-06 10:17:56','2025-12-06 10:17:56','2025-12-06 10:17:56',1,31,'46ff54a0-c3a6-4d5d-b161-f1361a7e2137',8,'49b6390c5ae14ddf850d4e9fda870857','groups',-1,'2025-12-07 10:17:56',NULL),('2025-12-06 10:17:56','2025-12-06 10:17:56','2025-12-06 10:17:56',1,32,'e79279c3-2028-48ab-98d7-7b7d26387c31',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',-1,'2025-12-07 10:17:56',NULL),('2025-12-06 10:17:56','2025-12-06 10:17:56','2025-12-06 10:17:56',1,33,'06e4fae8-b1c2-4112-8961-63a4f00420f2',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:17:56',NULL),('2025-12-06 10:17:56','2025-12-06 10:17:56','2025-12-06 10:17:56',1,34,'dff8be1b-50d0-4b6f-9336-1385bfea44ea',11,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:17:56',NULL),('2025-12-06 10:17:56','2025-12-06 10:17:56','2025-12-06 10:17:56',1,35,'0a82d877-b0ed-46fe-af6b-a0298504fbf9',12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:17:56',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,36,'efc0dd80-ed2c-475b-b176-e1dd880e7dee',15,'514ec268f5ca4320a08c7470e3cc5655','volumes',1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,37,'c27cbefe-65ba-4515-bd7b-b9262f46e5bf',16,'514ec268f5ca4320a08c7470e3cc5655','gigabytes',1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,38,'f13cc85b-c7c7-4d77-83a9-e611cbff301d',17,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-1',1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,39,'531a94e5-f2c1-4e5e-a1d6-f4ac64db0b9b',18,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-1',1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,40,'fab1f766-65c6-43eb-ab03-0168f0bc31d2',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',-1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,41,'6d296ffe-83df-48e2-9cb3-d66bb9644f42',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,42,'920c0788-600a-4c16-890f-7d9b92f187b2',12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:17:58',1,43,'f344ae9f-87a3-482c-a073-52d916373fd5',14,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:17:58',NULL),('2025-12-06 10:17:59','2025-12-06 10:18:00','2025-12-06 10:18:00',1,44,'f124ca8c-b464-45eb-b8d1-335c3a991ef8',19,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-2',1,'2025-12-07 10:17:59',NULL),('2025-12-06 10:17:59','2025-12-06 10:18:00','2025-12-06 10:18:00',1,45,'46c1eb92-8dbb-4295-801a-36e9915ac921',20,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-2',1,'2025-12-07 10:17:59',NULL),('2025-12-06 10:17:59','2025-12-06 10:18:00','2025-12-06 10:18:00',1,46,'6767ab60-6376-46bb-a022-afefe57fab5d',17,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-1',-1,'2025-12-07 10:17:59',NULL),('2025-12-06 10:17:59','2025-12-06 10:18:00','2025-12-06 10:18:00',1,47,'8120974e-b66a-4af6-81d5-02095d1f9c3f',18,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-1',-1,'2025-12-07 10:17:59',NULL),('2025-12-06 10:18:00','2025-12-06 10:18:00','2025-12-06 10:18:00',1,48,'29ddd930-dcf5-4af6-bf2c-f78b33df68fa',8,'49b6390c5ae14ddf850d4e9fda870857','groups',-1,'2025-12-07 10:18:00',NULL),('2025-12-06 10:18:00','2025-12-06 10:18:00','2025-12-06 10:18:00',1,49,'da08eefa-fabf-4f42-8746-83a03cbc19b3',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',-1,'2025-12-07 10:18:00',NULL),('2025-12-06 10:18:00','2025-12-06 10:18:00','2025-12-06 10:18:00',1,50,'8b501f86-87c8-4ac6-8961-33ce61ecdbfc',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:00',NULL),('2025-12-06 10:18:00','2025-12-06 10:18:00','2025-12-06 10:18:00',1,51,'78d830af-e264-46b2-befa-7bc31940f6b2',11,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:18:00',NULL),('2025-12-06 10:18:00','2025-12-06 10:18:00','2025-12-06 10:18:00',1,52,'3e855d4d-3f37-4773-9610-27ec932443b2',12,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-2067352107',-1,'2025-12-07 10:18:00',NULL),('2025-12-06 10:18:01','2025-12-06 10:18:01','2025-12-06 10:18:01',1,53,'ef14d752-b232-49b2-bb98-8a2caca8ce2b',8,'49b6390c5ae14ddf850d4e9fda870857','groups',1,'2025-12-07 10:18:01',NULL),('2025-12-06 10:18:01','2025-12-06 10:18:01','2025-12-06 10:18:01',1,54,'51985a9d-e96b-4e7f-b27a-d214675e97a0',15,'514ec268f5ca4320a08c7470e3cc5655','volumes',-1,'2025-12-07 10:18:01',NULL),('2025-12-06 10:18:01','2025-12-06 10:18:01','2025-12-06 10:18:01',1,55,'d77de482-143d-46d8-84ab-2ee3740c152c',16,'514ec268f5ca4320a08c7470e3cc5655','gigabytes',-1,'2025-12-07 10:18:01',NULL),('2025-12-06 10:18:01','2025-12-06 10:18:01','2025-12-06 10:18:01',1,56,'85ffd763-21b7-4c77-8046-864ad13d7f60',19,'514ec268f5ca4320a08c7470e3cc5655','volumes_volume-type-2',-1,'2025-12-07 10:18:01',NULL),('2025-12-06 10:18:01','2025-12-06 10:18:01','2025-12-06 10:18:01',1,57,'57a31efa-ae42-4e20-b3e1-80222a4ed233',20,'514ec268f5ca4320a08c7470e3cc5655','gigabytes_volume-type-2',-1,'2025-12-07 10:18:01',NULL),('2025-12-06 10:18:02','2025-12-06 10:18:02','2025-12-06 10:18:02',1,58,'d793749a-bf55-4a4f-a3b4-549fd9b07f4a',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',1,'2025-12-07 10:18:02',NULL),('2025-12-06 10:18:02','2025-12-06 10:18:02','2025-12-06 10:18:02',1,59,'74aa04a4-d1d0-45b3-b033-76078e530954',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:18:02',NULL),('2025-12-06 10:18:02','2025-12-06 10:18:02','2025-12-06 10:18:02',1,60,'5d3ce431-70d4-4a3e-a4cc-d20098d90fc8',21,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1882379761',1,'2025-12-07 10:18:02',NULL),('2025-12-06 10:18:02','2025-12-06 10:18:02','2025-12-06 10:18:02',1,61,'900f7b60-c008-4020-a1cf-333cbe21786b',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',1,'2025-12-07 10:18:02',NULL),('2025-12-06 10:18:03','2025-12-06 10:18:03','2025-12-06 10:18:03',1,62,'05dedb6a-4fc8-475d-84f8-aa7399c7baf7',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',1,'2025-12-07 10:18:03',NULL),('2025-12-06 10:18:03','2025-12-06 10:18:03','2025-12-06 10:18:03',1,63,'bfb46412-0fd3-463e-845f-315832a06089',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:18:03',NULL),('2025-12-06 10:18:03','2025-12-06 10:18:03','2025-12-06 10:18:03',1,64,'dc1af10f-ec42-4be4-a81c-0ce9def714d7',21,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1882379761',1,'2025-12-07 10:18:03',NULL),('2025-12-06 10:18:03','2025-12-06 10:18:03','2025-12-06 10:18:03',1,65,'a3d02e0a-dd34-4205-b094-2cb01d20b73f',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',1,'2025-12-07 10:18:03',NULL),('2025-12-06 10:18:09','2025-12-06 10:18:09','2025-12-06 10:18:09',1,66,'6f85d748-38a3-473e-93f3-25e7307ab302',23,'82e66d987af642e79e2539d816511c7b','volumes',1,'2025-12-07 10:18:09',NULL),('2025-12-06 10:18:09','2025-12-06 10:18:09','2025-12-06 10:18:09',1,67,'82b979c3-374b-4547-b6e8-de00a3426c81',24,'82e66d987af642e79e2539d816511c7b','gigabytes',1,'2025-12-07 10:18:09',NULL),('2025-12-06 10:18:09','2025-12-06 10:18:09','2025-12-06 10:18:09',1,68,'76af290f-5dd7-4bc5-9122-03793983d2f7',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',1,'2025-12-07 10:18:09',NULL),('2025-12-06 10:18:09','2025-12-06 10:18:09','2025-12-06 10:18:09',1,69,'12dbb2a5-20e4-4be9-97b8-824380a70e52',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',1,'2025-12-07 10:18:09',NULL),('2025-12-06 10:18:10','2025-12-06 10:18:10','2025-12-06 10:18:10',1,70,'73715925-fb11-4dbb-bdc9-352b03195171',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',2,'2025-12-07 10:18:10',NULL),('2025-12-06 10:18:10','2025-12-06 10:18:10','2025-12-06 10:18:10',1,71,'9f67402d-4f2d-4943-b10d-9e7f5647583f',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',2,'2025-12-07 10:18:10',NULL),('2025-12-06 10:18:10','2025-12-06 10:18:10','2025-12-06 10:18:10',1,72,'d4176286-e60b-41d3-9456-8b8b9d29362d',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',2,'2025-12-07 10:18:10',NULL),('2025-12-06 10:18:10','2025-12-06 10:18:10','2025-12-06 10:18:10',1,73,'527a847e-66dc-4e66-b0ae-47b8317452f9',27,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1882379761',2,'2025-12-07 10:18:10',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,74,'0cfc5cbd-dbc3-4e78-a9a5-fd3a359ff276',23,'82e66d987af642e79e2539d816511c7b','volumes',-1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,75,'a51f1717-9b57-4fcf-b1ed-b21b75228cc8',24,'82e66d987af642e79e2539d816511c7b','gigabytes',-1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,76,'4a85dd7b-b193-4486-8fc6-3356400f9f46',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',-1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,77,'4145d7d4-3207-4d8d-af0c-c357c2a06879',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',-1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,78,'4b1a8f8f-2d2b-4e70-9739-61433344a171',23,'82e66d987af642e79e2539d816511c7b','volumes',1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,79,'f6657d0b-ae09-485c-ac51-9d6461f01432',24,'82e66d987af642e79e2539d816511c7b','gigabytes',1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,80,'85e807ac-255e-490e-a028-e6acf15151a5',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:12','2025-12-06 10:18:12','2025-12-06 10:18:12',1,81,'ac16483e-c357-4915-88ab-3f6dadcabe04',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',1,'2025-12-07 10:18:12',NULL),('2025-12-06 10:18:14','2025-12-06 10:18:14','2025-12-06 10:18:14',1,82,'7a5b172c-a3c5-48c2-af4b-83a4acde0244',23,'82e66d987af642e79e2539d816511c7b','volumes',-1,'2025-12-07 10:18:14',NULL),('2025-12-06 10:18:14','2025-12-06 10:18:14','2025-12-06 10:18:14',1,83,'4462ea59-ffdf-4180-9110-0242cccca167',24,'82e66d987af642e79e2539d816511c7b','gigabytes',-1,'2025-12-07 10:18:14',NULL),('2025-12-06 10:18:14','2025-12-06 10:18:14','2025-12-06 10:18:14',1,84,'4dfc81d2-6303-42ca-b634-1c92eb8abb41',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',-1,'2025-12-07 10:18:14',NULL),('2025-12-06 10:18:14','2025-12-06 10:18:14','2025-12-06 10:18:14',1,85,'a86bd32a-2061-4a80-aef3-40e6d4eda333',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',-1,'2025-12-07 10:18:14',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,86,'b43f7103-5f10-4764-b8a8-df6e706ef4f1',23,'82e66d987af642e79e2539d816511c7b','volumes',1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,87,'ecdfb370-35b5-4dc6-a334-c1666e55c3cc',24,'82e66d987af642e79e2539d816511c7b','gigabytes',1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,88,'f3f8cd04-c40f-4e97-8962-3ed3718cf0b0',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,89,'9dff40a1-9f16-49d0-a5ed-188b512f0726',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,90,'d9a256e7-f266-4ed7-b1f0-c11d95a62884',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,91,'5e2d6b6c-4548-4f3b-91d9-c8df212ba731',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,92,'10a45395-ff6c-412e-9ee2-286b2f791af5',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,93,'dff5b8e5-95f3-4ffc-a15b-5ad7de68e01a',27,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,94,'5c681247-6924-40d1-9c94-d51edaeb005f',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,95,'ce0d26f9-16f7-47bb-9254-e128a063204f',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,96,'0aceb979-8f6c-436c-ba83-65ccb1962699',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:15',1,97,'f0ae9fd0-4233-476c-9b58-7e46b8a26ae1',27,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:15',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,98,'33eadba4-f764-432e-ab1a-6d6b14c0e309',8,'49b6390c5ae14ddf850d4e9fda870857','groups',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,99,'d14deeab-3b02-413e-a06a-b21ac7f33374',23,'82e66d987af642e79e2539d816511c7b','volumes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,100,'1749be5d-cdb3-4f0b-aad0-256ee72d816b',24,'82e66d987af642e79e2539d816511c7b','gigabytes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,101,'4d4b5da8-6646-4c41-804c-5170b9ad4c4a',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,102,'f79723ac-9e9f-4303-939b-9699834c0485',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,103,'c37c52fc-babc-46ca-a34b-a14780298895',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,104,'97dec01a-6946-4b8c-9ec4-b7b307bdabd9',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,105,'cab5b883-fb79-458b-a6b0-73b1d5842bd0',21,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,106,'ea2638db-123b-466c-a045-69ff5f9b5c28',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,107,'ab8c32e1-38ba-4a51-bee7-c30a8509ae21',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,108,'26cc6138-3a71-4133-9283-75041e37ea11',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,109,'97648b61-8f4e-4232-aa2a-c8aab3687604',21,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,110,'34f00bc7-0fed-47b5-a56c-a4c9dbdc92db',22,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1882379761',-1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,111,'50cfffcb-ec6c-4470-99bb-8a1d93380393',28,'8d525f3db4524999ac4cbc2a6d6f399f','volumes',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,112,'2a934143-5b62-4bd1-830a-c46c85dadd90',29,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,113,'f06447cb-3786-422b-b6ba-aaf2877e14fe',30,'8d525f3db4524999ac4cbc2a6d6f399f','volumes_tripleo',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,114,'2b9fd24e-140e-4d78-a7ee-ed1a77ae5e80',31,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes_tripleo',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,115,'ceced31e-9a7e-4877-a6bd-f7f21ca9c635',23,'82e66d987af642e79e2539d816511c7b','volumes',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,116,'109e6554-6289-4a3c-b66a-e54466d02c67',24,'82e66d987af642e79e2539d816511c7b','gigabytes',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,117,'99b9a5e6-c624-4258-aa9d-43917796def0',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:17',1,118,'beac39b1-8a2f-4fe9-b693-de2486eb4b4b',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',1,'2025-12-07 10:18:17',NULL),('2025-12-06 10:18:18','2025-12-06 10:18:18','2025-12-06 10:18:18',1,119,'31a59084-3558-4605-8b81-92197cd564a3',8,'49b6390c5ae14ddf850d4e9fda870857','groups',1,'2025-12-07 10:18:18',NULL),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,120,'8b9abc00-3e1f-4366-9fa4-cd390ad10555',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',1,'2025-12-07 10:18:19',NULL),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,121,'d64cbb93-745a-4509-875d-9d00b8e77638',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:18:19',NULL),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,122,'4772de70-ede3-412e-9999-a03ca052b8e7',32,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1726901555',1,'2025-12-07 10:18:19',NULL),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,123,'4d2ed982-cd47-4785-bf71-ed937845caaa',33,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1726901555',1,'2025-12-07 10:18:19',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,124,'ed7a141d-c091-4c26-82c6-527c2fb65767',23,'82e66d987af642e79e2539d816511c7b','volumes',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,125,'56510ef2-a00a-49a2-9b3e-bc5aa26ec755',24,'82e66d987af642e79e2539d816511c7b','gigabytes',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,126,'b793da92-f3dc-4fc1-b9b8-63d58e18179f',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,127,'cfb61a67-e5f3-4e2c-a0a2-d344d6d35dd3',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,128,'ddc6ca69-1588-4133-bb5b-c6ee5e43800b',28,'8d525f3db4524999ac4cbc2a6d6f399f','volumes',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,129,'1dd03a4e-d787-42a2-8bea-be25c39b4c64',29,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,130,'a71f4dff-760d-4e06-89bf-47d69e3c0e61',30,'8d525f3db4524999ac4cbc2a6d6f399f','volumes_tripleo',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,131,'ebeb0fbd-8282-4f73-9220-84150eb86ad4',31,'8d525f3db4524999ac4cbc2a6d6f399f','gigabytes_tripleo',-1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,132,'7cbee26b-7c9f-491a-8694-b1d97b2bd928',23,'82e66d987af642e79e2539d816511c7b','volumes',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,133,'5cde8950-d6f6-48b7-adfa-dd7d3545a9d3',24,'82e66d987af642e79e2539d816511c7b','gigabytes',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,134,'9ed14230-285f-4a46-83a5-61038a1b4ac4',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:20',1,135,'017ab54d-4797-48e8-94e1-9e460273be6e',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:21','2025-12-06 10:18:21','2025-12-06 10:18:21',1,136,'b28668e8-1f30-41cb-a94e-01aedb88ec17',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:21','2025-12-06 10:18:21','2025-12-06 10:18:21',1,137,'05a8ced5-5f95-4a7d-ba9f-e04e3b57358c',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:21','2025-12-06 10:18:21','2025-12-06 10:18:21',1,138,'2c0889df-3702-4eb6-9d28-655314db7593',33,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1726901555',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:21','2025-12-06 10:18:21','2025-12-06 10:18:21',1,139,'603534de-f964-455f-abec-935223a0bf27',34,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1726901555',1,'2025-12-07 10:18:20',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,140,'86f386bc-0515-4074-b529-9517214f89be',23,'82e66d987af642e79e2539d816511c7b','volumes',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,141,'ff63df22-3c84-4a1e-a581-ff448cf6aab3',24,'82e66d987af642e79e2539d816511c7b','gigabytes',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,142,'73f16fec-2810-42b4-845e-f7c059c1fc9e',25,'82e66d987af642e79e2539d816511c7b','volumes_tripleo',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,143,'06066586-b344-4062-bfba-0bb41df63c35',26,'82e66d987af642e79e2539d816511c7b','gigabytes_tripleo',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,144,'3524f9ba-7df4-4e39-9d3e-a409f3cfc462',13,'49b6390c5ae14ddf850d4e9fda870857','snapshots',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,145,'1d45e5ba-5622-4eaa-b3f9-cda8233ed997',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,146,'98e466ea-18d8-4a9a-932c-785f18886f84',33,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1726901555',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:23','2025-12-06 10:18:23','2025-12-06 10:18:23',1,147,'eb20686d-3652-498d-abd2-720a3ed500ba',34,'49b6390c5ae14ddf850d4e9fda870857','snapshots_tempest-GroupSnapshotsTest-volume-type-1726901555',-1,'2025-12-07 10:18:23',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,148,'780bf7e6-97af-4825-b8c0-510d01599b0e',35,'bdae3a4fd57541f391ba58bd701f861c','volumes',1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,149,'9499c9a7-0347-4fff-b46e-584200e4161f',36,'bdae3a4fd57541f391ba58bd701f861c','gigabytes',2,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,150,'0a5b37d9-68ae-4335-81c7-2ea375de5e25',37,'bdae3a4fd57541f391ba58bd701f861c','volumes_tripleo',1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,151,'67e36e5c-44b6-4033-852a-b1409f928134',38,'bdae3a4fd57541f391ba58bd701f861c','gigabytes_tripleo',2,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,152,'0c623952-6461-4c46-83d2-51e928cbb102',8,'49b6390c5ae14ddf850d4e9fda870857','groups',-1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,153,'7ad6452e-714c-4cea-be9f-5f8ac1dda262',9,'49b6390c5ae14ddf850d4e9fda870857','volumes',-1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,154,'646a1d57-a67f-48e4-a88c-bb395c5d06a4',10,'49b6390c5ae14ddf850d4e9fda870857','gigabytes',-1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,155,'c7b23b3c-1678-46ae-829e-c25ceb0cd631',32,'49b6390c5ae14ddf850d4e9fda870857','volumes_tempest-GroupSnapshotsTest-volume-type-1726901555',-1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:24',1,156,'2ecdd8f4-447a-481c-8444-22befa0187f1',33,'49b6390c5ae14ddf850d4e9fda870857','gigabytes_tempest-GroupSnapshotsTest-volume-type-1726901555',-1,'2025-12-07 10:18:24',NULL),('2025-12-06 10:18:25','2025-12-06 10:18:25','2025-12-06 10:18:25',1,157,'2ad0cf3e-73ea-4ff6-90e6-37996c16e5b2',39,'bdae3a4fd57541f391ba58bd701f861c','snapshots',1,'2025-12-07 10:18:25',NULL),('2025-12-06 10:18:25','2025-12-06 10:18:25','2025-12-06 10:18:25',1,158,'476e099d-a005-41f0-ad2e-3fd77f8b86ed',36,'bdae3a4fd57541f391ba58bd701f861c','gigabytes',2,'2025-12-07 10:18:25',NULL),('2025-12-06 10:18:25','2025-12-06 10:18:25','2025-12-06 10:18:25',1,159,'f81755be-e34f-4512-8619-264ad50fc410',38,'bdae3a4fd57541f391ba58bd701f861c','gigabytes_tripleo',2,'2025-12-07 10:18:25',NULL),('2025-12-06 10:18:25','2025-12-06 10:18:25','2025-12-06 10:18:25',1,160,'9c60b8bb-2af9-40e4-8eb4-766cacec7027',40,'bdae3a4fd57541f391ba58bd701f861c','snapshots_tripleo',1,'2025-12-07 10:18:25',NULL),('2025-12-06 10:18:27','2025-12-06 10:18:27','2025-12-06 10:18:27',1,161,'c303e94a-a4aa-4a1b-a403-1bc35db88bf5',39,'bdae3a4fd57541f391ba58bd701f861c','snapshots',-1,'2025-12-07 10:18:27',NULL),('2025-12-06 10:18:27','2025-12-06 10:18:27','2025-12-06 10:18:27',1,162,'9bbd53fd-667d-4920-aabe-cd0402fc5cb5',36,'bdae3a4fd57541f391ba58bd701f861c','gigabytes',-2,'2025-12-07 10:18:27',NULL),('2025-12-06 10:18:27','2025-12-06 10:18:27','2025-12-06 10:18:27',1,163,'7d477db3-ab0c-41f6-a44e-41e75f096e85',38,'bdae3a4fd57541f391ba58bd701f861c','gigabytes_tripleo',-2,'2025-12-07 10:18:27',NULL),('2025-12-06 10:18:27','2025-12-06 10:18:27','2025-12-06 10:18:27',1,164,'78018794-4e03-49c0-bc02-98ea8a7bea27',40,'bdae3a4fd57541f391ba58bd701f861c','snapshots_tripleo',-1,'2025-12-07 10:18:27',NULL),('2025-12-06 10:18:28','2025-12-06 10:18:28','2025-12-06 10:18:28',1,165,'fd1ff918-ea1c-4612-a28a-a93d31c40cf1',35,'bdae3a4fd57541f391ba58bd701f861c','volumes',-1,'2025-12-07 10:18:28',NULL),('2025-12-06 10:18:28','2025-12-06 10:18:28','2025-12-06 10:18:28',1,166,'c94c3397-4d44-4cab-a04c-35a380f18a02',36,'bdae3a4fd57541f391ba58bd701f861c','gigabytes',-2,'2025-12-07 10:18:28',NULL),('2025-12-06 10:18:28','2025-12-06 10:18:28','2025-12-06 10:18:28',1,167,'e6a41515-127c-4c77-8fb4-a7a36e9d5664',37,'bdae3a4fd57541f391ba58bd701f861c','volumes_tripleo',-1,'2025-12-07 10:18:28',NULL),('2025-12-06 10:18:28','2025-12-06 10:18:28','2025-12-06 10:18:28',1,168,'9e51d4d9-2906-4484-ad6f-1344b35c17c4',38,'bdae3a4fd57541f391ba58bd701f861c','gigabytes_tripleo',-2,'2025-12-07 10:18:28',NULL),('2025-12-06 10:18:35','2025-12-06 10:18:35','2025-12-06 10:18:35',1,169,'d5c90367-e5f1-410f-915f-b8063b1a1c78',41,'fa979675ad6e484daf8c7eb00c115ce5','volumes',1,'2025-12-07 10:18:35',NULL),('2025-12-06 10:18:35','2025-12-06 10:18:35','2025-12-06 10:18:35',1,170,'1080f2f7-43e3-454c-9e76-e27bdea63083',42,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes',1,'2025-12-07 10:18:35',NULL),('2025-12-06 10:18:35','2025-12-06 10:18:35','2025-12-06 10:18:35',1,171,'7ee55ea0-c64a-49e8-8a59-9f41fce8d45c',43,'fa979675ad6e484daf8c7eb00c115ce5','volumes_tripleo',1,'2025-12-07 10:18:35',NULL),('2025-12-06 10:18:35','2025-12-06 10:18:35','2025-12-06 10:18:35',1,172,'2753f465-2464-4742-8726-fd9e8148f111',44,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes_tripleo',1,'2025-12-07 10:18:35',NULL),('2025-12-06 10:18:37','2025-12-06 10:18:37','2025-12-06 10:18:37',1,173,'02d15be4-685b-4209-958a-6815ce8c68f9',45,'fa979675ad6e484daf8c7eb00c115ce5','snapshots',1,'2025-12-07 10:18:37',NULL),('2025-12-06 10:18:37','2025-12-06 10:18:37','2025-12-06 10:18:37',1,174,'8288a9c9-f91b-4d53-abbb-204cdb51ed15',42,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes',1,'2025-12-07 10:18:37',NULL),('2025-12-06 10:18:37','2025-12-06 10:18:37','2025-12-06 10:18:37',1,175,'9f6f6aa4-b604-4cd2-9fd6-357faca55291',44,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes_tripleo',1,'2025-12-07 10:18:37',NULL),('2025-12-06 10:18:37','2025-12-06 10:18:37','2025-12-06 10:18:37',1,176,'2bc09a6f-4340-43bd-93ea-77b5ec140fe5',46,'fa979675ad6e484daf8c7eb00c115ce5','snapshots_tripleo',1,'2025-12-07 10:18:37',NULL),('2025-12-06 10:18:38','2025-12-06 10:18:38','2025-12-06 10:18:38',1,177,'5fda0f74-6ec1-4e13-8cb4-78969c8f6269',47,'68eebcd7dc804fc1b9bdc2fcca919216','volumes',1,'2025-12-07 10:18:38',NULL),('2025-12-06 10:18:38','2025-12-06 10:18:38','2025-12-06 10:18:38',1,178,'358d5bea-7d80-4611-8bb8-f6f507246946',48,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',1,'2025-12-07 10:18:38',NULL),('2025-12-06 10:18:38','2025-12-06 10:18:38','2025-12-06 10:18:38',1,179,'bbc89808-7222-4735-a7a4-d7270d1e93d8',49,'68eebcd7dc804fc1b9bdc2fcca919216','volumes_tripleo',1,'2025-12-07 10:18:38',NULL),('2025-12-06 10:18:38','2025-12-06 10:18:38','2025-12-06 10:18:38',1,180,'e0cfeea8-6eae-455a-9d1c-393359908174',50,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes_tripleo',1,'2025-12-07 10:18:38',NULL),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,181,'6c30664a-4d28-4958-88e6-60d42231f508',51,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots',1,'2025-12-07 10:18:39',NULL),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,182,'b90dd3e1-d3f7-418b-bcca-d97c69a7cc51',48,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',1,'2025-12-07 10:18:39',NULL),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,183,'3d4c0dd5-c878-48e4-9165-ec097bbbd1ad',50,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes_tripleo',1,'2025-12-07 10:18:39',NULL),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,184,'389288fa-6dfa-4e2c-8737-4e2a36993cd5',52,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots_tripleo',1,'2025-12-07 10:18:39',NULL),('2025-12-06 10:18:40','2025-12-06 10:18:40','2025-12-06 10:18:40',1,185,'7083231c-b26f-4ebf-88c5-1db88e204922',45,'fa979675ad6e484daf8c7eb00c115ce5','snapshots',-1,'2025-12-07 10:18:40',NULL),('2025-12-06 10:18:40','2025-12-06 10:18:40','2025-12-06 10:18:40',1,186,'b3b90a26-9384-4d98-b032-e9f2337c3c8e',42,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes',-1,'2025-12-07 10:18:40',NULL),('2025-12-06 10:18:40','2025-12-06 10:18:40','2025-12-06 10:18:40',1,187,'a76bf54c-fd5b-4b8e-9ce1-c2dd35549efe',44,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes_tripleo',-1,'2025-12-07 10:18:40',NULL),('2025-12-06 10:18:40','2025-12-06 10:18:40','2025-12-06 10:18:40',1,188,'5d3810f5-ab1f-47b2-b2b8-17c92e156b9f',46,'fa979675ad6e484daf8c7eb00c115ce5','snapshots_tripleo',-1,'2025-12-07 10:18:40',NULL),('2025-12-06 10:18:41','2025-12-06 10:18:41','2025-12-06 10:18:41',1,189,'c4419bd7-01d0-4c58-b27f-0b1eaff8165e',51,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots',-1,'2025-12-07 10:18:41',NULL),('2025-12-06 10:18:41','2025-12-06 10:18:41','2025-12-06 10:18:41',1,190,'ea6d1976-4e41-459e-b90f-4c2ff896e9ae',48,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',-1,'2025-12-07 10:18:41',NULL),('2025-12-06 10:18:41','2025-12-06 10:18:41','2025-12-06 10:18:41',1,191,'f051af9d-c44f-43fc-8ce3-cbfafa51298d',50,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes_tripleo',-1,'2025-12-07 10:18:41',NULL),('2025-12-06 10:18:41','2025-12-06 10:18:41','2025-12-06 10:18:41',1,192,'69c93b17-74d6-4051-af44-71c5ba0e344d',52,'68eebcd7dc804fc1b9bdc2fcca919216','snapshots_tripleo',-1,'2025-12-07 10:18:41',NULL),('2025-12-06 10:18:42','2025-12-06 10:18:42','2025-12-06 10:18:42',1,193,'ca7f8289-cf27-4a8c-809d-b8a7bf1c3bfc',41,'fa979675ad6e484daf8c7eb00c115ce5','volumes',-1,'2025-12-07 10:18:42',NULL),('2025-12-06 10:18:42','2025-12-06 10:18:42','2025-12-06 10:18:42',1,194,'005e3060-df9f-40f9-b289-ff38569aa59a',42,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes',-1,'2025-12-07 10:18:42',NULL),('2025-12-06 10:18:42','2025-12-06 10:18:42','2025-12-06 10:18:42',1,195,'9687e812-8199-4a94-b285-038ad91562b4',43,'fa979675ad6e484daf8c7eb00c115ce5','volumes_tripleo',-1,'2025-12-07 10:18:42',NULL),('2025-12-06 10:18:42','2025-12-06 10:18:42','2025-12-06 10:18:42',1,196,'e4b896d0-1a88-497f-9edb-5bfce0e7ae2e',44,'fa979675ad6e484daf8c7eb00c115ce5','gigabytes_tripleo',-1,'2025-12-07 10:18:42',NULL),('2025-12-06 10:18:43','2025-12-06 10:18:43','2025-12-06 10:18:43',1,197,'c5a5c58d-6962-4cc4-99bc-6f46123c4e2c',47,'68eebcd7dc804fc1b9bdc2fcca919216','volumes',-1,'2025-12-07 10:18:43',NULL),('2025-12-06 10:18:43','2025-12-06 10:18:43','2025-12-06 10:18:43',1,198,'edb72561-1ec4-484c-b6bd-608ddeda2664',48,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes',-1,'2025-12-07 10:18:43',NULL),('2025-12-06 10:18:43','2025-12-06 10:18:43','2025-12-06 10:18:43',1,199,'42428d79-cad5-4a7c-b5fd-9bed7a8a6f2a',49,'68eebcd7dc804fc1b9bdc2fcca919216','volumes_tripleo',-1,'2025-12-07 10:18:43',NULL),('2025-12-06 10:18:43','2025-12-06 10:18:43','2025-12-06 10:18:43',1,200,'6f9a1afe-ae88-49c1-8c82-7e099123861d',50,'68eebcd7dc804fc1b9bdc2fcca919216','gigabytes_tripleo',-1,'2025-12-07 10:18:43',NULL),('2025-12-06 10:18:47','2025-12-06 10:18:47','2025-12-06 10:18:47',1,201,'241827d4-b9df-4e75-b2cd-ed235851f52b',53,'8107242293454375a6260c46e0ab59e4','volumes',1,'2025-12-07 10:18:47',NULL),('2025-12-06 10:18:47','2025-12-06 10:18:47','2025-12-06 10:18:47',1,202,'be44bb56-a960-4068-a51d-46464c88a7e2',54,'8107242293454375a6260c46e0ab59e4','gigabytes',1,'2025-12-07 10:18:47',NULL),('2025-12-06 10:18:47','2025-12-06 10:18:47','2025-12-06 10:18:47',1,203,'7efbc248-6f2d-4f2c-8ccc-a74b2b56be1c',55,'8107242293454375a6260c46e0ab59e4','volumes_tripleo',1,'2025-12-07 10:18:47',NULL),('2025-12-06 10:18:47','2025-12-06 10:18:47','2025-12-06 10:18:47',1,204,'1aa9fa38-83fa-4ff1-90a0-6517c90d46bf',56,'8107242293454375a6260c46e0ab59e4','gigabytes_tripleo',1,'2025-12-07 10:18:47',NULL),('2025-12-06 10:18:49','2025-12-06 10:18:49','2025-12-06 10:18:49',1,205,'31db7e3c-b0ca-44b7-a99f-22f22d689e5d',53,'8107242293454375a6260c46e0ab59e4','volumes',-1,'2025-12-07 10:18:49',NULL),('2025-12-06 10:18:49','2025-12-06 10:18:49','2025-12-06 10:18:49',1,206,'057cc67d-1c2e-4f5f-a047-c8eb90b16dc3',54,'8107242293454375a6260c46e0ab59e4','gigabytes',-1,'2025-12-07 10:18:49',NULL),('2025-12-06 10:18:49','2025-12-06 10:18:49','2025-12-06 10:18:49',1,207,'127d5977-0231-42e2-bb5e-71a6dd9623f1',55,'8107242293454375a6260c46e0ab59e4','volumes_tripleo',-1,'2025-12-07 10:18:49',NULL),('2025-12-06 10:18:49','2025-12-06 10:18:49','2025-12-06 10:18:49',1,208,'954c6438-b9f9-4ef5-949a-00b8e8d51e8a',56,'8107242293454375a6260c46e0ab59e4','gigabytes_tripleo',-1,'2025-12-07 10:18:49',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:55','2025-12-06 10:18:55',1,209,'5d248dce-d65f-4540-8e17-e4b0163d484c',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:55','2025-12-06 10:18:55',1,210,'33ba5208-6269-4e90-a9f7-5f95e0166fb0',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:55','2025-12-06 10:18:55',1,211,'9fc724ae-b5fd-4c64-be96-05ce254205cd',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:55','2025-12-06 10:18:55',1,212,'bb4eef3a-dc48-4fa1-a78f-33098706e251',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:56','2025-12-06 10:18:56',1,213,'2e955230-750a-4ab6-addb-60dbb273c265',61,'2cca2deb59744cdd922204ff50f015d2','volumes',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:56','2025-12-06 10:18:56',1,214,'c3fe1511-e3d3-479a-bbe9-a55117993e33',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:56','2025-12-06 10:18:56',1,215,'7dcdd9a5-ef33-48fc-a374-8ca47d0a0c36',63,'2cca2deb59744cdd922204ff50f015d2','volumes_tripleo',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:18:55','2025-12-06 10:18:56','2025-12-06 10:18:56',1,216,'a0dfc79c-403f-4dfb-95b5-39f7aace0c1b',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',1,'2025-12-07 10:18:55',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,217,'ffde0b73-ffad-4132-abd0-06cfb0008524',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,218,'de33a004-7db0-44b4-b401-824bc5c17ece',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,219,'215eb318-fdd8-4974-b7bd-f1cccc4a01d2',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,220,'397ea1a4-5ee4-4889-8b86-dd9c332fb209',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,221,'395f4f07-8dc4-4d3c-99c2-3960fc005456',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:04','2025-12-06 10:19:04','2025-12-06 10:19:04',1,222,'25e19af8-9b4c-4a62-a2f5-237b56c5fb56',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',1,'2025-12-07 10:19:04',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:06','2025-12-06 10:19:06',1,223,'4b34e18f-60cb-4021-ab2f-1f53e8db6267',61,'2cca2deb59744cdd922204ff50f015d2','volumes',-1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:06','2025-12-06 10:19:06',1,224,'bac4dc2a-20d8-4d88-9282-2410ec426a8b',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',-2,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:06','2025-12-06 10:19:06',1,225,'8c14bea9-7089-4309-b5a0-91443817c042',63,'2cca2deb59744cdd922204ff50f015d2','volumes_tripleo',-1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:06','2025-12-06 10:19:06',1,226,'38a7005d-4b47-4757-a510-765e598cfccd',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',-2,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:07','2025-12-06 10:19:07',1,227,'5ba4c24d-0eea-4696-93bc-5c5b63412a53',61,'2cca2deb59744cdd922204ff50f015d2','volumes',1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:07','2025-12-06 10:19:07',1,228,'7da044b1-e554-4f43-8ed8-fb820dc6c2aa',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:07','2025-12-06 10:19:07',1,229,'43bcd460-102e-44a1-aaa5-d3f63a273de2',63,'2cca2deb59744cdd922204ff50f015d2','volumes_tripleo',1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:06','2025-12-06 10:19:07','2025-12-06 10:19:07',1,230,'d153dae3-4c10-4b9f-b92a-be3ef47e6815',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',1,'2025-12-07 10:19:06',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,231,'a0b6f336-62b3-4c3e-af0b-0d6ea8fe2021',65,'2cca2deb59744cdd922204ff50f015d2','snapshots',1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,232,'9711b2d3-5a62-4f93-946b-f7634b658404',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,233,'e26e4d70-03ec-41c0-bfc4-07148e0a9f14',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,234,'cfd78c30-824c-47d9-a795-97b137c6bc5e',66,'2cca2deb59744cdd922204ff50f015d2','snapshots_tripleo',1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,235,'6f96e4ac-4a8a-4bee-b771-ea5b404acaef',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',-1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,236,'407ae450-4374-482d-99f6-6101c902978a',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',-1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,237,'3e24586f-e062-4a79-ac80-90e59ce9c890',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',-1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:09','2025-12-06 10:19:09','2025-12-06 10:19:09',1,238,'2382d679-3651-4f59-af9e-a006a458aed8',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',-1,'2025-12-07 10:19:09',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,239,'f37e9547-0994-437a-bf43-6fb86e794813',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,240,'77432e49-e4a8-42d1-9b71-e413b7dd72f3',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,241,'bb07406e-b3a0-4363-8dee-e45f91c7adc8',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',-1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,242,'be8df2a0-4ba9-4f6b-84f1-070b3cfb86f5',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',-1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,243,'d8c4c88f-4edb-43c7-9017-48e2f23b5531',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',-1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:10','2025-12-06 10:19:10','2025-12-06 10:19:10',1,244,'61376760-d88e-4779-9a5e-c38e9cc6211e',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',-1,'2025-12-07 10:19:10',NULL),('2025-12-06 10:19:11','2025-12-06 10:19:11','2025-12-06 10:19:11',1,245,'6e32c1a1-4f3a-42e3-ab07-7a37a72fc658',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',1,'2025-12-07 10:19:11',NULL),('2025-12-06 10:19:11','2025-12-06 10:19:11','2025-12-06 10:19:11',1,246,'934ab660-404e-4c81-a324-3087d445bb4a',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',1,'2025-12-07 10:19:11',NULL),('2025-12-06 10:19:11','2025-12-06 10:19:11','2025-12-06 10:19:11',1,247,'2126efac-18cd-4969-8cff-def52798b3ee',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',1,'2025-12-07 10:19:11',NULL),('2025-12-06 10:19:11','2025-12-06 10:19:11','2025-12-06 10:19:11',1,248,'6e36b670-7c1c-4afb-8ee3-9a1a94d64028',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',1,'2025-12-07 10:19:11',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,249,'60b13ded-fb78-4ed9-a116-7e96881a8564',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,250,'21e14bf5-d4af-4a32-9140-22cc70ea2d4c',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',2,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,251,'6dfbcc79-7b73-4780-a4a3-80c5605f3bbf',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,252,'8e5c9318-5dd5-46e8-ad9d-29fd816674d6',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',2,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,253,'788c0c11-24a5-4610-9bff-aa3d2046ac56',65,'2cca2deb59744cdd922204ff50f015d2','snapshots',-1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,254,'ff28e601-2601-43af-ae16-b273379772fd',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',-1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,255,'245df9c2-ae3c-4b42-85e2-42189d6f29f0',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',-1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:12','2025-12-06 10:19:12','2025-12-06 10:19:12',1,256,'20931663-7324-4caf-964a-52f1c7063596',66,'2cca2deb59744cdd922204ff50f015d2','snapshots_tripleo',-1,'2025-12-07 10:19:12',NULL),('2025-12-06 10:19:14','2025-12-06 10:19:14','2025-12-06 10:19:14',1,257,'f3e1827d-dc6d-4b07-ba4d-b8f024cc50a0',61,'2cca2deb59744cdd922204ff50f015d2','volumes',-1,'2025-12-07 10:19:14',NULL),('2025-12-06 10:19:14','2025-12-06 10:19:14','2025-12-06 10:19:14',1,258,'2483ed50-e778-4680-a29a-cfa82a78fefc',62,'2cca2deb59744cdd922204ff50f015d2','gigabytes',-2,'2025-12-07 10:19:14',NULL),('2025-12-06 10:19:14','2025-12-06 10:19:14','2025-12-06 10:19:14',1,259,'9cf64345-26ec-485d-ba9b-54ddcc2f375f',63,'2cca2deb59744cdd922204ff50f015d2','volumes_tripleo',-1,'2025-12-07 10:19:14',NULL),('2025-12-06 10:19:14','2025-12-06 10:19:14','2025-12-06 10:19:14',1,260,'1a9a5443-73ac-4376-a47f-0e2094cf6ab4',64,'2cca2deb59744cdd922204ff50f015d2','gigabytes_tripleo',-2,'2025-12-07 10:19:14',NULL),('2025-12-06 10:19:15','2025-12-06 10:19:15','2025-12-06 10:19:15',1,261,'7e849bb1-8cd9-4d91-8d9f-afb4103adf17',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',-1,'2025-12-07 10:19:15',NULL),('2025-12-06 10:19:15','2025-12-06 10:19:15','2025-12-06 10:19:15',1,262,'7e6e8e2d-2ab7-49c8-bbed-28b4676f33e1',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',-2,'2025-12-07 10:19:15',NULL),('2025-12-06 10:19:15','2025-12-06 10:19:15','2025-12-06 10:19:15',1,263,'c3163774-09d4-4543-9285-dcc1abc37f22',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',-1,'2025-12-07 10:19:15',NULL),('2025-12-06 10:19:15','2025-12-06 10:19:15','2025-12-06 10:19:15',1,264,'e083807f-2f8d-449d-8d96-fc035463bbd5',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',-2,'2025-12-07 10:19:15',NULL),('2025-12-06 10:19:16','2025-12-06 10:19:16','2025-12-06 10:19:16',1,265,'38b65dbf-21a5-496c-ba7c-677426ad5687',57,'d9b02e74009b4dd7b38d073a2a13fed2','volumes',-1,'2025-12-07 10:19:16',NULL),('2025-12-06 10:19:16','2025-12-06 10:19:16','2025-12-06 10:19:16',1,266,'a4269b01-19ca-492f-a3ea-0419ae21518d',58,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes',-1,'2025-12-07 10:19:16',NULL),('2025-12-06 10:19:16','2025-12-06 10:19:16','2025-12-06 10:19:16',1,267,'e29912e8-8779-4dce-a060-0a50867a2ed9',59,'d9b02e74009b4dd7b38d073a2a13fed2','volumes_tripleo',-1,'2025-12-07 10:19:16',NULL),('2025-12-06 10:19:16','2025-12-06 10:19:16','2025-12-06 10:19:16',1,268,'ae29811e-1132-4a90-99f1-9c148e000a4f',60,'d9b02e74009b4dd7b38d073a2a13fed2','gigabytes_tripleo',-1,'2025-12-07 10:19:16',NULL),('2025-12-06 10:19:17','2025-12-06 10:19:17','2025-12-06 10:19:17',1,269,'0d4249ed-411c-43ea-afa1-be622a6b6c1e',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:17',NULL),('2025-12-06 10:19:17','2025-12-06 10:19:17','2025-12-06 10:19:17',1,270,'a5e31f18-0dba-4de0-8f50-0588d4e888e6',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:17',NULL),('2025-12-06 10:19:17','2025-12-06 10:19:17','2025-12-06 10:19:17',1,271,'f6b1e82f-8344-47a1-bf45-36c93fb9e42f',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:17',NULL),('2025-12-06 10:19:17','2025-12-06 10:19:17','2025-12-06 10:19:17',1,272,'20604c08-e804-4bd0-a106-b5845d05a38e',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:17',NULL),('2025-12-06 10:19:19','2025-12-06 10:19:19','2025-12-06 10:19:19',1,273,'a71a6880-914f-406b-b713-db6fa7e2beea',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:19',NULL),('2025-12-06 10:19:19','2025-12-06 10:19:19','2025-12-06 10:19:19',1,274,'34686d0d-103b-4c48-9417-d8ef213db3c6',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:19',NULL),('2025-12-06 10:19:19','2025-12-06 10:19:19','2025-12-06 10:19:19',1,275,'536855a5-9c9e-410b-86ed-9f92f51b4bab',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:19',NULL),('2025-12-06 10:19:19','2025-12-06 10:19:19','2025-12-06 10:19:19',1,276,'3e7a5137-b694-4e9c-8273-d202a2ed627c',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:19',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,277,'483aeffe-f75a-4d52-9077-2fe43ddda58f',71,'839b049bc4e04682a1654015a92dbbe4','volumes',1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,278,'01c32fa1-2604-4440-90d5-94b66b513b3c',72,'839b049bc4e04682a1654015a92dbbe4','gigabytes',2,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,279,'894f4d37-0778-49c1-85cf-cfaf59292359',73,'839b049bc4e04682a1654015a92dbbe4','volumes_tripleo',1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,280,'8aec1592-87bb-4aff-83a2-558d51189f95',74,'839b049bc4e04682a1654015a92dbbe4','gigabytes_tripleo',2,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,281,'765e89ce-6b4e-49a3-8301-50f1fbdca720',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,282,'a3ce9e98-be35-4f5f-a3d0-5de2f2981df1',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,283,'660cc2ac-3cc9-4077-a2a7-d776d42a8442',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:20','2025-12-06 10:19:20','2025-12-06 10:19:20',1,284,'c6f09a05-bc27-45f8-84b0-3d8fbf321a42',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:20',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:22','2025-12-06 10:19:22',1,285,'0feeb08b-a238-4780-b011-a03500a5e509',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:22','2025-12-06 10:19:22',1,286,'29e801cd-c341-4232-ae75-94d62f3b4c32',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:22','2025-12-06 10:19:22',1,287,'e140d3b2-3ba2-49d2-9942-79176ae09b31',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:22','2025-12-06 10:19:22',1,288,'982ec3d4-f575-4218-aaf3-99217d8735ea',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:23','2025-12-06 10:19:23',1,289,'a5237390-0b8a-4503-b45c-4a94b1b7d763',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:23','2025-12-06 10:19:23',1,290,'97da9f19-53db-436e-abe5-a1da996e552e',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:23','2025-12-06 10:19:23',1,291,'ed455acb-cc4e-4b94-b7f8-7bc9b084d786',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:22','2025-12-06 10:19:23','2025-12-06 10:19:23',1,292,'bf082f24-dbcb-421b-972d-a3aac85bf29d',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:22',NULL),('2025-12-06 10:19:23','2025-12-06 10:19:23','2025-12-06 10:19:23',1,293,'c3e151d8-f649-45ff-85a7-a2fec02b8f4c',71,'839b049bc4e04682a1654015a92dbbe4','volumes',-1,'2025-12-07 10:19:23',NULL),('2025-12-06 10:19:23','2025-12-06 10:19:23','2025-12-06 10:19:23',1,294,'21944336-99c4-4c2a-982a-c8dc4a3d1610',72,'839b049bc4e04682a1654015a92dbbe4','gigabytes',-2,'2025-12-07 10:19:23',NULL),('2025-12-06 10:19:23','2025-12-06 10:19:23','2025-12-06 10:19:23',1,295,'1b52b24a-535a-4405-b5bf-40c092f7f908',73,'839b049bc4e04682a1654015a92dbbe4','volumes_tripleo',-1,'2025-12-07 10:19:23',NULL),('2025-12-06 10:19:23','2025-12-06 10:19:23','2025-12-06 10:19:23',1,296,'65192079-aeaa-4012-a314-4c83f2ee7c0a',74,'839b049bc4e04682a1654015a92dbbe4','gigabytes_tripleo',-2,'2025-12-07 10:19:23',NULL),('2025-12-06 10:19:24','2025-12-06 10:19:24','2025-12-06 10:19:24',1,297,'b26acbad-135e-49be-acb2-45763813b27e',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:24',NULL),('2025-12-06 10:19:24','2025-12-06 10:19:24','2025-12-06 10:19:24',1,298,'6e7c3423-e953-44de-ac46-08de0facb86a',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:24',NULL),('2025-12-06 10:19:24','2025-12-06 10:19:24','2025-12-06 10:19:24',1,299,'f0e14bf3-336f-47b1-a61a-c4956df3f475',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:24',NULL),('2025-12-06 10:19:24','2025-12-06 10:19:24','2025-12-06 10:19:24',1,300,'63b3e74a-bbc5-4260-92a5-68f3de67c225',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:24',NULL),('2025-12-06 10:19:25','2025-12-06 10:19:26','2025-12-06 10:19:26',1,301,'f5aa3c2d-f8fe-4b61-bf56-75bce9695984',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:25',NULL),('2025-12-06 10:19:25','2025-12-06 10:19:26','2025-12-06 10:19:26',1,302,'2106729c-1761-4f44-bc10-b12fcaa91a7f',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:25',NULL),('2025-12-06 10:19:25','2025-12-06 10:19:26','2025-12-06 10:19:26',1,303,'978447e9-ee3f-404d-bc8a-471db7dbb081',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:25',NULL),('2025-12-06 10:19:25','2025-12-06 10:19:26','2025-12-06 10:19:26',1,304,'7ced98c3-51db-4dde-9b20-d3f8ba5b6721',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:25',NULL),('2025-12-06 10:19:27','2025-12-06 10:19:27','2025-12-06 10:19:27',1,305,'77257bec-2ed6-44bd-8424-9b9025e2d7ad',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:27',NULL),('2025-12-06 10:19:27','2025-12-06 10:19:27','2025-12-06 10:19:27',1,306,'505977ec-0091-483f-92b8-43ae517c2ad4',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:27',NULL),('2025-12-06 10:19:27','2025-12-06 10:19:27','2025-12-06 10:19:27',1,307,'f2dcb1a1-d9e9-4026-b9c7-6a010aba80bf',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:27',NULL),('2025-12-06 10:19:27','2025-12-06 10:19:27','2025-12-06 10:19:27',1,308,'df071183-af37-4162-a294-a2b928bb412a',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:27',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,309,'8ace1bb1-fd90-4f79-ae05-cb4b011aae10',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,310,'cf6a5fd0-721b-4991-ae16-b9d3b608b97c',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,311,'15588741-c9b7-4aa0-9611-dc9273186781',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,312,'6141d182-f6e1-4efa-80fb-557a58b878f4',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,313,'44e67d6f-da7e-43dc-89d0-7f562401388b',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,314,'83836d1b-4fa0-48b0-82d0-394b9490970a',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,315,'4bf1b374-5672-4ef2-88ed-fc6755a9671a',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29','2025-12-06 10:19:29','2025-12-06 10:19:29',1,316,'20bfc62d-146b-4820-bc7e-07307dda9ca6',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:31','2025-12-06 10:19:31','2025-12-06 10:19:31',1,317,'b569c684-7a5f-4a6c-ab74-858ef070306c',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:31',NULL),('2025-12-06 10:19:31','2025-12-06 10:19:31','2025-12-06 10:19:31',1,318,'6bb65ba1-c923-4c2f-82cd-3db3ef8211fe',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:31',NULL),('2025-12-06 10:19:31','2025-12-06 10:19:31','2025-12-06 10:19:31',1,319,'51ad63e3-fcc1-47ab-a5b0-032302a741ff',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:31',NULL),('2025-12-06 10:19:31','2025-12-06 10:19:31','2025-12-06 10:19:31',1,320,'4ce8b037-39f6-4785-8ff3-12e301cbb736',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:31',NULL),('2025-12-06 10:19:38','2025-12-06 10:19:38','2025-12-06 10:19:38',1,321,'6b3c7db8-5d5f-46c9-8cc2-8122de421a5d',67,'911a328debfc4f209bacf73debc10fe3','volumes',1,'2025-12-07 10:19:38',NULL),('2025-12-06 10:19:38','2025-12-06 10:19:38','2025-12-06 10:19:38',1,322,'be0b390f-462d-469d-b599-8f5b78f636ff',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',1,'2025-12-07 10:19:38',NULL),('2025-12-06 10:19:38','2025-12-06 10:19:38','2025-12-06 10:19:38',1,323,'331e13ba-3145-490b-9019-6044ab871f8d',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',1,'2025-12-07 10:19:38',NULL),('2025-12-06 10:19:38','2025-12-06 10:19:38','2025-12-06 10:19:38',1,324,'42b2d13d-99a6-4ae4-ae2b-31d44eb7eb6b',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',1,'2025-12-07 10:19:38',NULL),('2025-12-06 10:19:40','2025-12-06 10:19:40','2025-12-06 10:19:40',1,325,'ac2fcc17-3c8f-40e0-9d00-4ea4d9a1fdf1',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:40',NULL),('2025-12-06 10:19:40','2025-12-06 10:19:40','2025-12-06 10:19:40',1,326,'a54db6e9-d835-4a5c-b924-7d7627c52361',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:40',NULL),('2025-12-06 10:19:40','2025-12-06 10:19:40','2025-12-06 10:19:40',1,327,'533c9a97-d40a-40e9-9163-3d667aa06906',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:40',NULL),('2025-12-06 10:19:40','2025-12-06 10:19:40','2025-12-06 10:19:40',1,328,'d2f65562-cc39-40aa-a8ff-780aa76b6236',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:40',NULL),('2025-12-06 10:19:42','2025-12-06 10:19:42','2025-12-06 10:19:42',1,329,'c5e9bffe-f032-4a09-ac82-caf7904f0e4c',67,'911a328debfc4f209bacf73debc10fe3','volumes',-1,'2025-12-07 10:19:42',NULL),('2025-12-06 10:19:42','2025-12-06 10:19:42','2025-12-06 10:19:42',1,330,'e5e0cfab-c2ee-418d-9005-39936f4cdef6',68,'911a328debfc4f209bacf73debc10fe3','gigabytes',-1,'2025-12-07 10:19:42',NULL),('2025-12-06 10:19:42','2025-12-06 10:19:42','2025-12-06 10:19:42',1,331,'f661108d-594d-488e-8efe-653678d093cf',69,'911a328debfc4f209bacf73debc10fe3','volumes_tripleo',-1,'2025-12-07 10:19:42',NULL),('2025-12-06 10:19:42','2025-12-06 10:19:42','2025-12-06 10:19:42',1,332,'63bb1b9c-da74-4761-b0f2-64c78a1d3941',70,'911a328debfc4f209bacf73debc10fe3','gigabytes_tripleo',-1,'2025-12-07 10:19:42',NULL),('2025-12-06 10:20:11','2025-12-06 10:20:11','2025-12-06 10:20:11',1,333,'094ebae4-0a9d-40e0-b2e9-9d9ebdec35ab',75,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:11','2025-12-06 10:20:11','2025-12-06 10:20:11',1,334,'7a9ca821-b446-4c96-b8c0-f96eba046308',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:11','2025-12-06 10:20:11','2025-12-06 10:20:11',1,335,'81149dd3-cbda-43a9-9b14-24b4fdcb7bfe',77,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes_tripleo',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:11','2025-12-06 10:20:11','2025-12-06 10:20:11',1,336,'d5b6b604-a447-4620-9c0a-7b387fdfdb46',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:12','2025-12-06 10:20:12','2025-12-06 10:20:12',1,337,'17a24396-3e7f-478c-8b50-fb445cc9360a',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',1,'2025-12-07 10:20:12',NULL),('2025-12-06 10:20:12','2025-12-06 10:20:12','2025-12-06 10:20:12',1,338,'4aea79f5-d957-4596-be4f-f7db123d7094',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:12',NULL),('2025-12-06 10:20:12','2025-12-06 10:20:12','2025-12-06 10:20:12',1,339,'a388558a-d7ec-4098-ae6c-08b1bbfad959',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:12',NULL),('2025-12-06 10:20:12','2025-12-06 10:20:12','2025-12-06 10:20:12',1,340,'b91d21a6-ab72-43ce-85b6-72abc551a071',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',1,'2025-12-07 10:20:12',NULL),('2025-12-06 10:20:15','2025-12-06 10:20:15','2025-12-06 10:20:15',1,341,'5d06553e-73bb-441c-9a21-62b414864256',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',1,'2025-12-07 10:20:14',NULL),('2025-12-06 10:20:15','2025-12-06 10:20:15','2025-12-06 10:20:15',1,342,'27e5a95e-5ddb-40cd-a5c3-a695f5f5c96e',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:14',NULL),('2025-12-06 10:20:15','2025-12-06 10:20:15','2025-12-06 10:20:15',1,343,'7cdcab41-521f-45b1-9b78-0ac6ae41b586',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:14',NULL),('2025-12-06 10:20:15','2025-12-06 10:20:15','2025-12-06 10:20:15',1,344,'fd8d896c-87f6-4ae9-895c-09942770ce7b',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',1,'2025-12-07 10:20:14',NULL),('2025-12-06 10:20:17','2025-12-06 10:20:17','2025-12-06 10:20:17',1,345,'3d21fe6c-b851-46e3-9ce7-bd280c2ef1a8',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',-1,'2025-12-07 10:20:17',NULL),('2025-12-06 10:20:17','2025-12-06 10:20:17','2025-12-06 10:20:17',1,346,'df0557a5-1cc3-4dac-b3c9-415c0f799dfc',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:17',NULL),('2025-12-06 10:20:17','2025-12-06 10:20:17','2025-12-06 10:20:17',1,347,'e09109b2-8801-4874-9945-f85b1f2d63b6',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:17',NULL),('2025-12-06 10:20:17','2025-12-06 10:20:17','2025-12-06 10:20:17',1,348,'e5173e43-e360-4020-9780-9175e7596a97',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',-1,'2025-12-07 10:20:17',NULL),('2025-12-06 10:20:18','2025-12-06 10:20:18','2025-12-06 10:20:18',1,349,'10d517d8-7070-4314-abe4-348bcd7ae440',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:18','2025-12-06 10:20:18','2025-12-06 10:20:18',1,350,'a2b4b681-4657-4149-abcf-a72cd8d416df',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:18','2025-12-06 10:20:18','2025-12-06 10:20:18',1,351,'63eb9afc-f261-463b-a73e-74a89008e06d',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:18','2025-12-06 10:20:18','2025-12-06 10:20:18',1,352,'7b09a7e3-de69-46ac-8374-2059c0f9cd49',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:20','2025-12-06 10:20:20','2025-12-06 10:20:20',1,353,'aa41ec11-c23b-4eef-9c09-dee6ab766710',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',-1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:20','2025-12-06 10:20:20','2025-12-06 10:20:20',1,354,'58bc5539-398d-4c22-b88d-cd16f38e13fd',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:20','2025-12-06 10:20:20','2025-12-06 10:20:20',1,355,'e1d671e5-55e9-43a3-bae9-c8b3cb373c3e',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:20','2025-12-06 10:20:20','2025-12-06 10:20:20',1,356,'fd8a967a-19a4-4ced-af58-95041555cdda',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',-1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:21','2025-12-06 10:20:21','2025-12-06 10:20:21',1,357,'d752fb6b-ca82-481f-b1dc-2bb1ac21b511',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',1,'2025-12-07 10:20:21',NULL),('2025-12-06 10:20:21','2025-12-06 10:20:21','2025-12-06 10:20:21',1,358,'79b508f7-2be8-46b1-90d7-4031054ef6dc',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:21',NULL),('2025-12-06 10:20:21','2025-12-06 10:20:21','2025-12-06 10:20:21',1,359,'b7dd63a9-f1ff-47ea-b42b-e0b1c8095936',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:21',NULL),('2025-12-06 10:20:21','2025-12-06 10:20:21','2025-12-06 10:20:21',1,360,'3e6c86a1-8d41-48b5-941f-10470ed79e70',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',1,'2025-12-07 10:20:21',NULL),('2025-12-06 10:20:23','2025-12-06 10:20:23','2025-12-06 10:20:23',1,361,'612e00ef-3096-4499-9cf1-3e9fa2a268ee',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',-1,'2025-12-07 10:20:23',NULL),('2025-12-06 10:20:23','2025-12-06 10:20:23','2025-12-06 10:20:23',1,362,'69313f68-32a2-4c6f-8947-63e08bc33d74',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:23',NULL),('2025-12-06 10:20:23','2025-12-06 10:20:23','2025-12-06 10:20:23',1,363,'38bdea6b-2557-4fe3-bda7-5c9cdf6d4627',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:23',NULL),('2025-12-06 10:20:23','2025-12-06 10:20:23','2025-12-06 10:20:23',1,364,'9fc5fd42-d547-4c74-96bb-862554c4e130',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',-1,'2025-12-07 10:20:23',NULL),('2025-12-06 10:20:25','2025-12-06 10:20:25','2025-12-06 10:20:25',1,365,'69460dc6-25f4-47ec-9729-0a0492814461',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:25','2025-12-06 10:20:25','2025-12-06 10:20:25',1,366,'ad1150de-a823-4ff9-bb1c-fbdc1e624215',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:25','2025-12-06 10:20:25','2025-12-06 10:20:25',1,367,'4e783769-9662-4f60-96b5-760bd660c489',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:25','2025-12-06 10:20:25','2025-12-06 10:20:25',1,368,'259bb6a8-5351-4934-b85c-5bfe187190fc',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:27','2025-12-06 10:20:27','2025-12-06 10:20:27',1,369,'b8393efb-4334-4704-b813-8e9497d2cc62',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',-1,'2025-12-07 10:20:27',NULL),('2025-12-06 10:20:27','2025-12-06 10:20:27','2025-12-06 10:20:27',1,370,'f5abaa40-2d36-457a-9cb5-8ad1989292f9',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:27',NULL),('2025-12-06 10:20:27','2025-12-06 10:20:27','2025-12-06 10:20:27',1,371,'ab2c09c8-560b-4283-b6f7-62d3ec03b704',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:27',NULL),('2025-12-06 10:20:27','2025-12-06 10:20:27','2025-12-06 10:20:27',1,372,'ed498855-aff2-4ca7-b567-c1cf69648246',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',-1,'2025-12-07 10:20:27',NULL),('2025-12-06 10:20:29','2025-12-06 10:20:29','2025-12-06 10:20:29',1,373,'99bc2d78-8e62-4f30-b6f3-ba8a05f3ee9f',79,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots',-1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29','2025-12-06 10:20:29','2025-12-06 10:20:29',1,374,'2bcf1c97-5cd9-4db0-952d-3fd1ee3db4fc',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29','2025-12-06 10:20:29','2025-12-06 10:20:29',1,375,'0670a22e-070b-47d5-975c-99db4c671807',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29','2025-12-06 10:20:29','2025-12-06 10:20:29',1,376,'5e0f0a8d-a8cf-485b-9d1d-9b6d307ddaf8',80,'6d0a8aa137f541eaa9efa5eddfd19a6b','snapshots_tripleo',-1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:30','2025-12-06 10:20:30','2025-12-06 10:20:30',1,377,'10364344-feeb-4d83-8a90-17ca7711e8ff',75,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes',-1,'2025-12-07 10:20:30',NULL),('2025-12-06 10:20:30','2025-12-06 10:20:30','2025-12-06 10:20:30',1,378,'df82db40-be7f-4381-8485-74aaa75e9d0d',76,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes',-1,'2025-12-07 10:20:30',NULL),('2025-12-06 10:20:30','2025-12-06 10:20:30','2025-12-06 10:20:30',1,379,'80593f65-3009-4793-b2e6-a8be24285df2',77,'6d0a8aa137f541eaa9efa5eddfd19a6b','volumes_tripleo',-1,'2025-12-07 10:20:30',NULL),('2025-12-06 10:20:30','2025-12-06 10:20:30','2025-12-06 10:20:30',1,380,'ea53cbcb-15c1-4c52-85bc-09d13eb10805',78,'6d0a8aa137f541eaa9efa5eddfd19a6b','gigabytes_tripleo',-1,'2025-12-07 10:20:30',NULL),('2025-12-06 10:20:36','2025-12-06 10:20:36','2025-12-06 10:20:36',1,381,'e283368c-8197-4b86-b0eb-78e02677e925',81,'889aeebe2fa34e0285e071ed4d74ee04','volumes',1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:36','2025-12-06 10:20:36','2025-12-06 10:20:36',1,382,'da8ca6d7-adcf-49dc-a9c1-a5010d3d268f',82,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes',1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:36','2025-12-06 10:20:36','2025-12-06 10:20:36',1,383,'4e3beb69-e858-4939-8836-92f8352792cf',83,'889aeebe2fa34e0285e071ed4d74ee04','volumes_tripleo',1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:36','2025-12-06 10:20:36','2025-12-06 10:20:36',1,384,'789c877b-027d-4dae-ba00-672a8e0c5092',84,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes_tripleo',1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:39','2025-12-06 10:20:39','2025-12-06 10:20:39',1,385,'a14078ad-5ec8-4e4c-a918-ffdc566e6967',81,'889aeebe2fa34e0285e071ed4d74ee04','volumes',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:39','2025-12-06 10:20:39','2025-12-06 10:20:39',1,386,'3dd3883a-c3a6-42a4-b2d6-2e67b19c751b',82,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:39','2025-12-06 10:20:39','2025-12-06 10:20:39',1,387,'4c001e89-773e-403f-813b-2c850dbd590b',83,'889aeebe2fa34e0285e071ed4d74ee04','volumes_tripleo',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:39','2025-12-06 10:20:39','2025-12-06 10:20:39',1,388,'1263aa7c-ed70-496f-a0a5-adeb9ae19383',84,'889aeebe2fa34e0285e071ed4d74ee04','gigabytes_tripleo',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:46','2025-12-06 10:20:46','2025-12-06 10:20:46',1,389,'c7815e63-71e0-43bb-a73d-21de330a4ba3',85,'511a934bef1b402c802c2c54d54771e7','volumes',1,'2025-12-07 10:20:46',NULL),('2025-12-06 10:20:46','2025-12-06 10:20:46','2025-12-06 10:20:46',1,390,'4586a3f8-b15e-4b23-a791-b553dadc226c',86,'511a934bef1b402c802c2c54d54771e7','gigabytes',1,'2025-12-07 10:20:46',NULL),('2025-12-06 10:20:46','2025-12-06 10:20:46','2025-12-06 10:20:46',1,391,'881a1b9e-b446-4970-9dd5-8ee8b08263cf',87,'511a934bef1b402c802c2c54d54771e7','volumes_tripleo',1,'2025-12-07 10:20:46',NULL),('2025-12-06 10:20:46','2025-12-06 10:20:46','2025-12-06 10:20:46',1,392,'0ecf297c-a3ab-4e91-91fd-fffd4edd5b53',88,'511a934bef1b402c802c2c54d54771e7','gigabytes_tripleo',1,'2025-12-07 10:20:46',NULL),('2025-12-06 10:20:48','2025-12-06 10:20:48','2025-12-06 10:20:48',1,393,'45abf094-7ac0-4e92-80db-b5b90ff3870b',85,'511a934bef1b402c802c2c54d54771e7','volumes',-1,'2025-12-07 10:20:48',NULL),('2025-12-06 10:20:48','2025-12-06 10:20:48','2025-12-06 10:20:48',1,394,'05c8eb5f-77d6-4dcb-917e-23d293f67e8b',86,'511a934bef1b402c802c2c54d54771e7','gigabytes',-1,'2025-12-07 10:20:48',NULL),('2025-12-06 10:20:48','2025-12-06 10:20:48','2025-12-06 10:20:48',1,395,'86fac704-629c-4512-8c78-6df337406ac5',87,'511a934bef1b402c802c2c54d54771e7','volumes_tripleo',-1,'2025-12-07 10:20:48',NULL),('2025-12-06 10:20:48','2025-12-06 10:20:48','2025-12-06 10:20:48',1,396,'1ef1defd-dfc1-451a-a3d5-0bb681a198b6',88,'511a934bef1b402c802c2c54d54771e7','gigabytes_tripleo',-1,'2025-12-07 10:20:48',NULL),('2025-12-06 10:20:53','2025-12-06 10:20:53','2025-12-06 10:20:53',1,397,'046f03f7-facc-461c-9fcf-bb05e9135667',89,'0862199e316e4225866a9d2f97b97851','groups',1,'2025-12-07 10:20:53',NULL),('2025-12-06 10:20:55','2025-12-06 10:20:55','2025-12-06 10:20:55',1,398,'b8e1e5af-7536-45a4-9d8b-07d8758e528e',89,'0862199e316e4225866a9d2f97b97851','groups',1,'2025-12-07 10:20:55',NULL),('2025-12-06 10:20:56','2025-12-06 10:20:56','2025-12-06 10:20:56',1,399,'2d83bb12-8c61-4a52-bf03-51ad5fc75621',90,'0862199e316e4225866a9d2f97b97851','volumes',1,'2025-12-07 10:20:56',NULL),('2025-12-06 10:20:56','2025-12-06 10:20:56','2025-12-06 10:20:56',1,400,'f27083a9-ad61-40f8-8f68-2e5299cca106',91,'0862199e316e4225866a9d2f97b97851','gigabytes',1,'2025-12-07 10:20:56',NULL),('2025-12-06 10:20:56','2025-12-06 10:20:56','2025-12-06 10:20:56',1,401,'1f8bc277-99dd-474b-b4b4-b9413c18798e',92,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1538876885',1,'2025-12-07 10:20:56',NULL),('2025-12-06 10:20:56','2025-12-06 10:20:56','2025-12-06 10:20:56',1,402,'f18dd413-dc4f-4659-a33b-04cc79dfc0d0',93,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1538876885',1,'2025-12-07 10:20:56',NULL),('2025-12-06 10:20:58','2025-12-06 10:20:58','2025-12-06 10:20:58',1,403,'89e4983c-e2ee-4d66-ad51-ff399612cf09',89,'0862199e316e4225866a9d2f97b97851','groups',-1,'2025-12-07 10:20:58',NULL),('2025-12-06 10:20:58','2025-12-06 10:20:58','2025-12-06 10:20:58',1,404,'187bac13-a876-471b-8eb8-8acab38ff19c',90,'0862199e316e4225866a9d2f97b97851','volumes',-1,'2025-12-07 10:20:58',NULL),('2025-12-06 10:20:58','2025-12-06 10:20:58','2025-12-06 10:20:58',1,405,'0e164e4e-de4b-4fcb-8b43-791c3261c012',91,'0862199e316e4225866a9d2f97b97851','gigabytes',-1,'2025-12-07 10:20:58',NULL),('2025-12-06 10:20:58','2025-12-06 10:20:58','2025-12-06 10:20:58',1,406,'4fcd3862-cb95-4d5c-a6a2-e22164d41113',92,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1538876885',-1,'2025-12-07 10:20:58',NULL),('2025-12-06 10:20:58','2025-12-06 10:20:58','2025-12-06 10:20:58',1,407,'8dbd3892-f4bf-423d-815f-a204d11de3e4',93,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1538876885',-1,'2025-12-07 10:20:58',NULL),('2025-12-06 10:20:59','2025-12-06 10:20:59','2025-12-06 10:20:59',1,408,'f228be52-bb47-4b31-ad70-e0444398f528',89,'0862199e316e4225866a9d2f97b97851','groups',-1,'2025-12-07 10:20:59',NULL),('2025-12-06 10:21:00','2025-12-06 10:21:00','2025-12-06 10:21:00',1,409,'904c6d6b-8496-4f8c-9eeb-5465e7121e96',89,'0862199e316e4225866a9d2f97b97851','groups',1,'2025-12-07 10:21:00',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,410,'0a9cdcf3-0ffb-4b6a-83d1-6be9c2b18d1c',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,411,'94d3e62f-51f0-47c8-a8e0-2a68ca698d6e',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,412,'50054de1-87f7-404e-bafe-431a90627c11',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,413,'0dd2310b-962d-4863-a5f5-ef4f9d66bf77',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,414,'eabec163-0a96-43ed-a9f0-550fce3a7d1a',90,'0862199e316e4225866a9d2f97b97851','volumes',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,415,'959736a0-70b2-4aec-a653-b030a95f3e0a',91,'0862199e316e4225866a9d2f97b97851','gigabytes',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,416,'d0e5dff5-eadb-4201-8bc5-0fe1610e8d83',98,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1333005575',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:01',1,417,'e0ce2df1-7cc6-40eb-a88a-c55fa1244cf8',99,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1333005575',1,'2025-12-07 10:21:01',NULL),('2025-12-06 10:21:02','2025-12-06 10:21:02','2025-12-06 10:21:02',1,418,'71d5d68a-b547-4d72-b658-8bade8572cb0',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',1,'2025-12-07 10:21:02',NULL),('2025-12-06 10:21:02','2025-12-06 10:21:02','2025-12-06 10:21:02',1,419,'aa011f3f-1bfb-4518-82aa-88ef913e9cb8',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',1,'2025-12-07 10:21:02',NULL),('2025-12-06 10:21:02','2025-12-06 10:21:02','2025-12-06 10:21:02',1,420,'9ceeb7e0-8163-4148-8355-5c3d23a92fd8',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',1,'2025-12-07 10:21:02',NULL),('2025-12-06 10:21:02','2025-12-06 10:21:02','2025-12-06 10:21:02',1,421,'a751d153-fce2-4841-b2f7-4a3be1edbe75',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',1,'2025-12-07 10:21:02',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,422,'52904aa6-55a7-4c5c-8608-7d4376b195c3',90,'0862199e316e4225866a9d2f97b97851','volumes',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,423,'00fa4fcd-f0e7-4d72-b7a2-81c908abf0ca',91,'0862199e316e4225866a9d2f97b97851','gigabytes',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,424,'7a5584d0-8eb2-4fa8-af25-dc6ba1a40648',98,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1333005575',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,425,'16334c9d-b919-4d29-a0ac-16d2245fe01c',99,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1333005575',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,426,'b1ed58c8-b46e-44a5-baae-75f88988a5fc',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,427,'1b9c7768-37e1-47b4-a2e8-0592dc0c7607',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,428,'72f354a2-00d8-49d8-8e56-3e85c3d3a565',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:03','2025-12-06 10:21:03','2025-12-06 10:21:03',1,429,'cc2a55b7-91e9-4e0c-9ad1-3656639f6f48',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',1,'2025-12-07 10:21:03',NULL),('2025-12-06 10:21:05','2025-12-06 10:21:05','2025-12-06 10:21:05',1,430,'80fd7752-87dc-4c62-9226-bfba3f8bad7b',100,'abf3db88f6aa45ec885a741fbdfeee25','volumes',1,'2025-12-07 10:21:05',NULL),('2025-12-06 10:21:05','2025-12-06 10:21:05','2025-12-06 10:21:05',1,431,'e20e5552-ea77-4565-aa10-a36500007ec2',101,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes',1,'2025-12-07 10:21:05',NULL),('2025-12-06 10:21:05','2025-12-06 10:21:05','2025-12-06 10:21:05',1,432,'6756e693-98dd-4ab7-a82a-f1bec089f51d',102,'abf3db88f6aa45ec885a741fbdfeee25','volumes_tripleo',1,'2025-12-07 10:21:05',NULL),('2025-12-06 10:21:05','2025-12-06 10:21:05','2025-12-06 10:21:05',1,433,'9eea045a-5849-4eb8-a71a-8bcf80af27b8',103,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes_tripleo',1,'2025-12-07 10:21:05',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,434,'6bb03694-52e1-4e3d-8896-5e11470a4803',100,'abf3db88f6aa45ec885a741fbdfeee25','volumes',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,435,'4f966cb9-797d-42c5-a73f-f80fab73ebb4',101,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,436,'d9a137d4-a6b1-4ea6-8aa9-adb6639fb3a2',102,'abf3db88f6aa45ec885a741fbdfeee25','volumes_tripleo',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,437,'722d38b3-6e35-4df9-bc9e-f75082e1008e',103,'abf3db88f6aa45ec885a741fbdfeee25','gigabytes_tripleo',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,438,'fc464ed3-5dc2-4b4a-b3db-3348ce4d7daa',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,439,'763d97d0-02ea-4d43-ac0e-02744dc79c9c',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,440,'684f8277-1493-4eee-a9f5-2361ddf04cf8',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07','2025-12-06 10:21:07','2025-12-06 10:21:07',1,441,'acf9a92b-955e-4180-8225-069295bf56b6',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,442,'48552d30-a13f-4be7-a59d-4cdcbc6c1071',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,443,'915b2bfa-88ca-4afc-bf95-ddbe5f0dd023',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,444,'c4dd17ab-a71a-4faf-bd82-67b7f47cb710',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,445,'d50aeb78-29c0-4e08-bc11-643eec5f198d',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,446,'65c860a7-9f86-4da3-af38-a7b4f541c303',89,'0862199e316e4225866a9d2f97b97851','groups',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,447,'19139952-3fc0-4f84-8c3b-a53896d204f8',90,'0862199e316e4225866a9d2f97b97851','volumes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,448,'464a256f-ed65-4ee1-afb3-6de7b9875fad',91,'0862199e316e4225866a9d2f97b97851','gigabytes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,449,'2c71b55f-dcb8-4092-afff-51680c469716',98,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1333005575',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,450,'ee75da6e-f385-437f-bc19-706975329efd',99,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1333005575',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,451,'c88c3eac-1d25-4568-83e6-23d079f6ba15',90,'0862199e316e4225866a9d2f97b97851','volumes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,452,'299324bb-5a8b-4c4e-8ff1-db0f57549f8e',91,'0862199e316e4225866a9d2f97b97851','gigabytes',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,453,'feaf2bcd-1698-47cf-a394-ae42c08aba3e',98,'0862199e316e4225866a9d2f97b97851','volumes_tempest-GroupsTest-volume-type-1333005575',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08','2025-12-06 10:21:08','2025-12-06 10:21:08',1,454,'01e0911f-ef78-4bb3-b0c8-a82c06533cb2',99,'0862199e316e4225866a9d2f97b97851','gigabytes_tempest-GroupsTest-volume-type-1333005575',-1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:09','2025-12-06 10:21:09','2025-12-06 10:21:09',1,455,'04308e44-4677-41c4-86e3-12990481f220',94,'7b08d7598dc24ecfb48eb0563cd3107f','volumes',-1,'2025-12-07 10:21:09',NULL),('2025-12-06 10:21:09','2025-12-06 10:21:09','2025-12-06 10:21:09',1,456,'6ba182ed-dce0-4102-9cf7-78c7adac2fad',95,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes',-1,'2025-12-07 10:21:09',NULL),('2025-12-06 10:21:09','2025-12-06 10:21:09','2025-12-06 10:21:09',1,457,'957cbf4b-13d2-46fa-9492-bbfed0546996',96,'7b08d7598dc24ecfb48eb0563cd3107f','volumes_tripleo',-1,'2025-12-07 10:21:09',NULL),('2025-12-06 10:21:09','2025-12-06 10:21:09','2025-12-06 10:21:09',1,458,'56c1825c-b1f6-472e-a51f-06515ce552f7',97,'7b08d7598dc24ecfb48eb0563cd3107f','gigabytes_tripleo',-1,'2025-12-07 10:21:09',NULL),('2025-12-06 10:21:16','2025-12-06 10:21:16','2025-12-06 10:21:16',1,459,'28367adf-fa41-4612-b25b-25730c7dd597',104,'617e21f2837c4be9825357089f4f14b0','volumes',1,'2025-12-07 10:21:16',NULL),('2025-12-06 10:21:16','2025-12-06 10:21:16','2025-12-06 10:21:16',1,460,'07227b8f-4cf9-4aed-b396-fab21b2b43b5',105,'617e21f2837c4be9825357089f4f14b0','gigabytes',1,'2025-12-07 10:21:16',NULL),('2025-12-06 10:21:16','2025-12-06 10:21:16','2025-12-06 10:21:16',1,461,'52a9ca32-58fb-488e-bfad-80cbaf3195ad',106,'617e21f2837c4be9825357089f4f14b0','volumes_tempest-VolumeTypesAccessTest-volume-type-1317874922',1,'2025-12-07 10:21:16',NULL),('2025-12-06 10:21:16','2025-12-06 10:21:16','2025-12-06 10:21:16',1,462,'31ffd6fa-064a-4f64-bdb4-56e610494497',107,'617e21f2837c4be9825357089f4f14b0','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1317874922',1,'2025-12-07 10:21:16',NULL),('2025-12-06 10:21:18','2025-12-06 10:21:18','2025-12-06 10:21:18',1,463,'c187a9dc-0e45-4610-9fdd-cf6573401213',104,'617e21f2837c4be9825357089f4f14b0','volumes',-1,'2025-12-07 10:21:18',NULL),('2025-12-06 10:21:18','2025-12-06 10:21:18','2025-12-06 10:21:18',1,464,'3b6a4f45-9b79-4bf0-8367-0ddace0d574d',105,'617e21f2837c4be9825357089f4f14b0','gigabytes',-1,'2025-12-07 10:21:18',NULL),('2025-12-06 10:21:18','2025-12-06 10:21:18','2025-12-06 10:21:18',1,465,'bdee95cc-fffd-437c-a6af-9c3e731a07eb',106,'617e21f2837c4be9825357089f4f14b0','volumes_tempest-VolumeTypesAccessTest-volume-type-1317874922',-1,'2025-12-07 10:21:18',NULL),('2025-12-06 10:21:18','2025-12-06 10:21:18','2025-12-06 10:21:18',1,466,'1ac6b72a-b605-445d-9b65-9b2dca3ea7d3',107,'617e21f2837c4be9825357089f4f14b0','gigabytes_tempest-VolumeTypesAccessTest-volume-type-1317874922',-1,'2025-12-07 10:21:18',NULL),('2025-12-06 10:21:20','2025-12-06 10:21:20','2025-12-06 10:21:20',1,467,'8e038eeb-b53d-4626-b512-483e05681ac3',108,'9847f1afa3464dc7b8aac27cb0247e9e','volumes',1,'2025-12-07 10:21:20',NULL),('2025-12-06 10:21:20','2025-12-06 10:21:20','2025-12-06 10:21:20',1,468,'bf87d9e3-2566-457b-a385-852422c062d6',109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',1,'2025-12-07 10:21:20',NULL),('2025-12-06 10:21:20','2025-12-06 10:21:20','2025-12-06 10:21:20',1,469,'785bae16-d12b-4f55-af6a-46484caa4af2',110,'9847f1afa3464dc7b8aac27cb0247e9e','volumes_tripleo',1,'2025-12-07 10:21:20',NULL),('2025-12-06 10:21:20','2025-12-06 10:21:20','2025-12-06 10:21:20',1,470,'8d59fe9e-a46a-4ccf-b3eb-f4d43fb81b3a',111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',1,'2025-12-07 10:21:20',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:21','2025-12-06 10:21:21',1,471,'9e75f879-89bb-4c28-a8ad-ac6e585b9685',112,'be339059edb649ed9bb15e3853dd8f27','volumes',1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:21','2025-12-06 10:21:21',1,472,'772b1dd8-387b-47a7-ba1e-e17bb6f4bb41',113,'be339059edb649ed9bb15e3853dd8f27','gigabytes',1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:21','2025-12-06 10:21:21',1,473,'cee36a43-9ebc-468a-86f8-ea0098fb1a9a',114,'be339059edb649ed9bb15e3853dd8f27','volumes_tripleo',1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:21','2025-12-06 10:21:21',1,474,'f058689a-3614-48ca-b0be-8bf8d0c413cb',115,'be339059edb649ed9bb15e3853dd8f27','gigabytes_tripleo',1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,475,'32a70e5b-f863-4dd5-b4ae-bd43d2fbe9ac',108,'9847f1afa3464dc7b8aac27cb0247e9e','volumes',-1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,476,'9e74a305-6260-457e-a18c-8f73b8f167b1',109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',-1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,477,'0f01d644-d9a1-4eea-8348-2add30e80d99',110,'9847f1afa3464dc7b8aac27cb0247e9e','volumes_tripleo',-1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,478,'fd072ed7-1bc6-4e86-af0a-eeda8626c35d',111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',-1,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,479,'145d14ea-1a18-42d6-9cc2-4c22345134ae',116,'be339059edb649ed9bb15e3853dd8f27','snapshots',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,480,'4b00fa6d-ca5c-4e6f-994f-b941a55e516a',113,'be339059edb649ed9bb15e3853dd8f27','gigabytes',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,481,'0314d7ee-e6f2-454c-ab3d-7ff6697adcbb',115,'be339059edb649ed9bb15e3853dd8f27','gigabytes_tripleo',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,482,'2ff26374-3dee-48e3-b0c6-f579365c6f25',117,'be339059edb649ed9bb15e3853dd8f27','snapshots_tripleo',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,483,'92ffdd17-d3a4-40af-b5d0-4c052aadaa47',118,'9847f1afa3464dc7b8aac27cb0247e9e','snapshots',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,484,'f1ca5a3f-dec2-43c3-9ff3-7287b8bffb74',109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,485,'3a38402f-9288-48d4-a55c-b37df4583d61',111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:21','2025-12-06 10:21:22','2025-12-06 10:21:22',1,486,'d8012ae0-1c1e-457e-85c8-80d08ff46f26',119,'9847f1afa3464dc7b8aac27cb0247e9e','snapshots_tripleo',0,'2025-12-07 10:21:21',NULL),('2025-12-06 10:21:22','2025-12-06 10:21:23','2025-12-06 10:21:23',1,487,'debdff32-a8f5-4228-9504-6610e120f9be',112,'be339059edb649ed9bb15e3853dd8f27','volumes',-1,'2025-12-07 10:21:22',NULL),('2025-12-06 10:21:22','2025-12-06 10:21:23','2025-12-06 10:21:23',1,488,'a785f2f7-8699-4471-89db-e154d740e862',113,'be339059edb649ed9bb15e3853dd8f27','gigabytes',-1,'2025-12-07 10:21:22',NULL),('2025-12-06 10:21:22','2025-12-06 10:21:23','2025-12-06 10:21:23',1,489,'2a297ad2-92ae-4cd6-95dc-f9d3362c1cf9',114,'be339059edb649ed9bb15e3853dd8f27','volumes_tripleo',-1,'2025-12-07 10:21:22',NULL),('2025-12-06 10:21:22','2025-12-06 10:21:23','2025-12-06 10:21:23',1,490,'8115b8d1-2363-4f07-b08d-0d0089f935a8',115,'be339059edb649ed9bb15e3853dd8f27','gigabytes_tripleo',-1,'2025-12-07 10:21:22',NULL),('2025-12-06 10:21:23','2025-12-06 10:21:23','2025-12-06 10:21:23',1,491,'f54a57b9-0c2c-4974-96c1-38830f60e1a9',108,'9847f1afa3464dc7b8aac27cb0247e9e','volumes',1,'2025-12-07 10:21:23',NULL),('2025-12-06 10:21:23','2025-12-06 10:21:23','2025-12-06 10:21:23',1,492,'a87b7715-6d3f-40fd-8b15-3242e24546ae',109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',1,'2025-12-07 10:21:23',NULL),('2025-12-06 10:21:23','2025-12-06 10:21:23','2025-12-06 10:21:23',1,493,'a11465da-8182-41e3-af7b-1258a5d9b01d',110,'9847f1afa3464dc7b8aac27cb0247e9e','volumes_tripleo',1,'2025-12-07 10:21:23',NULL),('2025-12-06 10:21:23','2025-12-06 10:21:23','2025-12-06 10:21:23',1,494,'fbfdcded-2108-4a33-b748-27efd15bca20',111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',1,'2025-12-07 10:21:23',NULL),('2025-12-06 10:21:25','2025-12-06 10:21:25','2025-12-06 10:21:25',1,495,'84a844f5-9002-4273-b57a-8cc81e52d37d',108,'9847f1afa3464dc7b8aac27cb0247e9e','volumes',-1,'2025-12-07 10:21:25',NULL),('2025-12-06 10:21:25','2025-12-06 10:21:25','2025-12-06 10:21:25',1,496,'d372b935-3141-4465-b524-05f987374b2e',109,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes',-1,'2025-12-07 10:21:25',NULL),('2025-12-06 10:21:25','2025-12-06 10:21:25','2025-12-06 10:21:25',1,497,'cecdd41a-1371-4327-a4ec-c5a6fc6680c4',110,'9847f1afa3464dc7b8aac27cb0247e9e','volumes_tripleo',-1,'2025-12-07 10:21:25',NULL),('2025-12-06 10:21:25','2025-12-06 10:21:25','2025-12-06 10:21:25',1,498,'b4811e29-c9bd-4390-9725-f9f99e38f91e',111,'9847f1afa3464dc7b8aac27cb0247e9e','gigabytes_tripleo',-1,'2025-12-07 10:21:25',NULL),('2025-12-06 10:21:27','2025-12-06 10:21:27','2025-12-06 10:21:27',1,499,'c0d03bc7-7a1a-405e-b669-ee08790fe7b4',120,'1ef7790e4e3343f99faca2d9c608b7f6','volumes',1,'2025-12-07 10:21:27',NULL),('2025-12-06 10:21:27','2025-12-06 10:21:27','2025-12-06 10:21:27',1,500,'016f0df5-0162-40ed-aaa4-2c121d5c80d8',121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',1,'2025-12-07 10:21:27',NULL),('2025-12-06 10:21:27','2025-12-06 10:21:27','2025-12-06 10:21:27',1,501,'dad50e4e-1ff7-4a0f-9f72-dd27f02a601f',122,'1ef7790e4e3343f99faca2d9c608b7f6','volumes_tripleo',1,'2025-12-07 10:21:27',NULL),('2025-12-06 10:21:27','2025-12-06 10:21:27','2025-12-06 10:21:27',1,502,'b0278414-c5a9-4046-9349-4d90044392d4',123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',1,'2025-12-07 10:21:27',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,503,'fa8a813d-10c8-4382-a94d-f45cf98f4249',124,'f0737a9f95674489a78f5f5ca36df954','volumes',1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,504,'b5dca5fc-1f2b-4451-ad9c-64a904b9f7fd',125,'f0737a9f95674489a78f5f5ca36df954','gigabytes',1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,505,'946eacee-61a1-4f5a-90af-7dc9217b9dd9',126,'f0737a9f95674489a78f5f5ca36df954','volumes_tripleo',1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,506,'11060b95-c39e-4f8a-842c-d2a566f10d20',127,'f0737a9f95674489a78f5f5ca36df954','gigabytes_tripleo',1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,507,'91cdf8fb-78a8-4c8f-9963-f55e5086dcdc',120,'1ef7790e4e3343f99faca2d9c608b7f6','volumes',-1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,508,'328499df-b453-4b3b-8b37-5c74147867f2',121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',-1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,509,'85daec3c-9e62-4306-9cfc-65f804e5f6f2',122,'1ef7790e4e3343f99faca2d9c608b7f6','volumes_tripleo',-1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,510,'b20f5c1d-d447-420e-97c0-671d46bd1a71',123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',-1,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,511,'c1b106a2-b50d-459b-9a1e-56c3ab17ef8a',128,'f0737a9f95674489a78f5f5ca36df954','snapshots',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,512,'55a29e35-3f80-4e39-b8dd-76c53650dde6',125,'f0737a9f95674489a78f5f5ca36df954','gigabytes',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,513,'4d6c2c69-58e8-4222-a488-122388633d5d',127,'f0737a9f95674489a78f5f5ca36df954','gigabytes_tripleo',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,514,'ac05b152-d4e8-4399-b24a-5d6222ad3268',129,'f0737a9f95674489a78f5f5ca36df954','snapshots_tripleo',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,515,'6e904892-db6e-4f43-88a0-f1c6ff2f2b5f',130,'1ef7790e4e3343f99faca2d9c608b7f6','snapshots',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,516,'21bdcfa6-be29-4dbd-afa1-4e358402730a',121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,517,'52bd0218-03c9-43b5-8e09-a1a1f49f6184',123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:29','2025-12-06 10:21:29','2025-12-06 10:21:29',1,518,'de1aee19-3db7-4405-99b8-c833419ff5ae',131,'1ef7790e4e3343f99faca2d9c608b7f6','snapshots_tripleo',0,'2025-12-07 10:21:29',NULL),('2025-12-06 10:21:30','2025-12-06 10:21:30','2025-12-06 10:21:30',1,519,'df3c6f16-a61f-44fb-9ed9-49b256561e5c',124,'f0737a9f95674489a78f5f5ca36df954','volumes',-1,'2025-12-07 10:21:30',NULL),('2025-12-06 10:21:30','2025-12-06 10:21:30','2025-12-06 10:21:30',1,520,'fbfe033f-244d-474c-991c-93c6a1a7eb2c',125,'f0737a9f95674489a78f5f5ca36df954','gigabytes',-1,'2025-12-07 10:21:30',NULL),('2025-12-06 10:21:30','2025-12-06 10:21:30','2025-12-06 10:21:30',1,521,'3318bb6f-f437-4ab3-8e17-386709c56016',126,'f0737a9f95674489a78f5f5ca36df954','volumes_tripleo',-1,'2025-12-07 10:21:30',NULL),('2025-12-06 10:21:30','2025-12-06 10:21:30','2025-12-06 10:21:30',1,522,'7de8cef7-a746-4a93-a10a-345d20ef58a6',127,'f0737a9f95674489a78f5f5ca36df954','gigabytes_tripleo',-1,'2025-12-07 10:21:30',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,523,'7649a565-887b-4f27-bab4-85d2b9e784db',120,'1ef7790e4e3343f99faca2d9c608b7f6','volumes',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,524,'9a8d4008-117f-4255-8265-6cd1c1ea783f',121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,525,'725cf035-3ff1-4bb5-b037-c996e30074ea',122,'1ef7790e4e3343f99faca2d9c608b7f6','volumes_tripleo',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,526,'2579236a-6b58-455d-b37d-7eb0430371f3',123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,527,'6cd81aaa-27b0-4dce-b889-c025ac3166ff',132,'eab6fb5a053a4a4f8668138357e0b3b6','volumes',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,528,'c0437804-bc85-4fde-a650-5a1017fc768a',133,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,529,'3f451053-08ba-47b1-91bd-9691606511a1',134,'eab6fb5a053a4a4f8668138357e0b3b6','volumes_tripleo',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:31',1,530,'4b209363-585e-444a-aaa8-42b23425af5a',135,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes_tripleo',1,'2025-12-07 10:21:31',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,531,'1d0c80bd-b2a8-49de-8c5c-4eb30bce02ad',136,'eab6fb5a053a4a4f8668138357e0b3b6','backups',1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,532,'36e7e5e9-94d8-4066-9d3d-49de0cadb903',137,'eab6fb5a053a4a4f8668138357e0b3b6','backup_gigabytes',1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,533,'ee2805d7-e6eb-41d0-b686-6d3c2b8d813f',120,'1ef7790e4e3343f99faca2d9c608b7f6','volumes',-1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,534,'a80af191-0b28-4459-af88-97f5197bed32',121,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes',-1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,535,'ff348e8b-ec8c-44cc-9434-a9a8fa509df2',122,'1ef7790e4e3343f99faca2d9c608b7f6','volumes_tripleo',-1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:33','2025-12-06 10:21:33','2025-12-06 10:21:33',1,536,'d936d437-55c2-443a-bffa-213b360b8876',123,'1ef7790e4e3343f99faca2d9c608b7f6','gigabytes_tripleo',-1,'2025-12-07 10:21:33',NULL),('2025-12-06 10:21:41','2025-12-06 10:21:41','2025-12-06 10:21:41',1,537,'5288f035-3595-41fa-9e0f-d024b22bf363',136,'eab6fb5a053a4a4f8668138357e0b3b6','backups',-1,'2025-12-07 10:21:41',NULL),('2025-12-06 10:21:41','2025-12-06 10:21:41','2025-12-06 10:21:41',1,538,'abc8a2f8-7655-470a-8697-8e777f098de9',137,'eab6fb5a053a4a4f8668138357e0b3b6','backup_gigabytes',-1,'2025-12-07 10:21:41',NULL),('2025-12-06 10:21:42','2025-12-06 10:21:42','2025-12-06 10:21:42',1,539,'dc0903f2-db36-476b-bd75-4cf5e7ca3069',132,'eab6fb5a053a4a4f8668138357e0b3b6','volumes',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:42','2025-12-06 10:21:42','2025-12-06 10:21:42',1,540,'21beeac7-d829-4307-8919-416fefbeabed',133,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:42','2025-12-06 10:21:42','2025-12-06 10:21:42',1,541,'d72e0b23-14c3-40e0-b0fd-359700df8679',134,'eab6fb5a053a4a4f8668138357e0b3b6','volumes_tripleo',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:42','2025-12-06 10:21:42','2025-12-06 10:21:42',1,542,'badfa073-34c1-44d3-98c1-96f3fc2d23b5',135,'eab6fb5a053a4a4f8668138357e0b3b6','gigabytes_tripleo',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:49','2025-12-06 10:21:49','2025-12-06 10:21:49',1,543,'84f16fab-dd31-48d6-8fdf-6aa86341d807',138,'8566f9acc2b141e2a06f7a1cbef81657','groups',1,'2025-12-07 10:21:49',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,544,'e121c14f-731c-4fd4-bd98-eccca8a04947',139,'8566f9acc2b141e2a06f7a1cbef81657','volumes',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,545,'6d70a815-0554-49c0-a4f8-6d64396e09f5',140,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,546,'5b6160bf-b157-4ba4-9cd6-f9b109c1edb9',141,'8566f9acc2b141e2a06f7a1cbef81657','volumes_tempest-GroupsV314Test-volume-type-1517531844',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,547,'07a48ba4-d5fd-4fbd-8338-4cc32831d224',142,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes_tempest-GroupsV314Test-volume-type-1517531844',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,548,'018e86a3-322c-4047-bcd1-fc0537a00e01',143,'fd1c979900294beeb6f273c0e1a6333a','volumes',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,549,'02f05151-dc5f-4cbd-b103-ffc308d95144',144,'fd1c979900294beeb6f273c0e1a6333a','gigabytes',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,550,'6b45bbb4-f6c2-4703-9dd7-90184219916b',145,'fd1c979900294beeb6f273c0e1a6333a','volumes_tripleo',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:21:50',1,551,'7192c5e0-ae27-4759-811a-f99f4a890c06',146,'fd1c979900294beeb6f273c0e1a6333a','gigabytes_tripleo',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:51','2025-12-06 10:21:51','2025-12-06 10:21:51',1,552,'63b971b0-00ec-4771-98e0-168422df9779',138,'8566f9acc2b141e2a06f7a1cbef81657','groups',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:52','2025-12-06 10:21:52','2025-12-06 10:21:52',1,553,'b1138c75-2578-4ee9-aa5a-16801f42cea9',139,'8566f9acc2b141e2a06f7a1cbef81657','volumes',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:52','2025-12-06 10:21:52','2025-12-06 10:21:52',1,554,'e370aa96-7e6f-44b2-8ab3-886a429c71b7',140,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:52','2025-12-06 10:21:52','2025-12-06 10:21:52',1,555,'06ec37b8-f141-4edd-b2c1-e5841df96514',141,'8566f9acc2b141e2a06f7a1cbef81657','volumes_tempest-GroupsV314Test-volume-type-1517531844',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:52','2025-12-06 10:21:52','2025-12-06 10:21:52',1,556,'910f3bac-fb3a-497e-b8fb-a39e628d3ce8',142,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes_tempest-GroupsV314Test-volume-type-1517531844',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:54','2025-12-06 10:21:54','2025-12-06 10:21:54',1,557,'4b4e0181-8154-46e7-add9-c3bbe866b7d5',138,'8566f9acc2b141e2a06f7a1cbef81657','groups',-1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54','2025-12-06 10:21:54','2025-12-06 10:21:54',1,558,'ce0b74f3-ce15-4572-b8da-944cfc6d1064',139,'8566f9acc2b141e2a06f7a1cbef81657','volumes',-1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54','2025-12-06 10:21:54','2025-12-06 10:21:54',1,559,'282b906f-3c43-4896-97bf-c196bb4572c0',140,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes',-1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54','2025-12-06 10:21:54','2025-12-06 10:21:54',1,560,'35b4f0b4-5627-4bcf-ab1a-1d67ff933eb5',141,'8566f9acc2b141e2a06f7a1cbef81657','volumes_tempest-GroupsV314Test-volume-type-1517531844',-1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54','2025-12-06 10:21:54','2025-12-06 10:21:54',1,561,'8fc6d638-e6b3-40bc-bca9-7bd519b9e678',142,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes_tempest-GroupsV314Test-volume-type-1517531844',-1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:55','2025-12-06 10:21:55','2025-12-06 10:21:55',1,562,'f89873f8-ad0a-4321-ab73-dc18a6d3b4c2',138,'8566f9acc2b141e2a06f7a1cbef81657','groups',-1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55','2025-12-06 10:21:55','2025-12-06 10:21:55',1,563,'af1f512c-0816-48a7-9289-0c2700837220',139,'8566f9acc2b141e2a06f7a1cbef81657','volumes',-1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55','2025-12-06 10:21:55','2025-12-06 10:21:55',1,564,'a8849330-9245-425b-84a4-febae1afdd4f',140,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes',-1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55','2025-12-06 10:21:55','2025-12-06 10:21:55',1,565,'f998b433-c2e2-4eca-b9c4-c022ac817a21',141,'8566f9acc2b141e2a06f7a1cbef81657','volumes_tempest-GroupsV314Test-volume-type-1517531844',-1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55','2025-12-06 10:21:55','2025-12-06 10:21:55',1,566,'5914405f-07d2-4dcd-a53b-278d6c1336dc',142,'8566f9acc2b141e2a06f7a1cbef81657','gigabytes_tempest-GroupsV314Test-volume-type-1517531844',-1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:22:11','2025-12-06 10:22:11','2025-12-06 10:22:11',1,567,'bb577d26-4a32-4a06-8a22-36f4a96da09d',147,'0869d8bc1b684db8b15afc4eebf3f39d','volumes',1,'2025-12-07 10:22:11',NULL),('2025-12-06 10:22:11','2025-12-06 10:22:11','2025-12-06 10:22:11',1,568,'9988c6e0-5b12-45fa-8796-b3ec30ff7d4a',148,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes',1,'2025-12-07 10:22:11',NULL),('2025-12-06 10:22:11','2025-12-06 10:22:11','2025-12-06 10:22:11',1,569,'9b9683d3-2c1a-47c9-9573-1118a927176c',149,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1709855650',1,'2025-12-07 10:22:11',NULL),('2025-12-06 10:22:11','2025-12-06 10:22:11','2025-12-06 10:22:11',1,570,'25058a80-1c91-471c-b711-882feeb801d8',150,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1709855650',1,'2025-12-07 10:22:11',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,571,'26b18e6f-c6d5-4e22-ae52-9d91d1ce551c',147,'0869d8bc1b684db8b15afc4eebf3f39d','volumes',-1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,572,'39bf2aa7-ca9c-48d1-9b1c-799fa6b22f1e',148,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes',-1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,573,'be9731bb-79f9-48e2-abca-ba0c8d47b319',149,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1709855650',-1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,574,'a5e2781c-8659-4e29-a362-3b66a55eddd4',150,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1709855650',-1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,575,'bc43cee4-85a4-4506-a08f-028dc75cd619',147,'0869d8bc1b684db8b15afc4eebf3f39d','volumes',1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,576,'8aba2036-4239-4d94-b055-f5b200259305',148,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes',1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,577,'4f270ee5-df74-4794-a4d2-70cf043a4ddc',151,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1206940502',1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:13',1,578,'af4fee04-038f-447d-ae49-8166c6ecebd0',152,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1206940502',1,'2025-12-07 10:22:13',NULL),('2025-12-06 10:22:14','2025-12-06 10:22:14','2025-12-06 10:22:14',1,579,'53696764-e6b9-4822-9b6a-e8b284fe2342',147,'0869d8bc1b684db8b15afc4eebf3f39d','volumes',-1,'2025-12-07 10:22:14',NULL),('2025-12-06 10:22:14','2025-12-06 10:22:14','2025-12-06 10:22:14',1,580,'fb9c247a-4936-479d-8005-c9743ca927f7',148,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes',-1,'2025-12-07 10:22:14',NULL),('2025-12-06 10:22:14','2025-12-06 10:22:14','2025-12-06 10:22:14',1,581,'7eca5d6f-e943-4d68-a626-64ddf56cb163',151,'0869d8bc1b684db8b15afc4eebf3f39d','volumes_tempest-UserMessagesTest-volume-type-1206940502',-1,'2025-12-07 10:22:14',NULL),('2025-12-06 10:22:14','2025-12-06 10:22:14','2025-12-06 10:22:14',1,582,'5d8ec46e-8161-4f3b-a530-d3f14e7e441f',152,'0869d8bc1b684db8b15afc4eebf3f39d','gigabytes_tempest-UserMessagesTest-volume-type-1206940502',-1,'2025-12-07 10:22:14',NULL),('2025-12-06 10:22:21','2025-12-06 10:22:21','2025-12-06 10:22:21',1,583,'a6470459-edd5-444a-92b6-0f2901bb7c9e',153,'318e19e7541249a9a89016c23feff533','groups',1,'2025-12-07 10:22:21',NULL),('2025-12-06 10:22:22','2025-12-06 10:22:22','2025-12-06 10:22:22',1,584,'3e78eb89-82b7-4c3f-9689-a1eb7be504e8',153,'318e19e7541249a9a89016c23feff533','groups',-1,'2025-12-07 10:22:22',NULL),('2025-12-06 10:22:27','2025-12-06 10:22:27','2025-12-06 10:22:27',1,585,'6b8ef3a2-6382-4705-a8b1-9702e1654750',154,'083713cc3880454487a156230b40fd02','volumes',1,'2025-12-07 10:22:27',NULL),('2025-12-06 10:22:27','2025-12-06 10:22:27','2025-12-06 10:22:27',1,586,'43f77e65-f305-4727-80b4-c5881eaff093',155,'083713cc3880454487a156230b40fd02','gigabytes',1,'2025-12-07 10:22:27',NULL),('2025-12-06 10:22:27','2025-12-06 10:22:27','2025-12-06 10:22:27',1,587,'9d01b312-d4dc-4a4a-8d48-4d4d68800374',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',1,'2025-12-07 10:22:27',NULL),('2025-12-06 10:22:27','2025-12-06 10:22:27','2025-12-06 10:22:27',1,588,'3563508e-2425-4860-9f47-2bb27f2e1721',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',1,'2025-12-07 10:22:27',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,589,'4b9b669c-7cd4-44a0-aa04-f6ed9d1f7ade',158,'083713cc3880454487a156230b40fd02','backups',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,590,'f2734521-d365-4751-bce3-9725cea1036a',159,'083713cc3880454487a156230b40fd02','backup_gigabytes',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,591,'0b82ca47-28a6-45f7-9ce6-66f42a4f1747',160,'190aaeb6184a4deda2f79f6b164f3204','volumes',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,592,'e78376bc-1e89-400c-b55e-dd46282c4ebe',161,'190aaeb6184a4deda2f79f6b164f3204','gigabytes',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,593,'5e3aa117-9a68-475e-b941-43e3bd01ba22',162,'190aaeb6184a4deda2f79f6b164f3204','volumes_tripleo',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28','2025-12-06 10:22:28','2025-12-06 10:22:28',1,594,'156785f8-9f83-41fc-812d-4dd6617908db',163,'190aaeb6184a4deda2f79f6b164f3204','gigabytes_tripleo',1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:33','2025-12-06 10:22:33','2025-12-06 10:22:33',1,595,'31f1db39-b705-4d8c-977f-515c17d773e1',164,'4b53cb909ca348ccacfc19b982cb4913','backups',1,'2025-12-07 10:22:33',NULL),('2025-12-06 10:22:33','2025-12-06 10:22:33','2025-12-06 10:22:33',1,596,'a6a6e1e4-b320-4eb6-ac37-abc9aaed79af',165,'4b53cb909ca348ccacfc19b982cb4913','backup_gigabytes',1,'2025-12-07 10:22:33',NULL),('2025-12-06 10:22:34','2025-12-06 10:22:34','2025-12-06 10:22:34',1,597,'aa9dfb4f-a6e5-4955-bfca-a71b9792a6f4',154,'083713cc3880454487a156230b40fd02','volumes',1,'2025-12-07 10:22:34',NULL),('2025-12-06 10:22:34','2025-12-06 10:22:34','2025-12-06 10:22:34',1,598,'6ad49c3a-7959-4e07-b94a-ccdd0aa53488',155,'083713cc3880454487a156230b40fd02','gigabytes',1,'2025-12-07 10:22:34',NULL),('2025-12-06 10:22:34','2025-12-06 10:22:34','2025-12-06 10:22:34',1,599,'8bd0ba39-cefd-4f56-9281-133f3f1767e3',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',1,'2025-12-07 10:22:34',NULL),('2025-12-06 10:22:34','2025-12-06 10:22:34','2025-12-06 10:22:34',1,600,'60c1dfdf-1697-41ea-abaa-bcc814705e4b',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',1,'2025-12-07 10:22:34',NULL),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:36',1,601,'5974f35f-6c56-4376-af72-cde2cc5bb8d8',166,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',1,'2025-12-07 10:22:36',NULL),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:36',1,602,'8947df61-c697-400c-8b8e-9c41496fe03d',167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',1,'2025-12-07 10:22:36',NULL),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:36',1,603,'6a0f8b29-c0d2-43b2-bf47-7635faa0c4bc',168,'709404a5dbce4ee7a79b01c6ddec07bd','volumes_tripleo',1,'2025-12-07 10:22:36',NULL),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:36',1,604,'6c6c4848-57d1-46cc-84bc-7519c8421678',169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',1,'2025-12-07 10:22:36',NULL),('2025-12-06 10:22:37','2025-12-06 10:22:38','2025-12-06 10:22:38',1,605,'235f5adc-ba79-4748-9559-09150872a72e',160,'190aaeb6184a4deda2f79f6b164f3204','volumes',-1,'2025-12-07 10:22:37',NULL),('2025-12-06 10:22:37','2025-12-06 10:22:38','2025-12-06 10:22:38',1,606,'e93bf012-d0a2-4f04-9963-f0b66866860e',161,'190aaeb6184a4deda2f79f6b164f3204','gigabytes',-1,'2025-12-07 10:22:37',NULL),('2025-12-06 10:22:37','2025-12-06 10:22:38','2025-12-06 10:22:38',1,607,'47a3c5d5-d904-4622-b325-54136709de5f',162,'190aaeb6184a4deda2f79f6b164f3204','volumes_tripleo',-1,'2025-12-07 10:22:37',NULL),('2025-12-06 10:22:37','2025-12-06 10:22:38','2025-12-06 10:22:38',1,608,'ccf1c848-c1d1-405c-8f42-8938b456b095',163,'190aaeb6184a4deda2f79f6b164f3204','gigabytes_tripleo',-1,'2025-12-07 10:22:37',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,609,'c0bf18a6-fc0a-4188-98d6-1afb93e1c49a',166,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,610,'0285bbc1-dc1e-4a4e-85c5-65c370a55d77',167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,611,'495e95ef-2b3a-49f9-bf29-ce1e7bfcce44',168,'709404a5dbce4ee7a79b01c6ddec07bd','volumes_tripleo',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,612,'cddda00c-9ef4-4d61-8970-3caf71dbd02f',169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,613,'4e5c426d-789c-4639-b8dc-7caa0abb8dc9',166,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,614,'3296d800-9400-4517-b495-75aa011a5bab',167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,615,'fa1f01e7-7070-42d0-b7d4-35120b2bb4eb',168,'709404a5dbce4ee7a79b01c6ddec07bd','volumes_tripleo',1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38','2025-12-06 10:22:38','2025-12-06 10:22:38',1,616,'12c1e296-250b-4b8f-b2e9-89fdefeb4de9',169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,617,'22709b65-a91b-4eac-b505-9ce8de4bb936',170,'257a7584f7b14f3fb15fdf774f388f44','volumes',1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,618,'af9a2caa-1f3a-4692-b0c2-31dca6833e67',171,'257a7584f7b14f3fb15fdf774f388f44','gigabytes',1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,619,'f711c4bd-b8c5-4713-97f8-a2e97c4dc9d1',172,'257a7584f7b14f3fb15fdf774f388f44','volumes_tripleo',1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,620,'21b6d4f6-4d7a-420d-ba79-145397ec66f0',173,'257a7584f7b14f3fb15fdf774f388f44','gigabytes_tripleo',1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,621,'821151dd-09e5-4303-ba76-491a7f5db071',166,'709404a5dbce4ee7a79b01c6ddec07bd','volumes',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,622,'880a1238-17eb-46ef-905b-4f75628a6a33',167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,623,'16499b40-0e95-4e19-94dc-98289f9c239d',168,'709404a5dbce4ee7a79b01c6ddec07bd','volumes_tripleo',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,624,'7ec0b820-3737-4d53-af6a-ecad7f3c9da4',169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,625,'3440ab4f-c65f-486b-a312-66857cd51544',174,'257a7584f7b14f3fb15fdf774f388f44','snapshots',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,626,'b84833fa-2f84-46a1-a958-3922688d89a4',171,'257a7584f7b14f3fb15fdf774f388f44','gigabytes',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,627,'8891b142-15ec-4f0e-8001-900c1cb48194',173,'257a7584f7b14f3fb15fdf774f388f44','gigabytes_tripleo',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,628,'c8efcdaf-79c4-45d6-99da-3d50baf42dc2',175,'257a7584f7b14f3fb15fdf774f388f44','snapshots_tripleo',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,629,'3ed63f34-c290-4074-8b82-a97bb7c5a217',176,'709404a5dbce4ee7a79b01c6ddec07bd','snapshots',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,630,'183b8063-7dec-4bc4-964c-ba61bc759f2f',167,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,631,'88ae8d01-748d-4ba5-848c-403a29cfb289',169,'709404a5dbce4ee7a79b01c6ddec07bd','gigabytes_tripleo',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,632,'a67ecc06-d95e-4e35-9464-8af32b23d559',177,'709404a5dbce4ee7a79b01c6ddec07bd','snapshots_tripleo',0,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,633,'5a6d74f4-6cb2-4911-9be4-a5a92f876f43',164,'4b53cb909ca348ccacfc19b982cb4913','backups',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:40','2025-12-06 10:22:40','2025-12-06 10:22:40',1,634,'b5e33ab5-53b1-499f-865a-193c28bd5ab3',165,'4b53cb909ca348ccacfc19b982cb4913','backup_gigabytes',-1,'2025-12-07 10:22:40',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,635,'5cf2c175-3dc5-4eab-bfce-caf701af6c0f',154,'083713cc3880454487a156230b40fd02','volumes',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,636,'e11ca206-000f-4d87-8895-9e7f0c926f44',155,'083713cc3880454487a156230b40fd02','gigabytes',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,637,'97a8f354-7186-41e3-b1c7-32af869b24c3',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,638,'c1af0e0b-72f4-4fe1-8816-2e6bea110b15',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,639,'ab457142-ace6-408a-9163-de323466a7cb',170,'257a7584f7b14f3fb15fdf774f388f44','volumes',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,640,'f8f0e56f-236b-4a72-80a1-782a2bce1052',171,'257a7584f7b14f3fb15fdf774f388f44','gigabytes',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,641,'83d1914e-5f8a-4a80-8570-c941b0db6a63',172,'257a7584f7b14f3fb15fdf774f388f44','volumes_tripleo',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41','2025-12-06 10:22:41','2025-12-06 10:22:41',1,642,'9c3c5dbf-b754-4c19-941e-7a0070888a77',173,'257a7584f7b14f3fb15fdf774f388f44','gigabytes_tripleo',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:42','2025-12-06 10:22:42','2025-12-06 10:22:42',1,643,'6824ce0c-6a2d-493d-b967-3c1ad521c736',143,'fd1c979900294beeb6f273c0e1a6333a','volumes',-1,'2025-12-07 10:22:42',NULL),('2025-12-06 10:22:42','2025-12-06 10:22:42','2025-12-06 10:22:42',1,644,'bbe931fd-df71-4af5-84c9-0d3495147ecf',144,'fd1c979900294beeb6f273c0e1a6333a','gigabytes',-1,'2025-12-07 10:22:42',NULL),('2025-12-06 10:22:42','2025-12-06 10:22:42','2025-12-06 10:22:42',1,645,'49f8ff70-292a-4421-a303-e896fb63667f',145,'fd1c979900294beeb6f273c0e1a6333a','volumes_tripleo',-1,'2025-12-07 10:22:42',NULL),('2025-12-06 10:22:42','2025-12-06 10:22:42','2025-12-06 10:22:42',1,646,'91fca057-bf84-4d73-9892-8f7b3287116f',146,'fd1c979900294beeb6f273c0e1a6333a','gigabytes_tripleo',-1,'2025-12-07 10:22:42',NULL),('2025-12-06 10:22:43','2025-12-06 10:22:43','2025-12-06 10:22:43',1,647,'1e521abb-c5bb-42ce-9d0f-dc65afb69f3c',158,'083713cc3880454487a156230b40fd02','backups',-1,'2025-12-07 10:22:43',NULL),('2025-12-06 10:22:43','2025-12-06 10:22:43','2025-12-06 10:22:43',1,648,'7d6d0e5b-f5e0-429e-9661-bc6fe2dc004d',159,'083713cc3880454487a156230b40fd02','backup_gigabytes',-1,'2025-12-07 10:22:43',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,649,'a93dd5fc-1832-43ff-9999-f9a0dfd55dcb',154,'083713cc3880454487a156230b40fd02','volumes',-1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,650,'a8eafdb3-8404-454d-94cb-9d7024979f7b',155,'083713cc3880454487a156230b40fd02','gigabytes',-1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,651,'242df3e9-8a77-4f9f-ae2c-f0b8f1fa660f',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',-1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,652,'31dfbfff-4d9e-4c5d-9549-5947998ec2e5',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',-1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,653,'54b6ee15-c6bf-4ccb-8827-59869893c836',154,'083713cc3880454487a156230b40fd02','volumes',1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,654,'ec89a1a9-17f6-4e23-ae1d-5e0bbabffe1e',155,'083713cc3880454487a156230b40fd02','gigabytes',1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,655,'4b1f0181-7739-47ee-af18-0d86d568ef8c',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:45','2025-12-06 10:22:45','2025-12-06 10:22:45',1,656,'0fe8ce0b-1d57-4a2e-93cb-85dac52dd00b',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',1,'2025-12-07 10:22:45',NULL),('2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:46',1,657,'4d18d7fa-54dc-4a97-b2cb-2a4a4548a89b',178,'096aefe63e33405396d6efe65bbb1733','volumes',1,'2025-12-07 10:22:46',NULL),('2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:46',1,658,'22182c54-94fe-4a5b-8f0a-40229a8d96fa',179,'096aefe63e33405396d6efe65bbb1733','gigabytes',1,'2025-12-07 10:22:46',NULL),('2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:46',1,659,'2f648fc2-63ac-498b-804f-c898a5added6',180,'096aefe63e33405396d6efe65bbb1733','volumes_tripleo',1,'2025-12-07 10:22:46',NULL),('2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:46',1,660,'580ffef6-e9e1-4061-b4fe-5d82f2384d1a',181,'096aefe63e33405396d6efe65bbb1733','gigabytes_tripleo',1,'2025-12-07 10:22:46',NULL),('2025-12-06 10:22:47','2025-12-06 10:22:47','2025-12-06 10:22:47',1,661,'ad969713-e5b3-4334-96f6-c494ccc88f3e',158,'083713cc3880454487a156230b40fd02','backups',1,'2025-12-07 10:22:47',NULL),('2025-12-06 10:22:47','2025-12-06 10:22:47','2025-12-06 10:22:47',1,662,'46f4cce5-99a6-4a93-8b19-705c5cccceb5',159,'083713cc3880454487a156230b40fd02','backup_gigabytes',1,'2025-12-07 10:22:47',NULL),('2025-12-06 10:22:48','2025-12-06 10:22:49','2025-12-06 10:22:49',1,663,'dfe2a2e7-c68c-4b39-8346-4974c135931a',182,'24d6923c0e47455ca133a232d042e0fc','volumes',1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:48','2025-12-06 10:22:49','2025-12-06 10:22:49',1,664,'ad35401f-3526-4062-980b-3d127ab11623',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:48','2025-12-06 10:22:49','2025-12-06 10:22:49',1,665,'485dee18-7bb2-4738-98cf-1df88105198d',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:48','2025-12-06 10:22:49','2025-12-06 10:22:49',1,666,'424ad7b5-1471-40c2-9d4c-7153fe2b0151',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:50','2025-12-06 10:22:50','2025-12-06 10:22:50',1,667,'9325e320-5945-4ed6-8fdb-14d9cf96cbe3',182,'24d6923c0e47455ca133a232d042e0fc','volumes',1,'2025-12-07 10:22:50',NULL),('2025-12-06 10:22:50','2025-12-06 10:22:50','2025-12-06 10:22:50',1,668,'886e1011-14e0-4fc5-b871-eabdab255028',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',1,'2025-12-07 10:22:50',NULL),('2025-12-06 10:22:50','2025-12-06 10:22:50','2025-12-06 10:22:50',1,669,'5bc95435-1284-405d-9bac-617cb519a9a7',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',1,'2025-12-07 10:22:50',NULL),('2025-12-06 10:22:50','2025-12-06 10:22:50','2025-12-06 10:22:50',1,670,'b6ff433c-9009-4681-8c44-75a1c034c715',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',1,'2025-12-07 10:22:50',NULL),('2025-12-06 10:22:51','2025-12-06 10:22:51','2025-12-06 10:22:51',1,671,'b67f713c-967d-48b0-bab7-fc7e4ada1e09',182,'24d6923c0e47455ca133a232d042e0fc','volumes',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:51','2025-12-06 10:22:51','2025-12-06 10:22:51',1,672,'f7dad71c-03fa-4d0a-8556-2ba927d5c48c',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:51','2025-12-06 10:22:51','2025-12-06 10:22:51',1,673,'06f569ab-3cf7-4ab9-b23f-bee8ebe46e74',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:51','2025-12-06 10:22:51','2025-12-06 10:22:51',1,674,'50cfe7b2-4e3a-449b-90ac-c25bb8514ff0',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:53','2025-12-06 10:22:53','2025-12-06 10:22:53',1,675,'891fb820-19ad-44df-9d2b-50585dd59383',158,'083713cc3880454487a156230b40fd02','backups',-1,'2025-12-07 10:22:53',NULL),('2025-12-06 10:22:53','2025-12-06 10:22:53','2025-12-06 10:22:53',1,676,'f358f868-6d3b-40e0-b948-732b5b58789e',159,'083713cc3880454487a156230b40fd02','backup_gigabytes',-1,'2025-12-07 10:22:53',NULL),('2025-12-06 10:22:54','2025-12-06 10:22:54','2025-12-06 10:22:54',1,677,'68cc2881-04b2-4513-93be-1b9e05a08e31',178,'096aefe63e33405396d6efe65bbb1733','volumes',-1,'2025-12-07 10:22:54',NULL),('2025-12-06 10:22:54','2025-12-06 10:22:54','2025-12-06 10:22:54',1,678,'d2f1a598-09d2-4c82-8d27-f18dc7ba4db3',179,'096aefe63e33405396d6efe65bbb1733','gigabytes',-1,'2025-12-07 10:22:54',NULL),('2025-12-06 10:22:54','2025-12-06 10:22:54','2025-12-06 10:22:54',1,679,'7f88cc4d-799d-4cb0-a19d-eac6cf972a1e',180,'096aefe63e33405396d6efe65bbb1733','volumes_tripleo',-1,'2025-12-07 10:22:54',NULL),('2025-12-06 10:22:54','2025-12-06 10:22:54','2025-12-06 10:22:54',1,680,'fb82b30f-7cc4-43bd-82a7-7e6ccbe88798',181,'096aefe63e33405396d6efe65bbb1733','gigabytes_tripleo',-1,'2025-12-07 10:22:54',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,681,'b34bc72d-2803-487c-90f1-6d791f5bed1a',154,'083713cc3880454487a156230b40fd02','volumes',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,682,'d06f86bf-0b3d-4177-83c5-d69b7f76e45c',155,'083713cc3880454487a156230b40fd02','gigabytes',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,683,'e7a526ca-f14b-4e61-b1bf-98a859a8aca2',182,'24d6923c0e47455ca133a232d042e0fc','volumes',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,684,'04f5fe45-f5d8-4c04-8a3b-628071df53cd',156,'083713cc3880454487a156230b40fd02','volumes_tripleo',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,685,'10e23b9c-3580-4279-9299-bf152591a083',157,'083713cc3880454487a156230b40fd02','gigabytes_tripleo',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,686,'ffbbb577-0831-4e69-924a-55c191dbf0c2',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,687,'93a15065-8b1a-4c04-9949-9709c62b02cc',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,688,'f19e80bc-f4d9-4b37-a560-daf7aefef4a8',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:56','2025-12-06 10:22:56','2025-12-06 10:22:56',1,689,'d3782a66-c13f-47e0-b196-572314741aad',182,'24d6923c0e47455ca133a232d042e0fc','volumes',-1,'2025-12-07 10:22:56',NULL),('2025-12-06 10:22:56','2025-12-06 10:22:56','2025-12-06 10:22:56',1,690,'d219637f-8178-4b28-8daf-79449c7150de',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',-1,'2025-12-07 10:22:56',NULL),('2025-12-06 10:22:56','2025-12-06 10:22:56','2025-12-06 10:22:56',1,691,'6af17a85-b7c0-48b9-89f1-3a02713beb7d',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',-1,'2025-12-07 10:22:56',NULL),('2025-12-06 10:22:56','2025-12-06 10:22:56','2025-12-06 10:22:56',1,692,'27e8a38f-379b-4f42-ae5c-7b1029ba0d88',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',-1,'2025-12-07 10:22:56',NULL),('2025-12-06 10:22:57','2025-12-06 10:22:57','2025-12-06 10:22:57',1,693,'27762f15-90f8-4784-8aa3-9b1f5ccbfce4',182,'24d6923c0e47455ca133a232d042e0fc','volumes',-1,'2025-12-07 10:22:57',NULL),('2025-12-06 10:22:57','2025-12-06 10:22:57','2025-12-06 10:22:57',1,694,'4a6544fb-0eda-412f-9827-ffb029acfddd',183,'24d6923c0e47455ca133a232d042e0fc','gigabytes',-1,'2025-12-07 10:22:57',NULL),('2025-12-06 10:22:57','2025-12-06 10:22:57','2025-12-06 10:22:57',1,695,'f6b6655e-7f0f-4cd8-8c1b-f197a5aded97',184,'24d6923c0e47455ca133a232d042e0fc','volumes_tripleo',-1,'2025-12-07 10:22:57',NULL),('2025-12-06 10:22:57','2025-12-06 10:22:57','2025-12-06 10:22:57',1,696,'0fe35eee-23a6-4396-95a2-cc1fb45e2150',185,'24d6923c0e47455ca133a232d042e0fc','gigabytes_tripleo',-1,'2025-12-07 10:22:57',NULL),('2025-12-06 10:23:01','2025-12-06 10:23:01','2025-12-06 10:23:01',1,697,'9e254a23-812a-46d1-9be2-b55fbc0b2fd5',186,'0ade48b7157047d2bc354a1299624e2c','volumes',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:01','2025-12-06 10:23:01','2025-12-06 10:23:01',1,698,'483a6b19-c236-4f07-8a03-c2021302c49e',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:01','2025-12-06 10:23:01','2025-12-06 10:23:01',1,699,'6cc600cb-ed35-4db4-9c3f-437230c46363',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:01','2025-12-06 10:23:01','2025-12-06 10:23:01',1,700,'0197f95f-778f-414a-a7a6-f38cb9b9049c',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:02','2025-12-06 10:23:02','2025-12-06 10:23:02',1,701,'87057a26-80c0-4f81-ad3d-79a357b7a66a',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:02','2025-12-06 10:23:02','2025-12-06 10:23:02',1,702,'dfb93ccb-e6a8-4f2a-a8a1-1279cd4df916',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:02','2025-12-06 10:23:02','2025-12-06 10:23:02',1,703,'0d88fa73-dbf0-4208-ac4f-0182882a6ddd',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:02','2025-12-06 10:23:02','2025-12-06 10:23:02',1,704,'e326ad7c-5cf5-4ead-94bc-72d2a1393bec',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:04','2025-12-06 10:23:04','2025-12-06 10:23:04',1,705,'17acab3b-f4ff-4839-bba4-a830d4e4785a',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',1,'2025-12-07 10:23:04',NULL),('2025-12-06 10:23:04','2025-12-06 10:23:04','2025-12-06 10:23:04',1,706,'e53dd39a-7d16-417d-8e94-101c4c7647ab',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:04',NULL),('2025-12-06 10:23:04','2025-12-06 10:23:04','2025-12-06 10:23:04',1,707,'10b28e32-2a7c-4120-bba4-24774d5d8376',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:04',NULL),('2025-12-06 10:23:04','2025-12-06 10:23:04','2025-12-06 10:23:04',1,708,'0bdc6bb7-d294-40f0-aaac-73784fb75cf6',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',1,'2025-12-07 10:23:04',NULL),('2025-12-06 10:23:06','2025-12-06 10:23:06','2025-12-06 10:23:06',1,709,'566cefd1-81ab-4a43-993e-8b298c925fd1',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',-1,'2025-12-07 10:23:06',NULL),('2025-12-06 10:23:06','2025-12-06 10:23:06','2025-12-06 10:23:06',1,710,'38ca3f8a-5bdc-4ab2-9075-953e65dc5ed9',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:06',NULL),('2025-12-06 10:23:06','2025-12-06 10:23:06','2025-12-06 10:23:06',1,711,'47ed79ab-0509-42c2-a02e-8ed348784b80',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:06',NULL),('2025-12-06 10:23:06','2025-12-06 10:23:06','2025-12-06 10:23:06',1,712,'7643ad17-f603-4347-a00a-8b920cd542d7',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',-1,'2025-12-07 10:23:06',NULL),('2025-12-06 10:23:07','2025-12-06 10:23:07','2025-12-06 10:23:07',1,713,'cb3aad3c-cb09-4bf3-b037-0becd1e32eb5',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:07','2025-12-06 10:23:07','2025-12-06 10:23:07',1,714,'bf33a652-f170-4d19-b1e4-ca59b9f8717a',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:07','2025-12-06 10:23:07','2025-12-06 10:23:07',1,715,'a57ddfc5-76c9-40f3-9639-61779daa9a04',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:07','2025-12-06 10:23:07','2025-12-06 10:23:07',1,716,'ce63df8f-7415-432f-a385-bee271966066',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:08','2025-12-06 10:23:08','2025-12-06 10:23:08',1,717,'8c5981e3-1444-4b3f-91e8-e0953d585173',186,'0ade48b7157047d2bc354a1299624e2c','volumes',-1,'2025-12-07 10:23:08',NULL),('2025-12-06 10:23:08','2025-12-06 10:23:08','2025-12-06 10:23:08',1,718,'d5bbf8c6-92b3-48c4-932d-96058ca6cf32',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:08',NULL),('2025-12-06 10:23:08','2025-12-06 10:23:08','2025-12-06 10:23:08',1,719,'e7fc2570-9a11-4569-9338-6a0662ffc30e',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',-1,'2025-12-07 10:23:08',NULL),('2025-12-06 10:23:08','2025-12-06 10:23:08','2025-12-06 10:23:08',1,720,'5370b2b9-62b4-4bab-a3fb-14817fee7405',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:08',NULL),('2025-12-06 10:23:09','2025-12-06 10:23:09','2025-12-06 10:23:09',1,721,'94894a02-7772-4e5f-aa5a-4f65c03d178a',186,'0ade48b7157047d2bc354a1299624e2c','volumes',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:09','2025-12-06 10:23:09','2025-12-06 10:23:09',1,722,'6f6e795d-3ca6-4527-b661-d4b43c01f4a5',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:09','2025-12-06 10:23:09','2025-12-06 10:23:09',1,723,'ddbd0517-529d-4d49-833a-386ca1b9e4aa',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:09','2025-12-06 10:23:09','2025-12-06 10:23:09',1,724,'b8545d1f-f626-4be8-8360-7278ab13085b',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:10','2025-12-06 10:23:10','2025-12-06 10:23:10',1,725,'56c9ec56-b2a3-444f-bf63-10f8a92bb8fb',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',1,'2025-12-07 10:23:10',NULL),('2025-12-06 10:23:10','2025-12-06 10:23:10','2025-12-06 10:23:10',1,726,'b7e120dd-edc3-4493-be72-595160faa09a',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:10',NULL),('2025-12-06 10:23:10','2025-12-06 10:23:10','2025-12-06 10:23:10',1,727,'151e15bf-204a-4d12-a751-ac1225d68276',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:10',NULL),('2025-12-06 10:23:10','2025-12-06 10:23:10','2025-12-06 10:23:10',1,728,'7b279d04-a22c-4e0c-a680-4a4b9f2ddd04',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',1,'2025-12-07 10:23:10',NULL),('2025-12-06 10:23:12','2025-12-06 10:23:12','2025-12-06 10:23:12',1,729,'b601e665-a31c-4e8a-854c-024585295add',186,'0ade48b7157047d2bc354a1299624e2c','volumes',1,'2025-12-07 10:23:12',NULL),('2025-12-06 10:23:12','2025-12-06 10:23:12','2025-12-06 10:23:12',1,730,'864f7d94-f212-4aed-b63e-8e4c61eec89a',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',1,'2025-12-07 10:23:12',NULL),('2025-12-06 10:23:12','2025-12-06 10:23:12','2025-12-06 10:23:12',1,731,'8dd059ba-fe95-4525-926d-3b7eb13492fd',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',1,'2025-12-07 10:23:12',NULL),('2025-12-06 10:23:12','2025-12-06 10:23:12','2025-12-06 10:23:12',1,732,'6b01a8ad-151a-433b-91cb-dc4fde657359',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',1,'2025-12-07 10:23:12',NULL),('2025-12-06 10:23:18','2025-12-06 10:23:18','2025-12-06 10:23:18',1,733,'8df89f5b-f957-4b7f-bf8f-1e5d2225a5ad',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',1,'2025-12-07 10:23:18',NULL),('2025-12-06 10:23:18','2025-12-06 10:23:18','2025-12-06 10:23:18',1,734,'eb439fff-bf56-4a05-9039-b0cd7895ab0e',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:18',NULL),('2025-12-06 10:23:18','2025-12-06 10:23:18','2025-12-06 10:23:18',1,735,'9b28cdc1-fc61-4624-b6a7-f399855bd6be',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',1,'2025-12-07 10:23:18',NULL),('2025-12-06 10:23:18','2025-12-06 10:23:18','2025-12-06 10:23:18',1,736,'754fadd2-9484-4523-9213-8773b3dd7c8f',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:18',NULL),('2025-12-06 10:23:19','2025-12-06 10:23:19','2025-12-06 10:23:19',1,737,'de5d5a75-bede-4e30-928c-c4c6b4d0ef23',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:19','2025-12-06 10:23:19','2025-12-06 10:23:19',1,738,'3e860852-80e2-4363-83d5-94bc1c0578bd',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:19','2025-12-06 10:23:19','2025-12-06 10:23:19',1,739,'41da3727-2ebb-4850-a283-032e7d609b74',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:19','2025-12-06 10:23:19','2025-12-06 10:23:19',1,740,'d406f0c2-033f-41b3-a77d-ace3fb377a7c',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:20','2025-12-06 10:23:20','2025-12-06 10:23:20',1,741,'686606cb-0baa-4eab-94a5-746eedc2e4b5',198,'8321907d0a38406c8e7c51f32ab796ad','backups',1,'2025-12-07 10:23:20',NULL),('2025-12-06 10:23:20','2025-12-06 10:23:20','2025-12-06 10:23:20',1,742,'64767587-dff9-4879-a126-3daef101c3be',199,'8321907d0a38406c8e7c51f32ab796ad','backup_gigabytes',1,'2025-12-07 10:23:20',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,743,'c111600f-3c6f-4cce-97f8-c260d0e50a65',190,'0ade48b7157047d2bc354a1299624e2c','snapshots',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,744,'b8e85e22-8611-40ab-b895-30e83ad75fb3',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,745,'fbf25d77-9f48-4daa-beda-2a9e79339b07',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,746,'6da8e1b1-72bc-47e3-9d8a-31da9f0b7a90',191,'0ade48b7157047d2bc354a1299624e2c','snapshots_tripleo',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,747,'94030a7e-8048-45c8-824d-1ff925fa8279',186,'0ade48b7157047d2bc354a1299624e2c','volumes',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,748,'20857a30-d7ce-4c41-a033-6fb10c649fe3',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,749,'636206cf-dcb7-48a2-a1a7-292c80367687',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:21','2025-12-06 10:23:21','2025-12-06 10:23:21',1,750,'75d5b375-5601-445c-ba08-e30a66d2c038',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:21',NULL),('2025-12-06 10:23:24','2025-12-06 10:23:24','2025-12-06 10:23:24',1,751,'619e1891-f9fb-40a6-80f7-d9894df9ce6d',186,'0ade48b7157047d2bc354a1299624e2c','volumes',-1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:24','2025-12-06 10:23:24','2025-12-06 10:23:24',1,752,'56e63185-0e60-4abf-8599-98dd9552d8ab',187,'0ade48b7157047d2bc354a1299624e2c','gigabytes',-1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:24','2025-12-06 10:23:24','2025-12-06 10:23:24',1,753,'0f2b9c94-9b86-4d0d-afcb-e6b7c7ac4b03',188,'0ade48b7157047d2bc354a1299624e2c','volumes_tripleo',-1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:24','2025-12-06 10:23:24','2025-12-06 10:23:24',1,754,'f5ed2e28-8feb-4e7a-be93-f9dc6122257a',189,'0ade48b7157047d2bc354a1299624e2c','gigabytes_tripleo',-1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:30','2025-12-06 10:23:30','2025-12-06 10:23:30',1,755,'f2e5625a-fe0c-412f-b4be-3d17ef314210',200,'70f435eabdfe445ab287f469849a5cad','volumes',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:30','2025-12-06 10:23:30','2025-12-06 10:23:30',1,756,'c65e416e-5301-4d03-805d-28d86b4e84bd',201,'70f435eabdfe445ab287f469849a5cad','gigabytes',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:30','2025-12-06 10:23:30','2025-12-06 10:23:30',1,757,'4c7c6299-33ad-4d86-ac4a-38c4968ab079',202,'70f435eabdfe445ab287f469849a5cad','volumes_tripleo',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:30','2025-12-06 10:23:30','2025-12-06 10:23:30',1,758,'780cd2cf-301e-4dd4-93dc-bb4d7137d33f',203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,759,'f2b57dc2-8017-4fb3-8e1c-81f5bef7b466',204,'e2b088aa0aa04fe8a692c8ef32041e76','volumes',1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,760,'310aa810-32c5-48d4-89a9-0ab6809f1fc2',205,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes',1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,761,'a8e29051-85fa-4562-afa1-9a0d8db93d56',206,'e2b088aa0aa04fe8a692c8ef32041e76','volumes_tripleo',1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,762,'6498f6a6-cdcb-4944-ad4b-0508415d5bd3',207,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes_tripleo',1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,763,'11976f2e-9c9c-4a5f-aa9d-439bb2261996',200,'70f435eabdfe445ab287f469849a5cad','volumes',-1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,764,'8b203c65-dcfa-4d8c-a905-8f6bc2a47721',201,'70f435eabdfe445ab287f469849a5cad','gigabytes',-1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,765,'c1fdbac0-a7f1-4b41-b002-2123f0ad9720',202,'70f435eabdfe445ab287f469849a5cad','volumes_tripleo',-1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,766,'fcebc0f0-3483-4226-b81c-2599de325a36',203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',-1,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,767,'3ec68229-7e06-4e1f-bc35-eed57447deb3',208,'e2b088aa0aa04fe8a692c8ef32041e76','snapshots',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,768,'9420c4c6-21b3-46d2-8a48-e4117a85dfb2',205,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,769,'bcaeaefd-be09-44de-9a0b-604eadd12a6e',207,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes_tripleo',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,770,'ee46b470-b16b-4cc5-8332-026e9e8113c1',209,'e2b088aa0aa04fe8a692c8ef32041e76','snapshots_tripleo',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,771,'41473175-770d-4ae1-b480-84069e14c028',210,'70f435eabdfe445ab287f469849a5cad','snapshots',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,772,'d5f070a2-9be3-4c25-91a9-b191f3abf832',201,'70f435eabdfe445ab287f469849a5cad','gigabytes',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,773,'e3aa455b-6392-4fad-9819-00b32f014a15',203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:32','2025-12-06 10:23:32','2025-12-06 10:23:32',1,774,'1b32cdf3-6c55-4ff0-8b35-a3847c262725',211,'70f435eabdfe445ab287f469849a5cad','snapshots_tripleo',0,'2025-12-07 10:23:32',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,775,'6d38a395-87fc-490b-91ca-fbb1a99d764e',204,'e2b088aa0aa04fe8a692c8ef32041e76','volumes',-1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,776,'874f3ebb-7c16-4496-883a-fafc47a29875',205,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes',-1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,777,'e72dfe52-c042-4245-b4ca-784b815d6b62',206,'e2b088aa0aa04fe8a692c8ef32041e76','volumes_tripleo',-1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,778,'fcf7b47e-9fce-44c6-9e9b-e7e8ff4ed9d7',207,'e2b088aa0aa04fe8a692c8ef32041e76','gigabytes_tripleo',-1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,779,'0f01d951-b865-419e-a9f8-ddf7ff4dbe7a',200,'70f435eabdfe445ab287f469849a5cad','volumes',1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,780,'3a731b1b-3cb4-43d3-94e4-01bcf3207010',201,'70f435eabdfe445ab287f469849a5cad','gigabytes',1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,781,'f376af38-a9be-47bc-9e0f-72d9f97889fe',202,'70f435eabdfe445ab287f469849a5cad','volumes_tripleo',1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:34','2025-12-06 10:23:34','2025-12-06 10:23:34',1,782,'27bf7211-d240-4664-bd8d-800a1209b9f4',203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',1,'2025-12-07 10:23:34',NULL),('2025-12-06 10:23:36','2025-12-06 10:23:37','2025-12-06 10:23:37',1,783,'c5a03372-db40-4d6c-8200-abd66f0cbafa',200,'70f435eabdfe445ab287f469849a5cad','volumes',-1,'2025-12-07 10:23:36',NULL),('2025-12-06 10:23:36','2025-12-06 10:23:37','2025-12-06 10:23:37',1,784,'39bf2ce7-e8b6-4360-9a17-de6354719cf1',201,'70f435eabdfe445ab287f469849a5cad','gigabytes',-1,'2025-12-07 10:23:36',NULL),('2025-12-06 10:23:36','2025-12-06 10:23:37','2025-12-06 10:23:37',1,785,'89bfbcc7-093e-49ce-960c-bb6655aa3a54',202,'70f435eabdfe445ab287f469849a5cad','volumes_tripleo',-1,'2025-12-07 10:23:36',NULL),('2025-12-06 10:23:36','2025-12-06 10:23:37','2025-12-06 10:23:37',1,786,'e75ddfd8-0af4-4ec5-8de9-cf20f074e480',203,'70f435eabdfe445ab287f469849a5cad','gigabytes_tripleo',-1,'2025-12-07 10:23:36',NULL),('2025-12-06 10:23:38','2025-12-06 10:23:38','2025-12-06 10:23:38',1,787,'8d0e4491-48ba-43ef-8122-ede52a38cd29',198,'8321907d0a38406c8e7c51f32ab796ad','backups',-1,'2025-12-07 10:23:38',NULL),('2025-12-06 10:23:38','2025-12-06 10:23:38','2025-12-06 10:23:38',1,788,'eaf5625f-5ce9-4ba0-95c2-58fcb35bf5b1',199,'8321907d0a38406c8e7c51f32ab796ad','backup_gigabytes',-1,'2025-12-07 10:23:38',NULL),('2025-12-06 10:23:39','2025-12-06 10:23:39','2025-12-06 10:23:39',1,789,'a639de27-e19b-473b-8c41-d32a85010926',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',-1,'2025-12-07 10:23:39',NULL),('2025-12-06 10:23:39','2025-12-06 10:23:39','2025-12-06 10:23:39',1,790,'8fc5def5-b06c-4d38-91b2-829940bfd516',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:39',NULL),('2025-12-06 10:23:39','2025-12-06 10:23:39','2025-12-06 10:23:39',1,791,'fb74e34b-98d8-4859-86d0-9a4609431795',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:39',NULL),('2025-12-06 10:23:39','2025-12-06 10:23:39','2025-12-06 10:23:39',1,792,'0bea4c74-f938-4ab7-a11f-6ce14b3fc56f',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',-1,'2025-12-07 10:23:39',NULL),('2025-12-06 10:23:40','2025-12-06 10:23:40','2025-12-06 10:23:40',1,793,'b6cefbed-3a71-4088-a422-2740741fff90',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',1,'2025-12-07 10:23:40',NULL),('2025-12-06 10:23:40','2025-12-06 10:23:40','2025-12-06 10:23:40',1,794,'3514f623-7514-40ef-825a-929359bca89e',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:40',NULL),('2025-12-06 10:23:40','2025-12-06 10:23:40','2025-12-06 10:23:40',1,795,'a1d39195-a57e-450f-96fe-3c1f1be1cb09',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:40',NULL),('2025-12-06 10:23:40','2025-12-06 10:23:40','2025-12-06 10:23:40',1,796,'c6574cb4-df52-407e-ab32-9210df6ef015',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',1,'2025-12-07 10:23:40',NULL),('2025-12-06 10:23:43','2025-12-06 10:23:43','2025-12-06 10:23:43',1,797,'9b16b964-2605-4335-8b85-6881a1f9c2ba',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',-1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:43','2025-12-06 10:23:43','2025-12-06 10:23:43',1,798,'511cc980-5248-4938-9c90-d33a14114abe',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:43','2025-12-06 10:23:43','2025-12-06 10:23:43',1,799,'a16cff0d-8ea6-4428-973e-6de3c3b9725b',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:43','2025-12-06 10:23:43','2025-12-06 10:23:43',1,800,'4731062b-7296-48ae-ac7d-978b3e5863ce',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',-1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:44','2025-12-06 10:23:44','2025-12-06 10:23:44',1,801,'4fc59023-f12a-4c88-8710-ab2cb23de91d',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',1,'2025-12-07 10:23:44',NULL),('2025-12-06 10:23:44','2025-12-06 10:23:44','2025-12-06 10:23:44',1,802,'7943825e-a689-4269-bc4f-1a48084c832f',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:44',NULL),('2025-12-06 10:23:44','2025-12-06 10:23:44','2025-12-06 10:23:44',1,803,'6c53a0aa-813d-4a27-b75a-690a7894eedb',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',1,'2025-12-07 10:23:44',NULL),('2025-12-06 10:23:44','2025-12-06 10:23:44','2025-12-06 10:23:44',1,804,'ceddeacf-2afd-4a93-9e66-bd407d46d334',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:44',NULL),('2025-12-06 10:23:45','2025-12-06 10:23:45','2025-12-06 10:23:45',1,805,'491cf43e-1ef4-449b-ae7f-11713fc06c6a',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:45','2025-12-06 10:23:45','2025-12-06 10:23:45',1,806,'877e0810-f760-4c95-adcf-9111bdd767a2',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:45','2025-12-06 10:23:45','2025-12-06 10:23:45',1,807,'7ba9af0e-188b-4319-8b8f-5d2f25ac3072',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:45','2025-12-06 10:23:45','2025-12-06 10:23:45',1,808,'b7a4f9b0-33cd-46b4-94a5-ce6ef1f877d9',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:47','2025-12-06 10:23:47','2025-12-06 10:23:47',1,809,'f840d854-6df7-434d-8483-40e2dcdd4793',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',1,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:47','2025-12-06 10:23:47','2025-12-06 10:23:47',1,810,'d31f227e-2bf1-4563-8edc-accf8d09d6e1',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',2,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:47','2025-12-06 10:23:47','2025-12-06 10:23:47',1,811,'bef68840-6417-493f-8856-4bc73dd5164a',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',1,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:47','2025-12-06 10:23:47','2025-12-06 10:23:47',1,812,'a190933e-413f-4ecb-90d7-585d1c505ba1',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',2,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,813,'e0b58bc1-f92d-498d-9aad-d61099addd3f',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',-1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,814,'bfde089d-58ce-4159-bd43-c87282b0b092',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-2,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,815,'022fd3b3-dcee-459a-9bc8-01a4c70103d7',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',-1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,816,'40688c59-1a8a-410f-8a9f-c8bd83b38483',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-2,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,817,'8b45428c-7b2a-40ca-9177-66a5e05992ff',212,'b51f704fe6204487b0317c3332364cca','volumes',1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,818,'9e210359-1476-4899-b87b-00d9e256224a',213,'b51f704fe6204487b0317c3332364cca','gigabytes',1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,819,'9783a30c-374e-4d65-9b7f-6ee3e4882661',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49','2025-12-06 10:23:49','2025-12-06 10:23:49',1,820,'95784356-01e9-4b66-ae99-d3ecb3812cb6',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:51','2025-12-06 10:23:51','2025-12-06 10:23:51',1,821,'c5f0dae2-5205-4e90-89dd-4f713e852162',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',-1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:51','2025-12-06 10:23:51','2025-12-06 10:23:51',1,822,'5f850b6b-c044-4091-968d-f95cbc695ba0',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:51','2025-12-06 10:23:51','2025-12-06 10:23:51',1,823,'a3634eed-6202-4688-8a5e-02cda9b7cbea',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:51','2025-12-06 10:23:51','2025-12-06 10:23:51',1,824,'0b93061c-17ec-4a1b-af4d-183cf150ad8c',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',-1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:52','2025-12-06 10:23:53','2025-12-06 10:23:53',1,825,'ac4b8a4e-00c0-462e-b14b-c377260d311c',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',-1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:52','2025-12-06 10:23:53','2025-12-06 10:23:53',1,826,'2359d87d-60c8-4040-9a1b-ff8b851a1820',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:52','2025-12-06 10:23:53','2025-12-06 10:23:53',1,827,'bb7013c1-0f69-424e-918b-1ba72998797a',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',-1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:52','2025-12-06 10:23:53','2025-12-06 10:23:53',1,828,'890be2dd-8c95-4248-b78d-3a2a57e6ce0d',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:53','2025-12-06 10:23:53','2025-12-06 10:23:53',1,829,'d57b898d-f072-4126-9c9d-bccf789a18d4',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',1,'2025-12-07 10:23:53',NULL),('2025-12-06 10:23:53','2025-12-06 10:23:53','2025-12-06 10:23:53',1,830,'7c9a019f-7cda-4d46-8bde-661e4361441f',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:53',NULL),('2025-12-06 10:23:53','2025-12-06 10:23:53','2025-12-06 10:23:53',1,831,'0e33e620-ef41-4438-ab5d-309d2355a438',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',1,'2025-12-07 10:23:53',NULL),('2025-12-06 10:23:53','2025-12-06 10:23:53','2025-12-06 10:23:53',1,832,'e8ece7c1-8067-4916-8422-51fa6d11a2ff',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:53',NULL),('2025-12-06 10:23:54','2025-12-06 10:23:54','2025-12-06 10:23:54',1,833,'c8dba797-11bb-4540-b72d-9c249cfbc4bf',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54','2025-12-06 10:23:54','2025-12-06 10:23:54',1,834,'34318294-cd1d-4d50-b235-f18d29cce7f8',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54','2025-12-06 10:23:54','2025-12-06 10:23:54',1,835,'96a52170-7207-43cb-aa22-ce3d87ec92a9',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54','2025-12-06 10:23:54','2025-12-06 10:23:54',1,836,'a62ef140-2e99-4f35-9af2-cb07f0370239',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:55','2025-12-06 10:23:55','2025-12-06 10:23:55',1,837,'4ee81f55-dd01-486d-91b0-03d101e1b95f',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',1,'2025-12-07 10:23:55',NULL),('2025-12-06 10:23:55','2025-12-06 10:23:55','2025-12-06 10:23:55',1,838,'8b5ef0f6-071c-4907-9dab-2356ff295009',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',1,'2025-12-07 10:23:55',NULL),('2025-12-06 10:23:55','2025-12-06 10:23:55','2025-12-06 10:23:55',1,839,'9363dc87-c355-4855-8756-5714b2059730',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',1,'2025-12-07 10:23:55',NULL),('2025-12-06 10:23:55','2025-12-06 10:23:55','2025-12-06 10:23:55',1,840,'9d4df5ed-e405-4f3c-a5a4-b71ce930f9d4',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',1,'2025-12-07 10:23:55',NULL),('2025-12-06 10:23:56','2025-12-06 10:23:56','2025-12-06 10:23:56',1,841,'de5fd1b8-ca76-4ab6-ad37-7910cc4953df',216,'b51f704fe6204487b0317c3332364cca','backups',1,'2025-12-07 10:23:56',NULL),('2025-12-06 10:23:56','2025-12-06 10:23:56','2025-12-06 10:23:56',1,842,'824a57c6-cbe7-48c9-9992-e6cfd1012a46',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',1,'2025-12-07 10:23:56',NULL),('2025-12-06 10:23:57','2025-12-06 10:23:57','2025-12-06 10:23:57',1,843,'a126a92a-9540-49f4-8d99-010ba6081b9b',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',-1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:57','2025-12-06 10:23:57','2025-12-06 10:23:57',1,844,'88d4c62c-ba75-413a-8368-775848545d6a',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:57','2025-12-06 10:23:57','2025-12-06 10:23:57',1,845,'2d665a82-ef53-48af-8104-a264eb2c7edb',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',-1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:57','2025-12-06 10:23:57','2025-12-06 10:23:57',1,846,'7d8ab1d0-7fcb-45aa-94fb-8ee99b4e601f',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,847,'e0c76bf1-51b7-47dc-8fa9-82f627809b70',212,'b51f704fe6204487b0317c3332364cca','volumes',1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,848,'c98f394b-bb81-47b2-89c1-db44a03aa1e5',213,'b51f704fe6204487b0317c3332364cca','gigabytes',1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,849,'b114a064-2bac-4e2e-8a1f-6f6763394d8e',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,850,'bd7ffc09-8546-47d4-8c8d-053667e6f182',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,851,'aa05e4bc-759d-4ee6-b7b4-8b6c3c146c7a',196,'8321907d0a38406c8e7c51f32ab796ad','snapshots',-1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,852,'8ed61fd6-6983-47eb-bceb-92bd9f181cc7',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,853,'6306995c-9554-4b43-85ae-072cd0f4fe52',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:23:59',1,854,'1281548d-cdd7-4011-a652-86be4dac9a24',197,'8321907d0a38406c8e7c51f32ab796ad','snapshots_tripleo',-1,'2025-12-07 10:23:59',NULL),('2025-12-06 10:24:01','2025-12-06 10:24:01','2025-12-06 10:24:01',1,855,'71041d67-0ecc-4729-913f-d92fead58bf2',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',-1,'2025-12-07 10:24:01',NULL),('2025-12-06 10:24:01','2025-12-06 10:24:01','2025-12-06 10:24:01',1,856,'fefa99e9-a68c-4e3e-9b84-09f0eabc04aa',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:24:01',NULL),('2025-12-06 10:24:01','2025-12-06 10:24:01','2025-12-06 10:24:01',1,857,'fc6b5d5b-a755-4f34-b1db-65e051e9e8bc',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',-1,'2025-12-07 10:24:01',NULL),('2025-12-06 10:24:01','2025-12-06 10:24:01','2025-12-06 10:24:01',1,858,'0029b4ed-73eb-4a33-8bb9-c5a689a1dbd0',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:24:01',NULL),('2025-12-06 10:24:02','2025-12-06 10:24:02','2025-12-06 10:24:02',1,859,'3137d618-ad74-4247-907a-c30c115e512e',192,'8321907d0a38406c8e7c51f32ab796ad','volumes',-1,'2025-12-07 10:24:02',NULL),('2025-12-06 10:24:02','2025-12-06 10:24:02','2025-12-06 10:24:02',1,860,'2107b564-dc7e-4ad8-b5b9-372e0b6c3d58',193,'8321907d0a38406c8e7c51f32ab796ad','gigabytes',-1,'2025-12-07 10:24:02',NULL),('2025-12-06 10:24:02','2025-12-06 10:24:02','2025-12-06 10:24:02',1,861,'fa63dd5b-0f76-4659-b5ec-1fb1918a6e25',194,'8321907d0a38406c8e7c51f32ab796ad','volumes_tripleo',-1,'2025-12-07 10:24:02',NULL),('2025-12-06 10:24:02','2025-12-06 10:24:02','2025-12-06 10:24:02',1,862,'5c07c461-93e8-4a16-af9d-4fb7d812ec1d',195,'8321907d0a38406c8e7c51f32ab796ad','gigabytes_tripleo',-1,'2025-12-07 10:24:02',NULL),('2025-12-06 10:24:05','2025-12-06 10:24:05','2025-12-06 10:24:05',1,863,'2cdfb935-60eb-433d-8a8b-5af9831a59e9',212,'b51f704fe6204487b0317c3332364cca','volumes',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:05','2025-12-06 10:24:05','2025-12-06 10:24:05',1,864,'cc804f8c-4896-4ac2-a668-9aaa88d1aa4a',213,'b51f704fe6204487b0317c3332364cca','gigabytes',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:05','2025-12-06 10:24:05','2025-12-06 10:24:05',1,865,'cf8ef6a4-cc93-484e-8838-f9a145151e88',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:05','2025-12-06 10:24:05','2025-12-06 10:24:05',1,866,'4ab45c95-6c26-44c1-ac7f-bdba64a33636',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:07','2025-12-06 10:24:07','2025-12-06 10:24:07',1,867,'3e705c17-55cf-44e2-b446-5975afceff8d',216,'b51f704fe6204487b0317c3332364cca','backups',-1,'2025-12-07 10:24:07',NULL),('2025-12-06 10:24:07','2025-12-06 10:24:07','2025-12-06 10:24:07',1,868,'6c4bc8e6-b5b0-405c-87dc-3a2c5ba63a46',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',-1,'2025-12-07 10:24:07',NULL),('2025-12-06 10:24:09','2025-12-06 10:24:09','2025-12-06 10:24:09',1,869,'4b74e83d-5995-4d48-b79d-b5a0212056f7',212,'b51f704fe6204487b0317c3332364cca','volumes',-1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:09','2025-12-06 10:24:09','2025-12-06 10:24:09',1,870,'f42d2d19-f9b5-4f92-a649-879573bde84a',213,'b51f704fe6204487b0317c3332364cca','gigabytes',-1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:09','2025-12-06 10:24:09','2025-12-06 10:24:09',1,871,'02567507-314b-4f9a-b308-9aeb7d939106',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',-1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:09','2025-12-06 10:24:09','2025-12-06 10:24:09',1,872,'3d3fbdfc-d0da-4388-934d-a3de12efb089',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',-1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:10','2025-12-06 10:24:10','2025-12-06 10:24:10',1,873,'b51e3396-df69-4e20-9461-80866d936685',212,'b51f704fe6204487b0317c3332364cca','volumes',1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:10','2025-12-06 10:24:10','2025-12-06 10:24:10',1,874,'f674c785-c229-4e67-b6a5-19121d55ea5d',213,'b51f704fe6204487b0317c3332364cca','gigabytes',1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:10','2025-12-06 10:24:10','2025-12-06 10:24:10',1,875,'c5058c2d-314e-4aab-a369-4d87981d995d',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:10','2025-12-06 10:24:10','2025-12-06 10:24:10',1,876,'12b74a3b-9378-4fe1-9630-72d3460517bb',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:59','2025-12-06 10:24:59','2025-12-06 10:24:59',1,877,'d04fc0c5-8a19-4e92-b210-5d7a9866951d',216,'b51f704fe6204487b0317c3332364cca','backups',1,'2025-12-07 10:24:59',NULL),('2025-12-06 10:24:59','2025-12-06 10:24:59','2025-12-06 10:24:59',1,878,'3f4c5ead-1bf1-4a0a-bba6-130a70ff0e76',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',1,'2025-12-07 10:24:59',NULL),('2025-12-06 10:25:03','2025-12-06 10:25:03','2025-12-06 10:25:03',1,879,'7837ee72-1ce9-44c8-b0d9-25dfa6b5259a',216,'b51f704fe6204487b0317c3332364cca','backups',1,'2025-12-07 10:25:03',NULL),('2025-12-06 10:25:03','2025-12-06 10:25:03','2025-12-06 10:25:03',1,880,'f4a98ad8-9ad9-448d-9fb7-09a4cd856290',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',1,'2025-12-07 10:25:03',NULL),('2025-12-06 10:25:09','2025-12-06 10:25:09','2025-12-06 10:25:09',1,881,'1d790695-bad1-4f34-a964-fa97ab557d06',216,'b51f704fe6204487b0317c3332364cca','backups',-1,'2025-12-07 10:25:09',NULL),('2025-12-06 10:25:09','2025-12-06 10:25:09','2025-12-06 10:25:09',1,882,'9a949027-b93d-49bc-b148-20d8c7f18561',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',-1,'2025-12-07 10:25:09',NULL),('2025-12-06 10:25:10','2025-12-06 10:25:10','2025-12-06 10:25:10',1,883,'bb37f77c-0538-4b52-ba2a-68f8b5734784',216,'b51f704fe6204487b0317c3332364cca','backups',1,'2025-12-07 10:25:10',NULL),('2025-12-06 10:25:10','2025-12-06 10:25:10','2025-12-06 10:25:10',1,884,'3d004db2-1dae-424a-bf18-2476715cabdc',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',1,'2025-12-07 10:25:10',NULL),('2025-12-06 10:25:16','2025-12-06 10:25:16','2025-12-06 10:25:16',1,885,'102341e4-737f-4ae9-adac-62d4402fab03',216,'b51f704fe6204487b0317c3332364cca','backups',-1,'2025-12-07 10:25:15',NULL),('2025-12-06 10:25:16','2025-12-06 10:25:16','2025-12-06 10:25:16',1,886,'db8efe11-9076-42b9-886f-4d224a67edc9',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',-1,'2025-12-07 10:25:15',NULL),('2025-12-06 10:25:18','2025-12-06 10:25:18','2025-12-06 10:25:18',1,887,'350a7ef9-c731-4fd6-b8a9-907e4a9775a7',216,'b51f704fe6204487b0317c3332364cca','backups',-1,'2025-12-07 10:25:18',NULL),('2025-12-06 10:25:18','2025-12-06 10:25:18','2025-12-06 10:25:18',1,888,'6e5c996f-218e-4548-8acb-b7ab8a5c2def',217,'b51f704fe6204487b0317c3332364cca','backup_gigabytes',-1,'2025-12-07 10:25:18',NULL),('2025-12-06 10:25:28','2025-12-06 10:25:28','2025-12-06 10:25:28',1,889,'4ea5ce8c-35e1-4666-95fd-78f871016e4f',212,'b51f704fe6204487b0317c3332364cca','volumes',-1,'2025-12-07 10:25:28',NULL),('2025-12-06 10:25:28','2025-12-06 10:25:28','2025-12-06 10:25:28',1,890,'592fb07d-8c92-4162-b2a4-91596b55f6bf',213,'b51f704fe6204487b0317c3332364cca','gigabytes',-1,'2025-12-07 10:25:28',NULL),('2025-12-06 10:25:28','2025-12-06 10:25:28','2025-12-06 10:25:28',1,891,'63974074-7ad6-4233-80e7-60accd755c29',214,'b51f704fe6204487b0317c3332364cca','volumes_tripleo',-1,'2025-12-07 10:25:28',NULL),('2025-12-06 10:25:28','2025-12-06 10:25:28','2025-12-06 10:25:28',1,892,'2b034353-d609-40a8-b1c9-b00b98a00b4a',215,'b51f704fe6204487b0317c3332364cca','gigabytes_tripleo',-1,'2025-12-07 10:25:28',NULL),('2025-12-06 10:25:34','2025-12-06 10:25:34','2025-12-06 10:25:34',1,893,'eab75ab2-c684-4571-83cc-203320701ec4',218,'bccedbe520d34898aad89e97c5258b2b','volumes',1,'2025-12-07 10:25:34',NULL),('2025-12-06 10:25:34','2025-12-06 10:25:34','2025-12-06 10:25:34',1,894,'12e5028b-8262-4fc1-9cc1-ffd289826f51',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',1,'2025-12-07 10:25:34',NULL),('2025-12-06 10:25:34','2025-12-06 10:25:34','2025-12-06 10:25:34',1,895,'d3240b81-e3c5-47bb-9c8d-8b27765c8c39',220,'bccedbe520d34898aad89e97c5258b2b','volumes_tripleo',1,'2025-12-07 10:25:34',NULL),('2025-12-06 10:25:34','2025-12-06 10:25:34','2025-12-06 10:25:34',1,896,'759b470c-62ce-41d1-97c2-7642351f55a1',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',1,'2025-12-07 10:25:34',NULL),('2025-12-06 10:25:36','2025-12-06 10:25:36','2025-12-06 10:25:36',1,897,'97bb6643-dc0d-453a-88b2-3c42275bdd16',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',1,'2025-12-07 10:25:36',NULL),('2025-12-06 10:25:36','2025-12-06 10:25:36','2025-12-06 10:25:36',1,898,'e8cdc18d-fac8-47f2-9597-38fd44f742c4',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',1,'2025-12-07 10:25:36',NULL),('2025-12-06 10:25:36','2025-12-06 10:25:36','2025-12-06 10:25:36',1,899,'346d7d45-decc-4002-b248-712a62ef6403',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',1,'2025-12-07 10:25:36',NULL),('2025-12-06 10:25:36','2025-12-06 10:25:36','2025-12-06 10:25:36',1,900,'54e388dd-e1bc-49ed-83eb-20ec3e2b4d8f',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',1,'2025-12-07 10:25:36',NULL),('2025-12-06 10:25:37','2025-12-06 10:25:37','2025-12-06 10:25:37',1,901,'2b86cadf-61c2-4e2c-8ed3-0be8d4750d9a',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',1,'2025-12-07 10:25:37',NULL),('2025-12-06 10:25:37','2025-12-06 10:25:37','2025-12-06 10:25:37',1,902,'2bb25e26-31e6-4e1a-9946-ce87cdac17a6',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',1,'2025-12-07 10:25:37',NULL),('2025-12-06 10:25:37','2025-12-06 10:25:37','2025-12-06 10:25:37',1,903,'c79ee5b2-f378-412a-9b6b-27980792866a',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',1,'2025-12-07 10:25:37',NULL),('2025-12-06 10:25:37','2025-12-06 10:25:37','2025-12-06 10:25:37',1,904,'c27a8401-95e0-4157-b525-7b450b8169fd',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',1,'2025-12-07 10:25:37',NULL),('2025-12-06 10:25:38','2025-12-06 10:25:38','2025-12-06 10:25:38',1,905,'e18e1b75-20ad-4882-a5d3-7cfb0336bf21',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',1,'2025-12-07 10:25:38',NULL),('2025-12-06 10:25:38','2025-12-06 10:25:38','2025-12-06 10:25:38',1,906,'e8a0204b-4abf-4d25-9985-b1af642a7d20',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',1,'2025-12-07 10:25:38',NULL),('2025-12-06 10:25:38','2025-12-06 10:25:38','2025-12-06 10:25:38',1,907,'726ddc09-3e32-460e-a910-7e969dd95c1d',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',1,'2025-12-07 10:25:38',NULL),('2025-12-06 10:25:38','2025-12-06 10:25:38','2025-12-06 10:25:38',1,908,'7d416154-24a8-4bcc-9f15-cc32c1abbbb0',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',1,'2025-12-07 10:25:38',NULL),('2025-12-06 10:25:40','2025-12-06 10:25:41','2025-12-06 10:25:41',1,909,'d4169e13-c3d5-4894-b2c0-f4d54ee29730',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',-1,'2025-12-07 10:25:40',NULL),('2025-12-06 10:25:40','2025-12-06 10:25:41','2025-12-06 10:25:41',1,910,'0ebfd0e3-218c-49b5-9005-bfdf427cfcb7',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',-1,'2025-12-07 10:25:40',NULL),('2025-12-06 10:25:40','2025-12-06 10:25:41','2025-12-06 10:25:41',1,911,'9f1435b5-df71-4233-bf2c-584c619ab17d',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',-1,'2025-12-07 10:25:40',NULL),('2025-12-06 10:25:40','2025-12-06 10:25:41','2025-12-06 10:25:41',1,912,'9c7b23ad-ab17-4ee1-9fc6-53b48871d754',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',-1,'2025-12-07 10:25:40',NULL),('2025-12-06 10:25:42','2025-12-06 10:25:42','2025-12-06 10:25:42',1,913,'ba8ae4f8-490b-4d5f-acca-effb8bb990e8',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',-1,'2025-12-07 10:25:42',NULL),('2025-12-06 10:25:42','2025-12-06 10:25:42','2025-12-06 10:25:42',1,914,'7b0652f0-c00a-4881-990b-5af9ccac36ef',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',-1,'2025-12-07 10:25:42',NULL),('2025-12-06 10:25:42','2025-12-06 10:25:42','2025-12-06 10:25:42',1,915,'045af8b7-1853-4332-b877-9db937ba63b7',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',-1,'2025-12-07 10:25:42',NULL),('2025-12-06 10:25:42','2025-12-06 10:25:42','2025-12-06 10:25:42',1,916,'606fdc96-28ae-46fa-a462-bd1cc8fa04f6',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',-1,'2025-12-07 10:25:42',NULL),('2025-12-06 10:25:43','2025-12-06 10:25:43','2025-12-06 10:25:43',1,917,'dc89a67f-6b38-4dbf-813c-566c3da4c8d7',222,'bccedbe520d34898aad89e97c5258b2b','snapshots',-1,'2025-12-07 10:25:43',NULL),('2025-12-06 10:25:43','2025-12-06 10:25:43','2025-12-06 10:25:43',1,918,'447a740d-016a-411d-93e1-3933d8a2da42',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',-1,'2025-12-07 10:25:43',NULL),('2025-12-06 10:25:43','2025-12-06 10:25:43','2025-12-06 10:25:43',1,919,'3a42fc6c-1431-47f3-ae76-62961262277c',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',-1,'2025-12-07 10:25:43',NULL),('2025-12-06 10:25:43','2025-12-06 10:25:43','2025-12-06 10:25:43',1,920,'853c7a6d-d252-4364-9a57-047e84a9796d',223,'bccedbe520d34898aad89e97c5258b2b','snapshots_tripleo',-1,'2025-12-07 10:25:43',NULL),('2025-12-06 10:25:45','2025-12-06 10:25:45','2025-12-06 10:25:45',1,921,'7283574b-8be2-4cd7-a722-942924120b38',218,'bccedbe520d34898aad89e97c5258b2b','volumes',-1,'2025-12-07 10:25:45',NULL),('2025-12-06 10:25:45','2025-12-06 10:25:45','2025-12-06 10:25:45',1,922,'602ab976-02c0-4763-a28c-e7a2146f8ca7',219,'bccedbe520d34898aad89e97c5258b2b','gigabytes',-1,'2025-12-07 10:25:45',NULL),('2025-12-06 10:25:45','2025-12-06 10:25:45','2025-12-06 10:25:45',1,923,'63706902-1dac-4915-89b1-ad54a2573900',220,'bccedbe520d34898aad89e97c5258b2b','volumes_tripleo',-1,'2025-12-07 10:25:45',NULL),('2025-12-06 10:25:45','2025-12-06 10:25:45','2025-12-06 10:25:45',1,924,'e309847d-6b7b-473c-9372-332e5849ac84',221,'bccedbe520d34898aad89e97c5258b2b','gigabytes_tripleo',-1,'2025-12-07 10:25:45',NULL);
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `services`
--

DROP TABLE IF EXISTS `services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `services` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) DEFAULT NULL,
  `binary` varchar(255) DEFAULT NULL,
  `topic` varchar(255) DEFAULT NULL,
  `report_count` int(11) NOT NULL,
  `disabled` tinyint(1) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `disabled_reason` varchar(255) DEFAULT NULL,
  `modified_at` datetime DEFAULT NULL,
  `rpc_current_version` varchar(36) DEFAULT NULL,
  `object_current_version` varchar(36) DEFAULT NULL,
  `replication_status` varchar(36) DEFAULT NULL,
  `frozen` tinyint(1) DEFAULT NULL,
  `active_backend_id` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `services_uuid_idx` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`disabled` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`frozen` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `services`
--

LOCK TABLES `services` WRITE;
/*!40000 ALTER TABLE `services` DISABLE KEYS */;
INSERT INTO `services` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `host`, `binary`, `topic`, `report_count`, `disabled`, `availability_zone`, `disabled_reason`, `modified_at`, `rpc_current_version`, `object_current_version`, `replication_status`, `frozen`, `active_backend_id`, `cluster_name`, `uuid`) VALUES ('2025-12-06 08:30:40','2025-12-06 09:08:37','2025-12-06 09:08:37',1,2,'np0005548785.localdomain','cinder-scheduler','cinder-scheduler',117,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'13694a5c-5e6a-448a-8aa6-c9095423d811'),('2025-12-06 08:30:55','2025-12-06 09:08:39','2025-12-06 09:08:39',1,5,'np0005548786.localdomain','cinder-scheduler','cinder-scheduler',116,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'85ced0bb-9376-400b-9a7b-df39b9116447'),('2025-12-06 08:30:56','2025-12-06 09:08:41','2025-12-06 09:08:41',1,8,'np0005548787.localdomain','cinder-scheduler','cinder-scheduler',117,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'f53cae5a-251a-4c76-9cd9-0427de345559'),('2025-12-06 08:34:23','2025-12-06 09:08:31','2025-12-06 09:08:31',1,11,'np0005548785.localdomain','cinder-backup','cinder-backup',143,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'ab3fc6d8-1cc2-408a-a2a1-790cd710e78c'),('2025-12-06 08:34:59','2025-12-06 10:40:02',NULL,0,14,'hostgroup@tripleo_ceph','cinder-volume','cinder-volume',686,0,'nova',NULL,NULL,'3.18','1.39','disabled',0,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999'),('2025-12-06 09:08:46','2025-12-06 10:40:01',NULL,0,17,'cinder-scheduler-0','cinder-scheduler','cinder-scheduler',546,0,'nova',NULL,NULL,'3.12','1.39','not-capable',0,NULL,NULL,'97a9763a-10d3-49e8-812d-7f991dde37f1'),('2025-12-06 09:08:50','2025-12-06 10:40:01',NULL,0,18,'cinder-backup-0','cinder-backup','cinder-backup',547,0,'nova',NULL,NULL,'2.4','1.39','not-capable',0,NULL,NULL,'c9a43565-9015-47cd-9143-f4e10d830b42');
/*!40000 ALTER TABLE `services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot_metadata`
--

DROP TABLE IF EXISTS `snapshot_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `snapshot_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshot_metadata_snapshot_id` (`snapshot_id`),
  CONSTRAINT `snapshot_metadata_ibfk_1` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot_metadata`
--

LOCK TABLES `snapshot_metadata` WRITE;
/*!40000 ALTER TABLE `snapshot_metadata` DISABLE KEYS */;
INSERT INTO `snapshot_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,1,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key1','value1'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,2,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key2','value2'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,3,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key3','value3_update'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,4,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key4','value4'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,5,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key1','value1'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,6,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key2','value2'),('2025-12-06 10:18:39','2025-12-06 10:18:39','2025-12-06 10:18:39',1,7,'a00b9c59-782e-45ed-9d06-2f801109fc2b','key3','value3_update'),('2025-12-06 10:23:40',NULL,'2025-12-06 10:23:43',1,8,'73823ec5-1373-4275-8959-39183fdbb5f3','snap-meta1','value1'),('2025-12-06 10:23:40',NULL,'2025-12-06 10:23:43',1,9,'73823ec5-1373-4275-8959-39183fdbb5f3','snap-meta2','value2'),('2025-12-06 10:23:40',NULL,'2025-12-06 10:23:43',1,10,'73823ec5-1373-4275-8959-39183fdbb5f3','snap-meta3','value3');
/*!40000 ALTER TABLE `snapshot_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshots`
--

DROP TABLE IF EXISTS `snapshots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshots` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `progress` varchar(255) DEFAULT NULL,
  `volume_size` int(11) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(255) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `cgsnapshot_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `provider_auth` varchar(255) DEFAULT NULL,
  `group_snapshot_id` varchar(36) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_snapshots_cgsnapshot_id` (`cgsnapshot_id`),
  KEY `ix_snapshots_group_snapshot_id` (`group_snapshot_id`),
  KEY `ix_snapshots_volume_id` (`volume_id`),
  KEY `snapshots_deleted_project_id_idx` (`deleted`,`project_id`),
  CONSTRAINT `snapshots_ibfk_1` FOREIGN KEY (`cgsnapshot_id`) REFERENCES `cgsnapshots` (`id`),
  CONSTRAINT `snapshots_ibfk_2` FOREIGN KEY (`group_snapshot_id`) REFERENCES `group_snapshots` (`id`),
  CONSTRAINT `snapshots_volume_id_fkey` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshots`
--

LOCK TABLES `snapshots` WRITE;
/*!40000 ALTER TABLE `snapshots` DISABLE KEYS */;
INSERT INTO `snapshots` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `user_id`, `project_id`, `status`, `progress`, `volume_size`, `scheduled_at`, `display_name`, `display_description`, `provider_location`, `encryption_key_id`, `volume_type_id`, `cgsnapshot_id`, `provider_id`, `provider_auth`, `group_snapshot_id`, `use_quota`) VALUES ('2025-12-06 10:18:39','2025-12-06 10:18:41','2025-12-06 10:18:41',1,'13794588-3f79-4805-8d98-ea6a95d59e09','83e632eb-a022-449b-86c6-d0cc45e117d8','3d981ab0be9140da81d41ec4317c0724','68eebcd7dc804fc1b9bdc2fcca919216','deleted','100%',1,NULL,'tempest-VolumeSnapshotQuotasNegativeTestJSON-Snapshot-2122854120',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:04','2025-12-06 10:23:05','2025-12-06 10:23:06',1,'164aee19-79da-4bc9-a9c4-e4693be755b7','3ab4ca44-ecf4-44f1-8792-adaa83357ca6','5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1647925196',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:20:12','2025-12-06 10:20:28','2025-12-06 10:20:29',1,'1e3255a2-9ad9-48f6-a391-9f63a1c469f5','a63a7999-dcc1-46a4-9418-5b99159f1305','defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','deleted','80%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1592479021',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:20:18','2025-12-06 10:20:19','2025-12-06 10:20:20',1,'270a9a0e-351e-4962-a081-f1de9b524be7','a63a7999-dcc1-46a4-9418-5b99159f1305','defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1837441335',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:17:52','2025-12-06 10:17:58','2025-12-06 10:17:58',1,'2ad324c7-ca64-41fb-ac5d-2c14a5eb323d','2802a656-e0aa-4314-8d2c-b8b6126b5169','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','deleted','100%',1,NULL,'tempest-group_snapshot-198457173',NULL,NULL,NULL,'927dda5f-99e7-4e29-8c0d-bc2850a18ade',NULL,NULL,NULL,'5d570957-ff61-47b9-90b6-1b114d4e460d',1),('2025-12-06 10:20:25','2025-12-06 10:20:26','2025-12-06 10:20:27',1,'2af96ad1-870e-463b-bfcd-531db378ee60','a63a7999-dcc1-46a4-9418-5b99159f1305','defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-1032488157',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:20:21','2025-12-06 10:20:22','2025-12-06 10:20:23',1,'2f86073d-5c57-48cb-be94-ee6d94bf4a51','a63a7999-dcc1-46a4-9418-5b99159f1305','defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-737979530',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:20:15','2025-12-06 10:20:16','2025-12-06 10:20:17',1,'3baae2f8-1463-4225-981e-811fa27d3fe2','a63a7999-dcc1-46a4-9418-5b99159f1305','defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','deleted','100%',1,NULL,'tempest-SnapshotsActionsTest-Snapshot-197336084',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:18:21','2025-12-06 10:18:23','2025-12-06 10:18:23',1,'4a38da70-4ed8-4166-a92e-a68412e8796e','76295f30-f4f9-476f-a489-01aad8911a0e','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','deleted','100%',1,NULL,'tempest-group_snapshot-1147147118',NULL,NULL,NULL,'b0f02714-dafa-4a55-8991-344da33daa86',NULL,NULL,NULL,'21638b59-7b9e-4b1c-b4bd-4beef4d51a82',1),('2025-12-06 10:18:10','2025-12-06 10:18:15','2025-12-06 10:18:15',1,'53ed38e0-2998-441f-87d2-0ed1009ff134','8193eeac-349b-466d-818d-bebdf9a01266','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-747549073',NULL,NULL,NULL,'80dfab08-2b1b-44e7-b2de-1f8cbff02067',NULL,NULL,NULL,'31739f3e-0c63-44d0-aaa7-b4c1d0a5330a',1),('2025-12-06 10:19:09','2025-12-06 10:19:11','2025-12-06 10:19:12',1,'57280a76-eecd-4cac-b61e-1ffa55858fd8','a8eb4c0c-df56-4c17-893c-7a447ebf9a00','969f4ae719ca4cb0abd04f2c326c0e33','2cca2deb59744cdd922204ff50f015d2','deleted','100%',1,NULL,'tempest-VolumesExtendTest-Snapshot-982792542',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:10','2025-12-06 10:23:14','2025-12-06 10:23:21',1,'67178e1f-f65c-45f9-9342-eb33d72bb944','b3e5c0b9-b04c-478b-9509-7a5b19ef9bad','5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-1289992620',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:40','2025-12-06 10:23:42','2025-12-06 10:23:43',1,'73823ec5-1373-4275-8959-39183fdbb5f3','2a956d59-22c7-4046-a8e9-3b5d490292c5','ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-new-snap-596771584','This is the new description of snapshot.',NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:18:37','2025-12-06 10:18:39','2025-12-06 10:18:40',1,'a00b9c59-782e-45ed-9d06-2f801109fc2b','77761d20-bc4c-4614-b166-5fe7fbaa300d','03f5c44949f4449daa2744e8caa11cba','fa979675ad6e484daf8c7eb00c115ce5','deleted','100%',1,NULL,'tempest-SnapshotMetadataTestJSON-Snapshot-641755900',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:25:38','2025-12-06 10:25:40','2025-12-06 10:25:41',1,'a0cfe709-aebd-4236-8e92-4a12cd92785c','642ea33a-b47f-4bfb-80dc-5655255dbf99','92598870d7ae4d9d9212196474c16ecd','bccedbe520d34898aad89e97c5258b2b','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-681084539',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:25:36','2025-12-06 10:25:42','2025-12-06 10:25:43',1,'a93e3d82-fa26-4cfc-b839-d0a74f923ef7','642ea33a-b47f-4bfb-80dc-5655255dbf99','92598870d7ae4d9d9212196474c16ecd','bccedbe520d34898aad89e97c5258b2b','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-218978187',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:18:10','2025-12-06 10:18:15','2025-12-06 10:18:15',1,'ab186809-a1b2-44e7-8c8b-0b9021a7536b','399e556e-571a-48f2-9bdb-f30633a4db9a','105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','deleted','100%',1,NULL,'tempest-GroupSnapshotsTest-Group_Snapshot-747549073',NULL,NULL,NULL,'80dfab08-2b1b-44e7-b2de-1f8cbff02067',NULL,NULL,NULL,'31739f3e-0c63-44d0-aaa7-b4c1d0a5330a',1),('2025-12-06 10:25:37','2025-12-06 10:25:41','2025-12-06 10:25:42',1,'acedbd31-61d7-414a-bed0-3efaf8f29f63','642ea33a-b47f-4bfb-80dc-5655255dbf99','92598870d7ae4d9d9212196474c16ecd','bccedbe520d34898aad89e97c5258b2b','deleted','100%',1,NULL,'tempest-VolumesSnapshotListTestJSON-Snapshot-1698586672',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:19','2025-12-06 10:23:38','2025-12-06 10:23:39',1,'bef84337-bca2-4e45-be0a-64b7f25e1843','2a956d59-22c7-4046-a8e9-3b5d490292c5','ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-939244529',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:45','2025-12-06 10:23:50','2025-12-06 10:23:51',1,'c6c0e653-b88b-490e-946c-e11026fe2f4e','8e0aa32f-5545-4053-9536-b4673a7d97fd','ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1961354095',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:23:54','2025-12-06 10:23:58','2025-12-06 10:23:59',1,'d4bf516e-5a23-43a2-bec3-5b42c5d0e5b8','3facb971-0e1d-4310-975b-5389732207df','ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','deleted','100%',1,NULL,'tempest-VolumesSnapshotTestJSON-Snapshot-1213432249',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:18:25','2025-12-06 10:18:26','2025-12-06 10:18:27',1,'d4ef7d48-df03-41d6-90fd-1d4241a0f231','1378d69b-7a68-4d7d-a347-5e524fd22c13','38b6c1bbbbc64644bf4be20defd13420','bdae3a4fd57541f391ba58bd701f861c','deleted','100%',2,NULL,'tempest-VolumesSnapshotNegativeTestJSON-Snapshot-588017887',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1),('2025-12-06 10:17:37','2025-12-06 10:17:41','2025-12-06 10:17:41',1,'d5d7e2d0-5677-42e0-9726-03bed4afacff','648a0ccb-ff11-4868-822d-923da177d812','9746c911f01c4fee942db215e7ee0535','3d64b92c0ac84e00a6e31382047e6db5','deleted','100%',1,NULL,'tempest-GroupSnapshotsV319Test-Group_Snapshot-1435614098',NULL,NULL,NULL,'03c53960-549b-4237-86ca-243e6e72af42',NULL,NULL,NULL,'0efabb33-cb68-43d1-8f6a-a396134145f2',1),('2025-12-06 10:23:02','2025-12-06 10:23:05','2025-12-06 10:23:07',1,'ee4125b3-c0d2-4f25-a294-57875b7da3c0','3ab4ca44-ecf4-44f1-8792-adaa83357ca6','5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','deleted','100%',1,NULL,'tempest-VolumesDeleteCascade-Snapshot-828627773',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `snapshots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transfers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `crypt_hash` varchar(255) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `no_snapshots` tinyint(1) DEFAULT NULL,
  `source_project_id` varchar(255) DEFAULT NULL,
  `destination_project_id` varchar(255) DEFAULT NULL,
  `accepted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_transfers_volume_id` (`volume_id`),
  CONSTRAINT `transfers_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`no_snapshots` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
INSERT INTO `transfers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `display_name`, `salt`, `crypt_hash`, `expires_at`, `no_snapshots`, `source_project_id`, `destination_project_id`, `accepted`) VALUES ('2025-12-06 10:21:28',NULL,'2025-12-06 10:21:29',1,'08f3cc2f-b1b5-4840-80c4-44ca03460bd8','97bf9a1f-38ca-42f8-b31d-83d4f182afdb',NULL,'12c1f2af','2016ffe9417122267e300aba3f860faf3cabc1bc',NULL,0,'1ef7790e4e3343f99faca2d9c608b7f6','f0737a9f95674489a78f5f5ca36df954',1),('2025-12-06 10:23:36',NULL,'2025-12-06 10:23:36',1,'40122864-315d-472f-91ae-ab22435db8cd','a0f7bb3f-86ec-4ef5-8886-f4a9d3152b06',NULL,'54b82ccd','f6a8c28d83de37d63b6be3a4a38ff39cc09cfbe0',NULL,0,'70f435eabdfe445ab287f469849a5cad',NULL,0),('2025-12-06 10:21:32',NULL,'2025-12-06 10:21:32',1,'4719fdc5-cc46-4c51-b58a-0412c33ffd04','5908ba0e-5371-4fde-b392-10bba350d8e8',NULL,'15d96785','380c9c7610235c8e6b51677a6f12bb0a73e1f8b8',NULL,0,'1ef7790e4e3343f99faca2d9c608b7f6',NULL,0),('2025-12-06 10:21:24',NULL,'2025-12-06 10:21:24',1,'6e127e92-cab7-41aa-8f11-b69ee51dc284','c5548a27-d737-4350-850c-8f75e81edf30',NULL,'5192b188','ce7982ec579e67ddac12fdbd1c136163aa37ae4d',NULL,0,'9847f1afa3464dc7b8aac27cb0247e9e',NULL,0),('2025-12-06 10:22:40',NULL,'2025-12-06 10:22:40',1,'bc7307c8-46d8-4eaf-a095-bb3c31d2a148','fbde1f3c-3c14-4413-85b1-e7e89d833d09',NULL,'e563f60c','87fe96aa44cd4e3d9b4d8ebd1fade2174ac2c178',NULL,0,'709404a5dbce4ee7a79b01c6ddec07bd','257a7584f7b14f3fb15fdf774f388f44',1),('2025-12-06 10:23:31',NULL,'2025-12-06 10:23:32',1,'cc1b3f8b-cf0d-4aaa-a61b-ade7ba80f638','0ade2eca-d7e0-4dff-8008-0e81177746c2',NULL,'70df19de','e6559e0fa9fce23e7918a43496a2b8c08b30c520',NULL,0,'70f435eabdfe445ab287f469849a5cad','e2b088aa0aa04fe8a692c8ef32041e76',1),('2025-12-06 10:21:21',NULL,'2025-12-06 10:21:21',1,'d911a3b8-c21b-4abb-906c-da7393ed2eae','554bfeb5-5a52-4417-94cc-4d7542dc1d87',NULL,'7283fda5','0461dfd3d48638776dd8420027c91ab50f12b4fb',NULL,0,'9847f1afa3464dc7b8aac27cb0247e9e','be339059edb649ed9bb15e3853dd8f27',1);
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_admin_metadata`
--

DROP TABLE IF EXISTS `volume_admin_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_admin_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_admin_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_admin_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_admin_metadata`
--

LOCK TABLES `volume_admin_metadata` WRITE;
/*!40000 ALTER TABLE `volume_admin_metadata` DISABLE KEYS */;
INSERT INTO `volume_admin_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-06 10:21:52','2025-12-06 10:21:52','2025-12-06 10:22:42',1,1,'4fd1bbeb-2532-44cd-9c93-c5b210752e41','readonly','False'),('2025-12-06 10:23:20',NULL,'2025-12-06 10:23:37',1,2,'c06e23b0-7c5a-499b-9bb0-36619d31f978','temporary','True');
/*!40000 ALTER TABLE `volume_admin_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_attachment`
--

DROP TABLE IF EXISTS `volume_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_attachment` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `volume_id` varchar(36) NOT NULL,
  `attached_host` varchar(255) DEFAULT NULL,
  `instance_uuid` varchar(36) DEFAULT NULL,
  `mountpoint` varchar(255) DEFAULT NULL,
  `attach_time` datetime DEFAULT NULL,
  `detach_time` datetime DEFAULT NULL,
  `attach_mode` varchar(36) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `connection_info` text DEFAULT NULL,
  `connector` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_attachment_volume_id` (`volume_id`),
  CONSTRAINT `volume_attachment_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_attachment`
--

LOCK TABLES `volume_attachment` WRITE;
/*!40000 ALTER TABLE `volume_attachment` DISABLE KEYS */;
INSERT INTO `volume_attachment` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `attached_host`, `instance_uuid`, `mountpoint`, `attach_time`, `detach_time`, `attach_mode`, `attach_status`, `connection_info`, `connector`) VALUES ('2025-12-06 10:24:56','2025-12-06 10:25:19','2025-12-06 10:25:19',1,'9fd8fe29-efa0-4174-a6a7-cc2325d45439','aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965','np0005548790.localdomain','b59377c8-c3d7-452b-8305-d2853ef47bb4','/dev/vdb','2025-12-06 10:24:58','2025-12-06 10:25:19','rw','detached','{\"name\": \"volumes/volume-aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965\", \"hosts\": [\"172.18.0.103\", \"172.18.0.104\", \"172.18.0.105\"], \"ports\": [\"6789\", \"6789\", \"6789\"], \"cluster_name\": \"ceph\", \"auth_enabled\": true, \"auth_username\": \"openstack\", \"secret_type\": \"ceph\", \"secret_uuid\": \"1939e851-b10c-5c3b-9bb7-8e7f380233e8\", \"volume_id\": \"aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965\", \"discard\": true, \"qos_specs\": null, \"access_mode\": \"rw\", \"encrypted\": false, \"cacheable\": false, \"driver_volume_type\": \"rbd\", \"attachment_id\": \"9fd8fe29-efa0-4174-a6a7-cc2325d45439\"}','{\"platform\": \"x86_64\", \"os_type\": \"linux\", \"ip\": \"192.168.122.108\", \"host\": \"np0005548790.localdomain\", \"multipath\": true, \"initiator\": \"iqn.1994-05.com.redhat:a4f71413484d\", \"do_local_attach\": false, \"nvme_hostid\": \"f03c6239-85fa-4e2b-b1f7-56cf939bb96f\", \"system uuid\": \"f03c6239-85fa-4e2b-b1f7-56cf939bb96f\", \"nqn\": \"nqn.2014-08.org.nvmexpress:uuid:f03c6239-85fa-4e2b-b1f7-56cf939bb96f\", \"nvme_native_multipath\": true, \"found_dsc\": \"\", \"mountpoint\": \"/dev/vdb\"}');
/*!40000 ALTER TABLE `volume_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_glance_metadata`
--

DROP TABLE IF EXISTS `volume_glance_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_glance_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_glance_metadata_snapshot_id` (`snapshot_id`),
  KEY `ix_volume_glance_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_glance_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `volume_glance_metadata_ibfk_2` FOREIGN KEY (`snapshot_id`) REFERENCES `snapshots` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_glance_metadata`
--

LOCK TABLES `volume_glance_metadata` WRITE;
/*!40000 ALTER TABLE `volume_glance_metadata` DISABLE KEYS */;
INSERT INTO `volume_glance_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `snapshot_id`, `key`, `value`) VALUES ('2025-12-06 10:18:59',NULL,'2025-12-06 10:19:06',1,1,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'signature_verified','False'),('2025-12-06 10:18:59',NULL,'2025-12-06 10:19:10',1,2,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'signature_verified','False'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,3,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'hw_rng_model','virtio'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,4,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,5,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,6,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,7,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'container_format','bare'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,8,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'disk_format','qcow2'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,9,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'min_disk','0'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,10,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'min_ram','0'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:06',1,11,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'size','21430272'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,12,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'hw_rng_model','virtio'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,13,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,14,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,15,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,16,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'container_format','bare'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,17,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'disk_format','qcow2'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,18,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'min_disk','0'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,19,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'min_ram','0'),('2025-12-06 10:19:04',NULL,'2025-12-06 10:19:10',1,20,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'size','21430272'),('2025-12-06 10:19:05',NULL,'2025-12-06 10:19:09',1,21,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'signature_verified','False'),('2025-12-06 10:19:05',NULL,'2025-12-06 10:19:09',1,22,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'hw_rng_model','virtio'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,23,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,24,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,25,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,26,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'container_format','bare'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,27,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'disk_format','qcow2'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,28,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'min_disk','0'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,29,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'min_ram','0'),('2025-12-06 10:19:06',NULL,'2025-12-06 10:19:09',1,30,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'size','21430272'),('2025-12-06 10:19:33',NULL,'2025-12-06 10:19:42',1,31,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'signature_verified','False'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,32,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'hw_rng_model','virtio'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,33,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,34,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,35,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,36,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'container_format','bare'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,37,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'disk_format','qcow2'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,38,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'min_disk','0'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,39,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'min_ram','0'),('2025-12-06 10:19:37',NULL,'2025-12-06 10:19:42',1,40,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'size','21430272'),('2025-12-06 10:22:30',NULL,'2025-12-06 10:22:37',1,41,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'signature_verified','False'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,42,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'hw_rng_model','virtio'),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:37',1,43,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'image_id','5137a025-3c5f-43c1-bc64-5f41270040a5'),('2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:37',1,44,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'image_name','image'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,45,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,46,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'container_format','bare'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,47,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'disk_format','qcow2'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,48,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'min_disk','0'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,49,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'min_ram','0'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,50,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'size','21430272'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:37',1,51,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'kernel_id','6ff710d2-942b-4d6b-9168-8c9cc2404ab1'),('2025-12-06 10:22:36',NULL,'2025-12-06 10:22:36',1,52,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'ramdisk_id','somedisk'),('2025-12-06 10:23:51',NULL,'2025-12-06 10:24:09',1,53,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'signature_verified','False'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,54,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'hw_rng_model','virtio'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,55,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,56,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,57,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,58,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'container_format','bare'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,59,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'disk_format','qcow2'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,60,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'min_disk','0'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,61,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'min_ram','0'),('2025-12-06 10:23:55',NULL,'2025-12-06 10:24:09',1,62,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'size','21430272'),('2025-12-06 10:24:02',NULL,'2025-12-06 10:24:05',1,63,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'signature_verified','False'),('2025-12-06 10:24:02',NULL,'2025-12-06 10:24:05',1,64,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'hw_rng_model','virtio'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,65,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'image_id','6a944ab6-8965-4055-b7fc-af6e395005ea'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,66,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'image_name','cirros-0.6.2-x86_64-disk.img'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,67,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'checksum','c8fc807773e5354afe61636071771906'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,68,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'container_format','bare'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,69,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'disk_format','qcow2'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,70,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'min_disk','0'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,71,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'min_ram','0'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,72,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'size','21430272');
/*!40000 ALTER TABLE `volume_glance_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_metadata`
--

DROP TABLE IF EXISTS `volume_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_metadata` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_metadata_volume_id` (`volume_id`),
  CONSTRAINT `volume_metadata_ibfk_1` FOREIGN KEY (`volume_id`) REFERENCES `volumes` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_metadata`
--

LOCK TABLES `volume_metadata` WRITE;
/*!40000 ALTER TABLE `volume_metadata` DISABLE KEYS */;
INSERT INTO `volume_metadata` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_id`, `key`, `value`) VALUES ('2025-12-06 10:18:18','2025-12-06 10:18:18','2025-12-06 10:18:19',1,1,'683e6875-f0c9-4f46-8a67-ab51490f007f','key1','value1_update'),('2025-12-06 10:18:18','2025-12-06 10:18:18','2025-12-06 10:18:18',1,2,'683e6875-f0c9-4f46-8a67-ab51490f007f','key2','value2'),('2025-12-06 10:18:18','2025-12-06 10:18:18','2025-12-06 10:18:18',1,3,'683e6875-f0c9-4f46-8a67-ab51490f007f','key3','value3'),('2025-12-06 10:18:18','2025-12-06 10:18:19','2025-12-06 10:18:19',1,4,'683e6875-f0c9-4f46-8a67-ab51490f007f','key4','value4'),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,5,'683e6875-f0c9-4f46-8a67-ab51490f007f','key1','value1'),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,6,'683e6875-f0c9-4f46-8a67-ab51490f007f','key2','value2'),('2025-12-06 10:18:19','2025-12-06 10:18:19','2025-12-06 10:18:19',1,7,'683e6875-f0c9-4f46-8a67-ab51490f007f','key3','value3_update'),('2025-12-06 10:19:17',NULL,'2025-12-06 10:19:22',1,8,'ded420af-d470-4f44-85ad-b5ef5d97c56c','Type','Test'),('2025-12-06 10:19:24',NULL,'2025-12-06 10:19:29',1,9,'3a8b91f9-c4bd-4db7-8691-02df4d82b916','Type','Test'),('2025-12-06 10:19:31',NULL,'2025-12-06 10:19:42',1,10,'999412e3-4ef5-476e-8154-00b3f6cde17c','Type','Test'),('2025-12-06 10:22:39',NULL,'2025-12-06 10:22:41',1,11,'eb844db9-3326-400d-ac0b-d6537fc655b9','src_backup_id','0c7dd433-ba6f-4f9b-be17-f12361d6cf82'),('2025-12-06 10:22:49',NULL,'2025-12-06 10:22:57',1,12,'f1f8b73f-e1f0-4c0d-a52a-cf06a9417441','Type','work'),('2025-12-06 10:22:50',NULL,'2025-12-06 10:22:56',1,13,'437b7552-7684-4e8d-8041-5fa73d48add9','Type','work'),('2025-12-06 10:22:51',NULL,'2025-12-06 10:22:55',1,14,'2b81c67f-e5f1-4fbc-bc36-df38f49059bd','Type','work'),('2025-12-06 10:24:03',NULL,'2025-12-06 10:24:05',1,15,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee','src_backup_id','2275aa64-1738-42a1-9c89-3639a4019908');
/*!40000 ALTER TABLE `volume_metadata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_extra_specs`
--

DROP TABLE IF EXISTS `volume_type_extra_specs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_extra_specs` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `volume_type_id` varchar(36) NOT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_type_extra_specs_volume_type_id` (`volume_type_id`),
  CONSTRAINT `volume_type_extra_specs_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_extra_specs`
--

LOCK TABLES `volume_type_extra_specs` WRITE;
/*!40000 ALTER TABLE `volume_type_extra_specs` DISABLE KEYS */;
INSERT INTO `volume_type_extra_specs` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `volume_type_id`, `key`, `value`) VALUES ('2025-12-06 10:22:11',NULL,'2025-12-06 10:22:13',1,1,'c9f6ce65-267e-498a-8d38-b0c676fa81d5','storage_protocol','tempest-storage_protocol-717766507'),('2025-12-06 10:22:11',NULL,'2025-12-06 10:22:13',1,2,'c9f6ce65-267e-498a-8d38-b0c676fa81d5','vendor_name','tempest-vendor_name-209053164'),('2025-12-06 10:22:13',NULL,'2025-12-06 10:22:14',1,3,'d59bdf68-d363-45a6-a805-f0d963c6d91c','storage_protocol','tempest-storage_protocol-1033424772'),('2025-12-06 10:22:13',NULL,'2025-12-06 10:22:14',1,4,'d59bdf68-d363-45a6-a805-f0d963c6d91c','vendor_name','tempest-vendor_name-658291450'),('2025-12-06 10:22:49',NULL,'2025-12-06 10:22:49',1,5,'625b1af3-e23c-4e50-bc07-bad325930d11','storage_protocol','iSCSI'),('2025-12-06 10:22:49',NULL,'2025-12-06 10:22:49',1,6,'625b1af3-e23c-4e50-bc07-bad325930d11','vendor_name','Open Source'),('2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',1,7,'3af1a561-e26b-4e44-a837-e51f0237afa1','spec3','val1'),('2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',1,8,'3af1a561-e26b-4e44-a837-e51f0237afa1','spec1','val1'),('2025-12-06 10:22:55','2025-12-06 10:22:55','2025-12-06 10:22:55',1,9,'3af1a561-e26b-4e44-a837-e51f0237afa1','spec2','val3'),('2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',1,10,'3af1a561-e26b-4e44-a837-e51f0237afa1','spec4','val4'),('2025-12-06 10:23:02',NULL,'2025-12-06 10:23:03',1,11,'35de368f-8f47-42b7-b090-fe122e06f93c','spec1','val1');
/*!40000 ALTER TABLE `volume_type_extra_specs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_type_projects`
--

DROP TABLE IF EXISTS `volume_type_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_type_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `volume_type_id` varchar(36) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `volume_type_id` (`volume_type_id`,`project_id`,`deleted`),
  CONSTRAINT `volume_type_projects_ibfk_1` FOREIGN KEY (`volume_type_id`) REFERENCES `volume_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_type_projects`
--

LOCK TABLES `volume_type_projects` WRITE;
/*!40000 ALTER TABLE `volume_type_projects` DISABLE KEYS */;
INSERT INTO `volume_type_projects` (`id`, `created_at`, `updated_at`, `deleted_at`, `volume_type_id`, `project_id`, `deleted`) VALUES (1,'2025-12-06 10:21:16',NULL,'2025-12-06 10:21:18','97789e4a-9087-42f3-895a-7f52ff4a5302','617e21f2837c4be9825357089f4f14b0',1),(2,'2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19','55ea79e8-0bd1-4470-8a7c-4b1264bb79ed','617e21f2837c4be9825357089f4f14b0',2),(3,'2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19','55ea79e8-0bd1-4470-8a7c-4b1264bb79ed','b0d8ee3dce5f48ada2c690a922117eb5',3);
/*!40000 ALTER TABLE `volume_type_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volume_types`
--

DROP TABLE IF EXISTS `volume_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volume_types` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `qos_specs_id` varchar(36) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volume_types_qos_specs_id` (`qos_specs_id`),
  CONSTRAINT `volume_types_ibfk_1` FOREIGN KEY (`qos_specs_id`) REFERENCES `quality_of_service_specs` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`is_public` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volume_types`
--

LOCK TABLES `volume_types` WRITE;
/*!40000 ALTER TABLE `volume_types` DISABLE KEYS */;
INSERT INTO `volume_types` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`, `qos_specs_id`, `is_public`, `description`) VALUES ('2025-12-06 10:22:49','2025-12-06 10:22:49','2025-12-06 10:22:50',1,'01d63061-84ee-4dea-a018-f264a1c74d15','tempest-volume-type-657125505',NULL,0,'tempest-volume-type-description-197071517'),('2025-12-06 10:17:33',NULL,'2025-12-06 10:17:43',1,'03c53960-549b-4237-86ca-243e6e72af42','tempest-GroupSnapshotsV319Test-volume-type-552402764',NULL,1,NULL),('2025-12-06 10:22:20',NULL,'2025-12-06 10:22:23',1,'1284d8af-5130-4cd5-b7eb-d43ba7ac283b','tempest-GroupsV320Test-volume-type-1054512995',NULL,1,NULL),('2025-12-06 10:22:49',NULL,'2025-12-06 10:22:49',1,'332c9b63-3160-487c-8c95-a73ae379254c','tempest-VolumeTypesTest-volume-type-1318464416',NULL,1,NULL),('2025-12-06 10:23:02',NULL,'2025-12-06 10:23:03',1,'35de368f-8f47-42b7-b090-fe122e06f93c','tempest-ExtraSpecsNegativeTest-volume-type-1494074056',NULL,1,NULL),('2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',1,'3af1a561-e26b-4e44-a837-e51f0237afa1','tempest-VolumeTypesExtraSpecsTest-volume-type-400705183',NULL,1,NULL),('2025-12-06 10:17:57',NULL,'2025-12-06 10:18:02',1,'42e58106-029f-436b-ae5e-9fb7e18e61e7','volume-type-2',NULL,1,NULL),('2025-12-06 08:33:41',NULL,NULL,0,'431a3082-d870-475c-9229-feea907d17d2','tripleo',NULL,1,NULL),('2025-12-06 10:21:00',NULL,'2025-12-06 10:21:09',1,'4775656f-035a-4184-abec-1a7b067cc6c9','tempest-GroupsTest-volume-type-1333005575',NULL,1,NULL),('2025-12-06 10:17:57',NULL,'2025-12-06 10:18:02',1,'4bceba66-78f0-4f12-b11a-13a0bea80f83','volume-type-1',NULL,1,NULL),('2025-12-06 10:20:54',NULL,'2025-12-06 10:20:54',1,'55bf3b49-8f62-4751-a58a-aeda327eeef1','tempest-VolumeTypesNegativeTest-volume-type-5598190',NULL,1,NULL),('2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19',1,'55ea79e8-0bd1-4470-8a7c-4b1264bb79ed','tempest-VolumeTypesAccessTest-volume-type-370299273',NULL,0,NULL),('2025-12-06 10:20:53',NULL,'2025-12-06 10:20:54',1,'5a4801c5-5f13-47e5-adce-11b0e05cc40c','tempest-VolumeTypesNegativeTest-volume-type-905214728',NULL,0,NULL),('2025-12-06 10:22:49',NULL,'2025-12-06 10:22:49',1,'625b1af3-e23c-4e50-bc07-bad325930d11','tempest-VolumeTypesTest-volume-type-872624775',NULL,1,'tempest-volume-type-description-1902181873'),('2025-12-06 10:18:01',NULL,'2025-12-06 10:18:18',1,'80dfab08-2b1b-44e7-b2de-1f8cbff02067','tempest-GroupSnapshotsTest-volume-type-1882379761',NULL,1,NULL),('2025-12-06 10:20:53',NULL,'2025-12-06 10:21:00',1,'8cfd4194-b2ea-43fd-9d8f-e9aee14615fa','tempest-GroupsTest-volume-type-1538876885',NULL,1,NULL),('2025-12-06 10:17:49',NULL,'2025-12-06 10:18:00',1,'927dda5f-99e7-4e29-8c0d-bc2850a18ade','tempest-GroupSnapshotsTest-volume-type-2067352107',NULL,1,NULL),('2025-12-06 10:21:16',NULL,'2025-12-06 10:21:19',1,'97789e4a-9087-42f3-895a-7f52ff4a5302','tempest-VolumeTypesAccessTest-volume-type-1317874922',NULL,0,NULL),('2025-12-06 10:18:18',NULL,'2025-12-06 10:18:25',1,'b0f02714-dafa-4a55-8991-344da33daa86','tempest-GroupSnapshotsTest-volume-type-1726901555',NULL,1,NULL),('2025-12-06 08:26:03','2025-12-06 08:26:03','2025-12-06 08:33:46',1,'bd4eb425-9ec6-4368-ad3c-19262cdf43a1','__DEFAULT__',NULL,1,'Default Volume Type'),('2025-12-06 10:22:02','2025-12-06 10:22:03','2025-12-06 10:22:03',1,'c181ba2a-6425-4b19-8ea7-9f7b6714a9f7','tempest-QosSpecsTestJSON-volume-type-137298494',NULL,1,NULL),('2025-12-06 10:22:11',NULL,'2025-12-06 10:22:13',1,'c9f6ce65-267e-498a-8d38-b0c676fa81d5','tempest-UserMessagesTest-volume-type-1709855650',NULL,1,NULL),('2025-12-06 10:22:13',NULL,'2025-12-06 10:22:14',1,'d59bdf68-d363-45a6-a805-f0d963c6d91c','tempest-UserMessagesTest-volume-type-1206940502',NULL,1,NULL),('2025-12-06 10:22:02','2025-12-06 10:22:03','2025-12-06 10:22:03',1,'debd2ca9-ef14-4a46-97b5-1b56a1b42397','tempest-QosSpecsTestJSON-volume-type-58570001',NULL,1,NULL),('2025-12-06 10:22:20',NULL,'2025-12-06 10:22:21',1,'e1f37386-8d27-42c7-a9b7-857937f6bbd3','tempest-VolumeQuotaClassesTest-volume-type-852158285',NULL,1,NULL),('2025-12-06 10:21:48',NULL,'2025-12-06 10:21:56',1,'f53abe89-cb1b-4f24-bcc7-eb7c1802a9ea','tempest-GroupsV314Test-volume-type-1517531844',NULL,1,NULL),('2025-12-06 10:22:02','2025-12-06 10:22:03','2025-12-06 10:22:03',1,'fa192fc4-efb7-4751-ab51-c26ce60cf66c','tempest-QosSpecsTestJSON-volume-type-1481151543',NULL,1,NULL);
/*!40000 ALTER TABLE `volume_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ec2_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `availability_zone` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `attach_status` varchar(255) DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `launched_at` datetime DEFAULT NULL,
  `terminated_at` datetime DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  `display_description` varchar(255) DEFAULT NULL,
  `provider_location` varchar(256) DEFAULT NULL,
  `provider_auth` varchar(256) DEFAULT NULL,
  `snapshot_id` varchar(36) DEFAULT NULL,
  `volume_type_id` varchar(36) NOT NULL,
  `source_volid` varchar(36) DEFAULT NULL,
  `bootable` tinyint(1) DEFAULT NULL,
  `provider_geometry` varchar(255) DEFAULT NULL,
  `_name_id` varchar(36) DEFAULT NULL,
  `encryption_key_id` varchar(36) DEFAULT NULL,
  `migration_status` varchar(255) DEFAULT NULL,
  `replication_status` varchar(255) DEFAULT NULL,
  `replication_extended_status` varchar(255) DEFAULT NULL,
  `replication_driver_data` varchar(255) DEFAULT NULL,
  `consistencygroup_id` varchar(36) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `multiattach` tinyint(1) DEFAULT NULL,
  `previous_status` varchar(255) DEFAULT NULL,
  `cluster_name` varchar(255) DEFAULT NULL,
  `group_id` varchar(36) DEFAULT NULL,
  `service_uuid` varchar(36) DEFAULT NULL,
  `shared_targets` tinyint(1) DEFAULT NULL,
  `use_quota` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_volumes_group_id` (`group_id`),
  KEY `ix_volumes_consistencygroup_id` (`consistencygroup_id`),
  KEY `volumes_service_uuid_idx` (`service_uuid`,`deleted`),
  KEY `volumes_deleted_project_id_idx` (`deleted`,`project_id`),
  KEY `volumes_deleted_host_idx` (`deleted`,`host`),
  CONSTRAINT `volumes_ibfk_1` FOREIGN KEY (`consistencygroup_id`) REFERENCES `consistencygroups` (`id`),
  CONSTRAINT `volumes_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `volumes_ibfk_3` FOREIGN KEY (`service_uuid`) REFERENCES `services` (`uuid`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`bootable` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`multiattach` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`shared_targets` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `volumes`
--

LOCK TABLES `volumes` WRITE;
/*!40000 ALTER TABLE `volumes` DISABLE KEYS */;
INSERT INTO `volumes` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `ec2_id`, `user_id`, `project_id`, `host`, `size`, `availability_zone`, `status`, `attach_status`, `scheduled_at`, `launched_at`, `terminated_at`, `display_name`, `display_description`, `provider_location`, `provider_auth`, `snapshot_id`, `volume_type_id`, `source_volid`, `bootable`, `provider_geometry`, `_name_id`, `encryption_key_id`, `migration_status`, `replication_status`, `replication_extended_status`, `replication_driver_data`, `consistencygroup_id`, `provider_id`, `multiattach`, `previous_status`, `cluster_name`, `group_id`, `service_uuid`, `shared_targets`, `use_quota`) VALUES ('2025-12-06 10:19:04','2025-12-06 10:19:07','2025-12-06 10:19:09',1,'0003b2f8-6655-41f6-be64-0beef5ccb973',NULL,'ec29f02579a54d488cbc8a2db31e2544','d9b02e74009b4dd7b38d073a2a13fed2','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:05','2025-12-06 10:19:06','2025-12-06 10:19:07','tempest-VolumesCloneTest-Volume-579902830',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2','f02f1e30-4817-476d-91fa-3e66cad146f1',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:30','2025-12-06 10:23:32','2025-12-06 10:23:34',1,'0ade2eca-d7e0-4dff-8008-0e81177746c2',NULL,'4467b515c7fc4de296ba6d1baa89897d','e2b088aa0aa04fe8a692c8ef32041e76','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:30','2025-12-06 10:23:31','2025-12-06 10:23:32','tempest-VolumesTransfersV357Test-Volume-1059221031',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:38','2025-12-06 10:19:39','2025-12-06 10:19:40',1,'0da0e98e-36a9-424f-b00b-8f525536d1b8',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:38','2025-12-06 10:19:38','2025-12-06 10:19:39','tempest-VolumesGetTest-Volume-636667961',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:20:56','2025-12-06 10:20:58','2025-12-06 10:20:58',1,'1174eca8-6d34-4276-995f-3968a9bb3246',NULL,'a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:20:56','2025-12-06 10:20:56',NULL,'tempest-volume-1151786250',NULL,NULL,NULL,NULL,'8cfd4194-b2ea-43fd-9d8f-e9aee14615fa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'61f08fa1-34ba-4f34-ae28-4354b3cad228','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:24','2025-12-06 10:18:28','2025-12-06 10:18:28',1,'1378d69b-7a68-4d7d-a347-5e524fd22c13',NULL,'38b6c1bbbbc64644bf4be20defd13420','bdae3a4fd57541f391ba58bd701f861c','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:18:24','2025-12-06 10:18:24','2025-12-06 10:18:28','tempest-VolumesSnapshotNegativeTestJSON-Volume-1074506097',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:03','2025-12-06 10:21:08','2025-12-06 10:21:08',1,'152dd506-a203-44c6-b81c-dd47d23a9fad',NULL,'a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:03','2025-12-06 10:21:03',NULL,'tempest-volume-1671739791',NULL,NULL,NULL,NULL,'4775656f-035a-4184-abec-1a7b067cc6c9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'06c34df4-7c6a-4a20-86ff-af8c5c25fdcd','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:11','2025-12-06 10:22:11','2025-12-06 10:22:13',1,'153abf3e-83be-4688-baed-f6caf3971b67',NULL,'c9d7db0d35bf49bca22e0a046ec5faf2','0869d8bc1b684db8b15afc4eebf3f39d',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-1757741358',NULL,NULL,NULL,NULL,'c9f6ce65-267e-498a-8d38-b0c676fa81d5',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-12-06 10:19:25','2025-12-06 10:19:27','2025-12-06 10:19:27',1,'21da2259-f8b9-4b83-97eb-a91f568e897f',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:26','2025-12-06 10:19:26','2025-12-06 10:19:27','tempest-VolumesGetTest-Volume-1058694622',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:17:51','2025-12-06 10:18:00','2025-12-06 10:18:00',1,'2802a656-e0aa-4314-8d2c-b8b6126b5169',NULL,'105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:17:51','2025-12-06 10:17:51',NULL,'tempest-volume-316803550',NULL,NULL,NULL,NULL,'927dda5f-99e7-4e29-8c0d-bc2850a18ade',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'1f8f804e-8752-4bda-a487-d6683876ed8b','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:50','2025-12-06 10:21:55','2025-12-06 10:21:55',1,'29a01f12-c3f9-4802-b5fc-d34232f73460',NULL,'69342e816b8a4c66a18fe32123f49c95','8566f9acc2b141e2a06f7a1cbef81657','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:50','2025-12-06 10:21:50',NULL,'tempest-volume-1462871684',NULL,NULL,NULL,NULL,'f53abe89-cb1b-4f24-bcc7-eb7c1802a9ea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'a63a6870-1eca-49de-936b-8fcaf3bed7ec','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:18','2025-12-06 10:24:01','2025-12-06 10:24:02',1,'2a956d59-22c7-4046-a8e9-3b5d490292c5',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:18','2025-12-06 10:23:18','2025-12-06 10:24:01','tempest-VolumesSnapshotTestJSON-Volume-764781009',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:51','2025-12-06 10:22:54','2025-12-06 10:22:55',1,'2b81c67f-e5f1-4fbc-bc36-df38f49059bd',NULL,'165e7f6825c844478ef86621d4584c4d','24d6923c0e47455ca133a232d042e0fc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:51','2025-12-06 10:22:51','2025-12-06 10:22:54','tempest-VolumesListTestJSON-Volume-1881592261',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:11','2025-12-06 10:19:16','2025-12-06 10:19:16',1,'2be7a959-f0e5-4c1d-8216-915ff973d59a',NULL,'ec29f02579a54d488cbc8a2db31e2544','d9b02e74009b4dd7b38d073a2a13fed2','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:11','2025-12-06 10:19:11','2025-12-06 10:19:16','tempest-VolumesCloneTest-Volume-1044950674',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:49','2025-12-06 10:24:08','2025-12-06 10:24:09',1,'323db21e-9cd3-4a57-af96-05c49a2bb708',NULL,'b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:49','2025-12-06 10:23:55','2025-12-06 10:24:08','tempest-VolumesBackupsTest-Volume-89239679',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:47','2025-12-06 10:23:48','2025-12-06 10:23:49',1,'32cbf6c3-0316-404a-8e4b-5d35fd06cbbc',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:23:47','2025-12-06 10:23:48','2025-12-06 10:23:48','tempest-VolumesSnapshotTestJSON-Volume-1900048680',NULL,NULL,NULL,'c6c0e653-b88b-490e-946c-e11026fe2f4e','431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:20','2025-12-06 10:19:22','2025-12-06 10:19:23',1,'34481e74-44ff-43be-a796-dd101ba8a9ca',NULL,'5533446cae154558992c3e249c7e19ee','839b049bc4e04682a1654015a92dbbe4','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:19:21','2025-12-06 10:19:21','2025-12-06 10:19:22','tempest-VolumesCloneNegativeTest-Volume-625922732',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:02','2025-12-06 10:21:07','2025-12-06 10:21:08',1,'36b98030-2f20-470d-a40f-358d96a46ada',NULL,'0d787d17c2df4c1cbf7bf928906ac9e8','7b08d7598dc24ecfb48eb0563cd3107f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:02','2025-12-06 10:21:02','2025-12-06 10:21:07','tempest-VolumesListAdminTestJSON-Volume-402161038',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:03','2025-12-06 10:18:17','2025-12-06 10:18:17',1,'399e556e-571a-48f2-9bdb-f30633a4db9a',NULL,'105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:04','2025-12-06 10:18:04',NULL,'tempest-volume-1797619386',NULL,NULL,NULL,NULL,'80dfab08-2b1b-44e7-b2de-1f8cbff02067',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'f2946e24-c767-49a4-b96c-8c9689ac8ba7','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:24','2025-12-06 10:19:28','2025-12-06 10:19:29',1,'3a8b91f9-c4bd-4db7-8691-02df4d82b916',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:24','2025-12-06 10:19:25','2025-12-06 10:19:28','tempest-VolumesGetTest-new-Volume-1393577354','This is the new description of volume',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2','80e2321a-c9b7-4c20-b250-30f47124a368',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:01','2025-12-06 10:23:05','2025-12-06 10:23:08',1,'3ab4ca44-ecf4-44f1-8792-adaa83357ca6',NULL,'5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:01','2025-12-06 10:23:01','2025-12-06 10:23:05','tempest-VolumesDeleteCascade-Volume-85580002',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:12','2025-12-06 10:19:15','2025-12-06 10:19:15',1,'3eb5dfaa-9c8b-43d0-b30e-5450005d7e6f',NULL,'ec29f02579a54d488cbc8a2db31e2544','d9b02e74009b4dd7b38d073a2a13fed2','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:19:12','2025-12-06 10:19:14','2025-12-06 10:19:15','tempest-VolumesCloneTest-Volume-1069789187',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2','2be7a959-f0e5-4c1d-8216-915ff973d59a',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:53','2025-12-06 10:24:00','2025-12-06 10:24:01',1,'3facb971-0e1d-4310-975b-5389732207df',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:53','2025-12-06 10:23:53','2025-12-06 10:24:00','tempest-VolumesSnapshotTestJSON-Volume-102941073',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:50','2025-12-06 10:22:55','2025-12-06 10:22:56',1,'437b7552-7684-4e8d-8041-5fa73d48add9',NULL,'165e7f6825c844478ef86621d4584c4d','24d6923c0e47455ca133a232d042e0fc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:50','2025-12-06 10:22:50','2025-12-06 10:22:55','tempest-VolumesListTestJSON-Volume-975151857',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:36','2025-12-06 10:22:37','2025-12-06 10:22:38',1,'478ca380-eb18-4143-ad2f-d7b6c330a727',NULL,'86df66862081439ba17e1c307ef669b9','709404a5dbce4ee7a79b01c6ddec07bd','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:36','2025-12-06 10:22:36','2025-12-06 10:22:37','tempest-VolumeQuotasAdminTestJSON-Volume-346318187',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:50','2025-12-06 10:22:41','2025-12-06 10:22:42',1,'4fd1bbeb-2532-44cd-9c93-c5b210752e41',NULL,'9de6f48dc19147a792197ebb1653dc5e','fd1c979900294beeb6f273c0e1a6333a','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:50','2025-12-06 10:21:50','2025-12-06 10:22:41','tempest-VolumesActionsTest-Volume-1541253450',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:17:58','2025-12-06 10:18:01','2025-12-06 10:18:01',1,'505f9d38-6698-4640-8cae-184d6409c7b2',NULL,'a753882f71734847b7e625f47b6c2b9d','514ec268f5ca4320a08c7470e3cc5655','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:17:58','2025-12-06 10:17:58','2025-12-06 10:18:01','tempest-VolumeRetypeWithoutMigrationTest-Volume-1049072532',NULL,NULL,NULL,NULL,'42e58106-029f-436b-ae5e-9fb7e18e61e7',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:01','2025-12-06 10:21:08','2025-12-06 10:21:09',1,'50cf84c8-95d9-4ae4-bf33-2a521ffbd36e',NULL,'0d787d17c2df4c1cbf7bf928906ac9e8','7b08d7598dc24ecfb48eb0563cd3107f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:01','2025-12-06 10:21:01','2025-12-06 10:21:08','tempest-VolumesListAdminTestJSON-Volume-1495894822',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:20:36','2025-12-06 10:20:38','2025-12-06 10:20:39',1,'516b5c20-6e33-4cf6-bedd-7de7b878a722',NULL,'3742bd6bc50045dc948a5ed989fe1987','889aeebe2fa34e0285e071ed4d74ee04','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:20:36','2025-12-06 10:20:37','2025-12-06 10:20:38','tempest-VolumeQuotasNegativeTestJSON-Volume-349111172',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:20','2025-12-06 10:21:22','2025-12-06 10:21:22',1,'554bfeb5-5a52-4417-94cc-4d7542dc1d87',NULL,'62ed0c0c12f545ef83d0c9ca14c39352','be339059edb649ed9bb15e3853dd8f27','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:20','2025-12-06 10:21:20','2025-12-06 10:21:22','tempest-VolumesTransfersV355Test-Volume-1097245017',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:31','2025-12-06 10:21:32','2025-12-06 10:21:33',1,'5908ba0e-5371-4fde-b392-10bba350d8e8',NULL,'2c8a6bc218904e268bcdd072b3b3d86d','1ef7790e4e3343f99faca2d9c608b7f6','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:31','2025-12-06 10:21:31','2025-12-06 10:21:32','tempest-VolumesTransfersTest-Volume-1411896186',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:17:54','2025-12-06 10:17:56','2025-12-06 10:17:56',1,'60afae2e-2ca8-4fab-ab1f-3446153c8322',NULL,'105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2ad324c7-ca64-41fb-ac5d-2c14a5eb323d','927dda5f-99e7-4e29-8c0d-bc2850a18ade',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'d333590b-3e8b-433e-b9e6-239776cbcf11',NULL,1,1),('2025-12-06 10:25:34','2025-12-06 10:25:44','2025-12-06 10:25:45',1,'642ea33a-b47f-4bfb-80dc-5655255dbf99',NULL,'92598870d7ae4d9d9212196474c16ecd','bccedbe520d34898aad89e97c5258b2b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:25:34','2025-12-06 10:25:35','2025-12-06 10:25:44','tempest-VolumesSnapshotListTestJSON-Volume-992167470',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:17:35','2025-12-06 10:17:43','2025-12-06 10:17:43',1,'648a0ccb-ff11-4868-822d-923da177d812',NULL,'9746c911f01c4fee942db215e7ee0535','3d64b92c0ac84e00a6e31382047e6db5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:17:35','2025-12-06 10:17:37',NULL,'tempest-volume-1186324743',NULL,NULL,NULL,NULL,'03c53960-549b-4237-86ca-243e6e72af42',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'b88908cd-5813-4342-8e39-d31d3002e7ec','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:17','2025-12-06 10:18:19','2025-12-06 10:18:20',1,'683e6875-f0c9-4f46-8a67-ab51490f007f',NULL,'140a27a2087f43f4918adaac6fe636d2','8d525f3db4524999ac4cbc2a6d6f399f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:17','2025-12-06 10:18:17','2025-12-06 10:18:19','tempest-VolumesMetadataTest-Volume-114205520',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:15','2025-12-06 10:18:16','2025-12-06 10:18:17',1,'6dd48046-39f7-4931-abe2-7be64faff04a',NULL,'70fb51c48cfc429f910e7d2995e5928a','82e66d987af642e79e2539d816511c7b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:15','2025-12-06 10:18:15','2025-12-06 10:18:16','tempest-VolumesActionsTest-Volume-1113687258',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:19','2025-12-06 10:19:20','2025-12-06 10:19:20',1,'72e0409e-a2ee-4ce6-9433-028cfb32c818',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:19','2025-12-06 10:19:19','2025-12-06 10:19:20','tempest-VolumesGetTest-Volume-2126905657',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:19','2025-12-06 10:18:24','2025-12-06 10:18:24',1,'76295f30-f4f9-476f-a489-01aad8911a0e',NULL,'105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:19','2025-12-06 10:18:20',NULL,'tempest-volume-1664681577',NULL,NULL,NULL,NULL,'b0f02714-dafa-4a55-8991-344da33daa86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'bd444e34-d819-4ff5-9444-4271d29ce628','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:35','2025-12-06 10:18:41','2025-12-06 10:18:42',1,'77761d20-bc4c-4614-b166-5fe7fbaa300d',NULL,'03f5c44949f4449daa2744e8caa11cba','fa979675ad6e484daf8c7eb00c115ce5','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:35','2025-12-06 10:18:36','2025-12-06 10:18:41','tempest-SnapshotMetadataTestJSON-Volume-660819810',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:03','2025-12-06 10:21:06','2025-12-06 10:21:07',1,'7b45579a-3404-4c2f-8df6-d4d85400b2f8',NULL,'0d787d17c2df4c1cbf7bf928906ac9e8','7b08d7598dc24ecfb48eb0563cd3107f','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:03','2025-12-06 10:21:04','2025-12-06 10:21:06','tempest-VolumesListAdminTestJSON-Volume-1557316478',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:22','2025-12-06 10:19:29','2025-12-06 10:19:29',1,'80e2321a-c9b7-4c20-b250-30f47124a368',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:23','2025-12-06 10:19:23','2025-12-06 10:19:29','tempest-VolumesGetTest-Volume-1538647438',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:02','2025-12-06 10:18:17','2025-12-06 10:18:17',1,'8193eeac-349b-466d-818d-bebdf9a01266',NULL,'105e2f456034459fb41c52b4f7ad38b0','49b6390c5ae14ddf850d4e9fda870857','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:02','2025-12-06 10:18:02',NULL,'tempest-volume-511729039',NULL,NULL,NULL,NULL,'80dfab08-2b1b-44e7-b2de-1f8cbff02067',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'f2946e24-c767-49a4-b96c-8c9689ac8ba7','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:38','2025-12-06 10:18:42','2025-12-06 10:18:43',1,'83e632eb-a022-449b-86c6-d0cc45e117d8',NULL,'3d981ab0be9140da81d41ec4317c0724','68eebcd7dc804fc1b9bdc2fcca919216','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:38','2025-12-06 10:18:38','2025-12-06 10:18:42','tempest-VolumeSnapshotQuotasNegativeTestJSON-Volume-1198941539',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:17','2025-12-06 10:18:19','2025-12-06 10:18:20',1,'8bf16bea-92af-4c06-91d7-5ce8ee9d650a',NULL,'70fb51c48cfc429f910e7d2995e5928a','82e66d987af642e79e2539d816511c7b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:18','2025-12-06 10:18:18','2025-12-06 10:18:19','tempest-VolumesActionsTest-Volume-1229307148',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:44','2025-12-06 10:23:52','2025-12-06 10:23:52',1,'8e0aa32f-5545-4053-9536-b4673a7d97fd',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:44','2025-12-06 10:23:44','2025-12-06 10:23:52','tempest-VolumesSnapshotTestJSON-Volume-1913466743',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:28','2025-12-06 10:22:36','2025-12-06 10:22:37',1,'907b8b79-8214-4869-8a33-39010fcf69f3',NULL,'7ae03e43faa04d1bbf58acfc698f4316','190aaeb6184a4deda2f79f6b164f3204','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:29','2025-12-06 10:22:36','2025-12-06 10:22:36','tempest-VolumesImageMetadata-Volume-512516817',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:01','2025-12-06 10:21:08','2025-12-06 10:21:08',1,'90a1f388-7ad6-4657-8278-beebd6ea5687',NULL,'a02ee852d0634ac0adb9f927efde9213','0862199e316e4225866a9d2f97b97851','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:02','2025-12-06 10:21:02',NULL,'tempest-volume-1303968035',NULL,NULL,NULL,NULL,'4775656f-035a-4184-abec-1a7b067cc6c9',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'06c34df4-7c6a-4a20-86ff-af8c5c25fdcd','0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:27','2025-12-06 10:21:29','2025-12-06 10:21:30',1,'97bf9a1f-38ca-42f8-b31d-83d4f182afdb',NULL,'b8e2f0c59fbf4bd693e0c4fc604705f7','f0737a9f95674489a78f5f5ca36df954','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:27','2025-12-06 10:21:28','2025-12-06 10:21:29','tempest-VolumesTransfersTest-Volume-968496783',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:31','2025-12-06 10:19:41','2025-12-06 10:19:42',1,'999412e3-4ef5-476e-8154-00b3f6cde17c',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:31','2025-12-06 10:19:37','2025-12-06 10:19:41','tempest-VolumesGetTest-new-Volume-1735584787','This is the new description of volume',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:55','2025-12-06 10:23:57','2025-12-06 10:23:57',1,'9a2b3832-6eed-48a7-91b7-3ae8be65a559',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:56','2025-12-06 10:23:56','2025-12-06 10:23:57','tempest-VolumesSnapshotTestJSON-Volume-1967425607',NULL,NULL,NULL,'d4bf516e-5a23-43a2-bec3-5b42c5d0e5b8','431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:20:46','2025-12-06 10:20:47','2025-12-06 10:20:48',1,'9ee9d0e2-ad80-4399-956e-3adaa69e16e0',NULL,'1e4e26edef4145a3b64cf319aa2deeb7','511a934bef1b402c802c2c54d54771e7','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:20:46','2025-12-06 10:20:46','2025-12-06 10:20:47','tempest-VolumesServicesTestJSON-Volume-388486445',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:34','2025-12-06 10:23:36','2025-12-06 10:23:36',1,'a0f7bb3f-86ec-4ef5-8886-f4a9d3152b06',NULL,'ad2d68ad3d074512b0be563db89acff0','70f435eabdfe445ab287f469849a5cad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:35','2025-12-06 10:23:35','2025-12-06 10:23:36','tempest-VolumesTransfersV357Test-Volume-1097431510',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:20:11','2025-12-06 10:20:30','2025-12-06 10:20:30',1,'a63a7999-dcc1-46a4-9418-5b99159f1305',NULL,'defae908f28745a4b8aa437967c921d2','6d0a8aa137f541eaa9efa5eddfd19a6b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:20:11','2025-12-06 10:20:11','2025-12-06 10:20:30','tempest-SnapshotsActionsTest-Volume-1903071354',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:19:06','2025-12-06 10:19:13','2025-12-06 10:19:14',1,'a8eb4c0c-df56-4c17-893c-7a447ebf9a00',NULL,'969f4ae719ca4cb0abd04f2c326c0e33','2cca2deb59744cdd922204ff50f015d2','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:19:07','2025-12-06 10:19:07','2025-12-06 10:19:13','tempest-VolumesExtendTest-Volume-281737364',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:27','2025-12-06 10:22:43','2025-12-06 10:22:45',1,'a9b72058-b3a6-4112-b2ef-a614b1de0110',NULL,'b898d0b45de84b89a6a6ac9032ba8e8e','083713cc3880454487a156230b40fd02','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:27','2025-12-06 10:22:27','2025-12-06 10:22:43','tempest-VolumesBackupsAdminTest-Volume-768494422',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:24:10','2025-12-06 10:25:25','2025-12-06 10:25:28',1,'aaa4ed2d-8dfc-40b7-87e3-cd5257ed1965',NULL,'b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:24:10','2025-12-06 10:24:10','2025-12-06 10:25:25','tempest-VolumesBackupsTest-Volume-2052036418',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:09','2025-12-06 10:23:14','2025-12-06 10:23:21',1,'b3e5c0b9-b04c-478b-9509-7a5b19ef9bad',NULL,'5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:09','2025-12-06 10:23:09','2025-12-06 10:23:14','tempest-VolumesDeleteCascade-Volume-855138240',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:20','2025-12-06 10:23:21','2025-12-06 10:23:37',1,'c06e23b0-7c5a-499b-9bb0-36619d31f978',NULL,'ba30359af5c949eb85d2462e256afb2a','8321907d0a38406c8e7c51f32ab796ad','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,'backup-vol-2a956d59-22c7-4046-a8e9-3b5d490292c5',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,0),('2025-12-06 10:21:23','2025-12-06 10:21:25','2025-12-06 10:21:25',1,'c5548a27-d737-4350-850c-8f75e81edf30',NULL,'0c86ca9db03a4b3f87509a8239093323','9847f1afa3464dc7b8aac27cb0247e9e','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:23','2025-12-06 10:21:23','2025-12-06 10:21:25','tempest-VolumesTransfersV355Test-Volume-1440734294',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:45','2025-12-06 10:22:53','2025-12-06 10:22:55',1,'c8bf4e16-7338-4494-ab1d-72a69d8b9b6d',NULL,'b898d0b45de84b89a6a6ac9032ba8e8e','083713cc3880454487a156230b40fd02','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:53','tempest-VolumesBackupsAdminTest-Volume-133978837',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:31','2025-12-06 10:21:41','2025-12-06 10:21:42',1,'ca3e4a86-d265-4057-b134-ad9b5e3eae4e',NULL,'efa0a8b565434ce69ac6e465c0524033','eab6fb5a053a4a4f8668138357e0b3b6','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:32','2025-12-06 10:21:32','2025-12-06 10:21:41','tempest-VolumesBackupsV39Test-Volume-1969983310',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'backing-up',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:56','2025-12-06 10:19:05','2025-12-06 10:19:06',1,'ca9e19b3-d243-42e7-ae59-36fafd88ec3c',NULL,'969f4ae719ca4cb0abd04f2c326c0e33','2cca2deb59744cdd922204ff50f015d2','hostgroup@tripleo_ceph#tripleo_ceph',2,'nova','deleted','detached','2025-12-06 10:18:56','2025-12-06 10:19:04','2025-12-06 10:19:05','tempest-VolumesExtendTest-Volume-1373808332',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'available',NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:16','2025-12-06 10:21:17','2025-12-06 10:21:18',1,'cceb9fed-2945-49b4-922b-6d3264fa495e',NULL,'9123e014de9b4461954565907989992a','617e21f2837c4be9825357089f4f14b0','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:16','2025-12-06 10:21:16','2025-12-06 10:21:17','tempest-VolumeTypesAccessTest-Volume-1777497264',NULL,NULL,NULL,NULL,'97789e4a-9087-42f3-895a-7f52ff4a5302',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:09','2025-12-06 10:18:11','2025-12-06 10:18:12',1,'ce92099a-c582-4baf-999f-fe1df9df33a6',NULL,'70fb51c48cfc429f910e7d2995e5928a','82e66d987af642e79e2539d816511c7b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:10','2025-12-06 10:18:10','2025-12-06 10:18:11','tempest-VolumesActionsTest-Volume-915961182',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:12','2025-12-06 10:18:14','2025-12-06 10:18:14',1,'cecaf917-5496-49ad-a950-de707f9ffc87',NULL,'70fb51c48cfc429f910e7d2995e5928a','82e66d987af642e79e2539d816511c7b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:12','2025-12-06 10:18:13','2025-12-06 10:18:14','tempest-VolumesActionsTest-Volume-899038200',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:47','2025-12-06 10:18:48','2025-12-06 10:18:49',1,'d26f67f1-f3d7-4ae9-87d1-518b5ce8ac44',NULL,'57ec6069516a4b81aa4707921be56ea6','8107242293454375a6260c46e0ab59e4','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:47','2025-12-06 10:18:47','2025-12-06 10:18:48','tempest-AbsoluteLimitsTests-Volume-918213669',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:05','2025-12-06 10:21:06','2025-12-06 10:21:07',1,'d624eff6-5f11-4e6f-869d-f31bc76d4bae',NULL,'e1cc575d68644435a96e018ab9cabf96','abf3db88f6aa45ec885a741fbdfeee25','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:21:05','2025-12-06 10:21:05','2025-12-06 10:21:06',NULL,NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:20','2025-12-06 10:18:22','2025-12-06 10:18:23',1,'d99adacd-8999-4df1-9c85-1c9159cee4fd',NULL,'70fb51c48cfc429f910e7d2995e5928a','82e66d987af642e79e2539d816511c7b','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:20','2025-12-06 10:18:20','2025-12-06 10:18:22','tempest-VolumesActionsTest-Volume-683051164',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:13','2025-12-06 10:22:13','2025-12-06 10:22:14',1,'ded1304c-77ea-4a6a-8e83-00704b16b4af',NULL,'c9d7db0d35bf49bca22e0a046ec5faf2','0869d8bc1b684db8b15afc4eebf3f39d',NULL,1,'nova','deleted','detached',NULL,NULL,NULL,'tempest-UserMessagesTest-Volume-22791445',NULL,NULL,NULL,NULL,'d59bdf68-d363-45a6-a805-f0d963c6d91c',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,1,1),('2025-12-06 10:19:17','2025-12-06 10:19:21','2025-12-06 10:19:22',1,'ded420af-d470-4f44-85ad-b5ef5d97c56c',NULL,'3965f53f15254c17b99da2e11d372200','911a328debfc4f209bacf73debc10fe3','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:19:17','2025-12-06 10:19:18','2025-12-06 10:19:21','tempest-VolumesGetTest-new-Volume-1861454231','This is the new description of volume',NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:12','2025-12-06 10:23:22','2025-12-06 10:23:24',1,'e744f48d-6364-4269-87f8-0494533a99b6',NULL,'5fad49d56c6d4e7fb8d4a17b6c2562c1','0ade48b7157047d2bc354a1299624e2c','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:13','2025-12-06 10:23:13','2025-12-06 10:23:22','tempest-VolumesDeleteCascade-Volume-588241716',NULL,NULL,NULL,'67178e1f-f65c-45f9-9342-eb33d72bb944','431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:34','2025-12-06 10:22:40','2025-12-06 10:22:41',1,'eb844db9-3326-400d-ac0b-d6537fc655b9',NULL,'b898d0b45de84b89a6a6ac9032ba8e8e','083713cc3880454487a156230b40fd02','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:35','2025-12-06 10:22:35','2025-12-06 10:22:40','tempest-VolumesBackupsAdminTest-Volume-768494422',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:18:55','2025-12-06 10:19:10','2025-12-06 10:19:10',1,'f02f1e30-4817-476d-91fa-3e66cad146f1',NULL,'ec29f02579a54d488cbc8a2db31e2544','d9b02e74009b4dd7b38d073a2a13fed2','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:18:55','2025-12-06 10:19:04','2025-12-06 10:19:10','tempest-VolumesCloneTest-Volume-59278507',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:49','2025-12-06 10:22:56','2025-12-06 10:22:57',1,'f1f8b73f-e1f0-4c0d-a52a-cf06a9417441',NULL,'165e7f6825c844478ef86621d4584c4d','24d6923c0e47455ca133a232d042e0fc','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:49','2025-12-06 10:22:49','2025-12-06 10:22:56','tempest-VolumesListTestJSON-Volume-792068669',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:46','2025-12-06 10:22:53','2025-12-06 10:22:54',1,'f2f5c444-d6b1-4d47-ade3-bce19de161fc',NULL,'400c7a5a05544a0596fadfc4160b3cdf','096aefe63e33405396d6efe65bbb1733','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:46','2025-12-06 10:22:46','2025-12-06 10:22:53','tempest-VolumesNegativeTest-Volume-1927927802',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:22:38','2025-12-06 10:22:41','2025-12-06 10:22:41',1,'fbde1f3c-3c14-4413-85b1-e7e89d833d09',NULL,'9c39945a8b44415a9175ea2785d26cd7','257a7584f7b14f3fb15fdf774f388f44','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:22:39','2025-12-06 10:22:39','2025-12-06 10:22:41','tempest-VolumeQuotasAdminTestJSON-Volume-1777838529',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:23:59','2025-12-06 10:24:04','2025-12-06 10:24:05',1,'fd91d0ee-bfdb-4ee4-8ca6-e58d60931aee',NULL,'b40d497af0834616a664e6909c0f6685','b51f704fe6204487b0317c3332364cca','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached','2025-12-06 10:23:59','2025-12-06 10:23:59','2025-12-06 10:24:03','tempest-VolumesBackupsTest-Volume-89239679',NULL,NULL,NULL,NULL,'431a3082-d870-475c-9229-feea907d17d2',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'0ff46ad4-2d5c-448f-abd2-ea89781df999',0,1),('2025-12-06 10:21:52','2025-12-06 10:21:54','2025-12-06 10:21:54',1,'fdd133c8-646a-4ccd-aa76-5aaa83574fa3',NULL,'69342e816b8a4c66a18fe32123f49c95','8566f9acc2b141e2a06f7a1cbef81657','hostgroup@tripleo_ceph#tripleo_ceph',1,'nova','deleted','detached',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'f53abe89-cb1b-4f24-bcc7-eb7c1802a9ea','29a01f12-c3f9-4802-b5fc-d34232f73460',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,'92ce1d4a-1cd3-48d1-a7ff-11c28aeb1baf',NULL,1,1);
/*!40000 ALTER TABLE `volumes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `workers`
--

DROP TABLE IF EXISTS `workers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `workers` (
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(40) NOT NULL,
  `resource_id` varchar(36) NOT NULL,
  `status` varchar(255) NOT NULL,
  `service_id` int(11) DEFAULT NULL,
  `race_preventer` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `resource_type` (`resource_type`,`resource_id`),
  KEY `ix_workers_service_id` (`service_id`),
  CONSTRAINT `workers_ibfk_1` FOREIGN KEY (`service_id`) REFERENCES `services` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `workers`
--

LOCK TABLES `workers` WRITE;
/*!40000 ALTER TABLE `workers` DISABLE KEYS */;
INSERT INTO `workers` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `resource_type`, `resource_id`, `status`, `service_id`, `race_preventer`) VALUES ('2025-12-06 08:26:03','2025-12-06 08:26:03.000123',NULL,0,2,'SENTINEL','SUB-SECOND','OK',NULL,0);
/*!40000 ALTER TABLE `workers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `glance`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `glance` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `glance`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('2023_1_contract01');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_locations`
--

DROP TABLE IF EXISTS `image_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `meta_data` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `ix_image_locations_deleted` (`deleted`),
  KEY `ix_image_locations_image_id` (`image_id`),
  CONSTRAINT `image_locations_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_locations`
--

LOCK TABLES `image_locations` WRITE;
/*!40000 ALTER TABLE `image_locations` DISABLE KEYS */;
INSERT INTO `image_locations` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `meta_data`, `status`) VALUES (2,'e0d06706-da90-478a-9829-34b75a3ce049','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/e0d06706-da90-478a-9829-34b75a3ce049/snap','2025-12-06 08:43:30','2025-12-06 08:43:30',NULL,0,'{\"store\": \"default_backend\"}','active'),(5,'6a944ab6-8965-4055-b7fc-af6e395005ea','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/6a944ab6-8965-4055-b7fc-af6e395005ea/snap','2025-12-06 10:13:13','2025-12-06 10:13:13',NULL,0,'{\"store\": \"default_backend\"}','active'),(6,'d147d58a-0420-4f78-80ae-ef1c5b00dd14','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/d147d58a-0420-4f78-80ae-ef1c5b00dd14/snap','2025-12-06 10:13:15','2025-12-06 10:13:15',NULL,0,'{\"store\": \"default_backend\"}','active'),(7,'1e65e0ca-1f5c-42c8-85d0-2716c18baec5','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/1e65e0ca-1f5c-42c8-85d0-2716c18baec5/snap','2025-12-06 10:13:40','2025-12-06 10:13:43','2025-12-06 10:13:43',1,'{\"store\": \"default_backend\"}','deleted'),(8,'1ee84077-ed8a-4ebf-b8c4-afd627148758','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/1ee84077-ed8a-4ebf-b8c4-afd627148758/snap','2025-12-06 10:13:51','2025-12-06 10:13:58','2025-12-06 10:13:58',1,'{\"store\": \"default_backend\"}','deleted'),(9,'7141663c-a695-4147-a03d-20e8d4f67069','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/7141663c-a695-4147-a03d-20e8d4f67069/snap','2025-12-06 10:14:42','2025-12-06 10:14:53','2025-12-06 10:14:53',1,'{\"store\": \"default_backend\"}','deleted'),(10,'af540be2-bf52-4bff-b4bd-6dea5cca6542','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/af540be2-bf52-4bff-b4bd-6dea5cca6542/snap','2025-12-06 10:15:12','2025-12-06 10:15:21','2025-12-06 10:15:21',1,'{\"store\": \"default_backend\"}','deleted'),(11,'516b003d-17ce-422b-b48f-7c6b2ba8dbe9','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/516b003d-17ce-422b-b48f-7c6b2ba8dbe9/snap','2025-12-06 10:16:52','2025-12-06 10:17:10','2025-12-06 10:17:10',1,'{\"store\": \"default_backend\"}','deleted'),(12,'e1e9b0b2-d5d4-441c-b52f-48ad329a8ac4','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/e1e9b0b2-d5d4-441c-b52f-48ad329a8ac4/snap','2025-12-06 10:16:53','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'{\"store\": \"default_backend\"}','deleted'),(13,'e0de1c98-b38b-4d60-acb1-4bf581edf865','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/e0de1c98-b38b-4d60-acb1-4bf581edf865/snap','2025-12-06 10:16:53','2025-12-06 10:16:55','2025-12-06 10:16:55',1,'{\"store\": \"default_backend\"}','deleted'),(14,'2eb9a005-5c67-431e-89ea-5dbfb81e7cfd','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/2eb9a005-5c67-431e-89ea-5dbfb81e7cfd/snap','2025-12-06 10:16:54','2025-12-06 10:17:08','2025-12-06 10:17:08',1,'{\"store\": \"default_backend\"}','deleted'),(15,'baba169c-4448-4dd5-9992-3f5f4584bfb9','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/baba169c-4448-4dd5-9992-3f5f4584bfb9/snap','2025-12-06 10:16:56','2025-12-06 10:17:06','2025-12-06 10:17:06',1,'{\"store\": \"default_backend\"}','deleted'),(16,'01bd93f5-4ae3-4b02-bbf2-ac98c28cab1d','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/01bd93f5-4ae3-4b02-bbf2-ac98c28cab1d/snap','2025-12-06 10:16:58','2025-12-06 10:17:04','2025-12-06 10:17:04',1,'{\"store\": \"default_backend\"}','deleted'),(17,'58ffa643-8b2b-40e1-b00e-d43590a3bc37','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/58ffa643-8b2b-40e1-b00e-d43590a3bc37/snap','2025-12-06 10:16:59','2025-12-06 10:17:02','2025-12-06 10:17:02',1,'{\"store\": \"default_backend\"}','deleted'),(18,'b318c449-eef1-413a-8f56-518aa993470b','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/b318c449-eef1-413a-8f56-518aa993470b/snap','2025-12-06 10:17:04','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'{\"store\": \"default_backend\"}','deleted'),(19,'b38b84c3-c97d-4082-8561-8dd7b1cc3b10','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/b38b84c3-c97d-4082-8561-8dd7b1cc3b10/snap','2025-12-06 10:17:06','2025-12-06 10:17:08','2025-12-06 10:17:08',1,'{\"store\": \"default_backend\"}','deleted'),(20,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/57a18f5d-0bb5-4bd4-8952-e0415dd44feb/snap','2025-12-06 10:18:16','2025-12-06 10:18:25','2025-12-06 10:18:25',1,'{\"store\": \"default_backend\"}','deleted'),(21,'66df6814-6caf-4001-aace-c11674b4cdf9','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/66df6814-6caf-4001-aace-c11674b4cdf9/snap','2025-12-06 10:18:23','2025-12-06 10:18:24','2025-12-06 10:18:24',1,'{\"store\": \"default_backend\"}','deleted'),(22,'dacb95d2-9ab4-4326-972a-377a14807da1','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/dacb95d2-9ab4-4326-972a-377a14807da1/snap','2025-12-06 10:22:38','2025-12-06 10:22:41','2025-12-06 10:22:41',1,'{\"store\": \"default_backend\"}','deleted'),(23,'c58b1bc6-e4c0-4ae8-9f5d-024a618e17b8','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/c58b1bc6-e4c0-4ae8-9f5d-024a618e17b8/snap','2025-12-06 10:22:48','2025-12-06 10:22:50','2025-12-06 10:22:50',1,'{\"store\": \"default_backend\"}','deleted'),(24,'37ef4daf-228e-4dd0-8c62-94148e573bdd','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/37ef4daf-228e-4dd0-8c62-94148e573bdd/snap','2025-12-06 10:22:50','2025-12-06 10:22:52','2025-12-06 10:22:52',1,'{\"store\": \"default_backend\"}','deleted'),(25,'f9534607-4d0e-4139-bd6d-4215880b29f8','rbd://1939e851-b10c-5c3b-9bb7-8e7f380233e8/images/f9534607-4d0e-4139-bd6d-4215880b29f8/snap','2025-12-06 10:30:45','2025-12-06 10:30:46','2025-12-06 10:30:46',1,'{\"store\": \"default_backend\"}','deleted');
/*!40000 ALTER TABLE `image_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_members`
--

DROP TABLE IF EXISTS `image_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `member` varchar(255) NOT NULL,
  `can_share` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`id`),
  UNIQUE KEY `image_members_image_id_member_deleted_at_key` (`image_id`,`member`,`deleted_at`),
  KEY `ix_image_members_deleted` (`deleted`),
  KEY `ix_image_members_image_id` (`image_id`),
  KEY `ix_image_members_image_id_member` (`image_id`,`member`),
  CONSTRAINT `image_members_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`can_share` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_members`
--

LOCK TABLES `image_members` WRITE;
/*!40000 ALTER TABLE `image_members` DISABLE KEYS */;
INSERT INTO `image_members` (`id`, `image_id`, `member`, `can_share`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `status`) VALUES (1,'cb72e6ab-1bed-44c7-9308-6e8f3ed565f8','22ce20552d574cab9c49ede157caade3',0,'2025-12-06 10:16:09','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'accepted'),(2,'94c61b47-d7dd-45ff-9dd8-8f29ec43e867','22ce20552d574cab9c49ede157caade3',0,'2025-12-06 10:16:10','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'accepted'),(3,'49f193af-9510-4d37-b87d-6f0d8db586ee','22ce20552d574cab9c49ede157caade3',0,'2025-12-06 10:16:10','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'rejected'),(4,'8de8da0b-eced-4fcf-9deb-0adb72583db4','22ce20552d574cab9c49ede157caade3',0,'2025-12-06 10:16:10','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'accepted'),(5,'e0de1c98-b38b-4d60-acb1-4bf581edf865','83707c8b00c540b895ad9bb3aab7f66d',0,'2025-12-06 10:16:53','2025-12-06 10:16:55','2025-12-06 10:16:55',1,'pending'),(6,'c1aef809-64d4-4c69-aa18-63281120c8a7','a69b7ea2512046cca1c38484e27e4cae',0,'2025-12-06 10:17:08','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'pending'),(7,'e3a2b59a-4e0e-48e5-82db-7541d90d6e36','a69b7ea2512046cca1c38484e27e4cae',0,'2025-12-06 10:17:09','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'pending');
/*!40000 ALTER TABLE `image_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_properties`
--

DROP TABLE IF EXISTS `image_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ix_image_properties_image_id_name` (`image_id`,`name`),
  KEY `ix_image_properties_deleted` (`deleted`),
  KEY `ix_image_properties_image_id` (`image_id`),
  CONSTRAINT `image_properties_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_properties`
--

LOCK TABLES `image_properties` WRITE;
/*!40000 ALTER TABLE `image_properties` DISABLE KEYS */;
INSERT INTO `image_properties` (`id`, `image_id`, `name`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (2,'e0d06706-da90-478a-9829-34b75a3ce049','owner_specified.openstack.md5','','2025-12-06 08:43:26','2025-12-06 08:43:26',NULL,0),(5,'e0d06706-da90-478a-9829-34b75a3ce049','owner_specified.openstack.sha256','','2025-12-06 08:43:26','2025-12-06 08:43:26',NULL,0),(8,'e0d06706-da90-478a-9829-34b75a3ce049','owner_specified.openstack.object','images/cirros','2025-12-06 08:43:26','2025-12-06 08:43:26',NULL,0),(11,'6a944ab6-8965-4055-b7fc-af6e395005ea','hw_rng_model','virtio','2025-12-06 10:13:11','2025-12-06 10:13:11',NULL,0),(12,'d147d58a-0420-4f78-80ae-ef1c5b00dd14','hw_rng_model','virtio','2025-12-06 10:13:13','2025-12-06 10:13:13',NULL,0),(13,'1ee84077-ed8a-4ebf-b8c4-afd627148758','os_distro','value2','2025-12-06 10:13:52','2025-12-06 10:13:58','2025-12-06 10:13:58',1),(14,'1ee84077-ed8a-4ebf-b8c4-afd627148758','os_version','alt1','2025-12-06 10:13:52','2025-12-06 10:13:58','2025-12-06 10:13:58',1),(15,'1ee84077-ed8a-4ebf-b8c4-afd627148758','architecture','value3','2025-12-06 10:13:54','2025-12-06 10:13:58','2025-12-06 10:13:58',1),(16,'7141663c-a695-4147-a03d-20e8d4f67069','hw_rng_model','virtio','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(17,'7141663c-a695-4147-a03d-20e8d4f67069','base_image_ref','6a944ab6-8965-4055-b7fc-af6e395005ea','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(18,'7141663c-a695-4147-a03d-20e8d4f67069','owner_user_name','tempest-UnshelveToHostMultiNodesTest-912460009-project-member','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(19,'7141663c-a695-4147-a03d-20e8d4f67069','owner_project_name','tempest-UnshelveToHostMultiNodesTest-912460009','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(20,'7141663c-a695-4147-a03d-20e8d4f67069','boot_roles','reader,member','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(21,'7141663c-a695-4147-a03d-20e8d4f67069','hw_machine_type','q35','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(22,'7141663c-a695-4147-a03d-20e8d4f67069','hw_cdrom_bus','sata','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(23,'7141663c-a695-4147-a03d-20e8d4f67069','hw_disk_bus','virtio','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(24,'7141663c-a695-4147-a03d-20e8d4f67069','hw_input_bus','usb','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(25,'7141663c-a695-4147-a03d-20e8d4f67069','hw_pointer_model','usbtablet','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(26,'7141663c-a695-4147-a03d-20e8d4f67069','hw_video_model','virtio','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(27,'7141663c-a695-4147-a03d-20e8d4f67069','hw_vif_model','virtio','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(28,'7141663c-a695-4147-a03d-20e8d4f67069','instance_uuid','3d34a856-7613-4158-b859-fb3089fe3bc7','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(29,'7141663c-a695-4147-a03d-20e8d4f67069','user_id','496ca8bf29dc4e81ba0b08a592dc45d3','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(30,'7141663c-a695-4147-a03d-20e8d4f67069','image_type','snapshot','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(31,'7141663c-a695-4147-a03d-20e8d4f67069','image_state','available','2025-12-06 10:14:42','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(32,'7141663c-a695-4147-a03d-20e8d4f67069','image_location','snapshot','2025-12-06 10:14:42','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(33,'7141663c-a695-4147-a03d-20e8d4f67069','owner_id','c6d84801a8b44d9da497e9761a0cd10c','2025-12-06 10:14:42','2025-12-06 10:14:53','2025-12-06 10:14:53',1),(34,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_rng_model','virtio','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(35,'af540be2-bf52-4bff-b4bd-6dea5cca6542','base_image_ref','6a944ab6-8965-4055-b7fc-af6e395005ea','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(36,'af540be2-bf52-4bff-b4bd-6dea5cca6542','owner_user_name','tempest-UnshelveToHostMultiNodesTest-912460009-project-member','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(37,'af540be2-bf52-4bff-b4bd-6dea5cca6542','owner_project_name','tempest-UnshelveToHostMultiNodesTest-912460009','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(38,'af540be2-bf52-4bff-b4bd-6dea5cca6542','boot_roles','reader,member','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(39,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_machine_type','q35','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(40,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_cdrom_bus','sata','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(41,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_disk_bus','virtio','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(42,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_input_bus','usb','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(43,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_pointer_model','usbtablet','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(44,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_video_model','virtio','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(45,'af540be2-bf52-4bff-b4bd-6dea5cca6542','hw_vif_model','virtio','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(46,'af540be2-bf52-4bff-b4bd-6dea5cca6542','clean_attempts','1','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(47,'af540be2-bf52-4bff-b4bd-6dea5cca6542','instance_uuid','3d34a856-7613-4158-b859-fb3089fe3bc7','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(48,'af540be2-bf52-4bff-b4bd-6dea5cca6542','user_id','496ca8bf29dc4e81ba0b08a592dc45d3','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(49,'af540be2-bf52-4bff-b4bd-6dea5cca6542','image_type','snapshot','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(50,'af540be2-bf52-4bff-b4bd-6dea5cca6542','image_state','available','2025-12-06 10:15:12','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(51,'af540be2-bf52-4bff-b4bd-6dea5cca6542','image_location','snapshot','2025-12-06 10:15:12','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(52,'af540be2-bf52-4bff-b4bd-6dea5cca6542','owner_id','c6d84801a8b44d9da497e9761a0cd10c','2025-12-06 10:15:12','2025-12-06 10:15:21','2025-12-06 10:15:21',1),(53,'b38b84c3-c97d-4082-8561-8dd7b1cc3b10','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-06 10:17:05','2025-12-06 10:17:08','2025-12-06 10:17:08',1),(55,'5e89b137-706f-4234-b097-c97e83c87b31','os_glance_importing_to_stores','','2025-12-06 10:17:16','2025-12-06 10:17:16',NULL,0),(56,'5e89b137-706f-4234-b097-c97e83c87b31','os_glance_failed_import','default_backend','2025-12-06 10:17:16','2025-12-06 10:17:16',NULL,0),(57,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-06 10:18:14','2025-12-06 10:18:25','2025-12-06 10:18:25',1),(58,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','os_glance_stage_host','http://glance-default-external-api-0.glance-default-external-api.openstack.svc:9292','2025-12-06 10:18:15','2025-12-06 10:18:25','2025-12-06 10:18:25',1),(60,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','os_glance_importing_to_stores','','2025-12-06 10:18:15','2025-12-06 10:18:25','2025-12-06 10:18:25',1),(61,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','os_glance_failed_import','','2025-12-06 10:18:15','2025-12-06 10:18:25','2025-12-06 10:18:25',1),(62,'66df6814-6caf-4001-aace-c11674b4cdf9','ramdisk_id','00000000-1111-2222-3333-444455556666','2025-12-06 10:18:17','2025-12-06 10:18:24','2025-12-06 10:18:24',1),(64,'66df6814-6caf-4001-aace-c11674b4cdf9','os_glance_importing_to_stores','','2025-12-06 10:18:17','2025-12-06 10:18:24','2025-12-06 10:18:24',1),(65,'66df6814-6caf-4001-aace-c11674b4cdf9','os_glance_failed_import','','2025-12-06 10:18:17','2025-12-06 10:18:24','2025-12-06 10:18:24',1);
/*!40000 ALTER TABLE `image_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_tags`
--

DROP TABLE IF EXISTS `image_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `image_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image_id` varchar(36) NOT NULL,
  `value` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_image_tags_image_id` (`image_id`),
  KEY `ix_image_tags_image_id_tag_value` (`image_id`,`value`),
  CONSTRAINT `image_tags_ibfk_1` FOREIGN KEY (`image_id`) REFERENCES `images` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_tags`
--

LOCK TABLES `image_tags` WRITE;
/*!40000 ALTER TABLE `image_tags` DISABLE KEYS */;
INSERT INTO `image_tags` (`id`, `image_id`, `value`, `created_at`, `updated_at`, `deleted_at`, `deleted`) VALUES (1,'516b003d-17ce-422b-b48f-7c6b2ba8dbe9','tempest-tag-972730517','2025-12-06 10:16:51','2025-12-06 10:17:10','2025-12-06 10:17:10',1),(2,'516b003d-17ce-422b-b48f-7c6b2ba8dbe9','tempest-tag-1329320178','2025-12-06 10:16:51','2025-12-06 10:17:10','2025-12-06 10:17:10',1),(3,'e1e9b0b2-d5d4-441c-b52f-48ad329a8ac4','tempest-tag-1209170410','2025-12-06 10:16:52','2025-12-06 10:17:09','2025-12-06 10:17:09',1),(4,'e1e9b0b2-d5d4-441c-b52f-48ad329a8ac4','tempest-tag-382070617','2025-12-06 10:16:52','2025-12-06 10:17:09','2025-12-06 10:17:09',1),(5,'2eb9a005-5c67-431e-89ea-5dbfb81e7cfd','tempest-tag-1145938797','2025-12-06 10:16:53','2025-12-06 10:17:08','2025-12-06 10:17:08',1),(6,'2eb9a005-5c67-431e-89ea-5dbfb81e7cfd','tempest-tag-1530905681','2025-12-06 10:16:53','2025-12-06 10:17:08','2025-12-06 10:17:08',1),(7,'baba169c-4448-4dd5-9992-3f5f4584bfb9','tempest-tag-269027100','2025-12-06 10:16:54','2025-12-06 10:17:06','2025-12-06 10:17:06',1),(8,'baba169c-4448-4dd5-9992-3f5f4584bfb9','tempest-tag-495511615','2025-12-06 10:16:54','2025-12-06 10:17:06','2025-12-06 10:17:06',1),(9,'01bd93f5-4ae3-4b02-bbf2-ac98c28cab1d','tempest-tag-1993894119','2025-12-06 10:16:56','2025-12-06 10:17:04','2025-12-06 10:17:04',1),(10,'01bd93f5-4ae3-4b02-bbf2-ac98c28cab1d','tempest-tag-846293462','2025-12-06 10:16:56','2025-12-06 10:17:04','2025-12-06 10:17:04',1),(11,'58ffa643-8b2b-40e1-b00e-d43590a3bc37','tempest-tag-1460707408','2025-12-06 10:16:58','2025-12-06 10:17:02','2025-12-06 10:17:02',1),(12,'58ffa643-8b2b-40e1-b00e-d43590a3bc37','tempest-tag-527920535','2025-12-06 10:16:58','2025-12-06 10:17:02','2025-12-06 10:17:02',1),(13,'fecce101-9451-4ef9-bb2a-9ff62e53d81c','tempest-tag-1375764329','2025-12-06 10:18:56','2025-12-06 10:18:56','2025-12-06 10:18:56',1);
/*!40000 ALTER TABLE `image_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `images` (
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `status` varchar(30) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `disk_format` varchar(20) DEFAULT NULL,
  `container_format` varchar(20) DEFAULT NULL,
  `checksum` varchar(32) DEFAULT NULL,
  `owner` varchar(255) DEFAULT NULL,
  `min_disk` int(11) NOT NULL,
  `min_ram` int(11) NOT NULL,
  `protected` tinyint(1) NOT NULL DEFAULT 0,
  `virtual_size` bigint(20) DEFAULT NULL,
  `visibility` enum('private','public','shared','community') NOT NULL DEFAULT 'shared',
  `os_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `os_hash_algo` varchar(64) DEFAULT NULL,
  `os_hash_value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checksum_image_idx` (`checksum`),
  KEY `ix_images_deleted` (`deleted`),
  KEY `owner_image_idx` (`owner`),
  KEY `created_at_image_idx` (`created_at`),
  KEY `updated_at_image_idx` (`updated_at`),
  KEY `visibility_image_idx` (`visibility`),
  KEY `os_hidden_image_idx` (`os_hidden`),
  KEY `os_hash_value_image_idx` (`os_hash_value`),
  CONSTRAINT `CONSTRAINT_2` CHECK (`deleted` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`protected` in (0,1)),
  CONSTRAINT `CONSTRAINT_4` CHECK (`os_hidden` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `images`
--

LOCK TABLES `images` WRITE;
/*!40000 ALTER TABLE `images` DISABLE KEYS */;
INSERT INTO `images` (`id`, `name`, `size`, `status`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `disk_format`, `container_format`, `checksum`, `owner`, `min_disk`, `min_ram`, `protected`, `virtual_size`, `visibility`, `os_hidden`, `os_hash_algo`, `os_hash_value`) VALUES ('01bd93f5-4ae3-4b02-bbf2-ac98c28cab1d','tempest-ListUserImagesTest-image-1700007835',2549,'deleted','2025-12-06 10:16:56','2025-12-06 10:17:04','2025-12-06 10:17:04',1,'aki','bare','ab1e3cae1960590b8baed15631e0a336','39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'private',0,'sha512','7a5651727e7be3b374b6ab6891f97180fb82ea597a2a7809150e0a877ad6438a78096a7afbfcc05f8a0d02fd29e8de98d6b3cd54c0a1de84e5cfc5b6c045be46'),('12ade715-13b2-4d38-aad4-7a7b4fa36937','tempest-test-261109987',NULL,'deleted','2025-12-06 10:18:30','2025-12-06 10:18:30','2025-12-06 10:18:30',1,'raw','bare',NULL,'06eecf2db90342a0849d9f963dfc2e11',0,0,0,NULL,'shared',0,NULL,NULL),('165e8821-1a39-4ff2-a786-a8ad608ae64b','tempest-ListUserImagesTest-image-1498797617',NULL,'deleted','2025-12-06 10:17:00','2025-12-06 10:17:00','2025-12-06 10:17:00',1,NULL,NULL,NULL,'39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'shared',1,NULL,NULL),('18b33ae1-c0dc-4e8e-a5e2-116b246637e2','tempest-image-43799332',NULL,'deleted','2025-12-06 10:17:05','2025-12-06 10:17:05','2025-12-06 10:17:05',1,'qcow2','bare',NULL,'ec54df1cc2e6480cbd18172c892b6984',0,0,0,NULL,'private',0,NULL,NULL),('1e65e0ca-1f5c-42c8-85d0-2716c18baec5','tempest-image-126396240',1963,'deleted','2025-12-06 10:13:39','2025-12-06 10:13:43','2025-12-06 10:13:43',1,'qcow2','bare','6094e761be2a696ae0217c28f642cbd0','8b00fd894fbe43a7a42e465def02b9d0',0,129,0,NULL,'private',0,'sha512','91cd53c794bf7e1b6581b5b87736a542ad270ced3f1f90f9391a702cb6f42eeaa52f307a1faaf46cdbbccf5394291c0f8682271a2ae5d419cb490ab7ec6f14b1'),('1ee84077-ed8a-4ebf-b8c4-afd627148758','tempest-image-289930105',1024,'deleted','2025-12-06 10:13:50','2025-12-06 10:13:58','2025-12-06 10:13:58',1,'raw','bare','fb10c6486390bec8414be90a93dfff3b','41c5aacc61744234925562dc59124c52',0,0,0,1024,'private',0,'sha512','ce7b6234592663b20e49bc3a143c45ae08fc9a2a3294e2a7ed1fb852aab791ed9a0f7357b9ea5e4003be96b8bac5dfba8a7a9d4735e791ac0fcdf5df3682f720'),('2eb9a005-5c67-431e-89ea-5dbfb81e7cfd','tempest-ListUserImagesTest-image-1958122064',2781,'deleted','2025-12-06 10:16:53','2025-12-06 10:17:08','2025-12-06 10:17:08',1,'ami','bare','e2346e40f1b0a8bd4f06da73901b3b21','39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'private',0,'sha512','f46f02c58e6f939c371d8bee3db0fb33c48616fcb0eb942bccf887a27a5804e77dce49f7d3452e88f8cf9b6e1b549b8c026e509c4ba58990e51955bf69c4ce52'),('3584989d-72cf-47d7-9241-c538b51eb014',NULL,NULL,'deleted','2025-12-06 10:15:00','2025-12-06 10:15:00','2025-12-06 10:15:00',1,'raw','bare',NULL,'096b6a0fc26a4dbd8b544a3a9c87e0de',0,0,0,NULL,'shared',0,NULL,NULL),('37ef4daf-228e-4dd0-8c62-94148e573bdd','tempest-VolumesNegativeTest-image-102561348',1024,'deleted','2025-12-06 10:22:50','2025-12-06 10:22:52','2025-12-06 10:22:52',1,'qcow2','bare','70dc0f6786d220c9d277501913006a40','096aefe63e33405396d6efe65bbb1733',2,0,0,NULL,'private',0,'sha512','b96ab40858ddd4dbac5179120463a7d723d490c5bb5df54339942cf8fb0cfda6b52ef1b6037f939c354aea01ea36a59384529fbf8608dac9bbe7631b8cab76ca'),('49f193af-9510-4d37-b87d-6f0d8db586ee','tempest-ImagesMemberTest-image-2100864581',NULL,'deleted','2025-12-06 10:16:10','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'raw','bare',NULL,'eb829c5db97a4c82b35011f68e8c1e65',0,0,0,NULL,'shared',0,NULL,NULL),('516b003d-17ce-422b-b48f-7c6b2ba8dbe9','tempest-ListUserImagesTest-image-1480602392',1943,'deleted','2025-12-06 10:16:51','2025-12-06 10:17:10','2025-12-06 10:17:10',1,'qcow2','bare','543efaa00f5125061009a2df53384ad5','39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'private',0,'sha512','730b514fb31f1ad9dc3b7d6475a7838ea8afbd67902ed7fe5b189098b702f7aeac942bd6f6d492a5658fe8e5f277538ced07e0ed36c27b93c0f67eaeacca2595'),('57a18f5d-0bb5-4bd4-8952-e0415dd44feb','tempest-image-1372013535',1024,'deleted','2025-12-06 10:18:14','2025-12-06 10:18:25','2025-12-06 10:18:25',1,'raw','bare','f08dbd285d3a51a11646fd47c30be51d','5ae5b2af677a466a97c4783ec75e136c',0,0,0,1024,'private',0,'sha512','49f0b95d9f21be0182f9eeebc7c37dbd1d433be5c249ee7785b560beb68242987316b58bf586579b3806fae2c0fe36bf173a565b9c22d3b9307a400031346ee1'),('58ffa643-8b2b-40e1-b00e-d43590a3bc37','tempest-ListUserImagesTest-image-2111359057',3140,'deleted','2025-12-06 10:16:58','2025-12-06 10:17:02','2025-12-06 10:17:02',1,'vhd','bare','ed6bef4ef3c90aa526c4a453e916c924','39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'private',0,'sha512','88d32a22add149b287cab8785c70f75fe234a039598dbddd6265f8ce30d915a60d6ef1b7cc13a5f9ceecc2491ae856f473df76d25e918a295a6779e399c5f22c'),('5e89b137-706f-4234-b097-c97e83c87b31','tempest-test-789924191',NULL,'queued','2025-12-06 10:17:16','2025-12-06 10:17:16',NULL,0,'raw','bare',NULL,'ce4a191131d2409a8fc6c1e67d19f7ce',0,0,0,NULL,'shared',0,NULL,NULL),('66df6814-6caf-4001-aace-c11674b4cdf9','tempest-image-2103899206',117440512,'deleted','2025-12-06 10:18:17','2025-12-06 10:18:24','2025-12-06 10:18:24',1,'raw','bare','4245576e3df99ea1211871b8b9514d3b','5ae5b2af677a466a97c4783ec75e136c',0,0,0,117440512,'private',0,'sha512','dbb480bdc4f13ead7e00b62766df2815ddc8d4775af8a82ec40f8afd433d4cb95a109a58fbe7e0a661be86e0a06321c00362bc881f58c61c40bd2d1486954594'),('6a944ab6-8965-4055-b7fc-af6e395005ea','cirros-0.6.2-x86_64-disk.img',21430272,'active','2025-12-06 10:13:11','2025-12-06 10:13:13',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','3d603431c0bb4967bafc7a0aa6108bfe',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('70b85762-7284-43d6-b5d7-eaa0b7c55011',NULL,NULL,'deleted','2025-12-06 10:16:59','2025-12-06 10:16:59','2025-12-06 10:16:59',1,NULL,NULL,NULL,'39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'shared',1,NULL,NULL),('7141663c-a695-4147-a03d-20e8d4f67069','tempest-UnshelveToHostMultiNodesTest-server-65395191-shelved',1073741824,'deleted','2025-12-06 10:14:22','2025-12-06 10:14:53','2025-12-06 10:14:53',1,'raw','bare',NULL,'c6d84801a8b44d9da497e9761a0cd10c',1,0,0,NULL,'private',0,NULL,NULL),('8de8da0b-eced-4fcf-9deb-0adb72583db4','tempest-ImagesMemberTest-image-909104869',NULL,'deleted','2025-12-06 10:16:10','2025-12-06 10:16:11','2025-12-06 10:16:11',1,'raw','bare',NULL,'eb829c5db97a4c82b35011f68e8c1e65',0,0,0,NULL,'shared',0,NULL,NULL),('94c61b47-d7dd-45ff-9dd8-8f29ec43e867','tempest-ImagesMemberTest-image-330202488',NULL,'deleted','2025-12-06 10:16:10','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'raw','bare',NULL,'eb829c5db97a4c82b35011f68e8c1e65',0,0,0,NULL,'shared',0,NULL,NULL),('a4cbb7c1-08a3-4b6e-87db-21eb30b72331',NULL,NULL,'deleted','2025-12-06 10:14:59','2025-12-06 10:14:59','2025-12-06 10:14:59',1,'raw','bare',NULL,'529f65c715484aba90278ed70be36dab',0,0,0,NULL,'shared',0,NULL,NULL),('af540be2-bf52-4bff-b4bd-6dea5cca6542','tempest-UnshelveToHostMultiNodesTest-server-65395191-shelved',1073741824,'deleted','2025-12-06 10:14:55','2025-12-06 10:15:21','2025-12-06 10:15:21',1,'raw','bare',NULL,'c6d84801a8b44d9da497e9761a0cd10c',1,0,0,NULL,'private',0,NULL,NULL),('b0503d14-1b22-4c58-92fa-3ba5ca05c249','tempest-BasicOperationsImagesAdminTest-Image-2003487693',NULL,'deleted','2025-12-06 10:14:59','2025-12-06 10:15:00','2025-12-06 10:15:00',1,'raw','bare',NULL,'228fc5efa6134c1e885bd45c6289a5c7',0,0,0,NULL,'public',0,NULL,NULL),('b318c449-eef1-413a-8f56-518aa993470b','tempest-image-1074363308',1024,'deleted','2025-12-06 10:17:03','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'raw','bare','41d836dab5665a6707e3073cc8edf587','ec54df1cc2e6480cbd18172c892b6984',0,0,0,1024,'private',0,'sha512','4a3f98e0f246e2d68b578ec5315fc95fc4df7dc7a569ce52772a2320cfd4c422429d685b5217461291caf0d4889ea2c6f970445311af0f51995b6a694d081ee1'),('b38b84c3-c97d-4082-8561-8dd7b1cc3b10','tempest-image-865857724',1024,'deleted','2025-12-06 10:17:05','2025-12-06 10:17:08','2025-12-06 10:17:08',1,'qcow2','bare','96856bb7b7ab3992826db56f63218a97','ec54df1cc2e6480cbd18172c892b6984',0,0,0,NULL,'private',0,'sha512','b3e1180bafd5a32342da0bccf4389fca80b3d27914515f384ac6e9f03627792cb40083a0dae851b2744d1564d346a3b71de7d09610da3d027f9cf9e9b7567f7e'),('baba169c-4448-4dd5-9992-3f5f4584bfb9','tempest-ListUserImagesTest-image-357207217',1831,'deleted','2025-12-06 10:16:54','2025-12-06 10:17:06','2025-12-06 10:17:06',1,'ari','bare','5488fae0e9bf511267e8337b6eed2894','39d77a386d64496599115cc3abaddbed',0,0,0,NULL,'private',0,'sha512','78413bc7cbd6e0d2c99f800f5b25f477ca9ec97b43dac7a90df4b4ab2d2fa3d898e2651414fe171c2b0ab1ad8b4d84f22ce551fe4222a7fa5ac6056a730f5639'),('c1aef809-64d4-4c69-aa18-63281120c8a7','tempest-ImagesMemberNegativeTest-image-215275372',NULL,'deleted','2025-12-06 10:17:08','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'raw','bare',NULL,'5b13fbba477244f3841a1579bbe4a502',0,0,0,NULL,'shared',0,NULL,NULL),('c5882814-217f-4b14-b21e-4150eee3d753','tempest-test-838600069',NULL,'deleted','2025-12-06 10:18:30','2025-12-06 10:18:30','2025-12-06 10:18:30',1,NULL,NULL,NULL,'06eecf2db90342a0849d9f963dfc2e11',0,0,0,NULL,'shared',0,NULL,NULL),('c58b1bc6-e4c0-4ae8-9f5d-024a618e17b8','tempest-VolumesNegativeTest-image-554483135',1024,'deleted','2025-12-06 10:22:47','2025-12-06 10:22:50','2025-12-06 10:22:50',1,'qcow2','bare','2553dcfcd529b005e3561a7f5493feae','096aefe63e33405396d6efe65bbb1733',2,0,0,NULL,'private',0,'sha512','1bd868646f15f79f55f23c5c91f59501ae0dedce6324555af1c8ce854d10ccfb57ccb38813d8bff7397598d783ae67c11c4428c3df6f57516c1bfe1242b5c070'),('c7d7ab8f-4e18-42ba-b92d-c411789d7e5d','tempest-task_image-1787910067',NULL,'deleted','2025-12-06 10:18:02','2025-12-06 10:18:02','2025-12-06 10:18:02',1,'qcow2','bare',NULL,NULL,0,0,0,NULL,'public',0,NULL,NULL),('cb72e6ab-1bed-44c7-9308-6e8f3ed565f8','tempest-ImagesMemberTest-image-206574319',NULL,'deleted','2025-12-06 10:16:09','2025-12-06 10:16:10','2025-12-06 10:16:10',1,'raw','bare',NULL,'eb829c5db97a4c82b35011f68e8c1e65',0,0,0,NULL,'shared',0,NULL,NULL),('cf960bdd-cabe-4854-bc2a-c4ded5e88c51','tempest-test-1443781132',NULL,'deleted','2025-12-06 10:18:30','2025-12-06 10:18:30','2025-12-06 10:18:30',1,'raw','bare',NULL,'06eecf2db90342a0849d9f963dfc2e11',0,0,0,NULL,'shared',0,NULL,NULL),('d147d58a-0420-4f78-80ae-ef1c5b00dd14','cirros-0.6.2-x86_64-disk.img_alt',21430272,'active','2025-12-06 10:13:13','2025-12-06 10:13:15',NULL,0,'qcow2','bare','c8fc807773e5354afe61636071771906','3d603431c0bb4967bafc7a0aa6108bfe',0,0,0,117440512,'public',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('dacb95d2-9ab4-4326-972a-377a14807da1','tempest-VolumesActionsTest-Image-577567526',1073741824,'deleted','2025-12-06 10:21:52','2025-12-06 10:22:41','2025-12-06 10:22:41',1,'raw','bare','cd573cfaace07e7949bc0c46028904ff','fd1c979900294beeb6f273c0e1a6333a',0,0,0,1073741824,'shared',0,'sha512','c5041ae163cf0f65600acfe7f6a63f212101687d41a57a4e18ffd2a07a452cd8175b8f5a4868dd2330bfe5ae123f18216bdbc9e0f80d131e64b94913a7b40bb5'),('e0d06706-da90-478a-9829-34b75a3ce049','cirros',21692416,'active','2025-12-06 08:43:26','2025-12-06 08:43:30',NULL,0,'qcow2','bare','87617e24a5e30cb3b87fda8c0764838f','3d603431c0bb4967bafc7a0aa6108bfe',0,0,0,117440512,'shared',0,'sha512','9a9bce0083a00939ec17c11febbfc767aa211aaa54f51e75c5a8b271a9b5637c77205a518b7a2007cb391d23cceb01e0e4e8d64832317151bc85b734b92a7be0'),('e0de1c98-b38b-4d60-acb1-4bf581edf865','tempest-ListSharedImagesTest-image-1014337300',2048,'deleted','2025-12-06 10:16:52','2025-12-06 10:16:55','2025-12-06 10:16:55',1,'qcow2','bare','b321e0be490b6519a4c2c4a8de08be0c','1f8385e255f14502b6a0abd3401d83c5',0,0,0,NULL,'shared',0,'sha512','1c89456b94b87120e61c8fd5c7cbcc6c5475d8566da8a85cafe168c0d4e5ad65ead601ac7ff4e6db70e34eda9d8f31ef1fd386fdf6434f5f912882c6d30ef797'),('e1e9b0b2-d5d4-441c-b52f-48ad329a8ac4','tempest-ListUserImagesTest-image-1686382597',3128,'deleted','2025-12-06 10:16:52','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'raw','bare','85aa317e3a7888c17244b2b78e4070a7','39d77a386d64496599115cc3abaddbed',0,0,0,3128,'private',0,'sha512','ad0e681dc6016de20dfe1c2cc6b112a480a32defaa7cd8e3f7b4f3ffb8b6c11cbe148a43ba1932c83ebf82d1b402cb5f89e4c8f771e95d553d1271c144d4efb3'),('e3a2b59a-4e0e-48e5-82db-7541d90d6e36','tempest-ImagesMemberNegativeTest-image-17794698',NULL,'deleted','2025-12-06 10:17:09','2025-12-06 10:17:09','2025-12-06 10:17:09',1,'raw','bare',NULL,'5b13fbba477244f3841a1579bbe4a502',0,0,0,NULL,'shared',0,NULL,NULL),('f71e4c17-e0eb-4d6d-b75f-bbde8caedc6d','tempest-ImagesTagsNegativeTest-image-478691016',NULL,'deleted','2025-12-06 10:15:26','2025-12-06 10:15:27','2025-12-06 10:15:27',1,'raw','bare',NULL,'7e4c0d33e9f3470f9c2e04d1d0b3fdd5',0,0,0,NULL,'private',0,NULL,NULL),('f92b31cc-df45-4e89-946b-99e965e3dc2f','tempest-new-image-1071481510',NULL,'deleted','2025-12-06 10:17:06','2025-12-06 10:17:06','2025-12-06 10:17:06',1,'qcow2','bare',NULL,'ec54df1cc2e6480cbd18172c892b6984',0,0,0,NULL,'private',0,NULL,NULL),('f9534607-4d0e-4139-bd6d-4215880b29f8','tempest-scenario-img--1253718362',21430272,'deleted','2025-12-06 10:30:42','2025-12-06 10:30:46','2025-12-06 10:30:46',1,'qcow2','bare','c8fc807773e5354afe61636071771906','7d2c3fc1d605488db2b4af2af7696c67',0,0,0,117440512,'private',0,'sha512','1103b92ce8ad966e41235a4de260deb791ff571670c0342666c8582fbb9caefe6af07ebb11d34f44f8414b609b29c1bdf1d72ffa6faa39c88e8721d09847952b'),('fecce101-9451-4ef9-bb2a-9ff62e53d81c','tempest-ImagesTagsTest-image-1302651735',NULL,'deleted','2025-12-06 10:18:56','2025-12-06 10:18:56','2025-12-06 10:18:56',1,'raw','bare',NULL,'77baa6b0592d4c47b8a2fa01954f5130',0,0,0,NULL,'private',0,NULL,NULL);
/*!40000 ALTER TABLE `images` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespace_resource_types`
--

DROP TABLE IF EXISTS `metadef_namespace_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespace_resource_types` (
  `resource_type_id` int(11) NOT NULL,
  `namespace_id` int(11) NOT NULL,
  `properties_target` varchar(80) DEFAULT NULL,
  `prefix` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`resource_type_id`,`namespace_id`),
  KEY `ix_metadef_ns_res_types_namespace_id` (`namespace_id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`),
  CONSTRAINT `metadef_namespace_resource_types_ibfk_2` FOREIGN KEY (`resource_type_id`) REFERENCES `metadef_resource_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespace_resource_types`
--

LOCK TABLES `metadef_namespace_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_namespace_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_namespace_resource_types` (`resource_type_id`, `namespace_id`, `properties_target`, `prefix`, `created_at`, `updated_at`) VALUES (2,2,'image','CIM_PASD_','2025-12-06 08:26:05',NULL),(2,5,'image','CIM_RASD_','2025-12-06 08:26:05',NULL),(2,8,NULL,'CIM_SASD_','2025-12-06 08:26:06',NULL),(2,23,'image','hw_','2025-12-06 08:26:07',NULL),(2,26,'image','hw_','2025-12-06 08:26:07',NULL),(2,38,'image',NULL,'2025-12-06 08:26:09',NULL),(2,53,'image','hw_','2025-12-06 08:26:10',NULL),(2,65,'image','hw_','2025-12-06 08:26:11',NULL),(2,77,'image',NULL,'2025-12-06 08:26:12',NULL),(2,80,'image',NULL,'2025-12-06 08:26:12',NULL),(2,83,'image',NULL,'2025-12-06 08:26:13',NULL),(2,86,'image',NULL,'2025-12-06 08:26:13',NULL),(5,2,NULL,'CIM_PASD_','2025-12-06 08:26:05',NULL),(5,23,NULL,'hw_','2025-12-06 08:26:07',NULL),(5,26,NULL,'hw_','2025-12-06 08:26:07',NULL),(5,29,NULL,NULL,'2025-12-06 08:26:08',NULL),(5,35,NULL,NULL,'2025-12-06 08:26:08',NULL),(5,38,NULL,NULL,'2025-12-06 08:26:09',NULL),(5,41,NULL,NULL,'2025-12-06 08:26:09',NULL),(5,44,NULL,'hw_','2025-12-06 08:26:09',NULL),(5,53,NULL,'hw_','2025-12-06 08:26:10',NULL),(5,62,NULL,NULL,'2025-12-06 08:26:11',NULL),(5,65,NULL,'hw_','2025-12-06 08:26:11',NULL),(5,68,NULL,NULL,'2025-12-06 08:26:11',NULL),(5,74,NULL,NULL,'2025-12-06 08:26:11',NULL),(5,77,NULL,NULL,'2025-12-06 08:26:12',NULL),(5,80,NULL,NULL,'2025-12-06 08:26:12',NULL),(5,83,NULL,NULL,'2025-12-06 08:26:13',NULL),(5,86,NULL,NULL,'2025-12-06 08:26:13',NULL),(5,89,NULL,'cinder_','2025-12-06 08:26:13',NULL),(5,92,NULL,'hw_','2025-12-06 09:03:59',NULL),(5,93,NULL,'hw_','2025-12-06 09:03:59',NULL),(5,94,NULL,'traits:','2025-12-06 09:03:59',NULL),(8,2,NULL,'CIM_PASD_','2025-12-06 08:26:05',NULL),(8,5,NULL,'CIM_RASD_','2025-12-06 08:26:05',NULL),(8,8,NULL,'CIM_SASD_','2025-12-06 08:26:06',NULL),(8,11,NULL,'CIM_VSSD_','2025-12-06 08:26:06',NULL),(8,14,NULL,NULL,'2025-12-06 08:26:07',NULL),(8,17,NULL,NULL,'2025-12-06 08:26:07',NULL),(8,20,NULL,NULL,'2025-12-06 08:26:07',NULL),(8,32,NULL,'aggregate_instance_extra_specs:','2025-12-06 08:26:08',NULL),(11,2,NULL,'CIM_PASD_','2025-12-06 08:26:05',NULL),(11,5,NULL,'CIM_RASD_','2025-12-06 08:26:05',NULL),(11,8,NULL,'CIM_SASD_','2025-12-06 08:26:06',NULL),(11,11,NULL,'CIM_VSSD_','2025-12-06 08:26:06',NULL),(11,23,NULL,'hw:','2025-12-06 08:26:07',NULL),(11,26,NULL,'hw:','2025-12-06 08:26:07',NULL),(11,32,NULL,'capabilities:','2025-12-06 08:26:08',NULL),(11,44,NULL,'hw:','2025-12-06 08:26:10',NULL),(11,47,NULL,NULL,'2025-12-06 08:26:10',NULL),(11,50,NULL,NULL,'2025-12-06 08:26:10',NULL),(11,53,NULL,'hw:','2025-12-06 08:26:10',NULL),(11,56,NULL,NULL,'2025-12-06 08:26:10',NULL),(11,59,NULL,NULL,'2025-12-06 08:26:11',NULL),(11,65,NULL,'hw:','2025-12-06 08:26:11',NULL),(11,92,NULL,'hw:','2025-12-06 09:03:59',NULL),(11,93,NULL,'hw:','2025-12-06 09:03:59',NULL),(11,94,NULL,'traits:','2025-12-06 09:03:59',NULL),(14,2,'scheduler_hints',NULL,'2025-12-06 08:26:05',NULL),(14,80,'metadata',NULL,'2025-12-06 08:26:12',NULL),(14,83,'metadata',NULL,'2025-12-06 08:26:13',NULL),(14,86,'metadata',NULL,'2025-12-06 08:26:13',NULL),(17,80,NULL,NULL,'2025-12-06 08:26:12',NULL);
/*!40000 ALTER TABLE `metadef_namespace_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_namespaces`
--

DROP TABLE IF EXISTS `metadef_namespaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_namespaces` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace` varchar(80) NOT NULL,
  `display_name` varchar(80) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `visibility` varchar(32) DEFAULT NULL,
  `protected` tinyint(1) DEFAULT NULL,
  `owner` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_namespaces_namespace` (`namespace`),
  KEY `ix_metadef_namespaces_owner` (`owner`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_namespaces`
--

LOCK TABLES `metadef_namespaces` WRITE;
/*!40000 ALTER TABLE `metadef_namespaces` DISABLE KEYS */;
INSERT INTO `metadef_namespaces` (`id`, `namespace`, `display_name`, `description`, `visibility`, `protected`, `owner`, `created_at`, `updated_at`) VALUES (2,'CIM::ProcessorAllocationSettingData','CIM Processor Allocation Setting','Properties related to the resource allocation settings of a processor (CPU) from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These are properties that identify processor setting data and may be specified to volume, image, host aggregate, flavor and Nova server as scheduler hint. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ProcessorAllocationSettingData.html.','public',1,'admin','2025-12-06 08:26:05',NULL),(5,'CIM::ResourceAllocationSettingData','CIM Resource Allocation Setting Data','Properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim) that represent settings specifically related to an allocated resource that are outside the scope of the CIM class typically used to represent the resource itself. These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_ResourceAllocationSettingData.html.','public',1,'admin','2025-12-06 08:26:05',NULL),(8,'CIM::StorageAllocationSettingData','CIM Storage Allocation Setting Data','Properties related to the allocation of virtual storage from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim). These properties may be specified to volume, host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_StorageAllocationSettingData.html.','public',1,'admin','2025-12-06 08:26:06',NULL),(11,'CIM::VirtualSystemSettingData','CIM Virtual System Setting Data','A set of virtualization specific properties from Common Information Model (CIM) schema (http://www.dmtf.org/standards/cim), which define the virtual aspects of a virtual system. These properties may be specified to host aggregate and flavor. For each property details, please refer to http://schemas.dmtf.org/wbem/cim-html/2/CIM_VirtualSystemSettingData.html.','public',1,'admin','2025-12-06 08:26:06',NULL),(14,'OS::Compute::AggregateDiskFilter','Disk Allocation per Host','Properties related to the Nova scheduler filter AggregateDiskFilter. Filters aggregate hosts based on the available disk space compared to the requested disk space. Hosts in the aggregate with not enough usable disk will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 08:26:07',NULL),(17,'OS::Compute::AggregateIoOpsFilter','IO Ops per Host','Properties related to the Nova scheduler filter AggregateIoOpsFilter. Filters aggregate hosts based on the number of instances currently changing state. Hosts in the aggregate with too many instances changing state will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',1,'admin','2025-12-06 08:26:07',NULL),(20,'OS::Compute::AggregateNumInstancesFilter','Instances per Host','Properties related to the Nova scheduler filter AggregateNumInstancesFilter. Filters aggregate hosts by the number of running instances on it. Hosts in the aggregate with too many instances will be filtered out. The filter must be enabled in the Nova scheduler to use these properties.','public',0,'admin','2025-12-06 08:26:07',NULL),(23,'OS::Compute::CPUPinning','CPU Pinning','This provides the preferred CPU pinning and CPU thread pinning policy to be used when pinning vCPU of the guest to pCPU of the host. See http://docs.openstack.org/admin-guide/compute-numa-cpu-pinning.html','public',1,'admin','2025-12-06 08:26:07',NULL),(26,'OS::Compute::GuestMemoryBacking','Guest Memory Backing','This provides the preferred backing option for guest RAM. Guest\'s memory can be backed by hugepages to limit TLB lookups. See also: https://wiki.openstack.org/wiki/VirtDriverGuestCPUMemoryPlacement','public',1,'admin','2025-12-06 08:26:07',NULL),(29,'OS::Compute::GuestShutdownBehavior','Shutdown Behavior','These properties allow modifying the shutdown behavior for stop, rescue, resize, and shelve operations.','public',1,'admin','2025-12-06 08:26:08',NULL),(32,'OS::Compute::HostCapabilities','Compute Host Capabilities','Hardware capabilities provided by the compute host. This provides the ability to fine tune the hardware specification required when an instance is requested. The ComputeCapabilitiesFilter should be enabled in the Nova scheduler to use these properties. When enabled, this filter checks that the capabilities provided by the compute host satisfy any extra specifications requested. Only hosts that can provide the requested capabilities will be eligible for hosting the instance.','public',1,'admin','2025-12-06 08:26:08',NULL),(35,'OS::Compute::Hypervisor','Hypervisor Selection','OpenStack Compute supports many hypervisors, although most installations use only one hypervisor. For installations with multiple supported hypervisors, you can schedule different hypervisors using the ImagePropertiesFilter. This filters compute nodes that satisfy any architecture, hypervisor type, or virtual machine mode properties specified on the instance\'s image properties.','public',1,'admin','2025-12-06 08:26:08',NULL),(38,'OS::Compute::InstanceData','Instance Config Data','Instances can perform self-configuration based on data made available to the running instance. These properties affect instance configuration.','public',1,'admin','2025-12-06 08:26:08',NULL),(41,'OS::Compute::LibvirtImage','libvirt Driver Options for Images','The libvirt Compute Driver Options for Glance Images.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 08:26:09',NULL),(44,'OS::Compute::Libvirt','libvirt Driver Options','The libvirt compute driver options.  \n\nThese are properties that affect the libvirt compute driver and may be specified on flavors and images.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 08:26:09',NULL),(47,'OS::Compute::Quota','Flavor Quota','Compute drivers may enable quotas on CPUs available to a VM, disk tuning, bandwidth I/O, and instance VIF traffic control.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 08:26:10',NULL),(50,'OS::Compute::RandomNumberGenerator','Random Number Generator','If a random-number generator device has been added to the instance through its image properties, the device can be enabled and configured.','public',1,'admin','2025-12-06 08:26:10',NULL),(53,'OS::Compute::VirtCPUTopology','Virtual CPU Topology','This provides the preferred socket/core/thread counts for the virtual CPU instance exposed to guests. This enables the ability to avoid hitting limitations on vCPU topologies that OS vendors place on their products. See also: https://opendev.org/openstack/nova-specs/src/branch/master/specs/juno/implemented/virt-driver-vcpu-topology.rst','public',1,'admin','2025-12-06 08:26:10',NULL),(56,'OS::Compute::VMwareFlavor','VMware Driver Options for Flavors','VMware Driver Options for Flavors may be used to customize and manage Nova Flavors. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 08:26:10',NULL),(59,'OS::Compute::VMwareQuotaFlavor','VMware Quota for Flavors','The VMware compute driver allows various compute quotas to be specified on flavors. When specified, the VMWare driver will ensure that the quota is enforced. These are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova. For a list of hypervisors, see: https://wiki.openstack.org/wiki/HypervisorSupportMatrix. For flavor customization, see: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 08:26:11',NULL),(62,'OS::Compute::VMware','VMware Driver Options','The VMware compute driver options.  \n\nThese are properties specific to VMWare compute drivers and will only have an effect if the VMWare compute driver is enabled in Nova.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 08:26:11',NULL),(65,'OS::Compute::Watchdog','Watchdog Behavior','Compute drivers may enable watchdog behavior over instances.  See: http://docs.openstack.org/admin-guide/compute-flavors.html','public',1,'admin','2025-12-06 08:26:11',NULL),(68,'OS::Compute::XenAPI','XenAPI Driver Options','The XenAPI compute driver options.  \n\nThese are properties specific to compute drivers.  For a list of all hypervisors, see here: https://wiki.openstack.org/wiki/HypervisorSupportMatrix.','public',1,'admin','2025-12-06 08:26:11',NULL),(71,'OS::Glance::CommonImageProperties','Common Image Properties','When adding an image to Glance, you may specify some common image properties that may prove useful to consumers of your image.',NULL,1,'admin','2025-12-06 08:26:11',NULL),(74,'OS::Glance::Signatures','Image Signature Verification','Image signature verification allows the user to verify that an image has not been modified prior to booting the image.','public',0,'admin','2025-12-06 08:26:11',NULL),(77,'OS::OperatingSystem','Common Operating System Properties','Details of the operating system contained within this image as well as common operating system properties that can be set on a VM instance created from this image.',NULL,1,'admin','2025-12-06 08:26:12',NULL),(80,'OS::Software::DBMS','Database Software','A database is an organized collection of data. The data is typically organized to model aspects of reality in a way that supports processes requiring information. Database management systems are computer software applications that interact with the user, other applications, and the database itself to capture and analyze data. (http://en.wikipedia.org/wiki/Database)','public',1,'admin','2025-12-06 08:26:12',NULL),(83,'OS::Software::Runtimes','Runtime Environment','Software is written in a specific programming language and the language must execute within a runtime environment. The runtime environment provides an abstraction to utilizing a computer\'s processor, memory (RAM), and other system resources.','public',1,'admin','2025-12-06 08:26:13',NULL),(86,'OS::Software::WebServers','Web Servers','A web server is a computer system that processes requests via HTTP, the basic network protocol used to distribute information on the World Wide Web. The most common use of web servers is to host websites, but there are other uses such as gaming, data storage, running enterprise applications, handling email, FTP, or other web uses. (http://en.wikipedia.org/wiki/Web_server)','public',1,'admin','2025-12-06 08:26:13',NULL),(89,'OS::Cinder::Volumetype','Cinder Volume Type','The Cinder volume type configuration option. Volume type assignment provides a mechanism not only to provide scheduling to a specific storage back-end, but also can be used to specify specific information for a back-end storage device to act upon.','public',1,'admin','2025-12-06 08:26:13',NULL),(92,'OS::Compute::CPUMode','CPU Mode','This provides the preferred CPU Model to be used when booting up a guest VM.','public',NULL,'admin','2025-12-06 09:03:59',NULL),(93,'OS::Compute::TPM','TPM Options','Configuration options for TPM','public',1,'admin','2025-12-06 09:03:59',NULL),(94,'OS::Compute::VTPM','Emulated Virtual TPM','Configuration options for Emulated Virtual TPM','public',1,'admin','2025-12-06 09:03:59',NULL);
/*!40000 ALTER TABLE `metadef_namespaces` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_objects`
--

DROP TABLE IF EXISTS `metadef_objects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `description` text DEFAULT NULL,
  `required` text DEFAULT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_objects_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_objects_name` (`name`),
  CONSTRAINT `metadef_objects_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_objects`
--

LOCK TABLES `metadef_objects` WRITE;
/*!40000 ALTER TABLE `metadef_objects` DISABLE KEYS */;
INSERT INTO `metadef_objects` (`id`, `namespace_id`, `name`, `description`, `required`, `json_schema`, `created_at`, `updated_at`) VALUES (2,47,'CPU Limits','You can configure the CPU limits with control parameters.',NULL,'{\"quota:cpu_shares\": {\"title\": \"Quota: CPU Shares\", \"description\": \"Specifies the proportional weighted share for the domain. If this element is omitted, the service defaults to the OS provided defaults. There is no unit for the value; it is a relative measure based on the setting of other VMs. For example, a VM configured with value 2048 gets twice as much CPU time as a VM configured with value 1024.\", \"type\": \"integer\"}, \"quota:cpu_period\": {\"title\": \"Quota: CPU Period\", \"description\": \"Specifies the enforcement interval (unit: microseconds) for QEMU and LXC hypervisors. Within a period, each VCPU of the domain is not allowed to consume more than the quota worth of runtime. The value should be in range [1000, 1000000]. A period with value 0 means no value.\", \"type\": \"integer\", \"minimum\": 1000, \"maximum\": 1000000}, \"quota:cpu_quota\": {\"title\": \"Quota: CPU Quota\", \"description\": \"Specifies the maximum allowed bandwidth (unit: microseconds). A domain with a negative-value quota indicates that the domain has infinite bandwidth, which means that it is not bandwidth controlled. The value should be in range [1000, 18446744073709551] or less than 0. A quota with value 0 means no value. You can use this feature to ensure that all vCPUs run at the same speed.\", \"type\": \"integer\"}}','2025-12-06 08:26:10',NULL),(5,47,'Disk QoS','Using disk I/O quotas, you can set maximum disk write to 10 MB per second for a VM user.',NULL,'{\"quota:disk_read_bytes_sec\": {\"title\": \"Quota: Disk read bytes / sec\", \"description\": \"Sets disk I/O quota for disk read bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_read_iops_sec\": {\"title\": \"Quota: Disk read IOPS / sec\", \"description\": \"Sets disk I/O quota for disk read IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_write_bytes_sec\": {\"title\": \"Quota: Disk Write Bytes / sec\", \"description\": \"Sets disk I/O quota for disk write bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_write_iops_sec\": {\"title\": \"Quota: Disk Write IOPS / sec\", \"description\": \"Sets disk I/O quota for disk write IOPS / sec.\", \"type\": \"integer\"}, \"quota:disk_total_bytes_sec\": {\"title\": \"Quota: Disk Total Bytes / sec\", \"description\": \"Sets disk I/O quota for total disk bytes / sec.\", \"type\": \"integer\"}, \"quota:disk_total_iops_sec\": {\"title\": \"Quota: Disk Total IOPS / sec\", \"description\": \"Sets disk I/O quota for disk total IOPS / sec.\", \"type\": \"integer\"}}','2025-12-06 08:26:10',NULL),(8,47,'Virtual Interface QoS','Bandwidth QoS tuning for instance virtual interfaces (VIFs) may be specified with these properties. Incoming and outgoing traffic can be shaped independently. If not specified, no quality of service (QoS) is applied on that traffic direction. So, if you want to shape only the network\'s incoming traffic, use inbound only (and vice versa). The OpenStack Networking service abstracts the physical implementation of the network, allowing plugins to configure and manage physical resources. Virtual Interfaces (VIF) in the logical model are analogous to physical network interface cards (NICs). VIFs are typically owned a managed by an external service; for instance when OpenStack Networking is used for building OpenStack networks, VIFs would be created, owned, and managed in Nova. VIFs are connected to OpenStack Networking networks via ports. A port is analogous to a port on a network switch, and it has an administrative state. When a VIF is attached to a port the OpenStack Networking API creates an attachment object, which specifies the fact that a VIF with a given identifier is plugged into the port.',NULL,'{\"quota:vif_inbound_average\": {\"title\": \"Quota: VIF Inbound Average\", \"description\": \"Network Virtual Interface (VIF) inbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_inbound_burst\": {\"title\": \"Quota: VIF Inbound Burst\", \"description\": \"Network Virtual Interface (VIF) inbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_inbound_peak\": {\"title\": \"Quota: VIF Inbound Peak\", \"description\": \"Network Virtual Interface (VIF) inbound peak in kilobytes per second. Specifies maximum rate at which an interface can receive data.\", \"type\": \"integer\"}, \"quota:vif_outbound_average\": {\"title\": \"Quota: VIF Outbound Average\", \"description\": \"Network Virtual Interface (VIF) outbound average in kilobytes per second. Specifies average bit rate on the interface being shaped.\", \"type\": \"integer\"}, \"quota:vif_outbound_burst\": {\"title\": \"Quota: VIF Outbound Burst\", \"description\": \"Network Virtual Interface (VIF) outbound burst in total kilobytes. Specifies the amount of bytes that can be burst at peak speed.\", \"type\": \"integer\"}, \"quota:vif_outbound_peak\": {\"title\": \"Quota: VIF Outbound Peak\", \"description\": \"Network Virtual Interface (VIF) outbound peak in kilobytes per second. Specifies maximum rate at which an interface can send data.\", \"type\": \"integer\"}}','2025-12-06 08:26:10',NULL),(11,80,'MySQL','MySQL is an object-relational database management system (ORDBMS). The MySQL development project has made its source code available under the terms of the GNU General Public License, as well as under a variety of proprietary agreements. MySQL was owned and sponsored by a single for-profit firm, the Swedish company MySQL AB, now owned by Oracle Corporation. MySQL is a popular choice of database for use in web applications, and is a central component of the widely used LAMP open source web application software stack (and other \'AMP\' stacks). (http://en.wikipedia.org/wiki/MySQL)',NULL,'{\"sw_database_mysql_version\": {\"title\": \"Version\", \"description\": \"The specific version of MySQL.\", \"type\": \"string\"}, \"sw_database_mysql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"The configured TCP/IP port which MySQL listens for incoming connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 3606}, \"sw_database_mysql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"root\"}}','2025-12-06 08:26:12',NULL),(14,80,'PostgreSQL','PostgreSQL, often simply \'Postgres\', is an object-relational database management system (ORDBMS) with an emphasis on extensibility and standards-compliance. PostgreSQL is cross-platform and runs on many operating systems. (http://en.wikipedia.org/wiki/PostgreSQL)',NULL,'{\"sw_database_postgresql_version\": {\"title\": \"Version\", \"description\": \"The specific version of PostgreSQL.\", \"type\": \"string\"}, \"sw_database_postgresql_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which PostgreSQL is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_postgresql_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"postgres\"}}','2025-12-06 08:26:12',NULL),(17,80,'SQL Server','Microsoft SQL Server is a relational database management system developed by Microsoft. There are at least a dozen different editions of Microsoft SQL Server aimed at different audiences and for workloads ranging from small single-machine applications to large Internet-facing applications with many concurrent users. Its primary query languages are T-SQL and ANSI SQL. (http://en.wikipedia.org/wiki/Microsoft_SQL_Server)',NULL,'{\"sw_database_sqlserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Microsoft SQL Server.\", \"type\": \"string\"}, \"sw_database_sqlserver_edition\": {\"title\": \"Edition\", \"description\": \"SQL Server is available in multiple editions, with different feature sets and targeting different users.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Datacenter\", \"Enterprise\", \"Standard\", \"Web\", \"Business Intelligence\", \"Workgroup\", \"Express\", \"Compact (SQL CE)\", \"Developer\", \"Embedded (SSEE)\", \"Express\", \"Fast Track\", \"LocalDB\", \"Parallel Data Warehouse (PDW)\", \"Business Intelligence\", \"Datawarehouse Appliance Edition\"]}, \"sw_database_sqlserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which SQL Server is to listen for connections from client applications. The default SQL Server port is 1433, and client ports are assigned a random value between 1024 and 5000.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1433}, \"sw_database_postsqlserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"sa\"}}','2025-12-06 08:26:12',NULL),(20,80,'Oracle','Oracle Database (commonly referred to as Oracle RDBMS or simply as Oracle) is an object-relational database management system produced and marketed by Oracle Corporation. (http://en.wikipedia.org/wiki/Oracle_Database)',NULL,'{\"sw_database_oracle_version\": {\"title\": \"Version\", \"description\": \"The specific version of Oracle.\", \"type\": \"string\"}, \"sw_database_oracle_edition\": {\"title\": \"Edition\", \"description\": \"Over and above the different versions of the Oracle database management software developed over time, Oracle Corporation subdivides its product into varying editions.\", \"type\": \"string\", \"default\": \"Express\", \"enum\": [\"Enterprise\", \"Standard\", \"Standard Edition One\", \"Express (XE)\", \"Workgroup\", \"Lite\"]}, \"sw_database_oracle_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Oracle is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 1521}}','2025-12-06 08:26:12',NULL),(23,80,'DB2','IBM DB2 is a family of database server products developed by IBM. These products all support the relational model, but in recent years some products have been extended to support object-relational features and non-relational structures, in particular XML. (http://en.wikipedia.org/wiki/IBM_DB2)',NULL,'{\"sw_database_db2_version\": {\"title\": \"Version\", \"description\": \"The specific version of DB2.\", \"type\": \"string\"}, \"sw_database_db2_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which DB2 is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5432}, \"sw_database_db2_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 08:26:12',NULL),(26,80,'MongoDB','MongoDB is a cross-platform document-oriented database. Classified as a NoSQL database, MongoDB uses JSON-like documents with dynamic schemas (MongoDB calls the format BSON), making the integration of data in certain types of applications easier and faster. Released under a combination of the GNU Affero General Public License and the Apache License, MongoDB is free and open-source software. (http://en.wikipedia.org/wiki/MongoDB)',NULL,'{\"sw_database_mongodb_version\": {\"title\": \"Version\", \"description\": \"The specific version of MongoDB.\", \"type\": \"string\"}, \"sw_database_mongodb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which MongoDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 27017}, \"sw_database_mongodb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 08:26:12',NULL),(29,80,'Couchbase Server','Couchbase Server, originally known as Membase, is an open source, distributed (shared-nothing architecture) NoSQL document-oriented database that is optimized for interactive applications. These applications must serve many concurrent users by creating, storing, retrieving, aggregating, manipulating and presenting data. In support of these kinds of application needs, Couchbase is designed to provide easy-to-scale key-value or document access with low latency and high sustained throughput. (http://en.wikipedia.org/wiki/Couchbase_Server)',NULL,'{\"sw_database_couchbaseserver_version\": {\"title\": \"Version\", \"description\": \"The specific version of Couchbase Server.\", \"type\": \"string\"}, \"sw_database_couchbaseserver_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Couchbase is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 11211}, \"sw_database_couchbaseserver_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 08:26:12',NULL),(32,80,'Redis','Redis is a data structure server (NoSQL). It is open-source, networked, in-memory, and stores keys with optional durability. The development of Redis has been sponsored by Pivotal Software since May 2013; before that, it was sponsored by VMware. The name Redis means REmote DIctionary Server. (http://en.wikipedia.org/wiki/Redis)',NULL,'{\"sw_database_redis_version\": {\"title\": \"Version\", \"description\": \"The specific version of Redis.\", \"type\": \"string\"}, \"sw_database_redis_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Redis is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 6379}, \"sw_database_redis_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"admin\"}}','2025-12-06 08:26:13',NULL),(35,80,'CouchDB','Apache CouchDB, commonly referred to as CouchDB, is an open source NoSQL database. It is a NoSQL database that uses JSON to store data, JavaScript as its query language using MapReduce, and HTTP for an API. One of its distinguishing features is multi-master replication. CouchDB was first released in 2005 and later became an Apache project in 2008. (http://en.wikipedia.org/wiki/CouchDB)',NULL,'{\"sw_database_couchdb_version\": {\"title\": \"Version\", \"description\": \"The specific version of CouchDB.\", \"type\": \"string\"}, \"sw_database_couchdb_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which CouchDB is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5984}, \"sw_database_couchdb_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(38,80,'Apache Cassandra','Apache Cassandra is an open source distributed NoSQL database management system designed to handle large amounts of data across many commodity servers, providing high availability with no single point of failure. (http://en.wikipedia.org/wiki/Apache_Cassandra)',NULL,'{\"sw_database_cassandra_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache Cassandra.\", \"type\": \"string\"}, \"sw_database_cassandra_listen_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Cassandra is to listen for connections from client applications.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 9160}, \"sw_database_cassandra_admin\": {\"title\": \"Admin User\", \"description\": \"The primary user with privileges to perform administrative operations.\", \"type\": \"string\", \"default\": \"cassandra\"}}','2025-12-06 08:26:13',NULL),(41,80,'HBase','HBase is an open source, non-relational (NoSQL), distributed database modeled after Google\'s BigTable and written in Java. It is developed as part of Apache Software Foundation\'s Apache Hadoop project and runs on top of HDFS (Hadoop Distributed Filesystem), providing BigTable-like capabilities for Hadoop. (http://en.wikipedia.org/wiki/Apache_HBase)',NULL,'{\"sw_database_hbase_version\": {\"title\": \"Version\", \"description\": \"The specific version of HBase.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(44,80,'Hazlecast','In computing, Hazelcast is an in-memory open source software data grid based on Java. By having multiple nodes form a cluster, data is evenly distributed among the nodes. This allows for horizontal scaling both in terms of available storage space and processing power. Backups are also distributed in a similar fashion to other nodes, based on configuration, thereby protecting against single node failure. (http://en.wikipedia.org/wiki/Hazelcast)',NULL,'{\"sw_database_hazlecast_version\": {\"title\": \"Version\", \"description\": \"The specific version of Hazlecast.\", \"type\": \"string\"}, \"sw_database_hazlecast_port\": {\"title\": \"Listen Port\", \"description\": \"Specifies the TCP/IP port or local Unix domain socket file extension on which Hazlecast is to listen for connections between members.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 5701}}','2025-12-06 08:26:13',NULL),(47,83,'PHP','PHP is a server-side scripting language designed for web development but also used as a general-purpose programming language. PHP code can be simply mixed with HTML code, or it can be used in combination with various templating engines and web frameworks. PHP code is usually processed by a PHP interpreter, which is usually implemented as a web server\'s native module or a Common Gateway Interface (CGI) executable. After the PHP code is interpreted and executed, the web server sends resulting output to its client, usually in form of a part of the generated web page – for example, PHP code can generate a web page\'s HTML code, an image, or some other data. PHP has also evolved to include a command-line interface (CLI) capability and can be used in standalone graphical applications. (http://en.wikipedia.org/wiki/PHP)',NULL,'{\"sw_runtime_php_version\": {\"title\": \"Version\", \"description\": \"The specific version of PHP.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(50,83,'Python','Python is a widely used general-purpose, high-level programming language. Its design philosophy emphasizes code readability, and its syntax allows programmers to express concepts in fewer lines of code than would be possible in languages such as C++ or Java. The language provides constructs intended to enable clear programs on both a small and large scale. Python supports multiple programming paradigms, including object-oriented, imperative and functional programming or procedural styles. It features a dynamic type system and automatic memory management and has a large and comprehensive standard library. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_python_version\": {\"title\": \"Version\", \"description\": \"The specific version of python.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(53,83,'Java','Java is a functional computer programming language that is concurrent, class-based, object-oriented, and specifically designed to have as few implementation dependencies as possible. It is intended to let application developers write once, run anywhere (WORA), meaning that code that runs on one platform does not need to be recompiled to run on another. Java applications are typically compiled to bytecode that can run on any Java virtual machine (JVM) regardless of computer architecture. (http://en.wikipedia.org/wiki/Java_(programming_language))',NULL,'{\"sw_runtime_java_version\": {\"title\": \"Version\", \"description\": \"The specific version of Java.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(56,83,'Ruby','Ruby is a dynamic, reflective, object-oriented, general-purpose programming language. It was designed and developed in the mid-1990s by Yukihiro Matsumoto in Japan. According to its authors, Ruby was influenced by Perl, Smalltalk, Eiffel, Ada, and Lisp. It supports multiple programming paradigms, including functional, object-oriented, and imperative. It also has a dynamic type system and automatic memory management. (http://en.wikipedia.org/wiki/Python_(programming_language))',NULL,'{\"sw_runtime_ruby_version\": {\"title\": \"Version\", \"description\": \"The specific version of Ruby.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(59,83,'Perl','Perl is a family of high-level, general-purpose, interpreted, dynamic programming languages. The languages in this family include Perl 5 and Perl 6. Though Perl is not officially an acronym, there are various backronyms in use, the most well-known being Practical Extraction and Reporting Language (http://en.wikipedia.org/wiki/Perl)',NULL,'{\"sw_runtime_perl_version\": {\"title\": \"Version\", \"description\": \"The specific version of Perl.\", \"type\": \"string\"}}','2025-12-06 08:26:13',NULL),(62,86,'Apache HTTP Server','The Apache HTTP Server, colloquially called Apache, is a Web server application notable for playing a key role in the initial growth of the World Wide Web. Apache is developed and maintained by an open community of developers under the auspices of the Apache Software Foundation. Most commonly used on a Unix-like system, the software is available for a wide variety of operating systems, including Unix, FreeBSD, Linux, Solaris, Novell NetWare, OS X, Microsoft Windows, OS/2, TPF, OpenVMS and eComStation. Released under the Apache License, Apache is open-source software. (http://en.wikipedia.org/wiki/Apache_HTTP_Server)',NULL,'{\"sw_webserver_apache_version\": {\"title\": \"Version\", \"description\": \"The specific version of Apache.\", \"type\": \"string\"}, \"sw_webserver_apache_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_apache_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 08:26:13',NULL),(65,86,'Nginx','Nginx (pronounced \'engine-x\') is an open source reverse proxy server for HTTP, HTTPS, SMTP, POP3, and IMAP protocols, as well as a load balancer, HTTP cache, and a web server (origin server). The nginx project started with a strong focus on high concurrency, high performance and low memory usage. It is licensed under the 2-clause BSD-like license and it runs on Linux, BSD variants, Mac OS X, Solaris, AIX, HP-UX, as well as on other *nix flavors. It also has a proof of concept port for Microsoft Windows. (http://en.wikipedia.org/wiki/Nginx)',NULL,'{\"sw_webserver_nginx_version\": {\"title\": \"Version\", \"description\": \"The specific version of Nginx.\", \"type\": \"string\"}, \"sw_webserver_nginx_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_nginx_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 08:26:13',NULL),(68,86,'IIS','Internet Information Services (IIS, formerly Internet Information Server) is an extensible web server created by Microsoft. IIS supports HTTP, HTTPS, FTP, FTPS, SMTP and NNTP. IIS is not turned on by default when Windows is installed. The IIS Manager is accessed through the Microsoft Management Console or Administrative Tools in the Control Panel. (http://en.wikipedia.org/wiki/Internet_Information_Services)',NULL,'{\"sw_webserver_iis_version\": {\"title\": \"Version\", \"description\": \"The specific version of IIS.\", \"type\": \"string\"}, \"sw_webserver_iis_http_port\": {\"title\": \"HTTP Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTP connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 80}, \"sw_webserver_iis_https_port\": {\"title\": \"HTTPS Port\", \"description\": \"The configured TCP/IP port on which the web server listens for incoming HTTPS connections.\", \"type\": \"integer\", \"minimum\": 1, \"maximum\": 65535, \"default\": 443}}','2025-12-06 08:26:13',NULL);
/*!40000 ALTER TABLE `metadef_objects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_properties`
--

DROP TABLE IF EXISTS `metadef_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_properties` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `json_schema` text NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_properties_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_properties_name` (`name`),
  CONSTRAINT `metadef_properties_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=388 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_properties`
--

LOCK TABLES `metadef_properties` WRITE;
/*!40000 ALTER TABLE `metadef_properties` DISABLE KEYS */;
INSERT INTO `metadef_properties` (`id`, `namespace_id`, `name`, `json_schema`, `created_at`, `updated_at`) VALUES (2,2,'InstructionSet','{\"title\": \"Instruction Set\", \"description\": \"Identifies the instruction set of the processor within a processor architecture.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86:i386\", \"x86:i486\", \"x86:i586\", \"x86:i686\", \"x86:64\", \"IA-64:IA-64\", \"AS/400:TIMI\", \"Power:Power_2.03\", \"Power:Power_2.04\", \"Power:Power_2.05\", \"Power:Power_2.06\", \"S/390:ESA/390\", \"S/390:z/Architecture\", \"S/390:z/Architecture_2\", \"PA-RISC:PA-RISC_1.0\", \"PA-RISC:PA-RISC_2.0\", \"ARM:A32\", \"ARM:A64\", \"MIPS:MIPS_I\", \"MIPS:MIPS_II\", \"MIPS:MIPS_III\", \"MIPS:MIPS_IV\", \"MIPS:MIPS_V\", \"MIPS:MIPS32\", \"MIPS64:MIPS64\", \"Alpha:Alpha\", \"SPARC:SPARC_V7\", \"SPARC:SPARC_V8\", \"SPARC:SPARC_V9\", \"SPARC:SPARC_JPS1\", \"SPARC:UltraSPARC2005\", \"SPARC:UltraSPARC2007\", \"68k:68000\", \"68k:68010\", \"68k:68020\", \"68k:68030\", \"68k:68040\", \"68k:68060\"]}','2025-12-06 08:26:05',NULL),(5,2,'ProcessorArchitecture','{\"title\": \"Processor Architecture\", \"description\": \"Identifies the processor architecture of the processor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"IA-64\", \"AS/400\", \"Power\", \"S/390\", \"PA-RISC\", \"ARM\", \"MIPS\", \"Alpha\", \"SPARC\", \"68k\"]}','2025-12-06 08:26:05',NULL),(8,2,'InstructionSetExtensionName','{\"title\": \"Instruction Set Extension\", \"description\": \"Identifies the instruction set extensions of the processor within a processor architecture.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"x86:3DNow\", \"x86:3DNowExt\", \"x86:ABM\", \"x86:AES\", \"x86:AVX\", \"x86:AVX2\", \"x86:BMI\", \"x86:CX16\", \"x86:F16C\", \"x86:FSGSBASE\", \"x86:LWP\", \"x86:MMX\", \"x86:PCLMUL\", \"x86:RDRND\", \"x86:SSE2\", \"x86:SSE3\", \"x86:SSSE3\", \"x86:SSE4A\", \"x86:SSE41\", \"x86:SSE42\", \"x86:FMA3\", \"x86:FMA4\", \"x86:XOP\", \"x86:TBM\", \"x86:VT-d\", \"x86:VT-x\", \"x86:EPT\", \"x86:SVM\", \"PA-RISC:MAX\", \"PA-RISC:MAX2\", \"ARM:DSP\", \"ARM:Jazelle-DBX\", \"ARM:Thumb\", \"ARM:Thumb-2\", \"ARM:ThumbEE)\", \"ARM:VFP\", \"ARM:NEON\", \"ARM:TrustZone\", \"MIPS:MDMX\", \"MIPS:MIPS-3D\", \"Alpha:BWX\", \"Alpha:FIX\", \"Alpha:CIX\", \"Alpha:MVI\"]}}','2025-12-06 08:26:05',NULL),(11,5,'Address','{\"title\": \"Address\", \"description\": \"The address of the resource.\", \"type\": \"string\"}','2025-12-06 08:26:05',NULL),(14,5,'AddressOnParent','{\"title\": \"Address On Parent\", \"description\": \"Describes the address of this resource in the context of the Parent.\", \"type\": \"string\"}','2025-12-06 08:26:05',NULL),(17,5,'AllocationUnits','{\"title\": \"Allocation Units\", \"description\": \"This property specifies the units of allocation used by the Reservation and Limit properties.\", \"type\": \"string\"}','2025-12-06 08:26:05',NULL),(20,5,'AutomaticAllocation','{\"title\": \"Automatic Allocation\", \"description\": \"This property specifies if the resource will be automatically allocated.\", \"type\": \"boolean\"}','2025-12-06 08:26:05',NULL),(23,5,'AutomaticDeallocation','{\"title\": \"Automatic Deallocation\", \"description\": \"This property specifies if the resource will be automatically de-allocated.\", \"type\": \"boolean\"}','2025-12-06 08:26:05',NULL),(26,5,'ConsumerVisibility','{\"title\": \"Consumer Visibility\", \"description\": \"Describes the consumers visibility to the allocated resource.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Passed-Through\", \"Virtualized\", \"Not represented\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 08:26:05',NULL),(29,5,'Limit','{\"title\": \"Limit\", \"description\": \"This property specifies the upper bound, or maximum amount of resource that will be granted for this allocation.\", \"type\": \"string\"}','2025-12-06 08:26:05',NULL),(32,5,'MappingBehavior','{\"title\": \"Mapping Behavior\", \"description\": \"Specifies how this resource maps to underlying resources. If the HostResource array contains any entries, this property reflects how the resource maps to those specific resources.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Not Supported\", \"Dedicated\", \"Soft Affinity\", \"Hard Affinity\", \"DMTF Reserved\", \"Vendor Reserved\"]}','2025-12-06 08:26:05',NULL),(35,5,'OtherResourceType','{\"title\": \"Other Resource Type\", \"description\": \"A string that describes the resource type when a well defined value is not available and ResourceType has the value \'Other\'.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(38,5,'Parent','{\"title\": \"Parent\", \"description\": \"The Parent of the resource.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(41,5,'PoolID','{\"title\": \"Pool ID\", \"description\": \"This property specifies which ResourcePool the resource is currently allocated from, or which ResourcePool the resource will be allocated from when the allocation occurs.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(44,5,'Reservation','{\"title\": \"Reservation\", \"description\": \"This property specifies the amount of resource guaranteed to be available for this allocation.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(47,5,'ResourceSubType','{\"title\": \"Resource Sub Type\", \"description\": \"A string describing an implementation specific sub-type for this resource.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(50,5,'ResourceType','{\"title\": \"Resource Type\", \"description\": \"The type of resource this allocation setting represents.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Other\", \"Computer System\", \"Processor\", \"Memory\", \"IDE Controller\", \"Parallel SCSI HBA\", \"FC HBA\", \"iSCSI HBA\", \"IB HCA\", \"Ethernet Adapter\", \"Other Network Adapter\", \"I/O Slot\", \"I/O Device\", \"Floppy Drive\", \"CD Drive\", \"DVD drive\", \"Disk Drive\", \"Tape Drive\", \"Storage Extent\", \"Other storage device\", \"Serial port\", \"Parallel port\", \"USB Controller\", \"Graphics controller\", \"IEEE 1394 Controller\", \"Partitionable Unit\", \"Base Partitionable Unit\", \"Power\", \"Cooling Capacity\", \"Ethernet Switch Port\", \"Logical Disk\", \"Storage Volume\", \"Ethernet Connection\", \"DMTF reserved\", \"Vendor Reserved\"]}','2025-12-06 08:26:06',NULL),(53,5,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"This property specifies the quantity of resources presented to the consumer.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(56,5,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(59,5,'Weight','{\"title\": \"Weight\", \"description\": \"This property specifies a relative priority for this allocation in relation to other allocations from the same ResourcePool.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(62,5,'Connection','{\"title\": \"Connection\", \"description\": \"The thing to which this resource is connected.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(65,5,'HostResource','{\"title\": \"Host Resource\", \"description\": \"This property exposes specific assignment of resources.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(68,8,'Access','{\"title\": \"Access\", \"description\": \"Access describes whether the allocated storage extent is 1 (readable), 2 (writeable), or 3 (both).\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Readable\", \"Writeable\", \"Read/Write Supported\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(71,8,'HostExtentName','{\"title\": \"Host Extent Name\", \"description\": \"A unique identifier for the host extent.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(74,8,'HostExtentNameFormat','{\"title\": \"Host Extent Name Format\", \"description\": \"The HostExtentNameFormat property identifies the format that is used for the value of the HostExtentName property.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"SNVM\", \"NAA\", \"EUI64\", \"T10VID\", \"OS Device Name\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(77,8,'HostExtentNameNamespace','{\"title\": \"Host Extent Name Namespace\", \"description\": \"If the host extent is a SCSI volume, then the preferred source for SCSI volume names is SCSI VPD Page 83 responses.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Unknown\", \"Other\", \"VPD83Type3\", \"VPD83Type2\", \"VPD83Type1\", \"VPD80\", \"NodeWWN\", \"SNVM\", \"OS Device Namespace\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(80,8,'HostExtentStartingAddress','{\"title\": \"Host Extent Starting Address\", \"description\": \"The HostExtentStartingAddress property identifies the starting address on the host storage extent identified by the value of the HostExtentName property that is used for the allocation of the virtual storage extent.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(83,8,'HostResourceBlockSize','{\"title\": \"Host Resource Block Size\", \"description\": \"Size in bytes of the blocks that are allocated at the host as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(86,8,'Limit','{\"title\": \"Limit\", \"description\": \"The maximum amount of blocks that will be granted for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(89,8,'OtherHostExtentNameFormat','{\"title\": \"Other Host Extent Name Format\", \"description\": \"A string describing the format of the HostExtentName property if the value of the HostExtentNameFormat property is 1 (Other).\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(92,8,'OtherHostExtentNameNamespace','{\"title\": \"Other Host Extent Name Namespace\", \"description\": \"A string describing the namespace of the HostExtentName property if the value of the HostExtentNameNamespace matches 1 (Other).\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(95,8,'Reservation','{\"title\": \"Reservation\", \"description\": \"The amount of blocks that are guaranteed to be available for this storage resource allocation at the host.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(98,8,'VirtualQuantity','{\"title\": \"Virtual Quantity\", \"description\": \"Number of blocks that are presented to the consumer.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(101,8,'VirtualQuantityUnits','{\"title\": \"Virtual Quantity Units\", \"description\": \"This property specifies the units used by the VirtualQuantity property.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(104,8,'VirtualResourceBlockSize','{\"title\": \"Virtual Resource Block Size\", \"description\": \"Size in bytes of the blocks that are presented to the consumer as the result of this storage resource allocation or storage resource allocation request.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(107,11,'AutomaticRecoveryAction','{\"title\": \"Automatic Recovery Action\", \"description\": \"Action to take for the virtual system when the software executed by the virtual system fails.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart\", \"Revert to snapshot\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(110,11,'AutomaticShutdownAction','{\"title\": \"Automatic Shutdown Action\", \"description\": \"Action to take for the virtual system when the host is shut down.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Turn Off\", \"Save state\", \"Shutdown\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(113,11,'AutomaticStartupAction','{\"title\": \"Automatic Startup Action\", \"description\": \"Action to take for the virtual system when the host is started.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"None\", \"Restart if previously active\", \"Always startup\", \"DMTF Reserved\"]}','2025-12-06 08:26:06',NULL),(116,11,'AutomaticStartupActionDelay','{\"title\": \"Automatic Startup Action Delay\", \"description\": \"Delay applicable to startup action.\", \"type\": \"string\"}','2025-12-06 08:26:06',NULL),(119,11,'AutomaticStartupActionSequenceNumber','{\"title\": \"Automatic Startup Action Sequence Number\", \"description\": \"Number indicating the relative sequence of virtual system activation when the host system is started.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(122,11,'ConfigurationDataRoot','{\"title\": \"Configuration Data Root\", \"description\": \"Filepath of a directory where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(125,11,'ConfigurationFile','{\"title\": \"Configuration File\", \"description\": \"Filepath of a file where information about the virtual system configuration is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(128,11,'ConfigurationID','{\"title\": \"Configuration ID\", \"description\": \"Unique id of the virtual system configuration.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(131,11,'CreationTime','{\"title\": \"Creation Time\", \"description\": \"Time when the virtual system configuration was created.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(134,11,'LogDataRoot','{\"title\": \"Log Data Root\", \"description\": \"Filepath of a directory where log information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(137,11,'RecoveryFile','{\"title\": \"Recovery File\", \"description\": \"Filepath of a file where recovery relateded information of the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(140,11,'SnapshotDataRoot','{\"title\": \"Snapshot Data Root\", \"description\": \"Filepath of a directory where information about virtual system snapshots is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(143,11,'SuspendDataRoot','{\"title\": \"Suspend Data Root\", \"description\": \"Filepath of a directory where suspend related information about the virtual system is stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(146,11,'SwapFileDataRoot','{\"title\": \"Swap File Data Root\", \"description\": \"Filepath of a directory where swapfiles of the virtual system are stored.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(149,11,'VirtualSystemIdentifier','{\"title\": \"Virtual System Identifier\", \"description\": \"VirtualSystemIdentifier shall reflect a unique name for the system as it is used within the virtualization platform.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(152,11,'VirtualSystemType','{\"title\": \"Virtual System Type\", \"description\": \"VirtualSystemType shall reflect a particular type of virtual system.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(155,11,'Notes','{\"title\": \"Notes\", \"description\": \"End-user supplied notes that are related to the virtual system.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(158,14,'disk_allocation_ratio','{\"title\": \"Disk Subscription Ratio\", \"description\": \"Allows the host to be under and over subscribed for the amount of disk space requested for an instance. A ratio greater than 1.0 allows for over subscription (hosts may have less usable disk space than requested). A ratio less than 1.0 allows for under subscription.\", \"type\": \"number\", \"readonly\": false}','2025-12-06 08:26:07',NULL),(161,17,'max_io_ops_per_host','{\"title\": \"Maximum IO Operations per Host\", \"description\": \"Prevents hosts in the aggregate that have this many or more instances currently in build, resize, snapshot, migrate, rescue or unshelve to be scheduled for new instances.\", \"type\": \"integer\", \"readonly\": false, \"default\": 8, \"minimum\": 1}','2025-12-06 08:26:07',NULL),(164,20,'max_instances_per_host','{\"title\": \"Max Instances Per Host\", \"description\": \"Maximum number of instances allowed to run on a host in the aggregate.\", \"type\": \"integer\", \"readonly\": false, \"minimum\": 0}','2025-12-06 08:26:07',NULL),(167,23,'cpu_policy','{\"title\": \"CPU Pinning policy\", \"description\": \"Type of CPU pinning policy.\", \"type\": \"string\", \"enum\": [\"shared\", \"dedicated\"]}','2025-12-06 08:26:07',NULL),(170,23,'cpu_thread_policy','{\"title\": \"CPU Thread Pinning Policy.\", \"description\": \"Type of CPU thread pinning policy.\", \"type\": \"string\", \"enum\": [\"isolate\", \"prefer\", \"require\"]}','2025-12-06 08:26:07',NULL),(173,26,'mem_page_size','{\"title\": \"Size of memory page\", \"description\": \"Page size to be used for Guest memory backing. Value can be specified as <number><unit> (i.e.: 2MB, 1GB) or \'any\', \'small\', \'large\'. If this property is set in Image metadata then only \'any\' and \'large\' values are accepted in Flavor metadata by Nova API.\", \"type\": \"string\"}','2025-12-06 08:26:07',NULL),(176,29,'os_shutdown_timeout','{\"title\": \"Shutdown timeout\", \"description\": \"By default, guests will be given 60 seconds to perform a graceful shutdown. After that, the VM is powered off.  This property allows overriding the amount of time (unit: seconds) to allow a guest OS to cleanly shut down before power off. A value of 0 (zero) means the guest will be powered off immediately with no opportunity for guest OS clean-up.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 08:26:08',NULL),(179,32,'cpu_info:vendor','{\"title\": \"Vendor\", \"description\": \"Specifies the CPU manufacturer.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Intel\", \"AMD\"]}','2025-12-06 08:26:08',NULL),(182,32,'cpu_info:model','{\"title\": \"Model\", \"description\": \"Specifies the CPU model. Use this property to ensure that your vm runs on a specific cpu model.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"Conroe\", \"Core2Duo\", \"Penryn\", \"Nehalem\", \"Westmere\", \"SandyBridge\", \"IvyBridge\", \"Haswell\", \"Broadwell\", \"Delhi\", \"Seoul\", \"Abu Dhabi\", \"Interlagos\", \"Kabini\", \"Valencia\", \"Zurich\", \"Budapest\", \"Barcelona\", \"Suzuka\", \"Shanghai\", \"Istanbul\", \"Lisbon\", \"Magny-Cours\", \"Valencia\", \"Cortex-A57\", \"Cortex-A53\", \"Cortex-A12\", \"Cortex-A17\", \"Cortex-A15\", \"Coretx-A7\", \"X-Gene\"]}','2025-12-06 08:26:08',NULL),(185,32,'cpu_info:arch','{\"title\": \"Architecture\", \"description\": \"Specifies the CPU architecture. Use this property to specify the architecture supported by the hypervisor.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"x86\", \"x86_64\", \"i686\", \"ia64\", \"ARMv8-A\", \"ARMv7-A\"]}','2025-12-06 08:26:08',NULL),(188,32,'cpu_info:topology:cores','{\"title\": \"cores\", \"description\": \"Number of cores.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 08:26:08',NULL),(191,32,'cpu_info:topology:threads','{\"title\": \"threads\", \"description\": \"Number of threads.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 08:26:08',NULL),(194,32,'cpu_info:topology:sockets','{\"title\": \"sockets\", \"description\": \"Number of sockets.\", \"type\": \"integer\", \"readonly\": false, \"default\": 1}','2025-12-06 08:26:08',NULL),(197,32,'cpu_info:features','{\"title\": \"Features\", \"description\": \"Specifies CPU flags/features. Using this property you can specify the required set of instructions supported by a vm.\", \"operators\": [\"<or>\", \"<all-in>\"], \"type\": \"array\", \"items\": {\"type\": \"string\", \"enum\": [\"fpu\", \"vme\", \"de\", \"pse\", \"tsc\", \"msr\", \"pae\", \"mce\", \"cx8\", \"apic\", \"sep\", \"mtrr\", \"pge\", \"mca\", \"cmov\", \"pat\", \"pse36\", \"pn\", \"clflush\", \"dts\", \"acpi\", \"mmx\", \"fxsr\", \"sse\", \"sse2\", \"ss\", \"ht\", \"tm\", \"ia64\", \"pbe\", \"syscall\", \"mp\", \"nx\", \"mmxext\", \"fxsr_opt\", \"pdpe1gb\", \"rdtscp\", \"lm\", \"3dnowext\", \"3dnow\", \"arch_perfmon\", \"pebs\", \"bts\", \"rep_good\", \"nopl\", \"xtopology\", \"tsc_reliable\", \"nonstop_tsc\", \"extd_apicid\", \"amd_dcm\", \"aperfmperf\", \"eagerfpu\", \"nonstop_tsc_s3\", \"pni\", \"pclmulqdq\", \"dtes64\", \"monitor\", \"ds_cpl\", \"vmx\", \"smx\", \"est\", \"tm2\", \"ssse3\", \"cid\", \"fma\", \"cx16\", \"xtpr\", \"pdcm\", \"pcid\", \"dca\", \"sse4_1\", \"sse4_2\", \"x2apic\", \"movbe\", \"popcnt\", \"tsc_deadline_timer\", \"aes\", \"xsave\", \"avx\", \"f16c\", \"rdrand\", \"hypervisor\", \"rng\", \"rng_en\", \"ace\", \"ace_en\", \"ace2\", \"ace2_en\", \"phe\", \"phe_en\", \"pmm\", \"pmm_en\", \"lahf_lm\", \"cmp_legacy\", \"svm\", \"extapic\", \"cr8_legacy\", \"abm\", \"sse4a\", \"misalignsse\", \"3dnowprefetch\", \"osvw\", \"ibs\", \"xop\", \"skinit\", \"wdt\", \"lwp\", \"fma4\", \"tce\", \"nodeid_msr\", \"tbm\", \"topoext\", \"perfctr_core\", \"perfctr_nb\", \"bpext\", \"perfctr_l2\", \"mwaitx\", \"ida\", \"arat\", \"cpb\", \"epb\", \"pln\", \"pts\", \"dtherm\", \"hw_pstate\", \"proc_feedback\", \"hwp\", \"hwp_notify\", \"hwp_act_window\", \"hwp_epp\", \"hwp_pkg_req\", \"intel_pt\", \"tpr_shadow\", \"vnmi\", \"flexpriority\", \"ept\", \"vpid\", \"npt\", \"lbrv\", \"svm_lock\", \"nrip_save\", \"tsc_scale\", \"vmcb_clean\", \"flushbyasid\", \"decodeassists\", \"pausefilter\", \"pfthreshold\", \"vmmcall\", \"fsgsbase\", \"tsc_adjust\", \"bmi1\", \"hle\", \"avx2\", \"smep\", \"bmi2\", \"erms\", \"invpcid\", \"rtm\", \"cqm\", \"mpx\", \"avx512f\", \"rdseed\", \"adx\", \"smap\", \"pcommit\", \"clflushopt\", \"clwb\", \"avx512pf\", \"avx512er\", \"avx512cd\", \"sha_ni\", \"xsaveopt\", \"xsavec\", \"xgetbv1\", \"xsaves\", \"cqm_llc\", \"cqm_occup_llc\", \"clzero\"]}}','2025-12-06 08:26:08',NULL),(200,35,'hypervisor_type','{\"title\": \"Hypervisor Type\", \"description\": \"Hypervisor type required by the image. Used with the ImagePropertiesFilter. \\n\\n Baremetal - physical provisioning. hyperv - Microsoft\\u00ae hyperv. KVM - Kernel-based Virtual Machine. LXC - Linux Containers (through libvirt). powervm - IBM\\u00ae PowerVM\\u00ae. QEMU - Quick EMUlator. UML - User Mode Linux. vmware - VMware\\u00ae vsphere. VZ - Virtuozzo OS Containers and Virtual Machines (through libvirt). For more information, see: https://docs.openstack.org/nova/latest/admin/configuration/hypervisors.html\", \"type\": \"string\", \"enum\": [\"baremetal\", \"hyperv\", \"kvm\", \"lxc\", \"powervm\", \"qemu\", \"uml\", \"vmware\", \"vz\", \"xen\"]}','2025-12-06 08:26:08',NULL),(203,35,'vm_mode','{\"title\": \"VM Mode\", \"description\": \"The virtual machine mode. This represents the host/guest ABI (application binary interface) used for the virtual machine. Used with the ImagePropertiesFilter. \\n\\n hvm \\u2014 Fully virtualized - This is the virtual machine mode (vm_mode) used by QEMU and KVM. \\n\\n xen - Xen 3.0 paravirtualized. \\n\\n uml \\u2014 User Mode Linux paravirtualized. \\n\\n exe \\u2014 Executables in containers. This is the mode used by LXC.\", \"type\": \"string\", \"enum\": [\"hvm\", \"xen\", \"uml\", \"exe\"]}','2025-12-06 08:26:08',NULL),(206,38,'img_config_drive','{\"title\": \"Config Drive\", \"description\": \"This property specifies whether or not Nova should use a config drive when booting the image. Mandatory means that Nova will always use a config drive when booting the image. OpenStack can be configured to write metadata to a special configuration drive that will be attached to the instance when it boots. The instance can retrieve any information from the config drive. One use case for the config drive is to pass network configuration information to the instance. See also: http://docs.openstack.org/user-guide/cli_config_drive.html\", \"type\": \"string\", \"enum\": [\"optional\", \"mandatory\"]}','2025-12-06 08:26:09',NULL),(209,38,'os_require_quiesce','{\"title\": \"Require Quiescent File system\", \"description\": \"This property specifies whether or not the filesystem must be quiesced during snapshot processing. For volume backed and image backed snapshots, yes means that snapshotting is aborted when quiescing fails, whereas, no means quiescing will be skipped and snapshot processing will continue after the quiesce failure.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 08:26:09',NULL),(212,41,'hw_cdrom_bus','{\"title\": \"CD-ROM Bus\", \"description\": \"Specifies the type of disk controller to attach CD-ROM devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 08:26:09',NULL),(215,41,'hw_disk_bus','{\"title\": \"Disk Bus\", \"description\": \"Specifies the type of disk controller to attach disk devices to.\", \"type\": \"string\", \"enum\": [\"scsi\", \"virtio\", \"uml\", \"xen\", \"ide\", \"usb\", \"fdc\", \"sata\", \"lxc\"]}','2025-12-06 08:26:09',NULL),(218,41,'hw_firmware_type','{\"title\": \"Firmware Type\", \"description\": \"Specifies whether the image should be booted with a legacy BIOS or with UEFI.\", \"type\": \"string\", \"enum\": [\"bios\", \"uefi\"]}','2025-12-06 08:26:09',NULL),(221,41,'hw_rng_model','{\"title\": \"Random Number Generator Device\", \"description\": \"Adds a random-number generator device to the image\'s instances. The cloud administrator can enable and control device behavior by configuring the instance\'s flavor. By default: The generator device is disabled. /dev/random is used as the default entropy source. To specify a physical HW RNG device, use the following option in the nova.conf file: rng_dev_path=/dev/hwrng\", \"type\": \"string\", \"default\": \"virtio\"}','2025-12-06 08:26:09',NULL),(224,41,'hw_machine_type','{\"title\": \"Machine Type\", \"description\": \"Enables booting an ARM system using the specified machine type. By default, if an ARM image is used and its type is not specified, Compute uses vexpress-a15 (for ARMv7) or virt (for AArch64) machine types. Valid types can be viewed by using the virsh capabilities command (machine types are displayed in the machine tag).\", \"type\": \"string\"}','2025-12-06 08:26:09',NULL),(227,41,'hw_scsi_model','{\"title\": \"SCSI Model\", \"description\": \"Enables the use of VirtIO SCSI (virtio-scsi) to provide block device access for compute instances; by default, instances use VirtIO Block (virtio-blk). VirtIO SCSI is a para-virtualized SCSI controller device that provides improved scalability and performance, and supports advanced SCSI hardware.\", \"type\": \"string\", \"default\": \"virtio-scsi\"}','2025-12-06 08:26:09',NULL),(230,41,'hw_video_model','{\"title\": \"Video Model\", \"description\": \"The graphic device model presented to the guest. hw_video_model=none disables the graphics device in the guest and should generally be used when using gpu passthrough.\", \"type\": \"string\", \"enum\": [\"vga\", \"cirrus\", \"vmvga\", \"xen\", \"qxl\", \"virtio\", \"gop\", \"none\"]}','2025-12-06 08:26:09',NULL),(233,41,'hw_video_ram','{\"title\": \"Max Video Ram\", \"description\": \"Maximum RAM (unit: MB) for the video image. Used only if a hw_video:ram_max_mb value has been set in the flavor\'s extra_specs and that value is higher than the value set in hw_video_ram.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 08:26:09',NULL),(236,41,'os_command_line','{\"title\": \"Kernel Command Line\", \"description\": \"The kernel command line to be used by the libvirt driver, instead of the default. For linux containers (LXC), the value is used as arguments for initialization. This key is valid only for Amazon kernel, ramdisk, or machine images (aki, ari, or ami).\", \"type\": \"string\"}','2025-12-06 08:26:09',NULL),(239,41,'os_type','{\"title\": \"OS Type\", \"description\": \"The operating system installed on the image. The libvirt driver contains logic that takes different actions depending on the value of the os_type parameter of the image. For example, for os_type=windows images, it creates a FAT32-based swap partition instead of a Linux swap partition, and it limits the injected host name to less than 16 characters.\", \"type\": \"string\", \"enum\": [\"linux\", \"windows\"]}','2025-12-06 08:26:09',NULL),(242,41,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor configuration. libvirt driver options: KVM and QEMU: e1000, ne2k_pci, pcnet, rtl8139, spapr-vlan, and virtio. Xen: e1000, netfront, ne2k_pci, pcnet, and rtl8139.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"ne2k_pci\", \"netfront\", \"pcnet\", \"rtl8139\", \"spapr-vlan\", \"virtio\"]}','2025-12-06 08:26:09',NULL),(245,41,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 08:26:09',NULL),(248,41,'hw_pmu','{\"title\": \"Virtual Performance Monitoring Unit\", \"description\": \"Controls emulation of a vPMU in the guest. To reduce latency in realtime workloads disable the vPMU by setting hw_pmu=false\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 08:26:09',NULL),(251,41,'hw_qemu_guest_agent','{\"title\": \"QEMU Guest Agent\", \"description\": \"This is a background process which helps management applications execute guest OS level commands. For example, freezing and thawing filesystems, entering suspend. However, guest agent (GA) is not bullet proof, and hostile guest OS can send spurious replies.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 08:26:09',NULL),(254,41,'hw_pointer_model','{\"title\": \"Pointer Model\", \"description\": \"Input devices allow interaction with a graphical framebuffer. For example to provide a graphic tablet for absolute cursor movement. Currently only supported by the KVM/QEMU hypervisor configuration and VNC or SPICE consoles must be enabled.\", \"type\": \"string\", \"enum\": [\"usbtablet\"]}','2025-12-06 08:26:09',NULL),(257,41,'img_hide_hypervisor_id','{\"title\": \"Hide hypervisor id\", \"description\": \"Enables hiding the host hypervisor signature in the guest OS.\", \"type\": \"string\", \"enum\": [\"yes\", \"no\"]}','2025-12-06 08:26:09',NULL),(260,44,'serial_port_count','{\"title\": \"Serial Port Count\", \"description\": \"Specifies the count of serial ports that should be provided. If hw:serial_port_count is not set in the flavor\'s extra_specs, then any count is permitted. If hw:serial_port_count is set, then this provides the default serial port count. It is permitted to override the default serial port count, but only with a lower value.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 08:26:10',NULL),(263,44,'boot_menu','{\"title\": \"Boot Menu\", \"description\": \"If true, enables the BIOS bootmenu. In cases where both the image metadata and Extra Spec are set, the Extra Spec setting is used. This allows for flexibility in setting/overriding the default behavior as needed.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 08:26:10',NULL),(266,44,'mem_encryption','{\"title\": \"Hardware Memory Encryption\", \"description\": \"Enables encryption of guest memory at the hardware level, if there are compute hosts available which support this. See https://docs.openstack.org/nova/latest/admin/configuration/hypervisor-kvm.html#amd-sev-secure-encrypted-virtualization for details.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 08:26:10',NULL),(269,50,'hw_rng:allowed','{\"title\": \"Random Number Generator Allowed\", \"description\": \"\", \"type\": \"boolean\"}','2025-12-06 08:26:10',NULL),(272,50,'hw_rng:rate_bytes','{\"title\": \"Random number generator limits.\", \"description\": \"Allowed amount of bytes that the guest can read from the host\'s entropy per period.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(275,50,'hw_rng:rate_period','{\"title\": \"Random number generator read period.\", \"description\": \"Duration of the read period in milliseconds.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(278,53,'cpu_sockets','{\"title\": \"vCPU Sockets\", \"description\": \"Preferred number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(281,53,'cpu_cores','{\"title\": \"vCPU Cores\", \"description\": \"Preferred number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(284,53,'cpu_threads','{\"title\": \" vCPU Threads\", \"description\": \"Preferred number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(287,53,'cpu_max_sockets','{\"title\": \"Max vCPU Sockets\", \"description\": \"Maximum number of sockets to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(290,53,'cpu_max_cores','{\"title\": \"Max vCPU Cores\", \"description\": \"Maximum number of cores to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(293,53,'cpu_max_threads','{\"title\": \"Max vCPU Threads\", \"description\": \"Maximum number of threads to expose to the guest.\", \"type\": \"integer\"}','2025-12-06 08:26:10',NULL),(296,56,'vmware:hw_version','{\"title\": \"VMware Hardware Version\", \"description\": \"Specifies the hardware version VMware uses to create images. If the hardware version needs to be compatible with a cluster version, for backward compatibility or other circumstances, the vmware:hw_version key specifies a virtual machine hardware version. In the event that a cluster has mixed host version types, the key will enable the vCenter to place the cluster on the correct host.\", \"type\": \"string\", \"enum\": [\"vmx-13\", \"vmx-11\", \"vmx-10\", \"vmx-09\", \"vmx-08\", \"vmx-07\", \"vmx-04\", \"vmx-03\"]}','2025-12-06 08:26:11',NULL),(299,56,'vmware:storage_policy','{\"title\": \"VMware Storage Policy\", \"description\": \"Specifies the storage policy to be applied for newly created instance. If not provided, the default storage policy specified in config file will be used. If Storage Policy Based Management (SPBM) is not enabled in config file, this value won\'t be used.\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(302,59,'quota:cpu_limit','{\"title\": \"Quota: CPU Limit\", \"description\": \"Specifies the upper limit for CPU allocation in MHz. This parameter ensures that a machine never uses more than the defined amount of CPU time. It can be used to enforce a limit on the machine\'s CPU performance. The value should be a numerical value in MHz. If zero is supplied then the cpu_limit is unlimited.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 08:26:11',NULL),(305,59,'quota:cpu_reservation','{\"title\": \"Quota: CPU Reservation Limit\", \"description\": \"Specifies the guaranteed minimum CPU reservation in MHz. This means that if needed, the machine will definitely get allocated the reserved amount of CPU cycles. The value should be a numerical value in MHz.\", \"type\": \"integer\", \"minimum\": 0}','2025-12-06 08:26:11',NULL),(308,62,'img_linked_clone','{\"title\": \"Linked Clone\", \"description\": \"By default, the VMware compute driver creates linked clones when possible (though this can be turned off by the operator). You can use this image property on a per-image basis to control whether virtual machines booted from the image are treated as full clones (value: false) or linked clones (value: true). Please refer to VMware documentation for information about full vs. linked clones.\", \"type\": \"boolean\"}','2025-12-06 08:26:11',NULL),(311,62,'vmware_adaptertype','{\"title\": \"Disk Adapter Type\", \"description\": \"The virtual SCSI or IDE controller used by the hypervisor.\", \"type\": \"string\", \"enum\": [\"lsiLogic\", \"lsiLogicsas\", \"paraVirtual\", \"busLogic\", \"ide\"], \"default\": \"lsiLogic\"}','2025-12-06 08:26:11',NULL),(314,62,'vmware_disktype','{\"title\": \"Disk Provisioning Type\", \"description\": \"When performing operations such as creating a virtual disk, cloning, or migrating, the disk provisioning type may be specified. Please refer to VMware documentation for more.\", \"type\": \"string\", \"enum\": [\"streamOptimized\", \"sparse\", \"preallocated\"], \"default\": \"preallocated\"}','2025-12-06 08:26:11',NULL),(317,62,'vmware_ostype','{\"title\": \"OS Type\", \"description\": \"A VMware GuestID which describes the operating system installed in the image. This value is passed to the hypervisor when creating a virtual machine. If not specified, the key defaults to otherGuest. See thinkvirt.com.\", \"type\": \"string\", \"enum\": [\"asianux3_64Guest\", \"asianux3Guest\", \"asianux4_64Guest\", \"asianux4Guest\", \"asianux5_64Guest\", \"asianux7_64Guest\", \"centos64Guest\", \"centosGuest\", \"centos6Guest\", \"centos6_64Guest\", \"centos7_64Guest\", \"coreos64Guest\", \"darwin10_64Guest\", \"darwin10Guest\", \"darwin11_64Guest\", \"darwin11Guest\", \"darwin12_64Guest\", \"darwin13_64Guest\", \"darwin14_64Guest\", \"darwin15_64Guest\", \"darwin16_64Guest\", \"darwin64Guest\", \"darwinGuest\", \"debian4_64Guest\", \"debian4Guest\", \"debian5_64Guest\", \"debian5Guest\", \"debian6_64Guest\", \"debian6Guest\", \"debian7_64Guest\", \"debian7Guest\", \"debian8_64Guest\", \"debian8Guest\", \"debian9_64Guest\", \"debian9Guest\", \"debian10_64Guest\", \"debian10Guest\", \"dosGuest\", \"eComStation2Guest\", \"eComStationGuest\", \"fedora64Guest\", \"fedoraGuest\", \"freebsd64Guest\", \"freebsdGuest\", \"genericLinuxGuest\", \"mandrakeGuest\", \"mandriva64Guest\", \"mandrivaGuest\", \"netware4Guest\", \"netware5Guest\", \"netware6Guest\", \"nld9Guest\", \"oesGuest\", \"openServer5Guest\", \"openServer6Guest\", \"opensuse64Guest\", \"opensuseGuest\", \"oracleLinux64Guest\", \"oracleLinuxGuest\", \"oracleLinux6Guest\", \"oracleLinux6_64Guest\", \"oracleLinux7_64Guest\", \"os2Guest\", \"other24xLinux64Guest\", \"other24xLinuxGuest\", \"other26xLinux64Guest\", \"other26xLinuxGuest\", \"other3xLinux64Guest\", \"other3xLinuxGuest\", \"otherGuest\", \"otherGuest64\", \"otherLinux64Guest\", \"otherLinuxGuest\", \"redhatGuest\", \"rhel2Guest\", \"rhel3_64Guest\", \"rhel3Guest\", \"rhel4_64Guest\", \"rhel4Guest\", \"rhel5_64Guest\", \"rhel5Guest\", \"rhel6_64Guest\", \"rhel6Guest\", \"rhel7_64Guest\", \"rhel7Guest\", \"sjdsGuest\", \"sles10_64Guest\", \"sles10Guest\", \"sles11_64Guest\", \"sles11Guest\", \"sles12_64Guest\", \"sles12Guest\", \"sles64Guest\", \"slesGuest\", \"solaris10_64Guest\", \"solaris10Guest\", \"solaris11_64Guest\", \"solaris6Guest\", \"solaris7Guest\", \"solaris8Guest\", \"solaris9Guest\", \"turboLinux64Guest\", \"turboLinuxGuest\", \"ubuntu64Guest\", \"ubuntuGuest\", \"unixWare7Guest\", \"vmkernel5Guest\", \"vmkernel6Guest\", \"vmkernel65Guest\", \"vmkernelGuest\", \"vmwarePhoton64Guest\", \"win2000AdvServGuest\", \"win2000ProGuest\", \"win2000ServGuest\", \"win31Guest\", \"win95Guest\", \"win98Guest\", \"windows7_64Guest\", \"windows7Guest\", \"windows7Server64Guest\", \"windows8_64Guest\", \"windows8Guest\", \"windows8Server64Guest\", \"windows9_64Guest\", \"windows9Guest\", \"windows9Server64Guest\", \"windowsHyperVGuest\", \"winLonghorn64Guest\", \"winLonghornGuest\", \"winMeGuest\", \"winNetBusinessGuest\", \"winNetDatacenter64Guest\", \"winNetDatacenterGuest\", \"winNetEnterprise64Guest\", \"winNetEnterpriseGuest\", \"winNetStandard64Guest\", \"winNetStandardGuest\", \"winNetWebGuest\", \"winNTGuest\", \"winVista64Guest\", \"winVistaGuest\", \"winXPHomeGuest\", \"winXPPro64Guest\", \"winXPProGuest\"], \"default\": \"otherGuest\"}','2025-12-06 08:26:11',NULL),(320,62,'hw_vif_model','{\"title\": \"Virtual Network Interface\", \"description\": \"Specifies the model of virtual network interface device to use. The valid options depend on the hypervisor. VMware driver supported options: e1000, e1000e, VirtualE1000, VirtualE1000e, VirtualPCNet32, VirtualSriovEthernetCard, and VirtualVmxnet.\", \"type\": \"string\", \"enum\": [\"e1000\", \"e1000e\", \"VirtualE1000\", \"VirtualE1000e\", \"VirtualPCNet32\", \"VirtualSriovEthernetCard\", \"VirtualVmxnet\", \"VirtualVmxnet3\"], \"default\": \"e1000\"}','2025-12-06 08:26:11',NULL),(323,62,'hw_vif_multiqueue_enabled','{\"title\": \"Multiqueue Enabled\", \"description\": \"If true, this enables the virtio-net multiqueue feature. In this case, the driver sets the number of queues equal to the number of guest vCPUs. This makes the network performance scale across a number of vCPUs.\", \"type\": \"string\", \"enum\": [\"true\", \"false\"]}','2025-12-06 08:26:11',NULL),(326,65,'watchdog_action','{\"title\": \"Watchdog Action\", \"description\": \"For the libvirt driver, you can enable and set the behavior of a virtual hardware watchdog device for each flavor. Watchdog devices keep an eye on the guest server, and carry out the configured action, if the server hangs. The watchdog uses the i6300esb device (emulating a PCI Intel 6300ESB). If hw_watchdog_action is not specified, the watchdog is disabled. Watchdog behavior set using a specific image\'s properties will override behavior set using flavors.\", \"type\": \"string\", \"enum\": [\"disabled\", \"reset\", \"poweroff\", \"pause\", \"none\"]}','2025-12-06 08:26:11',NULL),(329,68,'auto_disk_config','{\"title\": \"Disk Adapter Type\", \"description\": \"If true, the root partition on the disk is automatically resized before the instance boots. This value is only taken into account by the Compute service when using a Xen-based hypervisor with the XenAPI driver. The Compute service will only attempt to resize if there is a single partition on the image, and only if the partition is in ext3 or ext4 format.\", \"type\": \"boolean\"}','2025-12-06 08:26:11',NULL),(332,71,'kernel_id','{\"title\": \"Kernel ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the kernel when booting an AMI-style image.\"}','2025-12-06 08:26:11',NULL),(335,71,'ramdisk_id','{\"title\": \"Ramdisk ID\", \"type\": \"string\", \"pattern\": \"^([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}$\", \"description\": \"ID of image stored in Glance that should be used as the ramdisk when booting an AMI-style image.\"}','2025-12-06 08:26:11',NULL),(338,71,'instance_uuid','{\"title\": \"Instance ID\", \"type\": \"string\", \"description\": \"Metadata which can be used to record which instance this image is associated with. (Informational only, does not create an instance snapshot.)\"}','2025-12-06 08:26:11',NULL),(341,71,'architecture','{\"title\": \"CPU Architecture\", \"description\": \"The CPU architecture that must be supported by the hypervisor. For example, x86_64, arm, or ppc64. Run uname -m to get the architecture of a machine. We strongly recommend using the architecture data vocabulary defined by the libosinfo project for this purpose.\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(344,71,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(347,71,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(350,71,'description','{\"title\": \"Image description\", \"description\": \"A human-readable string describing this image.\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(353,71,'cinder_encryption_key_id','{\"title\": \"Cinder Encryption Key ID\", \"description\": \"Identifier in the OpenStack Key Management Service for the encryption key for the Block Storage Service to use when mounting a volume created from this image\", \"type\": \"string\"}','2025-12-06 08:26:11',NULL),(356,71,'cinder_encryption_key_deletion_policy','{\"title\": \"Cinder Encryption Key Deletion Policy\", \"description\": \"States the condition under which the Image Service will delete the object associated with the \'cinder_encryption_key_id\' image property.  If this property is missing, the Image Service will take no action\", \"type\": \"string\", \"enum\": [\"on_image_deletion\", \"do_not_delete\"]}','2025-12-06 08:26:11',NULL),(359,74,'img_signature','{\"title\": \"Image Signature\", \"description\": \"The signature of the image data encoded in base64 format.\", \"type\": \"string\"}','2025-12-06 08:26:12',NULL),(362,74,'img_signature_certificate_uuid','{\"title\": \"Image Signature Certificate UUID\", \"description\": \"The UUID used to retrieve the certificate from the key manager.\", \"type\": \"string\"}','2025-12-06 08:26:12',NULL),(365,74,'img_signature_hash_method','{\"title\": \"Image Signature Hash Method\", \"description\": \"The hash method used in creating the signature.\", \"type\": \"string\", \"enum\": [\"SHA-224\", \"SHA-256\", \"SHA-384\", \"SHA-512\"]}','2025-12-06 08:26:12',NULL),(368,74,'img_signature_key_type','{\"title\": \"Image Signature Key Type\", \"description\": \"The key type used in creating the signature.\", \"type\": \"string\", \"enum\": [\"RSA-PSS\", \"DSA\", \"ECC_SECT571K1\", \"ECC_SECT409K1\", \"ECC_SECT571R1\", \"ECC_SECT409R1\", \"ECC_SECP521R1\", \"ECC_SECP384R1\"]}','2025-12-06 08:26:12',NULL),(371,77,'os_distro','{\"title\": \"OS Distro\", \"description\": \"The common name of the operating system distribution in lowercase (uses the same data vocabulary as the libosinfo project). Specify only a recognized value for this field. Deprecated values are listed to assist you in searching for the recognized value.\", \"type\": \"string\"}','2025-12-06 08:26:12',NULL),(374,77,'os_version','{\"title\": \"OS Version\", \"description\": \"Operating system version as specified by the distributor. (for example, \'11.10\')\", \"type\": \"string\"}','2025-12-06 08:26:12',NULL),(377,77,'os_admin_user','{\"title\": \"OS Admin User\", \"description\": \"The name of the user with admin privileges.\", \"type\": \"string\"}','2025-12-06 08:26:12',NULL),(380,89,'img_volume_type','{\"title\": \"Image Volume Type\", \"description\": \"Specifies the volume type that should be applied during new volume creation with a image. This value is passed to Cinder when creating a new volume. Priority of volume type related parameters are 1.volume_type(via API or CLI), 2.cinder_img_volume_type, 3.default_volume_type(via cinder.conf). If not specified, volume_type or default_volume_type will be referred based on their priority.\", \"type\": \"string\"}','2025-12-06 08:26:13',NULL),(383,92,'cpu_mode','{\"title\": \"CPU Mode\", \"description\": \"Type of CPU Mode.\", \"type\": \"string\", \"enum\": [\"none\", \"host-model\", \"host-passthrough\", \"custom\"]}','2025-12-06 09:03:59',NULL),(384,93,'tpm_model','{\"title\": \"TPM model\", \"description\": \"TPM model to use. Option CRB is only valid for TPM version 2.0. Defaults to TIS.\", \"operators\": [\"<or>\"], \"type\": \"string\", \"enum\": [\"TIS\", \"CRB\"], \"default\": \"TIS\"}','2025-12-06 09:03:59',NULL),(385,94,'COMPUTE_SECURITY_TPM_1_2','{\"title\": \"Virtual TPM Version 1.2 Support\", \"description\": \"Enables virtual TPM version 1.2.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 09:03:59',NULL),(386,94,'COMPUTE_SECURITY_TPM_2_0','{\"title\": \"Virtual TPM Version 2.0 Support\", \"description\": \"Enables virtual TPM version 2.0.\", \"type\": \"string\", \"enum\": [\"required\"], \"default\": \"required\"}','2025-12-06 09:03:59',NULL);
/*!40000 ALTER TABLE `metadef_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_resource_types`
--

DROP TABLE IF EXISTS `metadef_resource_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_resource_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `protected` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_resource_types_name` (`name`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`protected` in (0,1))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_resource_types`
--

LOCK TABLES `metadef_resource_types` WRITE;
/*!40000 ALTER TABLE `metadef_resource_types` DISABLE KEYS */;
INSERT INTO `metadef_resource_types` (`id`, `name`, `protected`, `created_at`, `updated_at`) VALUES (2,'OS::Cinder::Volume',1,'2025-12-06 08:26:05',NULL),(5,'OS::Glance::Image',1,'2025-12-06 08:26:05',NULL),(8,'OS::Nova::Aggregate',1,'2025-12-06 08:26:05',NULL),(11,'OS::Nova::Flavor',1,'2025-12-06 08:26:05',NULL),(14,'OS::Nova::Server',1,'2025-12-06 08:26:05',NULL),(17,'OS::Trove::Instance',1,'2025-12-06 08:26:12',NULL);
/*!40000 ALTER TABLE `metadef_resource_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `metadef_tags`
--

DROP TABLE IF EXISTS `metadef_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `metadef_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namespace_id` int(11) NOT NULL,
  `name` varchar(80) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_metadef_tags_namespace_id_name` (`namespace_id`,`name`),
  KEY `ix_metadef_tags_name` (`name`),
  CONSTRAINT `metadef_tags_ibfk_1` FOREIGN KEY (`namespace_id`) REFERENCES `metadef_namespaces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `metadef_tags`
--

LOCK TABLES `metadef_tags` WRITE;
/*!40000 ALTER TABLE `metadef_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `metadef_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('Glance Migrations','/usr/lib/python3.9/site-packages/glance/db/sqlalchemy/migrate_repo',0);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `task_info`
--

DROP TABLE IF EXISTS `task_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `task_info` (
  `task_id` varchar(36) NOT NULL,
  `input` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  CONSTRAINT `task_info_ibfk_1` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `task_info`
--

LOCK TABLES `task_info` WRITE;
/*!40000 ALTER TABLE `task_info` DISABLE KEYS */;
INSERT INTO `task_info` (`task_id`, `input`, `result`, `message`) VALUES ('184da3cf-9f3b-4fa9-8d22-e220663db207','{\"image_properties\": {\"container_format\": \"bare\", \"disk_format\": \"qcow2\", \"visibility\": \"public\", \"name\": \"tempest-task_image-1787910067\"}, \"import_from_format\": \"qcow2\", \"import_from\": \"http://tempest-dummy-img-file-1444577197.qcow2\"}',NULL,'Task failed due to Internal Error'),('99fb292e-0b0b-4e08-8aff-7904eb13cc4a','{\"image_id\": \"5e89b137-706f-4234-b097-c97e83c87b31\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"http://does-not.exist/no/possible/way\"}, \"stores\": [\"default_backend\"]}, \"backend\": [\"default_backend\"]}',NULL,'Task failed due to Internal Error'),('b3d35569-6a22-4159-9773-5f4dec7b8e92','{\"image_id\": \"57a18f5d-0bb5-4bd4-8952-e0415dd44feb\", \"import_req\": {\"method\": {\"name\": \"glance-direct\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"57a18f5d-0bb5-4bd4-8952-e0415dd44feb\"}','Copied 0 MiB'),('d6ce335a-d686-453b-866a-94a4378f9a7d','{\"image_id\": \"66df6814-6caf-4001-aace-c11674b4cdf9\", \"import_req\": {\"method\": {\"name\": \"web-download\", \"uri\": \"https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img\"}, \"all_stores\": true}, \"backend\": [\"default_backend\"]}','{\"image_id\": \"66df6814-6caf-4001-aace-c11674b4cdf9\"}','Copied 112 MiB');
/*!40000 ALTER TABLE `task_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tasks` (
  `id` varchar(36) NOT NULL,
  `type` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL,
  `image_id` varchar(36) DEFAULT NULL,
  `request_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_tasks_deleted` (`deleted`),
  KEY `ix_tasks_owner` (`owner`),
  KEY `ix_tasks_status` (`status`),
  KEY `ix_tasks_type` (`type`),
  KEY `ix_tasks_updated_at` (`updated_at`),
  KEY `ix_tasks_image_id` (`image_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`deleted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`id`, `type`, `status`, `owner`, `expires_at`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `image_id`, `request_id`, `user_id`) VALUES ('184da3cf-9f3b-4fa9-8d22-e220663db207','import','failure','f742ea0e912f4adaa36453fa260c01e9','2025-12-08 10:18:02','2025-12-06 10:18:01','2025-12-06 10:18:02',NULL,0,NULL,'req-6d07bdb5-a98b-4343-b899-a51cb3913fff','e5c7d5967f7d46e7835cae124101c34e'),('99fb292e-0b0b-4e08-8aff-7904eb13cc4a','api_image_import','failure','ce4a191131d2409a8fc6c1e67d19f7ce','2025-12-08 10:17:16','2025-12-06 10:17:16','2025-12-06 10:17:16',NULL,0,'5e89b137-706f-4234-b097-c97e83c87b31','req-cc3d0063-13fb-47bb-b278-179c4aa987ea','bba733769c214abb9b0112bffafbaa4d'),('b3d35569-6a22-4159-9773-5f4dec7b8e92','api_image_import','success','5ae5b2af677a466a97c4783ec75e136c','2025-12-08 10:18:16','2025-12-06 10:18:15','2025-12-06 10:18:16',NULL,0,'57a18f5d-0bb5-4bd4-8952-e0415dd44feb','req-29c3309d-bc66-4851-898a-8f4633d4acca','3f5ca2acf210487dbe6f30ee479df5c9'),('d6ce335a-d686-453b-866a-94a4378f9a7d','api_image_import','success','5ae5b2af677a466a97c4783ec75e136c','2025-12-08 10:18:23','2025-12-06 10:18:17','2025-12-06 10:18:23',NULL,0,'66df6814-6caf-4001-aace-c11674b4cdf9','req-87063b1c-0d4d-4dc4-b30d-a7ac066750db','3f5ca2acf210487dbe6f30ee479df5c9');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `heat`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `heat` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `heat`;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `resource_action` varchar(255) DEFAULT NULL,
  `resource_status` varchar(255) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `physical_resource_id` varchar(255) DEFAULT NULL,
  `resource_status_reason` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_properties` blob DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `ev_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  CONSTRAINT `ev_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `event_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('heat','/usr/lib/python3.9/site-packages/heat/db/sqlalchemy/migrate_repo',86);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template`
--

DROP TABLE IF EXISTS `raw_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `template` longtext DEFAULT NULL,
  `files` longtext DEFAULT NULL,
  `environment` longtext DEFAULT NULL,
  `files_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_tmpl_files_fkey_ref` (`files_id`),
  CONSTRAINT `raw_tmpl_files_fkey_ref` FOREIGN KEY (`files_id`) REFERENCES `raw_template_files` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template`
--

LOCK TABLES `raw_template` WRITE;
/*!40000 ALTER TABLE `raw_template` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raw_template_files`
--

DROP TABLE IF EXISTS `raw_template_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `raw_template_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `files` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raw_template_files`
--

LOCK TABLES `raw_template_files` WRITE;
/*!40000 ALTER TABLE `raw_template_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `raw_template_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource`
--

DROP TABLE IF EXISTS `resource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `nova_instance` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  `rsrc_metadata` longtext DEFAULT NULL,
  `properties_data` longtext DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  `atomic_key` int(11) DEFAULT NULL,
  `needed_by` longtext DEFAULT NULL,
  `requires` longtext DEFAULT NULL,
  `replaces` int(11) DEFAULT NULL,
  `replaced_by` int(11) DEFAULT NULL,
  `current_template_id` int(11) DEFAULT NULL,
  `properties_data_encrypted` tinyint(1) DEFAULT NULL,
  `root_stack_id` varchar(36) DEFAULT NULL,
  `rsrc_prop_data_id` int(11) DEFAULT NULL,
  `attr_data_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `stack_id` (`stack_id`),
  KEY `current_template_id` (`current_template_id`),
  KEY `ix_resource_root_stack_id` (`root_stack_id`),
  KEY `rsrc_rsrc_prop_data_ref` (`rsrc_prop_data_id`),
  KEY `rsrc_attr_data_ref` (`attr_data_id`),
  CONSTRAINT `resource_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `resource_ibfk_2` FOREIGN KEY (`current_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `rsrc_attr_data_ref` FOREIGN KEY (`attr_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `rsrc_rsrc_prop_data_ref` FOREIGN KEY (`rsrc_prop_data_id`) REFERENCES `resource_properties_data` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`properties_data_encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource`
--

LOCK TABLES `resource` WRITE;
/*!40000 ALTER TABLE `resource` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_data`
--

DROP TABLE IF EXISTS `resource_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `redact` tinyint(1) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `resource_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_resource_id` (`resource_id`),
  CONSTRAINT `fk_resource_id` FOREIGN KEY (`resource_id`) REFERENCES `resource` (`id`) ON DELETE CASCADE,
  CONSTRAINT `CONSTRAINT_1` CHECK (`redact` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_data`
--

LOCK TABLES `resource_data` WRITE;
/*!40000 ALTER TABLE `resource_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_properties_data`
--

DROP TABLE IF EXISTS `resource_properties_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resource_properties_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data` longtext DEFAULT NULL,
  `encrypted` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`encrypted` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `resource_properties_data`
--

LOCK TABLES `resource_properties_data` WRITE;
/*!40000 ALTER TABLE `resource_properties_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `resource_properties_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(36) NOT NULL,
  `engine_id` varchar(36) NOT NULL,
  `host` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `binary` varchar(255) NOT NULL,
  `topic` varchar(255) NOT NULL,
  `report_interval` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `engine_id`, `host`, `hostname`, `binary`, `topic`, `report_interval`, `created_at`, `updated_at`, `deleted_at`) VALUES ('3c9bba04-c646-42fa-bf04-151835e5036b','52176f2d-9d4e-4b14-80c1-5da3c1c11ba0','np0005548785.localdomain','np0005548785.localdomain','heat-engine','engine',60,'2025-12-06 08:30:43','2025-12-06 08:57:43',NULL),('c938f9d1-3438-4536-b5a7-5d33cdf8f9cd','01df2f23-9639-43c5-9306-54fba62c85fc','heat-engine-d989c6c78-ls6jf','heat-engine-d989c6c78-ls6jf','heat-engine','engine',60,'2025-12-06 09:11:54','2025-12-06 10:39:54',NULL),('cc850d0d-530a-452e-9b98-5e5a4b462ae7','b45185ec-a6c2-4b0c-aaab-4978f12e6e78','heat-engine-d989c6c78-ls6jf','heat-engine-d989c6c78-ls6jf','heat-engine','engine',60,'2025-12-06 09:11:54','2025-12-06 10:39:54',NULL),('cce0fad1-7521-4d18-8849-5e8d54954abb','b8bdf391-b3b9-43a7-9ccc-3520b3f8e93b','np0005548787.localdomain','np0005548787.localdomain','heat-engine','engine',60,'2025-12-06 08:30:59','2025-12-06 08:57:59',NULL),('ce85cc0a-2a28-48f2-a363-f432eb11b203','b1a98731-dbb4-4c9e-916b-d5f16eb128c0','heat-engine-d989c6c78-ls6jf','heat-engine-d989c6c78-ls6jf','heat-engine','engine',60,'2025-12-06 09:11:53','2025-12-06 10:39:54',NULL),('d0152ff7-4c26-4a8b-834b-cdba14122ae2','2dc6cc8f-2713-4e02-98b7-9119cf19ada1','heat-engine-d989c6c78-ls6jf','heat-engine-d989c6c78-ls6jf','heat-engine','engine',60,'2025-12-06 09:11:53','2025-12-06 10:39:54',NULL),('e38beecc-e73f-4106-95e7-d56422191789','6663fe0b-9add-43d8-9169-c7e640037e57','np0005548786.localdomain','np0005548786.localdomain','heat-engine','engine',60,'2025-12-06 08:30:57','2025-12-06 08:57:57',NULL);
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `snapshot`
--

DROP TABLE IF EXISTS `snapshot`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `snapshot` (
  `id` varchar(36) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  KEY `ix_snapshot_tenant` (`tenant`),
  CONSTRAINT `snapshot_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `snapshot`
--

LOCK TABLES `snapshot` WRITE;
/*!40000 ALTER TABLE `snapshot` DISABLE KEYS */;
/*!40000 ALTER TABLE `snapshot` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_config`
--

DROP TABLE IF EXISTS `software_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_config` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `config` longtext DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_software_config_tenant` (`tenant`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_config`
--

LOCK TABLES `software_config` WRITE;
/*!40000 ALTER TABLE `software_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `software_deployment`
--

DROP TABLE IF EXISTS `software_deployment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `software_deployment` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `server_id` varchar(36) NOT NULL,
  `config_id` varchar(36) NOT NULL,
  `input_values` longtext DEFAULT NULL,
  `output_values` longtext DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `tenant` varchar(64) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `config_id` (`config_id`),
  KEY `ix_software_deployment_server_id` (`server_id`),
  KEY `ix_software_deployment_tenant` (`tenant`),
  KEY `ix_software_deployment_created_at` (`created_at`),
  CONSTRAINT `software_deployment_ibfk_1` FOREIGN KEY (`config_id`) REFERENCES `software_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `software_deployment`
--

LOCK TABLES `software_deployment` WRITE;
/*!40000 ALTER TABLE `software_deployment` DISABLE KEYS */;
/*!40000 ALTER TABLE `software_deployment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack`
--

DROP TABLE IF EXISTS `stack`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack` (
  `id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `raw_template_id` int(11) NOT NULL,
  `prev_raw_template_id` int(11) DEFAULT NULL,
  `user_creds_id` int(11) DEFAULT NULL,
  `username` varchar(256) DEFAULT NULL,
  `owner_id` varchar(36) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `status_reason` text DEFAULT NULL,
  `timeout` int(11) DEFAULT NULL,
  `tenant` varchar(256) DEFAULT NULL,
  `disable_rollback` tinyint(1) NOT NULL,
  `stack_user_project_id` varchar(64) DEFAULT NULL,
  `backup` tinyint(1) DEFAULT NULL,
  `nested_depth` int(11) DEFAULT NULL,
  `convergence` tinyint(1) DEFAULT NULL,
  `current_traversal` varchar(36) DEFAULT NULL,
  `current_deps` longtext DEFAULT NULL,
  `parent_resource_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `raw_template_id` (`raw_template_id`),
  KEY `prev_raw_template_id` (`prev_raw_template_id`),
  KEY `user_creds_id` (`user_creds_id`),
  KEY `ix_stack_owner_id` (`owner_id`),
  KEY `ix_stack_tenant` (`tenant`(255)),
  KEY `ix_stack_name` (`name`),
  CONSTRAINT `stack_ibfk_1` FOREIGN KEY (`raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_2` FOREIGN KEY (`prev_raw_template_id`) REFERENCES `raw_template` (`id`),
  CONSTRAINT `stack_ibfk_3` FOREIGN KEY (`user_creds_id`) REFERENCES `user_creds` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`disable_rollback` in (0,1)),
  CONSTRAINT `CONSTRAINT_2` CHECK (`backup` in (0,1)),
  CONSTRAINT `CONSTRAINT_3` CHECK (`convergence` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack`
--

LOCK TABLES `stack` WRITE;
/*!40000 ALTER TABLE `stack` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_lock`
--

DROP TABLE IF EXISTS `stack_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_lock` (
  `stack_id` varchar(36) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `engine_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`stack_id`),
  CONSTRAINT `stack_lock_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_lock`
--

LOCK TABLES `stack_lock` WRITE;
/*!40000 ALTER TABLE `stack_lock` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stack_tag`
--

DROP TABLE IF EXISTS `stack_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stack_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `tag` varchar(80) DEFAULT NULL,
  `stack_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stack_id` (`stack_id`),
  CONSTRAINT `stack_tag_ibfk_1` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stack_tag`
--

LOCK TABLES `stack_tag` WRITE;
/*!40000 ALTER TABLE `stack_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `stack_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sync_point`
--

DROP TABLE IF EXISTS `sync_point`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sync_point` (
  `entity_id` varchar(36) NOT NULL,
  `traversal_id` varchar(36) NOT NULL,
  `is_update` tinyint(1) NOT NULL,
  `atomic_key` int(11) NOT NULL,
  `stack_id` varchar(36) NOT NULL,
  `input_data` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`traversal_id`,`is_update`),
  KEY `fk_stack_id` (`stack_id`),
  CONSTRAINT `fk_stack_id` FOREIGN KEY (`stack_id`) REFERENCES `stack` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`is_update` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sync_point`
--

LOCK TABLES `sync_point` WRITE;
/*!40000 ALTER TABLE `sync_point` DISABLE KEYS */;
/*!40000 ALTER TABLE `sync_point` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_creds`
--

DROP TABLE IF EXISTS `user_creds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_creds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `region_name` varchar(255) DEFAULT NULL,
  `decrypt_method` varchar(64) DEFAULT NULL,
  `tenant` varchar(1024) DEFAULT NULL,
  `auth_url` text DEFAULT NULL,
  `tenant_id` varchar(256) DEFAULT NULL,
  `trust_id` varchar(255) DEFAULT NULL,
  `trustor_user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_creds`
--

LOCK TABLES `user_creds` WRITE;
/*!40000 ALTER TABLE `user_creds` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_creds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `keystone`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `keystone` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `keystone`;

--
-- Table structure for table `access_rule`
--

DROP TABLE IF EXISTS `access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service` varchar(64) DEFAULT NULL,
  `path` varchar(128) DEFAULT NULL,
  `method` varchar(16) DEFAULT NULL,
  `external_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `access_rule_external_id_key` (`external_id`),
  UNIQUE KEY `duplicate_access_rule_for_user_constraint` (`user_id`,`service`,`path`,`method`),
  KEY `external_id` (`external_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_rule`
--

LOCK TABLES `access_rule` WRITE;
/*!40000 ALTER TABLE `access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `access_token`
--

DROP TABLE IF EXISTS `access_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `access_token` (
  `id` varchar(64) NOT NULL,
  `access_secret` varchar(64) NOT NULL,
  `authorizing_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  `role_ids` text NOT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_access_token_consumer_id` (`consumer_id`),
  KEY `ix_access_token_authorizing_user_id` (`authorizing_user_id`),
  CONSTRAINT `access_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `access_token`
--

LOCK TABLES `access_token` WRITE;
/*!40000 ALTER TABLE `access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `access_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('29e87d24a316'),('e25ffa003242');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential`
--

DROP TABLE IF EXISTS `application_credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential` (
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `secret_hash` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `expires_at` bigint(20) DEFAULT NULL,
  `system` varchar(64) DEFAULT NULL,
  `unrestricted` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `duplicate_app_cred_constraint` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential`
--

LOCK TABLES `application_credential` WRITE;
/*!40000 ALTER TABLE `application_credential` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_access_rule`
--

DROP TABLE IF EXISTS `application_credential_access_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_access_rule` (
  `application_credential_id` int(11) NOT NULL,
  `access_rule_id` int(11) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`access_rule_id`),
  KEY `access_rule_id` (`access_rule_id`),
  CONSTRAINT `application_credential_access_rule_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE,
  CONSTRAINT `application_credential_access_rule_ibfk_2` FOREIGN KEY (`access_rule_id`) REFERENCES `access_rule` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_access_rule`
--

LOCK TABLES `application_credential_access_rule` WRITE;
/*!40000 ALTER TABLE `application_credential_access_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_access_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `application_credential_role`
--

DROP TABLE IF EXISTS `application_credential_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `application_credential_role` (
  `application_credential_id` int(11) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`application_credential_id`,`role_id`),
  CONSTRAINT `application_credential_role_ibfk_1` FOREIGN KEY (`application_credential_id`) REFERENCES `application_credential` (`internal_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `application_credential_role`
--

LOCK TABLES `application_credential_role` WRITE;
/*!40000 ALTER TABLE `application_credential_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `application_credential_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assignment`
--

DROP TABLE IF EXISTS `assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assignment` (
  `type` enum('UserProject','GroupProject','UserDomain','GroupDomain') NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  KEY `ix_actor_id` (`actor_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assignment`
--

LOCK TABLES `assignment` WRITE;
/*!40000 ALTER TABLE `assignment` DISABLE KEYS */;
INSERT INTO `assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserProject','0230cb4c53da4352b7218490b2c17f9f','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','0b60e97090454089ad6b8f4b898d0040','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','0b60e97090454089ad6b8f4b898d0040','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','1544b0e089d94c8fb9c36fa12e309648','9bffcf50ce6c4b07a51d7021f8a9cc25','c8d64f613d26423e8c2e24c515ca9252',0),('UserProject','1c4f5efd048a4728b8b385f1b97bb93f','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','1c4f5efd048a4728b8b385f1b97bb93f','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','1c7878b72e394756a744a2987b419fd8','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','1c7878b72e394756a744a2987b419fd8','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','1c7878b72e394756a744a2987b419fd8','660705fe1cbe4111b6f2c99ce8d05c8c','ac1c8ab1f8a24756a43883309bb56ede',0),('UserProject','22044c8ccf4c448da35f054bc8e6d992','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','22ff39926e0145649d48324b557e54cd','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','37c748c83d0749118aad1e714d9bad8c','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','37c748c83d0749118aad1e714d9bad8c','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','39d964f88e94434fb224ff3aee83c169','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','39d964f88e94434fb224ff3aee83c169','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','45242f27271d48b79b0238b7644a7b60','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','45242f27271d48b79b0238b7644a7b60','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','4b82c3c99efd48449ae4a5af07edaad5','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','4b82c3c99efd48449ae4a5af07edaad5','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','c0426c55171344f8b1aead6825904739','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','d2ec1ac92c11484fb52fc3dd4b2df2e6','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','d2ec1ac92c11484fb52fc3dd4b2df2e6','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','d8981dc265a846d2af1fd95fd6598ffb','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','d8981dc265a846d2af1fd95fd6598ffb','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','e6a3127800b04e0e8ce5899d342b1fc0','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','e6a3127800b04e0e8ce5899d342b1fc0','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','f52779cce5374723ad2618b5c2916973','660705fe1cbe4111b6f2c99ce8d05c8c','21df11cce40840a981926a82775f359c',0),('UserProject','f52779cce5374723ad2618b5c2916973','660705fe1cbe4111b6f2c99ce8d05c8c','620b1400081c464197069ecee5a56c86',0),('UserProject','ff0049f3313348bdb67886d170c1c765','3d603431c0bb4967bafc7a0aa6108bfe','21df11cce40840a981926a82775f359c',0),('UserProject','ff0049f3313348bdb67886d170c1c765','9bffcf50ce6c4b07a51d7021f8a9cc25','21df11cce40840a981926a82775f359c',0),('UserDomain','dc94af99a6814c1a85c6a553ec912f07','94e220b3a75b4b7fa2215bcfb787fa7d','21df11cce40840a981926a82775f359c',0);
/*!40000 ALTER TABLE `assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `config_register`
--

DROP TABLE IF EXISTS `config_register`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `config_register` (
  `type` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `config_register`
--

LOCK TABLES `config_register` WRITE;
/*!40000 ALTER TABLE `config_register` DISABLE KEYS */;
/*!40000 ALTER TABLE `config_register` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consumer`
--

DROP TABLE IF EXISTS `consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumer` (
  `id` varchar(64) NOT NULL,
  `description` varchar(64) DEFAULT NULL,
  `secret` varchar(64) NOT NULL,
  `extra` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consumer`
--

LOCK TABLES `consumer` WRITE;
/*!40000 ALTER TABLE `consumer` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `credential`
--

DROP TABLE IF EXISTS `credential`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credential` (
  `id` varchar(64) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `key_hash` varchar(64) NOT NULL,
  `encrypted_blob` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `credential`
--

LOCK TABLES `credential` WRITE;
/*!40000 ALTER TABLE `credential` DISABLE KEYS */;
INSERT INTO `credential` (`id`, `user_id`, `project_id`, `type`, `extra`, `key_hash`, `encrypted_blob`) VALUES ('bc80a30623b44e1b80ad491f4a849cf7','ff0049f3313348bdb67886d170c1c765',NULL,'cert','{}','04430310bd1f50f6e3f80fa187d8ac93ffabf561','gAAAAABpM-0W5qYiDR-cIgf7P3fIqVLPiypxV6KB5xy0qixS-1Pw8RA54qalsD5bnWXSHL4G0PS_75_NZNp3mrUqOStdn7pFfA==');
/*!40000 ALTER TABLE `credential` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint`
--

DROP TABLE IF EXISTS `endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint` (
  `id` varchar(64) NOT NULL,
  `legacy_endpoint_id` varchar(64) DEFAULT NULL,
  `interface` varchar(8) NOT NULL,
  `service_id` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `region_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `fk_endpoint_region_id` (`region_id`),
  CONSTRAINT `endpoint_service_id_fkey` FOREIGN KEY (`service_id`) REFERENCES `service` (`id`),
  CONSTRAINT `fk_endpoint_region_id` FOREIGN KEY (`region_id`) REFERENCES `region` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint`
--

LOCK TABLES `endpoint` WRITE;
/*!40000 ALTER TABLE `endpoint` DISABLE KEYS */;
INSERT INTO `endpoint` (`id`, `legacy_endpoint_id`, `interface`, `service_id`, `url`, `extra`, `enabled`, `region_id`) VALUES ('0148ae1f108e4ba49828256ef0a3983a',NULL,'public','703a0b85374a40b9b7522a3eb112c711','http://manila-public-openstack.apps-crc.testing/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('051761e4096049bdb5e183131c71ab90',NULL,'public','fe61b2daa8d8424b99e5eca9cfe52f82','http://placement-public-openstack.apps-crc.testing','{\"name\": \"placement\"}',1,'regionOne'),('1519a7eaf73d4c0eacd173303cc646e0',NULL,'public','6a90e815881e4fe7ba86b9228eac2b2f','http://barbican-public-openstack.apps-crc.testing','{\"name\": \"barbican\"}',1,'regionOne'),('1657b74316e64deb88196baa6f130dd1',NULL,'public','f5fbf2888a0c4b6da3f9fb80ced42184','http://manila-public-openstack.apps-crc.testing/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('1d693c9e181841849c26fb7424814c8a',NULL,'public','2bf0f0f0aeb648b48d156343254f9b96','http://heat-cfnapi-public-openstack.apps-crc.testing/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('225bc61fc16b4344ad31922cef61d9e0',NULL,'public','bba90c774f624db486388a58a8575e00','http://cinder-public-openstack.apps-crc.testing/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('3618d2275b0040e6aae4cb3602e51abf',NULL,'public','1b2d1e695dfd4be4bfa6e87d6234a856','http://heat-api-public-openstack.apps-crc.testing/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne'),('37b199404c24485a866e87fc25721529',NULL,'internal','6a90e815881e4fe7ba86b9228eac2b2f','http://barbican-internal.openstack.svc:9311','{\"name\": \"barbican\"}',1,'regionOne'),('4c056b63ff7648d2a6795d265bdea82a',NULL,'internal','2bf0f0f0aeb648b48d156343254f9b96','http://heat-cfnapi-internal.openstack.svc:8000/v1','{\"name\": \"heat-cfn\"}',1,'regionOne'),('52922bd110834b79b6ce42ecf7675716',NULL,'internal','1a3a6d24f20c417d9f50fce9df1ee98f','http://aodh-internal.openstack.svc:8042','{\"name\": \"aodh\"}',1,'regionOne'),('57d21c752a954723b959dc7705d5e2ca',NULL,'public','5476958678184f4cb27a3aed329d1494','http://nova-public-openstack.apps-crc.testing/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('5f8768d80b4d4c0f820156adebe39e15',NULL,'public','c3a94beac8134da2861320170020024c','http://keystone-public-openstack.apps-crc.testing','{}',1,'regionOne'),('6b6fe1a82b2544efa9f251c9d0ae5c5a',NULL,'internal','f5fbf2888a0c4b6da3f9fb80ced42184','http://manila-internal.openstack.svc:8786/v1/%(project_id)s','{\"name\": \"manila\"}',1,'regionOne'),('743c9f0f8ca044d99b11652776f21abb',NULL,'public','3bfe7cecbb1643debf415722c66f7491','http://neutron-public-openstack.apps-crc.testing','{\"name\": \"neutron\"}',1,'regionOne'),('83143cbe6ede4cee9cb06bbcb4623b35',NULL,'public','1a3a6d24f20c417d9f50fce9df1ee98f','http://aodh-public-openstack.apps-crc.testing','{\"name\": \"aodh\"}',1,'regionOne'),('84d31c5f80c844fbbece009060fb67c8',NULL,'internal','bba90c774f624db486388a58a8575e00','http://cinder-internal.openstack.svc:8776/v3','{\"name\": \"cinderv3\"}',1,'regionOne'),('8fbb94cf2353441c9a493a5167405db5',NULL,'internal','c3a94beac8134da2861320170020024c','http://keystone-internal.openstack.svc:5000','{}',1,'regionOne'),('972baeb4c6e24961bbbbee5a8c560dd3',NULL,'public','077c2b5efe0f4c2da18da960c984610a','http://glance-default-public-openstack.apps-crc.testing','{\"name\": \"glance\"}',1,'regionOne'),('98ac362f58184665b5907caa6575c2ae',NULL,'internal','3bfe7cecbb1643debf415722c66f7491','http://neutron-internal.openstack.svc:9696','{\"name\": \"neutron\"}',1,'regionOne'),('a2990928da7a4dd9b7795be22f5211fa',NULL,'internal','077c2b5efe0f4c2da18da960c984610a','http://glance-default-internal.openstack.svc:9292','{\"name\": \"glance\"}',1,'regionOne'),('b0d2f5010d0b46d5956e9eb6b9283348',NULL,'internal','fe61b2daa8d8424b99e5eca9cfe52f82','http://placement-internal.openstack.svc:8778','{\"name\": \"placement\"}',1,'regionOne'),('b604d7b8e776486495ae9031cf008b6c',NULL,'internal','5476958678184f4cb27a3aed329d1494','http://nova-internal.openstack.svc:8774/v2.1','{\"name\": \"nova\"}',1,'regionOne'),('ce0fba0222d644e1951101e1e1d15acf',NULL,'internal','703a0b85374a40b9b7522a3eb112c711','http://manila-internal.openstack.svc:8786/v2','{\"name\": \"manilav2\"}',1,'regionOne'),('ea6ac6f93bc241b8a2f69e014f098697',NULL,'internal','1b2d1e695dfd4be4bfa6e87d6234a856','http://heat-api-internal.openstack.svc:8004/v1/%(tenant_id)s','{\"name\": \"heat\"}',1,'regionOne');
/*!40000 ALTER TABLE `endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `endpoint_group`
--

DROP TABLE IF EXISTS `endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `endpoint_group` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `filters` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `endpoint_group`
--

LOCK TABLES `endpoint_group` WRITE;
/*!40000 ALTER TABLE `endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expiring_user_group_membership`
--

DROP TABLE IF EXISTS `expiring_user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expiring_user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `last_verified` datetime NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`,`idp_id`),
  KEY `group_id` (`group_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_2` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `expiring_user_group_membership_ibfk_3` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expiring_user_group_membership`
--

LOCK TABLES `expiring_user_group_membership` WRITE;
/*!40000 ALTER TABLE `expiring_user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `expiring_user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federated_user`
--

DROP TABLE IF EXISTS `federated_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federated_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `protocol_id` varchar(64) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idp_id` (`idp_id`,`protocol_id`,`unique_id`),
  KEY `user_id` (`user_id`),
  KEY `federated_user_protocol_id_fkey` (`protocol_id`,`idp_id`),
  CONSTRAINT `federated_user_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_ibfk_2` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE,
  CONSTRAINT `federated_user_protocol_id_fkey` FOREIGN KEY (`protocol_id`, `idp_id`) REFERENCES `federation_protocol` (`id`, `idp_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federated_user`
--

LOCK TABLES `federated_user` WRITE;
/*!40000 ALTER TABLE `federated_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `federated_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `federation_protocol`
--

DROP TABLE IF EXISTS `federation_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `federation_protocol` (
  `id` varchar(64) NOT NULL,
  `idp_id` varchar(64) NOT NULL,
  `mapping_id` varchar(64) NOT NULL,
  `remote_id_attribute` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`,`idp_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `federation_protocol_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `federation_protocol`
--

LOCK TABLES `federation_protocol` WRITE;
/*!40000 ALTER TABLE `federation_protocol` DISABLE KEYS */;
/*!40000 ALTER TABLE `federation_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `group`
--

DROP TABLE IF EXISTS `group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group` (
  `id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_group_name_domain_id` (`domain_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `group`
--

LOCK TABLES `group` WRITE;
/*!40000 ALTER TABLE `group` DISABLE KEYS */;
/*!40000 ALTER TABLE `group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `id_mapping`
--

DROP TABLE IF EXISTS `id_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `id_mapping` (
  `public_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `local_id` varchar(255) NOT NULL,
  `entity_type` enum('user','group') NOT NULL,
  PRIMARY KEY (`public_id`),
  UNIQUE KEY `domain_id` (`domain_id`,`local_id`,`entity_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `id_mapping`
--

LOCK TABLES `id_mapping` WRITE;
/*!40000 ALTER TABLE `id_mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `id_mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `identity_provider`
--

DROP TABLE IF EXISTS `identity_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `identity_provider` (
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `authorization_ttl` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_id` (`domain_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `identity_provider`
--

LOCK TABLES `identity_provider` WRITE;
/*!40000 ALTER TABLE `identity_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `identity_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `idp_remote_ids`
--

DROP TABLE IF EXISTS `idp_remote_ids`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `idp_remote_ids` (
  `idp_id` varchar(64) DEFAULT NULL,
  `remote_id` varchar(255) NOT NULL,
  PRIMARY KEY (`remote_id`),
  KEY `idp_id` (`idp_id`),
  CONSTRAINT `idp_remote_ids_ibfk_1` FOREIGN KEY (`idp_id`) REFERENCES `identity_provider` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `idp_remote_ids`
--

LOCK TABLES `idp_remote_ids` WRITE;
/*!40000 ALTER TABLE `idp_remote_ids` DISABLE KEYS */;
/*!40000 ALTER TABLE `idp_remote_ids` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `implied_role`
--

DROP TABLE IF EXISTS `implied_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `implied_role` (
  `prior_role_id` varchar(64) NOT NULL,
  `implied_role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`prior_role_id`,`implied_role_id`),
  KEY `implied_role_implied_role_id_fkey` (`implied_role_id`),
  CONSTRAINT `implied_role_implied_role_id_fkey` FOREIGN KEY (`implied_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE,
  CONSTRAINT `implied_role_prior_role_id_fkey` FOREIGN KEY (`prior_role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `implied_role`
--

LOCK TABLES `implied_role` WRITE;
/*!40000 ALTER TABLE `implied_role` DISABLE KEYS */;
INSERT INTO `implied_role` (`prior_role_id`, `implied_role_id`) VALUES ('21df11cce40840a981926a82775f359c','c8d64f613d26423e8c2e24c515ca9252'),('c8d64f613d26423e8c2e24c515ca9252','510ee393b0524f50b7c196d7e67d09ee');
/*!40000 ALTER TABLE `implied_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `limit`
--

DROP TABLE IF EXISTS `limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `limit` (
  `id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `resource_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  `registered_limit_id` varchar(64) DEFAULT NULL,
  `domain_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `limit_id_key` (`id`),
  KEY `registered_limit_id` (`registered_limit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `limit`
--

LOCK TABLES `limit` WRITE;
/*!40000 ALTER TABLE `limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `local_user`
--

DROP TABLE IF EXISTS `local_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `local_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) NOT NULL,
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `failed_auth_count` int(11) DEFAULT NULL,
  `failed_auth_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_id` (`domain_id`,`name`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `local_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `local_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=644 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `local_user`
--

LOCK TABLES `local_user` WRITE;
/*!40000 ALTER TABLE `local_user` DISABLE KEYS */;
INSERT INTO `local_user` (`id`, `user_id`, `domain_id`, `name`, `failed_auth_count`, `failed_auth_at`) VALUES (2,'ff0049f3313348bdb67886d170c1c765','default','admin',0,NULL),(5,'4b82c3c99efd48449ae4a5af07edaad5','default','aodh',0,NULL),(8,'1c7878b72e394756a744a2987b419fd8','default','ceilometer',0,NULL),(11,'1c4f5efd048a4728b8b385f1b97bb93f','default','cinder',0,NULL),(14,'45242f27271d48b79b0238b7644a7b60','default','cinderv3',0,NULL),(17,'e6a3127800b04e0e8ce5899d342b1fc0','default','glance',0,NULL),(20,'c0426c55171344f8b1aead6825904739','default','gnocchi',0,NULL),(23,'39d964f88e94434fb224ff3aee83c169','default','heat',0,NULL),(26,'dc94af99a6814c1a85c6a553ec912f07','94e220b3a75b4b7fa2215bcfb787fa7d','heat_stack_domain_admin',0,NULL),(29,'0230cb4c53da4352b7218490b2c17f9f','default','heat-cfn',0,NULL),(32,'37c748c83d0749118aad1e714d9bad8c','default','manila',0,NULL),(35,'22ff39926e0145649d48324b557e54cd','default','manilav2',0,NULL),(38,'0b60e97090454089ad6b8f4b898d0040','default','neutron',0,NULL),(41,'f52779cce5374723ad2618b5c2916973','default','nova',0,NULL),(44,'d2ec1ac92c11484fb52fc3dd4b2df2e6','default','placement',0,NULL),(47,'22044c8ccf4c448da35f054bc8e6d992','default','swift',0,NULL),(50,'d8981dc265a846d2af1fd95fd6598ffb','default','barbican',0,NULL),(51,'1544b0e089d94c8fb9c36fa12e309648','default','demo_tempestconf',0,NULL),(52,'e50bc0336ff24c2d8dfe7e6d0f8df8eb','default','alt_demo_tempestconf',0,NULL);
/*!40000 ALTER TABLE `local_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mapping`
--

DROP TABLE IF EXISTS `mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mapping` (
  `id` varchar(64) NOT NULL,
  `rules` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mapping`
--

LOCK TABLES `mapping` WRITE;
/*!40000 ALTER TABLE `mapping` DISABLE KEYS */;
/*!40000 ALTER TABLE `mapping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrate_version`
--

DROP TABLE IF EXISTS `migrate_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrate_version` (
  `repository_id` varchar(250) NOT NULL,
  `repository_path` text DEFAULT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`repository_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrate_version`
--

LOCK TABLES `migrate_version` WRITE;
/*!40000 ALTER TABLE `migrate_version` DISABLE KEYS */;
INSERT INTO `migrate_version` (`repository_id`, `repository_path`, `version`) VALUES ('keystone','/usr/lib/python3.9/site-packages/keystone/common/sql/migrate_repo',109),('keystone_contract','/usr/lib/python3.9/site-packages/keystone/common/sql/contract_repo',79),('keystone_data_migrate','/usr/lib/python3.9/site-packages/keystone/common/sql/data_migration_repo',79),('keystone_expand','/usr/lib/python3.9/site-packages/keystone/common/sql/expand_repo',79);
/*!40000 ALTER TABLE `migrate_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nonlocal_user`
--

DROP TABLE IF EXISTS `nonlocal_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `nonlocal_user` (
  `domain_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `user_id` varchar(64) NOT NULL,
  PRIMARY KEY (`domain_id`,`name`),
  UNIQUE KEY `ixu_nonlocal_user_user_id` (`user_id`),
  KEY `nonlocal_user_user_id_fkey` (`user_id`,`domain_id`),
  CONSTRAINT `nonlocal_user_user_id_fkey` FOREIGN KEY (`user_id`, `domain_id`) REFERENCES `user` (`id`, `domain_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nonlocal_user`
--

LOCK TABLES `nonlocal_user` WRITE;
/*!40000 ALTER TABLE `nonlocal_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `nonlocal_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password`
--

DROP TABLE IF EXISTS `password`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `local_user_id` int(11) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `self_service` tinyint(1) NOT NULL DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `created_at_int` bigint(20) NOT NULL DEFAULT 0,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `local_user_id` (`local_user_id`),
  CONSTRAINT `password_ibfk_1` FOREIGN KEY (`local_user_id`) REFERENCES `local_user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password`
--

LOCK TABLES `password` WRITE;
/*!40000 ALTER TABLE `password` DISABLE KEYS */;
INSERT INTO `password` (`id`, `local_user_id`, `expires_at`, `self_service`, `password_hash`, `created_at_int`, `expires_at_int`, `created_at`) VALUES (2,2,'2025-12-06 08:59:47',0,'$2b$12$C87lpKKB2rPTfCffAGQI3uAc.B8DuNZcQFSHWwrHQQJ3/18Gluc56',1765009592892074,1765011587024754,'2025-12-06 08:26:32'),(5,5,NULL,0,'$2b$12$Ob6Yj2rzUI.Xnb/ah2ej6e84NkrEMtXmo9FqDJfKcXjN4QtKEKqPa',1765009738839041,NULL,'2025-12-06 08:28:58'),(8,8,NULL,0,'$2b$12$HcHPuhF7qEBfvTIdLFVjyeCoBVnBxKghnTGPEYey6ZdFtbuVZtjAi',1765009739244410,NULL,'2025-12-06 08:28:59'),(11,11,NULL,0,'$2b$12$5a17dNuSgcdPHTlHlNaKPuKc1YKQhhPP.yih5Qaq34siS1TZKFtva',1765009739761946,NULL,'2025-12-06 08:28:59'),(14,14,NULL,0,'$2b$12$10qtPFny0K4Nns2LNwvPI./UIIq3nweablPvPqv/2f2ZmIBTy9LDO',1765009740151395,NULL,'2025-12-06 08:29:00'),(17,17,NULL,0,'$2b$12$cx8zlQ6/9G5.ux9c0QSOMOIJF2irefBlK9N/BS/jszH47LcZbPT4e',1765009740433435,NULL,'2025-12-06 08:29:00'),(20,20,NULL,0,'$2b$12$C/XwkA9CuCKagguAk0eCf.74Eg.22JsJ7ioM5SARzoWCm.GMBXc0y',1765009740982547,NULL,'2025-12-06 08:29:00'),(23,23,NULL,0,'$2b$12$9zjSrVJ0zHLf5rLhMGDj6.rAG35AmZZMECinbQjckIqFEgs0aloWS',1765009741278524,NULL,'2025-12-06 08:29:01'),(26,26,NULL,0,'$2b$12$XhDj6xDzwyTnNM9NDOvVYe/HyvjBKjy/iMI9sXpU8WlKtxoJuirD2',1765009741925527,NULL,'2025-12-06 08:29:01'),(29,29,NULL,0,'$2b$12$WLT7WcaC0zc6T/0m9E6HCuoUZQiZCJczXma8uvVAYzE4cEneFc0ae',1765009742469777,NULL,'2025-12-06 08:29:02'),(32,32,NULL,0,'$2b$12$E4lJ01J4t14mQ.y/pL5bo.ygY20W.oZwQzjP71DAV0Dn8bE0ITq7e',1765009742774503,NULL,'2025-12-06 08:29:02'),(35,35,NULL,0,'$2b$12$Bcoab6huWzC8V3/UAv385eV1z.2SGt.dLBhMt70.0ey68EnrVcb8y',1765009751665940,NULL,'2025-12-06 08:29:11'),(38,38,NULL,0,'$2b$12$Kch/Soa58yoCex.Twqcrs.Jp/DvRpUSgPNb5iC6cBWOFkuOpAtcmm',1765009752180653,NULL,'2025-12-06 08:29:12'),(41,41,NULL,0,'$2b$12$BooTWg5Zv6axJls9oD/MXewJ.RDH4OSYhwNrVOjRHbJORoraGB/wu',1765009752540897,NULL,'2025-12-06 08:29:12'),(44,44,NULL,0,'$2b$12$1Xre3ZIIN6pqOPf.uUEtS.JxBdd/1mgCxWa/t/j0zuSpoVoCsebi6',1765009753088824,NULL,'2025-12-06 08:29:13'),(47,47,NULL,0,'$2b$12$3.xYb1D29AhyOV7pT8ZNEe2AT8UjIUjCZGKkMi4UZvkYGivtaMKkS',1765009753478335,NULL,'2025-12-06 08:29:13'),(50,2,NULL,0,'$2b$12$pmZxzkAC9gHslr5ivQt9ZO4dmQaE/zIr2v8Z6TdWlDZbC3ylDgxe2',1765011587024754,NULL,'2025-12-06 08:59:47'),(51,50,NULL,0,'$2b$12$rgFPSD.5F8z3TGurm8cWOuH5EJ6P8vNB3VzFAMMIQTfOvTRENhODm',1765011734793860,NULL,'2025-12-06 09:02:14'),(52,51,NULL,0,'$2b$12$vYJrA.riS9YSRkdG8utD2Olng3US2EARe6EsV0pTf3hcm5Jnv/h4a',1765015983351081,NULL,'2025-12-06 10:13:03'),(53,52,NULL,0,'$2b$12$IB6pBIi9v4Y2yrpR0PSmJePoeicRnBRrcItCsBN3T3TuKo3/aG0le',1765015983828022,NULL,'2025-12-06 10:13:03');
/*!40000 ALTER TABLE `password` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy`
--

DROP TABLE IF EXISTS `policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `blob` text NOT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy`
--

LOCK TABLES `policy` WRITE;
/*!40000 ALTER TABLE `policy` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `policy_association`
--

DROP TABLE IF EXISTS `policy_association`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `policy_association` (
  `id` varchar(64) NOT NULL,
  `policy_id` varchar(64) NOT NULL,
  `endpoint_id` varchar(64) DEFAULT NULL,
  `service_id` varchar(64) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `endpoint_id` (`endpoint_id`,`service_id`,`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `policy_association`
--

LOCK TABLES `policy_association` WRITE;
/*!40000 ALTER TABLE `policy_association` DISABLE KEYS */;
/*!40000 ALTER TABLE `policy_association` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project` (
  `id` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  `parent_id` varchar(64) DEFAULT NULL,
  `is_domain` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_project_name_domain_id` (`domain_id`,`name`),
  KEY `project_parent_id_fkey` (`parent_id`),
  CONSTRAINT `project_domain_id_fkey` FOREIGN KEY (`domain_id`) REFERENCES `project` (`id`),
  CONSTRAINT `project_parent_id_fkey` FOREIGN KEY (`parent_id`) REFERENCES `project` (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project`
--

LOCK TABLES `project` WRITE;
/*!40000 ALTER TABLE `project` DISABLE KEYS */;
INSERT INTO `project` (`id`, `name`, `extra`, `description`, `enabled`, `domain_id`, `parent_id`, `is_domain`) VALUES ('1fdbdbf6894f4d0f8918198e1dc4f03b','alt_demo','{}','Project for Tempest alt_demo_tempestconf user',1,'default','default',0),('3d603431c0bb4967bafc7a0aa6108bfe','admin','{}','Bootstrap project for initializing the cloud.',1,'default','default',0),('660705fe1cbe4111b6f2c99ce8d05c8c','service','{}',NULL,1,'default','default',0),('94e220b3a75b4b7fa2215bcfb787fa7d','heat_stack','{}','',1,'<<keystone.domain.root>>',NULL,1),('9bffcf50ce6c4b07a51d7021f8a9cc25','demo','{}','Project for Tempest demo_tempestconf user',1,'default','default',0),('<<keystone.domain.root>>','<<keystone.domain.root>>','{}','',0,'<<keystone.domain.root>>',NULL,1),('default','Default','{}','The default domain',1,'<<keystone.domain.root>>',NULL,1);
/*!40000 ALTER TABLE `project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint`
--

DROP TABLE IF EXISTS `project_endpoint`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint` (
  `endpoint_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint`
--

LOCK TABLES `project_endpoint` WRITE;
/*!40000 ALTER TABLE `project_endpoint` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_endpoint_group`
--

DROP TABLE IF EXISTS `project_endpoint_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_endpoint_group` (
  `endpoint_group_id` varchar(64) NOT NULL,
  `project_id` varchar(64) NOT NULL,
  PRIMARY KEY (`endpoint_group_id`,`project_id`),
  CONSTRAINT `project_endpoint_group_ibfk_1` FOREIGN KEY (`endpoint_group_id`) REFERENCES `endpoint_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_endpoint_group`
--

LOCK TABLES `project_endpoint_group` WRITE;
/*!40000 ALTER TABLE `project_endpoint_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_endpoint_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_option`
--

DROP TABLE IF EXISTS `project_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_option` (
  `project_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`project_id`,`option_id`),
  CONSTRAINT `project_option_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_option`
--

LOCK TABLES `project_option` WRITE;
/*!40000 ALTER TABLE `project_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_tag`
--

DROP TABLE IF EXISTS `project_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_tag` (
  `project_id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`project_id`,`name`),
  UNIQUE KEY `project_id` (`project_id`,`name`),
  CONSTRAINT `project_tag_ibfk_1` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_tag`
--

LOCK TABLES `project_tag` WRITE;
/*!40000 ALTER TABLE `project_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `region`
--

DROP TABLE IF EXISTS `region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `region` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `parent_region_id` varchar(255) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `region`
--

LOCK TABLES `region` WRITE;
/*!40000 ALTER TABLE `region` DISABLE KEYS */;
INSERT INTO `region` (`id`, `description`, `parent_region_id`, `extra`) VALUES ('regionOne','',NULL,'{}');
/*!40000 ALTER TABLE `region` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registered_limit`
--

DROP TABLE IF EXISTS `registered_limit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `registered_limit` (
  `id` varchar(64) NOT NULL,
  `service_id` varchar(255) DEFAULT NULL,
  `region_id` varchar(64) DEFAULT NULL,
  `resource_name` varchar(255) DEFAULT NULL,
  `default_limit` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `internal_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`internal_id`),
  UNIQUE KEY `registered_limit_id_key` (`id`),
  KEY `region_id` (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `registered_limit`
--

LOCK TABLES `registered_limit` WRITE;
/*!40000 ALTER TABLE `registered_limit` DISABLE KEYS */;
/*!40000 ALTER TABLE `registered_limit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `request_token`
--

DROP TABLE IF EXISTS `request_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `request_token` (
  `id` varchar(64) NOT NULL,
  `request_secret` varchar(64) NOT NULL,
  `verifier` varchar(64) DEFAULT NULL,
  `authorizing_user_id` varchar(64) DEFAULT NULL,
  `requested_project_id` varchar(64) NOT NULL,
  `role_ids` text DEFAULT NULL,
  `consumer_id` varchar(64) NOT NULL,
  `expires_at` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_request_token_consumer_id` (`consumer_id`),
  CONSTRAINT `request_token_ibfk_1` FOREIGN KEY (`consumer_id`) REFERENCES `consumer` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `request_token`
--

LOCK TABLES `request_token` WRITE;
/*!40000 ALTER TABLE `request_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `request_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revocation_event`
--

DROP TABLE IF EXISTS `revocation_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revocation_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` varchar(64) DEFAULT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  `role_id` varchar(64) DEFAULT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `consumer_id` varchar(64) DEFAULT NULL,
  `access_token_id` varchar(64) DEFAULT NULL,
  `issued_before` datetime NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  `revoked_at` datetime NOT NULL,
  `audit_id` varchar(32) DEFAULT NULL,
  `audit_chain_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_revocation_event_new_revoked_at` (`revoked_at`),
  KEY `ix_revocation_event_issued_before` (`issued_before`),
  KEY `ix_revocation_event_project_id_issued_before` (`project_id`,`issued_before`),
  KEY `ix_revocation_event_user_id_issued_before` (`user_id`,`issued_before`),
  KEY `ix_revocation_event_audit_id_issued_before` (`audit_id`,`issued_before`)
) ENGINE=InnoDB AUTO_INCREMENT=1201 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revocation_event`
--

LOCK TABLES `revocation_event` WRITE;
/*!40000 ALTER TABLE `revocation_event` DISABLE KEYS */;
INSERT INTO `revocation_event` (`id`, `domain_id`, `project_id`, `user_id`, `role_id`, `trust_id`, `consumer_id`, `access_token_id`, `issued_before`, `expires_at`, `revoked_at`, `audit_id`, `audit_chain_id`) VALUES (1,NULL,NULL,'ff0049f3313348bdb67886d170c1c765',NULL,NULL,NULL,NULL,'2025-12-06 08:59:47',NULL,'2025-12-06 08:59:47',NULL,NULL),(2,NULL,NULL,'e07e351409454931956261939e395e98',NULL,NULL,NULL,NULL,'2025-12-06 10:13:42',NULL,'2025-12-06 10:13:42',NULL,NULL),(3,NULL,NULL,'a6a847bf9da74eeaa82345f68ce7880c',NULL,NULL,NULL,NULL,'2025-12-06 10:13:43',NULL,'2025-12-06 10:13:43',NULL,NULL),(4,NULL,NULL,'f77c88b9d0bc48f2b4df42e11d603bd1',NULL,NULL,NULL,NULL,'2025-12-06 10:13:43',NULL,'2025-12-06 10:13:43',NULL,NULL),(5,NULL,NULL,'a527c977255c42efbe4d332ef861701f',NULL,NULL,NULL,NULL,'2025-12-06 10:13:43',NULL,'2025-12-06 10:13:43',NULL,NULL),(6,NULL,NULL,'b99b116314bd45c290f23ef9041f4084',NULL,NULL,NULL,NULL,'2025-12-06 10:13:43',NULL,'2025-12-06 10:13:43',NULL,NULL),(7,NULL,NULL,'543fcbb7876f448bbbea78ed82142157',NULL,NULL,NULL,NULL,'2025-12-06 10:13:44',NULL,'2025-12-06 10:13:44',NULL,NULL),(8,NULL,NULL,'5249339f94a4409cb3ad96c97993a48c',NULL,NULL,NULL,NULL,'2025-12-06 10:13:44',NULL,'2025-12-06 10:13:44',NULL,NULL),(9,NULL,NULL,'4dfa1331c8094c25a2c07361a9dad6a5',NULL,NULL,NULL,NULL,'2025-12-06 10:13:44',NULL,'2025-12-06 10:13:44',NULL,NULL),(10,NULL,'f8c44be3c1754d5d8d2e1c3262e4d3ce',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(11,NULL,NULL,'658d5a7fff7f4f4880dc633d756d4a9a',NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(12,NULL,NULL,'37512a10e4514ee2b231e480aceda620',NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(13,NULL,NULL,'02873ba76d1a4f77826aec980d13d8ef',NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(14,NULL,'bb40adcae08a4835b7d01d7f2c052189',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(15,NULL,'8b00fd894fbe43a7a42e465def02b9d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(16,NULL,NULL,'cd6fb9a27b3343f2b536f4bd9a537071',NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(17,NULL,'1d8562fe10e34e8eb1288e8d3690d32c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(18,NULL,NULL,'4feb294037eb45cdac34d3c921bf5fde',NULL,NULL,NULL,NULL,'2025-12-06 10:13:45',NULL,'2025-12-06 10:13:45',NULL,NULL),(19,NULL,'eb7a6e02a38746a58022d848be358d3a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:46',NULL,'2025-12-06 10:13:46',NULL,NULL),(20,NULL,NULL,'d1908af35c2b4e21a42e046c7ac3ff29',NULL,NULL,NULL,NULL,'2025-12-06 10:13:46',NULL,'2025-12-06 10:13:46',NULL,NULL),(21,NULL,'b00ad28e3169491781b9c91f5b8f5fe1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:46',NULL,'2025-12-06 10:13:46',NULL,NULL),(22,NULL,NULL,'d4f71c40f5a3424a88babe5df5452d73',NULL,NULL,NULL,NULL,'2025-12-06 10:13:46',NULL,'2025-12-06 10:13:46',NULL,NULL),(23,NULL,'92383bb1eb6e4973a8d2bcc1d11bb08e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:46',NULL,'2025-12-06 10:13:46',NULL,NULL),(24,NULL,'e11358ba7d9a4ee8852935cb4a1219e8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:47',NULL,'2025-12-06 10:13:47',NULL,NULL),(25,NULL,'a7027df0d9bd48feb13a5ca53c6bcbfc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:47',NULL,'2025-12-06 10:13:47',NULL,NULL),(26,NULL,'dc02107fc9d748c39bb2edb330792baa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:47',NULL,'2025-12-06 10:13:47',NULL,NULL),(27,NULL,'65ccd9a78c1a436ba56e2d5b435d875e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:47',NULL,'2025-12-06 10:13:47',NULL,NULL),(28,NULL,'8d274658f537430ca7b16e6983c68bfd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:48',NULL,'2025-12-06 10:13:48',NULL,NULL),(29,NULL,'e0f49f1234dc402f9cc8b1ca53dfe289',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:48',NULL,'2025-12-06 10:13:48',NULL,NULL),(30,NULL,'dfc67646b79b4f5c87e12173880cfcac',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:48',NULL,'2025-12-06 10:13:48',NULL,NULL),(31,NULL,'26c99ae0c5c340348203a06e8ea35fb5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:49',NULL,'2025-12-06 10:13:49',NULL,NULL),(32,NULL,NULL,'1dbd0d31db664baba96f7f2bddf3d31b',NULL,NULL,NULL,NULL,'2025-12-06 10:13:53',NULL,'2025-12-06 10:13:53',NULL,NULL),(33,NULL,NULL,'ae5bd587f22044a39c8b09473e8e41d8',NULL,NULL,NULL,NULL,'2025-12-06 10:13:53',NULL,'2025-12-06 10:13:53',NULL,NULL),(34,NULL,NULL,'82796abab0cb46bc8da0a2788c3fa3a7',NULL,NULL,NULL,NULL,'2025-12-06 10:13:53',NULL,'2025-12-06 10:13:53',NULL,NULL),(35,NULL,NULL,'1f50e8ca55f841f08476ac962e4268f9',NULL,NULL,NULL,NULL,'2025-12-06 10:13:53',NULL,'2025-12-06 10:13:53',NULL,NULL),(36,NULL,NULL,'5afebb6a39944d34822225ed31f67de1',NULL,NULL,NULL,NULL,'2025-12-06 10:13:53',NULL,'2025-12-06 10:13:53',NULL,NULL),(37,NULL,'2b3299420905437da30323d4619ba270',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:55',NULL,'2025-12-06 10:13:55',NULL,NULL),(38,NULL,'09c16601cc564d38bbbfddf6e3d5dc4b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:55',NULL,'2025-12-06 10:13:55',NULL,NULL),(39,NULL,'cca6147189884eeda06dc8d4c282653a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:55',NULL,'2025-12-06 10:13:55',NULL,NULL),(40,NULL,'f29449ba7c58454b8f2911fcef9cfe5c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:55',NULL,'2025-12-06 10:13:55',NULL,NULL),(41,NULL,'6836d8cec3a34659a8b21edcee149c2b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:56',NULL,'2025-12-06 10:13:56',NULL,NULL),(42,NULL,NULL,'88476b4a8b3d43ac93955fb8d3b1618e',NULL,NULL,NULL,NULL,'2025-12-06 10:13:57',NULL,'2025-12-06 10:13:57',NULL,NULL),(43,NULL,NULL,'b51a513cd4e6444299b1dff6674b585a',NULL,NULL,NULL,NULL,'2025-12-06 10:13:57',NULL,'2025-12-06 10:13:57',NULL,NULL),(44,NULL,NULL,'1744706def56407ca326cb3a7f1d052f',NULL,NULL,NULL,NULL,'2025-12-06 10:13:57',NULL,'2025-12-06 10:13:57',NULL,NULL),(45,NULL,NULL,'5478f7d748d94bd0b3e29d87816ede7b',NULL,NULL,NULL,NULL,'2025-12-06 10:13:57',NULL,'2025-12-06 10:13:57',NULL,NULL),(46,NULL,NULL,'ff86b040d05b4d2abf1dafa92e038d55',NULL,NULL,NULL,NULL,'2025-12-06 10:13:58',NULL,'2025-12-06 10:13:58',NULL,NULL),(47,NULL,'81687e9eb3a9407c8364e3c518f899a3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:59',NULL,'2025-12-06 10:13:59',NULL,NULL),(48,NULL,'c135aca7aa594c3bba67ac5942c30853',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:13:59',NULL,'2025-12-06 10:13:59',NULL,NULL),(49,NULL,NULL,'24a586afa9e74fce93a5c7c0f2bb3409',NULL,NULL,NULL,NULL,'2025-12-06 10:13:59',NULL,'2025-12-06 10:13:59',NULL,NULL),(50,NULL,NULL,'7aaf94e131664a36b200e2e1f9469e91',NULL,NULL,NULL,NULL,'2025-12-06 10:13:59',NULL,'2025-12-06 10:13:59',NULL,NULL),(51,NULL,NULL,'643d797c155642e1bbce4f986bc56195',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(52,NULL,'41c5aacc61744234925562dc59124c52',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(53,NULL,'06cc583d4695483ca3a11aab96b7f65b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(54,NULL,NULL,'fe3f8a37d4ed4d459fe0cfb129e5e3ea',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(55,NULL,NULL,'2a3587b076674ed8ace3f13bf12d3493',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(56,NULL,'ea8858c742414349867392eabcd609b2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(57,NULL,NULL,'3d1a6d5fa243439eaebc262908d7fdcf',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(58,NULL,NULL,'c3fe07fa9aed45a5a9cbf27db792a04d',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(59,NULL,NULL,'c45f654a15494471a4855d57b2684759',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(60,NULL,NULL,'cd763ba84c1c4d31b0dcdf40b6f021b2',NULL,NULL,NULL,NULL,'2025-12-06 10:14:00',NULL,'2025-12-06 10:14:00',NULL,NULL),(61,NULL,'c37fed21dcdd404e96a956e24b46c93b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:01',NULL,'2025-12-06 10:14:01',NULL,NULL),(62,NULL,'ba3bb75b229f410abf0f59c4ed9bb12d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:01',NULL,'2025-12-06 10:14:01',NULL,NULL),(63,NULL,'3d76b57f320341e6a5fd08443a946be1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:02',NULL,'2025-12-06 10:14:02',NULL,NULL),(64,NULL,'9e8a98061c804af9bd2b8bb5909f891f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:02',NULL,'2025-12-06 10:14:02',NULL,NULL),(65,NULL,'1a264223547a41d28ba0c391ddf82333',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:02',NULL,'2025-12-06 10:14:02',NULL,NULL),(66,NULL,'7916c38e7dc743eda55e62fec728706f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:02',NULL,'2025-12-06 10:14:02',NULL,NULL),(67,NULL,'edbb47498f0f4fda9a78097d125b5dd1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:03',NULL,'2025-12-06 10:14:03',NULL,NULL),(68,NULL,'087253f6f7494994b356eb5761f9db69',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:03',NULL,'2025-12-06 10:14:03',NULL,NULL),(69,NULL,'2b5c0f03d3474c798823f58e4e467ad7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:04',NULL,'2025-12-06 10:14:04',NULL,NULL),(70,NULL,NULL,'a9c48334bcff40848d622b4dbd6de545',NULL,NULL,NULL,NULL,'2025-12-06 10:14:06',NULL,'2025-12-06 10:14:06',NULL,NULL),(71,NULL,NULL,'7e93ec4383c74b6f96693d00806f6f25',NULL,NULL,NULL,NULL,'2025-12-06 10:14:06',NULL,'2025-12-06 10:14:06',NULL,NULL),(72,NULL,NULL,'4a0337fd03ba4654a69691195d2fc0ce',NULL,NULL,NULL,NULL,'2025-12-06 10:14:07',NULL,'2025-12-06 10:14:07',NULL,NULL),(73,NULL,NULL,'cc32e5193bc24e5e93d64bcb719cf47a',NULL,NULL,NULL,NULL,'2025-12-06 10:14:07',NULL,'2025-12-06 10:14:07',NULL,NULL),(74,NULL,'37342da569044b4eacedfc2dcc54f101',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:11',NULL,'2025-12-06 10:14:11',NULL,NULL),(75,NULL,'491c9f0ccdfd4dde888539e136583f7a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:11',NULL,'2025-12-06 10:14:11',NULL,NULL),(76,NULL,NULL,'0d62b787ff1f4804adcb5529ad8630e4',NULL,NULL,NULL,NULL,'2025-12-06 10:14:12',NULL,'2025-12-06 10:14:12',NULL,NULL),(77,NULL,NULL,'92683d5b765b4376b8d2cc8c5d532660',NULL,NULL,NULL,NULL,'2025-12-06 10:14:12',NULL,'2025-12-06 10:14:12',NULL,NULL),(78,NULL,'009f263a791a47b79c0efb433ead2b70',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:12',NULL,'2025-12-06 10:14:12',NULL,NULL),(79,NULL,NULL,'ca65788699c04135b1ed8aaf3b822ade',NULL,NULL,NULL,NULL,'2025-12-06 10:14:13',NULL,'2025-12-06 10:14:13',NULL,NULL),(80,NULL,NULL,'8969988703284002a199a8f7050a8d3e',NULL,NULL,NULL,NULL,'2025-12-06 10:14:13',NULL,'2025-12-06 10:14:13',NULL,NULL),(81,NULL,'21ef75252c3948869dee58630cb60048',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:13',NULL,'2025-12-06 10:14:13',NULL,NULL),(82,NULL,NULL,'02d7ee16266e4eb1b10ebf46d01819f9',NULL,NULL,NULL,NULL,'2025-12-06 10:14:13',NULL,'2025-12-06 10:14:13',NULL,NULL),(83,NULL,NULL,'47ad6fcce3ea429e849c9f90bfe42944',NULL,NULL,NULL,NULL,'2025-12-06 10:14:13',NULL,'2025-12-06 10:14:13',NULL,NULL),(84,NULL,'610b865d10df4583937b79de0f4ab279',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:14',NULL,'2025-12-06 10:14:14',NULL,NULL),(85,NULL,'04603fd7848a419bbb102300ef7b0627',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:15',NULL,'2025-12-06 10:14:15',NULL,NULL),(86,NULL,'98baca6a5d164677b63f3dfaf1f2adc9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:15',NULL,'2025-12-06 10:14:15',NULL,NULL),(87,NULL,'195cb056ec0b4bb99f9142ff08c498ce',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:15',NULL,'2025-12-06 10:14:15',NULL,NULL),(88,NULL,'eb0b4a85895e401ca519af93768d6b64',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:15',NULL,'2025-12-06 10:14:15',NULL,NULL),(89,NULL,'2f6a66eceb2241d49e49f69659d2183d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:15',NULL,'2025-12-06 10:14:15',NULL,NULL),(90,NULL,NULL,'a071dde4e21a4104997ced076074955b',NULL,NULL,NULL,NULL,'2025-12-06 10:14:17',NULL,'2025-12-06 10:14:17',NULL,NULL),(91,NULL,NULL,'8af272356e2e443ba1473990a5733a70',NULL,NULL,NULL,NULL,'2025-12-06 10:14:17',NULL,'2025-12-06 10:14:17',NULL,NULL),(92,NULL,NULL,'4a41ae4fc3ce481497ba9fa88b4ea18c',NULL,NULL,NULL,NULL,'2025-12-06 10:14:18',NULL,'2025-12-06 10:14:18',NULL,NULL),(93,NULL,NULL,'99787ecb393f4cecb02fbe085ba01fa2',NULL,NULL,NULL,NULL,'2025-12-06 10:14:18',NULL,'2025-12-06 10:14:18',NULL,NULL),(94,NULL,'c5b1aab2304243c5b89b873c48a7a533',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:19',NULL,'2025-12-06 10:14:19',NULL,NULL),(95,NULL,NULL,'0a73c451d2324047a4c8c5d174679c26',NULL,NULL,NULL,NULL,'2025-12-06 10:14:19',NULL,'2025-12-06 10:14:19',NULL,NULL),(96,NULL,NULL,'88485bfacbd2433a83cfa7b3990983bf',NULL,NULL,NULL,NULL,'2025-12-06 10:14:19',NULL,'2025-12-06 10:14:19',NULL,NULL),(97,NULL,'d74634681b9646d583cbcff48777b93d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:19',NULL,'2025-12-06 10:14:19',NULL,NULL),(98,NULL,NULL,'600ead7cf1904185bd899fb000e4f069',NULL,NULL,NULL,NULL,'2025-12-06 10:14:19',NULL,'2025-12-06 10:14:19',NULL,NULL),(99,NULL,NULL,'01f72bc0493e447b8e64205b986c543b',NULL,NULL,NULL,NULL,'2025-12-06 10:14:20',NULL,'2025-12-06 10:14:20',NULL,NULL),(100,NULL,NULL,'beaf6c45ffa4403f973e364654c47c58',NULL,NULL,NULL,NULL,'2025-12-06 10:14:20',NULL,'2025-12-06 10:14:20',NULL,NULL),(101,NULL,'af35cad1721f4157a071ff2e90641e59',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:20',NULL,'2025-12-06 10:14:20',NULL,NULL),(102,NULL,'22f10c7a09054f058ac962913784aa8a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:20',NULL,'2025-12-06 10:14:20',NULL,NULL),(103,NULL,'6cf5120a5dde4794a83f77c48dfcfcec',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:21',NULL,'2025-12-06 10:14:21',NULL,NULL),(104,NULL,'8b45ed0d762747b4a27ad78d879f59e8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:21',NULL,'2025-12-06 10:14:21',NULL,NULL),(105,NULL,'91fa65de79904dde9f36758573e25486',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:22',NULL,'2025-12-06 10:14:22',NULL,NULL),(106,NULL,'57c9f39ae20545aca7be3f46dd0caee1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:22',NULL,'2025-12-06 10:14:22',NULL,NULL),(107,NULL,'486cc2f6bd194df5ba9ff6a05e6af745',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:23',NULL,'2025-12-06 10:14:23',NULL,NULL),(108,NULL,NULL,'65c906c0405b4778b550d221e455be73',NULL,NULL,NULL,NULL,'2025-12-06 10:14:25',NULL,'2025-12-06 10:14:25',NULL,NULL),(109,NULL,NULL,'27d815a82e334ef5b8d7c51d031cec87',NULL,NULL,NULL,NULL,'2025-12-06 10:14:25',NULL,'2025-12-06 10:14:25',NULL,NULL),(110,NULL,NULL,'01b3c0add7204bb382b5cb95d9661edf',NULL,NULL,NULL,NULL,'2025-12-06 10:14:26',NULL,'2025-12-06 10:14:26',NULL,NULL),(111,NULL,NULL,'34bce883e5814bc49630b0242bdf5327',NULL,NULL,NULL,NULL,'2025-12-06 10:14:26',NULL,'2025-12-06 10:14:26',NULL,NULL),(112,NULL,NULL,'073c17223b2948d2b0856e35b8cbfa54',NULL,NULL,NULL,NULL,'2025-12-06 10:14:26',NULL,'2025-12-06 10:14:26',NULL,NULL),(113,NULL,'2309270ab89c466897f788aa6aee0ff1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:27',NULL,'2025-12-06 10:14:27',NULL,NULL),(114,NULL,'c46a753e5a6d41f8ae359b04c6ccf2ff',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:27',NULL,'2025-12-06 10:14:27',NULL,NULL),(115,NULL,'2c2a11bbe7204c89a9a04173fcfbe727',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:27',NULL,'2025-12-06 10:14:27',NULL,NULL),(116,NULL,'924bfd206b0a4450918e43883472bc75',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:28',NULL,'2025-12-06 10:14:28',NULL,NULL),(117,NULL,'d7faecc174944b988107cc8591c76cc4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:29',NULL,'2025-12-06 10:14:29',NULL,NULL),(118,NULL,NULL,'a7a1b5ceda8c4c708630198ae672df22',NULL,NULL,NULL,NULL,'2025-12-06 10:14:31',NULL,'2025-12-06 10:14:31',NULL,NULL),(119,NULL,'609a7dd5befb49f3955cb5336852979c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(120,NULL,'cddd4f4b159041c1a8e0ce251d3b088d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(121,NULL,NULL,'7205e46df36e4523bdb7c37fe55eff3b',NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(122,NULL,NULL,'7d54ccf063a3424a90cc6f2ac7c72fce',NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(123,NULL,'04e3ea4788184bbd8bd3893d159ad65d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(124,NULL,NULL,'62abe04ecced48b08df36dbd152755a4',NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(125,NULL,NULL,'5109b15bc0194e248d9edd323a7288ed',NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(126,NULL,NULL,'861c0cbbaa154847a5eb89ca3f8f1d1b',NULL,NULL,NULL,NULL,'2025-12-06 10:14:32',NULL,'2025-12-06 10:14:32',NULL,NULL),(127,NULL,'a16fb252498e4ac6a72a5eb5c3f878da',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:34',NULL,'2025-12-06 10:14:34',NULL,NULL),(128,NULL,'1079624669bb4b039905d398fd330d27',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:35',NULL,'2025-12-06 10:14:35',NULL,NULL),(129,NULL,'08b7197e68e240fd90268915662a52f0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:35',NULL,'2025-12-06 10:14:35',NULL,NULL),(130,NULL,NULL,'b189412eea3b4e89aa2c6ca8c321d33b',NULL,NULL,NULL,NULL,'2025-12-06 10:14:35',NULL,'2025-12-06 10:14:35',NULL,NULL),(131,NULL,NULL,'0049dea8bc484a288929415f0278d57a',NULL,NULL,NULL,NULL,'2025-12-06 10:14:36',NULL,'2025-12-06 10:14:36',NULL,NULL),(132,NULL,'f8c8ed051d6f4aab98821a366a2a0a0e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:36',NULL,'2025-12-06 10:14:36',NULL,NULL),(133,NULL,'550f4c3bf626406eac0d7f6f917d607c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:37',NULL,'2025-12-06 10:14:37',NULL,NULL),(134,NULL,'206fcaa64fd14d0ea5fb23a017c43692',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:37',NULL,'2025-12-06 10:14:37',NULL,NULL),(135,NULL,'04f03920de874958b40e939f67f48a79',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:37',NULL,'2025-12-06 10:14:37',NULL,NULL),(136,NULL,NULL,'be18359917984743bd584fc2f38cddd1',NULL,NULL,NULL,NULL,'2025-12-06 10:14:39',NULL,'2025-12-06 10:14:39',NULL,NULL),(137,NULL,NULL,'27414936e7024d36824414c61b47b53a',NULL,NULL,NULL,NULL,'2025-12-06 10:14:40',NULL,'2025-12-06 10:14:40',NULL,NULL),(138,NULL,'6c58e48150214feebd6ae7accc221ca2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:41',NULL,'2025-12-06 10:14:41',NULL,NULL),(139,NULL,'64910c968d504fd491977b85d889751e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:41',NULL,'2025-12-06 10:14:41',NULL,NULL),(140,NULL,NULL,'c90e6a3c74fe413082b1f625d78b7183',NULL,NULL,NULL,NULL,'2025-12-06 10:14:41',NULL,'2025-12-06 10:14:41',NULL,NULL),(141,NULL,'4afbbe80e0e24a74bfd71057c09d994a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:41',NULL,'2025-12-06 10:14:41',NULL,NULL),(142,NULL,NULL,'4ae9872b4e944fd293080324db2bd4ef',NULL,NULL,NULL,NULL,'2025-12-06 10:14:41',NULL,'2025-12-06 10:14:41',NULL,NULL),(143,NULL,NULL,'ac76d8870bdf4cf9a25db4bac7340111',NULL,NULL,NULL,NULL,'2025-12-06 10:14:42',NULL,'2025-12-06 10:14:42',NULL,NULL),(144,NULL,'68fae8cf1bf74937b7e074397966404f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:42',NULL,'2025-12-06 10:14:42',NULL,NULL),(145,NULL,NULL,'8ffde49d51424081b03ed87bf6357c41',NULL,NULL,NULL,NULL,'2025-12-06 10:14:42',NULL,'2025-12-06 10:14:42',NULL,NULL),(146,NULL,NULL,'257f0d4d07ad4ed2986f6001b0e764f7',NULL,NULL,NULL,NULL,'2025-12-06 10:14:42',NULL,'2025-12-06 10:14:42',NULL,NULL),(147,NULL,'658502c9210040cdab0145717c83bd96',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:44',NULL,'2025-12-06 10:14:44',NULL,NULL),(148,NULL,'ce5b9c4df2a24695b04b9e5c24f05fea',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:45',NULL,'2025-12-06 10:14:45',NULL,NULL),(149,NULL,'fabee405989444a5840d782c3a126fe9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:46',NULL,'2025-12-06 10:14:46',NULL,NULL),(150,NULL,'d8fdc1eb63384f9fba15677d6f1fe57a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:46',NULL,'2025-12-06 10:14:46',NULL,NULL),(151,NULL,NULL,'4c3e40e59c0843abb7a0b31dbcd02f11',NULL,NULL,NULL,NULL,'2025-12-06 10:14:49',NULL,'2025-12-06 10:14:49',NULL,NULL),(152,NULL,NULL,'3305ac7b3c82439cb814a04c4211218c',NULL,NULL,NULL,NULL,'2025-12-06 10:14:50',NULL,'2025-12-06 10:14:50',NULL,NULL),(153,NULL,NULL,'cfe64314a29a44408c83817ca07ddd29',NULL,NULL,NULL,NULL,'2025-12-06 10:14:50',NULL,'2025-12-06 10:14:50',NULL,NULL),(154,NULL,'41ed961ccfe7413ca8204a5876e18812',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:51',NULL,'2025-12-06 10:14:51',NULL,NULL),(155,NULL,'acf759eaeb7446fc88bc4e5b64754b6b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:51',NULL,'2025-12-06 10:14:51',NULL,NULL),(156,NULL,'49ff1120e80846a8aeeae2de42ef3434',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:52',NULL,'2025-12-06 10:14:52',NULL,NULL),(157,NULL,NULL,'8fb403e5e83e44e19338be9f0607386e',NULL,NULL,NULL,NULL,'2025-12-06 10:14:54',NULL,'2025-12-06 10:14:54',NULL,NULL),(158,NULL,'f162d01914e3436da8fbdffa5e76b1f3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:14:56',NULL,'2025-12-06 10:14:56',NULL,NULL),(159,NULL,NULL,'6ede07e511704a5baa73d4775d347df0',NULL,NULL,NULL,NULL,'2025-12-06 10:15:00',NULL,'2025-12-06 10:15:00',NULL,NULL),(160,NULL,NULL,'93398e7cebe4412498cc4aa3a27a3f7c',NULL,NULL,NULL,NULL,'2025-12-06 10:15:00',NULL,'2025-12-06 10:15:00',NULL,NULL),(161,NULL,'626afb53f81241b2ae93be35fdaa3656',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:05',NULL,'2025-12-06 10:15:05',NULL,NULL),(162,NULL,'228fc5efa6134c1e885bd45c6289a5c7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:08',NULL,'2025-12-06 10:15:08',NULL,NULL),(163,NULL,NULL,'2cb6666fd09f40cbbf981d3652611875',NULL,NULL,NULL,NULL,'2025-12-06 10:15:12',NULL,'2025-12-06 10:15:12',NULL,NULL),(164,NULL,NULL,'04e47aa7567d4f03835e237e099ca6f6',NULL,NULL,NULL,NULL,'2025-12-06 10:15:12',NULL,'2025-12-06 10:15:12',NULL,NULL),(165,NULL,NULL,'3a50fae64027482ba5b10005ed97189e',NULL,NULL,NULL,NULL,'2025-12-06 10:15:13',NULL,'2025-12-06 10:15:13',NULL,NULL),(166,NULL,'498c913826fe4186acceec9a4f78e154',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:14',NULL,'2025-12-06 10:15:14',NULL,NULL),(167,NULL,'024b6fbc052c4ed7a93c855bd2ae77da',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:14',NULL,'2025-12-06 10:15:14',NULL,NULL),(168,NULL,'4a48180c92de4087813757acb72ce555',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:16',NULL,'2025-12-06 10:15:16',NULL,NULL),(169,NULL,NULL,'78da5ea3b1644be896d4d5775e97b8b1',NULL,NULL,NULL,NULL,'2025-12-06 10:15:18',NULL,'2025-12-06 10:15:18',NULL,NULL),(170,NULL,NULL,'2c8ef12de29948549615dd4b3cbcf221',NULL,NULL,NULL,NULL,'2025-12-06 10:15:18',NULL,'2025-12-06 10:15:18',NULL,NULL),(171,NULL,NULL,'a2ac2d8b36b94c608ab35ca7b5072422',NULL,NULL,NULL,NULL,'2025-12-06 10:15:18',NULL,'2025-12-06 10:15:18',NULL,NULL),(172,NULL,NULL,'b92e3d1826404618a930be17226753fd',NULL,NULL,NULL,NULL,'2025-12-06 10:15:19',NULL,'2025-12-06 10:15:19',NULL,NULL),(173,NULL,NULL,'3fe0113db4b648828d9cfdb142cfaa17',NULL,NULL,NULL,NULL,'2025-12-06 10:15:19',NULL,'2025-12-06 10:15:19',NULL,NULL),(174,NULL,NULL,'9b27ebb6c0974cdf8b17b6a05e331a3f',NULL,NULL,NULL,NULL,'2025-12-06 10:15:19',NULL,'2025-12-06 10:15:19',NULL,NULL),(175,NULL,'4185da56d12649bc8653dd9db208c0a0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:19',NULL,'2025-12-06 10:15:19',NULL,NULL),(176,NULL,'fa4008188037475c90c51de7a04028c2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:20',NULL,'2025-12-06 10:15:20',NULL,NULL),(177,NULL,'588bc73577e04c55b9b40995b6565d7d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:20',NULL,'2025-12-06 10:15:20',NULL,NULL),(178,NULL,'a7eab385c1fb4506aac43d505452200e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:21',NULL,'2025-12-06 10:15:21',NULL,NULL),(179,NULL,NULL,'740ed36be7cc45b0b6b307fc0a98cc7b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:22',NULL,'2025-12-06 10:15:22',NULL,NULL),(180,NULL,NULL,'eaf92332840e4b6487468b201a13e53f',NULL,NULL,NULL,NULL,'2025-12-06 10:15:22',NULL,'2025-12-06 10:15:22',NULL,NULL),(181,NULL,NULL,'c086da9e89444ea4bfa043a07c97e355',NULL,NULL,NULL,NULL,'2025-12-06 10:15:23',NULL,'2025-12-06 10:15:23',NULL,NULL),(182,NULL,'df2e4b157bba4692ae2bf21073362d69',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:23',NULL,'2025-12-06 10:15:23',NULL,NULL),(183,NULL,'d26c954712724bae88a84a90124d9b05',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:23',NULL,'2025-12-06 10:15:23',NULL,NULL),(184,NULL,'088ea8df069043ee8ed156bf735134b7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:23',NULL,'2025-12-06 10:15:23',NULL,NULL),(185,NULL,'c3447953b028436185aa0b74b2c95827',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:24',NULL,'2025-12-06 10:15:24',NULL,NULL),(186,NULL,NULL,'ca7f4f7a87c04cf0a453c208af450982',NULL,NULL,NULL,NULL,'2025-12-06 10:15:24',NULL,'2025-12-06 10:15:24',NULL,NULL),(187,NULL,NULL,'cad8feab32ef47dca2b940a3f1546935',NULL,NULL,NULL,NULL,'2025-12-06 10:15:24',NULL,'2025-12-06 10:15:24',NULL,NULL),(188,NULL,'a5c2b3498ef548d1ac8bd71cba712c8e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:24',NULL,'2025-12-06 10:15:24',NULL,NULL),(189,NULL,NULL,'496ca8bf29dc4e81ba0b08a592dc45d3',NULL,NULL,NULL,NULL,'2025-12-06 10:15:24',NULL,'2025-12-06 10:15:24',NULL,NULL),(190,NULL,NULL,'83cd451c5dc442c78643ba7608b7134a',NULL,NULL,NULL,NULL,'2025-12-06 10:15:25',NULL,'2025-12-06 10:15:25',NULL,NULL),(191,NULL,'12d8a1edb46f4ab694ecfa114ff730e4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:25',NULL,'2025-12-06 10:15:25',NULL,NULL),(192,NULL,'05374c1accc54a6bbe097d7421d3dc15',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:26',NULL,'2025-12-06 10:15:26',NULL,NULL),(193,NULL,'48c16b78edd4478f9497cfefc6873978',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:26',NULL,'2025-12-06 10:15:26',NULL,NULL),(194,NULL,NULL,'33183cd0374942d28883fcbc749d1e76',NULL,NULL,NULL,NULL,'2025-12-06 10:15:27',NULL,'2025-12-06 10:15:27',NULL,NULL),(195,NULL,NULL,'527d03b2592948a6a3b074d9736b910f',NULL,NULL,NULL,NULL,'2025-12-06 10:15:27',NULL,'2025-12-06 10:15:27',NULL,NULL),(196,NULL,'c6d84801a8b44d9da497e9761a0cd10c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:27',NULL,'2025-12-06 10:15:27',NULL,NULL),(197,NULL,NULL,'aa1036b09aed467da9d6df1bc108e96b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:27',NULL,'2025-12-06 10:15:27',NULL,NULL),(198,NULL,'7e4c0d33e9f3470f9c2e04d1d0b3fdd5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:28',NULL,'2025-12-06 10:15:28',NULL,NULL),(199,NULL,'95af0a84c30a4b5f831184cbee2f38b0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:29',NULL,'2025-12-06 10:15:29',NULL,NULL),(200,NULL,NULL,'5599b466684245b6974fb7bba0818ae3',NULL,NULL,NULL,NULL,'2025-12-06 10:15:30',NULL,'2025-12-06 10:15:30',NULL,NULL),(201,NULL,NULL,'4544b0f9267a44b6b37c2cc815270ba3',NULL,NULL,NULL,NULL,'2025-12-06 10:15:30',NULL,'2025-12-06 10:15:30',NULL,NULL),(202,NULL,NULL,'76251f9cc9654c81911c7f4e907b5ca4',NULL,NULL,NULL,NULL,'2025-12-06 10:15:31',NULL,'2025-12-06 10:15:31',NULL,NULL),(203,NULL,NULL,'5d11b6d018dd4abbb77f39ff8952fe05',NULL,NULL,NULL,NULL,'2025-12-06 10:15:31',NULL,'2025-12-06 10:15:31',NULL,NULL),(204,NULL,'a524763aaaa04d5b944a160695ff6ee2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:31',NULL,'2025-12-06 10:15:31',NULL,NULL),(205,NULL,'3c7bc69185ca490682be0143f3e9252c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:32',NULL,'2025-12-06 10:15:32',NULL,NULL),(206,NULL,'6982cb276bf64f0a9d9c8db7370079ba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:33',NULL,'2025-12-06 10:15:33',NULL,NULL),(207,NULL,'b31055a5942740fcac19e00849fa48a9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:33',NULL,'2025-12-06 10:15:33',NULL,NULL),(208,NULL,NULL,'a28a36eef2ba406a9bf7cdc22c3b8b6f',NULL,NULL,NULL,NULL,'2025-12-06 10:15:35',NULL,'2025-12-06 10:15:35',NULL,NULL),(209,NULL,'2ecd43c0500a4375abb91ad0757f047a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:35',NULL,'2025-12-06 10:15:35',NULL,NULL),(210,NULL,'b26307071caf4c8b9b7c4e480d442a29',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:35',NULL,'2025-12-06 10:15:35',NULL,NULL),(211,NULL,'e6b51606b9cf4b8ab40fbbdf62333d60',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:35',NULL,'2025-12-06 10:15:35',NULL,NULL),(212,NULL,'9d844b6e2e824ed7b1733398a0a6a76b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:36',NULL,'2025-12-06 10:15:36',NULL,NULL),(213,NULL,'a3f123c2712e45689d1ce3836f074d73',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:36',NULL,'2025-12-06 10:15:36',NULL,NULL),(214,NULL,'8c785d11d2b5468cb7fcdfe03f65648a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:37',NULL,'2025-12-06 10:15:37',NULL,NULL),(215,NULL,'50587f7265c542539b83e607a607bc41',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:37',NULL,'2025-12-06 10:15:37',NULL,NULL),(216,NULL,NULL,'24fd6bc8a9da410b93f4a47f43a8e2fc',NULL,NULL,NULL,NULL,'2025-12-06 10:15:38',NULL,'2025-12-06 10:15:38',NULL,NULL),(217,NULL,'39f12aa3c4b249adb9cccae0a4841f57',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:38',NULL,'2025-12-06 10:15:38',NULL,NULL),(218,NULL,'244c7122e7ae4db1b164c1d9a4f791bd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:38',NULL,'2025-12-06 10:15:38',NULL,NULL),(219,NULL,'7ca7a580a24747668f00612843ee9f2b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:39',NULL,'2025-12-06 10:15:39',NULL,NULL),(220,NULL,'1c6ac712d66d46d48f245ae1d13fb4bf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:39',NULL,'2025-12-06 10:15:39',NULL,NULL),(221,NULL,'9523eabb1c094cd38d4c26d63f006639',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:39',NULL,'2025-12-06 10:15:39',NULL,NULL),(222,NULL,'471396b1e44c47979f397ffe3cd31258',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:40',NULL,'2025-12-06 10:15:40',NULL,NULL),(223,NULL,NULL,'af36b11804eb4cef886342d70b3d817b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:40',NULL,'2025-12-06 10:15:40',NULL,NULL),(224,NULL,'9ad36f14b7fc4a85801bb8ee7527646a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:40',NULL,'2025-12-06 10:15:40',NULL,NULL),(225,NULL,'d8228ff8e94c455e80815149a2c47ee1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:40',NULL,'2025-12-06 10:15:40',NULL,NULL),(226,NULL,'1386cf6e433243f98b5eb40b3e507cca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:40',NULL,'2025-12-06 10:15:40',NULL,NULL),(227,NULL,'ad206428e5c74216afba6367c9ccd66d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:41',NULL,'2025-12-06 10:15:41',NULL,NULL),(228,NULL,'8650003049a043cd9f31897c1fc1dc0a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:41',NULL,'2025-12-06 10:15:41',NULL,NULL),(229,NULL,NULL,'e56def56d7b645bb8f630596d90763d3',NULL,NULL,NULL,NULL,'2025-12-06 10:15:41',NULL,'2025-12-06 10:15:41',NULL,NULL),(230,NULL,NULL,'af36b11804eb4cef886342d70b3d817b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:41',NULL,'2025-12-06 10:15:41',NULL,NULL),(231,NULL,NULL,'d84003cac1b044ab97a0b317811f67e3',NULL,NULL,NULL,NULL,'2025-12-06 10:15:41',NULL,'2025-12-06 10:15:41',NULL,NULL),(232,NULL,'8366521f8e0041ee8a57c9c845f0baef',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(233,NULL,'f5ffce2dde8c43369d1a180b6ca63062',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(234,NULL,NULL,'ac2e85103fd14829ad4e6df2357da95b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(235,NULL,'ffc0e0a9cef24805bde3ab047c86ebd1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(236,NULL,NULL,'310ca84346a742a09c8478aa7405cb30',NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(237,NULL,NULL,'024c3e9413fe462a99234b279c50f504',NULL,NULL,NULL,NULL,'2025-12-06 10:15:42',NULL,'2025-12-06 10:15:42',NULL,NULL),(238,NULL,'5bd426c09dd743399e71eb5c44db45cb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(239,NULL,'71a9650c6d3248aebaa113a8a82a862f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(240,NULL,NULL,'2ad652a51e13422da9534c4d4743bdc4',NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44','saqB0bBjR16D8QkkNA7smA',NULL),(242,NULL,'47cdc09a0edc4e90a8790944545a6c24',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(243,NULL,'718812fbe5b94cc0b9b51644cd44f086',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(244,NULL,'4efc75ec2bad464ab73c34f86dfbf712',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:44',NULL,'2025-12-06 10:15:44',NULL,NULL),(245,NULL,'7897d6398eb64eb29c66df8db792e581',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:45',NULL,'2025-12-06 10:15:45',NULL,NULL),(246,NULL,'f8cbf1b65a0247ee957db1cf163dd79a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:45',NULL,'2025-12-06 10:15:45',NULL,NULL),(247,NULL,NULL,'0e4b1500174547a1be8ce7c7cbef0ad7',NULL,NULL,NULL,NULL,'2025-12-06 10:15:45',NULL,'2025-12-06 10:15:45',NULL,NULL),(248,NULL,NULL,'a7fdcff30bff44a185ac564b30b08415',NULL,NULL,NULL,NULL,'2025-12-06 10:15:46',NULL,'2025-12-06 10:15:46',NULL,NULL),(249,NULL,NULL,'75a48bc73240408dacdd0e9071c91a76',NULL,NULL,NULL,NULL,'2025-12-06 10:15:46',NULL,'2025-12-06 10:15:46',NULL,NULL),(250,NULL,NULL,'af36b11804eb4cef886342d70b3d817b',NULL,NULL,NULL,NULL,'2025-12-06 10:15:46',NULL,'2025-12-06 10:15:46',NULL,NULL),(251,NULL,'d82b2773d05d44178b44bddca776cc58',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:48',NULL,'2025-12-06 10:15:48',NULL,NULL),(252,NULL,NULL,'96a229c1d7c440ce81c3808bc6d2aa45',NULL,NULL,NULL,NULL,'2025-12-06 10:15:48',NULL,'2025-12-06 10:15:48',NULL,NULL),(253,NULL,'c7a82b77f060446b8192cd7c16955179',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:48',NULL,'2025-12-06 10:15:48',NULL,NULL),(254,NULL,NULL,'d850e60a87184ef7afdb0fea7637da1e',NULL,NULL,NULL,NULL,'2025-12-06 10:15:49',NULL,'2025-12-06 10:15:49',NULL,NULL),(255,NULL,'e3db80915f7b4fd7b3d0f43a40c59f2b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:51',NULL,'2025-12-06 10:15:51',NULL,NULL),(256,NULL,'6a4e3235c97a48e7bcf129e63613de1b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:52',NULL,'2025-12-06 10:15:52',NULL,NULL),(257,NULL,'5e31546837da4e31a9746f95dba0a9d7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:53',NULL,'2025-12-06 10:15:53',NULL,NULL),(258,NULL,'360cf04977084d87b35f455de1e6e390',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:53',NULL,'2025-12-06 10:15:53',NULL,NULL),(259,NULL,NULL,'d8ce4d6c2851423c8369eb083bf64fbb',NULL,NULL,NULL,NULL,'2025-12-06 10:15:55',NULL,'2025-12-06 10:15:55',NULL,NULL),(260,NULL,NULL,'301435f7a5b44b3580f258b2ecc84ffb',NULL,NULL,NULL,NULL,'2025-12-06 10:15:55',NULL,'2025-12-06 10:15:55',NULL,NULL),(261,NULL,NULL,'7741dd16b3ac49918ff1268e1555d58a',NULL,NULL,NULL,NULL,'2025-12-06 10:15:55',NULL,'2025-12-06 10:15:55',NULL,NULL),(262,NULL,'04cdbd0da4d445b09006175f4c7a9ceb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:57',NULL,'2025-12-06 10:15:57',NULL,NULL),(263,NULL,NULL,'13e82032e79e47d4b0ada4de06e4f30a',NULL,NULL,NULL,NULL,'2025-12-06 10:15:58',NULL,'2025-12-06 10:15:58',NULL,NULL),(264,NULL,NULL,'9dcb3bd6bafe48bc9d741f09867eb2eb',NULL,NULL,NULL,NULL,'2025-12-06 10:15:58',NULL,'2025-12-06 10:15:58',NULL,NULL),(265,NULL,'f72ec4a8ddbd420384defdc216c53ba3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:58',NULL,'2025-12-06 10:15:58',NULL,NULL),(266,NULL,'0b8484edb91f445fbff09b61ae2b794b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:15:58',NULL,'2025-12-06 10:15:58',NULL,NULL),(267,NULL,NULL,'bd76e13cde8e44e8ba695c885208c142',NULL,NULL,NULL,NULL,'2025-12-06 10:16:00',NULL,'2025-12-06 10:16:00',NULL,NULL),(268,NULL,'92ff820405a14ec0829cd13c7d953ffd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:00',NULL,'2025-12-06 10:16:00',NULL,NULL),(269,NULL,'fb7b278c7acd4aea865d690e676ef9f6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:01',NULL,'2025-12-06 10:16:01',NULL,NULL),(270,NULL,NULL,'9904436cd0fb43ccafe86d4c0b3eba3f',NULL,NULL,NULL,NULL,'2025-12-06 10:16:02',NULL,'2025-12-06 10:16:02',NULL,NULL),(271,NULL,NULL,'aa39a1306e4049adaff4d6c53fce06eb',NULL,NULL,NULL,NULL,'2025-12-06 10:16:02',NULL,'2025-12-06 10:16:02',NULL,NULL),(272,NULL,'2d992c63411c44a6a706cfad65af19e3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:03',NULL,'2025-12-06 10:16:03',NULL,NULL),(273,NULL,'73b8cef6f6c54c64a624f6b9edeae374',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:03',NULL,'2025-12-06 10:16:03',NULL,NULL),(274,NULL,NULL,'6cf32e59ba8e4d00b8b9e69d9e03a540',NULL,NULL,NULL,NULL,'2025-12-06 10:16:04',NULL,'2025-12-06 10:16:04',NULL,NULL),(275,NULL,'28dbb54e458d46ec9944f16d3dbc7b04',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:05',NULL,'2025-12-06 10:16:05',NULL,NULL),(276,NULL,NULL,'da7bbd24eb95438897585b10577ea2e0',NULL,NULL,NULL,NULL,'2025-12-06 10:16:06',NULL,'2025-12-06 10:16:06',NULL,NULL),(277,NULL,'da995d8e002548889747013c0eeca935',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:06',NULL,'2025-12-06 10:16:06',NULL,NULL),(278,NULL,'7b94b0411da14b45846fb29e1c9660c9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:06',NULL,'2025-12-06 10:16:06',NULL,NULL),(279,NULL,NULL,'97e4f06099f04df1bb810449f688c6ac',NULL,NULL,NULL,NULL,'2025-12-06 10:16:07',NULL,'2025-12-06 10:16:07',NULL,NULL),(280,NULL,NULL,'a037edbd003c4ad1abe475adfe45c242',NULL,NULL,NULL,NULL,'2025-12-06 10:16:09',NULL,'2025-12-06 10:16:09',NULL,NULL),(281,NULL,'f7f7a421249944a7a68a80478e32eed0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:09',NULL,'2025-12-06 10:16:09',NULL,NULL),(282,NULL,NULL,'a6ce7ad35b314f4f9673e8df99eff4a3',NULL,NULL,NULL,NULL,'2025-12-06 10:16:11',NULL,'2025-12-06 10:16:11',NULL,NULL),(283,NULL,NULL,'ecb4c8d2a70c4e20b27ee3d8daf2f4ad',NULL,NULL,NULL,NULL,'2025-12-06 10:16:11',NULL,'2025-12-06 10:16:11',NULL,NULL),(284,NULL,'d3e2dff025dc4eabbf74cbcc5715fe84',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:11',NULL,'2025-12-06 10:16:11',NULL,NULL),(285,NULL,NULL,'6db3db0cf4d144018749199918c19ecd',NULL,NULL,NULL,NULL,'2025-12-06 10:16:11',NULL,'2025-12-06 10:16:11',NULL,NULL),(286,NULL,NULL,'7050052642404ca78e7529ebddb9e41f',NULL,NULL,NULL,NULL,'2025-12-06 10:16:12',NULL,'2025-12-06 10:16:12',NULL,NULL),(287,NULL,NULL,'b203a264b61d4d74a5eff5734b774863',NULL,NULL,NULL,NULL,'2025-12-06 10:16:12',NULL,'2025-12-06 10:16:12',NULL,NULL),(288,NULL,'bdeb811f2d72406d9e78f3e55cc3e985',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:14',NULL,'2025-12-06 10:16:14',NULL,NULL),(289,NULL,'eb829c5db97a4c82b35011f68e8c1e65',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:14',NULL,'2025-12-06 10:16:14',NULL,NULL),(290,NULL,NULL,'5f8096d40acc48c5aa744f03fe343e10',NULL,NULL,NULL,NULL,'2025-12-06 10:16:14',NULL,'2025-12-06 10:16:14',NULL,NULL),(291,NULL,NULL,'58bc47db53ed40cd951fd4ab5c7e9383',NULL,NULL,NULL,NULL,'2025-12-06 10:16:14',NULL,'2025-12-06 10:16:14',NULL,NULL),(292,NULL,'44e6bb9426fc43a084f983db0bd7f0ad',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:15',NULL,'2025-12-06 10:16:15',NULL,NULL),(293,NULL,'faab36cae04e43609ab666ff23bebe25',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:15',NULL,'2025-12-06 10:16:15',NULL,NULL),(294,NULL,'22ce20552d574cab9c49ede157caade3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:15',NULL,'2025-12-06 10:16:15',NULL,NULL),(295,NULL,'8c7fcc595df946d3b80ce18b65f4901e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:16',NULL,'2025-12-06 10:16:16',NULL,NULL),(296,NULL,NULL,'6db3db0cf4d144018749199918c19ecd',NULL,NULL,NULL,NULL,'2025-12-06 10:16:17',NULL,'2025-12-06 10:16:17',NULL,NULL),(297,NULL,NULL,'b25d9e5ec9eb4368a764482a325b9dda',NULL,NULL,NULL,NULL,'2025-12-06 10:16:17',NULL,'2025-12-06 10:16:17',NULL,NULL),(298,NULL,NULL,'c0f82d42124043bcb076ae248bc35f73',NULL,NULL,NULL,NULL,'2025-12-06 10:16:18',NULL,'2025-12-06 10:16:18',NULL,NULL),(299,NULL,NULL,'5818a8fe432a416b95d40fdeac421d6d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:18',NULL,'2025-12-06 10:16:18',NULL,NULL),(300,NULL,'bf2d32459c0141c2af051c8982de277a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:18',NULL,'2025-12-06 10:16:18',NULL,NULL),(301,NULL,'9167331b2c424ef6961b096b551f8434',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:18',NULL,'2025-12-06 10:16:18',NULL,NULL),(302,NULL,'bfa8183c4d6a46b081720844d42b0e87',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:18',NULL,'2025-12-06 10:16:18',NULL,NULL),(303,NULL,NULL,'dfd4de58e97d4e52849b63b0fc1b4d1b',NULL,NULL,NULL,NULL,'2025-12-06 10:16:19',NULL,'2025-12-06 10:16:19',NULL,NULL),(304,NULL,NULL,'72f94879e49942dda8a886e72a73efc7',NULL,NULL,NULL,NULL,'2025-12-06 10:16:19',NULL,'2025-12-06 10:16:19',NULL,NULL),(305,NULL,'a6fa097c65ea481a8cc5f0a5d3880aa4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:19',NULL,'2025-12-06 10:16:19',NULL,NULL),(306,NULL,'d60454a44a4b4482bf705ee4e3667605',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:19',NULL,'2025-12-06 10:16:19',NULL,NULL),(307,NULL,NULL,'035d4c7f669c4705bdf820ffa711aebc',NULL,NULL,NULL,NULL,'2025-12-06 10:16:20',NULL,'2025-12-06 10:16:20',NULL,NULL),(308,NULL,NULL,'26a188170d784400936986771b0b0cbc',NULL,NULL,NULL,NULL,'2025-12-06 10:16:20',NULL,'2025-12-06 10:16:20',NULL,NULL),(309,NULL,'baa9e6ac247744ab85d5b4bfb80250d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:21',NULL,'2025-12-06 10:16:21',NULL,NULL),(310,NULL,'3cb45335e4b5437ea1de7a3553462339',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:21',NULL,'2025-12-06 10:16:21',NULL,NULL),(311,NULL,'ff7f7e96a1554dd881e47e962de06c75',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:22',NULL,'2025-12-06 10:16:22',NULL,NULL),(312,NULL,'67444daa4d2b4cba95112bf7024758fb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:22',NULL,'2025-12-06 10:16:22',NULL,NULL),(313,NULL,'ab55ad805d244e5c98eb27e349180ec8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:22',NULL,'2025-12-06 10:16:22',NULL,NULL),(314,NULL,'63aecdc1483f4f228349046b4f2c08db',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:22',NULL,'2025-12-06 10:16:22',NULL,NULL),(315,NULL,'cbdb9a478876469086b7055f1df54d59',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:23',NULL,'2025-12-06 10:16:23',NULL,NULL),(316,NULL,NULL,'046572d9120c41bc9967a38724292f85',NULL,NULL,NULL,NULL,'2025-12-06 10:16:24',NULL,'2025-12-06 10:16:24',NULL,NULL),(317,NULL,'c7d760761a494fc3b0050c91755e84db',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:24',NULL,'2025-12-06 10:16:24',NULL,NULL),(318,NULL,'e3526d2f5af14e5cac1101cf03432338',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:24',NULL,'2025-12-06 10:16:24',NULL,NULL),(319,NULL,NULL,'7ddcfbb565d847da9328325a692e8d9e',NULL,NULL,NULL,NULL,'2025-12-06 10:16:25',NULL,'2025-12-06 10:16:25',NULL,NULL),(320,NULL,'2a068a428ae7480ea99e47c57f0f5107',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:25',NULL,'2025-12-06 10:16:25',NULL,NULL),(321,NULL,'cc3eb22acc014827b4bfdb970ce57c41',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:25',NULL,'2025-12-06 10:16:25',NULL,NULL),(322,NULL,'2e45f26fa95441f28fc70fe9d1a67779',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:25',NULL,'2025-12-06 10:16:25',NULL,NULL),(323,NULL,'405ee3a691b24fbd9f0d35912dda2157',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:26',NULL,'2025-12-06 10:16:26',NULL,NULL),(324,NULL,NULL,'5255ea252d0e455cb82e26e037b8a67f',NULL,NULL,NULL,NULL,'2025-12-06 10:16:26',NULL,'2025-12-06 10:16:26',NULL,NULL),(325,NULL,NULL,'dc72dc84002a4c1bac8584d90170344e',NULL,NULL,NULL,NULL,'2025-12-06 10:16:26',NULL,'2025-12-06 10:16:26',NULL,NULL),(326,NULL,NULL,'da5f0ffe552e46b29719bd18b0a21550',NULL,NULL,NULL,NULL,'2025-12-06 10:16:27',NULL,'2025-12-06 10:16:27',NULL,NULL),(327,NULL,NULL,'e8fa32b58192468d87c5302a589e6295',NULL,NULL,NULL,NULL,'2025-12-06 10:16:27',NULL,'2025-12-06 10:16:27',NULL,NULL),(328,NULL,'7ab619e38ee447239f047a3520454ddc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(329,NULL,'d493a8ae8d084a138873d079262468d9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(330,NULL,'ec442db20c1a48b4a5990f63329d5c43',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(331,NULL,NULL,'1c1a748c88114a5382362b8f540f1f21',NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(332,NULL,NULL,'3dd3a8e9e1844495b3ed7d596cee29d7',NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(333,NULL,NULL,'5ceb3a7da93c4045b5b7784a678f0b70',NULL,NULL,NULL,NULL,'2025-12-06 10:16:28',NULL,'2025-12-06 10:16:28',NULL,NULL),(334,NULL,'9649cd71f1fd4f49a269935dc08e103d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(335,NULL,'7435808e897043e08b27fd5dcaabc003',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(336,NULL,'1524f717182d4e979954e4395881895c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(337,NULL,NULL,'52e4c5fa07084e8d9abf1da0ba07bd82',NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(338,NULL,NULL,'14c2906554a7423089ab75a84e776b5e',NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(339,NULL,NULL,'5378badf088742e7924e7046a76c8d16',NULL,NULL,NULL,NULL,'2025-12-06 10:16:29',NULL,'2025-12-06 10:16:29',NULL,NULL),(340,NULL,NULL,'f95f7689d9084744bafe68e447058fa0',NULL,NULL,NULL,NULL,'2025-12-06 10:16:30',NULL,'2025-12-06 10:16:30',NULL,NULL),(341,NULL,'78c2dc676c584eb8b74c949c0fdf9fe5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:32',NULL,'2025-12-06 10:16:32',NULL,NULL),(342,NULL,'a4f75ce9c9f44f2ab8a26d0d034177cc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:32',NULL,'2025-12-06 10:16:32',NULL,NULL),(343,NULL,NULL,'6682a5ee3c1b43bb92157245b1edf36a',NULL,NULL,NULL,NULL,'2025-12-06 10:16:32',NULL,'2025-12-06 10:16:32',NULL,NULL),(344,NULL,NULL,'62d93c31971a485d9340cd265e58b80f',NULL,NULL,NULL,NULL,'2025-12-06 10:16:32',NULL,'2025-12-06 10:16:32',NULL,NULL),(345,NULL,NULL,'9dc1ab095f4748bc9f84482860e5e055',NULL,NULL,NULL,NULL,'2025-12-06 10:16:33',NULL,'2025-12-06 10:16:33',NULL,NULL),(346,NULL,NULL,'6fd62414b85147b4a92eb1dadf115d7a',NULL,NULL,NULL,NULL,'2025-12-06 10:16:33',NULL,'2025-12-06 10:16:33',NULL,NULL),(347,NULL,NULL,'13b250438f8e49ee9d0d9f0fe4791c05',NULL,NULL,NULL,NULL,'2025-12-06 10:16:33',NULL,'2025-12-06 10:16:33',NULL,NULL),(348,NULL,'d3c430c4d6344b75858846b83bd88029',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:33',NULL,'2025-12-06 10:16:33',NULL,NULL),(349,NULL,'7abcb26caf554444a05212700b28688a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(350,NULL,'7c03cb094d5c402f98456dc670e812ec',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(351,NULL,'5499ed8359c949efa2ef99698f1414e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(352,NULL,'75f9b1a5e4584e96a68470e13cc41b4e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(353,NULL,NULL,'76d0734be0ab4624bbc6f09bd66269c5',NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(354,NULL,'6bb585ad4f114a12a1a9903c86bab286',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(355,NULL,NULL,'6c595f876f6d4cb8aea5984786325ae7',NULL,NULL,NULL,NULL,'2025-12-06 10:16:34',NULL,'2025-12-06 10:16:34',NULL,NULL),(356,NULL,'a22ced63e346459ab637424ae7833af7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:35',NULL,'2025-12-06 10:16:35',NULL,NULL),(357,NULL,'249b0377f4ff46b5ba4372499f97425e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:35',NULL,'2025-12-06 10:16:35',NULL,NULL),(358,NULL,'5ebd86ce0a27460cb0cb98025ca2890f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:36',NULL,'2025-12-06 10:16:36',NULL,NULL),(359,NULL,'8934bbfbf7bd478498161dba81e33bac',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:36',NULL,'2025-12-06 10:16:36',NULL,NULL),(360,NULL,NULL,'5e95f5d68e83408f99de23dffa04fb44',NULL,NULL,NULL,NULL,'2025-12-06 10:16:37',NULL,'2025-12-06 10:16:37',NULL,NULL),(361,NULL,'45edb65bf83a4a4db7532c6555ab8a18',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:37',NULL,'2025-12-06 10:16:37',NULL,NULL),(362,NULL,NULL,'45c7a3d4f4b6436ea13d90cfe2ed5574',NULL,NULL,NULL,NULL,'2025-12-06 10:16:37',NULL,'2025-12-06 10:16:37',NULL,NULL),(363,NULL,NULL,'8bc1e01b56d348bcbb330474a500fc4d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:37',NULL,'2025-12-06 10:16:37',NULL,NULL),(364,NULL,'497aa680592c43cf99c0aad1fcfff683',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:38',NULL,'2025-12-06 10:16:38',NULL,NULL),(365,NULL,NULL,'3620ab5b566944619a0608ca9bb523e0',NULL,NULL,NULL,NULL,'2025-12-06 10:16:38',NULL,'2025-12-06 10:16:38',NULL,NULL),(366,NULL,'62a733e1fa904b89843d75eeaeb0a1ba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:39',NULL,'2025-12-06 10:16:39',NULL,NULL),(367,NULL,'af2db23facea49d1bf72a409dd340bca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:39',NULL,'2025-12-06 10:16:39',NULL,NULL),(368,NULL,'09b14315bb4b45fa8f486bb273b46176',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:40',NULL,'2025-12-06 10:16:40',NULL,NULL),(369,NULL,'e675fd4b77194e28b3bfa7b8fd978387',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:40',NULL,'2025-12-06 10:16:40',NULL,NULL),(370,NULL,NULL,'82f8c6a4b1994d12a6cfe7cab1e01fab',NULL,NULL,NULL,NULL,'2025-12-06 10:16:42',NULL,'2025-12-06 10:16:42',NULL,NULL),(371,NULL,'063072311d9e471f94b42fe9c5847b8d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:42',NULL,'2025-12-06 10:16:42',NULL,NULL),(372,NULL,NULL,'b019533d0c2244efb8e6db2e66cd2674',NULL,NULL,NULL,NULL,'2025-12-06 10:16:42',NULL,'2025-12-06 10:16:42',NULL,NULL),(373,NULL,'4d657627b5af484ab05aa3e2a1f58c63',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:42',NULL,'2025-12-06 10:16:42',NULL,NULL),(374,NULL,NULL,'d31d2d898f784d439254b89ef960b088',NULL,NULL,NULL,NULL,'2025-12-06 10:16:43',NULL,'2025-12-06 10:16:43',NULL,NULL),(375,NULL,'d4071454e40747789ed93d345fa1230b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:43',NULL,'2025-12-06 10:16:43',NULL,NULL),(376,NULL,'accb3ad4027c40b888e0b49e477a8477',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:43',NULL,'2025-12-06 10:16:43',NULL,NULL),(377,NULL,NULL,'9aa797a08a8f4a8bbb964c0fc963c4b8',NULL,NULL,NULL,NULL,'2025-12-06 10:16:44',NULL,'2025-12-06 10:16:44',NULL,NULL),(378,NULL,'c1a9ae19622341b2ac0eb06724294320',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:44',NULL,'2025-12-06 10:16:44',NULL,NULL),(379,NULL,NULL,'41953ecf1bda447d8ef88369299ab59d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:44',NULL,'2025-12-06 10:16:44',NULL,NULL),(380,NULL,NULL,'0feb2f3fb4e74e06a2c0655bc38f9f1d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:44',NULL,'2025-12-06 10:16:44',NULL,NULL),(381,NULL,NULL,'291cfb7fee75461c85c429ee8b4fe98d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:45',NULL,'2025-12-06 10:16:45',NULL,NULL),(382,NULL,NULL,'b7f6ebbb1f4c400795896ec36bd2f7b8',NULL,NULL,NULL,NULL,'2025-12-06 10:16:46',NULL,'2025-12-06 10:16:46',NULL,NULL),(383,NULL,NULL,'291cfb7fee75461c85c429ee8b4fe98d',NULL,NULL,NULL,NULL,'2025-12-06 10:16:47',NULL,'2025-12-06 10:16:47',NULL,NULL),(384,NULL,'e1f58107af7947eba25c364310c1c1b7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:47',NULL,'2025-12-06 10:16:47',NULL,NULL),(385,NULL,'ae5be3f8bf3d4b10950828ad8f56f079',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:48',NULL,'2025-12-06 10:16:48',NULL,NULL),(386,NULL,'ea919d630cc5403fb507b2e8a5df9872',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:48',NULL,'2025-12-06 10:16:48',NULL,NULL),(387,NULL,'477d547e11944c76aa7c2fecba5975d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:48',NULL,'2025-12-06 10:16:48',NULL,NULL),(388,NULL,NULL,'87a8b89faa9e4ad78425744b491df087',NULL,NULL,NULL,NULL,'2025-12-06 10:16:49',NULL,'2025-12-06 10:16:49',NULL,NULL),(389,NULL,NULL,'5a68c97ff8c5425597208eccc89ab909',NULL,NULL,NULL,NULL,'2025-12-06 10:16:49',NULL,'2025-12-06 10:16:49',NULL,NULL),(390,NULL,'f7a0d0e341c64b61ba21aa32ec6e8a07',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:49',NULL,'2025-12-06 10:16:49',NULL,NULL),(391,NULL,NULL,'b0cc302ce8d7440f82b21feb59f7f815',NULL,NULL,NULL,NULL,'2025-12-06 10:16:49',NULL,'2025-12-06 10:16:49',NULL,NULL),(392,NULL,'04b9b5548a84423fb9833b7dcbdf363e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:49',NULL,'2025-12-06 10:16:49',NULL,NULL),(393,NULL,'21b7da30e6194efab217fe3d2469999c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:51',NULL,'2025-12-06 10:16:51',NULL,NULL),(394,NULL,'bebc87e5dac0468b866f23732c780d25',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:53',NULL,'2025-12-06 10:16:53',NULL,NULL),(395,NULL,NULL,'c93f0a93e49a44078999a4bb556fc171',NULL,NULL,NULL,NULL,'2025-12-06 10:16:56',NULL,'2025-12-06 10:16:56',NULL,NULL),(396,NULL,NULL,'5268e0bc3b6b401db5f302d1f30d5498',NULL,NULL,NULL,NULL,'2025-12-06 10:16:56',NULL,'2025-12-06 10:16:56',NULL,NULL),(397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:56',NULL,'2025-12-06 10:16:56','UdNI31mwQg2_wqSYAptfAg',NULL),(398,NULL,NULL,'ef09424adcce46ec9ce1b1ee149df922',NULL,NULL,NULL,NULL,'2025-12-06 10:16:57',NULL,'2025-12-06 10:16:57',NULL,NULL),(399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:57',NULL,'2025-12-06 10:16:57','_Ep5653tSJCpNQa-QLnTlA',NULL),(400,NULL,NULL,'f330313bdddb4d93978dc3fef1131549',NULL,NULL,NULL,NULL,'2025-12-06 10:16:57',NULL,'2025-12-06 10:16:57',NULL,NULL),(401,NULL,'83707c8b00c540b895ad9bb3aab7f66d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:57',NULL,'2025-12-06 10:16:57',NULL,NULL),(402,NULL,'550d07fdc38d491ba10875a25f95fdea',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:58',NULL,'2025-12-06 10:16:58',NULL,NULL),(403,NULL,'1f8385e255f14502b6a0abd3401d83c5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:59',NULL,'2025-12-06 10:16:59',NULL,NULL),(404,NULL,'1a670e4d97e9490b8510f91d0b3e240b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:16:59',NULL,'2025-12-06 10:16:59',NULL,NULL),(405,NULL,NULL,'bf82f77e897b45fd92e806188e8473cf',NULL,NULL,NULL,NULL,'2025-12-06 10:17:02',NULL,'2025-12-06 10:17:02',NULL,NULL),(406,NULL,'212c405464d542ecb22e6bbf94505299',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:03',NULL,'2025-12-06 10:17:03',NULL,NULL),(407,NULL,NULL,'eb4bc63c24d64341b38168fec98495ef',NULL,NULL,NULL,NULL,'2025-12-06 10:17:04',NULL,'2025-12-06 10:17:04',NULL,NULL),(408,NULL,NULL,'9b1d9e5a077f4e67a8711194bdde54d0',NULL,NULL,NULL,NULL,'2025-12-06 10:17:04',NULL,'2025-12-06 10:17:04',NULL,NULL),(409,NULL,'623dfc6b7d334b1893eafe5f1f8a6f85',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:05',NULL,'2025-12-06 10:17:05',NULL,NULL),(410,NULL,'c452cb0d2885451a9e5043a748345046',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:07',NULL,'2025-12-06 10:17:07',NULL,NULL),(411,NULL,'9bd5fd3a1a5548bd91ac9975223ded0e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:09',NULL,'2025-12-06 10:17:09',NULL,NULL),(412,NULL,NULL,'0065eb816c1a4c0dbdf69aa46d32a8dc',NULL,NULL,NULL,NULL,'2025-12-06 10:17:09',NULL,'2025-12-06 10:17:09',NULL,NULL),(413,NULL,NULL,'3c31b607dbc6487abf457365ef1178ef',NULL,NULL,NULL,NULL,'2025-12-06 10:17:09',NULL,'2025-12-06 10:17:09',NULL,NULL),(414,NULL,NULL,'36382fcdac734a46acabb61a8a8a76b0',NULL,NULL,NULL,NULL,'2025-12-06 10:17:10',NULL,'2025-12-06 10:17:10',NULL,NULL),(415,NULL,NULL,'666b1832e9d042339f500f9f03508f88',NULL,NULL,NULL,NULL,'2025-12-06 10:17:10',NULL,'2025-12-06 10:17:10',NULL,NULL),(416,NULL,'5b13fbba477244f3841a1579bbe4a502',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:11',NULL,'2025-12-06 10:17:11',NULL,NULL),(417,NULL,'ec54df1cc2e6480cbd18172c892b6984',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:11',NULL,'2025-12-06 10:17:11',NULL,NULL),(418,NULL,NULL,'183487bfea4148c8bd274489b01ac583',NULL,NULL,NULL,NULL,'2025-12-06 10:17:11',NULL,'2025-12-06 10:17:11',NULL,NULL),(419,NULL,'290c121e7a5344fea2a32f4e64e74fb4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:12',NULL,'2025-12-06 10:17:12',NULL,NULL),(420,NULL,'a69b7ea2512046cca1c38484e27e4cae',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:12',NULL,'2025-12-06 10:17:12',NULL,NULL),(421,NULL,'39d77a386d64496599115cc3abaddbed',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:13',NULL,'2025-12-06 10:17:13',NULL,NULL),(422,NULL,NULL,NULL,NULL,'dfb780a8aa534cc5bdd357c74fc311c4',NULL,NULL,'2025-12-06 10:17:15',NULL,'2025-12-06 10:17:15',NULL,NULL),(423,NULL,NULL,'a3e6db8026a94c2bbb14dc443ac2cfa3',NULL,NULL,NULL,NULL,'2025-12-06 10:17:15',NULL,'2025-12-06 10:17:15',NULL,NULL),(424,NULL,NULL,'c1fbf12d99ad4d29ba0be10c8461fa83',NULL,NULL,NULL,NULL,'2025-12-06 10:17:16',NULL,'2025-12-06 10:17:16',NULL,NULL),(425,NULL,'b3fd279790904bae9723ca980b8ee9fa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:16',NULL,'2025-12-06 10:17:16',NULL,NULL),(426,NULL,'a782fbf6586a4aa1938065c13cfb0e38',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:17',NULL,'2025-12-06 10:17:17',NULL,NULL),(427,NULL,NULL,'bba733769c214abb9b0112bffafbaa4d',NULL,NULL,NULL,NULL,'2025-12-06 10:17:17',NULL,'2025-12-06 10:17:17',NULL,NULL),(428,NULL,NULL,NULL,NULL,'9a9d765efbd34b27a57fb11abeab7b2c',NULL,NULL,'2025-12-06 10:17:18',NULL,'2025-12-06 10:17:18',NULL,NULL),(429,NULL,NULL,'77204f64eee44c5399c5be3d8eb85ee6',NULL,NULL,NULL,NULL,'2025-12-06 10:17:18',NULL,'2025-12-06 10:17:18',NULL,NULL),(430,NULL,NULL,'7dcd2b11aeb4499894c7ac7c29cb6997',NULL,NULL,NULL,NULL,'2025-12-06 10:17:18',NULL,'2025-12-06 10:17:18',NULL,NULL),(431,NULL,'9bcc653c7da344c6af3b757c16081025',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:19',NULL,'2025-12-06 10:17:19',NULL,NULL),(432,NULL,NULL,'3ebc9a4ea09648d88b60d5d2b7d34a2d',NULL,NULL,NULL,NULL,'2025-12-06 10:17:19',NULL,'2025-12-06 10:17:19',NULL,NULL),(433,NULL,NULL,'ee8ba38611bb40feb52defeab1bd1843',NULL,NULL,NULL,NULL,'2025-12-06 10:17:19',NULL,'2025-12-06 10:17:19',NULL,NULL),(434,NULL,'ce4a191131d2409a8fc6c1e67d19f7ce',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:19',NULL,'2025-12-06 10:17:19',NULL,NULL),(435,NULL,NULL,'3d231e90c89b4e6fa46f4914f77cc6bd',NULL,NULL,NULL,NULL,'2025-12-06 10:17:21',NULL,'2025-12-06 10:17:21',NULL,NULL),(436,NULL,NULL,NULL,NULL,'2b9a722d75154518b2bfd608efa3e408',NULL,NULL,'2025-12-06 10:17:21',NULL,'2025-12-06 10:17:21',NULL,NULL),(437,NULL,'3ed926b69d0c4025b50af221bd5c56eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:21',NULL,'2025-12-06 10:17:21',NULL,NULL),(438,NULL,NULL,'3057c74f29bd428c91542c6e4554e615',NULL,NULL,NULL,NULL,'2025-12-06 10:17:21',NULL,'2025-12-06 10:17:21',NULL,NULL),(439,NULL,NULL,'d88c2dcd060645c0b0c9b57ff16313df',NULL,NULL,NULL,NULL,'2025-12-06 10:17:22',NULL,'2025-12-06 10:17:22',NULL,NULL),(440,NULL,'d921630cf1154e78b54b2e05166ad5c0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:22',NULL,'2025-12-06 10:17:22',NULL,NULL),(441,NULL,'d6a02136413f4ad3ac51d2c4ffdad3d4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:22',NULL,'2025-12-06 10:17:22',NULL,NULL),(442,NULL,'cee3e0c1575f4b46bd60ec5b2e858b9d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:22',NULL,'2025-12-06 10:17:22',NULL,NULL),(443,NULL,NULL,'14df7fe2429f441fa5505f30a14f2800',NULL,NULL,NULL,NULL,'2025-12-06 10:17:23',NULL,'2025-12-06 10:17:23',NULL,NULL),(444,NULL,NULL,'406e5cc53df749808a8770da68d7033d',NULL,NULL,NULL,NULL,'2025-12-06 10:17:23',NULL,'2025-12-06 10:17:23',NULL,NULL),(445,NULL,NULL,'53fa3043b6c24fbfbe4110f1f890ac9a',NULL,NULL,NULL,NULL,'2025-12-06 10:17:23',NULL,'2025-12-06 10:17:23',NULL,NULL),(446,NULL,NULL,'f89e0038548e41fa9a8202b7a7e9ade1',NULL,NULL,NULL,NULL,'2025-12-06 10:17:23',NULL,'2025-12-06 10:17:23',NULL,NULL),(447,NULL,'00df437027dd402f89cca379c6f491d2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:24',NULL,'2025-12-06 10:17:24',NULL,NULL),(448,NULL,'2dfe2468f2f24fc5bae2029067cb925d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:24',NULL,'2025-12-06 10:17:24',NULL,NULL),(449,NULL,'64b9b91747c648148f6dd23ce81ceb80',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:24',NULL,'2025-12-06 10:17:24',NULL,NULL),(450,NULL,'ffb5c3e6a11e4dffbe293400b3e26de4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:25',NULL,'2025-12-06 10:17:25',NULL,NULL),(451,NULL,'49bb78ce003e4bec87707ab7af03ae7e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:25',NULL,'2025-12-06 10:17:25',NULL,NULL),(452,NULL,NULL,'21032902d5d64bd69e0bd8af08b36c7f',NULL,NULL,NULL,NULL,'2025-12-06 10:17:26',NULL,'2025-12-06 10:17:26',NULL,NULL),(453,NULL,'eb9d92fdf8404ed197f0ae4233191f15',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:26',NULL,'2025-12-06 10:17:26',NULL,NULL),(454,NULL,NULL,'adc539efa64c4dd1af2e799fa14e71c6',NULL,NULL,NULL,NULL,'2025-12-06 10:17:26',NULL,'2025-12-06 10:17:26',NULL,NULL),(455,NULL,'ab16256cfe4c49e4ae483acaf11c645e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:26',NULL,'2025-12-06 10:17:26',NULL,NULL),(456,NULL,NULL,'b4f9b4e4cabd4b079cb8c31c22004b7a',NULL,NULL,NULL,NULL,'2025-12-06 10:17:27',NULL,'2025-12-06 10:17:27',NULL,NULL),(457,NULL,'37dcf5204733427ebb8bdbe574dca584',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:28',NULL,'2025-12-06 10:17:28',NULL,NULL),(458,NULL,'0890c4c844294550a2e132d4c80d77ba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:28',NULL,'2025-12-06 10:17:28',NULL,NULL),(459,NULL,NULL,'f0f93df6d79443c79cdafed2ff8872e7',NULL,NULL,NULL,NULL,'2025-12-06 10:17:28',NULL,'2025-12-06 10:17:28',NULL,NULL),(460,NULL,'530c57cbb7ac4df49e5d1c8d82160083',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:30',NULL,'2025-12-06 10:17:30',NULL,NULL),(461,NULL,NULL,NULL,NULL,'a58531fe44aa42ac9720d768e19f9cf1',NULL,NULL,'2025-12-06 10:17:31',NULL,'2025-12-06 10:17:31',NULL,NULL),(462,NULL,NULL,'2d74c9ac7f31434daf4f31f2cdd445da',NULL,NULL,NULL,NULL,'2025-12-06 10:17:32',NULL,'2025-12-06 10:17:32',NULL,NULL),(463,NULL,'ae0cdc97196d44abb4857e03a3ecba39',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:32',NULL,'2025-12-06 10:17:32',NULL,NULL),(464,NULL,NULL,'458d8d7090454255a7115c22874260f0',NULL,NULL,NULL,NULL,'2025-12-06 10:17:33',NULL,'2025-12-06 10:17:33',NULL,NULL),(465,NULL,NULL,'8eeb1ce8ea6f4981a55c23fbea57f4cb',NULL,NULL,NULL,NULL,'2025-12-06 10:17:33',NULL,'2025-12-06 10:17:33',NULL,NULL),(466,NULL,NULL,'b50ab118e6c942f39a516291bc857e6a',NULL,NULL,NULL,NULL,'2025-12-06 10:17:34',NULL,'2025-12-06 10:17:34',NULL,NULL),(467,NULL,'41d1389a302d470f870437f4686f60a4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:34',NULL,'2025-12-06 10:17:34',NULL,NULL),(468,NULL,'0b68e0cf8ee8418bb64d28167a6de6c9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:34',NULL,'2025-12-06 10:17:34',NULL,NULL),(469,NULL,NULL,'842cca8c4fed4807b40002480f167c24',NULL,NULL,NULL,NULL,'2025-12-06 10:17:34',NULL,'2025-12-06 10:17:34',NULL,NULL),(470,NULL,NULL,'816f4ad7adf84b39809aba3e1bb81843',NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(471,NULL,'d9d00b3ce1a747c48ffdc7dcb3ff2a5f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(472,NULL,NULL,'e44841e71d6d45e885653257007de27e',NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(473,NULL,NULL,'57ff944afa7641228eaa7c82c7d862c9',NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(474,NULL,NULL,NULL,NULL,'0d5ca7dfaf174c5fa168784463bfbc15',NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(475,NULL,NULL,'75af55f85c644dbbb2a1ce15c796fc02',NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(476,NULL,'f9595f0635f14c2196533c0f5ee5dc3b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:35',NULL,'2025-12-06 10:17:35',NULL,NULL),(477,NULL,'161893308749469fbaf167d0e576c1c4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:36',NULL,'2025-12-06 10:17:36',NULL,NULL),(478,NULL,NULL,'e7819aed09eb47d5831d80e49782c509',NULL,NULL,NULL,NULL,'2025-12-06 10:17:36',NULL,'2025-12-06 10:17:36',NULL,NULL),(479,NULL,NULL,'77ce9f1d232e4cda8cd9371779d00887',NULL,NULL,NULL,NULL,'2025-12-06 10:17:36',NULL,'2025-12-06 10:17:36',NULL,NULL),(480,NULL,'3dd0e455eaa843a79262755e0c2fe2ff',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:37',NULL,'2025-12-06 10:17:37',NULL,NULL),(481,NULL,'55654165b220427888a7a780cd2fefa6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:37',NULL,'2025-12-06 10:17:37',NULL,NULL),(482,NULL,'fc0c387f95aa4a09bdc0e6790b4d0fa1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:38',NULL,'2025-12-06 10:17:38',NULL,NULL),(483,NULL,'e79591b29df64afd86b0e1def21e6a92',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:39',NULL,'2025-12-06 10:17:39',NULL,NULL),(484,NULL,'f6c1f8c09fde46748884e58c766f5736',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:39',NULL,'2025-12-06 10:17:39',NULL,NULL),(485,NULL,'5523789982cc4afe954c78ca4aec7340',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:40',NULL,'2025-12-06 10:17:40',NULL,NULL),(486,NULL,NULL,'9360fd9454b64d96b92a0c9a1ea4849b',NULL,NULL,NULL,NULL,'2025-12-06 10:17:42',NULL,'2025-12-06 10:17:42',NULL,NULL),(487,NULL,'266ed339c72c438fb0508739da07bafb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(488,NULL,NULL,'cf2cadf875da4c9b86fb2902b9ee90bb',NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(489,NULL,NULL,'9746c911f01c4fee942db215e7ee0535',NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(490,NULL,NULL,'a667294e5ba142348b26eb0068fe5541',NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(491,NULL,'ee136d18b1fb47bbafbe46c617176ee7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(492,NULL,'63081b56b14c4df185079dd7f975cde1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:43',NULL,'2025-12-06 10:17:43',NULL,NULL),(493,NULL,NULL,'3ea76362796945abb0389f60eab07566',NULL,NULL,NULL,NULL,'2025-12-06 10:17:44',NULL,'2025-12-06 10:17:44',NULL,NULL),(494,NULL,'51d42915ae104bf99b6870e469f9b453',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:45',NULL,'2025-12-06 10:17:45',NULL,NULL),(495,NULL,NULL,'d6e0b16e54bd4ea5942972fa8e58fa09',NULL,NULL,NULL,NULL,'2025-12-06 10:17:45',NULL,'2025-12-06 10:17:45',NULL,NULL),(496,NULL,'3d64b92c0ac84e00a6e31382047e6db5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:45',NULL,'2025-12-06 10:17:45',NULL,NULL),(497,NULL,NULL,'d6e0b16e54bd4ea5942972fa8e58fa09',NULL,NULL,NULL,NULL,'2025-12-06 10:17:45',NULL,'2025-12-06 10:17:45',NULL,NULL),(498,NULL,'82b53f1b51be4c9ab941d54a89a5f850',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:45',NULL,'2025-12-06 10:17:45',NULL,NULL),(499,NULL,'23fdd860878442e1b8fc77e4ae3ef271',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(500,NULL,'d5114e685c1d455b88b2bb8a7b58d6df',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(501,NULL,NULL,'d956c36907db411e9ca9ddb2b306bc4e',NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(502,NULL,NULL,'bbab512ace204644a9a47fa66547b44a',NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(503,NULL,'1de269b03db547d18b710f7fadf8191a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(504,NULL,'2b975a1e6b7941c09260aeb20365b968',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:46',NULL,'2025-12-06 10:17:46',NULL,NULL),(505,NULL,'8baaa12c0d3c4f44a8c7bc09d72bc9dd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:49',NULL,'2025-12-06 10:17:49',NULL,NULL),(506,NULL,NULL,'b302a87a836a4ad788a26b8bebf95eed',NULL,NULL,NULL,NULL,'2025-12-06 10:17:49',NULL,'2025-12-06 10:17:49',NULL,NULL),(507,NULL,NULL,'cbdaf1b23a674e82b847a3099ddb75bc',NULL,NULL,NULL,NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',NULL,NULL),(508,NULL,NULL,'0be605af4c014ac586c4ad95d5d0effd',NULL,NULL,NULL,NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',NULL,NULL),(509,NULL,'407141ab4b294f36b7dc8ae0509eada7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',NULL,NULL),(510,NULL,NULL,'75bb1c8d14d641b1aeebdef1bad08333',NULL,NULL,NULL,NULL,'2025-12-06 10:17:50',NULL,'2025-12-06 10:17:50',NULL,NULL),(511,NULL,NULL,'6a42bcf71fc64eb1aae212bf01c121f7',NULL,NULL,NULL,NULL,'2025-12-06 10:17:51',NULL,'2025-12-06 10:17:51',NULL,NULL),(512,NULL,'b5df38c5435f43cabe0c08b1b4c64110',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:51',NULL,'2025-12-06 10:17:51',NULL,NULL),(513,NULL,'f989a5ca070f42869676d296f2821df0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:52',NULL,'2025-12-06 10:17:52',NULL,NULL),(514,NULL,'20a505b7c83049199c981ad059d3a0f7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:53',NULL,'2025-12-06 10:17:53',NULL,NULL),(515,NULL,'dabe45f49cad482aa7cb429729ae91db',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:53',NULL,'2025-12-06 10:17:53',NULL,NULL),(516,NULL,'4b48addcc28d4867ba60b367324ed1e6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:54',NULL,'2025-12-06 10:17:54',NULL,NULL),(517,NULL,NULL,'6c30b486b7164d0087551a6484b1bb26',NULL,NULL,NULL,NULL,'2025-12-06 10:17:54',NULL,'2025-12-06 10:17:54',NULL,NULL),(518,NULL,NULL,'36e4723ccf594be7bc3f6445d14cf2a8',NULL,NULL,NULL,NULL,'2025-12-06 10:17:54',NULL,'2025-12-06 10:17:54',NULL,NULL),(519,NULL,'ae7138c5f9044c958933511094c2626e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:57',NULL,'2025-12-06 10:17:57',NULL,NULL),(520,NULL,'d7a1a0b7394543f887723c6cc16c4342',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:17:58',NULL,'2025-12-06 10:17:58',NULL,NULL),(521,NULL,NULL,'c4f4a6a10baf4f97b15bf763d412fcbe',NULL,NULL,NULL,NULL,'2025-12-06 10:17:58',NULL,'2025-12-06 10:17:58',NULL,NULL),(522,NULL,NULL,'f68c3a9949bc420ebb413653d6ced094',NULL,NULL,NULL,NULL,'2025-12-06 10:17:58',NULL,'2025-12-06 10:17:58',NULL,NULL),(523,NULL,'bc67c594d9a64650bd3542d644fba0aa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:01',NULL,'2025-12-06 10:18:01',NULL,NULL),(524,NULL,NULL,'a753882f71734847b7e625f47b6c2b9d',NULL,NULL,NULL,NULL,'2025-12-06 10:18:02',NULL,'2025-12-06 10:18:02',NULL,NULL),(525,NULL,NULL,'774d9709879b49108b027799bce0187c',NULL,NULL,NULL,NULL,'2025-12-06 10:18:02',NULL,'2025-12-06 10:18:02',NULL,NULL),(526,NULL,NULL,'e5c7d5967f7d46e7835cae124101c34e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:03',NULL,'2025-12-06 10:18:03',NULL,NULL),(527,NULL,'c4557553d682436e9635b43b8dd280fc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:03',NULL,'2025-12-06 10:18:03',NULL,NULL),(528,NULL,NULL,'d34f23fcc95a477c8995a80761dae3a3',NULL,NULL,NULL,NULL,'2025-12-06 10:18:03',NULL,'2025-12-06 10:18:03',NULL,NULL),(529,NULL,'f742ea0e912f4adaa36453fa260c01e9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:05',NULL,'2025-12-06 10:18:05',NULL,NULL),(530,NULL,'a5426f7cf73a4662a380c71356126371',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:06',NULL,'2025-12-06 10:18:06',NULL,NULL),(531,NULL,'102b51d6c95d42ffbd80267daa07157e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:06',NULL,'2025-12-06 10:18:06',NULL,NULL),(532,NULL,NULL,'5ac7b950f6754db59eeafca5b8a2ad2a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:08',NULL,'2025-12-06 10:18:08',NULL,NULL),(533,NULL,NULL,'335a73eb54064d93a947a3a28c687575',NULL,NULL,NULL,NULL,'2025-12-06 10:18:08',NULL,'2025-12-06 10:18:08',NULL,NULL),(534,NULL,'514ec268f5ca4320a08c7470e3cc5655',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:08',NULL,'2025-12-06 10:18:08',NULL,NULL),(535,NULL,NULL,'4aedbaa3ad804fe3bd58f76b513610b3',NULL,NULL,NULL,NULL,'2025-12-06 10:18:08',NULL,'2025-12-06 10:18:08',NULL,NULL),(536,NULL,NULL,'4aedbaa3ad804fe3bd58f76b513610b3',NULL,NULL,NULL,NULL,'2025-12-06 10:18:09',NULL,'2025-12-06 10:18:09',NULL,NULL),(537,NULL,NULL,'335a73eb54064d93a947a3a28c687575',NULL,NULL,NULL,NULL,'2025-12-06 10:18:09',NULL,'2025-12-06 10:18:09',NULL,NULL),(538,NULL,NULL,'5ac7b950f6754db59eeafca5b8a2ad2a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:09',NULL,'2025-12-06 10:18:09',NULL,NULL),(539,NULL,NULL,'b1f849fcee42408e914cca5b712197cd',NULL,NULL,NULL,NULL,'2025-12-06 10:18:10',NULL,'2025-12-06 10:18:10',NULL,NULL),(540,NULL,NULL,'7f3b23d702224962bdae29470efbdcb2',NULL,NULL,NULL,NULL,'2025-12-06 10:18:10',NULL,'2025-12-06 10:18:10',NULL,NULL),(541,NULL,'d3206b7284824c8ab0ca211a18e9f553',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:12',NULL,'2025-12-06 10:18:12',NULL,NULL),(542,NULL,NULL,'7fbb8d4f7110415fa52ab13045fef230',NULL,NULL,NULL,NULL,'2025-12-06 10:18:12',NULL,'2025-12-06 10:18:12',NULL,NULL),(543,NULL,NULL,'833d9dd9dd114a66bcbf3ecd95f9e2c3',NULL,NULL,NULL,NULL,'2025-12-06 10:18:12',NULL,'2025-12-06 10:18:12',NULL,NULL),(544,NULL,'6be2ff03c22544408250bc07e09a35d4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:12',NULL,'2025-12-06 10:18:12',NULL,NULL),(545,NULL,'fbcca75115b44ee1af28c8637344b95e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:13',NULL,'2025-12-06 10:18:13',NULL,NULL),(546,NULL,NULL,'cea33980745e4d3ab4b18484a2d94398',NULL,NULL,NULL,NULL,'2025-12-06 10:18:13',NULL,'2025-12-06 10:18:13',NULL,NULL),(547,NULL,NULL,'23a6fa3c0698439abb39fa34c0299eb9',NULL,NULL,NULL,NULL,'2025-12-06 10:18:13',NULL,'2025-12-06 10:18:13',NULL,NULL),(548,NULL,NULL,'a1ca9d6362194a67852f10ecdc63ff69',NULL,NULL,NULL,NULL,'2025-12-06 10:18:13',NULL,'2025-12-06 10:18:13',NULL,NULL),(549,NULL,'d6abb77b6a704ad289064b8078b7c400',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:14',NULL,'2025-12-06 10:18:14',NULL,NULL),(550,NULL,'c09ba3fdbc194330b9c27517d9252a16',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:14',NULL,'2025-12-06 10:18:14',NULL,NULL),(551,NULL,'4fc3704e3f814e01a90ed561a1ef7e13',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:15',NULL,'2025-12-06 10:18:15',NULL,NULL),(552,NULL,'60c29fb1ddf1404793872d28a5ee9537',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:15',NULL,'2025-12-06 10:18:15',NULL,NULL),(553,NULL,NULL,'140a27a2087f43f4918adaac6fe636d2',NULL,NULL,NULL,NULL,'2025-12-06 10:18:20',NULL,'2025-12-06 10:18:20',NULL,NULL),(554,NULL,'8d525f3db4524999ac4cbc2a6d6f399f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:21',NULL,'2025-12-06 10:18:21',NULL,NULL),(555,NULL,'40415b7c7c9a49a7b209f010db9798a2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:22',NULL,'2025-12-06 10:18:22',NULL,NULL),(556,NULL,'71ac502546294384bd0758fd59ced8f4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:23',NULL,'2025-12-06 10:18:23',NULL,NULL),(557,NULL,NULL,'7e893675945241709e43e26c8c6fc968',NULL,NULL,NULL,NULL,'2025-12-06 10:18:23',NULL,'2025-12-06 10:18:23',NULL,NULL),(558,NULL,'b493fe8d870f41178f67dc9086e09309',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:23',NULL,'2025-12-06 10:18:23',NULL,NULL),(559,NULL,'19edc26c558348cb90123828c53b36a7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:24',NULL,'2025-12-06 10:18:24',NULL,NULL),(560,NULL,NULL,'33df4af8472c4b1c9d00e0ad4ae96fca',NULL,NULL,NULL,NULL,'2025-12-06 10:18:24',NULL,'2025-12-06 10:18:24',NULL,NULL),(561,NULL,NULL,'5afe27c0b6a4456cbcf647582ba9c44a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:24',NULL,'2025-12-06 10:18:24',NULL,NULL),(562,NULL,NULL,'105e2f456034459fb41c52b4f7ad38b0',NULL,NULL,NULL,NULL,'2025-12-06 10:18:25',NULL,'2025-12-06 10:18:25',NULL,NULL),(563,NULL,NULL,'c2a721f4c7c44641b3de5b9586a6e790',NULL,NULL,NULL,NULL,'2025-12-06 10:18:25',NULL,'2025-12-06 10:18:25',NULL,NULL),(564,NULL,NULL,'6c3d03d81e804969bea6b378745b6a34',NULL,NULL,NULL,NULL,'2025-12-06 10:18:25',NULL,'2025-12-06 10:18:25',NULL,NULL),(565,NULL,'863576c178e847948fa5f016c5498edd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:25',NULL,'2025-12-06 10:18:25',NULL,NULL),(566,NULL,NULL,'440e57a58b9f4b64af7435927930ce6a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:25',NULL,'2025-12-06 10:18:25',NULL,NULL),(567,NULL,NULL,'3f5ca2acf210487dbe6f30ee479df5c9',NULL,NULL,NULL,NULL,'2025-12-06 10:18:26',NULL,'2025-12-06 10:18:26',NULL,NULL),(568,NULL,'47514fdd2d814dfd819377edcac99253',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:26',NULL,'2025-12-06 10:18:26',NULL,NULL),(569,NULL,'49b6390c5ae14ddf850d4e9fda870857',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:27',NULL,'2025-12-06 10:18:27',NULL,NULL),(570,NULL,'ee4a64791e454ca9be8529f480bd3c76',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:27',NULL,'2025-12-06 10:18:27',NULL,NULL),(571,NULL,'5ae5b2af677a466a97c4783ec75e136c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:27',NULL,'2025-12-06 10:18:27',NULL,NULL),(572,NULL,'3aa9d9d3ea60478e98dd8c3bc0f27181',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:27',NULL,'2025-12-06 10:18:27',NULL,NULL),(573,NULL,NULL,'4c6008178bdc445aa99fb1b726f87b45',NULL,NULL,NULL,NULL,'2025-12-06 10:18:27',NULL,'2025-12-06 10:18:27',NULL,NULL),(574,NULL,'37eea2b31d9543b793c928d777810de4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:28',NULL,'2025-12-06 10:18:28',NULL,NULL),(575,NULL,NULL,'38b6c1bbbbc64644bf4be20defd13420',NULL,NULL,NULL,NULL,'2025-12-06 10:18:29',NULL,'2025-12-06 10:18:29',NULL,NULL),(576,NULL,'a2aaeadee6f14b78a73f8886be99b671',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:29',NULL,'2025-12-06 10:18:29',NULL,NULL),(577,NULL,NULL,'6eaefe6557764a83abeae2084698bbce',NULL,NULL,NULL,NULL,'2025-12-06 10:18:30',NULL,'2025-12-06 10:18:30',NULL,NULL),(578,NULL,NULL,NULL,NULL,NULL,'d9cdb9b7d181445da7d354d608e4ca16',NULL,'2025-12-06 10:18:30',NULL,'2025-12-06 10:18:30',NULL,NULL),(579,NULL,'bdae3a4fd57541f391ba58bd701f861c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:30',NULL,'2025-12-06 10:18:30',NULL,NULL),(580,NULL,NULL,NULL,NULL,NULL,'4f8f364f00244736ab647e3b6c1f57d7',NULL,'2025-12-06 10:18:31',NULL,'2025-12-06 10:18:31',NULL,NULL),(581,NULL,NULL,'e060447bf163490c83b14baaa69f034b',NULL,NULL,NULL,NULL,'2025-12-06 10:18:31',NULL,'2025-12-06 10:18:31',NULL,NULL),(582,NULL,NULL,'baefc4eb4db14f42aefbd9d40c1a9256',NULL,NULL,NULL,NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(583,NULL,'06eecf2db90342a0849d9f963dfc2e11',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(584,NULL,NULL,'70fb51c48cfc429f910e7d2995e5928a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(585,NULL,NULL,'65058ea6861c4a5aba41520a8601af66',NULL,NULL,NULL,NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(586,NULL,NULL,NULL,NULL,NULL,'c94b6d3fabf646daac107504aff893ec',NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(587,NULL,NULL,NULL,NULL,NULL,'3533d07695f749369c6c50c886170efe',NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(588,NULL,NULL,NULL,NULL,NULL,'2372bcca299442bf98c5eb884904066f',NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(589,NULL,NULL,'06e5b89a5e594bc5a63bd041890a89e7',NULL,NULL,NULL,NULL,'2025-12-06 10:18:32',NULL,'2025-12-06 10:18:32',NULL,NULL),(590,NULL,'98e92b02588946eca862b8460f965b72',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:33',NULL,'2025-12-06 10:18:33',NULL,NULL),(591,NULL,NULL,'5d6975b793254b19931475b5fb37b904',NULL,NULL,NULL,NULL,'2025-12-06 10:18:33',NULL,'2025-12-06 10:18:33',NULL,NULL),(592,NULL,'82e66d987af642e79e2539d816511c7b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:33',NULL,'2025-12-06 10:18:33',NULL,NULL),(593,NULL,'2502a7c872a64d0f96f35e1b849953cf',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:33',NULL,'2025-12-06 10:18:33',NULL,NULL),(594,NULL,NULL,'b1a355993de54fb0be71b6d50d26d58e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:34',NULL,'2025-12-06 10:18:34',NULL,NULL),(595,NULL,'a308e95ecdcd42139f2f3fc2eb3c3d38',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:34',NULL,'2025-12-06 10:18:34',NULL,NULL),(596,NULL,'0e55a8f81efe4564b36ffb82ca889337',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:35',NULL,'2025-12-06 10:18:35',NULL,NULL),(597,NULL,'32a517b62c9e4cd8a5697ce3632d0341',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:35',NULL,'2025-12-06 10:18:35',NULL,NULL),(598,NULL,'46e411da10774d468aa02a15ec83cd3e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:36',NULL,'2025-12-06 10:18:36',NULL,NULL),(599,NULL,NULL,'3d01e2612a5a43c384bef4b4d911202e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:38',NULL,'2025-12-06 10:18:38',NULL,NULL),(600,NULL,NULL,'162fec8f157b48749fefc8c703130a79',NULL,NULL,NULL,NULL,'2025-12-06 10:18:39',NULL,'2025-12-06 10:18:39',NULL,NULL),(601,NULL,NULL,'a8668c9afb6f4ed68d04bed23206fff5',NULL,NULL,NULL,NULL,'2025-12-06 10:18:39',NULL,'2025-12-06 10:18:39',NULL,NULL),(602,NULL,NULL,'8099403cc7c041869a0cec87a0b85e3a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:39',NULL,'2025-12-06 10:18:39',NULL,NULL),(603,NULL,NULL,'2ede3be8bc2d4ff6908e9b12c97a2b0e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:39',NULL,'2025-12-06 10:18:39',NULL,NULL),(604,NULL,'c408210a4e0b424884d4800ca20420d5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:40',NULL,'2025-12-06 10:18:40',NULL,NULL),(605,NULL,'0dfba6277e9f418ba38d4e9a2559c360',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:41',NULL,'2025-12-06 10:18:41',NULL,NULL),(606,NULL,'bc7e8ff4f03c4d01ae17dab87da77859',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:41',NULL,'2025-12-06 10:18:41',NULL,NULL),(607,NULL,'b5117c1d593844e9b41050d83d02d6eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:42',NULL,'2025-12-06 10:18:42',NULL,NULL),(608,NULL,NULL,'03f5c44949f4449daa2744e8caa11cba',NULL,NULL,NULL,NULL,'2025-12-06 10:18:43',NULL,'2025-12-06 10:18:43',NULL,NULL),(609,NULL,'197ab77345474d06bbca9810947efe5a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:43',NULL,'2025-12-06 10:18:43',NULL,NULL),(610,NULL,NULL,'3d981ab0be9140da81d41ec4317c0724',NULL,NULL,NULL,NULL,'2025-12-06 10:18:43',NULL,'2025-12-06 10:18:43',NULL,NULL),(611,NULL,NULL,'9bb9480609f24bb383b10c7bf4d24151',NULL,NULL,NULL,NULL,'2025-12-06 10:18:44',NULL,'2025-12-06 10:18:44',NULL,NULL),(612,NULL,'fa979675ad6e484daf8c7eb00c115ce5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:44',NULL,'2025-12-06 10:18:44',NULL,NULL),(613,NULL,'68eebcd7dc804fc1b9bdc2fcca919216',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:45',NULL,'2025-12-06 10:18:45',NULL,NULL),(614,NULL,NULL,'8a5f2cd89038450e822bee3e5af8be15',NULL,NULL,NULL,NULL,'2025-12-06 10:18:46',NULL,'2025-12-06 10:18:46',NULL,NULL),(615,NULL,'3c7990ece92b4c1a91d55e23de78d087',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:46',NULL,'2025-12-06 10:18:46',NULL,NULL),(616,NULL,'1dcb06c073594e5ab6c8feae724cde7b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:47',NULL,'2025-12-06 10:18:47',NULL,NULL),(617,NULL,NULL,'87094fd9721e43958656aa4afbce0b9c',NULL,NULL,NULL,NULL,'2025-12-06 10:18:48',NULL,'2025-12-06 10:18:48',NULL,NULL),(618,NULL,NULL,'57ec6069516a4b81aa4707921be56ea6',NULL,NULL,NULL,NULL,'2025-12-06 10:18:50',NULL,'2025-12-06 10:18:50',NULL,NULL),(619,NULL,NULL,'7a78e064968c4fa991ef90da3ae1745b',NULL,NULL,NULL,NULL,'2025-12-06 10:18:50',NULL,'2025-12-06 10:18:50',NULL,NULL),(620,NULL,NULL,'0f458e3ebdb3400189096df07ea842c7',NULL,NULL,NULL,NULL,'2025-12-06 10:18:50',NULL,'2025-12-06 10:18:50',NULL,NULL),(621,NULL,NULL,'1eb8324836864f76b719e6a54516cb7e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:50',NULL,'2025-12-06 10:18:50',NULL,NULL),(622,NULL,'f7db2a264472444c98ad6d26eab4797f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:51',NULL,'2025-12-06 10:18:51',NULL,NULL),(623,NULL,'78bd7e3740f04b9b9b052fdc7bbfe713',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:51',NULL,'2025-12-06 10:18:51',NULL,NULL),(624,NULL,'be7192a4bdca4795ae21812d358a5218',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:52',NULL,'2025-12-06 10:18:52',NULL,NULL),(625,NULL,NULL,'9b1422e7ba894ba7b8e14df8e50e50d0',NULL,NULL,NULL,NULL,'2025-12-06 10:18:52',NULL,'2025-12-06 10:18:52',NULL,NULL),(626,NULL,'8107242293454375a6260c46e0ab59e4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:53',NULL,'2025-12-06 10:18:53',NULL,NULL),(627,NULL,NULL,'b530424c53854b508f42256aa4cd8eec',NULL,NULL,NULL,NULL,'2025-12-06 10:18:54',NULL,'2025-12-06 10:18:54',NULL,NULL),(628,NULL,'2b1d664fab0f4b7f87439c153244cdc1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:54',NULL,'2025-12-06 10:18:54',NULL,NULL),(629,NULL,'4e9355901a104d68a3e03fc68d7e074c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:54',NULL,'2025-12-06 10:18:54',NULL,NULL),(630,NULL,NULL,'e1c90a54a16449fab8730ffe36ddf113',NULL,NULL,NULL,NULL,'2025-12-06 10:18:56',NULL,'2025-12-06 10:18:56',NULL,NULL),(631,NULL,NULL,'f1860ac2c0bf4a6fbbaf13ce92af9621',NULL,NULL,NULL,NULL,'2025-12-06 10:18:57',NULL,'2025-12-06 10:18:57',NULL,NULL),(632,NULL,NULL,'ea9b905d18304cd5b9952ded30a2534a',NULL,NULL,NULL,NULL,'2025-12-06 10:18:57',NULL,'2025-12-06 10:18:57',NULL,NULL),(633,NULL,NULL,'dd7f280921064e47bdd48fe44756c31e',NULL,NULL,NULL,NULL,'2025-12-06 10:18:57',NULL,'2025-12-06 10:18:57',NULL,NULL),(634,NULL,'77baa6b0592d4c47b8a2fa01954f5130',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:58',NULL,'2025-12-06 10:18:58',NULL,NULL),(635,NULL,'9e7e82b66b874490b5068b38d1e68b48',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:18:59',NULL,'2025-12-06 10:18:59',NULL,NULL),(636,NULL,'ebfbf1d74c7b44a2a2e2afea3266b3e6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:00',NULL,'2025-12-06 10:19:00',NULL,NULL),(637,NULL,'dd30ad29440e452b83473ec97e177ec4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:02',NULL,'2025-12-06 10:19:02',NULL,NULL),(638,NULL,NULL,'83cde879bada43e389105ddb662b01ba',NULL,NULL,NULL,NULL,'2025-12-06 10:19:04',NULL,'2025-12-06 10:19:04',NULL,NULL),(639,NULL,NULL,'1333c58cfc75447fad1b488a958549ce',NULL,NULL,NULL,NULL,'2025-12-06 10:19:07',NULL,'2025-12-06 10:19:07',NULL,NULL),(640,NULL,'d1bd71ff76334cd69c38a4b5f62df67d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:09',NULL,'2025-12-06 10:19:09',NULL,NULL),(641,NULL,'a269d8afc49848fbb8ce5cdb49ef37dc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:09',NULL,'2025-12-06 10:19:09',NULL,NULL),(642,NULL,NULL,'967fe8818b7647408328e3de3e7091ab',NULL,NULL,NULL,NULL,'2025-12-06 10:19:11',NULL,'2025-12-06 10:19:11',NULL,NULL),(643,NULL,'5047c5584c514ce29369fde4f9fad694',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:12',NULL,'2025-12-06 10:19:12',NULL,NULL),(644,NULL,NULL,'969f4ae719ca4cb0abd04f2c326c0e33',NULL,NULL,NULL,NULL,'2025-12-06 10:19:14',NULL,'2025-12-06 10:19:14',NULL,NULL),(645,NULL,NULL,'61394465732941c4a6d5711ff9e15485',NULL,NULL,NULL,NULL,'2025-12-06 10:19:15',NULL,'2025-12-06 10:19:15',NULL,NULL),(646,NULL,'fdb99075d7fc4cbcbbded3b486dca9f2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:16',NULL,'2025-12-06 10:19:16',NULL,NULL),(647,NULL,'2cca2deb59744cdd922204ff50f015d2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:16',NULL,'2025-12-06 10:19:16',NULL,NULL),(648,NULL,NULL,'ec29f02579a54d488cbc8a2db31e2544',NULL,NULL,NULL,NULL,'2025-12-06 10:19:17',NULL,'2025-12-06 10:19:17',NULL,NULL),(649,NULL,NULL,'2f3913aba808471bad248368f22b1af0',NULL,NULL,NULL,NULL,'2025-12-06 10:19:17',NULL,'2025-12-06 10:19:17',NULL,NULL),(650,NULL,'d9b02e74009b4dd7b38d073a2a13fed2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:18',NULL,'2025-12-06 10:19:18',NULL,NULL),(651,NULL,'e168b5b0885147e4a6262e10e0e30dfa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:21',NULL,'2025-12-06 10:19:21',NULL,NULL),(652,NULL,NULL,'5533446cae154558992c3e249c7e19ee',NULL,NULL,NULL,NULL,'2025-12-06 10:19:23',NULL,'2025-12-06 10:19:23',NULL,NULL),(653,NULL,NULL,'1ed058b4973449e2af8bf970c6965350',NULL,NULL,NULL,NULL,'2025-12-06 10:19:25',NULL,'2025-12-06 10:19:25',NULL,NULL),(654,NULL,NULL,'7365839d5bca455283c571ca0abd33bb',NULL,NULL,NULL,NULL,'2025-12-06 10:19:25',NULL,'2025-12-06 10:19:25',NULL,NULL),(655,NULL,'839b049bc4e04682a1654015a92dbbe4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:25',NULL,'2025-12-06 10:19:25',NULL,NULL),(656,NULL,'12673f85bb004c3c946338dc70e565e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:27',NULL,'2025-12-06 10:19:27',NULL,NULL),(657,NULL,'9602e81a94c44ffc9a60feca56a4a3b8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:27',NULL,'2025-12-06 10:19:27',NULL,NULL),(658,NULL,NULL,'dd5870cb3bff4dbd9b63b50fb2dfe939',NULL,NULL,NULL,NULL,'2025-12-06 10:19:29',NULL,'2025-12-06 10:19:29',NULL,NULL),(659,NULL,NULL,'a6a9256bca1441629c18003b71ba1c6f',NULL,NULL,NULL,NULL,'2025-12-06 10:19:29',NULL,'2025-12-06 10:19:29',NULL,NULL),(660,NULL,'34a17eee71de4bac8b71972a4b7b506c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:30',NULL,'2025-12-06 10:19:30',NULL,NULL),(661,NULL,NULL,'53ffb7586e18478c972ccb1538be92a0',NULL,NULL,NULL,NULL,'2025-12-06 10:19:31',NULL,'2025-12-06 10:19:31',NULL,NULL),(662,NULL,NULL,'8705da02a69e4c3281916dd7bc9ac6d1',NULL,NULL,NULL,NULL,'2025-12-06 10:19:31',NULL,'2025-12-06 10:19:31',NULL,NULL),(663,NULL,'d41ffc1b8f4644839dbec6daee03a8e8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:31',NULL,'2025-12-06 10:19:31',NULL,NULL),(664,NULL,'e3ec699823bd47cdb7259d56b75c95b2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:32',NULL,'2025-12-06 10:19:32',NULL,NULL),(665,NULL,'851f2bb5c4164322946aa41fe266eb66',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:34',NULL,'2025-12-06 10:19:34',NULL,NULL),(666,NULL,NULL,'25eb67fead874d42a56f64bcea2a5914',NULL,NULL,NULL,NULL,'2025-12-06 10:19:37',NULL,'2025-12-06 10:19:37',NULL,NULL),(667,NULL,NULL,'b30ee2b2ade74f9e80de3f1afc291bda',NULL,NULL,NULL,NULL,'2025-12-06 10:19:38',NULL,'2025-12-06 10:19:38',NULL,NULL),(668,NULL,'1ed2dd1e38e94e2fb3db30e196137ff2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:39',NULL,'2025-12-06 10:19:39',NULL,NULL),(669,NULL,'29c573bcf157448abe548893ad01e3d2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:40',NULL,'2025-12-06 10:19:40',NULL,NULL),(670,NULL,NULL,'80d541acc7534ed58d0b81817d6af35d',NULL,NULL,NULL,NULL,'2025-12-06 10:19:40',NULL,'2025-12-06 10:19:40',NULL,NULL),(671,NULL,NULL,'3965f53f15254c17b99da2e11d372200',NULL,NULL,NULL,NULL,'2025-12-06 10:19:42',NULL,'2025-12-06 10:19:42',NULL,NULL),(672,NULL,NULL,'f279325fd6b44b6a9cf19af767a2d096',NULL,NULL,NULL,NULL,'2025-12-06 10:19:44',NULL,'2025-12-06 10:19:44',NULL,NULL),(673,NULL,NULL,'d73b0d3919fb43f298a06f4a3ad666a1',NULL,NULL,NULL,NULL,'2025-12-06 10:19:44',NULL,'2025-12-06 10:19:44',NULL,NULL),(674,NULL,NULL,'4d468dd807f9428ca35388bd3acdcd40',NULL,NULL,NULL,NULL,'2025-12-06 10:19:44',NULL,'2025-12-06 10:19:44',NULL,NULL),(675,NULL,'911a328debfc4f209bacf73debc10fe3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:47',NULL,'2025-12-06 10:19:47',NULL,NULL),(676,NULL,NULL,'ee608c83c95e4f3b89126c0af033542a',NULL,NULL,NULL,NULL,'2025-12-06 10:19:48',NULL,'2025-12-06 10:19:48',NULL,NULL),(677,NULL,'4546d8ad0f9f489183755458f6e73de2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:49',NULL,'2025-12-06 10:19:49',NULL,NULL),(678,NULL,'a9be2712a2b242618de73b18ac23adf7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:53',NULL,'2025-12-06 10:19:53',NULL,NULL),(679,NULL,'a2e6067cdb6b47b7800024079f6bb108',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:19:54',NULL,'2025-12-06 10:19:54',NULL,NULL),(680,NULL,'d694f30d513746329568207534277c9c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:00',NULL,'2025-12-06 10:20:00',NULL,NULL),(681,NULL,NULL,'a31577503edf4745abb112adc3113276',NULL,NULL,NULL,NULL,'2025-12-06 10:20:01',NULL,'2025-12-06 10:20:01',NULL,NULL),(682,NULL,NULL,'ec9153e4b97248799dc22a4262ae5ef7',NULL,NULL,NULL,NULL,'2025-12-06 10:20:02',NULL,'2025-12-06 10:20:02',NULL,NULL),(683,NULL,NULL,'b41a719cd9f34b51bba80f2ff7bb9d45',NULL,NULL,NULL,NULL,'2025-12-06 10:20:02',NULL,'2025-12-06 10:20:02',NULL,NULL),(684,NULL,NULL,'f36e68de80ff4cfb85ab14c997e9cf64',NULL,NULL,NULL,NULL,'2025-12-06 10:20:02',NULL,'2025-12-06 10:20:02',NULL,NULL),(685,NULL,NULL,'10ba89ceb79442febe7d3762b1240837',NULL,NULL,NULL,NULL,'2025-12-06 10:20:02',NULL,'2025-12-06 10:20:02',NULL,NULL),(686,NULL,'90bd35d6ab7c40c58d9d1d61ff7a12d3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:03',NULL,'2025-12-06 10:20:03',NULL,NULL),(687,NULL,NULL,'25a08bdcfd48469799ef9ba8dce10243',NULL,NULL,NULL,NULL,'2025-12-06 10:20:03',NULL,'2025-12-06 10:20:03',NULL,NULL),(688,NULL,NULL,'0bba792cd5cb40b3824a85268d5a33df',NULL,NULL,NULL,NULL,'2025-12-06 10:20:05',NULL,'2025-12-06 10:20:05',NULL,NULL),(689,NULL,'a73251a68c34441ebd4ae61c5a7f8e2a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:06',NULL,'2025-12-06 10:20:06',NULL,NULL),(690,NULL,NULL,'78ff16ba544f4ea7a645543e1b3fab83',NULL,NULL,NULL,NULL,'2025-12-06 10:20:06',NULL,'2025-12-06 10:20:06',NULL,NULL),(691,NULL,'324e9b16bef1474d9c9b1e101d2f3ae1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:06',NULL,'2025-12-06 10:20:06',NULL,NULL),(692,NULL,'d030d665779a4b118b98a2e7243001c1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:07',NULL,'2025-12-06 10:20:07',NULL,NULL),(693,NULL,'b8f0c3846bef4c15827f3c3006c8ab63',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:08',NULL,'2025-12-06 10:20:08',NULL,NULL),(694,NULL,'fc638a2127c3441d8d9a2c6f5ea8caa7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:09',NULL,'2025-12-06 10:20:09',NULL,NULL),(695,NULL,NULL,'c8b356df38aa419cbeb5840b1bd6952e',NULL,NULL,NULL,NULL,'2025-12-06 10:20:12',NULL,'2025-12-06 10:20:12',NULL,NULL),(696,NULL,NULL,'6dde5336c4744e0d8b73b12e37058d2b',NULL,NULL,NULL,NULL,'2025-12-06 10:20:13',NULL,'2025-12-06 10:20:13',NULL,NULL),(697,NULL,NULL,'a86c73ba3c184e12856a751fad5b546b',NULL,NULL,NULL,NULL,'2025-12-06 10:20:13',NULL,'2025-12-06 10:20:13',NULL,NULL),(698,NULL,'b0cd3597c26c4ae5b17e4fcc045b4455',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:14',NULL,'2025-12-06 10:20:14',NULL,NULL),(699,NULL,'e03a3abfa2c441c78a203b763a3125eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:15',NULL,'2025-12-06 10:20:15',NULL,NULL),(700,NULL,'644326bd42d24a4ea4082b4f209b2205',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:16',NULL,'2025-12-06 10:20:16',NULL,NULL),(701,NULL,NULL,'b9f4d254b45d482eab7cfb178c231d9a',NULL,NULL,NULL,NULL,'2025-12-06 10:20:18',NULL,'2025-12-06 10:20:18',NULL,NULL),(702,NULL,NULL,'32bd2dabef1b4752a6bab38fa95f7a85',NULL,NULL,NULL,NULL,'2025-12-06 10:20:18',NULL,'2025-12-06 10:20:18',NULL,NULL),(703,NULL,'5f8e1c4c589749b99178bbc7c2bea3f0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:19',NULL,'2025-12-06 10:20:19',NULL,NULL),(704,NULL,'fa441ae8671e4b11bae17535283d4b4c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:20',NULL,'2025-12-06 10:20:20',NULL,NULL),(705,NULL,NULL,'5bed76562a9c480bbc65c8e3541d13c5',NULL,NULL,NULL,NULL,'2025-12-06 10:20:22',NULL,'2025-12-06 10:20:22',NULL,NULL),(706,NULL,'ca36e4f4a4714022a89a8f2cf1b30df9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:23',NULL,'2025-12-06 10:20:23',NULL,NULL),(707,NULL,NULL,'defae908f28745a4b8aa437967c921d2',NULL,NULL,NULL,NULL,'2025-12-06 10:20:31',NULL,'2025-12-06 10:20:31',NULL,NULL),(708,NULL,NULL,'e0e642c6e5b94e7698264a151ca8b421',NULL,NULL,NULL,NULL,'2025-12-06 10:20:31',NULL,'2025-12-06 10:20:31',NULL,NULL),(709,NULL,'0cecfa016ae24bd1bf739444a8149a51',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:32',NULL,'2025-12-06 10:20:32',NULL,NULL),(710,NULL,'6d0a8aa137f541eaa9efa5eddfd19a6b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:33',NULL,'2025-12-06 10:20:33',NULL,NULL),(711,NULL,NULL,'3742bd6bc50045dc948a5ed989fe1987',NULL,NULL,NULL,NULL,'2025-12-06 10:20:39',NULL,'2025-12-06 10:20:39',NULL,NULL),(712,NULL,NULL,'7975e7f9b3b14b428820528ea921b9c9',NULL,NULL,NULL,NULL,'2025-12-06 10:20:40',NULL,'2025-12-06 10:20:40',NULL,NULL),(713,NULL,'c7d40566613e48abb0bad3f54a20e498',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:42',NULL,'2025-12-06 10:20:42',NULL,NULL),(714,NULL,NULL,'95268a68b5c84162ba789100555874fb',NULL,NULL,NULL,NULL,'2025-12-06 10:20:42',NULL,'2025-12-06 10:20:42',NULL,NULL),(715,NULL,'889aeebe2fa34e0285e071ed4d74ee04',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:43',NULL,'2025-12-06 10:20:43',NULL,NULL),(716,NULL,'7787060a7af94f168805e73d06841337',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:43',NULL,'2025-12-06 10:20:43',NULL,NULL),(717,NULL,NULL,'ba38c7f9e7104c6aae5f8c0c0efbcbbb',NULL,NULL,NULL,NULL,'2025-12-06 10:20:46',NULL,'2025-12-06 10:20:46',NULL,NULL),(718,NULL,NULL,'a62c5b88f4c54b1a8e86c53b6336a7df',NULL,NULL,NULL,NULL,'2025-12-06 10:20:46',NULL,'2025-12-06 10:20:46',NULL,NULL),(719,NULL,NULL,'62de5bca11094c1db3b3f0941045a4aa',NULL,NULL,NULL,NULL,'2025-12-06 10:20:47',NULL,'2025-12-06 10:20:47',NULL,NULL),(720,NULL,'cac28ee51926445e98b064ed4d5f28d2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:47',NULL,'2025-12-06 10:20:47',NULL,NULL),(721,NULL,NULL,'1e4e26edef4145a3b64cf319aa2deeb7',NULL,NULL,NULL,NULL,'2025-12-06 10:20:49',NULL,'2025-12-06 10:20:49',NULL,NULL),(722,NULL,NULL,'ac435c0ca5df4e96ab8c2e973929c75c',NULL,NULL,NULL,NULL,'2025-12-06 10:20:49',NULL,'2025-12-06 10:20:49',NULL,NULL),(723,NULL,'5583ca2a0ce0433fad03245652750c4c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:49',NULL,'2025-12-06 10:20:49',NULL,NULL),(724,NULL,NULL,'977327d588d14c3889ef09c629f803b0',NULL,NULL,NULL,NULL,'2025-12-06 10:20:49',NULL,'2025-12-06 10:20:49',NULL,NULL),(725,NULL,'511a934bef1b402c802c2c54d54771e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:50',NULL,'2025-12-06 10:20:50',NULL,NULL),(726,NULL,'7ac49d079fe340aaaecd81451d9cdd01',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:51',NULL,'2025-12-06 10:20:51',NULL,NULL),(727,NULL,'8373bafaaec64bce922164cce92b4242',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:51',NULL,'2025-12-06 10:20:51',NULL,NULL),(728,NULL,'b4bb1bd9722045dfb55dadfe141ca323',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:51',NULL,'2025-12-06 10:20:51',NULL,NULL),(729,NULL,NULL,'59171e728e5b40f08ee9bf2cf1f197e8',NULL,NULL,NULL,NULL,'2025-12-06 10:20:53',NULL,'2025-12-06 10:20:53',NULL,NULL),(730,NULL,NULL,'b82aa594dc0f41ffb65537c85b2581f2',NULL,NULL,NULL,NULL,'2025-12-06 10:20:54',NULL,'2025-12-06 10:20:54',NULL,NULL),(731,NULL,NULL,'c4a5added01d403e9852382ab9e37e24',NULL,NULL,NULL,NULL,'2025-12-06 10:20:54',NULL,'2025-12-06 10:20:54',NULL,NULL),(732,NULL,'fa343a31280e4e4494795f33bbc51ecb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:56',NULL,'2025-12-06 10:20:56',NULL,NULL),(733,NULL,NULL,'c560e9dd48c84c2bb571de95cecfff70',NULL,NULL,NULL,NULL,'2025-12-06 10:20:56',NULL,'2025-12-06 10:20:56',NULL,NULL),(734,NULL,NULL,'3c50d030cbcb4b10861d132adc1813e6',NULL,NULL,NULL,NULL,'2025-12-06 10:20:57',NULL,'2025-12-06 10:20:57',NULL,NULL),(735,NULL,NULL,'41758282f74647fd9139076a4413daee',NULL,NULL,NULL,NULL,'2025-12-06 10:20:57',NULL,'2025-12-06 10:20:57',NULL,NULL),(736,NULL,NULL,'cb264d7094c74425984a005c3a331ef6',NULL,NULL,NULL,NULL,'2025-12-06 10:20:57',NULL,'2025-12-06 10:20:57',NULL,NULL),(737,NULL,'8d7c2969d2d142e7939cd9545aa69a1d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:57',NULL,'2025-12-06 10:20:57',NULL,NULL),(738,NULL,'1f00ab5f7d934f62991ed1e7e798e47e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:58',NULL,'2025-12-06 10:20:58',NULL,NULL),(739,NULL,'c4a2fd17baa14963bf4a9820b2615c0b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:58',NULL,'2025-12-06 10:20:58',NULL,NULL),(740,NULL,NULL,'828f4e6858ab4f33907e785e9a118342',NULL,NULL,NULL,NULL,'2025-12-06 10:20:59',NULL,'2025-12-06 10:20:59',NULL,NULL),(741,NULL,'61b49afac18a40868fe88987d5bd95c1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:20:59',NULL,'2025-12-06 10:20:59',NULL,NULL),(742,NULL,NULL,'dd3153b9db25400abec1d1e930b89335',NULL,NULL,NULL,NULL,'2025-12-06 10:20:59',NULL,'2025-12-06 10:20:59',NULL,NULL),(743,NULL,NULL,'300f2915f5d948b1b68e3932a410f1c6',NULL,NULL,NULL,NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:00',NULL,NULL),(744,NULL,NULL,'fa79cd0cb59f4e68a6715a71b372645d',NULL,NULL,NULL,NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:00',NULL,NULL),(745,NULL,'818b859de08540688ebdfcac842e6da6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:00',NULL,NULL),(746,NULL,'fa76bcfc789b4e53acf344cd0b1cd7c5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:00',NULL,NULL),(747,NULL,NULL,'99950c2dd91c4e3e9f353b21329b3d8e',NULL,NULL,NULL,NULL,'2025-12-06 10:21:00',NULL,'2025-12-06 10:21:00',NULL,NULL),(748,NULL,'815f2b1381c44cb1a9e45a3f836127a8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:02',NULL,'2025-12-06 10:21:02',NULL,NULL),(749,NULL,NULL,'273e1cbe5d3947f5b79f53a4cb30c980',NULL,NULL,NULL,NULL,'2025-12-06 10:21:02',NULL,'2025-12-06 10:21:02',NULL,NULL),(750,NULL,'fa8e34bd21444bf1be5f74b65d635158',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:03',NULL,'2025-12-06 10:21:03',NULL,NULL),(751,NULL,'9a754604b7cd48db9f2bfbdb22ebb0bd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:03',NULL,'2025-12-06 10:21:03',NULL,NULL),(752,NULL,'fc82976ac3144b2c8dbb1b5639000de1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:03',NULL,'2025-12-06 10:21:03',NULL,NULL),(753,NULL,NULL,'3e4c3243bf5c4e3a9a62ce06cde13e3d',NULL,NULL,NULL,NULL,'2025-12-06 10:21:07',NULL,'2025-12-06 10:21:07',NULL,NULL),(754,NULL,NULL,'260dfc8941214c308c05293af65bdae9',NULL,NULL,NULL,NULL,'2025-12-06 10:21:09',NULL,'2025-12-06 10:21:09',NULL,NULL),(755,NULL,'3611325ae8594883a9bcd4e1005703c3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:09',NULL,'2025-12-06 10:21:09',NULL,NULL),(756,NULL,NULL,'a02ee852d0634ac0adb9f927efde9213',NULL,NULL,NULL,NULL,'2025-12-06 10:21:09',NULL,'2025-12-06 10:21:09',NULL,NULL),(757,NULL,NULL,'e9b30c512ce140c985bb5bab705d7efc',NULL,NULL,NULL,NULL,'2025-12-06 10:21:10',NULL,'2025-12-06 10:21:10',NULL,NULL),(758,NULL,NULL,'0d787d17c2df4c1cbf7bf928906ac9e8',NULL,NULL,NULL,NULL,'2025-12-06 10:21:10',NULL,'2025-12-06 10:21:10',NULL,NULL),(759,NULL,NULL,'e1cc575d68644435a96e018ab9cabf96',NULL,NULL,NULL,NULL,'2025-12-06 10:21:10',NULL,'2025-12-06 10:21:10',NULL,NULL),(760,NULL,'24086b701d6b4d4081d2e63578d18d24',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:10',NULL,'2025-12-06 10:21:10',NULL,NULL),(761,NULL,'9b2787333d2a41889c66487cf6f1f824',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:11',NULL,'2025-12-06 10:21:11',NULL,NULL),(762,NULL,'abf3db88f6aa45ec885a741fbdfeee25',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:12',NULL,'2025-12-06 10:21:12',NULL,NULL),(763,NULL,'0862199e316e4225866a9d2f97b97851',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:12',NULL,'2025-12-06 10:21:12',NULL,NULL),(764,NULL,'7b08d7598dc24ecfb48eb0563cd3107f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:13',NULL,'2025-12-06 10:21:13',NULL,NULL),(765,NULL,NULL,'261c2099f6234b77aa4c2c5d12c55fcb',NULL,NULL,NULL,NULL,'2025-12-06 10:21:14',NULL,'2025-12-06 10:21:14',NULL,NULL),(766,NULL,NULL,'2a4d7b8309264c629e6a7f93da9eea33',NULL,NULL,NULL,NULL,'2025-12-06 10:21:14',NULL,'2025-12-06 10:21:14',NULL,NULL),(767,NULL,NULL,'20e73dea82d14668b6b190aa3ab4fe2b',NULL,NULL,NULL,NULL,'2025-12-06 10:21:15',NULL,'2025-12-06 10:21:15',NULL,NULL),(768,NULL,NULL,'8d5e7af6ef6449adb0d460abacce4537',NULL,NULL,NULL,NULL,'2025-12-06 10:21:15',NULL,'2025-12-06 10:21:15',NULL,NULL),(769,NULL,NULL,'4e822652309d4b429a1683106f98f2b2',NULL,NULL,NULL,NULL,'2025-12-06 10:21:15',NULL,'2025-12-06 10:21:15',NULL,NULL),(770,NULL,NULL,'0c2cf0c71288433baed1e5bcb364d9f6',NULL,NULL,NULL,NULL,'2025-12-06 10:21:15',NULL,'2025-12-06 10:21:15',NULL,NULL),(771,NULL,'c70a2749dde145bca59fa43c16d3a1cb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:16',NULL,'2025-12-06 10:21:16',NULL,NULL),(772,NULL,'cb458663cb5640eda98626796757d2a7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:17',NULL,'2025-12-06 10:21:17',NULL,NULL),(773,NULL,'9877ea92d21c443da020b2f5ac6e63a2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:17',NULL,'2025-12-06 10:21:17',NULL,NULL),(774,NULL,'90d3b7f16068431aa5a6b9731cf370c1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:18',NULL,'2025-12-06 10:21:18',NULL,NULL),(775,NULL,NULL,'9123e014de9b4461954565907989992a',NULL,NULL,NULL,NULL,'2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19',NULL,NULL),(776,NULL,NULL,'32507cd65f5b4864829e7b03667557c2',NULL,NULL,NULL,NULL,'2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19',NULL,NULL),(777,NULL,NULL,'50d2a615fd524960a0865e36c92b300a',NULL,NULL,NULL,NULL,'2025-12-06 10:21:19',NULL,'2025-12-06 10:21:19',NULL,NULL),(778,NULL,'317287f235e9449bbecd27cc55e50c76',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:20',NULL,'2025-12-06 10:21:20',NULL,NULL),(779,NULL,NULL,'18894715ea384479ab6561155114f3f7',NULL,NULL,NULL,NULL,'2025-12-06 10:21:21',NULL,'2025-12-06 10:21:21',NULL,NULL),(780,NULL,'617e21f2837c4be9825357089f4f14b0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:21',NULL,'2025-12-06 10:21:21',NULL,NULL),(781,NULL,NULL,'2c36ca91e0a44aa0b02f8bba067633f3',NULL,NULL,NULL,NULL,'2025-12-06 10:21:22',NULL,'2025-12-06 10:21:22',NULL,NULL),(782,NULL,NULL,'5397cab706324339aa7db7271b71c144',NULL,NULL,NULL,NULL,'2025-12-06 10:21:22',NULL,'2025-12-06 10:21:22',NULL,NULL),(783,NULL,NULL,'57b7165110d541dcbd550fec9e53b821',NULL,NULL,NULL,NULL,'2025-12-06 10:21:22',NULL,'2025-12-06 10:21:22',NULL,NULL),(784,NULL,'b0d8ee3dce5f48ada2c690a922117eb5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:22',NULL,'2025-12-06 10:21:22',NULL,NULL),(785,NULL,'c10c64021a544b89a5534dadb82defd7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:22',NULL,'2025-12-06 10:21:22',NULL,NULL),(786,NULL,'ad585e38a585413188401641b7f99059',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:23',NULL,'2025-12-06 10:21:23',NULL,NULL),(787,NULL,'079c8fe53cf74e56b1041a7221d6f7ca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:24',NULL,'2025-12-06 10:21:24',NULL,NULL),(788,NULL,'b80170816baf4e81b06e1157b03a36e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:25',NULL,'2025-12-06 10:21:25',NULL,NULL),(789,NULL,NULL,'0c86ca9db03a4b3f87509a8239093323',NULL,NULL,NULL,NULL,'2025-12-06 10:21:26',NULL,'2025-12-06 10:21:26',NULL,NULL),(790,NULL,NULL,'62ed0c0c12f545ef83d0c9ca14c39352',NULL,NULL,NULL,NULL,'2025-12-06 10:21:26',NULL,'2025-12-06 10:21:26',NULL,NULL),(791,NULL,NULL,'14db54f428d84c88aba32e6937011f75',NULL,NULL,NULL,NULL,'2025-12-06 10:21:26',NULL,'2025-12-06 10:21:26',NULL,NULL),(792,NULL,NULL,'ec78d92ffcbe435ba7b099e85570b79d',NULL,NULL,NULL,NULL,'2025-12-06 10:21:26',NULL,'2025-12-06 10:21:26',NULL,NULL),(793,NULL,NULL,'30cf04d5fefb49508c8902195ed7b7a2',NULL,NULL,NULL,NULL,'2025-12-06 10:21:27',NULL,'2025-12-06 10:21:27',NULL,NULL),(794,NULL,'969bd3cedbbc4b03a4546a8b852f13f2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:27',NULL,'2025-12-06 10:21:27',NULL,NULL),(795,NULL,'be339059edb649ed9bb15e3853dd8f27',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:28',NULL,'2025-12-06 10:21:28',NULL,NULL),(796,NULL,'6ce743a724c34387845e6b295502d728',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:28',NULL,'2025-12-06 10:21:28',NULL,NULL),(797,NULL,'c9825dbef45840dea3df0c4080146893',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:29',NULL,'2025-12-06 10:21:29',NULL,NULL),(798,NULL,'9847f1afa3464dc7b8aac27cb0247e9e',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:29',NULL,'2025-12-06 10:21:29',NULL,NULL),(799,NULL,NULL,'2c8a6bc218904e268bcdd072b3b3d86d',NULL,NULL,NULL,NULL,'2025-12-06 10:21:34',NULL,'2025-12-06 10:21:34',NULL,NULL),(800,NULL,NULL,'b8e2f0c59fbf4bd693e0c4fc604705f7',NULL,NULL,NULL,NULL,'2025-12-06 10:21:34',NULL,'2025-12-06 10:21:34',NULL,NULL),(801,NULL,NULL,'e30cf64f20b946a2813a5ed41eede359',NULL,NULL,NULL,NULL,'2025-12-06 10:21:34',NULL,'2025-12-06 10:21:34',NULL,NULL),(802,NULL,'552ef497717d434fa82fca1eb637e804',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:36',NULL,'2025-12-06 10:21:36',NULL,NULL),(803,NULL,NULL,'59fc468a3ce144759edc5d5688424751',NULL,NULL,NULL,NULL,'2025-12-06 10:21:36',NULL,'2025-12-06 10:21:36',NULL,NULL),(804,NULL,NULL,'a3846342ee734fae98d301bc764d5aa7',NULL,NULL,NULL,NULL,'2025-12-06 10:21:37',NULL,'2025-12-06 10:21:37',NULL,NULL),(805,NULL,'f0737a9f95674489a78f5f5ca36df954',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:37',NULL,'2025-12-06 10:21:37',NULL,NULL),(806,NULL,NULL,'e8f37b36f7194580996c32164f2971d2',NULL,NULL,NULL,NULL,'2025-12-06 10:21:37',NULL,'2025-12-06 10:21:37',NULL,NULL),(807,NULL,NULL,'23f3320b902243b7b041cbe708a349d5',NULL,NULL,NULL,NULL,'2025-12-06 10:21:37',NULL,'2025-12-06 10:21:37',NULL,NULL),(808,NULL,'1ef7790e4e3343f99faca2d9c608b7f6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:39',NULL,'2025-12-06 10:21:39',NULL,NULL),(809,NULL,'cf4a0fb5f4994d26acf80b3639b47c45',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:39',NULL,'2025-12-06 10:21:39',NULL,NULL),(810,NULL,NULL,'cc9a0aebc5df40baa5d30408481c8824',NULL,NULL,NULL,NULL,'2025-12-06 10:21:39',NULL,'2025-12-06 10:21:39',NULL,NULL),(811,NULL,'b38eb6f21ec74dda8dbf3ba362b740e6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:40',NULL,'2025-12-06 10:21:40',NULL,NULL),(812,NULL,'5ea98fc77f0c4728a4c2d7a5429d8129',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:41',NULL,'2025-12-06 10:21:41',NULL,NULL),(813,NULL,'d0315a7a31194fe5bc10aff481f0b185',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:41',NULL,'2025-12-06 10:21:41',NULL,NULL),(814,NULL,NULL,'0a112a7610ea464795cd9505d1adff12',NULL,NULL,NULL,NULL,'2025-12-06 10:21:42',NULL,'2025-12-06 10:21:42',NULL,NULL),(815,NULL,NULL,'efa0a8b565434ce69ac6e465c0524033',NULL,NULL,NULL,NULL,'2025-12-06 10:21:43',NULL,'2025-12-06 10:21:43',NULL,NULL),(816,NULL,NULL,'1c980f45f3e4418eb757be06bc24856c',NULL,NULL,NULL,NULL,'2025-12-06 10:21:43',NULL,'2025-12-06 10:21:43',NULL,NULL),(817,NULL,NULL,'fa029c59ca1143c3a47c6ff44f0fe268',NULL,NULL,NULL,NULL,'2025-12-06 10:21:43',NULL,'2025-12-06 10:21:43',NULL,NULL),(818,NULL,NULL,'b69ec24365414c968d8cdb4725eef95f',NULL,NULL,NULL,NULL,'2025-12-06 10:21:43',NULL,'2025-12-06 10:21:43',NULL,NULL),(819,NULL,NULL,'cd10082f0bfe419f9ffd09193458be27',NULL,NULL,NULL,NULL,'2025-12-06 10:21:44',NULL,'2025-12-06 10:21:44',NULL,NULL),(820,NULL,'eab6fb5a053a4a4f8668138357e0b3b6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:44',NULL,'2025-12-06 10:21:44',NULL,NULL),(821,NULL,'f5a7bbeba4b24e8186ef063c429b60eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:44',NULL,'2025-12-06 10:21:44',NULL,NULL),(822,NULL,'bd21220138724abd9c028beda882bb8a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:45',NULL,'2025-12-06 10:21:45',NULL,NULL),(823,NULL,'f7a062bb0b084dcb9736c737dbff3764',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:45',NULL,'2025-12-06 10:21:45',NULL,NULL),(824,NULL,'bd1309273a0a4c0e8809a4be473f7ff0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:46',NULL,'2025-12-06 10:21:46',NULL,NULL),(825,NULL,NULL,'4f519d0599954241b120631ea5b0005f',NULL,NULL,NULL,NULL,'2025-12-06 10:21:48',NULL,'2025-12-06 10:21:48',NULL,NULL),(826,NULL,NULL,'e79d3d9ca9844cf7a820fed66615a837',NULL,NULL,NULL,NULL,'2025-12-06 10:21:49',NULL,'2025-12-06 10:21:49',NULL,NULL),(827,NULL,'59422807a28544198d335242491278c9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:50',NULL,'2025-12-06 10:21:50',NULL,NULL),(828,NULL,'88ea8626c7df4b62bf7459a615217eeb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:50',NULL,'2025-12-06 10:21:50',NULL,NULL),(829,NULL,NULL,'4cc467ce0741485590699305e60c88f2',NULL,NULL,NULL,NULL,'2025-12-06 10:21:52',NULL,'2025-12-06 10:21:52',NULL,NULL),(830,NULL,'8c8effb89af64a7eaa29aa17e4fe40e7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:54',NULL,'2025-12-06 10:21:54',NULL,NULL),(831,NULL,NULL,'3e135f3ec1b146868bc539d6de06ad49',NULL,NULL,NULL,NULL,'2025-12-06 10:21:55',NULL,'2025-12-06 10:21:55',NULL,NULL),(832,NULL,NULL,'8b0c7944dfd447c294d7eb5612625189',NULL,NULL,NULL,NULL,'2025-12-06 10:21:55',NULL,'2025-12-06 10:21:55',NULL,NULL),(833,NULL,NULL,'40b219b6ed0e4bf59a03ac5f0d2fe456',NULL,NULL,NULL,NULL,'2025-12-06 10:21:55',NULL,'2025-12-06 10:21:55',NULL,NULL),(834,NULL,NULL,'db5c8b0893b04f6aa2b9688273d9e909',NULL,NULL,NULL,NULL,'2025-12-06 10:21:55',NULL,'2025-12-06 10:21:55',NULL,NULL),(835,NULL,NULL,'a2f6f80b9d5a42ccb727340d59efb967',NULL,NULL,NULL,NULL,'2025-12-06 10:21:56',NULL,'2025-12-06 10:21:56',NULL,NULL),(836,NULL,NULL,'69342e816b8a4c66a18fe32123f49c95',NULL,NULL,NULL,NULL,'2025-12-06 10:21:56',NULL,'2025-12-06 10:21:56',NULL,NULL),(837,NULL,NULL,'f6d5df4ea1d84dfda2a4150103fec0e7',NULL,NULL,NULL,NULL,'2025-12-06 10:21:56',NULL,'2025-12-06 10:21:56',NULL,NULL),(838,NULL,'a1f6137b35b245a4bc3dc7940c81d755',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:57',NULL,'2025-12-06 10:21:57',NULL,NULL),(839,NULL,'a18f82f0d09644c7b6d23e2fece8be4f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:57',NULL,'2025-12-06 10:21:57',NULL,NULL),(840,NULL,'ea64a9320772454e84f0ec1f8e559297',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:57',NULL,'2025-12-06 10:21:57',NULL,NULL),(841,NULL,'f724b70101a54e0ba06b9ffa69a4cb72',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:58',NULL,'2025-12-06 10:21:58',NULL,NULL),(842,NULL,'8566f9acc2b141e2a06f7a1cbef81657',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:59',NULL,'2025-12-06 10:21:59',NULL,NULL),(843,NULL,'1d71e1d8c61c4499906494dca75eead7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:21:59',NULL,'2025-12-06 10:21:59',NULL,NULL),(844,NULL,NULL,'f47e951a99734c9ba86fe322a9734426',NULL,NULL,NULL,NULL,'2025-12-06 10:22:01',NULL,'2025-12-06 10:22:01',NULL,NULL),(845,NULL,'21bf59760cb34866a9b2d62706be4811',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',NULL,NULL),(846,NULL,NULL,'9b60c0997f4d4bf6ad041d7d42509d36',NULL,NULL,NULL,NULL,'2025-12-06 10:22:03',NULL,'2025-12-06 10:22:03',NULL,NULL),(847,NULL,NULL,'e4fc2ffde7e9475ebed9492c03fb7eaf',NULL,NULL,NULL,NULL,'2025-12-06 10:22:04',NULL,'2025-12-06 10:22:04',NULL,NULL),(848,NULL,NULL,'319aada8de5844039139acd6d4ca442f',NULL,NULL,NULL,NULL,'2025-12-06 10:22:04',NULL,'2025-12-06 10:22:04',NULL,NULL),(849,NULL,NULL,'6596c21f02dd4e379379e65b0e17a02b',NULL,NULL,NULL,NULL,'2025-12-06 10:22:06',NULL,'2025-12-06 10:22:06',NULL,NULL),(850,NULL,'f31283eec4574cb986aaa0b25b37907a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:06',NULL,'2025-12-06 10:22:06',NULL,NULL),(851,NULL,NULL,'855e050f34334842b489f5e7ecf811bb',NULL,NULL,NULL,NULL,'2025-12-06 10:22:07',NULL,'2025-12-06 10:22:07',NULL,NULL),(852,NULL,NULL,'bf701c52b5d44075a996efe806e4470a',NULL,NULL,NULL,NULL,'2025-12-06 10:22:07',NULL,'2025-12-06 10:22:07',NULL,NULL),(853,NULL,NULL,'312957c6aa774cec8e87e48b699f5759',NULL,NULL,NULL,NULL,'2025-12-06 10:22:07',NULL,'2025-12-06 10:22:07',NULL,NULL),(854,NULL,'1deccdc18dac46569766c29ac649dbe0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:07',NULL,'2025-12-06 10:22:07',NULL,NULL),(855,NULL,'410ff89e580741199025c340c093426c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:08',NULL,'2025-12-06 10:22:08',NULL,NULL),(856,NULL,'0b0cb54d436440afa3f324ec7f09c741',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:09',NULL,'2025-12-06 10:22:09',NULL,NULL),(857,NULL,'2db8152bb67a4b328c498d8406f999c6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:10',NULL,'2025-12-06 10:22:10',NULL,NULL),(858,NULL,'aff741aa7ffb45e69b516ac04c7e66f7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:10',NULL,'2025-12-06 10:22:10',NULL,NULL),(859,NULL,NULL,'45fd864e7b3f47f8b48cb885183d0adc',NULL,NULL,NULL,NULL,'2025-12-06 10:22:13',NULL,'2025-12-06 10:22:13',NULL,NULL),(860,NULL,NULL,'ec38f91afc704aa9a50fd1d321acc654',NULL,NULL,NULL,NULL,'2025-12-06 10:22:13',NULL,'2025-12-06 10:22:13',NULL,NULL),(861,NULL,NULL,'29898fd2770148ada5906abc00ac8bb0',NULL,NULL,NULL,NULL,'2025-12-06 10:22:13',NULL,'2025-12-06 10:22:13',NULL,NULL),(862,NULL,NULL,'c4e6ec9414124882aba986a59aa3a3e1',NULL,NULL,NULL,NULL,'2025-12-06 10:22:13',NULL,'2025-12-06 10:22:13',NULL,NULL),(863,NULL,NULL,'c9d7db0d35bf49bca22e0a046ec5faf2',NULL,NULL,NULL,NULL,'2025-12-06 10:22:14',NULL,'2025-12-06 10:22:14',NULL,NULL),(864,NULL,'678e7aaced564776828960576789aff4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:15',NULL,'2025-12-06 10:22:15',NULL,NULL),(865,NULL,NULL,'ff62ad4bf60442acb4d5014a24263772',NULL,NULL,NULL,NULL,'2025-12-06 10:22:15',NULL,'2025-12-06 10:22:15',NULL,NULL),(866,NULL,'4bc40d3d29a24fc48c6e9a5c8ed430c2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:16',NULL,'2025-12-06 10:22:16',NULL,NULL),(867,NULL,'0869d8bc1b684db8b15afc4eebf3f39d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:17',NULL,'2025-12-06 10:22:17',NULL,NULL),(868,NULL,NULL,'0b0e814b677b4fbd84723c23380aec4b',NULL,NULL,NULL,NULL,'2025-12-06 10:22:17',NULL,'2025-12-06 10:22:17',NULL,NULL),(869,NULL,'427a870df85e416eacb15019a8a0d858',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:17',NULL,'2025-12-06 10:22:17',NULL,NULL),(870,NULL,'8cf642e4723a422297fa642f75188862',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:17',NULL,'2025-12-06 10:22:17',NULL,NULL),(871,NULL,'b4daafaf0e264da6a728bdd60c5d6377',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:18',NULL,'2025-12-06 10:22:18',NULL,NULL),(872,NULL,'f88c8d9427d5451587ee1e736390e3c4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:21',NULL,'2025-12-06 10:22:21',NULL,NULL),(873,NULL,NULL,'8be47aad0af8471392aab1c0c36ebd81',NULL,NULL,NULL,NULL,'2025-12-06 10:22:21',NULL,'2025-12-06 10:22:21',NULL,NULL),(874,NULL,NULL,'9304913bf9eb4089820870abdcb9489d',NULL,NULL,NULL,NULL,'2025-12-06 10:22:22',NULL,'2025-12-06 10:22:22',NULL,NULL),(875,NULL,'d68665af537b4f51b822e4b090668073',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:23',NULL,'2025-12-06 10:22:23',NULL,NULL),(876,NULL,NULL,'ec4c4d91ee4c4892b5a0007e35639cbc',NULL,NULL,NULL,NULL,'2025-12-06 10:22:23',NULL,'2025-12-06 10:22:23',NULL,NULL),(877,NULL,'1b87f40735e94220af9362226eb12624',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:23',NULL,'2025-12-06 10:22:23',NULL,NULL),(878,NULL,NULL,'6e357383949f44eb9be2d6531cf09983',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(879,NULL,NULL,'d30d15e6ab7f4843bf7e9cfdaf1e4c41',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(880,NULL,NULL,'05cea3733946411abb747782f855ad13',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(881,NULL,NULL,'184bb450d4864170a750006dfcc7e3fe',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(882,NULL,NULL,'8c8926260f75498ba88efcacf7010a6f',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(883,NULL,NULL,'47108d4c46554402a9fca248904c9996',NULL,NULL,NULL,NULL,'2025-12-06 10:22:24',NULL,'2025-12-06 10:22:24',NULL,NULL),(884,NULL,'e82deaff368b4feea9fec0f06459a6ca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:25',NULL,'2025-12-06 10:22:25',NULL,NULL),(885,NULL,'318e19e7541249a9a89016c23feff533',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:25',NULL,'2025-12-06 10:22:25',NULL,NULL),(886,NULL,'1501ea9e37f74fa698be7a5c04e0c9a2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:26',NULL,'2025-12-06 10:22:26',NULL,NULL),(887,NULL,'c975dde3e97d4665af303cf1c099b437',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:26',NULL,'2025-12-06 10:22:26',NULL,NULL),(888,NULL,'6a9ada521773408d947a57557a93858c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:27',NULL,'2025-12-06 10:22:27',NULL,NULL),(889,NULL,'27d01455ef604522b30ed3c627f764a1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:28',NULL,'2025-12-06 10:22:28',NULL,NULL),(890,NULL,NULL,'24193645530f4112b20669bb1fc87b25',NULL,NULL,NULL,NULL,'2025-12-06 10:22:29',NULL,'2025-12-06 10:22:29',NULL,NULL),(891,NULL,NULL,'cf83e4031d084b8faebabd816ccc8d4a',NULL,NULL,NULL,NULL,'2025-12-06 10:22:29',NULL,'2025-12-06 10:22:29',NULL,NULL),(892,NULL,NULL,'9046aafc2e894197ba5af7a14a5f93ad',NULL,NULL,NULL,NULL,'2025-12-06 10:22:29',NULL,'2025-12-06 10:22:29',NULL,NULL),(893,NULL,'c46055c9619b40b4b81b656be5ba8972',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:30',NULL,'2025-12-06 10:22:30',NULL,NULL),(894,NULL,'20da08794fe84a5e9d081e1856c3a90b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:31',NULL,'2025-12-06 10:22:31',NULL,NULL),(895,NULL,NULL,'02b36e7ff8b54c0ea203f9aa2a006b9f',NULL,NULL,NULL,NULL,'2025-12-06 10:22:35',NULL,'2025-12-06 10:22:35',NULL,NULL),(896,NULL,NULL,'ccf651867d2e467a85387893b983f73b',NULL,NULL,NULL,NULL,'2025-12-06 10:22:35',NULL,'2025-12-06 10:22:35',NULL,NULL),(897,NULL,NULL,'d80b03b6a328417f83847a33c3467543',NULL,NULL,NULL,NULL,'2025-12-06 10:22:36',NULL,'2025-12-06 10:22:36',NULL,NULL),(898,NULL,'b088b12441004d83ad8102ea175cdeb6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:37',NULL,'2025-12-06 10:22:37',NULL,NULL),(899,NULL,'40a609908d654e80b290625f417acaf6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:37',NULL,'2025-12-06 10:22:37',NULL,NULL),(900,NULL,'0bb1c648a1eb4322b7d7147d8b096005',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:38',NULL,'2025-12-06 10:22:38',NULL,NULL),(901,NULL,NULL,'7ae03e43faa04d1bbf58acfc698f4316',NULL,NULL,NULL,NULL,'2025-12-06 10:22:38',NULL,'2025-12-06 10:22:38',NULL,NULL),(902,NULL,'190aaeb6184a4deda2f79f6b164f3204',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:40',NULL,'2025-12-06 10:22:40',NULL,NULL),(903,NULL,NULL,'60f9b0f530754a3690a1c10df3214626',NULL,NULL,NULL,NULL,'2025-12-06 10:22:42',NULL,'2025-12-06 10:22:42',NULL,NULL),(904,NULL,NULL,'86df66862081439ba17e1c307ef669b9',NULL,NULL,NULL,NULL,'2025-12-06 10:22:42',NULL,'2025-12-06 10:22:42',NULL,NULL),(905,NULL,NULL,'9c39945a8b44415a9175ea2785d26cd7',NULL,NULL,NULL,NULL,'2025-12-06 10:22:42',NULL,'2025-12-06 10:22:42',NULL,NULL),(906,NULL,NULL,'f87722c68e6646b080f530096867b241',NULL,NULL,NULL,NULL,'2025-12-06 10:22:43',NULL,'2025-12-06 10:22:43',NULL,NULL),(907,NULL,'ac0a61a1a0c547ec899a2efec39ee132',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:43',NULL,'2025-12-06 10:22:43',NULL,NULL),(908,NULL,NULL,'5781ccfc050c48879bc2febeb45edfda',NULL,NULL,NULL,NULL,'2025-12-06 10:22:44',NULL,'2025-12-06 10:22:44',NULL,NULL),(909,NULL,'394673b24b3449889c7354261a069485',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:44',NULL,'2025-12-06 10:22:44',NULL,NULL),(910,NULL,NULL,'bdc998db767c405fa9d79433c0923cf6',NULL,NULL,NULL,NULL,'2025-12-06 10:22:44',NULL,'2025-12-06 10:22:44',NULL,NULL),(911,NULL,NULL,'10fe8fefbd6d4e759913559fa097da5f',NULL,NULL,NULL,NULL,'2025-12-06 10:22:44',NULL,'2025-12-06 10:22:44',NULL,NULL),(912,NULL,NULL,'b4b1fc6fa3b440a28f696a7911cbe75c',NULL,NULL,NULL,NULL,'2025-12-06 10:22:45',NULL,'2025-12-06 10:22:45',NULL,NULL),(913,NULL,'709404a5dbce4ee7a79b01c6ddec07bd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:45',NULL,'2025-12-06 10:22:45',NULL,NULL),(914,NULL,'257a7584f7b14f3fb15fdf774f388f44',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:46',NULL,'2025-12-06 10:22:46',NULL,NULL),(915,NULL,NULL,'9de6f48dc19147a792197ebb1653dc5e',NULL,NULL,NULL,NULL,'2025-12-06 10:22:46',NULL,'2025-12-06 10:22:46',NULL,NULL),(916,NULL,'f3e93244b8004145930461fd76b0fbbb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:46',NULL,'2025-12-06 10:22:46',NULL,NULL),(917,NULL,'fd1c979900294beeb6f273c0e1a6333a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:46',NULL,'2025-12-06 10:22:46',NULL,NULL),(918,NULL,'21b5e30f3fdc4ee5989f6db4f7562ff3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:47',NULL,'2025-12-06 10:22:47',NULL,NULL),(919,NULL,NULL,'71fd777285044408a97c1bcd9e31c316',NULL,NULL,NULL,NULL,'2025-12-06 10:22:47',NULL,'2025-12-06 10:22:47',NULL,NULL),(920,NULL,'a8ecb0b70bcf409abfa0dd07ba3c3a48',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:48',NULL,'2025-12-06 10:22:48',NULL,NULL),(921,NULL,NULL,'62322ce9b54e4926bdc8317dbdffd385',NULL,NULL,NULL,NULL,'2025-12-06 10:22:48',NULL,'2025-12-06 10:22:48',NULL,NULL),(922,NULL,NULL,'38c2865aa52745418ade3ab1bb2fd54b',NULL,NULL,NULL,NULL,'2025-12-06 10:22:48',NULL,'2025-12-06 10:22:48',NULL,NULL),(923,NULL,NULL,'b429fa167246458ab8a42a33efa35d93',NULL,NULL,NULL,NULL,'2025-12-06 10:22:48',NULL,'2025-12-06 10:22:48',NULL,NULL),(924,NULL,'b550fd5543ee40a1b0bbf6e21cb6a9f3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:49',NULL,'2025-12-06 10:22:49',NULL,NULL),(925,NULL,'bda02ea3c96c41dea538deeda04311bc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:50',NULL,'2025-12-06 10:22:50',NULL,NULL),(926,NULL,NULL,'42267b3d83c44a738814a6e7c38d3ff4',NULL,NULL,NULL,NULL,'2025-12-06 10:22:50',NULL,'2025-12-06 10:22:50',NULL,NULL),(927,NULL,NULL,'af933e973b9b4870a12fb22a724ad9ce',NULL,NULL,NULL,NULL,'2025-12-06 10:22:50',NULL,'2025-12-06 10:22:50',NULL,NULL),(928,NULL,'49596df2fe204e9ba6cde194b9dcbd99',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:50',NULL,'2025-12-06 10:22:50',NULL,NULL),(929,NULL,'cd5e563f75e14d08a1873055eac47c67',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:51',NULL,'2025-12-06 10:22:51',NULL,NULL),(930,NULL,'1ef4f313a6814244a5a3e08fcc6f236b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:52',NULL,'2025-12-06 10:22:52',NULL,NULL),(931,NULL,NULL,'400c7a5a05544a0596fadfc4160b3cdf',NULL,NULL,NULL,NULL,'2025-12-06 10:22:54',NULL,'2025-12-06 10:22:54',NULL,NULL),(932,NULL,'096aefe63e33405396d6efe65bbb1733',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',NULL,NULL),(933,NULL,NULL,'7a44e406fa904b889a0f483a4c7f969b',NULL,NULL,NULL,NULL,'2025-12-06 10:22:55',NULL,'2025-12-06 10:22:55',NULL,NULL),(934,NULL,NULL,'2bda8afb95784905b93fe1a9a5def251',NULL,NULL,NULL,NULL,'2025-12-06 10:22:56',NULL,'2025-12-06 10:22:56',NULL,NULL),(935,NULL,NULL,'b898d0b45de84b89a6a6ac9032ba8e8e',NULL,NULL,NULL,NULL,'2025-12-06 10:22:56',NULL,'2025-12-06 10:22:56',NULL,NULL),(936,NULL,NULL,'0623bd128f7a4499b3bbaf6262aeae18',NULL,NULL,NULL,NULL,'2025-12-06 10:22:56',NULL,'2025-12-06 10:22:56',NULL,NULL),(937,NULL,'083713cc3880454487a156230b40fd02',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:57',NULL,'2025-12-06 10:22:57',NULL,NULL),(938,NULL,'3a104079f023434e9e81bbb04ea01b1d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:57',NULL,'2025-12-06 10:22:57',NULL,NULL),(939,NULL,NULL,'165e7f6825c844478ef86621d4584c4d',NULL,NULL,NULL,NULL,'2025-12-06 10:22:58',NULL,'2025-12-06 10:22:58',NULL,NULL),(940,NULL,'4b53cb909ca348ccacfc19b982cb4913',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:58',NULL,'2025-12-06 10:22:58',NULL,NULL),(941,NULL,NULL,'7b2841706df44095ad14981023687871',NULL,NULL,NULL,NULL,'2025-12-06 10:22:58',NULL,'2025-12-06 10:22:58',NULL,NULL),(942,NULL,'8d19477f04ac4225a915ece395b23a79',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:22:59',NULL,'2025-12-06 10:22:59',NULL,NULL),(943,NULL,NULL,'d0a08cde4fda48429459a853fd139f8a',NULL,NULL,NULL,NULL,'2025-12-06 10:22:59',NULL,'2025-12-06 10:22:59',NULL,NULL),(944,NULL,NULL,'82f8f5222a344f16aba3e5abb2c9fe5a',NULL,NULL,NULL,NULL,'2025-12-06 10:22:59',NULL,'2025-12-06 10:22:59',NULL,NULL),(945,NULL,NULL,'94d9b8f468c54ac5b4aa0708d3aa35ae',NULL,NULL,NULL,NULL,'2025-12-06 10:22:59',NULL,'2025-12-06 10:22:59',NULL,NULL),(946,NULL,'24d6923c0e47455ca133a232d042e0fc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:00',NULL,'2025-12-06 10:23:00',NULL,NULL),(947,NULL,'dd8e1581263b41e2bc91ee613a6973f5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:00',NULL,'2025-12-06 10:23:00',NULL,NULL),(948,NULL,'e3db54722d7848c79a7f2383da5f3082',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:01',NULL,'2025-12-06 10:23:01',NULL,NULL),(949,NULL,'00d42fb3fe114975b941ad331bfb477b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:01',NULL,'2025-12-06 10:23:01',NULL,NULL),(950,NULL,NULL,'d6336e5967ac4416b0a49cf01954eeb8',NULL,NULL,NULL,NULL,'2025-12-06 10:23:03',NULL,'2025-12-06 10:23:03',NULL,NULL),(951,NULL,NULL,'78589e3ba5c749158fdfc67f76596abc',NULL,NULL,NULL,NULL,'2025-12-06 10:23:03',NULL,'2025-12-06 10:23:03',NULL,NULL),(952,NULL,'0f2f2672b2a84509a83a45a4a7831b02',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:04',NULL,'2025-12-06 10:23:04',NULL,NULL),(953,NULL,'c5fe8b5b714b4c44859bb5da85d1f140',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:05',NULL,'2025-12-06 10:23:05',NULL,NULL),(954,NULL,NULL,'a3e4c9daa401417cae05b6a4cd866474',NULL,NULL,NULL,NULL,'2025-12-06 10:23:06',NULL,'2025-12-06 10:23:06',NULL,NULL),(955,NULL,NULL,'98a4238bf9ed4fd49dc3d7c05d1794eb',NULL,NULL,NULL,NULL,'2025-12-06 10:23:07',NULL,'2025-12-06 10:23:07',NULL,NULL),(956,NULL,NULL,'ee27544002984183844d45ed4799874f',NULL,NULL,NULL,NULL,'2025-12-06 10:23:08',NULL,'2025-12-06 10:23:08',NULL,NULL),(957,NULL,NULL,'d2157887df78411c89bf01f61ee2d8dd',NULL,NULL,NULL,NULL,'2025-12-06 10:23:08',NULL,'2025-12-06 10:23:08',NULL,NULL),(958,NULL,NULL,'3664493062694229806f7a9896ba5dba',NULL,NULL,NULL,NULL,'2025-12-06 10:23:08',NULL,'2025-12-06 10:23:08',NULL,NULL),(959,NULL,NULL,'554ba216cd49415bae7adbc38382d6fc',NULL,NULL,NULL,NULL,'2025-12-06 10:23:08',NULL,'2025-12-06 10:23:08',NULL,NULL),(960,NULL,'2880304371f1414c8102fccc1bdc3029',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:08',NULL,'2025-12-06 10:23:08',NULL,NULL),(961,NULL,'487e8c66f71a4e52a6a688284a17ccf4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:09',NULL,'2025-12-06 10:23:09',NULL,NULL),(962,NULL,NULL,'384ccef963c34031960eb19869f27a13',NULL,NULL,NULL,NULL,'2025-12-06 10:23:10',NULL,'2025-12-06 10:23:10',NULL,NULL),(963,NULL,NULL,'fc3c8d0d3e1b4712b4ebee794d5c51ed',NULL,NULL,NULL,NULL,'2025-12-06 10:23:10',NULL,'2025-12-06 10:23:10',NULL,NULL),(964,NULL,NULL,'d15527bbfe3541d081546fd87b965969',NULL,NULL,NULL,NULL,'2025-12-06 10:23:10',NULL,'2025-12-06 10:23:10',NULL,NULL),(965,NULL,'534ba0a3785b4c6394c6c0ed135da2ae',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:10',NULL,'2025-12-06 10:23:10',NULL,NULL),(966,NULL,NULL,'47adc7d11f5a463eaeb60e39ef2e95a6',NULL,NULL,NULL,NULL,'2025-12-06 10:23:11',NULL,'2025-12-06 10:23:11',NULL,NULL),(967,NULL,'ee32a6e19c8d406d940d220a7bbdbbdc',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:11',NULL,'2025-12-06 10:23:11',NULL,NULL),(968,NULL,'3006b6c88845443ab13998bd660d02f7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:11',NULL,'2025-12-06 10:23:11',NULL,NULL),(969,NULL,'32c3d6224de34254bee75ac8f1ece984',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:12',NULL,'2025-12-06 10:23:12',NULL,NULL),(970,NULL,'0886aed97f774fb8b56d1d142c8fbff0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:12',NULL,'2025-12-06 10:23:12',NULL,NULL),(971,NULL,'9688bb6d8b6f4194b143273ff2df8f48',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:13',NULL,'2025-12-06 10:23:13',NULL,NULL),(972,NULL,NULL,'a4b90bda2fa345a8b8d4b043b191c4c0',NULL,NULL,NULL,NULL,'2025-12-06 10:23:15',NULL,'2025-12-06 10:23:15',NULL,NULL),(973,NULL,NULL,'03f60a9bc52b4eae9822a570dfee0686',NULL,NULL,NULL,NULL,'2025-12-06 10:23:16',NULL,'2025-12-06 10:23:16',NULL,NULL),(974,NULL,NULL,'054e7c5c284641299c5f61c39687e12d',NULL,NULL,NULL,NULL,'2025-12-06 10:23:16',NULL,'2025-12-06 10:23:16',NULL,NULL),(975,NULL,'7865e759d2fb478bb6ece9abe3d5083f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:16',NULL,'2025-12-06 10:23:16',NULL,NULL),(976,NULL,NULL,'3500db01fa824e0eade1e6e49ca8e41c',NULL,NULL,NULL,NULL,'2025-12-06 10:23:17',NULL,'2025-12-06 10:23:17',NULL,NULL),(977,NULL,NULL,'65d404ee3e0840ad8838ffebdebdf971',NULL,NULL,NULL,NULL,'2025-12-06 10:23:17',NULL,'2025-12-06 10:23:17',NULL,NULL),(978,NULL,'ba46069ea8444e4798bc8a4b160cb144',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:18',NULL,'2025-12-06 10:23:18',NULL,NULL),(979,NULL,'8f6198cb5ad546a2985c9ba3f588f5a9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:18',NULL,'2025-12-06 10:23:18',NULL,NULL),(980,NULL,NULL,'92cf70b38fc54b519ea4de3a05d3350a',NULL,NULL,NULL,NULL,'2025-12-06 10:23:18',NULL,'2025-12-06 10:23:18',NULL,NULL),(981,NULL,'95d47cf67680455aab1553dc435e37eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:19',NULL,'2025-12-06 10:23:19',NULL,NULL),(982,NULL,'3fcf0d8c55e54a8ca2b2f74100160e4c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:19',NULL,'2025-12-06 10:23:19',NULL,NULL),(983,NULL,NULL,'1653cdabeb4d4defac504fa88d0df629',NULL,NULL,NULL,NULL,'2025-12-06 10:23:22',NULL,'2025-12-06 10:23:22',NULL,NULL),(984,NULL,NULL,'8399017a26534c2d85e723325780f7fc',NULL,NULL,NULL,NULL,'2025-12-06 10:23:23',NULL,'2025-12-06 10:23:23',NULL,NULL),(985,NULL,'8168ad3d37a64ff680fd439a69736a7b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:23',NULL,'2025-12-06 10:23:23',NULL,NULL),(986,NULL,'b7f019fd77024048a2b1627f95df4eff',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:24',NULL,'2025-12-06 10:23:24',NULL,NULL),(987,NULL,NULL,'5fad49d56c6d4e7fb8d4a17b6c2562c1',NULL,NULL,NULL,NULL,'2025-12-06 10:23:25',NULL,'2025-12-06 10:23:25',NULL,NULL),(988,NULL,'0ade48b7157047d2bc354a1299624e2c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:26',NULL,'2025-12-06 10:23:26',NULL,NULL),(989,NULL,NULL,'6b9f8136acf34d49a0b31ec4659bbb92',NULL,NULL,NULL,NULL,'2025-12-06 10:23:29',NULL,'2025-12-06 10:23:29',NULL,NULL),(990,NULL,NULL,'2814f88e5cc64c07b34e30de97ae69c4',NULL,NULL,NULL,NULL,'2025-12-06 10:23:30',NULL,'2025-12-06 10:23:30',NULL,NULL),(991,NULL,NULL,'f9977c81245e4140857955966a8cb4c7',NULL,NULL,NULL,NULL,'2025-12-06 10:23:30',NULL,'2025-12-06 10:23:30',NULL,NULL),(992,NULL,NULL,'63dc152ab0d54d8a961a9d9a2e327ec2',NULL,NULL,NULL,NULL,'2025-12-06 10:23:30',NULL,'2025-12-06 10:23:30',NULL,NULL),(993,NULL,'e5b164ac927b45d4b65842ede2a39def',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:31',NULL,'2025-12-06 10:23:31',NULL,NULL),(994,NULL,'f5d8e06ed1ca4faa899da63e784fade6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:32',NULL,'2025-12-06 10:23:32',NULL,NULL),(995,NULL,'242bbb8f12664dd5bb7d98eb235ae932',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:32',NULL,'2025-12-06 10:23:32',NULL,NULL),(996,NULL,NULL,'f5728c0d8dfb4281886393be93f16d19',NULL,NULL,NULL,NULL,'2025-12-06 10:23:34',NULL,'2025-12-06 10:23:34',NULL,NULL),(997,NULL,NULL,'805403b999f44d65a2d9a5d3061ca422',NULL,NULL,NULL,NULL,'2025-12-06 10:23:35',NULL,'2025-12-06 10:23:35',NULL,NULL),(998,NULL,'b634b09905574fdcbdc5ebd9b10e60eb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:35',NULL,'2025-12-06 10:23:35',NULL,NULL),(999,NULL,NULL,'ad2d68ad3d074512b0be563db89acff0',NULL,NULL,NULL,NULL,'2025-12-06 10:23:37',NULL,'2025-12-06 10:23:37',NULL,NULL),(1000,NULL,NULL,'4467b515c7fc4de296ba6d1baa89897d',NULL,NULL,NULL,NULL,'2025-12-06 10:23:37',NULL,'2025-12-06 10:23:37',NULL,NULL),(1001,NULL,NULL,'ce2f38599f8d47bb9445ea2b878d8fd3',NULL,NULL,NULL,NULL,'2025-12-06 10:23:37',NULL,'2025-12-06 10:23:37',NULL,NULL),(1002,NULL,NULL,'523934eea22e485ead555b5c1ee83d0b',NULL,NULL,NULL,NULL,'2025-12-06 10:23:37',NULL,'2025-12-06 10:23:37',NULL,NULL),(1003,NULL,'aa930ae8716347b7ad27b88f5e5dff1f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:39',NULL,'2025-12-06 10:23:39',NULL,NULL),(1004,NULL,'2abeb06ca7b44931876415b79d9fb75a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:39',NULL,'2025-12-06 10:23:39',NULL,NULL),(1005,NULL,'70f435eabdfe445ab287f469849a5cad',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:39',NULL,'2025-12-06 10:23:39',NULL,NULL),(1006,NULL,'e2b088aa0aa04fe8a692c8ef32041e76',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:40',NULL,'2025-12-06 10:23:40',NULL,NULL),(1007,NULL,NULL,'97bd0b2f3d3d444f8c588efc9f1c7bd0',NULL,NULL,NULL,NULL,'2025-12-06 10:23:42',NULL,'2025-12-06 10:23:42',NULL,NULL),(1008,NULL,NULL,'63a2ab7311cc44eb9609aa12d2181ca5',NULL,NULL,NULL,NULL,'2025-12-06 10:23:42',NULL,'2025-12-06 10:23:42',NULL,NULL),(1009,NULL,NULL,'24430961e75b499c8132e916070db917',NULL,NULL,NULL,NULL,'2025-12-06 10:23:42',NULL,'2025-12-06 10:23:42',NULL,NULL),(1010,NULL,'5056d3cba6414807be278430a0762ee8',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:43',NULL,'2025-12-06 10:23:43',NULL,NULL),(1011,NULL,'c83cf8cf17554ef78c82738ac22165fa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:44',NULL,'2025-12-06 10:23:44',NULL,NULL),(1012,NULL,'d24493871c774c9fb492b7416ca93292',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:23:45',NULL,'2025-12-06 10:23:45',NULL,NULL),(1013,NULL,NULL,'ba30359af5c949eb85d2462e256afb2a',NULL,NULL,NULL,NULL,'2025-12-06 10:24:07',NULL,'2025-12-06 10:24:07',NULL,NULL),(1014,NULL,'8321907d0a38406c8e7c51f32ab796ad',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:08',NULL,'2025-12-06 10:24:08',NULL,NULL),(1015,NULL,NULL,'e4ea16c85bcc420392d966bc2f001858',NULL,NULL,NULL,NULL,'2025-12-06 10:24:10',NULL,'2025-12-06 10:24:10',NULL,NULL),(1016,NULL,NULL,'b81df451c358421e9fa2d40211e97c3d',NULL,NULL,NULL,NULL,'2025-12-06 10:24:11',NULL,'2025-12-06 10:24:11',NULL,NULL),(1017,NULL,NULL,'27c84077ffd54c46ae679867b185acda',NULL,NULL,NULL,NULL,'2025-12-06 10:24:11',NULL,'2025-12-06 10:24:11',NULL,NULL),(1018,NULL,NULL,'b70fd3da4ef648728fdf77feff51327f',NULL,NULL,NULL,NULL,'2025-12-06 10:24:11',NULL,'2025-12-06 10:24:11',NULL,NULL),(1019,NULL,NULL,'a3be16a8723d4b3cb871d03be4fae852',NULL,NULL,NULL,NULL,'2025-12-06 10:24:12',NULL,'2025-12-06 10:24:12',NULL,NULL),(1020,NULL,'f29f3a0980a345ba939f8e50f619841d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:13',NULL,'2025-12-06 10:24:13',NULL,NULL),(1021,NULL,'5914faf90fd14171adeb0a62b64d0b11',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:14',NULL,'2025-12-06 10:24:14',NULL,NULL),(1022,NULL,'6ced0b7d43b7479fa40fde81f7a9c080',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:15',NULL,'2025-12-06 10:24:15',NULL,NULL),(1023,NULL,NULL,'8c95b67d83b947d78dd96e1b4cce7a0e',NULL,NULL,NULL,NULL,'2025-12-06 10:24:17',NULL,'2025-12-06 10:24:17',NULL,NULL),(1024,NULL,NULL,'fe9feb56e87d4a3ca2528124d4b78d18',NULL,NULL,NULL,NULL,'2025-12-06 10:24:17',NULL,'2025-12-06 10:24:17',NULL,NULL),(1025,NULL,NULL,'0fbddb9f8bb54945b51e4653e6f4ddc7',NULL,NULL,NULL,NULL,'2025-12-06 10:24:17',NULL,'2025-12-06 10:24:17',NULL,NULL),(1026,NULL,NULL,'7d310253e9654810a87bd02c3b28f29f',NULL,NULL,NULL,NULL,'2025-12-06 10:24:17',NULL,'2025-12-06 10:24:17',NULL,NULL),(1027,NULL,'a860f91f361042a2b13934bff381f266',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:19',NULL,'2025-12-06 10:24:19',NULL,NULL),(1028,NULL,'48f345c666834404a4e8047095cdae24',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:19',NULL,'2025-12-06 10:24:19',NULL,NULL),(1029,NULL,'59affa10a0094cefb6a7c233728f9e68',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:20',NULL,'2025-12-06 10:24:20',NULL,NULL),(1030,NULL,'ff35cc04346b44cfaf4525680bd7cd12',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:20',NULL,'2025-12-06 10:24:20',NULL,NULL),(1031,NULL,NULL,'529ac784476a4c03a06857c35c9f38a3',NULL,NULL,NULL,NULL,'2025-12-06 10:24:33',NULL,'2025-12-06 10:24:33',NULL,NULL),(1032,NULL,'0e98feac0e5947229c2baa6fc34be5fb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:33',NULL,'2025-12-06 10:24:33',NULL,NULL),(1033,NULL,NULL,'2e821100b94443559eb555b391eef104',NULL,NULL,NULL,NULL,'2025-12-06 10:24:35',NULL,'2025-12-06 10:24:35',NULL,NULL),(1034,NULL,'b4a5504da73944ff953a9c5c2851c39c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:37',NULL,'2025-12-06 10:24:37',NULL,NULL),(1035,NULL,NULL,'27e19e7700664d06bda6ca97c9f76ded',NULL,NULL,NULL,NULL,'2025-12-06 10:24:39',NULL,'2025-12-06 10:24:39',NULL,NULL),(1036,NULL,'81f610f1bd1240099ddb8f0bb3dc395b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:40',NULL,'2025-12-06 10:24:40',NULL,NULL),(1037,NULL,NULL,'587ff6dd2c9445b2a0d1819832a7bb59',NULL,NULL,NULL,NULL,'2025-12-06 10:24:48',NULL,'2025-12-06 10:24:48',NULL,NULL),(1038,NULL,NULL,'2970cfbdbd7745dda2ed647cc0f08cd0',NULL,NULL,NULL,NULL,'2025-12-06 10:24:52',NULL,'2025-12-06 10:24:52',NULL,NULL),(1039,NULL,NULL,'1c7170331864480f917210b8723cf069',NULL,NULL,NULL,NULL,'2025-12-06 10:24:52',NULL,'2025-12-06 10:24:52',NULL,NULL),(1040,NULL,NULL,'c25f4de05ecd4014bc58031d0e9bfaf8',NULL,NULL,NULL,NULL,'2025-12-06 10:24:52',NULL,'2025-12-06 10:24:52',NULL,NULL),(1041,NULL,'bccda81fdd6247d7bc0bc19a42042aba',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:54',NULL,'2025-12-06 10:24:54',NULL,NULL),(1042,NULL,'ed42f6da342f4f1c80ef0f22b7955a47',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:55',NULL,'2025-12-06 10:24:55',NULL,NULL),(1043,NULL,'2d1ba63cea944088a5a3025a5034ba6c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:24:56',NULL,'2025-12-06 10:24:56',NULL,NULL),(1044,NULL,NULL,'3417fea9a7cf46a4a8d1be72c364db63',NULL,NULL,NULL,NULL,'2025-12-06 10:25:15',NULL,'2025-12-06 10:25:15',NULL,NULL),(1045,NULL,NULL,'58fc51cd55374a6f9aca770f673e918e',NULL,NULL,NULL,NULL,'2025-12-06 10:25:28',NULL,'2025-12-06 10:25:28',NULL,NULL),(1046,NULL,NULL,'5a77fc22a9f24b66860230c054bd00fa',NULL,NULL,NULL,NULL,'2025-12-06 10:25:28',NULL,'2025-12-06 10:25:28',NULL,NULL),(1047,NULL,NULL,'5c461f2bfa82459494e31a454d1cf0a6',NULL,NULL,NULL,NULL,'2025-12-06 10:25:28',NULL,'2025-12-06 10:25:28',NULL,NULL),(1048,NULL,'eb9c262cf0424f86ae2b0f6d38679b33',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:30',NULL,'2025-12-06 10:25:30',NULL,NULL),(1049,NULL,'14fcd30962314973b2c11b49f89b4cb4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:31',NULL,'2025-12-06 10:25:31',NULL,NULL),(1050,NULL,'438e893229f742e78fe8e62ef6ea17d5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:32',NULL,'2025-12-06 10:25:32',NULL,NULL),(1051,NULL,NULL,'b40d497af0834616a664e6909c0f6685',NULL,NULL,NULL,NULL,'2025-12-06 10:25:32',NULL,'2025-12-06 10:25:32',NULL,NULL),(1052,NULL,'b51f704fe6204487b0317c3332364cca',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:32',NULL,'2025-12-06 10:25:32',NULL,NULL),(1053,NULL,NULL,'a6d62e9381984680b8feaf471728ad16',NULL,NULL,NULL,NULL,'2025-12-06 10:25:34',NULL,'2025-12-06 10:25:34',NULL,NULL),(1054,NULL,'674b1770f1a44f0c83fe1e0bf22a570c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:35',NULL,'2025-12-06 10:25:35',NULL,NULL),(1055,NULL,NULL,'c61b698f36a64d2ea2add5441f5038b8',NULL,NULL,NULL,NULL,'2025-12-06 10:25:36',NULL,'2025-12-06 10:25:36',NULL,NULL),(1056,NULL,NULL,'c344b70d656343368e413054f302e6c1',NULL,NULL,NULL,NULL,'2025-12-06 10:25:36',NULL,'2025-12-06 10:25:36',NULL,NULL),(1057,NULL,NULL,'d83535ce83834b07b409cfac5588c89e',NULL,NULL,NULL,NULL,'2025-12-06 10:25:37',NULL,'2025-12-06 10:25:37',NULL,NULL),(1058,NULL,NULL,'3ee5ef1cb254411493554d56b8f03d09',NULL,NULL,NULL,NULL,'2025-12-06 10:25:37',NULL,'2025-12-06 10:25:37',NULL,NULL),(1059,NULL,NULL,'ccc03c3ca0d443d1a76410589d398307',NULL,NULL,NULL,NULL,'2025-12-06 10:25:37',NULL,'2025-12-06 10:25:37',NULL,NULL),(1060,NULL,'4a36146f4e144bfba426c3f231f70e43',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:38',NULL,'2025-12-06 10:25:38',NULL,NULL),(1061,NULL,'01a8be0484224196af5b9c855b1a393a',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:38',NULL,'2025-12-06 10:25:38',NULL,NULL),(1062,NULL,'8a822d07fb94416c87a2ea75a66d9344',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:39',NULL,'2025-12-06 10:25:39',NULL,NULL),(1063,NULL,'8d8bf1c721f0425eb169706adab54fb1',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:39',NULL,'2025-12-06 10:25:39',NULL,NULL),(1064,NULL,NULL,'394b18c09df14948a6365e779e7dca24',NULL,NULL,NULL,NULL,'2025-12-06 10:25:41',NULL,'2025-12-06 10:25:41',NULL,NULL),(1065,NULL,'22e4c98ea8954e978be825b3ab0d2398',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:42',NULL,'2025-12-06 10:25:42',NULL,NULL),(1066,NULL,NULL,'b3538a030be8444a9387062f6e37a8be',NULL,NULL,NULL,NULL,'2025-12-06 10:25:44',NULL,'2025-12-06 10:25:44',NULL,NULL),(1067,NULL,NULL,'667d9337426448799e2a5d60da4a2ee0',NULL,NULL,NULL,NULL,'2025-12-06 10:25:45',NULL,'2025-12-06 10:25:45',NULL,NULL),(1068,NULL,NULL,'f15d33a7b7844bc5998625dca8cc4248',NULL,NULL,NULL,NULL,'2025-12-06 10:25:45',NULL,'2025-12-06 10:25:45',NULL,NULL),(1069,NULL,NULL,'0914fd74b28d42f9877f77e93326fca4',NULL,NULL,NULL,NULL,'2025-12-06 10:25:45',NULL,'2025-12-06 10:25:45',NULL,NULL),(1070,NULL,NULL,'92598870d7ae4d9d9212196474c16ecd',NULL,NULL,NULL,NULL,'2025-12-06 10:25:46',NULL,'2025-12-06 10:25:46',NULL,NULL),(1071,NULL,'58338e183cca4ae085512d7fb0228951',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:46',NULL,'2025-12-06 10:25:46',NULL,NULL),(1072,NULL,'5a074a781731434ab6188e5e567d0116',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:47',NULL,'2025-12-06 10:25:47',NULL,NULL),(1073,NULL,'bccedbe520d34898aad89e97c5258b2b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:47',NULL,'2025-12-06 10:25:47',NULL,NULL),(1074,NULL,'91f7b86fa1044a16930bbe4d1efb3c86',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:48',NULL,'2025-12-06 10:25:48',NULL,NULL),(1075,NULL,NULL,'aaccee7342af4550b1754838d99354be',NULL,NULL,NULL,NULL,'2025-12-06 10:25:49',NULL,'2025-12-06 10:25:49',NULL,NULL),(1076,NULL,'b617eae13ecd4396b8e75b8057e20e14',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:51',NULL,'2025-12-06 10:25:51',NULL,NULL),(1077,NULL,NULL,'b841fc79191d42939335cc035fdd7cb7',NULL,NULL,NULL,NULL,'2025-12-06 10:25:55',NULL,'2025-12-06 10:25:55',NULL,NULL),(1078,NULL,NULL,'baa2031d15144fd08c0077ef0c165e0f',NULL,NULL,NULL,NULL,'2025-12-06 10:25:55',NULL,'2025-12-06 10:25:55',NULL,NULL),(1079,NULL,NULL,'fa33affef9e340a9b4f7a9bfd35a2dc9',NULL,NULL,NULL,NULL,'2025-12-06 10:25:55',NULL,'2025-12-06 10:25:55',NULL,NULL),(1080,NULL,NULL,'7d61ed94d546440bb4e36fd0a1de3920',NULL,NULL,NULL,NULL,'2025-12-06 10:25:56',NULL,'2025-12-06 10:25:56',NULL,NULL),(1081,NULL,'f7fba26846c34da1950e074a4b48d820',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:57',NULL,'2025-12-06 10:25:57',NULL,NULL),(1082,NULL,NULL,'71e0ae48c72840f2aeb2321ecc82b7ce',NULL,NULL,NULL,NULL,'2025-12-06 10:25:57',NULL,'2025-12-06 10:25:57',NULL,NULL),(1083,NULL,'8a003176cb034a6587302dd88099bab5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:57',NULL,'2025-12-06 10:25:57',NULL,NULL),(1084,NULL,'612b3a88a6734a8ca75d6487b5c72e99',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:25:58',NULL,'2025-12-06 10:25:58',NULL,NULL),(1085,NULL,NULL,'9f9e5d659e484079b029bd41bb7f8811',NULL,NULL,NULL,NULL,'2025-12-06 10:25:58',NULL,'2025-12-06 10:25:58',NULL,NULL),(1086,NULL,NULL,'38c53940388644ec97ee14b96e10f388',NULL,NULL,NULL,NULL,'2025-12-06 10:25:59',NULL,'2025-12-06 10:25:59',NULL,NULL),(1087,NULL,NULL,'12e43dd898c34749abf5f6192f272eea',NULL,NULL,NULL,NULL,'2025-12-06 10:25:59',NULL,'2025-12-06 10:25:59',NULL,NULL),(1088,NULL,'f44e58d5375a4b34a9625323d09c15b3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:00',NULL,'2025-12-06 10:26:00',NULL,NULL),(1089,NULL,'aa2d4195c29d4f4c8184cb1d4ef83f30',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:00',NULL,'2025-12-06 10:26:00',NULL,NULL),(1090,NULL,'fbfe636f949d4c9fa611fb1d26764bd2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:01',NULL,'2025-12-06 10:26:01',NULL,NULL),(1091,NULL,NULL,'9e1d63f6e00d4cb58bf5cc0b2ec713cc',NULL,NULL,NULL,NULL,'2025-12-06 10:26:02',NULL,'2025-12-06 10:26:02',NULL,NULL),(1092,NULL,NULL,'3a7c1829dee74bcaa01c628d9c15cb47',NULL,NULL,NULL,NULL,'2025-12-06 10:26:06',NULL,'2025-12-06 10:26:06',NULL,NULL),(1093,NULL,NULL,'6fc7725d97434199976428d67d2b42da',NULL,NULL,NULL,NULL,'2025-12-06 10:26:06',NULL,'2025-12-06 10:26:06',NULL,NULL),(1094,NULL,NULL,'b330a68d4a3243cc9c5fb536ab668f60',NULL,NULL,NULL,NULL,'2025-12-06 10:26:07',NULL,'2025-12-06 10:26:07',NULL,NULL),(1095,NULL,NULL,'751933dd4ea942f6a6f3bd50f5e4f010',NULL,NULL,NULL,NULL,'2025-12-06 10:26:07',NULL,'2025-12-06 10:26:07',NULL,NULL),(1096,NULL,NULL,'035c1a3dca934aef9f9f32cc4698159d',NULL,NULL,NULL,NULL,'2025-12-06 10:26:07',NULL,'2025-12-06 10:26:07',NULL,NULL),(1097,NULL,'cfab9f6ecb0942eb87922e66a206941b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:07',NULL,'2025-12-06 10:26:07',NULL,NULL),(1098,NULL,'d9cecec8f18f4319914ecb23a26e44f7',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:08',NULL,'2025-12-06 10:26:08',NULL,NULL),(1099,NULL,'f298bea74b2e4b57a0b66656896bc118',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:09',NULL,'2025-12-06 10:26:09',NULL,NULL),(1100,NULL,'0041391a20bc408fbd093a1759f3f9d4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:10',NULL,'2025-12-06 10:26:10',NULL,NULL),(1101,NULL,NULL,'b77a5a39381a4887b01678d32ba0ce10',NULL,NULL,NULL,NULL,'2025-12-06 10:26:12',NULL,'2025-12-06 10:26:12',NULL,NULL),(1102,NULL,NULL,'6323f58563b24a3f92c148add19094dd',NULL,NULL,NULL,NULL,'2025-12-06 10:26:13',NULL,'2025-12-06 10:26:13',NULL,NULL),(1103,NULL,NULL,'880469815a2f4b0a98d15748fa8ed589',NULL,NULL,NULL,NULL,'2025-12-06 10:26:13',NULL,'2025-12-06 10:26:13',NULL,NULL),(1104,NULL,NULL,'3e3a2f12e9f74c18b91c9537fe5133ce',NULL,NULL,NULL,NULL,'2025-12-06 10:26:14',NULL,'2025-12-06 10:26:14',NULL,NULL),(1105,NULL,'624d214a9b4c48cfbd1c047433c17c31',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:14',NULL,'2025-12-06 10:26:14',NULL,NULL),(1106,NULL,NULL,'61c21a4263824119a843a50317c4c171',NULL,NULL,NULL,NULL,'2025-12-06 10:26:14',NULL,'2025-12-06 10:26:14',NULL,NULL),(1107,NULL,NULL,'840ae9b76ac645528f6ee395b7442d49',NULL,NULL,NULL,NULL,'2025-12-06 10:26:15',NULL,'2025-12-06 10:26:15',NULL,NULL),(1108,NULL,'ff987c8e2b864ccdaa08ed3f21e55119',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:15',NULL,'2025-12-06 10:26:15',NULL,NULL),(1109,NULL,NULL,'be024cf11dad4978a6fe7305df794c54',NULL,NULL,NULL,NULL,'2025-12-06 10:26:15',NULL,'2025-12-06 10:26:15',NULL,NULL),(1110,NULL,NULL,'138be3b44cbf4d63b33fc1290da70b9d',NULL,NULL,NULL,NULL,'2025-12-06 10:26:15',NULL,'2025-12-06 10:26:15',NULL,NULL),(1111,NULL,'ae047d67660940bdad2b998653a87d40',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:15',NULL,'2025-12-06 10:26:15',NULL,NULL),(1112,NULL,'597416732a214f16b963a9e4c4769751',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:16',NULL,'2025-12-06 10:26:16',NULL,NULL),(1113,NULL,'e6013a40d43e41029b86132323b4a9ef',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:16',NULL,'2025-12-06 10:26:16',NULL,NULL),(1114,NULL,'4f1f5483827f4daa9804cdd5878693f5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:17',NULL,'2025-12-06 10:26:17',NULL,NULL),(1115,NULL,'780455f83f3f4806b4f2d9411937358d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:18',NULL,'2025-12-06 10:26:18',NULL,NULL),(1116,NULL,NULL,'1644a11ae40c48b1b47670cc152a36e7',NULL,NULL,NULL,NULL,'2025-12-06 10:26:18',NULL,'2025-12-06 10:26:18',NULL,NULL),(1117,NULL,NULL,'078b78846f2d4a30aeea50a4f1dcb176',NULL,NULL,NULL,NULL,'2025-12-06 10:26:18',NULL,'2025-12-06 10:26:18',NULL,NULL),(1118,NULL,'765e34e6566e45d58bea4500d56dbeef',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:19',NULL,'2025-12-06 10:26:19',NULL,NULL),(1119,NULL,NULL,'c7ecae2be99f4a189294087144e67380',NULL,NULL,NULL,NULL,'2025-12-06 10:26:23',NULL,'2025-12-06 10:26:23',NULL,NULL),(1120,NULL,'e741197adc3347b49d3373ac1543d6aa',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:25',NULL,'2025-12-06 10:26:25',NULL,NULL),(1121,NULL,NULL,'de610ccf2ab343a3a1db4928a3b456ee',NULL,NULL,NULL,NULL,'2025-12-06 10:26:32',NULL,'2025-12-06 10:26:32',NULL,NULL),(1122,NULL,NULL,'6f56dd06566e45309c8b26ab41e61c32',NULL,NULL,NULL,NULL,'2025-12-06 10:26:32',NULL,'2025-12-06 10:26:32',NULL,NULL),(1123,NULL,NULL,'429966cc48784db1ab616bda48c4e93f',NULL,NULL,NULL,NULL,'2025-12-06 10:26:32',NULL,'2025-12-06 10:26:32',NULL,NULL),(1124,NULL,'32020096223440be841b25fab4efec5d',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:34',NULL,'2025-12-06 10:26:34',NULL,NULL),(1125,NULL,'7223c83474f9484da8938102453548f3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:34',NULL,'2025-12-06 10:26:34',NULL,NULL),(1126,NULL,'78b260c5e2fa4b149862a3b0de1864dd',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:35',NULL,'2025-12-06 10:26:35',NULL,NULL),(1127,NULL,NULL,'fc98c2adcd214f4fae833a3f802bdb73',NULL,NULL,NULL,NULL,'2025-12-06 10:26:39',NULL,'2025-12-06 10:26:39',NULL,NULL),(1128,NULL,NULL,'7bb1773e5e9f468cad38d578672ebe7a',NULL,NULL,NULL,NULL,'2025-12-06 10:26:42',NULL,'2025-12-06 10:26:42',NULL,NULL),(1129,NULL,NULL,'450b5882f2354f1cab3b15197e20abbd',NULL,NULL,NULL,NULL,'2025-12-06 10:26:42',NULL,'2025-12-06 10:26:42',NULL,NULL),(1130,NULL,'0680825af8a248e9b1a46d099dbba654',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:43',NULL,'2025-12-06 10:26:43',NULL,NULL),(1131,NULL,NULL,'5ca728d6529f46e8b51f583ca022b800',NULL,NULL,NULL,NULL,'2025-12-06 10:26:43',NULL,'2025-12-06 10:26:43',NULL,NULL),(1132,NULL,NULL,'1dd4883165b549c784866d63d707d165',NULL,NULL,NULL,NULL,'2025-12-06 10:26:43',NULL,'2025-12-06 10:26:43',NULL,NULL),(1133,NULL,NULL,'45faa6a8113543078a5521198e01d9b5',NULL,NULL,NULL,NULL,'2025-12-06 10:26:43',NULL,'2025-12-06 10:26:43',NULL,NULL),(1134,NULL,'3342399b00ae40b48123295a9604de67',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:43',NULL,'2025-12-06 10:26:43',NULL,NULL),(1135,NULL,'d94ef965830c40a881a8674388fed9ec',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:45',NULL,'2025-12-06 10:26:45',NULL,NULL),(1136,NULL,'e0991b50d433489b9122b5c71fdb2883',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:46',NULL,'2025-12-06 10:26:46',NULL,NULL),(1137,NULL,'0aadcb434c154937a579c4dc18227ed4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:47',NULL,'2025-12-06 10:26:47',NULL,NULL),(1138,NULL,NULL,'89cc172d8f004059a9be3169236e18f9',NULL,NULL,NULL,NULL,'2025-12-06 10:26:47',NULL,'2025-12-06 10:26:47',NULL,NULL),(1139,NULL,NULL,'9226aceb2a1c4494915c01b3efb6fff5',NULL,NULL,NULL,NULL,'2025-12-06 10:26:49',NULL,'2025-12-06 10:26:49',NULL,NULL),(1140,NULL,'6f2e188b70a54bc29e92db291c7a13de',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:50',NULL,'2025-12-06 10:26:50',NULL,NULL),(1141,NULL,NULL,'ceb5ef54b11b4bff9d01ed1759edadee',NULL,NULL,NULL,NULL,'2025-12-06 10:26:52',NULL,'2025-12-06 10:26:52',NULL,NULL),(1142,NULL,'e7316df1eeb347dba5c463b6fe7e0b7c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:53',NULL,'2025-12-06 10:26:53',NULL,NULL),(1143,NULL,NULL,'f8b11dcaa4514416a8807183407a59b8',NULL,NULL,NULL,NULL,'2025-12-06 10:26:54',NULL,'2025-12-06 10:26:54',NULL,NULL),(1144,NULL,NULL,'370aba0d971a45b8abdac88f0022789d',NULL,NULL,NULL,NULL,'2025-12-06 10:26:54',NULL,'2025-12-06 10:26:54',NULL,NULL),(1145,NULL,NULL,'86ab6b0f64754d47a4d3f529f89d5de8',NULL,NULL,NULL,NULL,'2025-12-06 10:26:54',NULL,'2025-12-06 10:26:54',NULL,NULL),(1146,NULL,'029d2b4bb4d14fb381be08081c03995f',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:55',NULL,'2025-12-06 10:26:55',NULL,NULL),(1147,NULL,'31903d59544d41839f04a80bef220b94',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:56',NULL,'2025-12-06 10:26:56',NULL,NULL),(1148,NULL,'ab2d51cab3324185a3fc0ee3f863253b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:26:57',NULL,'2025-12-06 10:26:57',NULL,NULL),(1149,NULL,NULL,'041e62802a144408947150374fcbb021',NULL,NULL,NULL,NULL,'2025-12-06 10:27:18',NULL,'2025-12-06 10:27:18',NULL,NULL),(1150,NULL,NULL,'0662543ae30b4000b9078e91a6142770',NULL,NULL,NULL,NULL,'2025-12-06 10:27:19',NULL,'2025-12-06 10:27:19',NULL,NULL),(1151,NULL,NULL,'d025a6457f054c228439c73fc7d44ca8',NULL,NULL,NULL,NULL,'2025-12-06 10:27:19',NULL,'2025-12-06 10:27:19',NULL,NULL),(1152,NULL,NULL,'56a13b1a872444f1b6bded2d3982f5db',NULL,NULL,NULL,NULL,'2025-12-06 10:27:19',NULL,'2025-12-06 10:27:19',NULL,NULL),(1153,NULL,'df9c21a2dd5547ff8d499f2096a95677',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:20',NULL,'2025-12-06 10:27:20',NULL,NULL),(1154,NULL,'533cded34fff443982807cbe5efb88ee',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:21',NULL,'2025-12-06 10:27:21',NULL,NULL),(1155,NULL,'5965f7cc0f9b47f4a2901af990e670b4',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:22',NULL,'2025-12-06 10:27:22',NULL,NULL),(1156,NULL,NULL,'eea480481a9d4d95b03cc93b713e4682',NULL,NULL,NULL,NULL,'2025-12-06 10:27:22',NULL,'2025-12-06 10:27:22',NULL,NULL),(1157,NULL,NULL,'0f53e8d43faa41619104a62141238710',NULL,NULL,NULL,NULL,'2025-12-06 10:27:28',NULL,'2025-12-06 10:27:28',NULL,NULL),(1158,NULL,NULL,'fa99e615163e483d853b5e0dc9bbf002',NULL,NULL,NULL,NULL,'2025-12-06 10:27:28',NULL,'2025-12-06 10:27:28',NULL,NULL),(1159,NULL,NULL,'7e43288d50e64c44897d0234913de7ac',NULL,NULL,NULL,NULL,'2025-12-06 10:27:29',NULL,'2025-12-06 10:27:29',NULL,NULL),(1160,NULL,'a301ad0ca4e9440c854fb855c09357fb',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:31',NULL,'2025-12-06 10:27:31',NULL,NULL),(1161,NULL,'29b7fcfbecd9491eb79bd53cef7c0fc3',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:31',NULL,'2025-12-06 10:27:31',NULL,NULL),(1162,NULL,'cfb6a54e54a8451c8f51c2d7067d6155',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:27:32',NULL,'2025-12-06 10:27:32',NULL,NULL),(1163,NULL,NULL,'2957468dffca482697e1fd0d1c8ad85f',NULL,NULL,NULL,NULL,'2025-12-06 10:28:27',NULL,'2025-12-06 10:28:27',NULL,NULL),(1164,NULL,NULL,'6ba9651cf75f47eeb4d3acac13f5e612',NULL,NULL,NULL,NULL,'2025-12-06 10:28:27',NULL,'2025-12-06 10:28:27',NULL,NULL),(1165,NULL,NULL,'2b4d5b0fd17445b58e52baf66c4955ef',NULL,NULL,NULL,NULL,'2025-12-06 10:28:31',NULL,'2025-12-06 10:28:31',NULL,NULL),(1166,NULL,NULL,'bd51725cea7546cb9abde5118788de23',NULL,NULL,NULL,NULL,'2025-12-06 10:28:31',NULL,'2025-12-06 10:28:31',NULL,NULL),(1167,NULL,NULL,'41ebace8a49648d9bcaca2928ea07a0d',NULL,NULL,NULL,NULL,'2025-12-06 10:28:31',NULL,'2025-12-06 10:28:31',NULL,NULL),(1168,NULL,'03091ccf0b5546848dbe895affa06e82',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:28:32',NULL,'2025-12-06 10:28:32',NULL,NULL),(1169,NULL,'407388521bb04f21b3ced239438a361c',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:28:33',NULL,'2025-12-06 10:28:33',NULL,NULL),(1170,NULL,'7edc1938aa7d4901b62556ce15cb89f6',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:28:34',NULL,'2025-12-06 10:28:34',NULL,NULL),(1171,NULL,NULL,'5a6f42071c1145dfbbb90d24fa58dae0',NULL,NULL,NULL,NULL,'2025-12-06 10:28:52',NULL,'2025-12-06 10:28:52',NULL,NULL),(1172,NULL,'0130cf6296f34bac9ca26d4953c9e4d0',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:28:53',NULL,'2025-12-06 10:28:53',NULL,NULL),(1173,NULL,NULL,'4640cc805796419f9989edeeea6e3640',NULL,NULL,NULL,NULL,'2025-12-06 10:29:32',NULL,'2025-12-06 10:29:32',NULL,NULL),(1174,NULL,NULL,'0b08b9bfa12a45ca9b27018023d40949',NULL,NULL,NULL,NULL,'2025-12-06 10:29:32',NULL,'2025-12-06 10:29:32',NULL,NULL),(1175,NULL,NULL,'9106f9610df246458272a7586c704608',NULL,NULL,NULL,NULL,'2025-12-06 10:29:38',NULL,'2025-12-06 10:29:38',NULL,NULL),(1176,NULL,NULL,'25273911e9e34a2bbe0bdec12aab6088',NULL,NULL,NULL,NULL,'2025-12-06 10:29:39',NULL,'2025-12-06 10:29:39',NULL,NULL),(1177,NULL,NULL,'1678ab0d3aee48bd81909059625b46ed',NULL,NULL,NULL,NULL,'2025-12-06 10:29:39',NULL,'2025-12-06 10:29:39',NULL,NULL),(1178,NULL,'8223febae67d4b58a139c7a23382ebf9',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:40',NULL,'2025-12-06 10:29:40',NULL,NULL),(1179,NULL,'6d03a05cc5b84b5a8ad8984564f33882',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:41',NULL,'2025-12-06 10:29:41',NULL,NULL),(1180,NULL,'da1f8eccae394e4fa998641ffff12c88',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:42',NULL,'2025-12-06 10:29:42',NULL,NULL),(1181,NULL,NULL,'28d38dca519647c79ac1cf49438074f7',NULL,NULL,NULL,NULL,'2025-12-06 10:29:44',NULL,'2025-12-06 10:29:44',NULL,NULL),(1182,NULL,'f3491ae41aa34599a633235bfd460208',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:45',NULL,'2025-12-06 10:29:45',NULL,NULL),(1183,NULL,NULL,'d0dbb7dc3ac5436d8ce16f6289475805',NULL,NULL,NULL,NULL,'2025-12-06 10:29:50',NULL,'2025-12-06 10:29:50',NULL,NULL),(1184,NULL,NULL,'c3e7672ee4474f149391e714436df320',NULL,NULL,NULL,NULL,'2025-12-06 10:29:50',NULL,'2025-12-06 10:29:50',NULL,NULL),(1185,NULL,NULL,'2cd3f9dbe6754e8caaf3769df2ff046b',NULL,NULL,NULL,NULL,'2025-12-06 10:29:50',NULL,'2025-12-06 10:29:50',NULL,NULL),(1186,NULL,NULL,'01e7c9b3f67544cc85a4285c497927af',NULL,NULL,NULL,NULL,'2025-12-06 10:29:50',NULL,'2025-12-06 10:29:50',NULL,NULL),(1187,NULL,'c38315d1a2f7451283e39aa0bf6b8e45',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:51',NULL,'2025-12-06 10:29:51',NULL,NULL),(1188,NULL,'dab43131c7894a54b57bc7dfa17e277b',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:52',NULL,'2025-12-06 10:29:52',NULL,NULL),(1189,NULL,'f3aa4abb280d4f8d8557050839f299a5',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:29:53',NULL,'2025-12-06 10:29:53',NULL,NULL),(1190,NULL,NULL,'73642f50aeba4819bc920a6ba10bc246',NULL,NULL,NULL,NULL,'2025-12-06 10:30:05',NULL,'2025-12-06 10:30:05',NULL,NULL),(1191,NULL,NULL,'1cb2c497776e49bf8bc79ad120335fa3',NULL,NULL,NULL,NULL,'2025-12-06 10:30:11',NULL,'2025-12-06 10:30:11',NULL,NULL),(1192,NULL,NULL,'0d6b4577de91435b81bc8b1f76728021',NULL,NULL,NULL,NULL,'2025-12-06 10:30:12',NULL,'2025-12-06 10:30:12',NULL,NULL),(1193,NULL,NULL,'5ca3872664cc430c86aed9fd75533a16',NULL,NULL,NULL,NULL,'2025-12-06 10:30:12',NULL,'2025-12-06 10:30:12',NULL,NULL),(1194,NULL,'239678b35fcf49e4ae923494b68dbb72',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:30:13',NULL,'2025-12-06 10:30:13',NULL,NULL),(1195,NULL,'9d394c7b90e54d78902b10615bdcd254',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:30:15',NULL,'2025-12-06 10:30:15',NULL,NULL),(1196,NULL,'bd1e9bcd5dad42cb9d7b33ba0090bc19',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:30:16',NULL,'2025-12-06 10:30:16',NULL,NULL),(1197,NULL,NULL,'b7ac149ac1f442148f82e753ace3b96e',NULL,NULL,NULL,NULL,'2025-12-06 10:31:00',NULL,'2025-12-06 10:31:00',NULL,NULL),(1198,NULL,NULL,'1696f5d56fb3479e8531a875f16c7f43',NULL,NULL,NULL,NULL,'2025-12-06 10:31:00',NULL,'2025-12-06 10:31:00',NULL,NULL),(1199,NULL,'7d2c3fc1d605488db2b4af2af7696c67',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:31:00',NULL,'2025-12-06 10:31:00',NULL,NULL),(1200,NULL,'8f629f53128e4fc5819c111669f728b2',NULL,NULL,NULL,NULL,NULL,'2025-12-06 10:31:01',NULL,'2025-12-06 10:31:01',NULL,NULL);
/*!40000 ALTER TABLE `revocation_event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `extra` text DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL DEFAULT '<<null>>',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_role_name_domain_id` (`name`,`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role`
--

LOCK TABLES `role` WRITE;
/*!40000 ALTER TABLE `role` DISABLE KEYS */;
INSERT INTO `role` (`id`, `name`, `extra`, `domain_id`, `description`) VALUES ('21df11cce40840a981926a82775f359c','admin','{}','<<null>>',NULL),('510ee393b0524f50b7c196d7e67d09ee','reader','{}','<<null>>',NULL),('620b1400081c464197069ecee5a56c86','service','{}','<<null>>',NULL),('74aa199d350948be91c80f156ffa4500','swiftoperator','{}','<<null>>',NULL),('ac1c8ab1f8a24756a43883309bb56ede','ResellerAdmin','{}','<<null>>',NULL),('b08fc5d5f2f34c64ba1e744bee6d0fc8','heat_stack_user','{}','<<null>>',NULL),('c8d64f613d26423e8c2e24c515ca9252','member','{}','<<null>>',NULL);
/*!40000 ALTER TABLE `role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_option`
--

DROP TABLE IF EXISTS `role_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_option` (
  `role_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`role_id`,`option_id`),
  CONSTRAINT `role_option_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_option`
--

LOCK TABLES `role_option` WRITE;
/*!40000 ALTER TABLE `role_option` DISABLE KEYS */;
INSERT INTO `role_option` (`role_id`, `option_id`, `option_value`) VALUES ('21df11cce40840a981926a82775f359c','IMMU','true'),('510ee393b0524f50b7c196d7e67d09ee','IMMU','true'),('c8d64f613d26423e8c2e24c515ca9252','IMMU','true');
/*!40000 ALTER TABLE `role_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sensitive_config`
--

DROP TABLE IF EXISTS `sensitive_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sensitive_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sensitive_config`
--

LOCK TABLES `sensitive_config` WRITE;
/*!40000 ALTER TABLE `sensitive_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `sensitive_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service`
--

DROP TABLE IF EXISTS `service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service` (
  `id` varchar(64) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `extra` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service`
--

LOCK TABLES `service` WRITE;
/*!40000 ALTER TABLE `service` DISABLE KEYS */;
INSERT INTO `service` (`id`, `type`, `enabled`, `extra`) VALUES ('077c2b5efe0f4c2da18da960c984610a','image',1,'{\"description\": \"Glance Service\", \"name\": \"glance\"}'),('1a3a6d24f20c417d9f50fce9df1ee98f','alarming',1,'{\"description\": \"Aodh for autoscaling Service\", \"name\": \"aodh\"}'),('1b2d1e695dfd4be4bfa6e87d6234a856','orchestration',1,'{\"description\": \"Heat API service\", \"name\": \"heat\"}'),('2bf0f0f0aeb648b48d156343254f9b96','cloudformation',1,'{\"description\": \"Heat Cloudformation API service\", \"name\": \"heat-cfn\"}'),('3bfe7cecbb1643debf415722c66f7491','network',1,'{\"description\": \"Openstack Networking\", \"name\": \"neutron\"}'),('5476958678184f4cb27a3aed329d1494','compute',1,'{\"description\": \"Nova Compute Service\", \"name\": \"nova\"}'),('6a90e815881e4fe7ba86b9228eac2b2f','key-manager',1,'{\"description\": \"Barbican Service\", \"name\": \"barbican\"}'),('703a0b85374a40b9b7522a3eb112c711','sharev2',1,'{\"description\": \"Manila V2 Service\", \"name\": \"manilav2\"}'),('7aec6d8d0b494eba89ad129b7648f032','Ceilometer',1,'{\"description\": \"Ceilometer Service\", \"name\": \"ceilometer\"}'),('bba90c774f624db486388a58a8575e00','volumev3',1,'{\"description\": \"Cinder V3 Service\", \"name\": \"cinderv3\"}'),('c3a94beac8134da2861320170020024c','identity',1,'{\"name\": \"keystone\"}'),('f5fbf2888a0c4b6da3f9fb80ced42184','share',1,'{\"description\": \"Manila V1 Service\", \"name\": \"manila\"}'),('fe61b2daa8d8424b99e5eca9cfe52f82','placement',1,'{\"description\": \"Placement Service\", \"name\": \"placement\"}');
/*!40000 ALTER TABLE `service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_provider`
--

DROP TABLE IF EXISTS `service_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_provider` (
  `auth_url` varchar(256) NOT NULL,
  `id` varchar(64) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `description` text DEFAULT NULL,
  `sp_url` varchar(256) NOT NULL,
  `relay_state_prefix` varchar(256) NOT NULL DEFAULT 'ss:mem:',
  PRIMARY KEY (`id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_provider`
--

LOCK TABLES `service_provider` WRITE;
/*!40000 ALTER TABLE `service_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `service_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_assignment`
--

DROP TABLE IF EXISTS `system_assignment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_assignment` (
  `type` varchar(64) NOT NULL,
  `actor_id` varchar(64) NOT NULL,
  `target_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  `inherited` tinyint(1) NOT NULL,
  PRIMARY KEY (`type`,`actor_id`,`target_id`,`role_id`,`inherited`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`inherited` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_assignment`
--

LOCK TABLES `system_assignment` WRITE;
/*!40000 ALTER TABLE `system_assignment` DISABLE KEYS */;
INSERT INTO `system_assignment` (`type`, `actor_id`, `target_id`, `role_id`, `inherited`) VALUES ('UserSystem','ff0049f3313348bdb67886d170c1c765','system','21df11cce40840a981926a82775f359c',0);
/*!40000 ALTER TABLE `system_assignment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `token`
--

DROP TABLE IF EXISTS `token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `token` (
  `id` varchar(64) NOT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `valid` tinyint(1) NOT NULL,
  `trust_id` varchar(64) DEFAULT NULL,
  `user_id` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_token_expires` (`expires`),
  KEY `ix_token_expires_valid` (`expires`,`valid`),
  KEY `ix_token_user_id` (`user_id`),
  KEY `ix_token_trust_id` (`trust_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`valid` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `token`
--

LOCK TABLES `token` WRITE;
/*!40000 ALTER TABLE `token` DISABLE KEYS */;
/*!40000 ALTER TABLE `token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust`
--

DROP TABLE IF EXISTS `trust`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust` (
  `id` varchar(64) NOT NULL,
  `trustor_user_id` varchar(64) NOT NULL,
  `trustee_user_id` varchar(64) NOT NULL,
  `project_id` varchar(64) DEFAULT NULL,
  `impersonation` tinyint(1) NOT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `remaining_uses` int(11) DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `expires_at_int` bigint(20) DEFAULT NULL,
  `redelegated_trust_id` varchar(64) DEFAULT NULL,
  `redelegation_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `duplicate_trust_constraint_expanded` (`trustor_user_id`,`trustee_user_id`,`project_id`,`impersonation`,`expires_at`,`expires_at_int`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`impersonation` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust`
--

LOCK TABLES `trust` WRITE;
/*!40000 ALTER TABLE `trust` DISABLE KEYS */;
INSERT INTO `trust` (`id`, `trustor_user_id`, `trustee_user_id`, `project_id`, `impersonation`, `deleted_at`, `expires_at`, `remaining_uses`, `extra`, `expires_at_int`, `redelegated_trust_id`, `redelegation_count`) VALUES ('0d5ca7dfaf174c5fa168784463bfbc15','75af55f85c644dbbb2a1ce15c796fc02','e7819aed09eb47d5831d80e49782c509','161893308749469fbaf167d0e576c1c4',0,'2025-12-06 10:17:36',NULL,NULL,'{\"roles\": [{\"id\": \"5399fcec0b4a45b8b28cf1850ab36d65\"}]}',NULL,NULL,0),('2b9a722d75154518b2bfd608efa3e408','d88c2dcd060645c0b0c9b57ff16313df','e7819aed09eb47d5831d80e49782c509','d921630cf1154e78b54b2e05166ad5c0',1,'2025-12-06 10:17:22','2025-12-06 11:17:20',NULL,'{\"roles\": [{\"id\": \"4cf115bfbd1f4336b8b50a9088dd9650\"}]}',1765019840000000,NULL,0),('9a9d765efbd34b27a57fb11abeab7b2c','77204f64eee44c5399c5be3d8eb85ee6','e7819aed09eb47d5831d80e49782c509','9bcc653c7da344c6af3b757c16081025',1,'2025-12-06 10:17:19',NULL,NULL,'{\"roles\": [{\"id\": \"d919c811d11648f79cae7d861ea0af72\"}]}',NULL,NULL,0),('a58531fe44aa42ac9720d768e19f9cf1','2d74c9ac7f31434daf4f31f2cdd445da','e7819aed09eb47d5831d80e49782c509','ae0cdc97196d44abb4857e03a3ecba39',1,'2025-12-06 10:17:32',NULL,NULL,'{\"roles\": [{\"id\": \"7b87b021c36748a2bbd6fcedb6372024\"}]}',NULL,NULL,0),('dfb780a8aa534cc5bdd357c74fc311c4','c1fbf12d99ad4d29ba0be10c8461fa83','e7819aed09eb47d5831d80e49782c509','b3fd279790904bae9723ca980b8ee9fa',1,'2025-12-06 10:17:16',NULL,NULL,'{\"roles\": [{\"id\": \"f3c42b72c615482cb70e70c00059f6df\"}]}',NULL,NULL,0);
/*!40000 ALTER TABLE `trust` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trust_role`
--

DROP TABLE IF EXISTS `trust_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `trust_role` (
  `trust_id` varchar(64) NOT NULL,
  `role_id` varchar(64) NOT NULL,
  PRIMARY KEY (`trust_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `trust_role`
--

LOCK TABLES `trust_role` WRITE;
/*!40000 ALTER TABLE `trust_role` DISABLE KEYS */;
INSERT INTO `trust_role` (`trust_id`, `role_id`) VALUES ('0d5ca7dfaf174c5fa168784463bfbc15','5399fcec0b4a45b8b28cf1850ab36d65'),('2b9a722d75154518b2bfd608efa3e408','4cf115bfbd1f4336b8b50a9088dd9650'),('9a9d765efbd34b27a57fb11abeab7b2c','d919c811d11648f79cae7d861ea0af72'),('a58531fe44aa42ac9720d768e19f9cf1','7b87b021c36748a2bbd6fcedb6372024'),('dfb780a8aa534cc5bdd357c74fc311c4','f3c42b72c615482cb70e70c00059f6df');
/*!40000 ALTER TABLE `trust_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` varchar(64) NOT NULL,
  `extra` text DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `default_project_id` varchar(64) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_active_at` date DEFAULT NULL,
  `domain_id` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ixu_user_id_domain_id` (`id`,`domain_id`),
  KEY `domain_id` (`domain_id`),
  KEY `ix_default_project_id` (`default_project_id`),
  CONSTRAINT `CONSTRAINT_1` CHECK (`enabled` in (0,1))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `extra`, `enabled`, `default_project_id`, `created_at`, `last_active_at`, `domain_id`) VALUES ('0230cb4c53da4352b7218490b2c17f9f','{\"email\": \"heat-cfn@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:02',NULL,'default'),('0b60e97090454089ad6b8f4b898d0040','{\"email\": \"neutron@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:12','2025-12-06','default'),('1544b0e089d94c8fb9c36fa12e309648','{\"tenantId\": \"9bffcf50ce6c4b07a51d7021f8a9cc25\", \"email\": \"demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 10:13:03','2025-12-06','default'),('1c4f5efd048a4728b8b385f1b97bb93f','{\"email\": \"cinder@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:00','2025-12-06','default'),('1c7878b72e394756a744a2987b419fd8','{\"email\": \"ceilometer@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:28:59','2025-12-06','default'),('22044c8ccf4c448da35f054bc8e6d992','{\"email\": \"swift@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:13','2025-12-06','default'),('22ff39926e0145649d48324b557e54cd','{\"email\": \"manilav2@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:11',NULL,'default'),('37c748c83d0749118aad1e714d9bad8c','{\"email\": \"manila@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:03','2025-12-06','default'),('39d964f88e94434fb224ff3aee83c169','{\"email\": \"heat@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:01','2025-12-06','default'),('45242f27271d48b79b0238b7644a7b60','{\"email\": \"cinderv3@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:00',NULL,'default'),('4b82c3c99efd48449ae4a5af07edaad5','{\"email\": \"aodh@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:28:59','2025-12-06','default'),('c0426c55171344f8b1aead6825904739','{\"email\": \"gnocchi@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:01','2025-12-06','default'),('d2ec1ac92c11484fb52fc3dd4b2df2e6','{\"email\": \"placement@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:13','2025-12-06','default'),('d8981dc265a846d2af1fd95fd6598ffb','{}',1,'660705fe1cbe4111b6f2c99ce8d05c8c','2025-12-06 09:02:15','2025-12-06','default'),('dc94af99a6814c1a85c6a553ec912f07','{\"email\": \"heat_stack_domain_admin@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:02',NULL,'94e220b3a75b4b7fa2215bcfb787fa7d'),('e50bc0336ff24c2d8dfe7e6d0f8df8eb','{\"tenantId\": \"1fdbdbf6894f4d0f8918198e1dc4f03b\", \"email\": \"alt_demo_tempestconf@test.com\"}',1,NULL,'2025-12-06 10:13:04',NULL,'default'),('e6a3127800b04e0e8ce5899d342b1fc0','{\"email\": \"glance@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:00','2025-12-06','default'),('f52779cce5374723ad2618b5c2916973','{\"email\": \"nova@localhost\", \"description\": null}',1,NULL,'2025-12-06 08:29:12','2025-12-06','default'),('ff0049f3313348bdb67886d170c1c765','{\"email\": \"admin@localhost\"}',1,NULL,'2025-12-06 08:26:33','2025-12-06','default');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_group_membership`
--

DROP TABLE IF EXISTS `user_group_membership`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_group_membership` (
  `user_id` varchar(64) NOT NULL,
  `group_id` varchar(64) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `group_id` (`group_id`),
  CONSTRAINT `fk_user_group_membership_group_id` FOREIGN KEY (`group_id`) REFERENCES `group` (`id`),
  CONSTRAINT `fk_user_group_membership_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_group_membership`
--

LOCK TABLES `user_group_membership` WRITE;
/*!40000 ALTER TABLE `user_group_membership` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_group_membership` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_option`
--

DROP TABLE IF EXISTS `user_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_option` (
  `user_id` varchar(64) NOT NULL,
  `option_id` varchar(4) NOT NULL,
  `option_value` text DEFAULT NULL,
  PRIMARY KEY (`user_id`,`option_id`),
  CONSTRAINT `user_option_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_option`
--

LOCK TABLES `user_option` WRITE;
/*!40000 ALTER TABLE `user_option` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whitelisted_config`
--

DROP TABLE IF EXISTS `whitelisted_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whitelisted_config` (
  `domain_id` varchar(64) NOT NULL,
  `group` varchar(255) NOT NULL,
  `option` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`domain_id`,`group`,`option`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whitelisted_config`
--

LOCK TABLES `whitelisted_config` WRITE;
/*!40000 ALTER TABLE `whitelisted_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `whitelisted_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Current Database: `manila`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `manila` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci */;

USE `manila`;

--
-- Table structure for table `alembic_version`
--

DROP TABLE IF EXISTS `alembic_version`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `alembic_version` (
  `version_num` varchar(32) NOT NULL,
  PRIMARY KEY (`version_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `alembic_version`
--

LOCK TABLES `alembic_version` WRITE;
/*!40000 ALTER TABLE `alembic_version` DISABLE KEYS */;
INSERT INTO `alembic_version` (`version_num`) VALUES ('aebe2a413e13');
/*!40000 ALTER TABLE `alembic_version` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `async_operation_data`
--

DROP TABLE IF EXISTS `async_operation_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `async_operation_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `async_operation_data`
--

LOCK TABLES `async_operation_data` WRITE;
/*!40000 ALTER TABLE `async_operation_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `async_operation_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `availability_zones`
--

DROP TABLE IF EXISTS `availability_zones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `availability_zones` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `az_name_uc` (`name`,`deleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `availability_zones`
--

LOCK TABLES `availability_zones` WRITE;
/*!40000 ALTER TABLE `availability_zones` DISABLE KEYS */;
INSERT INTO `availability_zones` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `name`) VALUES ('2025-12-06 08:30:42.728311',NULL,NULL,'False','e48d749e-be44-49ef-831a-6e03f16559de','nova');
/*!40000 ALTER TABLE `availability_zones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backend_info`
--

DROP TABLE IF EXISTS `backend_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `backend_info` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `host` varchar(255) NOT NULL,
  `info_hash` varchar(255) NOT NULL,
  PRIMARY KEY (`host`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backend_info`
--

LOCK TABLES `backend_info` WRITE;
/*!40000 ALTER TABLE `backend_info` DISABLE KEYS */;
INSERT INTO `backend_info` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `host`, `info_hash`) VALUES ('2025-12-06 09:14:55.081223',NULL,NULL,0,'hostgroup@cephfs','e66c0dfc0d422efa26af62f5a81dd60603e2d39a');
/*!40000 ALTER TABLE `backend_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers_private_data`
--

DROP TABLE IF EXISTS `drivers_private_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drivers_private_data` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `entity_uuid` varchar(36) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` varchar(1023) NOT NULL,
  PRIMARY KEY (`entity_uuid`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers_private_data`
--

LOCK TABLES `drivers_private_data` WRITE;
/*!40000 ALTER TABLE `drivers_private_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `drivers_private_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `messages`
--

DROP TABLE IF EXISTS `messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `messages` (
  `id` varchar(36) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `request_id` varchar(255) DEFAULT NULL,
  `resource_type` varchar(255) DEFAULT NULL,
  `resource_id` varchar(36) DEFAULT NULL,
  `action_id` varchar(10) NOT NULL,
  `detail_id` varchar(10) DEFAULT NULL,
  `message_level` varchar(255) NOT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `messages`
--

LOCK TABLES `messages` WRITE;
/*!40000 ALTER TABLE `messages` DISABLE KEYS */;
INSERT INTO `messages` (`id`, `project_id`, `request_id`, `resource_type`, `resource_id`, `action_id`, `detail_id`, `message_level`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `expires_at`) VALUES ('0cf26184-8ddf-408a-a632-073618355768','b4a5504da73944ff953a9c5c2851c39c','req-a483030c-8e69-4a72-a6fc-3b20f6f9f104','SHARE','a553e159-ed5f-4558-9a1b-111a7c95bf9f','001','008','ERROR','2025-12-06 10:24:14.389653',NULL,NULL,'False','2026-01-05 10:24:14'),('11d4f600-d8d9-42a5-83c5-8070c11c89cd','b4a5504da73944ff953a9c5c2851c39c','req-168dfd4f-1f8c-40fc-8038-19d19aed4314','SHARE','103d1414-8414-4030-97d4-8b257af7705b','001','008','ERROR','2025-12-06 10:23:51.251124',NULL,NULL,'False','2026-01-05 10:23:51'),('1e330161-9c4b-45af-afe6-aae924d50ba5','b4a5504da73944ff953a9c5c2851c39c','req-ce875e47-bf2f-40f8-85d0-e539e10a73c7','SHARE','191bf6b4-191a-4e39-a228-2102683fefcd','001','008','ERROR','2025-12-06 10:23:58.005015',NULL,NULL,'False','2026-01-05 10:23:58'),('26d95c9a-0117-4b53-9bde-437b8645b1cf','b4a5504da73944ff953a9c5c2851c39c','req-d2be7452-1688-4993-a0bf-6c99a5bfe3e5','SHARE','16bdb2d7-c456-4141-9ac7-425a0e27a932','001','008','ERROR','2025-12-06 10:24:27.813880',NULL,NULL,'False','2026-01-05 10:24:27'),('31815714-b50c-4f46-8f27-836e8d7981d3','5914faf90fd14171adeb0a62b64d0b11','req-f59c3833-671c-4e11-b2af-4978365c4541','SHARE','a507a1d6-a638-48aa-a5f2-d2a17c698c4b','001','008','ERROR','2025-12-06 10:24:04.492840',NULL,NULL,'False','2026-01-05 10:24:04'),('4de2e34e-a6f8-4eae-a080-37b111dadc86','14fcd30962314973b2c11b49f89b4cb4','req-415d1029-82d3-4c39-9b68-3efe845218ba','SHARE','3abe7862-2001-40cb-9d30-42bcc3fec8ed','010','020','ERROR','2025-12-06 10:24:55.329146',NULL,NULL,'False','2026-01-05 10:24:55'),('59709e47-98f3-4f57-ba5f-a6e6fb408455','b4a5504da73944ff953a9c5c2851c39c','req-75a4db4c-d170-400e-a005-4a3b56b543e3','SHARE','1fae2c51-b329-4e8b-b2e5-baed82db938d','001','008','ERROR','2025-12-06 10:24:21.474695',NULL,NULL,'False','2026-01-05 10:24:21'),('5a6cd069-2e6c-4eab-ae8c-d4a9d3e92eff','5914faf90fd14171adeb0a62b64d0b11','req-2041d14e-231e-4625-ac0b-5166b544cddb','SHARE','75b92a52-66b9-46d6-bb8a-8de542d3a74b','001','008','ERROR','2025-12-06 10:23:54.410423',NULL,NULL,'False','2026-01-05 10:23:54'),('651ec028-1e27-4d4a-8c93-6a03520d5f6a','b4a5504da73944ff953a9c5c2851c39c','req-d8db2e2f-a338-473f-adce-29aab8ae79f0','SHARE','28cdfe2e-4912-40ba-a906-80a2bdd5e1a1','001','008','ERROR','2025-12-06 10:24:31.828400',NULL,'2025-12-06 10:24:34.944021','651ec028-1e27-4d4a-8c93-6a03520d5f6a','2026-01-05 10:24:31'),('774fb7d2-2b80-4b9a-8aa6-65ac766f9d9b','5914faf90fd14171adeb0a62b64d0b11','req-0d4e13b6-eb86-4cb7-aefd-d18f1d001d5f','SHARE','96051122-7ca6-4c22-9de3-21aafe9dea46','001','008','ERROR','2025-12-06 10:23:50.787570',NULL,NULL,'False','2026-01-05 10:23:50'),('78b07e5a-80ff-4d9a-adbe-03cd314b27cc','b4a5504da73944ff953a9c5c2851c39c','req-89d54caf-a87a-47b2-8f8e-d5a3d4e53ad8','SHARE','e7118b0f-e192-4b3d-a720-437766748e82','001','008','ERROR','2025-12-06 10:24:08.005670',NULL,NULL,'False','2026-01-05 10:24:08'),('a709f77e-b9ee-4752-9461-da24e9ee29f1','b4a5504da73944ff953a9c5c2851c39c','req-07a3a2f5-8d8d-4cb8-9b9d-7921c5a53ee6','SHARE','56f46075-d51c-4723-b7c7-2d3784bdb8ae','001','008','ERROR','2025-12-06 10:23:54.789280',NULL,NULL,'False','2026-01-05 10:23:54'),('e1a09a64-38d9-4826-9e68-b50b82b756b4','5914faf90fd14171adeb0a62b64d0b11','req-b3174b38-dce8-4f49-a35d-4f3c3c8af5c2','SHARE','a8819200-6aa0-4d2f-8cb0-0478197b6cdc','001','008','ERROR','2025-12-06 10:24:00.941966',NULL,NULL,'False','2026-01-05 10:24:00'),('f227a9e3-01c9-4f11-8a87-22116505eda3','5914faf90fd14171adeb0a62b64d0b11','req-c5538304-ddec-46d2-8121-2a416a79ca91','SHARE','7c86d7ba-fc79-4e93-9862-dcf66b59a39a','001','008','ERROR','2025-12-06 10:23:44.154802',NULL,NULL,'False','2026-01-05 10:23:44'),('f5788eb6-7235-4cd0-8d21-8e0aabd7101a','b4a5504da73944ff953a9c5c2851c39c','req-625a3be6-9b6e-447e-b1b3-611f1feeaf91','SHARE','7bee92dc-44f1-40ef-bff4-e5b5ccbb119f','001','008','ERROR','2025-12-06 10:23:47.686837',NULL,'2025-12-06 10:23:50.761301','f5788eb6-7235-4cd0-8d21-8e0aabd7101a','2026-01-05 10:23:47'),('fd648a05-d933-4f93-8411-ea1c9eedfc5c','b4a5504da73944ff953a9c5c2851c39c','req-d01bc22a-c6b7-4030-93fd-b3d26b325f58','SHARE','ba736177-f95b-4973-80ef-b31ad9373989','001','008','ERROR','2025-12-06 10:24:04.675677',NULL,NULL,'False','2026-01-05 10:24:04');
/*!40000 ALTER TABLE `messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `network_allocations`
--

DROP TABLE IF EXISTS `network_allocations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `network_allocations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` varchar(36) DEFAULT NULL,
  `id` varchar(36) NOT NULL,
  `ip_address` varchar(64) DEFAULT NULL,
  `mac_address` varchar(32) DEFAULT NULL,
  `share_server_id` varchar(36) NOT NULL,
  `label` varchar(255) DEFAULT 'user',
  `network_type` varchar(32) DEFAULT NULL,
  `segmentation_id` int(11) DEFAULT NULL,
  `ip_version` int(11) DEFAULT NULL,
  `cidr` varchar(64) DEFAULT NULL,
  `gateway` varchar(64) DEFAULT NULL,
  `mtu` int(11) DEFAULT NULL,
  `share_network_subnet_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `share_server_id` (`share_server_id`),
  KEY `fk_network_allocation_subnet_id_share_network_subnets` (`share_network_subnet_id`),
  CONSTRAINT `fk_network_allocation_subnet_id_share_network_subnets` FOREIGN KEY (`share_network_subnet_id`) REFERENCES `share_network_subnets` (`id`),
  CONSTRAINT `network_allocations_ibfk_1` FOREIGN KEY (`share_server_id`) REFERENCES `share_servers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `network_allocations`
--

LOCK TABLES `network_allocations` WRITE;
/*!40000 ALTER TABLE `network_allocations` DISABLE KEYS */;
/*!40000 ALTER TABLE `network_allocations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_share_type_quotas`
--

DROP TABLE IF EXISTS `project_share_type_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_share_type_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_quotas_per_share_types` (`share_type_id`,`resource`,`deleted`,`project_id`),
  CONSTRAINT `share_type_id_fk` FOREIGN KEY (`share_type_id`) REFERENCES `share_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_share_type_quotas`
--

LOCK TABLES `project_share_type_quotas` WRITE;
/*!40000 ALTER TABLE `project_share_type_quotas` DISABLE KEYS */;
INSERT INTO `project_share_type_quotas` (`id`, `project_id`, `resource`, `hard_limit`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `share_type_id`) VALUES (1,'cfab9f6ecb0942eb87922e66a206941b','shares',2,'2025-12-06 10:25:44.891966',NULL,'2025-12-06 10:26:06.176469',1,'74b08975-f556-437d-99a1-7053f1cc7f84'),(2,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',4,'2025-12-06 10:25:44.902790',NULL,'2025-12-06 10:26:06.176469',2,'74b08975-f556-437d-99a1-7053f1cc7f84'),(3,'cfab9f6ecb0942eb87922e66a206941b','shares',2,'2025-12-06 10:25:44.991835',NULL,'2025-12-06 10:26:06.106182',3,'b38c356d-96eb-4ed8-907d-f4cdda902d60'),(4,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',4,'2025-12-06 10:25:44.995812',NULL,'2025-12-06 10:26:06.106182',4,'b38c356d-96eb-4ed8-907d-f4cdda902d60'),(5,'cfab9f6ecb0942eb87922e66a206941b','shares',53,'2025-12-06 10:25:58.896834',NULL,'2025-12-06 10:25:58.971143',5,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(6,'cfab9f6ecb0942eb87922e66a206941b','snapshots',53,'2025-12-06 10:25:58.906167',NULL,'2025-12-06 10:25:58.971143',6,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(7,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1003,'2025-12-06 10:25:58.910291',NULL,'2025-12-06 10:25:58.971143',7,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(8,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1003,'2025-12-06 10:25:58.913324',NULL,'2025-12-06 10:25:58.971143',8,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(9,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',103,'2025-12-06 10:25:58.916432',NULL,'2025-12-06 10:25:58.971143',9,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(10,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',1003,'2025-12-06 10:25:58.919882',NULL,'2025-12-06 10:25:58.971143',10,'a6e56602-1bca-46cc-852b-3a05cdb4564f'),(11,'cfab9f6ecb0942eb87922e66a206941b','shares',53,'2025-12-06 10:25:59.304570',NULL,'2025-12-06 10:25:59.448189',11,'7b2e360b-3c27-4151-8566-11c0de987f28'),(12,'cfab9f6ecb0942eb87922e66a206941b','snapshots',53,'2025-12-06 10:25:59.364220',NULL,'2025-12-06 10:25:59.448189',12,'7b2e360b-3c27-4151-8566-11c0de987f28'),(13,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1003,'2025-12-06 10:25:59.372878',NULL,'2025-12-06 10:25:59.448189',13,'7b2e360b-3c27-4151-8566-11c0de987f28'),(14,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1003,'2025-12-06 10:25:59.392083',NULL,'2025-12-06 10:25:59.448189',14,'7b2e360b-3c27-4151-8566-11c0de987f28'),(15,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',103,'2025-12-06 10:25:59.401260',NULL,'2025-12-06 10:25:59.448189',15,'7b2e360b-3c27-4151-8566-11c0de987f28'),(16,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',1003,'2025-12-06 10:25:59.407861',NULL,'2025-12-06 10:25:59.448189',16,'7b2e360b-3c27-4151-8566-11c0de987f28'),(17,'cfab9f6ecb0942eb87922e66a206941b','shares',12,'2025-12-06 10:26:00.036742',NULL,'2025-12-06 10:26:05.910619',17,'b80712a2-3428-4551-8388-04ce03c7d3f0'),(18,'cfab9f6ecb0942eb87922e66a206941b','shares',49,'2025-12-06 10:26:01.859030',NULL,'2025-12-06 10:26:05.866503',18,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(19,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',999,'2025-12-06 10:26:01.929212',NULL,'2025-12-06 10:26:05.866503',19,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(20,'cfab9f6ecb0942eb87922e66a206941b','snapshots',49,'2025-12-06 10:26:02.027587',NULL,'2025-12-06 10:26:05.866503',20,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(21,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',999,'2025-12-06 10:26:02.105757',NULL,'2025-12-06 10:26:05.866503',21,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(22,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',99,'2025-12-06 10:26:02.170989',NULL,'2025-12-06 10:26:05.866503',22,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(23,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',999,'2025-12-06 10:26:02.233637',NULL,'2025-12-06 10:26:05.866503',23,'de9d9b41-7aa9-423f-ae28-497ad4d319fa'),(24,'cfab9f6ecb0942eb87922e66a206941b','shares',49,'2025-12-06 10:26:02.355094',NULL,'2025-12-06 10:26:05.811551',24,'ceacf466-3489-4801-a77b-402b63cc87e9'),(25,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',999,'2025-12-06 10:26:02.415293',NULL,'2025-12-06 10:26:05.811551',25,'ceacf466-3489-4801-a77b-402b63cc87e9'),(26,'cfab9f6ecb0942eb87922e66a206941b','snapshots',49,'2025-12-06 10:26:02.484154',NULL,'2025-12-06 10:26:05.811551',26,'ceacf466-3489-4801-a77b-402b63cc87e9'),(27,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',999,'2025-12-06 10:26:02.558101',NULL,'2025-12-06 10:26:05.811551',27,'ceacf466-3489-4801-a77b-402b63cc87e9'),(28,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',99,'2025-12-06 10:26:02.677461',NULL,'2025-12-06 10:26:05.811551',28,'ceacf466-3489-4801-a77b-402b63cc87e9'),(29,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',999,'2025-12-06 10:26:02.999922',NULL,'2025-12-06 10:26:05.811551',29,'ceacf466-3489-4801-a77b-402b63cc87e9'),(30,'cfab9f6ecb0942eb87922e66a206941b','shares',11,'2025-12-06 10:26:03.196785',NULL,'2025-12-06 10:26:05.744790',30,'f3c51481-d11e-4e89-b864-8e721db8f650'),(31,'cfab9f6ecb0942eb87922e66a206941b','shares',-1,'2025-12-06 10:26:03.351375',NULL,'2025-12-06 10:26:05.662461',31,'c772ab71-86e3-40f3-87f8-dd3e14a59a38');
/*!40000 ALTER TABLE `project_share_type_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `project_user_quotas`
--

DROP TABLE IF EXISTS `project_user_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `project_user_quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `user_id` varchar(255) NOT NULL,
  `project_id` varchar(255) NOT NULL,
  `resource` varchar(25) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `project_user_quotas`
--

LOCK TABLES `project_user_quotas` WRITE;
/*!40000 ALTER TABLE `project_user_quotas` DISABLE KEYS */;
INSERT INTO `project_user_quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `user_id`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-06 10:25:44.775382',NULL,'2025-12-06 10:25:58.586971',1,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',2),(2,'2025-12-06 10:25:44.785441',NULL,'2025-12-06 10:25:58.586971',2,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','gigabytes',7),(3,'2025-12-06 10:25:59.937755',NULL,'2025-12-06 10:26:00.104241',3,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',11),(4,'2025-12-06 10:26:00.960171',NULL,'2025-12-06 10:26:01.008763',4,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','gigabytes',-1),(5,'2025-12-06 10:26:01.060024',NULL,'2025-12-06 10:26:01.104020',5,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','share_replicas',-1),(6,'2025-12-06 10:26:01.156662',NULL,'2025-12-06 10:26:01.216993',6,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',-1),(7,'2025-12-06 10:26:01.292443',NULL,'2025-12-06 10:26:01.358875',7,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','share_networks',-1),(8,'2025-12-06 10:26:01.460779',NULL,'2025-12-06 10:26:01.508911',8,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',-1),(9,'2025-12-06 10:26:01.567259',NULL,'2025-12-06 10:26:01.625492',9,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',-1),(10,'2025-12-06 10:26:01.686925',NULL,'2025-12-06 10:26:01.736455',10,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','snapshots',-1),(11,'2025-12-06 10:26:03.929396',NULL,'2025-12-06 10:26:03.958131',11,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','gigabytes',999),(12,'2025-12-06 10:26:04.176788',NULL,'2025-12-06 10:26:04.200847',12,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','share_replicas',99),(13,'2025-12-06 10:26:04.415713',NULL,'2025-12-06 10:26:04.446314',13,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',999),(14,'2025-12-06 10:26:04.604832',NULL,'2025-12-06 10:26:04.636650',14,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','share_networks',9),(15,'2025-12-06 10:26:04.779646',NULL,'2025-12-06 10:26:04.838499',15,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',49),(16,'2025-12-06 10:26:04.980747',NULL,'2025-12-06 10:26:05.005910',16,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',999),(17,'2025-12-06 10:26:05.135584',NULL,'2025-12-06 10:26:05.180453',17,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','snapshots',49),(18,'2025-12-06 10:26:05.356932',NULL,'2025-12-06 10:26:05.382155',18,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',11),(19,'2025-12-06 10:26:05.556565',NULL,'2025-12-06 10:26:05.602517',19,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',-1);
/*!40000 ALTER TABLE `project_user_quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_classes`
--

DROP TABLE IF EXISTS `quota_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_classes` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_name` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_classes_class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_classes`
--

LOCK TABLES `quota_classes` WRITE;
/*!40000 ALTER TABLE `quota_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `quota_classes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quota_usages`
--

DROP TABLE IF EXISTS `quota_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quota_usages` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `in_use` int(11) NOT NULL,
  `reserved` int(11) NOT NULL,
  `until_refresh` int(11) DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ix_quota_usages_project_id` (`project_id`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quota_usages`
--

LOCK TABLES `quota_usages` WRITE;
/*!40000 ALTER TABLE `quota_usages` DISABLE KEYS */;
INSERT INTO `quota_usages` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `project_id`, `resource`, `in_use`, `reserved`, `until_refresh`, `share_type_id`) VALUES ('2025-12-06 10:18:48.574852','2025-12-06 10:18:54.778749',NULL,0,1,'dd7f280921064e47bdd48fe44756c31e','ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',0,0,NULL,NULL),('2025-12-06 10:18:48.578234','2025-12-06 10:18:54.778754',NULL,0,2,'dd7f280921064e47bdd48fe44756c31e','ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',0,0,NULL,NULL),('2025-12-06 10:18:48.589528','2025-12-06 10:18:54.778756','2025-12-06 10:18:57.513057',3,3,NULL,'ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',0,0,NULL,'6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:18:48.592331','2025-12-06 10:18:54.778759','2025-12-06 10:18:57.513057',4,4,NULL,'ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',0,0,NULL,'6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:19:29.524745','2025-12-06 10:19:34.102116',NULL,0,5,'25eb67fead874d42a56f64bcea2a5914','1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',0,0,NULL,NULL),('2025-12-06 10:19:29.528980','2025-12-06 10:19:34.102119',NULL,0,6,'25eb67fead874d42a56f64bcea2a5914','1ed2dd1e38e94e2fb3db30e196137ff2','shares',0,0,NULL,NULL),('2025-12-06 10:19:29.546426','2025-12-06 10:19:34.102120','2025-12-06 10:19:36.901900',7,7,NULL,'1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',0,0,NULL,'99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:29.551861','2025-12-06 10:19:34.102121','2025-12-06 10:19:36.901900',8,8,NULL,'1ed2dd1e38e94e2fb3db30e196137ff2','shares',0,0,NULL,'99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:36.340369','2025-12-06 10:19:41.760963',NULL,0,9,'f279325fd6b44b6a9cf19af767a2d096','d694f30d513746329568207534277c9c','shares',0,0,NULL,NULL),('2025-12-06 10:19:36.344997','2025-12-06 10:19:41.760966',NULL,0,10,'f279325fd6b44b6a9cf19af767a2d096','d694f30d513746329568207534277c9c','gigabytes',0,0,NULL,NULL),('2025-12-06 10:19:36.366290','2025-12-06 10:19:41.760967','2025-12-06 10:19:44.078924',11,11,NULL,'d694f30d513746329568207534277c9c','shares',0,0,NULL,'fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:36.369913','2025-12-06 10:19:41.760969','2025-12-06 10:19:44.078924',12,12,NULL,'d694f30d513746329568207534277c9c','gigabytes',0,0,NULL,'fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:41.761513','2025-12-06 10:19:46.969205',NULL,0,13,'ee608c83c95e4f3b89126c0af033542a','a9be2712a2b242618de73b18ac23adf7','gigabytes',0,0,NULL,NULL),('2025-12-06 10:19:41.767158','2025-12-06 10:19:46.969208',NULL,0,14,'ee608c83c95e4f3b89126c0af033542a','a9be2712a2b242618de73b18ac23adf7','shares',0,0,NULL,NULL),('2025-12-06 10:19:41.780742','2025-12-06 10:19:46.969209','2025-12-06 10:19:48.624969',15,15,NULL,'a9be2712a2b242618de73b18ac23adf7','gigabytes',0,0,NULL,'3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:41.782785','2025-12-06 10:19:46.969210','2025-12-06 10:19:48.624969',16,16,NULL,'a9be2712a2b242618de73b18ac23adf7','shares',0,0,NULL,'3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:58.245128','2025-12-06 10:20:09.698877',NULL,0,17,'a86c73ba3c184e12856a751fad5b546b','e03a3abfa2c441c78a203b763a3125eb','gigabytes',0,0,NULL,NULL),('2025-12-06 10:19:58.248111','2025-12-06 10:20:09.698881',NULL,0,18,'a86c73ba3c184e12856a751fad5b546b','e03a3abfa2c441c78a203b763a3125eb','shares',0,0,NULL,NULL),('2025-12-06 10:19:58.349013','2025-12-06 10:20:09.698883','2025-12-06 10:20:12.666073',19,19,NULL,'e03a3abfa2c441c78a203b763a3125eb','gigabytes',0,0,NULL,'dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:19:58.352574','2025-12-06 10:20:09.698884','2025-12-06 10:20:12.666073',20,20,NULL,'e03a3abfa2c441c78a203b763a3125eb','shares',0,0,NULL,'dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:02.045672','2025-12-06 10:20:06.430845',NULL,0,21,'a86c73ba3c184e12856a751fad5b546b','e03a3abfa2c441c78a203b763a3125eb','snapshots',0,0,NULL,NULL),('2025-12-06 10:20:02.048383','2025-12-06 10:20:06.430848',NULL,0,22,'a86c73ba3c184e12856a751fad5b546b','e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:02.061124','2025-12-06 10:20:06.430849','2025-12-06 10:20:12.666073',23,23,NULL,'e03a3abfa2c441c78a203b763a3125eb','snapshots',0,0,NULL,'dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:02.063841','2025-12-06 10:20:06.430850','2025-12-06 10:20:12.666073',24,24,NULL,'e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',0,0,NULL,'dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:10.523388','2025-12-06 10:20:53.975654',NULL,0,25,'3c50d030cbcb4b10861d132adc1813e6','c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:10.528014','2025-12-06 10:20:53.975657',NULL,0,26,'3c50d030cbcb4b10861d132adc1813e6','c4a2fd17baa14963bf4a9820b2615c0b','shares',0,0,NULL,NULL),('2025-12-06 10:20:10.536264','2025-12-06 10:20:53.975658','2025-12-06 10:20:56.854092',27,27,NULL,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',0,0,NULL,'c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:10.539130','2025-12-06 10:20:53.975659','2025-12-06 10:20:56.854092',28,28,NULL,'c4a2fd17baa14963bf4a9820b2615c0b','shares',0,0,NULL,'c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:11.514933','2025-12-06 10:20:19.117770',NULL,0,29,'5bed76562a9c480bbc65c8e3541d13c5','ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:11.517903','2025-12-06 10:20:19.117774',NULL,0,30,'5bed76562a9c480bbc65c8e3541d13c5','ca36e4f4a4714022a89a8f2cf1b30df9','shares',0,0,NULL,NULL),('2025-12-06 10:20:11.529077','2025-12-06 10:20:19.117776','2025-12-06 10:20:21.978616',31,31,NULL,'ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',0,0,NULL,'07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:11.533844','2025-12-06 10:20:19.117778','2025-12-06 10:20:21.978616',32,32,NULL,'ca36e4f4a4714022a89a8f2cf1b30df9','shares',0,0,NULL,'07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:22.496778','2025-12-06 10:20:22.547539','2025-12-06 10:20:25.779946',33,33,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,0,NULL,NULL),('2025-12-06 10:20:22.499957','2025-12-06 10:20:22.547543','2025-12-06 10:20:25.779946',34,34,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','shares',1,0,NULL,NULL),('2025-12-06 10:20:22.512787','2025-12-06 10:20:22.547545','2025-12-06 10:20:25.779946',35,35,NULL,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,0,NULL,'ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:22.516359','2025-12-06 10:20:22.547547','2025-12-06 10:20:25.779946',36,36,NULL,'cac28ee51926445e98b064ed4d5f28d2','shares',1,0,NULL,'ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:25.869120','2025-12-06 10:20:26.104994','2025-12-06 10:20:32.930072',37,37,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','gigabytes',2,0,NULL,NULL),('2025-12-06 10:20:25.873430','2025-12-06 10:20:26.104998','2025-12-06 10:20:32.930072',38,38,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','shares',2,0,NULL,NULL),('2025-12-06 10:20:26.068172','2025-12-06 10:20:26.105000','2025-12-06 10:20:32.930072',39,39,NULL,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:26.070573','2025-12-06 10:20:26.105002','2025-12-06 10:20:32.930072',40,40,NULL,'cac28ee51926445e98b064ed4d5f28d2','shares',1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:26.182063','2025-12-06 10:21:46.514119',NULL,0,41,'e79d3d9ca9844cf7a820fed66615a837','88ea8626c7df4b62bf7459a615217eeb','gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:26.187290','2025-12-06 10:21:46.514122',NULL,0,42,'e79d3d9ca9844cf7a820fed66615a837','88ea8626c7df4b62bf7459a615217eeb','shares',0,0,NULL,NULL),('2025-12-06 10:20:26.202420','2025-12-06 10:21:46.514123','2025-12-06 10:21:49.042082',43,43,NULL,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',0,0,NULL,'d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:26.206192','2025-12-06 10:21:46.514124','2025-12-06 10:21:49.042082',44,44,NULL,'88ea8626c7df4b62bf7459a615217eeb','shares',0,0,NULL,'d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:29.487521','2025-12-06 10:20:29.608654','2025-12-06 10:20:32.930072',45,45,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',1,0,NULL,NULL),('2025-12-06 10:20:29.493841','2025-12-06 10:20:29.608656','2025-12-06 10:20:32.930072',46,46,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','snapshots',1,0,NULL,NULL),('2025-12-06 10:20:29.521601','2025-12-06 10:20:29.608657','2025-12-06 10:20:32.930072',47,47,NULL,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:29.526102','2025-12-06 10:20:29.608659','2025-12-06 10:20:32.930072',48,48,NULL,'cac28ee51926445e98b064ed4d5f28d2','snapshots',1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:29.543055','2025-12-06 10:21:42.818583',NULL,0,49,'e79d3d9ca9844cf7a820fed66615a837','88ea8626c7df4b62bf7459a615217eeb','snapshots',0,0,NULL,NULL),('2025-12-06 10:20:29.553643','2025-12-06 10:21:42.818586',NULL,0,50,'e79d3d9ca9844cf7a820fed66615a837','88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:29.569840','2025-12-06 10:21:42.818587','2025-12-06 10:21:49.042082',51,51,NULL,'88ea8626c7df4b62bf7459a615217eeb','snapshots',0,0,NULL,'d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:29.572417','2025-12-06 10:21:42.818588','2025-12-06 10:21:49.042082',52,52,NULL,'88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',0,0,NULL,'d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:36.790337','2025-12-06 10:20:36.828600',NULL,0,53,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','snapshots',-1,0,NULL,NULL),('2025-12-06 10:20:36.804136','2025-12-06 10:20:36.828603',NULL,0,54,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',-1,0,NULL,NULL),('2025-12-06 10:20:36.812762','2025-12-06 10:20:36.828604','2025-12-06 10:20:42.912565',55,55,NULL,'cac28ee51926445e98b064ed4d5f28d2','snapshots',-1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:36.815521','2025-12-06 10:20:36.828605','2025-12-06 10:20:42.912565',56,56,NULL,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',-1,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:40.011196','2025-12-06 10:20:43.406242',NULL,0,57,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','shares',0,0,NULL,NULL),('2025-12-06 10:20:40.014463','2025-12-06 10:20:43.406244',NULL,0,58,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','cac28ee51926445e98b064ed4d5f28d2','gigabytes',0,0,NULL,NULL),('2025-12-06 10:20:40.078731','2025-12-06 10:20:40.253068','2025-12-06 10:20:42.912565',59,59,NULL,'cac28ee51926445e98b064ed4d5f28d2','shares',0,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:40.082275','2025-12-06 10:20:40.253069','2025-12-06 10:20:42.912565',60,60,NULL,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',0,0,NULL,'ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:43.383300','2025-12-06 10:20:43.406246','2025-12-06 10:20:46.304243',61,61,NULL,'cac28ee51926445e98b064ed4d5f28d2','shares',0,0,NULL,'ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:43.394188','2025-12-06 10:20:43.406247','2025-12-06 10:20:46.304243',62,62,NULL,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',0,0,NULL,'ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:21:06.088277','2025-12-06 10:21:07.767263',NULL,0,63,'3e4c3243bf5c4e3a9a62ce06cde13e3d','3611325ae8594883a9bcd4e1005703c3','share_networks',0,0,NULL,NULL),('2025-12-06 10:21:08.296922','2025-12-06 10:21:19.252928',NULL,0,64,'2c36ca91e0a44aa0b02f8bba067633f3','ad585e38a585413188401641b7f99059','gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:08.298655','2025-12-06 10:21:19.252930',NULL,0,65,'2c36ca91e0a44aa0b02f8bba067633f3','ad585e38a585413188401641b7f99059','shares',0,0,NULL,NULL),('2025-12-06 10:21:08.307633','2025-12-06 10:21:19.252932','2025-12-06 10:21:22.092644',66,66,NULL,'ad585e38a585413188401641b7f99059','gigabytes',0,0,NULL,'a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:08.309376','2025-12-06 10:21:19.252933','2025-12-06 10:21:22.092644',67,67,NULL,'ad585e38a585413188401641b7f99059','shares',0,0,NULL,'a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:11.539730','2025-12-06 10:21:15.951285',NULL,0,68,'2c36ca91e0a44aa0b02f8bba067633f3','ad585e38a585413188401641b7f99059','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:11.544006','2025-12-06 10:21:15.951288',NULL,0,69,'2c36ca91e0a44aa0b02f8bba067633f3','ad585e38a585413188401641b7f99059','snapshots',0,0,NULL,NULL),('2025-12-06 10:21:11.555255','2025-12-06 10:21:15.951289','2025-12-06 10:21:22.092644',70,70,NULL,'ad585e38a585413188401641b7f99059','snapshot_gigabytes',0,0,NULL,'a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:11.558975','2025-12-06 10:21:15.951290','2025-12-06 10:21:22.092644',71,71,NULL,'ad585e38a585413188401641b7f99059','snapshots',0,0,NULL,'a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:13.882443','2025-12-06 10:21:14.615822',NULL,0,72,'20e73dea82d14668b6b190aa3ab4fe2b','9877ea92d21c443da020b2f5ac6e63a2','share_networks',0,0,NULL,NULL),('2025-12-06 10:21:20.698027','2025-12-06 10:21:20.780974',NULL,0,73,'18894715ea384479ab6561155114f3f7','c10c64021a544b89a5534dadb82defd7','share_networks',1,0,NULL,NULL),('2025-12-06 10:21:28.436442','2025-12-06 10:21:39.612176',NULL,0,74,'1c980f45f3e4418eb757be06bc24856c','f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,0,NULL,NULL),('2025-12-06 10:21:28.438198','2025-12-06 10:21:39.612180',NULL,0,75,'1c980f45f3e4418eb757be06bc24856c','f7a062bb0b084dcb9736c737dbff3764','shares',1,0,NULL,NULL),('2025-12-06 10:21:28.446285','2025-12-06 10:21:39.612182','2025-12-06 10:21:43.076059',76,76,NULL,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,0,NULL,'720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:28.447942','2025-12-06 10:21:39.612184','2025-12-06 10:21:43.076059',77,77,NULL,'f7a062bb0b084dcb9736c737dbff3764','shares',1,0,NULL,'720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:32.069328','2025-12-06 10:21:32.817007',NULL,0,78,'fa029c59ca1143c3a47c6ff44f0fe268','f5a7bbeba4b24e8186ef063c429b60eb','shares',0,0,NULL,NULL),('2025-12-06 10:21:32.071739','2025-12-06 10:21:32.817010',NULL,0,79,'fa029c59ca1143c3a47c6ff44f0fe268','f5a7bbeba4b24e8186ef063c429b60eb','gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:32.100132','2025-12-06 10:21:32.282031',NULL,0,80,'fa029c59ca1143c3a47c6ff44f0fe268','f7a062bb0b084dcb9736c737dbff3764','shares',-1,0,NULL,NULL),('2025-12-06 10:21:32.101917','2025-12-06 10:21:32.282034',NULL,0,81,'fa029c59ca1143c3a47c6ff44f0fe268','f7a062bb0b084dcb9736c737dbff3764','gigabytes',-1,0,NULL,NULL),('2025-12-06 10:21:32.802564','2025-12-06 10:21:32.817011','2025-12-06 10:21:43.076059',82,82,NULL,'f5a7bbeba4b24e8186ef063c429b60eb','shares',0,0,NULL,'720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:32.805287','2025-12-06 10:21:32.817012','2025-12-06 10:21:43.076059',83,83,NULL,'f5a7bbeba4b24e8186ef063c429b60eb','gigabytes',0,0,NULL,'720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:34.356660','2025-12-06 10:21:37.271885',NULL,0,84,'a3846342ee734fae98d301bc764d5aa7','d0315a7a31194fe5bc10aff481f0b185','share_networks',0,0,NULL,NULL),('2025-12-06 10:21:47.272245','2025-12-06 10:22:32.724495',NULL,0,85,'02b36e7ff8b54c0ea203f9aa2a006b9f','0bb1c648a1eb4322b7d7147d8b096005','gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:47.274960','2025-12-06 10:22:32.724499',NULL,0,86,'02b36e7ff8b54c0ea203f9aa2a006b9f','0bb1c648a1eb4322b7d7147d8b096005','shares',0,0,NULL,NULL),('2025-12-06 10:21:47.287648','2025-12-06 10:22:32.724501','2025-12-06 10:22:35.546858',87,87,NULL,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',0,0,NULL,'d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:47.289891','2025-12-06 10:22:32.724503','2025-12-06 10:22:35.546858',88,88,NULL,'0bb1c648a1eb4322b7d7147d8b096005','shares',0,0,NULL,'d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:50.522252','2025-12-06 10:22:29.532339',NULL,0,89,'02b36e7ff8b54c0ea203f9aa2a006b9f','0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:50.525239','2025-12-06 10:22:29.532343',NULL,0,90,'02b36e7ff8b54c0ea203f9aa2a006b9f','0bb1c648a1eb4322b7d7147d8b096005','snapshots',0,0,NULL,NULL),('2025-12-06 10:21:50.544753','2025-12-06 10:22:29.532345','2025-12-06 10:22:35.546858',91,91,NULL,'0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',0,0,NULL,'d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:50.547920','2025-12-06 10:22:29.532346','2025-12-06 10:22:35.546858',92,92,NULL,'0bb1c648a1eb4322b7d7147d8b096005','snapshots',0,0,NULL,'d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:51.748588','2025-12-06 10:22:44.893050',NULL,0,93,'62322ce9b54e4926bdc8317dbdffd385','bda02ea3c96c41dea538deeda04311bc','gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:51.751847','2025-12-06 10:22:44.893053',NULL,0,94,'62322ce9b54e4926bdc8317dbdffd385','bda02ea3c96c41dea538deeda04311bc','shares',0,0,NULL,NULL),('2025-12-06 10:21:51.769542','2025-12-06 10:22:02.499296','2025-12-06 10:22:05.262858',95,95,NULL,'bda02ea3c96c41dea538deeda04311bc','gigabytes',0,0,NULL,'7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:51.771325','2025-12-06 10:22:02.499297','2025-12-06 10:22:05.262858',96,96,NULL,'bda02ea3c96c41dea538deeda04311bc','shares',0,0,NULL,'7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:55.055499','2025-12-06 10:22:41.729273',NULL,0,97,'62322ce9b54e4926bdc8317dbdffd385','bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:55.059653','2025-12-06 10:22:41.729276',NULL,0,98,'62322ce9b54e4926bdc8317dbdffd385','bda02ea3c96c41dea538deeda04311bc','snapshots',0,0,NULL,NULL),('2025-12-06 10:21:55.097846','2025-12-06 10:21:59.051779','2025-12-06 10:22:05.262858',99,99,NULL,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',0,0,NULL,'7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:55.105240','2025-12-06 10:21:59.051780','2025-12-06 10:22:05.262858',100,100,NULL,'bda02ea3c96c41dea538deeda04311bc','snapshots',0,0,NULL,'7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:59.388819','2025-12-06 10:22:04.136173',NULL,0,101,'855e050f34334842b489f5e7ecf811bb','aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',0,0,NULL,NULL),('2025-12-06 10:21:59.391038','2025-12-06 10:22:04.136175',NULL,0,102,'855e050f34334842b489f5e7ecf811bb','aff741aa7ffb45e69b516ac04c7e66f7','shares',0,0,NULL,NULL),('2025-12-06 10:21:59.401812','2025-12-06 10:22:04.136177','2025-12-06 10:22:06.986849',103,103,NULL,'aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',0,0,NULL,'a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:21:59.404221','2025-12-06 10:22:04.136178','2025-12-06 10:22:06.986849',104,104,NULL,'aff741aa7ffb45e69b516ac04c7e66f7','shares',0,0,NULL,'a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:22:05.349951','2025-12-06 10:22:09.325435','2025-12-06 10:22:48.117750',105,105,NULL,'bda02ea3c96c41dea538deeda04311bc','gigabytes',0,0,NULL,'4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:05.355797','2025-12-06 10:22:09.325436','2025-12-06 10:22:48.117750',106,106,NULL,'bda02ea3c96c41dea538deeda04311bc','shares',0,0,NULL,'4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:12.221451','2025-12-06 10:22:44.893054','2025-12-06 10:22:47.714328',107,107,NULL,'bda02ea3c96c41dea538deeda04311bc','gigabytes',0,0,NULL,'830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:12.224407','2025-12-06 10:22:44.893055','2025-12-06 10:22:47.714328',108,108,NULL,'bda02ea3c96c41dea538deeda04311bc','shares',0,0,NULL,'830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:15.492935','2025-12-06 10:22:41.729277','2025-12-06 10:22:47.714328',109,109,NULL,'bda02ea3c96c41dea538deeda04311bc','snapshots',0,0,NULL,'830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:15.495953','2025-12-06 10:22:41.729278','2025-12-06 10:22:47.714328',110,110,NULL,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',0,0,NULL,'830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:18.328619','2025-12-06 10:22:55.386154',NULL,0,111,'d0a08cde4fda48429459a853fd139f8a','00d42fb3fe114975b941ad331bfb477b','gigabytes',0,0,NULL,NULL),('2025-12-06 10:22:18.330363','2025-12-06 10:22:55.386158',NULL,0,112,'d0a08cde4fda48429459a853fd139f8a','00d42fb3fe114975b941ad331bfb477b','shares',0,0,NULL,NULL),('2025-12-06 10:22:18.344649','2025-12-06 10:22:55.386160','2025-12-06 10:22:59.125833',113,113,NULL,'00d42fb3fe114975b941ad331bfb477b','gigabytes',0,0,NULL,'299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:18.347117','2025-12-06 10:22:55.386162','2025-12-06 10:22:59.125833',114,114,NULL,'00d42fb3fe114975b941ad331bfb477b','shares',0,0,NULL,'299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:22.145664','2025-12-06 10:22:24.368128',NULL,0,115,'184bb450d4864170a750006dfcc7e3fe','27d01455ef604522b30ed3c627f764a1','share_networks',0,0,NULL,NULL),('2025-12-06 10:22:31.851211','2025-12-06 10:22:41.643615',NULL,0,116,'d0a08cde4fda48429459a853fd139f8a','00d42fb3fe114975b941ad331bfb477b','share_groups',0,0,NULL,NULL),('2025-12-06 10:23:01.836256','2025-12-06 10:23:07.175184',NULL,0,117,'d15527bbfe3541d081546fd87b965969','32c3d6224de34254bee75ac8f1ece984','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:01.839409','2025-12-06 10:23:07.175187',NULL,0,118,'d15527bbfe3541d081546fd87b965969','32c3d6224de34254bee75ac8f1ece984','shares',0,0,NULL,NULL),('2025-12-06 10:23:01.851036','2025-12-06 10:23:07.175188','2025-12-06 10:23:10.083991',119,119,NULL,'32c3d6224de34254bee75ac8f1ece984','gigabytes',0,0,NULL,'107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:01.853550','2025-12-06 10:23:07.175190','2025-12-06 10:23:10.083991',120,120,NULL,'32c3d6224de34254bee75ac8f1ece984','shares',0,0,NULL,'107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:02.453240','2025-12-06 10:23:19.680962',NULL,0,121,'1653cdabeb4d4defac504fa88d0df629','8168ad3d37a64ff680fd439a69736a7b','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:02.455189','2025-12-06 10:23:19.680965',NULL,0,122,'1653cdabeb4d4defac504fa88d0df629','8168ad3d37a64ff680fd439a69736a7b','shares',0,0,NULL,NULL),('2025-12-06 10:23:02.463952','2025-12-06 10:23:19.680966','2025-12-06 10:23:22.556821',123,123,NULL,'8168ad3d37a64ff680fd439a69736a7b','gigabytes',0,0,NULL,'827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:02.465712','2025-12-06 10:23:19.680967','2025-12-06 10:23:22.556821',124,124,NULL,'8168ad3d37a64ff680fd439a69736a7b','shares',0,0,NULL,'827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:05.734891','2025-12-06 10:23:16.399933',NULL,0,125,'1653cdabeb4d4defac504fa88d0df629','8168ad3d37a64ff680fd439a69736a7b','snapshots',0,0,NULL,NULL),('2025-12-06 10:23:05.739516','2025-12-06 10:23:16.399935',NULL,0,126,'1653cdabeb4d4defac504fa88d0df629','8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:05.755651','2025-12-06 10:23:16.399937','2025-12-06 10:23:22.556821',127,127,NULL,'8168ad3d37a64ff680fd439a69736a7b','snapshots',0,0,NULL,'827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:05.762692','2025-12-06 10:23:16.399938','2025-12-06 10:23:22.556821',128,128,NULL,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',0,0,NULL,'827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:24.263132','2025-12-06 10:24:14.548629',NULL,0,129,'8c95b67d83b947d78dd96e1b4cce7a0e','a860f91f361042a2b13934bff381f266','shares',0,0,NULL,NULL),('2025-12-06 10:23:24.265740','2025-12-06 10:24:14.548632',NULL,0,130,'8c95b67d83b947d78dd96e1b4cce7a0e','a860f91f361042a2b13934bff381f266','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:24.280959','2025-12-06 10:24:14.548634','2025-12-06 10:24:17.422099',131,131,NULL,'a860f91f361042a2b13934bff381f266','shares',0,0,NULL,'776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:24.283925','2025-12-06 10:24:14.548636','2025-12-06 10:24:17.422099',132,132,NULL,'a860f91f361042a2b13934bff381f266','gigabytes',0,0,NULL,'776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:27.518171','2025-12-06 10:24:11.076776',NULL,0,133,'8c95b67d83b947d78dd96e1b4cce7a0e','a860f91f361042a2b13934bff381f266','snapshots',0,0,NULL,NULL),('2025-12-06 10:23:27.520097','2025-12-06 10:24:11.076778',NULL,0,134,'8c95b67d83b947d78dd96e1b4cce7a0e','a860f91f361042a2b13934bff381f266','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:27.529754','2025-12-06 10:24:11.076780','2025-12-06 10:24:17.422099',135,135,NULL,'a860f91f361042a2b13934bff381f266','snapshots',0,0,NULL,'776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:27.531901','2025-12-06 10:24:11.076781','2025-12-06 10:24:17.422099',136,136,NULL,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',0,0,NULL,'776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:28.422937','2025-12-06 10:23:38.966426',NULL,0,137,'24430961e75b499c8132e916070db917','c83cf8cf17554ef78c82738ac22165fa','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:28.425205','2025-12-06 10:23:38.966430',NULL,0,138,'24430961e75b499c8132e916070db917','c83cf8cf17554ef78c82738ac22165fa','shares',0,0,NULL,NULL),('2025-12-06 10:23:28.439214','2025-12-06 10:23:38.966432','2025-12-06 10:23:41.840913',139,139,NULL,'c83cf8cf17554ef78c82738ac22165fa','gigabytes',0,0,NULL,'307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:28.441217','2025-12-06 10:23:38.966433','2025-12-06 10:23:41.840913',140,140,NULL,'c83cf8cf17554ef78c82738ac22165fa','shares',0,0,NULL,'307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:31.716607','2025-12-06 10:23:36.038956',NULL,0,141,'24430961e75b499c8132e916070db917','c83cf8cf17554ef78c82738ac22165fa','snapshots',0,0,NULL,NULL),('2025-12-06 10:23:31.719317','2025-12-06 10:23:36.038959',NULL,0,142,'24430961e75b499c8132e916070db917','c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:31.731613','2025-12-06 10:23:36.038961','2025-12-06 10:23:41.840913',143,143,NULL,'c83cf8cf17554ef78c82738ac22165fa','snapshots',0,0,NULL,'307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:31.735947','2025-12-06 10:23:36.038963','2025-12-06 10:23:41.840913',144,144,NULL,'c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',0,0,NULL,'307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:43.971425','2025-12-06 10:24:10.821215',NULL,0,145,'27c84077ffd54c46ae679867b185acda','5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,NULL),('2025-12-06 10:23:43.973670','2025-12-06 10:24:10.821220',NULL,0,146,'27c84077ffd54c46ae679867b185acda','5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:43.983595','2025-12-06 10:23:50.620719','2025-12-06 10:24:11.507804',147,147,NULL,'5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,'ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:43.990431','2025-12-06 10:23:50.620721','2025-12-06 10:24:11.507804',148,148,NULL,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,'ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:47.506715','2025-12-06 10:24:35.180540',NULL,0,149,'2e821100b94443559eb555b391eef104','b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,NULL),('2025-12-06 10:23:47.510128','2025-12-06 10:24:35.180543',NULL,0,150,'2e821100b94443559eb555b391eef104','b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,NULL),('2025-12-06 10:23:47.530067','2025-12-06 10:23:50.977485','2025-12-06 10:24:35.731438',151,151,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:47.535034','2025-12-06 10:23:50.977487','2025-12-06 10:24:35.731438',152,152,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:50.695089','2025-12-06 10:23:54.116020','2025-12-06 10:24:11.398564',153,153,NULL,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,'176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:50.696818','2025-12-06 10:23:54.116022','2025-12-06 10:24:11.398564',154,154,NULL,'5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,'176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:51.128350','2025-12-06 10:23:54.563923','2025-12-06 10:24:35.672095',155,155,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:51.131794','2025-12-06 10:23:54.563924','2025-12-06 10:24:35.672095',156,156,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:54.207038','2025-12-06 10:24:00.724030','2025-12-06 10:24:11.325166',157,157,NULL,'5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,'23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:23:54.209829','2025-12-06 10:24:00.724031','2025-12-06 10:24:11.325166',158,158,NULL,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,'23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:23:54.646142','2025-12-06 10:24:04.472538','2025-12-06 10:24:35.608164',159,159,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:23:54.648294','2025-12-06 10:24:04.472539','2025-12-06 10:24:35.608164',160,160,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:23:57.897304','2025-12-06 10:24:04.320388','2025-12-06 10:24:35.547296',161,161,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:23:57.899589','2025-12-06 10:24:04.320389','2025-12-06 10:24:35.547296',162,162,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:24:00.822518','2025-12-06 10:24:04.249071','2025-12-06 10:24:11.263671',163,163,NULL,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,'54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:00.827232','2025-12-06 10:24:04.249072','2025-12-06 10:24:11.263671',164,164,NULL,'5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,'54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:04.346997','2025-12-06 10:24:10.821223','2025-12-06 10:24:11.190024',165,165,NULL,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',0,0,NULL,'1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:04.349619','2025-12-06 10:24:10.821225','2025-12-06 10:24:11.190024',166,166,NULL,'5914faf90fd14171adeb0a62b64d0b11','shares',0,0,NULL,'1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:04.572832','2025-12-06 10:24:21.178394','2025-12-06 10:24:35.479307',167,167,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:04.577636','2025-12-06 10:24:21.178396','2025-12-06 10:24:35.479307',168,168,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:07.888260','2025-12-06 10:24:20.939977','2025-12-06 10:24:35.437399',169,169,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:07.890654','2025-12-06 10:24:20.939979','2025-12-06 10:24:35.437399',170,170,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:10.024972','2025-12-06 10:25:31.931626',NULL,0,171,'a6d62e9381984680b8feaf471728ad16','674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',0,0,NULL,NULL),('2025-12-06 10:24:10.027082','2025-12-06 10:25:31.931630',NULL,0,172,'a6d62e9381984680b8feaf471728ad16','674b1770f1a44f0c83fe1e0bf22a570c','shares',0,0,NULL,NULL),('2025-12-06 10:24:10.051227','2025-12-06 10:25:31.931632','2025-12-06 10:25:34.779687',173,173,NULL,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',0,0,NULL,'5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:10.055337','2025-12-06 10:25:31.931634','2025-12-06 10:25:34.779687',174,174,NULL,'674b1770f1a44f0c83fe1e0bf22a570c','shares',0,0,NULL,'5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:14.202805','2025-12-06 10:24:20.682523','2025-12-06 10:24:35.391945',175,175,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:14.205068','2025-12-06 10:24:20.682525','2025-12-06 10:24:35.391945',176,176,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:21.319626','2025-12-06 10:24:31.589112','2025-12-06 10:24:35.345798',177,177,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'8e9f608e-00c2-4462-8ccd-8749113629f6'),('2025-12-06 10:24:21.321374','2025-12-06 10:24:31.589114','2025-12-06 10:24:35.345798',178,178,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'8e9f608e-00c2-4462-8ccd-8749113629f6'),('2025-12-06 10:24:24.543387','2025-12-06 10:25:26.047692',NULL,0,179,'58fc51cd55374a6f9aca770f673e918e','14fcd30962314973b2c11b49f89b4cb4','gigabytes',0,0,NULL,NULL),('2025-12-06 10:24:24.551069','2025-12-06 10:25:26.047695',NULL,0,180,'58fc51cd55374a6f9aca770f673e918e','14fcd30962314973b2c11b49f89b4cb4','shares',0,0,NULL,NULL),('2025-12-06 10:24:24.571635','2025-12-06 10:25:26.047696','2025-12-06 10:25:28.581452',181,181,NULL,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',0,0,NULL,'da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:24:24.576824','2025-12-06 10:25:26.047697','2025-12-06 10:25:28.581452',182,182,NULL,'14fcd30962314973b2c11b49f89b4cb4','shares',0,0,NULL,'da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:24:27.661513','2025-12-06 10:24:31.348022','2025-12-06 10:24:35.293102',183,183,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:27.673561','2025-12-06 10:24:31.348023','2025-12-06 10:24:35.293102',184,184,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:28.102165','2025-12-06 10:25:22.458555',NULL,0,185,NULL,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',0,0,NULL,'71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:28.105322','2025-12-06 10:25:22.458558',NULL,0,186,NULL,'14fcd30962314973b2c11b49f89b4cb4','shares',0,0,NULL,'71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:31.690844','2025-12-06 10:24:35.180545','2025-12-06 10:24:35.229587',187,187,NULL,'b4a5504da73944ff953a9c5c2851c39c','shares',0,0,NULL,'4e271530-a165-46eb-8625-c6501979ce6a'),('2025-12-06 10:24:31.692850','2025-12-06 10:24:35.180547','2025-12-06 10:24:35.229587',188,188,NULL,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',0,0,NULL,'4e271530-a165-46eb-8625-c6501979ce6a'),('2025-12-06 10:24:34.829039','2025-12-06 10:25:19.108568',NULL,0,189,'5a77fc22a9f24b66860230c054bd00fa','438e893229f742e78fe8e62ef6ea17d5','gigabytes',0,0,NULL,NULL),('2025-12-06 10:24:34.832370','2025-12-06 10:25:19.108571',NULL,0,190,'5a77fc22a9f24b66860230c054bd00fa','438e893229f742e78fe8e62ef6ea17d5','shares',0,0,NULL,NULL),('2025-12-06 10:24:34.846838','2025-12-06 10:25:19.108572',NULL,0,191,NULL,'438e893229f742e78fe8e62ef6ea17d5','gigabytes',0,0,NULL,'71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:34.853571','2025-12-06 10:25:19.108573',NULL,0,192,NULL,'438e893229f742e78fe8e62ef6ea17d5','shares',0,0,NULL,'71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:45.274049','2025-12-06 10:24:49.458041',NULL,0,193,'c25f4de05ecd4014bc58031d0e9bfaf8','bccda81fdd6247d7bc0bc19a42042aba','shares',0,0,NULL,NULL),('2025-12-06 10:24:45.276381','2025-12-06 10:24:49.458044',NULL,0,194,'c25f4de05ecd4014bc58031d0e9bfaf8','bccda81fdd6247d7bc0bc19a42042aba','gigabytes',0,0,NULL,NULL),('2025-12-06 10:24:45.288083','2025-12-06 10:24:49.458045','2025-12-06 10:24:52.364812',195,195,NULL,'bccda81fdd6247d7bc0bc19a42042aba','shares',0,0,NULL,'d95ce746-1eb8-4b56-aa0f-a0495e6efe12'),('2025-12-06 10:24:45.289968','2025-12-06 10:24:49.458047','2025-12-06 10:24:52.364812',196,196,NULL,'bccda81fdd6247d7bc0bc19a42042aba','gigabytes',0,0,NULL,'d95ce746-1eb8-4b56-aa0f-a0495e6efe12'),('2025-12-06 10:24:46.663464','2025-12-06 10:25:28.666443',NULL,0,197,'a6d62e9381984680b8feaf471728ad16','674b1770f1a44f0c83fe1e0bf22a570c','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:24:46.666323','2025-12-06 10:25:28.666447',NULL,0,198,'a6d62e9381984680b8feaf471728ad16','674b1770f1a44f0c83fe1e0bf22a570c','snapshots',0,0,NULL,NULL),('2025-12-06 10:24:46.684101','2025-12-06 10:25:28.666449','2025-12-06 10:25:34.779687',199,199,NULL,'674b1770f1a44f0c83fe1e0bf22a570c','snapshot_gigabytes',0,0,NULL,'5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:46.687004','2025-12-06 10:25:28.666451','2025-12-06 10:25:34.779687',200,200,NULL,'674b1770f1a44f0c83fe1e0bf22a570c','snapshots',0,0,NULL,'5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:25:01.347142','2025-12-06 10:26:12.212559',NULL,0,201,'840ae9b76ac645528f6ee395b7442d49','4f1f5483827f4daa9804cdd5878693f5','gigabytes',0,0,NULL,NULL),('2025-12-06 10:25:01.352947','2025-12-06 10:26:12.212562',NULL,0,202,'840ae9b76ac645528f6ee395b7442d49','4f1f5483827f4daa9804cdd5878693f5','shares',0,0,NULL,NULL),('2025-12-06 10:25:01.361212','2025-12-06 10:26:12.212563','2025-12-06 10:26:15.120057',203,203,NULL,'4f1f5483827f4daa9804cdd5878693f5','gigabytes',0,0,NULL,'3df796e1-2d8e-44d3-be48-74110d6c20c0'),('2025-12-06 10:25:01.363765','2025-12-06 10:26:12.212564','2025-12-06 10:26:15.120057',204,204,NULL,'4f1f5483827f4daa9804cdd5878693f5','shares',0,0,NULL,'3df796e1-2d8e-44d3-be48-74110d6c20c0'),('2025-12-06 10:25:02.135843','2025-12-06 10:25:16.014103','2025-12-06 10:25:28.581452',205,205,NULL,'438e893229f742e78fe8e62ef6ea17d5','gigabytes',0,0,NULL,'da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:25:02.137902','2025-12-06 10:25:16.014108','2025-12-06 10:25:28.581452',206,206,NULL,'438e893229f742e78fe8e62ef6ea17d5','shares',0,0,NULL,'da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:25:04.838906','2025-12-06 10:26:08.977553',NULL,0,207,'840ae9b76ac645528f6ee395b7442d49','4f1f5483827f4daa9804cdd5878693f5','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:25:04.842314','2025-12-06 10:26:08.977556',NULL,0,208,'840ae9b76ac645528f6ee395b7442d49','4f1f5483827f4daa9804cdd5878693f5','snapshots',0,0,NULL,NULL),('2025-12-06 10:25:04.867963','2025-12-06 10:26:08.977557','2025-12-06 10:26:15.120057',209,209,NULL,'4f1f5483827f4daa9804cdd5878693f5','snapshot_gigabytes',0,0,NULL,'3df796e1-2d8e-44d3-be48-74110d6c20c0'),('2025-12-06 10:25:04.871720','2025-12-06 10:26:08.977558','2025-12-06 10:26:15.120057',210,210,NULL,'4f1f5483827f4daa9804cdd5878693f5','snapshots',0,0,NULL,'3df796e1-2d8e-44d3-be48-74110d6c20c0'),('2025-12-06 10:25:45.043459','2025-12-06 10:25:55.501673','2025-12-06 10:25:58.593005',211,211,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','gigabytes',0,0,NULL,NULL),('2025-12-06 10:25:45.045406','2025-12-06 10:25:55.501675','2025-12-06 10:25:58.593005',212,212,'3a7c1829dee74bcaa01c628d9c15cb47','cfab9f6ecb0942eb87922e66a206941b','shares',0,0,NULL,NULL),('2025-12-06 10:25:45.056275','2025-12-06 10:25:52.299752','2025-12-06 10:25:58.648102',213,213,NULL,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',0,0,NULL,'74b08975-f556-437d-99a1-7053f1cc7f84'),('2025-12-06 10:25:45.058425','2025-12-06 10:25:52.299754','2025-12-06 10:25:58.648102',214,214,NULL,'cfab9f6ecb0942eb87922e66a206941b','shares',0,0,NULL,'74b08975-f556-437d-99a1-7053f1cc7f84'),('2025-12-06 10:25:48.544780','2025-12-06 10:25:55.501677','2025-12-06 10:25:58.648102',215,215,NULL,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',0,0,NULL,'b38c356d-96eb-4ed8-907d-f4cdda902d60'),('2025-12-06 10:25:48.547314','2025-12-06 10:25:55.501678','2025-12-06 10:25:58.648102',216,216,NULL,'cfab9f6ecb0942eb87922e66a206941b','shares',0,0,NULL,'b38c356d-96eb-4ed8-907d-f4cdda902d60'),('2025-12-06 10:25:53.580705','2025-12-06 10:25:54.829926',NULL,0,217,'baa2031d15144fd08c0077ef0c165e0f','612b3a88a6734a8ca75d6487b5c72e99','share_networks',0,0,NULL,NULL),('2025-12-06 10:26:03.381822','2025-12-06 10:26:29.296940',NULL,0,218,'de610ccf2ab343a3a1db4928a3b456ee','78b260c5e2fa4b149862a3b0de1864dd','gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:03.386780','2025-12-06 10:26:29.296943',NULL,0,219,'de610ccf2ab343a3a1db4928a3b456ee','78b260c5e2fa4b149862a3b0de1864dd','shares',0,0,NULL,NULL),('2025-12-06 10:26:03.408218','2025-12-06 10:26:29.296944','2025-12-06 10:26:32.160368',220,220,NULL,'78b260c5e2fa4b149862a3b0de1864dd','gigabytes',0,0,NULL,'fbfc7461-6ad4-4728-956a-0e995aaed7a3'),('2025-12-06 10:26:03.410691','2025-12-06 10:26:29.296945','2025-12-06 10:26:32.160368',221,221,NULL,'78b260c5e2fa4b149862a3b0de1864dd','shares',0,0,NULL,'fbfc7461-6ad4-4728-956a-0e995aaed7a3'),('2025-12-06 10:26:12.448459','2025-12-06 10:26:13.617305',NULL,0,222,'880469815a2f4b0a98d15748fa8ed589','597416732a214f16b963a9e4c4769751','share_networks',0,0,NULL,NULL),('2025-12-06 10:26:12.757302','2025-12-06 10:26:12.790169',NULL,0,223,'3e3a2f12e9f74c18b91c9537fe5133ce','ae047d67660940bdad2b998653a87d40','share_networks',1,0,NULL,NULL),('2025-12-06 10:26:18.862729','2025-12-06 10:26:41.180022',NULL,0,224,'5ca728d6529f46e8b51f583ca022b800','e0991b50d433489b9122b5c71fdb2883','gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:18.866033','2025-12-06 10:26:41.180026',NULL,0,225,'5ca728d6529f46e8b51f583ca022b800','e0991b50d433489b9122b5c71fdb2883','shares',0,0,NULL,NULL),('2025-12-06 10:26:18.877751','2025-12-06 10:26:41.180027','2025-12-06 10:26:43.145936',226,226,NULL,'e0991b50d433489b9122b5c71fdb2883','gigabytes',0,0,NULL,'1dd86e7d-7678-4485-9853-d6395ef1acae'),('2025-12-06 10:26:18.880212','2025-12-06 10:26:41.180029','2025-12-06 10:26:43.145936',227,227,NULL,'e0991b50d433489b9122b5c71fdb2883','shares',0,0,NULL,'1dd86e7d-7678-4485-9853-d6395ef1acae'),('2025-12-06 10:26:29.944965','2025-12-06 10:29:35.861685',NULL,0,228,'9106f9610df246458272a7586c704608','8223febae67d4b58a139c7a23382ebf9','gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:29.949234','2025-12-06 10:29:35.861688',NULL,0,229,'9106f9610df246458272a7586c704608','8223febae67d4b58a139c7a23382ebf9','shares',0,0,NULL,NULL),('2025-12-06 10:26:29.965398','2025-12-06 10:29:35.861690','2025-12-06 10:29:38.728095',230,230,NULL,'8223febae67d4b58a139c7a23382ebf9','gigabytes',0,0,NULL,'680222cf-7bb8-4a1b-b125-c3858504e2dc'),('2025-12-06 10:26:29.970281','2025-12-06 10:29:35.861692','2025-12-06 10:29:38.728095',231,231,NULL,'8223febae67d4b58a139c7a23382ebf9','shares',0,0,NULL,'680222cf-7bb8-4a1b-b125-c3858504e2dc'),('2025-12-06 10:26:40.282894','2025-12-06 10:26:51.248366',NULL,0,232,'f8b11dcaa4514416a8807183407a59b8','31903d59544d41839f04a80bef220b94','gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:40.285215','2025-12-06 10:26:51.248370',NULL,0,233,'f8b11dcaa4514416a8807183407a59b8','31903d59544d41839f04a80bef220b94','shares',0,0,NULL,NULL),('2025-12-06 10:26:40.297204','2025-12-06 10:26:51.248372','2025-12-06 10:26:54.154596',234,234,NULL,'31903d59544d41839f04a80bef220b94','gigabytes',0,0,NULL,'bf96a8ba-3f41-41c1-bab0-0fec7f8ab7d2'),('2025-12-06 10:26:40.299935','2025-12-06 10:26:51.248374','2025-12-06 10:26:54.154596',235,235,NULL,'31903d59544d41839f04a80bef220b94','shares',0,0,NULL,'bf96a8ba-3f41-41c1-bab0-0fec7f8ab7d2'),('2025-12-06 10:26:43.571043','2025-12-06 10:26:48.097018',NULL,0,236,'f8b11dcaa4514416a8807183407a59b8','31903d59544d41839f04a80bef220b94','snapshots',0,0,NULL,NULL),('2025-12-06 10:26:43.572961','2025-12-06 10:26:48.097020',NULL,0,237,'f8b11dcaa4514416a8807183407a59b8','31903d59544d41839f04a80bef220b94','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:43.580835','2025-12-06 10:26:48.097021','2025-12-06 10:26:54.154596',238,238,NULL,'31903d59544d41839f04a80bef220b94','snapshots',0,0,NULL,'bf96a8ba-3f41-41c1-bab0-0fec7f8ab7d2'),('2025-12-06 10:26:43.582653','2025-12-06 10:26:48.097023','2025-12-06 10:26:54.154596',239,239,NULL,'31903d59544d41839f04a80bef220b94','snapshot_gigabytes',0,0,NULL,'bf96a8ba-3f41-41c1-bab0-0fec7f8ab7d2'),('2025-12-06 10:26:58.627781','2025-12-06 10:27:09.210220',NULL,0,240,'56a13b1a872444f1b6bded2d3982f5db','533cded34fff443982807cbe5efb88ee','gigabytes',0,0,NULL,NULL),('2025-12-06 10:26:58.630543','2025-12-06 10:27:09.210223',NULL,0,241,'56a13b1a872444f1b6bded2d3982f5db','533cded34fff443982807cbe5efb88ee','shares',0,0,NULL,NULL),('2025-12-06 10:26:58.643356','2025-12-06 10:27:09.210224','2025-12-06 10:27:19.057119',242,242,NULL,'533cded34fff443982807cbe5efb88ee','gigabytes',0,0,NULL,'3dcdf25b-d115-489f-b50d-65505d4d5489'),('2025-12-06 10:26:58.645857','2025-12-06 10:27:09.210225','2025-12-06 10:27:19.057119',243,243,NULL,'533cded34fff443982807cbe5efb88ee','shares',0,0,NULL,'3dcdf25b-d115-489f-b50d-65505d4d5489'),('2025-12-06 10:27:01.634868','2025-12-06 10:27:25.786420',NULL,0,244,'0f53e8d43faa41619104a62141238710','29b7fcfbecd9491eb79bd53cef7c0fc3','shares',0,0,NULL,NULL),('2025-12-06 10:27:01.636616','2025-12-06 10:27:25.786422',NULL,0,245,'0f53e8d43faa41619104a62141238710','29b7fcfbecd9491eb79bd53cef7c0fc3','gigabytes',0,0,NULL,NULL),('2025-12-06 10:27:01.644617','2025-12-06 10:27:25.786424','2025-12-06 10:27:28.679707',246,246,NULL,'29b7fcfbecd9491eb79bd53cef7c0fc3','shares',0,0,NULL,'d01b1fa8-19bd-48de-bb61-f7db267c7e7f'),('2025-12-06 10:27:01.646404','2025-12-06 10:27:25.786425','2025-12-06 10:27:28.679707',247,247,NULL,'29b7fcfbecd9491eb79bd53cef7c0fc3','gigabytes',0,0,NULL,'d01b1fa8-19bd-48de-bb61-f7db267c7e7f'),('2025-12-06 10:27:02.079447','2025-12-06 10:27:15.801909',NULL,0,248,'0662543ae30b4000b9078e91a6142770','5965f7cc0f9b47f4a2901af990e670b4','gigabytes',0,0,NULL,NULL),('2025-12-06 10:27:02.085649','2025-12-06 10:27:15.801912',NULL,0,249,'0662543ae30b4000b9078e91a6142770','5965f7cc0f9b47f4a2901af990e670b4','shares',0,0,NULL,NULL),('2025-12-06 10:27:02.097333','2025-12-06 10:27:15.801914','2025-12-06 10:27:19.057119',250,250,NULL,'5965f7cc0f9b47f4a2901af990e670b4','gigabytes',0,0,NULL,'3dcdf25b-d115-489f-b50d-65505d4d5489'),('2025-12-06 10:27:02.099680','2025-12-06 10:27:15.801915','2025-12-06 10:27:19.057119',251,251,NULL,'5965f7cc0f9b47f4a2901af990e670b4','shares',0,0,NULL,'3dcdf25b-d115-489f-b50d-65505d4d5489'),('2025-12-06 10:27:04.921317','2025-12-06 10:27:22.682029',NULL,0,252,'0f53e8d43faa41619104a62141238710','29b7fcfbecd9491eb79bd53cef7c0fc3','snapshots',0,0,NULL,NULL),('2025-12-06 10:27:04.923423','2025-12-06 10:27:22.682032',NULL,0,253,'0f53e8d43faa41619104a62141238710','29b7fcfbecd9491eb79bd53cef7c0fc3','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:27:04.934563','2025-12-06 10:27:22.682034','2025-12-06 10:27:28.679707',254,254,NULL,'29b7fcfbecd9491eb79bd53cef7c0fc3','snapshots',0,0,NULL,'d01b1fa8-19bd-48de-bb61-f7db267c7e7f'),('2025-12-06 10:27:04.936552','2025-12-06 10:27:22.682035','2025-12-06 10:27:28.679707',255,255,NULL,'29b7fcfbecd9491eb79bd53cef7c0fc3','snapshot_gigabytes',0,0,NULL,'d01b1fa8-19bd-48de-bb61-f7db267c7e7f'),('2025-12-06 10:27:26.600610','2025-12-06 10:28:28.093601',NULL,0,256,'2b4d5b0fd17445b58e52baf66c4955ef','407388521bb04f21b3ced239438a361c','gigabytes',0,0,NULL,NULL),('2025-12-06 10:27:26.605865','2025-12-06 10:28:28.093605',NULL,0,257,'2b4d5b0fd17445b58e52baf66c4955ef','407388521bb04f21b3ced239438a361c','shares',0,0,NULL,NULL),('2025-12-06 10:27:26.632593','2025-12-06 10:28:28.093607','2025-12-06 10:28:31.065261',258,258,NULL,'407388521bb04f21b3ced239438a361c','gigabytes',0,0,NULL,'c989b633-8422-4ce5-b49a-8d0357b5d427'),('2025-12-06 10:27:26.636929','2025-12-06 10:28:28.093609','2025-12-06 10:28:31.065261',259,259,NULL,'407388521bb04f21b3ced239438a361c','shares',0,0,NULL,'c989b633-8422-4ce5-b49a-8d0357b5d427'),('2025-12-06 10:29:18.448154','2025-12-06 10:29:32.573826',NULL,0,260,'0b08b9bfa12a45ca9b27018023d40949','8223febae67d4b58a139c7a23382ebf9','gigabytes',0,0,NULL,NULL),('2025-12-06 10:29:18.450923','2025-12-06 10:29:32.573827',NULL,0,261,'0b08b9bfa12a45ca9b27018023d40949','8223febae67d4b58a139c7a23382ebf9','shares',0,0,NULL,NULL),('2025-12-06 10:29:57.888411','2025-12-06 10:30:08.833691',NULL,0,262,'1cb2c497776e49bf8bc79ad120335fa3','239678b35fcf49e4ae923494b68dbb72','gigabytes',0,0,NULL,NULL),('2025-12-06 10:29:57.890240','2025-12-06 10:30:08.833694',NULL,0,263,'1cb2c497776e49bf8bc79ad120335fa3','239678b35fcf49e4ae923494b68dbb72','shares',0,0,NULL,NULL),('2025-12-06 10:29:57.900966','2025-12-06 10:30:08.833695','2025-12-06 10:30:11.696279',264,264,NULL,'239678b35fcf49e4ae923494b68dbb72','gigabytes',0,0,NULL,'a0e52eab-b0c9-40ad-87c3-3b367b1b6ef4'),('2025-12-06 10:29:57.903443','2025-12-06 10:30:08.833696','2025-12-06 10:30:11.696279',265,265,NULL,'239678b35fcf49e4ae923494b68dbb72','shares',0,0,NULL,'a0e52eab-b0c9-40ad-87c3-3b367b1b6ef4'),('2025-12-06 10:30:01.168070','2025-12-06 10:30:05.514011',NULL,0,266,'1cb2c497776e49bf8bc79ad120335fa3','239678b35fcf49e4ae923494b68dbb72','snapshots',0,0,NULL,NULL),('2025-12-06 10:30:01.170689','2025-12-06 10:30:05.514013',NULL,0,267,'1cb2c497776e49bf8bc79ad120335fa3','239678b35fcf49e4ae923494b68dbb72','snapshot_gigabytes',0,0,NULL,NULL),('2025-12-06 10:30:01.180180','2025-12-06 10:30:05.514015','2025-12-06 10:30:11.696279',268,268,NULL,'239678b35fcf49e4ae923494b68dbb72','snapshots',0,0,NULL,'a0e52eab-b0c9-40ad-87c3-3b367b1b6ef4'),('2025-12-06 10:30:01.182013','2025-12-06 10:30:05.514016','2025-12-06 10:30:11.696279',269,269,NULL,'239678b35fcf49e4ae923494b68dbb72','snapshot_gigabytes',0,0,NULL,'a0e52eab-b0c9-40ad-87c3-3b367b1b6ef4');
/*!40000 ALTER TABLE `quota_usages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotas`
--

DROP TABLE IF EXISTS `quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `quotas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) NOT NULL,
  `hard_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotas`
--

LOCK TABLES `quotas` WRITE;
/*!40000 ALTER TABLE `quotas` DISABLE KEYS */;
INSERT INTO `quotas` (`id`, `created_at`, `updated_at`, `deleted_at`, `deleted`, `project_id`, `resource`, `hard_limit`) VALUES (1,'2025-12-06 10:20:25.703775',NULL,'2025-12-06 10:20:25.773380',1,'cac28ee51926445e98b064ed4d5f28d2','shares',1),(2,'2025-12-06 10:20:29.329873',NULL,'2025-12-06 10:20:32.924132',2,'cac28ee51926445e98b064ed4d5f28d2','snapshots',1),(3,'2025-12-06 10:20:35.348439',NULL,'2025-12-06 10:20:35.505453',3,'cac28ee51926445e98b064ed4d5f28d2','shares',10),(4,'2025-12-06 10:20:35.591565',NULL,'2025-12-06 10:20:35.682230',4,'cac28ee51926445e98b064ed4d5f28d2','shares',10),(5,'2025-12-06 10:25:44.674982',NULL,'2025-12-06 10:25:58.635868',5,'cfab9f6ecb0942eb87922e66a206941b','shares',3),(6,'2025-12-06 10:25:44.683862',NULL,'2025-12-06 10:25:58.635868',6,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',10),(7,'2025-12-06 10:25:58.777825',NULL,'2025-12-06 10:25:59.041400',7,'cfab9f6ecb0942eb87922e66a206941b','shares',55),(8,'2025-12-06 10:25:58.783018',NULL,'2025-12-06 10:25:59.041400',8,'cfab9f6ecb0942eb87922e66a206941b','snapshots',55),(9,'2025-12-06 10:25:58.788283',NULL,'2025-12-06 10:25:59.041400',9,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1005),(10,'2025-12-06 10:25:58.793800',NULL,'2025-12-06 10:25:59.041400',10,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1005),(11,'2025-12-06 10:25:58.798881',NULL,'2025-12-06 10:25:59.041400',11,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',105),(12,'2025-12-06 10:25:58.804767',NULL,'2025-12-06 10:25:59.041400',12,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',1005),(13,'2025-12-06 10:25:59.170745',NULL,'2025-12-06 10:25:59.577467',13,'cfab9f6ecb0942eb87922e66a206941b','shares',55),(14,'2025-12-06 10:25:59.175378',NULL,'2025-12-06 10:25:59.577467',14,'cfab9f6ecb0942eb87922e66a206941b','snapshots',55),(15,'2025-12-06 10:25:59.180049',NULL,'2025-12-06 10:25:59.577467',15,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1005),(16,'2025-12-06 10:25:59.184577',NULL,'2025-12-06 10:25:59.577467',16,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1005),(17,'2025-12-06 10:25:59.189245',NULL,'2025-12-06 10:25:59.577467',17,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',105),(18,'2025-12-06 10:25:59.193914',NULL,'2025-12-06 10:25:59.577467',18,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',1005),(19,'2025-12-06 10:25:59.681419',NULL,'2025-12-06 10:25:59.750047',19,'cfab9f6ecb0942eb87922e66a206941b','shares',52),(20,'2025-12-06 10:25:59.687563',NULL,'2025-12-06 10:25:59.750047',20,'cfab9f6ecb0942eb87922e66a206941b','snapshots',52),(21,'2025-12-06 10:25:59.694004',NULL,'2025-12-06 10:25:59.750047',21,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1002),(22,'2025-12-06 10:25:59.698207',NULL,'2025-12-06 10:25:59.750047',22,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1002),(23,'2025-12-06 10:25:59.702961',NULL,'2025-12-06 10:25:59.750047',23,'cfab9f6ecb0942eb87922e66a206941b','share_networks',12),(24,'2025-12-06 10:25:59.715559',NULL,'2025-12-06 10:25:59.750047',24,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',102),(25,'2025-12-06 10:25:59.720533',NULL,'2025-12-06 10:25:59.750047',25,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',1002),(26,'2025-12-06 10:25:59.867283',NULL,'2025-12-06 10:26:00.143792',26,'cfab9f6ecb0942eb87922e66a206941b','shares',13),(27,'2025-12-06 10:26:00.199999',NULL,'2025-12-06 10:26:00.250079',27,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',-1),(28,'2025-12-06 10:26:00.300194',NULL,'2025-12-06 10:26:00.351622',28,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',-1),(29,'2025-12-06 10:26:00.409558',NULL,'2025-12-06 10:26:00.444498',29,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',-1),(30,'2025-12-06 10:26:00.484777',NULL,'2025-12-06 10:26:00.539841',30,'cfab9f6ecb0942eb87922e66a206941b','share_networks',-1),(31,'2025-12-06 10:26:00.636510',NULL,'2025-12-06 10:26:00.677465',31,'cfab9f6ecb0942eb87922e66a206941b','shares',-1),(32,'2025-12-06 10:26:00.725424',NULL,'2025-12-06 10:26:00.784198',32,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',-1),(33,'2025-12-06 10:26:00.850769',NULL,'2025-12-06 10:26:00.899617',33,'cfab9f6ecb0942eb87922e66a206941b','snapshots',-1),(34,'2025-12-06 10:26:03.138761',NULL,'2025-12-06 10:26:03.231702',34,'cfab9f6ecb0942eb87922e66a206941b','shares',10),(35,'2025-12-06 10:26:03.287715',NULL,'2025-12-06 10:26:03.371959',35,'cfab9f6ecb0942eb87922e66a206941b','shares',10),(36,'2025-12-06 10:26:03.447045',NULL,'2025-12-06 10:26:03.477104',36,'cfab9f6ecb0942eb87922e66a206941b','gigabytes',1002),(37,'2025-12-06 10:26:03.544296',NULL,'2025-12-06 10:26:03.565942',37,'cfab9f6ecb0942eb87922e66a206941b','share_networks',12),(38,'2025-12-06 10:26:03.628314',NULL,'2025-12-06 10:26:03.652829',38,'cfab9f6ecb0942eb87922e66a206941b','shares',52),(39,'2025-12-06 10:26:03.728176',NULL,'2025-12-06 10:26:03.750624',39,'cfab9f6ecb0942eb87922e66a206941b','snapshot_gigabytes',1002),(40,'2025-12-06 10:26:03.832849',NULL,'2025-12-06 10:26:03.854562',40,'cfab9f6ecb0942eb87922e66a206941b','snapshots',52),(41,'2025-12-06 10:26:04.024032',NULL,'2025-12-06 10:26:04.049456',41,'cfab9f6ecb0942eb87922e66a206941b','share_replicas',99),(42,'2025-12-06 10:26:04.295091',NULL,'2025-12-06 10:26:04.342353',42,'cfab9f6ecb0942eb87922e66a206941b','replica_gigabytes',999),(43,'2025-12-06 10:26:05.264640',NULL,'2025-12-06 10:26:05.403708',43,'cfab9f6ecb0942eb87922e66a206941b','shares',10),(44,'2025-12-06 10:26:05.479115',NULL,'2025-12-06 10:26:05.622343',44,'cfab9f6ecb0942eb87922e66a206941b','shares',10);
/*!40000 ALTER TABLE `quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reservations` (
  `created_at` datetime(6) DEFAULT NULL,
  `updated_at` datetime(6) DEFAULT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `deleted` int(11) DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) DEFAULT NULL,
  `uuid` varchar(36) NOT NULL,
  `usage_id` int(11) NOT NULL,
  `project_id` varchar(255) DEFAULT NULL,
  `resource` varchar(255) DEFAULT NULL,
  `delta` int(11) NOT NULL,
  `expire` datetime DEFAULT NULL,
  `share_type_id` varchar(36) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `usage_id` (`usage_id`),
  KEY `ix_reservations_project_id` (`project_id`),
  KEY `reservations_deleted_expire_idx` (`deleted`,`expire`),
  CONSTRAINT `reservations_ibfk_1` FOREIGN KEY (`usage_id`) REFERENCES `quota_usages` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=979 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reservations`
--

LOCK TABLES `reservations` WRITE;
/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`created_at`, `updated_at`, `deleted_at`, `deleted`, `id`, `user_id`, `uuid`, `usage_id`, `project_id`, `resource`, `delta`, `expire`, `share_type_id`) VALUES ('2025-12-06 10:18:48.580423',NULL,'2025-12-06 10:18:48.621331',1,1,'dd7f280921064e47bdd48fe44756c31e','47687d36-f5d9-45f9-8ec7-35decd2e453f',2,'ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',1,'2025-12-07 10:18:48',NULL),('2025-12-06 10:18:48.582755',NULL,'2025-12-06 10:18:48.621331',2,2,'dd7f280921064e47bdd48fe44756c31e','41745e62-9e22-4e53-b5dd-24bf82acbccf',1,'ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',1,'2025-12-07 10:18:48',NULL),('2025-12-06 10:18:48.594051',NULL,'2025-12-06 10:18:48.621331',3,3,NULL,'51555dd0-3a04-4970-b5da-35a969eec05f',4,'ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',1,'2025-12-07 10:18:48','6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:18:48.595650',NULL,'2025-12-06 10:18:48.621331',4,4,NULL,'0aa5f174-d795-40bf-b0e2-e1adf6b0280a',3,'ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',1,'2025-12-07 10:18:48','6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:18:54.734989',NULL,'2025-12-06 10:18:54.777186',5,5,'dd7f280921064e47bdd48fe44756c31e','ecf0dd9e-a9b8-4a48-94cb-4f83d926edeb',2,'ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',-1,'2025-12-07 10:18:54',NULL),('2025-12-06 10:18:54.737020',NULL,'2025-12-06 10:18:54.777186',6,6,'dd7f280921064e47bdd48fe44756c31e','c5a59953-8e9f-41c4-ab66-92a58fbc9763',1,'ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',-1,'2025-12-07 10:18:54',NULL),('2025-12-06 10:18:54.754809',NULL,'2025-12-06 10:18:54.777186',7,7,NULL,'1000a5b0-2710-45ad-82ca-122be80bb9f2',4,'ebfbf1d74c7b44a2a2e2afea3266b3e6','shares',-1,'2025-12-07 10:18:54','6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:18:54.755879',NULL,'2025-12-06 10:18:54.777186',8,8,NULL,'d7aa7bec-23f6-42e3-8bb2-b9354381f750',3,'ebfbf1d74c7b44a2a2e2afea3266b3e6','gigabytes',-1,'2025-12-07 10:18:54','6506a4cf-af63-452e-82f8-92b9e0a60ffc'),('2025-12-06 10:19:29.533158',NULL,'2025-12-06 10:19:29.583697',9,9,'25eb67fead874d42a56f64bcea2a5914','926cba8b-7f35-4ecf-8521-b2f4898a795e',6,'1ed2dd1e38e94e2fb3db30e196137ff2','shares',1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29.535793',NULL,'2025-12-06 10:19:29.583697',10,10,'25eb67fead874d42a56f64bcea2a5914','71bf3372-f7e0-40a6-97b6-1c5785e12cf5',5,'1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',1,'2025-12-07 10:19:29',NULL),('2025-12-06 10:19:29.554006',NULL,'2025-12-06 10:19:29.583697',11,11,NULL,'b5395944-5eda-4c23-bc97-7a9694ccf31c',8,'1ed2dd1e38e94e2fb3db30e196137ff2','shares',1,'2025-12-07 10:19:29','99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:29.555372',NULL,'2025-12-06 10:19:29.583697',12,12,NULL,'ce144860-1ed4-49d2-8b2e-80468557afda',7,'1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',1,'2025-12-07 10:19:29','99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:34.087736',NULL,'2025-12-06 10:19:34.101734',13,13,'25eb67fead874d42a56f64bcea2a5914','8a113665-949b-4106-ac93-941ebf3c99ea',6,'1ed2dd1e38e94e2fb3db30e196137ff2','shares',-1,'2025-12-07 10:19:34',NULL),('2025-12-06 10:19:34.088646',NULL,'2025-12-06 10:19:34.101734',14,14,'25eb67fead874d42a56f64bcea2a5914','8e2af1f9-a3ea-41c0-a8b2-9c3ffbe2b1ec',5,'1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',-1,'2025-12-07 10:19:34',NULL),('2025-12-06 10:19:34.094594',NULL,'2025-12-06 10:19:34.101734',15,15,NULL,'06c1cd52-8f02-4767-8078-22cb83b67574',8,'1ed2dd1e38e94e2fb3db30e196137ff2','shares',-1,'2025-12-07 10:19:34','99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:34.095287',NULL,'2025-12-06 10:19:34.101734',16,16,NULL,'fcf585a7-ab4e-470f-872b-b81365a3abd5',7,'1ed2dd1e38e94e2fb3db30e196137ff2','gigabytes',-1,'2025-12-07 10:19:34','99a530ec-115d-4f57-800c-2599cac144e3'),('2025-12-06 10:19:36.347956',NULL,'2025-12-06 10:19:36.400968',17,17,'f279325fd6b44b6a9cf19af767a2d096','79948be9-6a64-4b38-b24e-6032f2599803',9,'d694f30d513746329568207534277c9c','shares',1,'2025-12-07 10:19:36',NULL),('2025-12-06 10:19:36.351556',NULL,'2025-12-06 10:19:36.400968',18,18,'f279325fd6b44b6a9cf19af767a2d096','4e064d91-d637-4cbc-8c8e-aff11a2ebf3c',10,'d694f30d513746329568207534277c9c','gigabytes',1,'2025-12-07 10:19:36',NULL),('2025-12-06 10:19:36.372182',NULL,'2025-12-06 10:19:36.400968',19,19,NULL,'a741bf02-78cd-4a9b-b423-12dc714a7ff1',11,'d694f30d513746329568207534277c9c','shares',1,'2025-12-07 10:19:36','fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:36.373714',NULL,'2025-12-06 10:19:36.400968',20,20,NULL,'da6f6041-b70e-4304-8d0e-d38a2011724a',12,'d694f30d513746329568207534277c9c','gigabytes',1,'2025-12-07 10:19:36','fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:41.745203',NULL,'2025-12-06 10:19:41.760571',21,21,'f279325fd6b44b6a9cf19af767a2d096','31557f8f-3028-469e-ac17-eb46414e7d1a',9,'d694f30d513746329568207534277c9c','shares',-1,'2025-12-07 10:19:41',NULL),('2025-12-06 10:19:41.745942',NULL,'2025-12-06 10:19:41.760571',22,22,'f279325fd6b44b6a9cf19af767a2d096','b7926250-487e-4c27-9e56-cadeb1a1d7a2',10,'d694f30d513746329568207534277c9c','gigabytes',-1,'2025-12-07 10:19:41',NULL),('2025-12-06 10:19:41.752229',NULL,'2025-12-06 10:19:41.760571',23,23,NULL,'236b059a-a723-425a-b3d2-e18d6363d042',11,'d694f30d513746329568207534277c9c','shares',-1,'2025-12-07 10:19:41','fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:41.753191',NULL,'2025-12-06 10:19:41.760571',24,24,NULL,'7fc0d7b9-39a1-49ac-8c16-d6c8754e2e93',12,'d694f30d513746329568207534277c9c','gigabytes',-1,'2025-12-07 10:19:41','fad7681f-6fef-463c-a6c5-40718706f3a7'),('2025-12-06 10:19:41.774109',NULL,'2025-12-06 10:19:41.810012',25,25,'ee608c83c95e4f3b89126c0af033542a','4a35da49-2ecc-47f4-b056-716ed98a3e5b',14,'a9be2712a2b242618de73b18ac23adf7','shares',1,'2025-12-07 10:19:41',NULL),('2025-12-06 10:19:41.775797',NULL,'2025-12-06 10:19:41.810012',26,26,'ee608c83c95e4f3b89126c0af033542a','0fda3a11-a4cd-426d-8e44-f3e2b9419ad4',13,'a9be2712a2b242618de73b18ac23adf7','gigabytes',1,'2025-12-07 10:19:41',NULL),('2025-12-06 10:19:41.784444',NULL,'2025-12-06 10:19:41.810012',27,27,NULL,'aedcc092-c55a-447e-8684-9041e92a2354',16,'a9be2712a2b242618de73b18ac23adf7','shares',1,'2025-12-07 10:19:41','3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:41.785434',NULL,'2025-12-06 10:19:41.810012',28,28,NULL,'51ef9213-b84b-4c1b-817b-a2f1c9deac0e',15,'a9be2712a2b242618de73b18ac23adf7','gigabytes',1,'2025-12-07 10:19:41','3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:46.825253',NULL,'2025-12-06 10:19:46.968836',29,29,'ee608c83c95e4f3b89126c0af033542a','7d162e1e-d964-44a0-8890-afc92492899f',14,'a9be2712a2b242618de73b18ac23adf7','shares',-1,'2025-12-07 10:19:46',NULL),('2025-12-06 10:19:46.826105',NULL,'2025-12-06 10:19:46.968836',30,30,'ee608c83c95e4f3b89126c0af033542a','3bb115d9-bd3d-4826-b741-de4772c8a765',13,'a9be2712a2b242618de73b18ac23adf7','gigabytes',-1,'2025-12-07 10:19:46',NULL),('2025-12-06 10:19:46.960526',NULL,'2025-12-06 10:19:46.968836',31,31,NULL,'10e3fb16-b694-4f18-979f-a3e0dee4b29e',16,'a9be2712a2b242618de73b18ac23adf7','shares',-1,'2025-12-07 10:19:46','3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:46.961545',NULL,'2025-12-06 10:19:46.968836',32,32,NULL,'f4c424ef-4824-464d-a04f-1ae8c4b43eb3',15,'a9be2712a2b242618de73b18ac23adf7','gigabytes',-1,'2025-12-07 10:19:46','3028ba27-4ff8-4212-b901-06e28389a1bf'),('2025-12-06 10:19:58.250985',NULL,'2025-12-06 10:19:58.424533',33,33,'a86c73ba3c184e12856a751fad5b546b','8d8fdaf0-797d-40a0-ab8c-a70b8bdac107',18,'e03a3abfa2c441c78a203b763a3125eb','shares',1,'2025-12-07 10:19:58',NULL),('2025-12-06 10:19:58.252756',NULL,'2025-12-06 10:19:58.424533',34,34,'a86c73ba3c184e12856a751fad5b546b','1a1156e4-4c30-4bc5-9492-77f5fc4c6081',17,'e03a3abfa2c441c78a203b763a3125eb','gigabytes',1,'2025-12-07 10:19:58',NULL),('2025-12-06 10:19:58.354509',NULL,'2025-12-06 10:19:58.424533',35,35,NULL,'0a73710e-63e5-4a9f-8be5-a533af074bff',20,'e03a3abfa2c441c78a203b763a3125eb','shares',1,'2025-12-07 10:19:58','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:19:58.356140',NULL,'2025-12-06 10:19:58.424533',36,36,NULL,'e9bd097c-eb9b-41a4-bec6-aac5030b87b6',19,'e03a3abfa2c441c78a203b763a3125eb','gigabytes',1,'2025-12-07 10:19:58','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:02.050396',NULL,'2025-12-06 10:20:02.228533',37,37,'a86c73ba3c184e12856a751fad5b546b','9ea80f86-6061-4764-b49c-1042fc5f617d',21,'e03a3abfa2c441c78a203b763a3125eb','snapshots',1,'2025-12-07 10:20:02',NULL),('2025-12-06 10:20:02.051843',NULL,'2025-12-06 10:20:02.228533',38,38,'a86c73ba3c184e12856a751fad5b546b','446136e6-c459-4c45-b0c6-897f7c3593d7',22,'e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',1,'2025-12-07 10:20:02',NULL),('2025-12-06 10:20:02.065380',NULL,'2025-12-06 10:20:02.228533',39,39,NULL,'2aaeebdf-92f3-429e-bfd7-53496b2267d0',23,'e03a3abfa2c441c78a203b763a3125eb','snapshots',1,'2025-12-07 10:20:02','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:02.066538',NULL,'2025-12-06 10:20:02.228533',40,40,NULL,'2adf4704-e131-4df5-aeb4-8420fd0b2b91',24,'e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',1,'2025-12-07 10:20:02','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:06.410689',NULL,'2025-12-06 10:20:06.430452',41,41,'a86c73ba3c184e12856a751fad5b546b','994c7f9c-ed53-4452-bd7d-56a9433594e0',21,'e03a3abfa2c441c78a203b763a3125eb','snapshots',-1,'2025-12-07 10:20:06',NULL),('2025-12-06 10:20:06.411858',NULL,'2025-12-06 10:20:06.430452',42,42,'a86c73ba3c184e12856a751fad5b546b','202cc77e-697b-461d-bc5d-0d570c22b9bf',22,'e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',-1,'2025-12-07 10:20:06',NULL),('2025-12-06 10:20:06.420777',NULL,'2025-12-06 10:20:06.430452',43,43,NULL,'b7e69b30-dd5d-4e0f-89d2-56659d4e20aa',23,'e03a3abfa2c441c78a203b763a3125eb','snapshots',-1,'2025-12-07 10:20:06','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:06.422542',NULL,'2025-12-06 10:20:06.430452',44,44,NULL,'67c40c5b-2d1e-4e3a-98a1-719e88ecfd62',24,'e03a3abfa2c441c78a203b763a3125eb','snapshot_gigabytes',-1,'2025-12-07 10:20:06','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:09.674164',NULL,'2025-12-06 10:20:09.698289',45,45,'a86c73ba3c184e12856a751fad5b546b','8a6e3f2c-dd19-4e80-95be-4bd260e3fc3d',18,'e03a3abfa2c441c78a203b763a3125eb','shares',-1,'2025-12-07 10:20:09',NULL),('2025-12-06 10:20:09.676601',NULL,'2025-12-06 10:20:09.698289',46,46,'a86c73ba3c184e12856a751fad5b546b','0c18e39c-2fe5-420d-a2c5-a3295eb361a3',17,'e03a3abfa2c441c78a203b763a3125eb','gigabytes',-1,'2025-12-07 10:20:09',NULL),('2025-12-06 10:20:09.686461',NULL,'2025-12-06 10:20:09.698289',47,47,NULL,'bef6bf64-a453-421f-9dce-b36073315d96',20,'e03a3abfa2c441c78a203b763a3125eb','shares',-1,'2025-12-07 10:20:09','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:09.687312',NULL,'2025-12-06 10:20:09.698289',48,48,NULL,'1a5770af-7f9e-4922-a025-28a2b7560952',19,'e03a3abfa2c441c78a203b763a3125eb','gigabytes',-1,'2025-12-07 10:20:09','dbd07c3f-9429-4f56-9777-c8ff28ddd02c'),('2025-12-06 10:20:10.529461',NULL,'2025-12-06 10:20:10.560071',49,49,'3c50d030cbcb4b10861d132adc1813e6','f4ed4397-2e96-401f-aa23-21ff0d42843f',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:10',NULL),('2025-12-06 10:20:10.530618',NULL,'2025-12-06 10:20:10.560071',50,50,'3c50d030cbcb4b10861d132adc1813e6','5f65d97e-4386-4b93-baea-8652c7915b6b',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:10',NULL),('2025-12-06 10:20:10.540669',NULL,'2025-12-06 10:20:10.560071',51,51,NULL,'f84d392a-e232-48c7-af26-7a4f5ea5cde2',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:10','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:10.541792',NULL,'2025-12-06 10:20:10.560071',52,52,NULL,'fac5b7cf-b38b-4b72-badd-24a60c3d2c43',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:10','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:11.520292',NULL,'2025-12-06 10:20:11.562916',53,53,'5bed76562a9c480bbc65c8e3541d13c5','76cbccc2-2928-4da1-a92d-503bb71748a4',30,'ca36e4f4a4714022a89a8f2cf1b30df9','shares',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:11.521791',NULL,'2025-12-06 10:20:11.562916',54,54,'5bed76562a9c480bbc65c8e3541d13c5','eaaa04ac-ff07-43a7-b18d-b73b9fd446fb',29,'ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',1,'2025-12-07 10:20:11',NULL),('2025-12-06 10:20:11.537509',NULL,'2025-12-06 10:20:11.562916',55,55,NULL,'ca2f34d6-222d-40d7-830b-0879646da0c9',32,'ca36e4f4a4714022a89a8f2cf1b30df9','shares',1,'2025-12-07 10:20:11','07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:11.539208',NULL,'2025-12-06 10:20:11.562916',56,56,NULL,'d4246414-1d9c-4ae8-9706-e19d2325e160',31,'ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',1,'2025-12-07 10:20:11','07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:13.808670',NULL,'2025-12-06 10:20:13.836898',57,57,'3c50d030cbcb4b10861d132adc1813e6','a47706ec-7d0a-4296-8e5b-6cea08afb1eb',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:13',NULL),('2025-12-06 10:20:13.809843',NULL,'2025-12-06 10:20:13.836898',58,58,'3c50d030cbcb4b10861d132adc1813e6','782f2a51-f211-4db6-8421-ccf7bc7cb2dd',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:13',NULL),('2025-12-06 10:20:13.815870',NULL,'2025-12-06 10:20:13.836898',59,59,NULL,'d3f27970-1c60-4812-a408-c3317e1c2d6c',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:13','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:13.817015',NULL,'2025-12-06 10:20:13.836898',60,60,NULL,'2d8675b0-b74e-4ad3-98ff-4f6e37d19d8d',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:13','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:18.143981',NULL,'2025-12-06 10:20:18.168908',61,61,'3c50d030cbcb4b10861d132adc1813e6','2335e58b-2552-439e-bb0f-d401d637cd6b',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:18.144918',NULL,'2025-12-06 10:20:18.168908',62,62,'3c50d030cbcb4b10861d132adc1813e6','e4a3506a-2a0f-4d0b-9f17-307ecd11a9b0',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:18',NULL),('2025-12-06 10:20:18.155050',NULL,'2025-12-06 10:20:18.168908',63,63,NULL,'101c1ba9-8014-4b33-a8b9-923a8b18c826',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:18','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:18.157511',NULL,'2025-12-06 10:20:18.168908',64,64,NULL,'bd59abe3-e77f-441b-812a-86f1395db94d',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:18','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:19.097482',NULL,'2025-12-06 10:20:19.117185',65,65,'5bed76562a9c480bbc65c8e3541d13c5','401afa49-98ed-4d04-a6f3-962ff29dc214',30,'ca36e4f4a4714022a89a8f2cf1b30df9','shares',-1,'2025-12-07 10:20:19',NULL),('2025-12-06 10:20:19.098440',NULL,'2025-12-06 10:20:19.117185',66,66,'5bed76562a9c480bbc65c8e3541d13c5','c3d5e2ca-817e-4d81-a1ad-b451646caf24',29,'ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',-1,'2025-12-07 10:20:19',NULL),('2025-12-06 10:20:19.106171',NULL,'2025-12-06 10:20:19.117185',67,67,NULL,'ae3728b6-b4d8-462d-be1c-c61d9bb16ca2',32,'ca36e4f4a4714022a89a8f2cf1b30df9','shares',-1,'2025-12-07 10:20:19','07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:19.107227',NULL,'2025-12-06 10:20:19.117185',68,68,NULL,'b5f1c151-573a-43cf-aff0-2624af66936a',31,'ca36e4f4a4714022a89a8f2cf1b30df9','gigabytes',-1,'2025-12-07 10:20:19','07d426d7-4908-4929-9eb3-f5e174f085c3'),('2025-12-06 10:20:20.893694',NULL,'2025-12-06 10:20:20.930215',69,69,'3c50d030cbcb4b10861d132adc1813e6','dcf95d57-e2ce-4e82-8378-df0a4971e94e',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:20.895151',NULL,'2025-12-06 10:20:20.930215',70,70,'3c50d030cbcb4b10861d132adc1813e6','8a8f9b6f-ed5e-4ffa-867d-339ef8fd0718',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:20',NULL),('2025-12-06 10:20:20.901386',NULL,'2025-12-06 10:20:20.930215',71,71,NULL,'c705112b-e92f-4124-bbaa-568c01a46dcc',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:20','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:20.902662',NULL,'2025-12-06 10:20:20.930215',72,72,NULL,'6cf39b1b-7e59-4e6f-8bdb-715e7e95b395',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:20','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:22.502508',NULL,'2025-12-06 10:20:22.546962',73,73,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','34347ad4-2b07-4ecb-a498-7e772a6ada8e',34,'cac28ee51926445e98b064ed4d5f28d2','shares',1,'2025-12-07 10:20:22',NULL),('2025-12-06 10:20:22.504173',NULL,'2025-12-06 10:20:22.546962',74,74,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','fa095dd6-4123-47df-9f34-453dcd42cab9',33,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,'2025-12-07 10:20:22',NULL),('2025-12-06 10:20:22.519170',NULL,'2025-12-06 10:20:22.546962',75,75,NULL,'95088675-1878-4cf2-9172-25907d5f0ca4',36,'cac28ee51926445e98b064ed4d5f28d2','shares',1,'2025-12-07 10:20:22','ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:22.523069',NULL,'2025-12-06 10:20:22.546962',76,76,NULL,'2ae5d6ed-d047-44a1-8392-2b524c9682cf',35,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,'2025-12-07 10:20:22','ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:25.964404',NULL,'2025-12-06 10:20:25.981751',77,77,'3c50d030cbcb4b10861d132adc1813e6','498cd145-2bc2-487d-960e-18e73c499fe8',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:25.965171',NULL,'2025-12-06 10:20:25.981751',78,78,'3c50d030cbcb4b10861d132adc1813e6','1d8c5129-383d-479d-b15c-4f9fc22492b3',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:25.972032',NULL,'2025-12-06 10:20:25.981751',79,79,NULL,'6bc91fac-4f03-4c41-8e07-188ec4a2f873',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:25','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:25.972686',NULL,'2025-12-06 10:20:25.981751',80,80,NULL,'9c3aa755-46a7-497f-9b10-febb3b6bff52',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:25','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:26.043850',NULL,'2025-12-06 10:20:26.104243',81,81,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','2080081c-b2e1-40cd-8272-e56cd86ef665',38,'cac28ee51926445e98b064ed4d5f28d2','shares',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:26.045150',NULL,'2025-12-06 10:20:26.104243',82,82,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','0b2e1510-a108-4666-b831-cef8ebf7717d',37,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,'2025-12-07 10:20:25',NULL),('2025-12-06 10:20:26.073310',NULL,'2025-12-06 10:20:26.104243',83,83,NULL,'1ac49766-6290-465d-8efd-65c01c678be0',40,'cac28ee51926445e98b064ed4d5f28d2','shares',1,'2025-12-07 10:20:25','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:26.074839',NULL,'2025-12-06 10:20:26.104243',84,84,NULL,'e2155d25-0e5c-4573-8f65-5ee3bd409f3e',39,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',1,'2025-12-07 10:20:25','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:26.189719',NULL,'2025-12-06 10:20:26.242031',85,85,'e79d3d9ca9844cf7a820fed66615a837','3b7d965e-664e-4726-b240-02b73c3c8665',42,'88ea8626c7df4b62bf7459a615217eeb','shares',1,'2025-12-07 10:20:26',NULL),('2025-12-06 10:20:26.191055',NULL,'2025-12-06 10:20:26.242031',86,86,'e79d3d9ca9844cf7a820fed66615a837','46b6b034-ac14-4dc9-b649-bad3855a06ce',41,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',1,'2025-12-07 10:20:26',NULL),('2025-12-06 10:20:26.209952',NULL,'2025-12-06 10:20:26.242031',87,87,NULL,'c4c73dd1-c268-4941-a258-c315a4c3f5f9',44,'88ea8626c7df4b62bf7459a615217eeb','shares',1,'2025-12-07 10:20:26','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:26.211673',NULL,'2025-12-06 10:20:26.242031',88,88,NULL,'290adfb1-0472-4acc-9f4a-bc8a1c846c19',43,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',1,'2025-12-07 10:20:26','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:28.853162',NULL,'2025-12-06 10:20:28.898204',89,89,'3c50d030cbcb4b10861d132adc1813e6','0119902e-e4b7-4c06-9941-468dad396efc',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:28',NULL),('2025-12-06 10:20:28.856649',NULL,'2025-12-06 10:20:28.898204',90,90,'3c50d030cbcb4b10861d132adc1813e6','bdc6ed95-f408-48c4-951d-7b93448d3d33',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:28',NULL),('2025-12-06 10:20:28.864634',NULL,'2025-12-06 10:20:28.898204',91,91,NULL,'e0c0bd7f-c1db-4f1d-a0a2-40ff9a78d4ae',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:28','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:28.866136',NULL,'2025-12-06 10:20:28.898204',92,92,NULL,'a75fd761-3a91-427a-b5e8-ed479c157131',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:28','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:29.498459',NULL,'2025-12-06 10:20:29.608195',93,93,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','fc71a93a-9598-42de-b716-34c6c4e0c482',46,'cac28ee51926445e98b064ed4d5f28d2','snapshots',1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29.504815',NULL,'2025-12-06 10:20:29.608195',94,94,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','d431dd89-dad6-4ebd-a612-c09c7905d05c',45,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29.528016',NULL,'2025-12-06 10:20:29.608195',95,95,NULL,'0dea16d2-c68d-45b3-a626-49f6aff12ed6',48,'cac28ee51926445e98b064ed4d5f28d2','snapshots',1,'2025-12-07 10:20:29','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:29.529511',NULL,'2025-12-06 10:20:29.608195',96,96,NULL,'49f984f9-5b4e-475f-8f6d-c233bd6bdda7',47,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',1,'2025-12-07 10:20:29','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:29.560108',NULL,'2025-12-06 10:20:29.652988',97,97,'e79d3d9ca9844cf7a820fed66615a837','62cea3fc-130e-441a-9698-b18c8002ff39',49,'88ea8626c7df4b62bf7459a615217eeb','snapshots',1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29.563074',NULL,'2025-12-06 10:20:29.652988',98,98,'e79d3d9ca9844cf7a820fed66615a837','c1f5e768-6922-4559-bde3-50827bba37e3',50,'88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',1,'2025-12-07 10:20:29',NULL),('2025-12-06 10:20:29.574232',NULL,'2025-12-06 10:20:29.652988',99,99,NULL,'c59efd33-9cbd-463c-af7b-b8791a265276',51,'88ea8626c7df4b62bf7459a615217eeb','snapshots',1,'2025-12-07 10:20:29','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:29.575773',NULL,'2025-12-06 10:20:29.652988',100,100,NULL,'288287a8-2e13-44a0-bff8-a6a39e77346f',52,'88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',1,'2025-12-07 10:20:29','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:32.580758',NULL,'2025-12-06 10:20:32.595960',101,101,'3c50d030cbcb4b10861d132adc1813e6','23d92a9d-a589-407d-98a2-e0c9df1528fa',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:32',NULL),('2025-12-06 10:20:32.581611',NULL,'2025-12-06 10:20:32.595960',102,102,'3c50d030cbcb4b10861d132adc1813e6','616a1dfd-139f-447a-be4f-54a42a40b77e',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:32',NULL),('2025-12-06 10:20:32.587503',NULL,'2025-12-06 10:20:32.595960',103,103,NULL,'104137ac-130e-42b1-aefa-5309146d41f9',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:32','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:32.588281',NULL,'2025-12-06 10:20:32.595960',104,104,NULL,'7122f446-ebca-425f-a732-d5dc5a9c9826',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:32','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:32.949647',NULL,'2025-12-06 10:20:32.980363',105,105,'e79d3d9ca9844cf7a820fed66615a837','9d0f9401-df5e-4699-8b3e-fba36522864d',42,'88ea8626c7df4b62bf7459a615217eeb','shares',1,'2025-12-07 10:20:32',NULL),('2025-12-06 10:20:32.951068',NULL,'2025-12-06 10:20:32.980363',106,106,'e79d3d9ca9844cf7a820fed66615a837','df38ee3e-76a6-4c50-8251-fca130ce3de5',41,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',1,'2025-12-07 10:20:32',NULL),('2025-12-06 10:20:32.957393',NULL,'2025-12-06 10:20:32.980363',107,107,NULL,'aac5f29e-2b2c-4433-be30-cc17d61f5146',44,'88ea8626c7df4b62bf7459a615217eeb','shares',1,'2025-12-07 10:20:32','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:32.958849',NULL,'2025-12-06 10:20:32.980363',108,108,NULL,'fdf6a7f9-0d63-4075-ae12-430c8da7017a',43,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',1,'2025-12-07 10:20:32','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:20:35.497036',NULL,'2025-12-06 10:20:35.534743',109,109,'3c50d030cbcb4b10861d132adc1813e6','3ccc6819-8151-421b-9346-e3f64e3d1f83',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:35',NULL),('2025-12-06 10:20:35.498965',NULL,'2025-12-06 10:20:35.534743',110,110,'3c50d030cbcb4b10861d132adc1813e6','5dda8250-944d-424c-be03-f97996c09172',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:35',NULL),('2025-12-06 10:20:35.507790',NULL,'2025-12-06 10:20:35.534743',111,111,NULL,'048841c7-f659-4d31-9f9c-1a3f19e94690',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:35','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:35.509206',NULL,'2025-12-06 10:20:35.534743',112,112,NULL,'2c81859d-9751-473c-a05c-6f5ea89dba54',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:35','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:36.806443',NULL,'2025-12-06 10:20:36.828162',113,113,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','51185fce-3688-4c8f-b15f-1c2efe9da853',53,'cac28ee51926445e98b064ed4d5f28d2','snapshots',-1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:36.807317',NULL,'2025-12-06 10:20:36.828162',114,114,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','15978405-045f-48c2-8a69-e91826f9ad87',54,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',-1,'2025-12-07 10:20:36',NULL),('2025-12-06 10:20:36.818199',NULL,'2025-12-06 10:20:36.828162',115,115,NULL,'90ca479a-d4a9-4d0e-b017-32e332b4ffdc',55,'cac28ee51926445e98b064ed4d5f28d2','snapshots',-1,'2025-12-07 10:20:36','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:36.819068',NULL,'2025-12-06 10:20:36.828162',116,116,NULL,'bcb39531-be5a-47d6-b46b-f75e87f3587e',56,'cac28ee51926445e98b064ed4d5f28d2','snapshot_gigabytes',-1,'2025-12-07 10:20:36','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:40.016823',NULL,'2025-12-06 10:20:40.252510',117,117,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','7bdbdd6d-5e3a-4c9c-bb27-4721eb80690f',57,'cac28ee51926445e98b064ed4d5f28d2','shares',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:40.017698',NULL,'2025-12-06 10:20:40.252510',118,118,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','31df3fac-4f3f-44d1-b8b3-c230a241200e',58,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',-1,'2025-12-07 10:20:39',NULL),('2025-12-06 10:20:40.084719',NULL,'2025-12-06 10:20:40.252510',119,119,NULL,'6c1ba618-873c-4354-afc7-d6eae7564e59',59,'cac28ee51926445e98b064ed4d5f28d2','shares',-1,'2025-12-07 10:20:39','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:40.087728',NULL,'2025-12-06 10:20:40.252510',120,120,NULL,'e426a885-4691-4305-b596-244dc927baf5',60,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',-1,'2025-12-07 10:20:39','ae43ba57-a792-4011-a9dc-210f1edfe1a3'),('2025-12-06 10:20:40.652907',NULL,'2025-12-06 10:20:40.667204',121,121,'3c50d030cbcb4b10861d132adc1813e6','3e411672-abf2-4a84-90bc-568b2fb322a3',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:40',NULL),('2025-12-06 10:20:40.653669',NULL,'2025-12-06 10:20:40.667204',122,122,'3c50d030cbcb4b10861d132adc1813e6','5a3966cd-c43b-4c87-89ff-6af48cec1f4e',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:40',NULL),('2025-12-06 10:20:40.659906',NULL,'2025-12-06 10:20:40.667204',123,123,NULL,'468cb49b-5fb0-4be9-83f8-788537057b67',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:40','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:40.660659',NULL,'2025-12-06 10:20:40.667204',124,124,NULL,'3b83cd63-4efc-496b-9394-95143e60030c',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:40','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:43.374679',NULL,'2025-12-06 10:20:43.405821',125,125,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','c41d59b4-0263-479e-ab9f-1191bbd0aa8f',57,'cac28ee51926445e98b064ed4d5f28d2','shares',-1,'2025-12-07 10:20:43',NULL),('2025-12-06 10:20:43.376248',NULL,'2025-12-06 10:20:43.405821',126,126,'ba38c7f9e7104c6aae5f8c0c0efbcbbb','8f049d2e-b614-4413-b765-bb94057793f5',58,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',-1,'2025-12-07 10:20:43',NULL),('2025-12-06 10:20:43.397716',NULL,'2025-12-06 10:20:43.405821',127,127,NULL,'9e0ee7e1-08eb-49ab-87e6-cbe842bd1e61',61,'cac28ee51926445e98b064ed4d5f28d2','shares',-1,'2025-12-07 10:20:43','ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:43.398333',NULL,'2025-12-06 10:20:43.405821',128,128,NULL,'f7b7f89b-4526-4c5f-8eef-ff785d8689dc',62,'cac28ee51926445e98b064ed4d5f28d2','gigabytes',-1,'2025-12-07 10:20:43','ac003284-2d78-4a61-ac40-104bb626f7ba'),('2025-12-06 10:20:44.410323',NULL,'2025-12-06 10:20:44.450550',129,129,'3c50d030cbcb4b10861d132adc1813e6','0327bc74-4c3e-42a8-9b9b-691142b18593',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:44',NULL),('2025-12-06 10:20:44.412660',NULL,'2025-12-06 10:20:44.450550',130,130,'3c50d030cbcb4b10861d132adc1813e6','6c4e0eb2-8386-4370-a962-189d9c90f693',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:44',NULL),('2025-12-06 10:20:44.420921',NULL,'2025-12-06 10:20:44.450550',131,131,NULL,'9228822d-af29-43e9-b69a-247f4fab2e41',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',1,'2025-12-07 10:20:44','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:44.424119',NULL,'2025-12-06 10:20:44.450550',132,132,NULL,'a9015b5e-766e-4265-959b-5381e3a66db8',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',1,'2025-12-07 10:20:44','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:49.155787',NULL,'2025-12-06 10:20:49.174139',133,133,'3c50d030cbcb4b10861d132adc1813e6','a36445c4-6966-4b12-ade0-5f4a8fb152db',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:49',NULL),('2025-12-06 10:20:49.156417',NULL,'2025-12-06 10:20:49.174139',134,134,'3c50d030cbcb4b10861d132adc1813e6','a26d690a-9523-4a8d-b2db-146d11c4ca6c',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:49',NULL),('2025-12-06 10:20:49.163052',NULL,'2025-12-06 10:20:49.174139',135,135,NULL,'fe779c7c-290d-4320-8456-af9bc3a932f6',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:49','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:49.163819',NULL,'2025-12-06 10:20:49.174139',136,136,NULL,'038176cc-f22f-45b8-855c-cedb68a68862',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:49','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:53.947164',NULL,'2025-12-06 10:20:53.974932',137,137,'3c50d030cbcb4b10861d132adc1813e6','f6502b8c-1637-420f-b3e7-1be7eadaf26b',26,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:53',NULL),('2025-12-06 10:20:53.948891',NULL,'2025-12-06 10:20:53.974932',138,138,'3c50d030cbcb4b10861d132adc1813e6','0d3ad564-7dee-4a24-9284-24c1a0bf3131',25,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:53',NULL),('2025-12-06 10:20:53.960281',NULL,'2025-12-06 10:20:53.974932',139,139,NULL,'8c6d2b08-0c88-42da-9ba4-f152e07d9bbe',28,'c4a2fd17baa14963bf4a9820b2615c0b','shares',-1,'2025-12-07 10:20:53','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:20:53.961684',NULL,'2025-12-06 10:20:53.974932',140,140,NULL,'ec30833b-c444-473a-b0f5-9401e9443c0b',27,'c4a2fd17baa14963bf4a9820b2615c0b','gigabytes',-1,'2025-12-07 10:20:53','c51cdb03-0377-41fb-9fcd-b75eb7140b83'),('2025-12-06 10:21:06.091049',NULL,'2025-12-06 10:21:06.180906',141,141,'3e4c3243bf5c4e3a9a62ce06cde13e3d','d274bb6e-64c9-4358-b28c-ea6d19aef1ac',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',1,'2025-12-07 10:21:06',NULL),('2025-12-06 10:21:06.727541',NULL,'2025-12-06 10:21:06.733224',142,142,'3e4c3243bf5c4e3a9a62ce06cde13e3d','5c8bfb8d-6c85-4103-867a-00e115ec441d',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',-1,'2025-12-07 10:21:06',NULL),('2025-12-06 10:21:06.941732',NULL,'2025-12-06 10:21:07.007863',143,143,'3e4c3243bf5c4e3a9a62ce06cde13e3d','71369251-5cf9-4f26-8ded-a9e2b5e6258a',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',1,'2025-12-07 10:21:06',NULL),('2025-12-06 10:21:07.331227',NULL,'2025-12-06 10:21:07.338091',144,144,'3e4c3243bf5c4e3a9a62ce06cde13e3d','edbc56bc-6f8a-4f6b-967a-735cea5a3fe5',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07.400941',NULL,'2025-12-06 10:21:07.455532',145,145,'3e4c3243bf5c4e3a9a62ce06cde13e3d','92cefd23-8b71-453a-b941-7dc365c55c41',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:07.760271',NULL,'2025-12-06 10:21:07.766822',146,146,'3e4c3243bf5c4e3a9a62ce06cde13e3d','f9af8114-bb04-41f6-b2f8-d048166b7fbe',63,'3611325ae8594883a9bcd4e1005703c3','share_networks',-1,'2025-12-07 10:21:07',NULL),('2025-12-06 10:21:08.300132',NULL,'2025-12-06 10:21:08.333640',147,147,'2c36ca91e0a44aa0b02f8bba067633f3','db23e5e2-6aa8-46f4-b9e5-c58e292d253b',65,'ad585e38a585413188401641b7f99059','shares',1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08.301270',NULL,'2025-12-06 10:21:08.333640',148,148,'2c36ca91e0a44aa0b02f8bba067633f3','c8d49aeb-9f59-4da2-925f-852aec43466d',64,'ad585e38a585413188401641b7f99059','gigabytes',1,'2025-12-07 10:21:08',NULL),('2025-12-06 10:21:08.310902',NULL,'2025-12-06 10:21:08.333640',149,149,NULL,'46532b70-ce90-43e8-852e-cace1df37535',67,'ad585e38a585413188401641b7f99059','shares',1,'2025-12-07 10:21:08','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:08.312008',NULL,'2025-12-06 10:21:08.333640',150,150,NULL,'2364c9d8-82ac-44a3-bea6-ea75f2cd5475',66,'ad585e38a585413188401641b7f99059','gigabytes',1,'2025-12-07 10:21:08','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:11.546112',NULL,'2025-12-06 10:21:11.667270',151,151,'2c36ca91e0a44aa0b02f8bba067633f3','dbd2be68-f340-4f45-9920-5b165b3c8b8f',69,'ad585e38a585413188401641b7f99059','snapshots',1,'2025-12-07 10:21:11',NULL),('2025-12-06 10:21:11.547649',NULL,'2025-12-06 10:21:11.667270',152,152,'2c36ca91e0a44aa0b02f8bba067633f3','d04c2e02-be34-4c84-a023-90f432fa5e55',68,'ad585e38a585413188401641b7f99059','snapshot_gigabytes',1,'2025-12-07 10:21:11',NULL),('2025-12-06 10:21:11.561186',NULL,'2025-12-06 10:21:11.667270',153,153,NULL,'f6350197-97c1-449a-8e2c-67d028f4db31',71,'ad585e38a585413188401641b7f99059','snapshots',1,'2025-12-07 10:21:11','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:11.562430',NULL,'2025-12-06 10:21:11.667270',154,154,NULL,'339c0275-f3ee-43dd-aeb7-0d5cc3a10c83',70,'ad585e38a585413188401641b7f99059','snapshot_gigabytes',1,'2025-12-07 10:21:11','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:13.884979',NULL,'2025-12-06 10:21:13.922754',155,155,'20e73dea82d14668b6b190aa3ab4fe2b','5b59bc4d-9fa6-470a-bc51-d58c84db2a5e',72,'9877ea92d21c443da020b2f5ac6e63a2','share_networks',1,'2025-12-07 10:21:13',NULL),('2025-12-06 10:21:14.000558',NULL,'2025-12-06 10:21:14.039630',156,156,'20e73dea82d14668b6b190aa3ab4fe2b','ddd7ed79-0eda-4cda-a2ef-22c616fc977c',72,'9877ea92d21c443da020b2f5ac6e63a2','share_networks',1,'2025-12-07 10:21:13',NULL),('2025-12-06 10:21:14.478622',NULL,'2025-12-06 10:21:14.486674',157,157,'20e73dea82d14668b6b190aa3ab4fe2b','b8cb7fa2-eb23-498c-b507-74e24012b49a',72,'9877ea92d21c443da020b2f5ac6e63a2','share_networks',-1,'2025-12-07 10:21:14',NULL),('2025-12-06 10:21:14.609816',NULL,'2025-12-06 10:21:14.615432',158,158,'20e73dea82d14668b6b190aa3ab4fe2b','887f4947-eb12-45ba-8ca0-0bc950e88870',72,'9877ea92d21c443da020b2f5ac6e63a2','share_networks',-1,'2025-12-07 10:21:14',NULL),('2025-12-06 10:21:15.931632',NULL,'2025-12-06 10:21:15.950899',159,159,'2c36ca91e0a44aa0b02f8bba067633f3','45515225-5943-4337-a330-df9d13be9b46',69,'ad585e38a585413188401641b7f99059','snapshots',-1,'2025-12-07 10:21:15',NULL),('2025-12-06 10:21:15.932299',NULL,'2025-12-06 10:21:15.950899',160,160,'2c36ca91e0a44aa0b02f8bba067633f3','3fdf5647-92f0-48dc-83b1-c936484cea0d',68,'ad585e38a585413188401641b7f99059','snapshot_gigabytes',-1,'2025-12-07 10:21:15',NULL),('2025-12-06 10:21:15.939893',NULL,'2025-12-06 10:21:15.950899',161,161,NULL,'3996a623-d185-4baf-8b49-bcf206bc874a',71,'ad585e38a585413188401641b7f99059','snapshots',-1,'2025-12-07 10:21:15','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:15.940960',NULL,'2025-12-06 10:21:15.950899',162,162,NULL,'09516c40-8acb-4bb3-a24b-719b4aa43fd5',70,'ad585e38a585413188401641b7f99059','snapshot_gigabytes',-1,'2025-12-07 10:21:15','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:19.240984',NULL,'2025-12-06 10:21:19.252582',163,163,'2c36ca91e0a44aa0b02f8bba067633f3','6896cacd-165b-4b86-a639-19be1151b884',65,'ad585e38a585413188401641b7f99059','shares',-1,'2025-12-07 10:21:19',NULL),('2025-12-06 10:21:19.241758',NULL,'2025-12-06 10:21:19.252582',164,164,'2c36ca91e0a44aa0b02f8bba067633f3','356436d4-1349-4611-8ac9-98bd93ffc0cf',64,'ad585e38a585413188401641b7f99059','gigabytes',-1,'2025-12-07 10:21:19',NULL),('2025-12-06 10:21:19.246570',NULL,'2025-12-06 10:21:19.252582',165,165,NULL,'22f928a4-0385-4e15-9551-4076e205fa49',67,'ad585e38a585413188401641b7f99059','shares',-1,'2025-12-07 10:21:19','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:19.247172',NULL,'2025-12-06 10:21:19.252582',166,166,NULL,'a36e331d-e6df-4915-af22-12d43f06f2af',66,'ad585e38a585413188401641b7f99059','gigabytes',-1,'2025-12-07 10:21:19','a09468de-a9a3-43e8-9c5a-e16672106039'),('2025-12-06 10:21:20.704150',NULL,'2025-12-06 10:21:20.780136',167,167,'18894715ea384479ab6561155114f3f7','d73926d1-1761-45ef-bde8-2d64bc733a20',73,'c10c64021a544b89a5534dadb82defd7','share_networks',1,'2025-12-07 10:21:20',NULL),('2025-12-06 10:21:28.439625',NULL,'2025-12-06 10:21:28.472744',168,168,'1c980f45f3e4418eb757be06bc24856c','95b64c56-52c8-4e78-a8c3-25ecc6ea1a39',75,'f7a062bb0b084dcb9736c737dbff3764','shares',1,'2025-12-07 10:21:28',NULL),('2025-12-06 10:21:28.440678',NULL,'2025-12-06 10:21:28.472744',169,169,'1c980f45f3e4418eb757be06bc24856c','6f2080cf-4e22-4e1a-a584-857b128a728d',74,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,'2025-12-07 10:21:28',NULL),('2025-12-06 10:21:28.449771',NULL,'2025-12-06 10:21:28.472744',170,170,NULL,'db483f6e-38bc-45ed-a451-3fa2d4f2460c',77,'f7a062bb0b084dcb9736c737dbff3764','shares',1,'2025-12-07 10:21:28','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:28.450806',NULL,'2025-12-06 10:21:28.472744',171,171,NULL,'e5882d31-a193-4b40-8a00-433b8f096e62',76,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,'2025-12-07 10:21:28','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:32.073593',NULL,'2025-12-06 10:21:32.273296',172,172,'fa029c59ca1143c3a47c6ff44f0fe268','8c525466-bfb4-4eff-b228-010257dd047e',78,'f5a7bbeba4b24e8186ef063c429b60eb','shares',1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.076364',NULL,'2025-12-06 10:21:32.273296',173,173,'fa029c59ca1143c3a47c6ff44f0fe268','207e444e-97eb-4087-b7a0-e244880e350e',79,'f5a7bbeba4b24e8186ef063c429b60eb','gigabytes',1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.103440',NULL,'2025-12-06 10:21:32.281354',174,174,'fa029c59ca1143c3a47c6ff44f0fe268','77639912-5b71-4f93-a618-1a0691b96e3b',80,'f7a062bb0b084dcb9736c737dbff3764','shares',-1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.104101',NULL,'2025-12-06 10:21:32.281354',175,175,'fa029c59ca1143c3a47c6ff44f0fe268','cac2f768-6c5b-42cf-a26e-f83f444b7d66',81,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',-1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.791055',NULL,'2025-12-06 10:21:32.816616',176,176,'fa029c59ca1143c3a47c6ff44f0fe268','0636bbdb-3025-4bbf-8cff-f4c9d7c80044',78,'f5a7bbeba4b24e8186ef063c429b60eb','shares',-1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.793118',NULL,'2025-12-06 10:21:32.816616',177,177,'fa029c59ca1143c3a47c6ff44f0fe268','a8880998-4b9c-4947-afd7-af721d21bae8',79,'f5a7bbeba4b24e8186ef063c429b60eb','gigabytes',-1,'2025-12-07 10:21:32',NULL),('2025-12-06 10:21:32.808300',NULL,'2025-12-06 10:21:32.816616',178,178,NULL,'d54a27c8-246c-4bcb-8a14-00763c089dc3',82,'f5a7bbeba4b24e8186ef063c429b60eb','shares',-1,'2025-12-07 10:21:32','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:32.809274',NULL,'2025-12-06 10:21:32.816616',179,179,NULL,'050afa4a-7db3-49bb-a777-fb725253d685',83,'f5a7bbeba4b24e8186ef063c429b60eb','gigabytes',-1,'2025-12-07 10:21:32','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:34.359313',NULL,'2025-12-06 10:21:34.388405',180,180,'a3846342ee734fae98d301bc764d5aa7','e2d541e9-d211-4ded-8ffa-aeb3302a9979',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:34',NULL),('2025-12-06 10:21:34.558828',NULL,'2025-12-06 10:21:34.589168',181,181,'a3846342ee734fae98d301bc764d5aa7','39685dd0-0669-4c1e-8df8-4e43879c1cd1',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:34',NULL),('2025-12-06 10:21:34.742128',NULL,'2025-12-06 10:21:34.793206',182,182,'a3846342ee734fae98d301bc764d5aa7','a7b6dc55-c5d4-484d-b335-2980dc8c504a',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:34',NULL),('2025-12-06 10:21:34.953219',NULL,'2025-12-06 10:21:34.969519',183,183,'a3846342ee734fae98d301bc764d5aa7','f05b5088-5058-4635-928b-e477913cf107',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:34',NULL),('2025-12-06 10:21:35.096226',NULL,'2025-12-06 10:21:35.141408',184,184,'a3846342ee734fae98d301bc764d5aa7','06904cf6-a6fa-4391-93d0-30de5c065878',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.197320',NULL,'2025-12-06 10:21:35.230589',185,185,'a3846342ee734fae98d301bc764d5aa7','add8f311-ff02-45e7-97e9-1aea00fcd3cb',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.364837',NULL,'2025-12-06 10:21:35.369712',186,186,'a3846342ee734fae98d301bc764d5aa7','dace4c2a-8549-4103-ad13-6e7466dd7d13',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.477695',NULL,'2025-12-06 10:21:35.483850',187,187,'a3846342ee734fae98d301bc764d5aa7','133b8fcc-b55b-4c9b-9172-56da2474586e',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.666751',NULL,'2025-12-06 10:21:35.698233',188,188,'1c980f45f3e4418eb757be06bc24856c','27ff40a5-dc16-4564-bef4-ddb269f3d981',75,'f7a062bb0b084dcb9736c737dbff3764','shares',1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.668146',NULL,'2025-12-06 10:21:35.698233',189,189,'1c980f45f3e4418eb757be06bc24856c','7e9a79f4-262c-4e5a-9364-b51eb78145e5',74,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.675598',NULL,'2025-12-06 10:21:35.698233',190,190,NULL,'8b08877f-8083-476b-b191-c903fd82dbde',77,'f7a062bb0b084dcb9736c737dbff3764','shares',1,'2025-12-07 10:21:35','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:35.677138',NULL,'2025-12-06 10:21:35.698233',191,191,NULL,'419154fa-84a7-4a86-a4ad-af873a29aa86',76,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',1,'2025-12-07 10:21:35','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:35.853372',NULL,'2025-12-06 10:21:35.876993',192,192,'a3846342ee734fae98d301bc764d5aa7','9cb31531-2b89-418f-a003-5795c38610a6',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:35.997196',NULL,'2025-12-06 10:21:36.001690',193,193,'a3846342ee734fae98d301bc764d5aa7','4ce9d3db-cbb0-4d4e-9a05-fb2f8261749e',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:35',NULL),('2025-12-06 10:21:36.048551',NULL,'2025-12-06 10:21:36.101015',194,194,'a3846342ee734fae98d301bc764d5aa7','66ef59fc-7b45-43eb-a73e-0650e2d634f3',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',1,'2025-12-07 10:21:36',NULL),('2025-12-06 10:21:36.209946',NULL,'2025-12-06 10:21:36.220667',195,195,'a3846342ee734fae98d301bc764d5aa7','c4d127b6-4fd8-4406-b372-b95d8715a964',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:36',NULL),('2025-12-06 10:21:37.141892',NULL,'2025-12-06 10:21:37.147540',196,196,'a3846342ee734fae98d301bc764d5aa7','92d7aa4e-5ec9-4a70-9ca5-562969d27122',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:37',NULL),('2025-12-06 10:21:37.265290',NULL,'2025-12-06 10:21:37.271517',197,197,'a3846342ee734fae98d301bc764d5aa7','5c344204-3bff-4402-86a4-2295c1af6070',84,'d0315a7a31194fe5bc10aff481f0b185','share_networks',-1,'2025-12-07 10:21:37',NULL),('2025-12-06 10:21:39.371973',NULL,'2025-12-06 10:21:39.405845',198,198,'e79d3d9ca9844cf7a820fed66615a837','9ba50b67-df70-4d73-bd83-b97b5043d583',42,'88ea8626c7df4b62bf7459a615217eeb','shares',-1,'2025-12-07 10:21:39',NULL),('2025-12-06 10:21:39.385366',NULL,'2025-12-06 10:21:39.405845',199,199,'e79d3d9ca9844cf7a820fed66615a837','23737480-e35e-4532-9cfd-90dc8688964c',41,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',-1,'2025-12-07 10:21:39',NULL),('2025-12-06 10:21:39.396821',NULL,'2025-12-06 10:21:39.405845',200,200,NULL,'1637b087-193b-4af7-b856-597058004a57',44,'88ea8626c7df4b62bf7459a615217eeb','shares',-1,'2025-12-07 10:21:39','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:39.397561',NULL,'2025-12-06 10:21:39.405845',201,201,NULL,'33aeb534-5ed1-4dbf-8ab5-e762bd7f2dd4',43,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',-1,'2025-12-07 10:21:39','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:39.591999',NULL,'2025-12-06 10:21:39.611520',202,202,'1c980f45f3e4418eb757be06bc24856c','ced87922-31b8-4c84-9a66-c8a0aaeab15d',75,'f7a062bb0b084dcb9736c737dbff3764','shares',-1,'2025-12-07 10:21:39',NULL),('2025-12-06 10:21:39.593184',NULL,'2025-12-06 10:21:39.611520',203,203,'1c980f45f3e4418eb757be06bc24856c','886c1274-679b-4224-a096-5135b9dc41c2',74,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',-1,'2025-12-07 10:21:39',NULL),('2025-12-06 10:21:39.600037',NULL,'2025-12-06 10:21:39.611520',204,204,NULL,'e7857c14-9b73-468f-9093-ea1e04238945',77,'f7a062bb0b084dcb9736c737dbff3764','shares',-1,'2025-12-07 10:21:39','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:39.602167',NULL,'2025-12-06 10:21:39.611520',205,205,NULL,'fd29cf43-25c4-4d32-8661-3ffbbebcef74',76,'f7a062bb0b084dcb9736c737dbff3764','gigabytes',-1,'2025-12-07 10:21:39','720b9d9a-eb80-458d-9387-a9a893d98c77'),('2025-12-06 10:21:42.802142',NULL,'2025-12-06 10:21:42.818186',206,206,'e79d3d9ca9844cf7a820fed66615a837','d2433564-4ef0-4b69-a768-79028b720b4e',49,'88ea8626c7df4b62bf7459a615217eeb','snapshots',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:42.803574',NULL,'2025-12-06 10:21:42.818186',207,207,'e79d3d9ca9844cf7a820fed66615a837','f2a9ef0d-bb51-4cd4-8b84-77ac313bd648',50,'88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',-1,'2025-12-07 10:21:42',NULL),('2025-12-06 10:21:42.810090',NULL,'2025-12-06 10:21:42.818186',208,208,NULL,'73b9bc94-8b74-445c-95aa-87356910f083',51,'88ea8626c7df4b62bf7459a615217eeb','snapshots',-1,'2025-12-07 10:21:42','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:42.810784',NULL,'2025-12-06 10:21:42.818186',209,209,NULL,'71b852dc-ac5d-4bef-951f-7941436cd3f0',52,'88ea8626c7df4b62bf7459a615217eeb','snapshot_gigabytes',-1,'2025-12-07 10:21:42','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:46.482633',NULL,'2025-12-06 10:21:46.513743',210,210,'e79d3d9ca9844cf7a820fed66615a837','a88d6cc1-faef-429f-8595-8736d141c9d7',42,'88ea8626c7df4b62bf7459a615217eeb','shares',-1,'2025-12-07 10:21:46',NULL),('2025-12-06 10:21:46.483334',NULL,'2025-12-06 10:21:46.513743',211,211,'e79d3d9ca9844cf7a820fed66615a837','03e9ab00-bd4c-49e4-a27d-5a624e6f239d',41,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',-1,'2025-12-07 10:21:46',NULL),('2025-12-06 10:21:46.505748',NULL,'2025-12-06 10:21:46.513743',212,212,NULL,'50cb21df-7a8e-4536-9987-c6e98d7822d1',44,'88ea8626c7df4b62bf7459a615217eeb','shares',-1,'2025-12-07 10:21:46','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:46.506508',NULL,'2025-12-06 10:21:46.513743',213,213,NULL,'868e1feb-bee8-4d42-8986-e89e81b90212',43,'88ea8626c7df4b62bf7459a615217eeb','gigabytes',-1,'2025-12-07 10:21:46','d54caf7a-e53a-41c4-b4d0-0af8c3f5d1b2'),('2025-12-06 10:21:47.277108',NULL,'2025-12-06 10:21:47.324515',214,214,'02b36e7ff8b54c0ea203f9aa2a006b9f','ac2d8a8a-751d-4439-9fc1-dc5c76142160',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:21:47',NULL),('2025-12-06 10:21:47.278388',NULL,'2025-12-06 10:21:47.324515',215,215,'02b36e7ff8b54c0ea203f9aa2a006b9f','eb43afd3-ad62-4b6b-a426-29f411420ccf',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:21:47',NULL),('2025-12-06 10:21:47.292715',NULL,'2025-12-06 10:21:47.324515',216,216,NULL,'8751c798-526b-48db-8f0d-e44f95a9c99c',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:21:47','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:47.294591',NULL,'2025-12-06 10:21:47.324515',217,217,NULL,'efb20c99-4038-4a8f-a5ff-7934bf12326c',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:21:47','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:50.527967',NULL,'2025-12-06 10:21:50.623631',218,218,'02b36e7ff8b54c0ea203f9aa2a006b9f','57adb482-e646-49d9-94a8-7fc9ea49af6e',90,'0bb1c648a1eb4322b7d7147d8b096005','snapshots',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50.529557',NULL,'2025-12-06 10:21:50.623631',219,219,'02b36e7ff8b54c0ea203f9aa2a006b9f','acb32e4c-0d56-480c-a692-a3310739617c',89,'0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',1,'2025-12-07 10:21:50',NULL),('2025-12-06 10:21:50.550463',NULL,'2025-12-06 10:21:50.623631',220,220,NULL,'6b3370a1-a4a6-41e9-9651-08ed10d98e31',92,'0bb1c648a1eb4322b7d7147d8b096005','snapshots',1,'2025-12-07 10:21:50','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:50.551790',NULL,'2025-12-06 10:21:50.623631',221,221,NULL,'d48c316b-dd11-44bd-aa19-deff15d58c11',91,'0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',1,'2025-12-07 10:21:50','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:51.754213',NULL,'2025-12-06 10:21:51.809402',222,222,'62322ce9b54e4926bdc8317dbdffd385','1c77cbe3-42f1-469f-82a7-b1a84876278c',94,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:51.759175',NULL,'2025-12-06 10:21:51.809402',223,223,'62322ce9b54e4926bdc8317dbdffd385','31f5322e-6348-41f9-a2ec-2b0c932dffa4',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:21:51',NULL),('2025-12-06 10:21:51.772988',NULL,'2025-12-06 10:21:51.809402',224,224,NULL,'056efc27-c4c5-46ba-86f8-4751c61ed0b7',96,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:21:51','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:51.774290',NULL,'2025-12-06 10:21:51.809402',225,225,NULL,'a5dc8a17-2d78-4290-ae50-fb30d3804521',95,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:21:51','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:54.537836',NULL,'2025-12-06 10:21:54.560840',226,226,'02b36e7ff8b54c0ea203f9aa2a006b9f','1c5c24b0-5cbf-40ad-b29b-0ee25447b290',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54.539019',NULL,'2025-12-06 10:21:54.560840',227,227,'02b36e7ff8b54c0ea203f9aa2a006b9f','ceffd07e-ca87-48e8-b5e6-224b010334cb',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:21:54',NULL),('2025-12-06 10:21:54.544799',NULL,'2025-12-06 10:21:54.560840',228,228,NULL,'d13b4e19-3330-4ce6-b83d-b126462ba6d5',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:21:54','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:54.545811',NULL,'2025-12-06 10:21:54.560840',229,229,NULL,'6b4664df-040d-4584-8dfb-4775d0a547e5',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:21:54','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:55.061869',NULL,'2025-12-06 10:21:55.235544',230,230,'62322ce9b54e4926bdc8317dbdffd385','95a565ed-4e88-4dec-b1c9-4ca4d94c3e13',98,'bda02ea3c96c41dea538deeda04311bc','snapshots',1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55.065152',NULL,'2025-12-06 10:21:55.235544',231,231,'62322ce9b54e4926bdc8317dbdffd385','fbf8dd46-7228-4801-82fd-60c0cb11c9ae',97,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',1,'2025-12-07 10:21:55',NULL),('2025-12-06 10:21:55.113097',NULL,'2025-12-06 10:21:55.235544',232,232,NULL,'a5eb85be-6e9e-4a9c-9bad-6fc8f6108ab1',100,'bda02ea3c96c41dea538deeda04311bc','snapshots',1,'2025-12-07 10:21:55','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:55.114686',NULL,'2025-12-06 10:21:55.235544',233,233,NULL,'c4375556-07a3-4abe-853e-056e16a4b6a5',99,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',1,'2025-12-07 10:21:55','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:58.780232',NULL,'2025-12-06 10:21:58.801429',234,234,'02b36e7ff8b54c0ea203f9aa2a006b9f','93e5bbfd-9c9e-439f-94f0-bbf6b60d052e',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:21:58',NULL),('2025-12-06 10:21:58.782831',NULL,'2025-12-06 10:21:58.801429',235,235,'02b36e7ff8b54c0ea203f9aa2a006b9f','437c251f-9211-4e49-aefd-da011d3e1aef',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:21:58',NULL),('2025-12-06 10:21:58.790002',NULL,'2025-12-06 10:21:58.801429',236,236,NULL,'df5ebaa3-66ac-479d-bda3-11ffa5b2f85a',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:21:58','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:58.790869',NULL,'2025-12-06 10:21:58.801429',237,237,NULL,'21d4aab0-2247-4cdd-83f0-b13b4f8032c1',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:21:58','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:21:59.038268',NULL,'2025-12-06 10:21:59.051359',238,238,'62322ce9b54e4926bdc8317dbdffd385','dfc4e73a-1dde-4231-90c7-ad9dc7b68278',98,'bda02ea3c96c41dea538deeda04311bc','snapshots',-1,'2025-12-07 10:21:59',NULL),('2025-12-06 10:21:59.038995',NULL,'2025-12-06 10:21:59.051359',239,239,'62322ce9b54e4926bdc8317dbdffd385','bcd7d62a-f11c-429b-9dad-3710d1933284',97,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',-1,'2025-12-07 10:21:59',NULL),('2025-12-06 10:21:59.044299',NULL,'2025-12-06 10:21:59.051359',240,240,NULL,'5139a990-a337-4d3b-ae10-558e8599f416',100,'bda02ea3c96c41dea538deeda04311bc','snapshots',-1,'2025-12-07 10:21:59','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:59.045016',NULL,'2025-12-06 10:21:59.051359',241,241,NULL,'2fad2a39-fcba-47f6-ae51-8dce69293e3f',99,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',-1,'2025-12-07 10:21:59','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:21:59.392756',NULL,'2025-12-06 10:21:59.436998',242,242,'855e050f34334842b489f5e7ecf811bb','81ec7d34-2485-45cc-a24e-aef933f139ca',102,'aff741aa7ffb45e69b516ac04c7e66f7','shares',1,'2025-12-07 10:21:59',NULL),('2025-12-06 10:21:59.393965',NULL,'2025-12-06 10:21:59.436998',243,243,'855e050f34334842b489f5e7ecf811bb','bb136633-e4c5-450d-9dbd-1a04403e7c99',101,'aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',1,'2025-12-07 10:21:59',NULL),('2025-12-06 10:21:59.406933',NULL,'2025-12-06 10:21:59.436998',244,244,NULL,'4df6f20d-f993-4d7d-abd1-c1b46d84b369',104,'aff741aa7ffb45e69b516ac04c7e66f7','shares',1,'2025-12-07 10:21:59','a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:21:59.409123',NULL,'2025-12-06 10:21:59.436998',245,245,NULL,'596b58c3-8a39-4006-b3b4-22d5155c5c41',103,'aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',1,'2025-12-07 10:21:59','a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:22:01.587719',NULL,'2025-12-06 10:22:01.639175',246,246,'02b36e7ff8b54c0ea203f9aa2a006b9f','ab2bd1c7-90d7-4e3f-9f4b-793b3af252ac',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:01',NULL),('2025-12-06 10:22:01.589341',NULL,'2025-12-06 10:22:01.639175',247,247,'02b36e7ff8b54c0ea203f9aa2a006b9f','fff5c12b-ec89-4f6a-875b-93de6e681acb',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',2,'2025-12-07 10:22:01',NULL),('2025-12-06 10:22:01.601165',NULL,'2025-12-06 10:22:01.639175',248,248,NULL,'f941d7dd-70e1-4ba5-9d39-9957c80bc947',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:01','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:01.602397',NULL,'2025-12-06 10:22:01.639175',249,249,NULL,'5cc3d004-92c7-45ce-9515-364167b7e03f',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',2,'2025-12-07 10:22:01','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:02.470906',NULL,'2025-12-06 10:22:02.498696',250,250,'62322ce9b54e4926bdc8317dbdffd385','fc77e887-4280-4dc6-b33a-86eb24ace457',94,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:02',NULL),('2025-12-06 10:22:02.476066',NULL,'2025-12-06 10:22:02.498696',251,251,'62322ce9b54e4926bdc8317dbdffd385','a8578d45-34ff-4dd2-82c2-16c8c5eb3445',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:02',NULL),('2025-12-06 10:22:02.486785',NULL,'2025-12-06 10:22:02.498696',252,252,NULL,'c0105bcc-c909-46fa-9086-64867adb9525',96,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:02','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:22:02.487740',NULL,'2025-12-06 10:22:02.498696',253,253,NULL,'75413018-cb2f-4e25-a3f1-34f43dfb43d6',95,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:02','7fb032ea-4889-47fa-ac92-6480a1b847b3'),('2025-12-06 10:22:04.118876',NULL,'2025-12-06 10:22:04.135594',254,254,'855e050f34334842b489f5e7ecf811bb','fabf7736-488d-4fb8-bbcf-fdd608f410b5',102,'aff741aa7ffb45e69b516ac04c7e66f7','shares',-1,'2025-12-07 10:22:04',NULL),('2025-12-06 10:22:04.119606',NULL,'2025-12-06 10:22:04.135594',255,255,'855e050f34334842b489f5e7ecf811bb','2c87f43f-8c97-445d-8c71-50c041ee9c73',101,'aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',-1,'2025-12-07 10:22:04',NULL),('2025-12-06 10:22:04.127895',NULL,'2025-12-06 10:22:04.135594',256,256,NULL,'0785b820-26aa-4fbf-a839-06bf772c8dbb',104,'aff741aa7ffb45e69b516ac04c7e66f7','shares',-1,'2025-12-07 10:22:04','a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:22:04.128575',NULL,'2025-12-06 10:22:04.135594',257,257,NULL,'6e3f7d23-2f14-4087-a80e-f21f54d03a0b',103,'aff741aa7ffb45e69b516ac04c7e66f7','gigabytes',-1,'2025-12-07 10:22:04','a411a83b-11b5-4050-ab7a-dd6f1af05b20'),('2025-12-06 10:22:05.336710',NULL,'2025-12-06 10:22:05.387912',258,258,'62322ce9b54e4926bdc8317dbdffd385','39b581aa-dc32-4635-8ad3-149b3e465f0e',94,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:05',NULL),('2025-12-06 10:22:05.338066',NULL,'2025-12-06 10:22:05.387912',259,259,'62322ce9b54e4926bdc8317dbdffd385','9d57f3f5-cf9e-4939-93a2-845b81bd8bdd',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:05',NULL),('2025-12-06 10:22:05.357962',NULL,'2025-12-06 10:22:05.387912',260,260,NULL,'966ccf7f-08f9-4d7e-8cdf-f1800bd17453',106,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:05','4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:05.361163',NULL,'2025-12-06 10:22:05.387912',261,261,NULL,'c1badfda-1c69-4323-b261-4528b3aa1be8',105,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:05','4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:05.920045',NULL,'2025-12-06 10:22:05.956223',262,262,'02b36e7ff8b54c0ea203f9aa2a006b9f','20927e40-4590-4487-9823-cf1bf0fbba01',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:05',NULL),('2025-12-06 10:22:05.923670',NULL,'2025-12-06 10:22:05.956223',263,263,'02b36e7ff8b54c0ea203f9aa2a006b9f','df020dc4-5945-446e-9949-84c969e2ec45',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-2,'2025-12-07 10:22:05',NULL),('2025-12-06 10:22:05.941695',NULL,'2025-12-06 10:22:05.956223',264,264,NULL,'d198bdca-0407-4328-936e-61eddeedc552',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:05','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:05.943451',NULL,'2025-12-06 10:22:05.956223',265,265,NULL,'96d8e5be-fa93-4ad6-9657-efc9f38e8dce',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-2,'2025-12-07 10:22:05','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:08.764573',NULL,'2025-12-06 10:22:08.805974',266,266,'02b36e7ff8b54c0ea203f9aa2a006b9f','fa2addb3-833b-4e66-926c-45d01e0ee0bd',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:08',NULL),('2025-12-06 10:22:08.770426',NULL,'2025-12-06 10:22:08.805974',267,267,'02b36e7ff8b54c0ea203f9aa2a006b9f','2a63c6c5-1068-4687-b48e-a2950610829f',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:08',NULL),('2025-12-06 10:22:08.783070',NULL,'2025-12-06 10:22:08.805974',268,268,NULL,'d9c600cd-99bc-4b92-bf6a-d7b8d2d30a76',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:08','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:08.784171',NULL,'2025-12-06 10:22:08.805974',269,269,NULL,'a06fdffe-d452-4e7e-956e-6e09648890a6',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:08','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:09.309945',NULL,'2025-12-06 10:22:09.324837',270,270,'62322ce9b54e4926bdc8317dbdffd385','0ba0cd6c-8b71-407d-8d43-8579b56e0d18',94,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:09',NULL),('2025-12-06 10:22:09.310685',NULL,'2025-12-06 10:22:09.324837',271,271,'62322ce9b54e4926bdc8317dbdffd385','8752ded1-60b8-4685-b133-8fdc25650d65',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:09',NULL),('2025-12-06 10:22:09.317116',NULL,'2025-12-06 10:22:09.324837',272,272,NULL,'7b5c37c3-307f-4c74-8702-42d9ab642c8e',106,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:09','4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:09.317989',NULL,'2025-12-06 10:22:09.324837',273,273,NULL,'c8190609-ba1c-4ebd-80e1-44b286d7d185',105,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:09','4878a6e4-5b54-4264-962b-b9d1bda7cb0b'),('2025-12-06 10:22:12.213597',NULL,'2025-12-06 10:22:12.250723',274,274,'62322ce9b54e4926bdc8317dbdffd385','7ead5eac-50e1-4dc5-a345-dcac25b2404a',94,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:12',NULL),('2025-12-06 10:22:12.215945',NULL,'2025-12-06 10:22:12.250723',275,275,'62322ce9b54e4926bdc8317dbdffd385','d9a51e1d-218e-42a2-aa4d-3fc6095edd36',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:12',NULL),('2025-12-06 10:22:12.226067',NULL,'2025-12-06 10:22:12.250723',276,276,NULL,'164189c3-0313-46f7-a721-25ae5f6c8a06',108,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:12','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:12.228118',NULL,'2025-12-06 10:22:12.250723',277,277,NULL,'ed556355-696b-4665-80e2-ee0d36ac8c08',107,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:12','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:12.684961',NULL,'2025-12-06 10:22:12.721084',278,278,'02b36e7ff8b54c0ea203f9aa2a006b9f','06924eb3-69e7-4e80-b714-310df19dfb2a',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:12',NULL),('2025-12-06 10:22:12.686580',NULL,'2025-12-06 10:22:12.721084',279,279,'02b36e7ff8b54c0ea203f9aa2a006b9f','70637297-3b84-4694-b4ce-48073ec0e729',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:12',NULL),('2025-12-06 10:22:12.702392',NULL,'2025-12-06 10:22:12.721084',280,280,NULL,'776d91f8-2f0d-409e-9838-823b16372abe',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:12','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:12.704403',NULL,'2025-12-06 10:22:12.721084',281,281,NULL,'5c00c358-4109-4a2f-8402-0c5c2c519bf8',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:12','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:15.291011',NULL,'2025-12-06 10:22:15.329229',282,282,'02b36e7ff8b54c0ea203f9aa2a006b9f','f7a1d790-b311-4c5a-aa4c-e6382f446383',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:15',NULL),('2025-12-06 10:22:15.292994',NULL,'2025-12-06 10:22:15.329229',283,283,'02b36e7ff8b54c0ea203f9aa2a006b9f','4cd2e0ca-f41d-4751-ae22-0cd5723c4d5c',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:15',NULL),('2025-12-06 10:22:15.300702',NULL,'2025-12-06 10:22:15.329229',284,284,NULL,'0db3e802-0672-49fb-9911-793861edc2a7',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:15','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:15.301874',NULL,'2025-12-06 10:22:15.329229',285,285,NULL,'3fd2c781-3fbd-4f21-aa7d-50fa165d34b5',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:15','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:15.477441',NULL,'2025-12-06 10:22:15.562143',286,286,'62322ce9b54e4926bdc8317dbdffd385','2858bcfe-3d8d-42b2-8357-69f5fa4ae021',98,'bda02ea3c96c41dea538deeda04311bc','snapshots',1,'2025-12-07 10:22:15',NULL),('2025-12-06 10:22:15.481561',NULL,'2025-12-06 10:22:15.562143',287,287,'62322ce9b54e4926bdc8317dbdffd385','f8107344-34a2-48bc-b90e-1ffd329d21cd',97,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',1,'2025-12-07 10:22:15',NULL),('2025-12-06 10:22:15.499302',NULL,'2025-12-06 10:22:15.562143',288,288,NULL,'ebb342a9-b6e5-4491-997f-4514b40ee44f',109,'bda02ea3c96c41dea538deeda04311bc','snapshots',1,'2025-12-07 10:22:15','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:15.503957',NULL,'2025-12-06 10:22:15.562143',289,289,NULL,'ad9a0d1a-0814-4814-9051-8dbe4653d5d1',110,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',1,'2025-12-07 10:22:15','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:18.331841',NULL,'2025-12-06 10:22:18.377073',290,290,'d0a08cde4fda48429459a853fd139f8a','1c38e60a-e603-4979-907c-b48c526b2b30',112,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:18',NULL),('2025-12-06 10:22:18.332877',NULL,'2025-12-06 10:22:18.377073',291,291,'d0a08cde4fda48429459a853fd139f8a','411f2ce0-0bf8-4151-a91f-35ae03b035c6',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:18',NULL),('2025-12-06 10:22:18.350210',NULL,'2025-12-06 10:22:18.377073',292,292,NULL,'8e93fa6c-25eb-498d-93cf-eb616afd66f1',114,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:18','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:18.351419',NULL,'2025-12-06 10:22:18.377073',293,293,NULL,'3a670418-6625-4be9-b1b4-24b41c0e68fe',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:18','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:19.004971',NULL,'2025-12-06 10:22:19.034849',294,294,'62322ce9b54e4926bdc8317dbdffd385','2907cef2-73b5-418b-b764-aba363934d6a',94,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:18',NULL),('2025-12-06 10:22:19.007153',NULL,'2025-12-06 10:22:19.034849',295,295,'62322ce9b54e4926bdc8317dbdffd385','4945f1f9-1717-413a-9065-313bfc24dd7d',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:18',NULL),('2025-12-06 10:22:19.013703',NULL,'2025-12-06 10:22:19.034849',296,296,NULL,'0e66a93a-7d35-445b-a77c-2f7e8ba29844',108,'bda02ea3c96c41dea538deeda04311bc','shares',1,'2025-12-07 10:22:18','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:19.014919',NULL,'2025-12-06 10:22:19.034849',297,297,NULL,'3a9d440e-7a93-4792-820d-af5f4468f5a7',107,'bda02ea3c96c41dea538deeda04311bc','gigabytes',1,'2025-12-07 10:22:18','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:19.071794',NULL,'2025-12-06 10:22:19.116795',298,298,'02b36e7ff8b54c0ea203f9aa2a006b9f','f7ba6738-c9db-4a81-8bb8-e3af3712cfc5',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:19',NULL),('2025-12-06 10:22:19.073009',NULL,'2025-12-06 10:22:19.116795',299,299,'02b36e7ff8b54c0ea203f9aa2a006b9f','92460d9d-4f7c-4e91-9ee9-9b5f6046d169',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:19',NULL),('2025-12-06 10:22:19.088533',NULL,'2025-12-06 10:22:19.116795',300,300,NULL,'90896bc5-a77e-4077-95ce-dfa4ecf50853',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:19','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:19.094159',NULL,'2025-12-06 10:22:19.116795',301,301,NULL,'61a48058-c8cf-4278-8be9-f1a6f1043b03',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:19','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:21.712942',NULL,'2025-12-06 10:22:21.766941',302,302,'d0a08cde4fda48429459a853fd139f8a','b8906c92-259d-4207-998d-772359a3c7fe',112,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:21',NULL),('2025-12-06 10:22:21.714758',NULL,'2025-12-06 10:22:21.766941',303,303,'d0a08cde4fda48429459a853fd139f8a','071739f7-c79e-429d-a02d-c8f040f5a2db',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:21',NULL),('2025-12-06 10:22:21.727118',NULL,'2025-12-06 10:22:21.766941',304,304,NULL,'657d06dd-5e48-4b3b-ad0c-ab225120c934',114,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:21','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:21.728162',NULL,'2025-12-06 10:22:21.766941',305,305,NULL,'c08b15ad-861d-4c59-91ce-b29b2f7fed77',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:21','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:22.086318',NULL,'2025-12-06 10:22:22.114708',306,306,'02b36e7ff8b54c0ea203f9aa2a006b9f','4edd5b06-7336-4e4b-9956-9746614e5e01',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:22',NULL),('2025-12-06 10:22:22.087600',NULL,'2025-12-06 10:22:22.114708',307,307,'02b36e7ff8b54c0ea203f9aa2a006b9f','95063695-1b7d-4afa-8fac-8fdf3248c143',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:22',NULL),('2025-12-06 10:22:22.093982',NULL,'2025-12-06 10:22:22.114708',308,308,NULL,'1cf7b409-a1eb-4290-8a30-64a85719ae33',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',1,'2025-12-07 10:22:22','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:22.095162',NULL,'2025-12-06 10:22:22.114708',309,309,NULL,'23c88a4d-c878-4e81-ab2b-a24f30afe6c5',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',1,'2025-12-07 10:22:22','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:22.147554',NULL,'2025-12-06 10:22:22.182194',310,310,'184bb450d4864170a750006dfcc7e3fe','53bb20b0-dcda-48bc-a614-b435ec45ab67',115,'27d01455ef604522b30ed3c627f764a1','share_networks',1,'2025-12-07 10:22:22',NULL),('2025-12-06 10:22:22.854726',NULL,'2025-12-06 10:22:22.897271',311,311,'184bb450d4864170a750006dfcc7e3fe','91fc382b-5b34-47f2-91a6-e87872c1702d',115,'27d01455ef604522b30ed3c627f764a1','share_networks',1,'2025-12-07 10:22:22',NULL),('2025-12-06 10:22:23.251865',NULL,'2025-12-06 10:22:23.258638',312,312,'184bb450d4864170a750006dfcc7e3fe','d7779796-13a0-4c72-a89b-bd86a1b806a8',115,'27d01455ef604522b30ed3c627f764a1','share_networks',-1,'2025-12-07 10:22:23',NULL),('2025-12-06 10:22:23.322706',NULL,'2025-12-06 10:22:23.358382',313,313,'184bb450d4864170a750006dfcc7e3fe','9ab5e40e-1f1b-4ebe-afd9-43cfd0e09587',115,'27d01455ef604522b30ed3c627f764a1','share_networks',1,'2025-12-07 10:22:23',NULL),('2025-12-06 10:22:23.744917',NULL,'2025-12-06 10:22:23.750144',314,314,'184bb450d4864170a750006dfcc7e3fe','ef93f246-0e1e-496b-b5a7-625fa5f0f3b9',115,'27d01455ef604522b30ed3c627f764a1','share_networks',-1,'2025-12-07 10:22:23',NULL),('2025-12-06 10:22:24.360269',NULL,'2025-12-06 10:22:24.367819',315,315,'184bb450d4864170a750006dfcc7e3fe','cb68ec22-06c9-4e0a-b572-52a1ebab9ffe',115,'27d01455ef604522b30ed3c627f764a1','share_networks',-1,'2025-12-07 10:22:24',NULL),('2025-12-06 10:22:25.683259',NULL,'2025-12-06 10:22:25.708768',316,316,'d0a08cde4fda48429459a853fd139f8a','e8842527-776a-437f-b934-25b784922b57',112,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:25',NULL),('2025-12-06 10:22:25.685710',NULL,'2025-12-06 10:22:25.708768',317,317,'d0a08cde4fda48429459a853fd139f8a','4fda1f45-014b-4f7f-997a-b62da1daf84c',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:25',NULL),('2025-12-06 10:22:25.696008',NULL,'2025-12-06 10:22:25.708768',318,318,NULL,'505d21e1-f04b-4e38-bd8e-f1eca3c995e9',114,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:25','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:25.697381',NULL,'2025-12-06 10:22:25.708768',319,319,NULL,'9e1b8ddf-5359-48d7-91f0-d5321b006683',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:25','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:25.911060',NULL,'2025-12-06 10:22:25.927293',320,320,'02b36e7ff8b54c0ea203f9aa2a006b9f','2720343f-2306-46ac-a954-c716839f427f',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:25',NULL),('2025-12-06 10:22:25.911940',NULL,'2025-12-06 10:22:25.927293',321,321,'02b36e7ff8b54c0ea203f9aa2a006b9f','1d7a8bce-efd9-4983-8ad3-364c94507521',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:25',NULL),('2025-12-06 10:22:25.918627',NULL,'2025-12-06 10:22:25.927293',322,322,NULL,'2c3be81d-bc08-42a4-b3e1-a6037d937f68',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:25','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:25.919326',NULL,'2025-12-06 10:22:25.927293',323,323,NULL,'63741c87-c7d4-491c-821d-cda2e4dc6840',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:25','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:28.937937',NULL,'2025-12-06 10:22:28.992601',324,324,'d0a08cde4fda48429459a853fd139f8a','e3cbf677-3890-4b8d-81c6-251ba8006cf2',112,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28.939320',NULL,'2025-12-06 10:22:28.992601',325,325,'d0a08cde4fda48429459a853fd139f8a','6e984214-5403-463c-b693-987700f7e1b8',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:28',NULL),('2025-12-06 10:22:28.961295',NULL,'2025-12-06 10:22:28.992601',326,326,NULL,'c690ccdb-c8cd-4992-98c3-b9c298d540e8',114,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:28','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:28.966117',NULL,'2025-12-06 10:22:28.992601',327,327,NULL,'3af10d45-8ffb-4f76-aad9-52464f46fd06',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:28','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:29.507244',NULL,'2025-12-06 10:22:29.531858',328,328,'02b36e7ff8b54c0ea203f9aa2a006b9f','12cfbb4b-5112-4128-bfb7-8d94fee8d859',90,'0bb1c648a1eb4322b7d7147d8b096005','snapshots',-1,'2025-12-07 10:22:29',NULL),('2025-12-06 10:22:29.508346',NULL,'2025-12-06 10:22:29.531858',329,329,'02b36e7ff8b54c0ea203f9aa2a006b9f','44b753ae-d7a4-41a1-9ad3-a96080c1f927',89,'0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',-1,'2025-12-07 10:22:29',NULL),('2025-12-06 10:22:29.521399',NULL,'2025-12-06 10:22:29.531858',330,330,NULL,'6022e341-8661-4f84-bc21-7b9ab900159e',92,'0bb1c648a1eb4322b7d7147d8b096005','snapshots',-1,'2025-12-07 10:22:29','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:29.522593',NULL,'2025-12-06 10:22:29.531858',331,331,NULL,'317b8a80-46e9-47c0-9b63-5cd3121275a0',91,'0bb1c648a1eb4322b7d7147d8b096005','snapshot_gigabytes',-1,'2025-12-07 10:22:29','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:31.853884',NULL,'2025-12-06 10:22:31.878588',332,332,'d0a08cde4fda48429459a853fd139f8a','bc676f79-258a-404a-b6a8-cd18973a4f9e',116,'00d42fb3fe114975b941ad331bfb477b','share_groups',1,'2025-12-07 10:22:31',NULL),('2025-12-06 10:22:32.702298',NULL,'2025-12-06 10:22:32.723916',333,333,'02b36e7ff8b54c0ea203f9aa2a006b9f','e42ed325-b5c4-47b7-80a9-9e12b4352032',86,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:32',NULL),('2025-12-06 10:22:32.703395',NULL,'2025-12-06 10:22:32.723916',334,334,'02b36e7ff8b54c0ea203f9aa2a006b9f','a45919ce-8c4a-41b6-a07f-01299f205e14',85,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:32',NULL),('2025-12-06 10:22:32.712188',NULL,'2025-12-06 10:22:32.723916',335,335,NULL,'c4511158-4ab3-400b-8558-2a9688dee04f',88,'0bb1c648a1eb4322b7d7147d8b096005','shares',-1,'2025-12-07 10:22:32','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:32.714503',NULL,'2025-12-06 10:22:32.723916',336,336,NULL,'29776666-98a4-4339-b295-d3eb7ac809bc',87,'0bb1c648a1eb4322b7d7147d8b096005','gigabytes',-1,'2025-12-07 10:22:32','d21115ab-b194-4d90-8b18-6925745a3ea8'),('2025-12-06 10:22:35.130343',NULL,'2025-12-06 10:22:35.148449',337,337,'d0a08cde4fda48429459a853fd139f8a','c1d80551-612e-4864-b719-dc8e1459f5dc',116,'00d42fb3fe114975b941ad331bfb477b','share_groups',-1,'2025-12-07 10:22:35',NULL),('2025-12-06 10:22:38.070788',NULL,'2025-12-06 10:22:38.086245',338,338,'62322ce9b54e4926bdc8317dbdffd385','2c82116d-fdc7-4327-8dc1-812f63887fa0',94,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38.071744',NULL,'2025-12-06 10:22:38.086245',339,339,'62322ce9b54e4926bdc8317dbdffd385','7304093f-6623-4e0e-a2c2-d03050529e8a',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:38.078122',NULL,'2025-12-06 10:22:38.086245',340,340,NULL,'8bf362cf-04f3-44b9-a26e-99ba0064ed36',108,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:38','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:38.078830',NULL,'2025-12-06 10:22:38.086245',341,341,NULL,'74a349d4-4bd2-49df-b38c-3597d964d60d',107,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:38','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:38.342388',NULL,'2025-12-06 10:22:38.363779',342,342,'d0a08cde4fda48429459a853fd139f8a','82c9439f-7592-44ec-8b11-766ce502c2c5',116,'00d42fb3fe114975b941ad331bfb477b','share_groups',1,'2025-12-07 10:22:38',NULL),('2025-12-06 10:22:41.624557',NULL,'2025-12-06 10:22:41.643057',343,343,'d0a08cde4fda48429459a853fd139f8a','4ea7f10b-288d-46cc-bc2a-3136e4671a80',116,'00d42fb3fe114975b941ad331bfb477b','share_groups',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41.700214',NULL,'2025-12-06 10:22:41.728803',344,344,'62322ce9b54e4926bdc8317dbdffd385','5098f8b7-9393-4d42-8e97-7cc35cb59f2b',98,'bda02ea3c96c41dea538deeda04311bc','snapshots',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41.701002',NULL,'2025-12-06 10:22:41.728803',345,345,'62322ce9b54e4926bdc8317dbdffd385','82bdb69c-1147-45b6-98db-00f373f74c88',97,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',-1,'2025-12-07 10:22:41',NULL),('2025-12-06 10:22:41.711659',NULL,'2025-12-06 10:22:41.728803',346,346,NULL,'8b48f261-0538-4384-8585-28e7e2ffeebb',109,'bda02ea3c96c41dea538deeda04311bc','snapshots',-1,'2025-12-07 10:22:41','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:41.714197',NULL,'2025-12-06 10:22:41.728803',347,347,NULL,'b2a132ff-fd60-431a-9637-34de9ffd283c',110,'bda02ea3c96c41dea538deeda04311bc','snapshot_gigabytes',-1,'2025-12-07 10:22:41','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:44.847548',NULL,'2025-12-06 10:22:44.916168',348,348,'d0a08cde4fda48429459a853fd139f8a','22c41b0f-fa0a-4ba0-9f77-7f01821f6e7d',112,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:44',NULL),('2025-12-06 10:22:44.848830',NULL,'2025-12-06 10:22:44.916168',349,349,'d0a08cde4fda48429459a853fd139f8a','b1e7189a-6f4f-4a95-b88e-aa2980f9f94d',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:44',NULL),('2025-12-06 10:22:44.862962',NULL,'2025-12-06 10:22:44.916168',350,350,NULL,'d69f7f52-b8a0-444d-8780-af79e8085e54',114,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:44','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:44.867234',NULL,'2025-12-06 10:22:44.892597',351,351,'62322ce9b54e4926bdc8317dbdffd385','8ccfbee2-faa4-4073-9c09-d4e3564d1677',94,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:44',NULL),('2025-12-06 10:22:44.868835',NULL,'2025-12-06 10:22:44.892597',352,352,'62322ce9b54e4926bdc8317dbdffd385','397a663b-5a15-4882-a328-2754186a23ee',93,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:44',NULL),('2025-12-06 10:22:44.870218',NULL,'2025-12-06 10:22:44.916168',353,353,NULL,'8f3b62c7-811f-437b-ab39-77763c1cc1e7',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:44','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:44.877420',NULL,'2025-12-06 10:22:44.892597',354,354,NULL,'8e8cf05a-40a8-4fb1-a40e-77cd241af88b',108,'bda02ea3c96c41dea538deeda04311bc','shares',-1,'2025-12-07 10:22:44','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:44.879708',NULL,'2025-12-06 10:22:44.892597',355,355,NULL,'25207933-e69e-4486-8715-ff6555a483b0',107,'bda02ea3c96c41dea538deeda04311bc','gigabytes',-1,'2025-12-07 10:22:44','830204f7-9475-42eb-8120-6cffba6b75f2'),('2025-12-06 10:22:48.663327',NULL,'2025-12-06 10:22:48.691011',356,356,'d0a08cde4fda48429459a853fd139f8a','9b9a3dc9-e585-4ea0-a596-9365306d4409',112,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:48.664824',NULL,'2025-12-06 10:22:48.691011',357,357,'d0a08cde4fda48429459a853fd139f8a','6916ae72-7636-4e3f-b7f9-bbacedb9e2ed',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:48',NULL),('2025-12-06 10:22:48.678501',NULL,'2025-12-06 10:22:48.691011',358,358,NULL,'44723e68-d518-48ae-a3ab-5f3f26d14a77',114,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:48','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:48.680248',NULL,'2025-12-06 10:22:48.691011',359,359,NULL,'73ad82e0-45d5-4359-88ec-e8c65a51dc4f',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:48','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:51.584275',NULL,'2025-12-06 10:22:51.614609',360,360,'d0a08cde4fda48429459a853fd139f8a','93c632ed-d7bb-4224-bdc4-f5c49b584472',112,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:51.585812',NULL,'2025-12-06 10:22:51.614609',361,361,'d0a08cde4fda48429459a853fd139f8a','1f5122ae-22d2-4a39-9035-dd612e4a2f55',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:51',NULL),('2025-12-06 10:22:51.593053',NULL,'2025-12-06 10:22:51.614609',362,362,NULL,'4492a2d5-036e-4080-aff6-fe41f38e9b16',114,'00d42fb3fe114975b941ad331bfb477b','shares',1,'2025-12-07 10:22:51','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:51.594381',NULL,'2025-12-06 10:22:51.614609',363,363,NULL,'b7144ca9-6412-4add-bcc7-dcf37e773b03',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',1,'2025-12-07 10:22:51','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:55.355660',NULL,'2025-12-06 10:22:55.385549',364,364,'d0a08cde4fda48429459a853fd139f8a','d554e543-f6b1-4c79-ad7e-f2e81169a7bd',112,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55.357894',NULL,'2025-12-06 10:22:55.385549',365,365,'d0a08cde4fda48429459a853fd139f8a','ca00fe94-7a41-4b02-91d6-0b2217e6dac4',111,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:55',NULL),('2025-12-06 10:22:55.366527',NULL,'2025-12-06 10:22:55.385549',366,366,NULL,'c5566592-f1c0-4245-9f8d-e788c753f801',114,'00d42fb3fe114975b941ad331bfb477b','shares',-1,'2025-12-07 10:22:55','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:22:55.368235',NULL,'2025-12-06 10:22:55.385549',367,367,NULL,'e74f79cc-7afd-454e-8165-9bc8ea4eb9f7',113,'00d42fb3fe114975b941ad331bfb477b','gigabytes',-1,'2025-12-07 10:22:55','299a283c-6b1f-4814-915f-117be52651b5'),('2025-12-06 10:23:01.843259',NULL,'2025-12-06 10:23:01.875740',368,368,'d15527bbfe3541d081546fd87b965969','38859cad-0128-43ab-a998-2ee5d97aa288',118,'32c3d6224de34254bee75ac8f1ece984','shares',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:01.844529',NULL,'2025-12-06 10:23:01.875740',369,369,'d15527bbfe3541d081546fd87b965969','bc6fd58b-d1ed-471e-a080-5d4e7a398ae0',117,'32c3d6224de34254bee75ac8f1ece984','gigabytes',1,'2025-12-07 10:23:01',NULL),('2025-12-06 10:23:01.857816',NULL,'2025-12-06 10:23:01.875740',370,370,NULL,'8f969a7e-e013-4ad2-952c-b4af795d3eca',120,'32c3d6224de34254bee75ac8f1ece984','shares',1,'2025-12-07 10:23:01','107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:01.859011',NULL,'2025-12-06 10:23:01.875740',371,371,NULL,'3899465e-426b-43d0-bd2b-322c7d85e2a0',119,'32c3d6224de34254bee75ac8f1ece984','gigabytes',1,'2025-12-07 10:23:01','107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:02.456774',NULL,'2025-12-06 10:23:02.488889',372,372,'1653cdabeb4d4defac504fa88d0df629','2542d606-739b-462e-868f-703bf9ef0159',122,'8168ad3d37a64ff680fd439a69736a7b','shares',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:02.458022',NULL,'2025-12-06 10:23:02.488889',373,373,'1653cdabeb4d4defac504fa88d0df629','2b7a0162-a905-48d1-a587-c8ee23393bf8',121,'8168ad3d37a64ff680fd439a69736a7b','gigabytes',1,'2025-12-07 10:23:02',NULL),('2025-12-06 10:23:02.467329',NULL,'2025-12-06 10:23:02.488889',374,374,NULL,'31b4e70f-390d-4f91-8dc5-a3533000a85a',124,'8168ad3d37a64ff680fd439a69736a7b','shares',1,'2025-12-07 10:23:02','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:02.469444',NULL,'2025-12-06 10:23:02.488889',375,375,NULL,'87191d82-5335-45df-8f41-7381b43005eb',123,'8168ad3d37a64ff680fd439a69736a7b','gigabytes',1,'2025-12-07 10:23:02','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:05.742671',NULL,'2025-12-06 10:23:05.870236',376,376,'1653cdabeb4d4defac504fa88d0df629','cd5eb288-fdff-47ad-93c9-4b903f445c30',125,'8168ad3d37a64ff680fd439a69736a7b','snapshots',1,'2025-12-07 10:23:05',NULL),('2025-12-06 10:23:05.744294',NULL,'2025-12-06 10:23:05.870236',377,377,'1653cdabeb4d4defac504fa88d0df629','d74e6279-bd03-49ae-96d8-72311dec2c47',126,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',1,'2025-12-07 10:23:05',NULL),('2025-12-06 10:23:05.765110',NULL,'2025-12-06 10:23:05.870236',378,378,NULL,'6f2bd09a-f1d8-4129-a47c-8852ae6911aa',127,'8168ad3d37a64ff680fd439a69736a7b','snapshots',1,'2025-12-07 10:23:05','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:05.766736',NULL,'2025-12-06 10:23:05.870236',379,379,NULL,'7614d2cd-09fc-429c-8aaa-fd5d7dfcb997',128,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',1,'2025-12-07 10:23:05','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:07.144096',NULL,'2025-12-06 10:23:07.174821',380,380,'d15527bbfe3541d081546fd87b965969','cba3c877-2602-477c-b140-136025fa3e1f',118,'32c3d6224de34254bee75ac8f1ece984','shares',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:07.158995',NULL,'2025-12-06 10:23:07.174821',381,381,'d15527bbfe3541d081546fd87b965969','74a80faf-724e-4598-8beb-ef47b958ad57',117,'32c3d6224de34254bee75ac8f1ece984','gigabytes',-1,'2025-12-07 10:23:07',NULL),('2025-12-06 10:23:07.167329',NULL,'2025-12-06 10:23:07.174821',382,382,NULL,'0349da77-d4f1-4e5d-ba98-aa62ae3b02c3',120,'32c3d6224de34254bee75ac8f1ece984','shares',-1,'2025-12-07 10:23:07','107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:07.168407',NULL,'2025-12-06 10:23:07.174821',383,383,NULL,'9263d34c-f677-41fd-8450-ae85de0f160d',119,'32c3d6224de34254bee75ac8f1ece984','gigabytes',-1,'2025-12-07 10:23:07','107e5b00-835f-4df4-aba3-2da68bb74665'),('2025-12-06 10:23:09.296927',NULL,'2025-12-06 10:23:09.364059',384,384,'1653cdabeb4d4defac504fa88d0df629','e045b808-86da-4127-be43-699cf747855b',125,'8168ad3d37a64ff680fd439a69736a7b','snapshots',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:09.298352',NULL,'2025-12-06 10:23:09.364059',385,385,'1653cdabeb4d4defac504fa88d0df629','84630092-6579-4f10-8661-02caea4e0993',126,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',1,'2025-12-07 10:23:09',NULL),('2025-12-06 10:23:09.306027',NULL,'2025-12-06 10:23:09.364059',386,386,NULL,'c8267ef3-b294-4d9f-8cca-dc1a9cd7f776',127,'8168ad3d37a64ff680fd439a69736a7b','snapshots',1,'2025-12-07 10:23:09','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:09.307242',NULL,'2025-12-06 10:23:09.364059',387,387,NULL,'f95c5693-119c-4313-a020-19c7dd97069f',128,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',1,'2025-12-07 10:23:09','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:13.149194',NULL,'2025-12-06 10:23:13.162245',388,388,'1653cdabeb4d4defac504fa88d0df629','ea494629-dd71-49cf-b484-40f57c8745f2',125,'8168ad3d37a64ff680fd439a69736a7b','snapshots',-1,'2025-12-07 10:23:13',NULL),('2025-12-06 10:23:13.150040',NULL,'2025-12-06 10:23:13.162245',389,389,'1653cdabeb4d4defac504fa88d0df629','f2b67ce1-12d2-4360-9083-66b7593feec2',126,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',-1,'2025-12-07 10:23:13',NULL),('2025-12-06 10:23:13.155437',NULL,'2025-12-06 10:23:13.162245',390,390,NULL,'d7b25c4a-1f06-477d-a59e-df46dfc82172',127,'8168ad3d37a64ff680fd439a69736a7b','snapshots',-1,'2025-12-07 10:23:13','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:13.156058',NULL,'2025-12-06 10:23:13.162245',391,391,NULL,'3f77ee98-516a-446b-b415-d8107e8e5b44',128,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',-1,'2025-12-07 10:23:13','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:16.386036',NULL,'2025-12-06 10:23:16.399593',392,392,'1653cdabeb4d4defac504fa88d0df629','4c111f78-e35f-45c9-9d15-34b11ade2f92',125,'8168ad3d37a64ff680fd439a69736a7b','snapshots',-1,'2025-12-07 10:23:16',NULL),('2025-12-06 10:23:16.386730',NULL,'2025-12-06 10:23:16.399593',393,393,'1653cdabeb4d4defac504fa88d0df629','55ef41ae-a1d7-4dc5-8d6f-fdf597f6f0d0',126,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',-1,'2025-12-07 10:23:16',NULL),('2025-12-06 10:23:16.391877',NULL,'2025-12-06 10:23:16.399593',394,394,NULL,'82f7e690-ebfc-41c3-b1ad-603def732ac6',127,'8168ad3d37a64ff680fd439a69736a7b','snapshots',-1,'2025-12-07 10:23:16','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:16.393171',NULL,'2025-12-06 10:23:16.399593',395,395,NULL,'1c4549ef-3dc5-4bc8-83c9-2ba4a6fac515',128,'8168ad3d37a64ff680fd439a69736a7b','snapshot_gigabytes',-1,'2025-12-07 10:23:16','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:19.664745',NULL,'2025-12-06 10:23:19.680202',396,396,'1653cdabeb4d4defac504fa88d0df629','cbf15895-7372-4b92-a4f1-31ff226cf2ad',122,'8168ad3d37a64ff680fd439a69736a7b','shares',-1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:19.665531',NULL,'2025-12-06 10:23:19.680202',397,397,'1653cdabeb4d4defac504fa88d0df629','8b92f4e1-5d81-4c9c-9ef1-9a120fe2aae9',121,'8168ad3d37a64ff680fd439a69736a7b','gigabytes',-1,'2025-12-07 10:23:19',NULL),('2025-12-06 10:23:19.671865',NULL,'2025-12-06 10:23:19.680202',398,398,NULL,'8963708d-4317-42eb-a251-556342e69aaa',124,'8168ad3d37a64ff680fd439a69736a7b','shares',-1,'2025-12-07 10:23:19','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:19.672788',NULL,'2025-12-06 10:23:19.680202',399,399,NULL,'4d45c132-6874-4ede-b82c-289fb3d70194',123,'8168ad3d37a64ff680fd439a69736a7b','gigabytes',-1,'2025-12-07 10:23:19','827a7e33-f1c1-47c9-be2c-b98093ae7e5b'),('2025-12-06 10:23:24.267851',NULL,'2025-12-06 10:23:24.319378',400,400,'8c95b67d83b947d78dd96e1b4cce7a0e','dcaa9208-9a6f-4758-8564-795a3f88b734',129,'a860f91f361042a2b13934bff381f266','shares',1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:24.269181',NULL,'2025-12-06 10:23:24.319378',401,401,'8c95b67d83b947d78dd96e1b4cce7a0e','47fce4df-3412-49eb-9594-c92995e04438',130,'a860f91f361042a2b13934bff381f266','gigabytes',1,'2025-12-07 10:23:24',NULL),('2025-12-06 10:23:24.285833',NULL,'2025-12-06 10:23:24.319378',402,402,NULL,'1ed31837-497c-43b9-bc48-43ae6db1033d',131,'a860f91f361042a2b13934bff381f266','shares',1,'2025-12-07 10:23:24','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:24.287230',NULL,'2025-12-06 10:23:24.319378',403,403,NULL,'778a4167-a45f-4b34-9eac-505178ca5964',132,'a860f91f361042a2b13934bff381f266','gigabytes',1,'2025-12-07 10:23:24','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:27.522578',NULL,'2025-12-06 10:23:27.584016',404,404,'8c95b67d83b947d78dd96e1b4cce7a0e','746f27f0-da87-4fe3-a293-397e14773833',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:27',NULL),('2025-12-06 10:23:27.523715',NULL,'2025-12-06 10:23:27.584016',405,405,'8c95b67d83b947d78dd96e1b4cce7a0e','36173317-15b4-40ca-9422-3e29c113f670',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:27',NULL),('2025-12-06 10:23:27.533496',NULL,'2025-12-06 10:23:27.584016',406,406,NULL,'5b8575f2-7ed3-4cae-968a-a1b840e6e676',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:27','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:27.534745',NULL,'2025-12-06 10:23:27.584016',407,407,NULL,'43957877-167f-4536-811f-a0951aeee15e',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:27','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:28.428553',NULL,'2025-12-06 10:23:28.460629',408,408,'24430961e75b499c8132e916070db917','cc86906f-a7b3-4d9c-b98f-cda49fa1a025',138,'c83cf8cf17554ef78c82738ac22165fa','shares',1,'2025-12-07 10:23:28',NULL),('2025-12-06 10:23:28.431448',NULL,'2025-12-06 10:23:28.460629',409,409,'24430961e75b499c8132e916070db917','6b6c6ece-6f2d-42e8-8497-cccf066da207',137,'c83cf8cf17554ef78c82738ac22165fa','gigabytes',1,'2025-12-07 10:23:28',NULL),('2025-12-06 10:23:28.443037',NULL,'2025-12-06 10:23:28.460629',410,410,NULL,'d3f4be10-7556-4cd2-aee1-f9e62a23b1e1',140,'c83cf8cf17554ef78c82738ac22165fa','shares',1,'2025-12-07 10:23:28','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:28.444809',NULL,'2025-12-06 10:23:28.460629',411,411,NULL,'5011ac57-106c-47dc-8b3c-19f193a1f54b',139,'c83cf8cf17554ef78c82738ac22165fa','gigabytes',1,'2025-12-07 10:23:28','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:30.810777',NULL,'2025-12-06 10:23:30.910643',412,412,'8c95b67d83b947d78dd96e1b4cce7a0e','447b8859-a112-48bd-a849-f4d3bc9e84e1',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:30.812088',NULL,'2025-12-06 10:23:30.910643',413,413,'8c95b67d83b947d78dd96e1b4cce7a0e','fc090606-8d01-4c34-a420-5631d8a6fe55',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:30',NULL),('2025-12-06 10:23:30.830108',NULL,'2025-12-06 10:23:30.910643',414,414,NULL,'cc0dab8f-fdfb-4166-9146-225f5dce7b5c',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:30','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:30.831792',NULL,'2025-12-06 10:23:30.910643',415,415,NULL,'5cd53495-a5fa-4fdc-b51e-2d53ddf4e56e',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:30','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:31.721429',NULL,'2025-12-06 10:23:31.803097',416,416,'24430961e75b499c8132e916070db917','38b996d7-42a3-492a-8885-ade9542f002b',141,'c83cf8cf17554ef78c82738ac22165fa','snapshots',1,'2025-12-07 10:23:31',NULL),('2025-12-06 10:23:31.723115',NULL,'2025-12-06 10:23:31.803097',417,417,'24430961e75b499c8132e916070db917','98a24c1c-4144-4e39-b359-96c109cefe9d',142,'c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',1,'2025-12-07 10:23:31',NULL),('2025-12-06 10:23:31.738344',NULL,'2025-12-06 10:23:31.803097',418,418,NULL,'1336986f-8035-4b92-9ff4-764c883b3a68',143,'c83cf8cf17554ef78c82738ac22165fa','snapshots',1,'2025-12-07 10:23:31','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:31.739626',NULL,'2025-12-06 10:23:31.803097',419,419,NULL,'e687e4d3-19ad-4237-88a1-4059a27bfdd3',144,'c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',1,'2025-12-07 10:23:31','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:35.516961',NULL,'2025-12-06 10:23:35.541119',420,420,'8c95b67d83b947d78dd96e1b4cce7a0e','c793dd94-9dfb-459d-a35f-e42af0a5d5b6',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:35',NULL),('2025-12-06 10:23:35.518173',NULL,'2025-12-06 10:23:35.541119',421,421,'8c95b67d83b947d78dd96e1b4cce7a0e','b1865a33-36e5-47d9-9c35-e496cd5ef48d',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:35',NULL),('2025-12-06 10:23:35.526186',NULL,'2025-12-06 10:23:35.541119',422,422,NULL,'af57e7bb-9e0e-4c2a-a222-45c1988f0f05',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:35','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:35.527229',NULL,'2025-12-06 10:23:35.541119',423,423,NULL,'f9adcb06-180b-4c22-8e9e-d80e301e85ae',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:35','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:36.020647',NULL,'2025-12-06 10:23:36.038422',424,424,'24430961e75b499c8132e916070db917','c4f7cc14-e0d9-42b4-94e2-56847161a044',141,'c83cf8cf17554ef78c82738ac22165fa','snapshots',-1,'2025-12-07 10:23:35',NULL),('2025-12-06 10:23:36.021660',NULL,'2025-12-06 10:23:36.038422',425,425,'24430961e75b499c8132e916070db917','f3a380c5-bc63-4882-8c48-6140b1d55de7',142,'c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',-1,'2025-12-07 10:23:35',NULL),('2025-12-06 10:23:36.028403',NULL,'2025-12-06 10:23:36.038422',426,426,NULL,'50a9e71c-1dfe-4bc4-b3d0-38b244c5b2ac',143,'c83cf8cf17554ef78c82738ac22165fa','snapshots',-1,'2025-12-07 10:23:35','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:36.029338',NULL,'2025-12-06 10:23:36.038422',427,427,NULL,'5b1374da-79b7-4f77-9661-fd204f8c084c',144,'c83cf8cf17554ef78c82738ac22165fa','snapshot_gigabytes',-1,'2025-12-07 10:23:35','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:38.020790',NULL,'2025-12-06 10:23:38.116539',428,428,'8c95b67d83b947d78dd96e1b4cce7a0e','b086cd7a-d833-4345-acfe-ffbffe62789f',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:37',NULL),('2025-12-06 10:23:38.022612',NULL,'2025-12-06 10:23:38.116539',429,429,'8c95b67d83b947d78dd96e1b4cce7a0e','6cb937a6-6a2b-4894-b2ae-a0bd63342874',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:37',NULL),('2025-12-06 10:23:38.030031',NULL,'2025-12-06 10:23:38.116539',430,430,NULL,'9b9a5440-e711-49c0-8ec1-542cf176db5c',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:37','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:38.031349',NULL,'2025-12-06 10:23:38.116539',431,431,NULL,'1a2668d8-ce16-44bb-8ebc-c1969504f675',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:37','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:38.946730',NULL,'2025-12-06 10:23:38.965920',432,432,'24430961e75b499c8132e916070db917','90e280b9-aca3-43f0-8e9e-a0047cb1c511',138,'c83cf8cf17554ef78c82738ac22165fa','shares',-1,'2025-12-07 10:23:38',NULL),('2025-12-06 10:23:38.947771',NULL,'2025-12-06 10:23:38.965920',433,433,'24430961e75b499c8132e916070db917','ed3385df-a967-46c0-97cc-e7edf2d359ff',137,'c83cf8cf17554ef78c82738ac22165fa','gigabytes',-1,'2025-12-07 10:23:38',NULL),('2025-12-06 10:23:38.954839',NULL,'2025-12-06 10:23:38.965920',434,434,NULL,'2d738849-df98-498d-8257-36109c0258b2',140,'c83cf8cf17554ef78c82738ac22165fa','shares',-1,'2025-12-07 10:23:38','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:38.955872',NULL,'2025-12-06 10:23:38.965920',435,435,NULL,'6a3847da-f1d6-4bf8-84d3-09a737c2265a',139,'c83cf8cf17554ef78c82738ac22165fa','gigabytes',-1,'2025-12-07 10:23:38','307eb19a-1e00-4278-9496-c10fdf266956'),('2025-12-06 10:23:42.512629',NULL,'2025-12-06 10:23:42.546178',436,436,'8c95b67d83b947d78dd96e1b4cce7a0e','cae0bd30-ae44-4d74-a2df-b0d11eaaf170',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:42',NULL),('2025-12-06 10:23:42.513715',NULL,'2025-12-06 10:23:42.546178',437,437,'8c95b67d83b947d78dd96e1b4cce7a0e','1f2bc63d-4b97-436a-8b96-b2ddfb9fa020',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:42',NULL),('2025-12-06 10:23:42.527317',NULL,'2025-12-06 10:23:42.546178',438,438,NULL,'2429312e-5e46-49ef-b4c3-09b4a2c91090',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:42','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:42.528722',NULL,'2025-12-06 10:23:42.546178',439,439,NULL,'ceddd8ba-5a25-49d0-ba13-12eb4e153f7d',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:42','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:43.975277',NULL,'2025-12-06 10:23:44.036009',440,440,'27c84077ffd54c46ae679867b185acda','0025bcfc-e503-4159-9f58-8d870850577c',145,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:43.978037',NULL,'2025-12-06 10:23:44.036009',441,441,'27c84077ffd54c46ae679867b185acda','0cb64a7e-da06-4006-ba58-ca3cb48db039',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:43',NULL),('2025-12-06 10:23:43.995151',NULL,'2025-12-06 10:23:44.036009',442,442,NULL,'0334c9e7-a276-44af-bc56-6efab113bd0b',147,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:43','ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:44.008015',NULL,'2025-12-06 10:23:44.036009',443,443,NULL,'c67e3d47-5b9e-41da-b369-f7e6a2e0a615',148,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:43','ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:45.394739',NULL,'2025-12-06 10:23:45.488058',444,444,'8c95b67d83b947d78dd96e1b4cce7a0e','2d4d822f-9a8d-45be-90be-b51e3a032abe',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:45.397201',NULL,'2025-12-06 10:23:45.488058',445,445,'8c95b67d83b947d78dd96e1b4cce7a0e','4f3b15ea-57f6-4968-a80f-24ec82c74c97',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:45',NULL),('2025-12-06 10:23:45.408874',NULL,'2025-12-06 10:23:45.488058',446,446,NULL,'1f1b56ba-5c13-41d2-8d6e-f850b2d71aaa',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:45','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:45.410518',NULL,'2025-12-06 10:23:45.488058',447,447,NULL,'ced18395-da6c-4dd7-a55b-e078af5c3cc5',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:45','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:47.516122',NULL,'2025-12-06 10:23:47.591339',448,448,'2e821100b94443559eb555b391eef104','f76818f0-7dc8-4c9c-9515-afbc8009ff8c',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:47.519071',NULL,'2025-12-06 10:23:47.591339',449,449,'2e821100b94443559eb555b391eef104','c9ff5ea4-c694-4eec-a78a-195db66f016a',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:47',NULL),('2025-12-06 10:23:47.538759',NULL,'2025-12-06 10:23:47.591339',450,450,NULL,'da12eadf-e843-4baa-aeab-490d99610b79',152,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:47','6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:47.541693',NULL,'2025-12-06 10:23:47.591339',451,451,NULL,'b5b1fd39-fab2-4257-a04f-43590140dbf3',151,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:47','6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:49.340716',NULL,'2025-12-06 10:23:49.370319',452,452,'8c95b67d83b947d78dd96e1b4cce7a0e','729f4b84-e9d6-4c4b-9d4e-4d3d9e8e4feb',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49.341799',NULL,'2025-12-06 10:23:49.370319',453,453,'8c95b67d83b947d78dd96e1b4cce7a0e','a239198e-dbaf-4a11-8506-5627b47639de',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:49',NULL),('2025-12-06 10:23:49.356407',NULL,'2025-12-06 10:23:49.370319',454,454,NULL,'994e4ca4-18f3-488d-9de2-6760c9027f71',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:49','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:49.358956',NULL,'2025-12-06 10:23:49.370319',455,455,NULL,'f7601d2a-2ac0-4c4b-bb80-cbfe046f2b53',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:49','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:50.602708',NULL,'2025-12-06 10:23:50.620050',456,456,'27c84077ffd54c46ae679867b185acda','ac93a0d0-32af-45f8-bdcd-0d44075fa575',145,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.603519',NULL,'2025-12-06 10:23:50.620050',457,457,'27c84077ffd54c46ae679867b185acda','6ffe6209-0524-4bf4-b373-78720046d9c0',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.612868',NULL,'2025-12-06 10:23:50.620050',458,458,NULL,'4efe0183-54a8-49f1-9965-af34157738c8',147,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:23:50','ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:50.613511',NULL,'2025-12-06 10:23:50.620050',459,459,NULL,'d652241f-ab02-400c-b25a-0357bfaa7f43',148,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:23:50','ee1d41e2-7d0f-400b-b1d2-31e484ea96c9'),('2025-12-06 10:23:50.688627',NULL,'2025-12-06 10:23:50.720809',460,460,'27c84077ffd54c46ae679867b185acda','a2c3c46d-24e4-4ae9-94a6-3b12d4f8609f',145,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.689804',NULL,'2025-12-06 10:23:50.720809',461,461,'27c84077ffd54c46ae679867b185acda','9beedd9b-de60-4ec1-8536-07a4f5ac2a33',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.698198',NULL,'2025-12-06 10:23:50.720809',462,462,NULL,'fbaedec2-3e45-4c9a-9ccf-ef3121085118',154,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:50','176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:50.699237',NULL,'2025-12-06 10:23:50.720809',463,463,NULL,'621c1c36-2127-4f93-8ef2-a85cee65d96d',153,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:50','176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:50.960718',NULL,'2025-12-06 10:23:50.976849',464,464,'2e821100b94443559eb555b391eef104','0d445df5-7afc-4fa0-b76c-18f37080ab29',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.961747',NULL,'2025-12-06 10:23:50.976849',465,465,'2e821100b94443559eb555b391eef104','259939cd-44ee-40e4-b051-be59d3c26a41',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:23:50',NULL),('2025-12-06 10:23:50.968182',NULL,'2025-12-06 10:23:50.976849',466,466,NULL,'2e4885c0-7834-4af7-8129-e53c5de428ee',152,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:23:50','6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:50.969066',NULL,'2025-12-06 10:23:50.976849',467,467,NULL,'c7dc4414-d67b-4c12-898c-66c01394d771',151,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:23:50','6769942c-7518-4dd2-87b5-4f137e055ea8'),('2025-12-06 10:23:51.121638',NULL,'2025-12-06 10:23:51.157649',468,468,'2e821100b94443559eb555b391eef104','4b8d76b6-00e1-436f-bb4e-dac2b95d2ae1',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:51.122856',NULL,'2025-12-06 10:23:51.157649',469,469,'2e821100b94443559eb555b391eef104','18fd5890-2fd4-41f6-b61a-48ccd1a31c45',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:51',NULL),('2025-12-06 10:23:51.133549',NULL,'2025-12-06 10:23:51.157649',470,470,NULL,'461402cf-b80c-48a0-9a57-5d5ddf0d7cea',156,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:51','7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:51.134744',NULL,'2025-12-06 10:23:51.157649',471,471,NULL,'bebad79c-00c5-4fa8-bdd2-1027d76f580a',155,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:51','7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:52.223153',NULL,'2025-12-06 10:23:52.329547',472,472,'8c95b67d83b947d78dd96e1b4cce7a0e','95b42aae-8488-474e-bdbc-014bda3395dd',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:52.224691',NULL,'2025-12-06 10:23:52.329547',473,473,'8c95b67d83b947d78dd96e1b4cce7a0e','4ae5ab77-ab12-4888-8a46-b4b1be898521',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:52',NULL),('2025-12-06 10:23:52.236888',NULL,'2025-12-06 10:23:52.329547',474,474,NULL,'681238af-3901-422b-80d3-5b2a912ecf64',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:23:52','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:52.238386',NULL,'2025-12-06 10:23:52.329547',475,475,NULL,'6eb9de2f-c6fe-48c9-a107-16796e63779f',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:23:52','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:54.093123',NULL,'2025-12-06 10:23:54.115380',476,476,'27c84077ffd54c46ae679867b185acda','32817e97-859e-4422-9006-b2c7a37b28d3',145,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.094136',NULL,'2025-12-06 10:23:54.115380',477,477,'27c84077ffd54c46ae679867b185acda','eb3c16a6-b315-4486-8bca-da381ac2505d',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.101242',NULL,'2025-12-06 10:23:54.115380',478,478,NULL,'9ecd4a53-3716-4f68-8cab-bacf48959115',154,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:23:54','176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:54.102854',NULL,'2025-12-06 10:23:54.115380',479,479,NULL,'621638f6-0152-4a77-b377-c58b2a7b933d',153,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:23:54','176945be-8058-44a7-ad9c-638cddf04101'),('2025-12-06 10:23:54.196594',NULL,'2025-12-06 10:23:54.240856',480,480,'27c84077ffd54c46ae679867b185acda','4b3faf56-f7d0-46b6-82f2-28311322d435',145,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.198135',NULL,'2025-12-06 10:23:54.240856',481,481,'27c84077ffd54c46ae679867b185acda','391ad4d0-6149-4ee4-a825-093ca9ff6e1e',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.211907',NULL,'2025-12-06 10:23:54.240856',482,482,NULL,'d4aa3e71-cd7c-44cf-abe1-e14bcee11292',157,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:23:54','23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:23:54.213415',NULL,'2025-12-06 10:23:54.240856',483,483,NULL,'b31eb182-cdcb-405d-bce3-20a90366b6e1',158,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:23:54','23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:23:54.552493',NULL,'2025-12-06 10:23:54.563578',484,484,'2e821100b94443559eb555b391eef104','0687a043-fc3a-41d1-8352-6d18fa0f1050',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.553105',NULL,'2025-12-06 10:23:54.563578',485,485,'2e821100b94443559eb555b391eef104','e3fe44e8-1b4b-47a8-8ceb-9b6212eae772',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.557746',NULL,'2025-12-06 10:23:54.563578',486,486,NULL,'0b46a74b-31c9-4f00-8632-7ec1df7ab745',156,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:23:54','7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:54.558319',NULL,'2025-12-06 10:23:54.563578',487,487,NULL,'3f1c5efd-0e97-4c9b-bde1-38324d17d325',155,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:23:54','7c01689b-4935-4453-97d1-e511c3d55dbb'),('2025-12-06 10:23:54.638300',NULL,'2025-12-06 10:23:54.673800',488,488,'2e821100b94443559eb555b391eef104','8284c72d-a83c-4a73-a1be-f04d8f5e060b',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.639538',NULL,'2025-12-06 10:23:54.673800',489,489,'2e821100b94443559eb555b391eef104','3be69b3e-7bbc-4f2a-ab89-122f29ae2f16',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:54',NULL),('2025-12-06 10:23:54.650305',NULL,'2025-12-06 10:23:54.673800',490,490,NULL,'51bdbb8d-f920-4f2c-b985-d38231ddc7c0',160,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:54','6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:23:54.651694',NULL,'2025-12-06 10:23:54.673800',491,491,NULL,'1324aa38-0665-4a9e-829b-1f99cd6c4f01',159,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:54','6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:23:57.005586',NULL,'2025-12-06 10:23:57.021884',492,492,'8c95b67d83b947d78dd96e1b4cce7a0e','cc6873d4-4adb-45a3-82fd-d60fa9f6ab87',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:56',NULL),('2025-12-06 10:23:57.006323',NULL,'2025-12-06 10:23:57.021884',493,493,'8c95b67d83b947d78dd96e1b4cce7a0e','85af72aa-6fa8-4a4f-bb76-5ae07ad52c61',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:56',NULL),('2025-12-06 10:23:57.013206',NULL,'2025-12-06 10:23:57.021884',494,494,NULL,'f7d38bef-a541-4285-8115-e7ccd10ff2cf',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:23:56','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:57.014087',NULL,'2025-12-06 10:23:57.021884',495,495,NULL,'303e2fb1-fef1-4cdb-8895-797e82e8f15f',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:23:56','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:23:57.889891',NULL,'2025-12-06 10:23:57.923205',496,496,'2e821100b94443559eb555b391eef104','1bcf02f9-0300-40fe-99e6-7d39c88614fc',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:57.891082',NULL,'2025-12-06 10:23:57.923205',497,497,'2e821100b94443559eb555b391eef104','36954c3e-eb16-469f-a4de-d83c2b168dcb',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:57',NULL),('2025-12-06 10:23:57.901261',NULL,'2025-12-06 10:23:57.923205',498,498,NULL,'adbaf56f-3c0f-49a2-9807-f8f07bd24add',162,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:23:57','d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:23:57.902609',NULL,'2025-12-06 10:23:57.923205',499,499,NULL,'6a4b9d02-3bdb-4fec-8d4e-64e0fba306bc',161,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:23:57','d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:24:00.711973',NULL,'2025-12-06 10:24:00.723673',500,500,'27c84077ffd54c46ae679867b185acda','64d39d6f-e4cd-4d4d-9d8d-bfe730de6c54',145,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.712688',NULL,'2025-12-06 10:24:00.723673',501,501,'27c84077ffd54c46ae679867b185acda','76ccd582-aa29-4555-a101-9df04b47934e',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.717847',NULL,'2025-12-06 10:24:00.723673',502,502,NULL,'f708f59a-d989-4eb5-bdc3-c22bdda6a383',157,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:00','23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:24:00.718434',NULL,'2025-12-06 10:24:00.723673',503,503,NULL,'b593e83d-9ab0-402b-84aa-681dd50e1f0e',158,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:00','23efaac1-3650-4e49-814e-be2655b4e0f4'),('2025-12-06 10:24:00.727031',NULL,'2025-12-06 10:24:00.801636',504,504,'8c95b67d83b947d78dd96e1b4cce7a0e','d2b1e1ad-e3cb-4469-bc38-e0f88b54c76c',133,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.728758',NULL,'2025-12-06 10:24:00.801636',505,505,'8c95b67d83b947d78dd96e1b4cce7a0e','8e151017-32d6-447c-9102-46859745009c',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.735027',NULL,'2025-12-06 10:24:00.801636',506,506,NULL,'0bda373a-17a6-4156-abdd-f976818a794b',135,'a860f91f361042a2b13934bff381f266','snapshots',1,'2025-12-07 10:24:00','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:00.737865',NULL,'2025-12-06 10:24:00.801636',507,507,NULL,'4a03577b-5e17-4c9c-8808-4c0945d02ce9',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',1,'2025-12-07 10:24:00','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:00.803182',NULL,'2025-12-06 10:24:00.852657',508,508,'27c84077ffd54c46ae679867b185acda','04d9b11e-f9a6-477b-be01-7c9eeb9e2934',145,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.811188',NULL,'2025-12-06 10:24:00.852657',509,509,'27c84077ffd54c46ae679867b185acda','46c7c802-1d5c-4528-8cf8-6f355efaad1f',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:24:00',NULL),('2025-12-06 10:24:00.831221',NULL,'2025-12-06 10:24:00.852657',510,510,NULL,'f0c4f4c2-81d3-437b-b77c-1538b9ed84ef',164,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:24:00','54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:00.832591',NULL,'2025-12-06 10:24:00.852657',511,511,NULL,'4f8e64a5-9f34-45d2-9aa0-23ceb08bd1ff',163,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:24:00','54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:04.223955',NULL,'2025-12-06 10:24:04.248613',512,512,'27c84077ffd54c46ae679867b185acda','4b88d227-416d-4ec6-b38a-456576d9ff8b',145,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.227148',NULL,'2025-12-06 10:24:04.248613',513,513,'27c84077ffd54c46ae679867b185acda','6520b436-8687-4c13-8df2-5797e7bef170',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.238873',NULL,'2025-12-06 10:24:04.248613',514,514,NULL,'8fd82406-2fb8-49df-8a2e-c5ee17c31f8d',164,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:04','54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:04.240023',NULL,'2025-12-06 10:24:04.248613',515,515,NULL,'fdd90986-d367-4830-9a77-d0f246644550',163,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:04','54c33252-4a68-47c2-807f-447a753c6797'),('2025-12-06 10:24:04.303851',NULL,'2025-12-06 10:24:04.319787',516,516,'2e821100b94443559eb555b391eef104','154696e8-0c00-446d-8849-288308798432',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.304652',NULL,'2025-12-06 10:24:04.319787',517,517,'2e821100b94443559eb555b391eef104','cc037bf0-5247-401b-b3eb-46e8115fb747',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.313185',NULL,'2025-12-06 10:24:04.319787',518,518,NULL,'b603ea85-dbd9-47bc-9b1c-4c65be1d5355',162,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:04','d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:24:04.313863',NULL,'2025-12-06 10:24:04.319787',519,519,NULL,'70314541-5a63-4879-ba51-772daf74ee0a',161,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:04','d13266af-e92f-495b-bcf1-053d8050fa8c'),('2025-12-06 10:24:04.333634',NULL,'2025-12-06 10:24:04.384866',520,520,'27c84077ffd54c46ae679867b185acda','848d8908-c28c-423e-b414-5bf8db41cb4b',145,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.335519',NULL,'2025-12-06 10:24:04.384866',521,521,'27c84077ffd54c46ae679867b185acda','c49734c3-99a1-4808-aa38-e21dab478e51',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.354815',NULL,'2025-12-06 10:24:04.384866',522,522,NULL,'1fd3bc55-97fc-400c-9daa-fd3f9f980147',166,'5914faf90fd14171adeb0a62b64d0b11','shares',1,'2025-12-07 10:24:04','1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:04.356708',NULL,'2025-12-06 10:24:04.384866',523,523,NULL,'b05f2bd5-7d24-4909-bc51-a62506d204a9',165,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',1,'2025-12-07 10:24:04','1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:04.455579',NULL,'2025-12-06 10:24:04.472167',524,524,'2e821100b94443559eb555b391eef104','b1eac2cb-ebb1-408b-bf4f-bd617f949dc9',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.456252',NULL,'2025-12-06 10:24:04.472167',525,525,'2e821100b94443559eb555b391eef104','9bc323bb-b072-453b-87f8-75922c371262',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.464073',NULL,'2025-12-06 10:24:04.472167',526,526,NULL,'f0d36848-e250-4cdd-bb43-e361ba95dc59',160,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:04','6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:24:04.464711',NULL,'2025-12-06 10:24:04.472167',527,527,NULL,'571b563c-f868-414e-a420-48c90a224eea',159,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:04','6179c1a7-0e4a-4d8b-809c-73c9555f795c'),('2025-12-06 10:24:04.564579',NULL,'2025-12-06 10:24:04.607556',528,528,'2e821100b94443559eb555b391eef104','47260a18-8c06-4ccd-a44b-bac137763260',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.565713',NULL,'2025-12-06 10:24:04.607556',529,529,'2e821100b94443559eb555b391eef104','1ec1ac65-1723-487c-a784-8ae3700eebf5',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:04',NULL),('2025-12-06 10:24:04.579415',NULL,'2025-12-06 10:24:04.607556',530,530,NULL,'aa7eec8c-ec7a-49f7-a8da-47b7e5cdb35c',167,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:04','a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:04.580875',NULL,'2025-12-06 10:24:04.607556',531,531,NULL,'dab10273-1a7a-4dd2-9e2d-e2dd4fe4068f',168,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:04','a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:05.778985',NULL,'2025-12-06 10:24:05.796433',532,532,'8c95b67d83b947d78dd96e1b4cce7a0e','5b158654-82d3-4ab9-b1a6-a34b1576f6f3',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:05.779666',NULL,'2025-12-06 10:24:05.796433',533,533,'8c95b67d83b947d78dd96e1b4cce7a0e','76697bba-6349-4bd1-94a2-bc970b8324b4',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:24:05',NULL),('2025-12-06 10:24:05.784366',NULL,'2025-12-06 10:24:05.796433',534,534,NULL,'6f1d96fb-5856-48cf-95cd-b5ae224ea4d7',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:24:05','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:05.785067',NULL,'2025-12-06 10:24:05.796433',535,535,NULL,'5c5db1ed-97bc-4e6b-bd7a-8bb3fe8859c3',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:24:05','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:07.880715',NULL,'2025-12-06 10:24:07.923466',536,536,'2e821100b94443559eb555b391eef104','6c2ecd62-e6f9-4d6d-b5ba-3d4c119c45b6',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:07',NULL),('2025-12-06 10:24:07.882071',NULL,'2025-12-06 10:24:07.923466',537,537,'2e821100b94443559eb555b391eef104','2eecf485-29f9-434b-b2f3-f7f3fdf3667c',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:07',NULL),('2025-12-06 10:24:07.892649',NULL,'2025-12-06 10:24:07.923466',538,538,NULL,'3669d512-7d0e-45ef-837e-8b1ac975473b',170,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:07','e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:07.893970',NULL,'2025-12-06 10:24:07.923466',539,539,NULL,'19b103e4-3748-4eca-8f11-607fd0c2fdd0',169,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:07','e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:10.029097',NULL,'2025-12-06 10:24:10.091873',540,540,'a6d62e9381984680b8feaf471728ad16','0f186957-6daf-4d3c-ae2e-3cf2cf44217b',172,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:10.030387',NULL,'2025-12-06 10:24:10.091873',541,541,'a6d62e9381984680b8feaf471728ad16','4909ad1e-00e7-44d4-abce-2cea06c3eaf3',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:09',NULL),('2025-12-06 10:24:10.058562',NULL,'2025-12-06 10:24:10.091873',542,542,NULL,'ff3d4b2c-728c-4be9-af35-849240c44578',174,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:09','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:10.060725',NULL,'2025-12-06 10:24:10.091873',543,543,NULL,'fbc27266-c04f-4062-9723-55f3c3e42070',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:09','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:10.797676',NULL,'2025-12-06 10:24:10.820560',544,544,'27c84077ffd54c46ae679867b185acda','fdb956b2-7c52-49d3-826a-45112098de5a',145,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:10.798370',NULL,'2025-12-06 10:24:10.820560',545,545,'27c84077ffd54c46ae679867b185acda','2f7c9d14-e204-4146-bb98-0cee020b4153',146,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:10',NULL),('2025-12-06 10:24:10.811265',NULL,'2025-12-06 10:24:10.820560',546,546,NULL,'0e0fee6a-6182-4f82-a307-5ab44124e1d8',166,'5914faf90fd14171adeb0a62b64d0b11','shares',-1,'2025-12-07 10:24:10','1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:10.812111',NULL,'2025-12-06 10:24:10.820560',547,547,NULL,'69b96ba7-96db-4632-885e-b0d0026c2a7a',165,'5914faf90fd14171adeb0a62b64d0b11','gigabytes',-1,'2025-12-07 10:24:10','1e072841-4e99-43d4-813c-bc523d076a45'),('2025-12-06 10:24:11.060969',NULL,'2025-12-06 10:24:11.076365',548,548,'8c95b67d83b947d78dd96e1b4cce7a0e','a4714199-20a9-44b0-a6a9-d74bd6f77b9d',133,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:24:11',NULL),('2025-12-06 10:24:11.061823',NULL,'2025-12-06 10:24:11.076365',549,549,'8c95b67d83b947d78dd96e1b4cce7a0e','42ad03a9-ac3b-4bf2-9bf4-2b77d669eed7',134,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:24:11',NULL),('2025-12-06 10:24:11.066974',NULL,'2025-12-06 10:24:11.076365',550,550,NULL,'bdf2fdcf-928f-4e04-b7bf-ac7c7ea5f6f6',135,'a860f91f361042a2b13934bff381f266','snapshots',-1,'2025-12-07 10:24:11','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:11.067780',NULL,'2025-12-06 10:24:11.076365',551,551,NULL,'0d9d6111-34b3-4b91-b415-4b8e14205561',136,'a860f91f361042a2b13934bff381f266','snapshot_gigabytes',-1,'2025-12-07 10:24:11','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:13.362702',NULL,'2025-12-06 10:24:13.425757',552,552,'a6d62e9381984680b8feaf471728ad16','d812e083-9512-4f3e-b315-0c42bbf9c53a',172,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:13',NULL),('2025-12-06 10:24:13.371613',NULL,'2025-12-06 10:24:13.425757',553,553,'a6d62e9381984680b8feaf471728ad16','cf924dbe-c82a-4bda-81fc-36ea1eb245c1',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:13',NULL),('2025-12-06 10:24:13.387914',NULL,'2025-12-06 10:24:13.425757',554,554,NULL,'977fb8eb-9c6a-422b-91b6-5d39333c56d2',174,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:13','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:13.397200',NULL,'2025-12-06 10:24:13.425757',555,555,NULL,'1c384d44-4a65-4a48-ac49-85495be0918e',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:13','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:14.193177',NULL,'2025-12-06 10:24:14.226354',556,556,'2e821100b94443559eb555b391eef104','a5dbfb36-dc72-4414-b39b-ed67148b8cfc',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:14',NULL),('2025-12-06 10:24:14.195738',NULL,'2025-12-06 10:24:14.226354',557,557,'2e821100b94443559eb555b391eef104','25e741ce-94a9-42ec-abcd-aa04bbe44bc5',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:14',NULL),('2025-12-06 10:24:14.206924',NULL,'2025-12-06 10:24:14.226354',558,558,NULL,'1d11de9a-bca1-4509-b51e-2975384687e4',176,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:14','970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:14.208189',NULL,'2025-12-06 10:24:14.226354',559,559,NULL,'bb8536fa-5127-4b04-b294-079ddbf25c12',175,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:14','970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:14.533315',NULL,'2025-12-06 10:24:14.548108',560,560,'8c95b67d83b947d78dd96e1b4cce7a0e','9842c5f8-6f9e-4172-83f8-8a5ac0eac1f0',129,'a860f91f361042a2b13934bff381f266','shares',-1,'2025-12-07 10:24:14',NULL),('2025-12-06 10:24:14.534290',NULL,'2025-12-06 10:24:14.548108',561,561,'8c95b67d83b947d78dd96e1b4cce7a0e','fc68015b-38bc-48d7-ae82-bd511b4b880f',130,'a860f91f361042a2b13934bff381f266','gigabytes',-1,'2025-12-07 10:24:14',NULL),('2025-12-06 10:24:14.541004',NULL,'2025-12-06 10:24:14.548108',562,562,NULL,'8ba8d9c2-4407-4649-86d6-12bc1e4f3aeb',131,'a860f91f361042a2b13934bff381f266','shares',-1,'2025-12-07 10:24:14','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:14.541758',NULL,'2025-12-06 10:24:14.548108',563,563,NULL,'91ea2c6f-d473-4e66-ab1f-296fb9e21877',132,'a860f91f361042a2b13934bff381f266','gigabytes',-1,'2025-12-07 10:24:14','776e25c6-539b-4d49-a909-a9fdbde299cd'),('2025-12-06 10:24:16.683570',NULL,'2025-12-06 10:24:16.798013',564,564,'a6d62e9381984680b8feaf471728ad16','6962eb1f-947b-4952-bf11-b933d08a80bc',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:16',NULL),('2025-12-06 10:24:16.689347',NULL,'2025-12-06 10:24:16.798013',565,565,NULL,'e8eb3b44-c07d-4be0-84e0-bd8852ee9bf3',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:16','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:20.394176',NULL,'2025-12-06 10:24:20.414447',566,566,'a6d62e9381984680b8feaf471728ad16','ed5533e1-31a6-4c5c-8fa8-3e77c85090b7',172,'674b1770f1a44f0c83fe1e0bf22a570c','shares',-1,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.398381',NULL,'2025-12-06 10:24:20.414447',567,567,'a6d62e9381984680b8feaf471728ad16','18098c6c-d16b-49fd-8cd0-687602f4e99f',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',-2,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.404612',NULL,'2025-12-06 10:24:20.414447',568,568,NULL,'aca6d340-d18e-481b-83bc-2a24dc6259e3',174,'674b1770f1a44f0c83fe1e0bf22a570c','shares',-1,'2025-12-07 10:24:20','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:20.405425',NULL,'2025-12-06 10:24:20.414447',569,569,NULL,'fdd82511-68f7-453b-804f-80a2a7072a5b',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',-2,'2025-12-07 10:24:20','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:20.663637',NULL,'2025-12-06 10:24:20.681935',570,570,'2e821100b94443559eb555b391eef104','ea82a252-4cf3-4c31-856b-f622a1b4ed30',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.664462',NULL,'2025-12-06 10:24:20.681935',571,571,'2e821100b94443559eb555b391eef104','51d702ca-a37e-4db7-b016-95c8afd37adb',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.670316',NULL,'2025-12-06 10:24:20.681935',572,572,NULL,'b83e3f1e-9752-4d24-961b-74ad278a3d89',176,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:20','970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:20.671032',NULL,'2025-12-06 10:24:20.681935',573,573,NULL,'fe6e17e7-5596-4944-8058-386aa3555c41',175,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:20','970e81a2-4c69-4c8c-8a4b-47952b6ec2ed'),('2025-12-06 10:24:20.923881',NULL,'2025-12-06 10:24:20.939490',574,574,'2e821100b94443559eb555b391eef104','95b02064-0e00-4207-bd67-afa2b8c148ff',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.924573',NULL,'2025-12-06 10:24:20.939490',575,575,'2e821100b94443559eb555b391eef104','48c57484-ca0d-458c-a24c-6749b4986044',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:20',NULL),('2025-12-06 10:24:20.931832',NULL,'2025-12-06 10:24:20.939490',576,576,NULL,'34c0a42d-983b-4790-b954-8baad9df8549',170,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:20','e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:20.932459',NULL,'2025-12-06 10:24:20.939490',577,577,NULL,'225495a8-b2d6-488e-b0f1-78923597f812',169,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:20','e687b4b3-25cf-4aff-a08b-6332e55a7a2b'),('2025-12-06 10:24:21.163358',NULL,'2025-12-06 10:24:21.178025',578,578,'2e821100b94443559eb555b391eef104','de87f9c1-cd1f-457e-a8da-f7a8e74d630b',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:21',NULL),('2025-12-06 10:24:21.164098',NULL,'2025-12-06 10:24:21.178025',579,579,'2e821100b94443559eb555b391eef104','50eed2b0-2a17-41c6-b1ac-a98076ddebf8',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:21',NULL),('2025-12-06 10:24:21.169177',NULL,'2025-12-06 10:24:21.178025',580,580,NULL,'49bd1d2e-a8dc-44fa-be2d-442bbf60763d',167,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:21','a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:21.169781',NULL,'2025-12-06 10:24:21.178025',581,581,NULL,'2216bca5-8d64-440d-8ebc-60c0574bba3a',168,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:21','a9a6dd11-5167-4972-9091-2329b3740c0b'),('2025-12-06 10:24:21.313790',NULL,'2025-12-06 10:24:21.345918',582,582,'2e821100b94443559eb555b391eef104','d07997e6-fcdd-4309-b09a-0da43c255de3',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:21',NULL),('2025-12-06 10:24:21.314916',NULL,'2025-12-06 10:24:21.345918',583,583,'2e821100b94443559eb555b391eef104','7a2d0938-a742-4dac-9c2e-20f48ec61f46',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:21',NULL),('2025-12-06 10:24:21.322840',NULL,'2025-12-06 10:24:21.345918',584,584,NULL,'82f281b2-3a46-4456-94c7-dc5bd7efeb2a',178,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:21','8e9f608e-00c2-4462-8ccd-8749113629f6'),('2025-12-06 10:24:21.323875',NULL,'2025-12-06 10:24:21.345918',585,585,NULL,'f8adfe2a-946d-4501-8008-f78682ce7b09',177,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:21','8e9f608e-00c2-4462-8ccd-8749113629f6'),('2025-12-06 10:24:23.254540',NULL,'2025-12-06 10:24:23.280808',586,586,'a6d62e9381984680b8feaf471728ad16','17a354f5-5e2a-41bd-99f7-3b4c9c51a182',172,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:23',NULL),('2025-12-06 10:24:23.255942',NULL,'2025-12-06 10:24:23.280808',587,587,'a6d62e9381984680b8feaf471728ad16','a2eaed71-a37e-4505-91fd-e612a6255d7f',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:23',NULL),('2025-12-06 10:24:23.262674',NULL,'2025-12-06 10:24:23.280808',588,588,NULL,'316e357e-c552-4aef-9c68-09ca706d48ed',174,'674b1770f1a44f0c83fe1e0bf22a570c','shares',1,'2025-12-07 10:24:23','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:23.263795',NULL,'2025-12-06 10:24:23.280808',589,589,NULL,'8b39974a-f38f-497c-809d-4849e688e43b',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:23','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:24.555236',NULL,'2025-12-06 10:24:24.659644',590,590,'58fc51cd55374a6f9aca770f673e918e','6a00eb6b-402e-4640-95a8-1bdbd27b9a95',180,'14fcd30962314973b2c11b49f89b4cb4','shares',1,'2025-12-07 10:24:24',NULL),('2025-12-06 10:24:24.558580',NULL,'2025-12-06 10:24:24.659644',591,591,'58fc51cd55374a6f9aca770f673e918e','e444e585-d957-4de4-b44b-a3e46770b57e',179,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',1,'2025-12-07 10:24:24',NULL),('2025-12-06 10:24:24.580282',NULL,'2025-12-06 10:24:24.659644',592,592,NULL,'324f4915-48a1-4476-9a25-2073371dab5f',182,'14fcd30962314973b2c11b49f89b4cb4','shares',1,'2025-12-07 10:24:24','da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:24:24.589829',NULL,'2025-12-06 10:24:24.659644',593,593,NULL,'5d27f1f8-be58-4250-9830-90993447d60b',181,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',1,'2025-12-07 10:24:24','da5e9c3b-1204-498a-9ed5-074601f18f02'),('2025-12-06 10:24:26.725825',NULL,'2025-12-06 10:24:26.988707',594,594,'a6d62e9381984680b8feaf471728ad16','dcdaabd0-b343-48b3-a381-ca30fcfa2c7b',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:26',NULL),('2025-12-06 10:24:26.735069',NULL,'2025-12-06 10:24:26.988707',595,595,NULL,'d08199d3-9b12-492b-a4a5-f19c71bea2ec',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',1,'2025-12-07 10:24:26','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:27.640384',NULL,'2025-12-06 10:24:27.709214',596,596,'2e821100b94443559eb555b391eef104','3b391bea-a19a-4c7b-8fd6-66fdd9041285',150,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:27',NULL),('2025-12-06 10:24:27.641735',NULL,'2025-12-06 10:24:27.709214',597,597,'2e821100b94443559eb555b391eef104','0320a36e-745a-4d72-a699-5e2d99bb0adc',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:27',NULL),('2025-12-06 10:24:27.676905',NULL,'2025-12-06 10:24:27.709214',598,598,NULL,'0010f290-7166-4a17-8843-9c6fa7171765',183,'b4a5504da73944ff953a9c5c2851c39c','shares',1,'2025-12-07 10:24:27','c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:27.679039',NULL,'2025-12-06 10:24:27.709214',599,599,NULL,'f0f91a86-0519-4234-b546-28a8786ed04c',184,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',1,'2025-12-07 10:24:27','c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:28.096398',NULL,'2025-12-06 10:24:28.133364',600,600,'58fc51cd55374a6f9aca770f673e918e','91b345a0-5ccc-4c14-b3fe-744e1b567edf',180,'14fcd30962314973b2c11b49f89b4cb4','shares',1,'2025-12-07 10:24:28',NULL),('2025-12-06 10:24:28.097533',NULL,'2025-12-06 10:24:28.133364',601,601,'58fc51cd55374a6f9aca770f673e918e','a0f0d3f8-b34e-4382-ba11-5daf15e63c0a',179,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',1,'2025-12-07 10:24:28',NULL),('2025-12-06 10:24:28.110305',NULL,'2025-12-06 10:24:28.133364',602,602,NULL,'e19ad1a6-a926-43c7-b687-98a4eae1344d',186,'14fcd30962314973b2c11b49f89b4cb4','shares',1,'2025-12-07 10:24:28','71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:28.111379',NULL,'2025-12-06 10:24:28.133364',603,603,NULL,'2e2f6709-f00b-44b8-bc2a-9ddf276af1aa',185,'14fcd30962314973b2c11b49f89b4cb4','gigabytes',1,'2025-12-07 10:24:28','71c8d62d-9a5f-4eaa-b09a-2aebe35aed66'),('2025-12-06 10:24:30.504073',NULL,'2025-12-06 10:24:30.544155',604,604,'a6d62e9381984680b8feaf471728ad16','88254b20-1bf2-4102-8333-0898a5ea29a4',172,'674b1770f1a44f0c83fe1e0bf22a570c','shares',-1,'2025-12-07 10:24:30',NULL),('2025-12-06 10:24:30.505762',NULL,'2025-12-06 10:24:30.544155',605,605,'a6d62e9381984680b8feaf471728ad16','76d3374e-fa8a-418f-845c-8170f0141c05',171,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',-2,'2025-12-07 10:24:30',NULL),('2025-12-06 10:24:30.522311',NULL,'2025-12-06 10:24:30.544155',606,606,NULL,'f4534fcc-eef7-4ec0-88a8-22d1a008907a',174,'674b1770f1a44f0c83fe1e0bf22a570c','shares',-1,'2025-12-07 10:24:30','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:30.527640',NULL,'2025-12-06 10:24:30.544155',607,607,NULL,'32f5e5fe-5ad2-4057-afd9-f6cddd7b722b',173,'674b1770f1a44f0c83fe1e0bf22a570c','gigabytes',-2,'2025-12-07 10:24:30','5af8a7d5-d030-4b33-a86d-49dd2d035a86'),('2025-12-06 10:24:31.325862',NULL,'2025-12-06 10:24:31.347639',608,608,'2e821100b94443559eb555b391eef104','8684453b-ba53-4375-befd-85f32010f724',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:31',NULL),('2025-12-06 10:24:31.326804',NULL,'2025-12-06 10:24:31.347639',609,609,'2e821100b94443559eb555b391eef104','31403b22-1a08-49c4-bc84-dc6e7ea3fc76',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:31',NULL),('2025-12-06 10:24:31.339542',NULL,'2025-12-06 10:24:31.347639',610,610,NULL,'6b57ac89-9779-40b0-820c-454a968ba840',183,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:31','c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:31.340731',NULL,'2025-12-06 10:24:31.347639',611,611,NULL,'aa44dd59-1476-41dd-9744-fd9d44e7d788',184,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:31','c2a37754-c6cd-457c-b694-2c78158190ee'),('2025-12-06 10:24:31.566903',NULL,'2025-12-06 10:24:31.588679',612,612,'2e821100b94443559eb555b391eef104','f84ae0ae-ffb0-4c18-a464-ea2fae6cc5ca',150,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:31',NULL),('2025-12-06 10:24:31.567656',NULL,'2025-12-06 10:24:31.588679',613,613,'2e821100b94443559eb555b391eef104','db2380e8-46e5-4680-84de-18fd9bb7593c',149,'b4a5504da73944ff953a9c5c2851c39c','gigabytes',-1,'2025-12-07 10:24:31',NULL),('2025-12-06 10:24:31.577548',NULL,'2025-12-06 10:24:31.588679',614,614,NULL,'0cd58891-3acf-4073-879a-3d24cd141283',178,'b4a5504da73944ff953a9c5c2851c39c','shares',-1,'2025-12-07 10:24:31','8e9f608e-00c2-4462-8ccd-8749113629f6'),('2025-12-06 10:24:31.580728',NULL,'2025-12-06 10:24:31.588679',615,615,NULL,'dd56f6c6-6c41-4339-b5b2-5247dd2d4d8e',177,'b4a5504da73944ff953a9c5c2851c